/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserException;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgColumn;
import cz.startnet.utils.pgdiff.schema.PgConstraint;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgFunction;
import cz.startnet.utils.pgdiff.schema.PgIndex;
import cz.startnet.utils.pgdiff.schema.PgRelation;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgSequence;
import cz.startnet.utils.pgdiff.schema.PgTable;
import cz.startnet.utils.pgdiff.schema.PgTrigger;
import cz.startnet.utils.pgdiff.schema.PgView;
import java.text.MessageFormat;

public class CommentParser {
    public static void parse(PgDatabase pgDatabase, String string, boolean bl) {
        Parser parser = new Parser(string);
        parser.expect("COMMENT", "ON");
        if (parser.expectOptional("TABLE")) {
            CommentParser.parseTable(parser, pgDatabase);
        } else if (parser.expectOptional("COLUMN")) {
            CommentParser.parseColumn(parser, pgDatabase);
        } else if (parser.expectOptional("CONSTRAINT")) {
            CommentParser.parseConstraint(parser, pgDatabase);
        } else if (parser.expectOptional("DATABASE")) {
            CommentParser.parseDatabase(parser, pgDatabase);
        } else if (parser.expectOptional("FUNCTION")) {
            CommentParser.parseFunction(parser, pgDatabase);
        } else if (parser.expectOptional("INDEX")) {
            CommentParser.parseIndex(parser, pgDatabase);
        } else if (parser.expectOptional("SCHEMA")) {
            CommentParser.parseSchema(parser, pgDatabase);
        } else if (parser.expectOptional("SEQUENCE")) {
            CommentParser.parseSequence(parser, pgDatabase);
        } else if (parser.expectOptional("TRIGGER")) {
            CommentParser.parseTrigger(parser, pgDatabase);
        } else if (parser.expectOptional("VIEW")) {
            CommentParser.parseView(parser, pgDatabase);
        } else if (bl) {
            pgDatabase.addIgnoredStatement(string);
        }
    }

    private static void parseTable(Parser parser, PgDatabase pgDatabase) {
        String string = parser.parseIdentifier();
        String string2 = ParserUtils.getObjectName(string);
        String string3 = ParserUtils.getSchemaName(string, pgDatabase);
        PgTable pgTable = pgDatabase.getSchema(string3).getTable(string2);
        parser.expect("IS");
        pgTable.setComment(CommentParser.getComment(parser));
        parser.expect(";");
    }

    private static void parseConstraint(Parser parser, PgDatabase pgDatabase) {
        String string = ParserUtils.getObjectName(parser.parseIdentifier());
        parser.expect("ON");
        String string2 = parser.parseIdentifier();
        String string3 = ParserUtils.getObjectName(string2);
        String string4 = ParserUtils.getSchemaName(string2, pgDatabase);
        PgConstraint pgConstraint = pgDatabase.getSchema(string4).getTable(string3).getConstraint(string);
        parser.expect("IS");
        pgConstraint.setComment(CommentParser.getComment(parser));
        parser.expect(";");
    }

    private static void parseDatabase(Parser parser, PgDatabase pgDatabase) {
        parser.parseIdentifier();
        parser.expect("IS");
        pgDatabase.setComment(CommentParser.getComment(parser));
        parser.expect(";");
    }

    private static void parseIndex(Parser parser, PgDatabase pgDatabase) {
        String string = parser.parseIdentifier();
        String string2 = ParserUtils.getObjectName(string);
        String string3 = ParserUtils.getSchemaName(string, pgDatabase);
        PgSchema pgSchema = pgDatabase.getSchema(string3);
        PgIndex pgIndex = pgSchema.getIndex(string2);
        if (pgIndex == null) {
            PgConstraint pgConstraint = pgSchema.getPrimaryKey(string2);
            parser.expect("IS");
            pgConstraint.setComment(CommentParser.getComment(parser));
            parser.expect(";");
        } else {
            parser.expect("IS");
            pgIndex.setComment(CommentParser.getComment(parser));
            parser.expect(";");
        }
    }

    private static void parseSchema(Parser parser, PgDatabase pgDatabase) {
        String string = ParserUtils.getObjectName(parser.parseIdentifier());
        PgSchema pgSchema = pgDatabase.getSchema(string);
        parser.expect("IS");
        pgSchema.setComment(CommentParser.getComment(parser));
        parser.expect(";");
    }

    private static void parseSequence(Parser parser, PgDatabase pgDatabase) {
        String string = parser.parseIdentifier();
        String string2 = ParserUtils.getObjectName(string);
        String string3 = ParserUtils.getSchemaName(string, pgDatabase);
        PgSequence pgSequence = pgDatabase.getSchema(string3).getSequence(string2);
        parser.expect("IS");
        pgSequence.setComment(CommentParser.getComment(parser));
        parser.expect(";");
    }

    private static void parseTrigger(Parser parser, PgDatabase pgDatabase) {
        String string = ParserUtils.getObjectName(parser.parseIdentifier());
        parser.expect("ON");
        String string2 = parser.parseIdentifier();
        String string3 = ParserUtils.getObjectName(string2);
        String string4 = ParserUtils.getSchemaName(string2, pgDatabase);
        PgTrigger pgTrigger = pgDatabase.getSchema(string4).getTable(string3).getTrigger(string);
        parser.expect("IS");
        pgTrigger.setComment(CommentParser.getComment(parser));
        parser.expect(";");
    }

    private static void parseView(Parser parser, PgDatabase pgDatabase) {
        String string = parser.parseIdentifier();
        String string2 = ParserUtils.getObjectName(string);
        String string3 = ParserUtils.getSchemaName(string, pgDatabase);
        PgView pgView = pgDatabase.getSchema(string3).getView(string2);
        parser.expect("IS");
        pgView.setComment(CommentParser.getComment(parser));
        parser.expect(";");
    }

    private static void parseColumn(Parser parser, PgDatabase pgDatabase) {
        String string = parser.parseIdentifier();
        String string2 = ParserUtils.getObjectName(string);
        String string3 = ParserUtils.getSecondObjectName(string);
        String string4 = ParserUtils.getThirdObjectName(string);
        PgSchema pgSchema = pgDatabase.getSchema(string4);
        PgRelation pgRelation = pgSchema.getRelation(string3);
        PgColumn pgColumn = pgRelation.getColumn(string2);
        if (pgColumn == null) {
            throw new ParserException(MessageFormat.format(Resources.getString("CannotFindColumnInTable"), string, pgRelation.getName()));
        }
        parser.expect("IS");
        pgColumn.setComment(CommentParser.getComment(parser));
        parser.expect(";");
    }

    private static void parseFunction(Parser parser, PgDatabase pgDatabase) {
        Object object;
        String string = parser.parseIdentifier();
        String string2 = ParserUtils.getObjectName(string);
        String string3 = ParserUtils.getSchemaName(string, pgDatabase);
        PgSchema pgSchema = pgDatabase.getSchema(string3);
        parser.expect("(");
        PgFunction pgFunction = new PgFunction();
        pgFunction.setName(string2);
        while (!parser.expectOptional(")")) {
            object = parser.expectOptional("IN") ? "IN" : (parser.expectOptional("OUT") ? "OUT" : (parser.expectOptional("INOUT") ? "INOUT" : (parser.expectOptional("VARIADIC") ? "VARIADIC" : null)));
            int n = parser.getPosition();
            String string4 = null;
            String string5 = parser.parseDataType();
            int n2 = parser.getPosition();
            if (!parser.expectOptional(")") && !parser.expectOptional(",")) {
                parser.setPosition(n);
                string4 = ParserUtils.getObjectName(parser.parseIdentifier());
                string5 = parser.parseDataType();
            } else {
                parser.setPosition(n2);
            }
            PgFunction.Argument argument = new PgFunction.Argument();
            argument.setDataType(string5);
            argument.setMode((String)object);
            argument.setName(string4);
            pgFunction.addArgument(argument);
            if (parser.expectOptional(")")) break;
            parser.expect(",");
        }
        object = pgSchema.getFunction(pgFunction.getSignature());
        parser.expect("IS");
        ((PgFunction)object).setComment(CommentParser.getComment(parser));
        parser.expect(";");
    }

    private static String getComment(Parser parser) {
        String string = parser.parseString();
        if ("null".equalsIgnoreCase(string)) {
            return null;
        }
        return string;
    }

    private CommentParser() {
    }
}

