#include <stdbool.h>
#include <sys/resource.h>
#include <signal.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>


#include <sys/auxv.h>

#ifdef AT_PLATFORM
/* detect ARM ABI version will be optimized away if not used */
static inline bool need_armv_version(int atleastversion)
{
    int version;
    const char * platform = (const char *)getauxval(AT_PLATFORM);
    if (platform == NULL)
        return false;
    /* at least v5 */
    if (strlen(platform) < strlen("v5"))
        return false;
    if (*(platform++) != 'v')
        return false;

    char *endstr;
    errno = 0;
    version = strtol(platform,&endstr,10);
    if (errno != 0)
        return false;
    if (endstr == platform)
        return false;

    return (version >= atleastversion);

}
#endif

const struct rlimit nocore = { 0, 0 };

/* emulate kill by signal */
void
termination_handler (int signum)
{
    _exit(128+signum);
}

int main()
{
    /* no core */
    (void) setrlimit(RLIMIT_CORE, &nocore);
    /* return instead */
    struct sigaction new_action;
    new_action.sa_handler = termination_handler;
    (void) sigemptyset (&new_action.sa_mask);
    new_action.sa_flags = 0;
    (void) sigaction (SIGILL, &new_action, NULL);
    (void) sigaction (SIGBUS, &new_action, NULL);
    (void) sigaction (SIGSEGV, &new_action, NULL);
    /* now test */
    return !need_armv_version(8);;
    return 0;
}
