use strict;
use Digest::SHA3;

my $TAGS = join('|', qw(Len Msg Squeezed));
my @vecs = ();
while (<DATA>) {
	next unless /^\s*($TAGS)\s*=\s*([\dA-F]+)/o;
	push(@vecs, $2);
}

my $numtests = scalar(@vecs) / 3;
print "1..$numtests\n";

for (1 .. $numtests) {
	my $sha3 = Digest::SHA3->new(128000);
	my $Len = shift @vecs;
	my $Msg = pack("H*", shift @vecs);
	$sha3->add_bits($Msg, $Len, 1);
	my $MD = shift @vecs;
	my $computed = "";
	while (length($computed) < 512) {
		$computed .= $sha3->squeeze;
	}
	$computed = unpack("H*", substr($computed, 0, 512));
	print "not " unless $computed eq lc($MD);
	print "ok ", $_, "\n";
}

__DATA__
# Keccak(SakuraSequential|11)[r=1344, c=256], or SHAKE128 as in FIPS 202 draft

Len = 7
Msg = 4C
Squeezed = A656F4647F54B23452C2A911A75A027E5BADE8053DEB1D7456B40A6E619A9B1FF593F3B444FBFAA467B394A55162694B07091E8F107B8A7BCB8E053FD0336F11D09A933576C379EB9EDF7818C44E9B7A6947BECD1488ABC08A338D1771CD43CAAFD778F7EA4894824543F75D5F07D7D401EF5AA59E50CC2F1D9D5FA1CF248B5D0B4016876253BDEA8A9E5C308CD36CAB84E693AA63A6E4A1A97EA93D62604B19EDFDA3EA554E6138C110EA62F107D79EB4C920CFBFA53A2030F65326D62CBAAE014ED76ABA91F5621806D295364EA0818794D3C10A9855F8B77795C8A4A537B187A858EA6966BC509F43CA08ABBF2E7E2B372900739EA9564D68CDF9824693E022263EC497E52871399545F51EFA9EDCDC36DF3A460EBE4018AC9C46396F0E2E2A3F8642479CCF06B6192E21ED580DAF125C57FA725DEEEA7C45FB3148E6995164A182293CB8EDE54A803B4D0FA95A1D2C87B195957AD51234A45372F65622A65F854E1CB66D2B9E82D7D4CF553958F10F4AFE88DEE333F638E1D78791120B5C9C376D3D526149E803704BD9B64E9A1E4CEC6744CF08343E81DAC9054804FB12903DE045D9A55938ECCD2B6FCA009BFEBAF833255BD04FAC7A0E623B8A1827BCC858B1CD0AA5A27602F07DC3C1164D4E968CB27CF28EA7A8A0F05147F75035889BA2DA5A628D638E502852FFDF0E463397C7172373DAB0F5525642A759F12599

Len = 2047
Msg = 1F42ADD25C0A80A4C82AAE3A0E302ABF9261DCA7E7884FD869D96ED4CE88AAAA25304D2D79E1FA5CC1FA2C95899229BC87431AD06DA524F2140E70BD0536E9685EE7808F598D8A9FE15D40A72AEFF431239292C5F64BDB7F620E5D160B329DEB58CF6D5C0665A3DED61AE4ADBCA94DC2B7B02CDF3992FDF79B3D93E546D5823C3A630923064ED24C3D974C4602A49DF75E49CF7BD51EDC7382214CBA850C4D3D11B40A70B1D926E3755EC79693620C242AB0F23EA206BA337A7EDC5421D63126CB6C7094F6BC1CF9943796BE2A0D9EB74FC726AA0C0D3B3D39039DEAD39A7169F8C3E2365DD349E358BF08C717D2E436D65172A76ED5E1F1E694A75C19280B15
Squeezed = 745B6570B7EA6AF48BC476056E6810D9673EE24E32D3E1C352C0C3BE0F26BFB489EBF18D76DD26673FA2B96483847849EA2FA0D57361F25490965D546FEB3D15DBCCCC2366623F5C57951B898C18595653E58A866207995417A76F345DA4D3663F2624CB04D8FB45DE1D8A51E7F87BCB819AAA14F0D7F33E0E8E2E0753FE9E894E44581F1C56096B3215CA381269AC81F730A4F4B3C2E5903FB2B394CEBC7B3D87384582EF557BC5E34D46B4246714939D6840911A29827E566FC3CB49A5A6A599BDB55E704AC60C97BE158C52523F251C62139DB122091936E68F0E8A3E2EB6236FC2386D7A287DFAB845F4D8BD2F7B39456F6BD0BD8B79C8A6AE1713224C65D7B95BDA52F070AE3AF279D73224E997830D085F30AFC5B691278A809D2BD02E6D64ED9EF00B530AB4152F42871BF4C4719AE2D28E12FC70813653B7330AAE1664CDD4AFAB82619BB3D9A8BF1E5F483A9A3CC58B78D4C719CD3C8D2DC9CDF7C6776BC0829E796842657FD058DFE439931C1791D1F40EA997580FBDB5314BE868BBB20C330AD6466A7383058EF386480D609E9E11E7813DFD8186B1419C0F6007EDF017579B53766A207236450C97AA15C37C2FA14100E0153DD8A88E068BD27523252E157B55240190A6F18F7FFEBC029F6B84E1BE2850C0E2BD3F459FC90F36164C48A5E05B5EBACDB72DF25577B9E71CA2E624DF58D1BF36B8DB7073812B4B
