/* ----- encode/857xint16, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_857xint16_checksums[] = {
  "f1975f4d5aa9b69374c1b286295468accd26c0ea75cf76cceafcdd4142155810",
  "5e1d78e028b3f6eaa1be2526e5f3165ebd75ab25ad76cd4df3bd2376e70ab631",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_857xint16_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_857xint16_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_857xint16_ITEMBYTES

static void *storage_encode_857xint16_s;
static unsigned char *test_encode_857xint16_s;
static void *storage_encode_857xint16_x;
static unsigned char *test_encode_857xint16_x;
static void *storage_encode_857xint16_s2;
static unsigned char *test_encode_857xint16_s2;
static void *storage_encode_857xint16_x2;
static unsigned char *test_encode_857xint16_x2;

#define precomputed_encode_857xint16_NUM 4

static const unsigned char precomputed_encode_857xint16_s[precomputed_encode_857xint16_NUM][crypto_encode_STRBYTES] = {
  {60,115,234,207,5,46,216,231,185,243,91,59,77,65,51,163,186,108,105,179,57,128,188,70,234,121,111,211,227,31,21,55,28,177,23,131,3,131,156,69,2,98,146,55,103,67,134,251,195,42,228,217,101,242,84,30,107,229,121,36,174,86,193,60,214,245,85,133,0,235,213,156,232,125,24,54,204,196,149,155,76,128,51,196,16,255,228,214,76,189,45,172,202,45,251,250,52,194,29,30,253,134,42,227,159,243,41,201,255,210,141,66,178,1,110,244,2,131,99,204,254,77,251,166,155,3,167,244,93,83,104,20,67,207,188,248,27,69,237,99,115,158,44,155,5,79,222,91,0,240,250,15,144,91,209,77,124,39,32,140,3,190,215,41,229,69,60,184,127,165,176,127,137,51,76,27,73,21,217,60,200,107,11,75,103,171,164,122,64,42,24,227,239,192,195,93,118,26,9,227,249,211,52,224,230,185,123,247,65,65,167,234,205,201,82,164,136,117,217,215,212,44,195,116,119,185,146,119,89,149,163,113,97,209,156,56,61,186,97,232,151,161,212,215,93,61,166,75,59,103,108,38,30,148,89,19,215,68,132,108,103,75,0,89,188,33,101,233,57,179,150,251,99,142,159,170,180,64,210,61,124,240,24,182,227,213,251,237,196,159,95,79,12,6,98,240,142,211,0,252,189,168,149,207,106,217,168,148,33,45,205,253,116,72,226,164,78,17,9,117,85,75,161,139,157,160,97,180,4,33,8,39,78,101,85,45,122,65,45,86,21,110,81,177,16,172,164,16,206,154,154,157,66,152,77,69,19,153,88,180,56,19,170,170,246,84,176,207,7,238,58,132,164,153,4,48,66,43,226,219,144,39,145,157,241,115,29,128,143,248,49,98,251,184,223,82,61,17,12,249,113,109,30,6,246,226,73,195,5,78,130,154,215,222,27,86,143,29,92,65,184,134,146,22,24,70,251,235,220,191,236,215,100,155,229,4,50,41,237,189,234,148,149,176,165,53,127,31,142,144,91,29,111,166,232,216,182,87,150,252,197,63,133,83,213,110,232,108,24,182,92,143,172,109,229,214,184,212,242,108,192,59,176,13,37,120,223,151,180,231,244,178,22,103,13,27,200,63,35,57,181,39,191,143,5,11,181,202,76,97,206,54,172,60,129,175,241,85,156,99,206,187,251,116,228,57,89,178,48,166,145,1,32,137,207,77,40,45,1,10,143,119,159,233,37,210,190,215,197,113,212,27,198,91,158,85,159,104,211,87,175,161,45,3,55,130,226,58,58,95,198,125,64,4,235,120,138,233,185,70,224,81,96,239,182,218,79,172,201,229,150,218,131,205,175,250,135,155,184,4,40,219,36,208,87,38,92,176,226,90,78,184,195,164,52,2,176,19,245,242,33,238,171,23,55,45,165,125,52,5,145,17,22,127,201,111,156,242,26,175,45,252,176,104,67,244,145,241,124,67,21,122,82,209,14,161,85,6,69,62,197,107,217,78,141,42,70,123,29,96,57,39,237,117,114,199,102,117,34,176,54,172,238,33,131,214,105,74,0,120,206,152,14,120,84,56,4,44,55,254,251,224,104,136,3,235,166,46,236,197,255,15,71,145,110,238,244,224,94,249,155,189,172,32,121,195,235,98,243,43,25,240,124,249,95,119,145,108,71,12,17,82,182,120,116,167,5,131,0,185,230,12,61,125,148,56,125,199,220,133,140,110,66,100,143,247,123,124,215,31,91,181,175,10,197,30,23,177,114,20,53,40,25,117,80,189,68,13,21,169,254,230,232,11,146,179,250,41,198,176,109,176,198,155,65,111,86,113,40,11,4,170,88,248,12,108,134,224,93,35,220,108,121,152,59,143,58,217,84,74,25,249,123,75,143,211,34,132,13,230,157,100,229,85,140,25,246,207,4,98,121,227,242,122,173,254,152,235,219,157,145,55,246,18,216,73,204,169,108,92,180,229,161,160,236,172,71,167,235,191,32,232,185,201,149,196,94,170,20,242,66,100,224,3,103,152,112,114,42,240,115,172,255,254,30,220,69,139,112,87,32,10,124,87,175,91,121,135,181,98,65,144,46,40,247,107,88,90,173,40,228,36,213,204,25,38,242,26,56,107,223,222,30,127,56,190,113,35,210,189,48,116,146,124,15,185,253,150,84,35,42,166,21,140,40,161,156,201,149,48,49,167,248,80,62,186,147,89,230,140,226,170,223,35,120,135,125,160,9,159,15,42,86,85,35,210,14,214,87,37,67,49,14,252,179,30,61,148,247,239,162,162,59,192,146,147,150,10,85,76,146,198,15,138,204,231,234,102,252,154,5,25,165,189,140,245,230,101,125,174,41,21,24,219,155,239,193,49,212,116,172,7,25,16,25,146,86,62,82,248,252,120,10,121,174,184,240,16,74,234,248,99,65,58,155,27,246,165,143,20,219,181,201,237,107,252,193,57,94,84,156,202,85,201,198,155,135,147,0,75,205,199,117,34,116,20,87,111,119,186,97,100,144,140,6,93,16,38,167,75,125,77,171,233,80,180,168,62,133,135,146,172,243,155,160,35,106,101,63,153,127,19,76,181,231,179,237,31,71,157,195,155,70,180,84,140,195,151,59,95,182,107,79,89,164,124,215,179,113,25,76,158,74,116,98,173,102,47,180,98,160,249,13,12,41,169,210,74,105,36,47,48,148,238,216,230,224,144,4,11,139,24,20,193,246,30,241,36,161,220,129,196,0,4,12,161,212,109,46,246,144,138,27,206,169,34,122,215,18,146,178,71,87,0,75,29,118,164,59,240,132,152,254,84,199,204,159,73,85,254,63,148,230,102,14,246,153,28,162,15,113,41,231,252,40,58,181,185,136,175,87,142,106,120,169,228,102,83,239,243,96,31,243,54,117,229,176,98,100,33,190,63,246,15,208,187,58,220,11,131,211,160,135,242,134,113,247,221,33,171,83,46,67,160,222,184,171,240,140,159,25,90,215,242,120,3,88,141,204,32,199,227,215,219,114,161,215,145,61,68,195,205,183,211,94,219,72,101,36,145,251,100,117,236,139,97,197,229,84,248,94,116,122,9,69,64,74,171,176,231,235,157,75,239,90,18,248,184,136,221,190,205,175,3,225,42,149,93,16,162,207,247,8,59,106,54,76,221,224,176,74,140,245,186,37,250,162,62,205,179,212,69,58,0,108,74,64,79,66,214,31,25,52,74,161,95,214,59,152,18,139,109,45,245,91,156,229,216,167,3,136,234,60,242,169,135,207,74,164,180,232,36,102,58,19,202,31,45,148,181,135,205,30,107,14,247,162,228,239,69,221,119,150,239,163,238,114,103,60,227,117,0,90,39,136,129,158,38,128,132,109,65,19,216,79,212,91,190,74,36,127,51,39,28,152,151,227,7,64,231,20,132,53,187,214,253,209,134,65,222,79,179,198,136,29,215,206,49,249,91,30,4,14,95,250,228,140,52,23,186,102,39,41,148,214,180,233,170,84,111,142,42,57,178,239,87,7,75,122,193,189,55,210,45,228,36,158,112,121,54,45,190,32,202,231,198,53,134,50,22,86,242,119,122,128,26,192,134,55,231,216,99,242,129,236,186,67,250,6,207,77,166,32,65,251,213,246,78,231,254,234,247,108,224,130,214,27,176,245,113,38,211,139,166,253,92,98,143,153,110,14,19,177,104,117,80,230,131,156,177,94,151,144,128,220,17,252,74,126,237,248,192,2,126,188,223,1,31,39,194,20,75,5,22,10,116,184,172,146,90,216,222,186,72,186,4,235,186,122,115,210,149,232,78,175,180,61,239,96,149,211,10,87,196,40,184,177,195,66,167,198,127,207,206,54,171,138,107,164,91,15,157,17,241},
  {41,107,144,67,47,208,165,215,101,223,197,127,106,151,220,162,236,223,184,154,21,168,228,107,16,53,210,210,130,148,63,245,13,1,45,103,162,201,17,239,182,185,52,160,249,147,46,108,112,30,55,50,204,52,117,48,51,76,84,145,6,46,191,61,40,38,163,201,155,126,162,176,131,159,218,50,29,234,20,113,199,249,61,169,151,19,139,73,87,135,153,75,196,150,92,232,207,39,5,42,1,65,64,120,137,178,200,129,39,183,74,162,112,128,123,240,146,187,227,246,194,170,241,124,45,56,121,175,198,231,139,41,170,143,166,16,218,133,145,86,190,37,141,255,241,127,4,37,19,103,133,244,59,119,0,116,119,157,109,27,237,195,113,252,177,76,198,225,136,235,99,79,255,46,59,34,213,163,119,174,17,160,132,225,100,0,110,173,57,219,49,54,197,72,167,219,237,135,46,42,110,174,1,89,30,196,32,194,157,100,216,252,12,110,206,192,30,103,18,155,61,9,245,111,170,22,218,17,19,233,104,138,94,144,207,58,231,76,56,23,205,28,15,105,170,169,79,220,59,38,81,192,237,242,113,108,191,171,130,208,44,71,31,36,186,9,48,17,111,227,147,120,116,9,193,63,243,123,8,154,91,189,2,141,0,44,145,88,248,49,203,34,187,0,206,169,105,81,157,37,95,78,2,240,114,45,216,34,231,19,27,88,61,37,248,165,27,195,182,181,168,191,3,125,175,191,46,141,103,185,27,120,73,12,169,192,58,118,221,58,58,90,129,67,185,90,205,131,120,159,40,111,174,91,114,242,202,94,183,166,27,207,156,126,76,214,89,82,144,177,133,217,66,100,200,98,41,44,127,23,12,255,236,48,91,9,216,254,114,245,245,228,84,215,196,35,193,53,58,75,153,69,251,188,220,22,209,98,198,60,169,3,27,140,26,107,165,150,84,36,76,232,21,197,28,57,48,44,27,41,209,47,155,180,57,87,249,214,1,17,195,147,150,94,25,186,80,97,89,26,123,93,32,61,9,90,193,27,35,80,244,145,10,122,177,140,131,195,253,186,108,139,135,117,178,76,102,146,216,2,188,48,195,58,65,63,190,224,122,65,17,143,229,152,243,21,90,67,164,49,155,149,218,202,182,73,102,34,26,64,79,157,195,83,200,157,215,237,251,192,52,254,28,35,176,90,142,119,130,101,216,247,40,192,106,25,116,21,29,106,205,203,151,24,88,159,226,53,201,103,155,112,43,60,155,196,198,209,46,102,76,237,164,8,244,176,73,43,44,52,182,105,65,99,158,25,207,138,50,6,50,174,117,165,113,15,13,214,99,170,72,9,99,252,86,243,37,37,38,82,229,135,152,90,32,245,37,218,100,61,246,181,231,11,122,121,118,248,52,106,166,10,161,4,7,208,44,111,65,81,186,19,223,185,58,31,27,123,123,183,48,88,243,109,71,180,105,36,77,17,32,103,174,225,247,228,233,235,221,203,231,65,226,232,208,235,214,57,122,189,228,137,29,40,146,47,199,204,30,198,38,53,33,24,214,183,71,126,245,6,195,115,152,99,128,29,215,173,241,205,195,185,201,252,10,176,7,36,250,36,255,6,143,40,201,16,138,236,210,50,99,158,135,19,152,228,234,25,71,7,202,23,76,53,111,138,133,223,91,175,13,207,138,43,61,126,34,239,50,34,112,136,192,88,46,19,73,200,118,211,242,152,204,252,200,43,48,245,11,72,21,249,225,85,251,74,26,85,62,146,104,206,3,10,56,254,209,120,144,162,223,223,239,119,42,181,103,101,2,26,38,211,173,34,236,250,144,217,210,185,112,29,48,224,145,39,57,146,145,55,8,181,98,72,40,171,13,7,250,114,80,85,123,104,148,153,139,81,128,98,86,14,167,91,224,225,179,114,30,243,181,213,197,111,49,77,205,245,67,169,134,176,30,83,246,86,172,29,180,204,76,229,61,25,228,142,9,194,207,136,226,240,239,72,36,143,31,154,123,192,248,218,122,227,53,224,154,175,185,81,42,232,54,180,217,248,198,120,39,87,110,31,172,91,92,88,195,187,69,101,69,222,210,93,244,109,175,200,162,168,20,65,155,5,247,27,194,239,21,59,145,32,147,107,203,151,174,78,212,53,159,75,75,82,56,97,10,38,198,106,61,180,81,11,192,77,52,22,212,39,55,219,218,52,65,193,163,217,33,95,61,245,146,150,88,213,15,4,132,81,70,142,8,88,112,130,45,213,163,207,224,80,87,46,191,228,178,182,209,67,38,46,144,159,245,97,24,218,19,246,47,129,213,234,197,236,122,69,56,166,217,10,233,190,155,156,102,76,69,79,55,134,139,255,217,26,21,151,47,167,94,93,219,129,175,28,236,177,4,189,201,139,157,140,208,8,53,203,51,19,115,108,157,120,223,154,119,41,143,79,56,37,95,236,155,209,102,63,111,242,143,150,88,205,145,84,163,189,40,167,110,152,7,203,40,210,254,146,104,21,133,164,114,186,98,175,193,51,125,130,111,189,6,92,56,129,38,135,93,250,39,13,92,238,21,175,168,154,145,208,118,20,184,249,217,242,6,240,154,0,164,174,170,208,131,251,91,226,195,63,191,33,192,214,41,68,40,132,185,191,34,5,175,62,174,147,69,58,249,118,103,44,230,228,67,213,222,55,35,13,57,117,210,148,192,57,58,107,195,80,83,170,14,126,22,51,77,72,113,79,145,156,49,146,82,12,10,104,175,231,234,99,30,250,235,42,59,49,188,234,241,174,123,85,231,85,138,194,43,137,1,127,209,182,77,169,91,19,150,212,11,234,109,11,55,102,26,131,219,185,170,205,20,214,87,43,79,189,135,224,232,70,99,63,68,121,184,140,218,112,0,30,179,221,82,148,81,173,155,147,81,177,35,14,207,185,44,62,108,35,95,122,225,242,216,40,12,102,146,116,164,97,184,188,187,133,234,217,228,185,227,51,162,88,81,194,18,229,145,189,175,25,134,24,19,55,234,78,167,48,226,138,163,0,35,94,196,202,227,203,101,184,68,104,53,75,164,157,26,207,130,60,105,196,157,82,223,195,68,37,204,222,151,152,55,66,188,238,218,137,244,142,31,35,244,34,152,204,47,210,157,66,96,26,127,172,89,98,57,40,45,155,80,185,239,225,11,36,246,253,234,97,145,13,228,48,25,46,183,179,80,52,201,105,212,253,245,44,41,44,240,143,204,112,115,174,133,235,43,46,130,192,100,152,191,2,180,95,179,67,211,154,106,117,78,138,45,68,9,78,108,159,233,154,67,141,74,51,61,170,177,153,114,225,108,156,23,22,144,79,217,232,89,245,183,189,110,143,113,139,192,49,199,25,76,11,174,188,96,136,132,172,75,10,88,5,65,89,188,212,147,57,37,172,159,69,30,240,158,137,119,94,96,87,34,98,230,33,15,234,189,22,21,167,21,75,234,134,144,175,16,19,77,87,236,183,174,198,60,205,43,52,161,134,90,221,35,147,29,14,35,66,74,80,157,75,8,124,203,10,19,183,247,81,113,221,113,152,169,170,20,214,190,31,163,61,44,100,181,28,27,98,199,77,155,239,221,131,14,192,95,136,241,107,99,192,232,223,207,200,186,40,26,129,95,37,93,151,225,108,142,85,63,101,12,59,195,36,71,173,58,236,126,80,139,215,154,35,101,190,173,168,220,150,232,246,161,148,248,128,193,172,56,18,133,212,197,78,43,103,91,49,6,34,3,45,113,180,72,135,95,174,200,188,245,95,28,239,28,65,78,108,206,206,233,7,89,144,109,208,208,147,249,215,252,93,211,111,216,96,1,16,187,244,202,128,176,12,128,150,248,194,148,246},
  {32,170,132,211,101,148,101,202,87,45,187,21,180,109,253,68,214,214,201,15,190,22,243,223,213,97,15,208,42,144,54,115,139,176,112,240,75,192,73,87,94,240,153,13,50,248,212,70,37,5,9,32,204,115,13,40,175,153,249,43,48,246,43,109,235,136,198,102,110,28,131,68,177,25,3,108,16,164,217,36,71,220,103,245,107,208,166,119,18,49,202,170,233,87,18,200,18,147,234,151,54,20,183,67,185,169,167,147,237,91,12,17,196,32,52,183,243,8,103,214,69,15,60,218,101,202,92,58,244,144,3,245,102,147,209,29,61,199,205,37,245,187,19,118,25,190,41,255,139,218,147,58,94,68,75,9,104,96,246,44,133,207,199,246,170,224,79,230,53,228,136,92,10,155,246,122,25,195,38,250,13,250,187,0,214,97,195,4,136,146,141,35,56,151,21,114,249,36,163,126,249,44,17,2,23,52,163,12,72,52,191,41,213,138,115,172,84,8,164,10,90,11,73,44,108,58,71,139,246,251,54,84,87,134,24,42,33,48,85,107,50,56,178,148,254,181,90,230,190,214,90,138,2,135,132,73,221,246,28,161,103,178,91,65,128,123,212,178,129,128,119,78,70,186,164,183,133,251,5,58,208,58,76,70,127,109,222,121,16,41,127,194,247,22,192,58,57,235,116,8,1,232,37,14,249,169,5,50,62,168,90,99,122,65,157,55,67,241,115,218,245,204,19,5,38,104,226,133,234,171,122,206,163,19,59,153,96,175,150,213,23,50,72,28,164,233,54,41,110,157,131,12,116,237,10,236,62,68,152,217,195,236,29,7,29,235,99,126,53,192,17,98,59,78,70,22,101,152,205,250,199,169,189,44,124,198,124,126,75,163,90,130,20,52,255,10,214,140,179,179,40,138,37,254,66,198,0,143,168,79,1,11,142,70,104,37,162,81,93,220,224,198,79,29,215,254,96,111,178,143,229,72,194,247,12,50,181,66,247,227,201,55,108,158,247,147,8,197,68,47,58,249,122,179,111,220,176,176,254,235,228,232,248,62,142,46,211,77,158,232,46,163,212,255,156,239,238,157,198,142,194,68,124,39,135,204,245,28,20,21,122,74,96,71,74,45,80,149,122,165,111,204,205,147,76,219,36,173,26,58,124,189,58,169,37,222,13,104,126,204,98,211,185,0,70,89,73,132,227,111,5,149,4,176,111,229,52,129,192,3,157,149,219,211,94,196,139,251,120,119,47,50,98,75,186,141,57,238,241,217,108,204,204,96,166,173,209,132,153,74,17,126,254,17,226,191,246,114,102,28,237,54,50,126,97,238,255,55,82,45,123,216,226,23,158,155,34,62,146,26,223,58,242,52,159,47,42,240,32,26,203,131,117,156,66,197,113,240,20,92,167,136,154,117,253,150,123,168,169,6,218,100,242,202,94,246,62,179,44,168,26,180,166,100,201,159,9,198,132,159,162,23,73,40,237,19,40,131,105,80,52,104,246,240,36,81,61,245,104,236,117,186,162,214,163,219,125,145,38,196,10,132,87,246,197,166,22,140,151,59,139,11,255,44,197,105,49,135,30,90,24,16,43,210,23,36,117,131,28,159,237,224,225,224,102,244,116,236,156,25,226,153,63,210,77,146,195,12,19,70,162,239,253,215,230,58,179,46,84,142,224,13,95,60,112,254,130,22,230,49,105,200,119,208,37,41,95,206,242,75,192,175,45,51,103,41,33,211,4,40,255,19,191,206,215,183,200,8,153,201,57,46,104,168,109,214,134,116,128,221,44,63,150,3,199,42,205,229,0,16,74,40,131,22,89,20,142,89,214,48,150,131,238,147,45,222,27,58,56,237,194,141,70,142,127,67,100,101,64,253,101,245,44,118,227,118,147,101,64,71,158,200,142,206,245,15,10,167,193,211,44,214,11,84,63,250,204,2,6,109,166,196,241,64,171,131,101,119,20,29,225,81,139,190,211,213,210,184,253,178,145,66,234,185,84,187,217,43,232,40,193,77,209,63,144,78,71,66,22,238,176,51,170,48,172,185,240,117,104,118,243,201,139,186,98,43,143,98,138,34,125,162,212,130,59,199,82,85,122,16,0,83,121,137,216,209,160,115,181,63,180,224,97,72,183,148,14,112,166,21,140,243,200,22,89,16,43,13,15,140,15,233,254,202,47,66,83,255,63,112,183,86,66,202,63,21,202,152,86,131,92,10,67,58,222,168,79,97,152,54,129,240,85,30,101,235,73,123,55,204,16,80,116,140,130,22,195,177,224,98,66,75,245,162,222,210,220,20,59,69,161,248,121,33,248,178,49,236,81,236,216,150,124,221,85,175,32,50,120,211,21,209,51,236,200,56,242,153,158,99,251,127,213,40,122,59,203,235,119,69,167,151,160,16,164,189,113,111,6,243,190,133,120,121,225,139,137,41,51,124,244,189,213,190,90,105,152,119,39,168,211,255,112,17,54,108,92,11,120,107,118,179,66,194,5,206,199,107,69,197,231,118,117,38,144,133,252,164,156,136,14,144,158,83,170,32,211,172,164,64,205,188,202,95,121,162,181,68,26,52,190,243,174,194,247,166,162,218,58,67,108,105,95,231,246,16,85,160,108,30,62,228,4,186,187,31,133,116,6,168,194,107,199,45,211,169,107,18,22,36,163,53,125,132,203,110,170,188,183,32,20,133,45,17,131,123,233,235,31,1,126,59,190,88,95,110,134,150,230,49,120,177,88,246,53,250,36,88,217,89,133,41,193,84,111,134,229,8,147,26,155,41,251,76,190,32,32,103,125,33,202,28,82,38,244,25,17,147,244,251,229,75,216,46,149,217,40,59,89,14,12,141,41,66,255,182,26,217,181,149,177,123,61,72,158,98,99,105,121,76,229,228,102,115,105,148,169,98,6,193,191,246,136,241,210,251,139,202,133,81,84,29,3,128,51,226,248,131,156,5,42,189,188,31,219,28,211,46,208,118,190,233,247,154,17,121,39,162,208,0,211,4,162,98,248,125,21,73,168,248,112,76,15,227,205,158,127,9,27,129,255,102,219,145,149,242,17,18,228,25,65,215,55,169,79,50,204,32,45,21,77,93,224,101,95,90,88,190,202,160,100,125,238,2,242,255,123,155,45,114,77,39,82,210,70,137,30,151,72,124,194,30,140,17,116,252,58,49,189,44,210,115,71,204,158,100,77,207,132,72,170,70,234,171,177,249,146,32,96,175,197,15,245,114,175,215,78,23,75,20,200,79,96,175,9,230,47,59,68,4,137,89,132,125,19,50,236,100,136,60,175,49,71,54,231,27,195,249,120,203,203,60,13,242,208,13,27,124,255,3,24,237,246,11,156,31,73,89,53,227,246,248,83,198,236,77,221,1,240,190,59,79,59,207,97,74,99,37,163,79,5,123,58,122,34,239,119,162,11,139,227,88,35,189,169,66,96,4,117,102,78,253,35,23,80,162,24,198,169,232,180,24,34,127,58,131,168,229,201,34,42,104,44,228,198,173,8,153,144,46,85,229,188,166,194,58,247,210,16,45,30,234,38,252,195,222,172,149,118,98,126,141,7,166,141,70,230,35,41,221,110,91,146,84,68,137,79,37,124,183,187,218,106,224,130,249,143,229,251,107,159,147,50,90,48,12,193,139,224,179,157,8,72,246,192,36,123,92,29,12,102,239,210,63,135,154,181,54,207,139,11,106,101,101,19,252,243,44,79,99,204,226,102,56,214,7,158,136,66,56,158,46,209,227,60,100,131,220,60,209,153,20,236,106,136,26,59,55,29,193,246,1,142,193,168,239,104,27,239,209,94,61,13,244,182,115,83,229,112,26,154,4,60,143,162,149,77,185,61,178,72,195,121,141},
  {80,115,129,111,200,37,223,254,103,169,245,176,219,109,125,183,130,85,174,106,178,41,14,99,72,248,170,1,113,146,27,207,101,73,227,148,193,238,158,128,69,125,109,169,190,40,206,105,185,143,245,166,141,8,200,111,30,67,210,26,96,143,142,190,190,255,2,148,178,132,111,132,136,245,214,118,126,42,12,92,45,164,223,125,109,211,175,12,148,106,229,92,200,218,214,183,22,163,21,133,161,62,143,93,177,185,121,173,178,57,230,221,121,98,119,68,187,197,14,240,238,22,30,66,46,9,89,150,208,133,197,151,21,82,71,70,92,160,165,180,100,180,224,230,22,161,107,211,12,82,218,230,133,157,205,238,134,209,189,175,206,57,64,68,231,182,198,116,102,212,155,201,191,71,221,205,71,179,166,232,22,72,113,141,176,26,123,104,89,162,93,120,199,152,96,60,78,171,186,34,25,135,59,124,79,224,27,255,85,41,127,122,137,14,9,204,176,161,120,177,228,5,80,248,86,79,170,14,162,74,202,28,115,52,111,246,240,24,248,246,245,218,36,188,69,78,17,17,118,203,211,241,145,186,137,57,76,43,78,114,97,92,11,132,73,36,165,127,203,173,154,218,9,175,156,253,253,228,198,5,253,155,176,137,197,211,2,176,224,232,228,66,10,220,149,246,59,144,31,6,26,224,46,141,120,168,154,11,247,203,159,11,192,29,24,183,94,60,209,207,184,64,6,107,154,15,248,157,11,234,160,77,173,26,140,53,106,132,150,90,178,71,48,173,49,176,127,147,99,177,59,130,221,176,64,171,191,86,70,213,206,195,12,167,186,130,87,116,72,88,150,2,178,182,211,197,44,129,38,71,15,164,86,88,119,119,172,161,169,135,88,58,111,140,89,85,89,182,135,26,94,19,35,70,65,202,227,189,105,5,187,204,76,21,120,246,153,240,47,38,27,52,198,10,252,65,17,212,252,22,129,48,79,249,152,34,165,76,235,144,41,83,46,91,229,175,165,174,252,30,48,218,254,24,144,182,234,93,126,48,241,84,144,52,111,143,139,84,220,93,17,168,61,79,55,127,117,196,172,125,169,90,172,42,189,73,136,150,140,102,204,246,216,238,212,148,245,166,94,48,6,230,148,162,119,112,155,119,191,172,234,129,241,223,58,65,69,8,90,207,77,74,101,120,79,239,124,232,187,218,221,87,169,47,221,190,2,245,44,27,162,127,243,167,167,118,111,234,199,80,42,2,234,223,180,201,144,155,98,24,77,175,175,7,228,255,238,30,144,197,40,142,225,14,155,87,3,202,73,217,123,222,59,221,45,234,125,242,192,144,91,188,178,219,109,65,6,224,44,158,25,78,152,208,27,197,208,27,17,129,159,27,213,159,179,45,183,51,201,49,70,67,32,54,199,206,65,188,147,61,114,109,33,249,241,228,166,132,48,55,145,94,208,200,217,118,254,137,131,166,110,145,235,102,53,40,113,137,201,66,229,144,79,63,87,209,164,114,57,106,159,248,152,17,0,10,29,108,15,118,43,213,113,177,231,139,190,227,182,48,119,63,19,124,119,191,231,133,135,160,70,99,116,215,234,206,176,226,107,141,28,168,177,195,243,96,9,162,81,92,135,210,164,124,109,132,50,1,94,128,28,77,203,12,95,71,1,142,202,229,160,232,219,200,128,169,104,68,106,101,223,244,253,37,66,42,14,153,118,179,181,91,117,118,36,156,106,5,189,102,93,37,71,16,183,189,83,249,157,128,129,0,235,198,126,119,236,96,253,183,142,184,58,80,134,61,145,143,204,237,184,173,164,226,213,140,134,53,112,144,232,164,116,59,228,50,109,41,251,224,133,131,159,136,52,84,119,236,178,151,190,6,113,199,123,178,148,247,93,36,161,48,166,238,76,11,199,170,235,166,79,233,105,34,176,226,107,137,243,162,222,65,52,204,21,253,68,11,163,171,83,226,145,197,208,116,209,174,66,136,216,239,190,220,20,133,201,228,144,237,252,82,28,166,95,181,91,76,185,199,222,128,183,42,39,112,25,181,17,247,181,139,119,101,40,42,156,23,114,3,58,204,187,230,152,125,5,53,75,49,123,220,179,202,106,164,200,8,113,49,244,153,177,93,45,139,226,207,200,88,164,172,152,190,37,84,132,11,146,139,146,28,94,83,141,204,172,247,242,139,128,148,245,43,151,45,27,135,56,175,207,84,8,168,234,241,143,68,90,66,58,215,23,63,22,214,40,125,69,137,146,92,50,11,189,209,84,161,123,242,171,85,41,210,249,54,84,208,215,88,179,183,163,244,154,46,49,118,50,172,81,145,173,200,238,57,108,112,86,74,141,225,117,234,73,6,23,161,33,59,2,239,152,197,153,236,162,143,16,247,27,62,179,146,145,214,212,100,150,242,85,8,219,23,236,55,70,248,172,89,141,245,89,149,97,72,80,148,104,53,199,162,243,25,128,118,225,247,174,228,149,227,241,211,109,78,109,230,1,235,139,88,230,185,9,176,175,39,99,4,92,0,159,30,35,206,90,24,58,103,96,49,111,143,93,19,172,88,225,130,215,15,18,57,131,17,148,47,161,248,227,239,179,156,248,207,85,173,243,15,153,49,251,60,173,196,38,70,126,199,20,161,147,102,241,222,84,134,237,249,102,121,186,230,128,114,26,3,13,134,3,189,96,110,169,219,224,198,14,43,236,146,245,77,84,198,249,31,226,81,80,74,74,71,77,82,97,35,78,179,151,175,132,189,42,121,169,114,36,175,4,170,86,69,165,243,28,221,192,11,155,189,216,215,176,237,7,164,121,175,187,162,4,48,78,211,26,77,1,21,106,13,42,42,152,155,228,184,76,40,136,64,145,239,189,211,82,231,252,25,171,134,151,123,9,232,117,55,179,11,226,10,107,64,169,235,77,41,37,71,106,105,174,153,171,173,30,134,233,35,219,23,122,10,94,57,91,33,13,108,171,219,174,155,218,15,4,192,187,26,44,229,177,138,132,57,77,170,65,153,35,237,36,169,218,169,43,107,49,167,81,186,246,240,147,63,201,117,137,26,155,14,43,57,216,173,227,251,194,29,10,130,75,219,187,148,215,4,178,26,22,103,183,232,149,254,243,64,80,216,34,15,253,65,52,113,215,53,152,152,248,69,78,19,156,127,172,143,90,40,105,243,109,13,122,222,140,148,59,159,189,238,209,86,109,71,136,83,196,234,241,206,142,241,144,165,195,56,41,144,109,165,58,120,119,20,229,173,9,111,3,54,178,175,96,144,21,246,134,11,129,38,38,208,135,215,173,105,48,86,206,54,200,16,52,159,172,250,223,63,8,199,20,232,204,135,127,14,161,89,199,144,160,112,133,44,176,237,199,28,202,85,133,111,226,218,53,71,183,206,14,231,128,128,84,220,174,220,168,221,91,194,248,138,232,136,244,25,173,98,106,61,24,164,13,13,181,63,109,74,197,92,19,9,172,56,76,59,171,167,147,77,3,24,14,246,118,226,195,234,50,193,200,165,40,171,188,163,90,102,39,61,234,141,253,15,65,115,98,74,148,242,8,142,197,71,246,113,172,128,163,183,22,169,218,194,249,172,254,156,127,6,40,98,39,67,87,65,98,246,104,250,3,77,205,23,133,76,221,182,41,89,197,173,58,205,229,211,253,227,17,142,69,85,145,157,214,152,67,14,150,196,47,194,139,230,70,116,40,51,70,147,64,73,143,165,175,175,95,33,104,57,64,151,162,99,195,49,21,47,112,10,16,106,232,42,44,70,181,189,99,40,110,30,169,222,24,31,5,137,51,236,7,138,7,207,137,203,76,193,175,235,254,207,226,226,3,200,73,252,146,34,212,101},
} ;

static const uint16_t precomputed_encode_857xint16_x[precomputed_encode_857xint16_NUM][crypto_encode_ITEMS] = {
  {29500,53226,11781,59352,62393,15195,16717,41779,27834,45929,32825,18108,31210,54127,8163,14101,45340,33559,33539,17820,25090,14226,17255,64390,10947,55780,62053,7764,58731,9337,22190,15553,62934,34133,60160,40149,32232,13848,50380,39829,32844,50227,65296,55012,48460,44077,11722,64251,49716,7709,34557,58154,62367,51497,54015,17037,434,62574,33538,52323,19966,42747,923,62631,21341,5224,53059,63676,17691,25581,40563,39724,20229,23518,61440,4090,23440,19921,10108,35872,48643,10711,17893,47164,42367,32688,13193,6988,5449,15577,27592,19211,43879,31396,10816,58136,49391,24003,6774,58121,54265,57396,47590,63355,16705,60071,51661,42066,30088,55257,11476,29891,47479,30610,38233,29091,53601,14492,47677,59489,41367,55252,15709,19366,26427,9836,37918,4953,17623,27780,19303,22784,8636,59749,45881,64406,36451,43679,16564,15826,61564,46616,54755,60923,40900,20319,1548,61538,54158,64512,43197,53141,55658,38056,11553,64973,18548,42210,4430,29961,19285,35745,41117,46177,8452,9992,25934,11605,16762,22061,28181,45393,44048,4260,39630,40346,38978,17741,39187,46168,4920,43690,21750,53168,60935,33850,39332,12292,11074,56290,10128,40337,29681,32797,63631,25137,47355,21215,4413,63756,28017,1566,58102,49993,19973,39554,57047,22043,7567,16732,34488,5778,17944,60411,49116,55276,39780,1253,10546,48621,38122,45205,13733,8063,37006,7515,42607,55528,22454,64662,16325,21381,28373,27880,46616,36700,28076,55013,54456,27890,15296,3504,30757,38879,59316,45812,26390,6925,16328,14627,10165,36799,2821,51893,24908,14030,15532,44929,22001,25500,48078,29947,14820,45657,42544,401,35104,19919,11560,2561,30607,59807,53797,55230,29125,7124,23494,21918,26783,22483,41391,813,33335,15074,24378,32198,1088,30955,59786,18105,20960,61280,55990,44111,58825,55958,52611,64175,39815,1208,56104,53284,9815,45148,23266,47182,42179,564,5040,62197,60961,6059,11575,32165,1332,4497,32534,28617,62108,44826,64557,26800,62531,61841,17276,31253,53586,41230,1621,15941,27589,20185,10893,31558,24605,10041,30189,51058,30054,45090,44086,8686,54915,19049,30720,39118,30734,14420,11268,65079,57595,34920,60163,11942,50668,4095,37191,61038,57588,63838,48539,8364,50041,25323,11251,61465,63868,30559,27793,3143,21009,30902,42868,33541,47360,3302,32061,14484,51069,34268,28300,25666,63375,31867,8151,46427,2735,7877,45335,5234,10293,29977,48464,3396,43285,59134,3048,45970,10746,45254,45165,39878,28481,29014,2856,43524,63576,27660,57478,9053,27868,39033,36667,55610,19028,63769,19323,54159,33826,58893,25757,21989,6540,53238,25092,58233,31474,65197,60312,40411,14225,4854,18904,43468,23660,58804,41121,44268,42823,49131,59424,51641,50325,43614,61972,25666,992,39015,29296,61482,44147,65279,56350,35653,22384,2592,22396,23471,34681,25269,36929,10286,27639,23128,10413,9444,52437,9753,6898,27448,57055,32542,48696,9073,48594,29744,31890,47375,38653,9044,42538,35861,41256,51612,12437,42801,20728,47678,22931,36070,43746,9183,34680,41085,40713,10767,21846,53795,54798,9559,12611,64526,7859,37949,61431,41634,49211,37778,2710,19541,50834,35343,59340,26346,39676,6405,48549,62860,26086,44669,5417,56088,61339,12737,29908,1964,4121,37401,15958,63570,30972,30986,47278,4336,59978,25592,14913,7067,42486,5263,46555,60873,64619,14785,21598,51868,51541,39878,37767,19200,51149,8821,5236,28503,47735,25697,35984,23814,9744,19367,19837,59819,46160,16040,34693,44178,39923,9120,25962,39231,4991,46412,46055,8173,40263,39875,46150,35924,38851,24379,27574,22863,31908,46039,6513,40524,29770,44386,12134,25268,63904,3085,43305,19154,9321,12335,61076,59096,37088,2820,6283,49428,7926,9457,56481,50305,1024,41228,28116,63022,35472,52763,8873,55162,37394,18354,87,7499,42102,61499,39044,21758,52423,18847,65109,37951,26342,62990,7321,4002,10609,64743,14888,47541,44936,36439,30826,58537,21350,62447,8032,14067,58741,25264,8548,16318,4086,48080,56378,33547,41171,62087,29062,56823,43809,11859,41027,47326,61611,40844,23065,62167,888,36184,8396,58311,56279,41330,37335,17469,52675,54199,56158,25928,37156,25851,60533,24971,58821,63572,29790,2426,16453,43850,59312,40427,61259,4698,47352,56712,52670,943,10977,23957,41488,63439,15112,13930,56652,45280,35914,47861,64037,16034,46029,17876,58,19052,20288,54850,6431,18996,24481,15318,4760,28043,62765,40027,55525,935,60040,62012,34729,19151,46244,9448,14950,51731,11551,46484,52615,27422,63246,58530,17903,30685,61334,61091,26482,58172,117,10074,33160,9886,33920,16749,55315,54351,48731,9290,13183,7207,38808,2019,59200,33812,47925,64982,34513,56897,45903,35014,55069,12750,23545,1054,24334,58618,13452,47639,10086,37929,46294,43753,28500,10894,45625,22511,19207,49530,14269,11730,9444,28830,13945,48685,51744,50919,34357,5682,62038,31351,6784,34496,59191,25560,33266,47852,64067,52998,42573,16672,54779,20214,65255,63466,57452,54914,45083,29173,54054,42635,23805,36706,28313,4878,26801,20597,33766,45468,38750,32912,4572,19196,60798,49400,32258,57276,7937,49703,19220,5637,29706,44216,23186,57048,18618,1210,47851,29562,38354,20200,46255,61245,38240,2771,50263,47144,50097,42818,32710,52943,43830,27530,23460,40207,61713},
  {27433,17296,53295,55205,57189,32709,38762,41692,57324,39608,43029,27620,13584,53970,38018,62783,269,26413,51618,61201,47542,41012,37881,27694,7792,12855,13516,12405,19507,37204,11782,15807,9768,51619,32411,45218,40835,13018,59933,28948,63943,43325,5015,18827,34647,19353,38596,59484,10191,10757,16641,30784,45705,33224,46887,41546,32880,61563,48018,63203,43714,31985,14381,44921,59334,10635,36778,4262,34266,22161,9662,65421,32753,9476,26387,62597,30523,29696,40311,7021,50157,64625,19633,57798,60296,20323,12031,8763,41941,44663,40977,57732,100,44398,56121,13873,18629,56231,34797,10798,44654,22785,50206,49696,25757,64728,28172,49358,26398,39698,2365,28661,5802,4570,59667,35432,36958,15055,19687,5944,7373,26895,43434,56399,9787,49233,62189,27761,43967,53378,18220,9247,2490,4400,58223,30867,2420,16321,31731,39432,48475,36098,11264,22673,12792,8907,187,43470,20841,9629,20063,61442,11634,8920,5095,22555,9533,42488,49947,46518,49064,32003,49071,36142,47463,30747,3145,49321,30266,15069,23098,17281,23225,33741,40824,28456,23470,62066,24266,42679,53019,32412,54860,21081,45456,55685,25666,25288,11305,6015,65292,12524,2395,65240,62834,58613,55124,9156,13761,19258,17817,48379,5852,25297,15558,937,35867,27418,38565,9300,59468,50453,14620,11312,10523,12241,46235,22329,55033,4353,37827,24214,47641,24912,6745,23931,15648,23049,7105,20515,37364,31242,36017,50051,47869,35692,30087,19634,37478,728,12476,15043,16193,57534,16762,36625,39141,5619,17242,12708,38299,51930,18870,8806,16410,40271,21443,40392,60887,49403,65076,8988,23216,30606,25986,63448,49192,6506,5492,27165,52173,6295,40792,13794,26569,28827,15403,50331,53702,26158,60748,2212,45300,11081,13356,27062,25409,6558,35535,1586,44594,42357,3953,54797,43619,2376,64611,62294,9509,21030,34789,23192,62752,55845,15716,46582,3047,31098,63606,27188,2726,1185,53255,28460,20801,5050,47583,7994,31515,46971,22576,28147,46151,9321,4429,26400,57774,58615,60393,52189,16871,59618,60368,14806,48506,35300,10269,12178,52423,50718,13606,6177,47062,32327,1781,29635,25496,7552,44503,52721,47555,64713,45066,9223,9466,1791,10383,4297,60554,13010,40547,4999,58520,6634,1863,6090,13644,35439,57221,44891,53005,11146,32317,61218,8754,34928,22720,4910,51273,54134,39154,64716,11208,62768,18443,63765,21985,19195,21786,37438,52840,2563,65080,30929,41616,57311,30703,46378,25959,6658,54054,8877,64236,55696,47570,7536,57392,10129,37433,14225,46344,18530,43816,1805,29434,21840,26747,39316,20875,25216,3670,23463,57824,29363,62238,54709,28613,19761,62925,43331,45190,21278,22262,7596,52404,58700,6461,36580,49673,35023,61666,18671,36644,39455,49275,56056,58234,57397,44954,20921,59434,46134,63705,30918,22311,8046,23468,22620,48067,25925,56901,24018,28148,51375,43170,16660,1435,7159,61378,15125,8337,27539,38859,20142,13780,19359,21067,24888,9738,27334,46141,2897,19904,5684,10196,56119,13530,49473,55715,24353,62781,38546,54616,1039,20868,36422,22536,33392,54573,53155,20704,11863,58559,46770,17361,11814,40848,25077,55832,62995,33071,60117,60613,17786,42552,2777,48873,40091,19558,20293,34359,65419,6873,38677,42799,23902,33243,7343,45548,48388,35785,35997,2256,52021,4915,27763,30877,39647,10615,20367,9528,60511,53659,16230,62063,38543,52568,21649,48547,42792,39022,51975,53800,37630,5480,42117,47730,44898,13249,33405,48495,23558,33080,34598,64093,3367,61020,44821,39592,53393,5238,63928,62169,61446,154,44708,53418,64387,57947,16323,8639,54976,17449,33832,49081,1314,16047,37806,14917,30457,11367,58598,54595,14302,3363,30009,38098,14784,27450,20675,43603,32270,13078,18509,20337,40081,37425,3154,26634,59311,25578,64030,10987,12603,60092,44785,21883,21991,49802,35115,32513,46801,43341,4955,54422,59915,2925,26167,33562,47579,52650,54804,11095,48463,57479,18152,16227,31044,36024,28890,7680,56755,37970,44369,37787,45393,3619,47567,15916,9068,31327,62177,10456,26124,29842,24996,48312,34235,55786,47588,13283,22690,49745,58642,48529,6575,6278,14099,20202,12455,35554,163,24099,51908,52195,47205,26692,19253,40356,53018,15490,50281,21149,50143,9540,57036,39063,16951,61116,35290,36596,8991,8948,52376,53807,17053,6752,44159,25177,10297,39725,47440,57839,9227,65014,25066,3473,12516,11801,46007,13392,27081,64980,11509,11305,36848,28876,44659,60293,11819,49282,39012,703,24500,17331,39635,30058,35406,17453,19977,40812,39657,36163,13130,43581,39345,57714,40044,5655,20368,59609,62809,48567,36718,35697,12736,6599,2892,48302,34912,44164,2635,1368,22849,54460,14739,44069,17823,61470,35230,24183,22368,25122,8678,59919,5821,42773,19221,34538,44944,4880,22349,47084,50862,52540,13355,34465,56666,37667,3613,16931,20554,19357,31752,2763,46867,20983,56689,39025,43689,54804,8126,15779,25644,7349,25115,19911,61339,33757,49166,34911,27633,49251,57320,51407,10426,33050,9567,38749,27873,21902,25919,15116,9411,44359,60474,20606,55179,9114,48741,43181,38620,63208,38049,33016,44225,4664,54405,20165,26411,12635,8710,11523,46193,34632,44639,48328,24565,61212,16668,27726,52942,2025,36953,53357,37840,55289,24060,28627,24792,4097,62651,32970,3248,38528,49912,63124},
  {43552,54148,37989,51813,11607,5563,28084,17661,54998,4041,5822,57331,25045,53263,36906,29494,45195,61552,49227,22345,61534,3481,63538,18132,1317,8201,29644,10253,39343,11257,63024,27947,35051,26310,7278,17539,6577,27651,42000,9433,56391,62823,53355,30630,12562,43722,22505,51218,37650,38890,5174,17335,43449,37799,23533,4364,8388,46900,2291,54887,3909,55868,51813,14940,37108,62723,37734,7633,51005,9677,48117,30227,48665,65321,55947,14995,17502,2379,24680,11510,53125,63175,57514,58959,58421,23688,39690,31478,49945,64038,64013,187,25046,1219,37512,9101,38712,29205,9465,32419,11513,529,13335,3235,13384,10687,35541,44147,2132,2724,2906,11337,14956,35655,64502,21558,34391,10776,12321,27477,14386,38066,46590,58970,54974,35418,34562,18820,63197,41244,45671,16731,31616,45780,32897,20087,47686,47012,64389,14853,15056,17996,28031,31198,10512,49791,5879,15040,60217,2164,59393,3621,43513,12805,43070,25434,16762,14237,61763,55923,52469,1299,26662,34274,44010,52858,5027,39227,44896,54678,12823,7240,59812,10550,40302,3203,60788,60426,17470,55704,60611,1821,60189,32355,49205,25105,20027,5702,39013,64205,43463,11453,50812,32380,41803,33370,13332,2815,36054,46003,35368,65061,50754,36608,20392,2817,18062,9576,20898,56413,50912,7503,65239,28512,36786,18661,63426,12812,17077,58359,14281,40556,37879,50440,12100,63802,45946,56431,45232,60414,59620,16120,11918,19923,59550,41774,65492,61340,40430,36550,17602,10108,52359,7413,5396,19066,18272,11594,38224,42362,52335,37837,56140,44324,14874,48508,43322,56869,26637,52350,54114,185,22854,33865,28643,38149,45060,58735,33076,960,38301,54235,50270,64395,30584,12847,19298,36282,60985,55793,52332,24780,44454,34001,19097,32273,4606,49122,29430,7270,14061,32306,61025,14335,11602,55419,6114,39838,15906,6802,15071,13554,12191,61482,6688,33739,40053,50498,61553,23572,34983,30106,38653,43131,1705,25818,51954,63070,45886,43052,46106,25766,40905,50697,40836,6050,10313,5101,33576,20585,26676,61686,20772,62781,60520,47733,54946,56227,37245,50214,33802,63063,42693,35862,15255,2955,11519,27077,34609,23070,4120,53803,9239,33653,40732,57581,57569,62566,60532,6556,39394,53823,37453,3267,17939,61346,55293,15078,11955,36436,3552,15455,65136,5762,12774,51305,53367,10533,52831,19442,44992,13101,10599,54049,10244,5119,52927,47063,2248,51609,11833,43112,54893,29830,56704,16172,918,10951,58829,4096,10314,5763,5209,22926,12502,33686,37870,56877,14875,60728,36290,36422,17279,25956,64832,62821,30252,30435,26003,18240,51358,52878,4085,42762,54209,54828,21515,64063,716,27910,50342,16625,33707,30565,7444,20961,48779,54739,47314,45821,17041,47594,47956,11225,10472,19905,16337,20112,16967,60950,13232,12458,47532,30192,30312,51699,47755,11106,25231,8842,41597,33492,51003,21842,4218,21248,35193,53720,29600,16309,57524,18529,38071,28686,5542,62348,5832,4185,3371,35855,59663,51966,16943,65363,28735,22199,51778,5439,39114,33622,2652,14915,43230,24911,13976,61569,7765,60261,31561,52279,20496,35956,5762,45507,25312,19266,41717,53982,5340,17723,63649,8569,45816,60465,60497,38616,56700,44885,12832,54136,53525,60467,14536,39410,25502,32763,10453,15226,60363,17783,38823,4256,48548,28529,62214,34238,31096,35809,10633,31795,48628,48853,26970,30616,43047,65491,4464,27702,2908,27512,45942,49730,52741,27591,50501,30439,9845,34192,42236,34972,36878,21406,8362,44243,16548,48333,24522,41593,17589,13338,62398,49838,42743,55970,17210,26988,59231,4342,41045,7788,58430,47620,8123,29829,43014,27586,11719,43475,4715,9238,13731,33917,28363,48298,8375,34068,4397,31619,60393,287,15230,22718,28255,38534,12774,45432,63064,64053,22564,23001,10629,21697,34415,2277,6803,10651,19707,8382,26400,8573,7370,9810,6644,37649,64500,19429,11992,55701,15144,3673,36108,16937,46847,55578,38325,31665,18493,25246,26979,19577,58597,29542,37993,25257,49414,63167,61832,64466,51851,20869,7508,32771,57907,33784,1436,48426,8124,7387,11987,30416,59838,39671,30993,41511,208,1235,25250,32248,18709,63656,19568,58127,40653,2431,33051,26367,37339,62101,4625,6628,55105,43319,12879,8396,5421,23885,26080,23135,48728,41162,32100,750,65522,39803,29229,10061,53842,35142,38686,31816,7874,4492,64628,12602,11453,29650,52295,25758,53069,18564,18090,44010,63921,8338,44896,4037,29429,55215,5966,5195,20424,44896,58889,15151,1092,22921,32132,12819,25836,15496,12719,13895,7143,63939,52088,15563,61965,3536,31771,1023,60696,3062,8092,22857,58165,63734,50771,19948,477,48880,20283,53051,19041,9571,20387,31493,31290,61218,41591,35595,22755,48419,17065,1120,26229,64846,5923,41552,50712,59561,6324,32546,33594,58792,8905,26666,58412,44486,39176,11920,58709,42684,15042,54007,11536,59934,64550,57027,38316,25206,36222,42503,18061,9190,56617,23406,21650,35140,9551,46972,55995,57450,63874,58767,27643,37791,23090,3120,35777,46048,2205,63048,9408,23675,3101,61286,16338,39559,14005,35791,27147,25957,64531,11507,25423,58060,14438,2006,34974,14402,11934,58321,25660,56451,53564,5273,27372,6792,14139,49437,502,49550,61352,7016,53743,15710,62477,29622,58707,6768,1178,36668,38306,47437,45629,49992,36217},
  {29520,28545,9672,65247,43367,45301,28123,46973,21890,27310,10674,25358,63560,426,37489,53019,18789,38115,61121,32926,32069,43373,10430,27086,36793,42741,2189,28616,17182,6866,36704,48782,65470,37890,33970,33903,62856,30422,10878,23564,42029,32223,54125,3247,27284,23781,56008,47062,41750,34069,16033,23951,47537,44409,14770,56806,25209,17527,50619,61454,5870,16926,2350,38489,34256,38853,21013,17991,41052,46245,46180,59104,41238,54123,21004,59098,40325,61133,53638,44989,14798,17472,46823,29894,54374,51611,18367,52701,45895,59558,18454,36209,6832,26747,41561,30813,39111,15456,43854,8890,34585,31803,57423,65307,10581,31359,3721,52233,41392,45432,1508,63568,20310,3754,19106,7370,13427,63087,6384,63224,56053,48164,20037,4369,52086,61907,47761,14729,11084,29262,23649,33803,9289,32677,44491,55962,44809,64924,58621,1478,39933,35248,54213,45058,59616,17124,56330,63125,36923,1567,57370,36142,43128,2970,52215,2975,7616,46872,15454,53201,16568,27398,3994,40440,59915,19872,6829,13708,33898,23190,18354,44336,45105,37759,45411,33339,45277,43840,22207,54598,50126,42764,33466,29783,22600,662,46770,50643,33068,18214,41999,22614,30583,41388,34729,14936,35951,21849,46681,6791,4958,17955,51777,48611,1385,52411,5452,63096,61593,9775,13339,2758,16892,54289,5884,12417,63823,8856,19621,37099,21289,23342,45029,44709,7932,55856,6398,46736,24042,12414,21745,13456,36719,21643,24028,43025,20285,32567,50293,32172,23209,10924,18877,38536,26252,63180,61144,38100,42741,12382,58886,41620,28791,30619,44223,33258,57329,16698,2117,53082,19021,30821,61263,59516,55995,22493,12201,48861,62722,6956,32674,42995,30375,60015,20679,554,57322,51636,39824,6242,44877,1967,65508,7918,50576,36392,3809,22427,51715,55625,56955,56635,59949,62077,37056,48219,56242,16749,57350,40492,19993,53400,50459,7120,33041,7071,40917,11699,13239,12745,17222,13856,52935,48193,15763,28018,63777,58609,33958,14128,24209,51408,30425,35326,42627,37230,26347,10293,35185,17097,37093,16207,53591,29348,27193,63647,4504,2560,27677,30223,54571,45425,35815,58302,12470,16247,31763,49015,34279,41095,25414,55156,52970,58032,36203,43036,50097,24819,41481,23633,53895,31908,33901,306,32862,19740,3275,18271,36353,58826,59552,51419,43392,17512,25962,62687,9725,10818,39182,45942,23477,30325,39972,1386,26301,9565,4167,48567,63827,32925,129,50923,30590,24812,47101,47246,20538,15750,36753,60876,44472,58020,36053,13702,36976,42216,15220,13028,10605,57595,33669,34975,21556,60535,38834,1726,51057,45691,63380,9309,12449,61094,2892,43719,42731,59727,8809,58032,35179,41715,16862,52276,64789,2884,43939,57939,50577,29904,44753,34882,61400,56510,34068,58569,60816,21244,42524,46431,19547,51129,32990,10935,28711,46361,63249,35765,25975,10792,6044,882,52282,59067,32152,13573,12619,56443,51891,42090,2248,12657,39412,23985,35629,53218,22728,44196,48792,21541,2948,35730,7314,21342,52365,63404,35826,38016,11253,11671,34587,44856,21711,43016,61930,17551,16986,55098,16151,54806,32040,35141,23698,2866,53693,41300,62075,21931,53801,14073,53332,22743,47027,62627,11930,30257,44082,37201,51373,14830,28780,19030,57741,60021,1609,41239,15137,61186,50584,60569,36770,63248,15899,37555,54929,25812,62102,2133,6107,14316,63558,22956,62861,38233,18529,37968,13672,41671,6643,30336,63457,58542,58261,54257,20077,58989,60161,22667,47590,45065,10159,1123,92,7839,52771,6234,26426,12640,36719,4957,22700,33505,4055,14610,4483,12180,63649,61411,40115,53240,44373,4083,12697,15611,50349,17958,51070,41236,26259,57073,34388,63981,31078,59066,29312,794,34317,48387,28256,56233,50912,11022,37612,19957,50772,8185,20962,19024,18250,21069,9057,45902,44951,48516,31018,29353,44836,43524,17750,62373,56604,3008,48539,55256,60848,41991,44921,41659,12292,54094,19738,5377,3434,10794,39832,47332,10316,16520,61329,54205,59218,6652,34475,31639,59401,14197,2995,2786,16491,60329,10573,18213,26986,39342,44459,34334,9193,6107,2682,14686,8539,27661,56235,39854,4058,49156,6843,58668,35505,14724,43597,39233,60707,43300,43482,27435,42801,47697,61686,16275,30153,6793,3739,14635,44504,64483,7618,33290,56139,38075,1239,6834,26390,59575,65173,16627,55376,3874,16893,28980,13783,39064,17912,4942,32668,36780,10330,62313,3437,56954,38028,40763,61117,22225,18285,21384,60100,52977,61838,42384,14531,36905,42349,30778,5239,44517,28425,13827,44978,36960,62997,2950,9857,53286,55175,27053,22064,14030,4296,40756,64172,16351,50952,59412,34764,3711,22945,37063,28832,11397,60848,7367,21962,28549,56034,18229,52919,59150,32896,56404,56494,56744,49755,35576,35048,6644,25261,15722,42008,3341,16309,19053,23749,2323,14508,15180,42923,19859,6147,62990,57974,60099,49458,42440,43816,41916,26202,15655,36330,4093,29505,19042,62100,36360,18373,29174,32940,47011,43286,49882,44281,40190,1663,25128,17191,16727,63074,64104,19715,6093,19589,46813,22825,44485,52538,54245,58365,36369,21829,40337,39126,3651,50326,49711,59019,29766,13096,37702,18752,42383,44975,8543,14696,38720,25506,12739,12053,2672,27152,10984,17964,48565,10339,7790,57001,7960,35077,60467,35335,52999,52105,49484,60335,53246,58082,51203,64585,8850,26068},
} ;

static void test_encode_857xint16_impl(long long impl)
{
  unsigned char *s = test_encode_857xint16_s;
  unsigned char *x = test_encode_857xint16_x;
  unsigned char *s2 = test_encode_857xint16_s2;
  unsigned char *x2 = test_encode_857xint16_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_857xint16_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_857xint16(impl);
    printf("encode_857xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_857xint16_implementation(impl),ntruprime_dispatch_encode_857xint16_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_857xint16;
    printf("encode_857xint16 selected implementation %s compiler %s\n",ntruprime_encode_857xint16_implementation(),ntruprime_encode_857xint16_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_857xint16_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_857xint16_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_857xint16_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_857xint16_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_857xint16_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_857xint16_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_857xint16(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"857xint16")) return;
  storage_encode_857xint16_s = callocplus(crypto_encode_STRBYTES);
  test_encode_857xint16_s = aligned(storage_encode_857xint16_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_857xint16_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_857xint16_x = aligned(storage_encode_857xint16_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_857xint16_s2 = callocplus(maxalloc);
  test_encode_857xint16_s2 = aligned(storage_encode_857xint16_s2,crypto_encode_STRBYTES);
  storage_encode_857xint16_x2 = callocplus(maxalloc);
  test_encode_857xint16_x2 = aligned(storage_encode_857xint16_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_857xint16 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_857xint16();++impl)
      forked(test_encode_857xint16_impl,impl);
    ++test_encode_857xint16_s;
    ++test_encode_857xint16_x;
    ++test_encode_857xint16_s2;
    ++test_encode_857xint16_x2;
  }
  free(storage_encode_857xint16_x2);
  free(storage_encode_857xint16_s2);
  free(storage_encode_857xint16_x);
  free(storage_encode_857xint16_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

