
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file InputDataAttributes.h
    \\brief Definition of InputData Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "InputDataWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


InputDataWrapper::InputDataWrapper(): inputdata_(new InputData())

{

	
	
	
} 
InputDataWrapper::InputDataWrapper(InputData* inputdata): inputdata_(inputdata)
{
	
	
} 

InputDataWrapper::~InputDataWrapper()
{
	
}

void InputDataWrapper::set(const MagRequest& request)
{
	
	

	if  (request.countValues("INPUT_TYPE") ) {
		string type_value = request("INPUT_TYPE");
		inputdata_->type_ = type_value;
		}
	if  (request.countValues("INPUT_X_TYPE") ) {
		string x_type_value = request("INPUT_X_TYPE");
		inputdata_->x_type_ = x_type_value;
		}
	if  (request.countValues("INPUT_Y_TYPE") ) {
		string y_type_value = request("INPUT_Y_TYPE");
		inputdata_->y_type_ = y_type_value;
		}
	doublearray  x_value;
	for (int i = 0; i < request.countValues("INPUT_X_VALUES"); i++)
		x_value.push_back((double)request("INPUT_X_VALUES", i));
	if ( !x_value.empty() ) 
		inputdata_->x_ = x_value;
	doublearray  y_value;
	for (int i = 0; i < request.countValues("INPUT_Y_VALUES"); i++)
		y_value.push_back((double)request("INPUT_Y_VALUES", i));
	if ( !y_value.empty() ) 
		inputdata_->y_ = y_value;
	stringarray  date_x_value;
	for (int i = 0; i < request.countValues("INPUT_DATE_X_VALUES"); i++)
		date_x_value.push_back((string)request("INPUT_DATE_X_VALUES", i));
	if ( !date_x_value.empty() ) 
		inputdata_->date_x_ = date_x_value;
	stringarray  date_y_value;
	for (int i = 0; i < request.countValues("INPUT_DATE_Y_VALUES"); i++)
		date_y_value.push_back((string)request("INPUT_DATE_Y_VALUES", i));
	if ( !date_y_value.empty() ) 
		inputdata_->date_y_ = date_y_value;
	doublearray  x2_value;
	for (int i = 0; i < request.countValues("INPUT_X2_VALUES"); i++)
		x2_value.push_back((double)request("INPUT_X2_VALUES", i));
	if ( !x2_value.empty() ) 
		inputdata_->x2_ = x2_value;
	doublearray  y2_value;
	for (int i = 0; i < request.countValues("INPUT_Y2_VALUES"); i++)
		y2_value.push_back((double)request("INPUT_Y2_VALUES", i));
	if ( !y2_value.empty() ) 
		inputdata_->y2_ = y2_value;
	stringarray  date_x2_value;
	for (int i = 0; i < request.countValues("INPUT_DATE_X2_VALUES"); i++)
		date_x2_value.push_back((string)request("INPUT_DATE_X2_VALUES", i));
	if ( !date_x2_value.empty() ) 
		inputdata_->date_x2_ = date_x2_value;
	stringarray  date_y2_value;
	for (int i = 0; i < request.countValues("INPUT_DATE_Y2_VALUES"); i++)
		date_y2_value.push_back((string)request("INPUT_DATE_Y2_VALUES", i));
	if ( !date_y2_value.empty() ) 
		inputdata_->date_y2_ = date_y2_value;
	if  (request.countValues("INPUT_X_MISSING_VALUE") ) {
		double x_missing_value = request("INPUT_X_MISSING_VALUE");
		inputdata_->x_missing_ = x_missing_value;
		}
	if  (request.countValues("INPUT_Y_MISSING_VALUE") ) {
		double y_missing_value = request("INPUT_Y_MISSING_VALUE");
		inputdata_->y_missing_ = y_missing_value;
		}
	doublearray  values_value;
	for (int i = 0; i < request.countValues("INPUT_VALUES"); i++)
		values_value.push_back((double)request("INPUT_VALUES", i));
	if ( !values_value.empty() ) 
		inputdata_->values_ = values_value;
	doublearray  latitudes_value;
	for (int i = 0; i < request.countValues("INPUT_LATITUDE_VALUES"); i++)
		latitudes_value.push_back((double)request("INPUT_LATITUDE_VALUES", i));
	if ( !latitudes_value.empty() ) 
		inputdata_->latitudes_ = latitudes_value;
	doublearray  longitudes_value;
	for (int i = 0; i < request.countValues("INPUT_LONGITUDE_VALUES"); i++)
		longitudes_value.push_back((double)request("INPUT_LONGITUDE_VALUES", i));
	if ( !longitudes_value.empty() ) 
		inputdata_->longitudes_ = longitudes_value;
	doublearray  x_component_value;
	for (int i = 0; i < request.countValues("INPUT_X_COMPONENT_VALUES"); i++)
		x_component_value.push_back((double)request("INPUT_X_COMPONENT_VALUES", i));
	if ( !x_component_value.empty() ) 
		inputdata_->x_component_ = x_component_value;
	doublearray  y_component_value;
	for (int i = 0; i < request.countValues("INPUT_Y_COMPONENT_VALUES"); i++)
		y_component_value.push_back((double)request("INPUT_Y_COMPONENT_VALUES", i));
	if ( !y_component_value.empty() ) 
		inputdata_->y_component_ = y_component_value;
	if  (request.countValues("INPUT_AUTOMATIC") ) {
		string input_automatic_value = request("INPUT_AUTOMATIC");
		inputdata_->input_automatic_ = MagTranslator<string, bool>()(input_automatic_value);
		}
	
	
		string input_binning_value = request.countValues("INPUT_BINNING") ?  (string) request("INPUT_BINNING") : "on";
	MagLog::debug() << " INPUT_BINNING set to " << input_binning_value << endl;
	BinningObjectWrapper* input_binning_wrapper = 0;
	try
	{
		input_binning_wrapper = SimpleFactory<BinningObjectWrapper>::create(input_binning_value);
	}
	 catch (NoFactoryException) {
		MagLog::warning() << "[" << input_binning_value << "] is not a valid value for input_binning: reset to default -> [on]" << endl;
		input_binning_wrapper = SimpleFactory<BinningObjectWrapper>::create("on");
	}
	input_binning_wrapper->set(request);
	inputdata_->input_binning_ =  unique_ptr<BinningObject>(input_binning_wrapper->object());
	delete input_binning_wrapper;
	
}

void InputDataWrapper::print(ostream& out)  const
{
	out << "InputDataWrapper[]";
}


    



#include "NoBinningObjectWrapper.h"
static SimpleObjectMaker<NoBinningObject, BinningObject> InputData_input_binning_nobinning ("nobinning");
static SimpleObjectMaker<NoBinningObjectWrapper, BinningObjectWrapper> InputData_input_binning_nobinning_wrapper ("nobinning");


#include "NoBinningObjectWrapper.h"
static SimpleObjectMaker<NoBinningObject, BinningObject> InputData_input_binning_off ("off");
static SimpleObjectMaker<NoBinningObjectWrapper, BinningObjectWrapper> InputData_input_binning_off_wrapper ("off");


#include "BinningObjectWrapper.h"

static SimpleObjectMaker<BinningObjectWrapper> InputData_input_binning_binning_Wrapper("binning");


#include "BinningObjectWrapper.h"

static SimpleObjectMaker<BinningObjectWrapper> InputData_input_binning_on_Wrapper("on");



