
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file TextVisitorAttributes.h
    \\brief Definition of TextVisitor Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "TextVisitorAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

TextVisitorAttributes::TextVisitorAttributes():
	html_(ParameterManager::getBool("text_html")),
	count_(ParameterManager::getInt("text_line_count")),
	line1_(ParameterManager::getString("text_line_1")),
	line2_(ParameterManager::getString("text_line_2")),
	line3_(ParameterManager::getString("text_line_3")),
	line4_(ParameterManager::getString("text_line_4")),
	line5_(ParameterManager::getString("text_line_5")),
	line6_(ParameterManager::getString("text_line_6")),
	line7_(ParameterManager::getString("text_line_7")),
	line8_(ParameterManager::getString("text_line_8")),
	line9_(ParameterManager::getString("text_line_9")),
	line10_(ParameterManager::getString("text_line_10")),
	first_(ParameterManager::getInt("text_first_line")),
	font_(ParameterManager::getString("text_font")),
	font_style_(ParameterManager::getString("text_font_style")),
	font_dimension_(ParameterManager::getString("text_font_size")),
	orientation_(ParameterManager::getString("text_orientation")),
	automatic_(ParameterManager::getBool("text_automatic")),
	lines_(ParameterManager::getStringArray("text_lines")),
	mode_(ParameterManager::getString("text_mode")),
	x_(ParameterManager::getDouble("text_box_x_position")),
	y_(ParameterManager::getDouble("text_box_y_position")),
	width_(ParameterManager::getDouble("text_box_x_length")),
	height_(ParameterManager::getDouble("text_box_y_length")),
	blanking_(ParameterManager::getBool("text_box_blanking")),
	border_(ParameterManager::getBool("text_border")),
	border_thickness_(ParameterManager::getInt("text_border_thickness")),
	character1_(ParameterManager::getString("text_character_1")),
	character2_(ParameterManager::getString("text_character_2")),
	character3_(ParameterManager::getString("text_character_3")),
	character4_(ParameterManager::getString("text_character_4")),
	character5_(ParameterManager::getString("text_character_5")),
	character6_(ParameterManager::getString("text_character_6")),
	character7_(ParameterManager::getString("text_character_7")),
	character8_(ParameterManager::getString("text_character_8")),
	character9_(ParameterManager::getString("text_character_9")),
	character10_(ParameterManager::getString("text_character_10")),
	integer1_(ParameterManager::getInt("text_integer_1")),
	integer2_(ParameterManager::getInt("text_integer_2")),
	integer3_(ParameterManager::getInt("text_integer_3")),
	integer4_(ParameterManager::getInt("text_integer_4")),
	integer5_(ParameterManager::getInt("text_integer_5")),
	integer6_(ParameterManager::getInt("text_integer_6")),
	integer7_(ParameterManager::getInt("text_integer_7")),
	integer8_(ParameterManager::getInt("text_integer_8")),
	integer9_(ParameterManager::getInt("text_integer_9")),
	integer10_(ParameterManager::getInt("text_integer_10")),
	real1_(ParameterManager::getDouble("text_real_1")),
	real2_(ParameterManager::getDouble("text_real_2")),
	real3_(ParameterManager::getDouble("text_real_3")),
	real4_(ParameterManager::getDouble("text_real_4")),
	real5_(ParameterManager::getDouble("text_real_5")),
	real6_(ParameterManager::getDouble("text_real_6")),
	real7_(ParameterManager::getDouble("text_real_7")),
	real8_(ParameterManager::getDouble("text_real_8")),
	real9_(ParameterManager::getDouble("text_real_9")),
	real10_(ParameterManager::getDouble("text_real_10")),
	height_ratio_1_(ParameterManager::getDouble("text_line_height_ratio_1")),
	height_ratio_2_(ParameterManager::getDouble("text_line_height_ratio_2")),
	height_ratio_3_(ParameterManager::getDouble("text_line_height_ratio_3")),
	height_ratio_4_(ParameterManager::getDouble("text_line_height_ratio_4")),
	height_ratio_5_(ParameterManager::getDouble("text_line_height_ratio_5")),
	height_ratio_6_(ParameterManager::getDouble("text_line_height_ratio_6")),
	height_ratio_7_(ParameterManager::getDouble("text_line_height_ratio_7")),
	height_ratio_8_(ParameterManager::getDouble("text_line_height_ratio_8")),
	height_ratio_9_(ParameterManager::getDouble("text_line_height_ratio_9")),
	height_ratio_10_(ParameterManager::getDouble("text_line_height_ratio_10")),
	parameter_escape_(ParameterManager::getString("text_parameter_escape_character")),
	height_ratios_(ParameterManager::getDoubleArray("text_line_height_ratios"))
	,
	font_colour_(MagTranslator<string, Colour>().magics("text_colour")),
	justification_(MagTranslator<string, Justification>().magics("text_justification")),
	border_line_style_(MagTranslator<string, LineStyle>().magics("text_border_line_style")),
	border_colour_(MagTranslator<string, Colour>().magics("text_border_colour"))
	 
{
} 


TextVisitorAttributes::~TextVisitorAttributes()
{
	
}

    
void TextVisitorAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "text";
	
	setAttribute(prefix, "text_html", html_, params);
	setAttribute(prefix, "text_line_count", count_, params);
	setAttribute(prefix, "text_line_1", line1_, params);
	setAttribute(prefix, "text_line_2", line2_, params);
	setAttribute(prefix, "text_line_3", line3_, params);
	setAttribute(prefix, "text_line_4", line4_, params);
	setAttribute(prefix, "text_line_5", line5_, params);
	setAttribute(prefix, "text_line_6", line6_, params);
	setAttribute(prefix, "text_line_7", line7_, params);
	setAttribute(prefix, "text_line_8", line8_, params);
	setAttribute(prefix, "text_line_9", line9_, params);
	setAttribute(prefix, "text_line_10", line10_, params);
	setAttribute(prefix, "text_first_line", first_, params);
	setAttribute(prefix, "text_font", font_, params);
	setAttribute(prefix, "text_font_style", font_style_, params);
	setAttribute(prefix, "text_font_size", font_dimension_, params);
	setAttribute(prefix, "text_orientation", orientation_, params);
	setAttribute(prefix, "text_automatic", automatic_, params);
	setAttribute(prefix, "text_lines", lines_, params);
	setAttribute(prefix, "text_mode", mode_, params);
	setAttribute(prefix, "text_box_x_position", x_, params);
	setAttribute(prefix, "text_box_y_position", y_, params);
	setAttribute(prefix, "text_box_x_length", width_, params);
	setAttribute(prefix, "text_box_y_length", height_, params);
	setAttribute(prefix, "text_box_blanking", blanking_, params);
	setAttribute(prefix, "text_border", border_, params);
	setAttribute(prefix, "text_border_thickness", border_thickness_, params);
	setAttribute(prefix, "text_character_1", character1_, params);
	setAttribute(prefix, "text_character_2", character2_, params);
	setAttribute(prefix, "text_character_3", character3_, params);
	setAttribute(prefix, "text_character_4", character4_, params);
	setAttribute(prefix, "text_character_5", character5_, params);
	setAttribute(prefix, "text_character_6", character6_, params);
	setAttribute(prefix, "text_character_7", character7_, params);
	setAttribute(prefix, "text_character_8", character8_, params);
	setAttribute(prefix, "text_character_9", character9_, params);
	setAttribute(prefix, "text_character_10", character10_, params);
	setAttribute(prefix, "text_integer_1", integer1_, params);
	setAttribute(prefix, "text_integer_2", integer2_, params);
	setAttribute(prefix, "text_integer_3", integer3_, params);
	setAttribute(prefix, "text_integer_4", integer4_, params);
	setAttribute(prefix, "text_integer_5", integer5_, params);
	setAttribute(prefix, "text_integer_6", integer6_, params);
	setAttribute(prefix, "text_integer_7", integer7_, params);
	setAttribute(prefix, "text_integer_8", integer8_, params);
	setAttribute(prefix, "text_integer_9", integer9_, params);
	setAttribute(prefix, "text_integer_10", integer10_, params);
	setAttribute(prefix, "text_real_1", real1_, params);
	setAttribute(prefix, "text_real_2", real2_, params);
	setAttribute(prefix, "text_real_3", real3_, params);
	setAttribute(prefix, "text_real_4", real4_, params);
	setAttribute(prefix, "text_real_5", real5_, params);
	setAttribute(prefix, "text_real_6", real6_, params);
	setAttribute(prefix, "text_real_7", real7_, params);
	setAttribute(prefix, "text_real_8", real8_, params);
	setAttribute(prefix, "text_real_9", real9_, params);
	setAttribute(prefix, "text_real_10", real10_, params);
	setAttribute(prefix, "text_line_height_ratio_1", height_ratio_1_, params);
	setAttribute(prefix, "text_line_height_ratio_2", height_ratio_2_, params);
	setAttribute(prefix, "text_line_height_ratio_3", height_ratio_3_, params);
	setAttribute(prefix, "text_line_height_ratio_4", height_ratio_4_, params);
	setAttribute(prefix, "text_line_height_ratio_5", height_ratio_5_, params);
	setAttribute(prefix, "text_line_height_ratio_6", height_ratio_6_, params);
	setAttribute(prefix, "text_line_height_ratio_7", height_ratio_7_, params);
	setAttribute(prefix, "text_line_height_ratio_8", height_ratio_8_, params);
	setAttribute(prefix, "text_line_height_ratio_9", height_ratio_9_, params);
	setAttribute(prefix, "text_line_height_ratio_10", height_ratio_10_, params);
	setAttribute(prefix, "text_parameter_escape_character", parameter_escape_, params);
	setAttribute(prefix, "text_line_height_ratios", height_ratios_, params);
	
	setMember(prefix, "text_colour", font_colour_, params);
	setAttribute(prefix, "text_justification", justification_, params);
	setAttribute(prefix, "text_border_line_style", border_line_style_, params);
	setMember(prefix, "text_border_colour", border_colour_, params);
	
}

void TextVisitorAttributes::copy(const TextVisitorAttributes& other)
{
	html_ = other.html_;
	count_ = other.count_;
	line1_ = other.line1_;
	line2_ = other.line2_;
	line3_ = other.line3_;
	line4_ = other.line4_;
	line5_ = other.line5_;
	line6_ = other.line6_;
	line7_ = other.line7_;
	line8_ = other.line8_;
	line9_ = other.line9_;
	line10_ = other.line10_;
	first_ = other.first_;
	font_ = other.font_;
	font_style_ = other.font_style_;
	font_dimension_ = other.font_dimension_;
	orientation_ = other.orientation_;
	automatic_ = other.automatic_;
	lines_ = other.lines_;
	mode_ = other.mode_;
	x_ = other.x_;
	y_ = other.y_;
	width_ = other.width_;
	height_ = other.height_;
	blanking_ = other.blanking_;
	border_ = other.border_;
	border_thickness_ = other.border_thickness_;
	character1_ = other.character1_;
	character2_ = other.character2_;
	character3_ = other.character3_;
	character4_ = other.character4_;
	character5_ = other.character5_;
	character6_ = other.character6_;
	character7_ = other.character7_;
	character8_ = other.character8_;
	character9_ = other.character9_;
	character10_ = other.character10_;
	integer1_ = other.integer1_;
	integer2_ = other.integer2_;
	integer3_ = other.integer3_;
	integer4_ = other.integer4_;
	integer5_ = other.integer5_;
	integer6_ = other.integer6_;
	integer7_ = other.integer7_;
	integer8_ = other.integer8_;
	integer9_ = other.integer9_;
	integer10_ = other.integer10_;
	real1_ = other.real1_;
	real2_ = other.real2_;
	real3_ = other.real3_;
	real4_ = other.real4_;
	real5_ = other.real5_;
	real6_ = other.real6_;
	real7_ = other.real7_;
	real8_ = other.real8_;
	real9_ = other.real9_;
	real10_ = other.real10_;
	height_ratio_1_ = other.height_ratio_1_;
	height_ratio_2_ = other.height_ratio_2_;
	height_ratio_3_ = other.height_ratio_3_;
	height_ratio_4_ = other.height_ratio_4_;
	height_ratio_5_ = other.height_ratio_5_;
	height_ratio_6_ = other.height_ratio_6_;
	height_ratio_7_ = other.height_ratio_7_;
	height_ratio_8_ = other.height_ratio_8_;
	height_ratio_9_ = other.height_ratio_9_;
	height_ratio_10_ = other.height_ratio_10_;
	parameter_escape_ = other.parameter_escape_;
	height_ratios_ = other.height_ratios_;
	font_colour_ = unique_ptr<Colour>(other.font_colour_->clone());
	justification_ = other.justification_;
	border_line_style_ = other.border_line_style_;
	border_colour_ = unique_ptr<Colour>(other.border_colour_->clone());
	
} 


bool TextVisitorAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "text")  )
		return true;
	
	return false;
}

void TextVisitorAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "text")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void TextVisitorAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " html = " <<  html_;
	out << " count = " <<  count_;
	out << " line1 = " <<  line1_;
	out << " line2 = " <<  line2_;
	out << " line3 = " <<  line3_;
	out << " line4 = " <<  line4_;
	out << " line5 = " <<  line5_;
	out << " line6 = " <<  line6_;
	out << " line7 = " <<  line7_;
	out << " line8 = " <<  line8_;
	out << " line9 = " <<  line9_;
	out << " line10 = " <<  line10_;
	out << " first = " <<  first_;
	out << " font = " <<  font_;
	out << " font_style = " <<  font_style_;
	out << " font_dimension = " <<  font_dimension_;
	out << " orientation = " <<  orientation_;
	out << " automatic = " <<  automatic_;
	out << " lines = " <<  lines_;
	out << " mode = " <<  mode_;
	out << " x = " <<  x_;
	out << " y = " <<  y_;
	out << " width = " <<  width_;
	out << " height = " <<  height_;
	out << " blanking = " <<  blanking_;
	out << " border = " <<  border_;
	out << " border_thickness = " <<  border_thickness_;
	out << " character1 = " <<  character1_;
	out << " character2 = " <<  character2_;
	out << " character3 = " <<  character3_;
	out << " character4 = " <<  character4_;
	out << " character5 = " <<  character5_;
	out << " character6 = " <<  character6_;
	out << " character7 = " <<  character7_;
	out << " character8 = " <<  character8_;
	out << " character9 = " <<  character9_;
	out << " character10 = " <<  character10_;
	out << " integer1 = " <<  integer1_;
	out << " integer2 = " <<  integer2_;
	out << " integer3 = " <<  integer3_;
	out << " integer4 = " <<  integer4_;
	out << " integer5 = " <<  integer5_;
	out << " integer6 = " <<  integer6_;
	out << " integer7 = " <<  integer7_;
	out << " integer8 = " <<  integer8_;
	out << " integer9 = " <<  integer9_;
	out << " integer10 = " <<  integer10_;
	out << " real1 = " <<  real1_;
	out << " real2 = " <<  real2_;
	out << " real3 = " <<  real3_;
	out << " real4 = " <<  real4_;
	out << " real5 = " <<  real5_;
	out << " real6 = " <<  real6_;
	out << " real7 = " <<  real7_;
	out << " real8 = " <<  real8_;
	out << " real9 = " <<  real9_;
	out << " real10 = " <<  real10_;
	out << " height_ratio_1 = " <<  height_ratio_1_;
	out << " height_ratio_2 = " <<  height_ratio_2_;
	out << " height_ratio_3 = " <<  height_ratio_3_;
	out << " height_ratio_4 = " <<  height_ratio_4_;
	out << " height_ratio_5 = " <<  height_ratio_5_;
	out << " height_ratio_6 = " <<  height_ratio_6_;
	out << " height_ratio_7 = " <<  height_ratio_7_;
	out << " height_ratio_8 = " <<  height_ratio_8_;
	out << " height_ratio_9 = " <<  height_ratio_9_;
	out << " height_ratio_10 = " <<  height_ratio_10_;
	out << " parameter_escape = " <<  parameter_escape_;
	out << " height_ratios = " <<  height_ratios_;
	out << " font_colour = " <<  *font_colour_;
	out << " justification = " <<  justification_;
	out << " border_line_style = " <<  border_line_style_;
	out << " border_colour = " <<  *border_colour_;
	
	out << "]" << "\n";
}

void TextVisitorAttributes::toxml(ostream& out)  const
{
	out <<  "\"text\""; 
	out << ", \"text_html\":";
	niceprint(out,html_);
	out << ", \"text_line_count\":";
	niceprint(out,count_);
	out << ", \"text_line_1\":";
	niceprint(out,line1_);
	out << ", \"text_line_2\":";
	niceprint(out,line2_);
	out << ", \"text_line_3\":";
	niceprint(out,line3_);
	out << ", \"text_line_4\":";
	niceprint(out,line4_);
	out << ", \"text_line_5\":";
	niceprint(out,line5_);
	out << ", \"text_line_6\":";
	niceprint(out,line6_);
	out << ", \"text_line_7\":";
	niceprint(out,line7_);
	out << ", \"text_line_8\":";
	niceprint(out,line8_);
	out << ", \"text_line_9\":";
	niceprint(out,line9_);
	out << ", \"text_line_10\":";
	niceprint(out,line10_);
	out << ", \"text_first_line\":";
	niceprint(out,first_);
	out << ", \"text_font\":";
	niceprint(out,font_);
	out << ", \"text_font_style\":";
	niceprint(out,font_style_);
	out << ", \"text_font_size\":";
	niceprint(out,font_dimension_);
	out << ", \"text_orientation\":";
	niceprint(out,orientation_);
	out << ", \"text_automatic\":";
	niceprint(out,automatic_);
	out << ", \"text_lines\":";
	niceprint(out,lines_);
	out << ", \"text_mode\":";
	niceprint(out,mode_);
	out << ", \"text_box_x_position\":";
	niceprint(out,x_);
	out << ", \"text_box_y_position\":";
	niceprint(out,y_);
	out << ", \"text_box_x_length\":";
	niceprint(out,width_);
	out << ", \"text_box_y_length\":";
	niceprint(out,height_);
	out << ", \"text_box_blanking\":";
	niceprint(out,blanking_);
	out << ", \"text_border\":";
	niceprint(out,border_);
	out << ", \"text_border_thickness\":";
	niceprint(out,border_thickness_);
	out << ", \"text_character_1\":";
	niceprint(out,character1_);
	out << ", \"text_character_2\":";
	niceprint(out,character2_);
	out << ", \"text_character_3\":";
	niceprint(out,character3_);
	out << ", \"text_character_4\":";
	niceprint(out,character4_);
	out << ", \"text_character_5\":";
	niceprint(out,character5_);
	out << ", \"text_character_6\":";
	niceprint(out,character6_);
	out << ", \"text_character_7\":";
	niceprint(out,character7_);
	out << ", \"text_character_8\":";
	niceprint(out,character8_);
	out << ", \"text_character_9\":";
	niceprint(out,character9_);
	out << ", \"text_character_10\":";
	niceprint(out,character10_);
	out << ", \"text_integer_1\":";
	niceprint(out,integer1_);
	out << ", \"text_integer_2\":";
	niceprint(out,integer2_);
	out << ", \"text_integer_3\":";
	niceprint(out,integer3_);
	out << ", \"text_integer_4\":";
	niceprint(out,integer4_);
	out << ", \"text_integer_5\":";
	niceprint(out,integer5_);
	out << ", \"text_integer_6\":";
	niceprint(out,integer6_);
	out << ", \"text_integer_7\":";
	niceprint(out,integer7_);
	out << ", \"text_integer_8\":";
	niceprint(out,integer8_);
	out << ", \"text_integer_9\":";
	niceprint(out,integer9_);
	out << ", \"text_integer_10\":";
	niceprint(out,integer10_);
	out << ", \"text_real_1\":";
	niceprint(out,real1_);
	out << ", \"text_real_2\":";
	niceprint(out,real2_);
	out << ", \"text_real_3\":";
	niceprint(out,real3_);
	out << ", \"text_real_4\":";
	niceprint(out,real4_);
	out << ", \"text_real_5\":";
	niceprint(out,real5_);
	out << ", \"text_real_6\":";
	niceprint(out,real6_);
	out << ", \"text_real_7\":";
	niceprint(out,real7_);
	out << ", \"text_real_8\":";
	niceprint(out,real8_);
	out << ", \"text_real_9\":";
	niceprint(out,real9_);
	out << ", \"text_real_10\":";
	niceprint(out,real10_);
	out << ", \"text_line_height_ratio_1\":";
	niceprint(out,height_ratio_1_);
	out << ", \"text_line_height_ratio_2\":";
	niceprint(out,height_ratio_2_);
	out << ", \"text_line_height_ratio_3\":";
	niceprint(out,height_ratio_3_);
	out << ", \"text_line_height_ratio_4\":";
	niceprint(out,height_ratio_4_);
	out << ", \"text_line_height_ratio_5\":";
	niceprint(out,height_ratio_5_);
	out << ", \"text_line_height_ratio_6\":";
	niceprint(out,height_ratio_6_);
	out << ", \"text_line_height_ratio_7\":";
	niceprint(out,height_ratio_7_);
	out << ", \"text_line_height_ratio_8\":";
	niceprint(out,height_ratio_8_);
	out << ", \"text_line_height_ratio_9\":";
	niceprint(out,height_ratio_9_);
	out << ", \"text_line_height_ratio_10\":";
	niceprint(out,height_ratio_10_);
	out << ", \"text_parameter_escape_character\":";
	niceprint(out,parameter_escape_);
	out << ", \"text_line_height_ratios\":";
	niceprint(out,height_ratios_);
	out << ", \"text_colour\":";
	niceprint(out, *font_colour_);
	out << ", \"text_justification\":";
	niceprint(out, justification_);
	out << ", \"text_border_line_style\":";
	niceprint(out, border_line_style_);
	out << ", \"text_border_colour\":";
	niceprint(out, *border_colour_);
	
}

static MagicsParameter<string> text_html("text_html", "on", "");
static MagicsParameter<int> text_line_count("text_line_count", 1, "");
static MagicsParameter<string> text_line_1("text_line_1", "<magics_title/>", "");
static MagicsParameter<string> text_line_2("text_line_2", "", "");
static MagicsParameter<string> text_line_3("text_line_3", "", "");
static MagicsParameter<string> text_line_4("text_line_4", "", "");
static MagicsParameter<string> text_line_5("text_line_5", "", "");
static MagicsParameter<string> text_line_6("text_line_6", "", "");
static MagicsParameter<string> text_line_7("text_line_7", "", "");
static MagicsParameter<string> text_line_8("text_line_8", "", "");
static MagicsParameter<string> text_line_9("text_line_9", "", "");
static MagicsParameter<string> text_line_10("text_line_10", "", "");
static MagicsParameter<int> text_first_line("text_first_line", 1, "");
static MagicsParameter<string> text_font("text_font", "helvetica", "");
static MagicsParameter<string> text_font_style("text_font_style", "normal", "");
static MagicsParameter<string> text_font_size("text_font_size", "0.5", "");
static MagicsParameter<string> text_orientation("text_orientation", "horizontal", "");
static MagicsParameter<string> text_automatic("text_automatic", "on", "");
static MagicsParameter<stringarray> text_lines("text_lines", stringarray(), "");
static MagicsParameter<string> text_mode("text_mode", "title", "");
static MagicsParameter<double> text_box_x_position("text_box_x_position", -1, "");
static MagicsParameter<double> text_box_y_position("text_box_y_position", -1, "");
static MagicsParameter<double> text_box_x_length("text_box_x_length", -1, "");
static MagicsParameter<double> text_box_y_length("text_box_y_length", -1, "");
static MagicsParameter<string> text_box_blanking("text_box_blanking", "off", "");
static MagicsParameter<string> text_border("text_border", "off", "");
static MagicsParameter<int> text_border_thickness("text_border_thickness", 1, "");
static MagicsParameter<string> text_character_1("text_character_1", "", "");
static MagicsParameter<string> text_character_2("text_character_2", "", "");
static MagicsParameter<string> text_character_3("text_character_3", "", "");
static MagicsParameter<string> text_character_4("text_character_4", "", "");
static MagicsParameter<string> text_character_5("text_character_5", "", "");
static MagicsParameter<string> text_character_6("text_character_6", "", "");
static MagicsParameter<string> text_character_7("text_character_7", "", "");
static MagicsParameter<string> text_character_8("text_character_8", "", "");
static MagicsParameter<string> text_character_9("text_character_9", "", "");
static MagicsParameter<string> text_character_10("text_character_10", "", "");
static MagicsParameter<int> text_integer_1("text_integer_1", 0, "");
static MagicsParameter<int> text_integer_2("text_integer_2", 0, "");
static MagicsParameter<int> text_integer_3("text_integer_3", 0, "");
static MagicsParameter<int> text_integer_4("text_integer_4", 0, "");
static MagicsParameter<int> text_integer_5("text_integer_5", 0, "");
static MagicsParameter<int> text_integer_6("text_integer_6", 0, "");
static MagicsParameter<int> text_integer_7("text_integer_7", 0, "");
static MagicsParameter<int> text_integer_8("text_integer_8", 0, "");
static MagicsParameter<int> text_integer_9("text_integer_9", 0, "");
static MagicsParameter<int> text_integer_10("text_integer_10", 0, "");
static MagicsParameter<double> text_real_1("text_real_1", 0, "");
static MagicsParameter<double> text_real_2("text_real_2", 0, "");
static MagicsParameter<double> text_real_3("text_real_3", 0, "");
static MagicsParameter<double> text_real_4("text_real_4", 0, "");
static MagicsParameter<double> text_real_5("text_real_5", 0, "");
static MagicsParameter<double> text_real_6("text_real_6", 0, "");
static MagicsParameter<double> text_real_7("text_real_7", 0, "");
static MagicsParameter<double> text_real_8("text_real_8", 0, "");
static MagicsParameter<double> text_real_9("text_real_9", 0, "");
static MagicsParameter<double> text_real_10("text_real_10", 0, "");
static MagicsParameter<double> text_line_height_ratio_1("text_line_height_ratio_1", 1, "");
static MagicsParameter<double> text_line_height_ratio_2("text_line_height_ratio_2", 1, "");
static MagicsParameter<double> text_line_height_ratio_3("text_line_height_ratio_3", 1, "");
static MagicsParameter<double> text_line_height_ratio_4("text_line_height_ratio_4", 1, "");
static MagicsParameter<double> text_line_height_ratio_5("text_line_height_ratio_5", 1, "");
static MagicsParameter<double> text_line_height_ratio_6("text_line_height_ratio_6", 1, "");
static MagicsParameter<double> text_line_height_ratio_7("text_line_height_ratio_7", 1, "");
static MagicsParameter<double> text_line_height_ratio_8("text_line_height_ratio_8", 1, "");
static MagicsParameter<double> text_line_height_ratio_9("text_line_height_ratio_9", 1, "");
static MagicsParameter<double> text_line_height_ratio_10("text_line_height_ratio_10", 1, "");
static MagicsParameter<string> text_parameter_escape_character("text_parameter_escape_character", "@", "");
static MagicsParameter<doublearray> text_line_height_ratios("text_line_height_ratios", floatarray(), "");
static MagicsParameter<string> text_colour("text_colour", "navy", ""); 
static MagicsParameter<string> text_justification("text_justification", "centre", ""); 
static MagicsParameter<string> text_border_line_style("text_border_line_style", "solid", ""); 
static MagicsParameter<string> text_border_colour("text_border_colour", "blue", ""); 
