/*********************************************************************************
NixNote - An open-source client for the Evernote service.
Copyright (C) 2013 Randy Baumgarte

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
***********************************************************************************/

#include "mimereference.h"


MimeReference::MimeReference(QObject *parent) :
    QObject(parent)
{
    table = new QHash<QString,QString>();
    table->insert("application/vnd.hzn-3d-crossword",".x3d");
    table->insert("video/3gpp",".3gp");
    table->insert("video/3gpp2",".3g2");
    table->insert("application/vnd.mseq",".mseq");
    table->insert("application/vnd.3m.post-it-notes",".pwn");
    table->insert("application/vnd.3gpp.pic-bw-large",".plb");
    table->insert("application/vnd.3gpp.pic-bw-small",".psb");
    table->insert("application/vnd.3gpp.pic-bw-var",".pvb");
    table->insert("application/vnd.3gpp2.tcap",".tcap");
    table->insert("application/x-7z-compressed",".7z");
    table->insert("application/x-abiword",".abw");
    table->insert("application/x-ace-compressed",".ace");
    table->insert("application/vnd.americandynamics.acc",".acc");
    table->insert("application/vnd.acucobol",".acu");
    table->insert("application/vnd.acucorp",".atc");
    table->insert("audio/adpcm",".adp");
    table->insert("application/x-authorware-bin",".aab");
    table->insert("application/x-authorware-map",".aam");
    table->insert("application/x-authorware-seg",".aas");
    table->insert("application/vnd.adobe.air-application-installer-package+zip",".air");
    table->insert("application/x-shockwave-flash",".swf");
    table->insert("application/vnd.adobe.fxp",".fxp");
    table->insert("application/pdf",".pdf");
    table->insert("application/vnd.cups-ppd",".ppd");
    table->insert("application/x-director",".dir");
    table->insert("application/vnd.adobe.xdp+xml",".xdp");
    table->insert("application/vnd.adobe.xfdf",".xfdf");
    table->insert("audio/x-aac",".aac");
    table->insert("application/vnd.ahead.space",".ahead");
    table->insert("application/vnd.airzip.filesecure.azf",".azf");
    table->insert("application/vnd.airzip.filesecure.azs",".azs");
    table->insert("application/vnd.amazon.ebook",".azw");
    table->insert("application/vnd.amiga.ami",".ami");
    table->insert("application/andrew-inset","N/A");
    table->insert("application/vnd.android.package-archive",".apk");
    table->insert("application/vnd.anser-web-certificate-issue-initiation",".cii");
    table->insert("application/vnd.anser-web-funds-transfer-initiation",".fti");
    table->insert("application/vnd.antix.game-component",".atx");
    table->insert("application/vnd.apple.installer+xml",".mpkg");
    table->insert("application/applixware",".aw");
    table->insert("application/vnd.hhe.lesson-player",".les");
    table->insert("application/vnd.aristanetworks.swi",".swi");
    table->insert("text/x-asm",".s");
    table->insert("application/atomcat+xml",".atomcat");
    table->insert("application/atomsvc+xml",".atomsvc");
    table->insert("application/atom+xml",".xml");
    table->insert("application/pkix-attr-cert",".ac");
    table->insert("audio/x-aiff",".aif");
    table->insert("video/x-msvideo",".avi");
    table->insert("application/vnd.audiograph",".aep");
    table->insert("image/vnd.dxf",".dxf");
    table->insert("model/vnd.dwf",".dwf");
    table->insert("application/x-bcpio",".bcpio");
    table->insert("application/octet-stream",".bin");
    table->insert("image/bmp",".bmp");
    table->insert("application/x-bittorrent",".torrent");
    table->insert("application/vnd.rim.cod",".cod");
    table->insert("application/vnd.blueice.multipass",".mpm");
    table->insert("application/vnd.bmi",".bmi");
    table->insert("application/x-sh",".sh");
    table->insert("image/prs.btif",".btif");
    table->insert("application/vnd.businessobjects",".rep");
    table->insert("application/x-bzip",".bz");
    table->insert("application/x-bzip2",".bz2");
    table->insert("application/x-csh",".csh");
    table->insert("text/x-c",".c");
    table->insert("application/vnd.chemdraw+xml",".cdxml");
    table->insert("text/css",".css");
    table->insert("chemical/x-cdx",".cdx");
    table->insert("chemical/x-cml",".cml");
    table->insert("chemical/x-csml",".csml");
    table->insert("application/vnd.contact.cmsg",".cdbcmsg");
    table->insert("application/vnd.claymore",".cla");
    table->insert("application/vnd.clonk.c4group",".c4g");
    table->insert("image/vnd.dvb.subtitle",".sub");
    table->insert("application/cdmi-capability",".cdmia");
    table->insert("application/cdmi-container",".cdmic");
    table->insert("application/cdmi-domain",".cdmid");
    table->insert("application/cdmi-object",".cdmio");
    table->insert("application/cdmi-queue",".cdmiq");
    table->insert("application/vnd.cluetrust.cartomobile-config",".c11amc");
    table->insert("application/vnd.cluetrust.cartomobile-config-pkg",".c11amz");
    table->insert("image/x-cmu-raster",".ras");
    table->insert("model/vnd.collada+xml",".dae");
    table->insert("text/csv",".csv");
    table->insert("application/mac-compactpro",".cpt");
    table->insert("application/vnd.wap.wmlc",".wmlc");
    table->insert("image/cgm",".cgm");
    table->insert("x-conference/x-cooltalk",".ice");
    table->insert("image/x-cmx",".cmx");
    table->insert("application/vnd.xara",".xar");
    table->insert("application/vnd.cosmocaller",".cmc");
    table->insert("application/x-cpio",".cpio");
    table->insert("application/vnd.crick.clicker",".clkx");
    table->insert("application/vnd.crick.clicker.keyboard",".clkk");
    table->insert("application/vnd.crick.clicker.palette",".clkp");
    table->insert("application/vnd.crick.clicker.template",".clkt");
    table->insert("application/vnd.crick.clicker.wordbank",".clkw");
    table->insert("application/vnd.criticaltools.wbs+xml",".wbs");
    table->insert("application/vnd.rig.cryptonote",".cryptonote");
    table->insert("chemical/x-cif",".cif");
    table->insert("chemical/x-cmdf",".cmdf");
    table->insert("application/cu-seeme",".cu");
    table->insert("application/prs.cww",".cww");
    table->insert("text/vnd.curl",".curl");
    table->insert("text/vnd.curl.dcurl",".dcurl");
    table->insert("text/vnd.curl.mcurl",".mcurl");
    table->insert("text/vnd.curl.scurl",".scurl");
    table->insert("application/vnd.curl.car",".car");
    table->insert("application/vnd.curl.pcurl",".pcurl");
    table->insert("application/vnd.yellowriver-custom-menu",".cmp");
    table->insert("application/dssc+der",".dssc");
    table->insert("application/dssc+xml",".xdssc");
    table->insert("application/x-debian-package",".deb");
    table->insert("audio/vnd.dece.audio",".uva");
    table->insert("image/vnd.dece.graphic",".uvi");
    table->insert("video/vnd.dece.hd",".uvh");
    table->insert("video/vnd.dece.mobile",".uvm");
    table->insert("video/vnd.uvvu.mp4",".uvu");
    table->insert("video/vnd.dece.pd",".uvp");
    table->insert("video/vnd.dece.sd",".uvs");
    table->insert("video/vnd.dece.video",".uvv");
    table->insert("application/x-dvi",".dvi");
    table->insert("application/vnd.fdsn.seed",".seed");
    table->insert("application/x-dtbook+xml",".dtb");
    table->insert("application/x-dtbresource+xml",".res");
    table->insert("application/vnd.dvb.ait",".ait");
    table->insert("application/vnd.dvb.service",".svc");
    table->insert("audio/vnd.digital-winds",".eol");
    table->insert("image/vnd.djvu",".djvu");
    table->insert("application/xml-dtd",".dtd");
    table->insert("application/vnd.dolby.mlp",".mlp");
    table->insert("application/x-doom",".wad");
    table->insert("application/vnd.dpgraph",".dpg");
    table->insert("audio/vnd.dra",".dra");
    table->insert("application/vnd.dreamfactory",".dfac");
    table->insert("audio/vnd.dts",".dts");
    table->insert("audio/vnd.dts.hd",".dtshd");
    table->insert("image/vnd.dwg",".dwg");
    table->insert("application/vnd.dynageo",".geo");
    table->insert("application/ecmascript",".es");
    table->insert("application/vnd.ecowin.chart",".mag");
    table->insert("image/vnd.fujixerox.edmics-mmr",".mmr");
    table->insert("image/vnd.fujixerox.edmics-rlc",".rlc");
    table->insert("application/exi",".exi");
    table->insert("application/vnd.proteus.magazine",".mgz");
    table->insert("application/epub+zip",".epub");
    table->insert("message/rfc822",".eml");
    table->insert("application/vnd.enliven",".nml");
    table->insert("application/vnd.is-xpr",".xpr");
    table->insert("image/vnd.xiff",".xif");
    table->insert("application/vnd.xfdl",".xfdl");
    table->insert("application/emma+xml",".emma");
    table->insert("application/vnd.ezpix-album",".ez2");
    table->insert("application/vnd.ezpix-package",".ez3");
    table->insert("image/vnd.fst",".fst");
    table->insert("video/vnd.fvt",".fvt");
    table->insert("image/vnd.fastbidsheet",".fbs");
    table->insert("application/vnd.denovo.fcselayout-link",".fe_launch");
    table->insert("video/x-f4v",".f4v");
    table->insert("video/x-flv",".flv");
    table->insert("image/vnd.fpx",".fpx");
    table->insert("image/vnd.net-fpx",".npx");
    table->insert("text/vnd.fmi.flexstor",".flx");
    table->insert("video/x-fli",".fli");
    table->insert("application/vnd.fluxtime.clip",".ftc");
    table->insert("application/vnd.fdf",".fdf");
    table->insert("text/x-fortran",".f");
    table->insert("application/vnd.mif",".mif");
    table->insert("application/vnd.framemaker",".fm");
    table->insert("image/x-freehand",".fh");
    table->insert("application/vnd.fsc.weblaunch",".fsc");
    table->insert("application/vnd.frogans.fnc",".fnc");
    table->insert("application/vnd.frogans.ltf",".ltf");
    table->insert("application/vnd.fujixerox.ddd",".ddd");
    table->insert("application/vnd.fujixerox.docuworks",".xdw");
    table->insert("application/vnd.fujixerox.docuworks.binder",".xbd");
    table->insert("application/vnd.fujitsu.oasys",".oas");
    table->insert("application/vnd.fujitsu.oasys2",".oa2");
    table->insert("application/vnd.fujitsu.oasys3",".oa3");
    table->insert("application/vnd.fujitsu.oasysgp",".fg5");
    table->insert("application/vnd.fujitsu.oasysprs",".bh2");
    table->insert("application/x-futuresplash",".spl");
    table->insert("application/vnd.fuzzysheet",".fzs");
    table->insert("image/g3fax",".g3");
    table->insert("application/vnd.gmx",".gmx");
    table->insert("model/vnd.gtw",".gtw");
    table->insert("application/vnd.genomatix.tuxedo",".txd");
    table->insert("application/vnd.geogebra.file",".ggb");
    table->insert("application/vnd.geogebra.tool",".ggt");
    table->insert("model/vnd.gdl",".gdl");
    table->insert("application/vnd.geometry-explorer",".gex");
    table->insert("application/vnd.geonext",".gxt");
    table->insert("application/vnd.geoplan",".g2w");
    table->insert("application/vnd.geospace",".g3w");
    table->insert("application/x-font-ghostscript",".gsf");
    table->insert("application/x-font-bdf",".bdf");
    table->insert("application/x-gtar",".gtar");
    table->insert("application/x-texinfo",".texinfo");
    table->insert("application/x-gnumeric",".gnumeric");
    table->insert("application/vnd.google-earth.kml+xml",".kml");
    table->insert("application/vnd.google-earth.kmz",".kmz");
    table->insert("application/vnd.grafeq",".gqf");
    table->insert("image/gif",".gif");
    table->insert("text/vnd.graphviz",".gv");
    table->insert("application/vnd.groove-account",".gac");
    table->insert("application/vnd.groove-help",".ghf");
    table->insert("application/vnd.groove-identity-message",".gim");
    table->insert("application/vnd.groove-injector",".grv");
    table->insert("application/vnd.groove-tool-message",".gtm");
    table->insert("application/vnd.groove-tool-template",".tpl");
    table->insert("application/vnd.groove-vcard",".vcg");
    table->insert("video/h261",".h261");
    table->insert("video/h263",".h263");
    table->insert("video/h264",".h264");
    table->insert("application/vnd.hp-hpid",".hpid");
    table->insert("application/vnd.hp-hps",".hps");
    table->insert("application/x-hdf",".hdf");
    table->insert("audio/vnd.rip",".rip");
    table->insert("application/vnd.hbci",".hbci");
    table->insert("application/vnd.hp-jlyt",".jlt");
    table->insert("application/vnd.hp-pcl",".pcl");
    table->insert("application/vnd.hp-hpgl",".hpgl");
    table->insert("application/vnd.yamaha.hv-script",".hvs");
    table->insert("application/vnd.yamaha.hv-dic",".hvd");
    table->insert("application/vnd.yamaha.hv-voice",".hvp");
    table->insert("application/vnd.hydrostatix.sof-data",".sfd-hdstx");
    table->insert("application/hyperstudio",".stk");
    table->insert("application/vnd.hal+xml",".hal");
    table->insert("text/html",".html");
    table->insert("application/vnd.ibm.rights-management",".irm");
    table->insert("application/vnd.ibm.secure-container",".sc");
    table->insert("text/calendar",".ics");
    table->insert("application/vnd.iccprofile",".icc");
    table->insert("image/x-icon",".ico");
    table->insert("application/vnd.igloader",".igl");
    table->insert("image/ief",".ief");
    table->insert("application/vnd.immervision-ivp",".ivp");
    table->insert("application/vnd.immervision-ivu",".ivu");
    table->insert("application/reginfo+xml",".rif");
    table->insert("text/vnd.in3d.3dml",".3dml");
    table->insert("text/vnd.in3d.spot",".spot");
    table->insert("model/iges",".igs");
    table->insert("application/vnd.intergeo",".i2g");
    table->insert("application/vnd.cinderella",".cdy");
    table->insert("application/vnd.intercon.formnet",".xpw");
    table->insert("application/vnd.isac.fcs",".fcs");
    table->insert("application/ipfix",".ipfix");
    table->insert("application/pkix-cert",".cer");
    table->insert("application/pkixcmp",".pki");
    table->insert("application/pkix-crl",".crl");
    table->insert("application/pkix-pkipath",".pkipath");
    table->insert("application/vnd.insors.igm",".igm");
    table->insert("application/vnd.ipunplugged.rcprofile",".rcprofile");
    table->insert("application/vnd.irepository.package+xml",".irp");
    table->insert("text/vnd.sun.j2me.app-descriptor",".jad");
    table->insert("application/java-archive",".jar");
    table->insert("application/java-vm",".class");
    table->insert("application/x-java-jnlp-file",".jnlp");
    table->insert("application/java-serialized-object",".ser");
    table->insert("text/x-java-source",".java");
    table->insert("application/javascript",".js");
    table->insert("application/json",".json");
    table->insert("application/vnd.joost.joda-archive",".joda");
    table->insert("video/jpm",".jpm");
    table->insert("image/jpeg",".jpg");
    table->insert("application/vnd.kahootz",".ktz");
    table->insert("application/vnd.chipnuts.karaoke-mmd",".mmd");
    table->insert("application/vnd.kde.karbon",".karbon");
    table->insert("application/vnd.kde.kchart",".chrt");
    table->insert("application/vnd.kde.kformula",".kfo");
    table->insert("application/vnd.kde.kivio",".flw");
    table->insert("application/vnd.kde.kontour",".kon");
    table->insert("application/vnd.kde.kpresenter",".kpr");
    table->insert("application/vnd.kde.kspread",".ksp");
    table->insert("application/vnd.kde.kword",".kwd");
    table->insert("application/vnd.kenameaapp",".htke");
    table->insert("application/vnd.kidspiration",".kia");
    table->insert("application/vnd.kinar",".kne");
    table->insert("application/vnd.kodak-descriptor",".sse");
    table->insert("application/vnd.las.las+xml",".lasxml");
    table->insert("application/x-latex",".latex");
    table->insert("application/vnd.llamagraphics.life-balance.desktop",".lbd");
    table->insert("application/vnd.llamagraphics.life-balance.exchange+xml",".lbe");
    table->insert("application/vnd.jam",".jam");
    table->insert("application/vnd.lotus-1-2-3","0.123");
    table->insert("application/vnd.lotus-approach",".apr");
    table->insert("application/vnd.lotus-freelance",".pre");
    table->insert("application/vnd.lotus-notes",".nsf");
    table->insert("application/vnd.lotus-organizer",".org");
    table->insert("application/vnd.lotus-screencam",".scm");
    table->insert("application/vnd.lotus-wordpro",".lwp");
    table->insert("audio/vnd.lucent.voice",".lvp");
    table->insert("audio/x-mpegurl",".m3u");
    table->insert("video/x-m4v",".m4v");
    table->insert("application/mac-binhex40",".hqx");
    table->insert("application/vnd.macports.portpkg",".portpkg");
    table->insert("application/vnd.osgeo.mapguide.package",".mgp");
    table->insert("application/marc",".mrc");
    table->insert("application/marcxml+xml",".mrcx");
    table->insert("application/mxf",".mxf");
    table->insert("application/vnd.wolfram.player",".nbp");
    table->insert("application/mathematica",".ma");
    table->insert("application/mathml+xml",".mathml");
    table->insert("application/mbox",".mbox");
    table->insert("application/vnd.medcalcdata",".mc1");
    table->insert("application/mediaservercontrol+xml",".mscml");
    table->insert("application/vnd.mediastation.cdkey",".cdkey");
    table->insert("application/vnd.mfer",".mwf");
    table->insert("application/vnd.mfmp",".mfm");
    table->insert("model/mesh",".msh");
    table->insert("application/mads+xml",".mads");
    table->insert("application/mets+xml",".mets");
    table->insert("application/mods+xml",".mods");
    table->insert("application/metalink4+xml",".meta4");
    table->insert("application/vnd.ms-powerpoint.template.macroenabled.12",".potm");
    table->insert("application/vnd.ms-word.document.macroenabled.12",".docm");
    table->insert("application/vnd.ms-word.template.macroenabled.12",".dotm");
    table->insert("application/vnd.mcd",".mcd");
    table->insert("application/vnd.micrografx.flo",".flo");
    table->insert("application/vnd.micrografx.igx",".igx");
    table->insert("application/vnd.eszigno3+xml",".es3");
    table->insert("application/x-msaccess",".mdb");
    table->insert("video/x-ms-asf",".asf");
    table->insert("application/x-msdownload",".exe");
    table->insert("application/vnd.ms-artgalry",".cil");
    table->insert("application/vnd.ms-cab-compressed",".cab");
    table->insert("application/vnd.ms-ims",".ims");
    table->insert("application/x-ms-application",".application");
    table->insert("application/x-msclip",".clp");
    table->insert("image/vnd.ms-modi",".mdi");
    table->insert("application/vnd.ms-fontobject",".eot");
    table->insert("application/vnd.ms-excel",".xls");
    table->insert("application/vnd.ms-excel.addin.macroenabled.12",".xlam");
    table->insert("application/vnd.ms-excel.sheet.binary.macroenabled.12",".xlsb");
    table->insert("application/vnd.ms-excel.template.macroenabled.12",".xltm");
    table->insert("application/vnd.ms-excel.sheet.macroenabled.12",".xlsm");
    table->insert("application/vnd.ms-htmlhelp",".chm");
    table->insert("application/x-mscardfile",".crd");
    table->insert("application/vnd.ms-lrm",".lrm");
    table->insert("application/x-msmediaview",".mvb");
    table->insert("application/x-msmoney",".mny");
    table->insert("application/vnd.openxmlformats-officedocument.presentationml.presentation",".pptx");
    table->insert("application/vnd.openxmlformats-officedocument.presentationml.slide",".sldx");
    table->insert("application/vnd.openxmlformats-officedocument.presentationml.slideshow",".ppsx");
    table->insert("application/vnd.openxmlformats-officedocument.presentationml.template",".potx");
    table->insert("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",".xlsx");
    table->insert("application/vnd.openxmlformats-officedocument.spreadsheetml.template",".xltx");
    table->insert("application/vnd.openxmlformats-officedocument.wordprocessingml.document",".docx");
    table->insert("application/vnd.openxmlformats-officedocument.wordprocessingml.template",".dotx");
    table->insert("application/x-msbinder",".obd");
    table->insert("application/vnd.ms-officetheme",".thmx");
    table->insert("application/onenote",".onetoc");
    table->insert("audio/vnd.ms-playready.media.pya",".pya");
    table->insert("video/vnd.ms-playready.media.pyv",".pyv");
    table->insert("application/vnd.ms-powerpoint",".ppt");
    table->insert("application/vnd.ms-powerpoint.addin.macroenabled.12",".ppam");
    table->insert("application/vnd.ms-powerpoint.slide.macroenabled.12",".sldm");
    table->insert("application/vnd.ms-powerpoint.presentation.macroenabled.12",".pptm");
    table->insert("application/vnd.ms-powerpoint.slideshow.macroenabled.12",".ppsm");
    table->insert("application/vnd.ms-project",".mpp");
    table->insert("application/x-mspublisher",".pub");
    table->insert("application/x-msschedule",".scd");
    table->insert("application/x-silverlight-app",".xap");
    table->insert("application/vnd.ms-pki.stl",".stl");
    table->insert("application/vnd.ms-pki.seccat",".cat");
    table->insert("application/vnd.visio",".vsd");
    table->insert("video/x-ms-wm",".wm");
    table->insert("audio/x-ms-wma",".wma");
    table->insert("audio/x-ms-wax",".wax");
    table->insert("video/x-ms-wmx",".wmx");
    table->insert("application/x-ms-wmd",".wmd");
    table->insert("application/vnd.ms-wpl",".wpl");
    table->insert("application/x-ms-wmz",".wmz");
    table->insert("video/x-ms-wmv",".wmv");
    table->insert("video/x-ms-wvx",".wvx");
    table->insert("application/x-msmetafile",".wmf");
    table->insert("application/x-msterminal",".trm");
    table->insert("application/msword",".doc");
    table->insert("application/x-mswrite",".wri");
    table->insert("application/vnd.ms-works",".wps");
    table->insert("application/x-ms-xbap",".xbap");
    table->insert("application/vnd.ms-xpsdocument",".xps");
    table->insert("audio/midi",".mid");
    table->insert("application/vnd.ibm.minipay",".mpy");
    table->insert("application/vnd.ibm.modcap",".afp");
    table->insert("application/vnd.jcp.javame.midlet-rms",".rms");
    table->insert("application/vnd.tmobile-livetv",".tmo");
    table->insert("application/x-mobipocket-ebook",".prc");
    table->insert("application/vnd.mobius.mbk",".mbk");
    table->insert("application/vnd.mobius.dis",".dis");
    table->insert("application/vnd.mobius.plc",".plc");
    table->insert("application/vnd.mobius.mqy",".mqy");
    table->insert("application/vnd.mobius.msl",".msl");
    table->insert("application/vnd.mobius.txf",".txf");
    table->insert("application/vnd.mobius.daf",".daf");
    table->insert("text/vnd.fly",".fly");
    table->insert("application/vnd.mophun.certificate",".mpc");
    table->insert("application/vnd.mophun.application",".mpn");
    table->insert("video/mj2",".mj2");
    table->insert("audio/mpeg",".mpga");
    table->insert("video/vnd.mpegurl",".mxu");
    table->insert("video/mpeg",".mpeg");
    table->insert("application/mp21",".m21");
    table->insert("audio/mp4",".mp4a");
    table->insert("video/mp4",".mp4");
    table->insert("application/mp4",".mp4");
    table->insert("application/vnd.apple.mpegurl",".m3u8");
    table->insert("application/vnd.musician",".mus");
    table->insert("application/vnd.muvee.style",".msty");
    table->insert("application/xv+xml",".mxml");
    table->insert("application/vnd.nokia.n-gage.data",".ngdat");
    table->insert("application/vnd.nokia.n-gage.symbian.install",".n-gage");
    table->insert("application/x-dtbncx+xml",".ncx");
    table->insert("application/x-netcdf",".nc");
    table->insert("application/vnd.neurolanguage.nlu",".nlu");
    table->insert("application/vnd.dna",".dna");
    table->insert("application/vnd.noblenet-directory",".nnd");
    table->insert("application/vnd.noblenet-sealer",".nns");
    table->insert("application/vnd.noblenet-web",".nnw");
    table->insert("application/vnd.nokia.radio-preset",".rpst");
    table->insert("application/vnd.nokia.radio-presets",".rpss");
    table->insert("text/n3",".n3");
    table->insert("application/vnd.novadigm.edm",".edm");
    table->insert("application/vnd.novadigm.edx",".edx");
    table->insert("application/vnd.novadigm.ext",".ext");
    table->insert("application/vnd.flographit",".gph");
    table->insert("audio/vnd.nuera.ecelp4800",".ecelp4800");
    table->insert("audio/vnd.nuera.ecelp7470",".ecelp7470");
    table->insert("audio/vnd.nuera.ecelp9600",".ecelp9600");
    table->insert("application/oda",".oda");
    table->insert("application/ogg",".ogx");
    table->insert("audio/ogg",".oga");
    table->insert("video/ogg",".ogv");
    table->insert("application/vnd.oma.dd2+xml",".dd2");
    table->insert("application/vnd.oasis.opendocument.text-web",".oth");
    table->insert("application/oebps-package+xml",".opf");
    table->insert("application/vnd.intu.qbo",".qbo");
    table->insert("application/vnd.openofficeorg.extension",".oxt");
    table->insert("application/vnd.yamaha.openscoreformat",".osf");
    table->insert("audio/webm",".weba");
    table->insert("video/webm",".webm");
    table->insert("application/vnd.oasis.opendocument.chart",".odc");
    table->insert("application/vnd.oasis.opendocument.chart-template",".otc");
    table->insert("application/vnd.oasis.opendocument.database",".odb");
    table->insert("application/vnd.oasis.opendocument.formula",".odf");
    table->insert("application/vnd.oasis.opendocument.formula-template",".odft");
    table->insert("application/vnd.oasis.opendocument.graphics",".odg");
    table->insert("application/vnd.oasis.opendocument.graphics-template",".otg");
    table->insert("application/vnd.oasis.opendocument.image",".odi");
    table->insert("application/vnd.oasis.opendocument.image-template",".oti");
    table->insert("application/vnd.oasis.opendocument.presentation",".odp");
    table->insert("application/vnd.oasis.opendocument.presentation-template",".otp");
    table->insert("application/vnd.oasis.opendocument.spreadsheet",".ods");
    table->insert("application/vnd.oasis.opendocument.spreadsheet-template",".ots");
    table->insert("application/vnd.oasis.opendocument.text",".odt");
    table->insert("application/vnd.oasis.opendocument.text-master",".odm");
    table->insert("application/vnd.oasis.opendocument.text-template",".ott");
    table->insert("image/ktx",".ktx");
    table->insert("application/vnd.sun.xml.calc",".sxc");
    table->insert("application/vnd.sun.xml.calc.template",".stc");
    table->insert("application/vnd.sun.xml.draw",".sxd");
    table->insert("application/vnd.sun.xml.draw.template",".std");
    table->insert("application/vnd.sun.xml.impress",".sxi");
    table->insert("application/vnd.sun.xml.impress.template",".sti");
    table->insert("application/vnd.sun.xml.math",".sxm");
    table->insert("application/vnd.sun.xml.writer",".sxw");
    table->insert("application/vnd.sun.xml.writer.global",".sxg");
    table->insert("application/vnd.sun.xml.writer.template",".stw");
    table->insert("application/x-font-otf",".otf");
    table->insert("application/vnd.yamaha.openscoreformat.osfpvg+xml",".osfpvg");
    table->insert("application/vnd.osgi.dp",".dp");
    table->insert("application/vnd.palm",".pdb");
    table->insert("text/x-pascal",".p");
    table->insert("application/vnd.pawaafile",".paw");
    table->insert("application/vnd.hp-pclxl",".pclxl");
    table->insert("application/vnd.picsel",".efif");
    table->insert("image/x-pcx",".pcx");
    table->insert("image/vnd.adobe.photoshop",".psd");
    table->insert("application/pics-rules",".prf");
    table->insert("image/x-pict",".pic");
    table->insert("application/x-chat",".chat");
    table->insert("application/pkcs10",".p10");
    table->insert("application/x-pkcs12",".p12");
    table->insert("application/pkcs7-mime",".p7m");
    table->insert("application/pkcs7-signature",".p7s");
    table->insert("application/x-pkcs7-certreqresp",".p7r");
    table->insert("application/x-pkcs7-certificates",".p7b");
    table->insert("application/pkcs8",".p8");
    table->insert("application/vnd.pocketlearn",".plf");
    table->insert("image/x-portable-anymap",".pnm");
    table->insert("image/x-portable-bitmap",".pbm");
    table->insert("application/x-font-pcf",".pcf");
    table->insert("application/font-tdpfr",".pfr");
    table->insert("application/x-chess-pgn",".pgn");
    table->insert("image/x-portable-graymap",".pgm");
    table->insert("image/png",".png");
    table->insert("image/x-portable-pixmap",".ppm");
    table->insert("application/pskc+xml",".pskcxml");
    table->insert("application/vnd.ctc-posml",".pml");
    table->insert("application/postscript",".ai");
    table->insert("application/x-font-type1",".pfa");
    table->insert("application/vnd.powerbuilder6",".pbd");
    table->insert("application/pgp-encrypted","");
    table->insert("application/pgp-signature",".pgp");
    table->insert("application/vnd.previewsystems.box",".box");
    table->insert("application/vnd.pvi.ptid1",".ptid");
    table->insert("application/pls+xml",".pls");
    table->insert("application/vnd.pg.format",".str");
    table->insert("application/vnd.pg.osasli",".ei6");
    table->insert("text/prs.lines.tag",".dsc");
    table->insert("application/x-font-linux-psf",".psf");
    table->insert("application/vnd.publishare-delta-tree",".qps");
    table->insert("application/vnd.pmi.widget",".wg");
    table->insert("application/vnd.quark.quarkxpress",".qxd");
    table->insert("application/vnd.epson.esf",".esf");
    table->insert("application/vnd.epson.msf",".msf");
    table->insert("application/vnd.epson.ssf",".ssf");
    table->insert("application/vnd.epson.quickanime",".qam");
    table->insert("application/vnd.intu.qfx",".qfx");
    table->insert("video/quicktime",".qt");
    table->insert("application/x-rar-compressed",".rar");
    table->insert("audio/x-pn-realaudio",".ram");
    table->insert("audio/x-pn-realaudio-plugin",".rmp");
    table->insert("application/rsd+xml",".rsd");
    table->insert("application/vnd.rn-realmedia",".rm");
    table->insert("application/vnd.realvnc.bed",".bed");
    table->insert("application/vnd.recordare.musicxml",".mxl");
    table->insert("application/vnd.recordare.musicxml+xml",".musicxml");
    table->insert("application/relax-ng-compact-syntax",".rnc");
    table->insert("application/vnd.data-vision.rdz",".rdz");
    table->insert("application/rdf+xml",".rdf");
    table->insert("application/vnd.cloanto.rp9",".rp9");
    table->insert("application/vnd.jisp",".jisp");
    table->insert("application/rtf",".rtf");
    table->insert("text/richtext",".rtx");
    table->insert("application/vnd.route66.link66+xml",".link66");
    table->insert("application/rss+xml",".xml");
    table->insert("application/shf+xml",".shf");
    table->insert("application/vnd.sailingtracker.track",".st");
    table->insert("image/svg+xml",".svg");
    table->insert("application/vnd.sus-calendar",".sus");
    table->insert("application/sru+xml",".sru");
    table->insert("application/set-payment-initiation",".setpay");
    table->insert("application/set-registration-initiation",".setreg");
    table->insert("application/vnd.sema",".sema");
    table->insert("application/vnd.semd",".semd");
    table->insert("application/vnd.semf",".semf");
    table->insert("application/vnd.seemail",".see");
    table->insert("application/x-font-snf",".snf");
    table->insert("application/scvp-vp-request",".spq");
    table->insert("application/scvp-vp-response",".spp");
    table->insert("application/scvp-cv-request",".scq");
    table->insert("application/scvp-cv-response",".scs");
    table->insert("application/sdp",".sdp");
    table->insert("text/x-setext",".etx");
    table->insert("video/x-sgi-movie",".movie");
    table->insert("application/vnd.shana.informed.formdata",".ifm");
    table->insert("application/vnd.shana.informed.formtemplate",".itp");
    table->insert("application/vnd.shana.informed.interchange",".iif");
    table->insert("application/vnd.shana.informed.package",".ipk");
    table->insert("application/thraud+xml",".tfi");
    table->insert("application/x-shar",".shar");
    table->insert("image/x-rgb",".rgb");
    table->insert("application/vnd.epson.salt",".slt");
    table->insert("application/vnd.accpac.simply.aso",".aso");
    table->insert("application/vnd.accpac.simply.imp",".imp");
    table->insert("application/vnd.simtech-mindmapper",".twd");
    table->insert("application/vnd.commonspace",".csp");
    table->insert("application/vnd.yamaha.smaf-audio",".saf");
    table->insert("application/vnd.smaf",".mmf");
    table->insert("application/vnd.yamaha.smaf-phrase",".spf");
    table->insert("application/vnd.smart.teacher",".teacher");
    table->insert("application/vnd.svd",".svd");
    table->insert("application/sparql-query",".rq");
    table->insert("application/sparql-results+xml",".srx");
    table->insert("application/srgs",".gram");
    table->insert("application/srgs+xml",".grxml");
    table->insert("application/ssml+xml",".ssml");
    table->insert("application/vnd.koan",".skp");
    table->insert("text/sgml",".sgml");
    table->insert("application/vnd.stardivision.calc",".sdc");
    table->insert("application/vnd.stardivision.draw",".sda");
    table->insert("application/vnd.stardivision.impress",".sdd");
    table->insert("application/vnd.stardivision.math",".smf");
    table->insert("application/vnd.stardivision.writer",".sdw");
    table->insert("application/vnd.stardivision.writer-global",".sgl");
    table->insert("application/vnd.stepmania.stepchart",".sm");
    table->insert("application/x-stuffit",".sit");
    table->insert("application/x-stuffitx",".sitx");
    table->insert("application/vnd.solent.sdkm+xml",".sdkm");
    table->insert("application/vnd.olpc-sugar",".xo");
    table->insert("audio/basic",".au");
    table->insert("application/vnd.wqd",".wqd");
    table->insert("application/vnd.symbian.install",".sis");
    table->insert("application/smil+xml",".smi");
    table->insert("application/vnd.syncml+xml",".xsm");
    table->insert("application/vnd.syncml.dm+wbxml",".bdm");
    table->insert("application/vnd.syncml.dm+xml",".xdm");
    table->insert("application/x-sv4cpio",".sv4cpio");
    table->insert("application/x-sv4crc",".sv4crc");
    table->insert("application/sbml+xml",".sbml");
    table->insert("text/tab-separated-values",".tsv");
    table->insert("image/tiff",".tiff");
    table->insert("application/vnd.tao.intent-module-archive",".tao");
    table->insert("application/x-tar",".tar");
    table->insert("application/x-tcl",".tcl");
    table->insert("application/x-tex",".tex");
    table->insert("application/x-tex-tfm",".tfm");
    table->insert("application/tei+xml",".tei");
    table->insert("text/plain",".txt");
    table->insert("application/vnd.spotfire.dxp",".dxp");
    table->insert("application/vnd.spotfire.sfs",".sfs");
    table->insert("application/timestamped-data",".tsd");
    table->insert("application/vnd.trid.tpt",".tpt");
    table->insert("application/vnd.triscape.mxs",".mxs");
    table->insert("text/troff",".t");
    table->insert("application/vnd.trueapp",".tra");
    table->insert("application/x-font-ttf",".ttf");
    table->insert("text/turtle",".ttl");
    table->insert("application/vnd.umajin",".umj");
    table->insert("application/vnd.uoml+xml",".uoml");
    table->insert("application/vnd.unity",".unityweb");
    table->insert("application/vnd.ufdl",".ufd");
    table->insert("text/uri-list",".uri");
    table->insert("application/vnd.uiq.theme",".utz");
    table->insert("application/x-ustar",".ustar");
    table->insert("text/x-uuencode",".uu");
    table->insert("text/x-vcalendar",".vcs");
    table->insert("text/x-vcard",".vcf");
    table->insert("application/x-cdlink",".vcd");
    table->insert("application/vnd.vsf",".vsf");
    table->insert("model/vrml",".wrl");
    table->insert("application/vnd.vcx",".vcx");
    table->insert("model/vnd.mts",".mts");
    table->insert("model/vnd.vtu",".vtu");
    table->insert("application/vnd.visionary",".vis");
    table->insert("video/vnd.vivo",".viv");
    table->insert("application/ccxml+xml","ccxml");
    table->insert("application/voicexml+xml",".vxml");
    table->insert("application/x-wais-source",".src");
    table->insert("application/vnd.wap.wbxml",".wbxml");
    table->insert("image/vnd.wap.wbmp",".wbmp");
    table->insert("audio/x-wav",".wav");
    table->insert("application/davmount+xml",".davmount");
    table->insert("application/x-font-woff",".woff");
    table->insert("application/wspolicy+xml",".wspolicy");
    table->insert("image/webp",".webp");
    table->insert("application/vnd.webturbo",".wtb");
    table->insert("application/widget",".wgt");
    table->insert("application/winhlp",".hlp");
    table->insert("text/vnd.wap.wml",".wml");
    table->insert("text/vnd.wap.wmlscript",".wmls");
    table->insert("application/vnd.wap.wmlscriptc",".wmlsc");
    table->insert("application/vnd.wordperfect",".wpd");
    table->insert("application/vnd.wt.stf",".stf");
    table->insert("application/wsdl+xml",".wsdl");
    table->insert("image/x-xbitmap",".xbm");
    table->insert("image/x-xpixmap",".xpm");
    table->insert("image/x-xwindowdump",".xwd");
    table->insert("application/x-x509-ca-cert",".der");
    table->insert("application/x-xfig",".fig");
    table->insert("application/xhtml+xml",".xhtml");
    table->insert("application/xml",".xml");
    table->insert("application/xcap-diff+xml",".xdf");
    table->insert("application/xenc+xml",".xenc");
    table->insert("application/patch-ops-error+xml",".xer");
    table->insert("application/resource-lists+xml",".rl");
    table->insert("application/rls-services+xml",".rs");
    table->insert("application/resource-lists-diff+xml",".rld");
    table->insert("application/xslt+xml",".xslt");
    table->insert("application/xop+xml",".xop");
    table->insert("application/x-xpinstall",".xpi");
    table->insert("application/xspf+xml",".xspf");
    table->insert("application/vnd.mozilla.xul+xml",".xul");
    table->insert("chemical/x-xyz",".xyz");
    table->insert("application/yang",".yang");
    table->insert("application/yin+xml",".yin");
    table->insert("application/vnd.zul",".zir");
    table->insert("application/zip",".zip");
    table->insert("application/vnd.handheld-entertainment+xml",".zmm");
    table->insert("application/vnd.zzazz.deck+xml",".zaz");
}


MimeReference::~MimeReference() {
    delete table;
}



QString MimeReference::getExtensionFromMime(QString key, QString filename) {
    if (!table->contains(key)) {
        if (filename == "")
            filename = key;
        int pos = filename.lastIndexOf(".");
        if (pos != -1) {
            filename = filename.mid(pos);
            return filename.toLower();
        } else {
            int pos = filename.lastIndexOf("/");
            if (pos != -1) {
                pos++;
                filename = filename.mid(pos);
                return "."+filename;
            }
        }
    }
    QString extension = table->value(key);
    if (filename.endsWith(".zip", Qt::CaseInsensitive))
        extension = ".zip";
    return extension;
}

QString MimeReference::getMimeFromExtension(QString fileExtension) {

    QString retVal =  table->key(fileExtension.toLower());
    if (retVal == "") {
        return "application/data";
    }
    return retVal;
}


QString MimeReference::getExtensionFromMime(string key, string mime) {
    return this->getExtensionFromMime(QString::fromStdString(key), QString::fromStdString(mime));
}


QString MimeReference::getMimeFromExtension(string fileExtension) {
    return this->getMimeFromExtension(QString::fromStdString(fileExtension));
}



QString MimeReference::getMimeFromFileName(QString fileName) {
    int pos = fileName.lastIndexOf(".");
    if (pos != -1)
        fileName = fileName.mid(pos);
    return getMimeFromExtension(fileName);
}


QString MimeReference::getMimeFromFileName(string filename) {
    return getMimeFromFileName(QString::fromStdString(filename));
}
