/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.HealpixNested;
import cds.healpix.HealpixNestedFast;
import cds.healpix.Projection;
import cds.healpix.common.math.FastMath;
import cds.healpix.common.math.HackersDelight;
import cds.healpix.common.math.Math;
import cds.healpix.fillingcurve.FillingCurve2DType;
import java.util.EnumMap;

public final class Healpix
implements Projection {
    public static final int DEPTH_MAX = 29;
    private static final int NSIDE_MAX = Healpix.nside(29);
    private static final int N_LAT = 3;
    private static final int N_LON = 4;
    private static final int N_DEPTH0_HASH = 12;
    public static final double TRANSITION_Z = 0.6666666666666666;
    static final double ONE_OVER_TRANSITION_Z = 1.5;
    public static final double TRANSITION_LATITUDE = Math.asin(0.6666666666666666);
    public static double[] SMALLER_EDGE2OPEDGE_DIST = new double[]{0.8410686705685088, 0.37723631722170053, 0.18256386461918295, 0.09000432499034523, 0.04470553761855741, 0.02228115704023076, 0.011122977211214961, 0.005557125022105058, 0.0027774761500209185, 0.0013884670480328143, 6.941658374603201E-4, 3.4706600585087755E-4, 1.7352877579970442E-4, 8.676333125510362E-5, 4.338140148342286E-5, 2.1690634707822447E-5, 1.084530084565172E-5, 5.422646295795749E-6, 2.711322116099695E-6, 1.3556608000873442E-6, 6.778303355805395E-7, 3.389151516386149E-7, 1.69457571754776E-7, 8.472878485272006E-8, 4.236439215502565E-8, 2.1182195982014308E-8, 1.0591097960375205E-8, 5.295548939447981E-9, 2.647774429917369E-9, 1.3238871881399636E-9};
    public static final double LAT_OF_SQUARE_CELL = 0.39934019947897775;
    static final double COS_LAT_OF_SQUARE_CELL = 0.9213177319235613;
    private static final double EQUAT_PARABOLA_COEFF = 0.4933905296766163;
    private static final double[] DIST_CW_EQUATOR = new double[]{0.7853981633974483, 0.39269908169872414, 0.19634954084936207, 0.09817477042468103, 0.04908738521234052, 0.02454369260617026, 0.01227184630308513, 0.006135923151542565, 0.0030679615757712823, 0.0015339807878856412, 7.669903939428206E-4, 3.834951969714103E-4, 1.9174759848570515E-4, 9.587379924285257E-5, 4.7936899621426287E-5, 2.3968449810713143E-5, 1.1984224905356572E-5, 5.992112452678286E-6, 2.996056226339143E-6, 1.4980281131695715E-6, 7.490140565847857E-7, 3.7450702829239286E-7, 1.8725351414619643E-7, 9.362675707309822E-8, 4.681337853654911E-8, 2.3406689268274554E-8, 1.1703344634137277E-8, 5.8516723170686385E-9, 2.9258361585343192E-9, 1.4629180792671596E-9};
    private static final double[] DIST_TRANSIT_LAT_TO_PREV_RING = new double[]{0.8410686705679302, 0.4299308082455824, 0.21870018201290964, 0.11049492567137786, 0.05556369564623209, 0.027864942299874795, 0.013953769172063923, 0.006982275959440676, 0.0034924942664104064, 0.0017465872656792225, 8.733787988972619E-4, 4.367107076018728E-4, 2.1836068292035993E-4, 1.0918167400042478E-4, 5.459117016770598E-5, 2.7295668379889726E-5, 1.3647855014453647E-5, 6.823932713562186E-6, 3.411967658295545E-6, 1.7059841546096521E-6, 8.529921586841738E-7, 4.2649609977019054E-7, 2.1324805488109888E-7, 1.0662402882832822E-7, 5.331201469171987E-8, 2.6656007512393387E-8, 1.3328003811707845E-8, 6.664001905853922E-9, 3.33200089741581E-9, 1.666000448707905E-9};
    private static final double[] POLAR_LINEAR_COEFF = new double[]{Double.NaN, 0.1312192099038766, 0.060492837392452155, 0.029001500919391094, 0.01419382425997025, 0.007020691494838553, 0.0034913519041639258, 0.0017409349692292947, 8.692831611333698E-4, 4.343456141662374E-4, 2.1709882974034925E-4, 1.0853092231337608E-4, 5.426083823966203E-5, 2.7129263418298822E-5, 1.356434278725635E-5, 6.782099163568464E-6, 3.391031524325326E-6, 1.6955112477746438E-6, 8.477544953072421E-7, 4.238769654916027E-7, 2.1193841220245034E-7, 1.0596918844808161E-7, 5.298458983383655E-8, 2.649229379051603E-8, 1.324614662808308E-8, 6.62307322705194E-9, 3.311536588893444E-9, 1.6557682911737157E-9, 8.278841563091061E-10, 4.1394207794998953E-10};
    private static double[] EQUAT_LINEAR_COEFF = new double[]{0.35554441795671393, 0.20621297683954326, 0.11441072474544801, 0.06067048988147291, 0.03129240237539165, 0.01589770733619387, 0.008013317441437975, 0.004022977056353704, 0.0020155936679524915, 0.0010088263297003488, 5.046709411546653E-4, 2.523999650150198E-4, 1.2621611241593917E-4, 6.311208947320893E-5, 3.155705315107901E-5, 1.5778778691759518E-5, 7.889452376446927E-6, 3.944741946495324E-6, 1.9723749126056044E-6, 9.861884413943153E-7, 4.930944670120405E-7, 2.4654729533676847E-7, 1.232736627900346E-7, 6.163683559547574E-8, 3.081841863782956E-8, 1.5409209822969793E-8, 7.704605079503234E-9, 3.852302539751617E-9, 1.926151101857471E-9, 9.630755509287354E-10};
    public static final FillingCurve2DType DEFAULT_FCTYPE = FillingCurve2DType.Z_ORDER_LUPT;
    private static final HealpixNested[] HEALPIX_NESTED = new HealpixNested[30];
    private static final HealpixNestedFast[] HEALPIX_NESTED_FAST = new HealpixNestedFast[30];
    private static final EnumMap<FillingCurve2DType, HealpixNested[]> FCTYPE_HEALPIX_NESTED = new EnumMap(FillingCurve2DType.class);
    private static final EnumMap<FillingCurve2DType, HealpixNestedFast[]> FCTYPE_HEALPIX_NESTED_FAST = new EnumMap(FillingCurve2DType.class);
    public static final Healpix UI;

    public static double getLargestCenterToCellVertexDistance(double lonRad, double latRad, int depth) {
        latRad = java.lang.Math.abs(latRad);
        if (depth == 0) {
            return latRad < 0.39934019947897775 ? 0.7853981633974483 : 1.5707963267948966 - TRANSITION_LATITUDE;
        }
        if (latRad < 0.39934019947897775) {
            return DIST_CW_EQUATOR[depth] * (1.0 - 0.4933905296766163 * (latRad * latRad));
        }
        if (latRad < TRANSITION_LATITUDE) {
            return DIST_CW_EQUATOR[depth] * 0.9213177319235613 + (latRad - 0.39934019947897775) * EQUAT_LINEAR_COEFF[depth];
        }
        double lonMod = java.lang.Math.abs(0.7853981633974483 - lonRad % 1.5707963267948966);
        return POLAR_LINEAR_COEFF[depth] * lonMod + DIST_TRANSIT_LAT_TO_PREV_RING[depth];
    }

    private Healpix() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HealpixNested getNested(int depth) {
        HealpixNested instance = HEALPIX_NESTED[depth];
        if (instance != null) return instance;
        HealpixNested[] healpixNestedArray = HEALPIX_NESTED;
        synchronized (HEALPIX_NESTED) {
            instance = HEALPIX_NESTED[depth];
            if (instance != null) return instance;
            Healpix.HEALPIX_NESTED[depth] = instance = new HealpixNested(depth, DEFAULT_FCTYPE);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HealpixNested getNested(int depth, FillingCurve2DType fillingCurveType) {
        HealpixNested[] hn = FCTYPE_HEALPIX_NESTED.get((Object)fillingCurveType);
        HealpixNested instance = hn[depth];
        if (instance != null) return instance;
        HealpixNested[] healpixNestedArray = HEALPIX_NESTED;
        synchronized (HEALPIX_NESTED) {
            instance = hn[depth];
            if (instance != null) return instance;
            hn[depth] = instance = new HealpixNested(depth, fillingCurveType);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HealpixNestedFast getNestedFast(int depth) {
        HealpixNestedFast instance = HEALPIX_NESTED_FAST[depth];
        if (instance != null) return instance;
        HealpixNestedFast[] healpixNestedFastArray = HEALPIX_NESTED_FAST;
        synchronized (HEALPIX_NESTED_FAST) {
            instance = HEALPIX_NESTED_FAST[depth];
            if (instance != null) return instance;
            Healpix.HEALPIX_NESTED_FAST[depth] = instance = new HealpixNestedFast(depth, DEFAULT_FCTYPE);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HealpixNestedFast getNestedFast(int depth, FillingCurve2DType fillingCurveType) {
        HealpixNestedFast[] hn = FCTYPE_HEALPIX_NESTED_FAST.get((Object)fillingCurveType);
        HealpixNestedFast instance = hn[depth];
        if (instance != null) return instance;
        HealpixNestedFast[] healpixNestedFastArray = HEALPIX_NESTED_FAST;
        synchronized (HEALPIX_NESTED_FAST) {
            instance = hn[depth];
            if (instance != null) return instance;
            hn[depth] = instance = new HealpixNestedFast(depth, DEFAULT_FCTYPE);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return instance;
        }
    }

    public static int nside(int depth) {
        Healpix.checkDepth(depth);
        return 1 << depth;
    }

    static long halfNside4IEEEdouble(int depth) {
        return depth == 0 ? -4503599627370496L : (long)depth - 1L << 52;
    }

    static long nside4IEEEdouble(int depth) {
        return depth << 52;
    }

    static void checkDepth(int depth) {
        if (depth < 0 || depth > 29) {
            throw new IllegalArgumentException("Expected depth in [0, 29]. Actual: " + depth);
        }
    }

    public static void checkLatitude(double latRad) {
        if (latRad < -1.5707963267948966 || 1.5707963267948966 < latRad) {
            throw new IllegalArgumentException("Wrong latitude. Expected: in [-pi/2, pi/2]. Actual: " + latRad);
        }
    }

    public static int depth(int nside) {
        if (!HackersDelight.isPowOf2Fast(nside) || nside < 1 || nside > NSIDE_MAX) {
            throw new IllegalArgumentException("Nside must be a power of 2 in [1-2^29]");
        }
        return Integer.numberOfTrailingZeros(nside);
    }

    static long nsideSquare(int depth) {
        Healpix.checkDepth(depth);
        return 1L << (depth << 1);
    }

    public static long nHash(int depth) {
        Healpix.checkDepth(depth);
        return 12L << (depth << 1);
    }

    public static int nIsolatitudeRings(int depth) {
        Healpix.checkDepth(depth);
        assert (4 << depth == 4 * Healpix.nside(depth));
        return (4 << depth) - 1;
    }

    public static boolean isLatInNorthPolarCap(double latRad) {
        return latRad > TRANSITION_LATITUDE;
    }

    public static boolean isLatInSouthPolarCap(double latRad) {
        return latRad < -TRANSITION_LATITUDE;
    }

    static boolean isInEquatorialRegion(double absLatRad) {
        return absLatRad <= TRANSITION_LATITUDE;
    }

    public static int getBestStartingDepth(double distMaxInRad) {
        if (distMaxInRad != distMaxInRad || distMaxInRad > SMALLER_EDGE2OPEDGE_DIST[0]) {
            return -1;
        }
        if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[29]) {
            return 29;
        }
        if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[15]) {
            if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[22]) {
                if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[25]) {
                    if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[27]) {
                        if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[28]) {
                            return 28;
                        }
                        return 27;
                    }
                    if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[26]) {
                        return 26;
                    }
                    return 25;
                }
                if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[24]) {
                    return 24;
                }
                if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[23]) {
                    return 23;
                }
                return 22;
            }
            if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[18]) {
                if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[20]) {
                    if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[21]) {
                        return 21;
                    }
                    return 20;
                }
                if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[19]) {
                    return 19;
                }
                return 18;
            }
            if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[17]) {
                return 17;
            }
            if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[16]) {
                return 16;
            }
            return 15;
        }
        if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[7]) {
            if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[11]) {
                if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[13]) {
                    if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[14]) {
                        return 14;
                    }
                    return 13;
                }
                if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[12]) {
                    return 12;
                }
                return 11;
            }
            if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[9]) {
                if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[10]) {
                    return 10;
                }
                return 9;
            }
            if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[8]) {
                return 8;
            }
            return 7;
        }
        if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[3]) {
            if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[5]) {
                if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[6]) {
                    return 6;
                }
                return 5;
            }
            if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[4]) {
                return 4;
            }
            return 3;
        }
        if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[2]) {
            return 2;
        }
        if (distMaxInRad < SMALLER_EDGE2OPEDGE_DIST[1]) {
            return 1;
        }
        return 0;
    }

    static double sqrtOfThreeTimeOneMinusSinOf(double a) {
        assert (0.0 <= a && a <= 1.5707963267948966);
        return Math.SQRT6 * FastMath.cosQ(0.5 * a + 0.7853981633974483);
    }

    @Override
    public double[] project(double lonRad, double latRad) {
        double[] res = new double[2];
        this.project(lonRad, latRad, res);
        return res;
    }

    @Override
    public void project(double lonRad, double latRad, double[] resultXY) {
        double y;
        Healpix.checkLatitude(latRad);
        long signLon = HackersDelight.toBits(lonRad);
        double absLon = HackersDelight.fromBits(signLon & Long.MAX_VALUE);
        signLon &= Long.MIN_VALUE;
        long signLat = HackersDelight.toBits(latRad);
        double absLat = HackersDelight.fromBits(signLat & Long.MAX_VALUE);
        signLat &= Long.MIN_VALUE;
        double x = 1.2732395447351628 * absLon;
        int xOffset = (int)x | 1;
        x -= (double)xOffset;
        xOffset &= 7;
        if (Healpix.isInEquatorialRegion(absLat)) {
            y = FastMath.sinQ(absLat, 0.0);
            y *= 1.5;
        } else {
            y = Healpix.sqrtOfThreeTimeOneMinusSinOf(absLat);
            x *= y;
            y = 2.0 - y;
        }
        xOffset -= (xOffset & 4) << 1;
        x += (double)xOffset;
        x = HackersDelight.fromBits(signLon | HackersDelight.toBits(x));
        y = HackersDelight.fromBits(signLat | HackersDelight.toBits(y));
        resultXY[0] = x * 0.7853981633974483;
        resultXY[1] = y * 0.7853981633974483;
    }

    @Override
    public double[] unproject(double x, double y) {
        double[] res = new double[2];
        this.unproject(x, y, res);
        return res;
    }

    @Override
    public void unproject(double x, double y, double[] resultLonLat) {
        double lat;
        Healpix.checkProjectionBounds(x, y);
        long signX = HackersDelight.toBits(x);
        double absX = HackersDelight.fromBits(signX & Long.MAX_VALUE) * 1.2732395447351628;
        signX &= Long.MIN_VALUE;
        long signY = HackersDelight.toBits(y);
        double absY = HackersDelight.fromBits(signY & Long.MAX_VALUE) * 1.2732395447351628;
        signY &= Long.MIN_VALUE;
        int xOffset = (int)absX | 1;
        double lon = absX - (double)xOffset;
        if (Healpix.isInPlaneEquatorialRegion(absY)) {
            lat = Math.asin(absY * 0.6666666666666666);
        } else {
            lat = 2.0 - absY;
            if (Healpix.isNotNearFromPole(lat)) {
                lon /= lat;
                lon = this.dealWithNumericalApproxInEdge(lon);
            }
            lat *= 0.408248290463863;
            lat = 2.0 * FastMath.acos(lat) - 1.5707963267948966;
        }
        lon += (double)xOffset;
        lon = HackersDelight.fromBits(signX | HackersDelight.toBits(lon));
        lon += (double)(signX >>> 60);
        lat = HackersDelight.fromBits(signY | HackersDelight.toBits(lat));
        resultLonLat[0] = lon *= 0.7853981633974483;
        resultLonLat[1] = lat;
    }

    private static void checkProjectionBounds(double x, double y) {
        if (x < -java.lang.Math.PI || x > java.lang.Math.PI) {
            throw new IllegalArgumentException("x value \"" + x + "\" must be in [-pi, pi]");
        }
        if (y < -1.5707963267948966 || y > 1.5707963267948966) {
            throw new IllegalArgumentException("y value \"" + x + "\" must be in [-pi / 2, pi / 2]");
        }
    }

    private static boolean isInPlaneEquatorialRegion(double absY) {
        return absY <= 1.0;
    }

    private static boolean isNotNearFromPole(double sqrtOfThreeTimeOneMinusSinOf) {
        return sqrtOfThreeTimeOneMinusSinOf > 1.0E-13;
    }

    private double dealWithNumericalApproxInEdge(double lon) {
        return lon > 1.0 ? 1.0 : (lon < -1.0 ? -1.0 : lon);
    }

    public static long uniq(int depth, long hash) {
        return 16L << (depth << 1) | hash;
    }

    public static int uniq2depth(long uniqedHash) {
        return 60 - Long.numberOfLeadingZeros(uniqedHash) >>> 1;
    }

    public static long uniq2hash(long uniqedHash) {
        return uniqedHash & (Long.highestOneBit(uniqedHash) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long uniq2hash(long uniqdHash, int depth) {
        return uniqdHash & (16L << (depth << 1) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static void main(String[] args) {
        System.out.println(POLAR_LINEAR_COEFF[8] + " " + DIST_TRANSIT_LAT_TO_PREV_RING[8]);
        System.out.println(DIST_CW_EQUATOR[8] + " " + DIST_CW_EQUATOR[8] * 0.4933905296766163 + " " + DIST_CW_EQUATOR[8] * 0.5066094703233837);
        System.out.println("0.9213177319235613 " + EQUAT_LINEAR_COEFF[8]);
    }

    static {
        for (FillingCurve2DType fct : FillingCurve2DType.values()) {
            if (fct == DEFAULT_FCTYPE) {
                FCTYPE_HEALPIX_NESTED.put(fct, HEALPIX_NESTED);
                FCTYPE_HEALPIX_NESTED_FAST.put(fct, HEALPIX_NESTED_FAST);
                continue;
            }
            FCTYPE_HEALPIX_NESTED.put(fct, new HealpixNested[30]);
            FCTYPE_HEALPIX_NESTED_FAST.put(fct, new HealpixNestedFast[30]);
        }
        UI = new Healpix();
    }
}

