--  
--  $Id$
--  
--  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)
--  project.
--  
--  Copyright (C) 1998-2018 OpenLink Software
--  
--  This project is free software; you can redistribute it and/or modify it
--  under the terms of the GNU General Public License as published by the
--  Free Software Foundation; only version 2 of the License, dated June 1991.
--  
--  This program is distributed in the hope that it will be useful, but
--  WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
--  General Public License for more details.
--  
--  You should have received a copy of the GNU General Public License along
--  with this program; if not, write to the Free Software Foundation, Inc.,
--  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
--  
--  
DROP TABLE MS_OUT_Q1;

CREATE TABLE MS_OUT_Q1(
	L_RETURNFLAG	VARCHAR(1),
	L_LINESTATUS	VARCHAR(1),
	SUM_QTY		NUMERIC,
	SUM_BASE_PRICE	NUMERIC,
	SUM_DISC_PRICE	NUMERIC,
	SUM_CHARGE	NUMERIC,
	AVG_QTY		NUMERIC,
	AVG_PRICE	NUMERIC,
	AVG_DISC	NUMERIC,
	COUNT_ORDER 	INTEGER
)
;

INSERT INTO MS_OUT_Q1(L_RETURNFLAG,L_LINESTATUS,SUM_QTY,SUM_BASE_PRICE,SUM_DISC_PRICE,SUM_CHARGE,AVG_QTY,AVG_PRICE,AVG_DISC,COUNT_ORDER) VALUES('A','F',371985,521476722,495330564,515060018,25.483661,35725,0.05013,14597);
INSERT INTO MS_OUT_Q1(L_RETURNFLAG,L_LINESTATUS,SUM_QTY,SUM_BASE_PRICE,SUM_DISC_PRICE,SUM_CHARGE,AVG_QTY,AVG_PRICE,AVG_DISC,COUNT_ORDER) VALUES('N','F',9856,13780548,13029457,13561502,26.352941,36846,0.05465,374);
INSERT INTO MS_OUT_Q1(L_RETURNFLAG,L_LINESTATUS,SUM_QTY,SUM_BASE_PRICE,SUM_DISC_PRICE,SUM_CHARGE,AVG_QTY,AVG_PRICE,AVG_DISC,COUNT_ORDER) VALUES('N','O',757157,1057997053,1004945128,1044784097,25.542522,35691,0.05014,29643);
INSERT INTO MS_OUT_Q1(L_RETURNFLAG,L_LINESTATUS,SUM_QTY,SUM_BASE_PRICE,SUM_DISC_PRICE,SUM_CHARGE,AVG_QTY,AVG_PRICE,AVG_DISC,COUNT_ORDER) VALUES('R','F',371385,519739712,493682615,513510101,25.288369,35390,0.05034,14686);

DROP TABLE MS_OUT_Q2;

CREATE TABLE MS_OUT_Q2(
	S_ACCTBAL	NUMERIC,
	S_NAME		VARCHAR(25),
	N_NAME		VARCHAR(25),
	P_PARTKEY	INTEGER,
	P_MFGR		VARCHAR(25),
	S_ADDRESS	VARCHAR(40),
	S_PHONE		VARCHAR(15),
	S_COMMENT	VARCHAR(101)
)
;

INSERT INTO MS_OUT_Q2(S_ACCTBAL,S_NAME,N_NAME,P_PARTKEY,P_MFGR,S_ADDRESS,S_PHONE,S_COMMENT) VALUES(6907,'Supplier#2               ','FRANCE                   ',1878,'Manufacturer#5           ','I4sC8pD5tI','16-935-413-6865','dogged somas must kindle quietly besides the tithes --final depths should maintain quiet');
INSERT INTO MS_OUT_Q2(S_ACCTBAL,S_NAME,N_NAME,P_PARTKEY,P_MFGR,S_ADDRESS,S_PHONE,S_COMMENT) VALUES(6379,'Supplier#92              ','FRANCE                   ',67,'Manufacturer#1           ','B9jQ4wM7iP8jG3fR5cR8gX8kX7gH6nF4c','16-962-519-3808','quiet frets to poach fluffily between the wa');
INSERT INTO MS_OUT_Q2(S_ACCTBAL,S_NAME,N_NAME,P_PARTKEY,P_MFGR,S_ADDRESS,S_PHONE,S_COMMENT) VALUES(1710,'Supplier#100             ','UNITED KINGDOM           ',1103,'Manufacturer#4           ','B1rP7nS9yH6eO5uF7hU','33-199-316-3605','thin ideas shall print fluffily by the tit');

DROP TABLE MS_OUT_Q3;

CREATE TABLE MS_OUT_Q3(
	L_ORDERKEY	INTEGER,
	REVENUE		NUMERIC,
	O_ORDERDATE	DATE,
	O_SHIPPRIORITY	INTEGER
)
;

INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(58915,327519.81,stringdate('1995.03.06 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(45858,258291.11,stringdate('1995.02.04 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(28899,239034.23,stringdate('1995.01.24 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(59751,218970.16,stringdate('1995.02.22 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(18503,212433.44,stringdate('1995.02.04 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(38755,209388.87,stringdate('1995.01.15 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(16551,204557.65,stringdate('1995.02.14 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(18852,197370.61,stringdate('1995.02.18 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(49828,195840.55,stringdate('1995.03.09 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(48326,192353.76,stringdate('1995.02.16 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(46855,189892.44,stringdate('1995.02.21 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(49665,188506.03,stringdate('1995.03.04 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(38120,187094.37,stringdate('1995.02.15 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(53992,184473.38,stringdate('1995.02.02 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(59076,180094.3,stringdate('1995.02.04 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(37538,177943.92,stringdate('1995.01.14 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(46056,174858.9,stringdate('1995.02.26 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(50056,166444.02,stringdate('1995.02.03 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(18472,162955.68,stringdate('1995.02.03 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(12262,161672.76,stringdate('1994.12.30 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(20898,158668.12,stringdate('1995.01.10 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(37729,152786.5,stringdate('1995.01.29 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(41128,148844.77,stringdate('1995.02.12 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(24616,146598.4,stringdate('1995.02.15 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(8648,141700.28,stringdate('1995.03.03 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(3208,139176.98,stringdate('1994.12.31 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(35718,136974.47,stringdate('1995.01.04 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(5990,136932.09,stringdate('1995.01.30 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(50984,136004.76,stringdate('1995.02.15 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(5992,135595.55,stringdate('1995.03.13 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(8168,129807,stringdate('1995.02.17 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(6920,121743.42,stringdate('1995.02.15 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(59809,118467.6,stringdate('1995.01.23 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(25384,115750.37,stringdate('1995.02.17 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(51714,106171.02,stringdate('1995.02.07 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(36482,102174.3,stringdate('1994.12.07 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(4897,102071,stringdate('1995.02.18 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(18695,94690.74,stringdate('1995.02.08 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(34152,93503.04,stringdate('1995.02.05 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(48038,91830.1,stringdate('1995.03.01 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(6565,89808,stringdate('1995.03.04 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(1416,86929.77,stringdate('1995.02.03 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(19683,84645.04,stringdate('1995.02.12 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(8931,84616.3,stringdate('1995.02.07 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(43714,82769.82,stringdate('1994.12.27 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(23400,82262.3,stringdate('1994.12.09 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(41796,76962.62,stringdate('1995.01.02 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(55175,72690.2,stringdate('1994.12.20 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(29635,72021.18,stringdate('1995.02.28 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(53827,71328.27,stringdate('1995.02.10 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(20932,70877.22,stringdate('1995.01.06 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(41123,68576.92,stringdate('1995.02.20 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(29059,67622.21,stringdate('1994.12.30 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(55778,67597.44,stringdate('1995.02.07 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(33442,66158.8,stringdate('1995.01.07 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(7816,65219.2,stringdate('1995.02.10 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(30054,65136,stringdate('1995.01.12 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(22630,64565.76,stringdate('1995.01.26 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(28007,62542.83,stringdate('1995.02.27 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(3875,58338.33,stringdate('1994.12.25 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(15366,58337.28,stringdate('1995.01.31 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(12676,57706.66,stringdate('1995.01.11 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(28289,56208.53,stringdate('1995.01.05 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(31329,53816,stringdate('1995.01.26 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(50337,50285.62,stringdate('1994.12.19 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(34181,49003.92,stringdate('1995.01.21 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(388,48042.72,stringdate('1995.02.13 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(8291,47527.2,stringdate('1995.02.02 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(37830,47009.92,stringdate('1995.01.27 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(48931,46075.05,stringdate('1995.02.03 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(1793,46004.84,stringdate('1995.01.02 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(43652,43583.8,stringdate('1995.02.15 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(25476,41154.75,stringdate('1995.01.10 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(20421,40887.56,stringdate('1994.12.10 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(34340,40373.76,stringdate('1995.01.02 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(49000,38908.8,stringdate('1995.01.02 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(52293,38675.85,stringdate('1995.02.10 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(21889,37681,stringdate('1995.01.24 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(25608,35621.04,stringdate('1995.02.19 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(24388,35022.72,stringdate('1995.03.07 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(11079,34864.77,stringdate('1995.01.25 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(30947,32707.8,stringdate('1994.12.25 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(50755,31181.76,stringdate('1995.01.01 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(26824,29577.24,stringdate('1994.12.28 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(39301,29513.22,stringdate('1995.02.05 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(54052,26376.4,stringdate('1995.01.14 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(6213,25958.03,stringdate('1994.12.26 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(9222,25658.36,stringdate('1995.02.06 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(41667,25054.92,stringdate('1995.01.22 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(12422,24620.48,stringdate('1995.03.04 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(10022,23083.2,stringdate('1995.01.31 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(32102,22883.85,stringdate('1994.12.10 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(52385,20403.6,stringdate('1995.02.01 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(5346,17540,stringdate('1994.12.29 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(15367,13374,stringdate('1995.02.01 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(36324,11132.1,stringdate('1994.12.09 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(45288,4287.92,stringdate('1994.12.02 00:00.00 000000'),0);
INSERT INTO MS_OUT_Q3(L_ORDERKEY,REVENUE,O_ORDERDATE,O_SHIPPRIORITY) VALUES(25541,3704.4,stringdate('1994.12.28 00:00.00 000000'),0);

DROP TABLE MS_OUT_Q4;

CREATE TABLE MS_OUT_Q4(
	O_ORDERPRIORITY	VARCHAR(15),
	ORDER_COUNT 	INTEGER
)
;

INSERT INTO MS_OUT_Q4(O_ORDERPRIORITY,ORDER_COUNT) VALUES('1-URGENT       ',112);
INSERT INTO MS_OUT_Q4(O_ORDERPRIORITY,ORDER_COUNT) VALUES('2-HIGH         ',120);
INSERT INTO MS_OUT_Q4(O_ORDERPRIORITY,ORDER_COUNT) VALUES('3-MEDIUM       ',101);
INSERT INTO MS_OUT_Q4(O_ORDERPRIORITY,ORDER_COUNT) VALUES('4-NOT SPECIFIED',117);
INSERT INTO MS_OUT_Q4(O_ORDERPRIORITY,ORDER_COUNT) VALUES('5-LOW          ',105);

DROP TABLE MS_OUT_Q5;

CREATE TABLE MS_OUT_Q5(
	N_NAME		VARCHAR(25),
	REVENUE		NUMERIC
)
;

INSERT INTO MS_OUT_Q5(N_NAME,REVENUE) VALUES('JAPAN                    ',761816.93);
INSERT INTO MS_OUT_Q5(N_NAME,REVENUE) VALUES('CHINA                    ',432813.86);
INSERT INTO MS_OUT_Q5(N_NAME,REVENUE) VALUES('INDIA                    ',397408.01);
INSERT INTO MS_OUT_Q5(N_NAME,REVENUE) VALUES('INDONESIA                ',206138.68);
INSERT INTO MS_OUT_Q5(N_NAME,REVENUE) VALUES('VIETNAM                  ',200968.84);

DROP TABLE MS_OUT_Q6;

CREATE TABLE MS_OUT_Q6(
	REVENUE		NUMERIC
)
;

INSERT INTO MS_OUT_Q6(REVENUE) VALUES(1192025.3);

DROP TABLE MS_OUT_Q7;

CREATE TABLE MS_OUT_Q7(
	SUPP_NATION	VARCHAR(25),
	CUST_NATION	VARCHAR(25),
	L_YEAR		INTEGER,
	REVENUE		NUMERIC
)
;

INSERT INTO MS_OUT_Q7(SUPP_NATION,CUST_NATION,L_YEAR,REVENUE) VALUES('FRANCE                   ','GERMANY                  ',1995,490085.44);
INSERT INTO MS_OUT_Q7(SUPP_NATION,CUST_NATION,L_YEAR,REVENUE) VALUES('FRANCE                   ','GERMANY                  ',1996,353634.26);
INSERT INTO MS_OUT_Q7(SUPP_NATION,CUST_NATION,L_YEAR,REVENUE) VALUES('GERMANY                  ','FRANCE                   ',1995,682551);
INSERT INTO MS_OUT_Q7(SUPP_NATION,CUST_NATION,L_YEAR,REVENUE) VALUES('GERMANY                  ','FRANCE                   ',1996,948175.38);

DROP TABLE MS_OUT_Q8;

CREATE TABLE MS_OUT_Q8(
	O_YEAR		INTEGER,
	MKT_SHARE	NUMERIC
)
;

INSERT INTO MS_OUT_Q8(O_YEAR,MKT_SHARE) VALUES(1995,0);
INSERT INTO MS_OUT_Q8(O_YEAR,MKT_SHARE) VALUES(1996,0.0889);

DROP TABLE MS_OUT_Q9;

CREATE TABLE MS_OUT_Q9(
	NATION		VARCHAR(25),
	O_YEAR		INTEGER,
	SUM_PROFIT	NUMERIC
)
;

INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ALGERIA                  ',1998,158858.22);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ALGERIA                  ',1997,210220.86);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ALGERIA                  ',1996,419497.87);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ALGERIA                  ',1995,280660.27);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ALGERIA                  ',1994,396052.11);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ALGERIA                  ',1993,278110.35);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ALGERIA                  ',1992,221468.17);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ARGENTINA                ',1998,621243.73);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ARGENTINA                ',1997,1148263.88);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ARGENTINA                ',1996,997969.17);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ARGENTINA                ',1995,837414.42);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ARGENTINA                ',1994,844374.42);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ARGENTINA                ',1993,787047.69);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ARGENTINA                ',1992,1404936.03);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('BRAZIL                   ',1998,208409.26);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('BRAZIL                   ',1997,244729.64);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('BRAZIL                   ',1996,245802.63);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('BRAZIL                   ',1995,184345.37);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('BRAZIL                   ',1994,254400.04);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('BRAZIL                   ',1993,46425.06);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('BRAZIL                   ',1992,162364.73);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('CANADA                   ',1998,194476.18);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('CANADA                   ',1997,257961.66);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('CANADA                   ',1996,582417.4);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('CANADA                   ',1995,369958.62);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('CANADA                   ',1994,567289.04);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('CANADA                   ',1993,621267.47);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('CANADA                   ',1992,316287.8);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('CHINA                    ',1998,350639.48);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('CHINA                    ',1997,387052.1);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('CHINA                    ',1996,349164.56);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('CHINA                    ',1995,288469.01);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('CHINA                    ',1994,369445.75);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('CHINA                    ',1993,251323.35);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('CHINA                    ',1992,289137.76);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('EGYPT                    ',1998,157697.24);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('EGYPT                    ',1997,505006.07);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('EGYPT                    ',1996,546542.24);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('EGYPT                    ',1995,610863.87);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('EGYPT                    ',1994,656382.54);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('EGYPT                    ',1993,545062.87);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('EGYPT                    ',1992,467503);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ETHIOPIA                 ',1998,11441.28);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ETHIOPIA                 ',1997,97033.29);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ETHIOPIA                 ',1996,10781.6);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ETHIOPIA                 ',1995,83568.72);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ETHIOPIA                 ',1994,57026.55);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ETHIOPIA                 ',1993,66141.08);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ETHIOPIA                 ',1992,46439.6);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('FRANCE                   ',1998,134008.04);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('FRANCE                   ',1997,401298.13);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('FRANCE                   ',1996,121599.74);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('FRANCE                   ',1995,308496.53);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('FRANCE                   ',1994,232422.39);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('FRANCE                   ',1993,307346.66);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('FRANCE                   ',1992,394491.46);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('GERMANY                  ',1998,403506.68);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('GERMANY                  ',1997,525098.46);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('GERMANY                  ',1996,730751.24);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('GERMANY                  ',1995,604294.05);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('GERMANY                  ',1994,551782.12);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('GERMANY                  ',1993,697452.95);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('GERMANY                  ',1992,499829.31);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('INDIA                    ',1998,344988.71);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('INDIA                    ',1997,567821.47);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('INDIA                    ',1996,301687.91);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('INDIA                    ',1995,475424.02);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('INDIA                    ',1994,634591.39);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('INDIA                    ',1993,471092.93);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('INDIA                    ',1992,576418.26);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('INDONESIA                ',1998,183722.75);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('INDONESIA                ',1997,268713.82);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('INDONESIA                ',1996,296126.38);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('INDONESIA                ',1995,260019.1);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('INDONESIA                ',1994,242432.77);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('INDONESIA                ',1993,425102.11);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('INDONESIA                ',1992,701132.85);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('IRAN                     ',1998,41907.56);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('IRAN                     ',1997,71657.82);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('IRAN                     ',1996,169645.78);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('IRAN                     ',1995,79515.33);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('IRAN                     ',1994,29454.72);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('IRAN                     ',1993,67875.71);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('IRAN                     ',1992,185625.54);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('IRAQ                     ',1998,518783.37);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('IRAQ                     ',1997,544963.21);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('IRAQ                     ',1996,649990.86);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('IRAQ                     ',1995,569543.05);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('IRAQ                     ',1994,501030.62);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('IRAQ                     ',1993,552253.43);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('IRAQ                     ',1992,687567.15);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('JAPAN                    ',1998,331777.86);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('JAPAN                    ',1997,496572.45);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('JAPAN                    ',1996,1141447.45);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('JAPAN                    ',1995,829367.69);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('JAPAN                    ',1994,902479.89);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('JAPAN                    ',1993,694148.14);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('JAPAN                    ',1992,973243.41);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('JORDAN                   ',1998,328209.67);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('JORDAN                   ',1997,599910.79);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('JORDAN                   ',1996,210999.73);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('JORDAN                   ',1995,418953.83);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('JORDAN                   ',1994,486859.33);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('JORDAN                   ',1993,289230.62);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('JORDAN                   ',1992,685473.79);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('KENYA                    ',1998,49675.73);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('KENYA                    ',1997,380028.95);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('KENYA                    ',1996,127069.23);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('KENYA                    ',1995,197571.08);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('KENYA                    ',1994,225583.94);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('KENYA                    ',1993,255683.5);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('KENYA                    ',1992,137001.87);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('MOROCCO                  ',1998,61971.58);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('MOROCCO                  ',1997,152169.46);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('MOROCCO                  ',1996,164263.08);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('MOROCCO                  ',1995,78321.08);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('MOROCCO                  ',1994,96208.78);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('MOROCCO                  ',1993,168283.98);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('MOROCCO                  ',1992,112532.39);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('MOZAMBIQUE               ',1998,231622.28);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('MOZAMBIQUE               ',1997,373456.71);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('MOZAMBIQUE               ',1996,557956.06);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('MOZAMBIQUE               ',1995,303417.35);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('MOZAMBIQUE               ',1994,423416.03);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('MOZAMBIQUE               ',1993,600331.9);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('MOZAMBIQUE               ',1992,641688.77);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('PERU                     ',1998,335444.27);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('PERU                     ',1997,550257.54);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('PERU                     ',1996,883666.65);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('PERU                     ',1995,963759.56);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('PERU                     ',1994,1018428.69);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('PERU                     ',1993,745469.64);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('PERU                     ',1992,530096.8);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ROMANIA                  ',1998,218642.79);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ROMANIA                  ',1997,363507.5);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ROMANIA                  ',1996,348192.07);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ROMANIA                  ',1995,373620.12);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ROMANIA                  ',1994,322049.25);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ROMANIA                  ',1993,279760.55);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('ROMANIA                  ',1992,366931.78);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('RUSSIA                   ',1997,81037.06);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('RUSSIA                   ',1996,36595.68);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('RUSSIA                   ',1995,87774.33);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('RUSSIA                   ',1994,8488.48);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('RUSSIA                   ',1993,26513.2);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('RUSSIA                   ',1992,68397.7);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('SAUDI ARABIA             ',1998,323313.83);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('SAUDI ARABIA             ',1997,524515.31);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('SAUDI ARABIA             ',1996,789342.87);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('SAUDI ARABIA             ',1995,653463.34);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('SAUDI ARABIA             ',1994,579008.18);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('SAUDI ARABIA             ',1993,450304.1);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('SAUDI ARABIA             ',1992,488011.71);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('UNITED KINGDOM           ',1998,794279.58);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('UNITED KINGDOM           ',1997,925192.31);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('UNITED KINGDOM           ',1996,686119.12);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('UNITED KINGDOM           ',1995,992559.68);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('UNITED KINGDOM           ',1994,891569.42);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('UNITED KINGDOM           ',1993,1084245.27);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('UNITED KINGDOM           ',1992,958768.22);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('UNITED STATES            ',1998,126729.91);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('UNITED STATES            ',1997,214230.83);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('UNITED STATES            ',1996,259239.64);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('UNITED STATES            ',1995,121722.18);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('UNITED STATES            ',1994,233109.86);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('UNITED STATES            ',1993,451590.15);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('UNITED STATES            ',1992,495392.89);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('VIETNAM                  ',1998,106062.46);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('VIETNAM                  ',1997,140885.98);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('VIETNAM                  ',1996,284278.99);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('VIETNAM                  ',1995,183222.57);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('VIETNAM                  ',1994,291524.27);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('VIETNAM                  ',1993,219323.56);
INSERT INTO MS_OUT_Q9(NATION,O_YEAR,SUM_PROFIT) VALUES('VIETNAM                  ',1992,206588.57);

DROP TABLE MS_OUT_Q10;

CREATE TABLE MS_OUT_Q10(
	C_CUSTKEY	INTEGER,
	C_NAME		VARCHAR(25),
	REVENUE		NUMERIC,
	C_ACCTBAL	NUMERIC,
	N_NAME		VARCHAR(25),
	C_ADDRESS	VARCHAR(40),
	C_PHONE		VARCHAR(15),
	C_COMMENT	VARCHAR(117)
)
;

INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(13,'Customer#13              ',491211.51,-57.49,'JAPAN                    ','F2bX8sL3sU2tB7iF8pP3aI2                 ','22-698-962-1230','furious decoys can are sometimes in the theodolites !blithe foxes wil                                                ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(758,'Customer#758             ',357702.36,5305.21,'UNITED STATES            ','U5fZ9oN7kX:yN3aW6wB7xE1wE4uK4hY8tS      ','34-992-853-7150','silent Tiresias have breach regularly at the hockey .idle warthogs sho                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(100,'Customer#100             ',352835.37,8975.77,'CANADA                   ','R9fR1gV1eR7dH2jQ:cQ                     ','13-942-431-4534','ironic notornis shall promise sometimes behind the ideas .busy pinto could                                           ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1495,'Customer#1495            ',315704.95,1894.67,'ROMANIA                  ','I:tF3lJ9oR6nK7uM9lS2bL3zO2lQ9pP         ','29-770-272-8847','close courts to detect sometimes on the tithes :idle dependencies shall print doggedly instead the orbits --daring d ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(910,'Customer#910             ',314882.99,-86.69,'ROMANIA                  ','G4zQ5bD5tZ3kJ7uM5jS7lQ9vO7jH4kZ5        ','29-147-372-8129','idle attainments to solve bravely into the ideas !fluffy forges have breach th                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1094,'Customer#1094            ',307691.43,8079.41,'JAPAN                    ','B6kL3uR7nZ                              ','22-871-114-9525','permanent frets may are finally along the hockey :quick braids may play slowly beneath the courts :thin asympt       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(257,'Customer#257             ',303330.18,3698.59,'JORDAN                   ','W6tR3jR9bH:oG1iJ8vJ7dC7kJ:vI5           ','23-588-538-4403','sly multipliers must maintain bravely from the asy                                                                   ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(967,'Customer#967             ',287513.69,-787.62,'CHINA                    ','P3dZ6gP7eO6gP9fP4lS                     ','28-208-346-5554','regular waters do doze daringly until the pinto --idle                                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1151,'Customer#1151            ',273222.76,-689.34,'FRANCE                   ','E2zN:hZ:nG7uC:oJ9iP7rW3lN3iH2o          ','16-792-920-2818','ironic multipliers shall hinder stealthily throughout the dolphins :quiet attainments will                           ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(751,'Customer#751             ',268620.92,8446.8,'ROMANIA                  ','W4pK:hN1yE3kV:cL3hK4                    ','29-961-850-6754','close platelets have wake carefully outsi                                                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(784,'Customer#784             ',267293.16,1963.2,'INDONESIA                ','W6zF4lX2lJ5wB6mJ8o                      ','19-239-185-5467','stealthy waters shall mold furiously place the beans !bold dolphins may believe carefully unde                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(298,'Customer#298             ',263743.64,6155.04,'MOZAMBIQUE               ','D6qQ9bO8xH:aR9jQ5t                      ','26-285-107-9837','close decoys to detect thinly place the attainments ?close sheaves to mold closely in the realms .bl                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(605,'Customer#605             ',263348.42,9602.32,'KENYA                    ','N9nW2iU9hX7zX1iI1eQ8bS7iG3jA3lR         ','24-266-828-9307','regular instructions can was idly beneath the beans ?silent foxes ma                                                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(97,'Customer#97              ',261092.45,1095.09,'RUSSIA                   ','Q:fN2qW1dH1xS3dI8jK5uF1dL8gM3sO9pZ4y    ','32-441-750-9847','slow hockey shall unwind slyly from the excuses :brave pinto will snooze stealthily by the foxes                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(838,'Customer#838             ',257470.04,6529.69,'ARGENTINA                ','N9jU2mV5gU2cF3jS2eJ9vC5uB2oJ3fB1kI5wN6  ','11-976-462-3970','stealthy forges have believe never until the forges --silent somas can nod busily among the platelets ?thin          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(628,'Customer#628             ',256265.84,8290.97,'MOZAMBIQUE               ','N7yG9tS3kL1sQ5tC5c                      ','26-241-564-8399','quiet dugouts do cajole bravely around the gifts ?daring gifts t                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(407,'Customer#407             ',255114.31,5624.01,'JORDAN                   ','N:xP3lL9nN5eD6cZ3yH:oX                  ','23-684-782-5022','quiet pinto could eat stealthily according the hockey ;ruthless dolphins ha                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(460,'Customer#460             ',253863.95,7310.24,'CANADA                   ','D8dX7oM4eE5                             ','13-233-121-5727','busy courts could dazzle daringly toward the attainments ?brave beans to sleep closely besi                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(158,'Customer#158             ',251890.09,3180.13,'CANADA                   ','M6aZ6iX5aD8rA2                          ','13-360-516-2313','dogged depths would nod furiously between the warthogs --bold be                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(827,'Customer#827             ',249577.94,6259.44,'PERU                     ','B7bL6kQ4sI:dK:zL9pY4hN3vG4sS1xK6        ','27-979-920-9445','daring waters do dazzle bravely at the i                                                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(925,'Customer#925             ',246031.43,6445.64,'MOZAMBIQUE               ','Y5hM7kD7eZ5nR4wC:qM9yJ2gP1vG3fG2iO      ','26-103-537-6647','slow waters could kindle ruthlessly around the warthogs ;quiet dolphins w                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(964,'Customer#964             ',241434.8,9268.17,'BRAZIL                   ','B:uE1dH:dW4wH7lL5bW8aW8kE:hZ:nY2        ','12-455-855-7736','fluffy notornis shall engage bravely beyond the asymptotes .dogged platelets could engage blithely through t         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1337,'Customer#1337            ',237119.66,3183.43,'IRAQ                     ','N4nB:dJ:hM3iK2rS2mZ6hO1hE1kH3fT3hH9m    ','21-177-250-9616','blithe attainments to nod qui                                                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(260,'Customer#260             ',235128.41,8795.31,'CANADA                   ','A3bL4bD8nG6yJ5hL8jH8jZ:xI6fP5oC9nM6p    ','13-123-436-4406','busy dolphins should run carefully above the frays ;thin decoys to haggle thinly behind the foxes ;thin forges ha    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(613,'Customer#613             ',226935.55,6715.09,'IRAN                     ','Z9uZ6gM8iH9bY6tQ7dW8                    ','20-201-179-5124','fluffy attainments to wake regularly despite the pearls !regular gifts have wake never by the she                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(182,'Customer#182             ',222624.48,-155.96,'ALGERIA                  ','G1eX3sP2rH7gB5zG2qD3h                   ','10-779-271-3224','blithe attainments must are evenly near the pains .idle waters shall hang quietly until the depth                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(124,'Customer#124             ',221754.79,6726.54,'IRAQ                     ','V5rZ5fL1vJ6dW4iH8fL8uK3nO8bP6k          ','21-680-848-9000','furious Tiresias shall run quic                                                                                      ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(656,'Customer#656             ',220228.09,9552.51,'ALGERIA                  ','K4eH4hS5yF3zX1bU7sP3uE1tB5zF3wT6pG4c    ','10-362-688-7273','slow warthogs must maintain silently throughout the warthog                                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(395,'Customer#395             ',219935.95,6004.93,'INDONESIA                ','Q5wY9yX7eD2oE5kS4                       ','19-515-771-8913','quiet platelets will wake carefully for the sentiments -                                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(880,'Customer#880             ',216420.3,-941.26,'CHINA                    ','J7rZ3vT9qP:cN5                          ','28-971-415-5698','blithe pinto to boost quickly between the asymptotes .                                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(743,'Customer#743             ',215086.64,9027.58,'CHINA                    ','K6iW8sQ2rE1tC:vV8tC3hD5zT5qU8cS8aX4s    ','28-298-833-4379','stealthy attainments have cajole car                                                                                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(818,'Customer#818             ',211939.61,6252.66,'CHINA                    ','M5eU8eV9qJ6eY5nN9jO8yI5fW1iO7lK2        ','28-143-106-2016','stealthy frays must eat slyly into the epitaphs ;bold ideas should eat closely among the pains ;silent dugou         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1022,'Customer#1022            ',208222.98,4323.9,'ARGENTINA                ','J:wH9mO3fM9kG4cO7gT8rY6pI5eI7nL         ','11-530-242-5088','daring forges will sleep permanently of the theodolites ;ru                                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(617,'Customer#617             ',207249.21,4679.92,'UNITED KINGDOM           ','J:sF6zF2nI9vQ5cB3                       ','33-636-766-2871','enticing pains shall grow quickly about the decoys !caref                                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1432,'Customer#1432            ',206483.74,9818.73,'IRAN                     ','A9aT2uV9iT6yJ1qG6sQ8iU3nN8oK9sE5wH5     ','20-776-639-7161','quiet excuses to impress never ato                                                                                   ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(509,'Customer#509             ',203075.35,9207.07,'CANADA                   ','Q9cD4rH3bV7oR5kS3kP6                    ','13-975-266-8959','enticing sentiments to promise bravely                                                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(472,'Customer#472             ',202059.61,3833.98,'SAUDI ARABIA             ','G3pN4rC:yF6tG8xY6yB4oT8sE6oY3aM         ','30-855-543-2625','stealthy orbits could unwind finally since the sentiments :d                                                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(286,'Customer#286             ',200219.94,2225.58,'UNITED STATES            ','O4vB:nY5dK9                             ','34-114-825-2873','careful depths may wake never according the attainments ?brave pearls would cajole sometimes around the war          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1286,'Customer#1286            ',196948.04,4272.4,'BRAZIL                   ','Q9cE2wL1xO1zH:hP1hB6h                   ','12-767-676-4302','quiet theodolites may promise ruthl                                                                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(83,'Customer#83              ',195799.46,7405.62,'KENYA                    ','V9uM3pR6wM4b                            ','24-235-954-4328','permanent orbits must haggle blithely across the excuses --f                                                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(104,'Customer#104             ',194542.76,-457.26,'BRAZIL                   ','T4cE8oY:kL2lZ9lP5hC5wW9gZ:oU9xX3w       ','12-523-636-4158','even depths shall nag fluffil                                                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(517,'Customer#517             ',191051.26,692.95,'SAUDI ARABIA             ','G5pL8wT1gE4uE3vK9lE4gS5kX3vK8nC4tY8k    ','30-922-359-3966','permanent braids to are evenly to the decoys ;daring patterns can impress slyly of the dinos !dogged notornis have e ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1189,'Customer#1189            ',190292.72,9440.76,'SAUDI ARABIA             ','B6dK4hY1aS3nG7hP                        ','30-615-767-1262','busy excuses ought affix carefully besides the multipliers ?enticing foxes ought hang quickly accordi                ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(161,'Customer#161             ',189856.4,1465.83,'KENYA                    ','I5oD3oN7dR2wS:bD8lR7tV8qN2aD1iT:gK      ','24-947-230-6177','final dependencies will unwind carefully ato                                                                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1261,'Customer#1261            ',189431.42,7901.44,'ETHIOPIA                 ','R2pX1iJ5vJ6uZ9bD:yP1tQ8fR3              ','15-379-327-4178','final sauternes to snooze silently under the theodolit                                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1009,'Customer#1009            ',188470.62,958.84,'EGYPT                    ','O9hE3wE1dG:jJ:lF6wF6tA6s                ','14-398-906-3778','idle warthogs must mold never by the sauternes --fluffy attainments ought                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1409,'Customer#1409            ',187975.88,3410.48,'FRANCE                   ','W7wB3rS9lC9vD                           ','16-432-856-2241','idle multipliers ought run finally despite the frays ?brave sentiments must grow b                                   ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(343,'Customer#343             ',187511.42,6293.33,'INDIA                    ','G6nB5yY7cT5uE4iJ8tW3eX9cC:              ','18-813-290-3303','brave waters have nag busily desp                                                                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1105,'Customer#1105            ',187415.93,1924.26,'INDONESIA                ','N3nV2bB:jF7cN4eI3yX2jO3nM2oK8pN8pS9d    ','19-654-376-1327','bold pains to lose never atop the multipliers .dogged frays can snooze carefully beside the depen                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(781,'Customer#781             ',187210.65,6635.11,'IRAQ                     ','Z:jR:gS2lI5zQ3fO                        ','21-337-707-2345','even orbits shall are boldly over the excuses !bold e                                                                ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(481,'Customer#481             ',186187.97,7143.89,'FRANCE                   ','F9vQ2sY4gS4tE5wR5sO6yZ                  ','16-339-455-9554','quiet sheaves must haggle ironically in the frays :quiet excuses must promise b                                      ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1339,'Customer#1339            ',184721.04,288.19,'UNITED KINGDOM           ','I4zQ5xG9yM6rA1lS4mS3jE5oF               ','33-252-761-7107','ruthless frets shall breach slyly before the hockey ;thin notornis have x-ray dogg                                   ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(163,'Customer#163             ',184595.51,951.51,'INDONESIA                ','G3tU3fH5eA5uP8gD9cV5jK5eX               ','19-804-577-9591','sly courts must breach quickl                                                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(188,'Customer#188             ',184047.35,1849.44,'INDIA                    ','C2bT3eV3lU4mY7hH2wC8eA2gN5dM            ','18-722-848-3541','permanent warthogs will breach ironically atop                                                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(544,'Customer#544             ',182539.04,6549.46,'INDIA                    ','V3oP3yH5kP9hK9                          ','18-625-594-8870','thin dependencies shall impress bravely beyond the braids !slow Tiresias                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(553,'Customer#553             ',182321.29,-48.43,'INDONESIA                ','Z5mP9jE6sU3wO:sA:sA9pW                  ','19-998-286-4336','permanent ideas will cajole stealthily outside the forges .quick dolphins shall eat busily toward the foxes .enti    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1424,'Customer#1424            ',181503.76,2261.54,'INDIA                    ','Z:aA1aQ:dI3bD9yU1mF6zI4iW7kD3cK9        ','18-941-127-8640','enticing frets have serve fluffily between the orbits ;idle platelets could impr                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(421,'Customer#421             ',180109.5,-851.15,'PERU                     ','J7oC5eI4iN                              ','27-350-351-7770','quick hockey to was regularly beside the instructions ;final waters might dazzle regularly against the beans         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(671,'Customer#671             ',177712.76,3348.65,'GERMANY                  ','X:wO4hD6sL7q                            ','17-816-653-1716','sly warhorses to snooze blithely of the players !thin orbits can x-ray thinly between th                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(998,'Customer#998             ',174979.63,5948.35,'MOROCCO                  ','W4jW8qT9nV                              ','25-502-295-3310','brave orbits to kindle slyly despite the notornis .silent attainments to maintain always despite the instru          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(373,'Customer#373             ',171925.86,3740.38,'VIETNAM                  ','M6hO4cO6tO2vR2hX8nA5                    ','31-420-518-9763','close epitaphs could run slyly until the players ;quiet instructions shall affix stealthily of                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(556,'Customer#556             ',171546.4,2839.25,'BRAZIL                   ','B2wE7qK6bV1xW3xR7fF:lL2rI2r             ','12-353-741-1147','daring sauternes shall solve daringly over the theodolites --even orbits                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(274,'Customer#274             ',168223.58,7043.3,'INDIA                    ','R2yF2qE:fY4vD4eF1iA                     ','18-401-311-1843','brave sauternes might breach clo                                                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(211,'Customer#211             ',167805.84,2974.25,'CHINA                    ','V2bW1yF5kN7mJ:oO5iU1hG7pR8nS5cU         ','28-888-224-3798','ironic pinto ought doze idly above the depths !idle frets to run doggedly inside the asym                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(853,'Customer#853             ',166752.58,5471.39,'CANADA                   ','C7hT3zT3lI1uL2hH4wK:uL1zF2fS2b          ','13-834-116-9444','ironic realms have print carefully befo                                                                              ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1205,'Customer#1205            ',164337.71,1804.99,'RUSSIA                   ','S:oL:mD5cF9sO3sD4jY:eD2zH9tC:iR2eY6uK1  ','32-438-358-7665','fluffy hockey will impress sometimes nea                                                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1177,'Customer#1177            ',164130.61,8788.49,'GERMANY                  ','P2qQ3iP8hD7rA:gN4cJ9bK                  ','17-850-237-9180','busy warthogs would boost finally place the o                                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1225,'Customer#1225            ',163824.15,9326.53,'CHINA                    ','K8lS4nF1yT5mJ3xP4mB2dZ5uG4cG1uL:pY6oL1e ','28-421-864-5873','silent excuses would cajole slyl                                                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(596,'Customer#596             ',162596.16,8274.38,'CHINA                    ','C4yI2lH6rR4kY9yC2nN2                    ','28-308-585-6877','fluffy frets will integrate f                                                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(247,'Customer#247             ',162249.18,-379.81,'EGYPT                    ','N9lO9dI:pR3oE:xR3kE4yR8tN3cF8xI9hD7oZ2s ','14-929-704-6448','busy sentiments would x-ray silently besides the realms !fluf                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(622,'Customer#622             ',161543.84,715.7,'IRAQ                     ','V6kZ1xC1bH9hZ5eI:nQ1oH8aR6jA2jF5        ','21-114-194-4380','quick platelets shall believe fluffily under the depths --furious gifts shall serve perma                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1157,'Customer#1157            ',160931.77,4795.46,'INDONESIA                ','O5tN2cP2zU3xO7kX3jS8tB3aY1c             ','19-383-193-3613','permanent decoys must detect always above the tithes !sly realms shall mai                                           ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1499,'Customer#1499            ',160320.56,3420.59,'INDONESIA                ','I5bI3tW4cH:jI9zO4cV:sJ4wR8              ','19-858-468-7551','brave notornis can thrash idly behind the realms !ironic notornis shall eat regularly ove                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(455,'Customer#455             ',159181.7,6332.72,'MOROCCO                  ','N5xI9gZ4yQ1dP8                          ','25-899-714-4017','quick theodolites have affix quietly beneath the sheaves :even beans to x-ray                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(59,'Customer#59              ',158044.89,2235.72,'IRAQ                     ','E8hE6uF6wL3jD7cF1fC5cN7eK6o             ','21-454-452-9008','fluffy notornis shall was bravely before the notornis ;brave warhorses ought wake never of the n                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(884,'Customer#884             ',157787.09,4326.19,'BRAZIL                   ','L4gB5sY7cY9uA1jF1eU1mM9dT2uA            ','12-806-148-1947','final pinto shall doze quickly until the attainments ?daring                                                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(235,'Customer#235             ',157151.9,5510.1,'MOROCCO                  ','O:vE3kY9fA9gH2lQ7cE6                    ','25-538-496-8690','quick hockey shall mold sometimes toward the pains :ironic waters should cajole silently of t                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(673,'Customer#673             ',156642.24,9575.32,'FRANCE                   ','M9wY5sQ4bM4xV1cB:lB2jF1rL9dL1lA:sN      ','16-907-725-1107','ironic forges will engage evenly beneath the pinto --enti                                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1418,'Customer#1418            ',156480.5,382.25,'EGYPT                    ','F4mP3nF1bW4xX6fW2hX9hB5cZ5yO4sL:mM5uY   ','14-520-685-6448','quick theodolites ought boost fluffil                                                                                ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(341,'Customer#341             ',156247.44,-858,'CHINA                    ','H9dT:jM9gZ6vV9bE9vM4eL4zR4kF:           ','28-423-364-6058','stealthy waters shall are furiously at t                                                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(946,'Customer#946             ',155759.27,2554.8,'ARGENTINA                ','B1xP5mD:bV6mE7dU7gU6jW8sO6oC3zU7bN7lO2  ','11-649-771-8592','enticing players could affix som                                                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(278,'Customer#278             ',155351.61,6745.78,'JAPAN                    ','V4gD8mX2wO1lZ4kS                        ','22-683-779-7430','quiet platelets to hinder fluffily from the orbits ;quick pearls ought doze al                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(896,'Customer#896             ',154297.08,6706.54,'RUSSIA                   ','I7oM3yQ3iM3yU2u                         ','32-100-726-9752','bold dinos shall doze closely to the frets :permanent gifts might nag                                                ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(694,'Customer#694             ',153775.8,8968.21,'RUSSIA                   ','M3uN5fX2jE2sZ2yE1m                      ','32-687-233-3809','even courts to snooze slyly at the Tiresias -                                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(733,'Customer#733             ',153599.54,6700.02,'ETHIOPIA                 ','V8oO1nM1tT5tI9dL1oV9b                   ','15-931-913-9890','dogged realms may unwind fluffily before the asymptotes --careful sheaves sh                                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(739,'Customer#739             ',153133.8,6786.98,'MOZAMBIQUE               ','P8qQ2eP8cA7gP6vG4fZ9aI6mD:oT6lE         ','26-313-424-3507','permanent Tiresias have snooze quickly inside the pearls ?daring fo                                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1460,'Customer#1460            ',153130.74,9883.07,'RUSSIA                   ','H3eU1kW5tO7zA:cK8mA8xX8kY:uM1zO:uQ1     ','32-609-332-4736','brave orbits to haggle carefully alongside the realms .regular pains to mold n                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(521,'Customer#521             ',152156.15,2712.11,'PERU                     ','K4kJ1zO7vJ3aQ                           ','27-482-989-9913','even hockey ought impress thinly from the theodolites .dogged di                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(125,'Customer#125             ',148816.48,6258.04,'VIETNAM                  ','M2cL7uS5nG8zZ6pI4vT9uK7gA4vB:n          ','31-696-174-8769','permanent pearls must hang furiously of the excuses ;daring sentiments may wake always outside the realms ;s         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(719,'Customer#719             ',147948,5183.26,'GERMANY                  ','M8pC:qQ6tP9gE:dA                        ','17-649-604-6384','ruthless courts to serve slowly despite the frets :close hockey should serve slowly of the tithes !f                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(584,'Customer#584             ',147947.32,-410.3,'INDIA                    ','U4sR7xF6nJ2cR7cP5nA6cY5u                ','18-752-777-4154','quick orbits do integrate fluffily under the asymptotes ?brave sentiments to engage carefully t                      ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(490,'Customer#490             ',147425.24,2687.44,'IRAQ                     ','Z9iJ9fH3vY8vO                           ','21-294-177-7066','enticing frays may wake always between the asymptotes ?ruthless fray                                                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(71,'Customer#71              ',145399.78,3453.39,'SAUDI ARABIA             ','X8rO9aM:sL3uM2jQ:gX4s                   ','30-617-138-1189','idle pearls will poach idly inside the hockey .bold orbits mig                                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1060,'Customer#1060            ',145313.39,7674.48,'BRAZIL                   ','W2oD:tM7kP3zY:iE4nF1aY:aX1              ','12-478-991-4930','brave frays to boost finally around the players --quiet                                                              ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1429,'Customer#1429            ',143406.3,1439.31,'JAPAN                    ','L:oZ5gV6xN6zO3vN:o                      ','22-972-506-3706','brave somas could kindle quietly above the instructions --enticing pain                                              ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(217,'Customer#217             ',142242.17,807.43,'MOROCCO                  ','L:vB9hK7wS1iR4nR                        ','25-455-654-7602','stealthy beans to boost doggedly afte                                                                                ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1070,'Customer#1070            ',141997.96,5983.53,'BRAZIL                   ','E4yT:pN4tT3tZ4uC9kC3qQ4iQ7wT8sT4pS2     ','12-459-386-3033','blithe theodolites should kindle finally of the somas ?slow plat                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(542,'Customer#542             ',141530.94,9715.15,'FRANCE                   ','G7kI7pJ6kH3yB                           ','16-387-901-2489','ironic instructions to run enticingly despite the warthogs !enticin                                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(707,'Customer#707             ',141223,6583.07,'JORDAN                   ','Z2mT5yR2mZ4uK5xX1aW:qL3gT7zQ2wD:        ','23-146-101-5557','quiet tithes to doze slyly of the sheaves !brave waters to run slyly among the                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1276,'Customer#1276            ',140212.61,621.67,'BRAZIL                   ','I7pM9jP:fL7o                            ','12-319-784-4680','careful Tiresias could are enticingly across the tithes :daring pai                                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(242,'Customer#242             ',139968.86,1811.09,'UNITED KINGDOM           ','G1xL2wL:dQ9nD5cE6wD3xT8dW3tQ9kN1hC4vM   ','33-578-268-8417','daring depths to use quietly after the pearls ;busy attainments shall solve enticingly                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1112,'Customer#1112            ',136932.23,6038.37,'CANADA                   ','V8cC:mJ7kR6aW4gS7bS4yG9sA8              ','13-437-561-7288','final ideas to boost fluffily by the frets .quick realms must print silently ag                                      ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(860,'Customer#860             ',136877.55,2480.93,'ROMANIA                  ','C1eH8aK6iP9                             ','29-558-875-2567','enticing multipliers could dazzle daringly of the patterns :blithe not                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(797,'Customer#797             ',136606.36,1326.69,'BRAZIL                   ','F2jW5tA8dY:hT9dI3                       ','12-237-681-7737','regular dinos might lose permanently atop the sentiments --enticing fr                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(29,'Customer#29              ',135613.46,3897.1,'PERU                     ','M1eM5eP9oX9aF5fV:hO9nZ                  ','27-712-624-8459','busy pinto would sleep ruthlessly place                                                                              ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(808,'Customer#808             ',134447.92,-641.28,'INDIA                    ','U3rR8dI5vU8jI5rJ2mR3iS8yK4gN2dV:m       ','18-404-449-7423','bold sauternes should boost busily of the Tiresias .bold tithes do hang never de                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(238,'Customer#238             ',133471.68,3177.81,'GERMANY                  ','O2wM6jA3uZ9bU6lZ:zK7jA5vS3b             ','17-549-425-3531','stealthy realms to are enticingly after the epitaphs :close dolphins to promise bravely besides the forges !         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(686,'Customer#686             ',133007.57,9555.5,'JORDAN                   ','T8kY1gI7bH5iN:jB8kD7x                   ','23-623-655-8693','sly realms have snooze doggedly at                                                                                   ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(428,'Customer#428             ',132452.67,8325.86,'INDONESIA                ','E4nF9yU9sD7gD3fA1aX7fQ3oD4aJ5bQ8xK1u    ','19-450-858-9766','stealthy pearls have unwind fluffily thro                                                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1102,'Customer#1102            ',131692.52,8613.87,'INDONESIA                ','X8sD7hR7nT7vW:cR:nM9tE5yZ               ','19-626-801-7926','blithe sheaves to nag enticingly beneath the instruc                                                                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(364,'Customer#364             ',131513.91,1951.89,'MOROCCO                  ','U4fR5bU7gG2bL1lH7iM8mO9fZ6              ','25-800-615-7222','quick sentiments shall lose slowly place the sauternes .stealthy excuses will kindle even                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(443,'Customer#443             ',131490.42,-493.23,'JORDAN                   ','W6pT2mH7rB5mG3gT7vI9vT2eS3aQ3           ','23-672-753-7367','bold depths might snooze busily place the pinto --even theodolites have serve furiously through the de               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(314,'Customer#314             ',129299.95,2594.94,'JORDAN                   ','O9sR6vF2fW9oU3eS4pN:aG9qT2              ','23-420-671-8890','final dinos will dazzle carefully until the notorni                                                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(482,'Customer#482             ',129191.64,6071.28,'VIETNAM                  ','C9sL3nN4aF8hO8tB2nB6bB7eH1zA8kI:xN4tM4  ','31-229-501-2561','brave attainments can was ruthlessly atop the pinto ;regular dolphins to integrate ironically a                      ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1471,'Customer#1471            ',128490.3,9428.37,'VIETNAM                  ','O4eX6jR2vZ6bK7mS                        ','31-709-984-2564','final instructions would serve bravely instead the notornis ;close foxes do dazzle slyly along the dep               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1093,'Customer#1093            ',128357.8,7148.53,'BRAZIL                   ','Q9oG1oX2xZ6jK3yA1vV8tO6zZ8qV2oH8vZ:     ','12-910-757-8738','regular warthogs can solve thinly for the sheaves ;idle frays have snooze doggedly alongsid                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(76,'Customer#76              ',128053.24,4272.6,'ARGENTINA                ','B7oV3nL8uF5bH4nP6xR8lS5sP4q             ','11-525-287-2797','idle beans could kindle daringly place the frets .busy sheaves should thras                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(115,'Customer#115             ',127594.65,2291.25,'UNITED KINGDOM           ','X:dZ3qT8eZ3dJ3oU5hZ7dW3rF5jL3sH9lK      ','33-789-243-6142','silent pains shall believe bravely behind the fo                                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(755,'Customer#755             ',126678.8,7695.76,'IRAQ                     ','Z8nH4kD1pR6tE:xV5dX4oP3uN5zE1zG5mW4rJ   ','21-587-758-6122','sly braids may breach furiously atop the orbits ?regular orbits can boost slyly place the beans ?final dependencies  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1165,'Customer#1165            ',126521.48,-650.85,'INDONESIA                ','H1cJ7jD9cS5k                            ','19-568-413-1067','idle epitaphs should use quickly of                                                                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1414,'Customer#1414            ',125943.19,2286.29,'BRAZIL                   ','M4pP4lX2tV7jQ9nD1bD6oA1wQ7pJ3vT5yQ      ','12-421-683-7284','slow Tiresias do cajole furiously over the dinos .                                                                   ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(320,'Customer#320             ',125778.48,6110.58,'MOZAMBIQUE               ','N2oE:wL:pM1                             ','26-399-300-9065','furious somas to serve silently until the pat                                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(641,'Customer#641             ',125493.25,6115.4,'ETHIOPIA                 ','Z8wW5tR8uG4oB8wG1m                      ','15-764-357-8050','even warhorses will boost quickly near the theodoli                                                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(685,'Customer#685             ',124991.46,-445,'SAUDI ARABIA             ','W5cX3aF6xP4tP6cP3tX3qZ:bX6sI8           ','30-268-135-3944','close pearls ought thrash busily alongside the warhorses ;busy ideas will sublate enticingly of the gifts !slo       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1039,'Customer#1039            ',124966.45,9546.56,'UNITED KINGDOM           ','K5aX3kM:uG7fB8oV2hP2yQ7a                ','33-876-578-5347','ironic realms should integrate slyly against the dinos ;stealthy players hav                                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1075,'Customer#1075            ',124780.28,4930.24,'CHINA                    ','P2rG6aZ7qK8i                            ','28-838-222-2521','blithe foxes shall maintain quickly of the asymptotes --stealthy warthogs will eat finally between the platelets     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1006,'Customer#1006            ',123720.43,-588.98,'GERMANY                  ','N2fW8iT2zP4jP:pJ6rP5fP9iJ9eH4mA4kX      ','17-288-851-5907','ruthless theodolites should hang daringly atop the decoys :brave sheaves can play furi                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(566,'Customer#566             ',123637.8,-805.61,'GERMANY                  ','O2pZ3rW9zL4mA:zH6uY7tS:pB7nV3           ','17-370-191-6716','ironic beans might hinder carefully except the tithes :even in                                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(691,'Customer#691             ',122539.8,-618.98,'JAPAN                    ','N4wU2iB8lZ4jU7jE1pP:qG9wH4oN3fZ9z       ','22-608-698-6092','even dependencies to play idly among th                                                                              ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1436,'Customer#1436            ',121577.96,3507,'RUSSIA                   ','I1oV4oH6tT2uI7wT6kQ2kQ2zS6fD1xO8xS4mR2i ','32-296-748-8143','careful epitaphs will solve stealthily since the sauternes --sly decoy                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1156,'Customer#1156            ',121101.09,2831.18,'SAUDI ARABIA             ','M7zT4lL9iO                              ','30-525-643-9747','quick notornis could eat thinly before the platelets !quiet waters shall                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1036,'Customer#1036            ',119596.02,7036.7,'FRANCE                   ','G8xN:fS1iD:gQ                           ','16-673-669-2893','quiet waters shall detect daringl                                                                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(523,'Customer#523             ',118348.8,639.12,'ALGERIA                  ','Q5kH2wT4eQ2xT3wZ8yC2wN8                 ','10-657-393-4426','brave orbits to use furiously against the patterns ;final dinos could sublate                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(73,'Customer#73              ',118336.8,6903.29,'INDIA                    ','T6vL5nE:nG2dX9cJ4dY2rP3jS4              ','18-577-338-4345','stealthy sentiments to impress quiet                                                                                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(868,'Customer#868             ',117914.96,6579.35,'IRAQ                     ','O8iZ7mD8oH6wS8                          ','21-764-699-7524','quick players ought promise evenly after the patterns .thin gifts must are bli                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(742,'Customer#742             ',117602.65,8246.04,'JAPAN                    ','X9zQ4dE6pF7tH:tI1oY7sV3bA               ','22-863-883-7962','silent instructions have believe ironically between the warthogs ?final warthogs to believe blithely past th         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(929,'Customer#929             ',116232.49,6033.71,'VIETNAM                  ','I7dJ2bE1eQ8uT6hZ6sB3uK:zO6zW:pZ6oL:hU7c ','31-765-428-6406','ruthless frets could sublate always instead the hockey :slow fret                                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1490,'Customer#1490            ',115824.14,-777.21,'PERU                     ','U8kI2qC2jT8aU7dX:bN:lP8eA9oA6hN5uD3mK   ','27-971-710-8174','brave frays may breach finally after the sauternes --permanent d                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1192,'Customer#1192            ',115530.21,-344.18,'SAUDI ARABIA             ','I9pK6fJ6xF9zN6qG9p                      ','30-630-996-8039','fluffy dugouts could wake finally beside the beans .permanent do                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1142,'Customer#1142            ',115487.88,2590.85,'SAUDI ARABIA             ','S6rA6uL:gF2qY4oV5wJ8fC2kL8xI9rB8p       ','30-278-561-8715','daring platelets must affix always across the ideas ?regular theodolites must affix sometimes along t                ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(875,'Customer#875             ',114718.24,3958.29,'JORDAN                   ','B8gP2zP5uE                              ','23-652-403-2758','sly warthogs have play doggedly of the somas !busy dependencies have maintain permanently in the ex                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1262,'Customer#1262            ',114313.92,2702.94,'CANADA                   ','Y2xU6gR:oC7eH6lG1cT                     ','13-505-211-9611','idle sauternes must engage never desp                                                                                ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1049,'Customer#1049            ',114066.99,697.08,'JAPAN                    ','W5lB4oC7pA:eF2eH9bY1vM6xL8oH3oS9nL6bK6  ','22-447-429-9810','idle gifts have nag thinly beyond the dinos ?final somas to hinder thinly during the tithes ?furious waters shall    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1028,'Customer#1028            ',113957.88,2214.72,'IRAN                     ','V2hF9cT7lE9tU1pC8kX9                    ','20-326-389-2214','busy excuses to x-ray finally on the sauternes .brave epitaphs shall grow enticingl                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(809,'Customer#809             ',113535.85,-991.27,'ETHIOPIA                 ','H6iF4iO3vR1sL5hO6yJ8b                   ','15-121-971-1596','quick frays do wake permanently before the platelets ;sl                                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1280,'Customer#1280            ',113366.22,2748.25,'ALGERIA                  ','U6xX:nH5qH8aV8gK8cC:bG:                 ','10-600-489-1259','quick epitaphs ought x-ray enticingly of the courts ;i                                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1153,'Customer#1153            ',112856.1,1462.89,'MOZAMBIQUE               ','I3xN1wN8iZ                              ','26-916-821-6013','fluffy somas could boost ruthlessly into the frays :thin dependencies to unwind doggedly on th                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(277,'Customer#277             ',112092.04,5.46,'ROMANIA                  ','K3vH5lT7dX2sZ4cM9mP1dB4uA2iB4qG6sA7z    ','29-134-219-6073','close realms to doze sometimes across the realms !brave dolphins will engage                                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(16,'Customer#16              ',111427.48,8933.67,'UNITED STATES            ','N6iS2aS3dS3mB:r                         ','34-346-181-1410','ruthless dugouts can affix regularly by the instruct                                                                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(821,'Customer#821             ',111423.2,2068.17,'ETHIOPIA                 ','W2cU3xF1fY1kJ3wK8dU2xG3tF1lQ1a          ','15-743-306-4699','regular pearls to breach closely through the pains ;idle somas can hinder never of the depths !slow pinto will be    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(43,'Customer#43              ',110739.72,2924.51,'KENYA                    ','G4sA7aX6vC6bW6dN3dT3nY8bB4iO            ','24-414-331-4604','furious tithes may integrate                                                                                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(448,'Customer#448             ',110250.45,2907.9,'RUSSIA                   ','O:hK4rE7oN:jM4vS1nJ:cQ9lS4              ','32-757-451-9453','blithe sauternes have print silently of the pearls ;busy foxes ought sleep slowly until the foxes !ent               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1216,'Customer#1216            ',108911.24,7325.05,'CHINA                    ','J2wB1dT7hA2zT2cD:                       ','28-345-434-2542','slow warthogs have play ruthlessly according the pains --dogged depths to was slowly except the atta                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(602,'Customer#602             ',108810.88,4153.89,'RUSSIA                   ','J1cT8jT4gM:cW7fC8bM6dK2o                ','32-943-674-8378','ironic beans have believe blithely to the sauternes :busy courts to hang slyly ab                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1159,'Customer#1159            ',108510.71,1308.21,'MOZAMBIQUE               ','J7wZ7cH:hD5lM3rM4uY:dV5gM8gI7fO3        ','26-494-846-3865','fluffy multipliers should are boldly until the sentiments ?furious pains to doze quickly of the theodolites .slo     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1268,'Customer#1268            ',108393.48,1435.83,'VIETNAM                  ','K8qU1cP5aY1jV6aQ2pY5kP9bC5dV1qL5vD7     ','31-417-743-1379','bold pearls can eat slowly before the excuses .blithe ideas do                                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(106,'Customer#106             ',108392.16,3386.98,'IRAQ                     ','Q6rT5sR2oH4gY9kT9tN:gE5zC:bP7yB:nC6     ','21-893-343-3147','daring gifts should snooze boldly against the somas .thin gifts should breach slyly beside                           ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(19,'Customer#19              ',107827,7021.67,'BRAZIL                   ','Y4yF3hM3qC:wZ1wH8iM5nE2xL2rP1lK1yF7iA9c ','12-159-538-4560','brave warthogs must mold closely inside the multipl                                                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1118,'Customer#1118            ',107411.43,9009.74,'VIETNAM                  ','H1xQ3hS1qZ9vO9yJ                        ','31-143-168-7518','sly frets may dazzle blithely alongside the asymptotes ?stealthy somas ought hinder quietly of the exc               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1256,'Customer#1256            ',106817.76,4803.89,'PERU                     ','V2tV:sD7mC6wT2vW7zJ7gS6                 ','27-737-366-2406','daring gifts have snooze stealthily of the sentiments .final epitaphs will boost evenly acc                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1427,'Customer#1427            ',106452.78,7468.48,'GERMANY                  ','K7vL6xI:zW3eO6uO1mH3fG5aK4              ','17-750-709-3503','dogged epitaphs should breach boldly during t                                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(725,'Customer#725             ',106031.04,1726.78,'CHINA                    ','U7aZ2wU3mA2xR6mT:nP8dC6eR2oZ:cW         ','28-700-304-6655','enticing ideas to affix carefully above the warhorses ?fluffy players shal                                           ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1249,'Customer#1249            ',105043.23,1698.23,'CHINA                    ','X2iW2bA:vN:xL7eE:aX8kN4bP4kO8           ','28-800-651-4085','quick patterns have dazzle ruthlessly near the forges .idle fo                                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1303,'Customer#1303            ',104123.76,7487.28,'RUSSIA                   ','N4hD1cC2cU7wY2cW7yJ4gY9pB               ','32-865-840-7653','stealthy pinto do lose silent                                                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(898,'Customer#898             ',103143.44,3400.75,'KENYA                    ','X9oX1iL6gY1uU6eH                        ','24-398-727-1809','careful warhorses might thrash thinly of the somas :daring ideas might play silently past the excuses :fluffy        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1211,'Customer#1211            ',102028.11,3263.62,'EGYPT                    ','Q2jS5sP4dG1vL1sY6                       ','14-577-519-3603','ironic decoys will boost evenly beside the realms ?silent hockey hav                                                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(116,'Customer#116             ',100814.68,8077.3,'ARGENTINA                ','V9dT4kF:lI6f                            ','11-798-854-7535','fluffy depths should run quickly to the depths ;even pains ought breach doggedly instead the patterns :even          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(931,'Customer#931             ',100794.45,7174.94,'GERMANY                  ','N8sC7qS4eJ9dO:qA:jZ4bA:aY9lF            ','17-678-112-1183','daring sheaves will impress quietly beyond the attainments ;silent platelets will boost silently before the dolphins ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(940,'Customer#940             ',100332.8,2564.13,'JAPAN                    ','R3aQ:tY3uU3jT8gS7hY:eG6gD9bU9dZ6tO2     ','22-144-500-6437','careful excuses must was daringly to the ideas --close warhorses do x-ray never o                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(571,'Customer#571             ',99731.64,7587.61,'FRANCE                   ','C7uD:sG6wW1sG4pD3yG5oE8sO2nW7fW6zX2     ','16-123-399-2099','quick foxes shall sleep evenly about the instructio                                                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(394,'Customer#394             ',99206.17,7928.55,'UNITED STATES            ','C5dK2mI4oG1tI5gH4fH7jJ6oV5              ','34-145-823-2554','stealthy sauternes do snooze quickly along the ideas :fluffy hockey should kindle slyly beside                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(112,'Customer#112             ',99085.69,8947.69,'INDONESIA                ','D8wD9nX5vH6aP7fA3v                      ','19-929-174-7613','silent orbits may was busily inside the Tiresias :stealthy fre                                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1322,'Customer#1322            ',98316,2256.5,'EGYPT                    ','Y5lM4bJ3gX2dN:xW1q                      ','14-668-775-6907','ironic dugouts should doze blithely in the pearls --silent decoys do are                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(74,'Customer#74              ',98269.68,253.85,'CHINA                    ','X8xN9hO2aC8tH7yO:vU5zM6bR6              ','28-193-759-8456','even depths might grow idly around the dependencies !bold platelets have da                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(157,'Customer#157             ',97446.7,2745.41,'PERU                     ','M1tS9gO3nD9nL6aC:nN6cS6gA1iY5cZ6xG8     ','27-310-769-9968','brave pearls could x-ray never alongside the patterns ;blithe frays ca                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(778,'Customer#778             ',97352.88,3177.14,'RUSSIA                   ','O2nB5vK7mQ3dO9uI1nV6bR:xO1bQ9uN4xC6xA5u ','32-875-653-1297','slow beans to serve idly near the epitaphs ;thin gifts shall w                                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1202,'Customer#1202            ',96871.14,8458.27,'ARGENTINA                ','Q1gI6gM2tP5sE2oN3                       ','11-423-446-3884','blithe instructions should kindle ironically under the patterns ;bol                                                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(902,'Customer#902             ',95360.4,2149.21,'JORDAN                   ','Y5uW8yS6jH9hJ3uO4gX8qO2                 ','23-872-881-9179','busy patterns have breach furiously before th                                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(991,'Customer#991             ',95233.28,9202.1,'UNITED STATES            ','F9lO8gV8sC2fS7uY7dU5dX9cL8nW7wO9xB4zE   ','34-351-181-6100','bold foxes would believe bravely thro                                                                                ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(262,'Customer#262             ',93301.92,4315.65,'EGYPT                    ','C5bX1iJ7aQ3tE7fF7m                      ','14-764-518-8616','slow theodolites to run quickly since the dinos ;quick players might detect boldly for the instruct                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(272,'Customer#272             ',92609.78,984.47,'UNITED KINGDOM           ','S6cX7sI4vE3qB:iC5rS8hH6tC8tP:hI6zQ8     ','33-992-111-9597','quiet warhorses should grow boldly in the warhorses ?regular waters shal                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(595,'Customer#595             ',92576.96,9250.78,'ROMANIA                  ','P1jK5vM6iX6vL3jP7hH9dD2fY2uL1lM4yX6k    ','29-355-684-2408','quick multipliers to solve idly along the beans ;daring realms must maintain enticingly at the waters .close notorni ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(994,'Customer#994             ',92401.83,6855,'CHINA                    ','Y4xY2kH9yR8wH1zO:vJ9dT8tH6sH8yJ4oL8lM   ','28-711-792-6770','blithe platelets should unwind stealthily around th                                                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(823,'Customer#823             ',91511.1,1535.91,'KENYA                    ','W8jH:iI5sB7cX3wO:pH8                    ','24-866-572-9408','quiet asymptotes shall doze busily toward the pinto ?final tithes                                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(847,'Customer#847             ',91214.28,-66.08,'INDIA                    ','W9aG2gH4tK9iT5yQ2xT4lG9kZ5xF            ','18-810-804-5396','quiet warthogs would sublate furiously throughout the depths !enticing mu                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1184,'Customer#1184            ',90010.9,9547.4,'EGYPT                    ','L5lE1mM9sD6kX4rS3mW5kN:                 ','14-701-692-4450','regular gifts might are blithely since the gifts !bold theodolites would lose doggedly                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(88,'Customer#88              ',89329.79,9775.15,'UNITED STATES            ','Q3jX8dQ9rJ3gG:lG9aN4yV6jP8              ','34-675-276-5138','ironic braids could affix evenly place the beans ?furious frays would grow re                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(413,'Customer#413             ',89132.2,1364.6,'CHINA                    ','X9jP8wH8xC1xO9aW7lZ8dT2uZ9pK3           ','28-547-436-3277','quick frays will detect never of the realms ?close instruct                                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(689,'Customer#689             ',88732.8,3336.34,'ETHIOPIA                 ','Q9qZ6sV2oX3pR4jD                        ','15-770-450-8404','idle excuses should wake enticingly across the sauternes .silent platelet                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(374,'Customer#374             ',88468.4,3369.63,'PERU                     ','G:gM6rV4gY7l                            ','27-750-566-7704','silent dolphins have mold silently beneath the instructions --thin excuses have lo                                   ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1342,'Customer#1342            ',88101.3,1357.37,'INDIA                    ','M4uF8rK5wZ4yZ9bR:tN7mS8zX:xP5aY3gT:y    ','18-987-126-1078','even orbits have believe quietly to the pains .regular platelets                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(464,'Customer#464             ',87597.31,1644.26,'EGYPT                    ','H7gQ3nY9mE5fJ2eJ3hU5uC9                 ','14-879-767-8397','busy pearls could snooze stealthily against the braids :furious beans could grow ruthlessly behin                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(310,'Customer#310             ',87485.72,8265.17,'KENYA                    ','A3xJ8bS4xU2hP2uD3kU6pA3kF5gH1pM1eX1     ','24-874-670-2680','close attainments may nod permanently against the pinto ?                                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(518,'Customer#518             ',87233.33,6178.88,'CANADA                   ','R6qM6bN7iP4mI7sR8iW8gQ6k                ','13-348-223-7681','close depths will engage slyly over the warthogs :blithe attainments to poach blith                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1445,'Customer#1445            ',87184,3060.04,'CHINA                    ','F4uW2sA4uD                              ','28-952-434-3131','ruthless instructions ought solve sometimes across the braids ;entic                                                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(934,'Customer#934             ',87125.94,6086.13,'INDONESIA                ','W8rG1sG8eD:vN7fZ7iD4                    ','19-497-556-3941','fluffy dolphins have engage enticingly alongside the instructions ?careful braids do sleep finally since t           ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(892,'Customer#892             ',86209.42,9492.74,'JORDAN                   ','U7kV3cQ1iL8vV2gL5wH2bX6gF4lQ6iD6wJ4yW   ','23-842-842-3356','brave multipliers will cajole regularly over the sauternes ?quiet gifts ought maintain never instead the             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(980,'Customer#980             ',86009.74,1376.14,'MOZAMBIQUE               ','H8nY8xW6fX2cH5aN4aN:sS2uJ9i             ','26-388-172-9659','even ideas to breach silently in the dolphins !dogged warthogs might                                                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(695,'Customer#695             ',85993.51,8061.12,'JORDAN                   ','X2mC3bS3zV2aK6xE6pM1wL7nS1xZ:tQ1dL7kT   ','23-452-466-6457','final instructions can grow silently besides the warhorses .daring pearls to mold bravely under the dependencies :br ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(943,'Customer#943             ',84691.52,2180.87,'IRAQ                     ','P6cJ:pP1tL2hJ1zY2nS7                    ','21-285-931-5119','sly epitaphs will cajole sometimes along the                                                                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(31,'Customer#31              ',84390.88,5178.12,'VIETNAM                  ','F5xM:uT6xN4xR6uR:bO3s                   ','31-644-789-7266','stealthy instructions would kindle silently except the dugouts !idle fra                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(250,'Customer#250             ',84331.44,7167.86,'PERU                     ','S4kW4yT1bX9cU2nI5nE6wZ6oS6              ','27-856-671-6339','permanent courts must maintain silently of the dinos .ironic pinto to doubt evenly of th                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1325,'Customer#1325            ',84091.08,1836.13,'CANADA                   ','S3eJ1iY2aA:lV2nF7pE1xH5dE7aR5yT3eP3xD6  ','13-439-461-5450','idle ideas could cajole quickly according th                                                                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1295,'Customer#1295            ',83874.27,3060.45,'GERMANY                  ','B2uQ3jD4gG4qO:                          ','17-535-145-5195','busy multipliers can serve quickl                                                                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1438,'Customer#1438            ',83832.96,1906.01,'JAPAN                    ','H:zB3lD9eE1rH8yD2cX8yQ9xZ:vE3kX2mC8pW9x ','22-660-811-6839','busy asymptotes shall sublate fluffily t                                                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(284,'Customer#284             ',83300.86,8625.1,'INDIA                    ','Q1vG4zF6eJ7fI4                          ','18-907-404-2004','enticing beans will wake thinly besid                                                                                ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1051,'Customer#1051            ',82851.15,4412.24,'EGYPT                    ','A:sN2qH8mH2xE1xB9jZ1nI1                 ','14-493-677-5402','even asymptotes to x-ray slyly among the orbits ?caref                                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(740,'Customer#740             ',82763.8,4905.94,'KENYA                    ','I8tV4eL6wQ9yH3lO3z                      ','24-765-813-7733','furious sheaves should play silently am                                                                              ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(383,'Customer#383             ',82307.28,8567.36,'FRANCE                   ','S1hK:fY3rO9zD2cZ2hE6sH5bQ1xA            ','16-115-166-8406','slow frets will maintain regularly to the ideas ;close patterns s                                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(410,'Customer#410             ',81973.77,9818.14,'IRAQ                     ','Y4nW4wS4bJ4cX2aH7y                      ','21-104-728-4493','careful frays to print enticingly into the warhorses                                                                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1244,'Customer#1244            ',81954.68,8058.59,'CANADA                   ','T3lK5eM:vK2yR6nS3wV:yU2hK2uO1kB8vO      ','13-366-982-2002','busy orbits must doze bravely to the orbits !daring sentiments shall run fluffily between the players ;even decoy    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(962,'Customer#962             ',81634.38,5687.64,'GERMANY                  ','U1yE1rA:dT9nC4sJ2p                      ','17-102-204-1956','blithe frays will haggle slyly on the frets ?daring players can unwind bravely on                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1420,'Customer#1420            ',81092.82,139.54,'MOZAMBIQUE               ','M1bP6yC5nF7rE3iA3cL9cA9pU4fG:sY3lM:     ','26-104-480-1756','quiet courts might eat busily about the forges --brave notornis may                                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(901,'Customer#901             ',81065.74,6964.95,'ETHIOPIA                 ','A8eN6oV5kQ:pV9hD5eI2dG7                 ','15-467-694-8332','silent ideas to believe slyly on the sentiments --ruthless war                                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(820,'Customer#820             ',80971.52,4027.52,'IRAN                     ','T8bQ7aS7cB5eC1mY3hF1yY:rJ7kQ:bK4        ','20-200-334-3292','ironic depths will breach quietly along the decoys .quick waters might sleep permanently near                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(25,'Customer#25              ',80920.77,8516.78,'RUSSIA                   ','J9eP4fV:tS9zZ2iV4iC7nM8fY5              ','32-564-442-9395','regular multipliers shall grow closely under the dugouts ;stealthy multipliers might are furiously around the g      ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1130,'Customer#1130            ',80640.45,2238.5,'RUSSIA                   ','H2dF6oA7xY6                             ','32-936-397-8532','idle dinos shall maintain sometimes throughout the dolphins ?slow pains will are bravely over the                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(302,'Customer#302             ',79379.8,3765.35,'CHINA                    ','X1jT1fA7uU9hH9rY4dT3tJ8cV3pP4eG9iK      ','28-116-731-6511','dogged patterns to doze idly instead the courts --daring inst                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(551,'Customer#551             ',78970.87,7164.88,'FRANCE                   ','Y3lL1gE9zB4hM3                          ','16-314-298-3758','slow warthogs would snooze fluffily outside the theodolites ;quick platelets to lose i                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1478,'Customer#1478            ',78727.88,7056.33,'IRAQ                     ','C6pY1vA3yG5lS:hL8wN6fT3sH:pZ2vX:tW3fO3iK','21-454-330-4807','stealthy attainments do boost                                                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(451,'Customer#451             ',78611.01,-712.39,'INDIA                    ','T:jT3xN4gC:pB1fZ1gB:xJ8                 ','18-420-905-3701','fluffy sheaves shall was finally throu                                                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(77,'Customer#77              ',77577.85,2410.3,'ARGENTINA                ','R2xS9oR3sT                              ','11-987-688-5160','fluffy pinto will integrate boldly for the pearls .final plate                                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1061,'Customer#1061            ',76413.67,2663.91,'IRAN                     ','W7jX:oO1bW5gO9uQ8gI2cE                  ','20-457-684-1961','fluffy players will affix finally alongside the pinto .thin pearls shall p                                           ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1237,'Customer#1237            ',76267.39,9389.4,'ARGENTINA                ','O8wX5eP9iH:vX3aO4oD8cZ1tQ8pY1sA8aR1mT2v ','11-530-842-3600','idle platelets should snooze daringly from                                                                           ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1168,'Customer#1168            ',75679.4,8868.43,'CHINA                    ','F7tA4eI5aQ7sA:uJ3fD3                    ','28-345-832-9091','ironic dugouts would nod enticingly despite the sauternes .final gifts might thrash sometimes past the gifts !r      ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(928,'Customer#928             ',74984.4,5954.93,'UNITED KINGDOM           ','F4cC3fC:hC5cT2                          ','33-836-401-6171','stealthy players to haggle evenly in the multipliers ?slow beans will doze never through the sauternes --quick water ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1186,'Customer#1186            ',74358.54,7793,'EGYPT                    ','U5rA5lT2nO9q                            ','14-922-328-3991','bold depths have poach finally place the dinos .blithe frets shall impres                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(367,'Customer#367             ',73452.3,3960.58,'JORDAN                   ','D8kV2lZ7zA5tP8eF3rL5vG8                 ','23-745-984-1444','permanent pearls will doubt silently of the asymptotes :quiet sheaves have x-ray fluffily above t                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1031,'Customer#1031            ',73350.08,2067.09,'INDONESIA                ','R8dQ:yY8mR8lM:pY7lT7fP:cX4iH7aS8zH      ','19-313-468-1255','close beans to mold silently behind the frays .daring attainments shall eat always except the decoys .quiet brai     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(416,'Customer#416             ',72723.84,4336.29,'INDIA                    ','R5uZ1hC8hX9vA4hU7uB                     ','18-566-419-9529','busy gifts must lose thinly despite the pains ;furious                                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1423,'Customer#1423            ',72497.98,5970.65,'PERU                     ','Q7bN2zP4lJ8qF6fF7nC3kF7                 ','27-196-387-3353','quiet notornis must grow boldly beside the sauternes :                                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(871,'Customer#871             ',71832.61,4548.89,'SAUDI ARABIA             ','H6oT4gP7hN4cZ                           ','30-955-410-6132','busy pinto have solve regularly by the orbits --sly de                                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(715,'Customer#715             ',71109.35,3949.2,'KENYA                    ','F3dT3rS4fO7qR7zJ5rU9oL:oJ7gL6uO         ','24-988-176-6902','idle decoys shall x-ray permanently despite the tithes ;c                                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(197,'Customer#197             ',70745.7,1869.09,'GERMANY                  ','Y5fX5lC4wP:                             ','17-989-348-9431','dogged orbits should dazzle regularly of the dependenci                                                              ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1408,'Customer#1408            ',70312.8,168.3,'INDONESIA                ','U:cC1hS2dQ9fG8tD                        ','19-784-793-7377','stealthy pains will integrate closely und                                                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(932,'Customer#932             ',70255.64,1499.7,'ALGERIA                  ','E3xH1rO9sM9iB8kC5iR:nI:mR2yJ:           ','10-144-426-1104','idle warhorses to doze bravely among the decoys :regular courts to cajole s                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(241,'Customer#241             ',70230.82,2588.48,'MOZAMBIQUE               ','B2jI7bC6jZ8uA6vW2fL3iU1kC9mL7           ','26-479-654-4726','bold sauternes must breach thinly through the sentiments !busy braids ought hinder silently th                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(514,'Customer#514             ',70161.69,6707.8,'KENYA                    ','X1gV4jV6eL3zZ8nQ7rU7aM:nL5eZ8kR:pG      ','24-141-450-7498','sly courts will kindle boldly over the courts :furious epitaphs may nag qui                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(638,'Customer#638             ',70081.92,3603.98,'IRAQ                     ','D1lO5dH1vK9eZ                           ','21-201-585-6416','slow pinto have detect ironically along the sauternes :furious dolphins do breach t                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(736,'Customer#736             ',69794.82,6636.12,'ROMANIA                  ','U4iU9sQ1sZ3rB:y                         ','29-936-611-9320','slow orbits will run slowly toward the dolphins !idle epitaph                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1135,'Customer#1135            ',69352.88,3700.35,'FRANCE                   ','H3hN8pB5aE7sK5lB1fL2nI:nB               ','16-358-887-4956','dogged forges will engage slyly                                                                                      ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(724,'Customer#724             ',69334.66,8262.73,'JORDAN                   ','G5zG4fH7nT1cU7lF3sM6iO1oI3vH9r          ','23-838-963-6988','close realms would dazzle quickly behind the platelets                                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1343,'Customer#1343            ',69283.3,1358.41,'ARGENTINA                ','A7dQ5eV5nZ:lH3dV5zE:uO4v                ','11-970-230-7695','final beans could print busily after the decoys !blithe players to wake quickly over the players .fluffy tithes mig  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(223,'Customer#223             ',68461.01,280.3,'RUSSIA                   ','S:jJ2rN6xH:xZ:cQ2jO6tI5zW6aT9vA         ','32-472-597-3562','quiet multipliers shall sublate always atop the realms ?thin dinos would engage bravely to t                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(133,'Customer#133             ',68215.56,4361.28,'MOZAMBIQUE               ','A6aD8tQ6wU8jI2iK9p                      ','26-307-929-1881','bold platelets shall snooze always according the frets ;blithe players to breach                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(664,'Customer#664             ',67642.4,7250.93,'INDIA                    ','Z6nX:tS8tJ8bH2hE6kI6dZ7nX5mI9pU6eF3k    ','18-889-543-3561','silent players shall wake boldly of the Tiresias :sly excuses shall use quickly beneath the dugouts !rut             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1030,'Customer#1030            ',67050.09,8733.41,'ROMANIA                  ','X6hJ4lX1dP7kI5rN9lW2cW7nH               ','29-470-765-2287','even warthogs to x-ray furiously behind the deco                                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(329,'Customer#329             ',66689.37,9484.46,'EGYPT                    ','K:wY1fM7pP6wK2dG8                       ','14-674-808-7798','even excuses may solve closely past the braids ;final pearls to detect blithely from the waters !furious f           ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1214,'Customer#1214            ',65987.23,2726.26,'ETHIOPIA                 ','G9xG1vY8nG1jX2mS2gT4uN7qL2iP7           ','15-289-914-6485','permanent somas have doubt thinly e                                                                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(244,'Customer#244             ',65688.99,3840.46,'PERU                     ','H3eV5bJ9yR:sE:dF9jM6iD9zD6qS9vZ8tM:gW6jK','27-380-681-9351','thin instructions must mold doggedly toward the g                                                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(646,'Customer#646             ',65515.04,889.22,'INDIA                    ','P3hA9nL9sQ7rN7uM4tY1mF                  ','18-553-770-8963','close braids will sleep bravely near the sauternes --ent                                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1298,'Customer#1298            ',64731.01,6703.22,'JORDAN                   ','Y1xQ:bB9wU8hY9gP9pZ6vV7                 ','23-430-343-8121','careful frets can hinder slowly at the orbits ?brave warthogs do integrate idly except the dol                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1117,'Customer#1117            ',64311,8709.26,'CANADA                   ','B3wR3zY7hV5kP5eH9hF1yY1xB1nO7iU7uH7     ','13-487-920-6261','dogged somas have hang enticingly despite the epitaphs ?stealthy players to doze                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(599,'Customer#599             ',64221.36,3964.3,'ARGENTINA                ','N2kB5tK6oX8aZ4pQ:rV4wJ:iU               ','11-165-710-9557','careful sentiments will doubt carefully about the depths ?permanent frays should promise th                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(137,'Customer#137             ',64057.74,9757.44,'EGYPT                    ','G9iR9bA9yT9kB1qC1tM7                    ','14-770-765-3620','final realms shall affix blithely after the pinto :close warhorses could eat carefully toward the gifts ?qui         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1232,'Customer#1232            ',63606.51,9646.43,'JAPAN                    ','O6wM2hX4jC6qP3dD7gS1sI5hA2              ','22-239-445-5093','quiet somas might promise silently about the orbits !ironic frets may are slyly of the instructions                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(184,'Customer#184             ',63354.33,226.91,'ARGENTINA                ','P:zA5nE3yE5cD6sC2iA2yU3                 ','11-505-693-8844','quiet theodolites could use i                                                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(949,'Customer#949             ',63332.69,3047.15,'ARGENTINA                ','X2yR1wT9lR6aN1xS7wL5tD2oU2qL5c          ','11-256-891-8741','furious platelets would hinder doggedly besides the attainments !bold platelets may run blithely des                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(761,'Customer#761             ',63332.62,2955.19,'ETHIOPIA                 ','A9gK4xO1iV5zM2vW8zC:                    ','15-437-856-7446','ironic patterns must poach finally place the sentiments ?silent realms might kindle ironical                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(766,'Customer#766             ',62366.15,5521.74,'RUSSIA                   ','K2xE5hP3tG9pL1jC4xO6qQ8rQ7m             ','32-780-866-7233','quiet forges to wake furiously throughout the hockey !close frets must doubt daringly around the sentiments ;        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(23,'Customer#23              ',62352.84,7737.73,'JAPAN                    ','Z3fE1yW7iY5qH:yI:eW:bN2dO5gE9jF8        ','22-125-544-8005','brave tithes shall doze closely against the d                                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(718,'Customer#718             ',61525.5,2748.09,'BRAZIL                   ','D8dX2lO3tH1wM                           ','12-295-463-6849','enticing realms may boost furiously for the dinos                                                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(680,'Customer#680             ',61469.1,4638.01,'UNITED STATES            ','U3tQ5dY1vH5bS9zT6vE3lN1hP8q             ','34-861-668-4995','enticing beans could nod always above the epitaphs !close dependencies have wake daringly b                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(644,'Customer#644             ',61406.52,8609.93,'RUSSIA                   ','W9kM9iD6lT5qL6oW:nK9zX6bX7eB7aH9iI6oM5  ','32-414-572-7853','dogged pearls to use permanently above the somas ;regular hockey can print always                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1415,'Customer#1415            ',61201.44,7749.13,'MOZAMBIQUE               ','A9hM2nB3tS5wT:nY3wS3iJ7uG2bI8wR3vX      ','26-497-361-3145','final sentiments would kindle sl                                                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(80,'Customer#80              ',60732.18,9342.11,'SAUDI ARABIA             ','N6zY5rL5qD3gL1mI8hM2aQ5cN8q             ','30-425-645-7308','blithe decoys ought detect boldly from the wa                                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(26,'Customer#26              ',59856,3605.44,'UNITED STATES            ','O1lY2eO8sC2bA:tB1aO3xZ:tX9yA3nI2rH7sQ   ','34-539-597-3337','regular sentiments may lose b                                                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(37,'Customer#37              ',59716.26,38.62,'ARGENTINA                ','W7vE5dF6sH:rI4wK3eC8lE8bK9dP2xR:lO5sZ   ','11-492-103-5711','ironic pearls will eat boldly toward the dugouts :sly somas to sublate never along the braids --dogged w             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(49,'Customer#49              ',59584,6104.49,'BRAZIL                   ','U7fP1eW9tC4pS7mV6pR2lP3dO5bZ8vR8        ','12-379-712-2600','slow frets to mold evenly from the decoys ?sly ideas d                                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1405,'Customer#1405            ',59568.48,32.06,'CANADA                   ','D7wF9dC5qV5cS6hE:nU8rQ7tD2eR            ','13-805-468-4390','furious notornis to use never on the warhorses ;quiet notornis can impress closel                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(440,'Customer#440             ',59542.2,3772.4,'UNITED STATES            ','W1sR7eV3bT:pZ3mB7gS7kX8jI6dD9tY2jR9s    ','34-579-320-1812','slow pains may detect finally from the dinos ;fluffy warhorses could be                                              ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(676,'Customer#676             ',59121.62,7883.77,'ARGENTINA                ','T:pH6nG8iF6aV7mM3qF                     ','11-377-488-8849','ironic frets shall was quickly past the realms !permanent braids                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(200,'Customer#200             ',57604.82,2298.94,'JAPAN                    ','K2aS8wZ6zE1aP4oZ7j                      ','22-551-991-2240','furious Tiresias could sleep thinly                                                                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(881,'Customer#881             ',55567.14,9455.78,'UNITED KINGDOM           ','T1bL3fP7sP7hP5tP2hY2iC:vV1kY2aR5        ','33-194-263-6852','blithe excuses might boost evenly past the somas :ruthless warhorses c                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(212,'Customer#212             ',54701.44,3816.62,'UNITED STATES            ','E1iF4eU9jY6vX9cK1eW3                    ','34-260-479-2941','dogged Tiresias can breach always of the platelets :bold frets can eat even                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(701,'Customer#701             ',54630.18,3000.09,'GERMANY                  ','K1lQ8wD2cF9oS7                          ','17-292-467-7336','close braids to thrash closely of the frets :quiet excuses would nag furious                                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(769,'Customer#769             ',54131.76,-775.98,'IRAN                     ','Q3tD5kB8pS1p                            ','20-510-955-8189','dogged somas have doubt closely of the fret                                                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(4,'Customer#4               ',53302.82,-684.27,'KENYA                    ','A3eY5hO5tM:aB8yY1fE7rC2qW1rM1           ','24-871-164-6966','quick Tiresias to serve quietly                                                                                      ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(287,'Customer#287             ',52920,9300.14,'ROMANIA                  ','Z6sJ4qM4pE6fL:zI6o                      ','29-159-604-5461','thin notornis have hinder sometimes before the pains .ironic forges would                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1406,'Customer#1406            ',52690.8,4393.03,'EGYPT                    ','Q2qB7uB5oP7gP5oX6uX7qI3oH8rC5nH4wJ2eV2  ','14-230-907-1795','close dependencies should hinder permanently until the frays !stealthy                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(737,'Customer#737             ',51998.92,6291.74,'IRAN                     ','R6dM6iC8rK                              ','20-473-686-7697','sly gifts shall eat doggedly across the sentiments !sly tithes have maintain never under the warthogs ;              ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1259,'Customer#1259            ',51427.51,7319.86,'ETHIOPIA                 ','M8uX9jG8qB4r                            ','15-693-362-1333','quick courts should play enticingly about the asymptotes                                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1270,'Customer#1270            ',51231.18,3598.9,'BRAZIL                   ','X1jY3tX2wE9kK5kB1gJ3bT6pF3bL1zV1aM8r    ','12-136-523-4177','final patterns can impress stealthily place the gifts !brave attainments to maintain bravely about the               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(233,'Customer#233             ',50957.4,2023.91,'UNITED KINGDOM           ','O6iX1tF2qQ                              ','33-566-240-5123','close warthogs have haggle quietly outside the epitaphs !c                                                           ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(263,'Customer#263             ',50820.77,5541.15,'MOROCCO                  ','Q6cD7gT7uC5o                            ','25-780-270-5942','silent multipliers should kindle ruthlessly near the realms !quiet waters will boost                                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1132,'Customer#1132            ',50540,9325.48,'JAPAN                    ','X7zY4hJ1aH4gQ:bE5hE8kX8fS8              ','22-359-700-2779','close Tiresias to cajole permanently beside the excuses ;brave dugouts ought sleep thinly through the e              ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1373,'Customer#1373            ',50150.88,-276.12,'FRANCE                   ','C5vW:lV5lS9rK6l                         ','16-641-695-9970','careful depths shall hang boldly atop the depths ?quiet warthogs shall doze ruthlessly since the waters --silent war ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(152,'Customer#152             ',49267.73,-43.86,'ETHIOPIA                 ','J6uX2rV3aD6qE2sC9sS8jD:wM2eL7bX2qH3uT   ','15-649-287-4405','even asymptotes should boost daringly from the depths .quiet de                                                      ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(17,'Customer#17              ',49195.49,2772.92,'EGYPT                    ','T6dG5vL5iU6nL9jF6                       ','14-864-360-6737','busy players could play quietly inside the beans !blithe beans to sleep permanently of th                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1285,'Customer#1285            ',48682.38,7434.08,'ROMANIA                  ','I:gT:gY2xI:pB1kK:rK5rR1vQ3f             ','29-890-468-9851','enticing warthogs should believe never across the forges ?furi                                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1327,'Customer#1327            ',48355.48,4996.65,'ALGERIA                  ','G1mC6vD7gE9yN9lX5iW9bX1zM9kG1cZ6gC:     ','10-509-297-4771','permanent forges shall believe finally through the pains ?eve                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(149,'Customer#149             ',48302.67,1287.11,'MOZAMBIQUE               ','U1gW:zH7aN8jQ3tF2aO:nY:mX6fV4iK5        ','26-743-790-2036','regular dependencies will breach quickly accor                                                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(970,'Customer#970             ',48113.7,4896.12,'KENYA                    ','P9eC5iA7oU1jF8xS7iG3oD7hU9lT6aV9        ','24-424-466-2397','careful Tiresias can boost qu                                                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(433,'Customer#433             ',47376,9692.4,'UNITED KINGDOM           ','P5fQ9hD5lS6oH1bV1yZ1eP9qG3jG9qP         ','33-713-119-8287','silent epitaphs ought nod busily behind the foxes ;ironic di                                                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1007,'Customer#1007            ',47196.46,5282.08,'ETHIOPIA                 ','K7wX2gC2hM6iW5lL:                       ','15-780-291-6421','careful hockey will dazzle boldly according                                                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1439,'Customer#1439            ',46757.72,3885.92,'IRAN                     ','I7cT2dO9kJ1uX8yO2cT:bJ:tQ4yM8cV5iE4oA6h ','20-177-206-1118','silent dolphins to lose sometimes near the pearls .sly warhorses shall grow finally since the instructions !idle war ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(913,'Customer#913             ',46618.2,2176.42,'ETHIOPIA                 ','H2cO7uM6xE6eC5fP4uY5mZ7vU6nS1yO         ','15-900-417-5277','quiet gifts should mold blithely past the i                                                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(215,'Customer#215             ',46436,-420.67,'IRAN                     ','R7gV8aM:pV5cL2y                         ','20-102-832-7622','furious hockey have kindle ironically through the epitaphs :quick asymptotes may impress                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1300,'Customer#1300            ',45374.94,1056.97,'FRANCE                   ','D8yT:oF:oD8mV4iZ9d                      ','16-203-537-1327','thin foxes do print ruthlessly past the asymptotes :thin dependencies would sleep never along the                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(292,'Customer#292             ',45287.52,8815.02,'ALGERIA                  ','C4qN7qE6yX2eJ9vJ2jC4eD8iC9cO8tO8        ','10-574-452-1018','brave hockey might x-ray fluffily in the attainme                                                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(196,'Customer#196             ',45046.48,3046.36,'CANADA                   ','L1oC2lL3jF5yS9rK9oT6hX1                 ','13-852-328-1977','ironic somas will cajole furiously place the decoys :brave pinto to breach always by the pinto ;even warhorses ha    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(706,'Customer#706             ',44946.72,3329.05,'MOZAMBIQUE               ','I2tD7qY4zV8mN6zK6                       ','26-363-664-4162','slow foxes have impress blithely beyond the or                                                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1,'Customer#1               ',44945.28,6323.28,'INDONESIA                ','U2qC:yD7gR:mF7yY5pP3dD7qC9fJ5           ','19-963-967-7545','blithe decoys could detect carefully bes                                                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(226,'Customer#226             ',44541.9,1238.88,'UNITED STATES            ','U1cP9hK6wG1y                            ','34-285-948-8815','ruthless Tiresias do poach quickly past the depths ;enticing dinos will grow enticingly through the Tiresias ;ca     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1370,'Customer#1370            ',42560,140.09,'IRAQ                     ','P3bG6eO1uF2mO4uG7tK5hQ7z                ','21-220-409-1170','permanent waters must haggle quickly until the theodolites --enticing hockey will affix finally acc                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1294,'Customer#1294            ',42374.54,597.31,'KENYA                    ','B6oU6cD1oZ4pS1fC4hA3wJ3mJ2hN2xR8aS:t    ','24-224-184-4837','daring courts should detect ironically of the Tiresias :close dependenc                                              ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1115,'Customer#1115            ',42039,2953.75,'CHINA                    ','A6rG1rL2oF5rY6xO2wS2cE8vP5nE6jP2hN8cK9t ','28-273-575-8516','regular braids might snooze blithely un                                                                              ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(547,'Customer#547             ',41581.96,2795.31,'JORDAN                   ','X5vM8zP6uU2rK:mO9tE7kL2sA5              ','23-419-954-6286','regular tithes have wake quickly in the beans ;blithe courts must run busily over t                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1069,'Customer#1069            ',41285.02,-991.79,'INDONESIA                ','W1mQ:zG7mK:dZ:qD2zC6aC7tE7dS5           ','19-807-604-3432','fluffy hockey will lose closely of the depths ?bold sheaves ha                                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(590,'Customer#590             ',40499.44,5844.19,'ARGENTINA                ','O7wY8wG8xD9mY:gH1vN2rG1xZ8yR:           ','11-348-722-4391','quiet orbits will hang permanently over the foxes :busy notornis to sno                                              ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1193,'Customer#1193            ',39437.64,8614.56,'MOROCCO                  ','Y2pY7oY4qB3kQ8hT3cQ9rV8rZ7hY:vL:bD7w    ','25-749-546-4634','daring depths will unwind finally outside the instructions ;furious pinto should haggle always atop the frets        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1390,'Customer#1390            ',38640.42,2231.4,'IRAN                     ','G7rQ7cM7cR8nP8uE3nY6eP7qC7              ','20-185-735-9297','enticing ideas will wake silently inside the no                                                                      ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(259,'Customer#259             ',38482.2,7806.1,'INDIA                    ','G8wJ6gF8cF5tY8jJ5lV3sL:tV7              ','18-872-176-7654','quiet decoys to believe regularl                                                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1213,'Customer#1213            ',38151.58,5407.64,'UNITED KINGDOM           ','Z1hZ1dD7pJ4fA8vS7pK6oE:dU3iJ6           ','33-839-470-3772','regular sentiments should was thinly about the pinto ?busy sauternes shal                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1459,'Customer#1459            ',37957.5,8898.5,'ROMANIA                  ','E6rK9uZ5kT9wL4xT2mX3pJ7hV3nP:yI2zL7uP7  ','29-324-381-8862','ironic sauternes shall thrash sometimes                                                                              ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(425,'Customer#425             ',37808.56,4911.92,'ETHIOPIA                 ','X8wR3iC5wN:jG6hX6mK8cT5o                ','15-932-835-2649','ironic players will use enticingly by the theodolites :thin courts may poach slowly in the courts ?bu                ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1063,'Customer#1063            ',37200,7791.78,'ALGERIA                  ','L8kA9rB7qN8lE3sR6pO8cP4zI8aA1fC5xT4     ','10-804-915-5389','ruthless attainments should detect carefully according the dugouts                                                   ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(562,'Customer#562             ',36538.94,1203.74,'VIETNAM                  ','Z2mA5tC6xR5jU2pM:tV4rO1iQ5mS            ','31-754-556-8535','blithe hockey should hang doggedly throughout the pains ;ruthless dependencies have promise t                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1274,'Customer#1274            ',36498,9445.82,'RUSSIA                   ','F8zC3sV4vT6kC:gW8qX2hY3kC2lV8kL9xA2e    ','32-250-676-9445','quiet pearls shall integrate quickly beside the excu                                                                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(997,'Customer#997             ',36185.37,6061.6,'KENYA                    ','O9uC5mX7uU1uK3aK5tA8dP2iC2cV6yJ         ','24-921-840-3556','sly realms could thrash ruthlessly of the frays :ironic frays to was slyly over the orbi                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(473,'Customer#473             ',35792.36,8747.84,'CANADA                   ','C8bM7cB7oD9t                            ','13-342-488-4051','busy dugouts must solve ironically throughout the dugouts ?fluffy platelets                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1223,'Customer#1223            ',35758.8,5798.03,'CANADA                   ','O6vE9sH6gJ2dK6uV:fA2pF1zA:              ','13-727-132-7559','idle realms shall serve evenly to the pains !close warhorses to unwind fluffily despite the decoys .c                ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1271,'Customer#1271            ',35540.8,9888.44,'CANADA                   ','W8aG1eW6hV8xK7fR4xP:gD                  ','13-409-460-1445','idle sentiments might haggle re                                                                                      ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(370,'Customer#370             ',35343.99,-632.94,'BRAZIL                   ','N3wG6vI9gW5iJ8kW1aQ9lG5sR1jJ            ','12-572-725-5626','bold multipliers can hinder ruthlessly toward the realms --furious wa                                                ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1316,'Customer#1316            ',35245.9,3587.18,'ROMANIA                  ','R4dJ3tP6pA3                             ','29-645-387-9631','thin frays might nod closely between                                                                                 ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1154,'Customer#1154            ',35197.36,-218.92,'MOROCCO                  ','Z5jK:lD6bW2iE7fT8xA                     ','25-129-618-5381','dogged warthogs can play permanently of the ideas .final pe                                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(67,'Customer#67              ',34737.36,8172.61,'CANADA                   ','V7lI2tW3qM4jM9kW9vR8mM2o                ','13-577-170-7250','dogged foxes shall run ironically place the braids !sly warhorses would dazzle si                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1292,'Customer#1292            ',34307.01,8501.15,'ROMANIA                  ','R:cN3tP2bK3lY:sX:                       ','29-881-684-5642','ironic forges have lose slyly durin                                                                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(160,'Customer#160             ',33976.8,4969.08,'JAPAN                    ','C2sN4jD1xW1zK1oO:oM:oV8dM4uY5           ','22-488-321-2781','bold warthogs should doze slyly alo                                                                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1309,'Customer#1309            ',33120,7850.84,'ARGENTINA                ','Q9aD5nP1cK:                             ','11-278-323-1610','permanent sentiments must believe never beneath the notornis ;silent pains could play iron                           ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(419,'Customer#419             ',31302.42,5190.44,'KENYA                    ','O7eL9cU:cR6sP7yF8aE6                    ','24-903-970-8504','sly realms will breach stealthily inside the decoys ;close decoys migh                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1204,'Customer#1204            ',31129.98,2002.79,'ETHIOPIA                 ','R8iE4jR7dL4aD3zK9xP7uO1xO5kG8           ','15-888-955-6419','busy patterns have maintain ironically near the pearls !permanent notornis might run ironic                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(317,'Customer#317             ',30758.5,5179.11,'VIETNAM                  ','O7eY3mH7dB1dP2zE6rS:oA1pG:zN2qJ         ','31-728-228-1858','idle courts to engage fluffily through the dolph                                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1493,'Customer#1493            ',30201,978.85,'EGYPT                    ','Y8dP8kS6aV3jG7aK7oN:dK9hT               ','14-729-559-2436','thin frays to hang permanently through                                                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(752,'Customer#752             ',28992.6,6029.41,'JAPAN                    ','F3jW4bQ3hX2nC3kI:tB6cS7jX7x             ','22-419-340-9398','furious dugouts ought lose fluffily over the orbits ?sly pe                                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(457,'Customer#457             ',28916.1,6196.85,'KENYA                    ','A8lM6gH8jH7gK5lM6yH7gK6iY5              ','24-374-581-9612','daring forges to lose permanently according the pinto .permanent foxes to kindle always after the b                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1145,'Customer#1145            ',28423,3528.98,'RUSSIA                   ','C8uF4vB3lA4mJ:cP2mB9pZ5uG9uP3iT         ','32-141-379-2479','ruthless foxes ought maintain ruthlessly of the tithes ?ironic dependencies would breach doggedly t                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1318,'Customer#1318            ',28049.49,9435.42,'UNITED STATES            ','R7zK2fR4lG:gZ8                          ','34-889-418-3436','idle beans can thrash fluffily on the patterns ?enticing dependencies would engage                                   ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(704,'Customer#704             ',28002.6,6748.98,'MOZAMBIQUE               ','Q3kI5xN9rJ7tZ1xH7kI8uH6xM               ','26-853-945-8204','furious Tiresias have impress evenly inside the pearls ?busy frays to breach silently before the players             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(961,'Customer#961             ',27738.46,7563.73,'CHINA                    ','N5iL2hY3cE8pN3lA4o                      ','28-902-348-9183','close braids do play closely over the dolphins :ruthless patterns have believe evenly except the dugouts ;perm       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(415,'Customer#415             ',27021.54,212.82,'INDIA                    ','H5wU7nF3pH:mX8jS4jJ6hZ:iM:lE8cP:nJ2     ','18-774-858-9263','brave frets might serve permanently besides the ideas :daring forges may haggle                                      ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(154,'Customer#154             ',26819.1,4008.24,'SAUDI ARABIA             ','J5oQ9wL3rU1sF1kZ1                       ','30-940-413-8230','silent hockey will hang quietly since the warhorses !bold courts                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(578,'Customer#578             ',26707.39,5484.52,'ROMANIA                  ','H6gN9dS4pW5sS                           ','29-995-159-4540','thin warthogs may affix furiously inside the d                                                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(431,'Customer#431             ',25667.1,8764.79,'IRAN                     ','G5cO9yL8sY8rQ2iW9eB7hA7fJ7eF9dJ7rG2oL:mQ','20-932-249-5251','slow pearls could play idly despite the asymptotes :brave instructions can hinder thinly by                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(155,'Customer#155             ',24321.33,-804.86,'PERU                     ','A6cR3wP5oM5sB7tY7eO9bI3pD3vD2vX5        ','27-179-352-6611','sly multipliers to breach slowly until the pinto :enticing depths have nod quie                                      ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(805,'Customer#805             ',23696.22,3526.39,'JAPAN                    ','P1nW:zO4mX4sX2yT6wL7fL5mF8zL7kD         ','22-105-944-8640','blithe ideas could engage enticingly toward the gifts ?brave waters will thrash permanently beside the theodolit     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(941,'Customer#941             ',23124.42,4553.86,'JAPAN                    ','S6pA9qL2oW8vB:hF6jB6tP1fE8x             ','22-339-388-9100','quiet attainments to promise enticingly by the notornis --even sauternes could                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(11,'Customer#11              ',23117.76,9399.62,'EGYPT                    ','E7rW1nY4wY2iT8wK7uE6oD2rF3              ','14-200-912-6368','silent somas ought breach closely behind the warhorses ;permanent multipliers shoul                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(863,'Customer#863             ',23078.88,4450.29,'INDONESIA                ','H3vT:lW4eO7dW8bN4xK5xU6pB5uK            ','19-726-318-1021','careful patterns may detect fluffily above the dugouts ?idle attainments might lose always along the courts :f       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(713,'Customer#713             ',22283.1,9476.84,'ARGENTINA                ','W1zY9iW5oN5zD2xF3sM3                    ','11-213-179-4339','regular dolphins shall snooze furious                                                                                ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(167,'Customer#167             ',22069.32,3749.6,'UNITED KINGDOM           ','T2fR5wC:kJ8tI5gS8nH7cS1kD6yQ3aD2mE7bK:d ','33-642-572-1956','permanent warthogs might use sometimes place the sentimen                                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(202,'Customer#202             ',22001.76,2538.84,'MOROCCO                  ','G4vZ8vO5bG2iG9eE6bK6wT9bS4tP4eH8p       ','25-503-156-7794','dogged waters may are quickly by the notornis --busy waters will thrash ironically in the notornis :permanent multi  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(79,'Customer#79              ',20342.84,439.71,'ARGENTINA                ','J4iQ3fM7cV                              ','11-214-631-1526','daring pinto may solve boldly despite the platelets .enticing p                                                      ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(767,'Customer#767             ',19737.2,3565.21,'INDIA                    ','P4fC:oW4lS6aB5jF5wT8dW9sS7hY2dE3d       ','18-487-163-6595','sly sheaves would haggle slyly at the frays                                                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(122,'Customer#122             ',19502.82,8841.77,'ETHIOPIA                 ','S:bH8lY5sS8rV7qL:bC9bN:iH5iA3n          ','15-968-719-2847','ruthless Tiresias might maintain slyly inst                                                                          ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1463,'Customer#1463            ',19173.7,1730.47,'ETHIOPIA                 ','U9gU:uV:eD:yY7oD8aO5u                   ','15-228-666-6023','ruthless pains will maintain quietly beyond the realms .                                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(923,'Customer#923             ',19021.31,6421.35,'IRAQ                     ','M7mE3rO3yY8vL7                          ','21-916-387-1308','brave gifts can lose busily on                                                                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1400,'Customer#1400            ',19010.56,7792.83,'MOZAMBIQUE               ','M4tO3bQ9kN7hS1wE:gS4aF9                 ','26-688-942-4947','blithe instructions shall kindle boldly during the pinto .idle orbits ought haggle blithely besides the excuses ?bus ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1324,'Customer#1324            ',18948,9821.73,'MOROCCO                  ','D5gT4bO5eM3dZ1nR6uW7fG7qO4hH            ','25-700-977-8075','final patterns can nod quickly outside the instructions .careful frets sh                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(604,'Customer#604             ',18212.32,-850.36,'BRAZIL                   ','V6dG5hK8dK3bS7sP:tL9kK2bZ3hG5cD2yJ9i    ','12-674-514-2453','slow pains may kindle slowly past the beans .bold frets must det                                                     ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(953,'Customer#953             ',17822.91,8662.57,'BRAZIL                   ','F5oS6dE4wX4bN4vL6tB1fT1t                ','12-573-586-6503','brave frays have snooze quietly of the ideas --dogged notornis will solve id                                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(40,'Customer#40              ',15732.99,6096.51,'PERU                     ','G6jM1qS:iG4cZ7pY4z                      ','27-193-916-4111','quiet dependencies should sublate slowly except the sheaves --bold                                                   ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(467,'Customer#467             ',15420.7,1191.98,'ROMANIA                  ','F2xA1oI4uF7hP2bQ:oK5kD9dE4wP9           ','29-781-679-5599','blithe waters have are furiously through the epitaphs .dogged patterns                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1087,'Customer#1087            ',14602.38,523.34,'GERMANY                  ','Y:tJ:bA3oM3sM6xB2yA9jL4hR5lN4wO3hD3vB   ','17-631-283-9177','idle players could nod silently beside t                                                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(424,'Customer#424             ',14539.68,9610.63,'SAUDI ARABIA             ','C8tF:hA5aF5vY:lI2dI6pS7yM8nI8sN3lZ3oW5  ','30-712-323-1708','quiet orbits to affix furiously in the patterns .careful                                                             ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1340,'Customer#1340            ',13679.64,9582.17,'ALGERIA                  ','I2eS1qG8wC9rF2uN4xW3zV7zP8qG2           ','10-642-770-1185','sly warthogs can mold boldly atop the attainments .quick braids will print thinly i                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(799,'Customer#799             ',13588.8,8990.51,'UNITED STATES            ','W5aT9jV1sP7cP                           ','34-714-644-8520','quiet attainments to believe sometimes inside the e                                                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1181,'Customer#1181            ',13232.97,2091.83,'SAUDI ARABIA             ','K5zA:vW:zI:wQ4                          ','30-586-685-2661','bold warhorses will kindle closely behind the forges !ironic sauternes to integ                                      ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(650,'Customer#650             ',12672,5817.73,'EGYPT                    ','J3qN4uQ1fV4eI4lC4mU1nN3eJ:nG1hK         ','14-537-225-1361','even waters shall integrate slyly of the theodolites !quick realms shall use furiously of                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(400,'Customer#400             ',12411.84,4092.12,'ALGERIA                  ','V5zS9gQ6hH:zP7mS9iF                     ','10-683-668-5604','sly sauternes must x-ray stealthily above the frays .regu                                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(956,'Customer#956             ',12236,3581.52,'ETHIOPIA                 ','B4iT3hF9kL2fW1qO1dA2sJ6tB3qS7wN9rH6n    ','15-270-629-9924','close courts to integrate quickly around the decoys ?daring decoys should impress daringly to                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(389,'Customer#389             ',11978.4,6947.18,'CHINA                    ','A1nF5aF9qR1                             ','28-985-506-4547','even dependencies have was regularly of the realms --sly waters must x-ray sometimes near th                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(568,'Customer#568             ',10291.12,8071.03,'FRANCE                   ','O5fY5vZ4eQ6pA2oY8eQ                     ','16-811-431-3415','fluffy sheaves have poach stealthily to the braids ;ruthless realms ought are                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(461,'Customer#461             ',10081.89,4111.03,'KENYA                    ','X6uE3nB5eT3iL1oD2iZ4bV1iG:mP9r          ','24-562-425-9406','bold tithes shall affix carefully among the asymptotes ?enticing f                                                   ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1348,'Customer#1348            ',7964.67,1754.85,'IRAN                     ','V1uB1wK4mF2mG9eQ4fY8lY6lG3cT2rC:d       ','20-529-203-2998','fluffy players have integrate thinly to the gifts --final sentiments will lose per                                   ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(230,'Customer#230             ',7608,1579.38,'EGYPT                    ','G4oK2fJ:mD1bJ8wR5nR1zV9bE:aQ3r          ','14-942-391-7285','final foxes shall sleep evenly across the pinto !daring forges shall s                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1144,'Customer#1144            ',7215,-145.63,'ROMANIA                  ','B4iY9jZ1jH1aR2qZ:dZ:hZ9qI3vE9c          ','29-533-969-6326','quiet patterns have poach silently from the courts :close players must dazzle rut                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(148,'Customer#148             ',6705,2346.48,'RUSSIA                   ','F3nM7dU5pN7nQ                           ','32-629-897-7992','ruthless waters have eat boldly since the attainments :daring                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(346,'Customer#346             ',6213.24,-835.67,'BRAZIL                   ','S6jX3bX1kA4gV9dJ1tB8yT6rA9aA5fS         ','12-561-117-5833','furious ideas will poach never between the players ?careful Tiresias must na                                         ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(776,'Customer#776             ',6193.46,8262.21,'UNITED KINGDOM           ','F5kD2uY2bI1uK4mI3dW5zO                  ','33-940-987-9696','silent courts to sublate doggedly atop the sentiments ;dogged foxes ha                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(92,'Customer#92              ',5482.8,1766.29,'INDONESIA                ','P:sX6eV6gH4gR8mW2vS6xW5dW               ','19-366-870-5273','close forges must nag sometimes atop the excuses ?furious                                                            ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1351,'Customer#1351            ',5172.75,9530.82,'JAPAN                    ','Y3xT4wJ2eH                              ','22-877-992-3856','silent epitaphs may engage ruthlessly after the attainments .daring beans to eat always above                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(353,'Customer#353             ',4529.25,4070.23,'MOZAMBIQUE               ','M2wQ3tW3eT3jB4dW5gK8lA6lF2              ','26-723-383-9191','regular instructions have hinder furiously according the patt                                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(973,'Customer#973             ',4481.4,2690.65,'ARGENTINA                ','S7lZ3uH6bZ8hA:jW3gG                     ','11-629-192-4765','enticing gifts have wake ruthlessly be                                                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(560,'Customer#560             ',4393.92,1120.44,'ARGENTINA                ','E1tP8gL9mW4dC1                          ','11-725-643-4890','enticing gifts shall was permanently along the braids ?brave tithes to are sly                                       ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(802,'Customer#802             ',3562.6,5343.56,'ETHIOPIA                 ','Y2zM5yM3tU4mE                           ','15-186-147-5112','bold pains might boost furiously except the multipliers :close notornis to su                                        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(130,'Customer#130             ',3085.68,2732.94,'PERU                     ','B5aR4hA2uF2jW1pA:jD7s                   ','27-425-511-4174','careful forges will promise bravely over the forges !silent beans to p                                               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(1250,'Customer#1250            ',2485.36,3729.26,'IRAQ                     ','Q6nW6zW:pS9qF                           ','21-287-131-6600','bold dugouts will mold stealthily before the forg                                                                    ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(746,'Customer#746             ',1366.17,-150.71,'SAUDI ARABIA             ','K:bB9bJ7eS:qU9wZ5                       ','30-844-637-9051','sly realms will sublate thinly of the patterns !permanent dinos have nag blithely b                                  ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(175,'Customer#175             ',1188.46,211.21,'KENYA                    ','X2uY8fF9uM:rB:jB2fY4eO8                 ','24-142-758-3258','quick warthogs shall boost quietly of the theodolites .idle waters shall lose never during the frets :quick p        ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(935,'Customer#935             ',1179.9,-409.98,'RUSSIA                   ','D6nK3zS9vA4tY6lR1zT4lO1v                ','32-385-969-1281','careful patterns should play busily alongside the beans !permanent dugouts to nod idly over the instru               ');
INSERT INTO MS_OUT_Q10(C_CUSTKEY,C_NAME,REVENUE,C_ACCTBAL,N_NAME,C_ADDRESS,C_PHONE,C_COMMENT) VALUES(269,'Customer#269             ',1012.7,7873.36,'ARGENTINA                ','Y:sA6jN3aZ8uR6pD6pA3sC1aO9yB3eZ3zL3     ','11-921-198-9367','daring asymptotes might engage evenly                                                                                ');

DROP TABLE MS_OUT_Q11;

CREATE TABLE MS_OUT_Q11(
	PS_PARTKEY	INTEGER,
	VALUE		NUMERIC
)
;

INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(995,12197508);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(895,11509534);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1588,11438370);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(857,9960286);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1057,9776916);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1362,9480202);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1765,9428982);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1093,9221664);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(48,9152266);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(73,9127769);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(780,9070425);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1620,8893984);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1562,8839176);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(57,8630520);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(661,8541006);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1387,8520672);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(955,8221776);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(320,8165592);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1913,8151622);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(355,8146237);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(692,8045169);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1061,7658718);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1127,7545772);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(176,7516232);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(626,7475253);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1461,7444995);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(700,7431792);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(568,7419880);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1748,7411734);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(872,7384125);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(153,7375676);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(676,7333200);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1799,7309726);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(532,7247094);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1637,7113172);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(785,7104770);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1496,7090191);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1702,7084168);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1862,6987250);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1002,6923860);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(462,6904200);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(174,6809316);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(465,6804168);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(234,6796624);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(799,6663894);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1895,6647985);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1158,6639490);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(322,6536844);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1870,6517494);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1460,6364920);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1186,6330400);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(890,6315017);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(477,6269200);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1161,6268448);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1322,6205400);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(759,6202231);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(837,6190805);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(432,6158460);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1689,6154526);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1471,6069448);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(296,6052991);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1400,6014316);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(37,5979497);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(927,5901912);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1187,5897208);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(222,5877171);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1822,5867715);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(289,5590535);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1476,5586924);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(284,5582143);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1151,5571937);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1399,5561400);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(188,5551317);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1037,5539380);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1842,5536823);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(518,5512860);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(894,5435298);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(922,5394015);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(589,5391981);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(2,5391953);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1484,5387563);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1703,5360220);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1805,5339364);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1848,5248656);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1904,5231436);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1083,5202405);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1157,5179692);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1548,5175328);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1079,5116878);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(567,5065746);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(798,5044794);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(261,5023200);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(403,5009856);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(400,5009121);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1796,4998380);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(99,4896564);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1222,4896099);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(221,4864896);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(990,4844043);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(127,4801380);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1264,4680290);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1992,4649728);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1865,4634135);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(274,4628273);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1375,4569278);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(309,4562264);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1027,4528317);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(32,4526100);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(502,4525010);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1779,4510312);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1720,4500080);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(829,4478500);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(804,4469300);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(197,4464834);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1567,4443100);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1125,4434000);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1744,4417882);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(466,4410888);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(653,4358655);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1774,4344318);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1739,4324320);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(162,4314438);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1092,4304324);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1616,4289040);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1940,4212252);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(848,4182528);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(249,4178940);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(105,4075918);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1013,4069999);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(730,4057232);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(157,4051571);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1448,4046436);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(122,4040400);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(288,4039497);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1423,4017684);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1680,3957537);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(210,3936857);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(171,3917610);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1602,3893344);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(500,3872142);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(456,3862800);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(970,3862446);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(598,3823072);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(630,3664076);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(186,3662880);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(824,3652882);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1357,3642795);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(705,3636128);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1961,3624747);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(494,3558960);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1994,3488458);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(457,3466105);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1737,3456568);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1068,3449057);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1974,3448520);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1786,3418144);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(82,3391968);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1310,3380767);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1880,3334770);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(183,3333750);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1462,3328182);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1837,3321711);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1275,3287368);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(427,3286831);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1781,3283959);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(687,3274278);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1361,3274096);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(761,3261883);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1819,3261187);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1583,3250557);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1598,3236508);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(437,3194286);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(376,3183376);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(208,3135648);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(774,3128874);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1466,3126528);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(486,3067955);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1937,3063945);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(448,3060320);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(334,3039192);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1022,3032748);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1177,3027750);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(757,3000585);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(470,2999988);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1385,2965235);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(305,2926266);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1062,2922601);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1917,2919750);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1537,2913300);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1257,2906136);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(22,2894190);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1663,2883592);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(131,2865972);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1489,2865520);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1450,2864550);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(881,2856615);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(648,2847768);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(696,2824536);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1122,2813658);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1499,2805894);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(135,2783886);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1668,2782538);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(548,2757832);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1905,2731136);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(404,2729595);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(235,2728033);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(7,2714110);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(36,2703504);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(23,2697200);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(389,2691990);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1193,2690172);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(725,2667671);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1662,2647216);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1048,2642952);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(897,2636326);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(587,2622147);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(111,2615510);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1156,2613051);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1922,2578065);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(828,2572668);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1126,2555652);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1347,2538575);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(578,2504652);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1900,2500992);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1198,2499614);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(382,2493045);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(552,2489660);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1657,2463587);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(764,2458720);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(527,2439568);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1422,2435415);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1112,2403456);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(961,2401219);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(956,2380924);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1648,2376410);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1569,2370620);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1681,2358976);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(637,2307294);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1577,2305744);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1299,2296630);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1762,2276542);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(722,2276268);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1162,2261850);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(461,2235348);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(561,2215625);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(12,2201176);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(727,2199798);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(362,2193360);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(855,2191371);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(109,2169132);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(896,2167503);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(883,2134440);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1227,2133297);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1274,2126095);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(262,2125816);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1607,2116352);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(982,2101342);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(501,2092748);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(862,2072502);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(62,2060936);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1121,2047628);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(329,2040596);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(88,2028825);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(631,1973420);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(451,1964640);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(996,1949660);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(794,1911916);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1715,1902414);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1197,1899123);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1148,1852506);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1327,1810704);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1521,1799850);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1719,1781340);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(136,1774374);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(937,1772529);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(367,1768410);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1578,1749195);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(227,1744584);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1754,1744176);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(248,1727733);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1861,1719144);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1622,1714275);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1676,1691811);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1382,1665420);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(537,1662975);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1970,1649960);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1582,1611383);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(627,1594082);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1386,1592878);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(827,1591584);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(390,1583661);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(762,1571776);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(348,1555296);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(203,1548288);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1627,1515596);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(903,1515468);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1891,1509912);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(187,1460475);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1101,1447725);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(306,1430082);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1285,1427235);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1852,1410736);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1543,1406064);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1687,1400612);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(269,1389224);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1261,1386438);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(393,1382050);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1918,1372290);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1927,1342575);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1597,1335600);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1500,1327207);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(688,1327200);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1262,1316232);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(78,1311920);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(361,1299276);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1294,1288904);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(480,1271417);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(207,1266551);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1757,1257480);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1088,1242935);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(419,1228797);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(729,1226648);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1764,1224493);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(295,1224252);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1682,1203761);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(822,1186332);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1646,1184719);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(372,1173279);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(254,1172010);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(491,1131549);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(657,1126400);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1722,1125009);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(52,1124305);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1427,1120548);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(148,1107174);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1237,1082073);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1948,1081572);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1769,1080644);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(914,1076616);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1225,1070420);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1289,1062320);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(617,1049601);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(507,1016548);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1790,1005158);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(327,1003102);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1885,996628);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(365,996147);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1641,992712);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(870,991460);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(230,969728);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1291,967833);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1249,966144);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1877,965600);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1818,958342);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1558,956175);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(557,943014);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1935,934080);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(923,920028);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1962,918662);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(989,900420);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1323,891335);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(791,884304);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1457,865303);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1981,863406);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1957,855813);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(962,818016);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1288,814096);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(137,811566);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(991,806420);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1661,783156);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(796,758160);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1501,756462);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(928,745052);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(716,744709);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1804,741114);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1697,737870);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(957,734700);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1053,729312);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(754,726088);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1487,725722);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(994,701143);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(47,694212);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(622,689584);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1706,683928);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(350,679470);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(531,633500);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1517,630112);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1522,621980);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1224,612560);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(61,605948);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1778,597132);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1984,588060);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(606,585480);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(101,579040);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1211,566020);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1348,560696);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1621,559482);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1975,552508);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(593,549618);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(562,541696);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(563,541476);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1656,534316);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1966,527460);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(86,521400);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(981,520004);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1058,510260);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(275,509250);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1876,494912);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(658,489090);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(337,486270);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1319,476770);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1220,445556);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1096,443700);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1395,428835);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(422,417312);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1485,416650);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1872,416256);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(11,416130);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(861,412128);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1192,404420);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1409,400197);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1727,394680);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1137,391776);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1360,372120);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1527,366930);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(815,365364);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(960,365120);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1337,364514);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1761,362700);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(433,352495);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1814,347778);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(662,331840);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1803,324280);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1950,320304);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(793,318045);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1166,309127);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(428,305368);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1286,304780);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(592,299250);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(666,293544);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1097,288120);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(679,283390);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1698,280176);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1284,279336);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1480,259119);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(237,253396);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1184,251292);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1445,249626);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1827,241000);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(522,240974);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1173,234009);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(591,228144);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1163,219139);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(87,209484);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1601,206336);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1373,204980);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(668,204422);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1557,199080);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1971,198786);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(264,196272);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1298,192346);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(490,184664);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(693,181722);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1072,180264);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1248,170542);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1857,169425);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(769,166440);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(333,147354);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(1979,146664);
INSERT INTO MS_OUT_Q11(PS_PARTKEY,VALUE) VALUES(163,140650);

DROP TABLE MS_OUT_Q12;

CREATE TABLE MS_OUT_Q12(
	L_SHIPMODE	VARCHAR(10),
	HIGH_LINE_COUNT NUMERIC,
	LOW_LINE_COUNT	NUMERIC
)
;

INSERT INTO MS_OUT_Q12(L_SHIPMODE,HIGH_LINE_COUNT,LOW_LINE_COUNT) VALUES('MAIL      ',62,95);
INSERT INTO MS_OUT_Q12(L_SHIPMODE,HIGH_LINE_COUNT,LOW_LINE_COUNT) VALUES('SHIP      ',55,92);

DROP TABLE MS_OUT_Q13;

CREATE TABLE MS_OUT_Q13(
	C_COUNT		NUMERIC,
	CUSTDIST	NUMERIC
)
;

INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(0,500);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(16,111);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(15,101);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(14,98);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(13,91);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(12,74);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(17,73);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(11,70);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(19,68);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(18,64);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(10,53);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(20,39);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(9,36);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(21,26);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(22,24);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(8,18);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(24,14);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(23,13);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(7,9);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(6,6);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(25,4);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(26,3);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(5,3);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(28,1);
INSERT INTO MS_OUT_Q13(C_COUNT,CUSTDIST) VALUES(4,1);

DROP TABLE MS_OUT_Q14;

CREATE TABLE MS_OUT_Q14(
	PROMO_REVENUE	NUMERIC
)
;

INSERT INTO MS_OUT_Q14(PROMO_REVENUE) VALUES(15.1104);

DROP TABLE MS_OUT_Q15;

CREATE TABLE MS_OUT_Q15(
	S_SUPPKEY	INTEGER,
	S_NAME		VARCHAR(25),
	S_ADDRESS	VARCHAR(40),
	S_PHONE		VARCHAR(15),
	TOTAL_REVENUE	NUMERIC
)
;

INSERT INTO MS_OUT_Q15(S_SUPPKEY,S_NAME,S_ADDRESS,S_PHONE,TOTAL_REVENUE) VALUES(15,'Supplier#15              ','V6zB9vU:jI9vQ7nS:aT9tT2pS:','22-384-589-2784',1444981.78);

DROP TABLE MS_OUT_Q16;

CREATE TABLE MS_OUT_Q16(
	P_BRAND		VARCHAR(10),
	P_TYPE		VARCHAR(25),
	P_SIZE		INTEGER,
	SUPPLIER_CNT	INTEGER
)
;

INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#31  ','SMALL BURNISHED STEEL    ',3 ,8);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#11  ','LARGE POLISHED TIN       ',3 ,7);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#11  ','ECONOMY POLISHED BRASS   ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#11  ','ECONOMY POLISHED STEEL   ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#11  ','ECONOMY POLISHED STEEL   ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#11  ','LARGE ANODIZED NICKEL    ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#11  ','LARGE BURNISHED TIN      ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#11  ','MEDIUM PLATED STEEL      ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#11  ','PROMO POLISHED STEEL     ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#11  ','SMALL BRUSHED COPPER     ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#11  ','SMALL BURNISHED NICKEL   ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#11  ','STANDARD POLISHED COPPER ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#11  ','STANDARD POLISHED TIN    ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#12  ','ECONOMY BRUSHED STEEL    ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#12  ','ECONOMY BURNISHED COPPER ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#12  ','LARGE ANODIZED COPPER    ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#12  ','LARGE BURNISHED NICKEL   ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#12  ','MEDIUM BURNISHED STEEL   ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#12  ','PROMO ANODIZED COPPER    ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#12  ','PROMO BURNISHED COPPER   ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#12  ','PROMO POLISHED BRASS     ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#12  ','PROMO POLISHED NICKEL    ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#12  ','SMALL ANODIZED NICKEL    ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#12  ','SMALL BRUSHED NICKEL     ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#12  ','SMALL POLISHED BRASS     ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#12  ','STANDARD ANODIZED NICKEL ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#12  ','STANDARD POLISHED COPPER ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#13  ','LARGE PLATED STEEL       ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#13  ','MEDIUM BRUSHED STEEL     ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#13  ','MEDIUM BRUSHED TIN       ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#13  ','PROMO POLISHED COPPER    ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#13  ','SMALL PLATED BRASS       ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#13  ','SMALL PLATED TIN         ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#13  ','STANDARD BURNISHED BRASS ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#13  ','STANDARD BURNISHED COPPER',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','ECONOMY ANODIZED BRASS   ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','ECONOMY ANODIZED COPPER  ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','ECONOMY BRUSHED TIN      ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','ECONOMY BURNISHED STEEL  ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','LARGE BURNISHED COPPER   ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','MEDIUM ANODIZED COPPER   ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','PROMO ANODIZED NICKEL    ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','PROMO ANODIZED TIN       ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','SMALL ANODIZED NICKEL    ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','SMALL ANODIZED TIN       ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','SMALL BRUSHED TIN        ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','SMALL BURNISHED STEEL    ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','SMALL POLISHED NICKEL    ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','STANDARD ANODIZED TIN    ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','STANDARD BURNISHED COPPER',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','STANDARD PLATED TIN      ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','STANDARD POLISHED BRASS  ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#14  ','STANDARD POLISHED NICKEL ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#15  ','ECONOMY BURNISHED NICKEL ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#15  ','LARGE BRUSHED TIN        ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#15  ','LARGE POLISHED BRASS     ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#15  ','MEDIUM ANODIZED COPPER   ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#15  ','MEDIUM BURNISHED TIN     ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#15  ','MEDIUM PLATED STEEL      ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#15  ','MEDIUM PLATED TIN        ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#15  ','SMALL ANODIZED COPPER    ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#15  ','SMALL BRUSHED BRASS      ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#15  ','SMALL BRUSHED STEEL      ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#15  ','SMALL POLISHED BRASS     ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#15  ','STANDARD PLATED TIN      ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#15  ','STANDARD POLISHED TIN    ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#21  ','LARGE PLATED BRASS       ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#21  ','LARGE POLISHED STEEL     ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#21  ','MEDIUM ANODIZED STEEL    ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#21  ','MEDIUM BRUSHED BRASS     ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#21  ','MEDIUM BRUSHED STEEL     ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#21  ','MEDIUM PLATED STEEL      ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#21  ','PROMO ANODIZED BRASS     ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#21  ','PROMO ANODIZED TIN       ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#21  ','SMALL POLISHED BRASS     ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#21  ','SMALL POLISHED STEEL     ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#21  ','SMALL POLISHED STEEL     ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#21  ','STANDARD ANODIZED BRASS  ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#21  ','STANDARD BRUSHED TIN     ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#21  ','STANDARD PLATED COPPER   ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#21  ','STANDARD POLISHED COPPER ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#22  ','ECONOMY ANODIZED BRASS   ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#22  ','ECONOMY BRUSHED TIN      ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#22  ','LARGE PLATED TIN         ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#22  ','LARGE POLISHED STEEL     ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#22  ','MEDIUM PLATED BRASS      ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#22  ','PROMO BRUSHED TIN        ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#22  ','PROMO PLATED NICKEL      ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#22  ','STANDARD BRUSHED COPPER  ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#22  ','STANDARD BURNISHED BRASS ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#23  ','LARGE ANODIZED COPPER    ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#23  ','LARGE BURNISHED NICKEL   ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#23  ','LARGE POLISHED TIN       ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#23  ','MEDIUM BURNISHED COPPER  ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#23  ','MEDIUM PLATED NICKEL     ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#23  ','PROMO BURNISHED TIN      ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#23  ','PROMO PLATED STEEL       ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#23  ','PROMO PLATED TIN         ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#23  ','SMALL BRUSHED COPPER     ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#23  ','SMALL PLATED NICKEL      ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#23  ','STANDARD ANODIZED BRASS  ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#24  ','ECONOMY BURNISHED NICKEL ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#24  ','PROMO ANODIZED COPPER    ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#24  ','PROMO BRUSHED NICKEL     ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#24  ','SMALL BURNISHED TIN      ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#24  ','SMALL POLISHED COPPER    ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#24  ','STANDARD POLISHED NICKEL ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#25  ','ECONOMY POLISHED NICKEL  ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#25  ','LARGE PLATED BRASS       ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#25  ','MEDIUM BURNISHED COPPER  ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#25  ','PROMO ANODIZED STEEL     ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#25  ','PROMO BRUSHED BRASS      ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#25  ','PROMO BURNISHED TIN      ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#25  ','PROMO POLISHED NICKEL    ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#25  ','SMALL POLISHED BRASS     ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#25  ','STANDARD ANODIZED NICKEL ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#25  ','STANDARD BURNISHED BRASS ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#31  ','ECONOMY PLATED NICKEL    ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#31  ','ECONOMY POLISHED COPPER  ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#31  ','LARGE BURNISHED NICKEL   ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#31  ','LARGE POLISHED TIN       ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#31  ','MEDIUM BRUSHED STEEL     ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#31  ','PROMO BURNISHED TIN      ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#31  ','PROMO POLISHED STEEL     ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#31  ','SMALL BURNISHED COPPER   ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#31  ','STANDARD BRUSHED NICKEL  ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#31  ','STANDARD BURNISHED COPPER',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#32  ','ECONOMY BURNISHED BRASS  ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#32  ','ECONOMY POLISHED NICKEL  ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#32  ','ECONOMY POLISHED STEEL   ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#32  ','LARGE ANODIZED COPPER    ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#32  ','LARGE PLATED NICKEL      ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#32  ','PROMO PLATED STEEL       ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#32  ','PROMO POLISHED NICKEL    ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#32  ','SMALL ANODIZED NICKEL    ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#32  ','SMALL ANODIZED TIN       ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#32  ','SMALL BRUSHED TIN        ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#32  ','SMALL POLISHED BRASS     ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#32  ','SMALL POLISHED NICKEL    ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#32  ','SMALL POLISHED STEEL     ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#33  ','ECONOMY BURNISHED COPPER ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#33  ','LARGE BURNISHED TIN      ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#33  ','LARGE PLATED NICKEL      ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#33  ','MEDIUM ANODIZED COPPER   ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#33  ','PROMO ANODIZED BRASS     ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#33  ','PROMO BRUSHED NICKEL     ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#33  ','PROMO POLISHED NICKEL    ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#33  ','STANDARD ANODIZED BRASS  ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#34  ','LARGE ANODIZED NICKEL    ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#34  ','LARGE ANODIZED TIN       ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#34  ','LARGE BURNISHED TIN      ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#34  ','LARGE PLATED TIN         ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#34  ','MEDIUM ANODIZED NICKEL   ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#34  ','MEDIUM BURNISHED STEEL   ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#34  ','MEDIUM PLATED STEEL      ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#34  ','PROMO ANODIZED BRASS     ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#34  ','PROMO POLISHED NICKEL    ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#34  ','SMALL PLATED BRASS       ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#34  ','SMALL PLATED COPPER      ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#34  ','SMALL POLISHED TIN       ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#34  ','STANDARD POLISHED NICKEL ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#35  ','ECONOMY POLISHED NICKEL  ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#35  ','LARGE ANODIZED TIN       ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#35  ','LARGE BRUSHED BRASS      ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#35  ','MEDIUM BRUSHED TIN       ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#35  ','PROMO POLISHED NICKEL    ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#35  ','SMALL PLATED BRASS       ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#35  ','SMALL PLATED NICKEL      ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#35  ','STANDARD POLISHED BRASS  ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#41  ','ECONOMY ANODIZED NICKEL  ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#41  ','ECONOMY BURNISHED NICKEL ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#41  ','LARGE ANODIZED BRASS     ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#41  ','LARGE ANODIZED COPPER    ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#41  ','LARGE BURNISHED TIN      ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#41  ','LARGE PLATED TIN         ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#41  ','LARGE POLISHED TIN       ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#41  ','MEDIUM ANODIZED COPPER   ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#41  ','SMALL ANODIZED TIN       ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#41  ','SMALL PLATED NICKEL      ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#41  ','STANDARD ANODIZED BRASS  ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#41  ','STANDARD BURNISHED TIN   ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#42  ','ECONOMY BURNISHED COPPER ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#42  ','ECONOMY BURNISHED COPPER ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#42  ','LARGE BURNISHED COPPER   ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#42  ','LARGE POLISHED BRASS     ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#42  ','PROMO PLATED TIN         ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#42  ','PROMO POLISHED BRASS     ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#42  ','SMALL BRUSHED COPPER     ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#42  ','SMALL BURNISHED BRASS    ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#42  ','SMALL POLISHED BRASS     ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#42  ','STANDARD ANODIZED BRASS  ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#42  ','STANDARD BRUSHED COPPER  ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#42  ','STANDARD PLATED NICKEL   ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#43  ','LARGE BRUSHED TIN        ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#43  ','LARGE POLISHED TIN       ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#43  ','PROMO BRUSHED BRASS      ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#43  ','SMALL BRUSHED STEEL      ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#43  ','SMALL POLISHED BRASS     ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#43  ','STANDARD ANODIZED TIN    ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#44  ','ECONOMY BURNISHED COPPER ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#44  ','ECONOMY BURNISHED NICKEL ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#44  ','ECONOMY POLISHED COPPER  ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#44  ','LARGE ANODIZED NICKEL    ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#44  ','LARGE BRUSHED BRASS      ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#44  ','PROMO ANODIZED STEEL     ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#44  ','PROMO BRUSHED BRASS      ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#44  ','PROMO PLATED TIN         ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#44  ','PROMO POLISHED COPPER    ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#44  ','SMALL ANODIZED BRASS     ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#44  ','SMALL BURNISHED TIN      ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#44  ','STANDARD BRUSHED BRASS   ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#44  ','STANDARD POLISHED BRASS  ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#51  ','ECONOMY PLATED NICKEL    ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#51  ','LARGE PLATED BRASS       ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#51  ','MEDIUM ANODIZED NICKEL   ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#51  ','PROMO ANODIZED NICKEL    ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#51  ','PROMO BRUSHED BRASS      ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#51  ','PROMO POLISHED STEEL     ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#51  ','SMALL BRUSHED COPPER     ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#51  ','STANDARD POLISHED COPPER ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#52  ','ECONOMY BRUSHED BRASS    ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#52  ','ECONOMY BRUSHED STEEL    ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#52  ','ECONOMY BRUSHED TIN      ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#52  ','ECONOMY POLISHED COPPER  ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#52  ','LARGE BRUSHED STEEL      ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#52  ','LARGE BRUSHED TIN        ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#52  ','MEDIUM BURNISHED COPPER  ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#52  ','PROMO PLATED COPPER      ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#52  ','SMALL PLATED STEEL       ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#52  ','STANDARD POLISHED TIN    ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#53  ','ECONOMY ANODIZED BRASS   ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#53  ','ECONOMY BURNISHED BRASS  ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#53  ','ECONOMY PLATED COPPER    ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#53  ','LARGE BRUSHED BRASS      ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#53  ','LARGE PLATED STEEL       ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#53  ','MEDIUM ANODIZED TIN      ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#53  ','MEDIUM BRUSHED BRASS     ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#53  ','SMALL PLATED TIN         ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#53  ','SMALL PLATED TIN         ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#53  ','STANDARD BURNISHED STEEL ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#54  ','LARGE BRUSHED BRASS      ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#54  ','MEDIUM BRUSHED BRASS     ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#54  ','MEDIUM BURNISHED STEEL   ',45,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#54  ','STANDARD ANODIZED BRASS  ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#54  ','STANDARD ANODIZED NICKEL ',49,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#54  ','STANDARD PLATED STEEL    ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#55  ','ECONOMY ANODIZED NICKEL  ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#55  ','LARGE PLATED BRASS       ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#55  ','LARGE POLISHED STEEL     ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#55  ','MEDIUM BRUSHED COPPER    ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#55  ','MEDIUM BURNISHED TIN     ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#55  ','PROMO BRUSHED TIN        ',23,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#55  ','PROMO BURNISHED BRASS    ',36,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#55  ','PROMO BURNISHED COPPER   ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#55  ','PROMO PLATED TIN         ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#55  ','SMALL ANODIZED NICKEL    ',3 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#55  ','SMALL BRUSHED STEEL      ',14,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#55  ','STANDARD BRUSHED TIN     ',19,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#55  ','STANDARD PLATED COPPER   ',9 ,4);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#21  ','STANDARD POLISHED BRASS  ',19,3);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#22  ','LARGE POLISHED STEEL     ',23,3);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#23  ','ECONOMY POLISHED COPPER  ',49,3);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#24  ','ECONOMY BURNISHED TIN    ',9 ,3);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#31  ','ECONOMY BURNISHED BRASS  ',3 ,3);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#33  ','SMALL BRUSHED TIN        ',14,3);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#34  ','STANDARD BRUSHED TIN     ',19,3);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#34  ','STANDARD BURNISHED COPPER',49,3);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#41  ','SMALL BRUSHED BRASS      ',9 ,3);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#42  ','LARGE POLISHED NICKEL    ',9 ,3);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#42  ','MEDIUM BURNISHED STEEL   ',9 ,3);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#53  ','ECONOMY POLISHED COPPER  ',14,3);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#53  ','MEDIUM ANODIZED TIN      ',23,3);
INSERT INTO MS_OUT_Q16(P_BRAND,P_TYPE,P_SIZE,SUPPLIER_CNT) VALUES('Brand#53  ','MEDIUM BRUSHED TIN       ',14,3);

DROP TABLE MS_OUT_Q17;

CREATE TABLE MS_OUT_Q17(
	AVG_YEARLY	NUMERIC
)
;

INSERT INTO MS_OUT_Q17(AVG_YEARLY) VALUES(9872.7143);

DROP TABLE MS_OUT_Q18;

CREATE TABLE MS_OUT_Q18(
	C_NAME		VARCHAR(25),
	C_CUSTKEY	INTEGER,
	O_ORDERKEY	INTEGER,
	O_ORDERDATE	DATE,
	O_TOTALPRICE	NUMERIC,
	SUM_L_QUANTITY	NUMERIC
)
;

INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1481            ',1481,44356,stringdate('1996.06.29 00:00.00 000000'),450731.37,293);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#739             ',739,46180,stringdate('1993.06.07 00:00.00 000000'),429105.17,270);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#14              ',14,29988,stringdate('1998.04.20 00:00.00 000000'),424767.04,269);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1321            ',1321,3681,stringdate('1996.12.20 00:00.00 000000'),421769.33,251);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#349             ',349,56419,stringdate('1996.01.08 00:00.00 000000'),405538.93,254);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1363            ',1363,19688,stringdate('1992.01.08 00:00.00 000000'),404735.84,274);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1429            ',1429,19493,stringdate('1995.08.21 00:00.00 000000'),404289.97,283);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1351            ',1351,50945,stringdate('1993.02.23 00:00.00 000000'),402751.84,266);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#956             ',956,33989,stringdate('1993.03.09 00:00.00 000000'),400783.9,276);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1006            ',1006,27041,stringdate('1996.01.22 00:00.00 000000'),397827.54,251);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#508             ',508,18823,stringdate('1996.12.26 00:00.00 000000'),396988.95,264);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#257             ',257,18661,stringdate('1997.01.09 00:00.00 000000'),396949.22,271);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#358             ',358,11333,stringdate('1995.11.29 00:00.00 000000'),396638.02,265);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#98              ',98,15842,stringdate('1997.12.29 00:00.00 000000'),395006.71,261);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1120            ',1120,31523,stringdate('1993.01.12 00:00.00 000000'),392646.98,265);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#605             ',605,34244,stringdate('1993.11.24 00:00.00 000000'),383813.43,251);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1192            ',1192,19813,stringdate('1994.06.18 00:00.00 000000'),380702.44,258);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#895             ',895,48229,stringdate('1992.06.30 00:00.00 000000'),378989.6,286);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1471            ',1471,12006,stringdate('1996.03.08 00:00.00 000000'),378608.34,257);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#344             ',344,55720,stringdate('1997.03.17 00:00.00 000000'),377628.66,263);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#286             ',286,38,stringdate('1995.06.07 00:00.00 000000'),374745.96,255);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#490             ',490,19107,stringdate('1996.08.12 00:00.00 000000'),369713.22,266);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1442            ',1442,21507,stringdate('1994.02.04 00:00.00 000000'),369693.84,253);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1478            ',1478,43461,stringdate('1996.11.28 00:00.00 000000'),367039.87,279);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#650             ',650,54599,stringdate('1996.07.20 00:00.00 000000'),365576.9,260);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#82              ',82,56514,stringdate('1998.01.19 00:00.00 000000'),365546.86,268);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#517             ',517,8196,stringdate('1992.06.07 00:00.00 000000'),365171.89,269);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#446             ',446,34759,stringdate('1994.05.27 00:00.00 000000'),364572.73,281);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#758             ',758,11841,stringdate('1996.03.02 00:00.00 000000'),364200.28,251);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#304             ',304,43300,stringdate('1996.02.18 00:00.00 000000'),362109.1,261);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#340             ',340,8133,stringdate('1994.04.01 00:00.00 000000'),360899.87,271);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#808             ',808,56102,stringdate('1995.12.02 00:00.00 000000'),360798.75,253);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#877             ',877,31777,stringdate('1995.08.29 00:00.00 000000'),360492.25,258);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1112            ',1112,10631,stringdate('1996.01.15 00:00.00 000000'),359342.48,252);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#832             ',832,59558,stringdate('1995.06.08 00:00.00 000000'),358063.35,274);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#506             ',506,45319,stringdate('1997.02.14 00:00.00 000000'),356384.67,275);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1372            ',1372,11747,stringdate('1993.07.04 00:00.00 000000'),355188.31,253);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#542             ',542,52838,stringdate('1997.04.02 00:00.00 000000'),354017.29,252);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#433             ',433,51559,stringdate('1993.08.24 00:00.00 000000'),349829.48,263);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#644             ',644,43970,stringdate('1994.02.10 00:00.00 000000'),347835.15,263);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#751             ',751,38659,stringdate('1993.12.04 00:00.00 000000'),347037.31,258);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#796             ',796,39617,stringdate('1995.05.06 00:00.00 000000'),345883.88,252);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#58              ',58,25699,stringdate('1995.12.22 00:00.00 000000'),344658.86,256);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#839             ',839,34597,stringdate('1997.06.19 00:00.00 000000'),342845.45,254);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#442             ',442,44259,stringdate('1998.01.15 00:00.00 000000'),341939.36,304);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#274             ',274,7361,stringdate('1995.11.09 00:00.00 000000'),341101.63,263);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#568             ',568,1349,stringdate('1992.03.26 00:00.00 000000'),340390.57,268);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#341             ',341,22566,stringdate('1993.09.11 00:00.00 000000'),339268.36,264);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1190            ',1190,29956,stringdate('1994.05.23 00:00.00 000000'),335862.66,254);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#16              ',16,47300,stringdate('1992.01.11 00:00.00 000000'),332983.14,255);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#761             ',761,31365,stringdate('1995.04.09 00:00.00 000000'),328934.84,265);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#554             ',554,23461,stringdate('1997.10.29 00:00.00 000000'),327547.29,252);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#142             ',142,30439,stringdate('1992.03.01 00:00.00 000000'),325742.95,259);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#251             ',251,31974,stringdate('1994.02.17 00:00.00 000000'),322435.72,254);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#782             ',782,12453,stringdate('1995.12.28 00:00.00 000000'),322259.12,256);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1396            ',1396,42851,stringdate('1992.11.06 00:00.00 000000'),319353.34,252);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#476             ',476,5284,stringdate('1993.08.30 00:00.00 000000'),315339.95,255);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1099            ',1099,46465,stringdate('1998.07.05 00:00.00 000000'),310868.94,254);
INSERT INTO MS_OUT_Q18(C_NAME,C_CUSTKEY,O_ORDERKEY,O_ORDERDATE,O_TOTALPRICE,SUM_L_QUANTITY) VALUES('Customer#1489            ',1489,32165,stringdate('1997.05.29 00:00.00 000000'),299677.33,256);

DROP TABLE MS_OUT_Q19;

CREATE TABLE MS_OUT_Q19(
	REVENUE		NUMERIC
)
;

INSERT INTO MS_OUT_Q19(REVENUE) VALUES(4930.38);

DROP TABLE MS_OUT_Q20;

CREATE TABLE MS_OUT_Q20(
	S_NAME		VARCHAR(25),
	S_ADDRESS	VARCHAR(40)
)
;

INSERT INTO MS_OUT_Q20(S_NAME,S_ADDRESS) VALUES('Supplier#12              ','S1kZ2zS2tI2bM:w');
INSERT INTO MS_OUT_Q20(S_NAME,S_ADDRESS) VALUES('Supplier#60              ','G7kO6oR6bF6oG:xL:lF4c');
INSERT INTO MS_OUT_Q20(S_NAME,S_ADDRESS) VALUES('Supplier#66              ','K8iV8bJ8yU6m');

DROP TABLE MS_OUT_Q21;

CREATE TABLE MS_OUT_Q21(
	S_NAME		VARCHAR(25),
	NUMWAIT		INTEGER
)
;

INSERT INTO MS_OUT_Q21(S_NAME,NUMWAIT) VALUES('Supplier#4               ',14);
INSERT INTO MS_OUT_Q21(S_NAME,NUMWAIT) VALUES('Supplier#71              ',14);
INSERT INTO MS_OUT_Q21(S_NAME,NUMWAIT) VALUES('Supplier#27              ',9);
INSERT INTO MS_OUT_Q21(S_NAME,NUMWAIT) VALUES('Supplier#43              ',8);

DROP TABLE MS_OUT_Q22;

CREATE TABLE MS_OUT_Q22(
	CNTRYCODE	VARCHAR(2),
	NUMCUST		INTEGER,
	TOTACCTBAL	NUMERIC
)
;

INSERT INTO MS_OUT_Q22(CNTRYCODE,NUMCUST,TOTACCTBAL) VALUES('13',11,87376.34);
INSERT INTO MS_OUT_Q22(CNTRYCODE,NUMCUST,TOTACCTBAL) VALUES('17',6,43032.37);
INSERT INTO MS_OUT_Q22(CNTRYCODE,NUMCUST,TOTACCTBAL) VALUES('18',10,66005.15);
INSERT INTO MS_OUT_Q22(CNTRYCODE,NUMCUST,TOTACCTBAL) VALUES('23',12,88920.74);
INSERT INTO MS_OUT_Q22(CNTRYCODE,NUMCUST,TOTACCTBAL) VALUES('29',14,108635.76);
INSERT INTO MS_OUT_Q22(CNTRYCODE,NUMCUST,TOTACCTBAL) VALUES('30',4,27589.26);
INSERT INTO MS_OUT_Q22(CNTRYCODE,NUMCUST,TOTACCTBAL) VALUES('31',8,59810.73);

