/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.script.Token;
import org.jmol.shape.Shape;
import org.jmol.shapespecial.Dipole;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public class Dipoles
extends Shape {
    static final short DEFAULT_MAD = 5;
    static final float DEFAULT_OFFSETSIDE = 0.4f;
    int dipoleCount = 0;
    Dipole[] dipoles = new Dipole[4];
    private Dipole currentDipole;
    private Dipole tempDipole;
    private Point3f startCoord = new Point3f();
    private Point3f endCoord = new Point3f();
    private float dipoleValue;
    private boolean isUserValue;
    private boolean isBond;
    private boolean iHaveTwoEnds;
    private int atomIndex1;
    private int atomIndex2;
    private short colix;
    private Vector3f calculatedDipole;
    private String wildID;
    private static final float E_ANG_PER_DEBYE = 0.208194f;

    public void setProperty(String string, Object object, BitSet bitSet) {
        BitSet bitSet2;
        if ("init" == string) {
            this.tempDipole = new Dipole();
            this.tempDipole.dipoleValue = 1.0f;
            this.tempDipole.mad = (short)5;
            this.atomIndex1 = -1;
            this.tempDipole.modelIndex = -1;
            this.dipoleValue = 0.0f;
            this.calculatedDipole = null;
            this.iHaveTwoEnds = false;
            this.isBond = false;
            this.isUserValue = false;
            if (this.currentDipole != null) {
                Logger.debug("current dipole: " + this.currentDipole.thisID);
            }
            return;
        }
        if ("calculate" == string) {
            this.calculatedDipole = this.viewer.calculateMolecularDipole();
            Logger.info("calculated molecular dipole = " + this.calculatedDipole + " " + (this.calculatedDipole == null ? "" : "" + this.calculatedDipole.length()));
            return;
        }
        if ("thisID" == string) {
            this.wildID = null;
            String string2 = (String)object;
            if (string2 == null || TextFormat.isWild(string2)) {
                this.currentDipole = null;
                if (string2 != null) {
                    this.wildID = string2.toUpperCase();
                }
                return;
            }
            this.currentDipole = this.findDipole(string2);
            if (this.currentDipole == null) {
                this.currentDipole = this.allocDipole(string2, "");
            }
            Logger.debug("current dipole now " + this.currentDipole.thisID);
            this.tempDipole = this.currentDipole;
            if (string2.equals("molecular")) {
                Vector3f vector3f = this.calculatedDipole;
                if (vector3f == null) {
                    vector3f = this.viewer.getModelDipole();
                    Logger.info("file molecular dipole = " + vector3f + " " + (vector3f != null ? "" + vector3f.length() : ""));
                }
                if (vector3f == null) {
                    this.calculatedDipole = vector3f = this.viewer.calculateMolecularDipole();
                }
                if (vector3f == null) {
                    Logger.warn("No molecular dipole found for this model; setting to {0 0 0}");
                    vector3f = new Vector3f();
                }
                this.tempDipole.set(new Point3f(0.0f, 0.0f, 0.0f), new Vector3f(-vector3f.x, -vector3f.y, -vector3f.z));
                this.tempDipole.type = (short)4;
                this.tempDipole.thisID = "molecular";
                this.setDipole();
            }
            return;
        }
        if ("bonds" == string) {
            this.isBond = true;
            this.currentDipole = null;
            int n = this.dipoleCount;
            while (--n >= 0) {
                if (!this.isBondDipole(n)) continue;
                return;
            }
            this.getBondDipoles();
            return;
        }
        if ("on" == string) {
            this.setProperty(0x10000D, this.isBond, 0, 0.0f);
            return;
        }
        if ("off" == string) {
            this.setProperty(0x10000C, this.isBond, 0, 0.0f);
            return;
        }
        if ("delete" == string) {
            if (this.wildID == null && this.currentDipole == null) {
                this.clear(false);
                return;
            }
            this.setProperty(12291, this.isBond, 0, 0.0f);
            return;
        }
        if ("width" == string) {
            short s = this.tempDipole.mad = (short)(((Float)object).floatValue() * 1000.0f);
            if (this.currentDipole == null) {
                this.setProperty(659523, this.isBond, (int)s, 0.0f);
            }
            return;
        }
        if ("offset" == string) {
            float f = this.tempDipole.offsetAngstroms = ((Float)object).floatValue();
            if (this.currentDipole == null) {
                this.setProperty(1611272194, this.isBond, 0, f);
            }
            return;
        }
        if ("offsetPercent" == string) {
            int n = this.tempDipole.offsetPercent = ((Integer)object).intValue();
            if (this.tempDipole.dipoleValue != 0.0f) {
                this.tempDipole.offsetAngstroms = (float)n / 100.0f * this.tempDipole.dipoleValue;
            }
            if (this.currentDipole == null) {
                this.setProperty(269484194, this.isBond, 0, (float)n / 100.0f);
            }
            return;
        }
        if ("offsetSide" == string) {
            float f = ((Float)object).floatValue();
            this.setProperty(0x30000C, this.isBond, 0, f);
            return;
        }
        if ("cross" == string) {
            this.setProperty(135267329, this.isBond, (Boolean)object != false ? 1 : 0, 0.0f);
            return;
        }
        if ("color" == string) {
            this.colix = Graphics3D.getColix(object);
            if (this.isBond) {
                this.setColixDipole(this.colix, 1023, bitSet);
            } else if (object != null) {
                this.setProperty(1632638983, false, 0, 0.0f);
            }
            return;
        }
        if ("translucency" == string) {
            this.setProperty(0x400000C4, this.isBond, object.equals("translucent") ? 1 : 0, 0.0f);
            return;
        }
        if ("clear" == string) {
            this.currentDipole = null;
            this.clear(false);
        }
        if ("clearBonds" == string) {
            this.clear(true);
        }
        if ("startSet" == string) {
            BitSet bitSet3 = (BitSet)object;
            this.startCoord = this.viewer.getAtomSetCenter(bitSet3);
            this.tempDipole.set(this.startCoord, new Point3f(0.0f, 0.0f, 0.0f), this.dipoleValue);
            if (BitSetUtil.cardinalityOf(bitSet3) == 1) {
                this.atomIndex1 = bitSet3.nextSetBit(0);
            }
            return;
        }
        if ("atomBitset" == string) {
            bitSet2 = (BitSet)object;
            this.atomIndex1 = bitSet2.nextSetBit(0);
            this.startCoord = this.modelSet.atoms[this.atomIndex1];
            bitSet2.clear(this.atomIndex1);
            string = "endSet";
        }
        if ("endSet" == string) {
            this.iHaveTwoEnds = true;
            bitSet2 = (BitSet)object;
            if (this.atomIndex1 >= 0 && BitSetUtil.cardinalityOf(bitSet2) == 1) {
                this.atomIndex2 = bitSet2.nextSetBit(0);
                this.tempDipole.set(this.modelSet.atoms[this.atomIndex1], this.modelSet.atoms[this.atomIndex2], 1.0f);
                this.currentDipole = this.findDipole(this.tempDipole.thisID, this.tempDipole.dipoleInfo);
                this.tempDipole.thisID = this.currentDipole.thisID;
                if (this.isSameAtoms(this.currentDipole, this.tempDipole.dipoleInfo)) {
                    this.tempDipole = this.currentDipole;
                    if (this.dipoleValue > 0.0f) {
                        this.tempDipole.dipoleValue = this.dipoleValue;
                    }
                }
            } else {
                this.tempDipole.set(this.startCoord, this.viewer.getAtomSetCenter(bitSet2), this.dipoleValue);
            }
            return;
        }
        if ("startCoord" == string) {
            this.startCoord.set((Point3f)object);
            this.tempDipole.set(this.startCoord, new Point3f(0.0f, 0.0f, 0.0f), this.dipoleValue);
            return;
        }
        if ("endCoord" == string) {
            this.iHaveTwoEnds = true;
            this.endCoord.set((Point3f)object);
            this.tempDipole.set(this.startCoord, this.endCoord, this.dipoleValue);
            this.dumpDipoles("endCoord");
            return;
        }
        if ("value" == string) {
            this.dipoleValue = ((Float)object).floatValue();
            this.isUserValue = true;
            this.tempDipole.set(this.dipoleValue);
            if (this.tempDipole.offsetPercent != 0) {
                this.tempDipole.offsetAngstroms = (float)this.tempDipole.offsetPercent / 100.0f * this.tempDipole.dipoleValue;
            }
            return;
        }
        if ("set" == string) {
            if (this.isBond || !this.iHaveTwoEnds) {
                return;
            }
            this.setDipole();
            this.setModelIndex();
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            int n2 = this.dipoleCount;
            while (--n2 >= 0) {
                if (this.dipoles[n2].modelIndex > n) {
                    --this.dipoles[n2].modelIndex;
                    continue;
                }
                if (this.dipoles[n2].modelIndex != n) continue;
                if (this.dipoles[n2] == this.currentDipole) {
                    this.currentDipole = null;
                }
                this.dipoles = (Dipole[])ArrayUtil.deleteElements(this.dipoles, n2, 1);
                --this.dipoleCount;
            }
            this.currentDipole = null;
            return;
        }
    }

    private void setProperty(int n, boolean bl, int n2, float f) {
        if (this.currentDipole != null) {
            this.setProperty(n, this.currentDipole, n2, f);
        } else {
            int n3 = this.dipoleCount;
            while (--n3 >= 0) {
                if (bl && !this.isBondDipole(n3) || this.wildID != null && !TextFormat.isMatch(this.dipoles[n3].thisID.toUpperCase(), this.wildID, true, true)) continue;
                this.setProperty(n, this.dipoles[n3], n2, f);
            }
        }
    }

    private void setProperty(int n, Dipole dipole, int n2, float f) {
        switch (n) {
            case 0x10000D: {
                dipole.visible = true;
                return;
            }
            case 0x10000C: {
                dipole.visible = false;
                return;
            }
            case 12291: {
                this.deleteDipole(dipole);
                return;
            }
            case 659523: {
                dipole.mad = this.tempDipole.mad = (short)n2;
                return;
            }
            case 1611272194: {
                dipole.offsetAngstroms = f;
                return;
            }
            case 269484194: {
                dipole.offsetAngstroms = f * dipole.dipoleValue;
                return;
            }
            case 0x30000C: {
                dipole.offsetSide = f;
                return;
            }
            case 135267329: {
                dipole.noCross = n2 == 0;
                return;
            }
            case 1632638983: {
                dipole.colix = this.colix;
                return;
            }
            case 0x400000C4: {
                dipole.setTranslucent(n2 == 1, this.translucentLevel);
                return;
            }
        }
        Logger.error("Unkown dipole property! " + Token.nameOf(n));
    }

    public boolean getProperty(String string, Object[] objectArray) {
        if (string == "checkID") {
            String string2 = ((String)objectArray[0]).toUpperCase();
            boolean bl = TextFormat.isWild(string2);
            int n = this.dipoleCount;
            while (--n >= 0) {
                String string3 = this.dipoles[n].thisID;
                if (!string3.equalsIgnoreCase(string2) && (!bl || !TextFormat.isMatch(string3.toUpperCase(), string2, true, true))) continue;
                objectArray[1] = string3;
                return true;
            }
            return false;
        }
        return false;
    }

    public Object getProperty(String string, int n) {
        if (string.equals("list")) {
            return this.getShapeState();
        }
        return null;
    }

    private void getBondDipoles() {
        float[] fArray = this.modelSet.getPartialCharges();
        if (fArray == null) {
            return;
        }
        this.clear(true);
        Bond[] bondArray = this.modelSet.getBonds();
        int n = bondArray.length;
        while (--n >= 0) {
            float f;
            float f2;
            Bond bond = bondArray[n];
            if (!bond.isCovalent() || (f2 = fArray[bond.getAtomIndex1()]) == (f = fArray[bond.getAtomIndex2()])) continue;
            this.setDipole(bond.getAtom1(), bond.getAtom2(), f2, f);
        }
    }

    private boolean isBondDipole(int n) {
        if (n >= this.dipoles.length || this.dipoles[n] == null) {
            return false;
        }
        return this.dipoles[n].isBondType();
    }

    private void setColixDipole(short s, int n, BitSet bitSet) {
        if (s == 2) {
            return;
        }
        BondIterator bondIterator = this.modelSet.getBondIterator(n, bitSet);
        while (bondIterator.hasNext()) {
            Dipole dipole = this.findBondDipole(bondIterator.next());
            if (dipole == null) continue;
            dipole.colix = s;
        }
    }

    private void setDipole() {
        if (this.currentDipole == null) {
            this.currentDipole = this.allocDipole("", "");
        }
        this.currentDipole.set(this.tempDipole.thisID, this.tempDipole.dipoleInfo, this.tempDipole.atoms, this.tempDipole.dipoleValue, this.tempDipole.mad, this.tempDipole.offsetAngstroms, this.tempDipole.offsetPercent, this.tempDipole.offsetSide, this.tempDipole.origin, this.tempDipole.vector);
        this.currentDipole.isUserValue = this.isUserValue;
        this.currentDipole.modelIndex = this.viewer.getCurrentModelIndex();
    }

    private void setDipole(Atom atom, Atom atom2, float f, float f2) {
        Dipole dipole = this.findDipole(atom, atom2, true);
        float f3 = (f - f2) / 2.0f * atom.distance(atom2) / 0.208194f;
        if (f3 < 0.0f) {
            dipole.set(atom2, atom, -f3);
        } else {
            dipole.set(atom, atom2, f3);
        }
        dipole.type = (short)3;
        dipole.modelIndex = atom.getModelIndex();
    }

    private int getDipoleIndex(String string, String string2) {
        if (string != null && string.length() > 0) {
            int n = this.dipoleCount;
            while (--n >= 0) {
                if (!this.isSameAtoms(this.dipoles[n], string)) continue;
                return n;
            }
        }
        return this.getIndexFromName(string2);
    }

    private boolean isSameAtoms(Dipole dipole, String string) {
        return dipole != null && dipole.isBondType() && (dipole.dipoleInfo + dipole.dipoleInfo).indexOf(string) >= 0;
    }

    private int getDipoleIndex(int n, int n2) {
        int n3 = this.dipoleCount;
        while (--n3 >= 0) {
            if (this.dipoles[n3] == null || this.dipoles[n3].atoms[0] == null || this.dipoles[n3].atoms[1] == null || (this.dipoles[n3].atoms[0].getIndex() != n || this.dipoles[n3].atoms[1].getIndex() != n2) && (this.dipoles[n3].atoms[1].getIndex() != n || this.dipoles[n3].atoms[0].getIndex() != n2)) continue;
            return n3;
        }
        return -1;
    }

    private void deleteDipole(Dipole dipole) {
        if (dipole == null) {
            return;
        }
        if (this.currentDipole == dipole) {
            this.currentDipole = null;
        }
        int n = this.dipoleCount;
        while (this.dipoles[--n] != dipole) {
        }
        if (n < 0) {
            return;
        }
        for (int i = n + 1; i < this.dipoleCount; ++i) {
            this.dipoles[i - 1] = this.dipoles[i];
        }
        this.dipoles[--this.dipoleCount] = null;
    }

    private Dipole findDipole(String string) {
        int n = this.getIndexFromName(string);
        if (n >= 0) {
            return this.dipoles[n];
        }
        return null;
    }

    private Dipole findDipole(Atom atom, Atom atom2, boolean bl) {
        int n = this.getDipoleIndex(atom.getIndex(), atom2.getIndex());
        if (n >= 0) {
            return this.dipoles[n];
        }
        return bl ? this.allocDipole("", "") : null;
    }

    private Dipole findBondDipole(Bond bond) {
        Dipole dipole = this.findDipole(bond.getAtom1(), bond.getAtom2(), false);
        return dipole == null || dipole.atoms[0] == null ? null : dipole;
    }

    private Dipole findDipole(String string, String string2) {
        int n = this.getDipoleIndex(string2, string);
        if (n >= 0) {
            if (string.length() > 0) {
                this.dipoles[n].thisID = string;
            }
            return this.dipoles[n];
        }
        return this.allocDipole(string, string2);
    }

    private Dipole allocDipole(String string, String string2) {
        this.dipoles = (Dipole[])ArrayUtil.ensureLength(this.dipoles, this.dipoleCount + 1);
        if (string == null || string.length() == 0) {
            string = "dipole" + (this.dipoleCount + 1);
        }
        Dipole dipole = new Dipole(this.viewer.getCurrentModelIndex(), string, string2, this.colix, 5, true);
        this.dipoles[this.dipoleCount++] = dipole;
        Dipole dipole2 = dipole;
        return dipole2;
    }

    private void dumpDipoles(String string) {
        int n = this.dipoleCount;
        while (--n >= 0) {
            Dipole dipole = this.dipoles[n];
            Logger.info("\n\n" + string + " dump dipole " + n + " " + dipole + " " + dipole.thisID + " " + dipole.dipoleInfo + " " + dipole.visibilityFlags + " mad=" + dipole.mad + " vis=" + dipole.visible + "\n orig" + dipole.origin + " " + " vect" + dipole.vector + " val=" + dipole.dipoleValue);
        }
        if (this.currentDipole != null) {
            Logger.info(" current = " + this.currentDipole + this.currentDipole.origin);
        }
        if (this.tempDipole != null) {
            Logger.info(" temp = " + this.tempDipole + " " + this.tempDipole.origin);
        }
    }

    private void clear(boolean bl) {
        if (bl) {
            int n = this.dipoleCount;
            while (--n >= 0) {
                if (!this.isBondDipole(n)) continue;
                this.deleteDipole(this.dipoles[n]);
            }
            return;
        }
        int n = this.dipoleCount;
        while (--n >= 0) {
            if (this.isBond && !this.isBondDipole(n)) continue;
            this.deleteDipole(this.dipoles[n]);
        }
    }

    public int getIndexFromName(String string) {
        if (string == null) {
            return -1;
        }
        int n = this.dipoleCount;
        while (--n >= 0) {
            if (this.dipoles[n] == null || !string.equals(this.dipoles[n].thisID)) continue;
            return n;
        }
        return -1;
    }

    public Vector getShapeDetail() {
        Vector vector = new Vector();
        for (int i = 0; i < this.dipoleCount; ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            Dipole dipole = this.dipoles[i];
            hashtable.put("ID", dipole.thisID);
            hashtable.put("vector", dipole.vector);
            hashtable.put("origin", dipole.origin);
            if (dipole.atoms[0] != null) {
                Hashtable hashtable2 = new Hashtable();
                this.viewer.getAtomIdentityInfo(dipole.atoms[0].getIndex(), hashtable2);
                Vector vector2 = new Vector();
                vector2.addElement(hashtable2);
                hashtable2 = new Hashtable();
                this.viewer.getAtomIdentityInfo(dipole.atoms[1].getIndex(), hashtable2);
                vector2.addElement(hashtable2);
                hashtable.put("atoms", vector2);
                hashtable.put("magnitude", new Float(dipole.vector.length()));
            }
            vector.addElement(hashtable);
        }
        return vector;
    }

    private void setModelIndex() {
        if (this.currentDipole == null) {
            return;
        }
        this.currentDipole.visible = true;
        this.currentDipole.modelIndex = this.viewer.getCurrentModelIndex();
    }

    public void setVisibilityFlags(BitSet bitSet) {
        int n = this.dipoleCount;
        while (--n >= 0) {
            Dipole dipole = this.dipoles[n];
            dipole.visibilityFlags = (dipole.modelIndex < 0 || bitSet.get(dipole.modelIndex)) && dipole.mad != 0 && dipole.visible && dipole.origin != null && dipole.vector != null && dipole.vector.length() != 0.0f && dipole.dipoleValue != 0.0f ? this.myVisibilityFlag : 0;
        }
    }

    public String getShapeState() {
        if (this.dipoleCount == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        int n2 = this.viewer.getModelCount();
        for (int i = 0; i < this.dipoleCount; ++i) {
            Dipole dipole = this.dipoles[i];
            if (!dipole.isValid) continue;
            if (n2 > 1 && dipole.modelIndex != n) {
                n = dipole.modelIndex;
                Dipoles.appendCmd(stringBuffer, "frame " + this.viewer.getModelNumberDotted(n));
            }
            stringBuffer.append(dipole.getShapeState());
            Dipoles.appendCmd(stringBuffer, this.getColorCommand("dipole", dipole.colix));
        }
        return stringBuffer.toString();
    }
}

