/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.FieldInplaceActionButtonLook;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.SearchFieldWithExtension;
import com.intellij.ui.components.TextComponentEmptyText;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogDataKt;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.filter.BranchFilterModel;
import com.intellij.vcs.log.ui.filter.BranchFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.DateFilterModel;
import com.intellij.vcs.log.ui.filter.DateFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.FileFilterModel;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.ParentFilterModel;
import com.intellij.vcs.log.ui.filter.StructureFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.TextFilterModel;
import com.intellij.vcs.log.ui.filter.UserFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.ui.filter.VcsLogGraphOptionsChooserGroup;
import com.intellij.vcs.log.ui.filter.VcsLogPopupComponentAction;
import com.intellij.vcs.log.ui.filter.VcsLogTextFilterField;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u0000 P2\u00020\u0001:\u0006KLMNOPB?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001c\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u00010:H\u0002J\u0010\u0010;\u001a\u0002062\u0006\u0010<\u001a\u00020\u0011H\u0016J\b\u0010=\u001a\u00020/H\u0016J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020\u0006H\u0017J\u0010\u0010A\u001a\u0002062\u0006\u0010B\u001a\u00020\u0006H\u0017J\n\u0010C\u001a\u0004\u0018\u00010DH\u0014J\n\u0010E\u001a\u0004\u0018\u00010DH\u0004J\n\u0010F\u001a\u0004\u0018\u00010DH\u0004J\n\u0010G\u001a\u0004\u0018\u00010DH\u0004J\n\u0010H\u001a\u0004\u0018\u00010DH\u0004J\u0010\u0010I\u001a\u0002062\u0006\u0010J\u001a\u000202H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0016\u0010*\u001a\u00020+8\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u00100\u001a\u0015\u0012\f\u0012\n 3*\u0004\u0018\u0001020201\u00a2\u0006\u0002\b4X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi;", "Lcom/intellij/vcs/log/ui/filter/VcsLogFilterUiEx;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "filterConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "uiProperties", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "filters", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/vcs/log/data/VcsLogData;Ljava/util/function/Consumer;Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;Lcom/intellij/vcs/log/ui/VcsLogColorManager;Lcom/intellij/vcs/log/VcsLogFilterCollection;Lcom/intellij/openapi/Disposable;)V", "dataPack", "Lcom/intellij/vcs/log/VcsLogDataPack;", "visibleRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "branchFilterModel", "Lcom/intellij/vcs/log/ui/filter/BranchFilterModel;", "getBranchFilterModel", "()Lcom/intellij/vcs/log/ui/filter/BranchFilterModel;", "userFilterModel", "Lcom/intellij/vcs/log/ui/filter/FilterModel$SingleFilterModel;", "Lcom/intellij/vcs/log/VcsLogUserFilter;", "getUserFilterModel", "()Lcom/intellij/vcs/log/ui/filter/FilterModel$SingleFilterModel;", "dateFilterModel", "Lcom/intellij/vcs/log/ui/filter/DateFilterModel;", "getDateFilterModel", "()Lcom/intellij/vcs/log/ui/filter/DateFilterModel;", "structureFilterModel", "Lcom/intellij/vcs/log/ui/filter/FileFilterModel;", "getStructureFilterModel", "()Lcom/intellij/vcs/log/ui/filter/FileFilterModel;", "textFilterModel", "Lcom/intellij/vcs/log/ui/filter/TextFilterModel;", "getTextFilterModel", "()Lcom/intellij/vcs/log/ui/filter/TextFilterModel;", "parentFilterModel", "Lcom/intellij/vcs/log/ui/filter/ParentFilterModel;", "getParentFilterModel", "()Lcom/intellij/vcs/log/ui/filter/ParentFilterModel;", "textFilterField", "Lcom/intellij/vcs/log/ui/filter/VcsLogTextFilterField;", "filterListenerDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/vcs/log/ui/filter/VcsLogFilterUiEx$VcsLogFilterListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "onStructureFilterChanged", "", "rootFilter", "Lcom/intellij/vcs/log/VcsLogRootFilter;", "structureFilter", "Lcom/intellij/vcs/log/VcsLogStructureFilter;", "updateDataPack", "newDataPack", "getTextFilterComponent", "createActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getFilters", "setFilters", "collection", "createBranchComponent", "Lcom/intellij/openapi/actionSystem/AnAction;", "createUserComponent", "createDateComponent", "createStructureFilterComponent", "createGraphComponent", "addFilterListener", "listener", "MyActionButton", "MyVcsLogTextFilterField", "MainUiActionComponent", "UserFilterModel", "TextFilterField", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogClassicFilterUi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogClassicFilterUi.kt\ncom/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,300:1\n37#2,2:301\n*S KotlinDebug\n*F\n+ 1 VcsLogClassicFilterUi.kt\ncom/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi\n*L\n150#1:301,2\n*E\n"})
public class VcsLogClassicFilterUi
implements VcsLogFilterUiEx {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogData logData;
    @NotNull
    private final MainVcsLogUiProperties uiProperties;
    @NotNull
    private final VcsLogColorManager colorManager;
    @NotNull
    private VcsLogDataPack dataPack;
    @Nullable
    private Collection<? extends VirtualFile> visibleRoots;
    @NotNull
    private final BranchFilterModel branchFilterModel;
    @NotNull
    private final FilterModel.SingleFilterModel<VcsLogUserFilter> userFilterModel;
    @NotNull
    private final DateFilterModel dateFilterModel;
    @NotNull
    private final FileFilterModel structureFilterModel;
    @NotNull
    private final TextFilterModel textFilterModel;
    @ApiStatus.Internal
    @NotNull
    private final ParentFilterModel parentFilterModel;
    @NotNull
    private final VcsLogTextFilterField textFilterField;
    @NotNull
    private final EventDispatcher<VcsLogFilterUiEx.VcsLogFilterListener> filterListenerDispatcher;
    @NotNull
    private static final String VCS_LOG_TEXT_FILTER_HISTORY = "Vcs.Log.Text.Filter.History";

    public VcsLogClassicFilterUi(@NotNull VcsLogData logData, @NotNull Consumer<VcsLogFilterCollection> filterConsumer, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogColorManager colorManager, @Nullable VcsLogFilterCollection filters, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter(filterConsumer, (String)"filterConsumer");
        Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
        Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.logData = logData;
        this.uiProperties = uiProperties;
        this.colorManager = colorManager;
        this.dataPack = VisiblePack.EMPTY;
        EventDispatcher eventDispatcher = EventDispatcher.create(VcsLogFilterUiEx.VcsLogFilterListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.filterListenerDispatcher = eventDispatcher;
        this.branchFilterModel = new BranchFilterModel((Function0<? extends VcsLogDataPack>)((Function0)new MutablePropertyReference0Impl(this){

            public Object get() {
                return ((VcsLogClassicFilterUi)this.receiver).dataPack;
            }

            public void set(Object value) {
                ((VcsLogClassicFilterUi)this.receiver).dataPack = (VcsLogDataPack)value;
            }
        }), this.logData.getStorage(), VcsLogDataKt.getRoots(this.logData), (Function0<? extends Collection<? extends VirtualFile>>)((Function0)new MutablePropertyReference0Impl(this){

            public Object get() {
                return ((VcsLogClassicFilterUi)this.receiver).visibleRoots;
            }

            public void set(Object value) {
                ((VcsLogClassicFilterUi)this.receiver).visibleRoots = (Collection)value;
            }
        }), this.uiProperties, filters);
        this.userFilterModel = new UserFilterModel(this.uiProperties, filters);
        this.dateFilterModel = new DateFilterModel(this.uiProperties, filters);
        this.structureFilterModel = new FileFilterModel(this.logData.getLogProviders().keySet(), this.uiProperties, filters);
        this.textFilterModel = new TextFilterModel(this.uiProperties, filters, parentDisposable);
        this.parentFilterModel = new ParentFilterModel(this.uiProperties, this.logData.getLogProviders(), (Function0<? extends Collection<? extends VirtualFile>>)((Function0)new MutablePropertyReference0Impl(this){

            public Object get() {
                return ((VcsLogClassicFilterUi)this.receiver).visibleRoots;
            }

            public void set(Object value) {
                ((VcsLogClassicFilterUi)this.receiver).visibleRoots = (Collection)value;
            }
        }), filters);
        TextFilterField field = new TextFilterField(this.textFilterModel, parentDisposable);
        ActionToolbar toolbar2 = VcsLogClassicFilterUi.Companion.createTextActionsToolbar((JComponent)field.getTextEditor());
        JComponent jComponent = toolbar2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        this.textFilterField = new MyVcsLogTextFilterField(new SearchFieldWithExtension(jComponent, (SearchTextField)field));
        FilterModel[] filterModelArray = new FilterModel[]{this.branchFilterModel, this.userFilterModel, this.dateFilterModel, this.structureFilterModel, this.textFilterModel, this.parentFilterModel};
        for (FilterModel model : filterModelArray) {
            model.addSetFilterListener(() -> VcsLogClassicFilterUi._init_$lambda$0(filterConsumer, this));
        }
    }

    @NotNull
    protected final BranchFilterModel getBranchFilterModel() {
        return this.branchFilterModel;
    }

    @NotNull
    protected final FilterModel.SingleFilterModel<VcsLogUserFilter> getUserFilterModel() {
        return this.userFilterModel;
    }

    @NotNull
    protected final DateFilterModel getDateFilterModel() {
        return this.dateFilterModel;
    }

    @NotNull
    protected final FileFilterModel getStructureFilterModel() {
        return this.structureFilterModel;
    }

    @NotNull
    protected final TextFilterModel getTextFilterModel() {
        return this.textFilterModel;
    }

    @NotNull
    protected final ParentFilterModel getParentFilterModel() {
        return this.parentFilterModel;
    }

    private final void onStructureFilterChanged(VcsLogRootFilter rootFilter, VcsLogStructureFilter structureFilter) {
        this.visibleRoots = rootFilter != null || structureFilter != null ? (Collection)VcsLogUtil.getAllVisibleRoots(VcsLogDataKt.getRoots(this.logData), rootFilter, structureFilter) : null;
    }

    @Override
    public void updateDataPack(@NotNull VcsLogDataPack newDataPack) {
        Intrinsics.checkNotNullParameter((Object)newDataPack, (String)"newDataPack");
        this.dataPack = newDataPack;
    }

    @Override
    @NotNull
    public VcsLogTextFilterField getTextFilterComponent() {
        return this.textFilterField;
    }

    @Override
    @NotNull
    public ActionGroup createActionGroup() {
        Object[] objectArray = new AnAction[]{this.createBranchComponent(), this.createUserComponent(), this.createDateComponent(), this.createStructureFilterComponent(), this.createGraphComponent()};
        List actions2 = CollectionsKt.listOfNotNull((Object[])objectArray);
        return (ActionGroup)new DefaultActionGroup(actions2);
    }

    @RequiresEdt
    @NotNull
    public VcsLogFilterCollection getFilters() {
        VcsLogFilter[] vcsLogFilterArray;
        VcsLogFilter[] $this$getFilters_u24lambda_u240 = vcsLogFilterArray = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getFilters_u24lambda_u240.addAll((Collection)this.branchFilterModel.getFiltersList());
        $this$getFilters_u24lambda_u240.addAll((Collection)this.textFilterModel.getFiltersList());
        $this$getFilters_u24lambda_u240.addAll((Collection)this.structureFilterModel.getFiltersList());
        $this$getFilters_u24lambda_u240.add(this.dateFilterModel.getFilter());
        $this$getFilters_u24lambda_u240.add(this.userFilterModel.getFilter());
        $this$getFilters_u24lambda_u240.add(this.parentFilterModel.getFilter());
        List filters = CollectionsKt.filterNotNull((Iterable)CollectionsKt.build((List)vcsLogFilterArray));
        Collection $this$toTypedArray$iv = filters;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        vcsLogFilterArray = thisCollection$iv.toArray(new VcsLogFilter[0]);
        return VcsLogFilterObject.collection(Arrays.copyOf(vcsLogFilterArray, vcsLogFilterArray.length));
    }

    @Override
    @RequiresEdt
    public void setFilters(@NotNull VcsLogFilterCollection collection) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        this.branchFilterModel.setFilter(collection);
        this.structureFilterModel.setFilter(collection);
        this.textFilterModel.setFilter(collection);
        this.dateFilterModel.setFilter(collection.get(VcsLogFilterCollection.DATE_FILTER));
        this.userFilterModel.setFilter((VcsLogUserFilter)collection.get(VcsLogFilterCollection.USER_FILTER));
        this.parentFilterModel.setFilter(collection.get(VcsLogFilterCollection.PARENT_FILTER));
    }

    @Nullable
    protected AnAction createBranchComponent() {
        Supplier<String> supplier = VcsLogBundle.messagePointer("vcs.log.branch.filter.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        return (AnAction)new MainUiActionComponent(supplier, () -> VcsLogClassicFilterUi.createBranchComponent$lambda$0(this));
    }

    @Nullable
    protected final AnAction createUserComponent() {
        Supplier<String> supplier = VcsLogBundle.messagePointer("vcs.log.user.filter.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        return (AnAction)new MainUiActionComponent(supplier, () -> VcsLogClassicFilterUi.createUserComponent$lambda$0(this));
    }

    @Nullable
    protected final AnAction createDateComponent() {
        Supplier<String> supplier = VcsLogBundle.messagePointer("vcs.log.date.filter.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        return (AnAction)new MainUiActionComponent(supplier, () -> VcsLogClassicFilterUi.createDateComponent$lambda$0(this));
    }

    @Nullable
    protected final AnAction createStructureFilterComponent() {
        Supplier<String> supplier = VcsLogBundle.messagePointer("vcs.log.path.filter.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        return (AnAction)new MainUiActionComponent(supplier, () -> VcsLogClassicFilterUi.createStructureFilterComponent$lambda$0(this));
    }

    @Nullable
    protected final AnAction createGraphComponent() {
        return (AnAction)new VcsLogGraphOptionsChooserGroup(this.parentFilterModel);
    }

    @Override
    public void addFilterListener(@NotNull VcsLogFilterUiEx.VcsLogFilterListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.filterListenerDispatcher.addListener((EventListener)listener2);
    }

    private static final void _init_$lambda$0(Consumer $filterConsumer, VcsLogClassicFilterUi this$0) {
        $filterConsumer.accept(this$0.getFilters());
        ((VcsLogFilterUiEx.VcsLogFilterListener)this$0.filterListenerDispatcher.getMulticaster()).onFiltersChanged();
        this$0.onStructureFilterChanged(this$0.structureFilterModel.getRootFilter(), this$0.structureFilterModel.getStructureFilter());
    }

    private static final JComponent createBranchComponent$lambda$0(VcsLogClassicFilterUi this$0) {
        return new BranchFilterPopupComponent(this$0.uiProperties, this$0.branchFilterModel).initUi();
    }

    private static final JComponent createUserComponent$lambda$0(VcsLogClassicFilterUi this$0) {
        return new UserFilterPopupComponent(this$0.uiProperties, this$0.logData, this$0.userFilterModel).initUi();
    }

    private static final JComponent createDateComponent$lambda$0(VcsLogClassicFilterUi this$0) {
        return new DateFilterPopupComponent(this$0.dateFilterModel).initUi();
    }

    private static final JComponent createStructureFilterComponent$lambda$0(VcsLogClassicFilterUi this$0) {
        return new StructureFilterPopupComponent(this$0.uiProperties, this$0.structureFilterModel, this$0.colorManager).initUi();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0006\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0007H\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$Companion;", "", "<init>", "()V", "VCS_LOG_TEXT_FILTER_HISTORY", "", "createTooltipText", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "isFilterOnTheFlyEnabled", "", "()Z", "createTextActionsToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "editor", "Ljavax/swing/JComponent;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final String createTooltipText() {
            String string = VcsLogBundle.message("vcs.log.filter.text.hash.tooltip", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String text = string;
            String string2 = HelpTooltip.getShortcutAsHtml((String)KeymapUtil.getFirstKeyboardShortcutText((String)"Vcs.Log.FocusTextFilter"));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortcutAsHtml(...)");
            String shortcut = string2;
            String string3 = XmlStringUtil.wrapInHtml((CharSequence)(text + shortcut));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"wrapInHtml(...)");
            return string3;
        }

        private final boolean isFilterOnTheFlyEnabled() {
            return Registry.Companion.is("vcs.log.filter.text.on.the.fly");
        }

        private final ActionToolbar createTextActionsToolbar(JComponent editor) {
            ActionManager actionManager = ActionManager.getInstance();
            AnAction anAction = actionManager.getAction("Vcs.Log.TextFilterSettings");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            ActionGroup textActionGroup = (ActionGroup)anAction;
            ActionToolbarImpl toolbar2 = new ActionToolbarImpl(textActionGroup){

                protected ActionButton createToolbarButton(AnAction action, ActionButtonLook look, String place, Presentation presentation, Supplier<? extends Dimension> minimumSize) {
                    Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                    Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                    Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
                    Intrinsics.checkNotNullParameter(minimumSize, (String)"minimumSize");
                    MyActionButton button = new MyActionButton(action, presentation);
                    button.setFocusable(true);
                    this.applyToolbarLook(look, presentation, (JComponent)((Object)button));
                    return button;
                }

                protected boolean canReuseActionButton(ActionButton oldActionButton, Presentation newPresentation) {
                    Intrinsics.checkNotNullParameter((Object)oldActionButton, (String)"oldActionButton");
                    Intrinsics.checkNotNullParameter((Object)newPresentation, (String)"newPresentation");
                    return Intrinsics.areEqual(oldActionButton.getClass(), MyActionButton.class);
                }
            };
            toolbar2.setCustomButtonLook((ActionButtonLook)new FieldInplaceActionButtonLook());
            toolbar2.setReservePlaceAutoPopupIcon(false);
            toolbar2.setTargetComponent(editor);
            return (ActionToolbar)toolbar2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0005\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0017\u0010\r\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0016\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$MainUiActionComponent;", "Lcom/intellij/vcs/log/ui/filter/VcsLogPopupComponentAction;", "dynamicText", "Ljava/util/function/Supplier;", "", "componentCreator", "Ljavax/swing/JComponent;", "<init>", "(Ljava/util/function/Supplier;Ljava/util/function/Supplier;)V", "createCustomComponent", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "getTargetComponent", "Lorg/jetbrains/annotations/NotNull;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.vcs.log.impl"})
    @ApiStatus.Internal
    protected static final class MainUiActionComponent
    extends VcsLogPopupComponentAction {
        @NotNull
        private final Supplier<? extends JComponent> componentCreator;

        public MainUiActionComponent(@NotNull Supplier<String> dynamicText, @NotNull Supplier<? extends JComponent> componentCreator) {
            Intrinsics.checkNotNullParameter(dynamicText, (String)"dynamicText");
            Intrinsics.checkNotNullParameter(componentCreator, (String)"componentCreator");
            super(dynamicText);
            this.componentCreator = componentCreator;
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            JComponent jComponent = this.componentCreator.get();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"get(...)");
            return jComponent;
        }

        @Override
        @Nullable
        protected JComponent getTargetComponent(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            MainVcsLogUi mainVcsLogUi = (MainVcsLogUi)e.getData(VcsLogInternalDataKeys.MAIN_UI);
            return mainVcsLogUi != null ? mainVcsLogUi.getToolbar() : null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$MyActionButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "<init>", "(Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/openapi/actionSystem/Presentation;)V", "getPopState", "", "getIcon", "Ljavax/swing/Icon;", "intellij.platform.vcs.log.impl"})
    private static final class MyActionButton
    extends ActionButton {
        public MyActionButton(@NotNull AnAction action, @NotNull Presentation presentation) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            super(action, presentation, "Vcs.Log.SearchTextField", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.updateIcon();
        }

        public int getPopState() {
            return this.isSelected() ? 2 : super.getPopState();
        }

        @NotNull
        public Icon getIcon() {
            Icon selectedIcon;
            if (this.isEnabled() && this.isSelected() && (selectedIcon = this.myPresentation.getSelectedIcon()) != null) {
                return selectedIcon;
            }
            Icon icon = super.getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
            return icon;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$MyVcsLogTextFilterField;", "Lcom/intellij/vcs/log/ui/filter/VcsLogTextFilterField;", "searchField", "Lcom/intellij/ui/components/SearchFieldWithExtension;", "<init>", "(Lcom/intellij/ui/components/SearchFieldWithExtension;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "focusedComponent", "getFocusedComponent", "s", "", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "intellij.platform.vcs.log.impl"})
    private static final class MyVcsLogTextFilterField
    implements VcsLogTextFilterField {
        @NotNull
        private final SearchFieldWithExtension searchField;

        public MyVcsLogTextFilterField(@NotNull SearchFieldWithExtension searchField) {
            Intrinsics.checkNotNullParameter((Object)searchField, (String)"searchField");
            this.searchField = searchField;
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            return (JComponent)this.searchField;
        }

        @Override
        @NotNull
        public JComponent getFocusedComponent() {
            return this.searchField.getTextField();
        }

        @Override
        @NotNull
        public String getText() {
            String string = this.searchField.getTextField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }

        @Override
        public void setText(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.searchField.getTextField().setText(s);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0014J\b\u0010\u0010\u001a\u00020\fH\u0014J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterField;", "Lcom/intellij/ui/SearchTextField;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "textFilterModel", "Lcom/intellij/vcs/log/ui/filter/TextFilterModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi;Lcom/intellij/vcs/log/ui/filter/TextFilterModel;Lcom/intellij/openapi/Disposable;)V", "getMinimumSize", "Ljava/awt/Dimension;", "applyFilter", "", "addToHistory", "", "onFieldCleared", "onFocusLost", "isSameFilterAs", "otherText", "", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.platform.vcs.log.impl"})
    private final class TextFilterField
    extends SearchTextField
    implements UiDataProvider {
        @NotNull
        private final TextFilterModel textFilterModel;

        public TextFilterField(@NotNull TextFilterModel textFilterModel, Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)textFilterModel, (String)"textFilterModel");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            super(VcsLogClassicFilterUi.VCS_LOG_TEXT_FILTER_HISTORY);
            this.textFilterModel = textFilterModel;
            this.setText(this.textFilterModel.getText());
            this.getTextEditor().getEmptyText().setText(VcsLogBundle.message("vcs.log.filter.text.hash.empty.text", new Object[0]));
            TextComponentEmptyText.setupPlaceholderVisibility((JTextComponent)((JTextComponent)this.getTextEditor()));
            this.getTextEditor().addActionListener(arg_0 -> TextFilterField._init_$lambda$0(this, arg_0));
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (Companion.isFilterOnTheFlyEnabled()) {
                        this.applyFilter(false);
                    }
                }
            });
            this.textFilterModel.addSetFilterListener(() -> TextFilterField._init_$lambda$1(this));
            this.getTextEditor().setToolTipText(Companion.createTooltipText());
            Disposer.register((Disposable)parentDisposable, () -> TextFilterField._init_$lambda$2(this));
        }

        @NotNull
        public Dimension getMinimumSize() {
            Dimension size = super.getMinimumSize();
            size.width = Math.max(size.width, JBUIScale.scale((int)150));
            Intrinsics.checkNotNull((Object)size);
            return size;
        }

        private final void applyFilter(boolean addToHistory) {
            String string = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.textFilterModel.setFilterText(string);
            if (addToHistory) {
                this.addCurrentTextToHistory();
            }
        }

        protected void onFieldCleared() {
            this.textFilterModel.setFilter(null);
        }

        protected void onFocusLost() {
            if (!this.isSameFilterAs(this.textFilterModel.getText())) {
                this.applyFilter(Companion.isFilterOnTheFlyEnabled());
            }
        }

        private final boolean isSameFilterAs(String otherText) {
            String thisText = this.getText();
            CharSequence charSequence = thisText;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return StringsKt.isBlank((CharSequence)otherText);
            }
            return Intrinsics.areEqual((Object)thisText, (Object)otherText);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            DataKey<VcsLogUiProperties> dataKey = VcsLogInternalDataKeys.LOG_UI_PROPERTIES;
            Intrinsics.checkNotNullExpressionValue(dataKey, (String)"LOG_UI_PROPERTIES");
            sink.set(dataKey, (Object)VcsLogClassicFilterUi.this.uiProperties);
        }

        private static final void _init_$lambda$0(TextFilterField this$0, ActionEvent it) {
            this$0.applyFilter(true);
        }

        private static final void _init_$lambda$1(TextFilterField this$0) {
            String modelText = this$0.textFilterModel.getText();
            if (!this$0.isSameFilterAs(modelText)) {
                this$0.setText(modelText);
            }
        }

        private static final void _init_$lambda$2(TextFilterField this$0) {
            this$0.hidePopup();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$UserFilterModel;", "Lcom/intellij/vcs/log/ui/filter/FilterModel$SingleFilterModel;", "Lcom/intellij/vcs/log/VcsLogUserFilter;", "uiProperties", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "<init>", "(Lcom/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi;Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;Lcom/intellij/vcs/log/VcsLogFilterCollection;)V", "createFilter", "values", "", "", "getFilterValues", "filter", "intellij.platform.vcs.log.impl"})
    private final class UserFilterModel
    extends FilterModel.SingleFilterModel<VcsLogUserFilter> {
        public UserFilterModel(@Nullable MainVcsLogUiProperties uiProperties, VcsLogFilterCollection filters) {
            Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
            VcsLogFilterCollection.FilterKey filterKey = VcsLogFilterCollection.USER_FILTER;
            Intrinsics.checkNotNullExpressionValue((Object)filterKey, (String)"USER_FILTER");
            super(filterKey, uiProperties, filters);
        }

        @Override
        @NotNull
        protected VcsLogUserFilter createFilter(@NotNull List<String> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return VcsLogFilterObject.fromUserNames((Collection<String>)values, VcsLogClassicFilterUi.this.logData);
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogUserFilter filter) {
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            return new ArrayList(filter.getValuesAsText());
        }
    }
}

