/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.Questioner;
import java.awt.Dimension;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public interface TtyConnector {
    public int read(char[] var1, int var2, int var3) throws IOException;

    public void write(byte[] var1) throws IOException;

    public void write(String var1) throws IOException;

    public boolean isConnected();

    default public void resize(@NotNull TermSize termSize) {
        this.resize(new Dimension(termSize.getColumns(), termSize.getRows()));
    }

    public int waitFor() throws InterruptedException;

    public boolean ready() throws IOException;

    public String getName();

    public void close();

    @Deprecated
    default public void resize(@NotNull Dimension termWinSize) {
        this.resize(termWinSize, new Dimension(0, 0));
    }

    @Deprecated
    default public void resize(Dimension termWinSize, Dimension pixelSize) {
        throw new IllegalStateException("This method shouldn't be called. " + this.getClass() + " should override TtyConnector.resize(com.jediterm.core.util.TermSize)");
    }

    @Deprecated(forRemoval=true)
    default public boolean init(Questioner q) {
        return true;
    }
}

