/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.FloatAnimationSpec;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0011\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0082\bJ \u0010\u0016\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J(\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/compose/animation/core/FloatTweenSpec;", "Landroidx/compose/animation/core/FloatAnimationSpec;", "duration", "", "delay", "easing", "Landroidx/compose/animation/core/Easing;", "<init>", "(IILandroidx/compose/animation/core/Easing;)V", "getDuration", "()I", "getDelay", "durationNanos", "", "delayNanos", "getValueFromNanos", "", "playTimeNanos", "initialValue", "targetValue", "initialVelocity", "clampPlayTimeNanos", "getDurationNanos", "getVelocityFromNanos", "animation-core"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nFloatAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatAnimationSpec.kt\nandroidx/compose/animation/core/FloatTweenSpec\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n+ 3 VectorConverters.kt\nandroidx/compose/animation/core/VectorConvertersKt\n*L\n1#1,260:1\n223#1:261\n223#1:283\n119#2,10:262\n119#2,10:273\n119#2,10:284\n71#3:272\n*S KotlinDebug\n*F\n+ 1 FloatAnimationSpec.kt\nandroidx/compose/animation/core/FloatTweenSpec\n*L\n216#1:261\n244#1:283\n216#1:262,10\n223#1:273,10\n244#1:284,10\n219#1:272\n*E\n"})
public final class FloatTweenSpec
implements FloatAnimationSpec {
    private final int duration;
    private final int delay;
    @NotNull
    private final Easing easing;
    private final long durationNanos;
    private final long delayNanos;
    public static final int $stable;

    public FloatTweenSpec(int duration, int delay, @NotNull Easing easing) {
        Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
        this.duration = duration;
        this.delay = delay;
        this.easing = easing;
        this.durationNanos = (long)this.duration * 1000000L;
        this.delayNanos = (long)this.delay * 1000000L;
    }

    public /* synthetic */ FloatTweenSpec(int n, int n2, Easing easing, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 300;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            easing = EasingKt.getFastOutSlowInEasing();
        }
        this(n, n2, easing);
    }

    public final int getDuration() {
        return this.duration;
    }

    public final int getDelay() {
        return this.delay;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getValueFromNanos(long playTimeNanos, float initialValue, float targetValue2, float initialVelocity) {
        void stop$iv;
        void start$iv;
        void $this$fastCoerceAtMost$iv$iv$iv;
        void $this$fastCoerceAtLeast$iv$iv$iv;
        void minimumValue$iv$iv;
        void $this$fastCoerceIn$iv$iv;
        void this_$iv;
        FloatTweenSpec floatTweenSpec = this;
        long playTimeNanos$iv = playTimeNanos;
        boolean $i$f$clampPlayTimeNanos22 = false;
        long l = playTimeNanos$iv - this_$iv.delayNanos;
        long l2 = 0L;
        long maximumValue$iv$iv = this_$iv.durationNanos;
        boolean $i$f$fastCoerceIn = false;
        void var19_16 = $this$fastCoerceIn$iv$iv;
        void minimumValue$iv$iv$iv = minimumValue$iv$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv$iv ? minimumValue$iv$iv$iv : $this$fastCoerceAtLeast$iv$iv$iv;
        long maximumValue$iv$iv$iv = maximumValue$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        long clampedPlayTimeNanos = $this$fastCoerceAtMost$iv$iv$iv > maximumValue$iv$iv$iv ? maximumValue$iv$iv$iv : $this$fastCoerceAtMost$iv$iv$iv;
        float rawFraction = this.duration == 0 ? 1.0f : (float)clampedPlayTimeNanos / (float)this.durationNanos;
        float fraction = this.easing.transform(rawFraction);
        float f = initialValue;
        float $i$f$clampPlayTimeNanos22 = targetValue2;
        float fraction$iv = fraction;
        boolean $i$f$lerp = false;
        return (float)(start$iv * (1.0f - fraction$iv) + stop$iv * fraction$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final long clampPlayTimeNanos(long playTimeNanos) {
        void $this$fastCoerceAtMost$iv$iv;
        void $this$fastCoerceAtLeast$iv$iv;
        void minimumValue$iv;
        void $this$fastCoerceIn$iv;
        boolean $i$f$clampPlayTimeNanos = false;
        long l = playTimeNanos - this.delayNanos;
        long l2 = 0L;
        long maximumValue$iv = this.durationNanos;
        boolean $i$f$fastCoerceIn = false;
        void var11_7 = $this$fastCoerceIn$iv;
        void minimumValue$iv$iv = minimumValue$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv$iv ? minimumValue$iv$iv : $this$fastCoerceAtLeast$iv$iv;
        long maximumValue$iv$iv = maximumValue$iv;
        boolean $i$f$fastCoerceAtMost = false;
        return $this$fastCoerceAtMost$iv$iv > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv;
    }

    @Override
    public long getDurationNanos(float initialValue, float targetValue2, float initialVelocity) {
        return this.delayNanos + this.durationNanos;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getVelocityFromNanos(long playTimeNanos, float initialValue, float targetValue2, float initialVelocity) {
        void $this$fastCoerceAtMost$iv$iv$iv;
        void $this$fastCoerceAtLeast$iv$iv$iv;
        void minimumValue$iv$iv;
        void $this$fastCoerceIn$iv$iv;
        void this_$iv;
        FloatTweenSpec floatTweenSpec = this;
        long playTimeNanos$iv = playTimeNanos;
        boolean $i$f$clampPlayTimeNanos = false;
        long l = playTimeNanos$iv - this_$iv.delayNanos;
        long l2 = 0L;
        long maximumValue$iv$iv = this_$iv.durationNanos;
        boolean $i$f$fastCoerceIn = false;
        void var19_14 = $this$fastCoerceIn$iv$iv;
        void minimumValue$iv$iv$iv = minimumValue$iv$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv$iv ? minimumValue$iv$iv$iv : $this$fastCoerceAtLeast$iv$iv$iv;
        long maximumValue$iv$iv$iv = maximumValue$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        long clampedPlayTimeNanos = $this$fastCoerceAtMost$iv$iv$iv > maximumValue$iv$iv$iv ? maximumValue$iv$iv$iv : $this$fastCoerceAtMost$iv$iv$iv;
        if (clampedPlayTimeNanos == 0L) {
            return initialVelocity;
        }
        float startNum = this.getValueFromNanos(clampedPlayTimeNanos - 1000000L, initialValue, targetValue2, initialVelocity);
        float endNum = this.getValueFromNanos(clampedPlayTimeNanos, initialValue, targetValue2, initialVelocity);
        return (endNum - startNum) * 1000.0f;
    }

    public FloatTweenSpec() {
        this(0, 0, null, 7, null);
    }
}

