/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.ImmutableRangeSet;
import com.intellij.openapi.util.Version;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.impl.PyVersionCheck;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/psi/impl/PyVersionAwareElementVisitor;", "Lcom/jetbrains/python/psi/PyRecursiveElementVisitor;", "languageLevel", "Lcom/jetbrains/python/psi/LanguageLevel;", "<init>", "(Lcom/jetbrains/python/psi/LanguageLevel;)V", "version", "Lcom/intellij/openapi/util/Version;", "visitPyIfStatement", "", "node", "Lcom/jetbrains/python/psi/PyIfStatement;", "intellij.python.psi"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPyVersionAwareElementVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyVersionAwareElementVisitor.kt\ncom/jetbrains/python/psi/impl/PyVersionAwareElementVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public class PyVersionAwareElementVisitor
extends PyRecursiveElementVisitor {
    @Nullable
    private final Version version;

    /*
     * WARNING - void declaration
     */
    public PyVersionAwareElementVisitor(@Nullable LanguageLevel languageLevel) {
        Version version;
        PyVersionAwareElementVisitor pyVersionAwareElementVisitor = this;
        LanguageLevel languageLevel2 = languageLevel;
        if (languageLevel2 != null) {
            void it;
            LanguageLevel languageLevel3 = languageLevel2;
            PyVersionAwareElementVisitor pyVersionAwareElementVisitor2 = pyVersionAwareElementVisitor;
            boolean bl = false;
            version = new Version(it.getMajorVersion(), it.getMinorVersion(), 0);
            pyVersionAwareElementVisitor = pyVersionAwareElementVisitor2;
        } else {
            version = null;
        }
        pyVersionAwareElementVisitor.version = version;
    }

    @Override
    public void visitPyIfStatement(@NotNull PyIfStatement node) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (this.version == null) {
                super.visitPyIfStatement(node);
                return;
            }
            Sequence sequence = SequencesKt.sequenceOf((Object)node.getIfPart());
            PyIfPart[] pyIfPartArray = node.getElifParts();
            Intrinsics.checkNotNullExpressionValue((Object)pyIfPartArray, (String)"getElifParts(...)");
            Sequence ifParts = SequencesKt.plus((Sequence)sequence, (Sequence)ArraysKt.asSequence((Object[])pyIfPartArray));
            for (PyIfPart ifPart : ifParts) {
                Intrinsics.checkNotNull((Object)ifPart);
                ImmutableRangeSet<Version> versions = PyVersionCheck.convertToVersionRanges(ifPart);
                if (versions == null) {
                    super.visitPyIfStatement(node);
                    return;
                }
                if (!versions.contains((Comparable)this.version)) continue;
                ((PyStatementList)ifPart.getStatementList()).accept(this);
                return;
            }
            PyElement pyElement = (PyElsePart)node.getElsePart();
            if (pyElement == null || (pyElement = (PyStatementList)pyElement.getStatementList()) == null) break block3;
            pyElement.accept(this);
        }
    }
}

