/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootldr;

import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;

public final class AndroidBootLoaderConstants {
    public static final String BOOTLDR_NAME = "bootloader_images_header";
    public static final String BOOTLDR_MAGIC = "BOOTLDR!";
    public static final int BOOTLDR_MAGIC_SIZE = "BOOTLDR!".length();
    public static final String IMG_INFO_NAME = "img_info";
    public static final int IMG_INFO_NAME_LENGTH = 64;

    public static boolean isBootLoader(Program program) {
        try {
            Memory memory = program.getMemory();
            byte[] bytes = new byte[BOOTLDR_MAGIC_SIZE];
            memory.getBytes(program.getMinAddress(), bytes);
            String magic = new String(bytes).trim();
            return BOOTLDR_MAGIC.equals(magic);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

