/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string.translate;

import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.string.translate.TranslateStringsPlugin;
import ghidra.app.services.StringTranslationService;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.TranslationSettingsDefinition;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.task.TaskLauncher;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ManualStringTranslationService
implements StringTranslationService {
    private static final int MAX_STR_PROMPT = 30;

    @Override
    public String getTranslationServiceName() {
        return "Manual";
    }

    @Override
    public HelpLocation getHelpLocation() {
        return StringTranslationService.createStringTranslationServiceHelpLocation(TranslateStringsPlugin.class, this);
    }

    @Override
    public void translate(Program program, List<ProgramLocation> stringLocations, StringTranslationService.TranslateOptions options) {
        TaskLauncher.launchModal((String)"Manually translate strings", monitor -> {
            int id = program.startTransaction("Translate strings");
            try {
                for (int instanceNum = 0; instanceNum < stringLocations.size(); ++instanceNum) {
                    ProgramLocation progLoc = (ProgramLocation)stringLocations.get(instanceNum);
                    Data data = DataUtilities.getDataAtLocation((ProgramLocation)progLoc);
                    StringDataInstance stringData = StringDataInstance.getStringDataInstance((Data)data);
                    String strValue = stringData.getStringValue();
                    if (strValue == null) continue;
                    strValue = strValue.length() > 30 ? strValue.substring(0, 30) + "..." : strValue;
                    String previous = StringUtils.defaultString((String)stringData.getTranslatedValue());
                    String translatedValue = OptionDialog.showInputSingleLineDialog(null, (String)("Translate " + (instanceNum + 1) + " of " + stringLocations.size()), (String)("Translate \"" + strValue + "\""), (String)previous);
                    if (translatedValue == null) {
                        break;
                    }
                    if (translatedValue.trim().isEmpty()) continue;
                    TranslationSettingsDefinition.TRANSLATION.setTranslatedValue(data, translatedValue);
                    TranslationSettingsDefinition.TRANSLATION.setShowTranslated((Settings)data, true);
                }
            }
            finally {
                program.endTransaction(id, true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTranslatedValue(Program program, ProgramLocation stringLocation, String newValue) {
        Data data = DataUtilities.getDataAtLocation((ProgramLocation)stringLocation);
        StringDataInstance sdi = StringDataInstance.getStringDataInstance((Data)data);
        int id = program.startTransaction("Set string translated value");
        try {
            if (newValue.isEmpty() || newValue.equals(sdi.getStringValue())) {
                TranslationSettingsDefinition.TRANSLATION.clear((Settings)data);
                TranslationSettingsDefinition.TRANSLATION.setTranslatedValue(data, null);
            } else {
                TranslationSettingsDefinition.TRANSLATION.setTranslatedValue(data, newValue);
                TranslationSettingsDefinition.TRANSLATION.setShowTranslated((Settings)data, true);
            }
        }
        finally {
            program.endTransaction(id, true);
        }
    }
}

