/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.EOLComment;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.DataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

@StructureMapping(structureName={"runtime.pcHeader"})
public class GoPcHeader {
    public static final String GO_STRUCTURE_NAME = "runtime.pcHeader";
    private static final String RUNTIME_PCLNTAB_SYMBOLNAME = "runtime.pclntab";
    public static final String GOPCLNTAB_SECTION_NAME = "gopclntab";
    public static final int GO_1_2_MAGIC = -5;
    public static final int GO_1_16_MAGIC = -6;
    public static final int GO_1_18_MAGIC = -16;
    public static final int GO_1_20_MAGIC = -15;
    @ContextField
    private GoRttiMapper programContext;
    @ContextField
    private StructureContext<GoPcHeader> context;
    @FieldMapping
    @EOLComment(value="getGoVersion")
    private int magic;
    @FieldMapping
    private byte minLC;
    @FieldMapping
    private byte ptrSize;
    @FieldMapping(presentWhen="1.18+")
    @MarkupReference
    private long textStart;
    @FieldMapping(presentWhen="1.16+")
    @MarkupReference(value="getFuncnameAddress")
    private long funcnameOffset;
    @FieldMapping(presentWhen="1.16+")
    @MarkupReference(value="getCuAddress")
    private long cuOffset;
    @FieldMapping(presentWhen="1.16+")
    @MarkupReference(value="getFiletabAddress")
    private long filetabOffset;
    @FieldMapping(presentWhen="1.16+")
    @MarkupReference(value="getPctabAddress")
    private long pctabOffset;
    @FieldMapping(presentWhen="1.16+")
    @MarkupReference(value="getPclnAddress")
    private long pclnOffset;

    public static Address getPcHeaderAddress(Program program) {
        MemoryBlock pclntabBlock = GoRttiMapper.getGoSection(program, GOPCLNTAB_SECTION_NAME);
        if (pclntabBlock != null) {
            return pclntabBlock.getStart();
        }
        Symbol pclntabSymbol = GoRttiMapper.getGoSymbol(program, RUNTIME_PCLNTAB_SYMBOLNAME);
        return pclntabSymbol != null ? pclntabSymbol.getAddress() : null;
    }

    public static boolean hasPcHeader(Program program) {
        Address addr = GoPcHeader.getPcHeaderAddress(program);
        if (addr != null) {
            boolean bl;
            MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), addr);
            try {
                bl = GoPcHeader.isPcHeader(provider);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        provider.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            provider.close();
            return bl;
        }
        return false;
    }

    public static Address findPcHeaderAddress(GoRttiMapper programContext, AddressRange range, TaskMonitor monitor) throws IOException {
        Address pcHeaderAddr;
        if (range == null) {
            return null;
        }
        byte[] searchBytes = new byte[]{-1, -1, -1, -1, 0, 0, 0, (byte)programContext.getPtrSize()};
        byte[] searchMask = new byte[]{-16, -1, -1, -16, -1, -1, 0, -1};
        Memory memory = programContext.getProgram().getMemory();
        while ((pcHeaderAddr = memory.findBytes(range.getMinAddress(), range.getMaxAddress(), searchBytes, searchMask, true, monitor)) != null) {
            try (MemoryByteProvider bp = new MemoryByteProvider(memory, pcHeaderAddr, range.getMaxAddress());){
                if (GoPcHeader.isPcHeader(bp)) {
                    Address address = pcHeaderAddr;
                    return address;
                }
            }
            range = new AddressRangeImpl(pcHeaderAddr.next(), range.getMaxAddress());
        }
        return null;
    }

    public static boolean isPcHeader(ByteProvider provider) throws IOException {
        byte[] header = provider.readBytes(0L, 8L);
        if (provider.length() < 16L || header[4] != 0 || header[5] != 0 || header[6] != 1 && header[6] != 2 && header[6] != 4 || header[7] != 4 && header[7] != 8) {
            return false;
        }
        return GoPcHeader.readMagic(provider) != null;
    }

    public static Structure createArtificialGoPcHeaderStructure(CategoryPath cp, DataTypeManager dtm) {
        StructureDataType struct = new StructureDataType(cp, GO_STRUCTURE_NAME, 0, dtm);
        struct.setDescription("Artificial structure created by Ghidra to represent the header of the pclntable");
        struct.setPackingEnabled(true);
        struct.add(AbstractIntegerDataType.getUnsignedDataType((int)4, null), "magic", null);
        struct.add(AbstractIntegerDataType.getUnsignedDataType((int)1, null), "pad1", null);
        struct.add(AbstractIntegerDataType.getUnsignedDataType((int)1, null), "pad2", null);
        struct.add(AbstractIntegerDataType.getUnsignedDataType((int)1, null), "minLC", null);
        struct.add(AbstractIntegerDataType.getUnsignedDataType((int)1, null), "ptrSize", null);
        return struct;
    }

    public GoVer getGoVersion() {
        return GoPcHeader.magicToVer(this.magic);
    }

    public boolean hasTextStart() {
        return this.textStart != 0L;
    }

    public Address getTextStart() {
        return this.programContext.getDataAddress(this.textStart);
    }

    public Address getFuncnameAddress() {
        return this.funcnameOffset != 0L ? this.programContext.getDataAddress(this.context.getStructureStart() + this.funcnameOffset) : null;
    }

    public Address getCuAddress() {
        return this.cuOffset != 0L ? this.programContext.getDataAddress(this.context.getStructureStart() + this.cuOffset) : null;
    }

    public Address getFiletabAddress() {
        return this.filetabOffset != 0L ? this.programContext.getDataAddress(this.context.getStructureStart() + this.filetabOffset) : null;
    }

    public Address getPctabAddress() {
        return this.pctabOffset != 0L ? this.programContext.getDataAddress(this.context.getStructureStart() + this.pctabOffset) : null;
    }

    public Address getPclnAddress() {
        return this.pclnOffset != 0L ? this.programContext.getDataAddress(this.context.getStructureStart() + this.pclnOffset) : null;
    }

    public byte getMinLC() {
        return this.minLC;
    }

    public byte getPtrSize() {
        return this.ptrSize;
    }

    public int getMagic() {
        return this.magic;
    }

    private static GoVerEndian readMagic(ByteProvider provider) throws IOException {
        BinaryReader reader = new BinaryReader(provider, true);
        int magicInt = reader.readInt((DataConverter)LittleEndianDataConverter.INSTANCE, 0L);
        GoVer ver = GoPcHeader.magicToVer(magicInt);
        if (ver != GoVer.INVALID) {
            return new GoVerEndian(ver, Endian.LITTLE);
        }
        magicInt = reader.readInt((DataConverter)BigEndianDataConverter.INSTANCE, 0L);
        ver = GoPcHeader.magicToVer(magicInt);
        if (ver != GoVer.INVALID) {
            return new GoVerEndian(ver, Endian.BIG);
        }
        return null;
    }

    private static GoVer magicToVer(int magicInt) {
        return switch (magicInt) {
            case -5 -> new GoVer(1, 2, 0);
            case -6 -> new GoVer(1, 16, 0);
            case -16 -> new GoVer(1, 18, 0);
            case -15 -> new GoVer(1, 20, 0);
            default -> GoVer.INVALID;
        };
    }

    record GoVerEndian(GoVer goVer, Endian endian) {
        GoVerEndian(GoVer goVer, boolean isLittleEndian) {
            this(goVer, isLittleEndian ? Endian.LITTLE : Endian.BIG);
        }
    }
}

