/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.lang.ParallelInstructionLanguageHelper;
import ghidra.program.model.listing.Instruction;
import ghidra.program.util.ParallelInstructionLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;

public class ParallelInstructionFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Parallel ||";

    public ParallelInstructionFieldFactory() {
        super(FIELD_NAME);
    }

    private ParallelInstructionFieldFactory(FieldFormatModel model, ListingHighlightProvider hsProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hsProvider, displayOptions, fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof Instruction)) {
            return null;
        }
        Instruction instr = (Instruction)obj;
        ParallelInstructionLanguageHelper helper = instr.getProgram().getLanguage().getParallelInstructionHelper();
        if (helper == null) {
            return null;
        }
        String fieldText = helper.getMnemonicPrefix(instr);
        if (fieldText == null) {
            return null;
        }
        AttributedString as = new AttributedString(fieldText, (Color)ListingColors.PARALLEL_INSTRUCTION, this.getMetrics(), false, (Color)ListingColors.UNDERLINE);
        TextFieldElement text = new TextFieldElement(as, 0, 0);
        return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)text, this.startX + varWidth, this.width, this.hlProvider);
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof Instruction)) {
            return null;
        }
        Instruction instr = (Instruction)obj;
        return new ParallelInstructionLocation(instr.getProgram(), instr.getMinAddress(), col);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (programLoc instanceof ParallelInstructionLocation) {
            return new FieldLocation(index, fieldNum, 0, ((ParallelInstructionLocation)programLoc).getCharOffset());
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        return category == 4;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider hsProvider, ToolOptions toolOptinos, ToolOptions fieldOptions) {
        return new ParallelInstructionFieldFactory(formatModel, hsProvider, (Options)toolOptinos, (Options)fieldOptions);
    }
}

