/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model.columns;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.sort.ColumnRenderedValueBackupComparator;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.model.ColorsModified;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceClosedException;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.JTable;

public class TraceValueValColumn
extends AbstractDynamicTableColumn<ObjectTableModel.ValueRow, ObjectTableModel.ValueRow, Trace> {
    private Color diffColor = DebuggerResources.COLOR_VALUE_CHANGED;
    private Color diffColorSel = DebuggerResources.COLOR_VALUE_CHANGED_SEL;
    private final ValRenderer renderer = new ValRenderer();

    public String getColumnName() {
        return "Value";
    }

    public ObjectTableModel.ValueRow getValue(ObjectTableModel.ValueRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
        return rowObject;
    }

    public GColumnRenderer<ObjectTableModel.ValueRow> getColumnRenderer() {
        return this.renderer;
    }

    public Comparator<ObjectTableModel.ValueRow> getComparator(DynamicColumnTableModel<?> model, int columnIndex) {
        return this.getComparator().thenComparing((Comparator<ObjectTableModel.ValueRow>)new ColumnRenderedValueBackupComparator(model, columnIndex));
    }

    public Comparator<ObjectTableModel.ValueRow> getComparator() {
        return (r1, r2) -> {
            Object v1 = r1.getValue().getValue();
            Object v2 = r2.getValue().getValue();
            if (v1 instanceof Comparable && v1.getClass() == v2.getClass()) {
                return ((Comparable)v1).compareTo(v2);
            }
            return 0;
        };
    }

    public void setDiffColor(Color diffColor) {
        this.diffColor = diffColor;
    }

    public void setDiffColorSel(Color diffColorSel) {
        this.diffColorSel = diffColorSel;
    }

    private final class ValRenderer
    extends AbstractGColumnRenderer<ObjectTableModel.ValueRow>
    implements ColorsModified.InTable {
        private ValRenderer() {
            this.setHTMLRenderingEnabled(true);
        }

        public String getFilterString(ObjectTableModel.ValueRow t, Settings settings) {
            return t.getDisplay();
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            ObjectTableModel.ValueRow row = (ObjectTableModel.ValueRow)data.getValue();
            try {
                this.setText(row.getHtmlDisplay());
                this.setToolTipText(row.getToolTip());
                this.setForeground(this.getForegroundFor(data.getTable(), row.isModified(), data.isSelected()));
                if (row.isCurrent()) {
                    this.setBold();
                }
            }
            catch (TraceClosedException e) {
                this.setText("ERROR: Trace Closed");
                this.setToolTipText("This row is stale, since it refers to a trace that has since been closed");
                this.setForeground(this.getForegroundFor(data.getTable(), false, data.isSelected()));
            }
            return this;
        }

        @Override
        public Color getDiffForeground(JTable table) {
            return TraceValueValColumn.this.diffColor;
        }

        @Override
        public Color getDiffSelForeground(JTable table) {
            return TraceValueValColumn.this.diffColorSel;
        }
    }
}

