/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.dd;

import ghidra.program.model.data.ISF.IsfObject;
import ghidra.program.model.data.ISF.IsfSetting;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sarif.export.dd.ExtComment;

public class ExtCommentSet
implements IsfObject {
    List<ExtComment> comment;
    List<IsfSetting> setting;
    Map<Integer, ExtCommentSet> embedded;

    public ExtCommentSet(Data data) {
        this.exportComments(data);
        int n = data.getNumComponents();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Data component = data.getComponent(i);
                ExtCommentSet cs = new ExtCommentSet(component);
                if (cs.comment == null && cs.setting == null && cs.embedded == null) continue;
                if (this.embedded == null) {
                    this.embedded = new HashMap<Integer, ExtCommentSet>();
                }
                this.embedded.put(i, cs);
            }
        }
    }

    private void exportComments(Data data) {
        ExtComment isf;
        for (CommentType commentType : CommentType.values()) {
            String cval = data.getComment(commentType);
            if (cval == null) continue;
            if (this.comment == null) {
                this.comment = new ArrayList<ExtComment>();
            }
            isf = new ExtComment(data, commentType);
            this.comment.add(isf);
        }
        for (String string : data.getNames()) {
            Object value = data.getValue(string);
            if (value == null) continue;
            if (this.setting == null) {
                this.setting = new ArrayList<IsfSetting>();
            }
            isf = new IsfSetting(string, value);
            this.setting.add((IsfSetting)isf);
        }
    }
}

