/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.AbstractIterativeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.repulsion.BarnesHutFRRepulsion;
import org.jungrapht.visualization.layout.algorithms.repulsion.StandardFRRepulsion;
import org.jungrapht.visualization.layout.algorithms.util.IterativeContext;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FRLayoutAlgorithm<V>
extends AbstractIterativeLayoutAlgorithm<V>
implements IterativeContext {
    private static final Logger log = LoggerFactory.getLogger(FRLayoutAlgorithm.class);
    private double forceConstant;
    private double temperature;
    private int currentIteration;
    private int maxIterations;
    protected Map<V, Point> frVertexData = new ConcurrentHashMap<V, Point>();
    protected Function<V, Point> initializer = v -> Point.ORIGIN;
    private double attractionMultiplier = 0.75;
    protected double attractionConstant;
    private double repulsionMultiplier = 0.75;
    protected double repulsionConstant;
    private double max_dimension;
    private boolean initialized = false;
    protected StandardFRRepulsion.Builder repulsionContractBuilder;
    protected StandardFRRepulsion repulsionContract;
    protected double EPSILON = 1.0E-6;

    public static <V> Builder<V, ?, ?> builder() {
        return new Builder();
    }

    public FRLayoutAlgorithm() {
        this(FRLayoutAlgorithm.builder());
    }

    protected FRLayoutAlgorithm(Builder<V, ?, ?> builder) {
        super(builder);
        this.repulsionContractBuilder = builder.repulsionContractBuilder;
        this.maxIterations = builder.maxIterations;
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        Graph graph;
        super.visit(layoutModel);
        if (log.isTraceEnabled()) {
            log.trace("visiting " + layoutModel);
        }
        if ((graph = layoutModel.getGraph()) == null || graph.vertexSet().isEmpty()) {
            return;
        }
        this.max_dimension = Math.max(layoutModel.getWidth(), layoutModel.getHeight());
        this.initialize();
        this.repulsionContract = ((StandardFRRepulsion.Builder)((StandardFRRepulsion.Builder)((StandardFRRepulsion.Builder)((StandardFRRepulsion.Builder)((StandardFRRepulsion.Builder)this.repulsionContractBuilder.layoutModel((LayoutModel)layoutModel)).nodeData(this.frVertexData)).initializer(this.initializer)).repulsionConstant(this.repulsionConstant)).random(this.random)).build();
    }

    public void setAttractionMultiplier(double attraction) {
        this.attractionMultiplier = attraction;
    }

    public void setRepulsionMultiplier(double repulsion) {
        this.repulsionMultiplier = repulsion;
    }

    public void initialize() {
        this.doInit();
    }

    private void doInit() {
        Graph graph = this.layoutModel.getGraph();
        if (graph != null && graph.vertexSet().size() > 0) {
            this.currentIteration = 0;
            this.temperature = this.layoutModel.getWidth() / 10;
            this.forceConstant = Math.sqrt((double)this.layoutModel.getHeight() * (double)this.layoutModel.getWidth() / (double)graph.vertexSet().size());
            this.attractionConstant = this.attractionMultiplier * this.forceConstant;
            this.repulsionConstant = this.repulsionMultiplier * this.forceConstant;
            this.initialized = true;
        }
    }

    @Override
    public synchronized void step() {
        this.repulsionContract.step();
        if (!this.initialized) {
            this.doInit();
        }
        Graph graph = this.layoutModel.getGraph();
        ++this.currentIteration;
        while (true) {
            try {
                this.repulsionContract.calculateRepulsion();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        while (true) {
            try {
                for (Object edge : graph.edgeSet()) {
                    this.calcAttraction(edge);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        while (true) {
            try {
                for (Object vertex : graph.vertexSet()) {
                    if (this.layoutModel.isLocked(vertex)) continue;
                    if (this.cancelled) {
                        return;
                    }
                    this.calcPositions(vertex);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        this.cool();
    }

    protected synchronized void calcPositions(V vertex) {
        Point fvd = this.getFRData(vertex);
        if (fvd == null) {
            return;
        }
        Point xyd = (Point)this.layoutModel.apply(vertex);
        double deltaLength = Math.max(this.EPSILON, fvd.length());
        double positionX = xyd.x;
        double positionY = xyd.y;
        double newXDisp = fvd.x / deltaLength * Math.min(deltaLength, this.temperature);
        double newYDisp = fvd.y / deltaLength * Math.min(deltaLength, this.temperature);
        positionX += newXDisp;
        positionY += newYDisp;
        double borderWidth = (double)this.layoutModel.getWidth() / 50.0;
        if (positionX < borderWidth) {
            positionX = borderWidth + this.random.nextDouble() * borderWidth * 2.0;
        } else if (positionX > (double)this.layoutModel.getWidth() - borderWidth * 2.0) {
            positionX = (double)this.layoutModel.getWidth() - borderWidth - this.random.nextDouble() * borderWidth * 2.0;
        }
        if (positionY < borderWidth) {
            positionY = borderWidth + this.random.nextDouble() * borderWidth * 2.0;
        } else if (positionY > (double)this.layoutModel.getWidth() - borderWidth * 2.0) {
            positionY = (double)this.layoutModel.getWidth() - borderWidth - this.random.nextDouble() * borderWidth * 2.0;
        }
        this.layoutModel.set(vertex, positionX, positionY);
    }

    protected void calcAttraction(Object edge) {
        Graph graph = this.layoutModel.getGraph();
        Object vertex1 = graph.getEdgeSource(edge);
        Object vertex2 = graph.getEdgeTarget(edge);
        boolean v1_locked = this.layoutModel.isLocked(vertex1);
        boolean v2_locked = this.layoutModel.isLocked(vertex2);
        if (v1_locked && v2_locked) {
            return;
        }
        Point p1 = (Point)this.layoutModel.apply(vertex1);
        Point p2 = (Point)this.layoutModel.apply(vertex2);
        if (p1 == null || p2 == null) {
            return;
        }
        double xDelta = p1.x - p2.x;
        double yDelta = p1.y - p2.y;
        double deltaLength = Math.max(this.EPSILON, Math.sqrt(xDelta * xDelta + yDelta * yDelta));
        double force = deltaLength * deltaLength / this.attractionConstant;
        if (Double.isNaN(force)) {
            throw new IllegalArgumentException("Unexpected mathematical result in FRLayout:calcPositions [force]");
        }
        double dx = xDelta / deltaLength * force;
        double dy = yDelta / deltaLength * force;
        if (!v1_locked) {
            Point fvd1 = this.getFRData(vertex1);
            this.frVertexData.put((Point)vertex1, fvd1.add(-dx, -dy));
        }
        if (!v2_locked) {
            Point fvd2 = this.getFRData(vertex2);
            this.frVertexData.put((Point)vertex2, fvd2.add(dx, dy));
        }
    }

    private void cool() {
        this.temperature *= 1.0 - (double)this.currentIteration / (double)this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    protected Point getFRData(V vertex) {
        return this.frVertexData.computeIfAbsent((Point)vertex, (Function<Point, Point>)this.initializer);
    }

    public String toString() {
        return "FRLayoutAlgorithm{repulsionContract=" + this.repulsionContract + "}";
    }

    @Override
    public boolean done() {
        boolean done;
        if (this.cancelled) {
            return true;
        }
        boolean bl = done = this.currentIteration > this.maxIterations || this.temperature < 1.0 / this.max_dimension;
        if (done) {
            this.runAfter();
        }
        return done;
    }

    public static class Builder<V, T extends FRLayoutAlgorithm<V>, B extends Builder<V, T, B>>
    extends AbstractIterativeLayoutAlgorithm.Builder<V, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        private StandardFRRepulsion.Builder repulsionContractBuilder = new BarnesHutFRRepulsion.Builder();
        private int maxIterations = 700;

        public B repulsionContractBuilder(StandardFRRepulsion.Builder repulsionContractBuilder) {
            this.repulsionContractBuilder = repulsionContractBuilder;
            return (B)((Builder)this.self());
        }

        public B maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new FRLayoutAlgorithm(this);
        }
    }
}

