/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AddressMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.NameMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ProcedureFlags;

public abstract class AbstractLabelMsSymbol
extends AbstractMsSymbol
implements AddressMsSymbol,
NameMsSymbol {
    protected long offset;
    protected int segment;
    protected ProcedureFlags flags;
    protected String name;

    public AbstractLabelMsSymbol(AbstractPdb pdb, PdbByteReader reader, int offsetSize, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.offset = reader.parseVarSizedOffset(offsetSize);
        this.segment = pdb.parseSegment(reader);
        this.flags = new ProcedureFlags(reader);
        this.name = reader.parseString(pdb, strType);
        reader.align4();
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public int getSegment() {
        return this.segment;
    }

    public ProcedureFlags getFlags() {
        return this.flags;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: [%04X:%08X], %s %s\n", this.getSymbolTypeName(), this.segment, this.offset, this.name, this.flags.toString()));
    }
}

