/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.jar.ResourceFile;
import generic.theme.AbstractThemeReader;
import generic.theme.ColorValue;
import generic.theme.FontValue;
import generic.theme.GThemeValueMap;
import generic.theme.IconValue;
import generic.theme.LafType;
import generic.theme.ThemeValue;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class ThemePropertyFileReader
extends AbstractThemeReader {
    private GThemeValueMap defaults = new GThemeValueMap();
    private GThemeValueMap darkDefaults = new GThemeValueMap();
    private Map<LafType, GThemeValueMap> customSectionsMap = new HashMap<LafType, GThemeValueMap>();
    private boolean defaultSectionProcessed;

    public ThemePropertyFileReader(ResourceFile file) throws IOException {
        super(file.getAbsolutePath());
        try (InputStreamReader reader = new InputStreamReader(file.getInputStream());){
            this.read(reader);
        }
    }

    protected ThemePropertyFileReader(String source, Reader reader) throws IOException {
        super(source);
        this.read(reader);
    }

    public GThemeValueMap getDefaultValues() {
        return this.defaults;
    }

    public GThemeValueMap getDarkDefaultValues() {
        return this.darkDefaults;
    }

    public Map<LafType, GThemeValueMap> getLookAndFeelSections() {
        return this.customSectionsMap;
    }

    @Override
    protected void processNoSection(AbstractThemeReader.Section section) throws IOException {
        if (!section.isEmpty()) {
            this.error(section.getLineNumber(), "Theme properties file has values defined outside of a defined section");
        }
    }

    @Override
    protected void processDefaultSection(AbstractThemeReader.Section section) throws IOException {
        this.defaultSectionProcessed = true;
        this.processValues(this.defaults, section);
    }

    @Override
    protected void processDarkDefaultSection(AbstractThemeReader.Section section) throws IOException {
        if (!this.defaultSectionProcessed) {
            this.error(section.getLineNumber(), "Defaults section must be defined before Dark Defaults section!");
            return;
        }
        this.processValues(this.darkDefaults, section);
        this.validate("Dark Defaults", this.darkDefaults);
    }

    @Override
    protected void processCustomSection(AbstractThemeReader.Section section) throws IOException {
        String name = section.getName();
        LafType lafType = LafType.fromName(name);
        if (lafType == null) {
            this.error(section.getLineNumber(), "Unknown Look and Feel section found: " + name);
            return;
        }
        if (!this.defaultSectionProcessed) {
            this.error(section.getLineNumber(), "Defaults section must be defined before " + name + " section!");
            return;
        }
        GThemeValueMap customValues = new GThemeValueMap();
        this.processValues(customValues, section);
        this.customSectionsMap.put(lafType, customValues);
        this.validate(name, customValues);
    }

    private void validate(String name, GThemeValueMap valuesMap) {
        ThemeValue value;
        for (String id : valuesMap.getColorIds()) {
            if (this.defaults.containsColor(id) || ((ColorValue)(value = valuesMap.getColor(id))).isExternal()) continue;
            this.reportMissingDefaultsError("Color", name, id);
        }
        for (String id : valuesMap.getFontIds()) {
            if (this.defaults.containsFont(id) || ((FontValue)(value = valuesMap.getFont(id))).isExternal()) continue;
            this.reportMissingDefaultsError("Font", name, id);
        }
        for (String id : valuesMap.getIconIds()) {
            if (this.defaults.containsIcon(id) || ((IconValue)(value = valuesMap.getIcon(id))).isExternal()) continue;
            this.reportMissingDefaultsError("Icon", name, id);
        }
    }

    private void reportMissingDefaultsError(String type, String name, String id) {
        String message = type + " id found in \"" + name + "\" section, but not defined in \"Defaults\" section: " + id;
        this.error(-1, message);
    }
}

