/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm;

import org.jetbrains.coverage.org.objectweb.asm.ByteVector;
import org.jetbrains.coverage.org.objectweb.asm.Label;

final class Handler {
    final Label startPc;
    final Label endPc;
    final Label handlerPc;
    final int catchType;
    final String catchTypeDescriptor;
    Handler nextHandler;

    /*
     * WARNING - void declaration
     */
    Handler(Label startPc, Label endPc, Label handlerPc, int catchType, String catchTypeDescriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.startPc = var1_1;
        this.endPc = var2_2;
        this.handlerPc = var3_3;
        this.catchType = catchType;
        this.catchTypeDescriptor = catchTypeDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    Handler(Handler handler, Label startPc, Label endPc) {
        this((Label)var2_2, (Label)var3_3, handler.handlerPc, handler.catchType, handler.catchTypeDescriptor);
        void var1_1;
        void var3_3;
        void var2_2;
        this.nextHandler = var1_1.nextHandler;
    }

    /*
     * WARNING - void declaration
     */
    static Handler removeRange(Handler firstHandler, Label start, Label end) {
        void var1_1;
        Handler handler;
        void var2_2;
        void var3_3;
        int rangeEnd;
        if (firstHandler == null) {
            return null;
        }
        firstHandler.nextHandler = Handler.removeRange(firstHandler.nextHandler, start, end);
        int handlerStart = firstHandler.startPc.bytecodeOffset;
        int handlerEnd = firstHandler.endPc.bytecodeOffset;
        int rangeStart = start.bytecodeOffset;
        int n = rangeEnd = end == null ? Integer.MAX_VALUE : end.bytecodeOffset;
        if (rangeStart >= handlerEnd || rangeEnd <= handlerStart) {
            return firstHandler;
        }
        if (rangeStart <= var3_3) {
            if (rangeEnd >= handlerEnd) {
                return firstHandler.nextHandler;
            }
            return new Handler(firstHandler, end, firstHandler.endPc);
        }
        if (rangeEnd >= handlerEnd) {
            Handler handler2 = firstHandler;
            return new Handler(handler2, handler2.startPc, start);
        }
        firstHandler.nextHandler = new Handler(firstHandler, (Label)var2_2, firstHandler.endPc);
        Handler handler3 = handler;
        return new Handler(handler3, handler3.startPc, (Label)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static int getExceptionTableLength(Handler firstHandler) {
        void var1_1;
        Handler handler;
        int length = 0;
        while (handler != null) {
            ++length;
            handler = handler.nextHandler;
        }
        return (int)var1_1;
    }

    static int getExceptionTableSize(Handler firstHandler) {
        Handler handler;
        return 2 + 8 * Handler.getExceptionTableLength(handler);
    }

    static void putExceptionTable(Handler firstHandler, ByteVector output) {
        Handler handler;
        output.putShort(Handler.getExceptionTableLength(firstHandler));
        while (handler != null) {
            output.putShort(handler.startPc.bytecodeOffset).putShort(handler.endPc.bytecodeOffset).putShort(handler.handlerPc.bytecodeOffset).putShort(handler.catchType);
            handler = handler.nextHandler;
        }
    }
}

