/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en.translation;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.GlobalConfig;
import org.languagetool.Languages;
import org.languagetool.rules.en.translation.Inflector;
import org.languagetool.rules.translation.DataSource;
import org.languagetool.rules.translation.TranslationEntry;
import org.languagetool.rules.translation.Translator;
import org.languagetool.tagging.Tagger;
import org.languagetool.tools.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeoLingusTranslator
implements Translator {
    private static final Logger logger = LoggerFactory.getLogger(BeoLingusTranslator.class);
    private static final Pattern enUsPattern = Pattern.compile(".*?\\w+ \\[(Br|Am)\\.\\] ?/ ?\\w+ \\[(Br|Am)\\.\\].*");
    private static BeoLingusTranslator instance;
    private static final Set<String> verbsWithTo;
    private final Tagger tagger;
    private final Map<String, List<TranslationEntry>> de2en = new HashMap<String, List<TranslationEntry>>();
    private final Map<String, List<TranslationEntry>> en2de = new HashMap<String, List<TranslationEntry>>();
    private final Inflector inflector = new Inflector();

    public static synchronized BeoLingusTranslator getInstance(File beolingusFile) throws IOException {
        GlobalConfig config = new GlobalConfig();
        config.setBeolingusFile(beolingusFile);
        return BeoLingusTranslator.getInstance(config);
    }

    public static synchronized BeoLingusTranslator getInstance(GlobalConfig globalConfig) throws IOException {
        if (instance == null && globalConfig != null && globalConfig.getBeolingusFile() != null) {
            long t1 = System.currentTimeMillis();
            logger.info("Init dict from " + globalConfig.getBeolingusFile() + "...");
            instance = new BeoLingusTranslator(globalConfig.getBeolingusFile());
            long t2 = System.currentTimeMillis();
            logger.info("Init dict done (" + (t2 - t1) + "ms) - loaded " + instance.getDeEnSize() + " de -> en items.");
        }
        return instance;
    }

    public BeoLingusTranslator(File file) throws IOException {
        this.tagger = Languages.getLanguageForShortCode((String)"de").getTagger();
        List<String> lines = Files.readAllLines(file.toPath());
        for (String line : lines) {
            String[] englishParts;
            if (line.trim().isEmpty() || line.startsWith("#")) continue;
            String[] parts = line.split(" :: ");
            String german = parts[0];
            String english = parts[1];
            String[] germanParts = german.split("\\|");
            if (germanParts.length != (englishParts = english.split("\\|")).length) {
                throw new IOException("Invalid line format (DE item count != EN item count): " + line);
            }
            int i = 0;
            for (String germanPart : germanParts) {
                this.handleItem(this.de2en, germanParts, englishParts, i, germanPart);
                ++i;
            }
        }
    }

    private void handleItem(Map<String, List<TranslationEntry>> map, String[] germanParts, String[] englishParts, int i, String germanPart) {
        germanPart = germanPart.replaceAll("/.*?/", "");
        List<String> germanSubParts = this.split(germanPart);
        for (String germanSubPart : germanSubParts) {
            String key = this.cleanForLookup(germanSubPart);
            List<TranslationEntry> oldEntries = map.get(key);
            if (oldEntries != null) {
                if (englishParts[i].trim().isEmpty()) continue;
                oldEntries.add(new TranslationEntry(this.split(germanPart), this.split(englishParts[i].trim()), germanParts.length));
                map.put(key, oldEntries);
                continue;
            }
            ArrayList<TranslationEntry> l = new ArrayList<TranslationEntry>();
            if (englishParts[i].trim().isEmpty()) continue;
            l.add(new TranslationEntry(this.split(germanPart), this.split(englishParts[i]), germanParts.length));
            map.put(key, l);
        }
    }

    public List<String> split(String s) {
        List<String> parts = this.splitAtSemicolon(s);
        ArrayList<String> newParts = new ArrayList<String>();
        for (String part : parts) {
            if (enUsPattern.matcher(part).matches()) {
                String variant1 = part.replaceFirst("^(.*?)(\\w+) (\\[(?:Br|Am)\\.\\]) ?/ ?\\w+ \\[(?:Br|Am)\\.\\](.*)", "$1$2$4 $3");
                String variant2 = part.replaceFirst("^(.*?)(\\w+) (\\[(?:Br|Am)\\.\\]) ?/ ?(\\w+) (\\[(?:Br|Am)\\.\\])(.*)", "$1$4$6 $5");
                newParts.add(variant1);
                newParts.add(variant2);
                continue;
            }
            newParts.add(part);
        }
        return newParts;
    }

    int getDeEnSize() {
        return this.de2en.size();
    }

    List<String> splitAtSemicolon(String s) {
        List list = Arrays.stream(s.split(";\\s+")).map(k -> k.trim()).collect(Collectors.toList());
        ArrayList<String> mergedList = new ArrayList<String>();
        int mergeListPos = 0;
        boolean merging = false;
        for (String item : list) {
            int openPos = item.indexOf(123);
            int closePos = item.indexOf(125);
            if (merging) {
                mergedList.set(mergeListPos - 1, (String)mergedList.get(mergeListPos - 1) + "; " + item);
                --mergeListPos;
                if (closePos >= 0) {
                    merging = false;
                }
            } else if (openPos > closePos) {
                mergedList.add(item);
                merging = true;
            } else {
                mergedList.add(item);
            }
            ++mergeListPos;
        }
        return mergedList;
    }

    public List<TranslationEntry> translate(String term, String fromLang, String toLang) {
        Map<String, List<TranslationEntry>> map;
        if (fromLang.equals("de") && toLang.equals("en")) {
            map = this.de2en;
        } else if (fromLang.equals("en") && toLang.equals("de")) {
            map = this.en2de;
        } else {
            throw new RuntimeException("Not supported: " + fromLang + " -> " + toLang);
        }
        List<TranslationEntry> entries = map.get(term.toLowerCase());
        HashSet<TranslationEntry> entriesSet = new HashSet<TranslationEntry>();
        if (entries != null) {
            entriesSet.addAll(entries);
        }
        List<TranslationEntry> translationsForBaseforms = this.getTranslationsForBaseforms(term, map);
        for (TranslationEntry trans : translationsForBaseforms) {
            if (entries != null) {
                Optional<TranslationEntry> first = entries.stream().filter(k -> k.getL1().equals(trans.getL1())).findFirst();
                if (first.isPresent() && first.get().getL1().equals(trans.getL1())) continue;
                entriesSet.add(trans);
                continue;
            }
            entriesSet.add(trans);
        }
        ArrayList<TranslationEntry> sortedList = new ArrayList<TranslationEntry>(entriesSet);
        Collections.sort(sortedList, (t1, t2) -> Integer.compare(t2.getItemCount(), t1.getItemCount()));
        return sortedList;
    }

    @NotNull
    private List<TranslationEntry> getTranslationsForBaseforms(String term, Map<String, List<TranslationEntry>> map) {
        ArrayList<TranslationEntry> result = new ArrayList<TranslationEntry>();
        try {
            List readings = this.tagger.tag(Collections.singletonList(term));
            readings.addAll(this.tagger.tag(Collections.singletonList(StringTools.uppercaseFirstChar((String)term))));
            for (AnalyzedTokenReadings reading : readings) {
                List aTokens = reading.getReadings();
                this.addResultsForTokens(map, aTokens, result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not tag '" + term + "'", e);
        }
    }

    private void addResultsForTokens(Map<String, List<TranslationEntry>> map, List<AnalyzedToken> aTokens, List<TranslationEntry> result) {
        for (AnalyzedToken aToken : aTokens) {
            List<TranslationEntry> tmp;
            String lemma = aToken.getLemma();
            if (lemma == null || (tmp = map.get(lemma.toLowerCase())) == null) continue;
            for (TranslationEntry tmpEntry : tmp) {
                TranslationEntry entry;
                if (result.contains(tmpEntry) || (entry = this.cleanTranslationEntry(tmpEntry, aToken)) == null) continue;
                result.add(entry);
            }
        }
    }

    private TranslationEntry cleanTranslationEntry(TranslationEntry tmpEntry, AnalyzedToken aToken) {
        ArrayList<String> l = new ArrayList<String>();
        for (String s : tmpEntry.getL2()) {
            List<String> inflected = this.inflector.inflect(this.cleanTranslationForReplace(s, null), aToken.getPOSTag());
            for (String inflectedForm : inflected) {
                String cleanEntry = inflectedForm + " " + this.getTranslationSuffix(s);
                l.add(cleanEntry.trim());
            }
        }
        return l.size() > 0 ? new TranslationEntry(tmpEntry.getL1(), l, tmpEntry.getItemCount()) : null;
    }

    private String cleanForLookup(String s) {
        return s.replaceAll("\\{.*?\\}", "").replaceAll("\\[.*?\\]", "").replaceAll("\\(.*?\\)", "").replaceAll("/.*?/\\b", "").replace("jdn./etw. ", "").replace("jdm./etw. ", "").replace("etw./jdn. ", "").replace("etw./jdm. ", "").replace("etw. ", "").replace("jdn. ", "").replace("jdm. ", "").trim().toLowerCase();
    }

    public String cleanTranslationForReplace(String s, String prevWord) {
        String clean = s.replaceAll("\\[.*?\\]", "").replaceAll("\\{.*?\\}", "").replaceAll("\\(.*?\\)", "").replace("sth./sb.", "").replace("sb./sth.", "").replace("sth.", "").replace("sb.", "").replaceAll("/[A-Z]+/", "").replaceAll(" /[A-Z][a-z]+\\.?/", "").replace("<> ", "").replaceAll("<(.*)>", "").replaceAll("\\s+", " ").trim();
        if ("to".equals(prevWord) && clean.startsWith("to ")) {
            return clean.substring(3);
        }
        if (!"to".equals(prevWord) && clean.startsWith("to ") && !verbsWithTo.contains(prevWord)) {
            return clean.substring(3);
        }
        return clean;
    }

    public String getMessage() {
        return "Translate to English?";
    }

    public String getTranslationSuffix(String s) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> lookingFor = new ArrayList<String>();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '[') {
                lookingFor.add("]");
            } else if (c == ']' && lookingFor.contains("]")) {
                sb.append(c);
                sb.append(' ');
                lookingFor.remove("]");
            } else if (c == '<') {
                lookingFor.add(">");
            } else if (c == '>' && lookingFor.contains(">")) {
                sb.append(c);
                sb.append(' ');
                lookingFor.remove(">");
            } else if (c == '(') {
                lookingFor.add(")");
            } else if (c == ')') {
                sb.append(c);
                sb.append(' ');
                lookingFor.remove(")");
            } else if (c == '{') {
                lookingFor.add("}");
            } else if (c == '}') {
                sb.append(c);
                sb.append(' ');
                lookingFor.remove("}");
            }
            if (lookingFor.size() <= 0) continue;
            sb.append(c);
        }
        return sb.toString().trim();
    }

    public DataSource getDataSource() {
        return new DataSource("https://www.gnu.org/licenses/old-licenses/gpl-2.0.en.html", "BEOLINGUS", "http://dict.tu-chemnitz.de");
    }

    static {
        verbsWithTo = new HashSet<String>(Arrays.asList("afford", "agree", "aim", "appear", "arrange", "attempt", "beg", "care", "choose", "claim", "condescend", "consent", "dare", "decide", "demand", "deserve", "determine", "endeavour", "expect", "fail", "forget", "guarantee", "happen", "have", "help", "hesitate", "hope", "learn", "long", "manage", "mean", "need", "neglect", "offer", "plan", "prepare", "pretend", "proceed", "promise", "refuse", "resolve", "seem", "stop", "swear", "tend", "threaten", "trouble", "undertake", "volunteer", "vow", "want", "wish"));
    }
}

