/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.juife.Dial;
import org.jsampler.CC;
import org.jsampler.view.fantasia.Channel;
import org.jsampler.view.fantasia.ChannelOptionsView;
import org.jsampler.view.fantasia.ChannelScreen;
import org.jsampler.view.fantasia.ChannelView;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.NormalChannelOptionsView;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.basic.FantasiaPainter;
import org.jsampler.view.fantasia.basic.PixmapButton;
import org.jsampler.view.fantasia.basic.PixmapPane;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.linuxsampler.lscp.SamplerChannel;

public class NormalChannelView
extends JPanel
implements ChannelView {
    private final Channel channel;
    private ChannelOptionsView channelOptionsView = null;
    private final EnhancedDial dialVolume = new EnhancedDial();
    private final ChannelScreen screen;
    private final Channel.PowerButton btnPower;
    private final MuteButton btnMute = new MuteButton();
    private final SoloButton btnSolo = new SoloButton();
    private final Channel.OptionsButton btnOptions;
    private final Vector<JComponent> components = new Vector();
    private final EventHandler eventHandler = new EventHandler();

    public NormalChannelView(Channel channel) {
        this.components.add(this);
        this.channel = channel;
        this.btnPower = new Channel.PowerButton(channel);
        this.components.add(this.btnPower);
        this.btnOptions = new Channel.OptionsButton(channel);
        this.components.add(this.btnOptions);
        this.screen = new ChannelScreen(channel);
        this.setLayout(new BoxLayout(this, 0));
        this.btnPower.setAlignmentY(0.0f);
        JPanel jPanel = new JPanel();
        this.components.add(jPanel);
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 4));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setOpaque(false);
        jPanel.setAlignmentY(0.0f);
        jPanel.add(this.btnPower);
        jPanel.setPreferredSize(new Dimension(jPanel.getPreferredSize().width, 58));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        this.add(jPanel);
        this.add(this.createVSeparator());
        JPanel jPanel2 = new JPanel();
        this.components.add(jPanel2);
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 3, 0, 2));
        jPanel2.add(this.screen);
        this.add(jPanel2);
        this.add(this.createVSeparator());
        jPanel2 = new JPanel();
        this.components.add(jPanel2);
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        JLabel jLabel = new JLabel(Res.gfxMuteTitle);
        this.components.add(jLabel);
        jPanel2.add(jLabel);
        this.components.add(this.btnMute);
        jPanel2.add(this.btnMute);
        jLabel = new JLabel(Res.gfxSoloTitle);
        this.components.add(jLabel);
        jPanel2.add(jLabel);
        this.components.add(this.btnSolo);
        jPanel2.add(this.btnSolo);
        this.add(jPanel2);
        this.add(this.createVSeparator());
        jPanel2 = new JPanel();
        this.components.add(jPanel2);
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        jLabel = new JLabel(Res.gfxVolumeTitle);
        this.components.add(jLabel);
        jLabel.setAlignmentX(0.5f);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        jPanel2.add(jLabel);
        this.components.add(this.dialVolume);
        this.dialVolume.setDialPixmap(Res.gfxVolumeDial, 30, 330);
        this.dialVolume.setAlignmentX(0.5f);
        jPanel2.add(this.dialVolume);
        this.add(jPanel2);
        this.add(this.createVSeparator());
        jPanel2 = new JPanel();
        this.components.add(jPanel2);
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(27, 0, 0, 0));
        jLabel = new JLabel(Res.gfxOptionsTitle);
        this.components.add(jLabel);
        jLabel.setAlignmentX(0.5f);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        jPanel2.add(jLabel);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 3)));
        this.btnOptions.setAlignmentX(0.5f);
        jPanel2.add(this.btnOptions);
        this.add(jPanel2);
        this.setPreferredSize(new Dimension(420, 60));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.setAlignmentX(0.5f);
        this.installView();
    }

    @Override
    public ChannelView.Type getType() {
        return ChannelView.Type.NORMAL;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void installView() {
        String string = "volMeasurementUnitDecibel";
        FantasiaPrefs.preferences().addPropertyChangeListener(string, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = FantasiaPrefs.preferences().getBoolProperty("volMeasurementUnitDecibel");
                NormalChannelView.this.screen.updateVolumeInfo(NormalChannelView.this.dialVolume.getValue());
            }
        });
        this.screen.installListeners();
        this.addEnhancedMouseListener(this.channel.getContextMenu());
        this.addEnhancedMouseListener(this.getHandler());
    }

    @Override
    public void uninstallView() {
        this.screen.onDestroy();
        this.btnOptions.onDestroy();
        this.uninstallChannelOptionsView();
        this.removeEnhancedMouseListener(this.getHandler());
    }

    @Override
    public void installChannelOptionsView() {
        if (this.channelOptionsView != null) {
            return;
        }
        this.channelOptionsView = new NormalChannelOptionsView(this.channel);
        this.channelOptionsView.installView();
    }

    @Override
    public void uninstallChannelOptionsView() {
        if (this.channelOptionsView == null) {
            return;
        }
        this.channelOptionsView.uninstallView();
        this.channelOptionsView = null;
    }

    @Override
    public ChannelOptionsView getChannelOptionsView() {
        return this.channelOptionsView;
    }

    @Override
    public void updateChannelInfo() {
        SamplerChannel samplerChannel = this.channel.getChannelInfo();
        this.screen.updateScreenInfo(samplerChannel);
        float f = samplerChannel.getVolume() * 100.0f;
        this.screen.updateVolumeInfo((int)f);
        this.updateMuteIcon(samplerChannel);
        if (samplerChannel.isSoloChannel()) {
            this.btnSolo.setIcon(Res.gfxSoloOn);
        } else {
            this.btnSolo.setIcon(Res.gfxSoloOff);
        }
        this.dialVolume.setValue((int)(samplerChannel.getVolume() * 100.0f));
        boolean bl = samplerChannel.getEngine() != null;
        this.dialVolume.setEnabled(bl);
        this.btnSolo.setEnabled(bl);
        this.btnMute.setEnabled(bl);
        if (this.getChannelOptionsView() != null) {
            this.getChannelOptionsView().updateChannelInfo();
        }
    }

    @Override
    public void updateStreamCount(int n) {
        this.screen.updateStreamCount(n);
    }

    @Override
    public void updateVoiceCount(int n) {
        this.screen.updateVoiceCount(n);
    }

    @Override
    public void expandChannel() {
        if (this.btnOptions.isSelected()) {
            return;
        }
        this.btnOptions.doClick();
    }

    @Override
    public boolean isOptionsButtonSelected() {
        return this.btnOptions.isSelected();
    }

    @Override
    public void setOptionsButtonSelected(boolean bl) {
        this.btnOptions.setSelected(bl);
    }

    @Override
    public void addEnhancedMouseListener(MouseListener mouseListener) {
        this.removeEnhancedMouseListener(mouseListener);
        for (JComponent jComponent : this.components) {
            jComponent.addMouseListener(mouseListener);
        }
        this.screen.addEnhancedMouseListener(mouseListener);
    }

    @Override
    public void removeEnhancedMouseListener(MouseListener mouseListener) {
        for (JComponent jComponent : this.components) {
            jComponent.removeMouseListener(mouseListener);
        }
        this.screen.removeEnhancedMouseListener(mouseListener);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            super.paintComponent(graphics);
        }
        double d = this.getSize().getHeight();
        double d2 = this.getSize().getWidth();
        Color color = this.channel.isSelected() ? new Color(0x555555) : FantasiaPainter.color6;
        Color color2 = this.channel.isSelected() ? new Color(0x606060) : FantasiaPainter.color4;
        Graphics2D graphics2D = (Graphics2D)graphics;
        FantasiaPainter.paintGradient(graphics2D, 0.0, 0.0, d2 - 1.0, d - 1.0, color, color2);
        FantasiaPainter.paintOuterBorder(graphics2D, 0.0, 0.0, d2 - 1.0, d - 1.0, false, 0.27f, 0.11f, 0.64f, 0.2f);
    }

    private void updateMuteIcon(SamplerChannel samplerChannel) {
        if (samplerChannel.isMutedBySolo()) {
            this.btnMute.setIcon(Res.gfxMutedBySolo);
        } else if (samplerChannel.isMuted()) {
            this.btnMute.setIcon(Res.gfxMuteOn);
        } else {
            this.btnMute.setIcon(Res.gfxMuteOff);
        }
    }

    private void setVolume() {
        this.screen.updateVolumeInfo(this.dialVolume.getValue());
        if (this.dialVolume.getValueIsAdjusting()) {
            return;
        }
        int n = (int)(this.channel.getChannelInfo().getVolume() * 100.0f);
        if (n == this.dialVolume.getValue()) {
            return;
        }
        float f = this.dialVolume.getValue();
        this.channel.getModel().setBackendVolume(f /= 100.0f);
    }

    private JPanel createVSeparator() {
        PixmapPane pixmapPane = new PixmapPane(Res.gfxVLine);
        pixmapPane.setAlignmentY(0.0f);
        pixmapPane.setPreferredSize(new Dimension(2, 60));
        pixmapPane.setMinimumSize(pixmapPane.getPreferredSize());
        pixmapPane.setMaximumSize(pixmapPane.getPreferredSize());
        return pixmapPane;
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    private class EventHandler
    extends MouseAdapter {
        private EventHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3 && NormalChannelView.this.channel.isSelected()) {
                return;
            }
            CC.getMainFrame().getSelectedChannelsPane().processChannelSelection(NormalChannelView.this.channel, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
        }
    }

    private class SoloButton
    extends PixmapButton
    implements ActionListener {
        SoloButton() {
            super(Res.gfxSoloOff);
            this.setDisabledIcon(SubstanceImageCreator.makeTransparent(this, Res.gfxSoloOff, 0.4));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            SamplerChannel samplerChannel = NormalChannelView.this.channel.getChannelInfo();
            boolean bl2 = bl = !samplerChannel.isSoloChannel();
            if (bl) {
                this.setIcon(Res.gfxSoloOn);
                if (samplerChannel.isMutedBySolo()) {
                    NormalChannelView.this.btnMute.setIcon(Res.gfxMuteOff);
                }
            } else {
                this.setIcon(Res.gfxSoloOff);
                if (!samplerChannel.isMuted() && CC.getSamplerModel().getSoloChannelCount() > 1) {
                    NormalChannelView.this.btnMute.setIcon(Res.gfxMutedBySolo);
                }
            }
            NormalChannelView.this.channel.getModel().setBackendSolo(bl);
        }

        @Override
        public boolean contains(int n, int n2) {
            return n > 5 && n < 23 && n2 > 5 && n2 < 16;
        }
    }

    private class MuteButton
    extends PixmapButton
    implements ActionListener {
        MuteButton() {
            super(Res.gfxMuteOff);
            this.setDisabledIcon(SubstanceImageCreator.makeTransparent(this, Res.gfxMuteOff, 0.4));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SamplerChannel samplerChannel = NormalChannelView.this.channel.getChannelInfo();
            boolean bl = true;
            if (samplerChannel.isMuted() && !samplerChannel.isMutedBySolo()) {
                bl = false;
                boolean bl2 = CC.getSamplerModel().hasSoloChannel();
                if (samplerChannel.isSoloChannel() || !bl2) {
                    this.setIcon(Res.gfxMuteOff);
                } else {
                    this.setIcon(Res.gfxMutedBySolo);
                }
            } else {
                this.setIcon(Res.gfxMuteOn);
            }
            NormalChannelView.this.channel.getModel().setBackendMute(bl);
        }

        @Override
        public boolean contains(int n, int n2) {
            return n > 5 && n < 23 && n2 > 5 && n2 < 16;
        }
    }

    private class EnhancedDial
    extends Dial {
        EnhancedDial() {
            super(0, 100, 0);
            this.setMouseHandlerMode(Dial.MouseHandlerMode.LEFT_TO_RIGHT_AND_DOWN_TO_UP);
            int n = FantasiaPrefs.preferences().getIntProperty("maximumChannelVolume");
            this.setMaximum(n);
            String string = "maximumChannelVolume";
            FantasiaPrefs.preferences().addPropertyChangeListener(string, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    int n = FantasiaPrefs.preferences().getIntProperty("maximumChannelVolume");
                    EnhancedDial.this.setMaximum(n);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 3) {
                        EnhancedDial.this.setValue(EnhancedDial.this.getMaximum() / 2);
                        return;
                    }
                    if (mouseEvent.getButton() != 1) {
                        return;
                    }
                    if (mouseEvent.getClickCount() < 2) {
                        return;
                    }
                    EnhancedDial.this.setValue(EnhancedDial.this.getValueByPoint(mouseEvent.getPoint()));
                }
            });
            this.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    NormalChannelView.this.setVolume();
                }
            });
        }
    }
}

