/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.rules.patterns.AbstractPatternRule;

public class AbstractPatternRuleTest {
    @Test
    public void shortMessageIsLongerThanErrorMessage() throws IOException {
        for (Language lang : Languages.get()) {
            if (this.skipCountryVariant(lang)) {
                return;
            }
            JLanguageTool languageTool = new JLanguageTool(lang);
            for (AbstractPatternRule rule : this.getAllPatternRules(lang, languageTool)) {
                this.warnIfShortMessageLongerThanErrorMessage(rule);
            }
        }
    }

    private void warnIfShortMessageLongerThanErrorMessage(AbstractPatternRule rule) {
        int sizeOfErrorMessage;
        String shortMessage = rule.getShortMessage();
        int sizeOfShortMessage = shortMessage.length();
        if (sizeOfShortMessage >= (sizeOfErrorMessage = rule.getMessage().length())) {
            if (shortMessage.equals(rule.getMessage())) {
                System.err.println("Warning: The content of <short> and <message> are identical. No need for <short> tag in that case. <message>. Language: " + rule.language.getName() + ". Rule: " + rule.getFullId() + ":\n  <short>:   " + shortMessage + "\n  <message>: " + rule.getMessage());
            } else {
                System.err.println("Warning: The content of <short> should be shorter than the content of <message>. Language: " + rule.language.getName() + ". Rule: " + rule.getFullId() + ":\n  <short>:   " + shortMessage + "\n  <message>: " + rule.getMessage());
            }
        }
    }

    protected List<AbstractPatternRule> getAllPatternRules(Language language, JLanguageTool languageTool) throws IOException {
        ArrayList<AbstractPatternRule> rules = new ArrayList<AbstractPatternRule>();
        for (String patternRuleFileName : language.getRuleFileNames()) {
            rules.addAll(languageTool.loadPatternRules(patternRuleFileName));
        }
        return rules;
    }

    protected boolean skipCountryVariant(Language lang) {
        if (Languages.get().isEmpty() || ((Language)Languages.get().get(0)).equals((Object)lang)) {
            return false;
        }
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        boolean hasGrammarFiles = false;
        for (String grammarFile : this.getGrammarFileNames(lang)) {
            if (!dataBroker.ruleFileExists(grammarFile)) continue;
            hasGrammarFiles = true;
        }
        return !hasGrammarFiles && Languages.get().size() > 1;
    }

    protected List<String> getGrammarFileNames(Language lang) {
        String shortNameWithVariant = lang.getShortCodeWithCountryAndVariant();
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String ruleFile : lang.getRuleFileNames()) {
            String nameOnly = new File(ruleFile).getName();
            String fileName = shortNameWithVariant.contains("-x-") ? lang.getShortCode() + "/" + nameOnly : (shortNameWithVariant.contains("-") && !shortNameWithVariant.equals("xx-XX") && !shortNameWithVariant.endsWith("-ANY") && Languages.get().size() > 1 && !shortNameWithVariant.equals("de-DE") && !shortNameWithVariant.equals("ca-ES") ? lang.getShortCode() + "/" + shortNameWithVariant + "/" + nameOnly : lang.getShortCode() + "/" + nameOnly);
            if (fileNames.contains(fileName)) continue;
            fileNames.add(fileName);
        }
        return fileNames;
    }
}

