/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.osmand.data.FavouritePoint;
import net.osmand.data.LatLon;
import net.osmand.plus.FavouritesDbHelper;
import net.osmand.plus.MapMarkersHelper;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.actions.OffRoadAction;
import net.sourceforge.offroad.ui.FavoriteGroupRenderer;

public class AddFavoriteAction
extends OffRoadAction
implements DocumentListener {
    private JTextField mNameTextField;
    private JTextField mDescriptionTextField;
    private JComboBox<FavouritesDbHelper.FavoriteGroup> mComboBox;
    private DefaultComboBoxModel<FavouritesDbHelper.FavoriteGroup> mComboBoxModel;
    private JCheckBox mNewGroupCheckBox;
    private JTextField mGroupNameTextField;
    private JColorChooser mGroupColorChooser;
    private FavouritePoint mUpdatePoint;
    private JButton mOkButton;
    private int mInitialSelectedIndex = -1;

    public AddFavoriteAction(OsmWindow pContext, String pName, Icon pIcon, FavouritePoint pUpdatePoint) {
        super(pContext, pName, pIcon);
        this.mUpdatePoint = pUpdatePoint;
    }

    @Override
    public void actionPerformed(ActionEvent pE) {
        this.createDialog();
        this.mDialog.setTitle(this.getWindowTitle());
        Container contentPane = this.mDialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        gbl.columnWeights = new double[]{1.0};
        gbl.rowWeights = new double[]{1.0};
        contentPane.setLayout(gbl);
        int y = 0;
        contentPane.add((Component)new JLabel(this.getResourceString("offroad.favoriteName")), new GridBagConstraints(0, y, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mNameTextField = new JTextField();
        this.mNameTextField.getDocument().addDocumentListener(this);
        contentPane.add((Component)this.mNameTextField, new GridBagConstraints(1, y++, 2, 1, 4.0, 1.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        contentPane.add((Component)new JLabel(this.getResourceString("offroad.favoriteDescription")), new GridBagConstraints(0, y, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mDescriptionTextField = new JTextField();
        contentPane.add((Component)this.mDescriptionTextField, new GridBagConstraints(1, y++, 2, 1, 4.0, 1.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        contentPane.add((Component)new JLabel(this.getResourceString("offroad.favoriteGroup")), new GridBagConstraints(0, y, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mComboBox = new JComboBox();
        this.mComboBoxModel = new DefaultComboBoxModel();
        for (FavouritesDbHelper.FavoriteGroup filter : this.mContext.getFavorites().getFavoriteGroups()) {
            this.mComboBoxModel.addElement(filter);
        }
        this.mComboBox.setModel(this.mComboBoxModel);
        this.mComboBox.setFocusable(true);
        this.mComboBox.setRenderer(new FavoriteGroupRenderer());
        contentPane.add(this.mComboBox, new GridBagConstraints(1, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        contentPane.add((Component)new JLabel(this.getResourceString("offroad.favoriteNewGroup")), new GridBagConstraints(0, y, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.mNewGroupCheckBox = new JCheckBox();
        contentPane.add((Component)this.mNewGroupCheckBox, new GridBagConstraints(1, y++, 2, 1, 4.0, 1.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.mNewGroupCheckBox.addActionListener(t -> this.toggleNewGroup());
        contentPane.add((Component)new JLabel(this.getResourceString("offroad.favoriteGroupName")), new GridBagConstraints(0, y, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mGroupNameTextField = new JTextField();
        this.mGroupNameTextField.getDocument().addDocumentListener(this);
        contentPane.add((Component)this.mGroupNameTextField, new GridBagConstraints(1, y++, 2, 1, 4.0, 1.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        contentPane.add((Component)new JLabel(this.getResourceString("offroad.favoriteGroupColor")), new GridBagConstraints(0, y, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mGroupColorChooser = new JColorChooser();
        contentPane.add((Component)this.mGroupColorChooser, new GridBagConstraints(1, y++, 2, 1, 4.0, 1.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.mOkButton = new JButton(this.getResourceString("offroad.addFavoriteOK"));
        contentPane.add((Component)this.mOkButton, new GridBagConstraints(2, y, 1, 1, 1.0, 1.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.mOkButton.addActionListener(t -> this.terminate(true));
        JButton cancelButton = new JButton(this.getResourceString("offroad.addFavoriteCancel"));
        cancelButton.addActionListener(t -> this.terminate(false));
        contentPane.add((Component)cancelButton, new GridBagConstraints(1, y, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.mNewGroupCheckBox.setSelected(this.mComboBoxModel.getSize() == 0);
        this.toggleNewGroup();
        if (this.mUpdatePoint != null) {
            this.mNameTextField.setText(this.mUpdatePoint.getName());
            this.mDescriptionTextField.setText(this.mUpdatePoint.getDescription());
            this.mGroupColorChooser.setColor(this.mUpdatePoint.getColor());
            this.mGroupNameTextField.setText(this.mUpdatePoint.getCategory());
            for (int i = 0; i < this.mComboBoxModel.getSize(); ++i) {
                FavouritesDbHelper.FavoriteGroup fg = this.mComboBoxModel.getElementAt(i);
                if (fg.name == null || !fg.name.equals(this.mUpdatePoint.getCategory()) || fg.color != this.mUpdatePoint.getColor()) continue;
                this.mComboBox.setSelectedIndex(i);
                this.mInitialSelectedIndex = i;
                break;
            }
        } else {
            final MapMarkersHelper helper = this.mContext.getMapMarkersHelper();
            LatLon position = this.mContext.getCursorPosition();
            helper.addListener(new MapMarkersHelper.MapMarkerChangedListener(){

                @Override
                public void onMapMarkersChanged() {
                }

                @Override
                public void onMapMarkerChanged(final MapMarkersHelper.MapMarker pMapMarker) {
                    final 1 inst = this;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            helper.removeListener(inst);
                            AddFavoriteAction.this.mNameTextField.setText(pMapMarker.getPointDescription(AddFavoriteAction.this.mContext).getName());
                        }
                    });
                }
            });
            helper.addMapMarker(position, null);
        }
        this.mDialog.pack();
        this.decorateDialog();
        this.mDialog.setVisible(true);
    }

    protected String getWindowTitle() {
        return this.getResourceString("offroad.addFavorite");
    }

    private void toggleNewGroup() {
        boolean sel = this.mNewGroupCheckBox.isSelected();
        this.mGroupNameTextField.setEnabled(sel);
        this.mGroupColorChooser.setEnabled(sel);
        this.mComboBox.setEnabled(!sel);
        this.validate();
    }

    private void terminate(boolean pSaveResults) {
        LatLon pos = this.mContext.getCursorPosition();
        if (pSaveResults) {
            String groupName;
            String string2 = groupName = this.mNewGroupCheckBox.isSelected() ? this.createEmptyCategory() : this.getSelectedCategory();
            if (this.mUpdatePoint != null) {
                this.mContext.getFavorites().editFavouriteName(this.mUpdatePoint, this.mNameTextField.getText(), groupName, this.mDescriptionTextField.getText());
            } else {
                FavouritePoint point = new FavouritePoint(pos.getLatitude(), pos.getLongitude(), this.mNameTextField.getText(), groupName);
                point.setDescription(this.mDescriptionTextField.getText());
                this.mContext.getFavorites().addFavourite(point);
            }
            this.mContext.getDrawPanel().drawLater();
        }
        this.disposeDialog();
    }

    protected String createEmptyCategory() {
        String groupName = this.mGroupNameTextField.getText();
        this.mContext.getFavorites().addEmptyCategory(groupName, this.mGroupColorChooser.getColor().getRGB());
        return groupName;
    }

    protected String getSelectedCategory() {
        return this.mComboBoxModel.getElementAt((int)this.mComboBox.getSelectedIndex()).name;
    }

    @Override
    public void insertUpdate(DocumentEvent pE) {
        this.validate();
    }

    @Override
    public void removeUpdate(DocumentEvent pE) {
        this.validate();
    }

    private void validate() {
        if (!(this.mNameTextField.getText().length() <= 0 || this.mNewGroupCheckBox.isSelected() && this.mGroupNameTextField.getText().length() <= 0)) {
            this.mOkButton.setEnabled(true);
        } else {
            this.mOkButton.setEnabled(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent pE) {
        this.validate();
    }
}

