/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.cli.plugin;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.opensearch.cli.Command;
import org.opensearch.cli.Terminal;
import org.opensearch.common.cli.LoggingAwareMultiCommand;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.tools.cli.plugin.InstallPluginCommand;
import org.opensearch.tools.cli.plugin.ListPluginsCommand;
import org.opensearch.tools.cli.plugin.RemovePluginCommand;

public class PluginCli
extends LoggingAwareMultiCommand {
    private final Collection<Command> commands;

    private PluginCli() {
        super("A tool for managing installed opensearch plugins");
        this.subcommands.put("list", new ListPluginsCommand());
        this.subcommands.put("install", new InstallPluginCommand());
        this.subcommands.put("remove", new RemovePluginCommand());
        this.commands = Collections.unmodifiableCollection(this.subcommands.values());
    }

    public static void main(String[] args) throws Exception {
        PluginCli.exit((int)new PluginCli().main(args, Terminal.DEFAULT));
    }

    public void close() throws IOException {
        IOUtils.close(this.commands);
    }
}

