/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.ValidationException;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.forecast.settings.ForecastEnabledSetting;
import org.opensearch.forecast.settings.ForecastSettings;
import org.opensearch.forecast.transport.SuggestForecasterParamAction;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.transport.SuggestConfigParamRequest;
import org.opensearch.transport.client.node.NodeClient;
import org.owasp.encoder.Encode;

public class RestForecasterSuggestAction
extends BaseRestHandler {
    private static final String FORECASTER_SUGGEST_ACTION = "forecaster_suggest_action";
    private volatile TimeValue requestTimeout;

    public RestForecasterSuggestAction(Settings settings, ClusterService clusterService) {
        this.requestTimeout = (TimeValue)ForecastSettings.FORECAST_REQUEST_TIMEOUT.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ForecastSettings.FORECAST_REQUEST_TIMEOUT, it -> {
            this.requestTimeout = it;
        });
    }

    public String getName() {
        return FORECASTER_SUGGEST_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/%s/{%s}", "/_plugins/_forecast/forecasters", "_suggest", "type")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ForecastEnabledSetting.isForecastEnabled()) {
            throw new IllegalStateException("Forecast functionality is disabled. To enable update plugins.forecast.enabled to true");
        }
        try {
            XContentParser parser = request.contentParser();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            String typesStr = request.param("type");
            Forecaster config = this.parseConfig(parser);
            if (config != null) {
                return channel -> {
                    SuggestConfigParamRequest suggestForecasterParamRequest = new SuggestConfigParamRequest(AnalysisType.FORECAST, config, typesStr, this.requestTimeout);
                    client.execute((ActionType)SuggestForecasterParamAction.INSTANCE, (ActionRequest)suggestForecasterParamRequest, (ActionListener)new RestToXContentListener(channel));
                };
            }
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("fail to parse config");
            throw validationException;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Encode.forHtml((String)e.getMessage()));
        }
    }

    private Forecaster parseConfig(XContentParser parser) throws IOException {
        try {
            return Forecaster.parse(parser, null, null, new TimeValue(1L, TimeUnit.MINUTES), null);
        }
        catch (Exception e) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError(e.getMessage());
            throw validationException;
        }
    }
}

