/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.gcs;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

final class GoogleCloudStorageOperationsStats {
    private final AtomicLong getCount = new AtomicLong();
    private final AtomicLong listCount = new AtomicLong();
    private final AtomicLong putCount = new AtomicLong();
    private final AtomicLong postCount = new AtomicLong();
    private final String bucketName;

    GoogleCloudStorageOperationsStats(String bucketName) {
        this.bucketName = bucketName;
    }

    void trackGetOperation() {
        this.getCount.incrementAndGet();
    }

    void trackPutOperation() {
        this.putCount.incrementAndGet();
    }

    void trackPostOperation() {
        this.postCount.incrementAndGet();
    }

    void trackListOperation() {
        this.listCount.incrementAndGet();
    }

    String getTrackedBucket() {
        return this.bucketName;
    }

    Map<String, Long> toMap() {
        HashMap<String, Long> results = new HashMap<String, Long>();
        results.put("GetObject", this.getCount.get());
        results.put("ListObjects", this.listCount.get());
        results.put("InsertObject", this.postCount.get() + this.putCount.get());
        return results;
    }
}

