/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.view.ViewMode;

public class ViewModeComponent<T extends JComponent>
extends JPanel
implements Disposable {
    private Map<Optional<ViewMode>, T> mode2Component = new LinkedHashMap<Optional<ViewMode>, T>();
    private Optional<ViewMode> currentMode = Optional.empty();
    private Disposable disposeHook = () -> {};

    public ViewModeComponent() {
        this.setLayout(new CardLayout());
    }

    public void setDisposeHook(Disposable disposeHook) {
        this.disposeHook = disposeHook;
    }

    public void setViewMode(Optional<ViewMode> viewMode) {
        this.currentMode = viewMode;
        CardLayout cardLayout = (CardLayout)this.getLayout();
        if (viewMode.isPresent()) {
            cardLayout.show(this, viewMode.get().getName());
        } else {
            cardLayout.first(this);
        }
        JComponent component = (JComponent)this.mode2Component.get(this.currentMode);
        if (component != null) {
            component.requestFocus();
        }
    }

    public T getComponentForCurrentViewMode() {
        return (T)((JComponent)this.mode2Component.get(this.currentMode));
    }

    public void add(T component, ViewMode viewMode, boolean scrollPane) {
        if (this.mode2Component.isEmpty()) {
            this.mode2Component.put(Optional.empty(), component);
        }
        this.mode2Component.put(Optional.of(viewMode), component);
        if (!scrollPane) {
            super.add((Component)component, viewMode.getName());
        } else {
            super.add((Component)ComponentFactory.createScrollPane(component), viewMode.getName());
        }
    }

    @Override
    @Deprecated
    public Component add(Component comp) {
        throw new RuntimeException("Use add(Component, ViewMode, boolean)");
    }

    @Override
    @Deprecated
    public Component add(String name, Component comp) {
        throw new RuntimeException("Use add(Component, ViewMode, boolean)");
    }

    @Override
    @Deprecated
    public Component add(Component comp, int index) {
        throw new RuntimeException("Use add(Component, ViewMode, boolean)");
    }

    @Override
    @Deprecated
    public void add(Component comp, Object constraints) {
        throw new RuntimeException("Use add(Component, ViewMode, boolean)");
    }

    @Override
    @Deprecated
    public void add(Component comp, Object constraints, int index) {
        throw new RuntimeException("Use add(Component, ViewMode)");
    }

    public T getComponentForViewMode(Optional<ViewMode> viewMode) {
        return (T)((JComponent)this.mode2Component.get(viewMode));
    }

    public void dispose() throws Exception {
        this.disposeHook.dispose();
    }
}

