#!/bin/bash
##alternative window icon: /usr/share/icons/gnome/48x48/places/gnome-mime-x-directory-smb-share.png
#GUI Script to  search for ip's of shared folders and then connect to the selected on, using zzzfm (may be adapted to any file manager)- By PPC, 8/3/2022, full GPL license
#Dependencies: smbclient
#PS: Fully GUI eay to create/manage Samba shared folders easily- the package "system-config-samba", available in the  Repository
#sudo service smbd restart ### makes sure that Samba is running on the server, so shared folders are available

#Allow only one instance of the script at a time:
scriptname=$(basename "$0")
pid_of_script=$(pidof -x $scriptname)
for pid in $(pidof -x $scriptname); do
    if [ $pid != $$ ]; then #exit 1
    kill $pid_of_script
    fi 
done

#check for dependencies:
## testing for  yad
	if ! [ -x "$(command -v yad)" ]; then
  	 x-terminal-emulator -e whiptail --title "antiX-shares" --msgbox "You need to have yad, smclient and nmap installed. Please make sure that those packages are installed and re-run this script" 8 78
     exit 1
    fi

#Connectivity check:
ip=$(hostname -I)
if [ -n "$ip" ]; then
echo "Connected to a network - this device's IP is $ip"
else
echo "Not connected to a network, exiting"
yad --center --timeout=4 --window-icon="/usr/share/icons/numix-square-antix/48x48/places/gnome-mime-x-directory-smb-share.png"  --title="antiX-shares" --picture --filename=/usr/local/lib/ft10/icons/network-error.png --geometry=300x100-50-50 --inc=256 --button=" x " --timeout-indicator=bottom
exit
fi

## testing for smbclient and, in antiX, try to install it if user so selects
	if ! [ -x "$(command -v smbclient)" ]; then
	app="smbclient"
	install_apps=1
	fi
	
	if ! [ -x "$(command -v nmap)" ]; then
	app=$(echo $app nmap)
	install_apps=1
	fi
		
	if [[ "$install_apps" -eq 1 ]]; then
	 yad --title=$"antiX-shares" --window-icon=/usr/share/icons/numix-square-antix/48x48/places/gnome-mime-x-directory-smb-share.png --center --text=$"smbclient and/or nmap need to be installed. \n Do you want to automaticaly try to install this packages? " --button=" OK ":1 --button=" x ":2	
	 foo=$?
	 #This next line zeroes the file that is used to flag the end of the install process (in the end of the follwoing if statement, the "; echo 1 > /tmp/finished1" part changes that's file's content, signaling that the process is over and the main script can continue running:
	 echo 0 > /tmp/finished1
		if [[ $foo -eq 1 ]]; then x-terminal-emulator -e /bin/bash -c "gksu 'apt install -y $app'; echo 1 > /tmp/finished1"
		fi
	 #wait until install process is finished (this waits until the "sudo apt install" process running in paralelle echoes the value 1 to the /tmp/finished1 file:
finished=$(cat /tmp/finished1)
until [ $finished -gt 0 ]
do
finished=$(cat /tmp/finished1)
done
	
	fi



#test if install of each one of the dependencies was succefull, if not, exit:
	if ! [ -x "$(command -v smbclient)" ]; then	 yad --title=$"antiX-shares" --window-icon=/usr/share/icons/numix-square-antix/48x48/places/gnome-mime-x-directory-smb-share.png --center --text=$"Dependencies not installed!" --button=" x "
	 exit
	fi
	
	if ! [ -x "$(command -v nmap)" ]; then yad --title=$"antiX-shares" --window-icon=/usr/share/icons/numix-square-antix/48x48/places/gnome-mime-x-directory-smb-share.png --center --text=$"Dependencies not installed!" --button=" x "
	 exit
	fi

#Clean up temporary files:
echo "" > /tmp/range_of_available_ips
echo "" > /tmp/ccc
echo "" >/tmp/result

#Draw pulsating "wait" window, while searching for shared folders:
while true; do
echo "#"
done | yad --center --window-icon="/usr/share/icons/numix-square-antix/48x48/places/gnome-mime-x-directory-smb-share.png" --title="antiX-shares" --text="" --width 250 --text-align center --on-top --pulsate --no-buttons --auto-close --progress &

##Main part of the script:
#Create a list of all available ips for network shares:
ips=$(ip -o addr | sed '/: lo /d'|sed '/::/d')
newString="${ips#*inet}"
ip_range=$(echo $newString|cut -d ' ' -f 1)
echo The detected available IP range is: $ip_range

###Check what ips are on:
nmap -v -sn $ip_range > /tmp/ips
cat /tmp/ips | sed '/host down/d'  |grep -E -o "([0-9]{1,3}[\.]){3}[0-9]{1,3}" > /tmp/range_of_available_ips
echo IPs that will be searched for shared folders:
cat /tmp/range_of_available_ips
echo
echo Scanning for shared folders on each IP...

#Remove empty lines from the result:
sed -i '/^[[:space:]]*$/d' /tmp/range_of_available_ips

#Test every possible network share ip, and log the valid addresses:
while read line; do
##smbclient -L //<hostname>/<folder> –option=’client min protocol=NT1′
  smbclient -N -L $line  -option='client min protocol=NT1'  | sed '/Printer Drivers/d' | grep "Disk" | cut -d' ' -f1  >/tmp/ccc
  sleep 0.2
  cat /tmp/ccc
  
  while read line2; do
 sleep 0.2
  echo //$line/$line2 >>/tmp/result
  done </tmp/ccc
  
done </tmp/range_of_available_ips

#Remove empty lines from the result:
sed -i '/^[[:space:]]*$/d' /tmp/result

#Close pulsating "wait" window:
wmctrl -c "antiX-shares"

#Exit if no network shares were detected:
check=$(cat /tmp/result)
if [ -n "$check" ]; then
 echo 
 echo "...Done scanning. Detected Network shares:"
 echo "$check"
else
 echo "No network shares detected, exiting"
 #yad --center --window-icon="/usr/share/icons/numix-square-antix/48x48/places/gnome-mime-x-directory-smb-share.png" --title="antiX-shares" --text=$" No network shares detected! " --button=" x " --width 250
 yad --center --timeout=4 --window-icon="/usr/share/icons/numix-square-antix/48x48/places/gnome-mime-x-directory-smb-share.png"  --title="antiX-shares" --picture --filename=/usr/local/lib/ft10/icons/network-error.png --geometry=300x100-50-50 --inc=256 --button=" x " --timeout-indicator=bottom
exit
fi

#Window that allows user to select the share to connect to:
selectedshare=$(yad --no-buttons --window-icon="/usr/share/icons/numix-square-antix/48x48/places/gnome-mime-x-directory-smb-share.png" --title="antiX-shares" --width=250 --height=250 --fixed --center --separator=" " --list  --column=""  < /tmp/result)

#If nothing was selected, exit:
 if [[ $selectedshare = "" ]]; then exit
 fi

#Ask for credentials: 
share=$selectedshare
entry=$(yad --center --width=350 --window-icon="/usr/share/icons/numix-square-antix/48x48/places/gnome-mime-x-directory-smb-share.png" --title="$share" --form --field="<b><big><big> ☺ </big></big></b>" $USER --field=$"◦◦◦◦":H --button="OK")
username=$(echo $entry |cut -d\| -f1)
password=$(echo $entry |cut -d\| -f2)
udevil mount -t cifs -o username=$username,password=$password $share vers=1.0

#Try to mount share in zzzfm:
zzzfm $share & sleep 1
