#!/bin/bash
#Originally by Misho's Alarm, from the Busen Lab forum
#Very poorly adapted to work in antiX by PPC (8/1/2022)
        TEXTDOMAINDIR=/usr/share/locale
        TEXTDOMAIN=ft10-clock
        

export A_ICON="/tmp/alarm1a.svg"
export B_ICON="/tmp/alarm1b.svg"
export C_ICON="/tmp/alarm1c.svg"

if [ ! -e "$A_ICON" ]; then
   SVG="<""svg width='25' height='25' viewBox='0 0 260 260'> 
<g transform='scale(0.5 0.5) translate(130 160)' 
 fill='white' stroke='crimson' stroke-width='2.5%'> 
<path d='M25 195 c-18 -10 -30 -52 -22 -78 8 -28 28 -47 34 -32 1 3 0 6 
-5 12 -20 25 -20 56 0 81 9 11 4 23 -7 17z'/> 
<path d='M224 195 c-5 -3 -7 -10 -3 -14 22 -20 24 -58 3 -84 -6 -7 -7 -11 
-3 -16 12 -11 35 26 35 56 0 29 -20 65 -32 58z'/> 
<path d='M36 172 c-17 -18 -17 -51 0 -68 10 -11 23 0 13 11 -11 13 -12 31 
0 45 9 11 -2 22 -13 12z'/> 
<path d='M206 174 c-3 -4 -3 -8 2 -15 11 -14 10 -31 0 -44 -5 -5 -5 -10 
-2 -14 10 -9 27 14 27 37 0 22 -17 45 -27 36z'/> 
<path d='M108 160 c-44 -3 -70 -16 -56 -27 9 -7 11 -10 15 -15 10 -14 13 
-25 14 -48 1 -24 9 -38 26 -46 l6 -2 0 -6 c3 -21 30 -20 30 1 0 4 0 5 6 7 
18 9 27 26 27 50 0 25 8 41 29 60 11 10 -6 20 -40 25 -11 1 -47 2 -57 
1z'/> 
</g> 
</svg>"
	echo "$SVG" > $A_ICON	
	echo "$SVG" | sed 's/0.5 0.5/0.75 0.75/g' | sed 's/130 160/45 75/g' > $B_ICON
	echo "$SVG" | sed 's/0.5 0.5/1.0 1.0/g' | sed 's/130 160/0 45/g' > $C_ICON
fi

export D_ICON="/tmp/alarm4a.svg"
export E_ICON="/tmp/alarm4b.svg"
export F_ICON="/tmp/alarm4c.svg"

if [ ! -e "$D_ICON" ]; then
   SVG="<""svg width='25' height='25' viewBox='0 0 260 260'> 
<g transform='scale(0.5 0.5) translate(130 160)' 
 fill='black' stroke='crimson' stroke-width='2.5%'> 
<path d='M25 195 c-18 -10 -30 -52 -22 -78 8 -28 28 -47 34 -32 1 3 0 6 
-5 12 -20 25 -20 56 0 81 9 11 4 23 -7 17z'/> 
<path d='M224 195 c-5 -3 -7 -10 -3 -14 22 -20 24 -58 3 -84 -6 -7 -7 -11 
-3 -16 12 -11 35 26 35 56 0 29 -20 65 -32 58z'/> 
<path d='M36 172 c-17 -18 -17 -51 0 -68 10 -11 23 0 13 11 -11 13 -12 31 
0 45 9 11 -2 22 -13 12z'/> 
<path d='M206 174 c-3 -4 -3 -8 2 -15 11 -14 10 -31 0 -44 -5 -5 -5 -10 
-2 -14 10 -9 27 14 27 37 0 22 -17 45 -27 36z'/> 
<path d='M108 160 c-44 -3 -70 -16 -56 -27 9 -7 11 -10 15 -15 10 -14 13 
-25 14 -48 1 -24 9 -38 26 -46 l6 -2 0 -6 c3 -21 30 -20 30 1 0 4 0 5 6 7 
18 9 27 26 27 50 0 25 8 41 29 60 11 10 -6 20 -40 25 -11 1 -47 2 -57 
1z'/> 
</g> 
</svg>"
	echo "$SVG" > $D_ICON	
	echo "$SVG" | sed 's/0.5 0.5/0.75 0.75/g' | sed 's/130 160/45 75/g' > $E_ICON
	echo "$SVG" | sed 's/0.5 0.5/1.0 1.0/g' | sed 's/130 160/0 45/g' > $F_ICON
fi


alrm () {
PLAYER=mpv
PLAYER=$(egrep "^PLAYER=" $HOME/.yalrm | cut -d'=' -f2)
sound=/usr/local/lib/ft10/ahooga-horn-vobis.ogg
sound=$(egrep "^sound=" $HOME/.yalrm | cut -d'=' -f2)
export hr="$1"
[ "${hr:0:1}" = '0' ] && hr=${hr#?}
export mn="$2"
export target="$hr:$mn"
repeat="1"
repeat=$(egrep "^repeat=" $HOME/.yalrm | cut -d'=' -f2)
interval="0"
interval=$(egrep "^interval=" $HOME/.yalrm | cut -d'=' -f2)
dur="10"
dur=$(egrep "^dur=" $HOME/.yalrm | cut -d'=' -f2)
command () {
alarm_set_to_text=$"Alarm set to"	
alarm_text=$"Alarm"
yad --undecorated --image=$B_ICON --borders 12 --title="$alarm_text" --text=$"    \t<b>$alarm_set_to_text $hr:$mn</b> " --geometry=280x50-40-50 --no-buttons --timeout=3 &

} ; export -f command

command_running () {
	alarm_text=$"Alarm"
	alarm_set_to_text=$"Alarm set to"	
	cancel_text=$"To cancel, right-click icon for menu"
yad --undecorated --image=$F_ICON --borders 12 --title="$alarm_text" --text=$"    \t<b>$alarm_text $hr:$mn...</b> \n " --geometry=280x50-40-50 --no-buttons --timeout 4
} ; export -f command_running

cancel_quit_tray () {
#apid=$(ps -eo pid,cmd | grep "^$1" | sed -n 's/.* Set to \([^ ]*\).*/\1/p')
apid="$2"
echo [$apid]
kill $1
kill $(cat /tmp/yalrm_apid.$apid 2> /dev/null)
rm -f /tmp/yalrm_apid.$apid
rm -f $PIPE2
###pkill yad ###PPC
kill -USR1 $YAD_PID
}; export -f cancel_quit_tray

quit_tray () {
kill $1
rm -f $PIPE2
}; export -f quit_tray

quit_tray_running () {
kill $PLPID
rm -f $PIPE
}; export -f quit_tray_running

export PIPE2="/tmp/Y_ALRM2.$RANDOM"
mkfifo $PIPE2

# attach a file descriptor to the file
exec 4<> $PIPE2

show_icon () {

while true; do
   echo 'icon:'$A_ICON;
   sleep 0.25;
   echo 'icon:'$B_ICON;
   sleep 0.25;
   echo 'icon:'$C_ICON;
   sleep 0.25;
   echo 'icon:'$B_ICON;
   sleep 0.25;
done >$PIPE2 &
alarm_set_to_text=$"Alarm set to"
cancel_text=$"To cancel, right-click for menu"
cancel_alarm_text=$"Cancel Alarm"
yad \
--notification \
--image="$C_ICON" \
--auto-kill \
--no-middle \
--listen \
--text=$"$alarm_set_to_text $hr:$mn
$cancel_text" \
--command="bash -c command" <&4 &
export XPID=$!
echo menu:$"$cancel_alarm_text !bash -c 'cancel_quit_tray $XPID $target'!gtk-cancel" >$PIPE2 &
}; export -f show_icon

hrnow=$(echo $(date +"%k"))

(
# For when trying to set alarm for next day e.g. from current 21:00 to target 6:00
if [ "$hr" -eq "$hrnow" ] &&  [ "$mn" -le "$(date +"%M")" ]; then
# prompt yes/no in case accidentally chosen current hour but less than current minute

confirm_title=$"Are you sure???"
are_you_sure_text=$"  Are you sure to set the alarm for that time tomorrow?"
yad --center --title=$"$confirm_title" --text=$"$are_you_sure_text" --width=400 --button="OK:0"  --button="x:1"
[ $? -ne 0 ] && exit
command & show_icon
sleep $(( $(date --date="$(((23+$hr) - $hrnow)):$mn" +%s) - $(date --date="00:$(date +"%M"):$(date +"%S")" +%s) + 3600 ))
elif [ "$hr" -lt "$hrnow" ]; then
command & show_icon
sleep $(( $(date --date="$(((24+$hr) - $hrnow)):$mn" +%s) - $(date --date="00:$(date +"%M"):$(date +"%S")" +%s) ))
else
command & show_icon
sleep $(( $(date --date="$target" +%s) - $(date +%s) ));
fi

kill $XPID
rm -f $PIPE2
echo "Wake Up!"

command_running &

(
    if [ $repeat = 0 ]; then
while true; do
$PLAYER "$sound" </dev/null >/dev/null 2>&1 &
sleep $dur
pidplayer="$(pgrep -lf "$PLAYER $sound" | awk '{ print $1 }')"
[ -n "$pidplayer" ] && kill -9 $pidplayer
  if [ $dur -lt $interval ]; then
  sleep $(($interval-$dur)) 2> /dev/null
#  else
#  sleep $interval 2> /dev/null
  fi
done
    else
while [ $repeat -gt 0 ]; do
$PLAYER "$sound" </dev/null >/dev/null 2>&1 &
sleep $dur
pidplayer="$(pgrep -lf "$PLAYER $sound" | awk '{ print $1 }')"
[ -n "$pidplayer" ] && kill -9 $pidplayer
repeat=$(($repeat-1))
if [ $repeat -gt 0 ]; then
  if [ $dur -lt $interval ]; then
  sleep $(($interval-$dur)) 2> /dev/null
#  else
#  sleep $interval 2> /dev/null
  fi
fi
done
    fi
) &
export PLPID=$!

(
echo menu:"Stop Alarm and Exit tray!bash -c quit_tray_running!gtk-quit"
while true; do
   echo 'icon:'$D_ICON;
   sleep 0.25;
   echo 'icon:'$E_ICON;
   sleep 0.25;
   echo 'icon:'$F_ICON;
   sleep 0.25;
   echo 'icon:'$E_ICON;
   sleep 0.25;
done
) | yad --notification \
--no-middle \
--timeout=5 \
--listen \
--text="Alarm:
$hr:$mn" \
--command="bash -c command_running" &

export YPID=$!
wait $PLPID

kill $YPID
rm -f $PIPE

) &
export ALPID=$!
echo $ALPID > /tmp/yalrm_apid.$hr:$mn

wait $ALPID
kill $XPID 2> /dev/null
rm -f $PIPE
rm -f $PIPE2
rm -f /tmp/yalrm_apid.$hr:$mn
}; export -f alrm

# set hour and minute at current time in yad GUI
hour=$(echo -e "$(seq -w $(date +"%H") 23)\n$(seq -w 00 $(date +"%H"))" | sed '$ d' |xargs | tr ' ' ':')
min=$(echo -e "$(seq -w $(date +"%M") 59)\n$(seq -w 00 $(date +"%M"))" | sed '$ d' |xargs|tr ' ' ':')

# create preference file $HOME/.yalrm, if not exists
if [ ! -f $HOME/.yalrm ]; then
echo "#Media player used to play alarm:
PLAYER=mpv
#Alarm sound:
sound=/usr/local/lib/ft10/ahooga-horn-vobis.ogg
#Number of times the alarm sounds (0 =infinite):
repeat=01
#Interval between repetitions:
interval=00
#Duration of alarm sound:
dur=05" > $HOME/.yalrm > $HOME/.yalrm
fi

. $HOME/.yalrm

while :
do 

  date +"%H":"%M":"%S"
pidyad="$(pgrep -lf "yad --plug=$$" | awk '{ print $1 }')"
[ -z "$pidyad" ] && break
  sleep 0.5
done | yad --plug="$$" --tabnum=1 --form --cycle-read --columns=2 --image="clock" --field="                                      " --field="               \t\t\t\t\t\t:lbl" &

duration_text=$"Duration"
interval_text=$"Interval"
repeat_text=$"Repeat"
seconds_text=$"seconds"
infinite_text=$"infinite"

yad --plug="$$" --tabnum=2 --center --title="Alarm" --form  --fixed --image="/usr/share/icons/papirus-antix/48x48/apps/stock_alarm.png" --text=" " --columns=4 --item-separator=":" \
--field=$"Hour::CB" "$hour" \
--field=$"Minutes::CB" "$min" \
--field="OK:gtk-ok:Set Alarm:fbtn" 'bash -c "alrm %1 %2 %3 %4 %5 %6 %7 %8 %9"' &
yad --fixed --geometry=100x100+125+100 --title="FT10 Alarm" --window-icon=$B_ICON --paned --key="$$" --orient=vert --no-buttons
