/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*****************************************************************************/
/* This is an automatically generated file. If you're not                    */
/* nsSiteSecurityService.cpp, you shouldn't be #including it.     */
/*****************************************************************************/

#include <stdint.h>
const PRTime gPreloadListExpirationTime = INT64_C(1585036830608000);

class nsSTSPreload
{
  public:
    const char *mHost;
    const bool mIncludeSubdomains;
};

static const nsSTSPreload kSTSPreloadList[] = {
  { "0--1.de", true },
  { "0-24.com", true },
  { "0-24.net", true },
  { "00004048.com", true },
  { "000321365.com", true },
  { "000b58.com", true },
  { "000btt.net", true },
  { "00168365.com", true },
  { "001yapan.com", true },
  { "00228.am", false },
  { "00228.org", false },
  { "00228ww.com", false },
  { "00228x.com", false },
  { "00228xx.com", false },
  { "00228yy.com", false },
  { "00228z.com", false },
  { "00228zz.com", false },
  { "0022bet.vip", true },
  { "002k8.com", true },
  { "00365t.com", true },
  { "003971.com", true },
  { "008207.com", true },
  { "008251.com", true },
  { "008253.com", true },
  { "008271.com", true },
  { "009597.com", true },
  { "00dani.me", true },
  { "00f.net", true },
  { "01011970.xyz", true },
  { "010203.ru", true },
  { "010kb.com", true },
  { "010ks.com", true },
  { "010ks.net", true },
  { "01110000011100110111001001100111.com", true },
  { "01234048.com", true },
  { "012345678365.com", true },
  { "0123456789365.com", true },
  { "01365t.com", true },
  { "015kb.com", true },
  { "0166z6.com", true },
  { "016kb.com", true },
  { "0177z6.com", true },
  { "0188z6.com", true },
  { "018k8.com", true },
  { "01918.net", true },
  { "0199z6.com", true },
  { "01tools.com", true },
  { "020ks.com", true },
  { "0222z6.com", true },
  { "022367.com", true },
  { "022379.com", true },
  { "022391.com", true },
  { "022501.com", true },
  { "022503.com", true },
  { "022507.com", true },
  { "022571.com", true },
  { "022601.com", true },
  { "022609.com", true },
  { "022610.com", true },
  { "022kb.com", true },
  { "022ks.net", true },
  { "02327.net", true },
  { "02365t.com", true },
  { "02375.net", true },
  { "025k8.com", true },
  { "026122.com", true },
  { "02638.net", true },
  { "026kb.com", true },
  { "0288z6.com", true },
  { "029kb.com", true },
  { "02am8.com", true },
  { "03012.net", true },
  { "03018.net", true },
  { "0311z6.com", true },
  { "0312z6.com", true },
  { "0313z6.com", true },
  { "0315z6.com", true },
  { "0316z6.com", true },
  { "03170317.com", true },
  { "0317z6.com", true },
  { "0318z6.com", true },
  { "0319z6.com", true },
  { "0335z6.com", true },
  { "0351z6.com", true },
  { "0352z6.com", true },
  { "0353z6.com", true },
  { "0355z6.com", true },
  { "0356z6.com", true },
  { "0357z6.com", true },
  { "0358z6.com", true },
  { "0359z6.com", true },
  { "03637.com", true },
  { "0371z6.com", true },
  { "0372z6.com", true },
  { "0373z6.com", true },
  { "0375z6.com", true },
  { "0376z6.com", true },
  { "0377z6.com", true },
  { "038456.com", true },
  { "0393gg.com", true },
  { "0393hh.com", true },
  { "0393ii.com", true },
  { "0399z6.com", true },
  { "04365t.com", true },
  { "046569.com", true },
  { "04911701.cn", true },
  { "04d.co", true },
  { "050869.com", true },
  { "050ks.com", true },
  { "050media.nl", true },
  { "0510ks.com", true },
  { "0511315.net", true },
  { "0511ks.com", true },
  { "0511z6.com", true },
  { "0512z6.com", true },
  { "0513z6.com", true },
  { "0515z6.com", true },
  { "0516z6.com", true },
  { "0517z6.com", true },
  { "0518z6.com", true },
  { "0521z6.com", true },
  { "0523z6.com", true },
  { "0531z6.com", true },
  { "0532z6.com", true },
  { "0533z6.com", true },
  { "0535z6.com", true },
  { "05365t.com", true },
  { "0536z6.com", true },
  { "0537z6.com", true },
  { "0538z6.com", true },
  { "0539z6.com", true },
  { "0551z6.com", true },
  { "0552z6.com", true },
  { "0553z6.com", true },
  { "0555z6.com", true },
  { "0556z6.com", true },
  { "055kb.com", true },
  { "056675.com", true },
  { "056687.com", true },
  { "056690.com", true },
  { "056697.com", true },
  { "056867.com", true },
  { "056869.com", true },
  { "056875.com", true },
  { "056879.com", true },
  { "056950.com", true },
  { "056976.com", true },
  { "056985.com", true },
  { "056kb.com", true },
  { "0572z6.com", true },
  { "0573wk.com", true },
  { "0573z6.com", true },
  { "057587.com", true },
  { "057596.com", true },
  { "0575z6.com", true },
  { "0576z6.com", true },
  { "0577z6.com", true },
  { "0578z6.com", true },
  { "0579z6.com", true },
  { "058509.com", true },
  { "058596.com", true },
  { "058679.com", true },
  { "058kb.com", true },
  { "0591z6.com", true },
  { "0592z6.com", true },
  { "0593z6.com", true },
  { "0595z6.com", true },
  { "0596z6.com", true },
  { "0597z6.com", true },
  { "0598z6.com", true },
  { "0599z6.com", true },
  { "05am8.com", true },
  { "05am8.net", true },
  { "060795.com", true },
  { "0607p.com", true },
  { "060870.com", true },
  { "060875.com", true },
  { "06091994.xyz", true },
  { "06365t.com", true },
  { "065679.com", true },
  { "065706.com", true },
  { "065790.com", true },
  { "065970.com", true },
  { "065976.com", true },
  { "065l.com", true },
  { "066570.com", true },
  { "066579.com", true },
  { "066590.com", true },
  { "0666z6.com", true },
  { "066705.com", true },
  { "066709.com", true },
  { "066790.com", true },
  { "066816.com", true },
  { "066kb.com", true },
  { "067310.com", true },
  { "067313.com", true },
  { "067360.com", true },
  { "067361.com", true },
  { "06804.com", true },
  { "0681b.com", true },
  { "0681c.com", true },
  { "0681d.com", true },
  { "0681e.com", true },
  { "0681f.com", true },
  { "0681g.com", true },
  { "0681i.com", true },
  { "0681j.com", true },
  { "0681l.com", true },
  { "0681m.com", true },
  { "0681o.com", true },
  { "0681p.com", true },
  { "0681q.com", true },
  { "0681s.com", true },
  { "0681t.com", true },
  { "0681u.com", true },
  { "0681w.com", true },
  { "0681x.com", true },
  { "0681y.com", true },
  { "0681z.com", true },
  { "068663.com", true },
  { "068697.com", true },
  { "068756.com", true },
  { "068957.com", true },
  { "068kb.com", true },
  { "06918.net", true },
  { "0691ks.com", true },
  { "06lc.net", true },
  { "06se.com", true },
  { "070136.com", true },
  { "070167.com", true },
  { "070183.com", true },
  { "0708p.com", true },
  { "070968.com", true },
  { "070986.com", true },
  { "0711z6.com", true },
  { "0712z6.com", true },
  { "0713z6.com", true },
  { "0715z6.com", true },
  { "0716z6.com", true },
  { "0717z6.com", true },
  { "0718z6.com", true },
  { "0719z6.com", true },
  { "071k8.com", true },
  { "0720p.com", true },
  { "0722z6.com", true },
  { "0724ks.com", true },
  { "0728z6.com", true },
  { "0732ks.com", true },
  { "07365t.com", true },
  { "0737399.com", true },
  { "075k8.com", true },
  { "0760ks.com", true },
  { "0763ks.com", true },
  { "0766ks.com", true },
  { "076k8.com", true },
  { "0771z6.com", true },
  { "0772z6.com", true },
  { "0773z6.com", true },
  { "0775z6.com", true },
  { "0776z6.com", true },
  { "0777z6.com", true },
  { "077810.com", true },
  { "077863.com", true },
  { "0779z6.com", true },
  { "077k8.com", true },
  { "078kb.com", true },
  { "0792112.com", true },
  { "079606.com", true },
  { "079607.com", true },
  { "0798rcw.com", true },
  { "07d88.com", true },
  { "081115.com", true },
  { "081752.com", true },
  { "081763.com", true },
  { "081769.com", true },
  { "081783.com", true },
  { "081925.com", true },
  { "081927.com", true },
  { "081957.com", true },
  { "081967.com", true },
  { "082157.com", true },
  { "082159.com", true },
  { "082167.com", true },
  { "082173.com", true },
  { "082175.com", true },
  { "082179.com", true },
  { "082187.com", true },
  { "082192.com", true },
  { "082193.com", true },
  { "082195.com", true },
  { "082359.com", true },
  { "08365t.com", true },
  { "083832.com", true },
  { "083903.com", true },
  { "083905.com", true },
  { "083907.com", true },
  { "083912.com", true },
  { "083957.com", true },
  { "083960.com", true },
  { "083962.com", true },
  { "083965.com", true },
  { "083967.com", true },
  { "085851.com", true },
  { "085905.com", true },
  { "085950.com", true },
  { "087065.com", true },
  { "0871z6.com", true },
  { "0872z6.com", true },
  { "0873z6.com", true },
  { "087540.com", true },
  { "087569.com", true },
  { "087580.com", true },
  { "0875z6.com", true },
  { "0876z6.com", true },
  { "0877z6.com", true },
  { "08817a.com", true },
  { "08817c.com", true },
  { "08817d.com", true },
  { "08817e.com", true },
  { "08817f.com", true },
  { "08817g.com", true },
  { "08817h.com", true },
  { "08817j.com", true },
  { "08817k.com", true },
  { "08817m.com", true },
  { "08817w.com", true },
  { "08817y.com", true },
  { "08817z.com", true },
  { "08845.cc", true },
  { "0888z6.com", true },
  { "08918.net", true },
  { "089k8.com", true },
  { "08lc.net", true },
  { "09000113.nl", true },
  { "091k8.com", true },
  { "092k8.com", true },
  { "09365t.com", true },
  { "093k8.com", true },
  { "095598.cc", true },
  { "09892.net", true },
  { "098k8.com", true },
  { "0996z6.com", true },
  { "0998z6.com", true },
  { "0999z6.com", true },
  { "09am8.com", true },
  { "09btt.com", true },
  { "09d88.com", true },
  { "0au.de", true },
  { "0c3.de", true },
  { "0chan.pl", true },
  { "0cp8778.com", true },
  { "0day.agency", true },
  { "0des.com", true },
  { "0ii0.cf", true },
  { "0ik.de", true },
  { "0iz.net", true },
  { "0knowledge.de", false },
  { "0lc8.com", true },
  { "0lc8.net", true },
  { "0paste.com", true },
  { "0wx.cat", true },
  { "0wx.es", true },
  { "0wx.eu", true },
  { "0wx.org", true },
  { "0x.cx", true },
  { "0x.sk", true },
  { "0x0.li", true },
  { "0x00c.de", true },
  { "0x00ff00ff.com", true },
  { "0x15.ca", true },
  { "0x17.de", true },
  { "0x378.net", true },
  { "0x41.us", true },
  { "0x52.net", true },
  { "0x7.io", true },
  { "0x7d.com", true },
  { "0x7fffffff.net", true },
  { "0x80.org", true },
  { "0x90.in", true },
  { "0x90.io", true },
  { "0xabe.io", true },
  { "0xaf.tk", true },
  { "0xda.de", true },
  { "0xdc.io", false },
  { "0xdefaced.de", true },
  { "0xfc.de", true },
  { "0xff.se", true },
  { "0xn.de", true },
  { "1-2-3bounce.co.uk", true },
  { "1-345.com", false },
  { "100-downloads.com", true },
  { "10000v.ru", true },
  { "1000minds.com", true },
  { "1000wordsevents.com", true },
  { "1001kartini.com", true },
  { "1001kerstpakketten.com", false },
  { "10086.ru", true },
  { "100k.eu", true },
  { "100kredite.de", true },
  { "100lat.pl", true },
  { "100mani.it", true },
  { "100pounds.co.uk", true },
  { "100up.de", true },
  { "100up.org", true },
  { "100visits.tk", true },
  { "101.qa", true },
  { "101010.pl", true },
  { "1011100.com", true },
  { "101sauna.kz", true },
  { "101sauna.ru", true },
  { "102ch.us", true },
  { "1041263497.rsc.cdn77.org", true },
  { "10430.net", true },
  { "10435.net", true },
  { "10436.net", true },
  { "10438.net", true },
  { "10439.net", true },
  { "10453.net", true },
  { "10495.net", true },
  { "105318.com", false },
  { "106jamz.com", true },
  { "10774.net", true },
  { "107996.com", false },
  { "10840.net", true },
  { "1088.fun", true },
  { "109k8.com", true },
  { "10gbit.ovh", true },
  { "10hz.de", true },
  { "10k.ag", true },
  { "10ppm.com", true },
  { "11018xpj.com", false },
  { "110320.com", true },
  { "110k8.com", true },
  { "111.one", true },
  { "1111365t.com", true },
  { "1111k8.com", true },
  { "1112z6.com", true },
  { "111321365.com", true },
  { "111365t.com", true },
  { "1113z6.com", true },
  { "1115z6.com", true },
  { "11168365.com", true },
  { "1116z6.com", true },
  { "1117z6.com", true },
  { "1119z6.com", true },
  { "111b58.com", true },
  { "111plus.design", true },
  { "111z6.com", true },
  { "111zlong.com", true },
  { "1120340.com", true },
  { "1122z6.com", true },
  { "112app.nl", true },
  { "112hz.com", true },
  { "112it.ro", true },
  { "112z6.com", true },
  { "11335835.com", true },
  { "1133z6.com", true },
  { "11365t.com", true },
  { "113k8.com", true },
  { "113ks.com", true },
  { "113z6.com", true },
  { "11445835.com", true },
  { "114514ss.com", true },
  { "11555835.com", true },
  { "115lc.com", true },
  { "115z6.com", true },
  { "11665835.com", true },
  { "1166z6.com", true },
  { "116ks.com", true },
  { "116lc.com", true },
  { "116z6.com", true },
  { "11775835.com", true },
  { "1177z6.com", true },
  { "117lc.com", true },
  { "117z6.com", true },
  { "11885835.com", true },
  { "1188bet.vip", true },
  { "1188z6.com", true },
  { "118btt.com", true },
  { "118z6.com", true },
  { "1190america.tk", true },
  { "11995835.com", true },
  { "1199bet.vip", true },
  { "1199z6.com", true },
  { "119lc.com", true },
  { "119z6.com", true },
  { "11assets.com", true },
  { "11lc8.com", true },
  { "11lc8.net", true },
  { "11loc.de", true },
  { "11thstreetcoffee.com", true },
  { "11urss.com", true },
  { "120323.com", true },
  { "1212873467.rsc.cdn77.org", true },
  { "1212z6.com", true },
  { "1218641649.rsc.cdn77.org", true },
  { "1221z6.com", true },
  { "1222z6.com", true },
  { "122kb.com", true },
  { "123365t.com", true },
  { "12344048.com", true },
  { "12345678365.com", true },
  { "123456789365.com", true },
  { "1236.be", true },
  { "12365t.com", true },
  { "123apps.net", true },
  { "123bearing.co.uk", true },
  { "123bearing.com", true },
  { "123bearing.eu", true },
  { "123birthdaygreetings.com", true },
  { "123comparer.fr", true },
  { "123midterm.com", true },
  { "123nutricion.es", true },
  { "123opstalverzekeringen.nl", true },
  { "123roulement.be", true },
  { "123roulement.com", true },
  { "123seo.ml", true },
  { "123termpapers.com", true },
  { "123writings.com", true },
  { "123z6.com", true },
  { "124133.com", true },
  { "124633.com", true },
  { "125m125.de", true },
  { "126772.com", true },
  { "127661.com", true },
  { "127662.com", true },
  { "127663.com", true },
  { "127665.com", true },
  { "12autoankauf-berlin.de", true },
  { "12l.nl", true },
  { "12thmanrising.com", true },
  { "12train.com", true },
  { "12vpn.net", true },
  { "13-th.com", true },
  { "130.ua", true },
  { "130032.com", true },
  { "130212.com", true },
  { "130232.com", true },
  { "130ks.com", true },
  { "130ks.net", true },
  { "1313z6.com", true },
  { "131934.com", true },
  { "131954.com", true },
  { "131k66.ag", true },
  { "131ks.com", true },
  { "131ks.net", true },
  { "131z6.com", true },
  { "13214.cc", true },
  { "132301.com", true },
  { "132302.com", true },
  { "132k66.ag", true },
  { "132ks.com", true },
  { "132kv.ch", true },
  { "132z6.com", true },
  { "133294.com", true },
  { "1333z6.com", true },
  { "133492.com", true },
  { "1337.vg", true },
  { "133ks.com", true },
  { "133ks.net", true },
  { "133z6.com", true },
  { "134ks.com", true },
  { "134ks.net", true },
  { "135374.com", true },
  { "135416.com", true },
  { "1359826938.rsc.cdn77.org", true },
  { "135ks.com", true },
  { "135z6.com", true },
  { "136814.com", true },
  { "136824.com", true },
  { "136924.com", true },
  { "136k66.ag", true },
  { "136k66.com", true },
  { "136ks.com", true },
  { "136z6.com", true },
  { "137724.com", true },
  { "137k66.ag", true },
  { "137k66.com", true },
  { "137kb.com", true },
  { "137z6.com", true },
  { "138k66.ag", true },
  { "138z6.com", true },
  { "1391kj.com", true },
  { "1395kj.com", true },
  { "139k66.ag", true },
  { "139z6.com", true },
  { "13th-dover.uk", true },
  { "141145.com", true },
  { "14159.gb.net", true },
  { "143533.com", true },
  { "143633.com", true },
  { "143733.com", true },
  { "143918.com", true },
  { "143933.com", true },
  { "1453914078.rsc.cdn77.org", true },
  { "145433.com", true },
  { "145733.com", true },
  { "145ks.net", true },
  { "146233.com", true },
  { "146433.com", true },
  { "1464424382.rsc.cdn77.org", true },
  { "146533.com", true },
  { "146733.com", true },
  { "149433.com", true },
  { "149733.com", true },
  { "14erc.com", true },
  { "14ercooper.com", true },
  { "14it.de", true },
  { "14x3.de", true },
  { "15-10.com", true },
  { "1511774230.rsc.cdn77.org", true },
  { "151k66.ag", true },
  { "151k66.com", true },
  { "151ks.net", true },
  { "151z6.com", true },
  { "152433.com", true },
  { "152k66.ag", true },
  { "152k66.com", true },
  { "152z6.com", true },
  { "153ks.net", true },
  { "153z.com", true },
  { "153z6.com", true },
  { "154233.com", true },
  { "154633.com", true },
  { "154933.com", true },
  { "155175.com", true },
  { "155k66.ag", true },
  { "155k66.com", true },
  { "155ks.com", true },
  { "155ks.net", true },
  { "155z6.com", true },
  { "156433.com", true },
  { "156k66.com", true },
  { "156ks.net", true },
  { "156z6.com", true },
  { "157k66.com", true },
  { "157ks.com", true },
  { "157ks.net", true },
  { "157z6.com", true },
  { "158k66.ag", true },
  { "158k66.com", true },
  { "158ks.net", true },
  { "158z6.com", true },
  { "1590284872.rsc.cdn77.org", true },
  { "15918.net", true },
  { "159cp.com", true },
  { "159k66.ag", true },
  { "159k66.com", true },
  { "159ks.net", true },
  { "159z6.com", true },
  { "16-qw.tk", true },
  { "1600esplanade.com", true },
  { "160763.com", true },
  { "160887.com", true },
  { "161233.com", true },
  { "161263.com", true },
  { "162223.com", true },
  { "162229.com", true },
  { "162231.com", true },
  { "162263.com", true },
  { "162361.com", true },
  { "162jonesrd.ca", true },
  { "163132.com", true },
  { "1644091933.rsc.cdn77.org", true },
  { "1661237.com", true },
  { "1661618.com", true },
  { "1666ks.com", true },
  { "166jk.cc", true },
  { "166ks.net", true },
  { "16836500.com", true },
  { "1683651.com", true },
  { "16836511.com", true },
  { "1683652.com", true },
  { "16836522.com", true },
  { "1683653.com", true },
  { "16836533.com", true },
  { "1683654.com", true },
  { "16836544.com", true },
  { "1683655.com", true },
  { "16836555.com", true },
  { "16836577.com", true },
  { "16836588.com", true },
  { "1683659.com", true },
  { "16836599.com", true },
  { "168365t.com", true },
  { "168btt.com", true },
  { "168btt.net", true },
  { "168fff.cc", true },
  { "168z6.com", true },
  { "168zz.cc", true },
  { "1698k.com", true },
  { "16packets.com", true },
  { "16z6.com", true },
  { "16z66.com", true },
  { "170376.com", true },
  { "170386.com", true },
  { "170686.com", true },
  { "170ks.com", true },
  { "171083.com", true },
  { "171ks.com", true },
  { "1720302.com", true },
  { "1720312.com", true },
  { "173940.com", true },
  { "1750studios.com", false },
  { "175k8.com", true },
  { "175ks.com", true },
  { "1768calc.com.au", true },
  { "176f88.com", true },
  { "176ks.net", true },
  { "177603.com", true },
  { "177ks.net", true },
  { "178kb.com", true },
  { "178ks.net", true },
  { "17kpw.cc", true },
  { "17kpw.com", true },
  { "17xile.com", true },
  { "17xrk.com", true },
  { "180btt.com", true },
  { "180k8.com", true },
  { "180ks.net", true },
  { "1811559.com", true },
  { "181k8.com", true },
  { "181ks.net", true },
  { "181z6.com", true },
  { "182162.com", true },
  { "182k8.com", true },
  { "182ks.com", true },
  { "182ks.net", true },
  { "182z6.com", true },
  { "183k8.com", true },
  { "183z6.com", true },
  { "1844329061.rsc.cdn77.org", true },
  { "184kb.com", true },
  { "185k8.com", true },
  { "185ks.com", true },
  { "185z6.com", true },
  { "186ks.com", true },
  { "186z6.com", true },
  { "1876996.com", true },
  { "187z6.com", true },
  { "1888lc.com", true },
  { "188cn-sb.com", true },
  { "188da.com", true },
  { "188kb.com", true },
  { "188z6.com", true },
  { "189z6.com", true },
  { "18f.gov", true },
  { "18f.gsa.gov", false },
  { "1911trust.com", true },
  { "192433.com", true },
  { "192ks.com", true },
  { "1941-45.ru", true },
  { "1972969867.rsc.cdn77.org", true },
  { "197k8.com", true },
  { "1981612088.rsc.cdn77.org", true },
  { "1994.io", true },
  { "19990bb.com", false },
  { "19990cc.com", false },
  { "19990d.com", false },
  { "19990dd.com", false },
  { "19990ee.com", false },
  { "19990gg.com", false },
  { "19990jj.com", false },
  { "19990k.com", false },
  { "19990nn.com", false },
  { "19990q.com", false },
  { "19990r.com", false },
  { "19990tt.com", false },
  { "19990zz.com", false },
  { "199ks.com", true },
  { "199ks.net", true },
  { "19btt.com", true },
  { "19hundert84.de", false },
  { "19qq.vip", true },
  { "1a-diamantscheiben.de", true },
  { "1a-werkstattgeraete.de", true },
  { "1ab-machinery.com", true },
  { "1ag777.com", true },
  { "1ag88.com", true },
  { "1android.de", true },
  { "1b1.pl", true },
  { "1baks.tk", true },
  { "1blazing.cf", true },
  { "1c-power.ru", true },
  { "1chan.pl", true },
  { "1cool.vip", true },
  { "1cover.co.nz", true },
  { "1cover.com.au", true },
  { "1cprosto.tk", true },
  { "1datatec.com", true },
  { "1e9.nl", true },
  { "1europlan.nl", true },
  { "1f123.net", true },
  { "1fach-digital.de", true },
  { "1fc0.org", true },
  { "1gp.us", true },
  { "1hc.be", true },
  { "1hourproofreading.com", true },
  { "1in9.net", true },
  { "1it.click", true },
  { "1js.de", false },
  { "1kando.com", false },
  { "1ki174.com", true },
  { "1kmi.co", true },
  { "1lc1.com", true },
  { "1lc8.com", true },
  { "1lc8.net", true },
  { "1ll.uk", true },
  { "1lord1faith.com", true },
  { "1malaysian.tk", true },
  { "1montre.fr", true },
  { "1morebounce.co.uk", true },
  { "1net.uk", true },
  { "1nfr.com", false },
  { "1oaklasvegas.com", true },
  { "1of16.de", true },
  { "1on1on1.de", true },
  { "1on1on1.tv", true },
  { "1onehouse.com", true },
  { "1panorama.ru", true },
  { "1password.ca", true },
  { "1password.com", true },
  { "1password.eu", true },
  { "1pw.ca", true },
  { "1r.is", true },
  { "1rs.nl", true },
  { "1sand0s.nl", true },
  { "1se.co", true },
  { "1se2or3.com", true },
  { "1st-bounce.co.uk", true },
  { "1st-community.de", true },
  { "1stcarpetcleaning.co.uk", true },
  { "1stchoicelandscapingwa.com", true },
  { "1stclassbouncycastles.co.uk", true },
  { "1stforfun.co.uk", true },
  { "1stpeninsulabouncers.co.uk", true },
  { "1ticks.com", true },
  { "1v1.xyz", true },
  { "1v9.im", true },
  { "1vpns.com", true },
  { "1way.faith", true },
  { "1whw.co.uk", true },
  { "1wirelog.de", true },
  { "1wl.uk", true },
  { "1zombie.team", true },
  { "2.wtf", true },
  { "200.network", true },
  { "2000meter.no", true },
  { "2001y.me", true },
  { "2012.ovh", true },
  { "2012review.tk", true },
  { "2013review.tk", true },
  { "2015review.tk", true },
  { "2018fifaworldcup.tk", true },
  { "2019k8.com", true },
  { "2022class1.ga", true },
  { "2026j95.com", true },
  { "202jj.com", true },
  { "204504byse.info", true },
  { "208garfield.com", true },
  { "208wns.com", true },
  { "20at.com", true },
  { "20denier.com", true },
  { "210k8.com", true },
  { "213k8.com", true },
  { "215dy.net", true },
  { "217778.com", true },
  { "218btt.com", true },
  { "21sthammersmith.org.uk", true },
  { "21stnc.us", true },
  { "21x9.org", true },
  { "2206p.com", true },
  { "22168365.com", true },
  { "2222365t.com", true },
  { "2222k8.com", true },
  { "2222k8.net", true },
  { "22245j.com", true },
  { "22256j.com", true },
  { "222b58.com", true },
  { "222k8.com", true },
  { "222k8.net", true },
  { "222tips.com", true },
  { "224918.com", true },
  { "225485.com", true },
  { "2255motion.com", true },
  { "2264707.ru", true },
  { "228668.com", true },
  { "22884.org", false },
  { "2288422.com", false },
  { "2288499.com", false },
  { "22884a.com", false },
  { "22884b.com", false },
  { "22884e.com", false },
  { "22884g.com", false },
  { "22884h.com", false },
  { "2288bet.vip", true },
  { "22918.net", true },
  { "22994.org", false },
  { "2299433.com", false },
  { "2299455.com", false },
  { "2299466.com", false },
  { "22delta.com", true },
  { "22i.co.uk", true },
  { "22lc8.com", true },
  { "22lc8.net", true },
  { "230beats.com", true },
  { "233.be", true },
  { "23333.link", true },
  { "2333blog.com", true },
  { "2333z6.com", true },
  { "23365t.com", true },
  { "233blog.com", true },
  { "233boy.com", true },
  { "233hub.com", true },
  { "233hub.net", true },
  { "233hub.org", true },
  { "233now.com", true },
  { "233ss.net", true },
  { "233v2.com", true },
  { "233vps.com", true },
  { "233yes.com", true },
  { "23436565.com", true },
  { "234lc.com", true },
  { "235u.net", true },
  { "238212.com", true },
  { "24-7.jp", true },
  { "24.ie", true },
  { "245meadowvistaway.com", true },
  { "246060.ru", true },
  { "247medplan.com", true },
  { "24848168.com", true },
  { "24848188.com", true },
  { "2484822.com", true },
  { "2484833.com", true },
  { "2484855.com", true },
  { "24848588.com", true },
  { "24848678.com", true },
  { "24848918.com", true },
  { "24848a.vip", true },
  { "24848b.vip", true },
  { "24848c.vip", true },
  { "24848d.vip", true },
  { "24848e.vip", true },
  { "24848jj.com", true },
  { "24848kk.com", true },
  { "24848ll.com", true },
  { "24848mm.com", true },
  { "24848nn.com", true },
  { "24848oo.com", true },
  { "24848pp.com", true },
  { "24848qq.com", true },
  { "24848rr.com", true },
  { "24848ss.com", true },
  { "24848tt.com", true },
  { "24848uu.com", true },
  { "24848v.vip", true },
  { "24848vv.com", true },
  { "24848w.vip", true },
  { "24848ww.com", true },
  { "24848x.vip", true },
  { "24848xx.com", true },
  { "24848y.vip", true },
  { "24848yy.com", true },
  { "24848z.vip", true },
  { "24848zz.com", true },
  { "249722.com", true },
  { "24dian30.com", true },
  { "24hour-locksmithsanantonio.com", true },
  { "24hourcyclist.co.uk", true },
  { "24hourelectricalservices.co.uk", true },
  { "24hourlocksmithbaltimore.com", true },
  { "24hourlocksmithdallastx.com", true },
  { "24hourlocksmithdetroit.com", true },
  { "24hourlocksmithhoustontx.com", true },
  { "24hourlocksmithshouston.com", true },
  { "24hourlocksmithspring.com", true },
  { "24hoursanantoniolocksmiths.com", true },
  { "24hourscienceprojects.com", true },
  { "24ip.com", true },
  { "24ip.de", true },
  { "24ip.fr", true },
  { "24onlinereview.com", true },
  { "24seven.pk", true },
  { "24timeravis.dk", true },
  { "24zpravy.cz", true },
  { "2502.net", true },
  { "250708.com", true },
  { "2525admin.nl", true },
  { "2555z6.com", true },
  { "255k8.com", true },
  { "256pages.com", false },
  { "2586p.com", true },
  { "258877.com", true },
  { "25may.tk", true },
  { "25north.nl", true },
  { "25reinyan25.net", true },
  { "2600edinburgh.org", true },
  { "2600hq.com", true },
  { "260887.com", true },
  { "263.info", true },
  { "2666z6.com", true },
  { "266k66.com", true },
  { "266z6.com", true },
  { "267221.com", true },
  { "267661.com", true },
  { "26z6.com", true },
  { "27000.best", true },
  { "2718282.net", true },
  { "276112.com", true },
  { "276117.com", true },
  { "2777z6.com", true },
  { "277z6.com", true },
  { "27878.com", true },
  { "27878dd.com", true },
  { "27878gg.com", true },
  { "27878hh.com", true },
  { "27878ii.com", true },
  { "27878jj.com", true },
  { "27878ll.com", true },
  { "27878nn.com", true },
  { "27878oo.com", true },
  { "27878pp.com", true },
  { "27878qq.com", true },
  { "27878rr.com", true },
  { "27878ss.com", true },
  { "27878tt.com", true },
  { "27878vv.com", true },
  { "27878ww.com", true },
  { "27878xx.com", true },
  { "27878yy.com", true },
  { "27878zz.com", true },
  { "27is.com", true },
  { "28-industries.com", true },
  { "281116.com", true },
  { "281180.de", true },
  { "281ks.com", true },
  { "282ks.com", true },
  { "28365cn-365.com", true },
  { "284365.com", true },
  { "285551.com", true },
  { "2858958.com", true },
  { "2888z6.com", true },
  { "288cn-563.com", true },
  { "288game.net", true },
  { "288k8.com", true },
  { "288kb.com", true },
  { "288ks.com", true },
  { "288z6.com", true },
  { "28peaks.com", true },
  { "28spots.net", true },
  { "291.com", true },
  { "291167.xyz", true },
  { "2912.nl", true },
  { "293921.com", true },
  { "2948.ca", true },
  { "2991236.com", true },
  { "2999z6.com", true },
  { "299ks.net", true },
  { "2ag88.com", true },
  { "2au.ru", true },
  { "2bas.nl", true },
  { "2bcompany.ch", false },
  { "2bis10.de", true },
  { "2blazing.cf", true },
  { "2c-b.com", true },
  { "2c-d.com", true },
  { "2c-e.com", true },
  { "2c-t-2.com", true },
  { "2c-t-7.com", true },
  { "2c-t-8.com", true },
  { "2cash.ru", true },
  { "2chan.eu", true },
  { "2chan.jp", true },
  { "2cv-fahrer.de", true },
  { "2evip.com", true },
  { "2fm.ie", true },
  { "2fm.radio", true },
  { "2fraud.pro", true },
  { "2gen.com", true },
  { "2gether.fr", true },
  { "2h-nagoya.org", true },
  { "2habc.com", true },
  { "2heartsbookings.co.uk", true },
  { "2hypeenterprises.com", true },
  { "2isk.in", true },
  { "2jhb.com", true },
  { "2kgwf.fi", true },
  { "2krueger.de", true },
  { "2lc8.com", true },
  { "2lc8.net", true },
  { "2li.ch", true },
  { "2lovebirdsblog.com", true },
  { "2manydots.nl", true },
  { "2mb.solutions", true },
  { "2melo.fr", true },
  { "2monkeysandme.com", true },
  { "2nains.ch", true },
  { "2nerds1bit.com", true },
  { "2nics.net", true },
  { "2pay.fr", true },
  { "2programmers.net", true },
  { "2rsc.com", true },
  { "2rsc.net", true },
  { "2stv.net", false },
  { "2th.me", true },
  { "2ulcceria.nl", true },
  { "2wheel.com", false },
  { "2y.fi", true },
  { "2y3x.com", true },
  { "3-dot-careapp1-146314.appspot.com", true },
  { "30019.com", true },
  { "3006789.com", true },
  { "300m.com", false },
  { "301.technology", true },
  { "301355.com", true },
  { "301ks.com", true },
  { "302422.com", true },
  { "303112.com", true },
  { "303312.com", true },
  { "3033888.com", false },
  { "303422.com", true },
  { "30375511.com", true },
  { "30375544.com", true },
  { "30375566.com", true },
  { "3040519.com", true },
  { "304122.com", true },
  { "304322.com", true },
  { "304622.com", true },
  { "3056999.com", true },
  { "308xpj.com", false },
  { "309422.com", true },
  { "30bet365.com", true },
  { "310422.com", true },
  { "311186.com", true },
  { "311191.com", true },
  { "313422.com", true },
  { "313xpj.com", false },
  { "314022.com", true },
  { "314122.com", true },
  { "314322.com", true },
  { "314522.com", true },
  { "314622.com", true },
  { "314633.com", true },
  { "314922.com", true },
  { "315xpj.com", false },
  { "316433.com", true },
  { "317811111.com", true },
  { "31782222.com", true },
  { "317822222.com", true },
  { "31783333.com", true },
  { "317833333.com", true },
  { "31784444.com", true },
  { "317844444.com", true },
  { "317855555.com", true },
  { "31786666.com", true },
  { "317866666.com", true },
  { "3178666666.com", true },
  { "317877777.com", true },
  { "3178888888.com", true },
  { "31789999.com", true },
  { "317899999.com", true },
  { "3178b.com", true },
  { "3178bbb.com", true },
  { "3178c.com", true },
  { "3178ccc.com", true },
  { "3178dd.com", true },
  { "3178ddd.com", true },
  { "3178e.com", true },
  { "3178f.com", true },
  { "3178g.com", true },
  { "3178h.com", true },
  { "3178i.com", true },
  { "3178iii.com", true },
  { "3178j.com", true },
  { "3178jjj.com", true },
  { "3178l.com", true },
  { "3178m.com", true },
  { "3178n.com", true },
  { "3178o.com", true },
  { "3178p.com", true },
  { "3178ppp.com", true },
  { "3178qqq.com", true },
  { "3178rrr.com", true },
  { "3178tt.com", true },
  { "3178ttt.com", true },
  { "3178uuu.com", true },
  { "3178vvv.com", true },
  { "3178ww.com", true },
  { "3178www.com", true },
  { "3178xx.com", true },
  { "3178xxx.com", true },
  { "3178yy.com", true },
  { "3178yyy.com", true },
  { "3178zzz.com", true },
  { "319422.com", true },
  { "319xpj.com", false },
  { "31du.cn", true },
  { "31klabs.com", true },
  { "320281.net", true },
  { "321132.com", true },
  { "321live.nl", true },
  { "3222z6.com", true },
  { "324022.com", true },
  { "324122.com", true },
  { "324133.com", true },
  { "324522.com", true },
  { "324533.com", true },
  { "324922.com", true },
  { "325422.com", true },
  { "326422.com", true },
  { "326433.com", true },
  { "329422.com", true },
  { "32bet365.com", true },
  { "32h.de", true },
  { "33168365.com", true },
  { "3322z6.com", true },
  { "333321365.com", true },
  { "3333365t.com", true },
  { "333365t.com", true },
  { "3333k8.com", true },
  { "3333k8.net", true },
  { "3333ylc.cc", true },
  { "3333z6.com", true },
  { "33365t.com", true },
  { "333b58.com", true },
  { "3344981.com", true },
  { "3344982.com", true },
  { "3344983.com", true },
  { "3344985.com", true },
  { "3344986.com", true },
  { "3345.com", true },
  { "3358m.com", true },
  { "335a.cc", true },
  { "3366z6.com", true },
  { "3369p.com", true },
  { "338393.com", true },
  { "3389p.com", true },
  { "338sa.com", true },
  { "33am8.com", true },
  { "33b58.com", true },
  { "33btt.net", true },
  { "33jiasu.com", true },
  { "33kb88.com", true },
  { "33lc8.com", true },
  { "33lc8.net", true },
  { "33weishang.com", true },
  { "340422.com", true },
  { "340622.com", true },
  { "340922.com", true },
  { "341422.com", true },
  { "341433.com", true },
  { "341533.com", true },
  { "341633.com", true },
  { "341733.com", true },
  { "341922.com", true },
  { "342022.com", true },
  { "342033.com", true },
  { "342133.com", true },
  { "342633.com", true },
  { "342733.com", true },
  { "342922.com", true },
  { "342933.com", true },
  { "343022.com", true },
  { "343622.com", true },
  { "34365t.com", true },
  { "343722.com", true },
  { "343922.com", true },
  { "34536565.com", true },
  { "345lc.com", true },
  { "346022.com", true },
  { "346033.com", true },
  { "346122.com", true },
  { "346233.com", true },
  { "346322.com", true },
  { "346422.com", true },
  { "346522.com", true },
  { "346533.com", true },
  { "346722.com", true },
  { "346922.com", true },
  { "3473-wiki.de", true },
  { "348233.com", true },
  { "348433.com", true },
  { "348533.com", true },
  { "349022.com", true },
  { "349033.com", true },
  { "349233.com", true },
  { "349433.com", true },
  { "349533.com", true },
  { "350422.com", true },
  { "350533.com", true },
  { "35089y.com", true },
  { "35089y1.com", true },
  { "35089y2.com", true },
  { "351113.com", true },
  { "3518k.com", true },
  { "354022.com", true },
  { "354233.com", true },
  { "354622.com", true },
  { "354633.com", true },
  { "354922.com", true },
  { "354933.com", true },
  { "355ks.com", true },
  { "356433.com", true },
  { "357maelai.co", true },
  { "360-staffing.com", true },
  { "360365.com", true },
  { "360hosting.com.au", true },
  { "360live.fr", true },
  { "360rail.nl", true },
  { "360vrs.com", true },
  { "361116.com", true },
  { "361171.com", true },
  { "361173.com", true },
  { "361183.com", true },
  { "365.asia", true },
  { "3651143.com", true },
  { "3651145.com", true },
  { "3651146.com", true },
  { "3651147.com", true },
  { "3651149.com", true },
  { "36525.hk", true },
  { "36533c.com", true },
  { "36533d.com", true },
  { "36533e.com", true },
  { "36533f.com", true },
  { "36533g.com", true },
  { "36533h.com", true },
  { "36533i.com", true },
  { "36533j.com", true },
  { "36533k.com", true },
  { "36533l.com", true },
  { "36533m.com", true },
  { "36533n.com", true },
  { "36533o.com", true },
  { "36533p.com", true },
  { "36533q.com", true },
  { "36533r.com", true },
  { "36533s.com", true },
  { "36533t.com", true },
  { "36533u.com", true },
  { "36533v.com", true },
  { "36554ll.com", true },
  { "36554mm.com", true },
  { "365600dl.com", true },
  { "365654321.com", true },
  { "36565f.com", true },
  { "3657654321.com", true },
  { "36594a.com", true },
  { "36594b.com", true },
  { "36594c.com", true },
  { "3659801.com", true },
  { "365b58.com", true },
  { "365cn-288.com", true },
  { "365daysreview.com", true },
  { "365electricalvn.com", true },
  { "365iosapp.com", true },
  { "365propertybuyer.co.uk", false },
  { "365sb-cn.com", true },
  { "365securitymg.com", true },
  { "365skulls.com", true },
  { "365y0.com", true },
  { "365y00.com", true },
  { "365y1.com", true },
  { "365y11.com", true },
  { "365y2.com", true },
  { "365y22.com", true },
  { "365y3.com", true },
  { "365y33.com", true },
  { "365y5.com", true },
  { "365y55.com", true },
  { "365y6.com", true },
  { "365y66.com", true },
  { "365y7.com", true },
  { "365y77.com", true },
  { "365y9.com", true },
  { "365y99.com", true },
  { "365yapan.com", true },
  { "365ypw.com", true },
  { "365yuwen.com", true },
  { "365zg.com", true },
  { "366k66.com", true },
  { "366z6.com", true },
  { "367553.com", true },
  { "367556.com", true },
  { "370422.com", true },
  { "371422.com", true },
  { "371687.com", true },
  { "371cloud.com", false },
  { "373.moe", true },
  { "373422.com", true },
  { "373816.com", true },
  { "374933.com", true },
  { "375422.com", true },
  { "375ks.com", true },
  { "376208.com", true },
  { "376557.com", true },
  { "377625.com", true },
  { "377632.com", true },
  { "377813.com", true },
  { "377ks.com", true },
  { "378553.com", true },
  { "378901.com", true },
  { "378902.com", true },
  { "378ks.com", true },
  { "379700.com", true },
  { "37987.com", false },
  { "37987c.com", false },
  { "37987d.com", false },
  { "37987e.com", false },
  { "37987f.com", false },
  { "37987g.com", false },
  { "380111333.com", true },
  { "380111444.com", true },
  { "380111666.com", true },
  { "380222000.com", true },
  { "380222222.com", true },
  { "380222444.com", true },
  { "380222555.com", true },
  { "380222666.com", true },
  { "380222777.com", true },
  { "380222888.com", true },
  { "380222999.com", true },
  { "3803300.com", true },
  { "380422.com", true },
  { "3806600.com", true },
  { "3807722.com", true },
  { "380805.com", true },
  { "3808833.com", true },
  { "3809955.com", true },
  { "382225.com", true },
  { "387763.com", true },
  { "3886aa.com", true },
  { "388z6.com", true },
  { "38irkutsk.tk", true },
  { "390422.com", true },
  { "390933.com", true },
  { "392422.com", true },
  { "393422.com", true },
  { "394022.com", true },
  { "394122.com", true },
  { "394322.com", true },
  { "394522.com", true },
  { "394622.com", true },
  { "394922.com", true },
  { "3957e.com", true },
  { "3957h.com", true },
  { "3957i.com", true },
  { "3957j.com", true },
  { "3957k.com", true },
  { "3957l.com", true },
  { "3957m.com", true },
  { "3957n.com", true },
  { "3957o.com", true },
  { "3957p.com", true },
  { "3957q.com", true },
  { "3957r.com", true },
  { "3957s.com", true },
  { "3957t.com", true },
  { "3957u.com", true },
  { "3957v.com", true },
  { "3957w.com", true },
  { "3957x.com", true },
  { "3957y.com", true },
  { "3957z.com", true },
  { "396228.com", false },
  { "396301.com", true },
  { "396302.com", true },
  { "396303.com", true },
  { "396304.com", true },
  { "396305.com", true },
  { "3963bb.com", true },
  { "3963cc.com", true },
  { "3963dd.com", true },
  { "3963ee.com", true },
  { "3963ff.com", true },
  { "396422.com", true },
  { "3970abc.com", true },
  { "3970bc.com", true },
  { "3970ccc.com", true },
  { "3970fa.com", true },
  { "3970ku.com", true },
  { "3970ok.com", true },
  { "3970win.com", true },
  { "3970yes.com", true },
  { "3970ylc.com", true },
  { "398.info", true },
  { "398kb.com", true },
  { "399ks.com", true },
  { "399z6.com", true },
  { "39w66.com", true },
  { "3aandl.com", true },
  { "3ags.de", true },
  { "3b.pm", true },
  { "3bigking.com", true },
  { "3blazing.cf", true },
  { "3c-d.de", true },
  { "3chat.org", true },
  { "3countiescastlehire.co.uk", true },
  { "3d-animator.net", true },
  { "3d-fotoservice.de", true },
  { "3d1t0r4.com", true },
  { "3danimation.tk", true },
  { "3dcollective.es", true },
  { "3de5.nl", true },
  { "3deeplearner.com", true },
  { "3dgep.com", true },
  { "3djuegos.com", true },
  { "3dmusiclab.nl", true },
  { "3do3dont.com", true },
  { "3dprinterwiki.org", true },
  { "3dprintinggear.net", true },
  { "3dreactions.com", true },
  { "3elife.vn", true },
  { "3gdh.vip", true },
  { "3haeuserprojekt.org", true },
  { "3haueserprojekt.org", true },
  { "3james.com", true },
  { "3k188.com", true },
  { "3k288.com", true },
  { "3k788.com", true },
  { "3k878.com", true },
  { "3k988.com", true },
  { "3lc8.com", true },
  { "3logic.ru", true },
  { "3mbo.de", true },
  { "3n5b.com", true },
  { "3niu6.com", true },
  { "3niuurl.com", false },
  { "3oneseven.com", true },
  { "3pestki.org", true },
  { "3plusdesign.gr", true },
  { "3prn.com", true },
  { "3queens.cz", true },
  { "3queens.io", true },
  { "3r.org.uk", true },
  { "3rsee.com", true },
  { "3s-datasolution.de", true },
  { "3s-datasolutions.de", true },
  { "3s-ddns.de", true },
  { "3s-dns.de", true },
  { "3s-hosting.de", true },
  { "3s-mail.de", true },
  { "3sdatasolution.de", true },
  { "3sdatasolutions.de", true },
  { "3sddns.de", true },
  { "3sdns.de", true },
  { "3shosting.de", true },
  { "3smail.de", true },
  { "3tribes.co.uk", true },
  { "3typen.tv", true },
  { "3v4l.org", true },
  { "3ve.com", true },
  { "3vlnaeet.cz", true },
  { "3w-solutions.fr", true },
  { "3xbit.com.br", true },
  { "4-it.de", true },
  { "4000milestare.com", true },
  { "400k8.com", true },
  { "4025c.com", true },
  { "4025d.com", true },
  { "4025f.com", true },
  { "4025g.com", true },
  { "4025h.com", true },
  { "4025i.com", true },
  { "4025j.com", true },
  { "4025k.com", true },
  { "4025l.com", true },
  { "4025n.com", true },
  { "4025p.com", true },
  { "4025q.com", true },
  { "4025s.com", true },
  { "4025t.com", true },
  { "4025u.com", true },
  { "4025v.com", true },
  { "4025w.com", true },
  { "4025x.com", true },
  { "4025y.com", true },
  { "403.ch", true },
  { "4048.co", true },
  { "40481234.com", true },
  { "40482345.com", true },
  { "40484567.com", true },
  { "40485678.com", true },
  { "40486789.com", true },
  { "4048aaa.com", true },
  { "4048b.com", true },
  { "4048ccc.com", true },
  { "4048ddd.com", true },
  { "4048e.com", true },
  { "4048eee.com", true },
  { "4048fff.com", true },
  { "4048ggg.com", true },
  { "4048hhh.com", true },
  { "4048i.com", true },
  { "4048iii.com", true },
  { "4048jjj.com", true },
  { "4048lll.com", true },
  { "4048mmm.com", true },
  { "4048ooo.com", true },
  { "4048p.com", true },
  { "4048ppp.com", true },
  { "4048q.com", true },
  { "4048qqq.com", true },
  { "4048r.com", true },
  { "4048rrr.com", true },
  { "4048s.com", true },
  { "4048sss.com", true },
  { "4048t.com", true },
  { "4048ttt.com", true },
  { "4048vvv.com", true },
  { "4048w.com", true },
  { "4048www.com", true },
  { "4048x.com", true },
  { "4048xxx.com", true },
  { "4048y.com", true },
  { "4048yyy.com", true },
  { "4048z.com", true },
  { "4048zzz.com", true },
  { "404notfound.com.br", true },
  { "40666888.com", false },
  { "406811.com", true },
  { "406833.com", true },
  { "4096b.com", true },
  { "40acts.org.uk", true },
  { "40percentpapermache.com", true },
  { "41199.com", true },
  { "411film.com", true },
  { "411movie.com", true },
  { "411quest.com", true },
  { "4151365.com", true },
  { "416365.com", true },
  { "41studio.com", true },
  { "42.tools", true },
  { "420.nerdpol.ovh", true },
  { "420java.com", true },
  { "420screen.com", true },
  { "4233070.com", true },
  { "428northampton.com", true },
  { "42ch.com", true },
  { "42day.info", true },
  { "42l.fr", true },
  { "432web.net", true },
  { "437844.com", true },
  { "439050.com", true },
  { "43klive.com", true },
  { "44-k.com", true },
  { "440887.com", true },
  { "44168365.com", true },
  { "441jj.com", false },
  { "441jz.com", true },
  { "442887.com", true },
  { "442jz.com", true },
  { "44365t.com", true },
  { "443887.com", true },
  { "443jz.com", true },
  { "444887.com", true },
  { "444b58.com", true },
  { "4455bet.vip", true },
  { "445887.com", true },
  { "44b58.com", true },
  { "451365.com", true },
  { "45365t.com", true },
  { "456365t.com", true },
  { "45674048.com", true },
  { "456lc.com", true },
  { "459022.com", true },
  { "45b.org", true },
  { "463855.com", true },
  { "4661049.com", true },
  { "46d88.com", true },
  { "47.rs", true },
  { "4706666.com", true },
  { "4716666.com", true },
  { "4726666.com", true },
  { "4756666.com", true },
  { "4761.cc", true },
  { "4762.cc", true },
  { "4776070.com", true },
  { "4786666.com", true },
  { "47d88.com", true },
  { "48365365cn.com", true },
  { "48365cn-365.com", true },
  { "487511.com", true },
  { "487522.com", true },
  { "487866.com", true },
  { "48d88.com", true },
  { "491mhz.net", true },
  { "492977.com", true },
  { "492y.com", true },
  { "497773.com", true },
  { "49889.com", true },
  { "499ks.com", true },
  { "499ks.net", true },
  { "49dollaridahoregisteredagent.com", true },
  { "4best.tk", true },
  { "4c-haircare.com", true },
  { "4dillusion.tk", true },
  { "4everproxy.com", true },
  { "4evip.com", true },
  { "4eyes.ch", true },
  { "4fit.ro", true },
  { "4g-server.eu", false },
  { "4garage.com.br", true },
  { "4gnews.pt", true },
  { "4hmediaproductions.com", true },
  { "4host.ch", true },
  { "4investors.de", true },
  { "4lock.com.br", true },
  { "4mm.org", true },
  { "4monar.com", true },
  { "4obgyne.com", true },
  { "4plebs.moe", true },
  { "4project.co.il", true },
  { "4th-ave-studio.com", true },
  { "4thdc.com", true },
  { "4u.services", false },
  { "4u2ore.net", true },
  { "4vector.com", true },
  { "4vf.de", true },
  { "4wrd.cc", true },
  { "4x.fi", true },
  { "4x4-27mc.nl", true },
  { "4x4.lk", true },
  { "4x4coatingen.nl", true },
  { "4xlabs.co", true },
  { "5-890.com", false },
  { "50.gd", true },
  { "500k8.com", true },
  { "500promocodes.com", true },
  { "500promokodov.ru", true },
  { "501117.com", true },
  { "5017701.com", true },
  { "5017702.com", true },
  { "5017703.com", true },
  { "5017704.com", true },
  { "5017705.com", true },
  { "5017801.com", true },
  { "5017802.com", true },
  { "5017803.com", true },
  { "5017804.com", true },
  { "5017805.com", true },
  { "502312.com", true },
  { "504122.com", true },
  { "504322.com", true },
  { "504622.com", true },
  { "504922.com", true },
  { "505343.com", false },
  { "5055990.com", true },
  { "506422.com", true },
  { "508kb.com", true },
  { "50lakeshore.com", true },
  { "50milli.com", true },
  { "50north.de", true },
  { "513651.com", true },
  { "51365a.com", true },
  { "51365aa.com", true },
  { "51365b.com", true },
  { "51365bb.com", true },
  { "51365c.com", true },
  { "51365cc.com", true },
  { "51365d.com", true },
  { "51365dd.com", true },
  { "51365ee.com", true },
  { "513maximus.site", true },
  { "513x.cc", true },
  { "514122.com", true },
  { "514522.com", true },
  { "514922.com", true },
  { "515422.com", true },
  { "516422.com", true },
  { "516btt.com", true },
  { "516btt.net", true },
  { "516ks.com", true },
  { "518.com.tw", true },
  { "51877.net", true },
  { "518k8.com", true },
  { "519422.com", true },
  { "5197.com", true },
  { "51acg.eu.org", true },
  { "51guaq.com", true },
  { "51tiaojiu.com", true },
  { "52002a.com", true },
  { "52002b.com", true },
  { "52002d.com", true },
  { "52002e.com", true },
  { "52002f.com", true },
  { "52002g.com", true },
  { "52002h.com", true },
  { "52002i.com", true },
  { "52002j.com", true },
  { "52002k.com", true },
  { "52002l.com", true },
  { "52002m.com", true },
  { "52002n.com", true },
  { "52002o.com", true },
  { "52002p.com", true },
  { "52002q.com", true },
  { "52002r.com", true },
  { "52002s.com", true },
  { "52002t.com", true },
  { "52002u.com", true },
  { "52002v.com", true },
  { "52002w.com", true },
  { "52002x.com", true },
  { "52002y.com", true },
  { "52051.com", true },
  { "52051t.com", true },
  { "52051u.com", true },
  { "52051v.com", true },
  { "52051w.com", true },
  { "52051x.com", true },
  { "52051y.com", true },
  { "52051z.com", true },
  { "52062e.com", true },
  { "52062g.com", true },
  { "52062j.com", true },
  { "52062k.com", true },
  { "52062p.com", true },
  { "52062u.com", true },
  { "52062y.com", true },
  { "524022.com", true },
  { "524622.com", true },
  { "524922.com", true },
  { "525.info", true },
  { "5287.com", true },
  { "529kb.com", true },
  { "52dashboard.com", true },
  { "52kb365.com", true },
  { "52ncp.net", true },
  { "52sykb.com", true },
  { "531422.com", true },
  { "532441.com", true },
  { "532445.com", true },
  { "534122.com", true },
  { "534622.com", true },
  { "534922.com", true },
  { "535kb.com", true },
  { "5364.com", true },
  { "536422.com", true },
  { "5364b.com", true },
  { "5364c.com", true },
  { "5364d.com", true },
  { "5364jc.com", true },
  { "536kb.com", true },
  { "53ningen.com", true },
  { "540922.com", true },
  { "541022.com", true },
  { "541622.com", true },
  { "541651.com", true },
  { "541722.com", true },
  { "541922.com", true },
  { "545922.com", true },
  { "546802.com", true },
  { "54below.com", true },
  { "54lsj.cc", true },
  { "551365.com", true },
  { "552365.com", true },
  { "552z6.com", true },
  { "55365t.com", true },
  { "5539z.com", true },
  { "553z6.com", true },
  { "55554048.com", true },
  { "555b58.com", true },
  { "555btt.com", true },
  { "555kb.com", true },
  { "555wfcp.com", true },
  { "555zlong.com", true },
  { "556021.com", true },
  { "5566bet.vip", true },
  { "556777.cc", true },
  { "556z6.com", true },
  { "557z6.com", true },
  { "558btt.net", true },
  { "558z6.com", true },
  { "559z6.com", true },
  { "55b58.com", true },
  { "55d88.com", true },
  { "55ks.app", true },
  { "55lc8.com", true },
  { "56011r.com", true },
  { "56011s.com", true },
  { "56011t.com", true },
  { "56011u.com", true },
  { "56011v.com", true },
  { "56011w.com", true },
  { "56011x.com", true },
  { "56011y.com", true },
  { "56011z.com", true },
  { "56365t.com", true },
  { "565kb.com", true },
  { "566k66.com", true },
  { "566ks.com", true },
  { "566z6.com", true },
  { "56736565.com", true },
  { "56784048.com", true },
  { "572kb.com", true },
  { "575kb.com", true },
  { "5763.org", true },
  { "576422.com", true },
  { "577z6.com", true },
  { "5781.org", true },
  { "578637.com", true },
  { "5792.org", true },
  { "579422.com", true },
  { "5795111.com", true },
  { "579533.com", true },
  { "5795444.com", true },
  { "5795885.com", true },
  { "5795886.com", true },
  { "5795887.com", true },
  { "5796.org", true },
  { "5797.org", true },
  { "581018.com", true },
  { "581kb.com", true },
  { "583422.com", true },
  { "585422.com", true },
  { "585kb.com", true },
  { "586422.com", true },
  { "5889k.com", true },
  { "588k8.com", true },
  { "588z6.com", true },
  { "58d88.com", true },
  { "58w66.com", true },
  { "58xiangka.com", true },
  { "591422.com", true },
  { "592227.com", true },
  { "592422.com", true },
  { "593-7.com", false },
  { "5930593.com", true },
  { "594022.com", true },
  { "594622.com", true },
  { "595422.com", true },
  { "595ks.com", true },
  { "596422.com", true },
  { "59759vip.com", true },
  { "59759z.com", true },
  { "5981168.com", true },
  { "5981655.com", true },
  { "5981668.com", true },
  { "5981669.com", true },
  { "5981677.com", true },
  { "5981688.com", true },
  { "5981699.com", true },
  { "5981800.com", true },
  { "5981811.com", true },
  { "5981822.com", true },
  { "5981833.com", true },
  { "5981855.com", true },
  { "5981866.com", true },
  { "5981877.com", true },
  { "5981899.com", true },
  { "5981918.com", true },
  { "5981s.com", true },
  { "5981t.com", true },
  { "5981v.com", true },
  { "5981w.com", true },
  { "59859h.vip", true },
  { "59859j.vip", true },
  { "59859k.vip", true },
  { "59859l.vip", true },
  { "59859y.vip", true },
  { "59859z.vip", true },
  { "598877.com", true },
  { "5997891.com", true },
  { "599980.com", true },
  { "599ks.com", true },
  { "59rus.tk", true },
  { "5agks.com", true },
  { "5apps.com", true },
  { "5c1fd0f31022cbc40af9f785847baaf9.space", true },
  { "5ccapitalinvestments.com", true },
  { "5chat.it", true },
  { "5dm.tv", true },
  { "5eki.jp", true },
  { "5francs.com", true },
  { "5gb.space", true },
  { "5goglobal.com", true },
  { "5i.gs", true },
  { "5icsb.com", true },
  { "5ilg.com", true },
  { "5in.win", true },
  { "5k66.ag", true },
  { "5kraceforals.com", true },
  { "5lc8.com", true },
  { "5lc8.net", true },
  { "5percentperweek.com", true },
  { "5stars.tv", true },
  { "5thchichesterscouts.org.uk", true },
  { "5y.fi", true },
  { "5yeb.com", true },
  { "60062b.cc", true },
  { "60062h.cc", true },
  { "60062i.cc", true },
  { "600k8.com", true },
  { "602422.com", true },
  { "602yb.com", true },
  { "603yb.com", true },
  { "604122.com", true },
  { "604322.com", true },
  { "604522.com", true },
  { "604622.com", true },
  { "605422.com", true },
  { "606422.com", true },
  { "606722.com", true },
  { "608885.com", true },
  { "608vets.com", true },
  { "609422.com", true },
  { "611135.com", true },
  { "611165.com", true },
  { "611195.com", true },
  { "614022.com", true },
  { "614322.com", true },
  { "614922.com", true },
  { "616btt.com", true },
  { "616f88.com", true },
  { "616xin.com", true },
  { "61730123.com", true },
  { "618btt.com", true },
  { "619kb.com", true },
  { "61z6.com", true },
  { "620207.com", true },
  { "621422.com", true },
  { "621kb.com", true },
  { "62222.com", true },
  { "622812.com", true },
  { "622z6.com", true },
  { "623kb.com", true },
  { "624022.com", true },
  { "624122.com", true },
  { "624322.com", true },
  { "624522.com", true },
  { "624922.com", true },
  { "625kb.com", true },
  { "626422.com", true },
  { "630422.com", true },
  { "631422.com", true },
  { "633663.cc", true },
  { "633663.net", true },
  { "633663.vip", true },
  { "633kb.com", true },
  { "633z6.com", true },
  { "634022.com", true },
  { "634322.com", true },
  { "634622.com", true },
  { "634922.com", true },
  { "635422.com", true },
  { "636422.com", true },
  { "6365ah.com", true },
  { "6365am.com", true },
  { "6365bj.com", true },
  { "6365cq.com", true },
  { "6365dx.com", true },
  { "6365fj.com", true },
  { "6365gd.com", true },
  { "6365gs.com", true },
  { "6365gx.com", true },
  { "6365gz.com", true },
  { "6365hb.com", true },
  { "6365hh.com", true },
  { "6365hk.com", true },
  { "6365hlj.com", true },
  { "6365hn.com", true },
  { "6365jl.com", true },
  { "6365js.com", true },
  { "6365jx.com", true },
  { "6365ln.com", true },
  { "6365lt.com", true },
  { "6365nmg.com", true },
  { "6365nn.com", true },
  { "6365nx.com", true },
  { "6365qh.com", true },
  { "6365sc.com", true },
  { "6365sd.com", true },
  { "6365sh.com", true },
  { "6365ss.com", true },
  { "6365sx.com", true },
  { "6365tj.com", true },
  { "6365tw.com", true },
  { "6365xj.com", true },
  { "6365xz.com", true },
  { "6365yd.com", true },
  { "6365yn.com", true },
  { "6365zj.com", true },
  { "639422.com", true },
  { "63gaming.com", true },
  { "640622.com", true },
  { "640722.com", true },
  { "640922.com", true },
  { "641022.com", true },
  { "641322.com", true },
  { "641422.com", true },
  { "641522.com", true },
  { "641622.com", true },
  { "641722.com", true },
  { "641822.com", true },
  { "641922.com", true },
  { "642022.com", true },
  { "642322.com", true },
  { "642422.com", true },
  { "642722.com", true },
  { "642822.com", true },
  { "642922.com", true },
  { "643022.com", true },
  { "643122.com", true },
  { "643722.com", true },
  { "643922.com", true },
  { "645022.com", true },
  { "645122.com", true },
  { "645322.com", true },
  { "645722.com", true },
  { "645822.com", true },
  { "645922.com", true },
  { "646022.com", true },
  { "646322.com", true },
  { "646722.com", true },
  { "649022.com", true },
  { "649622.com", true },
  { "649722.com", true },
  { "649822.com", true },
  { "64d88.com", true },
  { "65131a.com", true },
  { "65131b.com", true },
  { "65131c.com", true },
  { "65131d.com", true },
  { "65131e.com", true },
  { "65131f.com", true },
  { "65131g.com", true },
  { "65131h.com", true },
  { "65131i.com", true },
  { "65131j.com", true },
  { "65131k.com", true },
  { "65131l.com", true },
  { "65131m.com", true },
  { "65131n.com", true },
  { "65131o.com", true },
  { "65131p.com", true },
  { "65131q.com", true },
  { "65131r.com", true },
  { "65131s.com", true },
  { "65131t.com", true },
  { "65131u.com", true },
  { "65131v.com", true },
  { "65131w.com", true },
  { "65131x.com", true },
  { "65131y.com", true },
  { "65131z.com", true },
  { "651422.com", true },
  { "652422.com", true },
  { "652kb.com", true },
  { "6542277.com", true },
  { "6543399.com", true },
  { "65477.com", true },
  { "6547700.com", true },
  { "6547711.com", true },
  { "6547722.com", true },
  { "6547733.com", true },
  { "6547744.com", true },
  { "6547755.com", true },
  { "6547766.com", true },
  { "6548855.com", true },
  { "6548877.com", true },
  { "6556a.com", true },
  { "6556b.com", true },
  { "6556c.com", true },
  { "6556d.com", true },
  { "6556f.com", true },
  { "6556g.com", true },
  { "6556h.com", true },
  { "6556j.com", true },
  { "6556k.com", true },
  { "6556m.com", true },
  { "6556x.com", true },
  { "6556z.com", true },
  { "655ks.com", true },
  { "655z6.com", true },
  { "659422.com", true },
  { "659ks.com", true },
  { "65d88.com", true },
  { "66.tn", true },
  { "661326.com", true },
  { "6616.fun", true },
  { "66168365.com", true },
  { "6617365.com", true },
  { "6618.fun", true },
  { "6619k.com", true },
  { "661z6.com", true },
  { "662607.xyz", true },
  { "6627365.com", true },
  { "6629365.com", true },
  { "662k66.com", true },
  { "662z6.com", true },
  { "663365666.com", true },
  { "663365777.com", true },
  { "663365888.com", true },
  { "663365a.vip", true },
  { "663365b.vip", true },
  { "663365c.vip", true },
  { "663365d.vip", true },
  { "663365e.vip", true },
  { "663365f.vip", true },
  { "663365g.vip", true },
  { "663365h.vip", true },
  { "663365i.com", true },
  { "663365i.vip", true },
  { "663365j.com", true },
  { "663365k.com", true },
  { "663365l.com", true },
  { "663365m.com", true },
  { "663365n.com", true },
  { "663365o.com", true },
  { "663365p.com", true },
  { "663365q.com", true },
  { "663365r.com", true },
  { "663365s.com", true },
  { "663365t.com", true },
  { "663365u.com", true },
  { "663365v.com", true },
  { "663365w.com", true },
  { "663365x.com", true },
  { "663365y.com", true },
  { "663365z.com", true },
  { "663z6.com", true },
  { "664048.com", true },
  { "6652566.com", true },
  { "6658.fun", true },
  { "665z6.com", true },
  { "666111bet.com", true },
  { "66619991.com", true },
  { "666222bet.com", true },
  { "666333bet.com", true },
  { "666365t.com", true },
  { "666555bet.com", true },
  { "66664048.com", true },
  { "666668722.com", true },
  { "666888bet.com", true },
  { "66689j.com", true },
  { "6669255.com", true },
  { "666999bet.com", true },
  { "666am8.com", true },
  { "666b58.com", true },
  { "666k66.com", true },
  { "666k8.com", true },
  { "666k8.net", true },
  { "666omg.com", true },
  { "6671365.com", true },
  { "6672365.com", true },
  { "6673365.com", true },
  { "6677bet.vip", true },
  { "667z6.com", true },
  { "6685m.com", true },
  { "6689m.com", true },
  { "668am8.com", true },
  { "668k8.com", true },
  { "668k8.net", true },
  { "668ks.com", true },
  { "668z6.com", true },
  { "669z6.com", true },
  { "66agks.com", true },
  { "66b58.com", true },
  { "66d88.net", true },
  { "66k66.ag", true },
  { "66lc8.com", true },
  { "66lc8.net", true },
  { "670102.com", true },
  { "670422.com", true },
  { "670633.com", true },
  { "671422.com", true },
  { "672422.com", true },
  { "673422.com", true },
  { "673569.com", true },
  { "676422.com", true },
  { "676812.com", true },
  { "677z6.com", true },
  { "67836565.com", true },
  { "678365cc.com", true },
  { "678365t.com", true },
  { "67877777.com", false },
  { "67894048.com", true },
  { "678z6.com", true },
  { "679422.com", true },
  { "67y7.com", true },
  { "680422.com", true },
  { "6810app.com", true },
  { "6830521.com", true },
  { "6848.com", true },
  { "6863070.com", true },
  { "686848.com", true },
  { "688libo.com", true },
  { "688z6.com", true },
  { "68hvip.com", true },
  { "690422.com", true },
  { "691422.com", true },
  { "692422.com", true },
  { "693422.com", true },
  { "694322.com", true },
  { "694622.com", true },
  { "694922.com", true },
  { "698kb.com", true },
  { "6997896.com", true },
  { "699z6.com", true },
  { "69butterfly.com", true },
  { "69fps.gg", true },
  { "69games.xxx", true },
  { "69ks.com", true },
  { "69wasted.net", true },
  { "6dec.gc.ca", true },
  { "6k66.ag", true },
  { "6k662.ag", true },
  { "6k663.ag", true },
  { "6k666.ag", true },
  { "6k666.cc", true },
  { "6k669.ag", true },
  { "6lc8.com", true },
  { "6lc8.net", true },
  { "6lo.zgora.pl", true },
  { "700.az", true },
  { "700k8.com", true },
  { "700wns.com", true },
  { "70365365.com", true },
  { "704233.com", true },
  { "704533.com", true },
  { "7045h.com", true },
  { "704633.com", true },
  { "7080997.com", true },
  { "70872.com", true },
  { "709129.com", true },
  { "70d88.com", true },
  { "712433.com", true },
  { "712kb.com", true },
  { "713367.com", true },
  { "713387.com", true },
  { "713433.com", true },
  { "71365365.com", true },
  { "714133.com", true },
  { "714533.com", true },
  { "714633.com", true },
  { "715433.com", true },
  { "716176.com", true },
  { "716227.com", true },
  { "716331.com", true },
  { "718113.com", true },
  { "718227.com", true },
  { "718337.com", true },
  { "718433.com", true },
  { "718552.com", true },
  { "718772.com", true },
  { "719433.com", true },
  { "721167.com", true },
  { "721172.com", true },
  { "7214.cc", true },
  { "7214.com", true },
  { "722201.com", true },
  { "722z6.com", true },
  { "724233.com", true },
  { "726127.com", true },
  { "726162.com", true },
  { "726176.com", true },
  { "726217.com", true },
  { "726221.com", true },
  { "726433.com", true },
  { "728433.com", true },
  { "729433.com", true },
  { "730433.com", true },
  { "731433.com", true },
  { "731716.com", true },
  { "732433.com", true },
  { "73365365.com", true },
  { "733z6.com", true },
  { "735433.com", true },
  { "736371.com", true },
  { "736381.com", true },
  { "736433.com", true },
  { "738433.com", true },
  { "739433.com", true },
  { "73info.com", false },
  { "740833.com", true },
  { "741833.com", true },
  { "742833.com", true },
  { "743833.com", true },
  { "74d88.com", true },
  { "755a.cc", true },
  { "755z6.com", true },
  { "756337.com", true },
  { "75d88.com", true },
  { "762.ch", false },
  { "762116.com", true },
  { "763137.com", true },
  { "76365365.com", true },
  { "7652.cc", true },
  { "7654321c.com", false },
  { "76668.com", true },
  { "7666898.com", true },
  { "76669.com", true },
  { "766k66.com", true },
  { "767kb.com", true },
  { "769k.com", true },
  { "76z66.com", true },
  { "77018aa.com", false },
  { "77018bb.com", false },
  { "77018cc.com", false },
  { "77018dd.com", false },
  { "77018ee.com", false },
  { "77018vip.com", false },
  { "77168365.com", true },
  { "77177.de", true },
  { "772z6.com", true },
  { "773z6.com", true },
  { "775018.com", true },
  { "775z6.com", true },
  { "776z6.com", true },
  { "7770b.com", true },
  { "777234567.com", false },
  { "777365t.com", true },
  { "7776365.com", true },
  { "77774048.com", true },
  { "777coin.com", true },
  { "778z6.com", true },
  { "779z6.com", true },
  { "77dd.com", true },
  { "77lc8.com", true },
  { "77zxdy.com", true },
  { "781671.com", true },
  { "781683.com", true },
  { "783631.com", true },
  { "78365app.com", true },
  { "78365b.com", true },
  { "78365bb.com", true },
  { "78365c.com", true },
  { "78365cc.com", true },
  { "78365dd.com", true },
  { "78365ee.com", true },
  { "783lab.com", true },
  { "787637.com", true },
  { "7878365.com", true },
  { "787kb.com", true },
  { "7885765.com", true },
  { "7888813.com", true },
  { "7888815.com", true },
  { "7888821.com", true },
  { "78904048.com", true },
  { "7891553.com", true },
  { "7891997.com", true },
  { "7893.net", true },
  { "78936565.com", true },
  { "789365t.com", true },
  { "7894.net", true },
  { "789451.com", true },
  { "790security.co.za", true },
  { "792ww.com", true },
  { "793ww.com", true },
  { "797715.com", true },
  { "799ks.com", true },
  { "799z6.com", true },
  { "79ch.com", true },
  { "7careconnect.com", true },
  { "7delights.com", true },
  { "7delights.in", true },
  { "7g31.com", true },
  { "7geese.com", true },
  { "7graus.pt", true },
  { "7k66.ag", true },
  { "7k66.vip", true },
  { "7kicks.com", true },
  { "7kovrikov.ru", true },
  { "7l00p.com", true },
  { "7lb.de", true },
  { "7lc8.com", true },
  { "7milesglobal.com", true },
  { "7minutemiles.com", true },
  { "7pets.net", true },
  { "7plus.com.au", true },
  { "7proxies.com", true },
  { "7sdre.am", true },
  { "7sons.de", true },
  { "7thcircledesigns.com", true },
  { "7win.am", true },
  { "7x24servis.com", true },
  { "8002d88.com", true },
  { "8006d88.com", true },
  { "8008d88.com", true },
  { "8012d88.com", true },
  { "8015d88.com", true },
  { "8028d.com", true },
  { "8029d.com", true },
  { "80365365.com", true },
  { "804322.com", true },
  { "80651a.com", true },
  { "80651c.com", true },
  { "8065d.com", true },
  { "806kb.com", true },
  { "8078d.com", true },
  { "8080883.com", true },
  { "8080889.com", true },
  { "8083d.com", true },
  { "80883.cc", true },
  { "80887.cc", true },
  { "809088.cc", true },
  { "8092d88.com", true },
  { "809422.com", true },
  { "80993.net", true },
  { "809kb.com", true },
  { "80bin.com", true },
  { "8102d88.com", true },
  { "811121.com", true },
  { "811z6.com", true },
  { "812221.com", true },
  { "8128d.com", true },
  { "8129d.com", true },
  { "8130d88.com", true },
  { "81365365.com", true },
  { "814022.com", true },
  { "8153d.com", true },
  { "8156d.com", true },
  { "815jz.com", true },
  { "816jz.com", true },
  { "8170d.com", true },
  { "8173d.com", true },
  { "81818app.com", true },
  { "81818b.com", true },
  { "81818c.com", true },
  { "81818e.com", true },
  { "81818f.com", true },
  { "81818g.com", true },
  { "81818h.com", true },
  { "81818i.com", true },
  { "81818j.com", true },
  { "81818k.com", true },
  { "81818l.com", true },
  { "81818n.com", true },
  { "81818o.com", true },
  { "81818p.com", true },
  { "81818q.com", true },
  { "81818r.com", true },
  { "81818s.com", true },
  { "81818t.com", true },
  { "81818u.com", true },
  { "81818w.com", true },
  { "81818x.com", true },
  { "81818y.com", true },
  { "81818z.com", true },
  { "8186d.com", true },
  { "8187d.com", true },
  { "8189196.com", true },
  { "8189d.com", true },
  { "818z6.com", true },
  { "8190d.com", true },
  { "819kb.com", true },
  { "81d88.com", true },
  { "8200d.com", true },
  { "8202d.com", true },
  { "8206d.com", true },
  { "8207d88.com", true },
  { "8208d.com", true },
  { "8211p.com", true },
  { "8212p.com", true },
  { "8213p.com", true },
  { "8214p.com", true },
  { "8215p.com", true },
  { "8216p.com", true },
  { "8225.com", true },
  { "8226d.com", true },
  { "8227d88.com", true },
  { "8228d88.com", true },
  { "822z6.com", true },
  { "8230d.com", true },
  { "8230d88.com", true },
  { "8238d.com", true },
  { "8239d.com", true },
  { "827774.com", true },
  { "82781111.com", true },
  { "82783333.com", true },
  { "82784444.com", true },
  { "82785555.com", true },
  { "82786666.com", true },
  { "82789999.com", true },
  { "8278a.com", true },
  { "8278a.net", true },
  { "8278aa.com", true },
  { "8278aaa.com", true },
  { "8278b.com", true },
  { "8278b.net", true },
  { "8278bb.com", true },
  { "8278bbb.com", true },
  { "8278bet.com", true },
  { "8278c.net", true },
  { "8278ccc.com", true },
  { "8278d.com", true },
  { "8278d.net", true },
  { "8278ddd.com", true },
  { "8278e.net", true },
  { "8278ee.com", true },
  { "8278f.net", true },
  { "8278ff.com", true },
  { "8278fff.com", true },
  { "8278g.com", true },
  { "8278g.net", true },
  { "8278gg.com", true },
  { "8278ggg.com", true },
  { "8278h.net", true },
  { "8278hh.com", true },
  { "8278hhh.com", true },
  { "8278i.net", true },
  { "8278ii.com", true },
  { "8278iii.com", true },
  { "8278j.net", true },
  { "8278jj.com", true },
  { "8278k.com", true },
  { "8278kk.com", true },
  { "8278l.com", true },
  { "8278ll.com", true },
  { "8278m.com", true },
  { "8278mm.com", true },
  { "8278nn.com", true },
  { "8278oo.com", true },
  { "8278pp.com", true },
  { "8278qq.com", true },
  { "8278rr.com", true },
  { "8278ss.com", true },
  { "8278tt.com", true },
  { "8278w.com", true },
  { "8278ww.com", true },
  { "8278y.com", true },
  { "8278yy.com", true },
  { "82ag88.com", true },
  { "833792.com", true },
  { "833z6.com", true },
  { "8371p.com", true },
  { "8373p.com", true },
  { "8376p.com", true },
  { "8378p.com", true },
  { "8387p.com", true },
  { "8396p.com", true },
  { "842365.com", true },
  { "842844.com", true },
  { "847773.com", true },
  { "848jz.com", true },
  { "8522.am", true },
  { "8522club.com", true },
  { "8522ph.com", true },
  { "8522tw.com", true },
  { "8522usa.com", true },
  { "856kb.com", true },
  { "8602012.com", true },
  { "8602013.com", true },
  { "8602014.com", true },
  { "8602015.com", true },
  { "8602016.com", true },
  { "8602017.com", true },
  { "8602018.com", true },
  { "8602019.com", true },
  { "8602020.com", true },
  { "8602021.com", true },
  { "86086011.com", true },
  { "86086022.com", true },
  { "86086033.com", true },
  { "86086044.com", true },
  { "86086055.com", true },
  { "86086066.com", true },
  { "86086077.com", true },
  { "86086099.com", true },
  { "861kb.com", true },
  { "866300.vip", true },
  { "866305.vip", true },
  { "866308.vip", true },
  { "866k66.com", true },
  { "866z6.com", true },
  { "868z6.com", true },
  { "869kb.com", true },
  { "86btt.com", true },
  { "86metro.ru", true },
  { "86z66.com", true },
  { "8722am.com", true },
  { "8722cn.com", true },
  { "8722hk.com", true },
  { "8722ph.com", true },
  { "8722tw.com", true },
  { "8722usa.com", true },
  { "87365365.com", true },
  { "877791.com", true },
  { "877z6.com", true },
  { "878365aa.com", true },
  { "878365app.com", true },
  { "878365b.com", true },
  { "878365bb.com", true },
  { "878365c.com", true },
  { "878365cc.com", true },
  { "878365cn.com", true },
  { "878365d.com", true },
  { "878365dd.com", true },
  { "878365ee.com", true },
  { "878365ii.com", true },
  { "878365jj.com", true },
  { "878365ll.com", true },
  { "878365mm.com", true },
  { "878365nn.com", true },
  { "88-line.com", true },
  { "88-line.net", true },
  { "8801ks.com", true },
  { "88021.com", false },
  { "8802ks.com", true },
  { "8802p.com", true },
  { "8806d.com", true },
  { "8809ks.com", true },
  { "881-line.com", true },
  { "881-line.net", true },
  { "8812ks.com", true },
  { "8815d.com", true },
  { "88168365.com", true },
  { "8816d.com", true },
  { "8818ks.com", true },
  { "8819ks.com", true },
  { "881z6.com", true },
  { "8822d88.com", true },
  { "8826d.com", true },
  { "8828ks.com", true },
  { "882kb.com", true },
  { "882z6.com", true },
  { "8830ks.com", true },
  { "88365.net", true },
  { "88365t.com", true },
  { "8839ks.com", true },
  { "883z6.com", true },
  { "8850d88.com", true },
  { "88522am.com", true },
  { "885287.com", true },
  { "8858ks.com", true },
  { "8859ks.com", true },
  { "885kb.com", true },
  { "885z6.com", true },
  { "8860d.com", true },
  { "8861ks.com", true },
  { "8862d.com", true },
  { "8868ks.com", true },
  { "8869ks.com", true },
  { "886k66.com", true },
  { "886k8.com", true },
  { "886k8.net", true },
  { "886z6.com", true },
  { "887.ag", true },
  { "8871d.com", true },
  { "8872d.com", true },
  { "88740a.com", false },
  { "88740g.com", false },
  { "8875d.com", true },
  { "8876d.com", true },
  { "8879d.com", true },
  { "887k66.com", true },
  { "887z6.com", true },
  { "8881234j.com", true },
  { "888234j.com", true },
  { "8882ks.com", true },
  { "8883456j.com", true },
  { "888345j.com", true },
  { "8884567j.com", true },
  { "888456j.com", true },
  { "88851333.com", true },
  { "88851777.com", true },
  { "888567j.com", true },
  { "8885ks.com", true },
  { "8886789j.com", true },
  { "8886ks.com", true },
  { "8888209.com", true },
  { "88884048.com", true },
  { "888888722.com", true },
  { "88889822.com", true },
  { "8888yule8888.com", true },
  { "888funcity.com", true },
  { "888funcity.net", true },
  { "888k66.com", true },
  { "8890d.com", true },
  { "8890ks.com", true },
  { "8891d.com", true },
  { "8891ks.com", true },
  { "8892d.com", true },
  { "8892ks.com", true },
  { "8895d.com", true },
  { "8895ks.com", true },
  { "8897d.com", true },
  { "889vip2.com", true },
  { "889vip3.com", true },
  { "889vip4.com", true },
  { "889vip5.com", true },
  { "889w889.com", true },
  { "889w889.net", true },
  { "889z6.com", true },
  { "88btt.com", true },
  { "88btt.net", true },
  { "88djl.cc", true },
  { "88home9.com", true },
  { "88kash.com", true },
  { "88kb88.com", true },
  { "88lc8.net", true },
  { "88lc88.com", true },
  { "88lc88.net", true },
  { "88lecheng.com", true },
  { "88wewin.com", true },
  { "88yule11.com", true },
  { "88yule112.com", true },
  { "88yule113.com", true },
  { "88yule12.com", true },
  { "88yule13.com", true },
  { "88yule15.com", true },
  { "88yule16.com", true },
  { "88yule3.com", true },
  { "88yule5.com", true },
  { "88yule6.com", true },
  { "88yule7.com", true },
  { "88yule9.com", true },
  { "8900d.com", true },
  { "8906d.com", true },
  { "8907d.com", true },
  { "8908d.com", true },
  { "8914499.com", true },
  { "8919d.com", true },
  { "8920d.com", true },
  { "8921d.com", true },
  { "8925d.com", true },
  { "8926d.com", true },
  { "89365t.com", true },
  { "89386.com", true },
  { "89386a.com", true },
  { "89386b.com", true },
  { "89386c.com", true },
  { "89386d.com", true },
  { "89386e.com", true },
  { "89386l.com", true },
  { "8938885.com", true },
  { "897774.com", true },
  { "898z6.com", true },
  { "899ks.com", true },
  { "899z6.com", true },
  { "89btt.com", true },
  { "8ag88.com", true },
  { "8balls.nl", true },
  { "8btt.app", true },
  { "8k66.vip", true },
  { "8lc8.net", true },
  { "8maerz.at", true },
  { "8me.nl", true },
  { "8t8.eu", true },
  { "8tech.com.hk", true },
  { "8thportsmouth.org.uk", true },
  { "8tuffbeers.com", true },
  { "8win.am", true },
  { "8xx888.com", true },
  { "8xxbet.net", true },
  { "8xxxxxxx.com", true },
  { "8yun.ga", true },
  { "9-11commission.gov", true },
  { "900823.com", true },
  { "9009019.com", false },
  { "900k8.com", true },
  { "901543.com", true },
  { "903422.com", true },
  { "905422.com", true },
  { "906vv.com", true },
  { "9090819.com", true },
  { "90920.cn", true },
  { "90r.jp", true },
  { "9108.fun", true },
  { "911.gov", true },
  { "911216.xyz", true },
  { "9118.com", true },
  { "9118.hk", true },
  { "911commission.gov", true },
  { "912422.com", true },
  { "913422.com", true },
  { "914122.com", true },
  { "915kb.com", true },
  { "917.moe", true },
  { "918-siteinfo.com", true },
  { "918.com", true },
  { "9180.fun", true },
  { "9180nn.com", true },
  { "9180tt.com", true },
  { "9180vv.com", true },
  { "9180xx.com", true },
  { "9180yy.com", true },
  { "9180zz.com", true },
  { "918101.net", true },
  { "91816.net", true },
  { "9186.fun", true },
  { "9186119.com", true },
  { "9189.fun", true },
  { "91891849.com", true },
  { "91891854.com", true },
  { "91891856.com", true },
  { "91891878.com", true },
  { "918aac.com", true },
  { "918aait.co", true },
  { "918aak.com", true },
  { "918aav.com", true },
  { "918ac.com", true },
  { "918aff.com", true },
  { "918agr.co", true },
  { "918ajj.com", true },
  { "918akk.com", true },
  { "918amj.co", true },
  { "918att.com", true },
  { "918axx.com", true },
  { "918ayy.com", true },
  { "918bbm.co", true },
  { "918bbt.com", true },
  { "918bby.co", true },
  { "918bby.com", true },
  { "918bcf.co", true },
  { "918bcw.co", true },
  { "918bhh.com", true },
  { "918bip.co", true },
  { "918bis.co", true },
  { "918bit.co", true },
  { "918btt.com", true },
  { "918btt.net", true },
  { "918btty.com", true },
  { "918bttz.com", true },
  { "918byy.com", true },
  { "918ca.com", true },
  { "918cca.com", true },
  { "918cce.com", true },
  { "918ccq.com", true },
  { "918ch.com", true },
  { "918cr.com", true },
  { "918ctt.com", true },
  { "918cx.com", true },
  { "918dc04.com", true },
  { "918dc16.com", true },
  { "918dc19.com", true },
  { "918dda.com", true },
  { "918ddj.com", true },
  { "918ddo.com", true },
  { "918ddx.com", true },
  { "918dxx.com", true },
  { "918ee.com", true },
  { "918eej.com", true },
  { "918ej.com", true },
  { "918ev.com", true },
  { "918ffa.com", true },
  { "918fq.com", true },
  { "918fr.com", true },
  { "918fv.com", true },
  { "918gd.com", true },
  { "918hr.com", true },
  { "918hu.com", true },
  { "918hw.com", true },
  { "918ia.com", true },
  { "918iz.com", true },
  { "918ji.com", true },
  { "918jt.co", true },
  { "918kx.com", true },
  { "918mc.com", true },
  { "918md10.com", true },
  { "918md16.com", true },
  { "918md25.com", true },
  { "918mf.com", true },
  { "918nc.com", true },
  { "918nd.com", true },
  { "918nu.com", true },
  { "918ny.com", true },
  { "918pt.com", true },
  { "918qa.com", true },
  { "918qg.com", true },
  { "918qs.com", true },
  { "918qz.com", true },
  { "918rw.com", true },
  { "918sn.com", true },
  { "918ta.com", true },
  { "918te.com", true },
  { "918tj.com", true },
  { "918tr.com", true },
  { "918tw.com", true },
  { "918uh.com", true },
  { "918um.com", true },
  { "918vb.com", true },
  { "918ve.com", true },
  { "918vi.com", true },
  { "918vz.com", true },
  { "918wa.com", true },
  { "918we.com", true },
  { "918wo.com", true },
  { "918wq.com", true },
  { "918ww.com", true },
  { "918xe.com", true },
  { "918xn.com", true },
  { "918yy.net", true },
  { "918ze.com", true },
  { "918zm.com", true },
  { "918zv.com", true },
  { "918zw.com", true },
  { "919422.com", true },
  { "91d27.com", true },
  { "91d52.com", true },
  { "91d57.com", true },
  { "91d58.com", true },
  { "91d89.com", true },
  { "91fldz.com", true },
  { "91travel.info", true },
  { "91z6.com", true },
  { "922z6.com", true },
  { "924122.com", true },
  { "924322.com", true },
  { "924622.com", true },
  { "926422.com", true },
  { "927774.com", true },
  { "92owl.com", true },
  { "92url.com", true },
  { "931422.com", true },
  { "932422.com", true },
  { "933325.com", true },
  { "933z6.com", true },
  { "934122.com", true },
  { "937774.com", true },
  { "939394.org", true },
  { "940365.com", true },
  { "941988.cn", true },
  { "943022.com", true },
  { "9449-27a1-22a1-e0d9-4237-dd99-e75e-ac85-2f47-9d34.de", true },
  { "946022.com", true },
  { "946422.com", true },
  { "949022.com", true },
  { "949122.com", true },
  { "949622.com", true },
  { "949722.com", true },
  { "9499060.com", true },
  { "9499066.com", true },
  { "9499068.com", true },
  { "9499113.com", true },
  { "9499115.com", true },
  { "9499118.com", true },
  { "9499125.com", true },
  { "9499137.com", true },
  { "9499151.com", true },
  { "9499212.com", true },
  { "9499232.com", true },
  { "9499238.com", true },
  { "9499263.com", true },
  { "9499278.com", true },
  { "9499292.com", true },
  { "9499293.com", true },
  { "9499343.com", true },
  { "9499369.com", true },
  { "9499399.com", true },
  { "9499403.com", true },
  { "9499459.com", true },
  { "9499518.com", true },
  { "9499558.com", true },
  { "9499565.com", true },
  { "9499568.com", true },
  { "9499575.com", true },
  { "9499668.com", true },
  { "9499676.com", true },
  { "9499682.com", true },
  { "9499737.com", true },
  { "9499757.com", true },
  { "9499835.com", true },
  { "9499855.com", true },
  { "9499869.com", true },
  { "9499958.com", true },
  { "9499aaaa.com", true },
  { "9499bbbb.com", true },
  { "9499cccc.com", true },
  { "9499dc.com", true },
  { "9499dddd.com", true },
  { "9499eeee.com", true },
  { "9499ffff.com", true },
  { "9499gggg.com", true },
  { "9499good.com", true },
  { "9499hhhh.com", true },
  { "9499iiii.com", true },
  { "9499jjj.com", true },
  { "9499jjjj.com", true },
  { "9499kkkk.com", true },
  { "9499l.com", true },
  { "9499llll.com", true },
  { "9499love.com", true },
  { "9499mmmm.com", true },
  { "9499nnnn.com", true },
  { "9499oooo.com", true },
  { "9499pppp.com", true },
  { "9499qqqq.com", true },
  { "9499rrrr.com", true },
  { "9499ssss.com", true },
  { "9499ttt.com", true },
  { "9499tttt.com", true },
  { "9499uuuu.com", true },
  { "9499vvvv.com", true },
  { "9499wwww.com", true },
  { "9499xxx.com", true },
  { "9499xxxx.com", true },
  { "9499yl.com", true },
  { "9499yyyy.com", true },
  { "9499zzzz.com", true },
  { "94imk.com", true },
  { "955z6.com", true },
  { "95am8.com", true },
  { "96002.com", false },
  { "96002e.com", false },
  { "962312.com", true },
  { "96678.com", true },
  { "966k66.com", true },
  { "966kb.com", true },
  { "966ks.com", true },
  { "966z6.com", true },
  { "9679693.com", true },
  { "967you.com", true },
  { "9681909.com", true },
  { "96z66.com", true },
  { "972422.com", true },
  { "97735.com", true },
  { "97736.com", true },
  { "97737.com", true },
  { "97738.com", true },
  { "97739.com", true },
  { "977hghg.com", true },
  { "977kb.com", true },
  { "977z6.com", true },
  { "9788876.com", true },
  { "9800.cc", true },
  { "9822.am", true },
  { "9822am.com", true },
  { "9822cn.com", true },
  { "9822hk.com", true },
  { "9822ph.com", true },
  { "9822tw.com", true },
  { "9822usa.com", true },
  { "984.ch", true },
  { "985kb.com", true },
  { "988316.com", true },
  { "988z6.com", true },
  { "989z6.com", true },
  { "98d88.com", true },
  { "98lc98.net", true },
  { "99123j.com", true },
  { "9918883.com", true },
  { "991z6.com", true },
  { "992z6.com", true },
  { "99365t.com", true },
  { "993z6.com", true },
  { "99456j.com", true },
  { "9950p.com", true },
  { "99599.fi", true },
  { "99599.net", true },
  { "995z6.com", true },
  { "9968909.com", false },
  { "99789j.com", true },
  { "997z6.com", true },
  { "998081.com", true },
  { "9988551.com", true },
  { "9988959.com", true },
  { "9988ty.com", true },
  { "998k66.com", true },
  { "998sa.com", true },
  { "998wns.com", true },
  { "998z6.com", true },
  { "999365t.com", true },
  { "9998k8.com", true },
  { "99994048.com", true },
  { "99999822.com", true },
  { "999998722.com", true },
  { "999b58.com", true },
  { "999btt.net", true },
  { "999k66.com", true },
  { "999salon.co", true },
  { "999salon.com", true },
  { "999zlong.com", true },
  { "99agks.com", true },
  { "99d88.com", true },
  { "99kb88.com", true },
  { "99lib.net", true },
  { "99qp.org", true },
  { "99rst.org", true },
  { "99spokes.com", true },
  { "9ag88.com", true },
  { "9box.jp", true },
  { "9farm.com", true },
  { "9fvip.net", true },
  { "9h.pl", true },
  { "9iwan.net", true },
  { "9jabase.com.ng", true },
  { "9jk7opa.com", true },
  { "9k223.com", true },
  { "9k226.com", true },
  { "9k227.com", true },
  { "9k228.com", true },
  { "9k229.com", true },
  { "9k233.com", true },
  { "9k235.com", true },
  { "9k236.com", true },
  { "9k237.com", true },
  { "9k238.com", true },
  { "9k239.com", true },
  { "9k252.com", true },
  { "9k253.com", true },
  { "9k255.com", true },
  { "9k256.com", true },
  { "9k257.com", true },
  { "9k258.com", true },
  { "9k259.com", true },
  { "9k265.com", true },
  { "9k266.com", true },
  { "9k267.com", true },
  { "9k268.com", true },
  { "9k269.com", true },
  { "9k272.com", true },
  { "9k273.com", true },
  { "9k275.com", true },
  { "9k276.com", true },
  { "9k277.com", true },
  { "9k278.com", true },
  { "9k279.com", true },
  { "9k283.com", true },
  { "9k285.com", true },
  { "9k287.com", true },
  { "9k289.com", true },
  { "9k292.com", true },
  { "9k295.com", true },
  { "9k296.com", true },
  { "9k297.com", true },
  { "9k298.com", true },
  { "9k299.com", true },
  { "9k322.com", true },
  { "9k325.com", true },
  { "9k328.com", true },
  { "9k332.com", true },
  { "9k335.com", true },
  { "9k336.com", true },
  { "9k338.com", true },
  { "9k362.com", true },
  { "9k363.com", true },
  { "9k366.com", true },
  { "9k368.com", true },
  { "9k372.com", true },
  { "9k373.com", true },
  { "9k375.com", true },
  { "9k376.com", true },
  { "9k378.com", true },
  { "9k383.com", true },
  { "9k385.com", true },
  { "9k386.com", true },
  { "9k388.com", true },
  { "9k398.com", true },
  { "9k566.com", true },
  { "9k573.com", true },
  { "9k577.com", true },
  { "9k589.com", true },
  { "9k625.com", true },
  { "9k627.com", true },
  { "9k629.com", true },
  { "9k632.com", true },
  { "9k637.com", true },
  { "9k657.com", true },
  { "9k659.com", true },
  { "9k672.com", true },
  { "9k677.com", true },
  { "9k679.com", true },
  { "9k683.com", true },
  { "9k687.com", true },
  { "9k693.com", true },
  { "9k696.com", true },
  { "9k822.com", true },
  { "9k825.com", true },
  { "9k828.com", true },
  { "9k829.com", true },
  { "9k832.com", true },
  { "9k837.com", true },
  { "9k838.com", true },
  { "9k852.com", true },
  { "9k857.com", true },
  { "9k858.com", true },
  { "9k862.com", true },
  { "9k866.com", true },
  { "9k867.com", true },
  { "9k868.com", true },
  { "9k869.com", true },
  { "9k873.com", true },
  { "9k882.com", true },
  { "9k886.com", true },
  { "9k895.com", true },
  { "9k897.com", true },
  { "9k898.com", true },
  { "9kb.xyz", true },
  { "9kopb.ru", true },
  { "9lc9.com", true },
  { "9pkfz.com", true },
  { "9riddles.com", true },
  { "9to5notes.in", true },
  { "9uelle.jp", true },
  { "9ungnir.xyz", true },
  { "9vx.org", true },
  { "9yw.me", true },
  { "a-1basements.com", true },
  { "a-1indianawaterproofing.com", true },
  { "a-allard.be", true },
  { "a-care.net", true },
  { "a-classinflatables.co.uk", true },
  { "a-invest.de", true },
  { "a-msystems.com", true },
  { "a-oben.org", true },
  { "a-tes-cotes.com", true },
  { "a-wife.net", true },
  { "a-ztransmission.com", true },
  { "a00228.com", false },
  { "a04gameapp.com", true },
  { "a06gameapp.com", true },
  { "a06webapp.com", true },
  { "a0print.nl", true },
  { "a1bouncycastlehire.com", true },
  { "a1jumpandbounce.co.uk", true },
  { "a1post.bg", true },
  { "a1scuba.com", true },
  { "a210.online", true },
  { "a22z.xyz", true },
  { "a291.cc", true },
  { "a2a.me", true },
  { "a2a.net", true },
  { "a2ch.ru", true },
  { "a2nutrition.com.au", true },
  { "a2os.club", true },
  { "a2os.xyz", true },
  { "a30.tokyo", false },
  { "a36533.com", true },
  { "a36594.com", true },
  { "a365vip1.com", true },
  { "a365vip2.com", true },
  { "a365vip3.com", true },
  { "a365vip5.com", true },
  { "a365vip9.com", true },
  { "a3mobile.com", true },
  { "a4sound.com", true },
  { "a77018.com", false },
  { "a7m2.me", true },
  { "a88fc.com", true },
  { "aa-tour.ru", true },
  { "aa00228.com", false },
  { "aa4888.com", true },
  { "aa7666.com", true },
  { "aaa-racing.com", true },
  { "aaa-racing.net", true },
  { "aaa-racing.uk", true },
  { "aaainfosystems.com", true },
  { "aaapl.com", true },
  { "aaapo.com.br", true },
  { "aabanet.com.br", true },
  { "aaben-bank.dk", true },
  { "aabenbank.dk", true },
  { "aabenjaminjewelry.com", true },
  { "aacs-design.com", true },
  { "aadv.com.br", true },
  { "aadw.de", true },
  { "aalalbayt.com", true },
  { "aalalbayt.net", true },
  { "aalstmotors-usedcars.be", false },
  { "aaltocapital.com", true },
  { "aamwa.com", true },
  { "aandkevents.co.uk", true },
  { "aanmpc.com", true },
  { "aanwp.com", true },
  { "aaomidi.com", true },
  { "aapar.nl", true },
  { "aapas.org.ar", true },
  { "aarailfan.com", true },
  { "aarklendoia.com", true },
  { "aarkue.eu", true },
  { "aaron-russell.co.uk", true },
  { "aaronfurtado.com", true },
  { "aaronkimmig.de", true },
  { "aaronroyle.com", true },
  { "aaronsilber.me", true },
  { "aarquiteta.com.br", true },
  { "aartsplastics.nl", true },
  { "aasvets.co.uk", true },
  { "aatf.us", true },
  { "aati.be", true },
  { "aati.info", true },
  { "aattrans.com", true },
  { "aavienna.com", true },
  { "ab-photography.nl", true },
  { "ab288.com", true },
  { "ab2888.cn", true },
  { "ab28s.com", true },
  { "ab2web.com", true },
  { "abaapplianceservice.com", true },
  { "abaaustin.com", true },
  { "ababyco.com.hr", true },
  { "abacusbouncycastle.co.uk", true },
  { "abacusfi.com", true },
  { "abacustech.co.jp", true },
  { "abandonedmines.gov", true },
  { "abashevo.ml", true },
  { "abateroad66.it", true },
  { "abbadabbabouncycastles.co.uk", true },
  { "abbeyok.com", true },
  { "abbeyvetspets.co.uk", true },
  { "abbottscastles.co.uk", true },
  { "abbruch-star.de", true },
  { "abc-rz.de", true },
  { "abc.li", true },
  { "abcbouncycastlessurrey.co.uk", true },
  { "abcbouncyfactory.co.uk", true },
  { "abcdreamusa.com", true },
  { "abcheck.se", true },
  { "abckam.com", true },
  { "abcode.ml", true },
  { "abcpartyhire.com", true },
  { "abcstudio.com.au", true },
  { "abdel.me", true },
  { "abdelaliezzyn.be", true },
  { "abdelaliezzyn.tk", true },
  { "abdelsater.net", true },
  { "abdl.link", true },
  { "abdulawal.tk", true },
  { "abdullahavci.com", true },
  { "abdullahavci.com.tr", true },
  { "abdullahavci.net.tr", true },
  { "abdullahzubayerofficial.ml", true },
  { "abdulrahman.eu", true },
  { "abdulwahaab.ca", true },
  { "abdurrahmangazidis.tk", true },
  { "abdurrehman.tk", true },
  { "abe-elektro.de", true },
  { "abe-medical.jp", true },
  { "abeilles-idapi.fr", false },
  { "abelbarretto.tk", true },
  { "abelsflooringandtile.com", true },
  { "abenteuer-ahnenforschung.de", true },
  { "abeontech.com", true },
  { "aberdeencastles.co.uk", true },
  { "aberdeenjudo.co.uk", true },
  { "aberon.pl", true },
  { "abeus.com", true },
  { "abg.ninja", true },
  { "abhaldus.ee", true },
  { "abhisharma.me", true },
  { "abhishekkabdijain.tk", true },
  { "abiapp.net", true },
  { "abibruce.co.uk", true },
  { "abidinginhesed.com", true },
  { "abigisp.com", true },
  { "abilitycaresoftware.com", true },
  { "abilitymatters.co.uk", true },
  { "abilityone.gov", true },
  { "abilma.com", true },
  { "abilymp06.net", true },
  { "abinyah.com", true },
  { "abiscrane.com", true },
  { "abitech.tk", true },
  { "abitidalavoro.roma.it", true },
  { "abitidasposa.roma.it", true },
  { "abiturma.de", true },
  { "abjay.com", true },
  { "ableprop.net", true },
  { "abloop.com", true },
  { "abmackenzie.com", true },
  { "abmc.gov", true },
  { "abminiplex.in", true },
  { "abmledger.ca", true },
  { "abmtax.ca", true },
  { "abn-consultants.ie", true },
  { "abnehmen.com", true },
  { "abobuch.de", true },
  { "aboces.org", true },
  { "abogadocriminalorlando.com", true },
  { "abogadoperu.com", true },
  { "abogadoscav.com", true },
  { "abogadosescobarysanchez.es", true },
  { "abolicionistas.com", true },
  { "abolition.net", true },
  { "abolitionism.ca", true },
  { "abolitionism.co.uk", true },
  { "abolitionism.com", true },
  { "abolitionism.in", true },
  { "abolitionism.net", true },
  { "abolitionism.us", true },
  { "abolitionist-project.com", true },
  { "abolitionist-society.com", true },
  { "abolitionist.ca", true },
  { "abolitionist.co.uk", true },
  { "abolitionist.com", true },
  { "abolitionist.in", true },
  { "abolitionist.net", true },
  { "abolitionist.us", true },
  { "abolitionistparty.com", true },
  { "abolitionistproject.com", true },
  { "abolitionistsociety.com", true },
  { "abolitionniste.com", true },
  { "abolizionista.com", true },
  { "abonilla.com", true },
  { "aborla.net", true },
  { "abos.eu", false },
  { "abouncycastleman.co.uk", true },
  { "about-bangladesh.tk", true },
  { "about-ti.me", true },
  { "abouthrm.nl", true },
  { "aboutict.nl", true },
  { "aboutlegal.nl", true },
  { "aboutmedia.nl", true },
  { "aboutmyproperty.ca", true },
  { "aboutpublishers.nl", true },
  { "aboutshakil.tk", true },
  { "aboutspice.com", true },
  { "aboutyou.at", true },
  { "aboutyou.be", true },
  { "aboutyou.ch", true },
  { "aboutyou.de", true },
  { "aboutyou.nl", true },
  { "aboveaverageplumbing.com", true },
  { "abox-kb.com", true },
  { "abpis.hr", true },
  { "abracadabra.co.jp", false },
  { "abrahametalero.tk", true },
  { "abrakidabra.com.br", true },
  { "abraxasteam.com", true },
  { "abrightspark.gq", true },
  { "abrikos.group", true },
  { "abristolgeek.co.uk", true },
  { "abseits.org", true },
  { "absolem.cc", false },
  { "absolutcruceros.com", true },
  { "absoluteautobody.com", true },
  { "absolutedouble.co.uk", true },
  { "absolutelyinflatables.co.uk", true },
  { "absoluterush.net", true },
  { "absolutewebdesigns.com", true },
  { "absolutviajes.com", true },
  { "abstractbarista.net", true },
  { "abstraction21.com", true },
  { "absturztau.be", true },
  { "absturztaube.ch", true },
  { "absynthe-inquisition.fr", true },
  { "abth.tk", true },
  { "abthorpe.org", true },
  { "abulanov.com", true },
  { "abundent.com", true },
  { "abuse.ch", true },
  { "abuse.fi", true },
  { "abuse.io", true },
  { "abusive-host.tk", true },
  { "abvent.net", true },
  { "abvlbasketviganello.ch", false },
  { "abyssproject.net", true },
  { "ac-admin.pl", true },
  { "ac-cosmetics.nl", true },
  { "ac-elektro.com.ua", true },
  { "ac-epmservices.com", true },
  { "ac.milan.it", true },
  { "ac0g.dyndns.org", true },
  { "aca-creative.co.uk", true },
  { "acacia-gardens.co.uk", true },
  { "academiadebomberosonline.com", true },
  { "academica.nl", true },
  { "academichealthscience.net", true },
  { "academie-de-police.ch", false },
  { "academie-musique-nice.com", true },
  { "academkin.com", true },
  { "academus.io", true },
  { "academy-awards.ml", true },
  { "academytv.com.au", true },
  { "acampar.com.br", true },
  { "acaptureservices.com", true },
  { "acara-yoga.de", true },
  { "acareer.in", true },
  { "acarreosvillavicencio.com", true },
  { "acat.io", true },
  { "acatec.de", true },
  { "acbrussels-used.be", false },
  { "accademia24.it", true },
  { "accademiapugilistica.it", true },
  { "accadia.academy", true },
  { "accelaway.com", true },
  { "acceleratenetworks.com", true },
  { "accelerateyourworld.org", true },
  { "accelsnow.com", true },
  { "accentthailand.com", true },
  { "acceptancerecoverycenter.com", true },
  { "acces-elevation.fr", true },
  { "accesloges.com", true },
  { "accesoriosviaje.com", true },
  { "accessacab.co.uk", true },
  { "accessauto-occasions.be", false },
  { "accessgaragedoors.com", true },
  { "accessibility.gov", true },
  { "accessibilityguidelines.com", true },
  { "accessibletravelclub.com", true },
  { "accesskeycloning.com", true },
  { "accessoirescheveuxchic.com", true },
  { "accessoripersmartphone.it", true },
  { "acchicocchi.com", true },
  { "accionistaprincipiante.com", true },
  { "accme.co", true },
  { "accoladescreens.com.au", true },
  { "accord-application.com", true },
  { "accordiondoor.com", true },
  { "account.bbc.com", true },
  { "account4u.nl", true },
  { "accounts.firefox.com", true },
  { "accounts.google.com", true },
  { "accpl.co", true },
  { "accpodcast.com", true },
  { "accreditamento.net", true },
  { "accrosoft.com", true },
  { "accs.org.au", true },
  { "accudraftpaintbooths.com", true },
  { "accurateautobodywa.com", true },
  { "accutint.com", true },
  { "ace.one", true },
  { "acealters.com", false },
  { "aceanswering.com", true },
  { "acecerts.co.uk", true },
  { "acecolleges.edu.au", true },
  { "aceinflatables.com", true },
  { "aceinstituteonline.com", true },
  { "aceitedelcampo.com", true },
  { "acelpb.com", true },
  { "acem.org.au", true },
  { "acemobileforce.com", true },
  { "acemypaper.com", true },
  { "acendealuz.com.br", true },
  { "acerentalandsales.com", true },
  { "acerislaw.com", true },
  { "acessibilidadebr.com.br", true },
  { "acessoeducacao.com", true },
  { "acfun.eu.org", true },
  { "acg.social", true },
  { "acg.vc", true },
  { "acgqwq.gq", true },
  { "acgtalktw.com", true },
  { "achalay.org", false },
  { "achat-volets-roulants.fr", true },
  { "achenar.net", true },
  { "acheter-ethylotest.fr", true },
  { "achieveinternet.com", true },
  { "achiksongs.tk", true },
  { "achromatisch.de", true },
  { "achterblog.de", true },
  { "achterstieg.dedyn.io", true },
  { "achtzehn.de", true },
  { "achtzehn.eu", true },
  { "achtzehnterachter.de", true },
  { "achtzig20.de", true },
  { "achwo.de", true },
  { "aciksite.com", true },
  { "acinq.co", true },
  { "ackermann.ch", true },
  { "acl.gov", true },
  { "aclu.org", false },
  { "acluva.org", false },
  { "acmi.fr", true },
  { "acneintelligence.com", true },
  { "acnpacific.com", true },
  { "acodess.com", true },
  { "aconnor.xyz", true },
  { "acordes.online", true },
  { "acorncastles.co.uk", true },
  { "acorncredentialing.com", true },
  { "acourse.io", false },
  { "acousti-tech.com", true },
  { "acousticalsolutions.com", true },
  { "acoustics.network", true },
  { "acoustics.tech", true },
  { "acousticsoundrecords.com", true },
  { "acoustique-tardy.com", false },
  { "acperu.ch", false },
  { "acquaparrucchieri.it", true },
  { "acquire.media", true },
  { "acquisition.gov", true },
  { "acquistareviagragenericoitalia.net", false },
  { "acrepairgeorgetown.com", true },
  { "acrepairhutto.com", true },
  { "acrepairroundrocktx.com", true },
  { "acrevalue.com", true },
  { "acriticismlab.org", true },
  { "acronis.com", true },
  { "acronis.org", true },
  { "acrosstheblvd.com", true },
  { "acroyoga-nuernberg.de", true },
  { "acrylbilder-acrylmalerei.de", true },
  { "acrylicwifi.com", true },
  { "acs-nettoyage-entretien-immeuble.com", true },
  { "acsbbs.org", true },
  { "acsc.gov.au", true },
  { "acscbasket.com", true },
  { "acsemb.org", true },
  { "acsports.ca", true },
  { "act-safety.nl", true },
  { "actc.org.uk", true },
  { "actgruppe.de", false },
  { "actheater.com", true },
  { "acticu.com", true },
  { "actiefgeld.nl", false },
  { "action-verite.fr", true },
  { "actioncleaningnd.com", true },
  { "actioncoachignite.co.za", true },
  { "actionfinancialservices.net", true },
  { "actionlabs.net", true },
  { "actionmadagascar.ch", false },
  { "actionsack.com", true },
  { "actionselling.com", true },
  { "actionverb.com", true },
  { "activatemyiphone.com", true },
  { "activateudid.com", true },
  { "active-tluszcz.pl", true },
  { "active.hu", false },
  { "active247.info", true },
  { "activeaerogels.com", true },
  { "activecare-monitor.com", false },
  { "activeexcavator.com", true },
  { "activefootandankle.com", true },
  { "activehire.co.uk", true },
  { "activeleisure.ie", true },
  { "activephoto.se", true },
  { "activespaceautomation.com", true },
  { "activespacetech.com", true },
  { "activityeventhire.co.uk", true },
  { "actom.cc", true },
  { "actonwoodworks.com", true },
  { "actors-cafe.net", true },
  { "actualadmins.com", true },
  { "actualidadblog.com", true },
  { "actualidadecommerce.com", true },
  { "actualidadgadget.com", true },
  { "actualidadiphone.com", true },
  { "actualidadkd.com", true },
  { "actualidadliteratura.com", true },
  { "actualidadmotor.com", true },
  { "actualidadviajes.com", true },
  { "actualsolutions.am", true },
  { "acudire.es", true },
  { "acuica.co.uk", false },
  { "acul.me", true },
  { "aculocity.com", true },
  { "acumed-diagnostic.com", true },
  { "acunetix.com", true },
  { "acupuntura.coach", true },
  { "acupuntura.doctor", true },
  { "acupuntura.institute", true },
  { "acupunturavalencia.xyz", true },
  { "acus.gov", true },
  { "acutewealthadvisors.com", true },
  { "acwcerts.co.uk", true },
  { "acwi.gov", true },
  { "acy.com", true },
  { "acyfxasia.com", true },
  { "acyume.com", true },
  { "ad-notam.asia", true },
  { "ad-notam.ch", true },
  { "ad-notam.co.uk", true },
  { "ad-notam.com", true },
  { "ad-notam.de", true },
  { "ad-notam.fr", true },
  { "ad-notam.it", true },
  { "ad-notam.pt", true },
  { "ad-notam.us", true },
  { "ad4msan.com", true },
  { "ad4msan.win", true },
  { "ada.gov", true },
  { "adaera.com", true },
  { "adalis.org", true },
  { "adam-ant.co.uk", true },
  { "adam-kostecki.de", true },
  { "adam.lgbt", true },
  { "adamas-magicus.ru", true },
  { "adambryant.ca", false },
  { "adamdixon.co.uk", true },
  { "adamdorman.com", true },
  { "adamfontenot.com", true },
  { "adamgibbins.com", true },
  { "adamh.us", true },
  { "adamkostecki.de", true },
  { "adamlee.com", true },
  { "adamoshaver.com", true },
  { "adamoutler.com", true },
  { "adamricheimer.com", true },
  { "adams.dk", true },
  { "adamsasphaltpaving.com", true },
  { "adamstas.com", true },
  { "adamyuan.xyz", true },
  { "adappt.co.uk", true },
  { "adapptlabs.com", true },
  { "adapt-elektronik.com", true },
  { "adapt.de", true },
  { "adaptablesecurity.org", true },
  { "adaptergonomics.com", true },
  { "adapti.de", true },
  { "adaptiveicons.com", true },
  { "adaptivemechanics.edu.au", true },
  { "adarixconsultores.com", true },
  { "adasbench.com", true },
  { "adativos.com.br", true },
  { "adawolfa.cz", true },
  { "adayinthelifeof.nl", true },
  { "adblockextreme.com", true },
  { "adblockextreme.net", true },
  { "adblockextreme.org", true },
  { "adc64.com", true },
  { "adceuta.tk", true },
  { "adcnvs.com", true },
  { "addcrazy.com", true },
  { "adderall.space", true },
  { "addicional.com", true },
  { "addictic.fr", true },
  { "addictionresource.com", true },
  { "addictively.com", true },
  { "addiko.net", true },
  { "addiko.rs", true },
  { "addisoncrump.info", true },
  { "addnewsite.tk", true },
  { "addnine.com", true },
  { "addo-addo.com", true },
  { "addon.watch", true },
  { "addones.org", true },
  { "addtoany.com", true },
  { "adduono.com", true },
  { "addvalue-renovations.co.uk", true },
  { "adelaidecc.com.au", true },
  { "adelebeals.com", true },
  { "adelightfulglow.com", true },
  { "adeline.mobi", true },
  { "adentalsolution.com", true },
  { "adept-elearning.com", true },
  { "adept.org.pl", true },
  { "adesa.co.uk", true },
  { "adevel.eu", true },
  { "adex.network", true },
  { "adf-safetytools.com", true },
  { "adf.rocks", true },
  { "adftrasporti.it", true },
  { "adhd-inattentive.com", true },
  { "adhesivelaundry.co.uk", true },
  { "adhocracy.plus", true },
  { "adidasrunningpartners.com", true },
  { "adiehard.party", false },
  { "adimaja.com", true },
  { "adimplere.com.br", true },
  { "adingenierie.fr", true },
  { "adiprospero.it", true },
  { "aditibhatia.com", true },
  { "adjagu.org", true },
  { "adlerneves.com", true },
  { "adlerneves.com.br", true },
  { "adlerosn.com", true },
  { "adlerosn.com.br", true },
  { "adlershop.ch", true },
  { "adlignum.se", true },
  { "adme.co.il", true },
  { "admin-serv.net", true },
  { "admin.casa", true },
  { "admin.fedoraproject.org", true },
  { "admin.google.com", true },
  { "admin.stg.fedoraproject.org", true },
  { "admind.at", true },
  { "adminforge.de", true },
  { "administracionessaez.es", true },
  { "administratie-smits.nl", true },
  { "administratiekantoorblom.nl", true },
  { "administrator.de", true },
  { "administratorserwera.pl", true },
  { "adminless.ovh", true },
  { "adminlinux.pl", true },
  { "admino.cz", true },
  { "adminrezo.fr", true },
  { "admirable.one", true },
  { "admody.com", true },
  { "admongo.gov", true },
  { "adnexa.it", true },
  { "adnolesh.com", true },
  { "adoll.ml", true },
  { "adollarseo.com", true },
  { "adomani-italia.com", true },
  { "adomicilio.com.gt", true },
  { "adonai.eti.br", true },
  { "adonis.hosting", true },
  { "adonis.media", true },
  { "adoniscabaret.co.uk", true },
  { "adonisgrup.ro", true },
  { "adontenchambers.com", true },
  { "adoptionlink.co.uk", true },
  { "adoptionpregnancycenter.com", true },
  { "adoptionpregnancycenter.net", true },
  { "adorecricket.com", true },
  { "adorewe.com", true },
  { "adorno-gymnasium.de", true },
  { "adoucisseur.shop", true },
  { "adpkdsim.org", true },
  { "adquisitio.co.uk", true },
  { "adquisitio.es", true },
  { "adquisitio.fr", true },
  { "adquisitio.it", true },
  { "adr.gov", true },
  { "adra.com", true },
  { "adrafinil.wiki", true },
  { "adrenalin.od.ua", true },
  { "adrenalin.travel", true },
  { "adrian.web.id", true },
  { "adrianbechtold.de", true },
  { "adriancitu.com", true },
  { "adriancostin.ro", true },
  { "adrianmejias.com", true },
  { "adrianobarbosa.xyz", true },
  { "adriatrans.ga", true },
  { "adrienjacquierbret.com", true },
  { "adrienkohlbecker.com", true },
  { "adriennesmiles.com", true },
  { "adrup.com", true },
  { "adsamcik.com", true },
  { "adsbouncycastles.co.uk", true },
  { "adsbtc.org", true },
  { "adsl2meg.fr", true },
  { "adsviews.gq", true },
  { "adswoo.com", true },
  { "adtelligent.com", true },
  { "adtgroup.com", true },
  { "adultwebcams1.com", true },
  { "adurra.com", true },
  { "aduvi.de", true },
  { "adv-f1.ru", true },
  { "adv.cr", true },
  { "advaith.fun", true },
  { "advaithbot.com", true },
  { "advance.hr", true },
  { "advanced-fleet-services.com", true },
  { "advanced-scribes.com", true },
  { "advanced.info", false },
  { "advanceddieselspokane.com", true },
  { "advancedelectricalservicesqld.com.au", true },
  { "advancedendoscopycenter.net", true },
  { "advancedoneroofing.com", true },
  { "advancedprotectionkey.com", true },
  { "advancedprotectionsecuritykey.com", true },
  { "advancedsurgicalconsultantsllc.com", true },
  { "advancedurologyswla.com", true },
  { "advancedwriters.com", true },
  { "advanceworx.com", true },
  { "advancis.net", true },
  { "advantagehomeexteriors.com", true },
  { "advantagemechanicalinc.com", true },
  { "advantis.tk", true },
  { "advara.com", true },
  { "advenacs.com", true },
  { "advenacs.com.au", true },
  { "advens.com", true },
  { "advens.fr", true },
  { "advento.bg", true },
  { "adventry.tk", true },
  { "adventure-inn.com", true },
  { "adventurecreators.com", true },
  { "adventuredrives.com", false },
  { "adventureforest.co.nz", true },
  { "adventureforest.nz", true },
  { "adventuregamers.com", true },
  { "adventurenow.nl", true },
  { "adventureswithlillie.ca", true },
  { "adventurousway.com", true },
  { "advertis.biz", true },
  { "advocate-europe.eu", true },
  { "advocoeurdehaan.nl", true },
  { "advogatech.com.br", true },
  { "advokat-malinovskii.ml", true },
  { "advokat-romanov.com", true },
  { "advokaty-yuristy.tk", true },
  { "advtran.com", true },
  { "adware.pl", false },
  { "adwokatkosterka.pl", true },
  { "adwokatzdunek.pl", true },
  { "adxperience.com", true },
  { "adzuna.at", true },
  { "adzuna.ca", true },
  { "adzuna.co.nz", true },
  { "adzuna.co.za", true },
  { "adzuna.com", true },
  { "adzuna.com.au", true },
  { "adzuna.com.br", true },
  { "adzuna.de", true },
  { "adzuna.fr", true },
  { "adzuna.in", true },
  { "adzuna.it", true },
  { "adzuna.nl", true },
  { "adzuna.pl", true },
  { "adzuna.ru", true },
  { "adzuna.sg", true },
  { "ae-construction.co.uk", true },
  { "ae-dir.com", true },
  { "ae-dir.org", true },
  { "ae86.dog", true },
  { "ae86.plus", true },
  { "ae86b.com", true },
  { "ae86c.com", true },
  { "ae86dj.com", true },
  { "ae86nb.com", true },
  { "aebian.org", true },
  { "aecexpert.fr", true },
  { "aecis.org", true },
  { "aedollon.com", true },
  { "aefcleaning.com", true },
  { "aegis.moe", true },
  { "aegisalarm.co.uk", true },
  { "aegisalarm.com", true },
  { "aegisalarms.co.uk", true },
  { "aegisalarms.com", true },
  { "aegrel.ee", true },
  { "aeh5134.cc", true },
  { "aehe.us", true },
  { "aei.co.uk", true },
  { "aeksistem.com", true },
  { "aelurus.com", true },
  { "aenterprise.info", true },
  { "aeon.co", true },
  { "aeonct.org", true },
  { "aeradesign.com", true },
  { "aerandir.fr", true },
  { "aergia.eu", true },
  { "aerisnetwork.com", true },
  { "aerlux.md", true },
  { "aero-pioneer.com", true },
  { "aero.parts", true },
  { "aeroacademia.com.mx", true },
  { "aeroalbrook.com", true },
  { "aerobasegroup.com", true },
  { "aerobotz.com", true },
  { "aeronautix.com", true },
  { "aeronote.net", true },
  { "aeropole.de", true },
  { "aeropole.eu", true },
  { "aerorecords.net", true },
  { "aerosimexperience.com", true },
  { "aerospace-schools.com", true },
  { "aerotechcoatings.com", true },
  { "aertel.ie", true },
  { "aes-freundeskreis.de", true },
  { "aessencia.com.br", true },
  { "aestheticsplus.xyz", true },
  { "aesthetikpiercing.de", true },
  { "aesthetx.com", true },
  { "aeternus.tech", true },
  { "aetherc0r3.eu", true },
  { "aetherlink.de", true },
  { "aextron.com", true },
  { "aextron.de", true },
  { "aextron.org", true },
  { "afashion.com.au", true },
  { "afavre.io", true },
  { "afcompany.it", true },
  { "afcurgentcarelyndhurst.com", true },
  { "affaire.com", true },
  { "affairefacile.net", true },
  { "affarsnatverk.nu", true },
  { "affektblog.de", true },
  { "affichagepub3.com", true },
  { "affiliatefeatures.com", true },
  { "affiliates.trade", true },
  { "affiliatetest.azurewebsites.net", true },
  { "affilie.de", true },
  { "affinity.co", true },
  { "affinitysync.com", true },
  { "affissioni.roma.it", true },
  { "affittacamere.roma.it", true },
  { "affittialmare.it", true },
  { "affittisalento.it", true },
  { "affordableazdivorce.com", false },
  { "affordableenvironmental.net", true },
  { "affordablehealthquotesforyou.com", true },
  { "affordableinsurancenow.com", true },
  { "affordablemudjacking.com", true },
  { "affordablepapers.com", true },
  { "affordableracingparts.com.au", true },
  { "affpass.com", true },
  { "affping.com", true },
  { "afghan.dating", true },
  { "afgn.com.ua", true },
  { "afi-business-consulting.com", true },
  { "aficards.com", true },
  { "aficionados.com.br", true },
  { "afilio.de", true },
  { "afinadoronline.com.br", true },
  { "afinaudio.com", true },
  { "aflebedevo.tk", true },
  { "afmtevents.com", true },
  { "afp548.com", true },
  { "afree.ir", false },
  { "afri.cc", true },
  { "africa.dating", true },
  { "africalebanon.tk", true },
  { "africanhosting.ml", true },
  { "africanimpact.com", true },
  { "africantourer.com", true },
  { "afrikarl.de", true },
  { "afrikmag.com", true },
  { "afrodigital.uk", true },
  { "afs-asso.org", true },
  { "after.digital", true },
  { "afterdwi.info", true },
  { "afterhate.fr", true },
  { "afterpay.com", true },
  { "aftonpravdan.nu", true },
  { "afva.net", true },
  { "afwd.international", true },
  { "ag-2.net", true },
  { "ag-3.net", true },
  { "ag-33.net", true },
  { "ag-55.net", true },
  { "ag-777.com", true },
  { "ag0.app", true },
  { "ag0101g.com", true },
  { "ag0202a.com", true },
  { "ag0707a.com", true },
  { "ag1515a.com", true },
  { "ag1588.com", true },
  { "ag173168.com", true },
  { "ag18ks.com", true },
  { "ag2020a.com", true },
  { "ag2983.com", true },
  { "ag3131a.com", true },
  { "ag3232g.com", true },
  { "ag4141a.com", true },
  { "ag4848g.com", true },
  { "ag4949g.com", true },
  { "ag5688.com", true },
  { "ag58ks.com", true },
  { "ag600.com", true },
  { "ag6005.com", true },
  { "ag6016.com", true },
  { "ag6033.com", true },
  { "ag6037.com", true },
  { "ag6072.com", true },
  { "ag6086.com", true },
  { "ag6211.com", true },
  { "ag6215.com", true },
  { "ag6225.com", true },
  { "ag6262g.com", true },
  { "ag6306.com", true },
  { "ag660.com", true },
  { "ag66321.com", true },
  { "ag686.com", true },
  { "ag68ks.com", true },
  { "ag698.com", true },
  { "ag700.com", true },
  { "ag8-game.com", true },
  { "ag8.email", true },
  { "ag800.com", true },
  { "ag80808.com", true },
  { "ag80880.com", true },
  { "ag8181g.com", true },
  { "ag81826.com", true },
  { "ag81867.com", true },
  { "ag855.net", true },
  { "ag87777.com", true },
  { "ag878.com", true },
  { "ag88-guide.com", true },
  { "ag880.com", true },
  { "ag88001.com", true },
  { "ag88008.com", true },
  { "ag88018.com", true },
  { "ag88028.com", true },
  { "ag88056.com", true },
  { "ag88058.com", true },
  { "ag88068.com", true },
  { "ag8808.com", true },
  { "ag88080.com", true },
  { "ag88081.com", true },
  { "ag88086.com", true },
  { "ag88089.com", true },
  { "ag88090.com", true },
  { "ag88094.com", true },
  { "ag88098.com", true },
  { "ag88110.com", true },
  { "ag88158.com", true },
  { "ag8819-livechat.com", true },
  { "ag88220.com", true },
  { "ag8829.com", true },
  { "ag88309.com", true },
  { "ag8850.com", true },
  { "ag88518.com", true },
  { "ag88550.com", true },
  { "ag8856.com", true },
  { "ag8859.com", true },
  { "ag88618.com", true },
  { "ag887.com", true },
  { "ag8876.com", true },
  { "ag88777.com", true },
  { "ag88777.net", true },
  { "ag8879.com", true },
  { "ag88798.com", true },
  { "ag88799.com", true },
  { "ag888.ag", true },
  { "ag88801.com", true },
  { "ag88818.com", true },
  { "ag888818.com", true },
  { "ag889.com", true },
  { "ag8890.com", true },
  { "ag88905.com", true },
  { "ag88906.com", true },
  { "ag88910.com", true },
  { "ag88988.com", true },
  { "ag88dc22.com", true },
  { "ag88ks.com", true },
  { "ag89000.com", true },
  { "ag89ks.com", true },
  { "ag918.ag", true },
  { "ag978.com", true },
  { "ag98ks.com", true },
  { "ag998.com", true },
  { "ag9ks.com", true },
  { "agaa35.com", true },
  { "agaa41.com", true },
  { "agalliasis.ch", false },
  { "agamsecurity.ch", false },
  { "agatajanik.de", true },
  { "agate.pw", true },
  { "agaveandpine.com", true },
  { "agechecker.net", true },
  { "agefriendlyri.org", true },
  { "ageg.ca", true },
  { "agemfis.com", true },
  { "agence-wazacom.fr", true },
  { "agences-cegee.fr", true },
  { "agencia.barcelona", true },
  { "agencia.cat", true },
  { "agencia.pro", true },
  { "agenciabonobo.com", true },
  { "agenciacorujadesign.com.br", true },
  { "agenciadeempregosdourados.com.br", true },
  { "agenciamseo.com.br", true },
  { "agencyalacarte.com", true },
  { "agencyinmotion.com", true },
  { "agencytsunami.com", true },
  { "agenda-loto.net", false },
  { "agenda21senden.de", true },
  { "agendaspectacles.fr", true },
  { "agendatelefonica.com.br", false },
  { "agent-grow.com", true },
  { "agentprocessing.com", true },
  { "agentrisk.com", true },
  { "agentur-pottkinder.de", true },
  { "agenux.org", true },
  { "agenziaimmobiliarezeta.it", true },
  { "agfmedia.com", true },
  { "agh6p.com", true },
  { "aghayeva-edler.de", true },
  { "agiapelagia.com", true },
  { "agibank.com.br", true },
  { "agic-geneve.ch", true },
  { "agilebits.com", true },
  { "agilecraft.com", true },
  { "agilesurvey.ch", true },
  { "agileui.com", true },
  { "agiley.se", true },
  { "agilicus.ca", true },
  { "agilicus.com", true },
  { "agilizing.us", true },
  { "agilob.net", true },
  { "aging.gov", true },
  { "agingstats.gov", true },
  { "aginion.net", true },
  { "agks0.com", true },
  { "agks006.com", true },
  { "agks008.com", true },
  { "agks02.com", true },
  { "agks06.com", true },
  { "agks08.com", true },
  { "agks1.com", true },
  { "agks11.com", true },
  { "agks111.com", true },
  { "agks113.com", true },
  { "agks12.com", true },
  { "agks13.com", true },
  { "agks133.com", true },
  { "agks136.com", true },
  { "agks138.com", true },
  { "agks150.com", true },
  { "agks168.com", true },
  { "agks18.com", true },
  { "agks188.com", true },
  { "agks19.com", true },
  { "agks2.com", true },
  { "agks3.com", true },
  { "agks4.com", true },
  { "agks666.com", true },
  { "agks68.com", true },
  { "agks8.com", true },
  { "agks88.com", true },
  { "agks89.com", true },
  { "agks9.com", true },
  { "agks96.com", true },
  { "agks98.com", true },
  { "agks988.com", true },
  { "agks99.com", true },
  { "agks998.com", true },
  { "agktest1.ga", true },
  { "aglc6.com", true },
  { "aglc8.com", true },
  { "aglc88.com", true },
  { "aglh.com", true },
  { "agliamici.it", true },
  { "aglucky.com", true },
  { "agm2525.com", true },
  { "agm4545.com", true },
  { "agm8383.com", true },
  { "agnesk.blog", true },
  { "agonswim.com", true },
  { "agoodmind.com", true },
  { "agoravox.fr", true },
  { "agoravox.it", true },
  { "agoravox.tv", true },
  { "agouraelectrical.com", true },
  { "agouraelectrician.com", true },
  { "agouraexteriorlighting.com", true },
  { "agourahillselectric.com", true },
  { "agourahillselectrical.com", true },
  { "agourahillselectrician.com", true },
  { "agourahillsexteriorlighting.com", true },
  { "agourahillslandscapelighting.com", true },
  { "agourahillslighting.com", true },
  { "agourahillsoutdoorlighting.com", true },
  { "agouralandscapelighting.com", true },
  { "agouralighting.com", true },
  { "agouraoutdoorlighting.com", true },
  { "agowa338.de", true },
  { "agpideas.com", true },
  { "agpsn.com", true },
  { "agr.asia", true },
  { "agrarking.com", true },
  { "agrarking.de", true },
  { "agrarshop4u.de", true },
  { "agrekov.ru", true },
  { "agrichamber.com.ua", true },
  { "agricolo.ch", true },
  { "agriculture-schools.com", true },
  { "agridir.site", true },
  { "agrios.de", true },
  { "agriquads.nl", true },
  { "agroconsultoraplus.com", true },
  { "agrodronechile.cl", true },
  { "agroline.by", true },
  { "agromotorsburzaco.com", true },
  { "agroplas.cf", true },
  { "agroxxi.ru", false },
  { "agroyard.com.ua", true },
  { "agsb.ch", false },
  { "agscinemas.com", true },
  { "agscinemasapp.com", true },
  { "agslot.com", true },
  { "agslot.net", true },
  { "agslot777.com", true },
  { "aguarani.com.br", true },
  { "aguijara.com", true },
  { "agung-furniture.com", true },
  { "agvip168.com", true },
  { "agvip88.com", true },
  { "agvip8800.com", true },
  { "agwa.name", true },
  { "agwin1.com", true },
  { "agwin2.com", true },
  { "agwin7.com", true },
  { "agwin777.com", true },
  { "agwin8.com", true },
  { "agwin9.com", true },
  { "agworkers.com", true },
  { "agy.cl", true },
  { "agyacht.club", true },
  { "ahawkesrealtors.com", true },
  { "ahd.com", false },
  { "ahegao.ca", true },
  { "ahj.no", true },
  { "ahkubiak.ovh", false },
  { "ahlaejaba.com", true },
  { "ahlz.sk", true },
  { "ahmad.works", true },
  { "ahmedabadflowermall.com", true },
  { "ahmedcharles.com", true },
  { "ahmerjamilkhan.org", true },
  { "ahmetozer.org", true },
  { "ahollamby.com", true },
  { "ahosi.com", true },
  { "ahoy.travel", true },
  { "ahoyconference.com", true },
  { "ahsyg.com", true },
  { "ahtuxpk.ru", true },
  { "ahu.la", true },
  { "ahughes03.com", true },
  { "ahxxm.com", false },
  { "ai-cuisine.fr", true },
  { "ai-english.jp", true },
  { "ai-media.tv", true },
  { "ai-soft.co.jp", true },
  { "ai.gov", true },
  { "aianipid.ee", true },
  { "aiasesoriainmobiliaria.com", true },
  { "aiat.net", true },
  { "aibenzi.com", true },
  { "aid-web.ch", true },
  { "aidanapple.com", true },
  { "aidanmitchell.co.uk", true },
  { "aidanmitchell.uk", true },
  { "aidanmontare.net", true },
  { "aidanpr.com", true },
  { "aidanpr.net", true },
  { "aidarikako.com", true },
  { "aiden.link", false },
  { "aidi-ahmi.com", true },
  { "aidmycomputer.com", true },
  { "aids.gov", true },
  { "aie.de", true },
  { "aievaluare.ro", true },
  { "aifriccampbell.com", true },
  { "aigcev.org", true },
  { "aigenpul.se", true },
  { "aigner-club.com", true },
  { "aigner-club.de", true },
  { "aignerimage.de", true },
  { "aignermunich.com", true },
  { "aignermunich.de", true },
  { "aignermunich.jp", true },
  { "aiho.stream", true },
  { "aiinsurance.io", true },
  { "aiinsurance.xyz", true },
  { "aijsk.com", true },
  { "aikenpromotions.com", true },
  { "aiki.de", true },
  { "aiki.do", true },
  { "aikido-club-limburg.de", true },
  { "aikido-kiel.de", true },
  { "aikido-linz.at", true },
  { "aikido-wels.at", true },
  { "ailitonia.com", true },
  { "ailitonia.xyz", true },
  { "aimare-web.tk", true },
  { "aimax.com", true },
  { "aimeeandalec.com", true },
  { "aimgroup.co.tz", true },
  { "aimi-salon.com", true },
  { "aimiastestseries.com", true },
  { "aimotive.com", true },
  { "aimstoreglobal.com", true },
  { "ainfographie.com", true },
  { "aintevenmad.ch", true },
  { "ainvest.de", true },
  { "ainzu.net", true },
  { "aiois.com", true },
  { "aipbarcelona.com", true },
  { "air-craftglass.com", true },
  { "air-shots.ch", false },
  { "air-techniques.fr", true },
  { "air-we-go.co.uk", true },
  { "airanyumi.net", true },
  { "airbnb.ae", true },
  { "airbnb.at", true },
  { "airbnb.be", true },
  { "airbnb.biz", true },
  { "airbnb.ca", true },
  { "airbnb.cat", true },
  { "airbnb.ch", true },
  { "airbnb.cl", true },
  { "airbnb.cn", true },
  { "airbnb.co.cr", true },
  { "airbnb.co.id", true },
  { "airbnb.co.il", true },
  { "airbnb.co.in", true },
  { "airbnb.co.kr", true },
  { "airbnb.co.nz", true },
  { "airbnb.co.uk", true },
  { "airbnb.co.ve", true },
  { "airbnb.com", true },
  { "airbnb.com.ar", true },
  { "airbnb.com.au", true },
  { "airbnb.com.bo", true },
  { "airbnb.com.br", true },
  { "airbnb.com.bz", true },
  { "airbnb.com.cn", true },
  { "airbnb.com.co", true },
  { "airbnb.com.ec", true },
  { "airbnb.com.gt", true },
  { "airbnb.com.hk", true },
  { "airbnb.com.hn", true },
  { "airbnb.com.hr", true },
  { "airbnb.com.kh", true },
  { "airbnb.com.mt", true },
  { "airbnb.com.my", true },
  { "airbnb.com.ni", true },
  { "airbnb.com.pa", true },
  { "airbnb.com.pe", true },
  { "airbnb.com.ph", true },
  { "airbnb.com.py", true },
  { "airbnb.com.sg", true },
  { "airbnb.com.sv", true },
  { "airbnb.com.tr", true },
  { "airbnb.com.tw", true },
  { "airbnb.com.ua", true },
  { "airbnb.com.vn", true },
  { "airbnb.cz", true },
  { "airbnb.de", true },
  { "airbnb.dk", true },
  { "airbnb.es", true },
  { "airbnb.fi", true },
  { "airbnb.fr", true },
  { "airbnb.gr", true },
  { "airbnb.gy", true },
  { "airbnb.hu", true },
  { "airbnb.ie", true },
  { "airbnb.is", true },
  { "airbnb.it", true },
  { "airbnb.jp", true },
  { "airbnb.la", true },
  { "airbnb.lu", true },
  { "airbnb.mx", true },
  { "airbnb.nl", true },
  { "airbnb.no", true },
  { "airbnb.pl", true },
  { "airbnb.pt", true },
  { "airbnb.ru", true },
  { "airbnb.se", true },
  { "airbnb.tools", true },
  { "airbnbchina.cn", true },
  { "airbnbopen.com", true },
  { "airborne-inflatables.co.uk", true },
  { "airbossofamerica.com", true },
  { "aircomms.com", true },
  { "airconditioning-sandton.co.za", true },
  { "airconrandburg.co.za", true },
  { "airconsalberton.co.za", true },
  { "airconsfourways.co.za", true },
  { "airconsmidrand.co.za", true },
  { "airductclean.com", false },
  { "airductcleaninggrandprairie.com", true },
  { "airductcleaningirving.com", true },
  { "airdur.eu", true },
  { "aireaseleaks.org", true },
  { "airetvie.com", true },
  { "airfax.io", true },
  { "airhart.me", true },
  { "airhelp.com", true },
  { "airhorn.de", true },
  { "airicy.com", true },
  { "airikai.com", true },
  { "airlibre-parachutisme.com", true },
  { "airmail.cc", false },
  { "airmash.online", true },
  { "airmaxinflatables.com", true },
  { "airnow.gov", true },
  { "airpbx.com", true },
  { "airplay-inflatable-hire.co.uk", true },
  { "airplayradio.nl", true },
  { "airport-charlotte.com", true },
  { "airportal.cn", true },
  { "airrestoration.ch", true },
  { "airship.com", true },
  { "airslate.com", true },
  { "airsnore.com", true },
  { "airsoft.ch", true },
  { "airswap.io", true },
  { "airtable.com", true },
  { "airtec-france.fr", true },
  { "airtimerewards.co.uk", false },
  { "airtoolaccessoryo.com", true },
  { "airvpn.org", true },
  { "airvuz.com", true },
  { "airwaystorage.net", true },
  { "airweb.top", true },
  { "airwolf.tk", true },
  { "airwolfthemes.com", true },
  { "airwrenchei.com", true },
  { "airy.host", true },
  { "ais.fashion", true },
  { "aisance-co.com", true },
  { "aisi316l.net", true },
  { "aistockcharts.com", true },
  { "aistrope.com", true },
  { "ait.com.ar", true },
  { "aiticon.com", true },
  { "aitosoftware.com", true },
  { "aitrust.ro", true },
  { "aiutodomestico.ch", false },
  { "aiva.ai", true },
  { "aivan.ai", true },
  { "aivd.lol", true },
  { "aiwosq.cn", true },
  { "aizxxs.com", true },
  { "aizxxs.net", true },
  { "aj-foster.com", true },
  { "ajarope.com", true },
  { "ajaxed.net", true },
  { "ajaxtime.tk", true },
  { "ajbenet.com", true },
  { "ajbouncycastles.co.uk", true },
  { "ajdiaz.me", true },
  { "ajeventhire.co.uk", true },
  { "ajfite.com", true },
  { "ajgroup-me.com", false },
  { "ajhstamps.co.uk", true },
  { "ajiaojr.info", true },
  { "ajiaojr.io", true },
  { "ajiaojr.me", true },
  { "ajiaojr.net", true },
  { "ajiboye.com", true },
  { "ajl.io", true },
  { "ajnah.net", true },
  { "ajnasz.hu", true },
  { "ajs5.com", true },
  { "ajsb85.com", true },
  { "ajwebsolutions.com", true },
  { "ak-varazdin.hr", true },
  { "ak-webit.de", true },
  { "ak47-miyamoto.spdns.org", true },
  { "aka.ms", true },
  { "akachanikuji.com", true },
  { "akademeia.moe", true },
  { "akademie-frankfurt.de", true },
  { "akalashnikov.ru", true },
  { "akamon.ac.jp", true },
  { "akaoma.com", true },
  { "akasha.world", true },
  { "akashdsouza.now.sh", true },
  { "akdusekbudil.cz", true },
  { "akeenext.com", true },
  { "akeenshort.com", true },
  { "akerboom.family", true },
  { "akerboom.org", true },
  { "akfoundationindia.com", true },
  { "akhabar.tk", true },
  { "akhealthconnection.com", false },
  { "akhomesforyou.com", true },
  { "akihito.com", true },
  { "akijo.de", true },
  { "akinix.com", true },
  { "akiym.com", true },
  { "akj.io", true },
  { "akkade.be", true },
  { "akkbouncycastles.co.uk", true },
  { "akkeylab.com", true },
  { "akoofs.com", true },
  { "akostecki.de", true },
  { "akoww.de", false },
  { "akoya.fi", true },
  { "akplates.org", true },
  { "akr.io", true },
  { "akr.services", true },
  { "akrep.com", true },
  { "akropolis-ravensburg.de", true },
  { "aksehir.bel.tr", true },
  { "akselinurmio.fi", true },
  { "akshi.in", true },
  { "aktca.org", true },
  { "aktin.cz", true },
  { "aktin.sk", true },
  { "aktion-vielfalt.ch", true },
  { "aktiv-naturheilmittel.at", false },
  { "aktiv-naturheilmittel.ch", true },
  { "aktiv-naturheilmittel.de", true },
  { "aktivace.eu", true },
  { "aktive-arbeitslose.at", true },
  { "aktivierungscenter.de", true },
  { "akuislam.com", true },
  { "akukas.com", true },
  { "akutun.cl", true },
  { "akvorrat.at", true },
  { "al-f.net", true },
  { "al3366.tech", true },
  { "al3abmizo.com", true },
  { "al3xpro.com", true },
  { "alab.space", true },
  { "alabamaag.gov", true },
  { "alabamacoastalradiology.com", true },
  { "alabamadebtrelief.org", true },
  { "alaboard.com", true },
  { "alabordage.fr", true },
  { "alacriti.com", true },
  { "aladdin.ie", true },
  { "aladdinschools.appspot.com", true },
  { "aladintechnologies.tk", true },
  { "alainbaechlerphotography.ch", false },
  { "alainfrancois.eu", true },
  { "alainfrancois.nl", true },
  { "alainmargot.ch", false },
  { "alainodea.com", true },
  { "alainwolf.ch", true },
  { "alainwolf.net", true },
  { "alair.cn", false },
  { "alalivre.cf", true },
  { "alamo-analytics.com", true },
  { "alamowellnessalliance.com", true },
  { "alanberger.me.uk", true },
  { "aland.co.uk", true },
  { "alandoyle.com", true },
  { "alanhua.ng", true },
  { "alaninkenya.org", true },
  { "alantica.ga", true },
  { "alargarlavida.com", true },
  { "alarmat.pl", true },
  { "alarmcomplete.co.uk", true },
  { "alarna.de", true },
  { "alasdelalma.com.co", true },
  { "alaskabuylocal.org", true },
  { "alaskafishinglodges.net", true },
  { "alaskajewelry.com", true },
  { "alastairs-place.net", true },
  { "alatkesehatan.tk", true },
  { "alaxyjewellers.co.za", true },
  { "alb-flirt.de", true },
  { "albalatedelarzobispo.tk", true },
  { "albanesi.it", true },
  { "albareport.com", true },
  { "albatrosswear.com", true },
  { "albbounce.co.uk", true },
  { "alberoraydolap.com", true },
  { "albersdruck.de", true },
  { "albert-yu.com", true },
  { "albertathome.org", true },
  { "albertcuyp-markt.amsterdam", true },
  { "albertforfuture.de", true },
  { "albertinum-goettingen.de", true },
  { "alberts-blatt.de", true },
  { "albilaga.id", true },
  { "albion2.org", true },
  { "alboweb.nl", true },
  { "albstaedter-kids-cup.de", true },
  { "alca31.com", false },
  { "alcamilo.cloudns.cc", true },
  { "alcatelonetouch.us", true },
  { "alchemy-media-marketing.com", true },
  { "alchemy.gr", true },
  { "alchimic.ch", false },
  { "alco-united.com", true },
  { "alcobendas.tk", true },
  { "alcoholapi.com", true },
  { "alcolecapital.com", true },
  { "alcouponest.com", true },
  { "alcubillas.tk", true },
  { "aldiabcs.com", true },
  { "aldien.com.br", true },
  { "aldomedia.com", true },
  { "aldorr.net", false },
  { "aldous-huxley.com", true },
  { "alecpap.com", true },
  { "alecpapierniak.com", true },
  { "alecrust.com", true },
  { "aleftinka.tk", true },
  { "alejarod.com", true },
  { "alek.in", true },
  { "aleksib.fi", true },
  { "alela.fr", true },
  { "alentadoras.com", true },
  { "aleph.land", true },
  { "alerbon.net", true },
  { "alertboxx.com", true },
  { "alertonline.nl", true },
  { "alerts.sg", true },
  { "alertwire.com", true },
  { "alesia-formation.fr", true },
  { "alessandrobasi.it", true },
  { "alessandroonline.com.br", true },
  { "alessandrotravel.com", true },
  { "alessandroz.ddns.net", true },
  { "aletm.it", true },
  { "alevi.tk", true },
  { "alex-ross.co.uk", true },
  { "alex4386.us", true },
  { "alex97000.de", true },
  { "alexander-beck.eu", true },
  { "alexanderb.info", true },
  { "alexandercanton.com", true },
  { "alexanderneng.de", true },
  { "alexanderschimpf.de", true },
  { "alexandra-schulze.de", true },
  { "alexandrastorm.com", true },
  { "alexandre-blond.fr", true },
  { "alexandreguarita.com.br", true },
  { "alexbaker.org", true },
  { "alexberts.ch", true },
  { "alexbogovich.com", true },
  { "alexcoman.com", true },
  { "alexdaniel.org", true },
  { "alexey-shamara.ru", true },
  { "alexeykopytko.com", true },
  { "alexfabian.myftp.org", true },
  { "alexgaynor.net", true },
  { "alexgebhard.com", true },
  { "alexglover.co.uk", true },
  { "alexhalderman.com", true },
  { "alexhd.de", true },
  { "alexisabarca.com", true },
  { "alexiskoustoulidis.com", true },
  { "alexjett.com", true },
  { "alexlambertz.de", true },
  { "alexlouden.com", true },
  { "alexmerkel.com", true },
  { "alexmerkel.me", true },
  { "alexmerkel.xyz", true },
  { "alexn.org", true },
  { "alexpavel.com", true },
  { "alexpnixon.com", true },
  { "alexpotter.net", true },
  { "alexs.de", true },
  { "alexsandrasverden.cf", true },
  { "alexschroeder.ch", true },
  { "alexsergeyev.com", true },
  { "alexsexton.com", true },
  { "alextaffe.com", true },
  { "alextjam.es", true },
  { "alextsang.net", true },
  { "alexvetter.de", true },
  { "alexwardweb.com", true },
  { "alexyang.me", true },
  { "alfa-host.ml", true },
  { "alfa-tech.su", true },
  { "alfacharlie.co", true },
  { "alfaperfumes.com.br", true },
  { "alfaproweb.fr", true },
  { "alfavit.cf", true },
  { "alforto.nl", true },
  { "alfratehotelcampiglio.it", true },
  { "alfred-figge.de", true },
  { "alfredapp.com", true },
  { "alftrain.com", true },
  { "algeriepart.com", true },
  { "alghanimcatering.com", true },
  { "algoentremanos.com", true },
  { "algolia.com", true },
  { "alhost.ml", true },
  { "aliacraft.net", true },
  { "aliantsoft.pl", true },
  { "aliaswp.com", true },
  { "alibangash.com", true },
  { "alice-memorial.de", true },
  { "alice-noutore.com", true },
  { "alice-of-alice.top", true },
  { "alice.tw", true },
  { "alicemaywebdesign.com.au", true },
  { "alicestudio.it", true },
  { "alicetone.net", true },
  { "aliefirfany.com", true },
  { "alieke.design", true },
  { "alien6.com", true },
  { "alienation.biz", true },
  { "alienslab.net", true },
  { "alienstat.com", true },
  { "alighierirescaldina.it", true },
  { "alignrs.com", true },
  { "alijammusic.com", false },
  { "alikulov.me", true },
  { "alinasmusicstudio.com", true },
  { "alinbu.net", true },
  { "alineonline.tk", true },
  { "aliorange.com", true },
  { "alisondavenport.ga", true },
  { "alisonisrealestate.com", true },
  { "alisonlitchfield.com", true },
  { "alistairstowing.com", true },
  { "alitec.it", true },
  { "aliv.biz", true },
  { "alix-board.de", true },
  { "alize-theatre.ch", false },
  { "aliziolaw.com", true },
  { "aljaspod.ch", true },
  { "aljaspod.com", true },
  { "aljaspod.hu", true },
  { "aljaspod.net", true },
  { "aljaspod.org", true },
  { "aljoschairmer.de", true },
  { "aljweb.com", true },
  { "alkacoin.net", true },
  { "alkemi-si.fr", true },
  { "alko-centr.ru", true },
  { "alko-stop.ml", true },
  { "alkopedia.tk", true },
  { "alkor.tk", true },
  { "alkusin.net", true },
  { "all-connect.net", false },
  { "all-fashion-schools.com", true },
  { "all-markup-news.com", true },
  { "all-things.tk", true },
  { "all4hardware4u.de", true },
  { "all878.com", true },
  { "allaboutfunuk.com", true },
  { "allaboutgreg.net", true },
  { "allaboutreligions.tk", true },
  { "allaboutswing.co.uk", true },
  { "allaboutswing.com", true },
  { "allactioneventhire.co.uk", true },
  { "allamericanmuslim.com", true },
  { "allamericanprotection.net", true },
  { "allamericatrans.com", true },
  { "allangirvan.net", true },
  { "allanta.be", true },
  { "allarmi.roma.it", true },
  { "allbenjoy.de", true },
  { "allbestcbdoil.com", true },
  { "allbetgame.cn", true },
  { "allbetgaming.com", true },
  { "allbigdicks.com", true },
  { "allbounceandplay.co.uk", true },
  { "allbouncesurrey.co.uk", true },
  { "allbrandbrand.com", true },
  { "allbursaries.co.za", true },
  { "allbusiness.com", true },
  { "allcapa.org", true },
  { "allcarecorrectionalpharmacy.com", true },
  { "allcarepharmacy.com", true },
  { "allcarespecialty.pharmacy", true },
  { "allcinema.net", true },
  { "allcleaningservice.org", true },
  { "allcleanservices.ca", true },
  { "allcloud.com", true },
  { "allcountyins.com", true },
  { "allcovered.nl", true },
  { "allcoveredbyac.com", true },
  { "alldewall.de", true },
  { "alle-zonvakanties.nl", true },
  { "alle.bg", true },
  { "allemoz.com", true },
  { "allemoz.fr", true },
  { "allenscaravans.co.uk", true },
  { "allensun.org", true },
  { "allenwillis.ga", true },
  { "allerstorfer.at", true },
  { "alles-nur-ge.cloud", true },
  { "alleskomtgoed.org", true },
  { "allesrocknroll.de", true },
  { "allfaucet.ml", true },
  { "allfoodrecipes.ga", true },
  { "allforyou.at", true },
  { "allfundsconnect.com", true },
  { "allgaragefloors.com", true },
  { "allgosts.ru", true },
  { "allgovernmentjobs.in", true },
  { "allgreenturf.com.au", true },
  { "allhard.org", true },
  { "alliance-psychiatry.com", true },
  { "alliances-globalsolutions.com", false },
  { "alliedfrozenstorage.com", true },
  { "alliedpavers.com", true },
  { "allinagency.com", true },
  { "allincoin.shop", true },
  { "allindiacityguide.com", true },
  { "allinone-ranking150.com", true },
  { "allinsuranceinformation.com", true },
  { "allis.studio", true },
  { "allitcrm.sytes.net", true },
  { "alljamin.com", true },
  { "allladyboys.com", true },
  { "allmajestic.com", true },
  { "allmemy.com", false },
  { "allmousepads.com", true },
  { "allnoticebd.com", true },
  { "allnovosibirsk.tk", true },
  { "allns.fr", true },
  { "allo-credit.ch", false },
  { "allo-luxembourg.tk", true },
  { "allofthestops.com", true },
  { "allontanamentovolatili.it", true },
  { "allontanamentovolatili.milano.it", true },
  { "allopurinol300mg.ml", true },
  { "alloutsec.com", true },
  { "alloverthehill.com", true },
  { "allphaseclean.com", true },
  { "allplayer.tk", true },
  { "allpointsblog.com", true },
  { "allpointsheating.com", true },
  { "allproptonline.com", true },
  { "allpussynow.com", true },
  { "allrad-buck.de", true },
  { "allright.tk", true },
  { "allroundpvp.net", true },
  { "allroundtechnology.com", true },
  { "allroundtechnology.nl", true },
  { "allsaints.church", true },
  { "allsearch.io", true },
  { "allseasonswaterproofing.com", true },
  { "allsoulinc.com", true },
  { "allsoulmobile.com", true },
  { "allsoultech.com", true },
  { "allspinecare.com", true },
  { "allstakesupply.com.au", true },
  { "allstarautokiaparts.com", true },
  { "allstarcashforcars.com", true },
  { "allstarquilts.com", true },
  { "allsun.online", true },
  { "allsurpl.us", true },
  { "allsync.com", true },
  { "allsync.nl", true },
  { "allteach.co.uk", true },
  { "allterrainfence.com", true },
  { "allthecryptonews.com", true },
  { "alltherooms.com", true },
  { "alltherooms.es", true },
  { "allthethings.co.nz", true },
  { "allthings.me", true },
  { "allthingssquared.com", true },
  { "allthingswild.co.uk", true },
  { "alltubedownload.net", true },
  { "allurebikerental.com", true },
  { "allurescarves.com", true },
  { "alluvion.studio", true },
  { "allweatherlandscaping.net", true },
  { "almaatlantica.com", true },
  { "almamet.com", true },
  { "almanssur.com", true },
  { "almatinki.com", true },
  { "almavios.com", false },
  { "almayadeen.education", true },
  { "almeeraloyalty.com", true },
  { "almenrausch-pirkhof.de", true },
  { "almisnedrm.com", true },
  { "almorafestival.com", true },
  { "almostobjective.com", true },
  { "almusbahperfume.com", true },
  { "almut-zielonka.de", true },
  { "alodocuratelemensagem.com.br", true },
  { "aloesoluciones.com.ar", true },
  { "alohapartyevents.co.uk", true },
  { "alonas.cf", true },
  { "alonas.ga", true },
  { "alonas.gq", true },
  { "alonas.ml", true },
  { "alonas.tk", true },
  { "alonetone.com", true },
  { "alov.blog", true },
  { "alp.od.ua", true },
  { "alpca.org", true },
  { "alpencam.com", true },
  { "alpencams.com", true },
  { "alpencams.net", true },
  { "alpengreis.ch", true },
  { "alpertron.com.ar", true },
  { "alpes-deis-tools.com", true },
  { "alpha-ag.ru", true },
  { "alpha-assistant.com", true },
  { "alpha-bet.com.ua", true },
  { "alpha-force.net", false },
  { "alpha-premium.com", true },
  { "alpha.ch", true },
  { "alpha88uat.com", true },
  { "alphaantileak.net", true },
  { "alphabetsigns.com", true },
  { "alphabouncycastles.co.uk", true },
  { "alphachat.net", true },
  { "alphadefense.co.za", true },
  { "alphaetomega3d.fr", true },
  { "alphafiduciaryservices.ch", false },
  { "alphainflatablehire.com", true },
  { "alphanodes.com", true },
  { "alphapengu.in", true },
  { "alphaperfumes.com.br", true },
  { "alphapoker.ru", true },
  { "alpharail.se", true },
  { "alpharoofga.com", true },
  { "alpharotary.com", true },
  { "alphasall.com", true },
  { "alphasib.ru", true },
  { "alphassl.de", true },
  { "alphavote-avex.com", true },
  { "alphavote.com", true },
  { "alphera.nl", true },
  { "alphie.me", true },
  { "alphipneux.fr", true },
  { "alpine-holiday.de", true },
  { "alpinechaletrental.com", true },
  { "alpinehighlandrealty.com", true },
  { "alpineplumbingandrooter.com", true },
  { "alpinepubliclibrary.org", true },
  { "alpinestarmassage.com", true },
  { "alplogopedia.it", true },
  { "alpstarentaisetaxi.com", true },
  { "alpstarentaisetaxi.fr", true },
  { "alquds.edu", true },
  { "alquiaga.com", true },
  { "alre-outillage.fr", true },
  { "als-japan.com", true },
  { "alsops.cf", true },
  { "alstertouch.com", true },
  { "alstertouch.de", true },
  { "alt-three.com", true },
  { "alt.org", true },
  { "altair.fi", true },
  { "altairlyh.com", true },
  { "altapina.com", false },
  { "altaplana.be", true },
  { "altaynews.kz", true },
  { "altco.group", true },
  { "altedirect.com", true },
  { "alteiria.fr", true },
  { "alter-news.fr", true },
  { "alteraro.com", true },
  { "alteraro.org", true },
  { "alterbaum.net", true },
  { "alteria.xyz", true },
  { "alternador.com.br", true },
  { "alternative.bike", true },
  { "alternative.hosting", true },
  { "alternativebit.fr", true },
  { "alternativehosting.ca", true },
  { "alternativehosting.com", true },
  { "alternativeinternet.ca", true },
  { "alternativet.party", true },
  { "alternativetomeds.com", true },
  { "alternatiwa.tk", true },
  { "alterspalter.de", true },
  { "altertek.org", true },
  { "altes-sportamt.de", true },
  { "altesses.eu", true },
  { "altestore.com", true },
  { "altijdleroy.nl", true },
  { "altijdleroy.online", true },
  { "altisdev.com", true },
  { "altkremsmuensterer.at", true },
  { "altmaestrat.es", true },
  { "altmann-systems.de", true },
  { "altoa.cz", true },
  { "altonblom.com", true },
  { "altonkey.com", true },
  { "altopartners.com", true },
  { "altopia.com", true },
  { "altorise.com", true },
  { "altphotos.com", true },
  { "altrui.st", true },
  { "altsdigital.com", true },
  { "altstipendiaten.de", true },
  { "altunbas.info", true },
  { "altweaver.com", true },
  { "aluminium-express.ru", true },
  { "aluminium-giesserei.de", true },
  { "alumni-kusa.jp", true },
  { "alupferd.de", true },
  { "aluroof.eu", true },
  { "alushta-vostorg.tk", true },
  { "alvcs.com", true },
  { "alvicom.hu", true },
  { "alvosec.com", true },
  { "alwayshowher.tk", true },
  { "alwayslookingyourbest.com", true },
  { "alwaysmine.fi", true },
  { "alwayswanderlust.com", true },
  { "alxlegal.com", true },
  { "alxu.ca", true },
  { "alxyjc.net", true },
  { "alyanak.ca", true },
  { "alyoung.com", true },
  { "alza.at", true },
  { "alza.co.uk", true },
  { "alza.cz", true },
  { "alza.de", true },
  { "alza.hu", true },
  { "alza.sk", true },
  { "alzashop.com", true },
  { "am-dd.com", true },
  { "am-executive-consulting.com", true },
  { "am156.com", true },
  { "am22i6xaf1m2a5m9k.xyz", true },
  { "am2s.fr", true },
  { "am5188.com", true },
  { "am6118.com", true },
  { "am615.am", true },
  { "am8.com", true },
  { "am8136.com", true },
  { "am88.ag", true },
  { "am9d104.com", true },
  { "ama.ne.jp", true },
  { "amaderelectronics.com", true },
  { "amadoraslindas.com", true },
  { "amagdic.com", true },
  { "amagical.net", false },
  { "amaiz.com", true },
  { "amal2019.com", true },
  { "amalfilapiazzetta.it", true },
  { "amalfipositanoboatrental.com", true },
  { "amalfirock.it", true },
  { "amalfitabula.it", true },
  { "amanatrustbooks.org.uk", true },
  { "amandadamsphotography.com", true },
  { "amandahamilton.tk", true },
  { "amandasage.ca", true },
  { "amandaworldstudies.com", true },
  { "amani-kinderdorf.de", true },
  { "amaranthinewanderlust.com", true },
  { "amardham.org", true },
  { "amaresq.com", true },
  { "amartinz.at", true },
  { "amateri.com", true },
  { "amateurpornhours.com", true },
  { "amateurradionotes.com", true },
  { "amateurvoicetalent.com", true },
  { "amati.solutions", true },
  { "amato.tk", true },
  { "amatsuka.com", true },
  { "amauf.de", true },
  { "amautorepairwa.com", true },
  { "amazetimberfurniture.com.au", true },
  { "amazili-communication.com", true },
  { "amazing-castles.co.uk", true },
  { "amazingraymond.com", true },
  { "amazingraymond.com.au", true },
  { "amb.tf", true },
  { "ambacoin.io", true },
  { "ambassify.com", true },
  { "ambassify.eu", true },
  { "amberalert.gov", true },
  { "amberglowleisure.co.uk", true },
  { "amberlightleisure.com", true },
  { "amberoad.tk", true },
  { "ambholding-usedcars.be", false },
  { "ambiente.one", true },
  { "ambiq.nl", true },
  { "ambulanza.roma.it", true },
  { "ambulari.cz", true },
  { "amcangroup.com", true },
  { "amcfirst.com", true },
  { "amchainitiative.org", true },
  { "amcs.website", true },
  { "amdm.ru", true },
  { "amdouglas.com", true },
  { "amechancez.work", true },
  { "ameego.com", true },
  { "ameego.it", true },
  { "ameego.net", true },
  { "ameego.nl", true },
  { "ameego.org", true },
  { "amees.me", false },
  { "ameliemarieintokyo.com", true },
  { "amello.de", true },
  { "amendine.fr", true },
  { "america.gov", true },
  { "americafamilylawcenter.org", true },
  { "american-school-search.com", true },
  { "american.dating", true },
  { "americandetour.com", true },
  { "americanfoundationbr.com", true },
  { "americanindiannursing.com", true },
  { "americanmediainstitute.com", true },
  { "americans.cam", true },
  { "americansforcommunitydevelopment.org", true },
  { "americanunicornparty.tk", true },
  { "americanwater.lk", true },
  { "americasbasementcontractor.com", true },
  { "americasdirector.com", true },
  { "americkykongres.cz", true },
  { "americorps.gov", true },
  { "ameriikanpoijat.org", true },
  { "amerika-forum.de", true },
  { "amerimex.cc", true },
  { "amerion.nl", true },
  { "amesgen.de", true },
  { "amethystbodyart.com", true },
  { "amethystdevelopment.co.uk", true },
  { "amf.to", true },
  { "amforst-ha.ddns.net", true },
  { "amforst.ddns.net", true },
  { "amg-microwave.com", true },
  { "amh-entertainments.co.uk", true },
  { "ami-de-bastanes.fr", true },
  { "amianto.roma.it", true },
  { "amica-travel.com", true },
  { "amica.it", true },
  { "amicalecanyon.ch", false },
  { "amiciperlatesta.it", true },
  { "amifoundation.net", true },
  { "amigucrochet.com", true },
  { "amikootours.com", true },
  { "amineptine.com", true },
  { "amionvpn.com", true },
  { "amir-heinisch.de", true },
  { "amirasyraf.com", true },
  { "amirautos.com", false },
  { "amirmahdy.com", true },
  { "amisderodin.fr", true },
  { "amitabhsirkiclasses.org.in", true },
  { "amitpatra.com", true },
  { "amj74-informatique.fr", true },
  { "amleather.pl", true },
  { "amm6e.com", true },
  { "ammanagingdirectors.com", true },
  { "amministratore.biz", true },
  { "amministratore.roma.it", true },
  { "amministratorecondominio.roma.it", true },
  { "amnesty-bf.org", true },
  { "amnesty.org.au", true },
  { "amnesy.fr", true },
  { "amobileway.co.uk", true },
  { "amokinio.com", true },
  { "amoozesh98.com", true },
  { "amoozesh98.ir", true },
  { "amorgos-aegialis.com", true },
  { "amorim.ca", true },
  { "amoxil.cf", true },
  { "amperaa.net", true },
  { "ampersandnbspsemicolon.com", true },
  { "ampgroep.nl", true },
  { "amphetamines.org", true },
  { "amphost.tk", true },
  { "amplead.com", true },
  { "ampleroads.com", true },
  { "ampproject.com", true },
  { "ampproject.org", true },
  { "amputated.tk", true },
  { "amrcaustin.com", true },
  { "amrcla.com", true },
  { "amrff.com", true },
  { "amruta.org", true },
  { "ams-web-qa.azurewebsites.net", true },
  { "ams.co.rs", true },
  { "amsel305nc.ddnss.de", true },
  { "amsfoodhk.com", true },
  { "amstelveentje.nl", true },
  { "amsterdamian.com", true },
  { "amt-taxfrance.com", true },
  { "amtsinfo.in", true },
  { "amuq.net", true },
  { "amuraimpianti.it", true },
  { "amusa.cl", true },
  { "amvip9.com", true },
  { "amxpj888.com", false },
  { "amyfoundhermann.com", true },
  { "amymabel.com", true },
  { "amyria.jp", true },
  { "amyyeung.com", true },
  { "amzn.rocks", true },
  { "an-alles-gedacht.de", true },
  { "an7hrax.se", true },
  { "anabolic.co", false },
  { "anabolickdieta.ga", true },
  { "anabolics.tk", true },
  { "anacreon.de", true },
  { "anadiyogacentre.com", true },
  { "anageorgia.com", true },
  { "anagramma.tk", true },
  { "anaiscoachpersonal.es", true },
  { "anaisfae.art", true },
  { "anakin.ca", true },
  { "analgesia.net", true },
  { "analisi-logica.it", true },
  { "analisilaica.it", true },
  { "analogist.net", true },
  { "analteengirls.net", true },
  { "analytics-shop.com", true },
  { "analyticsinmotion.com", true },
  { "analyticum.at", true },
  { "analyticum.com", true },
  { "analyticum.de", true },
  { "analyticum.eu", true },
  { "analyticum.net", true },
  { "anandchowdhary.com", true },
  { "ananke.io", true },
  { "anankecosmetics.com", true },
  { "anantshri.info", true },
  { "ananyoo.com", true },
  { "anarchistischegroepnijmegen.nl", false },
  { "anarcho-copy.org", true },
  { "anarhija.tk", true },
  { "anarkhe.net", true },
  { "anasahr.be", true },
  { "anastasia-shamara.ru", true },
  { "anatoray.com", true },
  { "anblik.com", true },
  { "ance.lv", false },
  { "ancestramil.fr", true },
  { "anchev.net", true },
  { "anchorit.gov", true },
  { "anchovy.nz", false },
  { "anciennes-automobiles.fr", true },
  { "anciens.org", true },
  { "ancientnorth.com", true },
  { "ancientnorth.nl", true },
  { "ancolies-andre.com", false },
  { "anconaswine.com", true },
  { "and-stuff.nl", true },
  { "and.com", true },
  { "andalusierondreizen.nl", true },
  { "andariegocusco.com", true },
  { "andarpersassi.it", true },
  { "andel.info", false },
  { "anders.hamburg", true },
  { "andersonpowerservices.com", true },
  { "andersonshatch.com", true },
  { "andesnevadotours.com", true },
  { "andicui.xyz", true },
  { "andiplusben.com", true },
  { "anditi.com", true },
  { "andre-lategan.com", true },
  { "andre-otto.com", true },
  { "andrea-kiaora.de", true },
  { "andrea-m.me", true },
  { "andrea-wirthensohn.at", false },
  { "andreaassenti.it", true },
  { "andreaboero.it", true },
  { "andreadraghetti.it", true },
  { "andreagobetti.com", true },
  { "andreagourmet.it", true },
  { "andreahruby.it", true },
  { "andreamcnett.com", true },
  { "andreas-kluge.eu", true },
  { "andreaseracleous.com", true },
  { "andreasfeusi.ch", true },
  { "andreasjanker.de", true },
  { "andreaskrasa.com", true },
  { "andreaslicht.nl", true },
  { "andreasolsson.se", true },
  { "andree.cloud", true },
  { "andrehansen.de", true },
  { "andrei-nakov.org", true },
  { "andreina-atencio.com", true },
  { "andrelauzier.com", true },
  { "andreoliveira.io", true },
  { "andrespaz.com", true },
  { "andresrios.nl", true },
  { "andreundnina.de", true },
  { "andrew.fi", true },
  { "andrew.london", true },
  { "andrewbdesign.com", false },
  { "andrewbennett.ltd", true },
  { "andrewdaws.io", true },
  { "andrewensley.com", true },
  { "andrewimeson.com", true },
  { "andrewin.ru", true },
  { "andrewisidoro.co.uk", true },
  { "andrewjphotography.com", true },
  { "andrewlarson.org", true },
  { "andrewmichaud.com", true },
  { "andrewmichaud.me", true },
  { "andrewpeng.net", true },
  { "andrewprokos.com", true },
  { "andrewpucci.com", true },
  { "andrewrgoss.com", true },
  { "andrewryno.com", true },
  { "andrewsun.com", true },
  { "andrewtasso.com", true },
  { "andrewtchin.com", true },
  { "andrewx.net", true },
  { "andrey1p.ru", true },
  { "andreyjuravlev.ga", true },
  { "andreypopp.com", true },
  { "andreysmirnov.tk", true },
  { "andrianova.ml", true },
  { "andrija-i-andjelka.com", true },
  { "andrisilberschmidt.ch", true },
  { "andro2id.com", true },
  { "andro4all.com", true },
  { "android-tv.3utilities.com", true },
  { "android.re", true },
  { "androide.com", true },
  { "androidhry.cz", true },
  { "androidkatalog.cz", true },
  { "androidnovinky.cz", true },
  { "androidservicetool.com", true },
  { "androidsis.com", true },
  { "androidtamer.com", true },
  { "androidtelefony.cz", true },
  { "androidzone.me", true },
  { "andromeda.se", true },
  { "andromedacenter.com", true },
  { "androtech.xyz", true },
  { "androticsdirect.com", true },
  { "andruvision.cz", true },
  { "andsat.org", true },
  { "andschwa.com", false },
  { "anduril.de", true },
  { "anduril.eu", true },
  { "andybrett.com", true },
  { "andyc.cc", true },
  { "andycraftz.eu", true },
  { "andycrockett.io", true },
  { "andysroom.dynu.net", true },
  { "andyt.eu", true },
  { "andzia.art.pl", true },
  { "anedot-sandbox.com", true },
  { "anedot.com", true },
  { "anedot.space", true },
  { "anedot.xyz", true },
  { "aneebahmed.com", true },
  { "anekdot-pr.tk", true },
  { "anepsa.com.mx", true },
  { "aneslix.com", false },
  { "anetaben.nl", true },
  { "anextraordinaryday.net", true },
  { "angehardy.com", true },
  { "angelcorpus.tk", true },
  { "angelesydemonios.es", true },
  { "angeletakis.net", true },
  { "angelicare.co.uk", true },
  { "angelinahair.com", true },
  { "angeljmadrid.com", true },
  { "angelok.ru", true },
  { "angelremigene.com", false },
  { "angelspabeauty.co.uk", true },
  { "angepsychedelices.tk", true },
  { "angiejones.com", true },
  { "anginf.de", true },
  { "angkasa.net.id", true },
  { "anglersconservation.net", true },
  { "anglictina-sojcak.cz", true },
  { "anglictinasojcak.cz", true },
  { "anglingactive.co.uk", true },
  { "anglirl.eu.org", true },
  { "angora.freesite.host", true },
  { "angora.me", true },
  { "angrapa.ru", true },
  { "angrido.com", true },
  { "angristan.fr", true },
  { "angristan.xyz", true },
  { "angry.im", true },
  { "angrysnarl.com", true },
  { "angryteeth.net", true },
  { "angular-software.at", true },
  { "angularjs.org", false },
  { "angusmak.com", true },
  { "anhaffen.lu", true },
  { "anhqv.es", true },
  { "ani-man.de", true },
  { "anicam.fr", true },
  { "animaemundi.be", false },
  { "animal-liberation.com", true },
  { "animal-rights.com", true },
  { "animalconnect.org.za", true },
  { "animalistic.io", true },
  { "animalliberation.tk", true },
  { "animaltesting.fr", true },
  { "animalz.tk", true },
  { "anime-culture.com", true },
  { "anime-rg.com", true },
  { "anime-tip.com", true },
  { "anime.my", false },
  { "anime1.me", true },
  { "anime1.moe", true },
  { "anime1.pw", true },
  { "animeai.com", true },
  { "animebits.moe", true },
  { "animeclub.in.ua", true },
  { "animedon.tk", true },
  { "animefever.tv", true },
  { "animefire.net", true },
  { "animefluxxx.com", true },
  { "animehf.com", true },
  { "animeinsights.net", true },
  { "animeone.me", true },
  { "animes-portal.info", true },
  { "animetriad.com", true },
  { "animojis.es", true },
  { "anipassion.com", false },
  { "anirvalle.com", true },
  { "anitaalbersen.nl", true },
  { "anitaxcph.dk", true },
  { "anivar.net", true },
  { "aniviasport.store", true },
  { "anjara.eu", true },
  { "anjocerdena.com", true },
  { "anjoola.com", true },
  { "ankane.org", true },
  { "ankaraevdenevenakliyat.name.tr", true },
  { "ankarakart.com.tr", true },
  { "ankaraotokiralama.tk", true },
  { "ankaraprofesyonelwebtasarim.com", true },
  { "ankaraseo.name.tr", true },
  { "ankarauzmanlarnakliyat.com", true },
  { "ankitha.in", true },
  { "ankitpati.in", true },
  { "ankiuser.net", true },
  { "ankiweb.net", true },
  { "ankwanoma.com", true },
  { "anleitung-deutsch-lernen.de", true },
  { "anleitung-zum-flechten.de", true },
  { "anleitung-zum-haekeln.de", true },
  { "anleitung-zum-schreiben.de", true },
  { "anleitung-zum-schweissen.de", true },
  { "anleitung-zum-toepfern.de", true },
  { "anna.info", true },
  { "annabelcinemas.com", true },
  { "annaenemma.nl", true },
  { "annafiore.com.br", true },
  { "annalitvinova.pro", true },
  { "annangela.moe", true },
  { "annarokina.com", true },
  { "annawagner.pl", true },
  { "annedaniels.co.uk", true },
  { "anneeden.de", true },
  { "annejan.com", true },
  { "anneliesonline.nl", true },
  { "annema.biz", true },
  { "annemakeslovelycandles.co.uk", true },
  { "annetta.com", true },
  { "annettewindlin.ch", true },
  { "annevankesteren.nl", true },
  { "anney-life.com", true },
  { "anniversary-cruise.com", true },
  { "annmariewaltsphotography.com", true },
  { "annonasoftware.com", true },
  { "annoyingasfuk.com", true },
  { "anns.eu", true },
  { "annuaire-auto-ecole.com", true },
  { "annuaire-jcb.com", true },
  { "annuaire-photographe.fr", false },
  { "annunciationbvmchurch.org", true },
  { "anodas.lt", true },
  { "anohana.org", true },
  { "anojan.com", true },
  { "anon-next.de", true },
  { "anonaddy.com", true },
  { "anonaddy.me", true },
  { "anoncom.net", true },
  { "anoncrypto.org", true },
  { "anoneko.com", true },
  { "anongoth.pl", true },
  { "anons.fr", false },
  { "anonser.tk", true },
  { "anonym-surfen.de", true },
  { "anonyme-spieler.at", true },
  { "anora.ai", true },
  { "anoracdn.net", true },
  { "anorak.tech", true },
  { "anotherfatgeek.net", true },
  { "anothervps.com", true },
  { "anouncer.ga", true },
  { "anowicki.pl", true },
  { "ans-delft.nl", true },
  { "ans-ge.ch", false },
  { "ansas.eu", true },
  { "ansas.net", true },
  { "ansdell.net", true },
  { "ansermet.net", false },
  { "ansgar-sonntag.de", true },
  { "ansgarsonntag.de", true },
  { "anshar.eu", true },
  { "ansibeast.net", true },
  { "ansichtssache.at", true },
  { "ansogning-sg.dk", true },
  { "anstaskforce.gov", true },
  { "antabuse.ga", true },
  { "antalyaescortyaren.tk", true },
  { "antama.eu", true },
  { "antama.nl", true },
  { "antanavagefarbiarz.com", true },
  { "antani.cloud", true },
  { "antarcti.co", true },
  { "antarees.net", true },
  { "antaresmedia.com.py", true },
  { "antarespc.com", true },
  { "antcas.com", false },
  { "antennajunkies.com", true },
  { "antennista.bari.it", true },
  { "antennista.catania.it", true },
  { "antennista.it", true },
  { "antennista.milano.it", true },
  { "antennista.pavia.it", true },
  { "antennista.roma.it", true },
  { "antennista.tv", true },
  { "antennistaroma.it", true },
  { "antennisti.milano.it", true },
  { "antennisti.roma.it", true },
  { "antfarm.cf", true },
  { "antfie.com", true },
  { "anthisis.tv", true },
  { "anthony.codes", true },
  { "anthonyellis.com", true },
  { "anthonyfontanez.com", true },
  { "anthonygaidot.fr", true },
  { "anthonyloop.com", true },
  { "anthonyvadala.me", true },
  { "anthropoid.ca", true },
  { "anti-bible.com", true },
  { "anti-nsa.tk", true },
  { "anti-radar.org", true },
  { "antiaz.com", true },
  { "anticopyright.com", true },
  { "antiekboerderijgraafland.nl", true },
  { "antifilter.network", true },
  { "antihistory.cf", true },
  { "antihype.space", true },
  { "antik-trodelmarkt.de", true },
  { "antikvarius.ro", true },
  { "antilaserpriority.com", true },
  { "antimine.me", true },
  { "antincendio.it", true },
  { "antincendio.roma.it", true },
  { "antipolygraph.org", true },
  { "antique-pedalcars.ch", true },
  { "antirepressionbayarea.com", true },
  { "antispamcloud.dk", true },
  { "antispeciesism.com", true },
  { "antispeciesist.com", true },
  { "antivirusprotection.reviews", true },
  { "antizon.net", true },
  { "antocom.com", true },
  { "antoinedeschenes.com", true },
  { "antoineelizabe.com", true },
  { "antoinemary.com", true },
  { "antonchen.com", true },
  { "antonimos.com.br", true },
  { "antonin.one", true },
  { "antonio-gartenbau.de", true },
  { "antoniogatti.ro", true },
  { "antonjuulnaber.dk", true },
  { "antonoff.tk", true },
  { "antonok.com", true },
  { "antota.lt", true },
  { "antragsgruen.de", true },
  { "antroposboutique.it", true },
  { "antroposofica.com.br", true },
  { "antvklik.com", true },
  { "antyblokada.pl", true },
  { "antyfake.pl", true },
  { "anulowano.pl", true },
  { "anunturitv.ro", true },
  { "anvartay.com", false },
  { "anvorte.com", false },
  { "anwalt.us", true },
  { "anwaltsindex.com", true },
  { "anxietyspace.com", true },
  { "anxiolytics.com", true },
  { "any-download.cf", true },
  { "any-download.ga", true },
  { "any-download.gq", true },
  { "any-download.ml", true },
  { "anyad.at", true },
  { "anyi.in", true },
  { "anyilin.cn", true },
  { "anymetrix.io", true },
  { "anyon.com", true },
  { "anypeer.net", true },
  { "anyquestions.govt.nz", true },
  { "anystack.xyz", true },
  { "anythinggraphic.net", true },
  { "anyways.at", true },
  { "anzacparkeast.com", true },
  { "anzeiger.ag", true },
  { "ao-dev.com", true },
  { "ao2.it", true },
  { "aoa.gov", true },
  { "aoadatacommunity.us", true },
  { "aobeauty.com.au", true },
  { "aod-tech.com", true },
  { "aoe9.com", true },
  { "aoeuaoeu.com", true },
  { "aofusa.net", true },
  { "aoil.gr", true },
  { "aokae.com", true },
  { "aopedeure.nl", true },
  { "aopsy.de", true },
  { "aori.com", true },
  { "aorosora.com", true },
  { "aosc.io", false },
  { "aostacarnavals.it", true },
  { "aotearoa.maori.nz", true },
  { "aotearoafreepress.com", true },
  { "aotearoaleaks.org", true },
  { "ap-swiss.ch", false },
  { "apa-canal.ro", true },
  { "apache-portal.com", true },
  { "apachehaus.de", false },
  { "apachelounge.com", true },
  { "apachezone.com", true },
  { "apadvantage.com", true },
  { "apalancamiento.trade", true },
  { "apart-hotel-weimar.de", true },
  { "apartmanicg.me", true },
  { "apartmanidano.com", true },
  { "apartment-in-rijeka.com", true },
  { "apartmentkroatien.at", true },
  { "apartmentregister.com.au", true },
  { "apasaja.tech", true },
  { "apbank.ch", true },
  { "apbox.de", true },
  { "apc.ec", true },
  { "apcemporium.co.uk", true },
  { "apcube.com", true },
  { "apdfawl.com", true },
  { "apdx.com", true },
  { "apef.ch", false },
  { "apercloud.es", true },
  { "apertis.org", true },
  { "aperture-science.net", true },
  { "apertureimaging.com", true },
  { "aperturelabs.tk", true },
  { "aperturesciencelabs.de", true },
  { "apervita.net", true },
  { "apex.to", true },
  { "apexitsolutions.ca", true },
  { "apgw.jp", true },
  { "aphelionentertainment.com", true },
  { "aphelis.net", true },
  { "api-connect.com", false },
  { "api.biz.tr", true },
  { "api.cloudflare.com", false },
  { "api.intercom.io", true },
  { "api.lookout.com", false },
  { "api.recurly.com", true },
  { "api.simple.com", false },
  { "api.xero.com", false },
  { "apicruz.com", true },
  { "apimon.de", true },
  { "apination.com", true },
  { "apio.systems", true },
  { "apiplus.fr", true },
  { "apirest.top", true },
  { "apis.google.com", true },
  { "apisyouwonthate.com", true },
  { "apitodemestre.com.br", true },
  { "apk.li", true },
  { "apk4fun.com", true },
  { "apkmod.id", true },
  { "apkpokemongo.gq", true },
  { "aplazame.com", true },
  { "aplikaceproandroid.cz", true },
  { "aplpackaging.co.uk", true },
  { "aplu.fr", true },
  { "aplus-usa.net", true },
  { "aplusdownload.com", true },
  { "apluswaterservices.com", true },
  { "apm.com.tw", true },
  { "apmg-certified.com", true },
  { "apn-dz.org", true },
  { "apn-einstellungen.de", true },
  { "apobot.de", true },
  { "apocalypseboard.tk", true },
  { "apocalypsemud.org", true },
  { "apod-portal-daily.azurewebsites.net", true },
  { "apod.com.au", true },
  { "apogeephoto.com", true },
  { "apollo-auto.com", true },
  { "apoly.de", true },
  { "apometria.site", true },
  { "aponkral.com", true },
  { "aponkral.com.tr", true },
  { "aponkral.net", true },
  { "aponkral.org", true },
  { "aporia.io", true },
  { "aposke.net", true },
  { "aposke.org", true },
  { "apostalegal.com", true },
  { "apostalegal.pt", true },
  { "apothecarydouglasville.com", true },
  { "apotheke55.de", true },
  { "apothes.is", true },
  { "app-at.work", true },
  { "app-scope.com", true },
  { "app.lookout.com", true },
  { "app.recurly.com", true },
  { "app.simpletax.ca", true },
  { "app.yinxiang.com", false },
  { "app00228.com", false },
  { "app11018.com", false },
  { "app2get.de", true },
  { "app6810.com", true },
  { "app77018.com", false },
  { "appagility.co.nz", true },
  { "appapi.link", true },
  { "apparelfashionwiki.com", true },
  { "appartement-andrea.at", true },
  { "appartement-evolene.net", false },
  { "appartementhaus-badria.de", true },
  { "appartementmarsum.nl", true },
  { "appassionata.ru", true },
  { "appbydl.com", true },
  { "appelaprojets.fr", true },
  { "appelboomdefilm.nl", true },
  { "appengine.google.com", true },
  { "appers.co", true },
  { "appgeek.com.br", true },
  { "appharbor.com", true },
  { "appify.org", true },
  { "appizia.com", true },
  { "applegun.com", true },
  { "applemon.com", true },
  { "appleoosa.com", true },
  { "applesencia.com", true },
  { "applian.jp", true },
  { "appliancepronwi.com", true },
  { "application-travel.us.com", true },
  { "applicationmanager.gov", true },
  { "applied-privacy.net", true },
  { "appliquette.com.au", true },
  { "apply-esta.us.com", true },
  { "apply-eta.org", true },
  { "apply-visa.us.com", true },
  { "apply.eu", true },
  { "appmeas.co.uk", true },
  { "appmobile.io", true },
  { "appninjas.com", true },
  { "apponic.com", true },
  { "appraf.com", true },
  { "apprank.in", true },
  { "apprendre-le-russe-avec-ania.fr", true },
  { "apprenticeship.gov", true },
  { "apprenticeships.gov", true },
  { "approbo.com", true },
  { "approval-workflow.com", true },
  { "approvedtreecare.com", true },
  { "apps.co", true },
  { "apps.facebook.com", false },
  { "apps.fedoraproject.org", true },
  { "apps.stg.fedoraproject.org", true },
  { "apps4inter.net", false },
  { "appsaraby.com", true },
  { "appscloudplus.com", true },
  { "appsdisosa.com", true },
  { "appseccalifornia.org", false },
  { "appsforlondon.com", true },
  { "appt.ch", false },
  { "apptesters.com", true },
  { "appuals.com", true },
  { "appub.co.jp", true },
  { "appui-de-fenetre.fr", true },
  { "appveyor.com", true },
  { "appworld.ga", true },
  { "appzoojoo.be", true },
  { "apretatuercas.es", true },
  { "aprikaner.de", true },
  { "aprogend.com.br", true },
  { "aproposcomputing.com", true },
  { "aprovpn.com", true },
  { "aprr.org", true },
  { "aprsdroid.org", true },
  { "aprz.de", true },
  { "apsa.paris", true },
  { "apstudynotes.org", true },
  { "aptekakolska.pl", true },
  { "aptitudetests.org", true },
  { "aptumseguros.mx", true },
  { "apu-board.de", true },
  { "apunkt.dk", true },
  { "apustaja.org", true },
  { "apuyou.io", true },
  { "apv-ollon.ch", true },
  { "apviz.io", true },
  { "apwide.com", true },
  { "aqarategypt.com", true },
  { "aqsiq.net", true },
  { "aqua-bucht.de", true },
  { "aqua-ferra.co.uk", true },
  { "aqua-fitness-nacht.de", true },
  { "aqua-fotowelt.de", true },
  { "aquabio.ch", false },
  { "aquabyte.co.uk", true },
  { "aquadecor.cf", true },
  { "aquadonis.ch", false },
  { "aquagarden.com.pl", true },
  { "aquahomo.com", true },
  { "aquaist.com", true },
  { "aqualife.com.gr", true },
  { "aqualifeprojects.com", true },
  { "aqualysis.nl", true },
  { "aquamarin.icu", true },
  { "aquapoint.kiev.ua", true },
  { "aquarden.com", true },
  { "aquarden.dk", true },
  { "aquariu.ms", true },
  { "aquarium-supplement.net", true },
  { "aquaselect.eu", true },
  { "aquasun.pl", true },
  { "aquaterm72.ru", true },
  { "aquaundine.net", true },
  { "aquavitaedayspa.com.au", true },
  { "aquelarreweb.com", true },
  { "aquila.co.uk", true },
  { "aquitainebrasserie.com.au", true },
  { "ar-informatique.ch", false },
  { "arab.dating", true },
  { "arabic-shirts.com", true },
  { "arabsexi.info", true },
  { "arachina.com", true },
  { "arackiralama.name.tr", true },
  { "aracusbienestar.com", true },
  { "arados.de", true },
  { "aragon.fun", true },
  { "arai21.net", true },
  { "aral.ml", true },
  { "araleeniken.com", true },
  { "aramido.de", true },
  { "aramloebmd.com", true },
  { "aranchhomes.com", true },
  { "aranycsillag.net", true },
  { "araratour.com", true },
  { "araro.ch", false },
  { "araseifudousan.com", true },
  { "arawaza.com", false },
  { "araxis.com", true },
  { "arbeitsch.eu", true },
  { "arbeitskreis-asyl-eningen.de", true },
  { "arbeitslosenverwaltung.de", true },
  { "arbejdsdag.dk", true },
  { "arbitrarion.com", true },
  { "arbitrary.ch", true },
  { "arboleda-hurtado.com", true },
  { "arcadio.fr", true },
  { "arcaik.net", true },
  { "arcanetides.com", true },
  { "arcanist.games", true },
  { "arcbouncycastles.co.uk", true },
  { "arcenergy.co.uk", true },
  { "archaeoadventures.com", true },
  { "archambault.paris", true },
  { "archbishop.ga", true },
  { "archeologicatoscana.it", true },
  { "archframe.net", true },
  { "archimedicx.com", true },
  { "archina.ir", true },
  { "archined.nl", true },
  { "archit.in", true },
  { "architectryan.com", true },
  { "architecture-colleges.com", true },
  { "architectureandgovernance.com", true },
  { "architecturequote.com", true },
  { "architectus.ga", true },
  { "archivero.es", true },
  { "archivesdelavieordinaire.ch", true },
  { "archivium.biz", true },
  { "archivosmercury.com", true },
  { "archivosstl.com", true },
  { "archiweb.pl", false },
  { "archlinux.de", true },
  { "archlinux.org", true },
  { "archwood.ro", true },
  { "arcinapoli.it", true },
  { "arclandholdings.com.au", true },
  { "arcobalabs.ca", true },
  { "arcogb.co", true },
  { "arcovix.com", true },
  { "arcridge.ca", true },
  { "arctic.ca", true },
  { "arctic.gov", true },
  { "arctica.io", true },
  { "arcticbit.net", true },
  { "arctus-security.com", true },
  { "arcueil-cachan.fr", false },
  { "arcusnova.de", true },
  { "ardadanal.com", true },
  { "ardor.noip.me", true },
  { "ardtrade.ru", true },
  { "area.ge", true },
  { "area4pro.com", true },
  { "areacinquentaeum.tk", true },
  { "areaclienti.net", false },
  { "areafiftylan.nl", true },
  { "areatrend.com", true },
  { "areis.pt", true },
  { "arekatieandchrisgettingmarried.com", true },
  { "arekatieandchrisgettingmarried.today", true },
  { "arekatieandchrismarriedyet.com", true },
  { "arena-lemgo.de", true },
  { "arenda247.by", true },
  { "arendburgers.nl", true },
  { "areqgaming.com", true },
  { "ares-trading.de", true },
  { "aresanel.com", true },
  { "arethsu.se", true },
  { "arfad.ch", false },
  { "arganaderm.ch", false },
  { "argb.de", true },
  { "argecord.com", true },
  { "argekultur.at", true },
  { "argentinatrabaja.org", true },
  { "argonium.com.au", true },
  { "argot.com", true },
  { "argovpay.com", true },
  { "argumentative-essay.gq", true },
  { "ariacreations.net", true },
  { "ariadermspa.com", true },
  { "arian.io", true },
  { "ariana.wtf", true },
  { "ariba.info", true },
  { "ariege-pyrenees.net", true },
  { "arielpereira.tk", true },
  { "arieswdd.com", true },
  { "arigato-java.download", true },
  { "ariixmex.com", true },
  { "arijitdg.net", true },
  { "arikar.eu", true },
  { "arilto.com", true },
  { "arinde.ee", true },
  { "arise19.com", true },
  { "arisechurch.com", false },
  { "ariseconference.org.nz", false },
  { "aritec-la.com", true },
  { "arithmetic.ga", true },
  { "arivo.com.br", true },
  { "ariyaoil.ir", true },
  { "arizana.com", true },
  { "arjan.nl", true },
  { "arjandejong.eu", true },
  { "arjanenthijs.nl", true },
  { "arjansteevels.nl", true },
  { "arjanvaartjes.net", true },
  { "arjunasdaughter.pub", true },
  { "arjweb.co.uk", true },
  { "arkacrao.org", true },
  { "arkadiyt.com", true },
  { "arkantos.agency", true },
  { "arkenco.cl", true },
  { "arkhvoid.xyz", true },
  { "arkitextonico.com", true },
  { "arkulagunak.com", false },
  { "arlaperu.com", true },
  { "arlartistadigital.com.mx", true },
  { "arlen.tv", true },
  { "arlenarmageddon.com", true },
  { "arletalibrary.com", true },
  { "arlingtonelectric.com", true },
  { "arlingtonwine.net", true },
  { "arm-host.com", true },
  { "arm.gov", true },
  { "armadale.wa.gov.au", true },
  { "armadaquadrat.com", true },
  { "armageddonstuff.com", true },
  { "armandsdiscount.com", true },
  { "armanozak.com", true },
  { "armansfinejewellery.com", true },
  { "armansfinejewellery.com.au", true },
  { "armarinhovirtual.com.br", true },
  { "armbrust.me", true },
  { "armcar.ga", true },
  { "armedpoet.com", true },
  { "armeniaweb.tk", true },
  { "armil.it", true },
  { "armin-cme.de", true },
  { "armin-cpe.de", true },
  { "arminpech.de", true },
  { "armor.ai", true },
  { "armpads.nl", true },
  { "armstrongsengineering.com", true },
  { "armtopnews.tk", true },
  { "army24.cz", true },
  { "armyprodej.cz", true },
  { "arnaudardans.com", true },
  { "arnaudb.net", true },
  { "arnaudfeld.de", true },
  { "arnaudlanna.com", true },
  { "arnesegers.be", true },
  { "arnevankauter.com", true },
  { "arniescastles.co.uk", true },
  { "arno-klein.com", true },
  { "arno-klein.de", true },
  { "arno-klein.eu", true },
  { "arno-klein.fr", true },
  { "arno-klein.net", true },
  { "arnoklein.eu", true },
  { "arnoklein.fr", true },
  { "arnoldkontz-occasions.lu", false },
  { "arnonerba.com", true },
  { "arnor.org", true },
  { "arnoudraeven.nl", true },
  { "arnoudvandalen.nl", true },
  { "arnove.fr", true },
  { "arnove.net", true },
  { "arnsmedia.nl", false },
  { "arod.tk", true },
  { "arogov.com", true },
  { "arokha.com", true },
  { "aromacos.ch", true },
  { "aron.host", true },
  { "aroonchande.com", false },
  { "aros.pl", true },
  { "arose.io", true },
  { "around-cms.de", true },
  { "arox.eu", true },
  { "arpatutorial.com", true },
  { "arpnet.co.jp", true },
  { "arqueo-ecuatoriana.ec", true },
  { "arquitet.com.br", true },
  { "arquitetura.pt", true },
  { "arrakis.se", true },
  { "arraudi.be", true },
  { "arrazane.com.br", true },
  { "arresttracker.com", true },
  { "arrive.by", true },
  { "arrmaforum.com", true },
  { "arroba.digital", true },
  { "arrow-analytics.nl", true },
  { "arrow-api.nl", true },
  { "arrowfastener.com", true },
  { "arrowheadaddict.com", true },
  { "arrowwebprojects.nl", true },
  { "ars-online.pl", true },
  { "arschkrebs.org", true },
  { "arsenal-charodeya.com", true },
  { "arsindecor.com", true },
  { "arslankaynakmetal.com", true },
  { "arsplus.ru", false },
  { "art-auction.jp", true },
  { "art-et-culture.ch", false },
  { "art-et-tonneaux.fr", true },
  { "art-news.tk", true },
  { "art-pix.com", true },
  { "art-pix.de", true },
  { "art-pix.net", true },
  { "art-shinbi.com", true },
  { "artacadia.org", true },
  { "artboja.com", true },
  { "artc.at", true },
  { "artcaly.com.br", true },
  { "artdeco-photo.com", false },
  { "artea.ga", true },
  { "arteaga.co.uk", true },
  { "arteaga.eu", true },
  { "arteaga.me", true },
  { "arteaga.tech", true },
  { "arteaga.uk", true },
  { "arteaga.xyz", true },
  { "artebel.com.br", true },
  { "artecat.ch", true },
  { "artedellavetrina.it", true },
  { "artedona.com", true },
  { "artefakt.es", true },
  { "artefeita.com.br", true },
  { "arteinstudio.it", true },
  { "artelt.com", true },
  { "artemis.re", true },
  { "artera.spb.ru", true },
  { "arterienundvenen.ch", true },
  { "arterydb.ru", true },
  { "artesaniastonalaytlaquepaque.com", true },
  { "arteseideias.com.pt", true },
  { "arteshow.ch", false },
  { "artfabrics.com", true },
  { "artforum.sk", true },
  { "artfullyelegant.com", true },
  { "arthan.me", true },
  { "arthermitage.org", true },
  { "arthritisrheumaticdiseases.com", true },
  { "arthurlaw.ca", true },
  { "arthuryidi.com", true },
  { "arti-islam.tk", true },
  { "articu.no", true },
  { "artifact.spb.ru", true },
  { "artifexnet.com", true },
  { "artificialgrassandlandscaping.com", true },
  { "artificialplants.tk", true },
  { "artigianociao.jp", true },
  { "artigoos.com", true },
  { "artimpact.ch", true },
  { "artioml.net", true },
  { "artionet.ch", true },
  { "artis-game.net", true },
  { "artisan-cheminees-poeles-design.fr", false },
  { "artisansoftaste.com", true },
  { "artisavotins.com", true },
  { "artistagenda.com", true },
  { "artistedeparis.fr", true },
  { "artistrunwebsite.com", true },
  { "artitbe.net", true },
  { "artiwear.com.tw", true },
  { "artlantis.nl", true },
  { "artleading.ru", true },
  { "artlifeisgood.com", true },
  { "artlogo.biz", true },
  { "artlogo.cz", true },
  { "artlogo.sk", true },
  { "artmarketingnews.com", true },
  { "artmoney.com", true },
  { "artmosfilms.co.za", true },
  { "artofcode.co.uk", true },
  { "artofhappyliving.com", true },
  { "artofmonitoring.com", false },
  { "artofwhere.com", true },
  { "artozoul.fr", true },
  { "artplasticsurgeons.com", true },
  { "artrapid.com", true },
  { "artratio.net", true },
  { "artroot.jp", true },
  { "artroscopiaperlosport.it", true },
  { "arts.gov", true },
  { "artschmidtoptical.com", true },
  { "artsmarket.ca", true },
  { "artspac.es", true },
  { "arttel-media.ru", true },
  { "arturli.be", true },
  { "arturopinto.com.mx", true },
  { "arturszalak.com", true },
  { "artweby.cz", true },
  { "artworxbathrooms.com.au", true },
  { "arty.name", true },
  { "artyengine.com", true },
  { "arubasunsetbeach.com", true },
  { "arufu.dk", true },
  { "arunjoshua.com", true },
  { "arveron.ch", false },
  { "arvid.io", true },
  { "arvindhariharan.com", true },
  { "arvindhariharan.me", true },
  { "arvutiladu.ee", true },
  { "arweth.com", true },
  { "arx-libertatis.org", true },
  { "arx.vg", true },
  { "arx8x.net", true },
  { "arxell.com", true },
  { "aryalaroca.de", true },
  { "aryan-nation.com", true },
  { "aryasenna.net", true },
  { "arzid.com", true },
  { "as200753.com", true },
  { "as200753.net", true },
  { "as44222.net", true },
  { "as5158.com", true },
  { "as8423.net", true },
  { "asaabforever.com", true },
  { "asabacortoscaseros.tk", true },
  { "asadatec.de", true },
  { "asafaweb.com", true },
  { "asafilm.co", true },
  { "asakoh.co.jp", true },
  { "asana.com", true },
  { "asananutrition.co.uk", true },
  { "asandu.eu", true },
  { "asanger.biz", true },
  { "asart.bg", true },
  { "asato-jewelry.com", true },
  { "asbestosthedarkarts.com", true },
  { "asbito.de", true },
  { "ascension.run", true },
  { "ascgathering.com", true },
  { "aschismatic.com", true },
  { "asciitable.tips", true },
  { "asciiwwdc.com", true },
  { "ascpaphilatelie.eu", true },
  { "asdchieti.tk", true },
  { "asdwfwqd.com", true },
  { "asdyx.de", true },
  { "asegem.es", true },
  { "asenno.com", true },
  { "aserver.co", true },
  { "asexualitat.cat", true },
  { "asfaleianet.gr", true },
  { "asgapps.co.za", true },
  { "asgrd.org", true },
  { "ashd1.goip.de", true },
  { "ashd2.goip.de", true },
  { "ashd3.goip.de", true },
  { "ashenm.ml", true },
  { "ashessin.com", true },
  { "ashlarimoveis.com.br", true },
  { "ashleyedisonuk.com", true },
  { "ashleykaryl.com", true },
  { "ashleymadison.com", true },
  { "ashleythouret.com", true },
  { "ashlocklawgroup.com", true },
  { "ashmportfolio.com", true },
  { "ashmyra.com", true },
  { "ashridgetrees.co.uk", true },
  { "ashtonbromleyceramics.co.uk", true },
  { "ashtonc.ca", true },
  { "ashtonwealth.com", true },
  { "ashutoshmishra.org", true },
  { "asia-gazette.com", true },
  { "asia.dating", true },
  { "asiaheavens.com", true },
  { "asialeonding.at", true },
  { "asian-industry.eu", true },
  { "asianshops.net", true },
  { "asianspa.co.uk", true },
  { "asianwebcams.webcam", true },
  { "asiasmi.tk", true },
  { "asiba.com.au", true },
  { "asiinc-tex.com", true },
  { "asile-colis.fr", true },
  { "asilo.roma.it", true },
  { "asinetasima.com", true },
  { "ask.fi", true },
  { "ask1.org", true },
  { "askcascade.com", true },
  { "askeustache.com", true },
  { "askizzy.org.au", true },
  { "askkaren.gov", true },
  { "askme-events.vip", true },
  { "askv6.net", true },
  { "askvg.com", true },
  { "askwhy.cz", true },
  { "askwhy.eu", true },
  { "asmanyasgiven.com", true },
  { "asmarketero.com", true },
  { "asmbsurvey.com", true },
  { "asmdz.com", true },
  { "asmeets.nl", true },
  { "asmood.net", true },
  { "asociaciontrastea.com", true },
  { "asp.net", true },
  { "aspargesgaarden.no", true },
  { "aspcl.ch", true },
  { "aspectuw.com.au", true },
  { "asperger-ag.ch", true },
  { "asperti.com", true },
  { "aspformacion.com", true },
  { "asphyxia.su", true },
  { "aspiescentral.com", true },
  { "aspiradorasbaratas.net", true },
  { "aspirateur-anti-pollution.fr", true },
  { "aspires.co.jp", true },
  { "aspireuniversal.com", true },
  { "aspirevc.com", true },
  { "aspisdata.com", true },
  { "asprion.org", true },
  { "asproni.it", true },
  { "asr.cloud", true },
  { "asr.li", true },
  { "asr.rocks", true },
  { "asr.solar", true },
  { "asra.gr", true },
  { "asryflorist.com", true },
  { "assaabloygaragedoors.ca", true },
  { "asseenfromthesidecar.org", true },
  { "assemblage.gq", true },
  { "assemble-together.org", true },
  { "assemblytechnicianjobs.com", true },
  { "assemblywithoutthewalls.org", true },
  { "assempsaibiza.com", true },
  { "assertion.de", true },
  { "assessoriati.com.br", true },
  { "assetbacked.capital", false },
  { "assetsec.io", true },
  { "assetsman-assetsvalue.com", true },
  { "assguidesporrentruy.ch", false },
  { "assign-it.co.uk", true },
  { "assignacii.ml", true },
  { "assis.partners", true },
  { "assistel.com", true },
  { "assistenciamultitec.com.br", true },
  { "associatedwomenshealthcare.com", true },
  { "associationhorizon.tk", true },
  { "assodigitale.it", true },
  { "asspinter.me", true },
  { "assumptionpj.org", true },
  { "astal.rs", true },
  { "astaninki.com", true },
  { "astarbouncycastles.co.uk", true },
  { "astarmathsandphysics.com", true },
  { "astaxanthin-sport.de", true },
  { "astaxanthin.de", true },
  { "astec-informatica.com", true },
  { "astengox.com", true },
  { "astenotarili.online", false },
  { "asticon.de", true },
  { "astifan.online", true },
  { "astral-imperium.com", true },
  { "astroalloys.com.au", true },
  { "astrociencia.tk", true },
  { "astrojunkies.com", true },
  { "astroloeches.tk", true },
  { "astrology42.com", true },
  { "astrong.pl", true },
  { "astroscopy.ch", false },
  { "astrovandalistas.cc", true },
  { "astucewebmaster.com", true },
  { "astural.org", false },
  { "astutikhonda.com", true },
  { "asu.moe", true },
  { "asuclassfinder.com", true },
  { "asun.co", true },
  { "asurbernardo.com", true },
  { "asurepay.cc", false },
  { "asustreiber.de", true },
  { "asvsa.ch", false },
  { "asws.nl", true },
  { "asyikbelanja.com", true },
  { "asylbarn.no", true },
  { "asystent-dzierzawy.pl", true },
  { "at.search.yahoo.com", false },
  { "at5.nl", true },
  { "at7s.me", true },
  { "ataber.pw", true },
  { "atacadocervejeiro.com.br", true },
  { "atacadodesandalias.com.br", true },
  { "atahualpa.com", true },
  { "atallo.com", true },
  { "atallo.es", true },
  { "ataton.ch", false },
  { "atayia.com", true },
  { "atbwebservices.co.uk", true },
  { "atc.cuneo.it", true },
  { "atchleyjazz.com", true },
  { "atchleyjazz.org", true },
  { "atchleylab.org", true },
  { "atcom.cl", true },
  { "atds.ch", false },
  { "ateamsport.dk", true },
  { "atease-salon.jp", true },
  { "atedificacion.com", true },
  { "ateli.com", true },
  { "atelier-coiffure.ch", false },
  { "atelier-naruby.cz", true },
  { "atelieracbaby.com.br", true },
  { "atelieraphelion.com", true },
  { "atelierbw.com", true },
  { "atelierdefrancais.ch", false },
  { "atelierdeloulou.fr", true },
  { "atelierdesflammesnoires.fr", true },
  { "atelierfantazie.sk", true },
  { "atelierhsn.com", true },
  { "ateliernaruby.cz", true },
  { "atelierssud.ch", false },
  { "atencionbimbo.com", false },
  { "aterlectric.com", true },
  { "aterskapa-data.se", true },
  { "atf.gov", true },
  { "atfstudios.tk", true },
  { "atgoetschel.ch", false },
  { "atgseed.co.uk", true },
  { "atgseed.uk", true },
  { "ath0.org", false },
  { "atheist-faq.com", true },
  { "atheist-refugees.com", true },
  { "atheistfrontier.com", true },
  { "atheit.com", true },
  { "athekiu.com", true },
  { "athemis.de", true },
  { "athena-garage.co.uk", true },
  { "athenadynamics.com", true },
  { "athenaneuro.com", true },
  { "athlin.de", true },
  { "athomedeco.fr", true },
  { "atigerseye.com", true },
  { "atimbertownservices.com", true },
  { "atinylittle.space", true },
  { "atis-ars.ru", true },
  { "atishchenko.com", true },
  { "atisoft.biz", true },
  { "atisoft.com.tr", true },
  { "atisoft.net", true },
  { "atisoft.net.tr", true },
  { "atisoft.web.tr", true },
  { "atitude.com", true },
  { "ativapsicologia.com.br", true },
  { "atl-paas.net", true },
  { "atlantareroof.com", true },
  { "atlantaspringroll.com", true },
  { "atlantichomes.com.au", true },
  { "atlanticmarina.com", true },
  { "atlanticpediatricortho.com", true },
  { "atlanticyellowpages.com", true },
  { "atlantis-kh.noip.me", true },
  { "atlantischild.hu", true },
  { "atlantishq.de", true },
  { "atlantiswaterproofing.com", true },
  { "atlas-heritage.com", true },
  { "atlas-multimedia.de", true },
  { "atlasauthority.com", true },
  { "atlasbrown.com", true },
  { "atlascoffeeclub.com", true },
  { "atlascultural.com", true },
  { "atlasdev.nl", true },
  { "atlasone.us", true },
  { "atlassignsandplaques.com", true },
  { "atletika.hu", true },
  { "atmalta.com", true },
  { "atmind.nl", true },
  { "atmmantenimiento.co", true },
  { "atnis.com", true },
  { "ato4sound.com", true },
  { "atolm.net", true },
  { "atom-china.org", true },
  { "atom.solutions", true },
  { "atom86.net", true },
  { "atomicbounce.co.uk", true },
  { "atomism.com", true },
  { "atorcidabrasileira.com.br", true },
  { "atplonline.co", true },
  { "atpnutrition.com", true },
  { "atrafloor.com", true },
  { "atraining.ru", true },
  { "atraverscugy.ch", false },
  { "atrevillot.com", true },
  { "atrias.net", true },
  { "atrinik.org", true },
  { "atsoftware.de", true },
  { "attac.us", true },
  { "atte.fi", true },
  { "attendanceondemand.com", true },
  { "attendantdesign.com", true },
  { "attendu.cz", true },
  { "attengo.ga", true },
  { "attention.horse", true },
  { "attilagyorffy.com", true },
  { "attilavandervelde.nl", true },
  { "attinderdhillon.com", true },
  { "attitudes-bureaux.fr", true },
  { "attogtech.com", true },
  { "attorney.org.il", true },
  { "attuned.se", true },
  { "attunedstore.com", true },
  { "attwood.org", true },
  { "atuendomr.com", true },
  { "atviras.lt", false },
  { "atvirtual.at", true },
  { "atvsafety.gov", true },
  { "atwar-mod.com", true },
  { "atwonline.org", true },
  { "atxchirocoverage.com", true },
  { "atyourprice.net", true },
  { "atypicom.es", true },
  { "atypicom.fr", true },
  { "atypicom.it", true },
  { "atypicom.pt", true },
  { "atzenchefin.de", true },
  { "atzzz.com", true },
  { "au2pb.org", true },
  { "aubergegilly.ch", false },
  { "aubg.org", true },
  { "aubio.org", true },
  { "aubonheurdeshuiles.fr", true },
  { "aubonmanger.fr", false },
  { "aubreysnider.com", true },
  { "auburnmedicalservices.com", true },
  { "auburnperio.com", true },
  { "aucarresainteloi.com", true },
  { "aucielrose.com", true },
  { "aucklandcastles.co.uk", true },
  { "aucospa.com", true },
  { "aucubin.de", true },
  { "audiclubbahrain.com", true },
  { "audiense.com", false },
  { "audio-detector.com", true },
  { "audiobookboo.com", true },
  { "audiobookstudio.com", true },
  { "audioboom.com", true },
  { "audiohub.com", true },
  { "audiohub.de", true },
  { "audiohub.fr", true },
  { "audiolibri.org", true },
  { "audiolot.com", true },
  { "audiomaze.com", true },
  { "audiophile.ch", false },
  { "audiophix.com", true },
  { "audiorecording.me", true },
  { "audiorental.net", true },
  { "audioschoolonline.com", true },
  { "audiotechniker.de", true },
  { "audirsq3.de", true },
  { "audisto.com", true },
  { "auditmatrix.com", true },
  { "auditos.com", true },
  { "audits.io", true },
  { "auditsquare.com", true },
  { "audreyhossepian.fr", true },
  { "audreyjudson.com", true },
  { "auenhof-agrar.de", true },
  { "auerbach-verlag.de", true },
  { "auf-feindgebiet.de", true },
  { "auf-nach-mallorca.info", true },
  { "aufro.com", true },
  { "aufwecken.dynu.net", true },
  { "augehost.com", true },
  { "augen-seite.de", true },
  { "augenlaser-chemnitz.de", true },
  { "augenlaser-dresden.de", true },
  { "augenlasercenter-dresden.de", true },
  { "augenlaserzentrum-dresden.com", true },
  { "augenlaserzentrum-dresden.eu", true },
  { "augesen.tk", true },
  { "augiero.it", true },
  { "augur.us", true },
  { "august-don.site", true },
  { "augustian-life.cz", true },
  { "augustiner-kantorei-erfurt.de", true },
  { "augustiner-kantorei.de", true },
  { "augustoshoppingnet.com.br", true },
  { "aukaraoke.su", true },
  { "auksnest.ca", true },
  { "aulasvirtualesperu.com", true },
  { "aulica-conseil.com", true },
  { "aulo.in", false },
  { "aumentada.net", true },
  { "aumilieudumonde.gf", true },
  { "aunali1.com", true },
  { "auntie-eileens.com.au", true },
  { "auntiesnorkel.com", true },
  { "auntmia.com", true },
  { "aupaysdesanes.com", true },
  { "auplidespages.fr", true },
  { "aura7chakr.com", true },
  { "aurbrowser.tk", true },
  { "aurelieburn.fr", true },
  { "aurelienaltarriba.fr", true },
  { "auricblue.com", true },
  { "auriko-games.de", true },
  { "aurnik.com", true },
  { "auroraassociationofrealtors.com", true },
  { "auroware.com", true },
  { "aus-ryugaku.info", true },
  { "ausec.ch", false },
  { "auskunftsbegehren.at", true },
  { "auspicacious.org", true },
  { "ausschreibungen-suedtirol.it", true },
  { "aussiefunadvisor.com", true },
  { "aussiemilfs.com", true },
  { "aussieseoadelaide.com.au", true },
  { "aussieseobrisbane.com.au", true },
  { "aussieservicedown.com", true },
  { "aussiestoresonline.com", true },
  { "austenplumbing.com", true },
  { "austerevisuals.com", true },
  { "austin-pearce.com", true },
  { "austin-security-cameras.com", true },
  { "austincardiac.com", true },
  { "austinchase.com", true },
  { "austinheap.com", false },
  { "austinlockout.com", true },
  { "austintxacrepairtoday.com", true },
  { "austinuniversityhouse.com", true },
  { "australian.dating", true },
  { "australianairbrushedtattoos.com.au", true },
  { "australianattractions.com.au", true },
  { "australianimmigrationadvisors.com.au", true },
  { "australianstrongmanalliance.com.au", true },
  { "australiantemporarytattoos.com", true },
  { "australiantemporarytattoos.com.au", true },
  { "australien-tipps.info", true },
  { "austromorph.space", true },
  { "auszeit-lanzarote.com", true },
  { "auszeit-walsrode.de", true },
  { "auszeit.bio", true },
  { "auth.adult", true },
  { "auth.mail.ru", true },
  { "authanet.ga", true },
  { "authcom.ca", true },
  { "authenticate.computer", true },
  { "authenticationhub.io", true },
  { "authenticwoodcraft.com", true },
  { "authinfo-bestellen.de", true },
  { "authinity.com", true },
  { "authland.com", false },
  { "author24.biz", true },
  { "author24.info", true },
  { "authoritysolutions.com", true },
  { "autimatisering.nl", true },
  { "autismewoerden.nl", true },
  { "auto-anleitung.de", true },
  { "auto-dealership-news.com", true },
  { "auto-i-dat.ch", true },
  { "auto-motor-i-sport.pl", true },
  { "auto-none.com", true },
  { "auto-plus.tn", true },
  { "auto-res.ru", true },
  { "auto-skills.ru", true },
  { "auto1.fi", true },
  { "autoauctionsohio.com", true },
  { "autoauctionsvirginia.com", true },
  { "autobarn.co.nz", true },
  { "autobedrijfgarant.nl", true },
  { "autobella-hurtownia.pl", true },
  { "autobelle.it", true },
  { "autobourcier.com", true },
  { "autocadperfmon.azurewebsites.net", true },
  { "autocartruck.com", true },
  { "autoccaz.fr", true },
  { "autocontrol.online", true },
  { "autocorner.com", true },
  { "autocrypt.org", true },
  { "autod.hu", true },
  { "autodalmacija.com", true },
  { "autodidactic.ai", true },
  { "autodidacticstudios.com", true },
  { "autodidacticstudios.net", true },
  { "autodius.com", true },
  { "autoelettricaperbambini.com", true },
  { "autoentrepreneurinfo.com", true },
  { "autoeshop.eu", true },
  { "autofficina.roma.it", true },
  { "autoglass.com.my", true },
  { "autohomehub.com", true },
  { "autoi.ch", true },
  { "autokeyinaustin.com", true },
  { "autokeyreplacementsanantonio.com", true },
  { "autoklub.cz", true },
  { "autokovrik-diskont.ru", true },
  { "autolawetawroclaw.pl", true },
  { "autoledky.sk", true },
  { "autolider.org", true },
  { "automacity.com", true },
  { "automagischeberegening.nl", true },
  { "automatethis.com.au", true },
  { "automatic.com", true },
  { "automationpro.me", true },
  { "automentesszolnok.hu", true },
  { "automotivegroup-usedcars.be", false },
  { "automotivemechanic.org", true },
  { "automuovifix.fi", true },
  { "automy.de", true },
  { "autonewssite.com", true },
  { "autonoleggio.milano.it", true },
  { "autoosijek.com", true },
  { "autopapo.com.br", true },
  { "autopark-ost-fichtner.de", true },
  { "autoparts.im", true },
  { "autoparts.sh", true },
  { "autoparts.wf", true },
  { "autoprice.info", false },
  { "autoproshouston.com", true },
  { "autorama.cf", true },
  { "autorando.com", true },
  { "autoreinigung-noack.de", true },
  { "autorepairseattle.com", true },
  { "autorijschooljohanbos.nl", true },
  { "autorijschoolrichardschut.nl", true },
  { "autorijschoolstorm.nl", true },
  { "autos-mertens.com", true },
  { "autosaan.ro", true },
  { "autoschadeschreuder.nl", true },
  { "autoschool.ga", true },
  { "autoscuola.roma.it", true },
  { "autoshinka72.ru", true },
  { "autoshopsolutions.com", true },
  { "autoshun.org", true },
  { "autoskola.hr", true },
  { "autoskolaplzen.cz", true },
  { "autoskole.hr", true },
  { "autospurghi.milano.it", true },
  { "autospurgo.com", true },
  { "autospurgo.it", true },
  { "autospurgo.milano.it", true },
  { "autostodulky.cz", true },
  { "autoteplo.org", true },
  { "autoterminus-used.be", false },
  { "autoto.hr", true },
  { "autotransportquoteservices.com", true },
  { "autotyreprest.ro", true },
  { "autouncle.at", true },
  { "autouncle.co.uk", true },
  { "autouncle.com", true },
  { "autouncle.de", true },
  { "autouncle.dk", true },
  { "autouncle.fi", true },
  { "autouncle.fr", true },
  { "autouncle.it", true },
  { "autouncle.pl", true },
  { "autouncle.pt", true },
  { "autouncle.ro", true },
  { "autouncle.se", true },
  { "autoverzekeringafsluiten.com", true },
  { "autovesti.cf", true },
  { "autowerkstatt-puchheim.de", true },
  { "autowise.dk", true },
  { "autres-talents.fr", true },
  { "autshir.com", true },
  { "auvidos.ru", true },
  { "aux-arts-de-la-table.com", true },
  { "auxiliame.com", true },
  { "auxille.com", true },
  { "av-yummy.com", true },
  { "av01.tv", true },
  { "ava-creative.de", false },
  { "ava-software.at", true },
  { "avaaz.org", true },
  { "avabouncehire.co.uk", true },
  { "avacariu.me", true },
  { "avaemr-development-environment.ca", true },
  { "avaeon.com", true },
  { "available.direct", true },
  { "availablecastles.com", true },
  { "avalon-island.ru", true },
  { "avalon-rpg.com", true },
  { "avalonbelltown.com", true },
  { "avalyuan.com", true },
  { "avancen.com", true },
  { "avanet.com", true },
  { "avangvpn.ga", true },
  { "avanovum.de", true },
  { "avantitualatin.com", true },
  { "avarcom.tk", true },
  { "avarty.com", true },
  { "avarty.net", true },
  { "avatardiffusion.com", true },
  { "avcd.cz", true },
  { "ave.zone", true },
  { "aveapps.com", false },
  { "aveclunettesoleil.fr", true },
  { "avedesk.org", false },
  { "avelinodiaz.gal", true },
  { "avengersonlinemovie.ga", true },
  { "aventurische-allianz.de", true },
  { "avenuedesbebes.com", true },
  { "avepol.cz", true },
  { "avepol.eu", true },
  { "averageinspired.com", true },
  { "averam.net", true },
  { "averen.co.uk", true },
  { "avernis.de", true },
  { "avexon.com", true },
  { "avi12.com", true },
  { "avia-krasnoyarsk.ru", true },
  { "avia-ufa.ru", true },
  { "aviasalon.spb.ru", true },
  { "aviationmilitaire.tk", true },
  { "aviationstrategies.aero", true },
  { "aviationstrategy.aero", true },
  { "aviationweather.gov", false },
  { "aviconverter.tk", true },
  { "avidmode-dev.com", true },
  { "avidmode-staging.com", true },
  { "avidmode.com", true },
  { "avinilo.com", true },
  { "avisofi-credit-immobilier.fr", true },
  { "aviteng.cloud", true },
  { "aviteng.com", true },
  { "avivaplasticsurgery.com", true },
  { "avlhostel.com", true },
  { "avm-multimedia.com", true },
  { "avmoo.com", true },
  { "avmrc.nl", true },
  { "avmup.com", true },
  { "avnet.ws", true },
  { "avocad.studio", true },
  { "avocode.com", true },
  { "avonture.be", true },
  { "avonvets.co.uk", true },
  { "avova.de", true },
  { "avpres.net", false },
  { "avptp.org", true },
  { "avqueen.cn", true },
  { "avrora-nov.ru", true },
  { "avsox.com", true },
  { "avtecmedia.com", true },
  { "avticket.ru", false },
  { "avtobania.pro", true },
  { "avtoforex.ru", true },
  { "avtogara-isperih.com", true },
  { "avtomarket.ru", true },
  { "avtosept.by", true },
  { "avtovokzaly.ru", true },
  { "avv.li", true },
  { "avvaterra.ch", true },
  { "avvcorda.com", false },
  { "avvocato.bologna.it", true },
  { "aw.gov.pl", true },
  { "aw.net", true },
  { "awangardaszkola.pl", true },
  { "awardplatform.com", true },
  { "awardsplatform.com", true },
  { "awaremi-tai.com", true },
  { "awaresec.com", true },
  { "awaresec.no", true },
  { "awarify.io", true },
  { "awarify.me", true },
  { "awaro.net", true },
  { "awaygroundguide.com", true },
  { "awbouncycastlehire.com", true },
  { "awesomebouncycastles.co.uk", true },
  { "awesomenamegenerator.com", true },
  { "awic.ca", true },
  { "awk.tw", true },
  { "awksolutions.com", true },
  { "awningcanopyus.com", true },
  { "awningsaboveus.com", true },
  { "awningsatlantaga.com", true },
  { "awningsydney.ga", true },
  { "awomansplacenj.com", true },
  { "awplasticsurgery.com", true },
  { "awsbs.de", true },
  { "awscloudrecipes.com", true },
  { "awsmdev.de", true },
  { "awsome-books.co.uk", true },
  { "awsumchan.org", true },
  { "awxg.com", true },
  { "ax25.org", true },
  { "axa.de", true },
  { "axault.com", true },
  { "axel-fischer.net", true },
  { "axel-voss.eu", true },
  { "axelname.ru", true },
  { "axelteichmann.net", true },
  { "axelvoss.eu", true },
  { "axin888.vip", true },
  { "axiodl.com", true },
  { "axiomeosteopathie.ca", true },
  { "axiomer.com", true },
  { "axishw.com", true },
  { "axispara-bg.com", true },
  { "axon-toumpa.gr", true },
  { "axone-computers.fr", false },
  { "axonholdingse.eu", true },
  { "axre.de", true },
  { "axrec.de", true },
  { "ay-net.jp", true },
  { "ayahya.me", false },
  { "ayanomimi.com", true },
  { "aycasac.com", true },
  { "aycomba.de", true },
  { "ayecode.ca", true },
  { "ayesh.me", true },
  { "aykutcevik.com", true },
  { "aylak.com", true },
  { "aylavblog.com", true },
  { "aylesburycastlehire.co.uk", true },
  { "aymerick-dupouey.fr", true },
  { "aymerick.fr", true },
  { "aymericlagier.com", true },
  { "ayothemes.com", true },
  { "ayporealestate.com", true },
  { "aypotech.com", true },
  { "ayrshirebouncycastlehire.co.uk", true },
  { "ayudacloud.com", true },
  { "ayudalabs.com", true },
  { "ayudapreview.com", true },
  { "ayumi.network", true },
  { "ayumindev.net", true },
  { "ayumix3.xyz", true },
  { "ayurveda-mantry.com", false },
  { "ayvalikgezgini.com", true },
  { "ayyz66.cc", true },
  { "az-moga.bg", true },
  { "az.net.au", true },
  { "az.search.yahoo.com", false },
  { "az1b2y3cx.com", true },
  { "azabani.com", true },
  { "azadliq.info", true },
  { "azarus.ch", true },
  { "azazy.net", false },
  { "azerinews.tk", true },
  { "azh-kunden.de", true },
  { "aziende.com.ar", true },
  { "azimut.fr", true },
  { "azithromycine.gq", true },
  { "azizvicdan.com", false },
  { "azlk-team.ru", true },
  { "azlocalbusiness.com", true },
  { "aznews.site", true },
  { "azora.cf", true },
  { "azort.com", true },
  { "azotobacter.nl", true },
  { "azpogomap.com", true },
  { "azrazalea.net", true },
  { "azrhymes.com", true },
  { "azsgeniedev.azurewebsites.net", true },
  { "azso.pro", true },
  { "azsupport.com", true },
  { "aztraslochi.it", true },
  { "aztrix.me", true },
  { "aztummytuck.com", true },
  { "azuki.cloud", true },
  { "azukie.com", true },
  { "azurecrimson.com", true },
  { "azuriasky.com", true },
  { "azuriasky.net", true },
  { "azuxul.fr", true },
  { "azzorti.com", true },
  { "azzurrapelletterie.it", true },
  { "b-b-law.com", true },
  { "b-cyclesshop.ch", false },
  { "b-honey.gr", true },
  { "b-performance.de", true },
  { "b-root-force.de", true },
  { "b-services.net", false },
  { "b-tree.be", true },
  { "b0000.co", true },
  { "b00228.com", false },
  { "b00de.ga", true },
  { "b0305.com", true },
  { "b0306.com", true },
  { "b0307.com", true },
  { "b0309.com", true },
  { "b03aa.com", true },
  { "b03bb.com", true },
  { "b03cc.com", true },
  { "b0hr.ai", true },
  { "b0k.org", true },
  { "b0rk.com", true },
  { "b1111.co", true },
  { "b131000.com", true },
  { "b1788.net", true },
  { "b1c1l1.com", true },
  { "b1nzy-pinged.me", true },
  { "b2bmuzikbank.com", true },
  { "b303.me", true },
  { "b36594.com", true },
  { "b4bouncycastles.co.uk", true },
  { "b4ckbone.de", true },
  { "b4lint.hu", true },
  { "b4z.eu", true },
  { "b58365.com", true },
  { "b58app.com", true },
  { "b58appb58app.com", true },
  { "b58appb58appb58app.com", true },
  { "b68.xyz", true },
  { "b70771.com", true },
  { "b70772.com", true },
  { "b70773.com", true },
  { "b70774.com", true },
  { "b70775.com", true },
  { "b70881.com", true },
  { "b70882.com", true },
  { "b70883.com", true },
  { "b70884.com", true },
  { "b70885.com", true },
  { "b72.com", true },
  { "b72.net", true },
  { "b7306.com", true },
  { "b73app.com", true },
  { "b73bb.com", true },
  { "b73dd.com", true },
  { "b73ee.com", true },
  { "b73ff.com", true },
  { "b767.net", true },
  { "b77018.com", false },
  { "b789.co", true },
  { "b81818.com", true },
  { "b83.tv", true },
  { "b83aa.com", true },
  { "b83bb.com", true },
  { "b83cc.com", true },
  { "b83dd.com", true },
  { "b83ee.com", true },
  { "b83ff.com", true },
  { "b83gg.com", true },
  { "b83hh.com", true },
  { "b83ii.com", true },
  { "b83jj.com", true },
  { "b83kk.com", true },
  { "b86255.com", true },
  { "b889b.com", true },
  { "b88vip2.com", true },
  { "b88vip3.com", true },
  { "b88vip4.com", true },
  { "b88vip5.com", true },
  { "b89bb.com", true },
  { "b89cc.com", true },
  { "b89dd.com", true },
  { "b89ee.com", true },
  { "b89ff.com", true },
  { "b89gg.com", true },
  { "b89hh.com", true },
  { "b89jj.com", true },
  { "b8a.me", true },
  { "b960.com", true },
  { "b9618.com", true },
  { "b979333.com", true },
  { "b979555.com", true },
  { "b979666.com", true },
  { "b979999.com", true },
  { "b99011.com", true },
  { "b99022.com", true },
  { "b99118.com", true },
  { "b99218.com", true },
  { "b99318.com", true },
  { "b99418.com", true },
  { "b99518.com", true },
  { "b99618.com", true },
  { "b99718.com", true },
  { "b99818.com", true },
  { "b99918.com", true },
  { "b9999ff.com", true },
  { "b9999hh.com", true },
  { "b9999ii.com", true },
  { "b9999jj.com", true },
  { "b9999ll.com", true },
  { "b9999mm.com", true },
  { "b9999nn.com", true },
  { "b9999pp.com", true },
  { "b9999qq.com", true },
  { "b9999ww.com", true },
  { "b9999zz.com", true },
  { "b99iosapp.com", true },
  { "ba47.net", true },
  { "baac-dewellmed.com", true },
  { "baalsworld.de", true },
  { "baanpingchan.com", true },
  { "baas-becking.biology.utah.edu", true },
  { "baazee.de", true },
  { "babacasino.net", true },
  { "babai.ru", true },
  { "babblenotes.com", true },
  { "babeleo.com", true },
  { "babounet.com", true },
  { "babsbibs.com", true },
  { "baby-bath-tub.com", true },
  { "baby-digne.com", false },
  { "babyboom.pl", true },
  { "babybuddah.ga", true },
  { "babycamapp.com", true },
  { "babyfotograf-schweiz.ch", true },
  { "babymasaze.cz", true },
  { "babyphototime.com", true },
  { "babypibu.com", true },
  { "bacanora.tk", true },
  { "bachata.info", true },
  { "baches-piscines.com", true },
  { "bachmannyachts.com", true },
  { "bachmatt-baar.ch", true },
  { "bachweid-baar.ch", true },
  { "baciu.ch", false },
  { "backeby.eu", true },
  { "background-checks-systems.com", true },
  { "background-checks.asia", true },
  { "background-checks.biz", true },
  { "background-checks.mobi", true },
  { "backgroundchecks.online", true },
  { "backgroundscreenersofamerica.com", true },
  { "backmitra.com", true },
  { "backmitra.mx", true },
  { "backmitra.nl", true },
  { "backmountaingas.com", true },
  { "backpacker.dating", true },
  { "backscattering.de", false },
  { "backschues.com", true },
  { "backschues.de", true },
  { "backschues.net", true },
  { "backseatbandits.com", true },
  { "backsideverbier.ch", false },
  { "backterris.com", true },
  { "backtest.org", true },
  { "backup-kurumsal.com", true },
  { "backupassist.de", true },
  { "backupcloud.ru", true },
  { "bacon-monitoring.org", true },
  { "baconismagic.ca", true },
  { "bacontreeconsulting.com", true },
  { "bacsmegye.hu", true },
  { "bactrim-antibiotic.ml", true },
  { "bacula.jp", true },
  { "bad.pet", true },
  { "badam.co", true },
  { "badanka.com", true },
  { "badanteinfamiglia.it", true },
  { "badaparda.com", true },
  { "badblock.fr", true },
  { "badcreditcarsfinance.co.uk", true },
  { "badedesign.no", true },
  { "badf00d.de", true },
  { "badgersystems.de", true },
  { "badges.fedoraproject.org", true },
  { "badges.stg.fedoraproject.org", true },
  { "badgirlsbible.com", true },
  { "badgr.io", true },
  { "badhusky.com", false },
  { "badkamermarkt.nl", true },
  { "badmania.fr", true },
  { "badmintonadvisor.com", true },
  { "badmintonbible.com", true },
  { "badodds.ga", true },
  { "badoo.com", true },
  { "badoo.de", true },
  { "badoo.eu", true },
  { "badoo.us", true },
  { "badrequest.me", true },
  { "badseacoffee.com", true },
  { "baeder-luboss.de", true },
  { "baer.im", true },
  { "baer.one", true },
  { "baer.space", true },
  { "bag.bg", true },
  { "bageez.us", true },
  { "bagelcraft.net", true },
  { "bageluncle.com", true },
  { "baggy.me.uk", true },
  { "bagheera.me.uk", true },
  { "baglu.com", false },
  { "bagnichimici.roma.it", true },
  { "bagsofbounce.co.uk", true },
  { "bagspecialist.nl", true },
  { "bagwrap.com", true },
  { "bah.im", false },
  { "bahaiprayers.io", true },
  { "bahana.net", true },
  { "bahnbonus-praemienwelt.de", true },
  { "bahnenimbild.de", true },
  { "bahnenimbild.eu", true },
  { "bahnhelden.de", true },
  { "bahninrotweissrot.at", true },
  { "bahnmagazine.de", true },
  { "bahrevaran.ir", true },
  { "baifubao.com", true },
  { "baiker.info", true },
  { "baildonbouncycastles.co.uk", true },
  { "baileebee.com", true },
  { "baileybae.com", true },
  { "bailleux.be", true },
  { "bailonga.com", true },
  { "baitcon.com", true },
  { "baiyu.blog", true },
  { "baiyu.me", true },
  { "baka-gamer.net", true },
  { "baka.net", true },
  { "baka.org.cn", true },
  { "bakermen.com", true },
  { "bakersafari.co", true },
  { "bakersfieldhomeoffer.com", true },
  { "bakerviewdentalcentre.com", true },
  { "bakeup.be", true },
  { "bakibal.com", true },
  { "bakingstone.com", true },
  { "bakkerinjebuurt.be", true },
  { "bakongcondo.com", true },
  { "balade-commune.ch", false },
  { "baladecommune.ch", false },
  { "balafon.cloud", true },
  { "balaganlimited.cf", true },
  { "balancascia.com.br", true },
  { "balance7.jp", true },
  { "balanceado.com", true },
  { "balancedbrawl.net", true },
  { "balancenaturalhealthclinic.ca", true },
  { "balaskas.gr", true },
  { "balboa.io", true },
  { "balboa.org.uk", true },
  { "balcaonet.com.br", true },
  { "balcarek.pl", true },
  { "balconnr.com", true },
  { "balconsverdun.com", false },
  { "baleen.us", true },
  { "balia.de", true },
  { "balicekzdravi.cz", false },
  { "balikonos.cz", true },
  { "balinese.dating", true },
  { "balist.es", true },
  { "balivillassanur.com", true },
  { "balkancrystals.com", true },
  { "balkonien.org", true },
  { "ball-bizarr.de", true },
  { "ball3d.es", true },
  { "ballarin.cc", true },
  { "ballast.tk", true },
  { "ballejaune.com", true },
  { "balletcenterofhouston.com", true },
  { "ballmerpeak.org", true },
  { "ballonsportclub-erlangen.de", true },
  { "ballotapi.com", true },
  { "ballothero.com", true },
  { "ballparkbuns.com", false },
  { "ballroom.info", true },
  { "balmeo.co.uk", true },
  { "balmofgilead.org.uk", true },
  { "baloch-intelligence.tk", true },
  { "balsamaiso.es", true },
  { "balslev.io", true },
  { "balter.com", true },
  { "balticer.de", true },
  { "balticmed.pl", true },
  { "balticnetworks.com", true },
  { "baltimorecashflow.com", true },
  { "bamahammer.com", true },
  { "bamanshop.com", true },
  { "bamboorelay.com", true },
  { "bambumania.com.br", true },
  { "bamily.rocks", true },
  { "bamtoki.com", true },
  { "ban.moe", true },
  { "bananabandy.com", true },
  { "bananacloud.fr", true },
  { "banananet.work", true },
  { "bananice.moe", true },
  { "bancacrs.it", true },
  { "bancastato.ch", true },
  { "bancobai.ao", true },
  { "bancoctt.pt", true },
  { "bancomap.ch", true },
  { "bancor.network", true },
  { "bancosdominicanos.net", true },
  { "bandagastrica.es", true },
  { "bandeira1.com.br", true },
  { "bandeiraimoveisitu.com.br", true },
  { "bandeirasnacionais.com", true },
  { "banderas-mundo.es", true },
  { "bandiere-mondo.it", true },
  { "bandiga.it", true },
  { "bandito.re", true },
  { "baneh-academic.com", true },
  { "banes.ch", true },
  { "bangdream.ga", true },
  { "bangkok-dark-night.com", true },
  { "bangkok.dating", true },
  { "bangkokcity.de", true },
  { "bangkokcookingclass.com", true },
  { "banglarfont.com", true },
  { "banglets.com", true },
  { "bangorfederal.com", true },
  { "banguilacoquette.com", true },
  { "bangumi.co", true },
  { "bangyu.wang", true },
  { "banham.co.uk", false },
  { "banham.com", true },
  { "banjostringiz.com", true },
  { "bank-yahav.co.il", true },
  { "bank.barclays.co.uk", true },
  { "bank.simple.com", false },
  { "banka.space", true },
  { "bankanswers.gov", true },
  { "bankapp.se", true },
  { "bankbranchlocator.com", true },
  { "bankcardoffer.com", true },
  { "bankcircle.co.in", true },
  { "bankee.us", true },
  { "banketbesteld.nl", true },
  { "bankheadvegetables.com", true },
  { "bankin.com", true },
  { "bankinter.pt", true },
  { "bankio.se", true },
  { "banknet.gov", true },
  { "bankofdenton.com", true },
  { "bankpolicies.com", true },
  { "bankruptcy.ky", true },
  { "banksaround.com", true },
  { "banksiaparkcottages.com.au", true },
  { "bankstownapartments.com.au", true },
  { "bankvanbreda.be", true },
  { "banned-bitches.tk", true },
  { "bannermarquees.ie", true },
  { "bannsecurity.com", true },
  { "banquevanbreda.be", true },
  { "bantaihost.com", true },
  { "baofengtech.com", true },
  { "baokhangfood.com", true },
  { "baopublishing.it", true },
  { "baptisteplanckaert.tk", true },
  { "bar-harcourt.com", true },
  { "bar.pl", true },
  { "barabrume.fr", true },
  { "barakayu.com", true },
  { "barans2239.com", true },
  { "baranyavar.hu", true },
  { "barao.tk", true },
  { "baravalle.com", true },
  { "baraxolka.ru", true },
  { "barbaderespeito.com.br", true },
  { "barbara-fuchs-gruene-fuerth.de", true },
  { "barbarabowersrealty.com", true },
  { "barbarafabbri.com", true },
  { "barbarafeldman.com", true },
  { "barbarians.com", false },
  { "barbate.fr", true },
  { "barbe-n-blues.fr", true },
  { "barbiere.it", true },
  { "barbu.family", true },
  { "barburas.com", true },
  { "barca-movie.jp", true },
  { "barcamp.koeln", true },
  { "barcel.com.mx", true },
  { "barcelonabagels.cat", true },
  { "barcelonapremium.es", true },
  { "barcelonapremiummini.es", true },
  { "barcelonawinewalk.com", true },
  { "barclays.net", true },
  { "barcoderealty.com", true },
  { "bardes.org", true },
  { "bardiharborow.com", true },
  { "bardiharborow.tk", true },
  { "baresquare.com", true },
  { "barganhanaweb.ml", true },
  { "bariatrica.es", true },
  { "bariatricsurgerysmg.com", true },
  { "bariseau-mottrie.be", false },
  { "barisi.me", true },
  { "baristador.com", true },
  { "barkerjr.xyz", true },
  { "barlotta.net", true },
  { "barnel.com", true },
  { "barnettville.com", true },
  { "barneveldcentrum.nl", true },
  { "barneydavey.com", true },
  { "barnflix.net", true },
  { "barnfotografistockholm.se", true },
  { "barnhardt4berks.com", true },
  { "barnvets.co.uk", true },
  { "baroloboys.de", true },
  { "baron14.be", true },
  { "baronspices.com", true },
  { "barpodsosnami.pl", true },
  { "barracuda.com.tr", true },
  { "barrera.io", true },
  { "barriofut.com", true },
  { "barrydenicola.com", true },
  { "bars.kh.ua", true },
  { "barsashop.com.br", true },
  { "barsgroup.com", true },
  { "bart-f.com", true },
  { "barta.me", true },
  { "bartbania.com", true },
  { "bartelt.name", true },
  { "barter4crypto.com", true },
  { "barth.services", true },
  { "bartkramer.nl", false },
  { "bartlamboo.nl", true },
  { "bartolomebellido.com", true },
  { "bartula.de", true },
  { "bartzutow.xyz", true },
  { "baruch.me", true },
  { "bas.co.jp", true },
  { "bascht.com", true },
  { "base-autonome-durable.com", false },
  { "basebalance.net", true },
  { "baseballrampage.com", true },
  { "baseballsavings.com", true },
  { "baseballwarehouse.com", true },
  { "baseconvert.com", true },
  { "baseerapp.com", true },
  { "baselang.com", true },
  { "basement961.co.nz", true },
  { "basementdoctornorthwest.com", true },
  { "basementfinishingohio.com", true },
  { "basementwaterproofingdesmoines.com", true },
  { "baserverz.ga", true },
  { "baseweb.design", true },
  { "bashing-battlecats.com", true },
  { "bashkirlife.tk", true },
  { "bashstreetband.co.uk", true },
  { "basicamente.digital", true },
  { "basicapparel.de", true },
  { "basicattentiontoken.org", true },
  { "basics.net", true },
  { "basketball-brannenburg.de", true },
  { "basketforex.com", true },
  { "basnoslovno.ru", true },
  { "basonlinemarketing.nl", true },
  { "basradio.tk", true },
  { "bass-pro.ru", true },
  { "bassblog.net", true },
  { "bassment.ph", true },
  { "bassresource.com", true },
  { "bassrhymeposse.tk", true },
  { "bassrider.eu", true },
  { "bassys.com.co", true },
  { "bastelzauberwelt.de", true },
  { "bastide-viens.com", true },
  { "bastolino.de", true },
  { "basw.eu", true },
  { "baswag.de", true },
  { "baswetter.photography", true },
  { "basyspro.net", true },
  { "batcave.tech", true },
  { "batch.com", true },
  { "batch.engineering", true },
  { "baterioverolety.cz", true },
  { "bati-alu.fr", true },
  { "batiburrillo.net", true },
  { "batipresta.ch", false },
  { "batiskaf.ua", true },
  { "batistareisfloresonline.com.br", true },
  { "batitrakya.org", true },
  { "batlab.ch", false },
  { "batolis.com", true },
  { "batook.org", true },
  { "batteryboys.ca", true },
  { "batteryboys.com", true },
  { "batterystaple.pw", true },
  { "battle-game.com", true },
  { "battleboxx.com", false },
  { "battleground.com.au", true },
  { "battleguard.net", true },
  { "batuhanbensoy.com.tr", true },
  { "bauer.network", false },
  { "bauernmarkt-fernitz.at", true },
  { "baufi24.de", true },
  { "baugeldspezi.de", true },
  { "baugelitt.eu", true },
  { "baugemeinschaftbernstein.de", true },
  { "bauingenieur24.de", true },
  { "baumannfabrice.com", true },
  { "baumkuchen-aus-dresden.de", true },
  { "baur.de", true },
  { "bausep.de", true },
  { "bauthier-occasions.be", false },
  { "bautied.de", true },
  { "bauunternehmen-herr.de", true },
  { "bavarianhiker.de", true },
  { "bavaroparadise.com", true },
  { "bavarovillage.com", true },
  { "bavartec.de", true },
  { "bawbby.com", true },
  { "bayareaenergyevents.com", true },
  { "baychimo.com", true },
  { "bayden.com", true },
  { "bayer-stefan.com", true },
  { "bayer-stefan.de", true },
  { "bayerhazard.de", true },
  { "bayerstefan.com", true },
  { "bayerstefan.de", true },
  { "bayerstefan.eu", true },
  { "bayherbalist.com", true },
  { "bayilelakiku.com", true },
  { "bayltd.com", true },
  { "bayly.eu", true },
  { "baymard.com", true },
  { "bayoleth.com", true },
  { "bayportbotswana.com", true },
  { "bayportghana.com", true },
  { "bayporttanzania.com", true },
  { "bayportuganda.com", true },
  { "baypromoteam.co.uk", true },
  { "bayraklar.info", true },
  { "baystreet.com.mt", true },
  { "baytalebaa.com", true },
  { "baytownent.com", true },
  { "baywatch.io", true },
  { "bayz.de", true },
  { "baza-gai.com.ua", true },
  { "bazaarbhaav.com", true },
  { "bazaarcompass.com", true },
  { "bazari.com.pl", true },
  { "bazinga-events.nl", true },
  { "bazos.at", true },
  { "bazos.cz", true },
  { "bazos.pl", true },
  { "bazos.sk", true },
  { "bazziergraphik.com", true },
  { "bb057.com", true },
  { "bb087.com", true },
  { "bb168.cc", true },
  { "bb882.com", true },
  { "bbalposticino.it", true },
  { "bbbff.net", true },
  { "bbc67.fr", true },
  { "bbcastles.com", true },
  { "bbcomcdn.com", true },
  { "bbgeschenke.ch", false },
  { "bbimarketing.com", true },
  { "bbinsure.com", true },
  { "bbka.org.uk", true },
  { "bbkworldwide.jp", true },
  { "bbld.de", true },
  { "bblove.me", true },
  { "bblsa.ch", false },
  { "bbnx.net", true },
  { "bbs8080.net", true },
  { "bbsec.xyz", true },
  { "bbuio.com", false },
  { "bbw.dating", true },
  { "bbwcs.co.uk", true },
  { "bbyouthco.com", true },
  { "bc-bd.org", false },
  { "bc-diffusion.com", true },
  { "bcansw.com.au", true },
  { "bcbulle.ch", false },
  { "bcdiesel.ca", true },
  { "bcdonadio.com", true },
  { "bcdonadio.com.br", true },
  { "bcdonadio.org", true },
  { "bceventhire.co.uk", true },
  { "bch7al.ma", false },
  { "bchep.com", true },
  { "bck-koethen.de", true },
  { "bck-lelystad.nl", true },
  { "bckaccompressoroz.com", true },
  { "bclogandtimberbuilders.com", true },
  { "bclrk.us", true },
  { "bcmainland.ca", true },
  { "bcmguide.com", true },
  { "bcmhire.co.uk", true },
  { "bcrook.com", true },
  { "bcswampcabins.com", true },
  { "bd-media.tk", true },
  { "bd2positivo.com", true },
  { "bda-boulevarddesairs.com", false },
  { "bdbxml.net", true },
  { "bdd.fi", true },
  { "bdikaros-network.net", true },
  { "bdpestsolutionsstlouis.com", true },
  { "bdtopshop.com", true },
  { "be-a-password.ninja", true },
  { "be-ka-tec.de", true },
  { "be-real.life", false },
  { "be-up-developpement.com", true },
  { "be-webdesign.com", true },
  { "be.search.yahoo.com", false },
  { "be2cloud.de", true },
  { "be4lead.com", true },
  { "bea.gov", true },
  { "beacham.online", true },
  { "beachcitycastles.com", true },
  { "beachmarketing.co.uk", true },
  { "beachpoint.tk", true },
  { "beadare.com", true },
  { "beadare.nl", true },
  { "beaglesecurity.com", true },
  { "bealpha.pl", true },
  { "beambdi.com", true },
  { "beanbagaa.com", true },
  { "beanilla.com", true },
  { "beanjuice.me", true },
  { "beansgalore.com.au", true },
  { "bearcms.com", true },
  { "bearded.sexy", true },
  { "beardic.cn", true },
  { "beardsome.me", true },
  { "beargoggleson.com", true },
  { "bearingworks.com", true },
  { "bearlakelife.com", true },
  { "beastiejob.com", true },
  { "beastowner.li", true },
  { "beatfeld.de", true },
  { "beatnikbreaks.com", true },
  { "beatrice-nightscout.herokuapp.com", true },
  { "beatrice-raws.org", true },
  { "beatrizaebischer.ch", false },
  { "beatuprobot.net", true },
  { "beau.pw", true },
  { "beaumelcosmetiques.fr", true },
  { "beaute-eternelle.ch", false },
  { "beauty-expert.co", true },
  { "beauty-form.ir", true },
  { "beauty-italy.ru", true },
  { "beauty24.de", true },
  { "beautyandfashionadvice.com", true },
  { "beautybear.dk", true },
  { "beautybh.com", true },
  { "beautycarepack.com.ng", true },
  { "beautyevent.fr", true },
  { "beautyinweb.net", true },
  { "beautykat.ru", true },
  { "beautyseasons.ru", true },
  { "beaver-creek.ga", true },
  { "beaverdamautos.com", true },
  { "beavertales.ca", true },
  { "bebe2luxe.es", true },
  { "bebe2luxe.fr", true },
  { "bebef.de", true },
  { "bebefofuxo.com.br", true },
  { "bebes.uno", true },
  { "bebest.gov", false },
  { "beboldpr.com", true },
  { "beckenhamcastles.co.uk", true },
  { "beckerantiques.com", true },
  { "beckijayes.family", true },
  { "beckyhirstconsulting.com.au", true },
  { "becleverwithyourcash.com", true },
  { "become-lucky.com", true },
  { "becomeabricklayer.com.au", true },
  { "becquerelgroup.com", true },
  { "becs.ch", false },
  { "becydog.cz", true },
  { "bedamedia.com", true },
  { "bedandbreakfast.dk", true },
  { "bedandbreakfasteuropa.com", true },
  { "bedandbreakfasthoekvanholland.com", true },
  { "beddentotaal.nl", true },
  { "bedels.nl", true },
  { "bednar.co", true },
  { "bedrocklinux.org", true },
  { "bedste10.dk", true },
  { "bee-creative.nl", true },
  { "bee-line.org.uk", true },
  { "bee-removal-dublin.com", true },
  { "beehive.govt.nz", true },
  { "beehive42.com", true },
  { "beehive42.eu", true },
  { "beehive42.net", true },
  { "beehive42.nl", true },
  { "beehive42.org", true },
  { "beehosting.pro", true },
  { "beeksnetwork.nl", true },
  { "beelen.fr", true },
  { "beelit.com", true },
  { "beeming.net", true },
  { "beer9.com", true },
  { "beercandle.com", true },
  { "beercast.co.uk", true },
  { "beeremovalspretoria.co.za", true },
  { "beergazetteer.com", true },
  { "beerians.com", true },
  { "beerjet.bg", true },
  { "beerjet.cz", true },
  { "beerjet.ro", true },
  { "beerjet.sk", true },
  { "beerjetcz.cz", true },
  { "beerly.eu", true },
  { "beers.my", true },
  { "beersconf.com", true },
  { "beestation13.com", true },
  { "beeswarmrehoming.com.au", true },
  { "beeswax-orgone.com", true },
  { "beethoveninlove.com", true },
  { "beetman.net", true },
  { "beeutifulparties.co.uk", true },
  { "beexfit.com", false },
  { "beezkneezcastles.co.uk", true },
  { "beeznest.com", true },
  { "befoodsafe.gov", true },
  { "beforesunrise.de", true },
  { "beforeyoueatoc.com", true },
  { "beframed.ch", false },
  { "befreewifi.info", true },
  { "befundonline.de", true },
  { "begabungsfoerderung.info", true },
  { "begbie.com", true },
  { "beginner.nl", true },
  { "begintravel.co.th", true },
  { "beginwp.top", true },
  { "behamepresrdce.sk", true },
  { "behamzdarma.cz", true },
  { "behar-selimi.tk", true },
  { "behead.de", true },
  { "beherit.pl", true },
  { "behindertenagentur.de", true },
  { "behna24hodin.cz", true },
  { "behoerden-online-dienste.de", true },
  { "behoreal.cz", true },
  { "bei18.com", true },
  { "beichtgenerator.de", true },
  { "beijesweb.nl", true },
  { "beijing.dating", true },
  { "beijinglug.club", true },
  { "beimchristoph.de", true },
  { "beinad.com", true },
  { "beinad.ru", true },
  { "beisance.com", true },
  { "bejarano.io", true },
  { "bekolite.com", true },
  { "belacapa.com.br", true },
  { "belanglos.de", true },
  { "belani.eu", true },
  { "belanja.express", true },
  { "belarto.be", true },
  { "belarto.de", true },
  { "belarto.es", true },
  { "belarto.fr", true },
  { "belarto.it", true },
  { "belarto.nl", true },
  { "belarto.pl", true },
  { "belastingmiddeling.nl", true },
  { "belavis.com", true },
  { "belebey.city", true },
  { "beleggingspanden-financiering.nl", true },
  { "belegit.org", true },
  { "belezashopping.com.br", true },
  { "belfastbounce.co.uk", true },
  { "belfastlocks.com", true },
  { "belfasttechservices.co.uk", true },
  { "belfor-probleme.de", true },
  { "belfordroxo.net.br", true },
  { "belge.rs", true },
  { "belgers.com", true },
  { "belgicaservices.be", true },
  { "belgraver.email", true },
  { "belgraver.eu", true },
  { "belgraver.xyz", true },
  { "belhopro.be", true },
  { "belics.com", true },
  { "belien-tweedehandswagens.be", false },
  { "believablebook.com", false },
  { "believersweb.org", true },
  { "bell.id.au", true },
  { "bella.network", true },
  { "bellaklein.de", true },
  { "bellamodeling.com", true },
  { "bellebakes.blog", true },
  { "bellevueowners.tk", true },
  { "bellezzasenzalimiti.it", true },
  { "bellinghamdetailandglass.com", true },
  { "belloy.ch", false },
  { "belloy.net", false },
  { "bellware.io", false },
  { "belly-button-piercings.com", true },
  { "bellyandbrain.amsterdam", true },
  { "belmontgoessolar.org", true },
  { "belos.at", true },
  { "belouga.org", true },
  { "belquant.cf", true },
  { "beltar.nl", true },
  { "belvoirbouncycastles.co.uk", true },
  { "bembee.tk", true },
  { "bemcorp.de", true },
  { "bemindly.com", true },
  { "bemsoft.pl", true },
  { "ben-energy.com", false },
  { "ben2.co.il", true },
  { "benabrams.it", true },
  { "benary.org", true },
  { "benatherton.com", true },
  { "benazir-reaction.tk", true },
  { "benbalter.com", true },
  { "benbozsa.ca", true },
  { "benc.io", true },
  { "benceskorka.com", true },
  { "benchling.com", true },
  { "benchmarkmonument.com", true },
  { "benchstoolo.com", true },
  { "bencorby.com", true },
  { "bendemaree.com", true },
  { "bendingtheending.com", true },
  { "bendix.co", true },
  { "bendostore.com", true },
  { "bendyworks.com", true },
  { "beneathvt.com", true },
  { "benedict-balzer.de", true },
  { "benediktgeissler.de", true },
  { "benefits.gov", true },
  { "benefitshub.io", true },
  { "benefitshub.xyz", true },
  { "benepiscinas.com.br", true },
  { "beneri.se", true },
  { "benetcasablancas.tk", true },
  { "benewpro.com", true },
  { "bengalurugifts.com", true },
  { "bengisureklam.com", true },
  { "benhaney.com", true },
  { "benhartmann.de", true },
  { "benhavenarchives.org", true },
  { "benjamin-hering.com", true },
  { "benjamin-mary.herokuapp.com", true },
  { "benjamin.pe", true },
  { "benjaminblack.net", true },
  { "benjamindietrich.com", true },
  { "benjamindietrich.de", true },
  { "benjaminjurke.com", true },
  { "benjaminkopelke.com", true },
  { "benjamins.com", true },
  { "benjaminvasel.de", true },
  { "benjii.me", true },
  { "benjijaldoner.nl", true },
  { "benmatthews.com.au", true },
  { "benmillett.us", false },
  { "bennettsbouncycastlehire.co.uk", true },
  { "bennettshire.co.uk", true },
  { "benni1.eu", true },
  { "bennierobinson.com", true },
  { "benno.frl", true },
  { "bennygommers.nl", true },
  { "benriya.shiga.jp", true },
  { "bensbouncycastles.co.uk", true },
  { "benschnarr.com", true },
  { "benscobie.com", true },
  { "benshoof.org", true },
  { "bensinflatables.co.uk", true },
  { "bensokol.com", true },
  { "bensoy.com", true },
  { "benstevinson.com", true },
  { "bentertain.de", true },
  { "bentinata.com", true },
  { "bentley.blog", true },
  { "bentley.link", true },
  { "bentongroup.co.uk", true },
  { "bentonweatherstone.co.uk", true },
  { "bentrask.com", true },
  { "benu.cz", true },
  { "benvds.com", true },
  { "benz-hikaku.com", true },
  { "benzi.io", true },
  { "benzina.cn", true },
  { "beoordelingen.be", true },
  { "bepayd.com", true },
  { "bephoenix.org.uk", false },
  { "beplephan.com", true },
  { "bequ1ck.com", true },
  { "bequiia.com", true },
  { "beranovi.com", true },
  { "beraten-entwickeln-steuern.de", true },
  { "berati.tv", true },
  { "beratungswelt.dvag", true },
  { "berdu.id", true },
  { "bereaplumber.co.za", true },
  { "bereginy.com.ua", true },
  { "berend.tk", true },
  { "bergenhave.nl", true },
  { "berger-chiro.com", true },
  { "bergevoet-fa.nl", false },
  { "bergfex.at", true },
  { "bergfex.com", true },
  { "berglust-pur.de", true },
  { "bergmanbeachproperties.com", true },
  { "bergstoneware.com", true },
  { "berichtsheft-vorlage.de", true },
  { "berikod.ru", true },
  { "beritanow.tk", true },
  { "berkat-luqs.ddns.net", true },
  { "berksabstract.com", true },
  { "berksarl.org", true },
  { "berksnetworking.com", true },
  { "berlin-flirt.de", true },
  { "berlin.dating", true },
  { "bermeitinger.eu", true },
  { "bermytraq.bm", true },
  { "bernadetteanderes.ch", false },
  { "bernar.do", true },
  { "bernardcontainers.be", false },
  { "bernarddickens.com", true },
  { "bernardez-photo.com", true },
  { "bernardgo.com", true },
  { "bernardo.fm", true },
  { "bernat.ch", true },
  { "bernat.im", true },
  { "bernbrucher.com", true },
  { "bernbrucher.de", true },
  { "bernd-leitner-fotodesign.com", true },
  { "bernd-leitner-fotodesign.de", true },
  { "bernd-leitner.de", true },
  { "berndbousard.com", true },
  { "berndklaus.at", true },
  { "bernexskiclub.ch", true },
  { "bernhard-seidenspinner.de", true },
  { "bernhardkau.de", true },
  { "bernhardluginbuehl.ch", true },
  { "bernhardluginbuehl.com", true },
  { "bernieware.de", true },
  { "bernmail.ch", true },
  { "bernyweb.net", true },
  { "berra.se", true },
  { "berruezoabogados.com", true },
  { "berrus.com", true },
  { "berrypay.com", true },
  { "bersotavocats.fr", false },
  { "berst.cz", true },
  { "berthabailey.com", true },
  { "bertholdsson.com", true },
  { "bertold.org", true },
  { "bertoliniodontoiatria.it", true },
  { "bertrand.bio", true },
  { "bertrandkeller.info", true },
  { "bertsmithvwparts.com", true },
  { "beryl.net", true },
  { "bescoutednow.com", true },
  { "bescover.com", true },
  { "besensi.com", true },
  { "beserberg.tk", true },
  { "besole.ch", true },
  { "bespokebathrooms.com.au", true },
  { "bespokemortgages.co.uk", true },
  { "bespokestraps.com", true },
  { "best-accounting-schools.com", true },
  { "best-art-colleges.com", true },
  { "best-baptist-colleges.com", true },
  { "best-beauty-schools.com", true },
  { "best-book.gq", true },
  { "best-business-colleges.com", true },
  { "best-catholic-colleges.com", true },
  { "best-community-colleges.com", true },
  { "best-culinary-colleges.com", true },
  { "best-education-schools.com", true },
  { "best-engineering-colleges.com", true },
  { "best-essay-service.com", true },
  { "best-graduate-programs.com", true },
  { "best-hvac-schools.com", true },
  { "best-lutheran-colleges.com", true },
  { "best-management-schools.com", true },
  { "best-marketing-schools.com", true },
  { "best-music-colleges.com", true },
  { "best-nursing-colleges.com", true },
  { "best-pharmacy-schools.com", true },
  { "best-tickets.co.uk", true },
  { "best-trucking-schools.com", true },
  { "best-wallpaper.net", true },
  { "best10websitebuilders.com", true },
  { "best2pay.net", true },
  { "best66.me", true },
  { "bestattungen-kammerer.de", true },
  { "bestattungshaus-kammerer.de", true },
  { "bestautoinsurance.com", true },
  { "bestbatteriesonline.com", true },
  { "bestbefore.com", true },
  { "bestboot.cf", true },
  { "bestbrokerindia.com", true },
  { "bestbuyzone.com", true },
  { "bestbyte.com.br", true },
  { "bestcarscyprus.com", true },
  { "bestcivilattorneys.com", true },
  { "bestdating.today", true },
  { "bestdownloadscenter.com", true },
  { "bestechgadgets.tk", true },
  { "bestedeal.nl", true },
  { "bestehostingproviders.nl", true },
  { "bestessaycheap.com", true },
  { "bestessayhelp.com", true },
  { "bestfotostudio.com", true },
  { "bestfriendsequality.org", true },
  { "bestgearlist.com", true },
  { "bestgiftever.ca", true },
  { "besthemes.tk", true },
  { "besti.it", true },
  { "bestinbarter.com", true },
  { "bestinshowing.com", true },
  { "bestinver.es", false },
  { "bestjumptrampolines.be", true },
  { "bestkenmoredentists.com", true },
  { "bestmedsmmj.com", true },
  { "bestmotherfucking.website", true },
  { "bestofbooks.gq", true },
  { "bestoliveoils.com", true },
  { "bestpartyhire.com", true },
  { "bestpig.fr", true },
  { "bestplumbing.com", true },
  { "bestporngirls.com", true },
  { "bestpractice.domains", true },
  { "bestprint.vn", true },
  { "bestproductsaudit.com", true },
  { "bestroofbox.com", true },
  { "bestshoesmix.com", true },
  { "bestsingingbowls.com", true },
  { "besttrade.tk", true },
  { "bestwarezone.com", true },
  { "bestwebcams.ml", true },
  { "bestwebsite.gallery", true },
  { "bet01vip.com", true },
  { "bet02vip.com", true },
  { "bet03vip.com", true },
  { "bet04vip.com", true },
  { "bet05vip.com", true },
  { "bet062.com", true },
  { "bet064.com", true },
  { "bet074.com", true },
  { "bet10vip.com", true },
  { "bet261.com", true },
  { "bet290.com", true },
  { "bet333111.com", true },
  { "bet333123.com", true },
  { "bet333222.com", true },
  { "bet333345.com", true },
  { "bet333444.com", true },
  { "bet333456.com", true },
  { "bet333555.com", true },
  { "bet333567.com", true },
  { "bet333666.com", true },
  { "bet333678.com", true },
  { "bet333789.com", true },
  { "bet333999.com", true },
  { "bet333h.com", true },
  { "bet333i.com", true },
  { "bet333j.com", true },
  { "bet333k.com", true },
  { "bet333l.com", true },
  { "bet333n.com", true },
  { "bet333o.com", true },
  { "bet333p.com", true },
  { "bet333q.com", true },
  { "bet333r.com", true },
  { "bet333s.com", true },
  { "bet333t.com", true },
  { "bet333u.com", true },
  { "bet333v.com", true },
  { "bet333w.com", true },
  { "bet333x.com", true },
  { "bet333y.com", true },
  { "bet333z.com", true },
  { "bet3602.com", true },
  { "bet3607.com", true },
  { "bet3639.com", true },
  { "bet365cn-casino.com", true },
  { "bet365cn-game.com", true },
  { "bet365cn-keno.com", true },
  { "bet365cn-livecasino.com", true },
  { "bet365cn-poker.com", true },
  { "bet365cn-sports.com", true },
  { "bet365cn-vegas.com", true },
  { "bet365cnq.com", true },
  { "bet365cnr.com", true },
  { "bet365cns.com", true },
  { "bet365cnt.com", true },
  { "bet365cnu.com", true },
  { "bet365cnv.com", true },
  { "bet365cnw.com", true },
  { "bet365cnx.com", true },
  { "bet365cny.com", true },
  { "bet365cnz.com", true },
  { "bet365u.com", true },
  { "bet44401.com", true },
  { "bet44402.com", true },
  { "bet44403.com", true },
  { "bet44404.com", true },
  { "bet44405.com", true },
  { "bet44406.com", true },
  { "bet44407.com", true },
  { "bet44409.com", true },
  { "bet44410.com", true },
  { "bet444400.com", true },
  { "bet444401.com", true },
  { "bet444402.com", true },
  { "bet444403.com", true },
  { "bet444404.com", true },
  { "bet444405.com", true },
  { "bet444406.com", true },
  { "bet444407.com", true },
  { "bet444408.com", true },
  { "bet444409.com", true },
  { "bet444410.com", true },
  { "bet444421.com", true },
  { "bet444422.com", true },
  { "bet444423.com", true },
  { "bet444424.com", true },
  { "bet444425.com", true },
  { "bet444426.com", true },
  { "bet444427.com", true },
  { "bet444428.com", true },
  { "bet444429.com", true },
  { "bet444430.com", true },
  { "bet5678.cc", true },
  { "bet5678.com", true },
  { "bet5678a.com", true },
  { "bet5678b.com", true },
  { "bet5678c.com", true },
  { "bet5678e.com", true },
  { "bet5678f.com", true },
  { "bet5678g.com", true },
  { "bet599.com", true },
  { "bet66669999.com", true },
  { "bet666888.vip", true },
  { "bet721.com", true },
  { "bet819.com", true },
  { "bet820.com", true },
  { "betaal.my", true },
  { "betaclouds.net", true },
  { "betaprofiles.com", true },
  { "betaworx.de", true },
  { "betaworx.eu", true },
  { "betb73.com", true },
  { "betcn-mart.com", true },
  { "betecnet.de", true },
  { "bethanyduke.com", true },
  { "bethanypeds.com", true },
  { "betheredge.us", true },
  { "bethpage.net", true },
  { "beticalia.com", true },
  { "betimely.com", true },
  { "betmobilenigeria.com", true },
  { "betobaccofree.gov", true },
  { "betonbit.com", true },
  { "betonmarkets.info", true },
  { "betor.cz", true },
  { "betpamm.com", true },
  { "betrifft-mich-dsgvo.ch", true },
  { "bets.gg", true },
  { "betseybuckheit.com", true },
  { "betsharpangles.com", true },
  { "betshoot.com", true },
  { "betsyshilling.com", true },
  { "bett1.de", true },
  { "bettaline.com.au", true },
  { "bettashoerepairs.com.au", true },
  { "better-bounce.co.uk", true },
  { "better.fyi", true },
  { "bettercareclinic.co.uk", true },
  { "bettercleaningcompany.co.uk", true },
  { "betterconsult.com", true },
  { "bettercrypto.org", true },
  { "betterna.me", true },
  { "betterscience.org", true },
  { "bettersecurity.co", true },
  { "betterselfbetterworld.cz", true },
  { "bettersocialmedia.co.uk", true },
  { "bettertechinterviews.com", true },
  { "bettertest.it", true },
  { "bettertime.de", true },
  { "bettertime.jetzt", true },
  { "betterweb.fr", true },
  { "betterworldinternational.org", true },
  { "bettflaschen.ch", true },
  { "bettingbusiness.ru", true },
  { "bettingsider.dk", true },
  { "bettmer.at", true },
  { "bettmer.de", true },
  { "bettolinokitchen.com", true },
  { "bettrlifeapp.com", true },
  { "betty-baloo.com", true },
  { "bettyweber.com", true },
  { "betulashop.ch", true },
  { "betwalker.com", true },
  { "beulen.email", true },
  { "beulen.link", true },
  { "beulen.pro", true },
  { "beuteugeu.com", true },
  { "bevallarta.com", true },
  { "bevedo.cz", true },
  { "bevedo.sk", true },
  { "beveiligingscamerawestland.nl", true },
  { "bevelbeer.com", true },
  { "bevelpix.com", true },
  { "beverhof.nl", true },
  { "beverlyinternational.com", true },
  { "bevhills.com", true },
  { "bevinco2020.com", true },
  { "bevnut.com", true },
  { "bewegigsruum.ch", true },
  { "bewegtes-lagern.at", true },
  { "bewegtes-lagern.ch", true },
  { "bewegtes-lagern.com", true },
  { "bewegtes-lagern.de", true },
  { "bewegteslagern.ch", true },
  { "bewegteslagern.com", true },
  { "bewegteslagern.de", true },
  { "bewegungsfluss.com", false },
  { "bewerbungsfibel.de", true },
  { "bewertet.de", true },
  { "bewonderen.com", true },
  { "bexleycastles.co.uk", true },
  { "beybiz.com", true },
  { "beyerautomation.com", true },
  { "beyerm.de", true },
  { "beyond-infinity.org", false },
  { "beyondalderaan.net", true },
  { "beyondbounce.co.uk", true },
  { "beyondboxgifts.com", true },
  { "beyondordinarylife.com", true },
  { "beyondpricing.com", true },
  { "beyondtodaymediagroup.com", true },
  { "beyondweb.net", true },
  { "beyours.be", true },
  { "bez-energie.de", true },
  { "bezahlbare-praemien.ch", true },
  { "bezemkast.nl", true },
  { "bezlampowe.pl", true },
  { "bezlepkovamatka.cz", true },
  { "bezpecnostsiti.cf", true },
  { "bezposrednio.net.pl", true },
  { "bezzia.com", true },
  { "bf5.ru", true },
  { "bfam.tv", true },
  { "bfanis.ir", true },
  { "bfcgermania88.de", true },
  { "bfem.gov", true },
  { "bfh.science", true },
  { "bfkcloud.ddns.net", true },
  { "bfob.gg", true },
  { "bforb.sk", true },
  { "bfp-mail.de", true },
  { "bfpg.org", true },
  { "bfw-online.de", true },
  { "bgbaby.net", true },
  { "bgemi.net", true },
  { "bgfashion.net", true },
  { "bgfix.se", true },
  { "bgfoto.info", true },
  { "bghost.xyz", true },
  { "bgkoleda.bg", true },
  { "bglsingles.de", true },
  { "bgmn.me", true },
  { "bgp.space", true },
  { "bgr34.cz", true },
  { "bgs-game.com", true },
  { "bgtgames.com", true },
  { "bgtoyou.com", true },
  { "bguidinger.com", true },
  { "bh-oberland.de", true },
  { "bh.sb", true },
  { "bharath-g.in", true },
  { "bhat.vn", true },
  { "bhavansvidyamandir.tk", true },
  { "bhaweshkumar.com", true },
  { "bhglamour.com", true },
  { "bhi.consulting", true },
  { "bhodisoft.com", true },
  { "bhrenovations.com", true },
  { "bhserralheria.com.br", true },
  { "bhtelecom.ba", true },
  { "bhuntr.com", true },
  { "bhxch.moe", true },
  { "bhyn.ca", true },
  { "bi.search.yahoo.com", false },
  { "bi1gif.radio", true },
  { "bi5.me", true },
  { "bi8cku.club", true },
  { "bi8cku.tech", true },
  { "biaggeo.com", true },
  { "biancapulizie.it", true },
  { "biancazapatka.com", true },
  { "biano-ai.com", true },
  { "biapinheiro.com.br", true },
  { "biasmath.es", true },
  { "bibica.net", true },
  { "bible-maroc.com", true },
  { "biblesignposts.com", true },
  { "bibleversesfordailyliving.com", true },
  { "bibliaon.com", true },
  { "bibliatodo.com", true },
  { "biblioblog.fr", true },
  { "bibliobus.ch", true },
  { "bibliology.org", true },
  { "bibliomarkt.ch", true },
  { "biblionaut.net", true },
  { "biblionix.com", true },
  { "biblioporn.com", true },
  { "bibliotecadeseguranca.com.br", true },
  { "bibliotekarien.se", true },
  { "bibliotekasnow.org", true },
  { "bibliotherapie-existentiale.com", true },
  { "biboumail.fr", true },
  { "bibuch.com", true },
  { "bicecontracting.com", true },
  { "bicha.net", true },
  { "bicifanaticos.com", true },
  { "bicranial.io", true },
  { "bicycleframeiz.com", true },
  { "bicycleuniverse.com", true },
  { "biddl.com", true },
  { "biddle.co", true },
  { "bidman.cz", true },
  { "bidman.eu", true },
  { "bidu.com.br", true },
  { "bie08.com", true },
  { "bie35.com", true },
  { "bie79.com", true },
  { "biec.moe", true },
  { "biegal.ski", true },
  { "biegner-technik.de", true },
  { "biego.cn", true },
  { "biehlsoft.info", true },
  { "bielefailed.de", true },
  { "bien-etre-sante.info", true },
  { "bienestarfacial.com", true },
  { "bienhacerlimpiezas.es", true },
  { "bienici.com", true },
  { "bienoubien.org", true },
  { "bienstar.tv", true },
  { "bienvenidoamerica.com", true },
  { "bierbaumer.net", true },
  { "biergaizi.info", true },
  { "bierochs.org", true },
  { "bierwebshop.be", true },
  { "bieser.ch", true },
  { "biester.pro", true },
  { "bifm.de", true },
  { "bifrost.cz", true },
  { "big-andy.co.uk", true },
  { "big-bounce.co.uk", true },
  { "big-tits-video.ru", true },
  { "bigbank.ee", true },
  { "bigbendcoffeeroasters.com", true },
  { "bigbendguide.com", true },
  { "bigbluedoor.net", true },
  { "bigboris.tk", true },
  { "bigbouncebouncycastles.co.uk", true },
  { "bigbouncetheory.co.uk", true },
  { "bigbounceuk.com", true },
  { "bigcakes.dk", true },
  { "bigclassaction.com", true },
  { "bigdinosaur.org", true },
  { "bigdiscounts.tk", true },
  { "bigfatbetty.com", true },
  { "biggerpicture.agency", true },
  { "biggles.io", true },
  { "bighouse-events.co.uk", true },
  { "bigideasnetwork.com", true },
  { "bigio.com.br", true },
  { "biglou.com", false },
  { "bigorbitgallery.org", true },
  { "bigpicture-learning.com", true },
  { "bigprintinglasvegas.com", true },
  { "bigsam.us", true },
  { "bigserp.com", true },
  { "bigshopper.com", true },
  { "bigshopper.nl", true },
  { "bigsisterchannel.com", true },
  { "bigskylifestylerealestate.com", true },
  { "bigskymontanalandforsale.com", true },
  { "bihub.io", true },
  { "biilo.com", true },
  { "bijancompany.com", true },
  { "bijouxcherie.com", true },
  { "bijuteriicualint.ro", true },
  { "bike-kurse.ch", true },
  { "bike-shack.com", true },
  { "bikebristol.com", true },
  { "bikehistory.org", true },
  { "biker.dating", true },
  { "bikhof.com", true },
  { "bikiniseli.com", true },
  { "bikkelbroeders.com", false },
  { "bikkelbroeders.nl", false },
  { "bilalic.com", true },
  { "bilalkilic.de", true },
  { "bilbayt.com", true },
  { "bilder-designs.de", true },
  { "bildkomponist.de", true },
  { "bildschirmflackern.de", true },
  { "bildungshaus-arnach.de", true },
  { "biletvkrym.ga", true },
  { "biletyplus.by", true },
  { "biletyplus.ua", true },
  { "bilgo.com", true },
  { "bilibili.link", true },
  { "bilibili.red", true },
  { "bilibili.sh", true },
  { "bilimoe.com", true },
  { "bilke.org", true },
  { "billaud.eu.org", true },
  { "billcompare.ga", true },
  { "billfazz.com", true },
  { "billgoldstein.name", true },
  { "billgradywebdesign.com", true },
  { "billhartzer.com", true },
  { "billigastehemsidan.se", true },
  { "billiger-mietwagen.de", true },
  { "billigerfinder.de", true },
  { "billigesommerhuse.nu", true },
  { "billigpoker.dk", true },
  { "billin.net", true },
  { "billionaire365.com", true },
  { "billionairemailinglist.com", true },
  { "billkochman.com", true },
  { "billogr.am", true },
  { "billogram.be", true },
  { "billogram.ch", true },
  { "billogram.co", true },
  { "billogram.co.uk", true },
  { "billogram.com", true },
  { "billogram.de", true },
  { "billogram.es", true },
  { "billogram.eu", true },
  { "billogram.fi", true },
  { "billogram.fr", true },
  { "billogram.io", true },
  { "billogram.it", true },
  { "billogram.me", true },
  { "billogram.net", true },
  { "billogram.nl", true },
  { "billogram.nu", true },
  { "billogram.org", true },
  { "billogram.se", true },
  { "billogramcontent.com", true },
  { "billograminternal.com", true },
  { "billogramstatic.com", true },
  { "billogramtest.com", true },
  { "billopay.com", true },
  { "billopay.de", true },
  { "billopay.se", true },
  { "billpro.com", false },
  { "billy.pictures", true },
  { "billyoh.com", true },
  { "billysbouncycastlehire.co.uk", true },
  { "billywig.stream", true },
  { "biltullen.com", true },
  { "bim.physio", true },
  { "bimacitizen.com", true },
  { "bimbo.com", false },
  { "bimbo.com.ar", false },
  { "bimbobakeriesusa.com", false },
  { "bimibroccoli.co.uk", true },
  { "bimibroccoli.com", true },
  { "bimibroccoli.dk", true },
  { "bimibroccoli.it", true },
  { "bimibroccoli.nl", true },
  { "bimibroccoli.se", true },
  { "bimibrocoli.es", true },
  { "bimibrocoli.fr", true },
  { "bimibrokkoli.de", true },
  { "bimmerlabs.com", true },
  { "bin92.com", true },
  { "bin95.com", true },
  { "bina.az", true },
  { "binans.com", true },
  { "binans.com.tr", true },
  { "binans.net", true },
  { "binaries.fr", true },
  { "binary.house", true },
  { "binaryapparatus.com", true },
  { "binaryappdev.com", true },
  { "binarycreations.scot", true },
  { "binarydream.fi", true },
  { "binaryevolved.com", true },
  { "binaryrebel.net", true },
  { "binarystud.io", true },
  { "binding-problem.com", true },
  { "bing.com", true },
  { "bingobank.org", true },
  { "binhex.net", true },
  { "binhp.com", true },
  { "biniou.net", true },
  { "binkconsulting.be", true },
  { "binnenmeer.de", true },
  { "binoqlo.com", true },
  { "binsp.net", true },
  { "bintach.com", true },
  { "binti.com", true },
  { "bintooshoots.com", true },
  { "bio-disinfestazione.it", true },
  { "bio-feed.org", true },
  { "bio-place.com", true },
  { "bio24.si", true },
  { "bioastin.de", true },
  { "bioatelier.it", true },
  { "biobuttons.ch", true },
  { "biocheminee.com", true },
  { "biocrafting.net", true },
  { "biodiagnostiki.clinic", true },
  { "biodieseldata.com", true },
  { "biodots.at", true },
  { "biodots.eu", true },
  { "biodots.info", true },
  { "biodots.it", true },
  { "bioedilizia.roma.it", true },
  { "bioemprendiendo.com", true },
  { "bioemsan.cz", true },
  { "bioequivalence.design", true },
  { "bioetco.ch", true },
  { "bioexploratorium.pl", true },
  { "biofattorietoscane.it", true },
  { "biofrequenze.it", true },
  { "biogecho.ch", false },
  { "biogecho.swiss", false },
  { "biogeist.de", true },
  { "biogiardinaggio.it", true },
  { "biographywiki.net", true },
  { "biohappiness.com", true },
  { "bioharmony.ca", true },
  { "biointelligence-explosion.com", true },
  { "bioknowme.com", true },
  { "biol.moscow", true },
  { "biol.spb.ru", true },
  { "biolack.cf", true },
  { "bioleev.sklep.pl", true },
  { "bioligo.ch", false },
  { "biolmarket.ru", true },
  { "biologis.ch", true },
  { "biology-colleges.com", true },
  { "biomag.it", true },
  { "biomathalliance.org", true },
  { "biomed-hospital.ch", true },
  { "biomed.ch", true },
  { "biomin.co.uk", true },
  { "biomodra.cz", true },
  { "bionezis.com", true },
  { "bionicman.name", true },
  { "bionima.com", true },
  { "biopsychiatry.com", true },
  { "bioresonanz-ibiza.com", true },
  { "biosafe.ch", false },
  { "biosalts.it", true },
  { "biosbits.org", true },
  { "biosearch.tk", true },
  { "bioshine.com.sg", true },
  { "biosignalanalytics.com", true },
  { "biosphere.cc", true },
  { "biospw.com", true },
  { "biotechware.com", true },
  { "biotera.cl", true },
  { "biotin.ch", true },
  { "biowtage.gq", true },
  { "birbaumer.li", true },
  { "birchbarkfurniture.com", true },
  { "birchbarkfurniture.fr", true },
  { "birdbrowser.com", true },
  { "birdie.pt", true },
  { "birdiehosting.nl", true },
  { "birdslabel.com", true },
  { "birdymanbestreviews.com", true },
  { "birgerschwarz.de", false },
  { "birgit-rydlewski.de", true },
  { "birkenstab.de", true },
  { "birkenwasser.de", true },
  { "birminghamsunset.com", true },
  { "birthdaytip.com", true },
  { "birthmatters.us", true },
  { "birzan.org", true },
  { "bisa-sis.net", true },
  { "bischoff-mathey.family", true },
  { "biscuit.town", true },
  { "biscuitcute.com.br", true },
  { "biser-borisov.eu", true },
  { "biser.online", true },
  { "bishopp.com.au", true },
  { "bishopscourt-hawarden.co.uk", true },
  { "bishoptx.com", true },
  { "bismarck-tb.de", true },
  { "bisoga.xyz", true },
  { "bison.co", true },
  { "bisq.community", true },
  { "bisq.network", true },
  { "bistrocean.com", true },
  { "bistroservice.de", true },
  { "bistrotdelagare.fr", true },
  { "bit-cloud.de", true },
  { "bit-rapid.com", true },
  { "bit-sentinel.com", true },
  { "bit-service-aalter.be", true },
  { "bit.biz.tr", true },
  { "bit8.com", true },
  { "bitaccelerate.com", true },
  { "bitbank.cc", true },
  { "bitbeans.de", true },
  { "bitbox.me", true },
  { "bitbucket.com", true },
  { "bitbucket.io", true },
  { "bitbucket.org", true },
  { "bitburner.de", true },
  { "bitcoin-fauset.cf", true },
  { "bitcoin-india.net", true },
  { "bitcoin-wizards.com", true },
  { "bitcoin.asia", true },
  { "bitcoin.ch", true },
  { "bitcoin.co.nz", true },
  { "bitcoin.de", true },
  { "bitcoin.im", true },
  { "bitcoin.info", true },
  { "bitcoin.org", true },
  { "bitcoin.us", true },
  { "bitcoinbitcoin.com", true },
  { "bitcoinbot.tk", true },
  { "bitcoincasinos.pro", true },
  { "bitcoincore.org", true },
  { "bitcoiner-or-shitcoiner.com", true },
  { "bitcoinfees.net", true },
  { "bitcoingambling.pro", true },
  { "bitcoinindia.com", true },
  { "bitcoinrealestate.com.au", true },
  { "bitcointhefts.com", true },
  { "bitcoinx.ro", true },
  { "bitcork.io", true },
  { "bitcqr.io", true },
  { "bitenose.com", true },
  { "bitex.la", true },
  { "bitfasching.de", false },
  { "bitfehler.net", true },
  { "bitfinder.nl", true },
  { "bitfuse.net", true },
  { "bitgain-leverage.com", true },
  { "bitgo.com", true },
  { "bitgrapes.com", true },
  { "bitguerrilla.com", true },
  { "bithausen.io", true },
  { "bither.net", true },
  { "bithir.co.uk", true },
  { "bititrain.com", true },
  { "bitjunkiehosting.com", true },
  { "bitking-trading.com", true },
  { "bitlish.com", true },
  { "bitlo.com", true },
  { "bitlo.com.tr", true },
  { "bitlo.io", true },
  { "bitlo.org", true },
  { "bitmag.ml", true },
  { "bitmainwarranty.com", true },
  { "bitmarket.net", true },
  { "bitmarket.pl", true },
  { "bitmask.me", true },
  { "bitmessage.ch", true },
  { "bitmidi.com", true },
  { "bitminter.com", true },
  { "bitmoe.com", true },
  { "bitok.com", true },
  { "bitpumpe.net", true },
  { "bitref.com", true },
  { "bitrefill.com", true },
  { "bitrush.nl", true },
  { "bits-hr.de", true },
  { "bitsafe.com.my", true },
  { "bitsalt.com", true },
  { "bitski.com", true },
  { "bitskins.co", true },
  { "bitskrieg.net", true },
  { "bitso.com", true },
  { "bitsoffreedom.nl", true },
  { "bitstage.uk", true },
  { "bitstep.ca", true },
  { "bitstorm.nl", true },
  { "bitstorm.org", true },
  { "bitsy.com", true },
  { "bitsync.nl", true },
  { "bitten.pw", true },
  { "bittersweetcandybowl.com", true },
  { "bittylicious.com", true },
  { "bitvest.io", true },
  { "bitvps.com", true },
  { "bitwarden.com", true },
  { "bitwolk.nl", true },
  { "bitxel.com.co", false },
  { "biurokarier.edu.pl", true },
  { "biuropulawy.pl", true },
  { "bixbydevelopers.com", true },
  { "bixservice.com", true },
  { "biyori.moe", true },
  { "biyou-homme.com", true },
  { "biz-architect.com", true },
  { "biz-secrety.gq", true },
  { "biz-secrety.ml", true },
  { "biz-seecrets.gq", true },
  { "biz4x.com", true },
  { "bizcash.co.za", true },
  { "bizeau.ch", true },
  { "bizlatinhub.com", true },
  { "biznes-sekrety.gq", true },
  { "biznes-sekrety.tk", true },
  { "biznesinfo.pl", true },
  { "biznesonline.info", true },
  { "biznet.tk", true },
  { "bizniskatalog.mk", true },
  { "biznpro.ru", true },
  { "bizpare.com", true },
  { "bizpay.su", true },
  { "bizstarter.cz", true },
  { "biztera.com", true },
  { "biztok.eu", true },
  { "biztouch.work", true },
  { "bizzdesign.cloud", true },
  { "bizzdesign.com", true },
  { "bizzit.se", true },
  { "bjarnerest.de", true },
  { "bjl688.cc", true },
  { "bjoe2k4.de", true },
  { "bjolanta.pl", true },
  { "bjornhelmersson.se", true },
  { "bjornjohansen.no", true },
  { "bjs.com.au", true },
  { "bjs.gov", true },
  { "bjsbouncycastles.com", true },
  { "bjut.photos", true },
  { "bk-wife.com", true },
  { "bkentertainments.co.uk", true },
  { "bkhpilates.co.uk", true },
  { "bkkf.at", true },
  { "bkositspartytime.co.uk", true },
  { "bkt.to", true },
  { "bl00.se", true },
  { "bl4ckb0x.biz", true },
  { "bl4ckb0x.com", true },
  { "bl4ckb0x.de", true },
  { "bl4ckb0x.eu", true },
  { "bl4ckb0x.info", true },
  { "bl4ckb0x.net", true },
  { "bl4ckb0x.org", true },
  { "blaargh.com", true },
  { "blaauwgeers.pro", true },
  { "blaauwgeers.travel", true },
  { "blabber.im", true },
  { "blablacar.co.uk", true },
  { "blablacar.com.tr", true },
  { "blablacar.com.ua", true },
  { "blablacar.de", true },
  { "blablacar.es", true },
  { "blablacar.fr", true },
  { "blablacar.hr", true },
  { "blablacar.hu", true },
  { "blablacar.in", true },
  { "blablacar.it", true },
  { "blablacar.mx", true },
  { "blablacar.nl", true },
  { "blablacar.pl", true },
  { "blablacar.pt", true },
  { "blablacar.ro", true },
  { "blablacar.rs", true },
  { "blablacar.ru", true },
  { "black-gay-porn.biz", true },
  { "black-holes.org", true },
  { "black-mail.nl", true },
  { "black-raven.fr", true },
  { "black.dating", true },
  { "black.host", true },
  { "black1ce.com", true },
  { "blackandpony.de", true },
  { "blackbag.nl", true },
  { "blackbam.at", true },
  { "blackberryforums.be", true },
  { "blackbird-whitebird.com", true },
  { "blackboxconnections.com", true },
  { "blackcat.ca", true },
  { "blackcatinformatics.ca", true },
  { "blackcatinformatics.com", true },
  { "blackdiam.net", true },
  { "blackdown.de", true },
  { "blackdragoninc.org", true },
  { "blackedbyte.com", true },
  { "blackevent.be", true },
  { "blackfire.io", true },
  { "blackgamelp.de", true },
  { "blackgate.org", true },
  { "blackhat.dk", true },
  { "blackhawkup.com", true },
  { "blackhelicopters.net", true },
  { "blackhillsinfosec.com", true },
  { "blackhost.org", true },
  { "blackjackballroomcasino.info", true },
  { "blackl.net", true },
  { "blacklightparty.be", true },
  { "blackmagickwitch.com", true },
  { "blackmagicshaman.com", true },
  { "blackminds.tk", true },
  { "blackmonday.gr", true },
  { "blacknetwork.eu", true },
  { "blacknova.io", true },
  { "blackoutzone.tk", true },
  { "blackpapermoon.de", true },
  { "blackphoenix.de", true },
  { "blackroadphotography.de", true },
  { "blackroot.eu", true },
  { "blackscytheconsulting.com", true },
  { "blackseals.net", true },
  { "blackspark.tk", true },
  { "blackstrapsecurity.com", true },
  { "blackstump.xyz", true },
  { "blackteam.org", true },
  { "blacktown.eu", true },
  { "blacktownbuildingsupplies.com.au", true },
  { "blacktubes.cf", true },
  { "blackys-chamber.de", false },
  { "blackzebra.audio", true },
  { "blaindalefarms.com", true },
  { "blaise.io", true },
  { "blakecoin.org", true },
  { "blakekhan.com", true },
  { "blakezone.com", true },
  { "blanboom.org", true },
  { "blancodent.com", true },
  { "blanket.technology", true },
  { "blasorchester-runkel.de", true },
  { "blastentertainment.com.au", true },
  { "blastersklan.com", true },
  { "blaudev.es", true },
  { "blauerhunger.de", true },
  { "blaulicht-giessen.de", true },
  { "blaumedia.com", true },
  { "blautiefe.de", true },
  { "blauwwit.be", true },
  { "blayne.me", true },
  { "blayneallan.com", true },
  { "blazing.cz", true },
  { "blazor.nl", true },
  { "blblblblbl.fr", true },
  { "bleaching-tipps.de", true },
  { "blechbuexn.de", true },
  { "bleche-onlineshop.at", true },
  { "bleche-onlineshop.de", true },
  { "blechinger.io", true },
  { "blechschmidt.saarland", true },
  { "blenderinsider.com", true },
  { "blenderman.org", true },
  { "blenderrecipereviews.com", true },
  { "blending.kr", true },
  { "blendle.com", true },
  { "blendle.nl", true },
  { "blendr.com", true },
  { "blendstudios.com", false },
  { "blenheimears.com", true },
  { "blenneros.net", false },
  { "blessedgeeks.org", true },
  { "blessedgeeks.social", true },
  { "blessedguy.com", true },
  { "blewebprojects.com", true },
  { "blichmann.eu", true },
  { "blideobames.com", true },
  { "blidz.com", true },
  { "blieque.co.uk", true },
  { "blijfbij.com", true },
  { "blijfbij.eu", true },
  { "blikund.swedbank.se", true },
  { "blindpigandtheacorn.com", true },
  { "blinds.media", true },
  { "blingsparkleshine.com", true },
  { "blingwang.cn", true },
  { "blink-security.com", true },
  { "blinkdrivex.com", true },
  { "blinking.link", true },
  { "blio.tk", true },
  { "blip.website", true },
  { "blissjoe.com", true },
  { "blissplan.com", true },
  { "blivawesome.dk", true },
  { "blivvektor.dk", true },
  { "blizhost.com", true },
  { "blizhost.com.br", true },
  { "blkbx.eu", true },
  { "blm.gov", true },
  { "blm36.cc", true },
  { "blm69.cc", true },
  { "blo-melchiorshausen.de", true },
  { "blobemoji.com", true },
  { "blobfolio.com", true },
  { "blobs.gg", true },
  { "blocher.ch", true },
  { "blochoestergaard.com", true },
  { "block-this.com", true },
  { "block65.com", true },
  { "blockchain.com", true },
  { "blockchain.info", true },
  { "blockchainced.com", true },
  { "blockchaindaigakko.jp", true },
  { "blockchainmagazine.net", true },
  { "blockchainwhiz.com", true },
  { "blockclique.io", true },
  { "blockedyourcar.com", true },
  { "blockedyourcar.net", true },
  { "blockedyourcar.org", true },
  { "blockmetry.com", true },
  { "blockstream.com", true },
  { "blockxit.de", true },
  { "bloemenbesteld.nl", true },
  { "bloemendal.me", true },
  { "blog-garage.com", true },
  { "blog-grupom2.es", true },
  { "blog-investimenti.it", true },
  { "blog.gov.uk", true },
  { "blog.linode.com", false },
  { "blog.lookout.com", false },
  { "blog.torproject.org", false },
  { "blogaid.net", true },
  { "bloganchoi.com", true },
  { "blogaram.tk", true },
  { "blogarts.net", true },
  { "blogauto.cz", true },
  { "blogbooker.com", true },
  { "blogcosmeticsurgeon.ga", true },
  { "blogdefarmacia.com", true },
  { "blogdelosjuguetes.com", true },
  { "blogdieconomia.it", true },
  { "blogdimoda.com", true },
  { "blogdimotori.it", true },
  { "blogexpert.ca", true },
  { "bloggermumofthreeboys.com", true },
  { "blogging-life.com", true },
  { "bloggingtipsfornewblogger.com", true },
  { "bloggytalky.com", true },
  { "bloginbeeld.nl", true },
  { "blogit.fi", true },
  { "bloglyric.com", true },
  { "blognews.cf", true },
  { "blognone.com", true },
  { "blogofapps.com", true },
  { "blogom.at", true },
  { "blogpress.co.il", true },
  { "blogredmachine.com", true },
  { "blogreen.org", true },
  { "blogsdna.com", true },
  { "blogthedayaway.com", true },
  { "blogtroterzy.pl", true },
  { "blok56.nl", true },
  { "blomberg.name", true },
  { "blonde.style", true },
  { "bloodpop.tk", true },
  { "bloodsports.org", true },
  { "bloody.pw", true },
  { "bloom-avenue.com", true },
  { "bloom.sh", true },
  { "blopezabogado.es", true },
  { "blrjmt.com", true },
  { "bltc.co.uk", true },
  { "bltc.com", true },
  { "bltc.net", true },
  { "bltc.org", true },
  { "bltc.org.uk", true },
  { "bltdirect.com", true },
  { "blubbablasen.de", true },
  { "blubberladen.de", true },
  { "blubop.fr", true },
  { "blue-gmbh-erfahrungen.de", true },
  { "blue-gmbh.de", true },
  { "blue-leaf81.net", true },
  { "blue-nijmegen.nl", true },
  { "blue42.net", true },
  { "blueangel.org.tw", true },
  { "bluebie.com", true },
  { "blueblou.com", true },
  { "bluebnc.com", true },
  { "bluecanvas.io", true },
  { "bluechilli.com", true },
  { "bluecrazii.nl", true },
  { "blued.moe", true },
  { "bluedeck.org", true },
  { "blueeyedmaid.co.uk", true },
  { "bluefrag.com", true },
  { "bluefuzz.nl", true },
  { "bluegifts.ro", true },
  { "bluehelixmusic.com", true },
  { "bluehillhosting.com", true },
  { "blueimp.net", true },
  { "bluekrypt.com", true },
  { "blueliquiddesigns.com.au", true },
  { "bluemanhoop.com", true },
  { "bluemarmalade.co.uk", true },
  { "bluemeda.web.id", true },
  { "bluemoonroleplaying.com", true },
  { "bluemosh.com", true },
  { "bluemtnrentalmanagement.ca", true },
  { "bluenote9.com", true },
  { "blueoakart.com", true },
  { "blueperil.de", true },
  { "bluepostbox.de", true },
  { "blueprintrealtytn.com", true },
  { "bluepromocode.com", true },
  { "bluerootsmarketing.com", true },
  { "blueskycoverage.com", true },
  { "blueskydigitalstrategy.com", true },
  { "blueskyinsure.com", true },
  { "bluesoap.com.au", true },
  { "bluestardiabetes.com", true },
  { "bluestarroofing.com", true },
  { "bluesuncamping.com", true },
  { "bluesunhotels.com", true },
  { "blueswandaily.com", true },
  { "bluesync.co", true },
  { "bluetexservice.com", true },
  { "bluetomatographics.com", true },
  { "bluetoothspecialist.ga", true },
  { "bluewavewebdesign.com", true },
  { "bluewizardart.net", true },
  { "bluex.im", true },
  { "bluex.info", true },
  { "bluex.net", true },
  { "bluex.org", true },
  { "bluffplumber.co.za", true },
  { "blui.xyz", true },
  { "bluiandaj.ml", true },
  { "bluimedia.com", true },
  { "bluinet.com", true },
  { "blumando.de", true },
  { "blumenfeldart.com", true },
  { "blumiges-fischbachtal.de", false },
  { "bluntandsnakes.com", true },
  { "blupig.net", true },
  { "blurringexistence.net", true },
  { "blusens.com", true },
  { "blusmurf.net", true },
  { "blutopia.xyz", false },
  { "blw.moe", true },
  { "blyat.science", true },
  { "blyth.me.uk", true },
  { "blythwood.com", true },
  { "blzrk.com", true },
  { "bmcorp.online", true },
  { "bmhglobal.com.au", true },
  { "bmk-kramsach.at", true },
  { "bmoattachments.org", true },
  { "bmone.net", true },
  { "bmros.com.ar", true },
  { "bmw-motorradclub-seefeld.de", true },
  { "bn4t.me", true },
  { "bnbsinflatablehire.co.uk", true },
  { "bnck.me", true },
  { "bngs.pl", true },
  { "bnin.org", true },
  { "bnjscastles.co.uk", true },
  { "bnstree.com", true },
  { "bnty.net", true },
  { "bnzblowermotors.com", true },
  { "bo4tracker.com", true },
  { "boardgamegeeks.de", true },
  { "boards.ie", true },
  { "boardspot.com", true },
  { "boat-engines.eu", true },
  { "boats.com", true },
  { "boattrader.com", true },
  { "boattrader.com.au", true },
  { "bob-dylan.tk", true },
  { "bobaly.es", true },
  { "bobancoamigo.com", true },
  { "bobandducky.com", true },
  { "bobaobei.net", true },
  { "bobasy.pl", true },
  { "bobazar.com", false },
  { "bobcoffee.com.br", true },
  { "bobcopeland.com", true },
  { "bobep.ru", true },
  { "bobkidbob.com", true },
  { "bobkoetsier.nl", true },
  { "bobnbounce.ie", true },
  { "bobnbouncedublin.ie", true },
  { "bobobox.net", true },
  { "bobstenancycleaning.co.uk", true },
  { "bobstronomie.fr", true },
  { "bocamo.it", true },
  { "bocawa.es", true },
  { "boccabell.com", true },
  { "bochantinobgyn.com", true },
  { "bochs.info", true },
  { "bockenauer.at", true },
  { "bocreation.fr", true },
  { "bodas.com.mx", true },
  { "bodegasvirei.com", true },
  { "bodemplaten4x4.nl", true },
  { "bodhi.fedoraproject.org", true },
  { "bodis.nl", true },
  { "bodrumhotelsresorts.com", true },
  { "bodsch.com", true },
  { "bodybuilding.com", true },
  { "bodybuildingworld.com", true },
  { "bodyconshop.com", true },
  { "bodygearguide.com", true },
  { "bodymusclejournal.com", true },
  { "bodypainter.pl", true },
  { "bodypainting.waw.pl", true },
  { "bodyshopnews.net", true },
  { "bodyweb.com.br", true },
  { "bodyworksautorebuild.com", true },
  { "boeddhashop.nl", true },
  { "boernecancerfonden.dk", true },
  { "boevik.ml", true },
  { "bogdancornianu.com", true },
  { "bogdanepureanu.ro", true },
  { "bogner.sh", true },
  { "bogosity.se", true },
  { "bohan.co", true },
  { "bohramt.de", true },
  { "boimmobilier.ch", false },
  { "boiseonlinemall.com", true },
  { "boisewaldorf.org", true },
  { "bojiu99.cc", true },
  { "bokadoktorn-test.net", true },
  { "bokadoktorn.se", true },
  { "boke112.com", true },
  { "bokka.com", true },
  { "bokkeriders.com", true },
  { "bokutake.com", true },
  { "bolalocobrews.co.uk", true },
  { "bolamarela.com.br", true },
  { "bolamarela.pt", true },
  { "boldt-metallbau.de", true },
  { "bolektro.de", true },
  { "boleyn.su", true },
  { "bolgarka.kz", true },
  { "bolgarnyelv.hu", true },
  { "bologna-disinfestazioni.it", true },
  { "bolovegna.it", true },
  { "bolsashidrosolubles.com", true },
  { "bolt.cm", false },
  { "bolt.com", true },
  { "boltbeat.com", true },
  { "bolte.org", true },
  { "boltenergy.ca", true },
  { "boltmobile.ca", true },
  { "bomb.codes", true },
  { "bombe-lacrymogene.fr", true },
  { "bomboniere.roma.it", true },
  { "bomhard.de", true },
  { "bomhard.net", true },
  { "bomhard.org", true },
  { "bonaccorso.eu", true },
  { "bonaemi.ga", true },
  { "bonami.cz", true },
  { "bonami.hu", true },
  { "bonami.pl", true },
  { "bonami.ro", true },
  { "bonami.sk", true },
  { "bonawehouse.co.uk", true },
  { "bonbonmania.com", false },
  { "bondagefetishstore.com", true },
  { "bondank.com", true },
  { "bondarenko.dn.ua", true },
  { "bondingwithbaby.ca", true },
  { "bondlink.com", true },
  { "bondskampeerder.nl", true },
  { "bonebunny.de", true },
  { "boneko.de", true },
  { "bonesserver.com", true },
  { "bonfi.net", true },
  { "bongbabyhouse.com", true },
  { "bongbabyhouse.vn", true },
  { "bongloy.com", true },
  { "bongminhtam.com", true },
  { "bongo.cat", true },
  { "bongocams.webcam", true },
  { "bongoo.fr", true },
  { "bonifacius.be", true },
  { "bonito.pl", true },
  { "bonn.digital", true },
  { "bonnant-associes.ch", false },
  { "bonnant-partners.ch", false },
  { "bonniecoloring.com", true },
  { "bonnieradvocaten.nl", true },
  { "bonnsustainabilityportal.de", true },
  { "bonnyprints.at", true },
  { "bonnyprints.ch", true },
  { "bonnyprints.es", true },
  { "bonnyprints.fr", true },
  { "bonprix.co.uk", true },
  { "bonsaimedia.nl", true },
  { "bonsi.net", true },
  { "bonsi.org", true },
  { "bonus.ca", true },
  { "bonus.net.nz", true },
  { "bonus.pl", true },
  { "bonusov.tk", true },
  { "bonussource.com", true },
  { "bonux.co", true },
  { "boodmo.com", true },
  { "book-in-hotel.com", true },
  { "booker.ly", true },
  { "bookingapp.be", true },
  { "bookingapp.nl", true },
  { "bookingslog.com", true },
  { "bookingtool.com", true },
  { "bookingtool.net", true },
  { "bookingworldspeakers.com", true },
  { "bookluk.com", true },
  { "bookmein.in", true },
  { "booknowmytrip.com", true },
  { "bookofdenim.com", true },
  { "booksearch.jp", true },
  { "bookshopofindia.com", true },
  { "booksinthefridge.at", true },
  { "bookslibrarybooks.gq", true },
  { "booktoan.com", true },
  { "booktracker-org.appspot.com", true },
  { "bookwave.art", true },
  { "bookzaga.com", true },
  { "bool.be", true },
  { "boombv.com", false },
  { "boomersurf.com", true },
  { "boomfestival.org", true },
  { "boomkins.net", true },
  { "boomshelf.com", true },
  { "boomshelf.org", true },
  { "boomvm.pw", true },
  { "boonbox.com", true },
  { "booox.cc", true },
  { "booox.info", true },
  { "booox.net", true },
  { "booox.org", true },
  { "boop.pro", true },
  { "booplab.com", false },
  { "booquiz.com", true },
  { "boosinflatablegames.co.uk", true },
  { "boosman.nu", true },
  { "boosmanpoolservice.com", true },
  { "boost.ink", true },
  { "booter.pw", true },
  { "boothlabs.me", true },
  { "bootjp.me", false },
  { "bootsschule-weiss.de", true },
  { "bopiweb.com", true },
  { "bopp.org", true },
  { "borahan.net", true },
  { "boran.cl", true },
  { "borba-umov.tk", true },
  { "borchers.ninja", true },
  { "bordadoenpedreria.com", true },
  { "borderless360.com", true },
  { "bordes.me", true },
  { "bordo.com.au", true },
  { "boreacr.com", true },
  { "boredhackers.com", true },
  { "boredhousewifeconfessions.cf", true },
  { "borein.cf", true },
  { "boreo.si", true },
  { "boresmail.ru", true },
  { "borisenko.by", true },
  { "borja.io", true },
  { "born2bounce.co.uk", true },
  { "bornandgrazed.com", true },
  { "borneodictionary.com", true },
  { "bornfiber.dk", true },
  { "bornhack.dk", true },
  { "bornreality.tk", true },
  { "borowski.pw", true },
  { "borrelpartybus.nl", true },
  { "borriquillacuenca.tk", true },
  { "borysek.net", true },
  { "borysenko.se", true },
  { "bosabosa.org", true },
  { "bosattondskap.tk", true },
  { "boscoyacht.ch", false },
  { "boscq.fr", true },
  { "bosekarmelitky.cz", true },
  { "boskeopolis-stories.com", true },
  { "boss.az", true },
  { "bossdistribuidora.com.br", true },
  { "bostonadvisors.com", true },
  { "bostonaoii.com", true },
  { "bosufitness.cz", true },
  { "bosun.io", true },
  { "bot-manager.pl", true },
  { "botcamp.org", true },
  { "botcore.ai", true },
  { "botezdepoveste.ro", true },
  { "botguard.net", true },
  { "bothellwaygarage.net", true },
  { "botmastery.com", true },
  { "botmedia.cf", true },
  { "botnam.com", true },
  { "botserver.de", true },
  { "bottaerisposta.net", true },
  { "bottineauneighborhood.org", true },
  { "bottinquebec.com", true },
  { "bottke.berlin", true },
  { "bottledstories.de", true },
  { "bou.cloud", true },
  { "bou.ke", true },
  { "bouah.net", true },
  { "bouchard-mathieux.com", true },
  { "bouchonville-knifemaker.com", true },
  { "boudah.pl", true },
  { "bougeret.fr", true },
  { "boughariosbros.com", true },
  { "boukoubengo.com", true },
  { "bouldercolorado.gov", true },
  { "boulderlibrary.org", true },
  { "boulderswap.com", true },
  { "boulzicourt.fr", true },
  { "bounce-a-mania.co.uk", true },
  { "bounce-a-roo.co.uk", true },
  { "bounce-abouts.com", true },
  { "bounce-n-go.co.uk", true },
  { "bounce-on.co.uk", true },
  { "bounce-r-us.co.uk", true },
  { "bounce-xtreme.co.uk", true },
  { "bounce4fun.co.uk", true },
  { "bounce4fun.ie", true },
  { "bounce4kidz.com", true },
  { "bounce4less.ie", true },
  { "bouncea-bout.com", true },
  { "bounceaboutandplay.co.uk", true },
  { "bounceaboutnewark.co.uk", true },
  { "bounceaboutsussex.co.uk", true },
  { "bouncealotcastlehire.co.uk", true },
  { "bouncealotnorthwest.co.uk", true },
  { "bounceandwobble.co.uk", true },
  { "bounceapp.com", true },
  { "bouncearoundevents.co.uk", true },
  { "bouncearoundsheffield.co.uk", true },
  { "bounceawaycastles.com", true },
  { "bouncebackcastles.co.uk", true },
  { "bouncebookings.com.au", true },
  { "bouncecrazy.ie", true },
  { "bouncejumpboston.co.uk", true },
  { "bouncekingdom.co.uk", true },
  { "bouncemaniaevents.co.uk", true },
  { "bouncemaniainflatables.co.uk", true },
  { "bouncemonkeys.co.uk", true },
  { "bouncenortheast.co.uk", true },
  { "bouncenpaint.co.uk", true },
  { "bouncepartycastles.com", true },
  { "bounceroosevents.co.uk", true },
  { "bouncers-bouncycastlehire.co.uk", true },
  { "bouncesouthwales.co.uk", true },
  { "bouncesquad.co.uk", true },
  { "bouncetasticuk.co.uk", true },
  { "bouncetheparty.co.uk", true },
  { "bounceunlimited.co.uk", true },
  { "bouncewrightcastles.co.uk", true },
  { "bouncincastles.co.uk", true },
  { "bouncingbairnsinflatables.co.uk", true },
  { "bouncingbeansinflatables.co.uk", true },
  { "bouncingbobsinflatables.co.uk", true },
  { "bouncingbuddiesleicester.co.uk", true },
  { "bouncinghigher.co.uk", true },
  { "bouncingscotland.com", true },
  { "bouncourseplanner.net", true },
  { "bouncy-castles-surrey.co.uk", true },
  { "bouncybaileys.co.uk", true },
  { "bouncyball.eu", true },
  { "bouncyballs.org", true },
  { "bouncybouncyboocastlehire.co.uk", true },
  { "bouncycastle.net.au", true },
  { "bouncycastlehire-norwich.com", true },
  { "bouncycastlehire-sheffield.co.uk", true },
  { "bouncycastlehire.co.uk", true },
  { "bouncycastlehireauckland.co.nz", true },
  { "bouncycastlehirebarnstaple.co.uk", true },
  { "bouncycastlehirebexley.co.uk", true },
  { "bouncycastlehirechelmsford.org.uk", true },
  { "bouncycastlehirehull.co.uk", true },
  { "bouncycastlehireinglasgow.co.uk", true },
  { "bouncycastlehirelouth.co.uk", true },
  { "bouncycastlehiremalvern.co.uk", true },
  { "bouncycastlehireoldham.co.uk", true },
  { "bouncycastlehirestroud.co.uk", true },
  { "bouncycastlehiresurrey.co.uk", true },
  { "bouncycastlehiretameside.co.uk", true },
  { "bouncycastlehirewinchester.co.uk", true },
  { "bouncycastleman.co.uk", true },
  { "bouncycastlemangloucestershire.co.uk", true },
  { "bouncycastleparade.com", true },
  { "bouncycastlesgalway.com", true },
  { "bouncycastleshire.co.uk", true },
  { "bouncycastleshireleeds.co.uk", true },
  { "bouncycastlesin.co.uk", true },
  { "bouncycastlesinderby.co.uk", true },
  { "bouncycastlesisleofwight.co.uk", true },
  { "bouncycastlesmonaghan.com", true },
  { "bouncycastlessheerness.co.uk", true },
  { "bouncydays.co.uk", true },
  { "bouncygiggles.com.au", true },
  { "bouncyhigher.co.uk", true },
  { "bouncyhousecastlehire.co.uk", true },
  { "bouncykingdom.co.uk", true },
  { "bouncykings.co.uk", true },
  { "bouncykingsnortheast.co.uk", true },
  { "bouncymacs.co.uk", true },
  { "bouncyrainbows.co.uk", true },
  { "bouncytime.co.uk", true },
  { "bouncywouncy.co.uk", true },
  { "bound2bounce.co.uk", true },
  { "boundarybrighton.com", true },
  { "boundaryvets.co.uk", true },
  { "bounouh.tk", true },
  { "bountyfactory.io", true },
  { "bourasse.fr", true },
  { "bourgeoisdoorco.com", true },
  { "bournefun.co.uk", true },
  { "bourseauxservices.com", true },
  { "boutiqueguenaelleverdin.com", true },
  { "boutoncoupdepoing.fr", true },
  { "bouw.live", true },
  { "bouwbedrijfvandortbv.nl", true },
  { "bouwplaatscheckin.nl", true },
  { "bouzouada.com", true },
  { "bouzouks.net", true },
  { "bovenwebdesign.nl", true },
  { "bovworkplacepensions.com", true },
  { "bowdens.me", true },
  { "bowedwallcrackrepair.com", true },
  { "boweryandvine.com", true },
  { "bowlcake.fr", true },
  { "bowling.com", true },
  { "bownty.be", true },
  { "bownty.co.uk", true },
  { "bownty.de", true },
  { "bownty.dk", true },
  { "bownty.es", true },
  { "bownty.fr", true },
  { "bownty.it", true },
  { "bownty.nl", true },
  { "bowntycdn.net", true },
  { "bowtie.com.hk", true },
  { "boxcritters.wiki", true },
  { "boxcryptor.com", false },
  { "boxdropcc.com", true },
  { "boxintense.com", true },
  { "boxlink.de", true },
  { "boxpeg.com", true },
  { "boxpirates.to", true },
  { "boxspringbett-160x200.de", true },
  { "boxt.com.au", true },
  { "boxvergelijker.nl", true },
  { "boyfriendcookbook.com", true },
  { "boyhost.cn", true },
  { "boyinglanguage.com", true },
  { "boykovo.tk", true },
  { "boypoint.de", true },
  { "boysontech.com", true },
  { "boz.nl", false },
  { "bozdoz.com", true },
  { "bozhok.tk", true },
  { "bozit.com.au", true },
  { "bpaste.net", true },
  { "bpastudies.org", true },
  { "bphostels.com", true },
  { "bpo.ovh", true },
  { "bpol-forum.de", true },
  { "bpreguica.com.br", true },
  { "bps.vc", true },
  { "bpvboekje.nl", true },
  { "bqcp.net", true },
  { "bqp.io", false },
  { "bqr.ch", false },
  { "br.search.yahoo.com", false },
  { "br1334shop.com.br", true },
  { "br3in.nl", false },
  { "br7.ru", true },
  { "braams.nl", true },
  { "braathe.no", true },
  { "brabank.no", true },
  { "brabank.se", true },
  { "bracho.xyz", true },
  { "brachotelborak.com", true },
  { "bracknellvets.co.uk", true },
  { "bradbrockmeyer.com", true },
  { "bradfordhottubhire.co.uk", true },
  { "bradfordmascots.co.uk", true },
  { "bradkovach.com", true },
  { "bradler.net", false },
  { "bradlinder.org", true },
  { "bradypatterson.com", true },
  { "braeunlich-gmbh.com", true },
  { "brage.info", true },
  { "brahmins.com", true },
  { "braiampeguero.xyz", true },
  { "brailsford.xyz", true },
  { "brain-force.ch", true },
  { "brainball.fr", false },
  { "brainboxai.com", true },
  { "braineet.com", true },
  { "brainobeat.com", true },
  { "brainserve.ch", false },
  { "brainserve.com", false },
  { "brainserve.swiss", false },
  { "brainshare.tk", true },
  { "brainsik.net", true },
  { "brainstobrand.com", true },
  { "braintreegateway.com", true },
  { "brainvoyagermusic.com", true },
  { "brainwav.es", true },
  { "brainwork.space", true },
  { "braithwaites.ltd", true },
  { "brakemanpro.com", true },
  { "brakpanplumber24-7.co.za", true },
  { "bralnik.com", true },
  { "bramhallsamusements.com", true },
  { "brammingfys.dk", true },
  { "bramois.tk", true },
  { "bramstaps.nl", true },
  { "bramvanaken.be", true },
  { "bramygrozy.pl", true },
  { "bran.land", true },
  { "branch-bookkeeper.com", true },
  { "branchtrack.com", true },
  { "brandand.co.uk", true },
  { "brandfolder.com", true },
  { "brandingclic.com", true },
  { "brandingclick.com", true },
  { "brandingcoapps.com", true },
  { "brandondivorcelawyer.com", true },
  { "brandonforce.com", true },
  { "brandongomez.me", true },
  { "brandonhubbard.com", true },
  { "brandonlin.me", true },
  { "brandonlui.com", true },
  { "brandonsample.com", true },
  { "brandonwalker.me", true },
  { "brandpit.nl", true },
  { "brandrocket.dk", true },
  { "brandstead.com", true },
  { "brandtrapselfie.nl", true },
  { "brandweerbarboek.nl", true },
  { "brandweerfraneker.nl", true },
  { "brandweertrainingen.nl", true },
  { "brandweeruitgeest.nl", true },
  { "brandwidth.com", true },
  { "brank.as", true },
  { "branno.org", true },
  { "branode.com", false },
  { "bransive.com.au", true },
  { "branw.xyz", false },
  { "brasal.ma", true },
  { "brasalcosmetics.com", true },
  { "brashear.me", true },
  { "brasildxn.com.br", true },
  { "brasileiro.ca", false },
  { "brasserie-mino.fr", true },
  { "brasserie-twins.be", true },
  { "brasserie-twins.com", true },
  { "bratteng.me", true },
  { "bratteng.xyz", true },
  { "bratunaconline.tk", true },
  { "bratvanov.com", true },
  { "brau-ingenieur.de", true },
  { "braudoktor.de", true },
  { "brauingenieur.de", true },
  { "braunsteinpc.com", true },
  { "braunwarth.info", true },
  { "brava.bg", true },
  { "brave-foods.ch", false },
  { "brave-foods.com", false },
  { "brave.com", true },
  { "bravebaby.com.au", true },
  { "bravebooks.berlin", true },
  { "bravica.tk", true },
  { "braviskindenjeugd.nl", true },
  { "bravisziekenhuis.nl", false },
  { "bravobet.et", true },
  { "bravor.pe", true },
  { "braystudio.com", true },
  { "brazenfol.io", true },
  { "brazilian.dating", true },
  { "brazilianbikinishop.com", true },
  { "braziliex.com", true },
  { "brazillens.com", true },
  { "brazoriabar.org", true },
  { "brb.city", true },
  { "brck.nl", true },
  { "brd.ro", true },
  { "bread.red", true },
  { "breadandlife.org", true },
  { "breadofgod.org", true },
  { "breadpirates.chat", true },
  { "breakcraft.tk", true },
  { "breakingtech.fr", true },
  { "breakingtech.it", true },
  { "breakout.careers", true },
  { "breaky.de", true },
  { "breard.tf", true },
  { "breathedreamgo.com", true },
  { "breathingblanket.com", true },
  { "brecht.ch", true },
  { "breckle.com.ua", true },
  { "brecknell.biz", true },
  { "brecknell.com", true },
  { "brecknell.info", true },
  { "brecknell.name", true },
  { "brecknell.net", true },
  { "brecknell.org", true },
  { "bredvid.no", true },
  { "breest.net", true },
  { "breeyn.com", true },
  { "brefy.com", true },
  { "brege.org", true },
  { "bregnedalsystems.dk", true },
  { "breitband.bz.it", true },
  { "breizh.pm", true },
  { "brejoc.com", true },
  { "brelahotelberulia.com", true },
  { "bremen-restaurants.de", true },
  { "bremensaki.com", true },
  { "bremerfriedensforum.de", true },
  { "brenbarnes.com", true },
  { "brenbarnes.com.au", true },
  { "brendanbatliner.com", true },
  { "brendansbits.com", true },
  { "brentacampbell.com", true },
  { "brentnewbury.com", true },
  { "bressier.fr", true },
  { "brest-news.tk", true },
  { "bretcarmichael.com", true },
  { "bretech.net", true },
  { "brettabel.com", true },
  { "brettcornwall.com", true },
  { "brettlawyer.com", true },
  { "brettpostin.com", true },
  { "bretzner.fr", false },
  { "brevboxar.se", true },
  { "brewercollinsleadership.com", true },
  { "brewsouth.com", true },
  { "brewspark.co", true },
  { "brewvo.com", true },
  { "breznet.com", true },
  { "brgins.com", true },
  { "brguk.com", true },
  { "brian-gordon.name", true },
  { "brianalaway.com", true },
  { "brianalawayconsulting.com", true },
  { "briandwells.com", true },
  { "brianfoshee.com", true },
  { "briangosnell.com", true },
  { "brianjohnson.co.za", true },
  { "brianlanders.us", true },
  { "brianmwaters.net", true },
  { "brianpagan.net", true },
  { "brianroadifer.com", true },
  { "briansemrau.com", true },
  { "briansmith.org", true },
  { "briantkatch.com", true },
  { "brianvalente.tk", true },
  { "brianwalther.com", true },
  { "brianwesaala.com", false },
  { "brianwilson.tk", true },
  { "briarproject.org", true },
  { "brickadia.com", true },
  { "brickftp.com", true },
  { "brickheroes.com", false },
  { "brickstreettrio.com", true },
  { "brickvortex.com", false },
  { "brickweb.co.uk", true },
  { "bricolajeux.ch", false },
  { "brid.gy", false },
  { "bridalfabrics.co.uk", true },
  { "bridalfabrics.com", true },
  { "bridalfabrics.fr", true },
  { "bridalfabrics.ru", true },
  { "bridalshoes.com", true },
  { "bridalweddingshow.ga", true },
  { "bride-forever.com", true },
  { "bridgedigest.tk", true },
  { "bridgedirectoutreach.com", true },
  { "bridgeglobalmarketing.com", true },
  { "bridgement.com", true },
  { "bridgercanyonfiremt.gov", false },
  { "bridgetroll.org", true },
  { "bridgevest.com", false },
  { "bridholm.se", true },
  { "bridltaceng.com", true },
  { "brie.tech", true },
  { "briefassistant.com", true },
  { "briefhansa.de", true },
  { "briefkasten-welt.com", true },
  { "briefvorlagen-papierformat.de", true },
  { "brier.me", true },
  { "brighouse-leisure.co.uk", true },
  { "brightday.bz", true },
  { "brightendofleasecleaning.com.au", true },
  { "brightonbank.com", true },
  { "brightonbouncycastles.net", true },
  { "brightonchilli.org.uk", true },
  { "brightpool-markets.com", true },
  { "brightside.com", true },
  { "brightworkcreative.com", true },
  { "brigidaarie.com", true },
  { "brigittefontaine.tk", true },
  { "brilliantbouncyfun.co.uk", true },
  { "brilliantproductions.co.nz", true },
  { "brimspark.systems", true },
  { "brindesgrafica.com.br", true },
  { "brindice.com.br", true },
  { "brindisi.tk", true },
  { "bring-heaven.com", true },
  { "bringingbackthesweatervest.com", true },
  { "brinksurl.com", true },
  { "brio-shop.ch", true },
  { "briograce.com.mx", true },
  { "brioukraine.store", true },
  { "brisbanelogistics.com.au", true },
  { "brisignshop.com.au", true },
  { "brisq.design", true },
  { "bristebein.com", true },
  { "bristolandwestonsuperbounce.com", true },
  { "britanniacateringyeovil.co.uk", true },
  { "britanniapandi.com", true },
  { "britelocate.com", true },
  { "britishbeef.com", true },
  { "britishbookmakers.co.uk", true },
  { "britishgroupsg.com", true },
  { "britishmeat.com", true },
  { "britishpearl.com", true },
  { "britishsciencefestival.org", true },
  { "britishscienceweek.org", true },
  { "britishsfaward.org", true },
  { "britishsnoring.co.uk", true },
  { "britneyclause.com", true },
  { "brittanyferriesnewsroom.com", true },
  { "britton-photography.com", true },
  { "brizawen.com", true },
  { "brk.st", true },
  { "brmsalescommunity.com", true },
  { "brnojebozi.cz", true },
  { "bro.hk", true },
  { "broadbandchoices.co.uk", true },
  { "broadbandnd.com", true },
  { "broadsheet.com.au", true },
  { "broadwayvets.co.uk", true },
  { "broadyexpress.com.au", true },
  { "brockmeyer.net", true },
  { "brockmeyer.org", true },
  { "brodowski.cc", true },
  { "broerict.nl", true },
  { "broersma.com", true },
  { "broeselei.at", true },
  { "brojagraphics.de", true },
  { "brokenhands.io", true },
  { "brokervalues.com", true },
  { "brokolit.com", true },
  { "brols.eu", true },
  { "brompton-cocktail.com", true },
  { "bronetb2b.com.br", true },
  { "bronevichok.ru", true },
  { "bronwynlewis.com", true },
  { "bronzew.com", true },
  { "broodbesteld.nl", true },
  { "broodingblogger.com", true },
  { "brookes.xyz", true },
  { "brooklynentdoc.com", true },
  { "brooklynrealestateblog.com", true },
  { "brosay-legko.ml", true },
  { "brossmanit.com", true },
  { "brouillard.ch", false },
  { "brouskat.be", true },
  { "brouwerijdeblauweijsbeer.nl", true },
  { "brownesgas.com", true },
  { "brownfieldstsc.org", true },
  { "brownforces.desi", true },
  { "brownforces.org", true },
  { "brownihc.com", true },
  { "browntowncountryclub.com", true },
  { "brownwolfstudio.com", true },
  { "browsbybecca.ca", true },
  { "browse-tutorials.com", true },
  { "browsemycity.com", true },
  { "browserleaks.com", true },
  { "brrd.io", true },
  { "brrr.fr", true },
  { "bru6.de", true },
  { "brubank.com", true },
  { "brubankv1-staging.azurewebsites.net", true },
  { "brucekovner.com", true },
  { "brucemartin.net", true },
  { "brucherlaw.lu", true },
  { "bruck.me", true },
  { "bruckmuehler-kanu-club.de", true },
  { "bruckner.li", true },
  { "brudkista.nu", true },
  { "brudkista.se", true },
  { "brudkistan.nu", true },
  { "brudkistan.se", true },
  { "brueser-gmbh.de", true },
  { "brugerklub.info", true },
  { "bruijns.org", true },
  { "brunchandmatch.be", true },
  { "brunick.de", false },
  { "brunn.email", true },
  { "brunner.ninja", true },
  { "brunoproduit.ch", false },
  { "brunoreno.be", true },
  { "brush.ninja", true },
  { "brushcreekyachts.com", true },
  { "brusselsexpoloft.ga", true },
  { "brusselsexpostudio.ga", true },
  { "brutecloud.com", true },
  { "bruun.co", true },
  { "bry.do", true },
  { "bryanarmijomd.com", true },
  { "bryandesrosiers.com", true },
  { "bryanfalchuk.com", true },
  { "bryankaplan.com", true },
  { "bryanphilton.com", true },
  { "bryanquigley.com", true },
  { "bryansmith.net", true },
  { "bryansmith.tech", true },
  { "brycecanyon.net", true },
  { "brycecanyonnationalpark.com", true },
  { "bryggebladet.dk", true },
  { "brzy-svoji.cz", true },
  { "bs-network.net", true },
  { "bs.to", true },
  { "bs12v.ru", true },
  { "bsa157.org", true },
  { "bsaft.ml", true },
  { "bsapack564.org", true },
  { "bsatroop794.org", true },
  { "bsc-rietz.at", true },
  { "bscc.support", true },
  { "bsd-box.net", true },
  { "bsdes.net", true },
  { "bsdio.com", true },
  { "bsdracing.ca", true },
  { "bsdunix.xyz", true },
  { "bsee.gov", true },
  { "bsg.ro", false },
  { "bsgamanet.ro", false },
  { "bsgcredit.ro", true },
  { "bsidesf.com", true },
  { "bsidesf.org", true },
  { "bsidessf.com", true },
  { "bsimerch.com", true },
  { "bsimyanmar.com", true },
  { "bsmn.ga", true },
  { "bsmomo-api.com", true },
  { "bso-buitengewoon.nl", true },
  { "bsociabl.com", true },
  { "bsp-southpool.com", true },
  { "bsquared.org", true },
  { "bssolvfagen-pre-storeswa-wap.azurewebsites.net", true },
  { "bsstainless.com", true },
  { "bstoked.net", true },
  { "bsw-solution.de", true },
  { "bszoft.hu", true },
  { "bt123.xyz", true },
  { "bt3655.com", true },
  { "bt3657.com", true },
  { "bt3658.com", true },
  { "bta.lv", false },
  { "bta00.com", true },
  { "bta55.com", true },
  { "btc-alpha.com", true },
  { "btc-doge.ga", true },
  { "btcarmory.com", true },
  { "btcbenthuizen.nl", true },
  { "btcbolsa.com", true },
  { "btcpop.co", true },
  { "bte365app.com", true },
  { "bteapp.com", true },
  { "btio.pw", false },
  { "btmstore.com.br", true },
  { "btnissanparts.com", true },
  { "btopc.jp", true },
  { "btorrent.xyz", true },
  { "btsapem.com", true },
  { "btshe.net", true },
  { "btshenqi.cc", true },
  { "btsoft.eu", true },
  { "btsou.org", true },
  { "btsow.com", false },
  { "btt0101.com", true },
  { "btt0303.com", true },
  { "btt0505.com", true },
  { "btt0606.com", true },
  { "btt0707.com", true },
  { "btt0707a.com", true },
  { "btt11.net", true },
  { "btt1111.com", true },
  { "btt1212.com", true },
  { "btt1313.com", true },
  { "btt138g.com", true },
  { "btt2020.com", true },
  { "btt2121.com", true },
  { "btt213.com", true },
  { "btt216.com", true },
  { "btt219.com", true },
  { "btt221.com", true },
  { "btt225.com", true },
  { "btt2323a.com", true },
  { "btt2525.com", true },
  { "btt256.com", true },
  { "btt263.com", true },
  { "btt268.com", true },
  { "btt269g.com", true },
  { "btt2929a.com", true },
  { "btt301.com", true },
  { "btt302.com", true },
  { "btt303.com", true },
  { "btt305.com", true },
  { "btt306.com", true },
  { "btt307.com", true },
  { "btt308.com", true },
  { "btt309.com", true },
  { "btt312.com", true },
  { "btt317.com", true },
  { "btt319.com", true },
  { "btt3311.com", true },
  { "btt332.com", true },
  { "btt350.com", true },
  { "btt351.com", true },
  { "btt352.com", true },
  { "btt353.com", true },
  { "btt3535.com", true },
  { "btt355.com", true },
  { "btt358.com", true },
  { "btt359.com", true },
  { "btt361.com", true },
  { "btt362.com", true },
  { "btt368.com", true },
  { "btt371.com", true },
  { "btt372.com", true },
  { "btt373.com", true },
  { "btt375.com", true },
  { "btt376.com", true },
  { "btt378.com", true },
  { "btt379.com", true },
  { "btt381.com", true },
  { "btt381g.com", true },
  { "btt529g.com", true },
  { "btt583g.com", true },
  { "btt6262a.com", true },
  { "btt6363a.com", true },
  { "btt645g.com", true },
  { "btt686.com", true },
  { "btt6868.com", true },
  { "btt7272a.com", true },
  { "btt775.com", true },
  { "btt7878.com", true },
  { "btt8.me", true },
  { "btt818g.com", true },
  { "btt829.com", true },
  { "btt830g.com", true },
  { "btt8787a.com", true },
  { "btt88.net", true },
  { "btt88818.com", true },
  { "btt889g.com", true },
  { "btt891.com", true },
  { "btt8989a.com", true },
  { "btt907.com", true },
  { "btt9090.com", true },
  { "btt918958.com", true },
  { "btt932g.com", true },
  { "btt945g.com", true },
  { "btt9898.com", true },
  { "btt996.com", true },
  { "btta15.com", true },
  { "btta16.com", true },
  { "btta26.com", true },
  { "btta27.com", true },
  { "btta30.com", true },
  { "bttc.co.uk", true },
  { "btth.pl", true },
  { "btth.tv", true },
  { "bttna.com", true },
  { "bttorj45.com", true },
  { "bttp7.com", true },
  { "bttt111.com", true },
  { "bttt222.com", true },
  { "bttt333.com", true },
  { "bttt999.com", true },
  { "bttyulecheng0.com", true },
  { "bttyulecheng7.com", true },
  { "bu-dun.com", true },
  { "buayacorp.com", true },
  { "bubblegumblog.com", true },
  { "bubblespetspa.com", true },
  { "bubblin.io", true },
  { "bubblinghottubs.co.uk", true },
  { "bubblybouncers.co.uk", true },
  { "bubulazi.com", false },
  { "bubulazy.com", true },
  { "bucek.cz", true },
  { "buch-angucken.de", true },
  { "buchhaltung-muehelos.de", true },
  { "buchwegweiser.com", true },
  { "buck-hydro.de", true },
  { "buckelewrealtygroup.com", true },
  { "bucketlist.co.ke", true },
  { "buckscountyobgyn.com", true },
  { "buckypaper.com", true },
  { "buddhismus.net", true },
  { "buddie5.com", true },
  { "buddlycrafts.com", true },
  { "buddy-acceptance-authentication-api.azurewebsites.net", true },
  { "buddy-acceptance-authentication-frontend.azurewebsites.net", true },
  { "buddy-acceptance-backoffice-frontend.azurewebsites.net", true },
  { "buddy-acceptance-banking-api.azurewebsites.net", true },
  { "buddy-acceptance-profiles-api.azurewebsites.net", true },
  { "buddy-acceptance-users-api.azurewebsites.net", true },
  { "buddy-acceptance-web-frontend.azurewebsites.net", true },
  { "buddycompany.net", true },
  { "buddyme.me", true },
  { "buddytop.com", true },
  { "buddyworks.net", true },
  { "budeanu.com", true },
  { "budger.nl", true },
  { "budget.gov", true },
  { "budgetalk.com", true },
  { "budgetboats.net", true },
  { "budgetcastlehire.co.uk", true },
  { "budgetlob.gov", true },
  { "budgetlovers.nl", true },
  { "budgiesballoons.com", true },
  { "budntod.com", true },
  { "budolangnau.ch", true },
  { "budolfs.de", true },
  { "bueltge.de", true },
  { "buena-vista.cz", true },
  { "buena.me", true },
  { "bueny.com", true },
  { "bueny.net", true },
  { "buerger-lenke.de", true },
  { "bueromoebel-experte.de", true },
  { "bueroplus.de", true },
  { "bueroschwarz.design", true },
  { "bueroshop24.de", true },
  { "buettgens.net", true },
  { "buffaloautomation.com", true },
  { "buffaloturf.com.au", true },
  { "buffashe.com", false },
  { "buffup.media", true },
  { "bug.ee", true },
  { "bugcrowd.com", true },
  { "bugginslab.co.uk", true },
  { "bugs.chromium.org", true },
  { "bugsmashed.com", true },
  { "bugteam.cn", true },
  { "bugu.org", true },
  { "bugwie.com", true },
  { "bugzil.la", true },
  { "bugzilla.mozilla.org", true },
  { "build.chromium.org", true },
  { "buildbytes.com", true },
  { "buildhoscaletraingi.com", true },
  { "buildiffuse.com", false },
  { "buildingclouds.de", true },
  { "buildkite.com", true },
  { "buildmorebuslanes.com", true },
  { "buildplease.com", true },
  { "builtory.my", true },
  { "builtvisible.com", true },
  { "builtwith.com", true },
  { "buissonchardin.fr", true },
  { "bukiskola.hu", true },
  { "bukkenfan.jp", true },
  { "bulario.com", true },
  { "bulario.net", true },
  { "bularmas.com", true },
  { "bulgarianwine.com", true },
  { "bulkcandystore.com", true },
  { "bulktshirtsjohannesburg.co.za", true },
  { "bulkwholesalesweets.co.uk", true },
  { "bulldog-hosting.de", false },
  { "bulledair-savons.ch", false },
  { "bullettags.com", true },
  { "bullshitmail.nl", true },
  { "bullterrier.nu", true },
  { "bulvar.tk", true },
  { "bulwarkcrypto.com", true },
  { "bulwarkhost.com", true },
  { "bumble.com", true },
  { "bund-von-theramore.de", true },
  { "bundespolizei-forum.de", true },
  { "bundito.com", true },
  { "bungabuket.com", true },
  { "bungee.pw", true },
  { "bunix.de", true },
  { "bunkyo-life.com", true },
  { "bunny-rabbits.com", true },
  { "bunny.parts", true },
  { "bunnycarenotes.com", true },
  { "bunnydiamond.de", true },
  { "bunzy.ca", true },
  { "buonventosbt.eu", true },
  { "bupropion.com", true },
  { "burakogun.com", true },
  { "burakogun.com.tr", true },
  { "burakogun.net", true },
  { "burakogun.net.tr", true },
  { "burakogun.org", true },
  { "burbankdental.com", true },
  { "burcevo.info", true },
  { "bureaugoodwork.nl", true },
  { "burg-hohnstein.com", true },
  { "burgernet.nl", true },
  { "burgers.io", true },
  { "burghardt.pl", true },
  { "buri.be", true },
  { "burialinsurancenetwork.com", true },
  { "burienergy.com", true },
  { "buriramradio.com", true },
  { "burke.services", true },
  { "burkhardt.at", true },
  { "burlapsac.ca", true },
  { "burnerfitness.com", true },
  { "burnhamonseabouncycastles.co.uk", true },
  { "burningbird.net", true },
  { "burningflipside.com", false },
  { "burningmarket.de", true },
  { "burntfish.com", true },
  { "burnworks.com", true },
  { "buronwater.com", true },
  { "burotec-sarl.com", true },
  { "burr.is", true },
  { "bursaries-southafrica.co.za", true },
  { "burtrum.family", true },
  { "burtrum.me", true },
  { "burtrum.name", true },
  { "burtrum.org", true },
  { "burzcast.ro", true },
  { "burzmali.com", true },
  { "burzum.ch", true },
  { "buscandolosmejores.com", true },
  { "buscasimple.com", true },
  { "buselefante.tk", true },
  { "bushbaby.com", true },
  { "busindre.com", true },
  { "business-garden.com", true },
  { "business-secreti.gq", true },
  { "business-secreti.tk", true },
  { "business.facebook.com", false },
  { "business.gov", true },
  { "businesscentermarin.ch", false },
  { "businessesdirectory.eu", true },
  { "businessfactors.de", true },
  { "businessloanconnection.org", false },
  { "businessmarketingblog.org", true },
  { "businesspartner.tk", true },
  { "businesswebadmin.com", true },
  { "busold.ws", true },
  { "busphotos.tk", true },
  { "bustabit.com", true },
  { "bustadice.com", true },
  { "bustany.org", true },
  { "buster.me.uk", true },
  { "busuttil.org.uk", true },
  { "buswiki.ml", true },
  { "butarque.es", true },
  { "buthowdoyoubuygroceries.com", true },
  { "butikvip.ru", true },
  { "butlerfm.dk", true },
  { "butter.horse", true },
  { "butteramotors.com", true },
  { "buttgun-tattoo.de", true },
  { "buttoned.io", true },
  { "buttonizer.pro", true },
  { "buttonline.ch", true },
  { "butts-are.cool", true },
  { "butz.cloud", true },
  { "butzies.ddnss.org", true },
  { "buurtpreventiefraneker.nl", true },
  { "buxum-communication.ch", false },
  { "buy-an-essay.gq", true },
  { "buy-essay-online.ga", true },
  { "buy-lasix-without-a-doctor-s-prescription.ga", true },
  { "buy-los-angeles-auto-insurance.com", true },
  { "buy-out.jp", true },
  { "buy-zofran.ga", true },
  { "buy2dollars.com", true },
  { "buyaccessible.gov", true },
  { "buyamerican.gov", false },
  { "buybutton.store", true },
  { "buycccam.tv", true },
  { "buycoins.top", true },
  { "buycurious.co.uk", true },
  { "buydiflucan.ml", true },
  { "buydissertations.com", true },
  { "buyerdocs.com", true },
  { "buyessay.org", true },
  { "buyessays.net", true },
  { "buyessayscheap.com", true },
  { "buyinginvestmentproperty.com", true },
  { "buylasix.ml", true },
  { "buylevaquin.tk", true },
  { "buypapercheap.net", true },
  { "buyplaytix.com", true },
  { "buyplore.com", true },
  { "buyrogaine.ga", true },
  { "buyseo.store", true },
  { "buysildenafil.ml", true },
  { "buysoft.co.uk", true },
  { "buytermpaper.com", true },
  { "buyusa.gov", true },
  { "buzz.tools", true },
  { "buzzcontent.com", true },
  { "buzzprint.it", true },
  { "bvalle.com", true },
  { "bvbmedia.nl", true },
  { "bvgt.org", true },
  { "bviphotovideo.com", true },
  { "bvl.aero", true },
  { "bvsa.co.za", true },
  { "bw.codes", true },
  { "bwanglab.com", true },
  { "bwcscorecard.org", true },
  { "bwfc.nl", true },
  { "bwgjms.com", true },
  { "bwgjms.net", true },
  { "bwgjms.org", true },
  { "bwh1.net", false },
  { "bwhbwh.com", true },
  { "bwhbwh.net", true },
  { "bwilkinson.co.uk", true },
  { "bwin18.cc", true },
  { "bwin369.cc", true },
  { "bwin58.cc", true },
  { "bwl-earth.club", true },
  { "bws16.de", true },
  { "bwserhoscaletrainaz.com", true },
  { "bx-n.de", true },
  { "bxegypt.com", true },
  { "bxp40.at", true },
  { "by-robyn.nl", true },
  { "byange.pro", true },
  { "byatte.com", true },
  { "byaustere.com", true },
  { "bye-bye.us", true },
  { "byeskille.no", true },
  { "byggonline.ga", true },
  { "bygningsregistrering.dk", true },
  { "byjamesrush.com", true },
  { "byjuschennai.com", true },
  { "bymark.co", true },
  { "bymike.co", true },
  { "bynder.com", true },
  { "bynet.cz", true },
  { "bypass.sh", true },
  { "bypetula.cz", true },
  { "byraje.com", true },
  { "byrko.cz", true },
  { "byrnesagency.com", true },
  { "byronkg.us", true },
  { "byrtz.de", true },
  { "bysgo.com", true },
  { "bytanchan.com", true },
  { "byte-time.com", true },
  { "byte.nl", true },
  { "byte128.com", true },
  { "bytearts.net", false },
  { "bytebucket.org", true },
  { "bytecode.no", true },
  { "byteflies.com", true },
  { "bytegoing.com", true },
  { "bytejail.com", true },
  { "bytelog.org", false },
  { "bytema.cz", true },
  { "bytema.eu", true },
  { "bytema.sk", true },
  { "bytemix.cloud", true },
  { "bytenoc.nl", true },
  { "bytepen.com", true },
  { "bytes.co", true },
  { "bytes.fyi", true },
  { "bytesatwork.de", true },
  { "byteshark.org", true },
  { "bytesign.de", true },
  { "bytesizedalex.com", true },
  { "bytesund.biz", true },
  { "bytesunlimited.com", false },
  { "byteswave.cl", true },
  { "bytesystems.com", true },
  { "byteterrace.com", true },
  { "bytheglass.gr", true },
  { "bytheswordinc.com", true },
  { "bythisverse.com", true },
  { "bytrain.net", true },
  { "byvshie.com", true },
  { "byxong.com", true },
  { "bzh.tf", true },
  { "bziaks.xyz", true },
  { "bzsparks.com", false },
  { "bztech.com.br", true },
  { "bzv-fr.eu", true },
  { "c-3.moe", true },
  { "c-aeroconsult.com", true },
  { "c-ma-copro.com", true },
  { "c-rtx.com", true },
  { "c-shock.org", true },
  { "c-webdesign.net", true },
  { "c-world.co.uk", true },
  { "c.cc", true },
  { "c00ke.com", true },
  { "c0rporation.com", true },
  { "c2design.it", true },
  { "c2lab.net", true },
  { "c36533.com", true },
  { "c36594.com", true },
  { "c3kidspace.de", true },
  { "c3sign.de", false },
  { "c3softworks.com", true },
  { "c3vo.de", true },
  { "c3w.at", true },
  { "c3wien.at", true },
  { "c3woc.de", false },
  { "c4539.com", true },
  { "c4k3.net", true },
  { "c5h8no4na.net", true },
  { "c7dn.com", true },
  { "c86255.com", true },
  { "c8ms113.com", true },
  { "ca-key.de", true },
  { "ca.gparent.org", true },
  { "ca.search.yahoo.com", false },
  { "ca5.de", true },
  { "caaps.org.au", true },
  { "caarecord.org", true },
  { "caasd.org", true },
  { "cabalacoach.com", true },
  { "cabaladada.org", true },
  { "cabarave.com", true },
  { "cabecera-descendimiento.tk", true },
  { "cabelgrano.tk", true },
  { "cabezadelcaballo.tk", true },
  { "cabforum.org", true },
  { "cabineritten.nl", true },
  { "cabinet-bedin.com", true },
  { "cabinet-life.fr", true },
  { "cabinetfurnituree.com", true },
  { "cablemod.com", true },
  { "cablesandkits.com", true },
  { "cabotfinancial.co.uk", true },
  { "cabuna.hr", true },
  { "cacao-chocolate.com", true },
  { "cacao.supply", true },
  { "cacaolalina.com", true },
  { "cacaumidade.com.br", true },
  { "cachacacha.com", true },
  { "cachedview.nl", true },
  { "cachetur.no", true },
  { "cackette.com", true },
  { "cacn.pw", true },
  { "cacrm.com", true },
  { "cactuspedia.ga", true },
  { "cad-noerdlingen.de", true },
  { "cadafamilia.de", true },
  { "cadams.io", true },
  { "caddyfashionshop.com", true },
  { "cadenceconstruction.com", true },
  { "cadep2019.com", true },
  { "cadetsge.ch", false },
  { "cadifit.ga", true },
  { "cadmail.nl", true },
  { "cadman.pw", true },
  { "cadmanlaw.ca", true },
  { "cadmanlaw.com", true },
  { "cadmax.pro", true },
  { "cadooz.com", true },
  { "cadorama.fr", true },
  { "cadoth.net", true },
  { "cadra.nl", true },
  { "cadre.com", true },
  { "cadsys.net", true },
  { "caesarkabalan.com", true },
  { "caetanobenet.es", true },
  { "caetanoflotas.es", true },
  { "caetanoformula.es", true },
  { "caetanoformulacadiz.es", true },
  { "caetanoformulagalicia.es", true },
  { "caetanomotorsmalaga.es", true },
  { "caetanoreicomsa.es", true },
  { "cafedelahalle.com", true },
  { "cafedupont.be", true },
  { "cafedupont.co.uk", true },
  { "cafedupont.de", true },
  { "cafedupont.nl", true },
  { "cafeimsueden.de", true },
  { "cafejulian.com", true },
  { "cafelandia.net", true },
  { "cafenix.tk", true },
  { "cafeobscura.nl", true },
  { "caferagazzi.de", true },
  { "cafermin.com", true },
  { "cafeterasbaratas.net", true },
  { "caffeinatedcode.com", true },
  { "caffeinatedengineers.com", true },
  { "caffeinefiend.org", true },
  { "cafled.org", true },
  { "caglarcakici.com", true },
  { "cainhosting.com", false },
  { "cairuz.in", true },
  { "cais.de", true },
  { "caizx.com", false },
  { "caja-pdf.es", true },
  { "cajalosandes.cl", true },
  { "cajio.ru", true },
  { "cakearific.com", true },
  { "cakeoffencesact.uk", true },
  { "cakesbyzoey.com", true },
  { "cakestart.net", true },
  { "caketoindia.com", true },
  { "cakingandbaking.com", true },
  { "cakirlarshipyard.com", true },
  { "calaad.net", true },
  { "calabasaselectric.com", true },
  { "calabasaselectrical.com", true },
  { "calabasaselectrician.com", true },
  { "calabasasexteriorlighting.com", true },
  { "calabasaslandscapelighting.com", true },
  { "calabasaslighting.com", true },
  { "calabasasoutdoorlighting.com", true },
  { "calaborlawnews.com", true },
  { "calafont.cat", false },
  { "calandrahosting.tk", true },
  { "calaverasmedicalcannabis.com", true },
  { "calbertsen.dk", true },
  { "calcedge.com", true },
  { "calcinacci.com", true },
  { "calcioragusa.tk", true },
  { "calcoolator.pl", true },
  { "calculadoraconversor.com", true },
  { "calcularis.ch", true },
  { "calculateaspectratio.com", true },
  { "calculates.org", true },
  { "calculator-imt.com", true },
  { "calculator.tf", true },
  { "calcworkshop.com", true },
  { "caldersoldas.com.br", true },
  { "caldervets.co.uk", true },
  { "caldoletto.com", true },
  { "calebthompson.io", true },
  { "calehoo.com", true },
  { "calendar.cf", false },
  { "calendar.google.com", true },
  { "calendarr.com", true },
  { "calendarsnow.com", true },
  { "calendly.com", true },
  { "calendriergn.ch", true },
  { "calenfil.com", true },
  { "caletka.cz", true },
  { "calgoty.com", true },
  { "calibra.com", true },
  { "calibreapp.com", false },
  { "calibso.net", true },
  { "calichines.com", true },
  { "caliderumba.com", true },
  { "californiawomensmedicalclinic.com", true },
  { "calitateavietii-ardeal.ro", true },
  { "calixte-concept.fr", true },
  { "call-centervko.kz", true },
  { "call.me", true },
  { "callanan.nl", true },
  { "callantonia.com", true },
  { "callear.org", true },
  { "callerstrom.se", true },
  { "callfunc.com", true },
  { "callhub.io", true },
  { "callmewhatever.com", true },
  { "calltoar.ms", true },
  { "calltothepen.com", true },
  { "callumsilcock.com", true },
  { "callumsilcock.me", true },
  { "calluna.nl", true },
  { "calluro.hr", true },
  { "calmtech.com", true },
  { "calomel.org", true },
  { "calonmahasiswa.com", true },
  { "calotte-academy.com", true },
  { "calposa.ml", true },
  { "calrotaract.org", true },
  { "calucon.de", true },
  { "calverleyparish.church", true },
  { "calvin.my", true },
  { "calvinallen.net", false },
  { "calzadonline1-latam.com", true },
  { "calzadonline1.com", true },
  { "camago.dk", true },
  { "camara360grados.com", true },
  { "camaradivisas.com", true },
  { "camaras.uno", true },
  { "camarilloelectric.com", true },
  { "camarilloelectrical.com", true },
  { "camarilloexteriorlighting.com", true },
  { "camarillolandscapelighting.com", true },
  { "camarillolighting.com", true },
  { "camarillooutdoorlighting.com", true },
  { "camashop.de", true },
  { "camastowncar.com", true },
  { "cambiemosjuegos.com", true },
  { "cambier.org", true },
  { "cambiowatch.ch", false },
  { "cambodiainfo.tk", true },
  { "cambodian.dating", true },
  { "cambreaconsulting.com", true },
  { "cambridge-examen.nl", true },
  { "cambridge-security.com", true },
  { "cambridgebouncers.co.uk", true },
  { "cambridgesecuritygroup.org", true },
  { "cambuslangharriers.org", true },
  { "camcapital.com", true },
  { "camconn.cc", true },
  { "camdesign.pl", true },
  { "cameo-membership.uk", true },
  { "camera-news.com", true },
  { "cameramark.nl", true },
  { "cameraslyphotography.tk", true },
  { "cameraviva.com.br", true },
  { "camerweb.es", true },
  { "camilomodzz.net", true },
  { "camisetasmalwee.com.br", true },
  { "camolist.com", true },
  { "camp-pleinsoleil.ch", true },
  { "camp.co.uk", true },
  { "campaign-ad.com", true },
  { "campaign.gov.uk", true },
  { "campaignhelpdesk.org", true },
  { "campaignlake.com", true },
  { "campaignwiki.org", true },
  { "campamentos.info", true },
  { "campbellapplianceheatingandair.com", true },
  { "campcambodia.org", true },
  { "campcanada.org", true },
  { "camperdays.de", true },
  { "camperlist.com", true },
  { "campermanaustralia.com", true },
  { "campertrailerfinance.com.au", true },
  { "camperverzekerd.nl", true },
  { "campfiretails.org", true },
  { "camping-aupigeonnier.fr", true },
  { "camping-landes.com", true },
  { "camping-le-pasquier.com", true },
  { "camping-seilershof.de", true },
  { "campinghuntingshooting.com", true },
  { "campingshop.pl", true },
  { "campingskyhooks.com", true },
  { "campistry.net", true },
  { "campmackinaw.com", true },
  { "campo-salado.com", true },
  { "campsoulfestival.com", true },
  { "campula.cz", true },
  { "campus-discounts.com", true },
  { "campus-finance.com", true },
  { "campusdrugprevention.gov", false },
  { "campusfit.co", true },
  { "campuswire.com", true },
  { "campvana.com", true },
  { "campwabashi.org", true },
  { "camshowdir.com", true },
  { "camshowdir.to", true },
  { "camshowhive.to", true },
  { "camshowhub.com", true },
  { "camshowhub.to", true },
  { "camshowplace.to", true },
  { "camshowstorage.com", true },
  { "camshowstorage.to", true },
  { "camshowverse.com", true },
  { "camshowverse.to", true },
  { "camsky.de", false },
  { "canada.ind.br", true },
  { "canadabread.com", false },
  { "canadaradon.com", true },
  { "canadasmotorcycle.ca", true },
  { "canadian.dating", true },
  { "canadianatheists.ca", true },
  { "canadianatheists.com", true },
  { "canadianoutdoorequipment.com", true },
  { "canadiantouristboard.com", true },
  { "canalecontracting.com", true },
  { "canalsidehouse.be", true },
  { "canalsidehouse.com", true },
  { "canariculturacolor.com", true },
  { "canarymod.net", true },
  { "canavilage.com", true },
  { "canavillage.net", true },
  { "canavillagepuntacana.com", true },
  { "canavillageresidences.com", true },
  { "canberraoutletcentre.com.au", true },
  { "cancerdata.nhs.uk", true },
  { "candaceplayforth.com", true },
  { "candelec.com", false },
  { "candeo-books.nl", true },
  { "candex.com", true },
  { "candguchocolat.com", true },
  { "candicecity.com", true },
  { "candidasa.com", true },
  { "candidateexperiencemarketing.nl", true },
  { "candidatlibre.net", true },
  { "candidaturedunprix.com", true },
  { "candinya.com", true },
  { "candinya.me", true },
  { "cando.eu", true },
  { "canfazz.com", true },
  { "cangku.in", true },
  { "canglong.net", true },
  { "canhas.report", true },
  { "canhazip.com", true },
  { "canhq.tk", true },
  { "canihavesome.coffee", true },
  { "canine-mobility.com", true },
  { "caniuse.email", true },
  { "canker.org", true },
  { "canmipai.com", true },
  { "cannabis-marijuana.com", true },
  { "cannabiscare.ca", true },
  { "cannabislegality.info", true },
  { "cannabismd.com", true },
  { "cannacards.ca", true },
  { "cannacun.com", true },
  { "cannaffiliate.com", true },
  { "cannagoals.com", true },
  { "cannahealth.com", true },
  { "cannoli.london", true },
  { "cannyfoxx.me", true },
  { "canobag.es", true },
  { "canoonic.se", true },
  { "canopycleaningmelbourne.com.au", true },
  { "canopytax.com", true },
  { "cant.at", true },
  { "cantatio.ch", false },
  { "canterbury.ws", true },
  { "canterburybouncycastlehire.co.uk", true },
  { "cantonroadjewelry.com", true },
  { "cantosdisidentes.tk", true },
  { "canttboardpachmarhi.org", true },
  { "canva-dev.com", true },
  { "canva.cn", true },
  { "canva.com", true },
  { "canx.org", true },
  { "canyonshoa.com", true },
  { "canyoupwn.me", true },
  { "cao.gov", true },
  { "cao.la", true },
  { "caoliu.tech", true },
  { "caoshan60.com", true },
  { "capachitos.cl", true },
  { "capacitacionyautoempleo.com", true },
  { "capacityproject.org", true },
  { "capbig.com", true },
  { "capeannpediatrics.com", true },
  { "capebretonpiper.com", true },
  { "caph.info", true },
  { "caphane.com", true },
  { "caphefin.com", true },
  { "capillary.io", true },
  { "capitainebaggy.ch", false },
  { "capital-match.com", true },
  { "capitalcap.com", true },
  { "capitalcollections.org.uk", true },
  { "capitalfps.com", true },
  { "capitalibre.com", true },
  { "capitalism.party", true },
  { "capitalist.cf", true },
  { "capitalmediaventures.co.uk", true },
  { "capitalonecardservice.com", true },
  { "capitalp.jp", true },
  { "capitalquadatv.org.nz", true },
  { "capitolpathways.org", true },
  { "caplinbouncycastles.co.uk", true },
  { "capper.de", true },
  { "capriccio.to", true },
  { "caprichosdevicky.com", true },
  { "caps.is", true },
  { "capsogusto.com", true },
  { "capstansecurity.co.uk", true },
  { "capstansecurity.com", true },
  { "capstoneinsights.com", true },
  { "captain-dandelion.com", true },
  { "captainark.net", true },
  { "captainfit.in", true },
  { "captainsfarm.in", true },
  { "captivationtheory.com", true },
  { "capturapp.com", false },
  { "capture-app.com", true },
  { "capuchinox.com", true },
  { "caputodesign.com", true },
  { "car-spaw-rac.fr", true },
  { "car.info", true },
  { "car24.de", true },
  { "car24portal.de", true },
  { "caraccio.li", true },
  { "carapax.net", true },
  { "carassure.de", true },
  { "carauctionnetwork.com", true },
  { "carauctionsalabama.com", true },
  { "carauctionscarolina.com", true },
  { "carauctionsgeorgia.com", true },
  { "carauctionsillinois.com", true },
  { "caravanserail.info", true },
  { "carbon-designz.com", true },
  { "carbon-project.org", true },
  { "carbon.coop", true },
  { "carbon12.org", true },
  { "carbon12.software", true },
  { "carbonating.com", true },
  { "carboneselectricosnettosl.info", false },
  { "carbonnel.me", true },
  { "carbono.uy", true },
  { "carbontv.com", true },
  { "carburetorcycleoi.com", true },
  { "carbuyersbrisbane.com.au", true },
  { "carcloud.ch", true },
  { "card-cashing.com", true },
  { "cardano.eco", true },
  { "cardanoinvestment.com", true },
  { "cardcaptorsakura.jp", true },
  { "carddreams.be", true },
  { "carddreams.de", true },
  { "carddreams.es", true },
  { "carddreams.nl", true },
  { "cardexchangesolutions.com", true },
  { "cardiagnostics.tk", true },
  { "cardioc.ru", true },
  { "cardios.srv.br", true },
  { "cardoni.net", true },
  { "cardozovargas.com", true },
  { "cardozovargas.me", true },
  { "cardranking.jp", true },
  { "cardrecovery.fr", true },
  { "cardsolutionsbh.com.br", true },
  { "cardxl.be", true },
  { "cardxl.de", true },
  { "cardxl.fr", true },
  { "cardxl.nl", true },
  { "care-spot.biz", true },
  { "care-spot.com", true },
  { "care-spot.info", true },
  { "care-spot.mobi", true },
  { "care-spot.net", true },
  { "care-spot.org", true },
  { "care-spot.us", true },
  { "care4all.com", true },
  { "careeapp.com", true },
  { "career.support", true },
  { "careeroptionscoach.com", true },
  { "careers.plus", true },
  { "careertransformed.com", true },
  { "carefulcolor.com", true },
  { "caremad.io", true },
  { "carepan.ga", true },
  { "carepassport.com", true },
  { "carespot.biz", true },
  { "carespot.co", true },
  { "carespot.mobi", true },
  { "carespot.net", true },
  { "carespot.org", true },
  { "carespot.us", true },
  { "carespotexpress.com", true },
  { "carespotexpresshealthcare.com", true },
  { "carespottravelmedicine.com", true },
  { "carespoturgentcare.com", true },
  { "carespoturgentcare.info", true },
  { "carespoturgentcare.net", true },
  { "carespoturgentcare.org", true },
  { "carespoturgentcare.us", true },
  { "caretta.co.uk", true },
  { "careyshop.cn", true },
  { "carezone.com", false },
  { "carfinancehelp.com", true },
  { "carfinans.ru", true },
  { "carfraemill.co.uk", true },
  { "cargobas.com", true },
  { "cargoguard.com", true },
  { "cargomaps.com", true },
  { "cargorestraintsystems.com.au", true },
  { "cargosapiens.com.br", true },
  { "carhunters.cz", true },
  { "caribbean.dating", true },
  { "caribbeanexams.com", true },
  { "caribougrill.com", true },
  { "caribuku.tk", true },
  { "carigami.fr", true },
  { "caringladies.org", true },
  { "carinthia.eu", true },
  { "carisenda.com", true },
  { "carium.com", true },
  { "carkeysanantonio.com", true },
  { "carlavitalesteticista.com", true },
  { "carlgo11.com", true },
  { "carlife-at.jp", true },
  { "carlili.fr", true },
  { "carlingfordapartments.com.au", true },
  { "carlinmack.com", true },
  { "carlitoxxpro.com", true },
  { "carlmjohnson.net", false },
  { "carlobiagi.de", true },
  { "carlocksmith--dallas.com", true },
  { "carlocksmithbaltimore.com", true },
  { "carlocksmithcarrollton.com", true },
  { "carlocksmithellicottcity.com", true },
  { "carlocksmithfallbrook.com", true },
  { "carlocksmithkey.com", true },
  { "carlocksmithlewisville.com", true },
  { "carlocksmithmesquite.com", true },
  { "carlocksmithtucson.com", true },
  { "carlosabarbamd.com", true },
  { "carlosfelic.io", true },
  { "carlosjeurissen.com", true },
  { "carlosjeurissen.nl", true },
  { "carlosmfalves.eu", true },
  { "carlot-j.com", true },
  { "carls-fallout-4-guide.com", true },
  { "carltontownfc.tk", true },
  { "carmatworld.co.uk", true },
  { "carmelglenane.com", true },
  { "carmelrise.co.uk", true },
  { "carmeni.tk", true },
  { "carmenluz.fr", true },
  { "carmineforsheriff.com", true },
  { "carnaticalifornia.com", true },
  { "carnet-du-voyageur.com", true },
  { "carnildo.com", true },
  { "caroes.be", true },
  { "caroffer.ch", true },
  { "carol-lambert.com", true },
  { "carolcappelletti.com", true },
  { "carolcestas.com", true },
  { "caroli.com", true },
  { "caroli.name", true },
  { "caroli.net", true },
  { "carolicious.tk", true },
  { "carolina.cz", true },
  { "carolinaclimatecontrolsc.com", true },
  { "carolinaoliveira.tk", true },
  { "carolinapainandspine.com", true },
  { "carolineball.com", true },
  { "carolineeball.com", true },
  { "carolinehanania.com", true },
  { "carolynjoyce.com.au", true },
  { "carontetourist.hr", true },
  { "carontetouristisoleminori.it", true },
  { "carousel.ga", true },
  { "carparo.net", true },
  { "carpet---cleaning.com", true },
  { "carpetandhardwoodflooringpros.com", true },
  { "carpetcleaning-cypress.com", true },
  { "carpetcleaningtomball.com", true },
  { "carplus.es", true },
  { "carplus.net", true },
  { "carpuya.ga", true },
  { "carrabiners.tk", true },
  { "carrando.com", true },
  { "carre-lutz.com", true },
  { "carriedin.com", true },
  { "carrierplatform.com", true },
  { "carringtonrealtygroup.com", true },
  { "carroattrezzimilanodaluiso.it", true },
  { "carroceriascarluis.com", true },
  { "cars4salecy.com", true },
  { "carshippingcarriers.com", true },
  { "carson-aviation-adventures.com", true },
  { "carson-matthews.co.uk", true },
  { "carsoug.com", true },
  { "carspneu.cz", true },
  { "cartaodigi.com", true },
  { "cartegrise.xyz", true },
  { "carteirasedistintivos.com.br", true },
  { "carterdan.net", true },
  { "carterstad.se", true },
  { "cartertonscouts.org.nz", true },
  { "cartes-voyance.fr", true },
  { "cartesentreprises-unicef.fr", true },
  { "carthedral.com", true },
  { "cartierplan.ga", false },
  { "carto.la", true },
  { "cartongesso.roma.it", true },
  { "cartooncastles.ie", true },
  { "cartouche24.eu", true },
  { "cartucce24.it", true },
  { "cartwrightrealestate.com", true },
  { "carusorealestate.com", true },
  { "carwashdruten.nl", true },
  { "carwellness-hinkelmann.de", true },
  { "cas-chauxdefonds.ch", true },
  { "casa-app.de", true },
  { "casa-due-pur.com", true },
  { "casa-due-pur.de", true },
  { "casa-due.com", true },
  { "casa-laguna.net", true },
  { "casa-lunch-break.de", true },
  { "casa-lunchbreak.de", true },
  { "casa-mea-inteligenta.ro", true },
  { "casaasia.cat", true },
  { "casaasia.es", true },
  { "casaasia.eu", true },
  { "casabouquet.com", true },
  { "casacazoleiro.com", true },
  { "casacochecurro.com", true },
  { "casadasportasejanelas.com", true },
  { "casadoarbitro.com.br", true },
  { "casadopulpo.com", true },
  { "casadowifi.com.br", true },
  { "casalindamex.com", true },
  { "casalribeiro.com", true },
  { "casalunchbreak.de", true },
  { "casamariposaspi.com", true },
  { "casapalla.com.br", true },
  { "casasuara.com", true },
  { "casavacanze.estate", true },
  { "casbuijs.nl", true },
  { "casburggraaf.com", false },
  { "casc.cz", true },
  { "cascadesjobcorpscca.com", true },
  { "cascavelle.fr", true },
  { "cascavelle.nl", true },
  { "case-vacanza-salento.com", true },
  { "casecoverkeygi.com", true },
  { "casecurity.org", true },
  { "caseificio.roma.it", true },
  { "caseof.fr", true },
  { "caseplus-daem.de", true },
  { "cases.lu", true },
  { "caseycapitalpartners.com", true },
  { "cash-4x4.com", true },
  { "cashati.com", true },
  { "cashbook.co.tz", true },
  { "cashbot.cz", true },
  { "cashbot.sk", true },
  { "cashenvoy.com", true },
  { "cashfazz.com", true },
  { "cashflowstrategist.com", true },
  { "cashforcarremovalsipswich.com.au", true },
  { "cashlogic.ch", false },
  { "cashmaxtexas.com", true },
  { "cashontime.com", true },
  { "cashplk.com", true },
  { "casian.ir", true },
  { "casino-cash-flow.com", true },
  { "casino-cash-flow.com.ru", true },
  { "casino-cash-flow.info", true },
  { "casino-cash-flow.pro", true },
  { "casino-cash-flow.ru", true },
  { "casino-cash-flow.su", true },
  { "casino-cashflow.ru", true },
  { "casinocash-flow.ru", true },
  { "casinocashflow.pro", true },
  { "casinocashflow.ru", true },
  { "casinocashflow.su", true },
  { "casinocashflow.xyz", true },
  { "casinochecking.com", true },
  { "casinoguide.dk", true },
  { "casinolegal.pt", true },
  { "casinolistings.com", true },
  { "casinomucho.com", true },
  { "casinomucho.org", true },
  { "casinomucho.se", true },
  { "casinoportugal.pt", true },
  { "casinorewards.info", true },
  { "casinorobots.com", true },
  { "casinosblockchain.io", true },
  { "casinotokelau.tk", true },
  { "casio-caisses-enregistreuses.fr", true },
  { "casjenprome.cz", true },
  { "casperfirm.com", true },
  { "casperpanel.com", true },
  { "caspicards.com", true },
  { "cassimo.com", false },
  { "castbulletassoc.org", false },
  { "castelannenberg.com", true },
  { "castellet.tk", true },
  { "castiana.xyz", true },
  { "castible.de", true },
  { "castle-engine.io", true },
  { "castle.network", true },
  { "castlecapers.com.au", true },
  { "castlecms.io", true },
  { "castleking.net", true },
  { "castlekingdomstockport.co.uk", true },
  { "castlekingkent.co.uk", true },
  { "castleparty.co.uk", true },
  { "castlepointanime.com", true },
  { "castles-in-the-sky.co.uk", true },
  { "castles4kidz.com", true },
  { "castlesrus-kent.com", true },
  { "castleswa.com.au", true },
  { "castrillodelavega.tk", true },
  { "cat.net", true },
  { "cat73.org", true },
  { "cat93.com", true },
  { "catalog-underwear.tk", true },
  { "catalog.beer", true },
  { "catalogobiblioteca.com", true },
  { "catalogobiblioteca.net", true },
  { "catalogosvirtualesonline.com", true },
  { "catalyconv.com", true },
  { "catalystapp.co", true },
  { "catbold.space", true },
  { "catbox.moe", true },
  { "catbull.com", true },
  { "catburton.co.uk", true },
  { "catchers.cc", true },
  { "catchersgear.com", true },
  { "catchhimandkeephim.com", true },
  { "catchief.com", true },
  { "catchkol.com", true },
  { "catcoxx.de", true },
  { "catenacondos.com", true },
  { "caterbing.com", true },
  { "catering-xanadu.cz", true },
  { "cateringvanhetland.nl", true },
  { "catfooddispensersreviews.com", true },
  { "catgirl.science", true },
  { "catharinesomerville.com", true },
  { "catharisme.eu", false },
  { "cathcartandwinn.com", true },
  { "catherinejf.com", true },
  { "cathiebrousse.com", true },
  { "catholic8964.org", true },
  { "catholics.dating", true },
  { "catholicteacherresources.com", true },
  { "cathosa.nl", true },
  { "cathouse.me", true },
  { "cathy.guru", true },
  { "cathy.lgbt", true },
  { "cathy.website", true },
  { "cathyfitzpatrick.com", true },
  { "cathyjf.ca", true },
  { "cathyjf.com", true },
  { "cathyjf.net", true },
  { "cathyjf.org", true },
  { "cathyjfitzpatrick.com", true },
  { "catiadecastro.com", true },
  { "cativa.net", true },
  { "catl.st", true },
  { "catlovingcare.com", true },
  { "catmoose.ca", true },
  { "catram.org", true },
  { "catus.moe", true },
  { "catveteran.com", true },
  { "caughtredhanded.co.nz", true },
  { "caulfieldeastapartments.com.au", true },
  { "caulfieldracecourseapartments.com.au", true },
  { "cav.ac", true },
  { "cavac.at", true },
  { "cavenderhill.com", true },
  { "cavern.tv", true },
  { "cavzodiaco.com.br", true },
  { "caxalt.com", true },
  { "caycehouse.com", true },
  { "caylercapital.com", true },
  { "cazaviajes.es", true },
  { "cazes.info", true },
  { "cb-crochet.com", true },
  { "cb1388.com", true },
  { "cb1588.com", true },
  { "cbbank.com", true },
  { "cbc-hire.co.uk", true },
  { "cbcf.info", true },
  { "cbd.casa", true },
  { "cbd.supply", true },
  { "cbdcontact.eu", true },
  { "cbdev.de", true },
  { "cbdmarket.space", true },
  { "cbdoilcures.co", true },
  { "cbecrft.net", true },
  { "cbin168.com", true },
  { "cbintermountainrealty.com", true },
  { "cbnainital.org.in", true },
  { "cbr-rcb.ca", true },
  { "cbr-xml-daily.ru", true },
  { "cbsdeheidevlinder.nl", true },
  { "cbt.tj", true },
  { "cbw.sh", true },
  { "cc-customer.de", true },
  { "cc00228.com", false },
  { "cc8822.cc", true },
  { "cc8833.cc", true },
  { "ccattestprep.com", true },
  { "ccavenue.com", true },
  { "ccblicense.com", true },
  { "ccc-ch.ch", true },
  { "ccc-cloud.de", true },
  { "cccwien.at", true },
  { "ccelectricaldrafting.ca", true },
  { "cceputnam360.com", true },
  { "ccgx.de", false },
  { "ccli.com", true },
  { "ccoooss.com", true },
  { "ccparishwilmington.org", true },
  { "ccprwebsite.org", true },
  { "ccr.ovh", true },
  { "ccriderlosangeles.com", true },
  { "ccsistema.com", true },
  { "cctv-supraveghere.ro", true },
  { "cctvview.info", true },
  { "ccu.plus", true },
  { "ccuuu.com", true },
  { "cd-shopware.de", true },
  { "cd-sport.com", true },
  { "cd.search.yahoo.com", false },
  { "cd5k.net", true },
  { "cda-aigle.ch", true },
  { "cdasenegal.com", true },
  { "cdasiaonline.com", false },
  { "cdbf.ch", false },
  { "cdbtech.com", true },
  { "cdburnerxp.se", true },
  { "cdc.cx", true },
  { "cdda.ch", false },
  { "cdemi.io", true },
  { "cdepot.eu", true },
  { "cdf.wiki", true },
  { "cdgfrm.com", true },
  { "cdigitale.com", true },
  { "cdireland.com", true },
  { "cdkeykopen.com", true },
  { "cdkeyprices.com", true },
  { "cdkeyworld.de", true },
  { "cdlinares.tk", true },
  { "cdmdisinfestazioni.it", true },
  { "cdn.ampproject.org", true },
  { "cdn6.de", true },
  { "cdncompanies.com", true },
  { "cdnjs.com", true },
  { "cdns.cloud", true },
  { "cdnsys.net", true },
  { "cdnya.com", true },
  { "cdom.de", true },
  { "cdsdigital.de", true },
  { "cdshining.com", true },
  { "cdu-gebhardshain.de", true },
  { "cdvl.org", true },
  { "ce-agentur.de", false },
  { "ce-pimkie.fr", true },
  { "ce-webdesign.de", true },
  { "ceanimalhealth.com", true },
  { "cebz.org", true },
  { "cecame.ch", true },
  { "ceciliacolombara.com", true },
  { "cecilwalker.com.au", false },
  { "cedarcitydining.com", true },
  { "cedarslodge.com", true },
  { "cedehb.be", true },
  { "cedric-bour.fr", true },
  { "cedricbonhomme.org", true },
  { "cedriccassimo.ch", false },
  { "cedriccassimo.com", false },
  { "ceebee.com", true },
  { "ceefaastresources.com", true },
  { "cegss.org.gt", true },
  { "ceiba.com.co", true },
  { "ceiphr.com", true },
  { "cejhon.cz", false },
  { "celadas.tk", true },
  { "celcelulares.com", true },
  { "celcomhomefibre.com.my", true },
  { "cele.bi", true },
  { "celebmasta.com", true },
  { "celebrasianconference.com", true },
  { "celebrityhealthcritic.com", true },
  { "celebrityscope.net", true },
  { "celebritytopnews.tk", true },
  { "celestebonito.pt", true },
  { "celiac.com", true },
  { "celiendev.ch", false },
  { "celine-patisserie.fr", true },
  { "cell-lookup.com", true },
  { "cellartracker.com", true },
  { "cellebrite.com", true },
  { "celliberate.co.uk", true },
  { "celltek-server.de", false },
  { "celltesequ.com", true },
  { "celltick.com", true },
  { "celtadigital.com", true },
  { "celti.ie.eu.org", true },
  { "celti.name", true },
  { "cementscience.com", true },
  { "ceml.ch", true },
  { "cenatorium.pl", true },
  { "cendata.co.uk", true },
  { "cennelley.com", true },
  { "cennelly.com", true },
  { "censurfridns.dk", true },
  { "censurfridns.nu", true },
  { "censys.io", true },
  { "centaur.de", true },
  { "centennialradon.com", true },
  { "centennialrewards.com", true },
  { "centennialseptic.com", true },
  { "center-elite.ml", true },
  { "centermk.ru", true },
  { "centerpereezd.ru", false },
  { "centerperson.org", true },
  { "centerpoint.ovh", true },
  { "centio.bg", true },
  { "centos.cz", true },
  { "centos.tips", true },
  { "centralbank.ae", true },
  { "centraldoencanador.com.br", true },
  { "centralebigmat.eu", true },
  { "centralegedimat.eu", true },
  { "centralfor.me", true },
  { "centralheating.hu", true },
  { "centralmissourifoundationrepair.com", true },
  { "centralpaellera.com", true },
  { "centralpoint.be", false },
  { "centralpoint.nl", false },
  { "centralstatecu.org", true },
  { "centrationgame.com", true },
  { "centreagree.com", true },
  { "centredaccueil.fr", false },
  { "centrederessourcement.com", true },
  { "centreoeil.ch", false },
  { "centrepointorguk-dev.azurewebsites.net", true },
  { "centrobill.com", true },
  { "centrodeesteticarecife.com", true },
  { "centroecuestrecastellar.com", true },
  { "centrojovencuenca.es", true },
  { "centrolavoro.org", true },
  { "centroperugia.gr", true },
  { "centrosocialferrel.pt", true },
  { "centrum-edukacji.tk", true },
  { "centrumhodinek.cz", true },
  { "centruvechisv.ro", true },
  { "centum.no", true },
  { "centura.de", true },
  { "centurialeonina.com", true },
  { "centurion-consulting.net", true },
  { "centurion-consulting.tech", true },
  { "centurioninfosec.com", true },
  { "centurioninfosec.com.sg", true },
  { "centurioninfosec.hk", true },
  { "centurioninfosec.sg", true },
  { "centurykiaparts.com", true },
  { "centurystonedental.com", true },
  { "ceopedia.org", true },
  { "ceramiche.roma.it", true },
  { "ceramixcoating.nl", true },
  { "ceramiya.com", true },
  { "cerastar.com", true },
  { "cerber.us", true },
  { "cerberis.com", true },
  { "cerberusinformatica.it", true },
  { "cerena-silver.ru", true },
  { "ceres-corp.org", true },
  { "cerivo.co.uk", true },
  { "cermak.photos", true },
  { "cernac.cz", true },
  { "cerpus-course.com", true },
  { "cerrajeriaamericadelquindio.com", true },
  { "cerrajeriaenvillavicencio.com", true },
  { "cert.ee", true },
  { "cert.govt.nz", true },
  { "certaintelligence.com", true },
  { "certbus.com", true },
  { "certcenter.com", true },
  { "certchannel.com", true },
  { "certevia.com", true },
  { "certfa.com", true },
  { "certible.com", true },
  { "certificatedetails.com", true },
  { "certificatetools.com", false },
  { "certificato-prevenzione-incendi.it", true },
  { "certificazioni-energetiche.it", true },
  { "certifiednurses.org", true },
  { "certisoncologysolutions.com", true },
  { "certmonitor.com.au", true },
  { "certmonitor.net", true },
  { "certnazionale.it", true },
  { "certspotter.com", true },
  { "certspotter.org", true },
  { "cervejista.com", true },
  { "ces-ltd.co.uk", true },
  { "cesarparedespacora.com", true },
  { "cesdb.com", true },
  { "cesipagano.com", true },
  { "ceskaexpedice.org", true },
  { "ceskepivnesety.sk", true },
  { "ceskepivnisety.cz", true },
  { "ceso-saco.com", true },
  { "cesobaly.cz", true },
  { "cestasedelicias.com.br", true },
  { "cetamol.com", true },
  { "ceu.edu", false },
  { "cevin.at", true },
  { "cevo.com.hr", true },
  { "cezdent.com", true },
  { "cf-ide.de", true },
  { "cfc-swc.gc.ca", true },
  { "cfda.gov", true },
  { "cfdcre5.org", true },
  { "cfh.com", true },
  { "cfigura.com", true },
  { "cflsystems.com", false },
  { "cfno.org", true },
  { "cfo.gov", true },
  { "cfpa-formation.fr", true },
  { "cfrq.ca", true },
  { "cfsh.tk", true },
  { "cftc.gov", true },
  { "cftcarouge.com", false },
  { "cfxdesign.com", true },
  { "cg-goerlitz.de", true },
  { "cg-systems.hu", true },
  { "cg.al", true },
  { "cg.search.yahoo.com", false },
  { "cga.best", true },
  { "cgal.org", true },
  { "cgan.de", true },
  { "cgbassurances.ch", false },
  { "cgcookiemarkets.com", true },
  { "cgeceia.cf", true },
  { "cgf-charcuterie.com", true },
  { "cgnparts.com", true },
  { "cgp.moe", true },
  { "cgpe.com", false },
  { "cgsmart.com", true },
  { "cgurtner.ch", true },
  { "ch-laborit.fr", true },
  { "ch.bzh", true },
  { "ch.search.yahoo.com", false },
  { "ch47f.com", true },
  { "chabaudparfum.com", true },
  { "chabert-provence.fr", true },
  { "chabik.com", true },
  { "chaboisseau.net", true },
  { "chad.ch", true },
  { "chadlenz.ca", true },
  { "chadpugsley.com", true },
  { "chadstoneapartments.com.au", true },
  { "chaffeyconstruction.com", true },
  { "chaifeng.com", true },
  { "chainels.com", true },
  { "chainge-re.com", true },
  { "chaip.org", true },
  { "chairsgb.com", true },
  { "chaisystems.net", true },
  { "chaletdemontagne.org", true },
  { "chaletmanager.com", true },
  { "chaletpierrot.ch", false },
  { "chaleur.com", true },
  { "challengerinvestors.tk", true },
  { "chalupalokovka.cz", true },
  { "chambion.ch", false },
  { "champdogs.co.uk", true },
  { "champdogs.com", true },
  { "champicreuse.fr", true },
  { "championcastles.ie", true },
  { "champions.co", true },
  { "championsofpowerfulliving.com", true },
  { "championweb.co.nz", false },
  { "championweb.com", false },
  { "championweb.com.au", false },
  { "championweb.com.sg", false },
  { "championweb.nz", false },
  { "championweb.sg", false },
  { "champonthis.de", true },
  { "chamsochoa.com", true },
  { "chancekorte.com", true },
  { "chancekorte.net", true },
  { "chanddriving.co.uk", true },
  { "change-coaching-gmbh.ch", true },
  { "changeanalytics.io", true },
  { "changeanalytics.us", true },
  { "changemywifipassword.com", true },
  { "changes.jp", true },
  { "changesfor.life", true },
  { "channelsurf.tv", false },
  { "chantalguggenbuhl.ch", false },
  { "chanz.com", true },
  { "chaos-games.org", true },
  { "chaos.run", true },
  { "chaoscastles.co.uk", true },
  { "chaoschemnitz.de", true },
  { "chaosdorf.de", true },
  { "chaosfield.at", true },
  { "chaospott.de", true },
  { "chaoswars.ddns.net", true },
  { "chaoswebs.net", true },
  { "chapek9.com", true },
  { "chapelfordbouncers.co.uk", true },
  { "chapelhousevet.co.uk", true },
  { "chapelle.co.uk", true },
  { "chapiteauxduleman.fr", true },
  { "chaplain.co", true },
  { "charbonnel.eu", true },
  { "charcoal-se.org", true },
  { "charcoalvenice.com", true },
  { "chardhamhotel.com", true },
  { "charge.co", false },
  { "chargify.com", true },
  { "charisma.ai", true },
  { "charitylog.co.uk", true },
  { "charlenew.xyz", true },
  { "charles-darwin.com", true },
  { "charlesbwise.com", true },
  { "charlespitonltd.com", true },
  { "charlesrogers.co.uk", true },
  { "charlestonfacialplastic.com", true },
  { "charlie4change.com", true },
  { "charliedillon.com", true },
  { "charliegarrod.com", true },
  { "charliehr.com", true },
  { "charlierogers.co.uk", true },
  { "charlierogers.com", true },
  { "charlotteomnes.com", true },
  { "charlottesvillegolfcommunities.com", true },
  { "charlottesvillehorsefarms.com", true },
  { "charlotteswimmingpoolbuilder.com", true },
  { "charlylou.de", true },
  { "charmander.me", true },
  { "charmanterelefant.at", true },
  { "charmingsaul.com", true },
  { "charmyadesara.com", true },
  { "charset.org", true },
  { "charta-digitale-vernetzung.de", true },
  { "charteroak.org", true },
  { "chartpen.com", true },
  { "chartsheets.com", true },
  { "chartsy.de", true },
  { "chartwellestate.com", true },
  { "chasafilli.ch", true },
  { "chascrazycreations.com", true },
  { "chasetrails.co.uk", true },
  { "chat-house-adell.com", true },
  { "chat-libera.org", true },
  { "chat-porc.eu", true },
  { "chat-senza-registrazione.net", true },
  { "chat.cz", true },
  { "chat40.net", true },
  { "chataberan.cz", true },
  { "chatbelgie.eu", true },
  { "chatbots.systems", true },
  { "chatear.social", true },
  { "chateau-de-lisle.fr", true },
  { "chateaudestrainchamps.com", false },
  { "chateroids.com", true },
  { "chatfacile.org", true },
  { "chatforskning.no", true },
  { "chatgrape.com", true },
  { "chathund.de", true },
  { "chatitaly.org", true },
  { "chatnederland.eu", true },
  { "chatswoodprestige.com.au", true },
  { "chatsworthelectrical.com", true },
  { "chatt-gratis.net", true },
  { "chatt-gratis.org", true },
  { "chattanoogaface.com", true },
  { "chattergalerie.eu", true },
  { "chattergallery.com", true },
  { "chattersworld.nl", true },
  { "chattingorcheating.com", true },
  { "chatu.io", true },
  { "chatu.me", true },
  { "chatucomputers.com", true },
  { "chaturbate.com", true },
  { "chaturbate.com.tw", true },
  { "chaturbates.org", true },
  { "chatxp.com", true },
  { "chatxsingle.net", true },
  { "chatxtutti.com", true },
  { "chatzimanolis.com", true },
  { "chatzimanolis.gr", true },
  { "chauffage-budget.fr", true },
  { "chaurocks.com", true },
  { "chaussenot.net", true },
  { "chaussurerunning.fr", true },
  { "chaussuresmarche.fr", true },
  { "chavetaro.com", true },
  { "chawa.jp", true },
  { "chazalet.fr", false },
  { "chbs.me", true },
  { "chch.it", true },
  { "chcoc.gov", true },
  { "chcsct.com", true },
  { "chcuscojungle.com", true },
  { "chd-expert.fr", true },
  { "cheap-colleges.com", true },
  { "cheap-life-insurance-quote.com", true },
  { "cheapcaribbean.com", true },
  { "cheapessay.net", true },
  { "cheapestgamecards.at", true },
  { "cheapestgamecards.be", true },
  { "cheapestgamecards.co.uk", true },
  { "cheapestgamecards.com", true },
  { "cheapestgamecards.fi", true },
  { "cheapestgamecards.fr", true },
  { "cheapestgamecards.nl", true },
  { "cheapestgamecards.no", true },
  { "cheapgeekts.com", false },
  { "cheapgoa.com", true },
  { "cheapiesystems.com", true },
  { "cheapsharedhost.com", true },
  { "cheapsharedhost.org", true },
  { "cheapsmall.tk", true },
  { "cheapssl.com.tr", true },
  { "cheapsslrenewal.com", true },
  { "cheapsslsecurity.com.au", true },
  { "cheapticket.in", true },
  { "cheapwritinghelp.com", true },
  { "cheapwritingservice.com", true },
  { "cheatengine.pro", true },
  { "cheater.best", true },
  { "cheatsupreme.com", true },
  { "cheazey.net", true },
  { "cheazey.org", true },
  { "check.torproject.org", false },
  { "checkandreportlive.com", true },
  { "checkblau.de", true },
  { "checkmatewebsolutions.com", true },
  { "checkmin.cf", true },
  { "checkmyessay.com", true },
  { "checkmyhttps.net", true },
  { "checkmypsoriasis.com", true },
  { "checkout.google.com", true },
  { "checkpoint-tshirt.com", true },
  { "checkra.in", true },
  { "checkrent.ir", true },
  { "checkspf.net", true },
  { "checktype.com", true },
  { "checkui.com", true },
  { "checkwebsiteonline.com", true },
  { "checkyourmath.com", true },
  { "checkyourprivilege.org", true },
  { "checkyourreps.org", true },
  { "checos.co.uk", true },
  { "cheddarpayments.com", true },
  { "cheekycharliessoftplay.co.uk", true },
  { "cheekymonkeysinflatables.co.uk", true },
  { "cheela.org", true },
  { "cheem.co.uk", true },
  { "cheeseemergency.co.uk", true },
  { "cheetahwerx.com", true },
  { "cheezflix.uk", true },
  { "chefcuisto.com", true },
  { "chefkoch.de", true },
  { "chefpablito.tk", true },
  { "chefz.co", true },
  { "chehalemgroup.com", true },
  { "cheladmin.ru", true },
  { "chelpogoda.tk", true },
  { "chelseafs.co.uk", true },
  { "cheltenhambouncycastles.co.uk", true },
  { "cheltik.ru", true },
  { "chelyaba.tk", true },
  { "chemco.mu", true },
  { "chemicalcrux.org", true },
  { "chemicalpharm.com", true },
  { "chemiphys.com", false },
  { "chemistry-schools.com", true },
  { "chenapartment.com", true },
  { "cheneypartners.com", true },
  { "chengfayun.com", true },
  { "chengxindong.com", true },
  { "chenkun.pro", true },
  { "chenky.com", true },
  { "chenna.me", true },
  { "chennien.com", true },
  { "chenpei.org", true },
  { "chenqinghua.com", true },
  { "chenx221.ml", true },
  { "chenx221.xyz", true },
  { "chenx2210.xyz", true },
  { "chenzhekl.me", true },
  { "chenzhipeng.com.cn", true },
  { "cheque-transitionactive.fr", true },
  { "cheraghestan.com", true },
  { "cherie-belle.com", true },
  { "chernyak.id.au", true },
  { "cherry-green.ch", true },
  { "cherrybread.net", true },
  { "cherryonit.com", false },
  { "cherrywoodtech.com", true },
  { "chertseybouncycastles.co.uk", true },
  { "chesapeakebaychristmas.com", true },
  { "chess.com", true },
  { "chessboardao.com", true },
  { "chesskid.com", true },
  { "chesspoint.ch", true },
  { "chestercountypediatrics.com", true },
  { "chestercountyroboticsurgery.com", true },
  { "chesterfieldplaceapartmentsstl.com", true },
  { "chestnut.cf", true },
  { "chetanrana.me", true },
  { "chetwood.se", true },
  { "chevy37.com", true },
  { "chevymotor-occasions.be", false },
  { "chewey.de", true },
  { "chewey.org", true },
  { "chewingucand.com", true },
  { "chez-janine.de", true },
  { "chez-oim.org", true },
  { "chez.moe", true },
  { "chezbernard.tk", true },
  { "chfr.search.yahoo.com", false },
  { "chhlin.com", true },
  { "chhory.com", true },
  { "chhy.at", true },
  { "chianti2002.jp", true },
  { "chiaseeds24.com", true },
  { "chiavistello.it", true },
  { "chiboard.co", true },
  { "chiboost.net", true },
  { "chibr.eu", true },
  { "chic-leather.com", true },
  { "chicagenial.com", true },
  { "chicagobreastaugdrs.com", true },
  { "chicagoemergencyclosings.com", true },
  { "chicagolug.org", false },
  { "chicback.com", true },
  { "chicisimo.com", true },
  { "chicjrajeevalochana.com", true },
  { "chicofc.tk", true },
  { "chicolawfirm.com", true },
  { "chicourologist.com", true },
  { "chicurrichi.com", true },
  { "chiemgauflirt.de", true },
  { "chif16.at", true },
  { "chika.kr", true },
  { "chikazawa.info", true },
  { "childcare.gov", true },
  { "childcounseling.org", true },
  { "childcustodylegalaid.org", true },
  { "childno.de", true },
  { "childrenandmedia.org.au", true },
  { "childrenfirstalways.org", true },
  { "childreninadversity.gov", true },
  { "childrens-room.com", true },
  { "childrensentertainmentleicester.co.uk", true },
  { "childrensfurniture.co.uk", true },
  { "childrenspartiesrus.com", true },
  { "childstats.gov", true },
  { "childvisitationassistance.org", true },
  { "chiledogphoto.com", true },
  { "chilihosting.eu", true },
  { "chilikin.pro", true },
  { "chilimath.com", true },
  { "chilio.net", true },
  { "chilliwackchurchofgod.com", true },
  { "chima.net", true },
  { "chima.us", true },
  { "chimeratool.com", true },
  { "chimerity.com", true },
  { "chimpanzee.net", true },
  { "chimpmatic.com", true },
  { "china-online-news.tk", true },
  { "chinahighlights.ru", true },
  { "chinaspaceflight.com", true },
  { "chineserecipes.xyz", true },
  { "ching.tv", true },
  { "chinwag.im", true },
  { "chinwag.org", true },
  { "chip.pl", true },
  { "chipcore.com", false },
  { "chippy.ch", false },
  { "chipset.no", true },
  { "chiralsoftware.com", true },
  { "chireiden.net", true },
  { "chiro-neuchatel.ch", false },
  { "chiropractic.gr", true },
  { "chiropracticwpb.com", true },
  { "chiropraktik-riemann.de", true },
  { "chiropraticien-neuchatel.ch", false },
  { "chiropratique-neuchatel.ch", false },
  { "chirosphere.ch", false },
  { "chirpstory.com", true },
  { "chiru.no", true },
  { "chirurgoplastico.roma.it", true },
  { "chisago-isantidfl.com", true },
  { "chit.search.yahoo.com", false },
  { "chitoku.jp", false },
  { "chksite.com", true },
  { "chl.la", true },
  { "chliine.ch", true },
  { "chlo-products.biz", true },
  { "chlo-products.net", true },
  { "chloes.gr", true },
  { "chloescastles.co.uk", true },
  { "chlth.com", true },
  { "chmc.ml", true },
  { "chmielarz.it", true },
  { "chmsoft.com.ua", true },
  { "chmsoft.ru", true },
  { "chocamekong.com", true },
  { "chocgu.com", true },
  { "chocodecor.com.br", true },
  { "chocolah.com.au", false },
  { "chocolat.work", true },
  { "chocolatesandhealth.com", true },
  { "chocolatier-tristan.ch", false },
  { "chocolytech.info", true },
  { "chocope-peru.tk", true },
  { "chodaczek.pl", true },
  { "chomp.life", true },
  { "chook.as", true },
  { "choootto.net", true },
  { "choosemypc.net", true },
  { "chopperdesign.com", true },
  { "chordify.net", true },
  { "chorpinkpoemps.de", true },
  { "chosenplaintext.org", true },
  { "chourishi-shigoto.com", true },
  { "chovancova.sk", true },
  { "choyri.com", true },
  { "chpwmedicare.org", true },
  { "chr1sbin.works", true },
  { "chris-siedler.at", true },
  { "chrisahrweileryoga.com", true },
  { "chrisaitch.com", true },
  { "chrisbryant.me.uk", true },
  { "chrisburnell.com", true },
  { "chriscarey.com", true },
  { "chriscutts.uk", true },
  { "chrisdecairos.ca", true },
  { "chrisgieger.com", true },
  { "chrisirwin.ca", true },
  { "chrisjean.com", true },
  { "chrislane.com", true },
  { "chrismarker.org", true },
  { "chrismathys.com", true },
  { "chrismcclendon.com", true },
  { "chrismckee.co.uk", true },
  { "chrismorgan.info", true },
  { "chrismurrayfilm.com", true },
  { "chrisnekarda.com", true },
  { "chrisplankhomes.com", true },
  { "chrispstreet.com", true },
  { "chrisseoguy.com", true },
  { "chrisshort.net", true },
  { "chrissmiley.co.uk", true },
  { "chrisspencercreative.com", true },
  { "chrisspencermusic.com", true },
  { "chrissx.ga", true },
  { "christadelphiananswers.org", true },
  { "christadelphians.eu", true },
  { "christec.net", true },
  { "christensenplace.us", true },
  { "christiaanconover.com", true },
  { "christian-fischer.pictures", true },
  { "christian-folini.ch", true },
  { "christian-gredig.de", true },
  { "christian-host.com", true },
  { "christian-liebel.com", true },
  { "christian-stadelmann.de", true },
  { "christianadventurecamps.org", true },
  { "christianblog.ml", true },
  { "christiancleva.com", true },
  { "christiancoleman.info", true },
  { "christiandiscourse.net", true },
  { "christianfaq.org", true },
  { "christianforums.com", true },
  { "christiangehring.org", true },
  { "christianillies.de", true },
  { "christianjens.com", true },
  { "christianliebel.com", true },
  { "christianlis.org.uk", true },
  { "christianlis.uk", true },
  { "christianmoore.me", true },
  { "christianoliff.com", true },
  { "christianpilgrimage.com.au", true },
  { "christianr.me", true },
  { "christianrasch.de", true },
  { "christians.dating", true },
  { "christianscholz.de", false },
  { "christianwitts.tech", true },
  { "christiehawkes.com", true },
  { "christiesantiques.com", true },
  { "christineandcie.fr", true },
  { "christineblachford.com", true },
  { "christineprayon.de", true },
  { "christmascard.be", true },
  { "christmaspartyhire.co.uk", true },
  { "christoph-conrads.name", true },
  { "christopher-simon.de", true },
  { "christopher.sh", false },
  { "christopherandcharlotte.uk", true },
  { "christopherburg.com", true },
  { "christopherd.me", true },
  { "christopherkennelly.com", true },
  { "christopherstocks.online", true },
  { "christophertruncer.com", true },
  { "christophsackl.de", true },
  { "christthekingparish.net", true },
  { "christtheredeemer.us", true },
  { "chriswald.com", true },
  { "chriswarrick.com", true },
  { "chriswells.io", true },
  { "chriswilding.co.uk", true },
  { "chrisx.xyz", true },
  { "chromaitaly.com", true },
  { "chromcraft-revington.com", true },
  { "chrome-devtools-frontend.appspot.com", true },
  { "chrome.com", false },
  { "chrome.google.com", true },
  { "chromebookchart.com", true },
  { "chromebooksforwork.com", true },
  { "chromereporting-pa.googleapis.com", true },
  { "chromeworld.ru", true },
  { "chromiumbugs.appspot.com", true },
  { "chromiumcodereview.appspot.com", false },
  { "chromopho.be", true },
  { "chroniclesofgeorge.com", true },
  { "chronograph.pe", true },
  { "chronology.no", true },
  { "chronosgroup.eu", true },
  { "chronoshop.cz", true },
  { "chrpaul.de", true },
  { "chrstn.eu", true },
  { "chrxw.com", true },
  { "chrysanthos.net", true },
  { "chrystajewelry.com", true },
  { "chrystus.pl", true },
  { "chs.us", false },
  { "chshealthcare.co.uk", true },
  { "chshouyu.com", true },
  { "chsterz.de", true },
  { "chtsi.uk", true },
  { "chuchote-moi.fr", true },
  { "chuck.ovh", true },
  { "chuill.com", true },
  { "chun.pro", true },
  { "chunche.net", true },
  { "chungsir.com.pa", true },
  { "chunk.science", true },
  { "chupadelfrasco.com", true },
  { "chupanhcotrang.com", true },
  { "chuppa.com.au", true },
  { "churchofsaintbenedict.com", true },
  { "churchofsaintrocco.org", true },
  { "churchofscb.org", true },
  { "churchthemes.com", true },
  { "churchwebcanada.ca", true },
  { "churchwebsupport.com", true },
  { "churningtracker.com", true },
  { "chwilrank.pl", true },
  { "chyen.cc", true },
  { "chytraauta.cz", true },
  { "chziyue.com", true },
  { "ci-fo.org", true },
  { "ci-suite.com", true },
  { "ciagutek.pl", true },
  { "cialde.it", true },
  { "cialisonlinee.com", true },
  { "ciancode.com", true },
  { "cianmawhinney.me", true },
  { "ciaracode.com", true },
  { "ciat.no", false },
  { "cibercactus.com", true },
  { "cichol.com", true },
  { "cidbot.com", true },
  { "ciderclub.com", true },
  { "cidersus.com.ec", true },
  { "cie-theatre-montfaucon.ch", false },
  { "cielly.com", true },
  { "cienciasempresariais.pt", true },
  { "cierreperimetral.com", true },
  { "cifapme.net", true },
  { "cifop-numerique.fr", true },
  { "cig-dem.com", false },
  { "cigar-cartel.com", true },
  { "cigarterminal.com", false },
  { "cihar.com", true },
  { "ciicutini.ro", true },
  { "cikeblog.com", true },
  { "cilacapnews.ml", true },
  { "ciliwang.live", true },
  { "ciliwang.org", true },
  { "cilloc.be", true },
  { "cima-idf.fr", true },
  { "cimbalino.org", true },
  { "cimballa.com", true },
  { "cimfax.com", true },
  { "cinafilm.com", true },
  { "cine-music.de", true },
  { "cine.to", true },
  { "cinefilzonen.se", true },
  { "cinefun.net", true },
  { "cinema.paris", true },
  { "cinemarxism.com", true },
  { "cinemasetfree.com", true },
  { "cinemixer.club", true },
  { "cinemysticism.com", true },
  { "cineplex.my", true },
  { "cineworld.co.in", true },
  { "cinexmachina.com", true },
  { "ciniticket.com", true },
  { "cinkciarz.pl", true },
  { "cinq-elements.com", false },
  { "cinsects.de", true },
  { "cintactimber.com", true },
  { "cio-ciso-interchange.org", true },
  { "cio-cisointerchange.org", true },
  { "cio.go.jp", false },
  { "cio.gov", false },
  { "cioscloud.com", true },
  { "cip.md", true },
  { "cipartyhire.co.uk", true },
  { "cipher.team", true },
  { "cipherboy.com", true },
  { "ciphersuite.info", true },
  { "ciphrex.com", true },
  { "cipri.com", true },
  { "cipri.net", true },
  { "cipri.nl", true },
  { "cipri.org", true },
  { "cipria.no", true },
  { "cipy.com", true },
  { "cir.is", true },
  { "circady.com", true },
  { "circara.com", true },
  { "circle-people.com", true },
  { "circu.ml", true },
  { "circuitcityelectricaladelaide.com.au", true },
  { "circulatedigital.com", true },
  { "circule.cc", true },
  { "ciri.com.co", true },
  { "cirrus0.de", true },
  { "cirruslab.ch", true },
  { "cirurgicagervasio.com.br", true },
  { "cirurgicalucena.com.br", true },
  { "cirurgicavirtual.com.br", true },
  { "cisa.gov", true },
  { "ciscodude.net", true },
  { "cisoaid.com", true },
  { "cisofy.com", true },
  { "cispeo.org", true },
  { "ciss.ltd", true },
  { "cissa.org.au", true },
  { "cissofitness.com", true },
  { "cisum-cycling.com", true },
  { "cisy.me", true },
  { "citas-adultas.com", true },
  { "citationranker.com", true },
  { "citcuit.in", true },
  { "citfin.cz", true },
  { "cities.cl", true },
  { "citimarinestore.com", true },
  { "citizenkevin.com", true },
  { "citizensbankal.com", true },
  { "citizenscience.gov", false },
  { "citizenscience.org", true },
  { "citizensgbr.org", true },
  { "citizensleague.org", true },
  { "citizing.org", true },
  { "citrusui.me", true },
  { "citsc.de", true },
  { "cittadesign.com", false },
  { "citton.com.br", true },
  { "city-adm.lviv.ua", true },
  { "city-walks.info", true },
  { "citybeat.de", true },
  { "citycreek.studio", true },
  { "citydance.ee", true },
  { "cityfloorsupply.com", true },
  { "citylights.eu", true },
  { "citymoobel.ee", true },
  { "cityoftitans.com", true },
  { "cityoftitansmmo.com", true },
  { "citypro.tk", true },
  { "citysportapp.com", false },
  { "citywidealarms.com", true },
  { "citywisdom.tk", true },
  { "cityworksonline.com", true },
  { "civey.com", true },
  { "civicamente.cl", true },
  { "civicforum.pl", true },
  { "civics.us", true },
  { "civilbikes.com", true },
  { "civilg20.org", true },
  { "civillines.nl", true },
  { "civiltoday.com", true },
  { "civmob.com", true },
  { "cixiaoya.space", true },
  { "cixiaoya1.xyz", true },
  { "cixiaoya2.xyz", true },
  { "cj-espace-vert.fr", true },
  { "cj-jackson.com", true },
  { "cjbeckert.com", false },
  { "cjdby.net", true },
  { "cjdpenterprises.com", true },
  { "cjdpenterprises.com.au", true },
  { "cjenni.ch", true },
  { "cjey.me", true },
  { "cjhzp.net", true },
  { "cjr.host", true },
  { "cjs8866.cc", true },
  { "cjsounds.com", true },
  { "ck.cx", true },
  { "ck1020.cc", true },
  { "ckenelley.com", true },
  { "ckenelly.com", true },
  { "ckenely.com", true },
  { "ckenneley.com", true },
  { "ckennelley.com", true },
  { "ckennelly.com", true },
  { "ckennely.com", true },
  { "cklie.de", true },
  { "ckliemann.com", true },
  { "ckliemann.net", true },
  { "ckna.ca", true },
  { "ckostecki.de", true },
  { "ckp.io", true },
  { "ckpl.us", true },
  { "cktennis.com", true },
  { "ckventura.sk", true },
  { "cl.search.yahoo.com", false },
  { "claimconnect.com", true },
  { "claimconnect.us", true },
  { "claimflights.at", true },
  { "claimflights.co.uk", false },
  { "claimflights.com", false },
  { "claimflights.de", false },
  { "claimflights.it", false },
  { "claimflights.pl", false },
  { "claimflights.ro", false },
  { "claimjeidee.be", true },
  { "claimnote.com", true },
  { "clairegold.com", true },
  { "clairescastles.co.uk", true },
  { "clairette-de-die-lantheaume.fr", true },
  { "claitec.com", true },
  { "clan-hosting.tk", true },
  { "clan-wars.ml", true },
  { "clan-zone.dk", true },
  { "clanebouncycastles.com", true },
  { "clanrose.org.uk", true },
  { "clanwarz.com", true },
  { "clare3dx.com", true },
  { "clarkelectricalservices.com.au", true },
  { "clarkwinkelmann.com", true },
  { "clase3.tk", true },
  { "clash.lol", true },
  { "class.com.au", true },
  { "classdojo.com", true },
  { "classicalpilates.ca", true },
  { "classiccutstupelo.com", true },
  { "classicfg.com.au", true },
  { "classics.io", true },
  { "classictheatrecumbria.co.uk", true },
  { "classpoint.cz", true },
  { "classroom.google.com", true },
  { "classroomconductor.com", true },
  { "classroomcountdown.co.nz", true },
  { "classteaching.com.au", true },
  { "claster.it", true },
  { "claude.me", true },
  { "claude.photo", true },
  { "claudeleveille.com", true },
  { "claudia-urio.com", false },
  { "claudiney.id", true },
  { "claudiolemos.com", true },
  { "claumarservice.com", true },
  { "claus-bahr.de", true },
  { "clauseriksen.net", true },
  { "clav1d.com", true },
  { "clawe.de", true },
  { "clawhammer.dk", true },
  { "clayandcottonkirkwood.com", true },
  { "claygregory.com", true },
  { "clayprints.com", true },
  { "clazzrooms.com", true },
  { "cldejessey.com", true },
  { "cldinc.com", true },
  { "cldly.com", true },
  { "clean-mailbox.com", true },
  { "cleanapproachnw.com", true },
  { "cleanbrowsing.org", true },
  { "cleandetroit.org", true },
  { "cleandogsnederland.nl", true },
  { "cleango.pl", true },
  { "cleanhouse2000.us", true },
  { "cleaningservicejulai.com", true },
  { "cleaningsolutionn.com", true },
  { "cleanplanet.co.jp", true },
  { "clearance365.co.uk", true },
  { "clearblueday.co.uk", true },
  { "clearbookscdn.uk", true },
  { "clearbreezesecuritydoors.com.au", true },
  { "clearchaos.net", true },
  { "clearip.com", true },
  { "clearpay.co.uk", true },
  { "clearspringinsurance.com", true },
  { "clearview-creative.com", true },
  { "clearvoice.com", true },
  { "clearvoice1.com", true },
  { "clearwaterbidets.com", false },
  { "cleary.xyz", true },
  { "clemency.com", true },
  { "clemens-bartz.de", true },
  { "clemensbartz.de", true },
  { "clemenscompanies.com", true },
  { "clement-beaufils.fr", true },
  { "clementfevrier.fr", true },
  { "cles-asso.fr", true },
  { "cles.jp", true },
  { "cleveille.com", true },
  { "clevermatch.com", true },
  { "clevertarget.ru", true },
  { "cleververmarkten.com", true },
  { "cleververmarkten.de", true },
  { "clevisto.com", true },
  { "clevvi.com.au", true },
  { "cleysense.com", true },
  { "clica.net", true },
  { "clicandfioul.com", true },
  { "clicheshishalounge.co.uk", true },
  { "click-licht.de", true },
  { "click2order.co.uk", true },
  { "click4web.com", true },
  { "clickbasin.co.uk", true },
  { "clickclickphish.com", true },
  { "clickenergy.com.au", true },
  { "clickingmad.com", true },
  { "clickphish.com", true },
  { "clien.net", true },
  { "client.coach", false },
  { "clientboss.com", true },
  { "clientcms.co.uk", true },
  { "clientesendemanda.com", true },
  { "clientportal.com", true },
  { "clientsecure.me", true },
  { "cliffbreak.de", true },
  { "cliffburton.tk", true },
  { "clifflu.net", true },
  { "cliffyb.com", true },
  { "cliksource.com", true },
  { "climaprecio.es", true },
  { "climateinteractive.org", true },
  { "climatestew.com", true },
  { "climatgate.tk", true },
  { "climatizzatore.roma.it", true },
  { "clindoeilmontagne.com", false },
  { "clinicaarques.es", true },
  { "clinicadentalvinateros.es", true },
  { "clinicainfinitydental.com", true },
  { "clinicalrehabilitation.info", true },
  { "clinicaltrialpodcast.com", true },
  { "clinicaltrials.gov", true },
  { "clinicamiracueto.com", true },
  { "clinicasmedicas.com.br", true },
  { "clinicminds.com", true },
  { "clinicos.cl", true },
  { "clinique-ser.ca", true },
  { "cliniquevethuy.be", true },
  { "clintonlibrary.gov", true },
  { "clip.ovh", true },
  { "clipchamp.com", true },
  { "clipclip.com", true },
  { "clippings.com", true },
  { "cliqz.com", true },
  { "clive.io", true },
  { "clmde.de", true },
  { "clnc.to", true },
  { "clnlboard.co.uk", true },
  { "clnnet.ch", true },
  { "clo.me", true },
  { "clockcaster.com", true },
  { "clocklab.design", true },
  { "clockworksms.com", true },
  { "clomid100mg.ga", true },
  { "cloneuniverse.com", true },
  { "clorophilla.net", true },
  { "closeli.cn", true },
  { "closelinksecurity.co.uk", true },
  { "closelinksecurity.com", true },
  { "closetemail.com", true },
  { "closoltech.com", true },
  { "cloud-screen.com", true },
  { "cloud-surfer.net", false },
  { "cloud.bugatti", true },
  { "cloud.fail", true },
  { "cloud.google.com", true },
  { "cloud.gov", true },
  { "cloud10.io", true },
  { "cloud255.com", true },
  { "cloud42.ch", false },
  { "cloud9bouncycastlehire.com", true },
  { "cloud9vets.co.uk", true },
  { "cloudapps.digital", true },
  { "cloudbolin.es", true },
  { "cloudbrothers.info", true },
  { "cloudcaprice.net", true },
  { "cloudcert.org", true },
  { "cloudcite.net", true },
  { "cloudclouds.com", true },
  { "cloudcrux.net", true },
  { "clouddesk.co.uk", true },
  { "clouddog.com.br", true },
  { "cloudeezy.com", true },
  { "cloudey.net", true },
  { "cloudfiles.at", true },
  { "cloudflare-dns.com", true },
  { "cloudflare.com", true },
  { "cloudflareonazure.com", true },
  { "cloudhoreca.com", true },
  { "cloudia.org", true },
  { "cloudily.com", true },
  { "cloudix.cf", true },
  { "cloudkeep.nl", true },
  { "cloudlessdreams.com", false },
  { "cloudlight.biz", true },
  { "cloudninelandscapedesign.com", true },
  { "cloudnote.cc", true },
  { "cloudns.net", true },
  { "cloudofertas.com.br", true },
  { "cloudoptimizedsmb.com", true },
  { "cloudoptimus.com", true },
  { "cloudpengu.in", true },
  { "cloudpipes.com", true },
  { "cloudpole.de", true },
  { "cloudsavvyit.com", true },
  { "cloudse.co.uk", true },
  { "cloudsec.tk", true },
  { "cloudsecurityalliance.com", true },
  { "cloudsecurityalliance.net", true },
  { "cloudsecurityalliance.org", true },
  { "cloudsecuritycongress.net", true },
  { "cloudsecuritycongress.org", true },
  { "cloudservice.io", true },
  { "cloudservices.nz", false },
  { "cloudsign.jp", true },
  { "cloudspace-analytics.com", true },
  { "cloudspire.net", true },
  { "cloudsters.nl", true },
  { "cloudteam.de", true },
  { "cloudtocloud.tk", true },
  { "cloudtropia.de", true },
  { "cloudup.com", true },
  { "cloudwallce.com", true },
  { "clouz.de", true },
  { "cloveros.ga", true },
  { "clovertwo.com", true },
  { "clownindeklas.nl", true },
  { "cloxy.com", true },
  { "cloze.com", true },
  { "clsfoundationrepairandwaterproofing.com", true },
  { "clsimage.com", true },
  { "clsoft.ch", true },
  { "clu-in.org", true },
  { "club-adulti.ro", true },
  { "club-climate.com", true },
  { "club-creole.com", true },
  { "club-dieta.ru", true },
  { "club-duomo.com", true },
  { "club-eclipse.tk", true },
  { "club-jose.com", true },
  { "club-leondehuanuco.tk", true },
  { "club-premiere.com", true },
  { "club-reduc.com", true },
  { "club-slow.jp", true },
  { "club-yy.com", true },
  { "club103.ch", false },
  { "clubapk.com", true },
  { "clubatleticonacionalpotosi.tk", true },
  { "clubcorsavenezuela.com", false },
  { "clubdelzapato.com", true },
  { "clubdeportivocieza.tk", true },
  { "clubefiel.com.br", true },
  { "clubegolfpt.com", true },
  { "clubempleos.com", true },
  { "clubeohara.com", true },
  { "cluberiks.ga", true },
  { "clubfamily.de", true },
  { "clubiconkenosha.com", true },
  { "clubmarina.store", true },
  { "clubmini.jp", true },
  { "clubnoetig-ink2g.de", true },
  { "clubon.space", true },
  { "clubtamarugal.tk", true },
  { "cluster.biz.tr", true },
  { "clusterfuck.nz", true },
  { "clutch.ua", true },
  { "clwrota.com", true },
  { "cm-loures.pt", true },
  { "cmacacias.ch", true },
  { "cmadeangelis.it", true },
  { "cmc.pt", true },
  { "cmcressy.ch", true },
  { "cmdline.org", true },
  { "cme-colleg.de", true },
  { "cmfaccounting.com", false },
  { "cmgacheatcontrol.com", true },
  { "cmillrehab.com", true },
  { "cmlachapelle.ch", true },
  { "cmlancy.ch", true },
  { "cmlignon.ch", true },
  { "cmn-group.com", true },
  { "cmn-groupe.com", true },
  { "cmngroup.com", true },
  { "cmngroupe.com", true },
  { "cmplainpalais.ch", true },
  { "cmpsc.uk", true },
  { "cmserviscz.cz", true },
  { "cmshangu.com", true },
  { "cmskakuyasu.info", true },
  { "cmskeyholding.co.uk", true },
  { "cmskeyholding.com", true },
  { "cmv.gr", true },
  { "cmylife.nl", true },
  { "cn.search.yahoo.com", false },
  { "cn8522.com", true },
  { "cna5.cc", true },
  { "cna5.net", true },
  { "cna5.org", true },
  { "cnam-idf.fr", true },
  { "cnbibo.com", true },
  { "cnbs.ch", true },
  { "cnc-lehrgang.de", true },
  { "cncado.net", true },
  { "cncbazar365.com", true },
  { "cncrans.ch", false },
  { "cncs.gov.pt", true },
  { "cni-certing.it", true },
  { "cnitdog.com", false },
  { "cnre.eu", true },
  { "cnss.io", true },
  { "cnvt.fr", true },
  { "cnymenshealth.com", true },
  { "co-founder-stuttgart.de", true },
  { "co.search.yahoo.com", false },
  { "co50.com", true },
  { "coachapp-ipass.herokuapp.com", true },
  { "coachbakery.com", true },
  { "coachezmoi.ch", false },
  { "coachfederation.ro", true },
  { "coaching-harmonique.fr", true },
  { "coaching-impulse.ch", false },
  { "coaching-park.fr", true },
  { "coachsystem.ru", true },
  { "coalitionministries.org", true },
  { "coalpointcottage.com", true },
  { "coastline.net.au", true },
  { "coastmedicalservice.com", true },
  { "coathangastrangla.com", true },
  { "coathangastrangler.com", true },
  { "coathangerstrangla.com", true },
  { "coathangerstrangler.com", true },
  { "coatl-industries.com", true },
  { "coatsandcocktails.org", true },
  { "cobalt.io", true },
  { "cobaltgp.com", true },
  { "cobaltis.co.uk", true },
  { "cobracastles.co.uk", true },
  { "cocaine.ninja", true },
  { "cocalc.com", true },
  { "cocareonline.com", true },
  { "coccolebenessere.it", true },
  { "cocinoyo.com", true },
  { "cock.li", false },
  { "cockfile.com", true },
  { "cockybot.com", true },
  { "coco-line.ch", true },
  { "cocoamexico.com", true },
  { "cocodroid.com", true },
  { "coconutoil24.com", true },
  { "cocoscastles.co.uk", true },
  { "cocquyt-usedcars.be", false },
  { "cod88.cc", true },
  { "coda.io", true },
  { "coda.moe", true },
  { "coda.today", true },
  { "coda.world", true },
  { "codabix.com", true },
  { "codabix.de", true },
  { "code-poets.co.uk", true },
  { "code-vikings.de", true },
  { "code-well.com", true },
  { "code.facebook.com", false },
  { "code.fm", true },
  { "code.google.com", true },
  { "code.taxi", true },
  { "code123.eu", true },
  { "code4.hk", true },
  { "code67.com", true },
  { "codeandpeace.com", true },
  { "codeandsupply.co", true },
  { "codebrahma.com", false },
  { "codebrew.com.au", true },
  { "codedelarouteenligne.fr", true },
  { "codedo.info", true },
  { "codedump.net", true },
  { "codeeclipse.com", true },
  { "codeferm.com", true },
  { "codefordus.nrw", true },
  { "codeguard.xyz", true },
  { "codehz.one", true },
  { "codeidea.ga", true },
  { "codein.ca", true },
  { "codeine.co.uk", true },
  { "codeit.guru", true },
  { "codeit.us", true },
  { "codejots.com", true },
  { "codelei.fr", true },
  { "codelyoko.club", true },
  { "codemahrt.com", true },
  { "codemill.se", true },
  { "codemonster.eu", true },
  { "codenode.io", true },
  { "codeofthenorth.com", true },
  { "codepoints.net", true },
  { "codepref.com", true },
  { "codereview.appspot.com", false },
  { "codereview.chromium.org", false },
  { "coderscripts.com", true },
  { "coderware.co.uk", true },
  { "codes.pk", true },
  { "codesgroup.tk", true },
  { "codesport.io", true },
  { "codespromo.be", true },
  { "codestudies.net", true },
  { "codetheworld.com", true },
  { "codetipi.com", true },
  { "codetripping.net", true },
  { "codeux.com", true },
  { "codeux.info", true },
  { "codeux.net", true },
  { "codevat.com", true },
  { "codeventure.de", true },
  { "codeversetech.com", true },
  { "codewild.de", true },
  { "codexpo.net", true },
  { "codeyellow.nl", true },
  { "codific.com", true },
  { "codigodelbonusbet365.com", true },
  { "codimaker.com", true },
  { "coding-minds.com", true },
  { "coding.lv", true },
  { "codingblog.org", true },
  { "codingforspeed.com", true },
  { "codinginfinity.me", true },
  { "codingrobots.com", true },
  { "codista.com", true },
  { "cododigital.co.uk", true },
  { "codxg.org", true },
  { "codyevanscomputer.com", true },
  { "codymoniz.com", true },
  { "codyqx4.com", true },
  { "coecho.net", true },
  { "coens.me.uk", true },
  { "coeus.cloud", true },
  { "cofbev.com", true },
  { "coffee-machine.reviews", true },
  { "coffee-mamenoki.jp", true },
  { "coffee-up.it", true },
  { "coffeeandteabrothers.com", true },
  { "coffeestain.ltd", true },
  { "cogala.eu", true },
  { "cogeneration-energy.com", true },
  { "cogent.cc", true },
  { "cogitoltd.com", true },
  { "cognicom-gaming.com", true },
  { "cognitip.com", true },
  { "cognitiveapplications.net", true },
  { "cognitivecomputingconsortium.com", true },
  { "cognitohq.com", true },
  { "cogsquad.house", true },
  { "coiffeurschnittstelle.ch", true },
  { "coiffeurty.com", true },
  { "coiffure-andrea.ch", true },
  { "coigach-assynt.org", true },
  { "coignieresentransition.fr", true },
  { "coimmvest.com", true },
  { "coin-quest.net", true },
  { "coin.dance", true },
  { "coin.space", true },
  { "coinapult.com", true },
  { "coinbase.com", true },
  { "coincealed.com", true },
  { "coinchat.im", true },
  { "coincircle.com", true },
  { "coinclickz.fun", true },
  { "coinclickz.xyz", true },
  { "coincoin.eu.org", true },
  { "coincolors.co", true },
  { "coindeal.com", true },
  { "coinf.it", true },
  { "coinflux.com", true },
  { "coingate.com", true },
  { "coinlist.co", false },
  { "coinloan.io", true },
  { "coinmewallet.com", true },
  { "coinpath.io", true },
  { "coinroom.com", true },
  { "coinsmat.com", true },
  { "coinsuggest.com", true },
  { "coinsz.co", true },
  { "cointosh.jp", true },
  { "coinvex.org", true },
  { "coinx.pro", true },
  { "coisasdemulher.org", true },
  { "cojam.ru", true },
  { "cojo.eu", true },
  { "cokebar.info", true },
  { "coker.com.au", true },
  { "cokomi.com", true },
  { "col-head.com", true },
  { "col.la", true },
  { "cola-host.tk", true },
  { "colaborativa.tv", true },
  { "coladv.com", true },
  { "colantonio.homelinux.net", true },
  { "colasjourdain.fr", true },
  { "colchonesmoon.com", true },
  { "colcomm.com", true },
  { "coldawn.com", false },
  { "coldcardwallet.com", true },
  { "coldfff.com", true },
  { "coldhak.ca", true },
  { "coldiario.com", true },
  { "coldlasers.org", true },
  { "coldren.org", true },
  { "coldstreamcreekfarm.com", true },
  { "colemak.com", true },
  { "colengo.com", true },
  { "colf.online", true },
  { "colibris.xyz", true },
  { "colincogle.name", true },
  { "colinespinas.com", true },
  { "colinsnaith.co.uk", true },
  { "colinstark.ca", true },
  { "collab.ddnss.org", true },
  { "collabora-office.com", true },
  { "collabora.ca", true },
  { "collabora.co.kr", true },
  { "collabora.co.uk", true },
  { "collabora.com", true },
  { "collabora.kr", true },
  { "collabora.ninja", true },
  { "collabora.social", true },
  { "collabora.uk", true },
  { "collaboracloudsuite.com", true },
  { "collaboraoffice.co.uk", true },
  { "collaboraoffice.com", true },
  { "collaborativehealthpsychology.com", true },
  { "collabornation.net", true },
  { "collaction.hk", true },
  { "collada.org", true },
  { "collectdocs.com", true },
  { "collectiblebeans.com", true },
  { "collectivesupply.com", true },
  { "collectorknives.net", true },
  { "collectorsystems.com", true },
  { "collegeconnexxions.com.au", true },
  { "collegegirlhd.com", true },
  { "collegenavigator.gov", true },
  { "collegepaperworld.com", true },
  { "collegeprospectsofcentralindiana.com", true },
  { "collegereligionandphilosophy.com", true },
  { "collegesexvid.com", true },
  { "collegestationhomes.com", true },
  { "collinel-hossari.com", true },
  { "collinelhossari.com", true },
  { "collinklippel.com", true },
  { "collinmbarrett.com", true },
  { "colloquy.mobi", true },
  { "cololi.moe", true },
  { "colombiajeans.co", true },
  { "colombian.dating", true },
  { "colombianas.webcam", true },
  { "colonize.africa", true },
  { "color01.net", true },
  { "colorblindprogramming.com", true },
  { "colorbrush.ru", true },
  { "colorcodedlyrics.com", true },
  { "colorectalcompounding.com", true },
  { "colorfuldots.com", true },
  { "colorhexa.com", true },
  { "coloristcafe.com", true },
  { "colorlib.com", false },
  { "colorpicker.fr", true },
  { "colors3d.com", true },
  { "colorsbycarin.com", true },
  { "colossal-events.co.uk", true },
  { "colourfulcastles.co.uk", true },
  { "colourmanagementpro.com", true },
  { "colpacpackaging.com", true },
  { "colson-occasions.be", false },
  { "coltellisurvival.com", true },
  { "columbuswines.com", true },
  { "colyakoomusic.com", true },
  { "colyakootees.com", true },
  { "com-in.de", true },
  { "com.cc", true },
  { "comalia.com", true },
  { "comarkinstruments.net", true },
  { "combigo.com", true },
  { "combron.be", true },
  { "combron.co.uk", true },
  { "combron.com", true },
  { "combron.nl", true },
  { "comcol.nl", true },
  { "comcov.com", true },
  { "comdotgame.com", true },
  { "comdurav.com", true },
  { "comeals.com", true },
  { "comedimagrire.it", true },
  { "comedyhuis.nl", true },
  { "comeoishii.com", true },
  { "comercialbelzunces.com", true },
  { "comercialroxana.com", true },
  { "comercialtpv.com", true },
  { "comercialtrading.eu", true },
  { "comerford.net", true },
  { "comestoarra.com", true },
  { "cometcache.com", true },
  { "cometonovascotia.ca", true },
  { "comff.net", true },
  { "comfintouch.com", true },
  { "comflores.com.br", true },
  { "comfortmastersinsulation.com", true },
  { "comfortsolutionsair.com", true },
  { "comhack.com", true },
  { "comicbank.org", true },
  { "comicsans.tk", true },
  { "comicspornos.com", true },
  { "comicspornow.com", true },
  { "comicspornoxxx.com", true },
  { "comicwiki.dk", true },
  { "comidina.com", true },
  { "comiteaintriathlon.fr", true },
  { "comiteexpertes.gc.ca", true },
  { "comlipa.gq", true },
  { "comm.cx", true },
  { "commco.nl", true },
  { "commechezvous.ch", false },
  { "commerce.gov", true },
  { "commercezen.com", true },
  { "commercia.srl", true },
  { "commercial-academy.fr", true },
  { "commeunamour.com", true },
  { "commissaris-vraagbaak.nl", true },
  { "commissionagenda.com", true },
  { "commitsandrebases.com", true },
  { "commlabindia.com", true },
  { "common.io", true },
  { "commoncode.com.au", true },
  { "commoncode.io", true },
  { "commoncore4kids.com", true },
  { "commons-mayflower.tk", true },
  { "commonsenseamericanpolitics.com", true },
  { "communalconsulting.org", true },
  { "communiques.info", true },
  { "communist-party.tk", true },
  { "communitychurchafrica.co.za", true },
  { "communitycodeofconduct.com", true },
  { "communitymanagertorrejon.com", true },
  { "communote.net", true },
  { "commure.com", true },
  { "como-se-escribe.com", true },
  { "comoaliviareldolor.de", true },
  { "comoculosdesol.pt", true },
  { "comocurarlagastritis24.online", true },
  { "comocurarlagastritistratamientonatural.com", true },
  { "comodesinflamarlashemorroides.org", true },
  { "comodo.nl", true },
  { "comodormirmasrapido.com", true },
  { "comodosslstore.com", true },
  { "comogene.com", true },
  { "comohacerblog.net", true },
  { "comohacerpara.com", true },
  { "comoimportar.net", true },
  { "comopuededejardefumar.net", true },
  { "comoquitarlacaspa24.com", true },
  { "comosecarabarriga.net", true },
  { "comoseduzir.net", true },
  { "comosefazisto.com.br", true },
  { "comp.kiev.ua", true },
  { "comp2go.com.au", true },
  { "compactchess.cc", true },
  { "compagnia-buffo.de", false },
  { "compagniemartin.com", false },
  { "companion-web.net", true },
  { "comparatif-moto.fr", true },
  { "compareandrecycle.co.uk", true },
  { "comparecompensationclaims.com", true },
  { "compareinsurance.com.au", true },
  { "comparemymobile.com", true },
  { "comparesoft.com", true },
  { "comparewatch.com", true },
  { "comparexcloudcenter.com", true },
  { "compartirtrenmesaave.com", true },
  { "compassdirectportal.com", true },
  { "compassfinance.com", true },
  { "compassintladv.com", true },
  { "compassionaterelease.com", true },
  { "compassleaf.com", true },
  { "compasslos.com", true },
  { "compeat.com", true },
  { "competencyassessment.ca", true },
  { "competitor.com", true },
  { "comphare.nl", true },
  { "compibus.fr", true },
  { "compilenix.org", true },
  { "complete-it.co.uk", true },
  { "completefloorcoverings.com", true },
  { "completesecurityessex.co.uk", true },
  { "completesecurityessex.com", true },
  { "completionist.me", true },
  { "complexart.ro", true },
  { "complexorganization.com", true },
  { "complexorganizations.com", true },
  { "compliance-management.ch", false },
  { "compliance-systeme.de", true },
  { "compliancedictionary.com", true },
  { "compliancerisksoftware.co.uk", true },
  { "compliantbusinessprocessing.com", true },
  { "componentshop.co.uk", true },
  { "compositedevtec.tk", true },
  { "compostatebien.com.ar", true },
  { "compoundingrxusa.com", true },
  { "comprarcarteras.online", true },
  { "comprarimpresoras-3d.com", true },
  { "comprarparaguas.online", true },
  { "comprauncelular.com", true },
  { "compreautomacao.com.br", true },
  { "compree.com", true },
  { "compservice.in.ua", true },
  { "comptablevilledequebec.com", true },
  { "comptrollerofthecurrency.gov", true },
  { "comptu.com", true },
  { "compubench.com", true },
  { "compucorner.mx", true },
  { "compunetwor.com", true },
  { "compuplast.cz", true },
  { "computec.ch", true },
  { "computehealth.com", true },
  { "computer-acquisti.com", true },
  { "computer-science-schools.com", true },
  { "computerassistance.co.uk", true },
  { "computerbase.de", true },
  { "computercamaccgi.com", true },
  { "computercraft.net", true },
  { "computeremergency.com.au", false },
  { "computerhilfe-feucht.de", true },
  { "computerinfobits.com", true },
  { "computernetwerkwestland.nl", true },
  { "computersystems.guru", false },
  { "computingsociety.co.uk", true },
  { "computop.com", true },
  { "computron.ga", true },
  { "comschool.com.br", true },
  { "comumlab.org", true },
  { "comunidadmontepinar.es", true },
  { "comvos.de", true },
  { "comw.cc", true },
  { "con-con.nl", true },
  { "conalcorp.com", true },
  { "conalpedis.tk", true },
  { "conatus.ai", true },
  { "conaudisa.com", false },
  { "concept-web.ch", false },
  { "concerto.amsterdam", true },
  { "concertsenboite.fr", true },
  { "concertsto.com", true },
  { "conciencia.fit", true },
  { "concierge.diet", true },
  { "concilio.com", true },
  { "conciliumnotaire.ca", true },
  { "concordiagaming.com", true },
  { "concordsoftwareleasing.com", true },
  { "concretelevelingsystems.com", true },
  { "concreterepairatlanta.com", true },
  { "concreterepairconcreteraising.com", true },
  { "concursos.com.br", true },
  { "concursosabertos.com.br", true },
  { "concursuri.biz", true },
  { "condecom.com.br", true },
  { "condepenalba.com", false },
  { "condesaelectronics.com", true },
  { "condolencemessages.net", true },
  { "condominiosi.it", true },
  { "condominioweb.com", true },
  { "condosforcash.com", true },
  { "condroz-motors.be", false },
  { "conectadev.com", true },
  { "conectumfinanse.pl", true },
  { "conejovalleyelectrical.com", true },
  { "conejovalleyelectrician.com", true },
  { "conejovalleyexteriorlighting.com", true },
  { "conejovalleylandscapelighting.com", true },
  { "conejovalleylighting.com", true },
  { "conejovalleyoutdoorlighting.com", true },
  { "conexiontransporte.com", true },
  { "conference-expert.eu", true },
  { "confiancefoundation.org", true },
  { "config.schokokeks.org", false },
  { "confiscate.ga", true },
  { "confiwall.de", true },
  { "conforama.es", true },
  { "conforama.pt", true },
  { "conformal.com", false },
  { "conformax.com.br", true },
  { "confrerie-rp.fr", true },
  { "conftree.com", true },
  { "confygo.com", true },
  { "congafasdesol.com", true },
  { "congineer.com", true },
  { "congobunkering.com", false },
  { "congresscoverage.com", true },
  { "conju.cat", true },
  { "conjugacao.com.br", true },
  { "conkret.mobi", true },
  { "conmedapps.com", true },
  { "conn.cx", true },
  { "connect-ed.network", true },
  { "connect-me.com", true },
  { "connect.dating", true },
  { "connect.facebook.net", true },
  { "connecta.store", true },
  { "connectedcare.md", true },
  { "connectfri.club", true },
  { "connectfss.com", true },
  { "connectingrentals.com", true },
  { "connectingrentalsofbethel.com", true },
  { "connectionstrings.com", true },
  { "connectivia.it", true },
  { "connectmath.com", true },
  { "connectme.com.mx", true },
  { "connectmy.car", true },
  { "connecto-data.com", true },
  { "connectum.eu", true },
  { "conner.work", true },
  { "connexas.eu", true },
  { "connexfilter.com", true },
  { "connexion.health", true },
  { "connexionht.com", true },
  { "connext.de", true },
  { "connictro.de", true },
  { "connorhatch.com", true },
  { "connyduck.at", true },
  { "conocchialidasole.it", true },
  { "conocedordigital.com", true },
  { "conociendosalama.com", true },
  { "conorboyd.info", true },
  { "conory.com", true },
  { "conotoxia.com", true },
  { "conquer-addiction.org", true },
  { "conrad-kostecki.de", true },
  { "conradboraboranuiresort.com", true },
  { "conradcartagena.com", true },
  { "conradkostecki.de", true },
  { "conradsautotransmissionrepair.com", true },
  { "consagracionamariasantisima.org", true },
  { "consciente.ch", true },
  { "consciente.ngo", true },
  { "consciente.ong", true },
  { "consciouschoices.net", true },
  { "consegnafioridomicilio.net", true },
  { "consegne.it", true },
  { "consejosdenutricion.com", true },
  { "consensoprivacy.it", true },
  { "consertodecelulares.com.br", true },
  { "conservativenewsandviews.com", true },
  { "consideredgifts.com", true },
  { "consilium-vitae.ch", true },
  { "consiliumvitae.ch", true },
  { "console-tribe.com", true },
  { "console.rest", true },
  { "consoleuniverse.tk", true },
  { "consommateuraverti.com", true },
  { "constant-rough.de", true },
  { "consteval.org", true },
  { "constexpr.org", true },
  { "constinit.org", true },
  { "constitution.website", true },
  { "construct.net", true },
  { "constructieve.nl", true },
  { "construction-colleges.com", true },
  { "construction-student.co.uk", true },
  { "constructive.men", true },
  { "construred.tk", true },
  { "consul.io", true },
  { "consulenza.pro", true },
  { "consultation.biz.tr", true },
  { "consultimator.com", true },
  { "consultimedia.de", true },
  { "consulting-cloud.com", true },
  { "consultingconnection.co", true },
  { "consultinghero.es", true },
  { "consultoresrey.cl", true },
  { "consultoriadeseguranca.com.br", true },
  { "consultoriosodontologicos.com.br", true },
  { "consultpetkov.com", true },
  { "consulvation.com", true },
  { "consumeractionlawgroup.com", true },
  { "consumerfiles.com", true },
  { "consumersentinel.gov", true },
  { "consuwijzer.nl", true },
  { "contabilidadebrooklin.com.br", true },
  { "contact.inc", true },
  { "contact.xyz", true },
  { "contactaffix.com", true },
  { "containerspace.com.au", true },
  { "contaquanto.com.br", true },
  { "contemplativeeducation.org", true },
  { "content-api-dev.azurewebsites.net", false },
  { "contentcoms.co.uk", true },
  { "contenthosting.com.br", true },
  { "contentmarathon.com", true },
  { "contentpass.net", true },
  { "contentq.nl", true },
  { "contessa32experience.com", true },
  { "conti-profitlink.co.uk", true },
  { "continuumrecoverycenter.com", true },
  { "contouring.fr", true },
  { "contrabass.net", true },
  { "contractormountain.com", true },
  { "contractorswestga.com", true },
  { "contractwriters.com", true },
  { "contrasentido.net", true },
  { "contraspin.co.nz", true },
  { "contratatupoliza.com", true },
  { "contratti.it", true },
  { "contributor.google.com", false },
  { "controlambientalbogota.com", true },
  { "controlautocom.com.br", true },
  { "controlbooth.com", true },
  { "controle.net", true },
  { "controleer-maar-een-ander.nl", true },
  { "controllertech.com", true },
  { "controlvoltage.cc", true },
  { "contunda.de", true },
  { "conv2pdf.com", true },
  { "convergence.fi", true },
  { "convergencela.com", true },
  { "convergnce.com", true },
  { "conversationsri.ga", true },
  { "conversiepartners.nl", true },
  { "conversiones.com", true },
  { "convert.im", true },
  { "converticacommerce.com", false },
  { "convertimg.com", true },
  { "cookescastles.co.uk", true },
  { "cookicons.co", true },
  { "cookie4.com", true },
  { "cookieandkate.com", true },
  { "cookiecrook.com", true },
  { "cooking-sun.com", true },
  { "cookingcrusade.com", true },
  { "cookinglife.nl", false },
  { "cookingperfected.com", true },
  { "cookingreporter.com", true },
  { "cookmedical.com", false },
  { "cookwithmanali.com", true },
  { "cool-parties.co.uk", true },
  { "cool-wallpapers.jp", true },
  { "cool.haus", true },
  { "cool110.tk", true },
  { "cool110.xyz", true },
  { "coolattractions.co.uk", true },
  { "coolbitx.com", true },
  { "coolcamping.com", true },
  { "cooldan.com", true },
  { "coole-fete.de", true },
  { "coolgifs.de", true },
  { "cooljv.com", true },
  { "coolprylar.se", true },
  { "coolshirt.tk", true },
  { "coomonte.tk", true },
  { "coonawarrawines.com.au", true },
  { "coonelnel.net", true },
  { "coore.jp", true },
  { "coorpacademy.com", true },
  { "coorpintr.com", true },
  { "copan.com.br", true },
  { "copdfoundation.org", true },
  { "copenhagenoptimization.com", true },
  { "copleylawfirm.com", true },
  { "copperandtileroofing.com", true },
  { "copperheados.com", true },
  { "coppidesentupidora.com.br", true },
  { "copplaw.com", true },
  { "coptel.cz", true },
  { "coptkm.cz", true },
  { "copycaught.com", true },
  { "copycaught.net", true },
  { "copycaught.org", true },
  { "copycenter.cf", true },
  { "copycrafter.net", true },
  { "copydz.com", true },
  { "copypoison.com", true },
  { "copyright-watch.org", true },
  { "copyrightcoins.com", true },
  { "copyrightcoins.help", true },
  { "copyrightcoinsnews.com", true },
  { "copyshrug.ca", true },
  { "copywriting-on-demand.tk", true },
  { "coralreef.blue", true },
  { "corbi.net.au", true },
  { "cordejong.nl", true },
  { "cordemar.info", true },
  { "corder.tech", true },
  { "cordeydesign.ch", false },
  { "cordis.io", true },
  { "cordis.tk", true },
  { "cordlessdog.com", true },
  { "cordobaaldia.com.mx", true },
  { "core-concepts.de", false },
  { "core-networks.de", true },
  { "core.mx", true },
  { "core.org.pt", true },
  { "coreapm.org", true },
  { "corecodec.com", true },
  { "corehealthberks.com", true },
  { "coreless-stretchfilm.com", true },
  { "corelia.net", true },
  { "corepartners.com.ua", true },
  { "coresolutions.ca", true },
  { "coreum.ca", true },
  { "corevetconnect.co.uk", true },
  { "coreyjmahler.com", true },
  { "corgi.party", true },
  { "coribi.com", true },
  { "corinastefan.ro", true },
  { "corintech.net", true },
  { "coriolis.ch", true },
  { "corisu.co", true },
  { "corkedwinebar.com", true },
  { "corkerscrisps.co.uk", true },
  { "corksoncolumbus.com", true },
  { "corlija.com", true },
  { "corlinde.nl", true },
  { "corlitocaffe.de", true },
  { "cornercircle.co.uk", true },
  { "cornergarage.coop", true },
  { "cornerstone.network", true },
  { "cornerstonecmc.org", true },
  { "cornfestgiethoorn.nl", true },
  { "corniche.com", true },
  { "corningcu.org", true },
  { "cornitek.tk", true },
  { "cornmachine.com", true },
  { "cornodo.com", true },
  { "corona-academy.com", true },
  { "corona-renderer.cloud", true },
  { "corona-renderer.com", true },
  { "coronersconnect.co.uk", true },
  { "coropiacere.org", true },
  { "corp.goog", true },
  { "corpfin.net", true },
  { "corpio.nl", true },
  { "corpkitnw.com", true },
  { "corpoflow.nl", true },
  { "corporateclash.net", true },
  { "corporatecomputingsolutions.com", true },
  { "corporateinfluencers.com", true },
  { "corpulant.coffee", true },
  { "corpulantcoffee.com", true },
  { "corpulent.coffee", true },
  { "corpulentcoffee.com", true },
  { "corpuschristisouthriver.org", true },
  { "corpusslayer.com", true },
  { "corrbee.com", true },
  { "correct.cf", true },
  { "correctconstructions.com.au", true },
  { "correctiv.org", true },
  { "correctlydesign.com", true },
  { "correctpaardbatterijnietje.nl", true },
  { "correotemporal.org", true },
  { "corrick.io", true },
  { "corriel.com", true },
  { "corrupted.io", true },
  { "corruptos.tk", true },
  { "corsa-b.uk", true },
  { "corscanplus.com", true },
  { "corsicalaw.com", true },
  { "corsihaccpsicurezzalavoro.it", true },
  { "corsisicurezza.it", true },
  { "corso-antincendio.org", true },
  { "corsomassaggi.it", true },
  { "cortealcastello.it", true },
  { "cortexitrecruitment.com", true },
  { "cortexx.nl", true },
  { "cortis-consulting.ch", true },
  { "corvax.kiev.ua", true },
  { "corvee.com", true },
  { "coryadum.com", true },
  { "corytyburski.com", true },
  { "cosasque.com", true },
  { "cosciamoos.com", true },
  { "cosec.cn", true },
  { "cosirex.com", true },
  { "cosmechic.fr", true },
  { "cosmekaitori.jp", true },
  { "cosmeticappraisal.com", true },
  { "cosmeticasimple.com", true },
  { "cosmetify.com", true },
  { "cosmetique-totale.nl", true },
  { "cosmic-os.org", true },
  { "cosmicnavigator.com", true },
  { "cosmicworlds.com", true },
  { "cosmicworlds.mobi", true },
  { "cosmodacollection.com", true },
  { "cosmofunnel.com", true },
  { "cosmohit.ua", true },
  { "cosmos-software.tk", true },
  { "cosmundi.de", true },
  { "cosplayer.com", true },
  { "cospol.ch", false },
  { "costablancavoorjou.com", true },
  { "costarellos.com", true },
  { "costcoinsider.com", true },
  { "costinstefan.eu", true },
  { "costreportdata.com", false },
  { "costulessdirect.com", true },
  { "coteibem.com.br", true },
  { "coteries.com", false },
  { "cotoacc.com", true },
  { "cotonmusic.ch", false },
  { "cotswoldflatroofing.com", true },
  { "cotwe-ge.ch", false },
  { "cou.re", true },
  { "cougar.dating", true },
  { "counselingfw.com", true },
  { "counsellingtime.com", true },
  { "counstellor.com", false },
  { "countdowntrader.com", true },
  { "counter-team.ch", false },
  { "counterenlol.com", true },
  { "counterglobal.com", true },
  { "countermail.com", false },
  { "countermats.net", true },
  { "countersolutions.co.uk", true },
  { "countetime.com", true },
  { "country-creativ.de", true },
  { "countrybrewer.com.au", true },
  { "countryfrog.uk", true },
  { "countryhouseresort.com", true },
  { "countrylife.cz", true },
  { "countryoutlaws.ca", true },
  { "countrysidemarquees.co.uk", true },
  { "countybankdel.com", true },
  { "countyjailinmatesearch.com", true },
  { "coupestanley.com", true },
  { "couponbates.com", true },
  { "couponbre.com", true },
  { "couponcodesme.com", true },
  { "couponlo.net", true },
  { "cour4g3.me", true },
  { "couragefound.org", true },
  { "couriergrey.com", true },
  { "couriersrs.com", true },
  { "coursables.com", true },
  { "courseconfidence.com", true },
  { "coursera.org", true },
  { "courseworkbank.info", true },
  { "courvix.com", true },
  { "coussinsky.net", true },
  { "couvreur-hinault.fr", true },
  { "covbounce.co.uk", true },
  { "coveredinspiders.com", true },
  { "covershousing.nl", true },
  { "covery.ai", true },
  { "covoiturage.fr", true },
  { "covve.com", false },
  { "covybrat.cz", true },
  { "cowbird.org", true },
  { "coweo.cz", true },
  { "coworking-luzern.ch", true },
  { "cowsay.blog", true },
  { "coxcapitalmanagement.com", true },
  { "coxxs.me", true },
  { "coxxs.moe", true },
  { "coya.tw", true },
  { "cozmoyachts.com", true },
  { "cozo.me", true },
  { "cozumel-activities.com", true },
  { "cozyeggdesigns.com", true },
  { "cp-st-martin.be", true },
  { "cp015.com", true },
  { "cpars.gov", true },
  { "cpasperdu.com", true },
  { "cpcheats.co", true },
  { "cpchur.ch", true },
  { "cpd-education.co.uk", true },
  { "cpe-colleg.de", true },
  { "cpe-registry.com", true },
  { "cpe-registry.net", true },
  { "cpe-registry.org", true },
  { "cpegypt.tk", true },
  { "cperegistry.net", true },
  { "cperegistry.org", true },
  { "cpgarmor.com", true },
  { "cphpvb.net", true },
  { "cplus.me", true },
  { "cplusplus.se", true },
  { "cppan.org", true },
  { "cppaste.org", true },
  { "cpqcol.gov.co", true },
  { "cprnearme.com", true },
  { "cpsa.co.uk", true },
  { "cpsc.gov", true },
  { "cpsurvey.com", true },
  { "cptoon.com", true },
  { "cpu.biz.tr", true },
  { "cpvmatch.eu", true },
  { "cpy.pt", true },
  { "cqn.ch", false },
  { "cr.search.yahoo.com", false },
  { "cr8haven.com", true },
  { "cra-bank.com", true },
  { "cra-search.net", true },
  { "craazzyman21.at", true },
  { "crabrave.space", true },
  { "crackcat.de", true },
  { "cracker.in.th", true },
  { "crackheros.site", true },
  { "crackle.io", true },
  { "crackorsquad.in", true },
  { "crackslut.eu", true },
  { "cracksnet.tk", true },
  { "crackstation.net", true },
  { "cradlepointecm.com", true },
  { "craft-beer.life", true },
  { "craft-me-in.com", true },
  { "craftandbuild.de", true },
  { "crafted.cat", true },
  { "crafters.co.jp", true },
  { "craftinghand.com", true },
  { "craftinginredlipstick.com", true },
  { "craftist.de", true },
  { "craftmachinec.com", true },
  { "craftshiponline.tk", true },
  { "craftsmandruggets.com", true },
  { "craftsmany.net", true },
  { "crafttalk.tk", true },
  { "craftyguy.net", true },
  { "craftyphotons.net", true },
  { "crag.com.tw", true },
  { "craig-mullins.com", true },
  { "craigbates.co.uk", false },
  { "craigdavis.ga", true },
  { "craigfrancis.co.uk", true },
  { "craigleclaireteam.com", true },
  { "craigrouse.com", true },
  { "craigwfox.com", true },
  { "crain.com.au", true },
  { "cralarm.de", true },
  { "cramersoft.com", true },
  { "cranberry-tee.de", true },
  { "crandall.io", true },
  { "cranforddental.com", true },
  { "cranshafengin.com", true },
  { "crapmail.tk", true },
  { "crapouill.es", true },
  { "crashboy.ws", true },
  { "craterx.com", true },
  { "cratss.co.uk", true },
  { "crawford.cloud", true },
  { "crawfordcountytcc.org", true },
  { "crawler.ninja", true },
  { "crawleybouncycastles.co.uk", true },
  { "crawlspaceandbasementsolutions.com", true },
  { "crazy-bulks.com", true },
  { "crazy-cat.net", true },
  { "crazy-coders.com", true },
  { "crazybulk.co.uk", true },
  { "crazybulk.com", true },
  { "crazybulk.de", true },
  { "crazybulk.fr", true },
  { "crazycastles.ie", true },
  { "crazycraftland.net", true },
  { "crazydomains.ae", true },
  { "crazydomains.co.nz", true },
  { "crazydomains.co.uk", true },
  { "crazydomains.com.au", true },
  { "crazydomains.in", true },
  { "crazygifts.cf", true },
  { "crazymarvin.com", true },
  { "crazymeeshu.com", true },
  { "crazynoisybizarre.town", true },
  { "crazypaul.com", true },
  { "crazypowered.com", true },
  { "crbug.com", true },
  { "crc-bank.com", true },
  { "crc-search.com", true },
  { "crdmendoza.net", true },
  { "crea-etc.net", false },
  { "crea-th.at", true },
  { "crea-that.fr", true },
  { "crea.bg", true },
  { "crealogix-online.com", true },
  { "creamcastles.co.uk", true },
  { "creampiepornvids.com", true },
  { "creamsoft.com", true },
  { "creamyfox.com", true },
  { "creared.edu.co", true },
  { "creareup.com", true },
  { "createbeing.com", true },
  { "createcos.com", true },
  { "creategyx.ga", true },
  { "createme.com.pl", true },
  { "creatic.co", true },
  { "creatieven.com", true },
  { "creation-contemporaine.com", true },
  { "creationsgate.com", true },
  { "creative-thinking.ro", true },
  { "creative-wave.fr", true },
  { "creativeangles.in", true },
  { "creativecaptiv.es", true },
  { "creativecommons.gr", true },
  { "creativecommons.org", true },
  { "creativeconceptsvernon.com", true },
  { "creativedigital.co.nz", true },
  { "creativeglassgifts.com.au", true },
  { "creativeground.com.au", true },
  { "creativeideasagency.com", true },
  { "creativeimagery.com.au", true },
  { "creativeink.de", true },
  { "creativekkids.com", true },
  { "creativelaw.eu", true },
  { "creativeliquid.com", true },
  { "creativesectors.tk", true },
  { "creativesurvey.com", true },
  { "creativeweb.biz", true },
  { "creativewolf.net", true },
  { "creativosonline.org", true },
  { "creatixx-network.de", false },
  { "creatleencoaching.com", true },
  { "creators-design.com", true },
  { "creators.direct", true },
  { "creatorswave.com", true },
  { "crebita.de", true },
  { "crecman.fr", true },
  { "credential.eu", true },
  { "credex.bg", true },
  { "credigo.se", true },
  { "credit-default-swaps.tk", true },
  { "creditif.tk", true },
  { "creditkarma.com", true },
  { "credito360.pt", true },
  { "creditor.tk", true },
  { "creditorapido.pt", true },
  { "creditos-rapidos.com", true },
  { "creditozen.es", true },
  { "creditozen.mx", true },
  { "creditproautos.com", false },
  { "creditscoretalk.com", true },
  { "creeks-coworking.com", true },
  { "creep.im", true },
  { "creepypastas.com", true },
  { "creepypastas.net", true },
  { "creer-une-boutique-en-ligne.com", true },
  { "creermonsite-wp.com", true },
  { "creerunsitepro.com", true },
  { "crefelder.com", true },
  { "crem.in", false },
  { "cremedigital.com", true },
  { "cremepassion.de", true },
  { "crena.ch", true },
  { "crepa.ch", false },
  { "crestasantos.com", false },
  { "cretdupuy.com", false },
  { "creteangle.com", true },
  { "cretica.no", true },
  { "creusalp.ch", false },
  { "crew.moe", true },
  { "crgalvin.com", true },
  { "crgm.net", true },
  { "cribcore.com", true },
  { "cricklewood.condos", true },
  { "criena.com", true },
  { "criena.net", true },
  { "crime-lawyers.com", true },
  { "crimefreeliving.com", true },
  { "crimesolutions.gov", true },
  { "crimevictims.gov", true },
  { "criminal-attorney.ru", true },
  { "criminal.enterprises", true },
  { "crimsonconnect.co.uk", true },
  { "crinesdanzantes.be", true },
  { "criptocert.com", true },
  { "criptoinvest.pt", true },
  { "criptolog.com", true },
  { "criptomoneylite.tk", true },
  { "criscitos.it", true },
  { "crisisactual.com", true },
  { "crisisnextdoor.gov", true },
  { "crismatthews.com", true },
  { "crisp.chat", true },
  { "crisp.email", true },
  { "crisp.help", true },
  { "crisp.im", true },
  { "crisp.watch", true },
  { "crispinusphotography.com", true },
  { "cristalstandards.com", true },
  { "cristarta.com", true },
  { "cristau.org", true },
  { "cristianonascimento.ml", true },
  { "cristianuibar.com", true },
  { "critical.today", false },
  { "criticalgenesis.tk", true },
  { "criticalsurveys.co.uk", true },
  { "critterguard.org", true },
  { "crizin.io", true },
  { "crm.onlime.ch", false },
  { "crm114d.com", true },
  { "croceverdevb.it", true },
  { "crochetnerd.com", true },
  { "croco.vision", true },
  { "crocuscoaching.co.uk", true },
  { "croisedanslemetro.com", true },
  { "croixblanche-haguenau.fr", false },
  { "cromefire.myds.me", true },
  { "cromosomax.com", true },
  { "cromwellvets.co.uk", true },
  { "cronberg.ch", true },
  { "cronenberg.cc", true },
  { "cronix.cc", true },
  { "cronologie.de", true },
  { "cronometer.com", true },
  { "cronoscentral.be", true },
  { "cropdiagnosis.com", true },
  { "crosbug.com", true },
  { "cross-culture.tk", true },
  { "cross-led-sign.com", true },
  { "cross-view.com", true },
  { "cross.lol", true },
  { "crossborderreturns.com", true },
  { "crossedwires.net", true },
  { "crossfiremovies.tk", true },
  { "crossfitblackwater.com", true },
  { "crossformer.com", true },
  { "crosslifenutrition.co.uk", false },
  { "crossnet.io", true },
  { "crossoverit.com", true },
  { "crosspeakoms.com", true },
  { "crossroads-gmbh.ch", true },
  { "crossway.nl", true },
  { "crosswords123.com", true },
  { "crowcloud.com", true },
  { "crowd.supply", true },
  { "crowdbox.net", true },
  { "crowdcloud.be", true },
  { "crowdliminal.com", true },
  { "crowdsim3d.com", true },
  { "crowdspire.org", true },
  { "crowdsupply.com", true },
  { "crowleymarine.com", true },
  { "crownaffairs.ch", true },
  { "crownbouncycastlehire.co.uk", true },
  { "crowncastles.co.uk", true },
  { "crownmarqueehire.co.uk", true },
  { "crownpoint.com", true },
  { "crownsterling.io", true },
  { "crows.io", true },
  { "croydonapartments.com.au", true },
  { "croydonbouncycastles.co.uk", true },
  { "crrev.com", true },
  { "crsmsodry.cz", true },
  { "crsoresina.it", true },
  { "crstat.ru", true },
  { "crt.cloud", true },
  { "crtalleres.com", true },
  { "crucibleofworlds.com", true },
  { "cruicky.uk", true },
  { "cruisemoab.com", true },
  { "crumbcontrol.com", true },
  { "crunchrapps.com", true },
  { "crustytoothpaste.net", true },
  { "crute.me", true },
  { "crvegas.com", true },
  { "crvv.me", true },
  { "cry-sys.de", true },
  { "cry.nu", false },
  { "cryoblaster.com", true },
  { "cryothanasia.com", true },
  { "crypt.is-by.us", true },
  { "cryptagio.com", true },
  { "cryptearth.de", true },
  { "crypted.chat", true },
  { "crypteianetworks.com", true },
  { "cryptex.net", true },
  { "cryptex.pw", true },
  { "cryptizy.com", true },
  { "crypto.cat", false },
  { "crypto.graphics", true },
  { "crypto.is", false },
  { "cryptobin.co", true },
  { "cryptocon.org", true },
  { "cryptoegg.ca", true },
  { "cryptofan.org", true },
  { "cryptofrog.co", true },
  { "cryptography.ch", true },
  { "cryptography.io", true },
  { "cryptoguidemap.com", true },
  { "cryptoholic.co", true },
  { "cryptoisnotacrime.org", true },
  { "cryptojacks.io", true },
  { "cryptojourney.com", true },
  { "cryptology.ch", true },
  { "cryptomail.nl", true },
  { "cryptomaniaks.com", true },
  { "cryptonom.org", true },
  { "cryptonym.com", true },
  { "cryptoparty.at", true },
  { "cryptoparty.tv", true },
  { "cryptopartyutah.org", true },
  { "cryptopaste.org", true },
  { "cryptophobia.nl", true },
  { "cryptorival.com", true },
  { "cryptoseb.pw", true },
  { "cryptoshot.pw", true },
  { "cryptract.co", true },
  { "crys.cloud", true },
  { "crys.email", true },
  { "crys.hu", true },
  { "crys.me", true },
  { "crys.ovh", true },
  { "crys.pw", true },
  { "crys.tv", true },
  { "crystal-zone.com", true },
  { "crystalapp.ca", true },
  { "crystalchandelierservices.com", true },
  { "crystalgrid.net", true },
  { "crystaloscillat.com", true },
  { "crystalroad.net", true },
  { "crystalzoneshop.com", true },
  { "crystone.me", true },
  { "cryz.ru", true },
  { "cs-algeria.tk", true },
  { "cs.money", true },
  { "cs2016.ch", true },
  { "csa-library.org", true },
  { "csaapac.com", true },
  { "csaapac.org", true },
  { "csabg.org", true },
  { "csacongress.com", true },
  { "csacongress.org", true },
  { "csacongress.us", true },
  { "csadc.org", true },
  { "csasummit.net", true },
  { "csca.me", true },
  { "cscau.com", true },
  { "cscdn.net", true },
  { "csci571.com", true },
  { "csd-slovenije.si", true },
  { "cselzer.com", true },
  { "csfcloud.com", true },
  { "csfd.cz", true },
  { "csgf.fun", true },
  { "csgf.ru", true },
  { "csgo.su", true },
  { "csgoswap.com", true },
  { "csharpmarc.net", true },
  { "cshub.nl", true },
  { "csi.lk", true },
  { "csinterstargeneve.ch", false },
  { "csirt.ee", true },
  { "csjministriesfoundation.org", true },
  { "cskentertainment.co.uk", true },
  { "cslaboralistas.pe", true },
  { "csmainframe.com", true },
  { "csosa.gov", true },
  { "csovek-idomok.hu", true },
  { "csp.ch", false },
  { "cspeti.hu", true },
  { "cspvalidator.org", true },
  { "csrichter.com", true },
  { "css-tricks.tk", true },
  { "css.direct", false },
  { "cssai.eu", true },
  { "cssaunion.com", true },
  { "cst188.cc", true },
  { "cstanley.net", true },
  { "cstb.ch", false },
  { "cstp-marketing.com", true },
  { "cstrong.nl", true },
  { "csu.st", true },
  { "csust.net", true },
  { "csvalpha.nl", true },
  { "cswarzone.com", true },
  { "cswebi.net", true },
  { "cswgmbh.de", true },
  { "csy.hu", true },
  { "ct.search.yahoo.com", false },
  { "ctc-transportation.com", true },
  { "ctcom-peru.com", true },
  { "ctcue.com", true },
  { "ctes.cz", true },
  { "ctf-albstadt.de", true },
  { "ctf.link", true },
  { "ctkwwri.org", true },
  { "ctliu.com", true },
  { "ctmrepository.com", true },
  { "ctnguyen.de", true },
  { "ctnguyen.net", true },
  { "ctns.de", false },
  { "ctoin.tw", true },
  { "ctomp.io", false },
  { "ctpe.net", true },
  { "ctrl.blog", true },
  { "cttso.gov", true },
  { "cu247secure.ie", true },
  { "cuatroymedia.com", true },
  { "cub-bouncingcastles.co.uk", true },
  { "cubaal.com", true },
  { "cubanchino.tk", true },
  { "cube.builders", true },
  { "cubebot.io", true },
  { "cubebuilders.net", true },
  { "cubecart-demo.co.uk", true },
  { "cubecart-hosting.co.uk", true },
  { "cubecraft.net", true },
  { "cubecraftcdn.com", true },
  { "cubekrowd.net", true },
  { "cubeperformancecentre.com.au", true },
  { "cubesugar.info", true },
  { "cubetech.co.jp", true },
  { "cubia.de", true },
  { "cubia3.com", true },
  { "cubia4.com", true },
  { "cubiest.com", true },
  { "cubigames.tk", true },
  { "cubile.xyz", true },
  { "cubing.net", true },
  { "cublick.com", true },
  { "cubos.io", false },
  { "cubsbestteaminbaseball.com", true },
  { "cubua.com", true },
  { "cuchichi.es", true },
  { "cuckoopalace.cn", true },
  { "cuddlecomfort.com", true },
  { "cuddlingyaks.com", true },
  { "cudoo.de", true },
  { "cueca.com.br", true },
  { "cuecasonline.com.br", true },
  { "cuegee.com", true },
  { "cuentamecomopaso.es", true },
  { "cuentasmutualamr.org.ar", true },
  { "cuetoems.com", true },
  { "cuibonobo.com", true },
  { "cuio.net", true },
  { "cuir-lipari.fr", true },
  { "culan.dk", true },
  { "cultiv.nl", true },
  { "cultofd50.org", true },
  { "cultofperf.org.uk", true },
  { "cultura10.com", true },
  { "culturabrasilia.tk", true },
  { "culturalparadiso.tk", true },
  { "culturedcode.com", true },
  { "cultureshift.co", true },
  { "culturesouthwest.org.uk", true },
  { "culturess.com", true },
  { "cumagini.com", true },
  { "cumberlandrivertales.com", true },
  { "cuminas.com", true },
  { "cuminas.jp", true },
  { "cumnock.name", true },
  { "cumnock.org", true },
  { "cumplegenial.com", true },
  { "cumseface.eu", true },
  { "cumshots-video.ru", true },
  { "cuoc.org.uk", true },
  { "cup.al", true },
  { "cupclub.com", true },
  { "cupoane-reducere.net", true },
  { "cupom.net", true },
  { "cur.by", true },
  { "curacao-firma.com", true },
  { "curacaodiveguide.com", true },
  { "curamail.co.uk", true },
  { "curbside.com", true },
  { "cureatr.com", true },
  { "curieux.digital", false },
  { "curio-shiki.com", true },
  { "curiosity-driven.org", true },
  { "curlify.com", true },
  { "curlybracket.co.uk", true },
  { "currency-strength.com", true },
  { "current-usa.com", true },
  { "currentlystreaming.com", true },
  { "currentlyusa.com", true },
  { "currynissanmaparts.com", true },
  { "cursos-trabajadores.net", true },
  { "cursos.com", true },
  { "cursosdeinglesmexico.com", true },
  { "cursosforex.com", true },
  { "cursosgratuitos.pe", true },
  { "cursosingles.com", true },
  { "cursossena.co", true },
  { "cursosypostgrados.com", true },
  { "cursuri-de-actorie.ro", true },
  { "curtacircuitos.com.br", false },
  { "curtis-smith.me.uk", true },
  { "curtis-smith.uk", true },
  { "curtislinville.net", true },
  { "curtissmith.me.uk", true },
  { "curtissmith.uk", true },
  { "curveprotect.com", true },
  { "curveprotect.cz", true },
  { "curveprotect.net", true },
  { "curveprotect.org", true },
  { "curvissa.co.uk", true },
  { "custamped.com", true },
  { "custer.tk", true },
  { "custodian.nl", true },
  { "custodyxchange.com", true },
  { "customdissertation.com", true },
  { "customessaystation.gq", true },
  { "customfitbymj.net", true },
  { "customizeyoursink.com", true },
  { "custompapers.com", true },
  { "customradio.tk", true },
  { "customsportsocks.com", true },
  { "customwebsitesplus.com", true },
  { "customwritings.com", true },
  { "customwritingservice.com", true },
  { "customwritten.com", true },
  { "cuteselfie.com", true },
  { "cutlinks.ml", true },
  { "cutmylink.gq", true },
  { "cutner.co", true },
  { "cuvva.co", true },
  { "cuvva.co.uk", true },
  { "cuvva.com", true },
  { "cuvva.eu", true },
  { "cuvva.io", true },
  { "cuvva.it", true },
  { "cuvva.me", true },
  { "cuvva.net", true },
  { "cuvva.org", true },
  { "cuvva.uk", true },
  { "cuvva.us", true },
  { "cuxpool.net", true },
  { "cvazquez.es", true },
  { "cvc.digital", true },
  { "cvchomes.com", true },
  { "cvcoders.com", true },
  { "cvdc.xyz", true },
  { "cve-le-carrousel.ch", false },
  { "cviip.ca", true },
  { "cviip.com", true },
  { "cvl.ch", false },
  { "cvlibrary.co.uk", true },
  { "cvmu.jp", true },
  { "cvo-group.com", true },
  { "cvr.dk", true },
  { "cvtemplatemaster.com", true },
  { "cvtshop.com.br", true },
  { "cvutdecin.cz", true },
  { "cvv.cn", true },
  { "cw.center", true },
  { "cwaclub.tk", true },
  { "cwagner.me", true },
  { "cwbrtrust.ca", true },
  { "cwc.gov", true },
  { "cwgaming.co.uk", true },
  { "cwmart.in", true },
  { "cwrau.com", true },
  { "cwrau.de", true },
  { "cwrau.info", true },
  { "cwrau.io", true },
  { "cwrau.me", true },
  { "cwrau.name", true },
  { "cwrau.rocks", true },
  { "cwrau.tech", true },
  { "cwrcoding.com", true },
  { "cwwise.com", true },
  { "cx100.io", true },
  { "cxadd.com", true },
  { "cyanghost.com", true },
  { "cyanhexagon.com", true },
  { "cyber-core.co.uk", true },
  { "cyber-travel.com", true },
  { "cyber-yaroslavl.tk", true },
  { "cyber.je", true },
  { "cyberatlantis.com", true },
  { "cybercareers.gov", true },
  { "cybercat-tver.tk", true },
  { "cybercrew.cc", true },
  { "cybercrime-forschung.de", true },
  { "cybercrime.gov", true },
  { "cybercustodian.com", true },
  { "cyberdean.fr", true },
  { "cyberdiscoverycommunity.uk", true },
  { "cyberduck.io", true },
  { "cyberdyne.ie", true },
  { "cyberdyne.llc", true },
  { "cyberfamily.network", true },
  { "cyberforensics.com", true },
  { "cyberfrancais.ro", true },
  { "cybergame-host.tk", true },
  { "cybergroup.cf", true },
  { "cybergrx.com", true },
  { "cyberguerrilla.info", true },
  { "cyberguerrilla.org", true },
  { "cyberhipsters.nl", true },
  { "cyberianhusky.com", false },
  { "cyberium-planet.cf", true },
  { "cyberlab.team", false },
  { "cyberlegal.co", true },
  { "cybermaniac.tk", true },
  { "cyberme.sh", true },
  { "cybermotives.com", true },
  { "cybernetivdigital.com", true },
  { "cyberogism.com", true },
  { "cyberonesol.com", true },
  { "cyberoptic.de", true },
  { "cyberpathogen.me", true },
  { "cyberpcforum.com", true },
  { "cyberphaze.com", true },
  { "cyberphoenix.tk", true },
  { "cyberpubonline.com", true },
  { "cybersafesolutions.com", true },
  { "cyberscan.io", true },
  { "cybersecurity.gr", true },
  { "cybersecurity.run", true },
  { "cybersecuritychallenge.be", false },
  { "cybersecurityketen.nl", true },
  { "cyberseguranca.com.br", true },
  { "cybersins.com", true },
  { "cybersmart.co.uk", true },
  { "cybersmartdefence.com", true },
  { "cybersound.tk", true },
  { "cyberspect.com", true },
  { "cyberspect.io", true },
  { "cyberstatus.de", true },
  { "cybertrash.xyz", true },
  { "cybertu.be", true },
  { "cyberwars.dk", true },
  { "cyberwire.nl", true },
  { "cybozu.cn", true },
  { "cybozu.com", true },
  { "cyclebeads.com", true },
  { "cycledownunder.com", true },
  { "cycleluxembourg.lu", true },
  { "cyclinggoodso.com", true },
  { "cyclonebikes.com.ua", true },
  { "cyclop-editorial.fr", true },
  { "cydetec.com", true },
  { "cyfly.org", true },
  { "cygnan.com", true },
  { "cygnatus.com", true },
  { "cygnius.net", true },
  { "cykelbanor.se", true },
  { "cyl6.com", true },
  { "cylindehea.com", true },
  { "cylindricity.com", true },
  { "cyllos.me", true },
  { "cynicaloptimist.me", true },
  { "cyon.ch", true },
  { "cyph.audio", true },
  { "cyph.com", true },
  { "cyph.healthcare", true },
  { "cyph.im", true },
  { "cyph.io", true },
  { "cyph.me", true },
  { "cyph.video", true },
  { "cyph.ws", true },
  { "cyphar.com", true },
  { "cypherpunk.at", true },
  { "cypherpunk.observer", true },
  { "cypressinheritancesaga.com", true },
  { "cyprus-company-service.com", true },
  { "cysec.biz", true },
  { "cysmo.de", true },
  { "cytat.tk", true },
  { "cytech.com.tr", true },
  { "cythereaxxx.com", true },
  { "cyumus.com", true },
  { "cz.ma", true },
  { "czakey.net", true },
  { "czaw.org", true },
  { "czbix.com", true },
  { "czbtm.com", true },
  { "czc.cz", true },
  { "czech.is", true },
  { "czechvirus.cz", true },
  { "czerno.com", true },
  { "czk.mk", true },
  { "czprothz.tk", true },
  { "czwartybrat.pl", true },
  { "d-20.fr", true },
  { "d-consultant.ru", true },
  { "d-designerin.de", true },
  { "d-eisenbahn.com", true },
  { "d-macindustries.com", true },
  { "d-parts.de", true },
  { "d-parts24.de", true },
  { "d-toys.com.ua", true },
  { "d-training.de", true },
  { "d-vision-web.com", true },
  { "d.nf", true },
  { "d.nr", true },
  { "d00228.com", false },
  { "d00d.de", true },
  { "d0g.cc", true },
  { "d0m41n.name", true },
  { "d0xq.com", true },
  { "d2.gg", true },
  { "d2ph.com", true },
  { "d36533.com", true },
  { "d3a.xyz", true },
  { "d3dev.cf", true },
  { "d3lab.net", true },
  { "d3xt3r01.tk", true },
  { "d3xx3r.de", true },
  { "d42.no", true },
  { "d4b.in.ua", true },
  { "d4done.com", true },
  { "d4fx.de", true },
  { "d4x.de", true },
  { "d66.ag", true },
  { "d66.nl", true },
  { "d6c5yfulmsbv6.cloudfront.net", true },
  { "d7211.com", true },
  { "d7215.com", true },
  { "d7216.com", true },
  { "d8.ag", true },
  { "d8.io", true },
  { "d8118.com", true },
  { "d81818.com", true },
  { "d8228.com", true },
  { "d8778.com", true },
  { "d8787.net", true },
  { "d88.ag", true },
  { "d88.cc", false },
  { "d88.cn.com", true },
  { "d881.net", true },
  { "d8811.net", true },
  { "d88111.com", true },
  { "d8812.com", true },
  { "d8813.com", true },
  { "d8814.com", true },
  { "d8816.net", true },
  { "d8817.com", true },
  { "d8819.com", true },
  { "d8824.com", true },
  { "d88322.com", true },
  { "d88333.com", true },
  { "d8834.com", true },
  { "d8841.com", true },
  { "d8842.com", true },
  { "d8843.com", true },
  { "d8845.com", true },
  { "d8847.com", true },
  { "d8850.net", true },
  { "d88522.com", true },
  { "d8853.com", true },
  { "d8854.com", true },
  { "d8859.com", true },
  { "d886.net", true },
  { "d8860.net", true },
  { "d8861.com", true },
  { "d8864.com", true },
  { "d88688.com", true },
  { "d8870.net", true },
  { "d8872.net", true },
  { "d8874.com", true },
  { "d8878.com", true },
  { "d888.ag", true },
  { "d888.co", true },
  { "d888.me", true },
  { "d88818.com", true },
  { "d88870.com", true },
  { "d88877.com", true },
  { "d88882.com", true },
  { "d88886.com", true },
  { "d8890.net", true },
  { "d8897.com", true },
  { "d8898.com", true },
  { "d88988.com", true },
  { "d88998.com", true },
  { "d88agent.com", true },
  { "d88dc05.com", true },
  { "d88girls.com", true },
  { "d88md03.com", true },
  { "d88md24.com", true },
  { "d88md29.com", true },
  { "d8998.com", true },
  { "d9c.eu", true },
  { "daallexx.eu", true },
  { "dabai.club", true },
  { "dabai.photo", true },
  { "dabasstacija.lv", true },
  { "dabuttonfactory.com", true },
  { "daceurope.co.uk", true },
  { "dachb0den.net", true },
  { "dachbleche24-shop.de", true },
  { "dachdecker-ranzenberger.de", true },
  { "dachdeckermeister-egon-weiss.de", true },
  { "dachtechnik-windschuettl.de", true },
  { "daciaforum.nl", true },
  { "daciamodellen.nl", true },
  { "dadadani.xyz", true },
  { "dadafterforty.be", true },
  { "daddybio.com", true },
  { "daddyfinger.me", true },
  { "dado.fr", true },
  { "dado.me", true },
  { "dado.virtual.museum", true },
  { "dadosch.de", true },
  { "dadrian.io", true },
  { "daduke.org", true },
  { "daemen.org", true },
  { "daemon-hentai.tk", true },
  { "daemonslayer.net", true },
  { "daemwool.ch", true },
  { "daevel.com", true },
  { "daevel.fr", true },
  { "daevel.net", true },
  { "dafe2021.ee", true },
  { "dafont.com", true },
  { "dafricapress.com", true },
  { "dafyddcrosby.com", true },
  { "dag-hebergement.fr", true },
  { "dag-konsult.com", true },
  { "dagensannonser.se", true },
  { "dagmarhamalova.cz", true },
  { "dagrs.se", true },
  { "dahlberg.cologne", true },
  { "dahobo.tk", true },
  { "dai.top", true },
  { "dai94.com", true },
  { "daidr.me", true },
  { "daie-inc.com", true },
  { "daigakujuken-plus.com", true },
  { "daikoz.com", true },
  { "dailybits.be", true },
  { "dailyblogged.com", true },
  { "dailychristianpodcast.com", true },
  { "dailyemailinboxing.com", true },
  { "dailyenglishchallenge.com", true },
  { "dailyhealthguard.com", true },
  { "dailykos.com", true },
  { "dailynewsclubs.ga", true },
  { "dailypop.ru", true },
  { "dailyrenewblog.com", true },
  { "dailyrover.com", true },
  { "dailyroverr.com", true },
  { "dailyxenang.com", true },
  { "daimafengzi.com", true },
  { "dairyshrine.org", true },
  { "daisakuikeda.org", true },
  { "daisidaniels.co.uk", true },
  { "daisy-peanut.com", true },
  { "daisypeanut.com", true },
  { "daitouryu-jujutsu.com", true },
  { "dajiadu.net", true },
  { "dajiadu8.com", true },
  { "dajiale.org", true },
  { "dak.org", true },
  { "dakin.nyc", true },
  { "dakindesign.com", true },
  { "dakinnyc.com", true },
  { "daknob.net", true },
  { "dakota-spain.tk", true },
  { "dakotasjoint.com", true },
  { "daktarisys.com", true },
  { "dal.net.sa", true },
  { "daladubbeln.se", true },
  { "dalaran.city", true },
  { "dalb.in", true },
  { "dalcomseo.com", true },
  { "dale-west.com", true },
  { "dalfsennet.nl", true },
  { "dalianbbq.com", true },
  { "dalingk.com", true },
  { "dallaslu.com", true },
  { "dallasmenshealth.com", true },
  { "dallinbryce.com", true },
  { "dallmeier.net", true },
  { "dalmatiersheusden.be", true },
  { "damaged.org", true },
  { "damasexpress.com", true },
  { "damedrogy.cz", true },
  { "damejidlo.cz", true },
  { "dameocio.com", true },
  { "damghaem.ir", true },
  { "damianus.hr", true },
  { "damianuv-blog.cz", true },
  { "damicris.ro", true },
  { "damienoreilly.org", true },
  { "daminiphysio.ca", true },
  { "damip.net", true },
  { "damirsystems.com", true },
  { "damjanovic.it", true },
  { "dammekens.be", true },
  { "damngoodpepper.com", false },
  { "damonline.dk", true },
  { "dampedia.com", true },
  { "dan-bureau.com", true },
  { "dan-bureau.dk", true },
  { "dan.me.uk", true },
  { "danads.com", true },
  { "danajamin.com", true },
  { "danalytics.com.pe", true },
  { "danamica.dk", true },
  { "danandrum.com", true },
  { "danarozmarin.com", true },
  { "danbaldwinart.com", true },
  { "danbergen.com", true },
  { "danburycampervans.co.uk", true },
  { "dance-colleges.com", true },
  { "danceylove.net", true },
  { "danchen.org", true },
  { "dancingcubs.co.uk", true },
  { "dandan101.com", true },
  { "dandenongroadapartments.com.au", true },
  { "dandia.ro", true },
  { "danel.ski", true },
  { "danelska.pl", true },
  { "danelski.pl", true },
  { "danfromit.co.uk", true },
  { "danfromit.com", true },
  { "dangr.zone", true },
  { "danhalliday.com", true },
  { "danholloway.online", true },
  { "daniel-baumann.ch", true },
  { "daniel-cholewa.de", true },
  { "daniel-kulbe.de", true },
  { "daniel-leblanc.tk", true },
  { "daniel-milnes.co.uk", true },
  { "daniel-milnes.uk", true },
  { "daniel-ruf.de", true },
  { "daniel-wildhaber.ch", true },
  { "danielas.boutique", true },
  { "daniele.tech", true },
  { "danielehniss.de", true },
  { "danielepestilli.com", true },
  { "danielgorr.de", true },
  { "danielgray.email", true },
  { "danielgray.me", true },
  { "danielguttfreundphd.net", true },
  { "danielhinterlechner.eu", true },
  { "danielhochleitner.de", true },
  { "danieliancu.com", true },
  { "danieljamesscott.org", true },
  { "danieljball.co.uk", true },
  { "danieljstevens.com", true },
  { "danielkanchev.com", true },
  { "danielkeppler.com", true },
  { "danielkoster.nl", true },
  { "danielluisrodriguezs.com", true },
  { "danielmartin.de", true },
  { "danielmiessler.com", true },
  { "danielmoch.com", true },
  { "danielmorell.com", true },
  { "danieln.tech", true },
  { "danielnaaman.com", true },
  { "danielparker.com.au", true },
  { "danielpenno.com", true },
  { "danielpeukert.cz", true },
  { "danielran.com", true },
  { "danielrozenberg.com", true },
  { "danielsblog.org", true },
  { "danielsfirm.com", true },
  { "danielstach.cz", true },
  { "danielsteiner.net", true },
  { "danielstiner.me", true },
  { "danielthompson.info", true },
  { "danieltollot.de", true },
  { "danielvanassen.nl", true },
  { "danielvoogsgerd.nl", true },
  { "danielwildhaber.ch", true },
  { "danifabi.eu", true },
  { "daniilgeorge.com", true },
  { "danilapisarev.com", true },
  { "danjesensky.com", true },
  { "dank.ninja", true },
  { "dankim.de", false },
  { "danla.nl", true },
  { "danmaby.com", true },
  { "danmarksbedstefredagsbar.dk", true },
  { "danmarksflyttemand.dk", true },
  { "danmassarano.com", true },
  { "danminkevitch.com", false },
  { "danna-salary.com", true },
  { "danndorf.com", true },
  { "dannhanks.com", true },
  { "dannicholas.net", true },
  { "danny-tittel.de", true },
  { "dannycairns.com", true },
  { "dannygaidateraelgar.com", true },
  { "dannyjota.tk", true },
  { "dannyrohde.de", false },
  { "dannystevens.co.uk", true },
  { "danotage.tv", true },
  { "danpiel.net", true },
  { "dansage.co", true },
  { "dansaunders.me", true },
  { "dansdiscounttools.com", true },
  { "dansedesalonsaintave.fr", true },
  { "danselibre.net", true },
  { "danselibre.org", true },
  { "danseressen.nl", true },
  { "danskefilm.dk", true },
  { "danskoferie.dk", true },
  { "danskoya.com", true },
  { "danslan.org", true },
  { "danstillman.com", true },
  { "dantransports.fr", true },
  { "danw.io", true },
  { "danwin1210.me", true },
  { "danwolff.se", true },
  { "danyabanya.com", true },
  { "danzac.com", true },
  { "danzka.tk", true },
  { "dao.spb.su", true },
  { "daop.co.uk", true },
  { "daoro.net", false },
  { "daphne.informatik.uni-freiburg.de", true },
  { "dapoxetinagenerico.cf", true },
  { "dapperdom.net", true },
  { "daracokorilo.com", true },
  { "darani.ch", true },
  { "daravk.ch", true },
  { "darbi.org", true },
  { "darc-mak.de", false },
  { "darchoods.net", false },
  { "darcymarshall.com", true },
  { "dare.deals", true },
  { "dareyou.be", true },
  { "darf.nl", true },
  { "dariaburger.de", true },
  { "darinkotter.com", true },
  { "darioackermann.ch", false },
  { "darioclip.com", true },
  { "darioturchetti.me", true },
  { "dark-crystal.tk", true },
  { "dark-infection.de", true },
  { "dark-nova.me", true },
  { "dark-nova.tk", true },
  { "dark-vision.cz", true },
  { "dark.fail", true },
  { "dark.ninja", true },
  { "darkcores.net", true },
  { "darkengine.io", true },
  { "darkengine.net", true },
  { "darkeststar.org", true },
  { "darkfire.ch", true },
  { "darklang.com", true },
  { "darklaunch.com", true },
  { "darknessflickers.com", false },
  { "darknetlive.com", true },
  { "darknight.blog", true },
  { "darkrisks.com", true },
  { "darkserver.fedoraproject.org", true },
  { "darkserver.stg.fedoraproject.org", true },
  { "darkshop.nl", true },
  { "darkskymap.com", true },
  { "darkspacelab.com", true },
  { "darktime.ru", true },
  { "darkwater.info", true },
  { "darkx.me", true },
  { "darlenejacques.com", true },
  { "darmgesundheit.ch", true },
  { "darom.jp", true },
  { "darshnam.com", true },
  { "dartcode.org", true },
  { "dartetdemetiers.fr", true },
  { "darth-sonic.de", true },
  { "darwinkel.net", true },
  { "darwinsearch.org", true },
  { "daryl.moe", true },
  { "darylcrouse.com", true },
  { "darylcumbo.net", true },
  { "das-forum24.de", true },
  { "das-mediale-haus.de", true },
  { "das-sommercamp.de", true },
  { "dasgeestig.nl", true },
  { "dashdrive.net", true },
  { "dashlane.com", true },
  { "dashnearby.com", true },
  { "dasignsource.com", true },
  { "dasinternetluegt.at", true },
  { "dassolutions.eu", true },
  { "dasteichwerk.at", true },
  { "dasug.de", true },
  { "dat4u.de", true },
  { "data-captive.com", true },
  { "data-detox.de", true },
  { "data-jt.de", true },
  { "data-wing.ga", false },
  { "data.bayern", true },
  { "data.gov", true },
  { "data.govt.nz", true },
  { "data.haus", true },
  { "data.world", true },
  { "data3w.nl", true },
  { "databasez.net", true },
  { "databionix.com", true },
  { "databutlr.com", true },
  { "databutlr.net", true },
  { "datacalle.com", true },
  { "datacaptive.com", true },
  { "datacommissioner.gov.au", true },
  { "datadit.hu", true },
  { "datadyne.technology", true },
  { "dataformers.at", true },
  { "datagrail.io", true },
  { "dataharvest.at", true },
  { "datahive360.com", true },
  { "datahjalp.nu", true },
  { "datajobs.ai", true },
  { "datakick.org", true },
  { "datalife.gr", true },
  { "datalysis.ch", false },
  { "dataman.ml", true },
  { "dataprivacysolution.com", true },
  { "datapun.ch", true },
  { "dataregister.info", true },
  { "datart.fr", true },
  { "datasafeassurance.co.uk", true },
  { "datascience.cafe", true },
  { "datascience.ch", false },
  { "dataskydd.net", false },
  { "dataspace.pl", true },
  { "datasupport-stockholm.se", true },
  { "datasupport.one", true },
  { "dataswamp.org", true },
  { "datatekniikka.fi", false },
  { "datatekniker.nu", true },
  { "datateknologsektionen.se", false },
  { "datatree.nl", true },
  { "datatruckers.com", true },
  { "datatruckers.email", true },
  { "datatruckers.eu", true },
  { "datatruckers.net", true },
  { "datatruckers.nl", true },
  { "datatruckers.org", true },
  { "datatypes.net", true },
  { "datax-cloud.de", true },
  { "datecougarslocal.com", true },
  { "datelah.com", true },
  { "datememe.com", true },
  { "datenendlager.org", true },
  { "datengrab.xyz", true },
  { "datenkeks.de", true },
  { "dateno1.com", true },
  { "datenreiter.org", true },
  { "datenschutz-consult.de", true },
  { "datenschutz-individuell.de", true },
  { "datenschutzgrundverordnung.de", true },
  { "datenschutztag.org", true },
  { "datenschutzzentrum.de", true },
  { "datenwerkstatt.net", true },
  { "datewon.net", true },
  { "dating.wedding", true },
  { "datingsite-vergelijken.website", true },
  { "datingsrit.tk", true },
  { "datingticino.ch", false },
  { "datisstom.nl", true },
  { "datmancrm.com", true },
  { "dator-test.se", true },
  { "datorhjalp-stockholm.se", true },
  { "datorhjalptaby.se", true },
  { "datorservice-stockholm.se", true },
  { "datumou-osusume.com", true },
  { "datumou-recipe.com", true },
  { "datumstudio.jp", true },
  { "daubecity.de", true },
  { "daubehosting.de", true },
  { "daunatotala.ro", true },
  { "dave-pearce.com", true },
  { "daveaglick.com", true },
  { "davecardwell.com", true },
  { "davelynes.com", true },
  { "daveoc64.co.uk", true },
  { "daveops.net", true },
  { "davepage.me.uk", true },
  { "davepearce.com", true },
  { "davescomputertips.com", true },
  { "davesinclair.com.au", true },
  { "davetempleton.com", true },
  { "davethom.net", true },
  { "davevelopment.net", true },
  { "davewardle.com", true },
  { "davewood.com.au", true },
  { "david-corry.com", true },
  { "david-hinschberger.me", true },
  { "david-jeffery.co.uk", true },
  { "david-merkel.de", true },
  { "david-pearce.com", true },
  { "david-reess.de", true },
  { "david-schiffmann.de", true },
  { "david.kitchen", true },
  { "davidadrian.org", true },
  { "davidandersson.se", true },
  { "davidandrewcoaching.com", true },
  { "davidbranco.me", true },
  { "davidbrookes.me", true },
  { "davidbuckell.com", true },
  { "daviddever.net", true },
  { "davidfetveit.com", true },
  { "davidfrancoeur.com", true },
  { "davidgouveia.net", true },
  { "davidgow.net", true },
  { "davidgreig.uk", true },
  { "davidgroup.co.id", true },
  { "davidgrudl.com", true },
  { "davidhanle.com", true },
  { "davidje13.com", true },
  { "davidkeane.com", true },
  { "davidkennardphotography.com", true },
  { "davidking.xyz", true },
  { "davidlamprea.com", true },
  { "davidlane.io", true },
  { "davidlyness.com", true },
  { "davidmcevoy.org.uk", true },
  { "davidmessenger.co.uk", true },
  { "davidmn.org", true },
  { "davidops.com", true },
  { "davidpearce.com", true },
  { "davidpearce.org", true },
  { "davidpescarolo.it", true },
  { "davidschadlich.com", true },
  { "davidschlachter.com", true },
  { "davidschubert.com", true },
  { "davidsimner.me.uk", true },
  { "davidsopas.com", true },
  { "davidtiffany.com", true },
  { "davidundetiwan.com", true },
  { "davidzeegers.nl", true },
  { "davie3.com", true },
  { "davisdieselandautorepair.com", true },
  { "davisroi.com", true },
  { "davo-usedcars.be", false },
  { "davy-server.com", true },
  { "davypropper.com", true },
  { "daw.nz", true },
  { "dawgs.ga", true },
  { "dawnbringer.eu", true },
  { "dawnbringer.net", true },
  { "dawnofeden.net", true },
  { "dawnson.is", true },
  { "dawoud.org", true },
  { "dawson-floridavilla.co.uk", true },
  { "dax.guide", true },
  { "daxpatterns.com", true },
  { "daycontactlens.com", true },
  { "daylightpirates.org", true },
  { "daymprove.life", true },
  { "dayofdays.be", true },
  { "dayofthegirl.gc.ca", true },
  { "days.one", true },
  { "daysinnaustin.com", true },
  { "daysoftheyear.com", true },
  { "dayswithnostabbings.ca", true },
  { "dayuse-hotels.it", true },
  { "dayuse.co.uk", true },
  { "dayuse.com", true },
  { "dayuse.cz", true },
  { "dayuse.es", true },
  { "dayuse.fr", true },
  { "dayuse.pt", true },
  { "dayuse.se", true },
  { "daywalkers-photography.de", true },
  { "dazz.it", true },
  { "dazzit.ca", true },
  { "dazzit.com", true },
  { "dazzit.io", true },
  { "dazzit.net", true },
  { "dazzit.org", true },
  { "dazzit.xyz", true },
  { "db-works.nl", true },
  { "db.ci", true },
  { "dbapress.org", true },
  { "dbaron.org", true },
  { "dbas.cz", true },
  { "dbb.wtf", true },
  { "dbentertainment.co.uk", true },
  { "dbgamestudio.com", true },
  { "dblcastles.co.uk", true },
  { "dbldub.net", true },
  { "dbmiller.org", true },
  { "dbmteam.com", true },
  { "dborcard.com", false },
  { "dbpkg.com", true },
  { "dbplanview.com", true },
  { "dbq.com", true },
  { "dbrand.com", true },
  { "dbrgn.ch", true },
  { "dbtsai.com", false },
  { "dc-acupuncture.com", true },
  { "dc-elektro.com", true },
  { "dc-elektro.de", true },
  { "dc-elektro.eu", true },
  { "dc-occasies.be", false },
  { "dc-solution.de", false },
  { "dc1.com.br", true },
  { "dc562.org", true },
  { "dc585.info", true },
  { "dcain.me", true },
  { "dcards.in.th", true },
  { "dcave.net", true },
  { "dcbouncycastles.co.uk", true },
  { "dcc.moe", true },
  { "dccwiki.com", true },
  { "dcdestetica.it", true },
  { "dcepler.net", true },
  { "dchatelain.ch", false },
  { "dchest.org", true },
  { "dckd.nl", true },
  { "dclaisse.fr", true },
  { "dcmapping.net", true },
  { "dcmarvelunited.com", true },
  { "dcmediahosting.com", true },
  { "dcmt.co", true },
  { "dcpower.eu", true },
  { "dcrdev.com", true },
  { "dcw.io", true },
  { "dcyph.de", true },
  { "dd.art.pl", true },
  { "dd00228.com", false },
  { "dd118d.com", true },
  { "dd11d.net", true },
  { "dd202d.com", true },
  { "dd207d.com", true },
  { "dd209d.com", true },
  { "dd211d.com", true },
  { "dd215d.com", true },
  { "dd33d.net", true },
  { "dd44d.net", true },
  { "dd7211.com", true },
  { "ddatsh.com", true },
  { "ddays2008.org", true },
  { "dddmelbourne.com", true },
  { "ddel.de", true },
  { "dden.ca", true },
  { "ddepot.us", true },
  { "ddhosted.com", true },
  { "ddns-test.de", true },
  { "ddnsweb.com", false },
  { "ddoser.cn", false },
  { "ddosguard.cf", true },
  { "ddosolitary.org", true },
  { "ddracepro.net", true },
  { "dds.mil", true },
  { "ddsmatchsouthwest.com", true },
  { "de-gucci.com", true },
  { "de-kramers.nl", true },
  { "de-mail.info", true },
  { "de-medici.nl", true },
  { "de-mossadeq.tk", true },
  { "de-rwa.de", true },
  { "de.search.yahoo.com", false },
  { "de8468.com", true },
  { "dead-letter.email", true },
  { "deadbeef.ninja", true },
  { "deadc0de.re", true },
  { "deadmorose.ru", true },
  { "deadpulse.com", true },
  { "deadroot.tk", true },
  { "deaf.dating", true },
  { "deaf.eu.org", true },
  { "deal-runners.cf", true },
  { "deal30.fr", true },
  { "dealapp.nl", true },
  { "dealbanana.at", true },
  { "dealbanana.be", true },
  { "dealbanana.ch", true },
  { "dealbanana.co.uk", true },
  { "dealbanana.com", true },
  { "dealbanana.de", true },
  { "dealbanana.fi", true },
  { "dealbanana.fr", true },
  { "dealbanana.it", true },
  { "dealbanana.se", true },
  { "dealbx.com", true },
  { "dealcruiser.nl", true },
  { "dealdump.nl", true },
  { "dealerselectric.com", true },
  { "dealinflatables.co.uk", true },
  { "dealosa.com", true },
  { "dealspotr.com", true },
  { "dealszone.net", true },
  { "deamuseum.org", true },
  { "deanandnatalia.co.za", true },
  { "deanbank.com", true },
  { "deanjerkovich.com", true },
  { "deanmorgan.org", true },
  { "deano-s.co.uk", true },
  { "deanosplace.net", true },
  { "deanpearce.net", true },
  { "deantiguos.es", true },
  { "dearfcc.com", true },
  { "dearfcc.net", true },
  { "dearfcc.org", true },
  { "dearktiel.nl", true },
  { "dearnevalleybouncycastles.co.uk", true },
  { "dearstackexchange.com", true },
  { "death.social", true },
  { "deathofspring.com", false },
  { "deathsdomain.com", true },
  { "deathy.ro", true },
  { "deautomaat.nl", true },
  { "deavel.com", true },
  { "deavel.fr", true },
  { "deavel.net", true },
  { "debarras-diogene.paris", true },
  { "debatereport.com", true },
  { "debbyefurd.com", true },
  { "debie-usedcars.be", false },
  { "debierhandel.nl", true },
  { "debigare.com", true },
  { "debitterballetjes.tk", true },
  { "debron-ot.nl", true },
  { "debrusoft.ch", true },
  { "debtrecycling.com.au", true },
  { "debuemon.com", true },
  { "debuis.nl", true },
  { "dec6.gc.ca", true },
  { "decaffeinated.io", true },
  { "decal-times.com", true },
  { "decalquai.ch", false },
  { "decarrouseloss.nl", true },
  { "dechat.nl", true },
  { "decher.de", true },
  { "dechetor.fr", true },
  { "decidio.cc", true },
  { "decipe.com", true },
  { "decis.fr", true },
  { "decisivetactics.com", true },
  { "deckenplatten.org", true },
  { "deckersheaven.com", true },
  { "declarationlocationmeublee.com", true },
  { "declivitas.com", true },
  { "deco-parisienne.fr", true },
  { "decock-usedcars.be", false },
  { "decode.ga", true },
  { "decofiori.com", true },
  { "decologisticsgh.com", true },
  { "decompiled.de", true },
  { "deconsolas.tk", true },
  { "decoora.com", true },
  { "decor-d.com", true },
  { "decor-live.ru", true },
  { "decor-prazdnik.ru", true },
  { "decorarmicasa.com", true },
  { "decoratingadvice.co.uk", true },
  { "decorativeconcretewa.com.au", true },
  { "decorativeflooring.com", true },
  { "decoratore.roma.it", true },
  { "decoratrix.com", true },
  { "decorauvent.ca", true },
  { "decorestilo.com.br", true },
  { "decorotti.com.tr", true },
  { "decosoftware.com", true },
  { "decrousaz-ceramique.ch", false },
  { "decrypto.net", true },
  { "decs.es", true },
  { "dede.ml", true },
  { "dedelta.net", true },
  { "dedg3.com", true },
  { "dedge.org", true },
  { "dedicatedtowomenobgyn.com", true },
  { "dedmoroz.ga", true },
  { "dedmorozrzn.ru", false },
  { "dedoho.pw", false },
  { "dedoles.at", true },
  { "dedoles.com", true },
  { "dedoles.cz", true },
  { "dedoles.de", true },
  { "dedoles.hu", true },
  { "dedoles.pl", true },
  { "dedoles.ro", true },
  { "dedoles.sk", true },
  { "deduijventil.nl", true },
  { "dee.pe", true },
  { "dee.su", true },
  { "deechtebakkers.nl", true },
  { "deegeeinflatables.co.uk", true },
  { "deelmijnreis.nl", true },
  { "deep-labs.com", true },
  { "deep.club", true },
  { "deepbluecrafting.co.uk", true },
  { "deepcode.io", true },
  { "deephill.com", true },
  { "deepinnov.com", true },
  { "deepinsight.io", true },
  { "deeplink-medical.com", true },
  { "deepnet.cc", true },
  { "deeps.me", true },
  { "deepserve.info", true },
  { "deepspace.dedyn.io", true },
  { "deepspace4.com", true },
  { "deerfieldapartmentsstl.com", true },
  { "deerwoodrvpark.com", true },
  { "def-pos.ru", true },
  { "defantasia.cl", true },
  { "defcon.org", true },
  { "defcongroups.org", true },
  { "defeestboek.nl", true },
  { "defendas.com", true },
  { "defendbearbutte.org", true },
  { "defender-pro.com", true },
  { "defendersz.com", true },
  { "defendinnovation.org", true },
  { "defendtheweb.net", true },
  { "defensivefirearmsinstruction.org", true },
  { "defero.io", true },
  { "defesa.gov.br", true },
  { "deffo.com.au", true },
  { "defiantrust.com", true },
  { "defibrillateur.co", true },
  { "define-atheism.com", true },
  { "define-atheist.com", true },
  { "defineatheism.com", true },
  { "defineatheist.com", true },
  { "definitely.cn", true },
  { "definitions360.com", true },
  { "defis-franciliens.fr", true },
  { "deflect.ca", true },
  { "deflumeri.com", true },
  { "deflumeriker.com", true },
  { "defman.me", true },
  { "defont.nl", true },
  { "defreitas.no", true },
  { "deftek.com", true },
  { "defterikebir.tk", true },
  { "deftig-und-fein.de", true },
  { "deftnerd.com", true },
  { "defunct-engineers.ml", true },
  { "defuse.ca", true },
  { "defxing.net", true },
  { "degata.com", true },
  { "degeeks.xyz", true },
  { "degen-elektrotechnik.de", true },
  { "degestamptepot.nl", true },
  { "degit.de", true },
  { "degoeiewebsite.cf", true },
  { "degoticapunk.xyz", true },
  { "degoulet.net", true },
  { "degracetechnologie.com", true },
  { "degradarium.com", true },
  { "degrasboom.nl", true },
  { "dehopre.com", true },
  { "dehydrated.de", true },
  { "deidee.nl", true },
  { "deimos.gq", true },
  { "dein-baumdienst.de", true },
  { "dein-trueffel.de", true },
  { "deinballon.de", true },
  { "deine-gitarre.com", true },
  { "deinelakaien.tk", true },
  { "deinewebsite.de", true },
  { "deinfoto.ch", true },
  { "deinsparen24.de", true },
  { "deitti.net", true },
  { "dejandayoff.com", true },
  { "dejongonline.eu", true },
  { "dejting-sidor.com", true },
  { "dejure.org", false },
  { "dejw.cz", true },
  { "dekasegi-kansai.com", true },
  { "dekasegi-supportcenter.com", true },
  { "dekasiba.com", true },
  { "dekel.co.il", true },
  { "dekeurslagers.nl", true },
  { "dekko.io", true },
  { "dekonix.ru", true },
  { "dekruifschalkwijk.nl", true },
  { "dekulk.nl", true },
  { "del-ex.de", true },
  { "delahrzolder.nl", true },
  { "delam.site", true },
  { "delbecqvo.be", false },
  { "delegao.moe", true },
  { "deleidscheflesch.nl", true },
  { "delfic.org", true },
  { "delhionlinegifts.com", true },
  { "deliacreates.com", true },
  { "deliandiver.org", true },
  { "deliberatedigital.com", true },
  { "deliciisanatoase.ro", true },
  { "deliciousmedia.co.uk", true },
  { "deliciousmedia.net", true },
  { "delicioustable.com", true },
  { "delid.cz", true },
  { "delio.tk", true },
  { "dellacasapizzasemassas.com.br", true },
  { "dellipaoli.com", true },
  { "delogo.nl", true },
  { "delopt.co.in", true },
  { "delorenzi.dk", true },
  { "deloretta.com", true },
  { "delosgaia.nl", true },
  { "delpark.de", true },
  { "delphia.ai", true },
  { "delphia.com", true },
  { "delphine.dance", true },
  { "delta-data.ch", true },
  { "delta-host.ml", true },
  { "delta-smart.ch", true },
  { "delta.ru", true },
  { "delta23.de", false },
  { "deltaacademy.org", true },
  { "deltadata.ch", true },
  { "deltafinanceiro.com", true },
  { "deltafinanceiro.com.br", true },
  { "deltaloja.com.br", true },
  { "deltanio.nl", true },
  { "deltaonlineguards.com", true },
  { "deltaservers.blog.br", true },
  { "deltaservers.com.br", true },
  { "deltasigmachi.org", true },
  { "deltatutoriais.com.br", true },
  { "deltav.ml", false },
  { "deltava.org", true },
  { "deltawolf.tk", true },
  { "demadryn.com", true },
  { "demarle.ch", false },
  { "demastglazenwasserij.nl", true },
  { "demedx.at", true },
  { "dementiacaring.com.au", true },
  { "dementiapraecox.de", true },
  { "dementieva-pennetta.tk", true },
  { "demeyere-usedcars.be", false },
  { "demfloro.ru", true },
  { "demibaguette.com", true },
  { "demicrofonos.com", true },
  { "demijn.nl", true },
  { "demilletech.net", true },
  { "demiranda.com", true },
  { "demirdokum.tk", true },
  { "demmer.one", true },
  { "demo.swedbank.se", true },
  { "demo9.ovh", true },
  { "democracy-news.tk", true },
  { "democracychronicles.com", true },
  { "democracydirect.com", true },
  { "democracyineurope.eu", true },
  { "democraziaineuropa.eu", true },
  { "demomanca.com", true },
  { "demonbuster.tk", true },
  { "demoniak.ch", true },
  { "demonwav.com", true },
  { "demonwolfdev.com", true },
  { "demopanel.tk", true },
  { "demotivatorbi.ru", true },
  { "dempsters.ca", false },
  { "demuzere.be", true },
  { "denabot.pw", true },
  { "denaehula.com", true },
  { "denali.net", false },
  { "denardbrewing.com", true },
  { "denariu.net", true },
  { "denatured.tk", true },
  { "denbkh.ru", false },
  { "dendelft.nl", true },
  { "denegmnogo.tk", true },
  { "denejki.tk", true },
  { "dengivdom.tk", true },
  { "dengode.eu", true },
  { "denimtoday.com", true },
  { "denince.net", true },
  { "denis-martinez.photos", true },
  { "denisadinu.com", true },
  { "denisewakeman.com", true },
  { "denistruffaut.fr", false },
  { "deniszczuk.pl", true },
  { "deniz.uk", true },
  { "denizdesign.co.uk", true },
  { "denkeandersblog.de", true },
  { "denkmalagentur.ch", true },
  { "denkmalsetzung.at", true },
  { "denkubator.de", true },
  { "dennisang.com", true },
  { "dennisdoes.net", false },
  { "dennisforbes.ca", true },
  { "dennishzg.com", true },
  { "denniskoot.nl", true },
  { "dennismurphy.biz", true },
  { "dennisvandenbos.nl", true },
  { "dennogumi.org", true },
  { "denous.nl", true },
  { "dent.uy", true },
  { "dental-cloud.eu", true },
  { "dental-colleges.com", true },
  { "dentallaborgeraeteservice.de", true },
  { "dentechnica.co.uk", true },
  { "dentistesdarveauetrioux.com", true },
  { "dentistglasgow.com", true },
  { "dentistryateastpiedmont.com", true },
  { "dentrassi.de", true },
  { "dentystabirmingham.co.uk", true },
  { "denvergospelhall.org", true },
  { "denvernews.ml", true },
  { "denwauranailab.com", true },
  { "denydarko.tk", true },
  { "deonlinespecialist.nl", true },
  { "deontology.com", true },
  { "depaco.com", true },
  { "depannage-traceur.fr", true },
  { "deparis.me", true },
  { "departmentofdefense.tk", true },
  { "departmentofoncology.com", true },
  { "depeces.com", true },
  { "depechemode-live.com", true },
  { "depedclub.net", true },
  { "depedsurigaodelnorte.com", true },
  { "depedtalks.com", true },
  { "depedtambayan.net", true },
  { "depedtayo.ph", true },
  { "depelos.co", true },
  { "depelteau.com", true },
  { "dependablehvacrefrigeration.com", true },
  { "depicus.com", true },
  { "depilacioncon.com", true },
  { "depleteduranium.tk", true },
  { "depoker.top", true },
  { "depone.net", true },
  { "depop.com", true },
  { "depositart.com", true },
  { "depositomerci.it", true },
  { "depositomobili.it", true },
  { "depot24.nl", true },
  { "depotsquarekerrville.com", true },
  { "depotter-usedcars.be", false },
  { "deprecate.de", true },
  { "deprobe.pro", true },
  { "depthe.gr", true },
  { "depuratori.milano.it", true },
  { "der-bank-blog.de", true },
  { "der-fliesenzauberer.de", true },
  { "der-gardinenmann.de", true },
  { "der-lan.de", true },
  { "der-rohrstock.club", true },
  { "der-rudi.eu", true },
  { "der-windows-papst.de", true },
  { "derattizzazione.name", true },
  { "derattizzazioni.biz", true },
  { "derattizzazioni.milano.it", true },
  { "derattizzazioni.org", true },
  { "derbuntering.de", true },
  { "derbybouncycastles.com", true },
  { "derbyware.com", true },
  { "derco.com.co", true },
  { "derdewereldrommelmarkt.nl", true },
  { "dereferenced.net", true },
  { "derehamcastles.co.uk", true },
  { "derekbooth.co.uk", true },
  { "derekheld.com", true },
  { "derekkent.com", true },
  { "derekseaman.com", false },
  { "derekseaman.studio", false },
  { "derf.red", true },
  { "derf.us", true },
  { "dergeilstestammderwelt.de", true },
  { "derhil.de", true },
  { "derivedata.com", true },
  { "derkuki.de", true },
  { "dermaldistinction.com", true },
  { "dermapuur.nl", true },
  { "dermato.floripa.br", true },
  { "dermatologie-morges.ch", false },
  { "dermediq.nl", true },
  { "dermopigmentista.it", true },
  { "dermot.org.uk", true },
  { "dermscc.com", true },
  { "dermsf.com", true },
  { "deroo.org", true },
  { "derp.army", true },
  { "derp.chat", true },
  { "derpy.pp.ua", true },
  { "derre.fr", true },
  { "derreichesack.com", true },
  { "derw.pw", true },
  { "des-hommes-et-des-clous.com", true },
  { "desafiomovilidadsustentable.com", true },
  { "desagaz.com", true },
  { "desanta.top", true },
  { "descargar-apk.org", true },
  { "desec.io", true },
  { "desentupidorademais.com.br", true },
  { "desentupidorapernambucana.com.br", true },
  { "desert-maroc.com", true },
  { "desertbloomplasticsurgery.com", true },
  { "desertmedaesthetics.com", true },
  { "desertsounds.org", true },
  { "desheng28.com", true },
  { "deshevle-net.com", true },
  { "deshobi.cloud", true },
  { "design-in-bad.eu", true },
  { "design-tooning.de", true },
  { "designartepublicidad.com", true },
  { "designed-cybersecurity.com", true },
  { "designedcybersecurity.com", true },
  { "designer-drug.com", true },
  { "designera.se", true },
  { "designerchad.com", true },
  { "designgraphic.fr", true },
  { "designhuddle.com", true },
  { "designrhome.com", true },
  { "designs.codes", true },
  { "designsbyjanith.com", true },
  { "designskin.ch", false },
  { "designville.cz", true },
  { "designville.sk", true },
  { "desila.jp", true },
  { "desish.cf", true },
  { "deskaservices.com", true },
  { "deskdesign.nl", true },
  { "deskeen.fr", true },
  { "deskguide.info", true },
  { "desklite.gr", true },
  { "desktopd.eu.org", false },
  { "desktopfx.net", false },
  { "deskture.com", true },
  { "desmaakvanplanten.be", true },
  { "desormiers.com", true },
  { "despachomariscal.com", true },
  { "despertadoronline.com.es", true },
  { "despinavandi.gr", true },
  { "desplats.com.ar", true },
  { "despora.de", true },
  { "dessinemoilademocratie.ch", false },
  { "destakbrasilbrindes.com.br", true },
  { "destech.nl", true },
  { "destileria.net.br", true },
  { "destroymc.net", true },
  { "destyntek.com", true },
  { "desu.ne.jp", true },
  { "desuchan.eu", true },
  { "desuchan.org", true },
  { "desynced.rocks", true },
  { "det-te.ch", true },
  { "detalhecomercio.com.br", true },
  { "detalika.ru", true },
  { "detalyedesigngroup.com", true },
  { "detao.org", true },
  { "detecmon.com", true },
  { "detecte-fuite.ch", false },
  { "detecte.ch", false },
  { "detectefuite.ch", false },
  { "detectify.com", true },
  { "detectivedesk.com.au", true },
  { "deteken.be", true },
  { "detekenmuze.nl", true },
  { "determapp.de", true },
  { "dethemium.com", true },
  { "deti-online.com", true },
  { "detki.cf", true },
  { "detodojuegos.com", true },
  { "detoxetmoi.com", true },
  { "detreannamaria.tk", true },
  { "detroit-english.de", true },
  { "detroitzoo.org", true },
  { "detuinmuze.nl", true },
  { "detyobuv.tk", true },
  { "detype.nl", true },
  { "deu.sh", true },
  { "deuchnord.fr", true },
  { "deude.de", true },
  { "deukie.nl", true },
  { "deumavan.ch", true },
  { "deurenfabriek.nl", true },
  { "deutsch-vietnamesisch-dolmetscher.com", true },
  { "deutsche-seniorenbetreuung.de", true },
  { "deutsche-tageszeitungen.de", true },
  { "deutschebusiness.com", true },
  { "deutscher-bericht.de", true },
  { "deutscher-rollenspielpreis.de", true },
  { "deutscheshoponline.com", true },
  { "deutschland-dsl.de", true },
  { "dev-brandywineglobal.com", true },
  { "dev-greavesindia.pantheonsite.io", true },
  { "dev-gutools.co.uk", true },
  { "dev-pmcc.net", true },
  { "dev-tek.de", true },
  { "dev.moe", true },
  { "devagency.fr", true },
  { "devalps.eu", true },
  { "devcf.com", true },
  { "devcoins.org", true },
  { "devconf.nl", true },
  { "devcore.pl", true },
  { "devdeb.com", true },
  { "devel.cz", true },
  { "develop.cool", true },
  { "develope.cz", true },
  { "developer.android.com", true },
  { "developer.moe", true },
  { "developerdan.com", true },
  { "developermail.io", false },
  { "developers.facebook.com", false },
  { "developfx.com", false },
  { "developmentaid.org", true },
  { "developmentsites.melbourne", true },
  { "develops.co.il", true },
  { "develux.net", true },
  { "deviant.email", true },
  { "devicom.mx", true },
  { "devildog.tk", true },
  { "devillers-occasions.be", false },
  { "devils-co.tk", true },
  { "devils-point.de", true },
  { "devilshakerz.com", true },
  { "deviltraxxx.de", true },
  { "devinfo.net", false },
  { "devinite.com", true },
  { "devirc.net", true },
  { "devklog.net", true },
  { "devlamvzw.org", false },
  { "devlatron.net", true },
  { "devlinjurister.se", true },
  { "devlogr.com", true },
  { "devmode.fm", true },
  { "devnull.zone", true },
  { "devolution.ws", true },
  { "devops-survey.com", true },
  { "devops.pf", true },
  { "devopsish.com", true },
  { "devpp.com.br", true },
  { "devragu.com", true },
  { "devrandom.net", true },
  { "devries.one", true },
  { "devsjournal.com", true },
  { "devstaff.gr", true },
  { "devstores.io", false },
  { "devswag.io", true },
  { "devtea.cz", true },
  { "devtoys.ru", true },
  { "devtty.org", true },
  { "devun.limited", true },
  { "devzero.io", true },
  { "dewaard.de", true },
  { "dewalch.net", true },
  { "dewapress.com", true },
  { "dewinter.com", true },
  { "dewitteprins.nl", true },
  { "dewolden.nl", false },
  { "dex.top", true },
  { "dexalo.de", true },
  { "dexigner.com", true },
  { "dexonrest.azurewebsites.net", true },
  { "dexonservicedeskws.azurewebsites.net", true },
  { "deyute.com", true },
  { "dez-online.de", true },
  { "dezeregio.nl", true },
  { "dezet-ev.de", true },
  { "dezmembrariromania.ro", true },
  { "dezzoroofing.co.za", true },
  { "df1paw.de", true },
  { "df3312.com", true },
  { "df3313.com", true },
  { "df3314.com", true },
  { "df3315.com", true },
  { "df3316.com", true },
  { "df3317.com", true },
  { "df3318.com", true },
  { "df3319.com", true },
  { "df63.cc", true },
  { "dfafacts.gov", true },
  { "dfctaiwan.org", true },
  { "dfektlan.no", true },
  { "dfl.mn", false },
  { "dflcares.com", true },
  { "dfmn.berlin", true },
  { "dfranke.com", true },
  { "dg68.cc", true },
  { "dgangsta.net", true },
  { "dgbouncycastlehire.com", true },
  { "dgeex.eu", true },
  { "dgitup.com", true },
  { "dgportals.co.uk", true },
  { "dgpot.com", true },
  { "dgt-portal.de", true },
  { "dgtakano.co.jp", true },
  { "dgx.io", true },
  { "dhakawebhost.com", true },
  { "dharveydev.com", true },
  { "dhautefeuille.eu", true },
  { "dhauwer.nl", true },
  { "dhaynes.xyz", true },
  { "dhconcept.ch", false },
  { "dhde.de", true },
  { "dheart.net", true },
  { "dhedegaard.dk", true },
  { "dhelixnet.de", true },
  { "dhemant.de", true },
  { "dhhs.gov", true },
  { "dhinflatables.co.uk", true },
  { "dhirendrayadav.com", true },
  { "dhit.pl", true },
  { "dhlinux.org", true },
  { "dhome.at", true },
  { "dia-de.com", true },
  { "dia.com.br", true },
  { "diabetessucks.net", true },
  { "diabhal-staff.com", true },
  { "diabhal-staff.it", true },
  { "diablovalleytech.com", true },
  { "diadiemdangsong.com", true },
  { "diadorafitness.it", true },
  { "diagnoseo.com", true },
  { "diagnoseo.pl", true },
  { "diagnoseo.se", true },
  { "dialapicnic.co.za", true },
  { "dialoegue.com", true },
  { "diamante.ro", true },
  { "diamantovaburza.cz", true },
  { "diamgroup.pl", true },
  { "diamond-hairstyle.dk", true },
  { "diamondrose.co.za", true },
  { "diamondsleepsolutions.com", true },
  { "diamondyze.nl", true },
  { "diamorphine.com", true },
  { "dianadrive.com", true },
  { "dianefriedli.ch", false },
  { "diario-egipto.com", true },
  { "diariocibao.com", true },
  { "diariodearaxa.com.br", true },
  { "diarionoticia.pe", true },
  { "diariorealidad.com", true },
  { "diaroma.it", true },
  { "diarynote.jp", true },
  { "diasdasemana.com", true },
  { "diasp.org", true },
  { "diatrofi-ygeia.gr", true },
  { "diba.org.cn", true },
  { "dibiphp.com", true },
  { "diccionariodedudas.com", true },
  { "diccionarqui.com", true },
  { "dice.tokyo", true },
  { "dicelab-rhul.org", true },
  { "dicelab.co.uk", true },
  { "dicesites.com", true },
  { "dicio.com.br", true },
  { "dicionario.org", true },
  { "dicionariodegirias.com.br", true },
  { "dicionariodelatim.com.br", true },
  { "dicionariodenomesproprios.com.br", true },
  { "dicionariodesimbolos.com.br", true },
  { "dicionarioetimologico.com.br", true },
  { "dicionariofinanceiro.com", true },
  { "dicionariopopular.com", true },
  { "dicionarios.cc", true },
  { "dick.red", true },
  { "dickord.cloud", true },
  { "dickpics.ru", true },
  { "dicksakowicz.com", true },
  { "dicoding.com", true },
  { "dictionaryofnumbers.com", true },
  { "dictionarypro.net", true },
  { "dictzone.com", true },
  { "didacte.com", true },
  { "didche.net", false },
  { "diddens.de", true },
  { "dideeducacion.com", true },
  { "didefamilia.com", true },
  { "didesalud.com", true },
  { "didierghez.com", true },
  { "didierlaumen.be", true },
  { "didtrumpopengovernmentyet.com", true },
  { "die-bergfuehrer.de", true },
  { "die-borts.ch", true },
  { "die-gruenen-teufel.de", true },
  { "die-machons.de", true },
  { "die-partei-reutlingen.de", true },
  { "die-pizzabaeckerei.de", true },
  { "die-pleners.de", true },
  { "die-seide.de", true },
  { "die-seiler.de", true },
  { "die-sinlosen.de", true },
  { "die-speisekammer-reutlingen.de", true },
  { "diebestengutscheine.de", true },
  { "diebestenvpn.de", true },
  { "diebetriebsraete.de", true },
  { "diedrich.co", true },
  { "dieecpd.org", true },
  { "diegelernten.de", true },
  { "diegerbers.de", true },
  { "diegocoy.com", true },
  { "diegogelin.com", false },
  { "diegogonzalez.com.co", true },
  { "diegorbaquero.com", true },
  { "diehl.io", true },
  { "diekperaiwseis.gr", true },
  { "diem-project.org", true },
  { "diemattels.at", true },
  { "dienchaninstitute.com", true },
  { "diendorfer.space", true },
  { "dienstplan.cc", true },
  { "dienstplan.one", true },
  { "diepanhcare.com", true },
  { "dierabenmutti.de", true },
  { "dieradvies.nl", true },
  { "dierenartsdeconinck.be", true },
  { "dieselanimals.lt", true },
  { "dieselgalleri.com", true },
  { "diesteppenreiter.de", true },
  { "dietaanticelulitica.com", true },
  { "dietaanticelulitis.com", true },
  { "dietafeliz.com", true },
  { "dietbrand.eu", true },
  { "dieterglas.de", true },
  { "dietergreven.de", false },
  { "dieterstinglhamber.me", false },
  { "diethood.com", true },
  { "dieti-natura.com", true },
  { "dieti.net", true },
  { "dietlin.com", true },
  { "dietrich.cx", true },
  { "dieumfrage.com", true },
  { "diferenca.com", true },
  { "different.cz", true },
  { "differenta.ro", true },
  { "differentgirleveryday.ml", true },
  { "diffnow.com", true },
  { "difoosion.com", true },
  { "digcit.org", true },
  { "digdata.de", true },
  { "dighans.com", true },
  { "digiarc.net", true },
  { "digibull.email", true },
  { "digibull.link", true },
  { "digicasso.nl", true },
  { "digicode.hu", true },
  { "digicy.cloud", true },
  { "digideli.ee", true },
  { "digiepoxypaint.com", true },
  { "digilicious.com", true },
  { "digimaat.agency", true },
  { "digimagical.com", true },
  { "digimedia.cd", false },
  { "digioccumss.ddns.net", true },
  { "digipost.no", true },
  { "digirechnung.de", true },
  { "digired.ro", true },
  { "digit.ec", true },
  { "digital-compounds.com", true },
  { "digital-eastside.de", true },
  { "digital-insurance-engine.com", true },
  { "digital-insurance-engine.de", true },
  { "digital-insurance-platform.com", true },
  { "digital-insurance-platform.de", true },
  { "digital-liberal.ch", true },
  { "digital-sculpture.org", true },
  { "digital-sign.com.cn", true },
  { "digital.gov", false },
  { "digital.govt.nz", true },
  { "digital1st.co.uk", true },
  { "digitalagencynetwork.com", true },
  { "digitalallies.co.uk", true },
  { "digitalarchitecture.com", true },
  { "digitalarchives.tw", true },
  { "digitalbitbox.com", true },
  { "digitalblood.eu", true },
  { "digitalch.ng", true },
  { "digitalchurch.ng", true },
  { "digitalcitizen.life", true },
  { "digitalcitizen.ro", true },
  { "digitalcoffeepodcast.com", true },
  { "digitalcraftmarketing.co.uk", true },
  { "digitalcronies.com", true },
  { "digitaldaily.de", true },
  { "digitaldatacenter.net", true },
  { "digitaldeli.com", true },
  { "digitaldeli.org", true },
  { "digitaldeli.tv", true },
  { "digitaldeli.us", true },
  { "digitaldeliarchive.com", true },
  { "digitaldem.it", true },
  { "digitalehandtekeningen.nl", true },
  { "digitaleoverheid.nl", false },
  { "digitaleplus.fr", true },
  { "digitaletanker.com", true },
  { "digitalfoster.org", true },
  { "digitalframe.nl", true },
  { "digitalfury.co.uk", true },
  { "digitalfuturenow.com", true },
  { "digitalgov.gov", true },
  { "digitalhabit.at", true },
  { "digitalhabitat.io", true },
  { "digitalid-sandbox.com", true },
  { "digitalid.com", true },
  { "digitalid.com.au", true },
  { "digitalliteracy.gov", true },
  { "digitalmarketingindallas.com", true },
  { "digitalpiloten.org", true },
  { "digitalposition.com", true },
  { "digitalprimate.my", true },
  { "digitalredshirts.com", true },
  { "digitalrights.center", true },
  { "digitalrights.fund", true },
  { "digitalskillswap.com", true },
  { "digitalspiders.pk", true },
  { "digitalsurge.io", true },
  { "digitaltcertifikat.dk", true },
  { "digitaltrust.ae", true },
  { "digitalunite.de", true },
  { "digitec.ch", true },
  { "digitecgalaxus.ch", true },
  { "digitiqo.com", true },
  { "digitkon.com", true },
  { "digitreads.com", true },
  { "digixcellence.com", true },
  { "digminecraft.com", true },
  { "digpath.co.uk", true },
  { "digwp.com", true },
  { "dihesan.com", true },
  { "dijitaller.com", true },
  { "dijkmanmuziek.nl", false },
  { "dijkmanvandoorn.nl", false },
  { "dilberkebab.co.uk", true },
  { "dildoexperten.se", true },
  { "dildosconsoladores.cl", true },
  { "diletec.com.br", true },
  { "dilibel.be", true },
  { "diligo.ch", false },
  { "dillewijnzwapak.nl", true },
  { "dillonkorman.com", true },
  { "diluv.com", false },
  { "dimagrimentoincorso.it", true },
  { "dimanet.fr", true },
  { "dimanss47.net", true },
  { "dime-staging.com", true },
  { "dime.io", true },
  { "dimeponline.com.br", true },
  { "dimez.ru", true },
  { "dimiskovska.de", true },
  { "dimitrihomes.com", true },
  { "dimitrovi.tk", true },
  { "dimmersagourahills.com", true },
  { "dimmerscalabasas.com", true },
  { "dimmersdosvientos.com", true },
  { "dimmershiddenhills.com", true },
  { "dimmerslakesherwood.com", true },
  { "dimmersnewburypark.com", true },
  { "dimmersoakpark.com", true },
  { "dimmersthousandoaks.com", true },
  { "dimmerswestlakevillage.com", true },
  { "dimo-analytics.fr", true },
  { "dimo-crm.fr", true },
  { "dimo-dematerialisation.com", true },
  { "dimo-tresorerie.fr", true },
  { "dimomaint-sav.fr", true },
  { "dimomaint.com", true },
  { "dimomaint.de", true },
  { "dimomaint.es", true },
  { "dimomaint.it", true },
  { "dimomaint.nl", true },
  { "dimomaint.pt", true },
  { "dimonb.com", true },
  { "dimosoftware.fr", true },
  { "din-hkd.jp", true },
  { "dinepont.fr", true },
  { "dinerroboticurology.com", true },
  { "dingsbums.shop", true },
  { "dinheirolucrar.com", true },
  { "dinkommunikasjon.no", true },
  { "dinmtb.dk", true },
  { "dino.lol", true },
  { "dinocarrozzeria.com", true },
  { "dinstec.cl", true },
  { "dintrafic.net", true },
  { "diodeled.com", true },
  { "diodo.me", true },
  { "dioesfoto.com", true },
  { "dionysos-ios.gr", true },
  { "dipalma.me", true },
  { "dipdaq.com", true },
  { "dipietro.id.au", true },
  { "dipling.de", true },
  { "diplomatiq.org", true },
  { "diplona.de", true },
  { "dipro.id", true },
  { "dipulse.it", true },
  { "dir2epub.com", true },
  { "dir2epub.org", true },
  { "dirba.io", true },
  { "direct-sel.com", true },
  { "direct.cz", true },
  { "direct365.es", true },
  { "directed.ir", true },
  { "directelectricalltd.co.uk", true },
  { "directfinance.cz", true },
  { "directhomeremodelinginc.com", true },
  { "directlendingsolutions.com", true },
  { "directlinkfunding.co.uk", true },
  { "directnews.be", true },
  { "directoriostelefonicos.com", true },
  { "directorioz.com", true },
  { "directorydashboard.ga", true },
  { "directorydisc.ga", true },
  { "directoryhub.io", true },
  { "directreal.sk", true },
  { "directspa.fr", true },
  { "directveilig.nl", true },
  { "direktvermarktung-schmitzberger.at", true },
  { "dirk-dogs.tk", true },
  { "dirk-scheele.de", true },
  { "dirk-weise.de", true },
  { "dirkdoering.de", true },
  { "dirkjonker.nl", true },
  { "dirko.net", true },
  { "dirkwolf.de", true },
  { "dirtinmyshoes.com", true },
  { "dirtygeek.ovh", true },
  { "dirtyincest.com", true },
  { "dirtyprettyartwear.com", true },
  { "dirtytiles.xyz", true },
  { "disability.gov", true },
  { "disabilitydischarge.com", true },
  { "disabled-world.com", true },
  { "disabled.dating", true },
  { "disabuse.cf", true },
  { "disadattamentolavorativo.it", true },
  { "disanteimpianti.com", false },
  { "disc.uz", true },
  { "discarica.bari.it", true },
  { "discarica.bologna.it", true },
  { "discarica.firenze.it", true },
  { "discarica.it", true },
  { "discarica.milano.it", true },
  { "discarica.napoli.it", true },
  { "discarica.roma.it", true },
  { "disch.com.de", true },
  { "dischempharmacie.com", true },
  { "disciples.io", true },
  { "discodery.com", true },
  { "discofitta.com", true },
  { "disconformity.net", true },
  { "disconnect.tk", true },
  { "discord.gg", true },
  { "discord.gift", true },
  { "discord4j.com", true },
  { "discordapp.com", true },
  { "discordbee.com", true },
  { "discordia.me", true },
  { "discordservers.com", true },
  { "discount24.de", true },
  { "discountlumberspokane.com", true },
  { "discounto.de", true },
  { "discountpokale.at", false },
  { "discountpokale.de", true },
  { "discover-shaken.com", true },
  { "discoverthreejs.com", true },
  { "discoverucluelet.com", true },
  { "discoveryaima.com", true },
  { "discoveryballoon.org", true },
  { "discrypt.ca", true },
  { "discus-communications.dk", true },
  { "dise-online.de", true },
  { "disinclined.org", true },
  { "disinfesta.it", true },
  { "disinfestando.info", true },
  { "disinfestatore.roma.it", true },
  { "disinfestatori.com", true },
  { "disinfestazione.brescia.it", true },
  { "disinfestazione.torino.it", true },
  { "disinfestazione.venezia.it", true },
  { "disinfestazione.verona.it", true },
  { "disinfestazione24.it", true },
  { "disinfestazioneblatte.it", true },
  { "disinfestazionecimici.roma.it", true },
  { "disinfestazioni-umbria.it", true },
  { "disinfestazioni.bari.it", true },
  { "disinfestazioni.bergamo.it", true },
  { "disinfestazioni.catania.it", true },
  { "disinfestazioni.co", true },
  { "disinfestazioni.firenze.it", true },
  { "disinfestazioni.genova.it", true },
  { "disinfestazioni.gorizia.it", true },
  { "disinfestazioni.info", true },
  { "disinfestazioni.milano.it", true },
  { "disinfestazioni.napoli.it", true },
  { "disinfestazioni.net", true },
  { "disinfestazioni.padova.it", true },
  { "disinfestazioni.rimini.it", true },
  { "disinfestazioni.torino.it", true },
  { "disinfestazioni.treviso.it", true },
  { "disinfestazioni.udine.it", true },
  { "disinfestazioni.venezia.it", true },
  { "disinfestazioni.verona.it", true },
  { "disinfestazioni24.it", true },
  { "disinfestazionivespe.milano.it", true },
  { "disinfestazionizanzare.milano.it", true },
  { "disinfestazionizanzare.roma.it", true },
  { "disinisharing.com", true },
  { "disk.do", true },
  { "diskbit.com", true },
  { "diskbit.nl", true },
  { "disking.co.uk", true },
  { "dismail.de", true },
  { "displayenergycertificate.co.uk", true },
  { "displaysfas.com", true },
  { "disposable.link", true },
  { "disproweb.com", true },
  { "disroot.org", true },
  { "disrupters.ch", false },
  { "disruptiveadvertising.com", true },
  { "dissertationhelp.com", true },
  { "dissieux.com", true },
  { "dist-it.com", true },
  { "dist.torproject.org", false },
  { "distancelove.ml", true },
  { "disti.com", true },
  { "distiduffer.org", true },
  { "distillery.com", true },
  { "distinguishedprisoner.com", true },
  { "distortmotion.com", true },
  { "distracteddriving.gov", true },
  { "distratus.com", true },
  { "distribuidoracristal.com.br", true },
  { "distribuidoraplus.com", true },
  { "distribuidorveterinario.es", true },
  { "distributore.it", true },
  { "distributori.roma.it", true },
  { "district.sg", true },
  { "districtcapital.com", true },
  { "distrivalle.ec", true },
  { "distro.fr", true },
  { "ditec.sk", true },
  { "diti.me", true },
  { "dities.tk", true },
  { "diva.nl", true },
  { "divari.nl", true },
  { "divcoder.com", true },
  { "dive-japan.com", true },
  { "divedowntown.com", true },
  { "divegearexpress.com", true },
  { "diveidc.com", true },
  { "diveplan.org", true },
  { "diver-equipment.eu", true },
  { "diversifiedproduct.com", true },
  { "diversityflags.com", true },
  { "diversityflags.com.au", true },
  { "diversityflags.nz", true },
  { "divewithfrank.com", true },
  { "divi-experte.de", true },
  { "dividendz.net", true },
  { "divinasaiamodas.com.br", true },
  { "divinegames.studio", true },
  { "divineglowinghealth.com", false },
  { "divinemercyparishvld.com", true },
  { "diving.photo", true },
  { "divingforlife.org", true },
  { "divisasexpress.com", true },
  { "divisuite.com", true },
  { "divjak.at", true },
  { "divorciosmurcia.com", true },
  { "divup.com", true },
  { "diwei.vip", true },
  { "dixibox.com", true },
  { "diyanet.nl", true },
  { "diybook.at", true },
  { "diycc.org", true },
  { "diygeek.com", true },
  { "diyibo.com", true },
  { "diymediahome.org", true },
  { "diyosun.com", true },
  { "diytechguides.com", true },
  { "diyvideoeditor.com", true },
  { "dizayner.tk", true },
  { "dizzythewizard.co.uk", true },
  { "dj-leszwolle.nl", true },
  { "dj-x.info", true },
  { "dj3dub.com", true },
  { "djangobirthday.com", true },
  { "djangoproject.com", true },
  { "djangosnippets.org", true },
  { "djanpana.com", true },
  { "djbbouncycastles.co.uk", true },
  { "djbobbytables.com", true },
  { "djboekingskantoor.nl", true },
  { "djc.me", true },
  { "djcursuszwolle.nl", true },
  { "djdavid98.hu", true },
  { "djdeepstate.com", true },
  { "djfrenchy.com", true },
  { "dji-ars.pl", true },
  { "djipanov.com", true },
  { "djitsolutions.com", true },
  { "djl188.cc", true },
  { "djl63.com", true },
  { "djl63001.com", true },
  { "djleon.net", true },
  { "djlinux.cz", true },
  { "djlnetworks.co.uk", true },
  { "djlove.tk", true },
  { "djmox.in", true },
  { "djsanonimo.com", true },
  { "djsbouncycastlehire.com", true },
  { "djslash.tk", true },
  { "djvintagevinyl.com", true },
  { "djvintagevinyl.nl", true },
  { "djwaynepryke.com", true },
  { "dk-kromeriz.cz", true },
  { "dk.com", true },
  { "dk.search.yahoo.com", false },
  { "dk1818.cc", true },
  { "dkcomputers.com.au", true },
  { "dkds.us", true },
  { "dkstage.com", true },
  { "dkwedding.gr", true },
  { "dl.google.com", true },
  { "dlaspania.pl", true },
  { "dlde.ru", true },
  { "dldl.fr", true },
  { "dleger.space", true },
  { "dlfsymposium.nl", true },
  { "dlitz.net", true },
  { "dll4free.com", true },
  { "dlld.com", true },
  { "dlld.org", true },
  { "dlld.us", true },
  { "dlscomputers.com.au", true },
  { "dlui.xyz", true },
  { "dlunch.net", true },
  { "dlyatepla.ml", true },
  { "dlz149.me", true },
  { "dlzz.net", true },
  { "dm.lookout.com", false },
  { "dm.mylookout.com", false },
  { "dm7ds.de", true },
  { "dmaglobal.com", true },
  { "dmailshop.ro", true },
  { "dmarc.dk", true },
  { "dmarc.tech", true },
  { "dmarcian.com", true },
  { "dmatrix.xyz", true },
  { "dmcw.de", true },
  { "dmd.lv", true },
  { "dmdd.org.uk", true },
  { "dmerkel.de", true },
  { "dmfj.io", true },
  { "dmhtwebordering.com", true },
  { "dmi.es", true },
  { "dmitry.sh", true },
  { "dmmkenya.co.ke", false },
  { "dmmultionderhoud.nl", true },
  { "dmn.sh", true },
  { "dmoj.ca", true },
  { "dmparish.com", true },
  { "dn3s.me", true },
  { "dn42.us", true },
  { "dna.li", true },
  { "dnacloud.pl", true },
  { "dnakids.co.uk", true },
  { "dnalounge.com", true },
  { "dnapizza.com", true },
  { "dnc.org.nz", true },
  { "dndtools.net", true },
  { "dnlr.tech", true },
  { "dnmlab.it", true },
  { "dnoid.to", true },
  { "dnplegal.com", true },
  { "dns-control.eu", true },
  { "dns-swiss.ch", true },
  { "dns.google.com", true },
  { "dns8.online", true },
  { "dnsaio.com", true },
  { "dnscrawler.com", true },
  { "dnscrypt-blacklist.tk", true },
  { "dnscrypt.info", true },
  { "dnscrypt.nl", true },
  { "dnscurve.io", true },
  { "dnshallinta.fi", true },
  { "dnsipv6.srv.br", true },
  { "dnskeep.com", true },
  { "dnskeeper.com", true },
  { "dnsman.se", true },
  { "dnsmate.net", true },
  { "dnsrate.com", true },
  { "dnssecandipv6.se", true },
  { "dnstwister.report", true },
  { "do-pro.net", true },
  { "do-prod.com", false },
  { "do.gd", true },
  { "do.search.yahoo.com", false },
  { "do13.net", true },
  { "do67.de", true },
  { "do67.net", true },
  { "doanhnhankhanhhoa.vn", true },
  { "dobbshvac.com", true },
  { "dobraprace.cz", false },
  { "dobre-programy.xyz", true },
  { "dobreprogramy.pro", true },
  { "dobrisan.ro", true },
  { "dobryautoskup.pl", true },
  { "doc-baza.ru", true },
  { "doc.ai", true },
  { "doc.python.org", true },
  { "doc.to", false },
  { "doc8643.com", true },
  { "docabo.ch", true },
  { "docassure.de", true },
  { "docbox.ch", true },
  { "docdoc.ru", true },
  { "docemeldoces.com", true },
  { "doceo.com", true },
  { "dockerbook.com", false },
  { "dockerup.net", true },
  { "dockflow.com", true },
  { "dockstarter.com", true },
  { "dockysearch.com", true },
  { "docline.gov", true },
  { "docloh.de", true },
  { "docloudu.info", true },
  { "docmed360.com", true },
  { "docplexus.com", true },
  { "docs.google.com", false },
  { "docs.python.org", true },
  { "docs.tw", true },
  { "docskiff.com", true },
  { "doctabaila.com", true },
  { "doctafit.com", true },
  { "docteurcardin.com", true },
  { "doctor-locks.co.uk", true },
  { "doctor.dating", true },
  { "doctor360.com.au", true },
  { "doctorcalefon.com", true },
  { "doctorfox.co.uk", true },
  { "doctornaima.ml", true },
  { "doctorperu.com", true },
  { "doctorwho.cz", true },
  { "doctorxdentist.com", true },
  { "docubox.info", true },
  { "docucopies.com", true },
  { "docudanang.com.vn", false },
  { "documaniatv.com", true },
  { "docupaymentuat.xyz", true },
  { "docusearch.com", true },
  { "dodikod.tk", true },
  { "dodopri.com", true },
  { "doenjoylife.com", true },
  { "doeren.com", true },
  { "doerz.com", true },
  { "does.one", true },
  { "doesburg-comp.nl", true },
  { "doesinfotech.com", true },
  { "dofux.org", true },
  { "dogadayiz.net", true },
  { "dogan.ch", false },
  { "dogandoganay.com", true },
  { "dogcontrol.ca", true },
  { "dogear.ch", true },
  { "dogforum.de", true },
  { "dogfriendly.co.uk", true },
  { "doggedbyirs.com", true },
  { "doggo.cloud", true },
  { "doggo.dance", true },
  { "doggo.email", true },
  { "doggroomingcourse.com", true },
  { "dogmap.jp", true },
  { "dogodki.today", true },
  { "dogoo.com", true },
  { "dogpawstudio.com", true },
  { "dogrescuegreece.nl", true },
  { "dogvolution.com", true },
  { "dogworld.com.br", true },
  { "dohanews.co", true },
  { "doihavetoputonpants.com", true },
  { "doinaruscior.eu", true },
  { "doitauto.de", true },
  { "doitexperience.com", true },
  { "dojozendebourges.fr", true },
  { "dokelio-idf.fr", true },
  { "dokhuyenmaigiatot.com", true },
  { "doki.space", false },
  { "dokipy.no", true },
  { "dokkanashop.com", true },
  { "dokuboard.com", true },
  { "dolcesalatoweb.it", true },
  { "dolci-delizie.de", true },
  { "dolciterapie.com", true },
  { "doli.se", true },
  { "dolice.net", true },
  { "dolinathome.com", true },
  { "doll.ml", true },
  { "dollarrp.pl", true },
  { "dollchan.org", true },
  { "dollemore.com", true },
  { "dollhousetoyo.com", true },
  { "dolorism.com", true },
  { "dolph.de", true },
  { "doma.in", true },
  { "domadillo.com", true },
  { "domain-ermittlung.de", true },
  { "domain-skachat.cf", true },
  { "domain-speicher.com", true },
  { "domain-speicher.de", true },
  { "domain001.info", true },
  { "domainedemiolan.ch", false },
  { "domainevanina.fr", true },
  { "domainexpress.de", false },
  { "domainforfree.gq", true },
  { "domainkauf.de", true },
  { "domainname.forsale", true },
  { "domainoo.com", true },
  { "domains.google.com", true },
  { "domainsilk.com", true },
  { "domainspeicher.com", true },
  { "domainspeicher.one", true },
  { "domainstaff.com", true },
  { "domainvoider.cf", true },
  { "domakidis.com", true },
  { "domarkperu.com", true },
  { "domaxpoker.com", true },
  { "domein-direct.com", true },
  { "domein-direct.nl", true },
  { "domeindns.nl", true },
  { "domenaru.ga", true },
  { "domenic.me", true },
  { "domenicam.com", true },
  { "domesticcleaners.co.uk", true },
  { "domfee.com", true },
  { "domhaase.me", true },
  { "domhos.tk", true },
  { "domian.cz", true },
  { "domicile-clean.fr", true },
  { "dominationgame.co.uk", true },
  { "dominctheroofguy.com", true },
  { "dominicandfelixroco.tk", true },
  { "dominicanosenpr.com", true },
  { "dominicself.co.uk", true },
  { "dominictaylor.co.uk", true },
  { "dominik-bergmann.de", true },
  { "dominik.st", true },
  { "dominikaner-vechta.de", true },
  { "dominionregistries.domains", true },
  { "dominique-haas.fr", false },
  { "dominoknihy.cz", true },
  { "dominomatrix.com", true },
  { "domjh.com", true },
  { "dommascate.com.br", true },
  { "domob.eu", true },
  { "domodeco.fr", true },
  { "domodedovo.travel", true },
  { "domop.cc", true },
  { "domop.net", true },
  { "domop.org", true },
  { "domowe-potrawy.pl", true },
  { "domprojects.com", true },
  { "domscripting.com", true },
  { "domster.com", true },
  { "domus-global.com", true },
  { "domus-global.cz", true },
  { "domwkwiatach.pl", true },
  { "domyassignments.com", true },
  { "domycasestudy.com", true },
  { "domycoursework.com", true },
  { "domycreativewritings.com", true },
  { "domydissertations.com", true },
  { "domyessay.net", true },
  { "domyessays.com", true },
  { "domyhomework123.com", true },
  { "domyhomeworks.net", true },
  { "domyiadaptacje.pl", true },
  { "domynetwork.com", true },
  { "domypapers.com", true },
  { "domyresearchpaper.com", true },
  { "domyreview.net", true },
  { "domyspeech.com", true },
  { "domytermpaper.com", true },
  { "domythesis.net", true },
  { "domyzitrka.cz", true },
  { "domznak.ru", true },
  { "donabeneko.jp", true },
  { "donaldjenkins.com", true },
  { "donaldm.co.uk", true },
  { "donaldtrump.ga", true },
  { "donateabox.org", true },
  { "donateaday.net", true },
  { "donation.ph", true },
  { "donboscogroep.nl", true },
  { "donfelino.tk", false },
  { "dongcdn.com", true },
  { "dongxuwang.com", true },
  { "donjusto.nl", true },
  { "donkennedyandsons.com", true },
  { "donkeytrekkingkefalonia.com", true },
  { "donnaandscottmcelweerealestate.com", true },
  { "donnabrothers.com", true },
  { "donnacha.blog", true },
  { "donnachie.net", true },
  { "donnajeanbooks.com", true },
  { "donner-reuschel.de", true },
  { "donnons.org", false },
  { "donnoval.ru", false },
  { "donotcall.gov", true },
  { "donotlink.it", true },
  { "donovankraag.nl", true },
  { "donpanda.cz", true },
  { "donpomodoro.com.co", true },
  { "donsremovals.com.au", true },
  { "dont.re", true },
  { "dont.watch", true },
  { "dontbeevil.com", true },
  { "dontbubble.me", true },
  { "dontcageus.org", true },
  { "donthedragonwilson.com", true },
  { "dontpayfull.com", true },
  { "dontstopcoffee.com", true },
  { "donttrust.me", true },
  { "donutcompany.co.jp", true },
  { "dooby.fr", true },
  { "dooleylabs.com", true },
  { "dooleytackaberry.com", true },
  { "doolz.co.nz", true },
  { "doomoo.com", true },
  { "doomsworld.com", true },
  { "doomtech.net", true },
  { "doomus.me", true },
  { "doooooops.com", true },
  { "doop.im", true },
  { "doordecor.bg", true },
  { "doorflow.com", true },
  { "doorhandlese.com", true },
  { "doorshingekit.com", true },
  { "doorswest.net", true },
  { "doortim.nl", true },
  { "dopesoft.de", true },
  { "dophys.top", true },
  { "doppeleinhorn.de", true },
  { "doppler.com", true },
  { "dopsi.ch", true },
  { "dor-tak.com", true },
  { "dor-tak.ru", true },
  { "dora.moe", true },
  { "doradocomputer.com", true },
  { "doradoscampeon.tk", true },
  { "doramamusic.gq", true },
  { "dorco.be", true },
  { "dorde.eu", true },
  { "dorfbaeck.at", true },
  { "dorfbrunnen.eu", false },
  { "dorfpark-falkenburg.de", true },
  { "dorfzittig.de", true },
  { "doriangirod.ch", false },
  { "dorianharmans.nl", true },
  { "doridian.com", true },
  { "doridian.de", true },
  { "doridian.net", true },
  { "doridian.org", true },
  { "dormirmucho.com", true },
  { "dormitengernyikaland.hu", true },
  { "dormiu.com", true },
  { "dormiu.com.br", true },
  { "dornhecker.me", true },
  { "dorogaminina.tk", true },
  { "dorpshuis-dwarsgracht.nl", true },
  { "dorpshuiskesteren.nl", true },
  { "dorsetentertainments.co.uk", true },
  { "dorth.nl", true },
  { "dosenkiwi.at", true },
  { "dosje.org", true },
  { "doska.by", true },
  { "doska.ru", true },
  { "dosomeworks.biz", true },
  { "dossplumbing.co.za", false },
  { "dostalsecurity.com", true },
  { "dostav.tk", true },
  { "dostlar.fr", true },
  { "dosvientoselectric.com", true },
  { "dosvientoselectrical.com", true },
  { "dosvientoselectrician.com", true },
  { "dosvientosexteriorlighting.com", true },
  { "dosvientoslandscapelighting.com", true },
  { "dosvientoslighting.com", true },
  { "dosvientosoutdoorlighting.com", true },
  { "doswap.com", true },
  { "dosyauzantisi.com", true },
  { "dot42.no", true },
  { "dotacni-parazit.cz", true },
  { "dotbigbang.com", true },
  { "dotbox.org", true },
  { "dotcircle.co", true },
  { "dotesports.com", true },
  { "dotgov.gov", true },
  { "dothebangthingsalon.com", true },
  { "dothydesign.com", true },
  { "dotjesper.com", true },
  { "dotjesper.dk", true },
  { "dotjesper.net", true },
  { "dotjs.party", true },
  { "dotkniseandroida.cz", true },
  { "dotkod.pl", true },
  { "dotneko.net", true },
  { "dotnetdocs.ir", true },
  { "dotphoto.com", true },
  { "dotplex.com", true },
  { "dotplex.de", true },
  { "dotrox.net", true },
  { "dotshule.ug", true },
  { "dotsiam.co.th", true },
  { "dotsiam.com", true },
  { "dotsiam.in.th", true },
  { "dottore.roma.it", true },
  { "douai.me", true },
  { "doubleaste.com", true },
  { "doubleavineyards.com", true },
  { "doubleglazingmasters.com.au", true },
  { "doubleup.com.au", true },
  { "doucheba.gs", false },
  { "doughseeker.com", true },
  { "douglascountybar.com", true },
  { "douglascountyfilmtrail.com", true },
  { "dougley.com", true },
  { "dougsautobody.com", true },
  { "doujinshi.info", true },
  { "doujinspot.com", true },
  { "douzer.de", true },
  { "douzer.industries", true },
  { "dovenzorgmalawi.nl", true },
  { "dovermotion.com", true },
  { "dowell.media", true },
  { "dowellconsulting.com", true },
  { "dowhatmakegood.de", true },
  { "dowling.nz", true },
  { "download-knigi.gq", true },
  { "download.dk", true },
  { "downloadaja.com", true },
  { "downloadfiles.cf", true },
  { "downloadgamemods.com", true },
  { "downloadgram.com", true },
  { "downloadhindimovie.com", true },
  { "downloads.zdnet.com", true },
  { "downloadsoftwaregratisan.com", true },
  { "downrightcute.com", true },
  { "downtimerobot.nl", true },
  { "downtownautospecialists.com", true },
  { "downtownstevenspoint.org", true },
  { "downtownsuiteliving.com", true },
  { "downtownvernon.com", true },
  { "downunderporn.com", true },
  { "dox-box.eu", true },
  { "doxal.ro", true },
  { "doxepin1.gq", true },
  { "doxycyclineprices.cf", true },
  { "doyleshamrock.com", true },
  { "doyoucheck.com", false },
  { "doyouedc.com", true },
  { "doyoutax.com", false },
  { "doypacky.cz", false },
  { "doze-cloud.tech", true },
  { "dozecloud.com", true },
  { "dp.cx", true },
  { "dpd.com.pl", true },
  { "dpecuador.com", true },
  { "dpellegrini.com", true },
  { "dperson.net", true },
  { "dpfsolutionsfl.com", true },
  { "dpg.no", true },
  { "dphipartner.com", true },
  { "dpi-design.de", true },
  { "dpim.org.my", true },
  { "dpisecuretests.com", true },
  { "dpm-ident.de", false },
  { "dponetwork.nl", true },
  { "dposit.com", true },
  { "dposit.email", true },
  { "dposit.eu", true },
  { "dposit.net", true },
  { "dposit.org", true },
  { "dprb.biz", true },
  { "dps.srl", true },
  { "dpsg-hohenlinden.de", true },
  { "dpsg-roden.de", false },
  { "dpwsweeps.co.uk", true },
  { "dr-becarelli-philippe.chirurgiens-dentistes.fr", true },
  { "dr-bodendorf.de", true },
  { "dr-klotz.info", true },
  { "dr-knirr.de", true },
  { "dr-marlen-nystroem.de", true },
  { "dr-moldovan.de", true },
  { "dr-nystroem.de", true },
  { "dr-peter-jahn.de", true },
  { "dr-schlamminger.de", true },
  { "dr-schmutzer.de", true },
  { "dr-schuessler.de", true },
  { "dr-stoetter.de", true },
  { "dr-www.de", true },
  { "dr.mg", true },
  { "dr2dr.ca", true },
  { "draadloos-besturen.nl", true },
  { "draadloze-noodstop.nl", true },
  { "drabadir.com", true },
  { "drabim.org", true },
  { "drach.xyz", true },
  { "drachenleder.de", true },
  { "dracisvet.cz", true },
  { "dracoon.com", true },
  { "dracoon.de", true },
  { "dracoon.team", true },
  { "dracox.com", true },
  { "draemar.com", true },
  { "draftguru.com.au", true },
  { "dragcave.net", true },
  { "dragfiles.com", true },
  { "draghetti.it", true },
  { "draghive.com", true },
  { "dragon-chem.eu", true },
  { "dragon-hearts.co.uk", true },
  { "dragon.nu", true },
  { "dragoncave.me", true },
  { "dragonclean.gr", true },
  { "dragonheartsrpg.com", true },
  { "dragonkin.net", true },
  { "dragonprogrammer.com", true },
  { "dragonschool.org", true },
  { "dragonsunited.at", true },
  { "dragonsunited.ch", true },
  { "dragonsunited.de", true },
  { "dragonsunited.eu", true },
  { "dragonsunited.info", true },
  { "dragonsunited.net", true },
  { "dragonsunited.org", true },
  { "dragontours.net", true },
  { "dragonwolfpackaquaria.com", true },
  { "dragowebdesign.com", true },
  { "draintechnorthwest.net", true },
  { "drake.partners", true },
  { "drakecommercial.com", true },
  { "drakeluce.com", true },
  { "drakenson.de", true },
  { "drakfot.se", true },
  { "drakoacademy.org", true },
  { "draliabadi.com", true },
  { "dramaticpeople.com", true },
  { "dramyalderman.com", true },
  { "dranderle.com", true },
  { "drandrewarnold.com", true },
  { "dranik.ga", true },
  { "dranous.com", true },
  { "drapeauxdespays.fr", true },
  { "dras.hu", true },
  { "dratini0.hu", true },
  { "draugr.de", true },
  { "draw.uy", true },
  { "drawesome.uy", true },
  { "drawingcode.net", true },
  { "drawtwo.gg", true },
  { "drawvesly.ovh", true },
  { "drawxp.com", true },
  { "draycotthotel.com", true },
  { "drbresnick.com", true },
  { "drbriones.com", true },
  { "drcarolynquist.com", true },
  { "drchrislivingston.com", true },
  { "drchristophepanthier.com", true },
  { "drcourtney.com", true },
  { "drdegenhart.de", true },
  { "drdenisvincenzi.com.br", true },
  { "drdipilla.com", true },
  { "drdripplumbingsydney.com.au", true },
  { "dream-pools.cf", true },
  { "dreamboxpro.com", true },
  { "dreamcrack.tk", true },
  { "dreamcraft.su", true },
  { "dreamcreator108.com", true },
  { "dreamday-with-dreamcar.de", true },
  { "dreamdestine.com", true },
  { "dreamdivers.com", true },
  { "dreamhostremixer.com", true },
  { "dreamhouses.com", true },
  { "dreamlandmagic.com", true },
  { "dreamlordpress.it", true },
  { "dreamlux.cz", true },
  { "dreamlux.sk", true },
  { "dreammaker-nw.com", true },
  { "dreammakerutah.com", true },
  { "dreamof.net", false },
  { "dreamrae.net", true },
  { "dreamsforabetterworld.com.au", true },
  { "dreamstream.nl", true },
  { "dreamstream.tv", true },
  { "dreamstream.video", true },
  { "dreamstudio.com", true },
  { "dreamsxxl.com", true },
  { "dreamwork.financial", true },
  { "dreamz-staging.zone", true },
  { "dreamz.com", true },
  { "dreatho.com", true },
  { "dreemurr.com", true },
  { "drei01.com", true },
  { "drei01.de", true },
  { "drei01.technology", true },
  { "dreid.org", true },
  { "drendermobilyaservisi.com", true },
  { "dresden-kaffee-24.de", true },
  { "dresden-kaffeeroesterei.de", true },
  { "dresdener-mandelstollen.de", true },
  { "dresdens-pfefferkuchenprinzessin.de", true },
  { "dresdner-kaffeeroesterei.de", true },
  { "dresdner-mandelstollen.de", true },
  { "dresdner-stollen-von-reimann.de", false },
  { "dresdner-stollen.shop", true },
  { "dress-cons.com", true },
  { "dressify.in", true },
  { "dressingmaternity.fr", true },
  { "drevanbeale.com", true },
  { "drevo-door.cz", false },
  { "drew.beer", true },
  { "drew.life", true },
  { "drewapianostudio.com", true },
  { "drewlearns.com", true },
  { "drewsilcock.co.uk", true },
  { "drewzar.com", true },
  { "dreyfussplasticsurgery.com", true },
  { "drezzy.it", true },
  { "drgeadsdavinci.com", true },
  { "drgerthplasticsurgery.com", true },
  { "drghomi.com", true },
  { "drglassgyn.com", true },
  { "drgn.li", true },
  { "drgn.no", true },
  { "drgrace.ca", true },
  { "drhathazi.hu", true },
  { "drheibel.com", true },
  { "drherndonent.com", true },
  { "drhildebrand.net", true },
  { "drhoseyni.com", true },
  { "drhyler.com", true },
  { "drianpublishing.tk", true },
  { "driesjtuver.nl", true },
  { "driftdude.nl", true },
  { "driftingruby.com", true },
  { "drighes.com", true },
  { "drillingsupply.info", true },
  { "drillingsupplystore.com", true },
  { "drillion.net", true },
  { "drillshackresort.com", true },
  { "drilon.be", true },
  { "drinkcontrolapp.com", true },
  { "drinkgas-jihlava.cz", true },
  { "drinkgo.vn", true },
  { "driv.io", true },
  { "drive.google.com", false },
  { "driveexport.com", true },
  { "driven2shine.eu", true },
  { "drivenes.net", true },
  { "driver.ru", true },
  { "drivercopilot.com", true },
  { "driverless.id", true },
  { "driverprofiler.co.uk", true },
  { "driverscollection.com", true },
  { "drivetonortheast.com", true },
  { "drivinghorror.com", true },
  { "drivinhors.com", true },
  { "drivya.com", true },
  { "drizz.com.br", false },
  { "drjacquesmalan.com", true },
  { "drjoe.ca", true },
  { "drjosebarrera.com", true },
  { "drjuanitacollier.com", false },
  { "drjulianneil.com", true },
  { "drkhsh.at", false },
  { "drlandis.com", true },
  { "drlangsdon.com", true },
  { "drlinkcheck.com", true },
  { "drmayakato.com", true },
  { "drmcdaniel.com", true },
  { "drms.us", true },
  { "drmtransit.com", true },
  { "drogariasantoantonio.pt", true },
  { "drogavista.com.br", true },
  { "droid101.com", true },
  { "droidandy.com", true },
  { "droidapp.nl", true },
  { "droidchart.com", true },
  { "droidgyan.com", true },
  { "droidhere.com", true },
  { "drone-it.net", false },
  { "dronebl.org", true },
  { "droneland.nl", true },
  { "dronepilotgeorgia.com", true },
  { "dronepit.dk", true },
  { "dronesz.co", true },
  { "droni.cz", true },
  { "dronografia.es", true },
  { "dronova-art.ru", true },
  { "drop.com", true },
  { "dropbox.com", true },
  { "dropboxer.net", true },
  { "droperplus.com", true },
  { "dropistic.com", true },
  { "droppia.io", true },
  { "dropq.nl", true },
  { "dropscloud.spdns.de", true },
  { "dropshare.cloud", true },
  { "dropshell.net", true },
  { "droso.dk", true },
  { "drown.photography", true },
  { "drpetersenobgynal.com", true },
  { "drpetervoigt.ddns.net", true },
  { "drpetervoigt.de", true },
  { "drphillipsmwc.com", true },
  { "drpico.com.au", true },
  { "drpil.nl", true },
  { "drpure.top", true },
  { "drradin.com", true },
  { "drrhonda.com", true },
  { "drrr.chat", true },
  { "drrr.com", true },
  { "drrr.wiki", true },
  { "drsajjadian.com", true },
  { "drsamuelkoo.com", true },
  { "drschlarb.eu", true },
  { "drsheri.com", true },
  { "drsturgeonfreitas.com", true },
  { "drsubbio.com", true },
  { "drthalhammer.at", true },
  { "drtimmarch.com", true },
  { "drtimothybradley.com", true },
  { "drtristanberry.com", true },
  { "druckerei-huesgen.de", true },
  { "drugs.com", true },
  { "drumbe.at", true },
  { "drumlines.org", true },
  { "drummondframing.com", true },
  { "drunkendropkes.tk", true },
  { "drunkscifi.com", true },
  { "drupal-expert.it", true },
  { "drupal.org", true },
  { "drupalspb.org", true },
  { "drusantia.net", true },
  { "drusillas.co.uk", true },
  { "druwe.net", false },
  { "drwang.group", true },
  { "drweinrach.com", true },
  { "drweissbrot.net", true },
  { "drwxr.org", true },
  { "drybjed.net", true },
  { "drycleancoalition.org", true },
  { "drycreekphoto.com", true },
  { "drydrydry.com", true },
  { "dryerventcleaningarlington.com", true },
  { "dryerventcleaningcarrollton.com", true },
  { "dryjersey.com", true },
  { "dryudha.site", true },
  { "drywallresponse.gov", true },
  { "ds.lol", true },
  { "ds138.cc", true },
  { "ds168.cc", true },
  { "ds28s.com", true },
  { "ds388.cc", true },
  { "ds67.de", true },
  { "dsancomics.com", true },
  { "dsanraffleshangbai.xyz", true },
  { "dsayce.com", true },
  { "dsble.de", true },
  { "dsbmradio.tk", true },
  { "dsbutler.de", true },
  { "dscharrer.com", true },
  { "dschwarzachtaler.de", true },
  { "dsebastien.net", true },
  { "dsektionen.se", false },
  { "dsgarms.com", true },
  { "dsgholsters.com", true },
  { "dsgnet.hu", true },
  { "dsgvo-addon.eu", true },
  { "dsgvo-analyse.de", true },
  { "dsgvo.name", true },
  { "dsh.io", true },
  { "dshield.org", true },
  { "dsi7.com", true },
  { "dsimons.tk", true },
  { "dsm5.com", true },
  { "dsmjs.com", true },
  { "dso-izlake.si", true },
  { "dsol.hu", true },
  { "dsouzamusic.com", true },
  { "dspace.pl", true },
  { "dspropertyservicesltd.co.uk", true },
  { "dsreal.de", true },
  { "dstamou.de", true },
  { "dsteiner.at", true },
  { "dstvinstalledenvale.co.za", true },
  { "dstvinstallglenvista.co.za", true },
  { "dstvinstalljohannesburg.co.za", true },
  { "dstvinstallkemptonpark.co.za", true },
  { "dstvrandburg.co.za", true },
  { "dstvsandton.co.za", true },
  { "dstvsouthafrica.com", true },
  { "dsuinnovation.com", true },
  { "dt688.net", true },
  { "dtbouncycastles.co.uk", true },
  { "dtbw.eu", true },
  { "dtbw.net", true },
  { "dtbw.org", true },
  { "dtdsh.com", true },
  { "dtg-fonds.com", true },
  { "dtg-fonds.de", true },
  { "dtg-fonds.net", true },
  { "dtgmns.com", true },
  { "dtinel.org", true },
  { "dtivandortbv.nl", true },
  { "dtleague.eu", true },
  { "dtmbnl.com", true },
  { "dtmbx.com", true },
  { "dtmbx.email", true },
  { "dtmbx.eu", true },
  { "dtmbx.net", true },
  { "dtmbx.nl", true },
  { "dtmbx.org", true },
  { "dtmlnp.com", true },
  { "dtngny.com", true },
  { "dtnx.email", true },
  { "dtnx.eu", true },
  { "dtnx.net", true },
  { "dtnx.org", true },
  { "dtnxny.com", true },
  { "dtoweb.be", true },
  { "dtp-mstdn.jp", false },
  { "dtuaarsfest.dk", true },
  { "dtune.me", true },
  { "dtx.sk", true },
  { "du-alex.ru", true },
  { "duarteeleiteconsultoria.com.br", true },
  { "dub.cz", true },
  { "dubai-company.ae", true },
  { "dubaieveningsafari.com", true },
  { "dubaizone.cf", true },
  { "dubbingkursus.dk", true },
  { "dubbningshemsidan.se", true },
  { "dubious-website.com", true },
  { "dublin-traceroute.net", true },
  { "dubrava.tk", true },
  { "dubrovskiy.net", true },
  { "dubrovskiy.pro", true },
  { "dubstep.fr", true },
  { "dubtrack.fm", true },
  { "ducadu.com", true },
  { "duch.cloud", true },
  { "duckbase.com", true },
  { "duckblade.com", true },
  { "duckcorp.org", true },
  { "duckduck.horse", true },
  { "duckduckstart.com", true },
  { "duckfam.us", true },
  { "duckinc.net", true },
  { "ducksoft.fi", true },
  { "duct.me", true },
  { "dudesunderwear.com.br", false },
  { "due-diligence-security.com", true },
  { "duelingaces.com", true },
  { "duernberg.at", true },
  { "duesee.org", true },
  { "duesterhus.eu", true },
  { "dufrei.com", true },
  { "dug.net.pl", true },
  { "duggtec.com", true },
  { "dugunedavet.com", true },
  { "duh.se", true },
  { "duijf.info", true },
  { "duijf.io", true },
  { "duijfathome.nl", true },
  { "duitang.com", true },
  { "dukan-recepty.ru", true },
  { "dukatek.cz", true },
  { "dukeandduchessdrivingschool.co.uk", true },
  { "dukegat.de", false },
  { "dukers-baelemans.nl", true },
  { "dukesatqueens.com", true },
  { "dukun.de", true },
  { "dulcinela.es", true },
  { "dulei.si", true },
  { "dullapp.com", true },
  { "dum.moe", true },
  { "dumax.xyz", true },
  { "dumb-laws.net.ru", true },
  { "dumbeartech.com", true },
  { "dumberger-bau.de", true },
  { "dumboverflow.com", true },
  { "dumino.bg", true },
  { "duncancmt.com", true },
  { "duncanfamilytrust.org", true },
  { "duncanmoffat.com", true },
  { "duncanwinfrey.com", true },
  { "duncm.com", true },
  { "dungdev.net", true },
  { "dungeon-bbs.de", true },
  { "dunklau.fr", true },
  { "dunkle-seite.org", true },
  { "dunmanelectric.com", true },
  { "dunyahalleri.com", true },
  { "duobus.nl", true },
  { "duoluodeyu.com", true },
  { "duoquadragintien.fr", true },
  { "duoyin.com", true },
  { "dupisces.com.tw", true },
  { "duplicazionechiavi.it", true },
  { "duploclique.pt", false },
  { "dupree.co", true },
  { "dupree.pe", true },
  { "durand.tf", true },
  { "duranthon.eu", true },
  { "durbanlocksmiths.co.za", true },
  { "durcal.tk", true },
  { "durdle.com", true },
  { "dureuil.info", true },
  { "durfteparticiperen.nl", true },
  { "durgatopos.it", true },
  { "duria.de", true },
  { "duriaux-dentiste.ch", false },
  { "durin-art.com", true },
  { "durmatest.com", true },
  { "durys.be", true },
  { "dusmomente.com", true },
  { "dustandsand.com", true },
  { "dustplanet.de", true },
  { "dustri.org", true },
  { "dustygroove.com", true },
  { "dustyspokesbnb.ca", true },
  { "dustywilson.com", true },
  { "dutch.desi", true },
  { "dutchessuganda.com", true },
  { "dutchfoodie.nl", true },
  { "dutchforkrunners.com", true },
  { "dutchrank.nl", true },
  { "dutchsailors.com", true },
  { "dutchwanderers.nl", true },
  { "dutchweballiance.nl", true },
  { "dutkoteam.com", true },
  { "dutrac.co.id", true },
  { "dutyfreeinformation.com", true },
  { "duval.paris", true },
  { "duvalo.eu", true },
  { "duvalo.info", true },
  { "duvalo.net", true },
  { "duvalo.org", true },
  { "duvalo.sk", true },
  { "duxi-s-feromonami.ga", true },
  { "dv189.com", true },
  { "dvbris.co.uk", true },
  { "dvbris.com", true },
  { "dvdinmotion.com", true },
  { "dvdland.com.au", true },
  { "dvhosting.be", true },
  { "dvipadmin.com", true },
  { "dvlot.ru", true },
  { "dvnatura.ch", false },
  { "dvorupotocnych.sk", true },
  { "dvwc.org", true },
  { "dvx.cloud", true },
  { "dwgf.xyz", true },
  { "dwi-sued.de", true },
  { "dwood.store", true },
  { "dworzak.ch", true },
  { "dwscdv3.com", true },
  { "dwtm.ch", true },
  { "dwworld.co.uk", true },
  { "dwz-solutions.com", true },
  { "dx-revision.com", true },
  { "dx2o.com", true },
  { "dxgl.info", true },
  { "dxgl.org", true },
  { "dxm.no-ip.biz", true },
  { "dxmpay.com", true },
  { "dxzsj.cn", true },
  { "dybuster.at", true },
  { "dybuster.ch", true },
  { "dybuster.com", true },
  { "dybuster.de", true },
  { "dybuster.es", true },
  { "dybuster.it", true },
  { "dybuster.se", true },
  { "dyeager.org", true },
  { "dyktig.as", true },
  { "dyktig.no", true },
  { "dylancl.cf", true },
  { "dylangattey.com", true },
  { "dylankatz.com", true },
  { "dylanknoll.ca", true },
  { "dylanspcrepairs.com", true },
  { "dylmye.me", false },
  { "dylnuge.com", true },
  { "dym.asia", true },
  { "dym.bz", true },
  { "dym2012.com", true },
  { "dym2013.com", true },
  { "dym2014.com", true },
  { "dym2017.com", true },
  { "dymersion.com", true },
  { "dymfbbs.com", true },
  { "dymmovie.com", true },
  { "dymowski.de", false },
  { "dyn.im", true },
  { "dynaloop.net", false },
  { "dynamicdesignuk.com", true },
  { "dynamicnet.net", false },
  { "dynamics-365.no", true },
  { "dynamics365.no", true },
  { "dynamicsretailnotes.com", true },
  { "dynamictostatic.com", true },
  { "dynamofanforum.de", true },
  { "dynapptic.com", true },
  { "dynastic.co", true },
  { "dynastyarena.com", true },
  { "dynastybullpen.com", true },
  { "dynastycalculator.com", true },
  { "dynastycentral.com", true },
  { "dynastychalkboard.com", true },
  { "dynastyclubhouse.com", true },
  { "dynastycrate.com", true },
  { "dynastyduel.com", true },
  { "dynastyfan.com", true },
  { "dynastygoal.com", true },
  { "dynastylocker.com", true },
  { "dynastyredline.com", true },
  { "dyncdn.me", true },
  { "dyneco.io", true },
  { "dynn.be", false },
  { "dynocc.xyz", true },
  { "dynorphin.com", true },
  { "dynorphins.com", true },
  { "dynts.pro", true },
  { "dynx.pl", true },
  { "dyremyhr.no", true },
  { "dyrenesverden.no", true },
  { "dyrkar.com", true },
  { "dyrstad.net", true },
  { "dyrvigs.de", true },
  { "dyscalculia-blog.com", true },
  { "dysthymia.com", true },
  { "dyxe.me", true },
  { "dyxe.xyz", true },
  { "dyz.pw", true },
  { "dzar.nsupdate.info", true },
  { "dzeina.ch", false },
  { "dzet.de", true },
  { "dziaduch.pl", true },
  { "dziary.com", true },
  { "dziekonski.com", true },
  { "dziscover.com", true },
  { "dziura.me", true },
  { "dziurdzia.pl", true },
  { "dzivniekubriviba.lv", true },
  { "dzndk.com", true },
  { "dznn.nl", true },
  { "dzomo.org", true },
  { "dzsi.bi", false },
  { "dzsibi.com", true },
  { "dzsula.hu", true },
  { "dzu.fund", true },
  { "dzu.me", true },
  { "dzu.works", true },
  { "dzus.tk", true },
  { "dzworld.com", true },
  { "dzyszla.pl", true },
  { "dzytdl.com", true },
  { "e-bikesdirect.co.uk", true },
  { "e-borneoshop.com", true },
  { "e-briancon.com", true },
  { "e-businessexpert.com", true },
  { "e-coexist.com", true },
  { "e-colle.info", true },
  { "e-cottage.com.br", true },
  { "e-diabolo.tk", true },
  { "e-emploi.be", true },
  { "e-enterprise.gov", false },
  { "e-id.ee", true },
  { "e-klempir.cz", true },
  { "e-labo.works", true },
  { "e-lambre.com", true },
  { "e-learningbs.com", true },
  { "e-lifetechnology.com", true },
  { "e-mandataires.fr", true },
  { "e-michiganinsurance.com", true },
  { "e-nanum.kr", true },
  { "e-privat.info", true },
  { "e-ptn.com", true },
  { "e-referendum.cz", true },
  { "e-speak24.pl", true },
  { "e-standardstore.org", true },
  { "e-surety.net", true },
  { "e-sushi.net", true },
  { "e-sw.co.jp", true },
  { "e-teachers.me", true },
  { "e-tech-solution.com", true },
  { "e-tech-solution.net", true },
  { "e-techsolution.com", true },
  { "e-techsolutions.net", true },
  { "e-tonery.cz", true },
  { "e-traceur-france.fr", true },
  { "e-tresor.at", true },
  { "e-tune-mt.net", true },
  { "e-typ.eu", true },
  { "e-verify.gov", true },
  { "e-webos.com", true },
  { "e-worksmedia.com", false },
  { "e.mail.ru", true },
  { "e007.com", true },
  { "e15r.co", true },
  { "e2feed.com", true },
  { "e30.ee", true },
  { "e36533.com", true },
  { "e5tv.hu", true },
  { "e64.com", true },
  { "e6e.io", true },
  { "e7d.io", true },
  { "e7fun.net", true },
  { "e81818.com", true },
  { "e901.com", true },
  { "e965.ru", true },
  { "ea-lateleassistance.com", true },
  { "ea2drocks.com", true },
  { "eac.gov", true },
  { "eacero.com", true },
  { "ead-italia.it", true },
  { "eagle.net", true },
  { "eagleindustriesltd.com", true },
  { "eaglemessaging.com", true },
  { "eaglemoe.com", true },
  { "eaglenation.net", true },
  { "eagletechz.com.br", true },
  { "eaglewreck.info", true },
  { "eaglexiang.org", true },
  { "eagleyecs.com", true },
  { "eaimty.com", true },
  { "ealev.de", true },
  { "eallion.com", true },
  { "eapestudioweb.com", true },
  { "earfolds.com", true },
  { "earl.org.uk", true },
  { "earlybetter.com", true },
  { "earlyyearshub.com", true },
  { "earmarks.gov", true },
  { "earn.com", true },
  { "earn99.co", true },
  { "earningthatis.tk", true },
  { "earthava.com", true },
  { "earthcorporation.cf", true },
  { "earthsolidarity.org", true },
  { "earthspundesigns.com", true },
  { "earthsystemprediction.gov", true },
  { "earticleblog.com", true },
  { "easez.net", true },
  { "eashwar.com", true },
  { "eason-yang.com", true },
  { "eastarm.net", true },
  { "eastbaycontractor.com", true },
  { "eastblue.org", true },
  { "easterncapebirding.co.za", true },
  { "eastlothianbouncycastles.co.uk", true },
  { "eastmaintech.com", true },
  { "eastmanbusinessinstitute.com", true },
  { "eastmidlandsstargazers.org.uk", true },
  { "eastnorschool.co.uk", true },
  { "eastping.com", true },
  { "eastplan.co.kr", true },
  { "eastsidecottages.co.uk", true },
  { "eastsideroofingcontractor.com", true },
  { "eaststudios.net", true },
  { "eastwesttmc.com.au", true },
  { "eastwind.cloud", true },
  { "eastyorkshirebuses.co.uk", true },
  { "easy-rpg.org", false },
  { "easy-vn.com", true },
  { "easy2bathe.co.uk", true },
  { "easyadsnbanners.tk", false },
  { "easycoding.org", true },
  { "easyconstat.com", true },
  { "easycosmetic.ch", true },
  { "easydumpsterrental.com", true },
  { "easyeditcms.com", true },
  { "easyeigo.com", true },
  { "easyfiles.ch", true },
  { "easyfiles.gq", true },
  { "easyhaul.com", true },
  { "easylogics.tk", true },
  { "easynm.cn", true },
  { "easypay.bg", true },
  { "easypayments.pro", true },
  { "easypets.fr", true },
  { "easyproperty.com", true },
  { "easypv.ch", true },
  { "easyroad.fr", true },
  { "easyshare.gq", true },
  { "easyslide.be", true },
  { "easystore.co", true },
  { "easytechguides.com", true },
  { "easytube.ga", true },
  { "easyweenies.com", true },
  { "easywin.ml", true },
  { "easywio.com", true },
  { "eat-sleep-code.com", true },
  { "eatery.co.il", true },
  { "eatmebudapest.hu", true },
  { "eaton-works.com", true },
  { "eatry.io", true },
  { "eatsleeprepeat.net", true },
  { "eatson.com", true },
  { "eatz-and-treatz.com", true },
  { "eaucube.com", true },
  { "eaugenethomas.cf", true },
  { "eauxdespleiades.ch", false },
  { "eazyproject.net", true },
  { "eb-net.de", true },
  { "eb7.jp", true },
  { "ebaby.bg", true },
  { "ebankcbt.com", true },
  { "ebanking.indovinabank.com.vn", true },
  { "ebankingabersicher.ch", true },
  { "ebankingbutsecure.ch", true },
  { "ebankingentoutesecurite.ch", true },
  { "ebankingmasicuro.ch", true },
  { "ebas.ch", true },
  { "ebashim.tk", true },
  { "ebataw.com", true },
  { "ebaymotorssucks.com", true },
  { "ebenda.org", true },
  { "ebenezersbarnandgrill.com", true },
  { "ebermannstadt.de", false },
  { "ebertlang.com", true },
  { "eberwe.in", true },
  { "ebest.co.jp", true },
  { "ebiografia.com", true },
  { "ebisi.be", true },
  { "ebizarts.com", true },
  { "eblog.cf", true },
  { "eblog.com.au", true },
  { "eblog.ink", true },
  { "eboardsolutions.com", true },
  { "eboek.info", true },
  { "ebola-hosting.cz", true },
  { "ebonyriddle.com", true },
  { "eboocker.de", true },
  { "ebookabc.tk", true },
  { "ebooki.eu.org", true },
  { "ebooknetworking.net", true },
  { "ebooks-pdf.cf", true },
  { "eboutic.ch", true },
  { "eboyer.com", true },
  { "ebpglobal.com", false },
  { "ebrnd.de", true },
  { "ebteam.ir", true },
  { "eburg.ml", true },
  { "ebuyclub.com", true },
  { "ec-current.com", true },
  { "ec.mine.nu", true },
  { "ecalculator.org", true },
  { "ecardoo.com", true },
  { "ecardoo.de", true },
  { "ecardoo.net", true },
  { "ecardoo.org", true },
  { "ecbt.co.il", true },
  { "ecchidreams.com", true },
  { "ecco-verde.com", false },
  { "ecdn.cz", true },
  { "ecfnorte.com.br", true },
  { "echarity.ae", true },
  { "echarlascartas.es", true },
  { "echatta.net", true },
  { "echatta.org", true },
  { "echidna-rocktools.eu", true },
  { "echo-in.info", true },
  { "echo-security.co", true },
  { "echo.co.uk", true },
  { "echoanalytics.com", true },
  { "echobridgepartners.com", true },
  { "echodio.com", true },
  { "echofoxtrot.co", true },
  { "echoit.net", true },
  { "echoit.net.au", true },
  { "echoit.services", true },
  { "echopaper.com", true },
  { "echorecovery.org", true },
  { "echosim.io", true },
  { "echosixmonkey.com", true },
  { "echosnature.fr", true },
  { "echosystem.fr", true },
  { "echoworld.ch", false },
  { "echternach-immobilien.de", true },
  { "ecigfind.com", true },
  { "ecir.pro", true },
  { "ecir.ru", true },
  { "ecirtam.net", true },
  { "eciso.io", true },
  { "eckel.co", true },
  { "eckstein.tech", true },
  { "eclectiv.com", true },
  { "eclipse.ws", true },
  { "eclipseforum.tk", true },
  { "eclypsium.io", false },
  { "ecmatching.com", true },
  { "ecmeshltd.com", true },
  { "ecnetworker.com", true },
  { "eco-derattizzazione.it", true },
  { "eco-flowplumbing.com", true },
  { "eco-repair.be", true },
  { "eco-solu.co.jp", true },
  { "eco-work.it", true },
  { "eco2u.ru", true },
  { "ecobagsmauritius.com", true },
  { "ecobee.com", false },
  { "ecobergerie.fr", true },
  { "ecobin.nl", true },
  { "ecoccinelles.ch", false },
  { "ecoccinelles.com", false },
  { "ecococon.fr", true },
  { "ecocreativity.org", true },
  { "ecodedi.com", true },
  { "ecodesign-labo.jp", true },
  { "ecodesigns.nl", true },
  { "ecodigital.social", true },
  { "ecofabrica.com.br", true },
  { "ecofac-bs.com", true },
  { "ecogen.com.au", true },
  { "ecogen.net.au", true },
  { "ecoheatcool.co.uk", true },
  { "ecohostingservices.uk", true },
  { "ecole-attalens.ch", false },
  { "ecoledusabbat.org", false },
  { "ecolemathurincordier.com", false },
  { "ecombustibil.ro", true },
  { "ecomia.dk", true },
  { "ecomycie.com", true },
  { "economiafinanzas.com", true },
  { "economias.pt", true },
  { "economicinclusion.gov", true },
  { "economics-colleges.com", true },
  { "economie2.alsace", true },
  { "economiefidu.ch", false },
  { "economies.ch", false },
  { "econsorzio.com", true },
  { "econsumer.gov", true },
  { "ecorp.cc", true },
  { "ecos-ev.de", true },
  { "ecos.srl", true },
  { "ecoshare.info", true },
  { "ecosm.com.au", true },
  { "ecosound.ch", false },
  { "ecostruxureit.com", true },
  { "ecosystem.atlassian.net", true },
  { "ecosystemmanager-uat1.azurewebsites.net", true },
  { "ecoterramedia.com", true },
  { "ecotransfer.bio", true },
  { "ecotur.org", true },
  { "ecovision.com.br", true },
  { "ecpannualmeeting.com", true },
  { "ecpic.gov", true },
  { "ecr-test-backoffice-app.azurewebsites.net", true },
  { "ecr-test-partnapp.azurewebsites.net", true },
  { "ecrandouble.ch", false },
  { "ecriminalrecords.com", true },
  { "ecrownoffire.com", true },
  { "ecsupplyinc.com", true },
  { "ecuadorbienesraices.com", true },
  { "ecuatask.com", true },
  { "ecuteam.com", true },
  { "ecxforum.com", true },
  { "ed-studios.tk", true },
  { "ed.gs", true },
  { "edanni.io", true },
  { "edapt.org.uk", true },
  { "edas.info", false },
  { "edcaptain.com", true },
  { "edd-miles.com", true },
  { "eddesign.ch", true },
  { "eddmil.es", true },
  { "eddokloosterman.com", true },
  { "eddy.ee", true },
  { "eddyn.net", true },
  { "edeals.co", true },
  { "edeals.co.com", true },
  { "edeals.com.co", true },
  { "edeca.net", true },
  { "edefrutos.me", true },
  { "edehsa.com", true },
  { "edelweiss-pinzolo.com", true },
  { "eden-eu.com", true },
  { "eden-project-insight.tk", true },
  { "eden.co.uk", true },
  { "edenmal.net", true },
  { "edenming.info", true },
  { "edesseglabor.hu", true },
  { "edfinancial.com", true },
  { "edgarz.tk", true },
  { "edgefantasy.com", true },
  { "edgeservices.co.uk", true },
  { "edgetalk.net", true },
  { "edh.email", true },
  { "edhesive.com", true },
  { "edholm.pub", true },
  { "edi-gate.com", true },
  { "edi-gate.de", true },
  { "edibarcode.com", true },
  { "edicct.com", true },
  { "edify.space", true },
  { "edilservizi.it", true },
  { "edilservizivco.it", true },
  { "edinburghsportsandoutdoorlearning.com", true },
  { "edincmovie.com", true },
  { "edisa.xyz", true },
  { "ediscomp.sk", true },
  { "edisonlee55.com", true },
  { "edisonluiz.com", true },
  { "edisonnissanparts.com", true },
  { "edit.co.uk", true },
  { "edit.yahoo.com", false },
  { "edited.de", true },
  { "edition-bambou.com", false },
  { "edition-sonblom.de", true },
  { "editionsnoiretrouge.com", true },
  { "edlinger.at", true },
  { "edlinger.mobi", true },
  { "edlinus.cn", true },
  { "edmm.jp", true },
  { "edmodo.com", true },
  { "edmoncu.com", true },
  { "edmundcelis.com", true },
  { "edp-collaborative.com", true },
  { "edplan.io", true },
  { "edragneainpuscarie.ro", true },
  { "edrosd.cf", true },
  { "edsby.com", true },
  { "edservicing.com", true },
  { "edshogg.co.uk", true },
  { "edsinet.com", false },
  { "edsm.net", true },
  { "edstem.org", true },
  { "edstep.com", true },
  { "edtech-hub.com", true },
  { "edtech.ee", true },
  { "edtechwebb.com", true },
  { "edu-kingdom.com", true },
  { "edu6.cloud", true },
  { "eduart.tk", true },
  { "edubase.net", true },
  { "edubras.com.br", true },
  { "educa2.es", true },
  { "educacionvirtual.com.ar", true },
  { "educaestado.com", true },
  { "educatek.es", true },
  { "educateyourskin.com", true },
  { "educationevolving.org", true },
  { "educationfutures.com", true },
  { "educationmalaysia.co.uk", true },
  { "educative.io", true },
  { "educativetech.com", true },
  { "eductf.org", true },
  { "edugundavetiyesi.com", true },
  { "eduid.se", false },
  { "edukador.com", true },
  { "edumundo.nl", true },
  { "edunet.gq", true },
  { "eduroam.no", true },
  { "eduroam.uy", true },
  { "edusanjal.com", true },
  { "eduschedule.org", true },
  { "edusercontent.com", true },
  { "eduvpn.no", true },
  { "eduxpert.in", true },
  { "edv-kohls.de", true },
  { "edv-lehrgang.de", true },
  { "edv-ringhofer.de", true },
  { "edv-schmittner.de", true },
  { "edvgarbe.de", true },
  { "edvmesstec.de", true },
  { "edwardsgrounds.co.uk", true },
  { "edwardsnowden.com", true },
  { "edwardspeyer.com", true },
  { "edwellbrook.com", true },
  { "edwinmattiacci.com", true },
  { "edwinyrkuniversity.de", true },
  { "edxg.de", false },
  { "edxn.de", true },
  { "edyhenry.tk", true },
  { "edyou.eu", true },
  { "edyou.org", true },
  { "edzilla.info", true },
  { "ee00228.com", false },
  { "ee362.com", true },
  { "ee367.com", true },
  { "ee371.com", true },
  { "ee372.com", true },
  { "ee373.com", true },
  { "ee396.com", true },
  { "ee397.com", true },
  { "ee575.com", true },
  { "ee735.com", true },
  { "ee736.com", true },
  { "ee951.com", true },
  { "ee973.com", true },
  { "eebt.hu", true },
  { "eelcapone.nl", true },
  { "eellak.gr", true },
  { "eelsden.net", true },
  { "eelzak.nl", true },
  { "eemcevn.com", true },
  { "eentertain.com.my", true },
  { "eentweevijf.be", true },
  { "eenvren.com", true },
  { "eenvxing.com", true },
  { "eer.io", true },
  { "eerstejaarsweekend.nl", true },
  { "eery.de", true },
  { "eesti.xyz", true },
  { "eet.nu", true },
  { "eewna.org", true },
  { "ef-georgia.org", true },
  { "ef.gy", true },
  { "efaas.nl", true },
  { "efag.com", true },
  { "efcross.com", true },
  { "efeen.nl", true },
  { "eff.org", true },
  { "effdocs.com", true },
  { "effe.ch", false },
  { "effective-altruist.com", true },
  { "effectivecoffee.com", true },
  { "effectivepapers.com", true },
  { "effex.ru", true },
  { "effinfun.com", true },
  { "effortlesshr.com", true },
  { "eficsolar.com", true },
  { "efinity.io", true },
  { "efipsactiva.com", true },
  { "eflorashop.be", true },
  { "eflorashop.ch", true },
  { "eflorashop.co.uk", true },
  { "eflorashop.com", true },
  { "eflorashop.de", true },
  { "eflorashop.es", true },
  { "eflorashop.fr", true },
  { "eflorashop.it", true },
  { "eflorashop.mx", true },
  { "eflorashop.net", true },
  { "eflorashop.us", true },
  { "efmcredentialing.org", true },
  { "efoood.org", true },
  { "efreet.xyz", true },
  { "eft.boutique", true },
  { "eftopia.org", true },
  { "egablo.black", true },
  { "egarden.it", true },
  { "egb.at", false },
  { "egbc.ca", true },
  { "egeozcan.com", true },
  { "eges.eu", true },
  { "egg-ortho.ch", true },
  { "eggblast.com", true },
  { "eggert.org", false },
  { "egglestonyouthcenter.org", true },
  { "egiftcards.be", true },
  { "egles.eu", true },
  { "eglisedenantes.fr", true },
  { "ego4u.com", true },
  { "ego4u.de", true },
  { "egold-keeper.com", true },
  { "egomaniaque.tk", true },
  { "egonix.de", true },
  { "egov4.ch", true },
  { "egovernment-podcast.com", true },
  { "egres.xyz", true },
  { "egrojsoft.info", true },
  { "egrp365.ru", true },
  { "egw-ceramica.de", true },
  { "egweb.tv", true },
  { "ehaccp.it", true },
  { "ehandel.com", true },
  { "ehazi.hu", true },
  { "ehb-sec-ward.be", true },
  { "ehbsecuritydavy.be", true },
  { "ehbssl.com", true },
  { "ehcommerce.com", true },
  { "ehcommerce.org", true },
  { "eheliche-disziplin.schule", true },
  { "ehipaa.com", true },
  { "ehlacademy.org", true },
  { "ehmsen.nu", true },
  { "ehmtheblueline.com", true },
  { "ehne.de", true },
  { "ehomusicgear.com", true },
  { "ehorizon.jp", true },
  { "ehrenburg.info", true },
  { "ehub.cz", true },
  { "ehub.hu", true },
  { "ehub.pl", true },
  { "ehub.sk", true },
  { "eichel.eu", true },
  { "eichinger-stelzl.de", true },
  { "eichler.work", true },
  { "eickemeyer.nl", true },
  { "eickhof.co", true },
  { "eickhof.us", true },
  { "eickhofcolumbaria.com", true },
  { "eidelpes.info", true },
  { "eigenpul.se", true },
  { "eigenpulse.com", true },
  { "eighty-aid.com", true },
  { "eightyfour.ca", true },
  { "eightysoft.de", true },
  { "eigpropertyauctions.co.uk", true },
  { "eihaikyo.com", true },
  { "eikentafels.nl", true },
  { "eikounoayumi.jp", true },
  { "eilhan.com", true },
  { "eimacs.com", true },
  { "eimmigration.com", true },
  { "einaros.is", true },
  { "eine-andere-welt.org", true },
  { "einfachbahn.de", true },
  { "einheft.info", true },
  { "einheizpreis.de", true },
  { "einkaufi.de", true },
  { "einrichtwerk.de", true },
  { "einrichtwerk.shop", true },
  { "einsatzstellenverwaltung.de", true },
  { "einser.com", true },
  { "einsteinathome.org", true },
  { "einsurancetraining.com", true },
  { "eintageinzug.de", true },
  { "eintragsservice24.de", true },
  { "eion.io", true },
  { "eioperator.com", false },
  { "eirastudios.co.uk", false },
  { "eirb.fr", true },
  { "eirik.eu", true },
  { "eisaev.ru", true },
  { "eisen-biomed.ch", true },
  { "eisenbahnfreunde-lengerich.de", true },
  { "eisenhowerlibrary.gov", true },
  { "eiskratzer-bedrucken.de", true },
  { "eiti.online", true },
  { "eiyoushi-shigoto.com", true },
  { "ej.uz", true },
  { "ejdv-anmeldung.de", true },
  { "ejelectrical-qld.com.au", true },
  { "ejkhosting.nl", true },
  { "ejkmedia.nl", true },
  { "ejkmuseum.nl", true },
  { "ejknet.nl", true },
  { "ejkwebdesign.nl", true },
  { "ek-networks.de", false },
  { "ekaigotenshoku.com", true },
  { "ekalisch.de", true },
  { "ekaplast.com.pl", true },
  { "ekati.ru", true },
  { "ekb-avia.ru", true },
  { "ekd.de", true },
  { "ekedc.com", true },
  { "ekedp.com", true },
  { "ekimma.com", true },
  { "eklepka.com", true },
  { "eklitzke.org", true },
  { "ekocleaningllc.com", true },
  { "ekokontakt.cz", true },
  { "ekonbenefits.com", true },
  { "ekostecki.de", true },
  { "ekouniejow.pl", true },
  { "ekpj.jp", true },
  { "ekranos.me", true },
  { "ekre.club", true },
  { "eksisozluk.com", true },
  { "ekspoint-mods.ru", true },
  { "ekvastra.in", true },
  { "ekyu.moe", true },
  { "ekz-crosstour.ch", true },
  { "ekzarta.ru", true },
  { "ekzcrosstour.ch", true },
  { "el-cell.com", true },
  { "el-hossari.com", true },
  { "el-news.de", true },
  { "elaboratefiction.com", true },
  { "eladgames.com", true },
  { "eladlak-ingatlan.com", true },
  { "elagplus.com", true },
  { "elainerock.com", true },
  { "elainesearer.com", true },
  { "elaon.de", true },
  { "elars.de", true },
  { "elarvee.xyz", true },
  { "elasticshift.com", true },
  { "elb500ttl.nl", true },
  { "elbetech.net", true },
  { "elblogdegoyo.mx", true },
  { "elbohlyart.com", true },
  { "elburgozagalicos.com", true },
  { "elcambiador.es", true },
  { "elcin.tk", true },
  { "eldapoint.co.uk", true },
  { "eldercare.gov", true },
  { "elderjustice.gov", true },
  { "eldertons.co.uk", true },
  { "eldevo.com", true },
  { "eldoradocylinders.com", true },
  { "eldrid.ge", true },
  { "eldritchfiction.net", true },
  { "electerious.com", true },
  { "electionsbycounty.com", true },
  { "electionsdatabase.com", true },
  { "electr0sheep.com", true },
  { "electragirl.com", true },
  { "electras.cf", true },
  { "electric-vault.co.uk", true },
  { "electricagoura.com", true },
  { "electricagourahills.com", true },
  { "electrical-schools.com", true },
  { "electricalagoura.com", true },
  { "electricalagourahills.com", true },
  { "electricalcalabasas.com", true },
  { "electricalcamarillo.com", true },
  { "electricalconejovalley.com", true },
  { "electricaldosvientos.com", true },
  { "electricalfencingbedfordview.co.za", true },
  { "electricalfencingedenvale.co.za", true },
  { "electricalhiddenhills.com", true },
  { "electricallakesherwood.com", true },
  { "electricalmalibu.com", true },
  { "electricalmoorpark.com", true },
  { "electricalnewburypark.com", true },
  { "electricaloakpark.com", true },
  { "electricalsimivalley.com", true },
  { "electricalthousandoaks.com", true },
  { "electricalwestlakevillage.com", true },
  { "electriccalabasas.com", true },
  { "electriccamarillo.com", true },
  { "electriccitysf.com", true },
  { "electricconejovalley.com", true },
  { "electricdosvientos.com", true },
  { "electricfencealberton.co.za", true },
  { "electricfenceboksburg.co.za", true },
  { "electricfencemidrand.co.za", true },
  { "electricfenceroodepoort.co.za", true },
  { "electricfencingballito.co.za", true },
  { "electricfencinggillitts.co.za", true },
  { "electricfencinghillcrest.co.za", true },
  { "electricfencingkloof.co.za", true },
  { "electricfencingpinetown.co.za", true },
  { "electricgatemotorgermiston.co.za", true },
  { "electricgatemotorglenvista.co.za", true },
  { "electricgatemotorrandburg.co.za", true },
  { "electricgatemotorsballito.co.za", true },
  { "electricgatemotorsberea.co.za", true },
  { "electricgatemotorsbluff.co.za", true },
  { "electricgatemotorskemptonpark.co.za", true },
  { "electricgatemotorsqueensburgh.co.za", true },
  { "electricgatemotorsroodepoort.co.za", true },
  { "electricgatemotorsumhlanga.co.za", true },
  { "electrichiddenhills.com", true },
  { "electrichome.fr", true },
  { "electrician-umhlangaridge.co.za", true },
  { "electricianagoura.com", true },
  { "electricianagourahills.com", true },
  { "electriciancalabasas.com", true },
  { "electriciancamarillo.com", true },
  { "electricianconejovalley.com", true },
  { "electriciandosvientos.com", true },
  { "electricianhiddenhills.com", true },
  { "electriciankemptonpark24-7.co.za", true },
  { "electricianlakesherwood.com", true },
  { "electricianlalucia.co.za", true },
  { "electricianmalibu.com", true },
  { "electricianmoorpark.com", true },
  { "electriciannewburypark.com", true },
  { "electricianoakpark.com", true },
  { "electriciansimivalley.com", true },
  { "electricianthousandoaks.com", true },
  { "electricianwestlakevillage.com", true },
  { "electricimagination.co.uk", true },
  { "electriclakesherwood.com", true },
  { "electricmalibu.com", true },
  { "electricmoorpark.com", true },
  { "electricnewburypark.com", true },
  { "electricoakpark.com", true },
  { "electricsimivalley.com", true },
  { "electricthousandoaks.com", true },
  { "electricwestlakevillage.com", true },
  { "electro-pak.com.pk", true },
  { "electrocardiographe.net", true },
  { "electroforum.tk", true },
  { "electrolivefest.spb.ru", true },
  { "electromagnetism.gq", true },
  { "electronic-ignition-system.com", true },
  { "electronicafacil.net", true },
  { "electronicayseguridadmonserrate.com", true },
  { "electronicfasteners.com", false },
  { "electronicssrit.tk", true },
  { "electroniko.cf", true },
  { "electrostatics.com", true },
  { "electrotainment.com", true },
  { "electroworld.cz", true },
  { "electrum.org", true },
  { "elegance-sm.com", true },
  { "eleganceperfumes.com.br", true },
  { "elegantlatex.tk", true },
  { "eleicoes2014.com.br", true },
  { "eleicoes2016.com.br", true },
  { "eleicoes2018.com", true },
  { "elejordemarketingconsultancy.com", true },
  { "elekharris.com", true },
  { "elektrische-zahnbuerste24.de", true },
  { "elektro-adam.de", true },
  { "elektro-diehm.de", true },
  { "elektro-doerr.com", true },
  { "elektro-hammes.net", true },
  { "elektro-hofmann-gmbh.de", true },
  { "elektro-hornetz.de", true },
  { "elektro-kahlen.de", true },
  { "elektro-koehl.de", true },
  { "elektro-liebeskind.de", true },
  { "elektro-metz.de", true },
  { "elektro-pfeiffer.de", true },
  { "elektro-praha10.cz", true },
  { "elektro-rossbach.de", true },
  { "elektro-roth.de", true },
  { "elektro-stock.de", true },
  { "elektro-woerdehoff.de", true },
  { "elektrobusch.com", true },
  { "elektrofinke.de", true },
  { "elektrokarges.de", true },
  { "elektrometz.de", true },
  { "elektronickakancelar.cz", true },
  { "elektropartner.nu", true },
  { "elektropost.org", true },
  { "elektrotango.tk", true },
  { "elektrotechnik-heisel.de", true },
  { "elektrotechnik-kaetzel.de", true },
  { "elektrownie-tanio.net", true },
  { "elemental.software", true },
  { "elementalsoftware.net", true },
  { "elementalsoftware.org", true },
  { "elementarewatson.it", true },
  { "elementarty.com", true },
  { "elementarywave.com", true },
  { "elementblend.com", true },
  { "elements.guide", true },
  { "elementshop.co.uk", true },
  { "elena-baykova.ru", true },
  { "elenatranslations.nl", true },
  { "elenta.lt", true },
  { "elephantia.cf", true },
  { "elephants.net", true },
  { "elephpant.cz", true },
  { "elepover.com", true },
  { "eletesstilus.hu", true },
  { "eletminosegert.ro", true },
  { "eletor.com", true },
  { "eletor.pl", true },
  { "eletrochape.com.br", true },
  { "elettricista-roma.it", true },
  { "elettricista-roma.org", true },
  { "elettricisti.roma.it", true },
  { "elettrodomestici.roma.it", true },
  { "eleusis-zur-verschwiegenheit.de", true },
  { "elevationtech.co.za", true },
  { "elevatoraptitudetest.com", true },
  { "elexel.ru", true },
  { "elexprimidor.com", true },
  { "elexwong.com", true },
  { "elfe.de", true },
  { "elfnon.com", true },
  { "elforno.gr", true },
  { "elfring.eu", true },
  { "elfussports.com", true },
  { "elgalponazo.com.ar", true },
  { "elglobo.com.mx", false },
  { "elgosblanc.com", true },
  { "elgrecohotel.gr", true },
  { "elgringosrentals.com", true },
  { "elguadia.faith", true },
  { "elguillatun.cl", true },
  { "elhamadimi.com", true },
  { "elhorizontal.com", true },
  { "elhossari.com", true },
  { "elian-art.de", true },
  { "eliaskordelakos.com", true },
  { "eliasojala.me", true },
  { "eliasong.com", true },
  { "eliaswendt.com", true },
  { "eliaswendt.de", true },
  { "elibom.com", true },
  { "elie.net", true },
  { "elifesciences.org", true },
  { "eligibilis.com", true },
  { "eligible.com", true },
  { "eligibleapi.com", true },
  { "eligrey.com", true },
  { "elijahgrey.com", true },
  { "elikers.ml", true },
  { "elinevanhaaften.nl", true },
  { "elinvention.ovh", true },
  { "eliott.be", true },
  { "elipsyum.com", true },
  { "elisa.ee", false },
  { "elisabeth-kostecki.de", true },
  { "elisabeth-strunz.de", true },
  { "elisabethcasanova.ch", true },
  { "elisabethkostecki.de", true },
  { "elisabethrene.com", true },
  { "elite-design.tk", true },
  { "elite-nakhodka.tk", true },
  { "elite-porno.ru", true },
  { "elite-tools.tk", true },
  { "elite12.de", true },
  { "elitebasementsohio.com", true },
  { "elitebouncingfun.com", true },
  { "elitedns.info", true },
  { "elitegameservers.net", true },
  { "elitel.nl", true },
  { "elitepainmanagement.com", true },
  { "elitsa.gr", true },
  { "elixi.re", true },
  { "elixir.bzh", true },
  { "elizabethbuitrago.com", true },
  { "elizabethrominski.com", true },
  { "elizeugomes.com.br", true },
  { "eljef.me", true },
  { "elkim.cz", true },
  { "elkoy.org", true },
  { "ell888.com", true },
  { "ella-kwikmed.com", false },
  { "ellak.gr", true },
  { "ellatotal.com", true },
  { "elldus.de", true },
  { "elle-weine.de", true },
  { "ellegaard.dk", true },
  { "ellemental.me", true },
  { "ellencorddry.com", true },
  { "ellevit.ch", false },
  { "elliesbouncers.co.uk", true },
  { "elliot.cat", true },
  { "elliquiy.com", true },
  { "ellisamusements.co.uk", true },
  { "ellisleisure.co.uk", true },
  { "ellsinger.me", true },
  { "elmermx.ch", true },
  { "elmresan.ir", true },
  { "elnan.do", true },
  { "elo-forum.org", true },
  { "elo-rocket.com", true },
  { "elodrias.de", true },
  { "elon-musk.ml", true },
  { "elonaspitze.de", true },
  { "elosuite.com", true },
  { "elpo.net", true },
  { "elpoderdelespiritu.org", true },
  { "elprint.com", true },
  { "elradix.be", true },
  { "elranchofeliz.org", true },
  { "elri.blog", true },
  { "elriacdn.com", true },
  { "elrinconderovica.com", true },
  { "elsanoguera.com", true },
  { "elshou.com", true },
  { "elsignificadodesonar.com", true },
  { "elskling.no", true },
  { "elstopstelten.nl", false },
  { "elsuccionador.com", true },
  { "elsvanderlugt.nl", true },
  { "eltair.com", true },
  { "eltern-verein.ch", true },
  { "elternbeiratswahl.online", true },
  { "elternforum-birmensdorf.ch", true },
  { "elternverein-utzenstorf.ch", true },
  { "eltip.click", true },
  { "eltlaw.com", true },
  { "eluhome.de", true },
  { "eluvio.com", true },
  { "elvendrim.xyz", true },
  { "elviraszabo.com", true },
  { "elvispresley.net", true },
  { "elvn.tokyo", false },
  { "elwave.org", true },
  { "elwebkala.com", true },
  { "elwix.com", true },
  { "elyasweb.com", true },
  { "elycoin.io", true },
  { "elysiandigital.co", true },
  { "elysiria.fr", true },
  { "elysiumware.com", true },
  { "em-biotek.cz", true },
  { "emaging-productions.fr", true },
  { "emaging.fr", true },
  { "emailconfiguration.com", true },
  { "emailhunter.co", true },
  { "emailmeform.com", true },
  { "emailprivacytester.com", true },
  { "emailtemporal.org", false },
  { "emaily.eu", true },
  { "emanol.co.uk", true },
  { "emanuel.photography", true },
  { "emanuelduss.ch", true },
  { "emanueleanastasio.com", true },
  { "emanuelemazzotta.com", true },
  { "emarketingmatters.com", true },
  { "emasex.es", true },
  { "embassycargo.eu", true },
  { "emberlife.com", true },
  { "embodiaacademy.com", true },
  { "embodiaapp.com", true },
  { "embox.net", true },
  { "embracecontext.com", true },
  { "embraceni.org", true },
  { "embroideryexpress.co.uk", true },
  { "embsaypreschool.co.uk", true },
  { "emby.cloud", true },
  { "emcspotlight.com", true },
  { "emdrupholm.dk", true },
  { "emecew.com", true },
  { "emeliefalk.se", true },
  { "emeliemai.com", true },
  { "ememsei.com", true },
  { "emeraldcbdshop.com", false },
  { "emeraldcityswagger.com", true },
  { "emeraldislerealty.com", true },
  { "emergency-federal-register.gov", true },
  { "emergencyessay.com", true },
  { "emergencyshutoff.com", true },
  { "emergesydney.com.au", true },
  { "emersoncanada.ca", true },
  { "emex.ro", true },
  { "emi.im", true },
  { "emielraaijmakers.nl", true },
  { "emigratieplanner.com", true },
  { "emil-dein-baecker.de", true },
  { "emil-reimann.com", true },
  { "emil.click", true },
  { "emil.one", true },
  { "emiliendevos.be", true },
  { "emilio.media", true },
  { "emiliops.com", true },
  { "emilong.com", true },
  { "emils-1910.de", true },
  { "emilstahl.com", true },
  { "emilstahl.dk", true },
  { "emilvarga.com", true },
  { "emily.moe", true },
  { "emilybellydance.com.au", true },
  { "emilyjohnson.ga", true },
  { "emilypennock.com", true },
  { "emirabiz.com", false },
  { "emirefek.net", true },
  { "emirichardson.com", true },
  { "emisia.com", true },
  { "emkode.pl", true },
  { "emkrivoy.com", true },
  { "emmagarland.com", true },
  { "emmagraystore.com", true },
  { "emmaliddell.com", true },
  { "emmastree.com", true },
  { "emme3abbigliamento.it", true },
  { "emmiwelentain.com", true },
  { "emmynet.de", true },
  { "emobilityforum.org", true },
  { "emoforum.tk", true },
  { "emoji.bzh", false },
  { "emolafarm.com", true },
  { "emond-usedcars.net", false },
  { "emotionalmente.com", true },
  { "emotive.productions", true },
  { "emoxie.com", true },
  { "empathogen.com", true },
  { "empathogens.com", true },
  { "empathy.ca", true },
  { "empatico.org", true },
  { "empatico.xyz", true },
  { "emperola.com", true },
  { "emperor-penguin.com", true },
  { "emperor-penguins.com", true },
  { "empherino.net", true },
  { "empicargo.com", true },
  { "empire-univ.com", true },
  { "emploi-collectivites.fr", true },
  { "employeeexpress.gov", true },
  { "employeemanual.com.au", true },
  { "employer.gov", true },
  { "employer.guru", true },
  { "employer411.com", true },
  { "employment-applicant.com", true },
  { "emporikonathenshotel.com", true },
  { "emporiodascalcinhas.com.br", true },
  { "emporiodosperfumes.com.br", true },
  { "emporioonline.com.br", true },
  { "emporiopatanegra.com.br", true },
  { "emporioviverbem.com.br", false },
  { "empower.net", true },
  { "empowerdb.com", true },
  { "empoweren.com", true },
  { "emprechtinger.com", true },
  { "emprego.pt", true },
  { "empregosrj.com", true },
  { "emptybox.org", true },
  { "empyrean-advisors.com", true },
  { "emrah.io", true },
  { "emrahcinik.com", true },
  { "emreaydinfan.tk", true },
  { "emresaglam.com", true },
  { "emrullahsahin.com", true },
  { "ems.gov", true },
  { "emsa-casm.ca", true },
  { "emulator.ml", true },
  { "emultiagent.pl", true },
  { "emvoice.net", true },
  { "emvoiceapp.com", true },
  { "emw3.com", true },
  { "emyr.net", true },
  { "emyself.org", true },
  { "emzi0767.com", true },
  { "en-booster.jp", true },
  { "en-crypt.me", true },
  { "en-este.link", true },
  { "en-maktoob.search.yahoo.com", false },
  { "en0.io", true },
  { "en4rab.co.uk", true },
  { "enaah.de", true },
  { "enalean.com", true },
  { "enamae.net", true },
  { "enanto.com", true },
  { "enbecom.net", true },
  { "enbulleiugnen.com", true },
  { "encfs.win", true },
  { "encircleapp.com", true },
  { "encnet.de", true },
  { "encode.host", true },
  { "encodecloud.net", true },
  { "encoderx.uk", true },
  { "encontra-me.org", true },
  { "encoro.org", true },
  { "encountercss.com", true },
  { "encouragemarketing.com", true },
  { "encredible.de", false },
  { "encredible.org", false },
  { "encretplomb.ch", false },
  { "encrypted.google.com", true },
  { "encryptmy.site", true },
  { "encryptmysite.net", true },
  { "encuentraprecios.es", true },
  { "encycarpedia.com", true },
  { "encyclopedia-titanica.org", true },
  { "endbox.email", true },
  { "endeal.nl", true },
  { "ender.co.at", true },
  { "ender.fr", true },
  { "enderbycamping.com", true },
  { "enderle.cloud", true },
  { "endingthedocumentgame.gov", true },
  { "endlessdiy.ca", true },
  { "endlessvideo.com", true },
  { "endlesswebsite.tk", true },
  { "endoftenancycleaninglondon.co.uk", true },
  { "endoftennancycleaning.co.uk", true },
  { "endpointsystems.com", true },
  { "enduranceday.be", true },
  { "endurogp.org", true },
  { "endustriyelfirinlar.com", true },
  { "endviolence.gc.ca", true },
  { "endzeit-architekten.com", false },
  { "eneamarcantoni.com", true },
  { "eneko.com", true },
  { "energie-sante.ch", false },
  { "energiekeurplus.nl", true },
  { "energija-visiems.lt", true },
  { "energy-drink-magazin.de", true },
  { "energy-healings.com", true },
  { "energy-in-balance.eu", true },
  { "energy-infra.nl", true },
  { "energy-initiative.com", true },
  { "energyaupair.se", true },
  { "energybank.com.br", true },
  { "energycodes.gov", true },
  { "energydrinkblog.de", true },
  { "energyefficientservices.com", true },
  { "energyelephant.com", true },
  { "energygenie.com.au", true },
  { "energyled.com.br", true },
  { "energysolutionstech.com", true },
  { "energystar.gov", true },
  { "enersolelectrical.com.au", true },
  { "enerte.ru", true },
  { "enerypa.tk", true },
  { "enet-navigator.de", true },
  { "enfantsdelarue.ch", true },
  { "enflow.nl", true },
  { "enforcement-trends-dev.azurewebsites.net", true },
  { "enforcement-trends-test.azurewebsites.net", true },
  { "enforcement-trends.azurewebsites.net", true },
  { "eng-erlangen.de", true },
  { "engagelogic.com", true },
  { "enganches.es", true },
  { "engarde.net", true },
  { "engaugetools.com", true },
  { "engelke-optik.de", true },
  { "engelundlicht.ch", true },
  { "engelwerbung.com", true },
  { "engg.ca", true },
  { "engie-laadpalen.nl", true },
  { "engiedev.net", true },
  { "engima.nl", true },
  { "enginepit.com", true },
  { "enginsight.com", true },
  { "enginx.net", true },
  { "engl-server.de", true },
  { "engl-systems.de", true },
  { "englishbulgaria.net", true },
  { "englishcast.com.br", true },
  { "englishforums.com", true },
  { "englishlol.com", true },
  { "englishphonopass.com", true },
  { "englishstudio.com", true },
  { "englishtofrench.eu", true },
  { "englishtype.com", false },
  { "engvid.com", true },
  { "engweld.co.uk", true },
  { "engym.com.tw", true },
  { "enigma.swiss", false },
  { "enitso.de", true },
  { "enixgaming.com", true },
  { "eniziolab.com", true },
  { "enjin.zone", true },
  { "enjincoin.io", true },
  { "enjinwallet.io", true },
  { "enjinx.cn", true },
  { "enjinx.io", true },
  { "enjoy-drive.com", true },
  { "enjoymondayofficial.com", true },
  { "enjoytech.fr", true },
  { "enlamochiladeadri.com", true },
  { "enlight.no", true },
  { "enlightenedhr.com", true },
  { "enlilrosse.com", true },
  { "enlnf.link", true },
  { "enloestatebank.com", true },
  { "ennea-mediation.fr", true },
  { "enness.co.uk", true },
  { "ennori.jp", true },
  { "enodais.gr", true },
  { "enofmusic.com", true },
  { "enoisdaturma.tk", true },
  { "enorekcah.com", true },
  { "enot32.ru", true },
  { "enotecastore.it", true },
  { "enotefile.com", true },
  { "enpasenerji.com.tr", true },
  { "enquos.com", true },
  { "enrack.tk", true },
  { "enrich.email", true },
  { "enrico-caruso.it", true },
  { "enrique-monroy.tk", true },
  { "enrique.wtf", true },
  { "enriquepiraces.com", true },
  { "enrollapp.com", true },
  { "ensage.io", true },
  { "enscosupply.com", true },
  { "ensemble-rubato.de", true },
  { "ensembling.com", true },
  { "ensley.tech", true },
  { "ensons.de", true },
  { "ensured.com", true },
  { "ensured.nl", true },
  { "ensurtec.com", true },
  { "ent-london.com", true },
  { "entabe.jp", true },
  { "entactogen.com", true },
  { "entactogens.com", true },
  { "enter.eco", true },
  { "entercenter.ru", true },
  { "entersoftsecurity.com", true },
  { "entertainmentblog.tk", true },
  { "entertainmentformitzvahs.com", true },
  { "entheogens.com", true },
  { "enthusiaformazione.com", true },
  { "entradaweb.cl", true },
  { "entrainr.com", true },
  { "entrecieletpierres.com", false },
  { "entrezdansladanse.fr", true },
  { "entropia.de", false },
  { "entropy.su", true },
  { "entrusted.io", true },
  { "entryboss.cc", true },
  { "entrypoint.sh", true },
  { "entwickler.land", true },
  { "enuchi.jp", true },
  { "enuygun.com", true },
  { "envant.co.uk", true },
  { "envescent.com", true },
  { "enviaya.com.mx", true },
  { "envide.no", true },
  { "enviro-umweltservice.de", true },
  { "enviroli.co.uk", true },
  { "enviroli.com", true },
  { "enviroli.org.uk", true },
  { "enviroli.uk", true },
  { "environmental-colleges.com", true },
  { "enviroprobasements.com", true },
  { "envman.io", true },
  { "envoie.moi", true },
  { "envoker.nl", true },
  { "envoyez.moi", true },
  { "enwikipedia.tk", true },
  { "enxadahost.com", true },
  { "enzoic.com", true },
  { "eocservices.co.uk", true },
  { "eoitek.com", true },
  { "eola.co", true },
  { "eon.tech", true },
  { "eonhive.com", true },
  { "eons.io", true },
  { "eooe.me", true },
  { "eoonglobalresources.jp", true },
  { "eopugetsound.org", false },
  { "eos-utvalget.no", true },
  { "eosol.de", true },
  { "eosol.net", true },
  { "eosolutions.co", true },
  { "ep-cortex.com", true },
  { "ep-plus.jp", true },
  { "epa.com.es", true },
  { "epagos.com.ar", true },
  { "epal.pt", true },
  { "epassafe.com", true },
  { "epawnatl.com", true },
  { "epay.bg", true },
  { "epcreport.net", true },
  { "epdeveloperchallenge.com", true },
  { "ephesusbreeze.com", true },
  { "epi-lichtblick.de", true },
  { "epi.one", false },
  { "epic-vistas.com", true },
  { "epic-vistas.de", true },
  { "epicbouncycastles.co.uk", true },
  { "epicdowney.com", true },
  { "epicentar.mk", true },
  { "epicenter.ga", true },
  { "epicenter.work", true },
  { "epicenter.works", true },
  { "epicentre.works", true },
  { "epicfail.be", true },
  { "epicginger.fi", true },
  { "epichouse.net", false },
  { "epicinflatables.co.uk", true },
  { "epickitty.co.uk", true },
  { "epiclub.com.au", true },
  { "epicpages.com", true },
  { "epicserver.ru", true },
  { "epicsoft.de", true },
  { "epicvistas.com", true },
  { "epicvistas.de", true },
  { "epicwalnutcreek.com", true },
  { "epidastudio.com", true },
  { "epidauros.be", true },
  { "epigrafes-led-farmakeia.gr", true },
  { "epikomagazine.com", true },
  { "epilepsiyle.com", true },
  { "epilis.gr", true },
  { "epinesdeparadis.com", true },
  { "epiphanyofourlordchurch.com", true },
  { "epiphyte.network", true },
  { "episkevh-plaketas.gr", true },
  { "epistas.com", true },
  { "epistas.de", true },
  { "epitesz.co", true },
  { "epiteugma.com", true },
  { "epitome.cc", true },
  { "epitome.games", true },
  { "epizentrum.work", true },
  { "epizentrum.works", true },
  { "epmcentroitalia.it", true },
  { "epolitiker.com", true },
  { "epos-distributor.co.uk", true },
  { "epos.az", true },
  { "eposbirmingham.co.uk", true },
  { "eposbrighton.co.uk", true },
  { "eposbristol.co.uk", true },
  { "eposcardiff.co.uk", true },
  { "eposig.net", true },
  { "eposkent.co.uk", true },
  { "eposleeds.co.uk", true },
  { "eposleicester.co.uk", true },
  { "eposliverpool.co.uk", true },
  { "eposlondon.co.uk", true },
  { "epossheffield.co.uk", true },
  { "eposswansea.co.uk", true },
  { "epostplus.li", true },
  { "eposyork.co.uk", true },
  { "eppelblei.lu", true },
  { "eppelduerferjugend.lu", true },
  { "eppelpress.lu", true },
  { "eppione.com", true },
  { "epreskripce.cz", true },
  { "eprezto.com", true },
  { "eprojectfreetv.com", true },
  { "epsilon.dk", true },
  { "epsmil.it", true },
  { "epspolymer.com", true },
  { "epublibre.org", true },
  { "epyonsuniverse.net", true },
  { "eq-serve.com", true },
  { "eqassociates.com", true },
  { "eqibank.com", true },
  { "eqiware.com", true },
  { "equabanking.cz", true },
  { "equalcloud.com", true },
  { "equidam.com", true },
  { "equifaxobjection.com", true },
  { "equinecoaching.ca", true },
  { "equinetherapy.ca", true },
  { "equinox.io", true },
  { "equipandoloja.net.br", true },
  { "equipedefrance.tv", false },
  { "equipoweb.info", true },
  { "equisecu.com", true },
  { "equk.co.uk", true },
  { "er-mgmt.com", true },
  { "er.tl", true },
  { "er1s.xyz", true },
  { "era.fi", true },
  { "eradoom.net", true },
  { "erasmo.info", true },
  { "erasmusplusrooms.com", true },
  { "erasure.tk", true },
  { "erate.fi", true },
  { "erath.fr", false },
  { "erdethamburgeronsdag.no", true },
  { "erektion1.gq", true },
  { "erethon.com", true },
  { "erf-neuilly.com", true },
  { "erfolgsmaschine.ch", true },
  { "ergo-open.de", true },
  { "ergobyte.eu", true },
  { "ergobyte.gr", true },
  { "ergodark.com", true },
  { "ergonova.fr", true },
  { "ergoterapeutas.lt", true },
  { "ergovita.com.br", true },
  { "ericabrahamsen.net", true },
  { "ericairwin.com", true },
  { "ericdiao.com", true },
  { "erichoekstra.com", true },
  { "erichoekstra.nl", true },
  { "erichogue.ca", true },
  { "erichorstmanshof.nl", true },
  { "ericjohnltd.com", true },
  { "erick.blog", true },
  { "ericksonvasquez.com", true },
  { "ericleuthardt.com", true },
  { "ericoc.com", true },
  { "erics.site", true },
  { "ericsilva.org", true },
  { "ericspeidel.de", true },
  { "ericvaughn-flam.com", true },
  { "eridanus.uk", true },
  { "eridas.ml", true },
  { "erigrid.eu", true },
  { "eriix.org", true },
  { "erik-stomp.de", true },
  { "erikapsicologia.com", true },
  { "erikatanithphotography.co.uk", true },
  { "erikheemskerk.nl", true },
  { "erikhubers.nl", true },
  { "erikkruithof.nl", true },
  { "erikseth.de", true },
  { "erikwalther.eu", true },
  { "erinaceinae.com", true },
  { "eringmaguire.com", true },
  { "erinn.io", true },
  { "erisrenee.com", true },
  { "eristajanmutka.com", true },
  { "erisys.net", true },
  { "erkaelderbarenaaben.dk", true },
  { "erkenntniswen.de", true },
  { "erkiss.live", true },
  { "erlebnisarchaeologie-bayern.de", true },
  { "ermessecurity.com", true },
  { "ernal.net", true },
  { "ernearmetx.com", true },
  { "ernest.ly", true },
  { "ero-video.net", true },
  { "ero.ink", false },
  { "erodvd.com", false },
  { "eromon.net", true },
  { "eron.info", true },
  { "eropics.org", true },
  { "erp-band.ru", true },
  { "erp.band", true },
  { "erpax.com", true },
  { "erpband.ru", true },
  { "erpcargo.com", false },
  { "erpelstolz.at", true },
  { "erperium.nl", true },
  { "errietta.me", true },
  { "errolstambler.com", true },
  { "error.fail", true },
  { "error418.nl", true },
  { "errortools.com", true },
  { "ers35.com", true },
  { "ersa-shop.com", true },
  { "ershiwo.com", true },
  { "ersinbiltekin.tk", true },
  { "ersinerce.com", true },
  { "erstehilfeprodukte.at", true },
  { "ert.ovh", true },
  { "erty.stream", true },
  { "eru.im", false },
  { "eru.moe", true },
  { "erudicia.com", true },
  { "erudicia.de", true },
  { "erudicia.es", true },
  { "erudicia.fr", true },
  { "erudicia.it", true },
  { "erudicia.nl", true },
  { "erudicia.se", true },
  { "erudicia.uk", true },
  { "erudikum.cz", true },
  { "eruga.es", true },
  { "ervaarjapan.nl", true },
  { "ervinthagod.xyz", true },
  { "erwanlepape.com", true },
  { "erwin.saarland", true },
  { "erwinpaal.nl", true },
  { "erwinschmaeh.ch", true },
  { "erwinwensveen.nl", true },
  { "erythroxylum-coca.com", true },
  { "es-geenen.de", true },
  { "es-tools.at", true },
  { "es-tools.com", true },
  { "es-tools.de", true },
  { "es-trade.biz", true },
  { "es.search.yahoo.com", false },
  { "esagente.com", true },
  { "esalesclub.com", true },
  { "esalesdata.com", true },
  { "esamievalori.com", true },
  { "esample.info", true },
  { "esb9588.info", true },
  { "esc.chat", true },
  { "esc.gov", true },
  { "escael.org", true },
  { "escandille.com", true },
  { "escapeforyou.com", true },
  { "escapeplaza.de", true },
  { "escaperoomdoctor.com", true },
  { "escaperoomsolutions.com", true },
  { "escapetalk.nl", true },
  { "escavador.com", true },
  { "esclear.de", true },
  { "escobarservice7000.com", true },
  { "escontact.ch", false },
  { "escortbee.com", true },
  { "escortbruxelles.be", true },
  { "escortgigolo.com", true },
  { "escortlareryaman.com", true },
  { "escortlistings.ca", true },
  { "escortlistings.mx", true },
  { "escortlistings.ph", true },
  { "escortsforu.com", true },
  { "escortslittleblackbook.com", true },
  { "escovator-records.tk", true },
  { "escritoriodearte.com", false },
  { "escuelabiblica.com", true },
  { "escyr.top", true },
  { "esdacademy.eu", false },
  { "esdenera.com", true },
  { "esdiscuss.org", true },
  { "esdvfootloose.nl", true },
  { "eseances.ch", true },
  { "esehospitalsabanagrande.com", true },
  { "eservices-greece.com", true },
  { "eseth.de", true },
  { "esfahanahan.com", true },
  { "esfiledecrypter.com", true },
  { "esg-abi2001.de", true },
  { "esgen.org", true },
  { "esgr.in", true },
  { "esh.ink", true },
  { "esher.ac.uk", true },
  { "eshigami.com", true },
  { "eshop-prices.com", true },
  { "eshspotatoes.com", true },
  { "esigmbh.de", true },
  { "esigtorg.ru", true },
  { "esim.cz", true },
  { "esite.ch", true },
  { "eskapi.fr", true },
  { "eskdale.net", true },
  { "eskriett.com", false },
  { "eslint.org", false },
  { "esmart.ru", true },
  { "esmejor.tk", true },
  { "esoa.net", true },
  { "esoko.eu", true },
  { "esolcourses.com", true },
  { "esolitos.com", true },
  { "eson.eu", true },
  { "esono.de", true },
  { "esoteric.website", true },
  { "esoterikerforum.de", true },
  { "esovita.de", true },
  { "espace-caen.fr", false },
  { "espace-gestion.fr", true },
  { "espace-habitat-francais.fr", true },
  { "espace.network", true },
  { "espacelanguetokyo.fr", true },
  { "espacetemps.ch", true },
  { "espacetheosophie.fr", true },
  { "espacio-cultural.com", true },
  { "espaciosdelalma.com", true },
  { "espacobebecia.com.br", true },
  { "espanol.search.yahoo.com", false },
  { "espci.fr", true },
  { "especialistagoogleadwords.com.br", true },
  { "especificosba.com.ar", true },
  { "espehus.dk", true },
  { "esperantio.tk", true },
  { "espgg.org", true },
  { "espherapromocional.com.br", true },
  { "espigol.org", true },
  { "espiritugay.com", true },
  { "esport-agency.fr", true },
  { "esport-battlefield.com", true },
  { "espower.com.sg", true },
  { "espritrait.com", false },
  { "espyder.net", true },
  { "esquirou-trieves.fr", false },
  { "esrhd.com", true },
  { "esrinfo.com", true },
  { "esroradio.com", true },
  { "essay-writing-topics-fce.tk", true },
  { "essayace.co.uk", true },
  { "essaybrand.com", true },
  { "essaychecker.com", true },
  { "essaydirectory.com", false },
  { "essayforsale.net", true },
  { "essayforum.com", false },
  { "essayhave.com", true },
  { "essayjob.com", true },
  { "essaylib.com", true },
  { "essaymaker.gq", true },
  { "essaynews.com", true },
  { "essaypro.net", true },
  { "essays.me", true },
  { "essayscam.org", false },
  { "essayshark.com", true },
  { "essaytalk.com", true },
  { "essaywriting.biz", true },
  { "essenalablog.de", true },
  { "essencespresso.es", true },
  { "essenerbaeder.de", true },
  { "essex.cc", true },
  { "essextimbercraft.co.uk", true },
  { "essite.net", true },
  { "esslm.sk", true },
  { "essoduke.org", true },
  { "essteebee.ch", false },
  { "est-it.de", true },
  { "est-keyman.de", true },
  { "estada.ch", true },
  { "estadoreclamos.com", true },
  { "estafallando.es", true },
  { "estafallando.mx", true },
  { "estahl.dk", true },
  { "estaleiro.org", true },
  { "estaryshop.com.br", true },
  { "estcequejailaflemme.fr", false },
  { "estcequonmetenprodaujourdhui.info", true },
  { "esteam.se", true },
  { "estedafah.com", true },
  { "estefan.dyndns.org", true },
  { "estela-artes.com", true },
  { "esteladigital.com", true },
  { "esteriliza-me.org", true },
  { "esterilizacion-perros.es", true },
  { "esteticanorte.com.br", true },
  { "estetici.com", true },
  { "estetista.net", true },
  { "esthe-zukan.com", true },
  { "estherlew.is", true },
  { "esthernariyoshi.com", true },
  { "estilopack-loja.com.br", true },
  { "estimulantesbrasil.com", true },
  { "estintori.roma.it", true },
  { "estoic.net", true },
  { "estonoentraenelexamen.com", true },
  { "estoppels.com", true },
  { "estraks.com", true },
  { "estudiarparaser.com", true },
  { "estudiaryaprenderingles.com", true },
  { "estudiogarcia-rada.com", true },
  { "estufitas.com", true },
  { "esu.moe", true },
  { "esuretynew.azurewebsites.net", true },
  { "esyoil.com", true },
  { "et-inf.de", true },
  { "eta.cz", true },
  { "etaes.eu", true },
  { "etajerka-spb.ru", true },
  { "etajerka.spb.ru", true },
  { "etalktome.com", true },
  { "etaoinwu.com", true },
  { "etaoinwu.win", true },
  { "etasigmaphi.org", true },
  { "etath.com", true },
  { "etax.com.au", true },
  { "etaxigraz.com", true },
  { "etccooperative.org", true },
  { "etch.co", true },
  { "etda.or.th", true },
  { "etduvindemoselle.fr", true },
  { "etech-solution.com", true },
  { "etech-solution.net", true },
  { "etech-solutions.com", true },
  { "etechsolution.net", true },
  { "eteesheet.com", true },
  { "eternal-warriors.de", true },
  { "eternalabyss.int.eu.org", true },
  { "eternalflame.info", true },
  { "eternalparking.com", true },
  { "eternalparking.eu", true },
  { "eternalparking.net", true },
  { "eternalparking.org", true },
  { "eternalsymbols.com", true },
  { "eternit.roma.it", true },
  { "eth0.nl", true },
  { "eth1.fi", true },
  { "etha.nz", true },
  { "ethack.org", true },
  { "ethanchin.com", false },
  { "ethanjones.me", true },
  { "ethanlew.is", true },
  { "ethelbrooks.com", true },
  { "ethelbrooks.es", true },
  { "ethercalc.org", true },
  { "etherpad.nl", true },
  { "ethers.news", true },
  { "ethicalconsumer.org", true },
  { "ethicaldata.co.uk", true },
  { "ethicalpolitics.org", true },
  { "ethicsburg.gov", true },
  { "ethika.com", true },
  { "ethil-faer.fr", true },
  { "ethiobaba.com", true },
  { "ethiopian.dating", true },
  { "ethitter.com", true },
  { "etienne.cc", true },
  { "etiennes.work", true },
  { "etiquetaunica.com.br", true },
  { "etna.com.br", true },
  { "etni-cidade.net", true },
  { "etnoria.com", true },
  { "etoile-usedcars.com", false },
  { "etre-soi.ch", false },
  { "etre-vivant.fr", false },
  { "etrecosmeticderm.com", true },
  { "etresmant.es", true },
  { "etrker.com", true },
  { "ets2mp.de", true },
  { "etskinner.com", true },
  { "etskinner.net", true },
  { "etudesbibliques.fr", false },
  { "etudesbibliques.net", false },
  { "etudesbibliques.org", false },
  { "eturist.si", true },
  { "etv.cx", true },
  { "etwalldentalpractice.co.uk", true },
  { "etyd.org", true },
  { "eu-darlehen-finanzierung.de", true },
  { "eu-datenbank.de", true },
  { "eu-gamers.com", true },
  { "eu-stellenangebot.de", true },
  { "euanbarrett.com", true },
  { "euc.world", true },
  { "euchre.us", true },
  { "eugenekay.com", true },
  { "eugenetech.org", true },
  { "eugeniocorso.com", true },
  { "eujuicers.bg", true },
  { "eujuicers.com", true },
  { "eujuicers.com.hr", true },
  { "eujuicers.com.ua", true },
  { "eujuicers.cz", true },
  { "eujuicers.de", true },
  { "eujuicers.es", true },
  { "eujuicers.fr", true },
  { "eujuicers.hu", true },
  { "eujuicers.it", true },
  { "eujuicers.pl", true },
  { "eujuicers.pt", true },
  { "eujuicers.ro", true },
  { "eujuicers.rs", true },
  { "eujuicers.ru", true },
  { "eujuicers.si", true },
  { "eujuicers.sk", true },
  { "eulenschmiede.de", true },
  { "eulessplumbers.com", true },
  { "euman.ml", true },
  { "eumr.org", true },
  { "euporos.ch", true },
  { "eureka.archi", true },
  { "euro-construction.co.uk", true },
  { "euroalter.com", true },
  { "eurocars2000.es", true },
  { "eurocenterobuda.hu", true },
  { "eurocertificazione.it", true },
  { "eurocomcompany.cz", true },
  { "euroconthr.ro", true },
  { "eurodentaire.com", true },
  { "euroexpres.info", true },
  { "euroflora.com", true },
  { "euroflora.mobi", true },
  { "eurofrank.eu", true },
  { "eurogarden-parts.de", true },
  { "eurogarden.be", true },
  { "eurogarden.nl", true },
  { "eurolocarno.es", true },
  { "euronic.fi", true },
  { "euroonline.org", true },
  { "europa.jobs", true },
  { "europainchemnitz.de", true },
  { "europalettenkaufen.de", true },
  { "europareise2010.de", true },
  { "europarts-sd.com", true },
  { "europastudien-chemnitz.de", true },
  { "europastudien.de", true },
  { "european-agency.org", true },
  { "european-hospital.ga", true },
  { "european-hospital.ml", true },
  { "european-hospital.tk", true },
  { "europeancupinline.eu", true },
  { "europeanstudies-chemnitz.de", true },
  { "europeantimberconnectors.ca", true },
  { "europeanwineresource.com", true },
  { "europeos.es", true },
  { "europetravelservice.co.uk", true },
  { "europop.com", true },
  { "eurora.de", true },
  { "eurorecambios24.com", true },
  { "euroroad17.dk", true },
  { "euroscot.de", true },
  { "euroshop.or.at", true },
  { "euroshop.tk", true },
  { "euroskano.nl", true },
  { "eurotop.net.pl", true },
  { "eurotramp.com", true },
  { "eurousa.us", true },
  { "eurovision.ie", true },
  { "eurowaage.de", true },
  { "eusarse.tk", true },
  { "eusolar.cloud", true },
  { "euterpiaradio.ch", true },
  { "eutiximo.com", true },
  { "eutotal.com", true },
  { "euwid-energie.de", true },
  { "euwid.de", true },
  { "ev-zertifikate.de", true },
  { "eva-briegel-fanpage.tk", true },
  { "eva-select.com", true },
  { "eva.cz", true },
  { "evaalordiah.tk", true },
  { "evadental.institute", true },
  { "evafojtova.cz", true },
  { "evailoil.ee", true },
  { "evailoil.eu", true },
  { "evamachkova.cz", true },
  { "evamathil.de", true },
  { "evamira.com", true },
  { "evanfiddes.com", true },
  { "evangelicalmagazine.com", true },
  { "evangelosm.com", true },
  { "evansdesignstudio.com", false },
  { "evanwang0.com", true },
  { "evasioncreole.com", true },
  { "evasovova.cz", true },
  { "evavolfova.cz", true },
  { "evdenevenakliyatankara.name.tr", true },
  { "eve-online-com.ru", true },
  { "eve-raynon.fr", true },
  { "eve-ua.com", true },
  { "eveadmin.azurewebsites.net", false },
  { "evearly.com", true },
  { "eveil-et-savoirs.com", true },
  { "evelienzorgt.nl", true },
  { "evelyndayman.com", true },
  { "evenementenhoekvanholland.nl", true },
  { "event-blick.de", true },
  { "event-fullyyours.com", true },
  { "event4fun.no", true },
  { "eventaro.com", true },
  { "eventblog2017.tk", true },
  { "eventerlebnis.ch", true },
  { "eventide.space", true },
  { "eventim-business.com", true },
  { "eventim-business.de", true },
  { "eventive.org", true },
  { "eventnexus.co.uk", true },
  { "eventosbgp.com", true },
  { "eventosenmendoza.com.ar", true },
  { "eventosformativos.tk", true },
  { "eventprazdnik.ru", true },
  { "events-hire.co.uk", true },
  { "eventservicestockholm.se", true },
  { "eventsframe.com", true },
  { "eventtech.com", false },
  { "evenwallet.com", true },
  { "eveonline.com", true },
  { "ever.sale", true },
  { "everain.me", true },
  { "everberg.tk", true },
  { "everettsautorepair.com", true },
  { "everfine.com.tw", true },
  { "evergladesrestoration.gov", true },
  { "everglow.co.jp", true },
  { "everglowtrading.com", true },
  { "evergreenmichigan.com", true },
  { "everhome.de", true },
  { "everichspice.com", false },
  { "everify.gov", true },
  { "everling.lu", true },
  { "everlong.org", true },
  { "evermarkstudios.com", true },
  { "evernaut.com", true },
  { "everpcpc.com", true },
  { "evertonarentwe.com", true },
  { "everwaking.com", false },
  { "every-day-life.com", false },
  { "everyday.eu.org", true },
  { "everydaylatestnews.com", true },
  { "everyfad.com", true },
  { "everykidoutdoors.gov", false },
  { "everything-everywhere.com", true },
  { "everythingaccess.com", true },
  { "everythingstech.com", true },
  { "everytrycounts.gov", false },
  { "eveshamglass.co.uk", true },
  { "eveswell.com", true },
  { "evexia.xyz", true },
  { "eviction.cf", true },
  { "evidence-based.review", true },
  { "evidencebased.net", true },
  { "evidenceusa.com.br", true },
  { "evidencija.ba", true },
  { "evileden.com", true },
  { "evilla.ru", false },
  { "evilmartians.com", true },
  { "evilnerd.de", true },
  { "evion.nl", true },
  { "evisa.us.com", true },
  { "evlear.com", true },
  { "evlorin.com", true },
  { "evnt.team", true },
  { "evntage.com", true },
  { "evoco.vc", true },
  { "evodation.com", true },
  { "evodation.org", true },
  { "evodia-spirits.de", true },
  { "evohomecare.com", true },
  { "evok.com.co", false },
  { "evolutioninflatables.co.uk", true },
  { "evolutionlending.co.uk", true },
  { "evolutionpets.com", true },
  { "evolvetechnologies.co.uk", true },
  { "evolvingsouls.com", true },
  { "evolvingthoughts.net", true },
  { "evomada.com", true },
  { "evomon.com", true },
  { "evony.eu", true },
  { "evosyn.com", true },
  { "evotec.pl", true },
  { "evotec.xyz", true },
  { "evoting-test.ch", false },
  { "evoting.ch", true },
  { "evowrap.co.uk", true },
  { "evpro.lt", true },
  { "evrial.com", true },
  { "evrica.me", true },
  { "evromandie.ch", true },
  { "evrotrust.com", true },
  { "evsinemasistemleri.tk", true },
  { "evstatus.com", true },
  { "evtasima.name.tr", true },
  { "evthing.se", true },
  { "evtripping.com", true },
  { "evtscan.io", true },
  { "evyn.eu", true },
  { "ewa-hayward.co.uk", true },
  { "ewaipiotr.pl", true },
  { "ewanm89.co.uk", true },
  { "ewanm89.com", true },
  { "ewanm89.uk", true },
  { "ewar.lt", false },
  { "ewc.co.jp", true },
  { "ewcd.co.jp", true },
  { "ewe2.ninja", true },
  { "ewhitehat.com", true },
  { "ewie.name", true },
  { "ewinstore.com", true },
  { "ewritingservice.com", true },
  { "ewsfeed.com", true },
  { "ewtl.es", true },
  { "ewus.de", true },
  { "ex-deli.jp", true },
  { "exablue.de", true },
  { "exactlyinfinite.com", true },
  { "exactphilosophy.net", true },
  { "exadime.net", true },
  { "exagoni.com.au", true },
  { "exagoni.com.my", true },
  { "examedge.com", true },
  { "examika.ru", true },
  { "example.eu.org", true },
  { "exampleessays.com", true },
  { "exams9.com", true },
  { "examsite.tk", true },
  { "examticket.tk", true },
  { "exaplac.com", true },
  { "exarpy.com", true },
  { "exatmiseis.net", false },
  { "exbolivo.com", true },
  { "excaliburtitle.com", false },
  { "exceed.global", true },
  { "exceedagency.com", true },
  { "excel-mechanical.com", true },
  { "excel-utbildning.nu", true },
  { "excelkurs.one", true },
  { "excelkursdirekt.eu", true },
  { "excella.me", true },
  { "excellence-eventos.com", true },
  { "excelsiorcomics.com.br", true },
  { "exceltechdubai.com", true },
  { "exceltechoman.com", true },
  { "excentos.com", true },
  { "excerp.tech", true },
  { "excess-baggage.com", true },
  { "excessamerica.com", true },
  { "excesssecurity.com", true },
  { "exchangers.top", true },
  { "exchaser.com", true },
  { "excitoninteractive.com", true },
  { "exclusivebeautystudio.com.au", true },
  { "exclusivebouncycastles.co.uk", true },
  { "exclusivecarcare.co.uk", true },
  { "excursionescaribe.com", true },
  { "exdamo.de", true },
  { "exe-boss.tech", true },
  { "execbar.com", true },
  { "exechip.com", true },
  { "execution.biz.tr", true },
  { "executiveresolutions.co.uk", true },
  { "exegese.ch", true },
  { "exeintel.com", true },
  { "exekutori.com", true },
  { "exemples-de-stands.com", true },
  { "exerforge.com", true },
  { "exeria.de", true },
  { "exexcarriers.com", true },
  { "exeye.io", true },
  { "exgaywatch.com", true },
  { "exgen.io", true },
  { "exhibityour.com", true },
  { "exiahost.com", true },
  { "existest.com", true },
  { "exit9wineandliquor.com", true },
  { "exitooutdoor.com", true },
  { "exl-english.com", true },
  { "exmart.ng", true },
  { "exmoe.com", true },
  { "exocen.com", true },
  { "exodiac.ph", true },
  { "exon.io", true },
  { "exordiumconcepts.com", true },
  { "exoscale.ch", true },
  { "exoscale.com", true },
  { "exoten-spezialist.de", true },
  { "exoticads.com", true },
  { "exoticaz.to", true },
  { "exozwiki.com", false },
  { "exp.de", true },
  { "expancio.com", false },
  { "expanddigital.media", true },
  { "expandeco.com", true },
  { "expatfinancial.com.hk", true },
  { "expatfire.com", true },
  { "expatmortgage.uk", true },
  { "expe.voyage", true },
  { "expeditiegrensland.nl", true },
  { "experienceoutdoors.org.uk", true },
  { "experienceoz.com.au", true },
  { "experimentator.cz", true },
  { "experise.fr", true },
  { "expert-korovin.ru", true },
  { "expert-voronezh.tk", true },
  { "expert.cz", true },
  { "experteasy.com.au", true },
  { "expertisematrix.com", true },
  { "expertofficefitouts.com.au", true },
  { "expertpaintersvt.com", true },
  { "expertpanel.gc.ca", true },
  { "expertplumbingandsolarservicesbathurst.com.au", true },
  { "expertsverts.com", true },
  { "expertvagabond.com", true },
  { "expertviolinteacher.com", true },
  { "expicore.com", true },
  { "expii.com", true },
  { "expiscor.solutions", true },
  { "explicate.org", true },
  { "explodie.org", true },
  { "explodingcamera.com", true },
  { "exploit-db.com", true },
  { "exploit.cz", true },
  { "exploit.party", true },
  { "exploit.ph", true },
  { "exploited.cz", true },
  { "exploithe.net", true },
  { "exploitit.com.au", true },
  { "exploodo.rocks", true },
  { "explorebigideas.com", true },
  { "exploredouglascountyga.com", true },
  { "exploremonero.com", true },
  { "exploretsp.gov", true },
  { "exploringmorocco.tours", true },
  { "expmind.co.in", true },
  { "expo-america.ru", true },
  { "expo-asia.ru", true },
  { "expo-europe.ru", true },
  { "expo-larionov.org", true },
  { "exponentialnews.net", true },
  { "expoort.com", true },
  { "expoort.es", true },
  { "expoort.fr", true },
  { "expoort.it", true },
  { "expopodium.com", true },
  { "exporta.cz", true },
  { "exposurecompensation.co.uk", true },
  { "expouniverse.tk", true },
  { "express-shina.ru", true },
  { "express-vpn.com", true },
  { "express-vyvoz.ru", true },
  { "express1040.com", true },
  { "expressemotion.net", true },
  { "expresshosting.org", true },
  { "expressmarket.ru", true },
  { "expresstinte.de", true },
  { "expressvpn.com", true },
  { "expromo.eu", true },
  { "expxkcd.com", true },
  { "exs.lv", true },
  { "exsanio.de", true },
  { "exside.com", true },
  { "exsora.com", true },
  { "extasic.com", true },
  { "extensia.it", true },
  { "extensibility.biz.tr", true },
  { "extensiblewebmanifesto.org", true },
  { "extensiblewebsummit.org", true },
  { "extensionciglia.roma.it", true },
  { "extensionschallenge.com", true },
  { "extensiontree.com", true },
  { "exteriorlightingagoura.com", true },
  { "exteriorlightingagourahills.com", true },
  { "exteriorlightingcalabasas.com", true },
  { "exteriorlightingcamarillo.com", true },
  { "exteriorlightingconejovalley.com", true },
  { "exteriorlightingdosvientos.com", true },
  { "exteriorlightinghiddenhills.com", true },
  { "exteriorlightinglakesherwood.com", true },
  { "exteriorlightingmalibu.com", true },
  { "exteriorlightingmoorpark.com", true },
  { "exteriorlightingnewburypark.com", true },
  { "exteriorlightingoakpark.com", true },
  { "exteriorlightingsimivalley.com", true },
  { "exteriorlightingthousandoaks.com", true },
  { "exteriorlightingwestlakevillage.com", true },
  { "extinctionrebellion.de", true },
  { "extintormadrid.com", true },
  { "extmatrix.com", false },
  { "extradesktops.com", false },
  { "extradiely.sk", true },
  { "extradivers-worldwide.com", true },
  { "extratorrent.cool", true },
  { "extrawdw.net", true },
  { "extreemhost.nl", true },
  { "extreme-gaming.de", true },
  { "extreme-gaming.us", true },
  { "extreme-players.com", true },
  { "extreme-players.de", true },
  { "extreme.co.th", true },
  { "exvs.org", true },
  { "exxpozed-image.de", true },
  { "exxpozed.ch", true },
  { "exxpozed.co.uk", true },
  { "exxpozed.com", true },
  { "exxpozed.de", true },
  { "exxpozed.eu", true },
  { "exxvip.com", true },
  { "exyplis.com", true },
  { "eyal-dvorkin.com", true },
  { "eye-encounters.com", true },
  { "eyebrowsmicroblading.co.uk", true },
  { "eyecandy.gr", true },
  { "eyedesignuniversity.com", true },
  { "eyeglasses.com", false },
  { "eyelashconcept.com", true },
  { "eyeonid.com", true },
  { "eyep.me", true },
  { "eyes-berg.ch", false },
  { "eyes-berg.com", false },
  { "eyesandearsrescue.org", true },
  { "eyetooth.ga", true },
  { "eynio.com", true },
  { "eyona.com", true },
  { "eyps.net", true },
  { "eyrelles-tissus.com", true },
  { "eythorsson.com", true },
  { "ez3d.eu", true },
  { "ezakazivanje.rs", true },
  { "ezdog.press", true },
  { "ezequiel-garzon.net", false },
  { "ezesec.com", true },
  { "ezftrs.com", true },
  { "ezgamble.com", true },
  { "ezgif.com", true },
  { "ezhik-din.ru", true },
  { "ezik-ido.tk", true },
  { "eziwine.com", true },
  { "eznetworks.com.br", true },
  { "eztvtorrent.com", true },
  { "ezwritingservice.com", true },
  { "f-droid.org", true },
  { "f-hd.net", true },
  { "f-thie.de", true },
  { "f-u-c-k.wien", true },
  { "f00.fr", true },
  { "f00f.org", true },
  { "f0x.es", true },
  { "f1318.com", false },
  { "f1318.net", false },
  { "f13cybertech.cz", true },
  { "f1classement.com", false },
  { "f1distribution.com", true },
  { "f1fever.co.uk", true },
  { "f1fever.net", true },
  { "f1minute.com", true },
  { "f1nal-lap.be", true },
  { "f2h.io", true },
  { "f36533.com", true },
  { "f36594.com", true },
  { "f3nws.com", true },
  { "f43.me", true },
  { "f51365.com", true },
  { "f5la.com", true },
  { "f5nu.com", true },
  { "f8003.com", true },
  { "f8007.com", true },
  { "f8036.com", true },
  { "f81818.com", true },
  { "f88-line.com", true },
  { "f88-line.net", true },
  { "f88288.com", true },
  { "f88da.com", true },
  { "f88fine.com", true },
  { "f88good.com", true },
  { "f88line.com", true },
  { "f88line.net", true },
  { "f88ll.com", true },
  { "f88qin.com", true },
  { "f88vip102.com", true },
  { "f88vip103.com", true },
  { "f88vip104.com", true },
  { "f88vip105.com", true },
  { "f88vip106.com", true },
  { "f88vip19.com", true },
  { "f88vip2.com", true },
  { "f88vip20.com", true },
  { "f88vip21.com", true },
  { "f88vip22.com", true },
  { "f88vip23.com", true },
  { "f88vip3.com", true },
  { "f88vip4.com", true },
  { "f88vip5.com", true },
  { "f88vip6.com", true },
  { "f88yule1.com", true },
  { "f88yule111.com", true },
  { "f88yule122.com", true },
  { "f88yule3.com", true },
  { "f88yule5.com", true },
  { "f88yule6.com", true },
  { "f88yule7.com", true },
  { "f88yule8.com", true },
  { "f88yule9.com", true },
  { "f8908.com", true },
  { "f8921.com", true },
  { "f8cp0.com", true },
  { "f8cp1.com", true },
  { "f8cp2.com", true },
  { "f8cp3.com", true },
  { "f8cp4.com", true },
  { "f8cp5.com", true },
  { "f8cp6.com", true },
  { "f8cp7.com", true },
  { "f8cp9.com", true },
  { "f8s.co", true },
  { "f9marketing.com", true },
  { "fa-works.com", true },
  { "fa158k.com", true },
  { "fabbro-roma.org", true },
  { "fabbro.roma.it", true },
  { "faber.org.ru", true },
  { "fabian-fingerle.de", true },
  { "fabian-klose.com", true },
  { "fabian-klose.de", true },
  { "fabian-klose.net", true },
  { "fabianackle.ch", true },
  { "fabianbeiner.com", true },
  { "fabianbeiner.de", false },
  { "fabianegli.ch", true },
  { "fabianfranke.de", true },
  { "fabiankoeppen.com", true },
  { "fabien-hebuterne.fr", true },
  { "fabienne-roux.org", true },
  { "fabiobier.com", true },
  { "fabiocicerchia.it", true },
  { "fabjansisters.eu", true },
  { "fabled.com", true },
  { "fableforge.nl", true },
  { "fabriceleroux.com", false },
  { "fabrika.com.br", true },
  { "fabriziocavaliere.it", true },
  { "fabriziorocca.it", true },
  { "fabrysociety.org", true },
  { "fabse.net", true },
  { "fabservicos.com.br", true },
  { "fabslabour.uk", true },
  { "fabulosa.com.br", true },
  { "faca.gov", true },
  { "facai666.cc", true },
  { "facai888.cc", true },
  { "facanabota.com", true },
  { "facanabota.com.br", true },
  { "facarospauls.com", true },
  { "facchinaggio.milano.it", true },
  { "facchinaggio.roma.it", true },
  { "facciadastile.it", true },
  { "face-fashion.de", true },
  { "face-mania.com", true },
  { "facealacrise.fr", true },
  { "facebook-atom.appspot.com", true },
  { "facebook.com", false },
  { "facebydrh.com", true },
  { "facebylouise.co.uk", true },
  { "facedack.com", true },
  { "facekungfu.com", true },
  { "facemd.net", true },
  { "facepainting.gr", true },
  { "faceresources.org", true },
  { "facesdr.com", true },
  { "fach-journalist.de", true },
  { "fachmann-umzuege.de", true },
  { "fachschaftslisten.at", true },
  { "fachschaftslisten.org", true },
  { "fachversand-hennes.de", true },
  { "facialexercising.com", true },
  { "facil.services", false },
  { "faciledireto.com.br", true },
  { "facilities.fr", true },
  { "facilitiessurvey.org", true },
  { "facility-service-muenchen.de", true },
  { "facingbipolar.com", false },
  { "fackovec.cz", true },
  { "factbytefactbox.com", true },
  { "factor.cc", false },
  { "factorio.tools", true },
  { "factoriotools.com", true },
  { "factoriotools.net", true },
  { "factoriotools.org", true },
  { "factorit.fr", true },
  { "factory-f.net", true },
  { "factslider.tk", true },
  { "facturama.pt", true },
  { "factuur.pro", true },
  { "factuursturen.be", true },
  { "factuursturen.nl", true },
  { "factys.es", true },
  { "facua.org", true },
  { "facucosta.com.ar", true },
  { "faderweb.de", true },
  { "fadilus.com", true },
  { "fady.vn", true },
  { "faehler.de", true },
  { "faelix.net", true },
  { "faeservice.eu", true },
  { "fafa018.com", true },
  { "fafa066.com", true },
  { "fafa106.com", true },
  { "faggut.gg", true },
  { "fahmed.de", true },
  { "fahrenwal.de", false },
  { "fahrenwalde.de", false },
  { "fahrschule-laux.de", true },
  { "fahrwerk.io", true },
  { "fai.gov", false },
  { "faidanoi.it", true },
  { "faidatefacile.it", true },
  { "failforward.tech", true },
  { "failover.de", true },
  { "failover.eu", true },
  { "failoverplan.it", true },
  { "fairbairnrealty.com", true },
  { "fairbill.com", true },
  { "fairedeseconomies.info", true },
  { "fairgaming.ml", true },
  { "fairgolfteams.com", true },
  { "fairgreenlimited.com", true },
  { "fairleighcrafty.com", true },
  { "fairmarketing.com", true },
  { "fairplay.im", true },
  { "fairr.de", true },
  { "fairr.online", true },
  { "fairssl.dk", true },
  { "fairssl.se", true },
  { "fairviewmotel-simcoe.com", true },
  { "fairydust.space", true },
  { "fairyth.tk", true },
  { "faithcentercogop.net", true },
  { "faithgrowth.com", true },
  { "faithindemocracy.eu", false },
  { "faithleaks.org", true },
  { "faithwatch.org", true },
  { "faixaazul.com", true },
  { "faizan.net", true },
  { "faizan.xyz", true },
  { "faizanullah.com", true },
  { "fake-show.ga", true },
  { "fakeduckpond.com", true },
  { "fakeemergency.com", true },
  { "fakerli.com", true },
  { "fakes-ru.tk", true },
  { "fakt.tk", true },
  { "fakti.bg", true },
  { "faktotum.tech", true },
  { "fakturi.com", true },
  { "fakturoid.cz", true },
  { "falaeapp.org", true },
  { "falaowang.com", true },
  { "falasteenjobs.com", true },
  { "falbros.com", true },
  { "falcema.com", true },
  { "falconfrag.com", true },
  { "falconvintners.com", true },
  { "falcoz.co", true },
  { "faldoria.de", true },
  { "falegname-roma.it", true },
  { "falegname.roma.it", true },
  { "falegnameria.milano.it", true },
  { "fall.ga", true },
  { "fallenangeldrinks.co.uk", true },
  { "fallenangeldrinks.com", true },
  { "fallenangelspirits.co.uk", true },
  { "fallenangelspirits.com", true },
  { "fallenmoons.nl", true },
  { "fallenmystic.com", true },
  { "fallin.space", true },
  { "falling.se", true },
  { "fallofthecitadel.com", true },
  { "falsterhus.de", true },
  { "falsterhus.dk", true },
  { "falsum.net", true },
  { "fam-borsch.de", true },
  { "fam-kreibich.de", true },
  { "fam-stemmer.de", false },
  { "fam-weyer.de", true },
  { "famcloud.de", true },
  { "fameng.nl", true },
  { "fameus.fr", true },
  { "familiaperez.net", false },
  { "familie-keil.de", true },
  { "familie-kruithof.nl", true },
  { "familie-kupschke.de", true },
  { "familie-leu.ch", true },
  { "familie-monka.de", true },
  { "familie-poeppinghaus.de", true },
  { "familie-remke.de", true },
  { "familie-sprink.de", false },
  { "familiearchivaris.nl", true },
  { "familieholme.de", true },
  { "familienportal.de", true },
  { "familiereimann.com", true },
  { "familjenfrodlund.se", true },
  { "familjenm.se", true },
  { "familleseux.net", true },
  { "familleshilton.com", true },
  { "familylawhotline.org", true },
  { "familyparties.co.uk", true },
  { "familyreal.ru", true },
  { "familyrecipe.co.uk", true },
  { "familytreehq.com", true },
  { "familyworld.gr", true },
  { "famion.eu", false },
  { "famososnaweb.com", true },
  { "famousbirthdays.com", true },
  { "famoushostels.com", true },
  { "famvangelder.nl", true },
  { "famvsomeren.nl", true },
  { "fan.gov", true },
  { "fanactu.com", true },
  { "fanatical.com", true },
  { "fanatik.io", true },
  { "fanboi.ch", true },
  { "fanbot.co", true },
  { "fancy-bridge.com", true },
  { "fancy.org.uk", true },
  { "fancygaming.dk", true },
  { "fandler.cz", true },
  { "fandomservices.com", true },
  { "fanfareunion.ch", false },
  { "fangs.ink", true },
  { "fanjingbo.com", true },
  { "fanjingbo.me", true },
  { "fanjoe.be", true },
  { "fanohus.de", true },
  { "fanohus.dk", true },
  { "fansale.de", true },
  { "fansided.com", true },
  { "fantasiapainter.com", true },
  { "fantasiatravel.hr", true },
  { "fantasmesexuel.info", true },
  { "fantasticcleaners.com.au", true },
  { "fantasticcleanersbristol.co.uk", true },
  { "fantastichandymanmelbourne.com.au", true },
  { "fantastici.de", true },
  { "fantasticservices.com", true },
  { "fantasticservicesgroup.com", true },
  { "fantasticservicesgroup.com.au", true },
  { "fantasy-judo.com", true },
  { "fantasycastles.co.uk", true },
  { "fantasydrop.com", true },
  { "fantasyescortsbirmingham.co.uk", true },
  { "fantasymina.de", true },
  { "fantasypartyhire.com.au", true },
  { "fantasyspectrum.com", true },
  { "fantgames.com", true },
  { "fantraxhq.com", true },
  { "fanyina.cn", true },
  { "fanyina.com", true },
  { "fanyue123.tk", true },
  { "fanz.pro", true },
  { "fanzlive.com", true },
  { "fapiis.gov", true },
  { "fapp.tube", true },
  { "fapplepie.com", true },
  { "faq.ie", true },
  { "fara.gov", true },
  { "faradome.ws", true },
  { "faradrive.ir", true },
  { "farallonesrentacar.com", true },
  { "farberplasticsurgery.com", true },
  { "farcecrew.de", true },
  { "farces.com", false },
  { "faretrotter.com", true },
  { "farfallapets.com.br", true },
  { "farfetchos.com", true },
  { "fargtorget.se", true },
  { "farhadexchange.com", true },
  { "farhood.org", true },
  { "farid.is", true },
  { "farleybrass.com.au", true },
  { "farmacia-lloret.com", true },
  { "farmaciacomunalelacchiarella.it", true },
  { "farmaciacorvi.it", true },
  { "farmaciadejaime.es", true },
  { "farmaspeed.it", true },
  { "farmer.dating", true },
  { "farmers.gov", false },
  { "farmkazuto.com", true },
  { "farodeluz.ca", true },
  { "faroebusinessreport.com", true },
  { "faroes.net", true },
  { "faroes.org", true },
  { "farsil.eu", true },
  { "fart.wtf", true },
  { "farthing.xyz", true },
  { "farwat.ru", true },
  { "farzli.com", false },
  { "faschingmd.com", true },
  { "fascia.fit", true },
  { "fashion-stoff.de", true },
  { "fashion.bg", true },
  { "fashion24.de", true },
  { "fashiondays.bg", true },
  { "fashiondays.hu", true },
  { "fashiondays.ro", true },
  { "fashioneditor.gr", true },
  { "fashionlistify.tk", true },
  { "fashiontrendsetter.com", true },
  { "fashionunited.be", true },
  { "fashionunited.cl", true },
  { "fashionunited.com", true },
  { "fashionunited.com.ar", true },
  { "fashionunited.de", true },
  { "fashionunited.fi", true },
  { "fashionunited.hk", true },
  { "fashionunited.hu", true },
  { "fashionunited.ie", true },
  { "fashionunited.lu", true },
  { "fashionunited.mx", true },
  { "fashionunited.nl", true },
  { "fashionunited.no", true },
  { "fashionunited.nz", true },
  { "fashionunited.pl", true },
  { "fashionunited.se", true },
  { "fashionusa.gq", true },
  { "fashionweekweb.com", true },
  { "fashionxmas.gq", true },
  { "fashtic.nl", true },
  { "faspirits.co.uk", true },
  { "faspirits.com", true },
  { "fassaden-selleng.de", true },
  { "fassadenverkleidung24.de", true },
  { "fassi-sport.it", true },
  { "fast-cargo.ml", true },
  { "fast-pro.co.jp", true },
  { "fastblit.com", true },
  { "fastcash.com.br", true },
  { "fastcomcorp.com", true },
  { "fastcommerce.org", true },
  { "fastconfirm.com", true },
  { "fastconv.com", true },
  { "fastest-hosting.co.uk", true },
  { "fastforwardsociety.nl", true },
  { "fasthost.com.br", true },
  { "fastighetsekonomi.com", true },
  { "fastinviter.com", true },
  { "fastknigi.ml", true },
  { "fastlike.co", true },
  { "fastmail.com", false },
  { "fastonline.ro", true },
  { "fastos.com", true },
  { "fastos.de", true },
  { "fastpresence.com", true },
  { "fastserv.pl", true },
  { "fasturl.ml", true },
  { "fastvistorias.com.br", true },
  { "fastworx.com", true },
  { "fatecdevday.com.br", true },
  { "fateitalia.it", true },
  { "fatherhood.gov", true },
  { "fathers4equalrights.org", true },
  { "fatidique.com", true },
  { "fatihingemisi.com", true },
  { "fatimamoldes.com.br", true },
  { "fatmixx.com", true },
  { "fatowltees.com", true },
  { "fattailcall.com", false },
  { "fatturegeko.eu", true },
  { "fattyink.com", true },
  { "faucetbox.com", false },
  { "faultlines.org", true },
  { "fauvettes.be", true },
  { "favalart.com", true },
  { "favirei.com", true },
  { "favorai.com", true },
  { "fawong.com", true },
  { "faxvorlagen-druckvorlagen.de", true },
  { "fayntic.com", true },
  { "fazzfinancial.com", true },
  { "fb-feed.net", true },
  { "fb.gg", true },
  { "fb.me", true },
  { "fbcdn.net", true },
  { "fbi.gov", true },
  { "fbigame.com", true },
  { "fbiic.gov", true },
  { "fbijobs.gov", true },
  { "fbo.gov", false },
  { "fboerman.nl", true },
  { "fbrief.org", true },
  { "fbsbx.com", true },
  { "fbtholdings.com", true },
  { "fburl.com", true },
  { "fbwgynplus.com", true },
  { "fbwgynplus.com.au", true },
  { "fc.media", true },
  { "fc8882.com", false },
  { "fc8882.net", false },
  { "fca-tools.com", true },
  { "fcapollo.tk", true },
  { "fcbarcelona.cz", true },
  { "fcburk.de", true },
  { "fccarbon.com", true },
  { "fcdn.nl", true },
  { "fcforum.net", true },
  { "fcic.gov", true },
  { "fcingolstadt.de", true },
  { "fcosinus.com", true },
  { "fcprovadia.com", true },
  { "fcsic.gov", true },
  { "fdalawboston.com", true },
  { "fdaregs.com", true },
  { "fdevs.ch", true },
  { "fdfz.edu.cn", true },
  { "fdicig.gov", true },
  { "fdicoig.gov", true },
  { "fdis.net.cn", true },
  { "fdm.ro", true },
  { "fdms.gov", true },
  { "fdp-brig-glis.ch", true },
  { "fdpbrig.ch", true },
  { "fdremodelingatlanta.com", true },
  { "fdresearch.ca", true },
  { "fdworlds.com", true },
  { "fe-data.nl", true },
  { "feac.us", true },
  { "feandc.com", true },
  { "feastr-dev.de", true },
  { "feastr.de", true },
  { "feastr.io", true },
  { "feat.agency", true },
  { "featherweightlabs.com", true },
  { "feb.gov", true },
  { "febeditora.com.br", true },
  { "fedcenter.gov", true },
  { "federaljobs.gov", true },
  { "federalreserve.gov", true },
  { "federalreserveconsumerhelp.gov", true },
  { "federatedbank.com", true },
  { "fedjobs.gov", true },
  { "fedorahosted.org", true },
  { "fedorapeople.org", true },
  { "fedoraproject.org", true },
  { "fedpartnership.gov", true },
  { "fedramp.gov", false },
  { "fedrtc.org", true },
  { "fedshirevets.gov", true },
  { "fedux.com.ar", true },
  { "fedvan.com", true },
  { "feedbin.com", false },
  { "feedfall.com", true },
  { "feedhq.org", true },
  { "feedkovacs.hu", true },
  { "feedough.com", true },
  { "feedthefuture.gov", false },
  { "feeeei.com", true },
  { "feek.fit", true },
  { "feel-events.com", true },
  { "feel.aero", true },
  { "feelgood-workouts.de", true },
  { "feelmom.com", true },
  { "feeltennis.net", true },
  { "feen.us", true },
  { "feepod.com", true },
  { "feetpa.ws", true },
  { "fefelovalex.ru", true },
  { "fegame.eu", true },
  { "fegame.mobi", true },
  { "fegame.net", true },
  { "fegame.nl", true },
  { "fegc-wgec.gc.ca", true },
  { "fegli.gov", true },
  { "fehngarten.de", true },
  { "feigling.net", false },
  { "feildel.fr", true },
  { "feilen.de", true },
  { "feilestrokestown.com", true },
  { "feisim.com", true },
  { "feisim.org", true },
  { "feistyduck.com", true },
  { "feixiang.eu.org", true },
  { "feiya.ng", true },
  { "fejervar.hu", true },
  { "fekir.info", true },
  { "feld.design", true },
  { "feld.saarland", true },
  { "feldbogenclub-hamburg.de", true },
  { "feldhousen.com", true },
  { "felett.es", true },
  { "feli.games", true },
  { "felicifia.org", true },
  { "felinepc.com", true },
  { "felistirnavia.sk", true },
  { "felix-hirner.de", true },
  { "felixaufreisen.de", true },
  { "felixbarta.de", true },
  { "felixcrux.com", true },
  { "felixduart.com", true },
  { "felixkaaman.com", true },
  { "felixklein.com", true },
  { "felixklenner.de", true },
  { "felixqu.com", true },
  { "felixsanz.com", true },
  { "felixseele.de", true },
  { "felsing.net", true },
  { "feltons.me", true },
  { "femastudios.com", true },
  { "feminina.pt", true },
  { "feministreview.cf", true },
  { "feministspectrum.org", true },
  { "feministwiki.org", true },
  { "femmes-women.gc.ca", true },
  { "femmes.gc.ca", true },
  { "femmesaupluriel.com", true },
  { "femtomind.com", true },
  { "feng-hhcm.com", true },
  { "feng.si", true },
  { "fengchuiyudaqu.ml", true },
  { "fengyi.tel", true },
  { "fenhl.net", true },
  { "fenichelar.com", true },
  { "fenixhost.com.br", true },
  { "fenom.com", true },
  { "fenster-bank.at", true },
  { "fenster-bank.de", true },
  { "feragon.net", true },
  { "ferc.gov", true },
  { "fergtm.com", true },
  { "feriehus-danmark.no", true },
  { "ferien-netzwerk.de", true },
  { "ferienchalet-wallis.ch", true },
  { "ferienhaeuser-krummin.de", true },
  { "ferienhaus-danemark-hund.de", true },
  { "ferienhaus-danemark-privat.de", true },
  { "ferienhaus-laesoe.de", true },
  { "ferienhaus-polchow-ruegen.de", false },
  { "ferienhaus-urlaub-danemark.de", true },
  { "ferienhausprovence.ch", true },
  { "ferienstpeter.de", true },
  { "ferienwohnung-hafeninsel-stralsund.de", true },
  { "ferienwohnung-wiesengrund.eu", true },
  { "ferieservice.dk", true },
  { "feriespotter.dk", true },
  { "ferlc.org", true },
  { "ferm-rotterdam.nl", true },
  { "fermabel.com.br", true },
  { "fern.health", true },
  { "fernandes.org", true },
  { "fernandob.com", true },
  { "fernandobarata.pt", true },
  { "fernandobarillas.com", true },
  { "fernandomiguel.net", true },
  { "fernland.com.au", true },
  { "feross.net", true },
  { "feross.org", true },
  { "ferprobolivia.com", true },
  { "ferrada.org", false },
  { "ferrariadvisor.it", true },
  { "ferret.zone", true },
  { "ferreteriaxerez.com", true },
  { "ferriswheelofficial.us", true },
  { "ferrolatino.ch", true },
  { "ferrone.ru", true },
  { "ferrousmoon.com", true },
  { "ferry.tw", true },
  { "ferticare.pt", true },
  { "fertigasi.com", true },
  { "fertila.de", true },
  { "festaprylar.se", true },
  { "festesuniversitaries.tk", true },
  { "festival-tipps.com", true },
  { "festival-transform.com", true },
  { "festival-transform.fr", true },
  { "festivaldimouamaroussiou.gr", true },
  { "festivaljapon.com", true },
  { "festivalpopayan.tk", true },
  { "festx.co.za", true },
  { "fetch.co.uk", true },
  { "fetchease.com", true },
  { "fetishbazar.cz", true },
  { "fetlife.com", true },
  { "fettlaus.de", true },
  { "feudalisten.de", true },
  { "feuerhaken.org", true },
  { "feuerhuhn.de", true },
  { "feuerloescher-arten.de", true },
  { "feuerloescher-test.de", true },
  { "feuerwehr-coesfeld.de", true },
  { "feuerwehr-gebirge.de", true },
  { "feuerwehr-heiligenberg.de", true },
  { "feuerwehr-illmensee.de", true },
  { "feuerwehr-mehring.de", true },
  { "feuerwehr-offenbach-bieber.de", false },
  { "feuerwehr-vechta.de", true },
  { "feuerwehrbadwurzach.de", true },
  { "feuerwerksmanufaktur.de", true },
  { "feuetgloire.com", false },
  { "fewo-hafeninsel-stralsund.de", true },
  { "fewo-thueringer-wald.de", true },
  { "fewo32.de", true },
  { "feybiblia.com", true },
  { "ff-bad-hoehenstadt.de", true },
  { "ff-koenigstein-opf.de", true },
  { "ff-obersunzing-niedersunzing.de", true },
  { "ff00228.com", false },
  { "ff14-mstdn.xyz", false },
  { "ff18.cc", true },
  { "ff326.com", true },
  { "ff396.com", true },
  { "ff612.com", true },
  { "ff675.com", true },
  { "ff769.com", true },
  { "ff861.com", true },
  { "ff916.com", true },
  { "ff956.com", true },
  { "ff965.com", true },
  { "ff967.com", true },
  { "ff976.com", true },
  { "ffb.gov", false },
  { "ffbans.org", true },
  { "fff-du.de", true },
  { "fffinfo.de", true },
  { "ffg.berlin", true },
  { "ffiec.gov", true },
  { "ffis.me", true },
  { "ffkoenigsberg.de", true },
  { "fflone.com", true },
  { "ffmradio.de", true },
  { "ffmv.de", true },
  { "ffprofile.com", true },
  { "ffrev.de", true },
  { "ffsociety.nl", true },
  { "ffvideo.xyz", true },
  { "ffw-zeven.de", true },
  { "ffzeven.de", true },
  { "fgsv-heureka.de", true },
  { "fgsv-kongress.de", true },
  { "fh169.cc", true },
  { "fhar.be", true },
  { "fhba.com.au", true },
  { "fhconseil.fr", false },
  { "fhdhelp.de", false },
  { "fhdhilft.de", false },
  { "fheuschen.de", true },
  { "fhfaoig.gov", true },
  { "fhinds.co.uk", true },
  { "fhservices.com.au", true },
  { "fi.google.com", true },
  { "fi.search.yahoo.com", false },
  { "fiam.me", true },
  { "fiareapp.red", false },
  { "fiasgo.com", true },
  { "fiasgo.dk", true },
  { "fiasgo.i.ng", true },
  { "fibercoverage.com", true },
  { "fibo-forex.org", true },
  { "fibra.click", true },
  { "fibrasynormasdecolombia.com", true },
  { "fibretv.co.nz", true },
  { "fibretv.tv", true },
  { "fibromuebles.com", true },
  { "fichier-pdf.fr", true },
  { "fickweiler.nl", true },
  { "fidanza.eu", true },
  { "fidelapp.com", true },
  { "fidelis-it.ch", true },
  { "fidelis-it.net", true },
  { "fidhouriet.ch", true },
  { "fidias.com.br", true },
  { "fidoo.com", true },
  { "fiduciaire-azur.com", true },
  { "fiduciaire-ratio.ch", false },
  { "fieggen.eu", true },
  { "fieggen.net", true },
  { "fieldexpert.eu", true },
  { "fieldwork-paysage.com", false },
  { "fierlafijn.net", true },
  { "fierscleaning.nl", true },
  { "fiery.me", true },
  { "fierykitchen.pl", false },
  { "fietsvierdaagsen.nl", true },
  { "fifacup.ga", true },
  { "fifautstore.com", true },
  { "fifei.de", true },
  { "fifichachnil.paris", true },
  { "fifr.nl", true },
  { "fiftynorth.eu", true },
  { "fiftyonetielt.be", true },
  { "figan.cz", true },
  { "fight215.com", true },
  { "fight215.org", true },
  { "figinstitute.org", true },
  { "figliasons.com", true },
  { "figshare.com", true },
  { "figurasdelinguagem.com.br", true },
  { "figure.nz", true },
  { "fiilr.com", true },
  { "fiix.io", true },
  { "fijnewoensdag.nl", true },
  { "fiken.no", true },
  { "fikriwildannugraha.com", true },
  { "fikst.com", true },
  { "fil-tec-rixen.com", true },
  { "filamentia.nl", true },
  { "filanthropystar.org", true },
  { "filaretihairlove.gr", true },
  { "file-pdf.it", true },
  { "filebox.one", true },
  { "filecloud.fun", true },
  { "filecopa.com", true },
  { "filedesc.com", true },
  { "filehash.de", true },
  { "filehippo.com", true },
  { "files.com", true },
  { "files.from-me.org", true },
  { "fileservicios.com.ar", true },
  { "filestar.io", true },
  { "filestartest.io", true },
  { "filesuffix.com", true },
  { "filezilla-project.org", true },
  { "filhin.es", true },
  { "filhodohomem.com", true },
  { "fili.com", true },
  { "filidorwiese.nl", true },
  { "filiio.com", true },
  { "filingsmadeeasy.com", true },
  { "filip-prochazka.com", false },
  { "filippo.io", true },
  { "filipsebesta.com", true },
  { "fillo.sk", true },
  { "film-colleges.com", true },
  { "film-op-tv.nl", true },
  { "film-storyboards.fr", true },
  { "film-tutorial.com", true },
  { "filmarchiv-sachsen.de", true },
  { "filmatiporno.xxx", true },
  { "filmcrewdb.com", true },
  { "filme-onlines.com", true },
  { "filmers.net", true },
  { "filmitis.com", true },
  { "filmpronet.in", true },
  { "filmreviewonline.com", true },
  { "filmserver.de", true },
  { "filmsite-studio.com", true },
  { "filmwallpapers.ml", true },
  { "filoo.de", true },
  { "filstop.com", true },
  { "filterlists.com", true },
  { "filtr.me", true },
  { "fimfiction.net", true },
  { "fimozin.ga", true },
  { "fimp.pt", true },
  { "fimsquad.com", true },
  { "finagosolo.com", true },
  { "final-expense-quotes.com", true },
  { "finalrewind.org", true },
  { "finalx.nl", true },
  { "finance-colleges.com", true },
  { "finance-news.ga", true },
  { "financejobs.ch", true },
  { "financialfreedomaus.com", true },
  { "finansa.no", true },
  { "finanstilsynet.dk", true },
  { "finanziero.de", true },
  { "finch.am", true },
  { "find-job-in.com", true },
  { "find-mba.com", true },
  { "finda.ae", true },
  { "findaffordablehousing.ca", true },
  { "findapinball.com", true },
  { "findautoloan.ml", true },
  { "findelahistoria.com", true },
  { "findingkorea.com", false },
  { "findingtheuniverse.com", true },
  { "finditez.com", true },
  { "findlocalproduce.co.uk", true },
  { "findoon.de", true },
  { "findrejsepartner.dk", true },
  { "findsingledating.ml", true },
  { "findstorenearme.ca", true },
  { "findstorenearme.co.uk", true },
  { "findstorenearme.us", true },
  { "findtreatment.gov", false },
  { "findyourtrainer.com", true },
  { "findyourvoice.ca", true },
  { "finefriends.nl", true },
  { "finefriends.social", true },
  { "finefriendsapp.com", true },
  { "finehealth.ru", true },
  { "finelovedolls.com", true },
  { "finenet.com.tw", true },
  { "finestrabatalera.tk", true },
  { "finestreview.cf", true },
  { "finestrina.net", true },
  { "finethin.com.br", true },
  { "finevegashomes.com", true },
  { "finewineonline.com", true },
  { "finext.cz", true },
  { "finflix.net", true },
  { "finform.ch", true },
  { "fini-de-jouer.ch", false },
  { "finilaviolence.gc.ca", true },
  { "finisron.in", true },
  { "finkelstein.fr", true },
  { "finkmartin.com", true },
  { "finlito.tk", true },
  { "finn.io", true },
  { "finnclass.cz", true },
  { "finnwea.com", true },
  { "finotax.com", true },
  { "fins.money", true },
  { "finsprings.org", true },
  { "fintandunleavy.com", false },
  { "fintry.ca", true },
  { "finvantage.com", true },
  { "finwe.info", true },
  { "finzy.com", true },
  { "fionafuchs.de", true },
  { "fionamcbride.com", true },
  { "fioristionline.it", true },
  { "fioristionline.net", true },
  { "fioritic.com", true },
  { "fioulmarket.fr", true },
  { "fir3net.com", true },
  { "firc.de", true },
  { "fire-schools.com", true },
  { "firebaseio.com", true },
  { "firebirdrangecookers.com", true },
  { "firebounty.com", true },
  { "fireboxfood.com", true },
  { "firecareandsecurity.co.uk", true },
  { "firecore.com", true },
  { "firecry.org", true },
  { "firefense.com", true },
  { "firefighters.dating", true },
  { "fireflyiii.spdns.org", true },
  { "firegeisha.com", true },
  { "fireglow.de", true },
  { "firegoby.jp", true },
  { "fireleadership.gov", true },
  { "firemist.com", true },
  { "firemudfm.com", true },
  { "firenews.cf", true },
  { "firenza.org", true },
  { "fireorbit.de", false },
  { "fireportal.cz", true },
  { "fireportal.sk", true },
  { "firerain.me", true },
  { "fireshellsecurity.team", true },
  { "firesofheaven.org", true },
  { "firestuff.org", true },
  { "firetotheprisons.org", true },
  { "firevap.org", true },
  { "fireworksshowvr.com", true },
  { "firexfly.com", true },
  { "firma-cerny.cz", true },
  { "firma-offshore.com", true },
  { "firmajulegaver.dk", true },
  { "firmament.space", true },
  { "firmapi.com", true },
  { "firmen-assekuranz.de", true },
  { "firmenwerbung-vermarktung.de", true },
  { "firmware.science", true },
  { "first-house.no", true },
  { "first-time-offender.com", true },
  { "first.org", true },
  { "first4it.com", true },
  { "firstbooks.ml", true },
  { "firstchoicebouncycastlehire.co.uk", true },
  { "firstchoicecandy.com", true },
  { "firstchoicefriseur.at", true },
  { "firstclasscastles.com", true },
  { "firstclassleisure.co.uk", true },
  { "firstcoastteaco.com", true },
  { "firstderm.com", true },
  { "firstdorsal.eu", true },
  { "firstdry.com.br", true },
  { "firstfinca.de", true },
  { "firstinnovationltd.com", true },
  { "firstmall.de", true },
  { "firstnet.gov", true },
  { "firstnetworksouth.com", true },
  { "firstq.xyz", true },
  { "firstrays.com", true },
  { "firstwebring.tk", true },
  { "firtreetechnology.co.uk", true },
  { "fischer-kundendienst.de", true },
  { "fischers.cc", true },
  { "fiscoeconti.it", true },
  { "fish-hook.ru", true },
  { "fish4dogs.com", true },
  { "fishermailbox.net", true },
  { "fishermansbendcorporation.com.au", true },
  { "fishermansbendtownhouses.com.au", true },
  { "fishexport.eu", true },
  { "fishgen.no", true },
  { "fishlanestudios.com", true },
  { "fishoilsafety.com", true },
  { "fishtacos.blog", true },
  { "fisinfomanagerdr.com", true },
  { "fisiobox.eu", true },
  { "fisioterapista.roma.it", true },
  { "fiskalnepretor.pl", true },
  { "fiskelures.se", true },
  { "fit-4u.ch", false },
  { "fit-mit-nina.com", true },
  { "fit365.jp", false },
  { "fitchconnect.com", true },
  { "fite.family", true },
  { "fitequilibrio.com.br", true },
  { "fitinclass.com", true },
  { "fitkram.cz", true },
  { "fitness-challenge.co.uk", true },
  { "fitness.gov", true },
  { "fitnesskarate.club", true },
  { "fitnessunder50.com", true },
  { "fito.tk", true },
  { "fittelo.cz", true },
  { "fittingperfetto.it", true },
  { "fitzsim.org", true },
  { "fivestartrader.com", true },
  { "fivethirtyeight.com", true },
  { "fixatom.com", true },
  { "fixed.supply", true },
  { "fixedtodayplumbing.com.au", true },
  { "fixel.express", true },
  { "fixfm.tk", true },
  { "fixforce.nl", true },
  { "fixhotsauce.com", true },
  { "fixingscrews.co.uk", true },
  { "fixlasvegas.com", true },
  { "fixmyalarmpanel.co.uk", true },
  { "fixmycomputerdude.com", true },
  { "fizadvocaten.nl", true },
  { "fiziktedavi.name.tr", true },
  { "fizyoterapi.name.tr", true },
  { "fizz.buzz", false },
  { "fizzgi.gs", true },
  { "fj.je", true },
  { "fj.search.yahoo.com", false },
  { "fj.simple.com", false },
  { "fjdekermadec.com", true },
  { "fjordboge.dk", true },
  { "fjzone.org", true },
  { "fkfev.de", true },
  { "fkosquad.moe", true },
  { "fkraiem.org", true },
  { "fktpm.ru", true },
  { "flaemig42.de", false },
  { "flagburningworld.com", true },
  { "flagfox.net", true },
  { "flaggorvarlden.se", true },
  { "flagi-panstw.pl", true },
  { "flagistrany.ru", true },
  { "flagpedia.asia", true },
  { "flagpedia.net", true },
  { "flagshop.jp", true },
  { "flagspot.net", false },
  { "flam3d.be", true },
  { "flam3d.nl", true },
  { "flam3d.org", true },
  { "flamero.fi", true },
  { "flamet.eu", true },
  { "flameworked.com", true },
  { "flamingkeys.com", true },
  { "flamingowomenspavilion.com", true },
  { "flamme-von-anor.de", true },
  { "flana.com", true },
  { "flanga.io", true },
  { "flanga.org", true },
  { "flangaapis.com", true },
  { "flapoverspeed.com", true },
  { "flare.cloud", true },
  { "flashback.org", true },
  { "flashbeing.com", true },
  { "flashcomp.cz", true },
  { "flashgamedev.tk", true },
  { "flashgot.net", true },
  { "flass.lu", true },
  { "flassetlocators.com", true },
  { "flat.io", true },
  { "flatbellyreview.com", true },
  { "flatbook.one", true },
  { "flatmail.pl", true },
  { "flatmatehub.com.au", true },
  { "flatpackmates.co.uk", true },
  { "flauschig.net", true },
  { "flavinus.fr", true },
  { "flaviu.co.uk", true },
  { "flavo.io", true },
  { "flawlesscowboy.xyz", true },
  { "flcatering.com", true },
  { "flealab.it", true },
  { "fleep.io", true },
  { "fleesty.dynv6.net", true },
  { "fleet-group.com", true },
  { "fleet-search.com", true },
  { "fleetcor.at", true },
  { "fleetcor.ch", true },
  { "fleetcor.cz", true },
  { "fleetcor.de", true },
  { "fleetcor.fr", true },
  { "fleetcor.hu", true },
  { "fleetcor.lu", true },
  { "fleetcor.nl", true },
  { "fleetcor.pl", true },
  { "fleetcor.sk", true },
  { "fleetcorcards.be", true },
  { "fleetsmith.com", true },
  { "fleetssl.com", true },
  { "fleetyards.net", true },
  { "flehm.de", true },
  { "fleisch.club", true },
  { "flers-agglo.fr", true },
  { "flerstourisme.fr", true },
  { "fletcherdigital.com", true },
  { "fletchto99.com", true },
  { "fletemaritimo.online", true },
  { "flets-ms.com", true },
  { "fleurenplume.fr", true },
  { "fleursdujour.ph", true },
  { "fleuryfleury.com", true },
  { "flexapplications.se", true },
  { "flexbuildingsystems.com", true },
  { "flexfunding.com", true },
  { "fleximaal.com", true },
  { "fleximal.com", true },
  { "fleximus.org", false },
  { "flexport.com", true },
  { "flexstart.me", true },
  { "fliacuello.com.ar", true },
  { "flibusta.appspot.com", true },
  { "flickcritter.com", true },
  { "flieger-funk-runde.de", true },
  { "fliesen-waldschmidt.de", true },
  { "flight.school", true },
  { "flightdeckfriend.com", true },
  { "flightmedx.com", true },
  { "flightright.at", true },
  { "flightright.co.uk", true },
  { "flightright.com", true },
  { "flightright.de", true },
  { "flightright.es", true },
  { "flightright.fr", true },
  { "flightright.it", true },
  { "flightright.se", true },
  { "flightschoolbooking.com", true },
  { "flightschoolcandidates.gov", true },
  { "flightzero.cf", true },
  { "fliino.com", true },
  { "fliino.eu", true },
  { "fliino.info", true },
  { "fliino.net", true },
  { "fliino.org", true },
  { "flinch.io", true },
  { "flip.kim", true },
  { "flipmusic.tk", true },
  { "flipneus.net", true },
  { "flipphotography.ga", true },
  { "fliptable.org", true },
  { "flirt-norden.de", true },
  { "flirtee.net", true },
  { "flirtfaces.de", true },
  { "flirtos.de", true },
  { "flixcheck.de", true },
  { "flixstats.com", true },
  { "flixtube.me", true },
  { "flmortgagebank.com", true },
  { "floaternet.com", true },
  { "flockbox.club", true },
  { "flocktofedora.org", true },
  { "floersheimer-openair.de", true },
  { "floffi.media", true },
  { "floify.com", true },
  { "flokinet.is", true },
  { "flokkr.com", true },
  { "flonharmonymassage.space", true },
  { "floobits.com", true },
  { "floodsmart.gov", true },
  { "floogulinc.com", true },
  { "floorballphilippines.tk", true },
  { "flooringnightmares.com", true },
  { "flooringsourcetx.com", true },
  { "floors4lessbay.com", true },
  { "floort.net", false },
  { "floraclick.net", true },
  { "floraexpress.it", true },
  { "florafiora.com.br", false },
  { "florausa.net", true },
  { "floravan.com", true },
  { "floravino.de", true },
  { "florence.uk.net", true },
  { "florenceapp.co.uk", true },
  { "florenciasabio.com", true },
  { "florent-tatard.fr", true },
  { "florentynadawn.co.uk", true },
  { "florian-bachelet.fr", true },
  { "florian-lefevre.fr", true },
  { "florian-thie.de", true },
  { "florianbecker.it", true },
  { "floriankarmen.com", true },
  { "floriankeller.de", true },
  { "florianmitrea.uk", true },
  { "florianschmitt.ca", true },
  { "floriantanner.ch", true },
  { "florida-immigration.com", true },
  { "floridafabrication.net", true },
  { "floridahomesinvest.com", true },
  { "floridamainmovers.com", true },
  { "floridasexhealth.com", true },
  { "floridawaterapparel.net", true },
  { "floridaweightlossdoctors.com", true },
  { "florinlungu.it", true },
  { "florismouwen.com", false },
  { "floristik-online.com", true },
  { "floristmou.com", true },
  { "florisvdk.net", true },
  { "floriswesterman.nl", true },
  { "flosch.at", false },
  { "floskelwolke.de", true },
  { "flossexanten.de", true },
  { "flourishtogether.com", true },
  { "flow.su", true },
  { "flowcom.de", true },
  { "flowersquito.com", true },
  { "flowinity.com", true },
  { "flowinvoice.com", true },
  { "flowreader.com", true },
  { "flra.gov", true },
  { "fluffy.moe", true },
  { "fluffycloud.de", true },
  { "fluggesellschaft.de", true },
  { "fluglektuere.com", true },
  { "fluidmeterusa.com", true },
  { "fluidpicturesinc.com", true },
  { "fluids.ac.uk", true },
  { "fluitbeurt.nl", true },
  { "flumble.nl", true },
  { "flunschi.goip.de", true },
  { "fluoxetine.net", true },
  { "flushlife.com", true },
  { "fluteandpianoteaching.co.uk", true },
  { "flux.healthcare", true },
  { "fluxfingers.net", true },
  { "fluxforge.com", true },
  { "fluxi.fi", true },
  { "fluxoid.com", true },
  { "flw365365.com", true },
  { "fly-en-drive.nl", true },
  { "fly.moe", true },
  { "flyadrenaline.com", true },
  { "flyavantar.com", true },
  { "flyawaybirds.ga", true },
  { "flyboyfpv.com", true },
  { "flydrivesicilie.nl", true },
  { "flyer.tools", true },
  { "flyersmarket.com", true },
  { "flygon.pink", true },
  { "flying-dudes.de", true },
  { "flyinghigh.co.jp", true },
  { "flyinglocksmiths.com", true },
  { "flyingpackets.net", true },
  { "flyingrub.me", true },
  { "flymns.fr", true },
  { "flynn.io", true },
  { "flyp.me", true },
  { "flypenge.dk", true },
  { "flyserver.co.il", false },
  { "flyswoop.com", true },
  { "flyt.online", true },
  { "flytoadventures.com", true },
  { "flywus.com", true },
  { "fm.ie", true },
  { "fmbilder.se", true },
  { "fmcs.gov", true },
  { "fmdance.cl", true },
  { "fmeventcentre.com", true },
  { "fminsight.net", true },
  { "fmodoux.biz", false },
  { "fmussatmd.com", true },
  { "fnanen.net", true },
  { "fnbnokomis.com", true },
  { "fnh-expert.net", true },
  { "fnkr.net", true },
  { "fnof.ch", true },
  { "fnordserver.eu", true },
  { "fnpro.eu", true },
  { "foair.me", true },
  { "foairbus.fr", false },
  { "foairbussas.fr", false },
  { "focanamoda.com.br", true },
  { "focanocliente.com.br", true },
  { "focusmark.jp", false },
  { "focusministries1.org", true },
  { "focuspointtechnologies.com", true },
  { "foej-aktiv.de", true },
  { "foej.net", true },
  { "foerster.gmbh", true },
  { "fogway.net", true },
  { "foia.gov", true },
  { "foiaonline.gov", true },
  { "foixet.com", true },
  { "fojing.com", true },
  { "fojt.cz", true },
  { "fojtova.cz", true },
  { "fojtovi.cz", true },
  { "fokan.be", true },
  { "fokan.ch", true },
  { "fokep.no", true },
  { "fokus.ag", true },
  { "folar.ga", true },
  { "folio.no", true },
  { "foliumbiosciences.com", true },
  { "foliumfinance.com", true },
  { "foljeton.dk", true },
  { "folk.as", true },
  { "follandviolins.com", true },
  { "followback.net", true },
  { "follower98.ir", true },
  { "followmystaff.com", true },
  { "followthatpage.com", true },
  { "followthedog.co.uk", true },
  { "foluomeng.net", true },
  { "folv.es", true },
  { "folwark.krakow.pl", true },
  { "folwarkwiazy.pl", true },
  { "fomopop.com", true },
  { "fonamperu.org.pe", true },
  { "fondationwiggli.ch", true },
  { "fondy.eu", true },
  { "fondy.ru", true },
  { "fondy.ua", true },
  { "fonga.ch", true },
  { "fonline.tk", true },
  { "fono.jp", true },
  { "fonolo.com", true },
  { "fonseguin.ca", true },
  { "font-converter.net", true },
  { "fonte-trading.com", true },
  { "fontedoprazer.com", true },
  { "fontein.de", true },
  { "fontlibrary.org", true },
  { "fonts4free.net", true },
  { "fonzone.it", true },
  { "foo.fo", true },
  { "foo.hamburg", true },
  { "food4healthybones.com", true },
  { "foodattitude.ch", false },
  { "foodboy.com", true },
  { "foodev.de", true },
  { "foodlist.net", true },
  { "foodloader.net", true },
  { "foodsafety.gov", true },
  { "foodsafetyjobs.gov", true },
  { "foodsoul.pro", true },
  { "foodwise.marketing", true },
  { "foolip.org", true },
  { "foolwealth.com", true },
  { "foonly.fi", true },
  { "foorack.com", true },
  { "fooster.io", true },
  { "foot.fr", true },
  { "footagecrate.com", true },
  { "footballforum.de", true },
  { "footballsrit.tk", true },
  { "for.care", false },
  { "foray-jero.me", true },
  { "forbidden-mods.de", true },
  { "forcelink.eu", true },
  { "forcelink.nl", true },
  { "forcelinkamerica.com", true },
  { "forcelinkamerica.nl", true },
  { "forcewave.com", true },
  { "ford-mustang.tk", true },
  { "ford-shop.by", true },
  { "ford.com.au", true },
  { "ford.com.br", true },
  { "ford.com.cn", true },
  { "ford.mx", true },
  { "fordlibrarymuseum.gov", true },
  { "fordsync.com", true },
  { "foreachcode.com", true },
  { "forecastcity.com", true },
  { "foreclosureattorneyhouston.com", true },
  { "forefrontcloud.com", true },
  { "foregroundweb.com", true },
  { "foreign-language-colleges.com", true },
  { "foreignxchange.com.au", true },
  { "forellenpark.com", true },
  { "forensicsoftware.biz", true },
  { "forento.be", true },
  { "forestraven.net", true },
  { "forevergreens.us", true },
  { "foreverssl.com", true },
  { "foreversummertime.com", true },
  { "forewordreviews.com", true },
  { "forex-giants.com", true },
  { "forex.ee", true },
  { "forexarby.com", true },
  { "forexchef.de", true },
  { "forexcity.cf", true },
  { "forexee.com", true },
  { "forextickler.com", true },
  { "forextimes.ru", true },
  { "forextraders.com", true },
  { "forfeit.ga", true },
  { "forfeiture.gov", true },
  { "forfunssake.co.uk", true },
  { "forge-goerger.eu", false },
  { "forgotten-legends.org", true },
  { "form3w.nl", true },
  { "formacionyestudios.com", true },
  { "formalgrammar.tk", true },
  { "formality.one", true },
  { "forman.store", true },
  { "formapi.io", true },
  { "format-paysage.ch", false },
  { "formation-assureur.com", true },
  { "formation-mac.ch", false },
  { "formationseeker.com", true },
  { "formi9.com", true },
  { "formio.nl", true },
  { "formsbyair.com", true },
  { "formsmarts.com", true },
  { "formula-ot.ru", true },
  { "formulacionquimica.com", true },
  { "formulastudent.de", true },
  { "fornoreason.net.au", true },
  { "fornwall.net", true },
  { "foroaranda.com", true },
  { "forodeespanol.com", true },
  { "forodieta.com", false },
  { "forokd.com", true },
  { "forrestheller.com", true },
  { "forro.info", true },
  { "forsaleinedmonton.ca", true },
  { "forsec.nl", true },
  { "forsi.xyz", true },
  { "forstbetrieb-hennecke.de", true },
  { "forstprodukte.de", true },
  { "fortdodgeradio.com", true },
  { "forteggz.nl", true },
  { "forthetoys.com", true },
  { "forthewin.rocks", true },
  { "forthvalleykeswick.co.uk", true },
  { "fortnine.ca", true },
  { "fortran.io", true },
  { "fortress.no", true },
  { "fortress.sk", true },
  { "fortuna-apotheke-lahnstein.de", true },
  { "fortuna.co.ua", true },
  { "forty-two.nl", true },
  { "forty8creates.com", true },
  { "fortygordy.com", true },
  { "fortytwo.cloud", true },
  { "forum-4.com", true },
  { "forum-bonn.de", true },
  { "forum-egypte.tk", true },
  { "forum-noginska.tk", true },
  { "forum-tutorapide.ml", true },
  { "forum.quantifiedself.com", false },
  { "forumcarriocity.tk", true },
  { "forumdimo.fr", true },
  { "forumirc.net", true },
  { "forumotomobil.com", true },
  { "forumpakistan.tk", true },
  { "forumstandaardisatie.nl", true },
  { "forumvoordemocratie.nl", true },
  { "forvisualdesign.com", false },
  { "forward-fly-fishing.ch", false },
  { "foryourhealthybody.com", true },
  { "fos-apps.org", true },
  { "fos-games.org", true },
  { "fosaudit.com", true },
  { "foscamcanada.com", true },
  { "fosdem.org", true },
  { "foselectro.ru", true },
  { "fosgreece.com", true },
  { "fossdaily.xyz", true },
  { "fossforward.com", true },
  { "fossilfreeyale.org", true },
  { "fosterpark.ca", true },
  { "fotella.com", true },
  { "fotl.ua", true },
  { "foto-janvanaefst.nl", true },
  { "foto-leistenschneider.de", true },
  { "foto-leitner.com", true },
  { "foto-leitner.de", true },
  { "foto-robitsch.at", true },
  { "foto-roma.ru", true },
  { "foto.by", true },
  { "fotoblog.nrw", true },
  { "fotoboxvysocina.cz", true },
  { "fotofaerie.net", true },
  { "fotoflits.net", true },
  { "fotofon.tk", true },
  { "fotografechristha.nl", true },
  { "fotografiadellalucerossa.com", true },
  { "fotografiamakro.pl", true },
  { "fotohome.dk", true },
  { "fotokomorkomania.pl", true },
  { "fotoleitner.com", true },
  { "fotoleitner.de", true },
  { "fotonjan.com", true },
  { "fotopalacedigitalstudio.tk", true },
  { "fotostravestisbr.com", true },
  { "fotostudio-leitner.com", true },
  { "fotostudio-leitner.de", true },
  { "fotostudio-schweiz.ch", true },
  { "fotowolfy.com", true },
  { "fougner.co", true },
  { "found.website", true },
  { "foundationrepairnebraska.com", true },
  { "foundationspecialistmi.com", true },
  { "foundchurch.co.uk", true },
  { "founded.ml", true },
  { "founderio.net", true },
  { "foundsounds.me", true },
  { "fourashesgolfcentre.co.uk", true },
  { "fourashesgolfcentre.com", true },
  { "fourfourcrew.com", true },
  { "fourmies.fr", true },
  { "fournarisopenday.com", true },
  { "fourscore.ga", true },
  { "fourxone.com", true },
  { "fowlervwparts.com", true },
  { "fowlsmurf.net", true },
  { "fox.my", false },
  { "foxes.no", true },
  { "foxesare.sexy", true },
  { "foxhillshotel.com", true },
  { "foxo.blue", true },
  { "foxontheinter.net", true },
  { "foxphotography.ch", false },
  { "foxquill.com", false },
  { "foxroy.com", true },
  { "foxstreetcomms.co.za", false },
  { "foxtrotfm.tk", true },
  { "fozzie.co.uk", true },
  { "fozzie.space", true },
  { "fpasca.com", true },
  { "fpc.gov", false },
  { "fpersona.com", true },
  { "fps73.ru", true },
  { "fpsclasico.de", true },
  { "fpsv.de", true },
  { "fpt-technojapan.com", true },
  { "fpy.cz", true },
  { "fr.search.yahoo.com", false },
  { "fr33tux.org", true },
  { "frack.nl", false },
  { "fracreazioni.it", true },
  { "fraesentest.de", true },
  { "frag.works", true },
  { "fragmentspuren.de", true },
  { "fragstore.net", true },
  { "fraho.eu", true },
  { "frail.gq", true },
  { "framapiaf.org", false },
  { "framboise314.fr", true },
  { "framer.com", true },
  { "framezdakkapellen.nl", true },
  { "fran.cr", true },
  { "fran.id", true },
  { "france-news.cf", true },
  { "francepandi.fr", true },
  { "francesca-and-lucas.com", true },
  { "francescopalazzo.com", true },
  { "francescopandolfibalbi.it", true },
  { "francescoyatesfansite.com", true },
  { "francetraceur.fr", true },
  { "franchini.email", true },
  { "franchini.engineer", true },
  { "franchisehive.com", true },
  { "francinebelanger.network", true },
  { "francis.ph", true },
  { "francisli.net", false },
  { "franckgirard.net", true },
  { "franckyz.com", true },
  { "francois-occasions.be", false },
  { "francoisbelangerboisclair.com", true },
  { "francoise-paviot.com", true },
  { "francoisharvey.ca", true },
  { "francoislepage.com", false },
  { "francoz.me", true },
  { "frandor.co.uk", true },
  { "frank.fyi", true },
  { "frankbellamy.co.uk", true },
  { "frankellawfirm.com", true },
  { "franken-lehrmittel.de", true },
  { "frankenhost.de", true },
  { "frankenlehrmittel.de", true },
  { "frankieburkeactor.tk", true },
  { "frankieistanbul.com", true },
  { "frankierfachmann.de", true },
  { "frankierprofi.de", true },
  { "frankierstar.de", true },
  { "frankinteriordesign.co.uk", true },
  { "frankl.in", true },
  { "franklinmagic.com", true },
  { "frankopol-sklep.pl", true },
  { "frankpalomeque.com", true },
  { "frankslaughterinsurance.com", true },
  { "frankyan.com", true },
  { "franqois.id", true },
  { "frantic1048.com", true },
  { "frantorregrosa.me", true },
  { "franz-vatter.de", true },
  { "franz.beer", true },
  { "franziska-pascal.de", true },
  { "franziskaherbert.de", true },
  { "franzknoll.de", true },
  { "fraplaster.com", true },
  { "frappant.cc", true },
  { "frappant.net", true },
  { "frasch-umzuege.de", true },
  { "fraselab.ru", true },
  { "frasesconemocion.com", true },
  { "frasesdodia.com", true },
  { "frasesdodia.net", true },
  { "frasesparaface.com.br", true },
  { "frasesytarjetas.com", true },
  { "frattaroli.org", true },
  { "frau-inge.de", true },
  { "frau-pusteblu.me", true },
  { "frau-sucht-bauer.de", true },
  { "fraudmarc.com", true },
  { "frauen-etappenrennen.de", true },
  { "frauenarzt-niendorf.de", false },
  { "frauenarzt-zinke.de", true },
  { "frauenlob.rocks", true },
  { "fraufries.de", true },
  { "fraurichter.net", true },
  { "fraye.net", true },
  { "frazell.net", true },
  { "frbracch.it", true },
  { "frc.gov", true },
  { "frdl.ch", false },
  { "freaksites.dk", true },
  { "freaksports.com.au", true },
  { "freakyawesome.com", true },
  { "frebib.co.uk", true },
  { "frebib.com", true },
  { "frebib.net", true },
  { "freddieleeman.nl", true },
  { "fredericcote.com", true },
  { "frederik-braun.com", false },
  { "frederikshavn.net", true },
  { "frederikvig.com", true },
  { "fredhook.tk", true },
  { "fredloya.com", true },
  { "fredriksslaktforskning.se", true },
  { "freds4buildings.com", true },
  { "fredsmith.net", true },
  { "fredsmith.org", true },
  { "fredsmith.us", true },
  { "fredvoyage.fr", true },
  { "free-bitco.ml", true },
  { "free-generate.tk", true },
  { "free-ss.site", true },
  { "free.com.tw", true },
  { "freeaf.gq", true },
  { "freebarrettbrown.org", true },
  { "freebcard.com", true },
  { "freebegames.tk", true },
  { "freebetoffers.co.uk", true },
  { "freebies.id", true },
  { "freebookmakersbetsandbonuses.com.au", true },
  { "freeboson.org", true },
  { "freebsd.la", true },
  { "freebsd.one", true },
  { "freebsd.wiki", true },
  { "freebsdbrasil.com.br", true },
  { "freebus.org", true },
  { "freecloud.at", true },
  { "freecookies.nl", true },
  { "freedev.cz", true },
  { "freedgb.com", true },
  { "freedom.nl", false },
  { "freedom.press", true },
  { "freedom35.org", true },
  { "freedomfinance.se", true },
  { "freedomflotilla.org", true },
  { "freedomhk.info", true },
  { "freedomhkg.info", true },
  { "freedomhkg.net", true },
  { "freedomhkg.org", true },
  { "freedomonline.bg", true },
  { "freedomrahoitus.fi", true },
  { "freedomtoolkit.com", true },
  { "freeenglishhelp.com", true },
  { "freeexampapers.com", true },
  { "freefilesync.org", true },
  { "freefinancialhelp.net", true },
  { "freeform4u.de", true },
  { "freegame-mugen.jp", true },
  { "freegovernmentcellphoneguide.com", true },
  { "freegutters.com", true },
  { "freeiconspng.com", true },
  { "freeinoutboard.com", true },
  { "freejeremy.net", true },
  { "freekdevries.nl", true },
  { "freeks.com.br", true },
  { "freelance-webdesigner.jp", true },
  { "freelance.boutique", true },
  { "freelance.nl", true },
  { "freelanceessaywriters.com", true },
  { "freelancehunt.com", true },
  { "freelancejobs.org.uk", true },
  { "freelancerhub.online", true },
  { "freelanceunited.co.uk", true },
  { "freelauri.com", true },
  { "freelifer.jp", true },
  { "freemanlogistics.com", true },
  { "freemans.com", true },
  { "freeministryresources.org", true },
  { "freemomhugs.org", true },
  { "freemotion.tk", true },
  { "freemyipod.org", true },
  { "freenetproject.org", true },
  { "freeonplate.com", true },
  { "freepastlife.com", true },
  { "freepnglogos.com", true },
  { "freepublicprofile.com", true },
  { "freertomorrow.com", true },
  { "freeshell.de", true },
  { "freeshkre.li", true },
  { "freesitemapgenerator.com", true },
  { "freesms-online.de", true },
  { "freesnowden.is", true },
  { "freesoft-board.to", false },
  { "freesoftlab.com", true },
  { "freesolitaire.win", true },
  { "freesourcestl.org", true },
  { "freespot.mobi", true },
  { "freessl.tech", true },
  { "freesslcertificate.me", true },
  { "freestylesolutions.com", true },
  { "freetaxusa.com", true },
  { "freethetv.ie", true },
  { "freetrung.tk", true },
  { "freetsa.org", true },
  { "freevision.co", true },
  { "freevst.ir", true },
  { "freeweibo.com", true },
  { "freewerkt.nl", true },
  { "freewoodfactory.com", true },
  { "freeyourmusic.com", true },
  { "freezion.com", true },
  { "freiboth.ddns.net", true },
  { "freie-software.net", true },
  { "freiewaehler-verden.de", true },
  { "freifahrt.de", true },
  { "freifall.tk", true },
  { "freifamily.ch", true },
  { "freifunk-burgaltendorf.de", true },
  { "freifunk-essen.de", true },
  { "freifunk-luenen.de", true },
  { "freimeldungen.de", true },
  { "freims.cc", true },
  { "freitasul.com.br", true },
  { "freitasul.io", true },
  { "freiwuppertal.de", true },
  { "freiwurst.net", true },
  { "freizeitbad-riff.de", true },
  { "freizeitplaza.de", true },
  { "frenchcreekcog.org", true },
  { "frenchguy.ch", true },
  { "frenchmusic.fr", true },
  { "frequencebanane.ch", false },
  { "frequentflyerapp.com", true },
  { "fresh-hotel.org", true },
  { "fresh-networks.net", true },
  { "fresh.co.il", true },
  { "fresh4.co.uk", true },
  { "freshair.com.br", true },
  { "freshbean.club", true },
  { "freshbooks.com", true },
  { "freshdesigns.de", true },
  { "freshdns.nl", true },
  { "freshempire.gov", true },
  { "freshers9.com", true },
  { "freshmaza.com", true },
  { "freshpounds.com", true },
  { "fretscha.com", true },
  { "frettirnar.is", true },
  { "fretworksec.com", true },
  { "freundinnen-ausflug.de", true },
  { "freundinnen-kurzurlaub.de", true },
  { "freundinnen-urlaub.de", true },
  { "freundinnenausflug.de", true },
  { "frforms.com", true },
  { "friarsonbase.com", true },
  { "frickelboxx.de", true },
  { "frickelmeister.de", true },
  { "fridarestaurantemexicano.com", true },
  { "fridaysforfuture-bremen.de", true },
  { "fridolinka.cz", true },
  { "friedberg2020.de", true },
  { "friederes.lu", true },
  { "friederloch.de", true },
  { "friedrich-foto-art.de", true },
  { "friedsamphotography.com", true },
  { "friedstechnology.com", true },
  { "friedstechnology.nl", true },
  { "friedstechnology.online", true },
  { "friedzombie.com", true },
  { "friedzombie.nl", true },
  { "friedzombie.online", true },
  { "friendlycleaners.co.uk", true },
  { "friendlysiberia.com", true },
  { "friendowment.us", true },
  { "friends-of-naz.com", true },
  { "friends-socialgroup.org", true },
  { "friends.tn", true },
  { "friends24.cz", true },
  { "friendship-quotes.co.uk", true },
  { "friendshipismagicsquad.com", true },
  { "friendsofgfwpc.org", true },
  { "friet.org", true },
  { "frietbesteld.nl", true },
  { "frietzombie.nl", true },
  { "friezy.ru", true },
  { "frigi.ch", false },
  { "frign.de", true },
  { "frigolit.net", true },
  { "friller.com.au", true },
  { "frillip.com", true },
  { "fringeintravel.com", true },
  { "frinkiac.com", true },
  { "frino.de", true },
  { "frippz.se", true },
  { "friseur-foerder.de", true },
  { "friss.com", true },
  { "fritz-koehne-schule.de", true },
  { "fritzrepair.com", true },
  { "frizo.com", true },
  { "frizzless.com", true },
  { "fro.se", true },
  { "frob.nl", true },
  { "frode.win", true },
  { "froehliche-hessen.de", true },
  { "frogatto.com", true },
  { "frogeye.fr", true },
  { "froggitt.com", true },
  { "froh.co.jp", true },
  { "frolova.org", true },
  { "fromager.net", true },
  { "fromanolderwoman.com", true },
  { "fromscratch.rocks", true },
  { "fromtheboxoffice.com", true },
  { "fronteers.nl", false },
  { "frontier-ad.co.jp", true },
  { "frontiers.nl", true },
  { "frontline.cloud", true },
  { "frontlinemessenger.com", true },
  { "froogo.co.uk", true },
  { "fropky.com", true },
  { "frosoku.com", true },
  { "frostprotection.co.uk", true },
  { "frostwarning.com", true },
  { "frosty.sk", true },
  { "frothy.coffee", true },
  { "frovi.co.uk", true },
  { "frownonline.co.uk", true },
  { "frozen-geek.net", true },
  { "frozen-solid.net", true },
  { "frozendurian.club", true },
  { "frozenfutures.com", true },
  { "frozenjam.com", true },
  { "frozensector.com", true },
  { "frpg.gov", true },
  { "frprn.com", true },
  { "frprn.es", true },
  { "frprn.xxx", true },
  { "frsra.ml", true },
  { "frtib.gov", true },
  { "frtn.com", true },
  { "frtrains.com", false },
  { "fruchthof24.de", true },
  { "fruchtikus.net", true },
  { "fruend-hausgeraeteshop.de", true },
  { "frugalfamilyhome.com", true },
  { "frugalmechanic.com", true },
  { "frugro.be", true },
  { "fruit-farm.tk", true },
  { "fruition.co.jp", true },
  { "fruitscale.com", true },
  { "fruityten.co.uk", true },
  { "frusky.de", true },
  { "frutasyvejetales.com", true },
  { "fruxprivatebank.net", true },
  { "fryergroup.com", true },
  { "fs-g.org", true },
  { "fs-maistadt.de", true },
  { "fs257.com", true },
  { "fsavc.org.uk", true },
  { "fsbn.eu", true },
  { "fsbnh.bank", true },
  { "fsbpaintrock.com", true },
  { "fsbturton.com", true },
  { "fsch2009.com", true },
  { "fsck.jp", false },
  { "fsckd.com", true },
  { "fscott.de", true },
  { "fsfxpackages.com", true },
  { "fsg.one", true },
  { "fsgeek.ca", true },
  { "fsk.fo", true },
  { "fskounoike.com", true },
  { "fsky.info", true },
  { "fsm2016.org", true },
  { "fsps.ch", true },
  { "fsty.uk", true },
  { "fsvt.ch", false },
  { "ft.com", false },
  { "ftang.de", true },
  { "ftc.gov", false },
  { "ftccomplaintassistant.gov", true },
  { "ftcefile.gov", true },
  { "ftdev.in", true },
  { "ftexchange.com", true },
  { "ftgeufyihreufheriofeuozirgrgd.tk", true },
  { "fthat.link", true },
  { "ftl13.com", true },
  { "ftmc.tk", true },
  { "ftnpower.com", true },
  { "ftptest.net", true },
  { "ftrsecure.com", true },
  { "ftv.re", true },
  { "ftworthhousekeeper.com", true },
  { "ftx.com", true },
  { "ftx.io", true },
  { "fuantaishenhaimuli.net", true },
  { "fuckav.ru", true },
  { "fuckcie.com", true },
  { "fucklife.ch", true },
  { "fucknazis.tk", true },
  { "fuckup.dk", true },
  { "fuckz.net", true },
  { "fuechschen.org", true },
  { "fuelingyourdreams.com", false },
  { "fuerstenfelder-immobilien.de", true },
  { "fuglede.dk", true },
  { "fuite.ch", false },
  { "fuitedeau.ch", false },
  { "fuites.ch", false },
  { "fujianshipbuilding.com", true },
  { "fujiwaraqol.com", true },
  { "fujiwarashinzo.com", true },
  { "fukakukeiba.com", true },
  { "fukata.org", true },
  { "fukikaeru.com", true },
  { "fukt.ca", true },
  { "fukuiedu.com", true },
  { "fukushima-fun.com", true },
  { "fulfilmentcrowd.com", true },
  { "fulgenzis.com", true },
  { "fuliwang.info", true },
  { "fuliwang.us", true },
  { "full-race.com", true },
  { "full-stack.ninja", true },
  { "fullautomotivo.com.br", true },
  { "fullbundle.com", true },
  { "fullcirclestudio.nl", true },
  { "fullerlife.org.uk", true },
  { "fullfilez.com", true },
  { "fullhost.com", true },
  { "fullhub.ru", true },
  { "fullmatch.net", true },
  { "fullmoviez.co", true },
  { "fullstacknotes.com", false },
  { "fumblers.ca", true },
  { "fumerolles.ch", false },
  { "fumo.se", false },
  { "fun-bounce.co.uk", true },
  { "fun-fan.biz", true },
  { "fun-tasia.co.uk", true },
  { "fun4kidzbouncycastles.co.uk", true },
  { "fun4ubouncycastles.co.uk", true },
  { "fun888city.com", true },
  { "fun888city.net", true },
  { "fun88city.com", true },
  { "funadvisor.ca", true },
  { "funadvisorfrance.com", true },
  { "funatic.nl", true },
  { "funcabinrentals.com", true },
  { "funchestra.at", false },
  { "functional.cc", true },
  { "functions-online.com", true },
  { "fundacionfranciscofiasco.org", true },
  { "fundamentt.com", true },
  { "fundavi.jp", true },
  { "fundayltd.com", true },
  { "fundays.nl", true },
  { "fundchan.com", true },
  { "fundeego.com", false },
  { "fundingrainbows.com", true },
  { "fundkyapp.com", true },
  { "fundmylegalclaim.co.uk", true },
  { "fundort.ch", true },
  { "funds.ddns.net", true },
  { "funerare-cazacu.com", true },
  { "funfactorleeds.co.uk", true },
  { "funfair.io", true },
  { "funfoodco.co.uk", true },
  { "funfun.com.br", true },
  { "fungomoscow.cf", true },
  { "funhouse-inflatables.co.uk", true },
  { "funinbeds.org.uk", true },
  { "funken-networks.de", true },
  { "funkfernbedienung-industrie.de", true },
  { "funknotaus.de", true },
  { "funktionel.co", true },
  { "funktionevents.co.uk", true },
  { "funktionsverket.se", true },
  { "funkydealz.no", true },
  { "funmountaincanyon.com", true },
  { "funniestclip.com", true },
  { "funnybikini.com", true },
  { "funnychristianjokes.tk", true },
  { "funoverip.net", true },
  { "funsochi.ru", true },
  { "funspins.com", true },
  { "funtime-inflatables.co.uk", true },
  { "funtime.com.ua", true },
  { "funtime.kiev.ua", true },
  { "funtimeentertainment.co.uk", true },
  { "funtimesbouncycastles.co.uk", true },
  { "funyirotraktor.hu", true },
  { "fur.red", true },
  { "furcdn.net", true },
  { "furgetmeknot.org", true },
  { "furgo.love", true },
  { "furigana.info", true },
  { "furkancaliskan.com", true },
  { "furkot.com", true },
  { "furkot.de", true },
  { "furkot.es", true },
  { "furkot.fr", true },
  { "furkot.it", true },
  { "furkot.pl", true },
  { "furlan.co", false },
  { "furlog.it", false },
  { "furnfurs.com", true },
  { "furnishedproperty.com.au", true },
  { "furniturezoneboone.com", true },
  { "furries-united.de", true },
  { "furry.bot", true },
  { "furry.cat", true },
  { "furry.cool", true },
  { "furry.dk", true },
  { "furryrex.top", true },
  { "furrytech.network", true },
  { "fursuitbutts.com", true },
  { "fusa-miyamoto.jp", true },
  { "fusechange.org", true },
  { "fuselight.nl", true },
  { "fuseos.net", true },
  { "fuseyahoken.com", true },
  { "fussball-xxl.de", true },
  { "fussell.io", true },
  { "fuszara.pl", true },
  { "futa.moe", false },
  { "futaba-works.com", true },
  { "futbol-tv.tk", true },
  { "futbolvivo.tv", true },
  { "futbomb.com", true },
  { "future-moves.com", true },
  { "futureaudiographics.com", true },
  { "futurefastforward.com", true },
  { "futurefund.com", true },
  { "futuregrowthva.com", true },
  { "futurenda.com", true },
  { "futuressm.com", true },
  { "futurezone.at", true },
  { "fuuko.net", true },
  { "fuvelis.fr", true },
  { "fuwafuwa.moe", true },
  { "fuyu.moe", true },
  { "fuzenet.net", true },
  { "fuzoku.jp", true },
  { "fuzzing-project.org", true },
  { "fvap.gov", true },
  { "fveevaete.com", true },
  { "fwdx.net", true },
  { "fwest.ovh", true },
  { "fwest98.nl", true },
  { "fwest98.ovh", true },
  { "fws.gov", true },
  { "fwz.me", true },
  { "fx-rating.com", true },
  { "fx-rk.com", true },
  { "fx5.de", true },
  { "fxislamic.com", true },
  { "fxmarketing.com.au", true },
  { "fxmarketing.net.au", true },
  { "fxopen.co.uk", true },
  { "fxopen.com", true },
  { "fxopen.com.au", true },
  { "fxopen.com.br", true },
  { "fxopen.com.mx", true },
  { "fxopen.my", true },
  { "fxopen.ru", true },
  { "fxp.co.il", true },
  { "fxseo.com.au", true },
  { "fxsshiwo.cn", true },
  { "fxstrategics.com", true },
  { "fxtalk.cn", true },
  { "fxthai.com", true },
  { "fxtrade-lab.com", true },
  { "fxweb.co", true },
  { "fxwebsites.com.au", true },
  { "fxwebsites.net.au", true },
  { "fxwebstudio.net.au", true },
  { "fyfywka.com", true },
  { "fyksen.me", true },
  { "fyn.nl", true },
  { "fyner.lt", true },
  { "fyol.xyz", false },
  { "fyreek.me", true },
  { "fyretrine.com", true },
  { "fysesbjerg.dk", true },
  { "fysiomassageoosterhout.nl", true },
  { "fysiotherapieapeldoornzuid.nl", true },
  { "fysiotherapieholtenbroek.nl", true },
  { "fysiovdberg.nl", true },
  { "fyss.ga", true },
  { "fytcart.com", true },
  { "fytorio-pasxalis.gr", true },
  { "fzbrweb.cz", true },
  { "fzdm.com", true },
  { "fzhyzamt.com", true },
  { "fzx750.ru", true },
  { "g-ds.de", true },
  { "g-fruit.gr", true },
  { "g-lab.xyz", true },
  { "g-m-w.eu", true },
  { "g-p-design.com", true },
  { "g-rom.net", true },
  { "g.co", false },
  { "g00228.com", false },
  { "g0881.com", true },
  { "g0man.com", true },
  { "g1.ie", true },
  { "g10e.ch", true },
  { "g116688.com", true },
  { "g22-livechat.com", true },
  { "g2jp.uk", true },
  { "g2links.com", true },
  { "g2pla.net", true },
  { "g2ship.com", true },
  { "g2soft.net", true },
  { "g365.vip", true },
  { "g36533.com", true },
  { "g3d.ro", true },
  { "g3dev.ch", false },
  { "g3homefoods.com", true },
  { "g3rv4.com", true },
  { "g4w.co", true },
  { "g51365.com", true },
  { "g7yy.com", true },
  { "g81818.com", true },
  { "g818city.com", true },
  { "g8energysolutions.co.uk", true },
  { "ga-2.it", true },
  { "ga-part.ru", true },
  { "gaaz.fr", true },
  { "gabe.house", true },
  { "gabe565.com", true },
  { "gabeb1920.com", true },
  { "gabecook.com", true },
  { "gabinetejuridicotecnologicojuandemeseguer.es", true },
  { "gabinetpsychoterapii.krakow.pl", true },
  { "gabiocs.com", true },
  { "gablesportsga.com", true },
  { "gabriel.to", true },
  { "gabriele-kluge.de", true },
  { "gabriele.tips", true },
  { "gabrielgn.com.br", true },
  { "gabriella.cf", true },
  { "gabrielsteens.nl", true },
  { "gabryjeluk.tk", true },
  { "gachimuchi.ru", true },
  { "gachiyase.com", true },
  { "gachter.name", false },
  { "gaci88play.com", true },
  { "gadabit.pl", true },
  { "gaddini.it", true },
  { "gadgetadvisor.com", true },
  { "gadgethacks.com", true },
  { "gadgetstock.ir", true },
  { "gae123.com", true },
  { "gaelico.tk", true },
  { "gaengler.com", true },
  { "gaest.com", true },
  { "gaestehaus-leipzig.de", true },
  { "gaestehaus-monika.com", true },
  { "gaetanosonline.com", true },
  { "gaetantremois.fr", true },
  { "gaff-rig.co.uk", true },
  { "gaflooring.com", true },
  { "gafunds.com", true },
  { "gaganenterprises.in", true },
  { "gagliarducci.it", true },
  { "gagnerplusdargent.info", true },
  { "gagniard.org", true },
  { "gagor.pl", true },
  { "gagramore.cf", true },
  { "gagygnole.ch", false },
  { "gaiavanderzeyp.com", true },
  { "gaigelama.com", true },
  { "gaines-sodiamex.fr", true },
  { "gaio-automobiles.fr", true },
  { "gaireg.de", true },
  { "gaitandmobility.com", true },
  { "gaitrehabilitation.com", true },
  { "gaitresearch.com", true },
  { "gajas18.com", true },
  { "gajowniczek.eu", true },
  { "gakdigital.com", true },
  { "gakki.photos", true },
  { "gaku-architect.com", true },
  { "gala.kiev.ua", false },
  { "galabau-maurmann.de", true },
  { "galacg.me", true },
  { "galak.ch", false },
  { "galaktika-znakomstv.tk", true },
  { "galaltosalento.it", true },
  { "galanight.cz", true },
  { "galax.us", true },
  { "galaxus.at", true },
  { "galaxus.ch", true },
  { "galaxus.com", true },
  { "galaxus.de", true },
  { "galaxus.eu", true },
  { "galaxus.fr", true },
  { "galaxy.edu.pe", true },
  { "galaxymusicpromo.com", true },
  { "galaxyplex.tk", true },
  { "galaxyscientific.com", true },
  { "galeriakobylarz.pl", true },
  { "galeriarr.pl", true },
  { "galeries.photo", false },
  { "galganoboutique.com", true },
  { "galighticus.com", true },
  { "galileanhome.org", true },
  { "galinas-blog.de", true },
  { "galinos.gr", true },
  { "galj.info", true },
  { "galle.cz", true },
  { "galleonwaymedical.com.au", true },
  { "gallerify.eu", true },
  { "galletasgabi.com.mx", false },
  { "galleyfoods.com", true },
  { "gallicrooster.com", true },
  { "gallifreyapp.co.uk", true },
  { "gallifreypermaculture.com.au", true },
  { "gallmeyer-consulting.com", true },
  { "gallun-shop.com", true },
  { "galpaoap.com.br", true },
  { "galvingao.com", true },
  { "gamberorosso.menu", true },
  { "gambetti.fr", true },
  { "gambitnash.co.uk", true },
  { "gambitnash.com", true },
  { "gambitprint.com", true },
  { "gambler.ru", true },
  { "gamblerhealing.com", true },
  { "gamblernd.com", true },
  { "gambling-business.club", true },
  { "gamblinghero.com", true },
  { "gamcore.com", true },
  { "game-files.net", false },
  { "game-topic.ru", true },
  { "game4less.com", true },
  { "game7.de", true },
  { "game818play.com", true },
  { "game88city.com", true },
  { "game88city.net", true },
  { "game88play.com", true },
  { "game88yule.com", true },
  { "gameanalytics.com", true },
  { "gameblabla.nl", true },
  { "gamebrott.com", true },
  { "gamecard-shop.nl", true },
  { "gamechefpummarola.eu", true },
  { "gamechurch.de", true },
  { "gameclue.jp", true },
  { "gamecollector.be", true },
  { "gameconservation.org.uk", true },
  { "gamedevelopers.pl", true },
  { "gamegear.club", true },
  { "gamegix.com", true },
  { "gameharbor.duckdns.org", true },
  { "gameindustry.eu", true },
  { "gameisbest.jp", true },
  { "gamejobs.co", true },
  { "gamekaitori.jp", true },
  { "gamekeepers.cz", true },
  { "gamemodding.com", true },
  { "gamenauta.com.br", true },
  { "gamenerd.net", true },
  { "gameofbooks.de", true },
  { "gamepad.com.br", true },
  { "gameplaysforkids.com", true },
  { "gamepreorders.com", true },
  { "gamer-portal.com", true },
  { "gamercredo.com", true },
  { "gamereader.de", true },
  { "gamerepublic.hu", true },
  { "gameres.com", true },
  { "gamerezo.com", true },
  { "gamerspost.ga", true },
  { "gamerzdot.com", true },
  { "games4theworld.org", true },
  { "gamesaviour.com", true },
  { "gamesdepartment.co.uk", true },
  { "gameserver-admin.ga", true },
  { "gameserver-sponsor.me", true },
  { "gameshogun.xyz", true },
  { "gameshowchallenge.ie", true },
  { "gamesided.com", true },
  { "gamesme.cn", true },
  { "gamesplanet.com", true },
  { "gamesputnik.ru", true },
  { "gamestats.gg", true },
  { "gametilt.com", true },
  { "gametube.website", true },
  { "gamewinninggoal.com", true },
  { "gamilab.com", true },
  { "gamilab.no", true },
  { "gamingexodus.com", true },
  { "gamingmedley.com", true },
  { "gamingroomaccessories.com", true },
  { "gamingtilltheend.cf", true },
  { "gamingx.tk", true },
  { "gamingzoneservers.com", true },
  { "gamisalya.com", true },
  { "gamishou.fr", true },
  { "gamismu.com", true },
  { "gamivo.com", true },
  { "gammaphibeta.tk", true },
  { "ganado.org", true },
  { "ganaenergia.com", true },
  { "ganaenergia.es", true },
  { "ganasoku.net", true },
  { "gancedo.com.es", true },
  { "gandalfservice.com", true },
  { "gandalfthefeline.com", true },
  { "gandgliquors.com", true },
  { "ganggalbichler.at", true },
  { "gangnamcool.com", true },
  { "ganodermatiendaonline.com", true },
  { "ganpris.online", true },
  { "gansleit.com", false },
  { "ganyouxuan.com", true },
  { "ganzgraph.de", true },
  { "ganztagplus.de", true },
  { "gao.ci", true },
  { "gao.rocks", true },
  { "gaodebo.com", true },
  { "gaos.org", true },
  { "gaozj.com", true },
  { "gapdirect.com", true },
  { "gapfa.org", false },
  { "gaphag.ddns.net", true },
  { "garage-leone.com", false },
  { "garagedejan.ch", true },
  { "garagedoorrepairingsanjose.com", true },
  { "garageenginuity.com", true },
  { "garagegoossens.be", true },
  { "garagesmart.com.au", true },
  { "garagevanhulle-used.be", false },
  { "garanteasy.com", true },
  { "garazskapuszereles.hu", true },
  { "garbomuffin.com", true },
  { "garbott.co.uk", true },
  { "garcia-franco.com", true },
  { "garciagerman.com", true },
  { "garda-see.mobi", true },
  { "gardedenfantspourtous.fr", true },
  { "gardengameshireuk.com", true },
  { "gardeningdirect.co.uk", true },
  { "gardensandgifts.com", true },
  { "gardensquaredental.co.uk", true },
  { "gardenstate.tech", true },
  { "gardikagigih.com", true },
  { "gardis.ua", true },
  { "garduri-electrice-animale.ro", true },
  { "garethbowker.com", true },
  { "garethkirk.com", true },
  { "garethrhugh.es", true },
  { "gargazon.net", true },
  { "garnuchbau.de", true },
  { "garron.net", true },
  { "garrowmediallc.com", true },
  { "garsio.com", true },
  { "gartenbaur.de", true },
  { "gartenplanung-brendes.de", true },
  { "garycarmell.com", true },
  { "garycwaite.com", true },
  { "garyjones.co.uk", true },
  { "garyrh.com", true },
  { "garystallman.com", true },
  { "garyswine.com", true },
  { "garywhittington.com", true },
  { "gashalot.com", true },
  { "gasinstallationsjohannesburg.co.za", true },
  { "gaspapp.com", true },
  { "gastauftritt.net", true },
  { "gastoudererenda.nl", true },
  { "gastrobox.com.co", true },
  { "gastromedicalcenter.com.br", true },
  { "gastronom.ga", true },
  { "gastrotiger.at", true },
  { "gastrotiger.de", true },
  { "gate2home.com", true },
  { "gateaucreation.fr", true },
  { "gatekiller.co.uk", true },
  { "gatewaybridal.com", true },
  { "gatewayclub.com.au", true },
  { "gathegi.ga", true },
  { "gathermycrew.org.au", true },
  { "gathu.co.ke", true },
  { "gauche.com", true },
  { "gaudeamus-folklor.cz", true },
  { "gaudere.co.jp", true },
  { "gaussianwaves.com", true },
  { "gauthier.dk", true },
  { "gavin.sh", true },
  { "gavins.stream", true },
  { "gavlix.se", true },
  { "gavr.me", true },
  { "gavr.space", true },
  { "gavr.xyz", true },
  { "gaw.sh", true },
  { "gay-personal-ads.com", true },
  { "gay-sissies.com", true },
  { "gaya-sa.org", true },
  { "gayauthors.org", true },
  { "gaycc.cc", true },
  { "gaymerconnect.net", true },
  { "gaymerx.com", true },
  { "gaymerx.net", true },
  { "gaymerx.org", true },
  { "gaypirateassassins.com", true },
  { "gaysexpositions.guide", true },
  { "gaysfisting.com", true },
  { "gaytorrent.ru", true },
  { "gayukai.net", true },
  { "gayxsite.com", true },
  { "gazellegames.net", true },
  { "gazete.org", true },
  { "gazette.govt.nz", true },
  { "gazflynn.com", true },
  { "gazizov.tk", true },
  { "gb-repair.com", true },
  { "gbc-radio.nl", true },
  { "gbcsummercamps.com", true },
  { "gbl.selfip.net", true },
  { "gboys.net", false },
  { "gbs-uk.com", true },
  { "gbthatcher.com", true },
  { "gc-mc.de", true },
  { "gc.de", true },
  { "gc.gy", true },
  { "gc.ru.net", true },
  { "gcbit.dk", true },
  { "gcfadvisors.com", true },
  { "gchc.com", true },
  { "gchq.lol", true },
  { "gcode.space", true },
  { "gcoded.de", true },
  { "gcs-ventures.com", true },
  { "gcsepod.com", true },
  { "gd88.cc", true },
  { "gdb-tutorial.net", true },
  { "gdesemena.ru", true },
  { "gdgrzeszow.pl", true },
  { "gdiary.net", true },
  { "gdngs.de", true },
  { "gdoce.es", false },
  { "gdpr-pohotovost.cz", true },
  { "gdpr.fr", true },
  { "gdraco.com", true },
  { "gdv.me", true },
  { "gdz-spishy.com", true },
  { "ge3k.net", false },
  { "gear4you.shop", true },
  { "gearallnews.com", true },
  { "gearbot.rocks", true },
  { "gearboxhero.com", true },
  { "gearev.net", true },
  { "gearfinder.nl", true },
  { "gearset.com", true },
  { "gearwise.se", true },
  { "geaskb.nl", true },
  { "geba-online.de", true },
  { "gebn.co.uk", true },
  { "gebn.uk", true },
  { "geboortestoeltje.com", true },
  { "geborgen-wachsen.de", true },
  { "gebruikershandleiding.com", true },
  { "gecem.org", true },
  { "gechr.io", true },
  { "geckler-ee.de", false },
  { "geder.at", true },
  { "gedlingcastlehire.co.uk", true },
  { "gedlingtherapy.co.uk", true },
  { "geecrat.com", true },
  { "geek-hub.de", true },
  { "geek.ch", true },
  { "geekabit.nl", true },
  { "geekandi.com", true },
  { "geekariom.com", true },
  { "geekbundle.org", true },
  { "geekclubbooks.com", true },
  { "geekeffect.co.uk", true },
  { "geeklair.net", true },
  { "geeklan.co.uk", true },
  { "geekles.net", true },
  { "geekpad.com", true },
  { "geeks.berlin", true },
  { "geeks.lgbt", true },
  { "geeks.one", false },
  { "geeksandthecity.fr", true },
  { "geekshirts.cz", true },
  { "geekstreet.fr", true },
  { "geektarven.com", true },
  { "geektier.com", true },
  { "geektopia.es", true },
  { "geekwhack.org", true },
  { "geekwithabudget.com", true },
  { "geekwu.org", true },
  { "geekyquiz.com", true },
  { "geekz.sk", true },
  { "geekzone.co.nz", true },
  { "geekzone.fr", true },
  { "geeq.ch", true },
  { "geerdsen.net", true },
  { "geertdegraaf.nl", true },
  { "geertswei.nl", true },
  { "gefolge.org", true },
  { "gegeco.ch", false },
  { "geh.li", true },
  { "gehaowu.com", true },
  { "gehas-wein-shop.de", false },
  { "gehatrans.de", true },
  { "gehirn.co.jp", true },
  { "gehirn.jp", true },
  { "gehopft.de", true },
  { "gehreslaw.com", true },
  { "gehrke.cloud", true },
  { "gehrke.in", true },
  { "gehsicht.de", true },
  { "geigenbauer.in", false },
  { "geiser-family.ch", true },
  { "geisser-elektronikdata.de", true },
  { "geitenijs.com", true },
  { "gelaendermanufaktur.de", true },
  { "gelb-computer.de", true },
  { "geld-im-blick.de", true },
  { "geld24.nl", true },
  { "geldimblick.de", true },
  { "geleenbeekdal.nl", true },
  { "geleia-real.com", true },
  { "gelis.ch", true },
  { "gellis12.com", true },
  { "gelog-software.de", false },
  { "gelonghui.com", true },
  { "geloofindemocratie.nl", false },
  { "gelpinhos.pt", true },
  { "gelsey.com", true },
  { "geluidsstudio.com", true },
  { "geluk.io", true },
  { "gelukkigehonden.nl", true },
  { "geluleminceur.fr", true },
  { "gemails.eu", true },
  { "gemeentestein.nl", true },
  { "gemeinsam-ideen-verwirklichen.de", true },
  { "gemini.com", true },
  { "gemquery.com", true },
  { "gemstn.com", true },
  { "gemstonz.org", true },
  { "genbright.com", true },
  { "genchev.io", true },
  { "gencmedya.com", true },
  { "gender-summit.com", true },
  { "genderidentiteit.nl", true },
  { "gendrin.com", true },
  { "gendundrupa.ch", true },
  { "gene-drive.com", true },
  { "gene-drives.com", true },
  { "genealogiegazet.nl", true },
  { "genealogieonline.nl", true },
  { "genealogiewerkbalk.nl", true },
  { "genealorand.com", true },
  { "geneau.net", true },
  { "genehightower.com", true },
  { "genehome.com.au", true },
  { "genen.ga", true },
  { "generador-electrico.com", true },
  { "general-anaesthesia.com", true },
  { "general-anaesthetics.com", true },
  { "general-anesthesia.com", true },
  { "general-plast.com", true },
  { "generalinsuranceservices.com", true },
  { "generationr.nl", true },
  { "generator.creditcard", true },
  { "generic.cx", true },
  { "generujdata.cz", true },
  { "genesiseureka.com", true },
  { "genesismachina.ca", true },
  { "genesistrading.com", true },
  { "genesysmi.com", true },
  { "genetargetsolutions.com.au", true },
  { "genetidyne.com", true },
  { "genevachauffeur.com", true },
  { "geneve-naturisme.ch", false },
  { "genevoise-entretien.ch", true },
  { "genfaerd.dk", true },
  { "genioideal.com", true },
  { "geniush.ovh", true },
  { "geniusteacher.in", true },
  { "geniuszone.biz", true },
  { "gennerator.com", true },
  { "genocidediary.org", true },
  { "genodeftest.de", true },
  { "genomedia.jp", true },
  { "genomequestlive.com", true },
  { "genosse-einhorn.de", true },
  { "genossenwiese.ch", true },
  { "genoveve.de", true },
  { "gensend.com", true },
  { "gensenwedding.jp", true },
  { "genshiken-itb.org", true },
  { "gensicke.de", true },
  { "genslerapps.com", true },
  { "genslerwisp.com", true },
  { "gensokyo.re", true },
  { "gensonline.eu", true },
  { "gentcdn.com", true },
  { "gentledance.ch", true },
  { "gentledance.net", true },
  { "gentlent.com", true },
  { "gentlent.net", true },
  { "gentoo-blog.de", true },
  { "gentoocn.org", true },
  { "gentz.rocks", true },
  { "genunlimited.tk", true },
  { "genusshotel-riegersburg.at", true },
  { "geocar.com", true },
  { "geocompass.at", true },
  { "geoffnussmd.com", true },
  { "geoffsec.org", true },
  { "geofox.org", true },
  { "geography-schools.com", true },
  { "geohoney.com", true },
  { "geoip.fedoraproject.org", true },
  { "geoip.stg.fedoraproject.org", true },
  { "geojs.io", true },
  { "geology-schools.com", true },
  { "geomac.gov", true },
  { "geometra.roma.it", true },
  { "geometra24.it", true },
  { "geomex.be", true },
  { "geomonkeys.com", true },
  { "geoponika.gr", true },
  { "geoport.al", true },
  { "georadar-algerie.com", true },
  { "george-brighton.co.uk", true },
  { "george-orwell.com", true },
  { "georgeblack.me", true },
  { "georgebrighton.co.uk", true },
  { "georgecolgrove.com", true },
  { "georgedesign.ch", true },
  { "georgekaraoglanis.tk", true },
  { "georgemaschke.net", true },
  { "georgepancescu.ro", true },
  { "georgesand.be", true },
  { "georgescarryout.com", true },
  { "georgewatson.me", true },
  { "georgewbushlibrary.gov", true },
  { "georgiaautoglass.net", true },
  { "georgiadance.com", true },
  { "georgiaglassrepair.com", true },
  { "georgiastuartyoga.co.uk", false },
  { "georgiaurologist.com", true },
  { "georgioskontaxis.com", true },
  { "georgioskontaxis.net", true },
  { "georgioskontaxis.org", true },
  { "georgmayer.eu", true },
  { "geoscan.aero", true },
  { "geoscope.ch", false },
  { "geotab.com", true },
  { "gepgroup.gr", true },
  { "gepps.de", true },
  { "geraintwhite.co.uk", true },
  { "gerald-zojer.com", true },
  { "geraldoazevedo.com.br", true },
  { "geraldsonrealty.com", true },
  { "gerardinden.nl", true },
  { "gerardozamudio.mx", true },
  { "gerbang-singkolo.ga", true },
  { "gerbyte.co.uk", true },
  { "gerbyte.com", true },
  { "gerinet.pl", true },
  { "germandarknes.net", true },
  { "germanicvs.tk", true },
  { "germanmasterpainters.nz", true },
  { "germanssky.de", true },
  { "germantrip.tk", true },
  { "germanytravel.ga", true },
  { "germanytravelguide.ml", true },
  { "gernert-server.de", true },
  { "gero.io", true },
  { "geroiplavska.tk", true },
  { "gerritcodereview.com", true },
  { "gervais-avocat.fr", true },
  { "gerwinvanderkamp.nl", true },
  { "ges-bo.de", true },
  { "gesamenvat.nl", true },
  { "geschaeftsideen-ebook.de", true },
  { "geschichtscheck.de", true },
  { "geschmacksache.online", true },
  { "geschwinder.net", true },
  { "gesevi.com", true },
  { "gesica.cloud", true },
  { "gesmav-trier.de", true },
  { "gesnex.com", true },
  { "gessettirotti.it", true },
  { "gestionrocamar.es", true },
  { "gestlifes.com", true },
  { "gestormensajeria.com", true },
  { "gestsal.com", true },
  { "gestus.co", true },
  { "gesunddurchenergie.ch", true },
  { "gesundheitmassage.com", true },
  { "gesundheitswelt24.de", true },
  { "get-california-real-estate.com", true },
  { "get-erp.ru", true },
  { "get-it-live.com", true },
  { "get-it-live.de", true },
  { "get-maurice.com", true },
  { "get-on.bid", true },
  { "get-quick-bits-fast-2018.pw", true },
  { "get.how", true },
  { "get2getha.org", true },
  { "getacrane.co.uk", true },
  { "getalitools.ru", true },
  { "getbookked.com", true },
  { "getbooks.co.il", true },
  { "getboubou.com", true },
  { "getbox.me", true },
  { "getbreadcrumbs.com", true },
  { "getbrowink.com", true },
  { "getbutterfly.com", true },
  { "getcard.cc", true },
  { "getcertified.pro", true },
  { "getcheapinsurancenow.info", true },
  { "getcloak.com", false },
  { "getdash.io", true },
  { "getdeveloper.de", true },
  { "geteduroam.no", true },
  { "geterp.ru", true },
  { "geteventbox.com", true },
  { "getfedora.org", true },
  { "getfirstalert.com", true },
  { "getflorence.co.uk", true },
  { "getgeek.es", true },
  { "getgeek.se", true },
  { "gethow.org", true },
  { "gethttpsforfree.com", true },
  { "getidmcc.com", true },
  { "getinphase.com", true },
  { "getintopc.com", true },
  { "getitlive.de", true },
  { "getlawyered.com.au", true },
  { "getmango.com", true },
  { "getmdl.io", true },
  { "getmerch.eu", true },
  { "getmovil.com", false },
  { "getnib.com", true },
  { "getnikola.com", true },
  { "getonyx.com", true },
  { "getpagespeed.com", true },
  { "getpaidclub.tk", true },
  { "getpanelapp.com", true },
  { "getpei.com", true },
  { "getpromo.cf", true },
  { "getpublii.com", true },
  { "getrambling.com", true },
  { "getsecure.nl", true },
  { "getsensibill.com", true },
  { "getsetbounce.co.uk", true },
  { "getsmartaboutdrugs.gov", false },
  { "getsmarterinsurance.com", true },
  { "getsport.mobi", true },
  { "getsubs.net", true },
  { "getteamninja.com", true },
  { "getthefriendsyouwant.com", true },
  { "getticker.com", true },
  { "gettok.com", true },
  { "gettopquality.com", true },
  { "getupandbounce.co.uk", true },
  { "getvdownloader.com", true },
  { "getwemap.com", true },
  { "getwisdom.io", true },
  { "getwork.tk", true },
  { "getyour.nz", true },
  { "getyourlifestraight.com", true },
  { "geus-okna.eu", true },
  { "gevelreinigingtiel.nl", true },
  { "geyduschek.be", true },
  { "gezinnenhilton.com", true },
  { "gezondetips.nl", true },
  { "gf-franken.de", true },
  { "gf5fcalc.com", true },
  { "gfac.ru", true },
  { "gfahnen.de", true },
  { "gfast.ru", true },
  { "gfcleisure.co.uk", true },
  { "gfe.li", true },
  { "gfedating.com", true },
  { "gfelite.de", true },
  { "gfestival.fo", true },
  { "gfk-kunststoff-luebben.de", true },
  { "gflame.de", true },
  { "gforce.ninja", true },
  { "gfoss.eu", true },
  { "gfourmis.co", true },
  { "gfronline.tk", true },
  { "gfxbench.com", true },
  { "gfxworld.tk", true },
  { "ggbet.me", true },
  { "ggdcpt.com", true },
  { "gggggg.org", true },
  { "gginin.today", true },
  { "ggismo.com", true },
  { "ggiveilig.nl", true },
  { "ggl-luzern.ch", false },
  { "ggma.co.uk", true },
  { "ggmmontascale.it", true },
  { "ggp2.com", true },
  { "ggs-marschallstrasse.de", true },
  { "ggs.jp", true },
  { "ggservers.com", true },
  { "ggx.us", true },
  { "gh-sandanski.com", true },
  { "gha.st", true },
  { "gheestore.in", true },
  { "ghettonetflix.de", true },
  { "ghfip.com.au", true },
  { "ghini.com", true },
  { "ghislainphu.fr", true },
  { "ghkim.net", true },
  { "ghostsupreme.eu", true },
  { "ghowell.io", true },
  { "ghull.email", true },
  { "ghuntley.com", false },
  { "giac.net", true },
  { "giac.org", true },
  { "giacomopelagatti.it", true },
  { "giakki.eu", false },
  { "giannademartini.com", true },
  { "gianproperties.com", true },
  { "giant-panda.com", true },
  { "giant-tortoise.com", true },
  { "gianttree.de", true },
  { "giaoxudongtri.com", true },
  { "giaphaco.com", true },
  { "giardinaggio.milano.it", true },
  { "giardinaggio.napoli.it", true },
  { "giardinaggio.roma.it", true },
  { "giardiniblog.it", true },
  { "giardiniere.bologna.it", true },
  { "giardiniere.milano.it", true },
  { "giardiniere.roma.it", true },
  { "gichigamigames.com", true },
  { "giebel.it", true },
  { "gielectrical.com.au", true },
  { "giemall.com", true },
  { "gierds.de", true },
  { "gieschke.de", true },
  { "giethoorn.com", true },
  { "gietvloergarant.nl", false },
  { "gifino.fr", true },
  { "giftcard.net", true },
  { "giftcardgranny.com", true },
  { "giftedconsortium.com", true },
  { "giftking.nl", false },
  { "giftlist.guru", true },
  { "gifts365.co.uk", true },
  { "giftya.com", true },
  { "gifudodo.com", true },
  { "gig-raiffeisen.de", true },
  { "giga.nl", true },
  { "gigabitz.pw", true },
  { "gigantism.com", true },
  { "gigasoft.tk", true },
  { "giggletotz.co.uk", true },
  { "gigin.eu", true },
  { "gigin.me", true },
  { "gigis-pizzeria.de", true },
  { "gigis.cloud", true },
  { "giglink.club", true },
  { "gigolodavid.be", true },
  { "gigs.guide", true },
  { "gigseekr.com", true },
  { "gijsbertus.com", true },
  { "gijswesterman.nl", true },
  { "gikovatelojavirtual.com.br", true },
  { "gilangcp.com", true },
  { "gileadpac.com", true },
  { "giliamor.com", true },
  { "gillfamily.de", true },
  { "gillmanandsoame.co.uk", true },
  { "gillyscastles.co.uk", true },
  { "gilme.net", true },
  { "gilnet.be", false },
  { "gimme.money", true },
  { "gimnazjum-miloslaw.tk", true },
  { "gina-architektur.design", true },
  { "ginabaum.com", true },
  { "ginen.xyz", true },
  { "gingersutton.com", true },
  { "ginionusedcars.be", false },
  { "ginja.co.th", true },
  { "ginnegappen.nl", true },
  { "ginniemae.gov", true },
  { "gino-gelati.de", true },
  { "ginza-luce.net", true },
  { "ginza-viola.com", true },
  { "ginzadelunch.jp", true },
  { "ginzaj.com", true },
  { "giochiecodici.it", true },
  { "gioielleriamolena.com", true },
  { "giovannarossi.tk", true },
  { "gipelpsb.fr", true },
  { "gipfelbuch.gr", true },
  { "gippert-klein.de", true },
  { "giraffeduck.com", true },
  { "giraffenland.de", true },
  { "giraffes.org", true },
  { "giri.co", true },
  { "girl.science", true },
  { "girlan.net", true },
  { "girlinthetiara.com", true },
  { "girlsforum.com", true },
  { "girlz.jp", true },
  { "girsa.org", true },
  { "girvas.ru", true },
  { "gisac.org", true },
  { "gisauto.ru", true },
  { "gisch.tk", true },
  { "gisher.news", true },
  { "gisher.org", true },
  { "gisher.video", true },
  { "gishiko.net", true },
  { "gistr.io", true },
  { "git.market", false },
  { "git.sb", true },
  { "git.tt", true },
  { "gitecolombedesbois.com", true },
  { "gitep.org.uk", true },
  { "gites-alizea.com", true },
  { "gitesdeshautescourennes.com", true },
  { "github.com", true },
  { "githubapp.com", true },
  { "githubber.com", true },
  { "githubber.tv", true },
  { "gitla.in", true },
  { "gittigidiyor.com", true },
  { "gittr.ch", true },
  { "gitube.cn", true },
  { "giuem.com", true },
  { "giunchi.net", true },
  { "giuseppemacario.men", true },
  { "givastar.com", true },
  { "give.net", true },
  { "give2charity.co", true },
  { "give2charityapp.com", true },
  { "giveattheoffice.org", false },
  { "giveaways.ph", true },
  { "givemylife.gq", true },
  { "given2.com", true },
  { "givepenny.com", true },
  { "givesunlight.com", true },
  { "givingnexus.org", false },
  { "givingtools.com", true },
  { "gixtools.com", true },
  { "gixtools.net", true },
  { "gizmo.ovh", true },
  { "gj-bochum.de", true },
  { "gjcampbell.co.uk", true },
  { "gjengset.com", true },
  { "gjspunk.de", false },
  { "gkasper.de", true },
  { "gkb2020.ch", true },
  { "gkoenig-innenausbau.de", true },
  { "gkralik.eu", true },
  { "gku-winterling.de", false },
  { "gkv-gorinchem.nl", true },
  { "gl.search.yahoo.com", false },
  { "glaciernursery.com", true },
  { "gladdy.co.uk", true },
  { "gladdymedia.co.uk", true },
  { "gladdymedia.com", true },
  { "gladdymedia.uk", true },
  { "gladiac.duckdns.org", true },
  { "gladwellentertainments.co.uk", true },
  { "gladysstrickland.com", true },
  { "glahcks.com", true },
  { "glamcosmetic.ch", true },
  { "glamguru.co.il", true },
  { "glamguru.world", true },
  { "glamira.de", true },
  { "glammybabes.com", true },
  { "glamour4you.de", true },
  { "glamourdaze.com", true },
  { "glamouria.com.br", true },
  { "glamur-video.com", true },
  { "glasdon.com", true },
  { "glasen-hardt.de", true },
  { "glasfaser-im-hanseviertel.de", true },
  { "glasgestaltung.biz", true },
  { "glasner.photo", true },
  { "glass.google.com", true },
  { "glassemployees.com", true },
  { "glassexpertswa.com", true },
  { "glassofgrape.com", true },
  { "glassrainbowtrust.org.je", true },
  { "glassrom.pw", true },
  { "glasweld.com", true },
  { "glavsudexpertiza.ru", true },
  { "glazedmag.fr", true },
  { "glcastlekings.co.uk", true },
  { "gleanview.com", true },
  { "glebov.tk", true },
  { "gleich-aluminium-shop.de", true },
  { "glenberviegolfclub.com", true },
  { "glencarbide.com", true },
  { "glendarraghbouncycastles.co.uk", true },
  { "glenhuntlyapartments.com.au", true },
  { "glenshere.com", true },
  { "glexia.com", true },
  { "glidingshop.cz", true },
  { "glidingshop.de", true },
  { "glidingshop.eu", true },
  { "gliihc.net", true },
  { "glimhome.com", true },
  { "glittersjabloon.nl", true },
  { "glitzafricafashionweek.com", true },
  { "glitzerstuecke.de", true },
  { "glixee.com", true },
  { "glk.partners", true },
  { "glloq.org", false },
  { "gloalerts.com", true },
  { "global-adult-webcams.com", true },
  { "global-monitoring.com", true },
  { "global-office.com", false },
  { "global-village.koeln", true },
  { "global1.gg", true },
  { "globalbano.com", true },
  { "globalchokepoints.org", true },
  { "globalcomix.com", true },
  { "globaleaks.org", true },
  { "globalesm.com", true },
  { "globalgovernancewatch.org", true },
  { "globalhealth.gov", true },
  { "globalhealthstrategiesnetwork.com", true },
  { "globalhealthstrategiesnetwork.info", true },
  { "globalhealthstrategiesnetwork.net", true },
  { "globalhealthstrategiesnetwork.org", true },
  { "globalinvestigations.co.uk", true },
  { "globalipaction.ch", true },
  { "globalisierung-fakten.de", true },
  { "globalitac.com", true },
  { "globalnewsdaily.cf", true },
  { "globalno.me", true },
  { "globalonetechnology.com", true },
  { "globalprojetores.com.br", true },
  { "globalresearchcouncil.org", true },
  { "globalresistancecorporation.com", true },
  { "globalshippinglimited.ga", true },
  { "globalvoice.ga", true },
  { "globalwitness.org", true },
  { "globalzone.tk", true },
  { "globecollege.nl", true },
  { "globelink-group.com", true },
  { "globemusic.es", true },
  { "globetalent.nl", true },
  { "globologic.com", true },
  { "glocalworks.jp", true },
  { "gloeckle-gruppe.de", true },
  { "glofox.com", true },
  { "glolighting.co.za", true },
  { "gloneta.com", false },
  { "glont.net", true },
  { "gloryholefucking.com", true },
  { "glosiko.com", true },
  { "glosons.com", true },
  { "glotech.co.uk", true },
  { "glotechkitchens.co.uk", true },
  { "glotechrepairs.co.uk", true },
  { "gloucestershiregospelpartnership.org.uk", true },
  { "glueck-im-norden.de", true },
  { "gluecksgriff-taschen.de", true },
  { "glueckskindter.de", true },
  { "gluedtomusic.com", true },
  { "gluhov-ss.ru", true },
  { "gluit.de", true },
  { "glutenfreehomemaker.com", true },
  { "glutenfreelife.co.nz", true },
  { "glutenfreevr.com", true },
  { "glykofridis.nl", true },
  { "glyptodon.com", true },
  { "glyxins.com", true },
  { "gm.search.yahoo.com", false },
  { "gmacedo.com", true },
  { "gmail.com", false },
  { "gmao.com", true },
  { "gmbh-kiekin.de", true },
  { "gmc.uy", true },
  { "gmccar.it", true },
  { "gmcd.co", true },
  { "gmdu.net", true },
  { "gmenhq.com", true },
  { "gmind.ovh", true },
  { "gmod.de", true },
  { "gmpark.dk", true },
  { "gmpartsdb.com", true },
  { "gmslparking.co.uk", true },
  { "gmta.nl", true },
  { "gmtplus.co.za", true },
  { "gmuh.fr", true },
  { "gmw-ingenieurbuero.de", true },
  { "gmx.at", true },
  { "gmx.ch", true },
  { "gmx.co.uk", true },
  { "gmx.com", true },
  { "gmx.de", true },
  { "gmx.es", true },
  { "gmx.fr", true },
  { "gmx.net", true },
  { "gn00.com", true },
  { "gnax.jp", false },
  { "gnetion.com", true },
  { "gnetwork.eu", true },
  { "gnezdo.tk", true },
  { "gnfrazier.me", true },
  { "gnilebein.de", true },
  { "gnk.io", true },
  { "gnmlive.com", true },
  { "gnucashtoqif.us", true },
  { "gnwp.eu", true },
  { "go-away.xyz", true },
  { "go-datasecurity.de", true },
  { "go-dutch.eu", true },
  { "go-embedded.de", true },
  { "go-kuwait.tk", true },
  { "go-life.com.tw", true },
  { "go-propiedades.cl", true },
  { "go-srx.tk", true },
  { "go-wild.co.uk", true },
  { "go-zh.org", true },
  { "go.exchange", true },
  { "go.microsoft.com", true },
  { "go2archive.nl", true },
  { "go2people-websites.nl", true },
  { "go2ubl.nl", true },
  { "go889w.com", true },
  { "goa8.xyz", true },
  { "goalbookapp.com", true },
  { "goanalyse.co.uk", true },
  { "goand.run", true },
  { "goarmy.eu", true },
  { "goatcloud.com", true },
  { "goaudits.com", true },
  { "gobarrelroll.com", true },
  { "gobiz.com.my", true },
  { "gobouncy.co.uk", true },
  { "gobouncy.com", true },
  { "gobytedesign.co.uk", true },
  { "goc4wraps.com", true },
  { "gocardless.com", true },
  { "gocher.me", true },
  { "gochu.se", true },
  { "gocleanerslondon.co.uk", true },
  { "god-clan.hu", true },
  { "godall.tk", true },
  { "godan.tech", true },
  { "godattributes.com", true },
  { "godaxen.tv", true },
  { "godclan.hu", true },
  { "goddg.com", true },
  { "godesigner.ru", true },
  { "godruoyi.com", true },
  { "godsofhell.com", true },
  { "godsofhell.de", true },
  { "goeb.eu", true },
  { "goeb.org", true },
  { "goededoelkerstkaarten.nl", true },
  { "goedkopeonesies.nl", true },
  { "goedverzekerd.net", true },
  { "goehler-baumpflege.de", true },
  { "goemail.me", true },
  { "goerres2014.de", true },
  { "goetemp.de", true },
  { "goettinger-biergarten.de", true },
  { "goffrie.com", true },
  { "goflo.net", true },
  { "gofoiayourself.org", true },
  { "gogle-analytics.com", true },
  { "gogleapis.com", true },
  { "gogoodyear.eu", true },
  { "gogroopie.com", true },
  { "gogroopie.ie", true },
  { "gogrow.com", true },
  { "gogs.ca", true },
  { "gogsat.com", true },
  { "gohon.org", true },
  { "goingreen.com.au", true },
  { "goiymua.com", true },
  { "gokhankesici.com", true },
  { "gokmenguresci.com", true },
  { "golang.org", true },
  { "golang.zone", true },
  { "golangnews.com", true },
  { "goldandgopher.com", true },
  { "goldclubcasino.com", true },
  { "goldcoast-plumbing.com.au", true },
  { "goldcoastasian.com", true },
  { "goldcoasthypnotherapyhypnosis.com.au", true },
  { "goldcoastphotographycourses.com", true },
  { "goldcoaststumpbusters.com", true },
  { "golden-kamuy.com", true },
  { "goldenage.tk", true },
  { "goldenbadger.de", true },
  { "goldendawnapersonalaffair.com", true },
  { "goldenhillsoftware.com", true },
  { "goldenhost.ca", true },
  { "goldenhostmyanmar.com", false },
  { "goldenplate.com.sg", true },
  { "goldfmromania.ro", true },
  { "goldlevelmarketing.com", true },
  { "goldlevelprint.com", true },
  { "goldmark.com.au", false },
  { "goldpreisfinder.at", true },
  { "goldsecurity.com", true },
  { "goldships.com", true },
  { "goldsilver.org.ua", true },
  { "goldskysecurity.com", true },
  { "goldstein.tel", true },
  { "goldsteinlawgroup.com", true },
  { "goldytechspecialists.com", true },
  { "golf18network.com", true },
  { "golf18staging.com", true },
  { "golfhausmallorca.com", true },
  { "golfscape.com", true },
  { "golighthouse.com", true },
  { "golik.net.pl", false },
  { "golnet.hu", true },
  { "golosok.ml", true },
  { "golser-schuh.at", true },
  { "golser.info", true },
  { "gomasy.jp", true },
  { "gomedium.com", true },
  { "gomel.chat", true },
  { "gomel.city", true },
  { "gomelchat.com", true },
  { "gomelphoto.com", true },
  { "gommista.roma.it", true },
  { "gondelvaartdwarsgracht.nl", true },
  { "gondola-parkinson.com", true },
  { "gongjianwei.com", true },
  { "gongjuhao.com", true },
  { "gonx.dk", false },
  { "goo.gl", true },
  { "gooby.co", false },
  { "good-tips.pro", true },
  { "good588.com", true },
  { "gooday.life", true },
  { "goodfor.us", true },
  { "goodhealthtv.com", true },
  { "goodiesoft.hu", true },
  { "goodmood.co.uk", true },
  { "goodmood.fr", true },
  { "goodmoodsocken.de", true },
  { "goodquote.gq", false },
  { "goodshepherdmv.com", true },
  { "goodsleep.pet", true },
  { "goodth.ink", true },
  { "goodtrip.kr", true },
  { "goodvibesblog.com", true },
  { "google", true },
  { "google-analytics.com", true },
  { "googleandroid.cz", true },
  { "googlemail.com", false },
  { "googleplex.com", true },
  { "googleshortcuts.org", true },
  { "googlesource.com", true },
  { "goombi.fr", true },
  { "goonersworld.co.uk", true },
  { "goonfleet.com", true },
  { "gooty.ru", true },
  { "goover.de", true },
  { "goow.in", true },
  { "goozp.com", true },
  { "goparity.com", true },
  { "gopayz.com.my", true },
  { "gophoto.it", true },
  { "gopnikman.cf", true },
  { "gopostore.com", true },
  { "goproinspectiongroup.com", true },
  { "goquiq.com", true },
  { "goquiqstatus.com", true },
  { "gordeijnsbouw.nl", true },
  { "gordonchevy.com", true },
  { "gordonscouts.com.au", true },
  { "gordy.fr", true },
  { "gordyf.com", true },
  { "gordyforty.com", true },
  { "gorgeconnect.com", true },
  { "gorgias.me", true },
  { "gorky.media", true },
  { "gorn.ch", true },
  { "gornergrat-kulm.ch", true },
  { "gorodabakan.ml", true },
  { "gorodrostov.tk", true },
  { "gorpg.club", true },
  { "gosaavd.tk", true },
  { "gosccs.com", true },
  { "gosforthdentalsurgery.co.uk", true },
  { "goshawkdb.io", true },
  { "goshin-group.co.jp", true },
  { "goshow.tv", true },
  { "gosnipe.com", true },
  { "gosolockpicks.com", true },
  { "gospelfollower.com", true },
  { "gospelites.com", true },
  { "gospelvestcination.de", true },
  { "gospicers.ca", true },
  { "gospomedley.com.ng", true },
  { "gosportweather.co.uk", true },
  { "gostaffer.com", true },
  { "gostargazing.co.uk", true },
  { "gosti-dom.ga", true },
  { "gosu.pro", true },
  { "gosuland.org", true },
  { "goswak.com", true },
  { "goszakupki.tk", true },
  { "got-tty.de", true },
  { "goteborgsklassikern.se", true },
  { "gotech.com.eg", false },
  { "gothamlimo.com", true },
  { "gothic.dating", true },
  { "gotirupati.com", false },
  { "gotmalk.org", false },
  { "goto.google.com", true },
  { "goto.msk.ru", true },
  { "goto.world", true },
  { "goto10.se", true },
  { "gotomi.info", false },
  { "gotowebsites.info", true },
  { "gotowned.org", false },
  { "gotoxy.at", true },
  { "gotrail.fr", true },
  { "gotravel.us", true },
  { "gottcode.org", false },
  { "goudenharynck.be", true },
  { "gouforit.com", true },
  { "gougeaway.tk", true },
  { "gouldcooksey.com", true },
  { "goup.co", true },
  { "goup.com.tr", true },
  { "gourgouli.com", true },
  { "gourmetfestival.de", true },
  { "gourmetspalencia.com", true },
  { "gourmetvitamins.ga", true },
  { "gov.tc", true },
  { "gov.uk", false },
  { "governmentjobs.gov", true },
  { "governorhub.com", true },
  { "govisitcostarica.co.cr", true },
  { "govisitcostarica.com", true },
  { "govloans.gov", true },
  { "govsurvey.us", true },
  { "govtjobs.blog", true },
  { "govtrack.us", true },
  { "govype.com", true },
  { "gow220.ru", true },
  { "gowancommunications.com", true },
  { "goweraesthetics.co.uk", true },
  { "gowervets.co.uk", true },
  { "gowildrodeo.co.uk", true },
  { "gowithflo.de", true },
  { "gozaars.com", true },
  { "gozenhost.com", true },
  { "gpalabs.com", true },
  { "gpcp.org", true },
  { "gpcsolutions.fr", true },
  { "gpdimaranathasiantar.org", false },
  { "gpfclan.de", true },
  { "gpfitness.com.br", true },
  { "gpgscoins.com", true },
  { "gpl-elite.store", true },
  { "gplans.us", true },
  { "gplvilla.com", true },
  { "gpm.ltd", true },
  { "gpna.org", true },
  { "gprs.uk.com", true },
  { "gps-fleettracking.ga", true },
  { "gpsblackbox.com", true },
  { "gpsolarpanels.com", true },
  { "gpsvideocanada.com", true },
  { "gpswebsoft.ml", true },
  { "gpu.nu", true },
  { "gpureport.cz", true },
  { "gpz500s.tk", true },
  { "gqmstore.com.br", true },
  { "gqyyingshi.com", true },
  { "gqyys.com", true },
  { "gqyyy.cc", true },
  { "gr.search.yahoo.com", false },
  { "gr8engineer2b.com", true },
  { "grabacabpa.com", true },
  { "grabadolasermonterrey.com", true },
  { "grabatt.de", true },
  { "grabtech.vn", true },
  { "grace-wan.com", true },
  { "gracebaking.com", false },
  { "gracedays.org", true },
  { "gracethrufaith.com", true },
  { "gracetini.com", true },
  { "graddient.com", true },
  { "gradecam.com", false },
  { "gradienthosting.co.uk", true },
  { "gradients.com", true },
  { "gradualgram.com", true },
  { "graeber.com", true },
  { "graecum.org", true },
  { "graetnew.com", true },
  { "graf-igor.ch", true },
  { "graf.re", true },
  { "grafcaps.com", true },
  { "graffen.dk", true },
  { "grafia.ink", true },
  { "graficasantana.com.br", true },
  { "grafik.gq", true },
  { "grafittikontroll.cf", true },
  { "grafmag.pl", true },
  { "grafoteka.pl", true },
  { "graft.community", true },
  { "graft.observer", true },
  { "grahamarthur.com", true },
  { "grahambaker.ca", true },
  { "grahamcarruthers.co.za", true },
  { "grahamcluley.com", true },
  { "grailians.com", true },
  { "grailify.com", true },
  { "graingert.co.uk", true },
  { "graliv.net", false },
  { "gramiaperu.com", true },
  { "grammysgrid.com", true },
  { "grand-city38.ru", true },
  { "grandcafecineac.nl", true },
  { "grandcafetwist.nl", true },
  { "grandcapital.cn", true },
  { "grandcapital.id", true },
  { "grandcapital.net", true },
  { "grandcapital.ru", true },
  { "grandcastles.co.uk", true },
  { "grandchene.ch", false },
  { "grande.coffee", true },
  { "grandeto.com", true },
  { "grandisco.tk", true },
  { "grandjunctionbrewing.com", true },
  { "grandmusiccentral.com.au", true },
  { "grandpadusercontent.com", true },
  { "grandwailea.com", true },
  { "grandworldnghiduong.com", false },
  { "granfort.es", false },
  { "graniteind.com", true },
  { "grannyshouse.de", true },
  { "grantcooper.com", true },
  { "grantmorrison.net", true },
  { "grantpark.org", true },
  { "grantplatform.com", true },
  { "grantsmasters.com", true },
  { "grantsplatform.com", true },
  { "graonatural.com.br", true },
  { "grapee.jp", true },
  { "grapeintentions.com", true },
  { "grapevine.is", true },
  { "graph.org", true },
  { "graphcommons.com", true },
  { "graphene.software", true },
  { "grapheneos.org", true },
  { "graphic-schools.com", true },
  { "graphic-shot.com", true },
  { "graphobyte.com", true },
  { "grapholio.net", true },
  { "grasboomamersfoort.nl", true },
  { "grasboombinnendoor.nl", true },
  { "grasboomclophaemer.nl", true },
  { "grasboomderoos.nl", true },
  { "grasboomleusden.nl", true },
  { "grasboommax.nl", true },
  { "grasboommeerbalans.nl", true },
  { "grasboomveenendaal.nl", true },
  { "grasboomvondellaan.nl", true },
  { "grasmark.com", true },
  { "graspingtech.com", true },
  { "grasscity.com", true },
  { "grassenberg.de", true },
  { "grasshoppervape.com", true },
  { "grasso.io", true },
  { "grassreinforcement.com.au", true },
  { "gratis.market", true },
  { "gratisgamecards.nl", true },
  { "gratisonlinespel.tk", true },
  { "gratisrollenspieltag.de", true },
  { "gratiswifivoorjegasten.nl", true },
  { "gratitudeabundancepassion.com", true },
  { "grattan.co.uk", true },
  { "graumeier.de", true },
  { "gravilink.com", true },
  { "graviola.es", true },
  { "gravitascreative.net", true },
  { "gravityformspdfextended.com", true },
  { "gravitypdf.com", true },
  { "grawe-blog.at", true },
  { "grayclub.co.il", true },
  { "grayhatter.com", true },
  { "grayiron.io", true },
  { "grayscale.co", true },
  { "grayson.sh", true },
  { "graz2020.com", true },
  { "grazieitalian.com", true },
  { "grazitti.com", true },
  { "grc.com", false },
  { "greatagain.gov", true },
  { "greaterlowellpediatrics.com", true },
  { "greaterreadingyp.org", true },
  { "greatestwebsiteonearth.com", true },
  { "greatfire.org", true },
  { "greathairtransplants.com", true },
  { "greatislandarts.ca", true },
  { "greatlakeside.de", true },
  { "greatlifeinsurancegroup.com", true },
  { "greatskillchecks.com", true },
  { "greatwebdesign.uk", true },
  { "greboid.com", true },
  { "greek-kitchen.co", true },
  { "greek.dating", true },
  { "greekmusic.academy", true },
  { "greekplots.com", true },
  { "greeks.tk", true },
  { "green-anarchy.tk", true },
  { "green-attitude.be", true },
  { "green-care.nl", true },
  { "green-light.co.nz", true },
  { "green-techno.ru", true },
  { "greenaddress.it", true },
  { "greenapproach.ca", true },
  { "greencircleplantnursery.com.au", true },
  { "greencircleplantnursery.net.au", true },
  { "greendrive.tk", true },
  { "greener.pl", true },
  { "greengates.co.uk", true },
  { "greengorych.ru", true },
  { "greenhats.de", true },
  { "greenliquidsystem.com", true },
  { "greenliv.pl", true },
  { "greenlungs.net", true },
  { "greenmachines.com", true },
  { "greenoutdoor.dk", false },
  { "greenpanda.de", true },
  { "greenpark.uz", true },
  { "greenpartyofnewmilford.org", true },
  { "greenpathscience.com", true },
  { "greenpaws.ee", true },
  { "greenpeace-magazin.de", true },
  { "greenpeace.berlin", true },
  { "greenponik.com", true },
  { "greenroach.ru", true },
  { "greenrushdaily.com", true },
  { "greensad36.ru", true },
  { "greensborosecuritycameras.com", true },
  { "greensdictofslang.com", true },
  { "greensidevetpractice.co.uk", true },
  { "greenstreethammers.com", true },
  { "greentea.ml", true },
  { "greenteamtwente.nl", true },
  { "greenwithdecor.com", true },
  { "greg.red", true },
  { "gregbrimble.com", true },
  { "greger.me", true },
  { "gregmarziomedia-dev.com", true },
  { "gregmarziomedia.com", true },
  { "gregmc.ru", true },
  { "gregmilton.com", true },
  { "gregmote.com", true },
  { "gregoirow.be", false },
  { "gregorians.org", true },
  { "gregorkofler.com", true },
  { "gregory-thibault.com", true },
  { "gregorydorrifourt.fr", true },
  { "gregorykelleher.com", true },
  { "gregoryrealestategroup.com", true },
  { "gregorywiest.com", true },
  { "greice.de", true },
  { "greiner-it.de", true },
  { "greinerj.de", true },
  { "grekiskagudar.tk", true },
  { "grenadiercorps-kaarst.de", true },
  { "grenadiere-kaarst.de", true },
  { "grenadierkorps-kaarst.de", true },
  { "grenadierkorps.de", true },
  { "grendel.no", true },
  { "grenlandkiropraktor.no", true },
  { "grepmaste.rs", false },
  { "grepular.com", true },
  { "greta-birkner.de", true },
  { "grexx.today", true },
  { "greyhash.se", true },
  { "greymattertechs.com", true },
  { "greysky.me", true },
  { "greyskymedia.com", true },
  { "greysolutions.it", true },
  { "greywizard.com", true },
  { "greywolf.cz", true },
  { "grh.am", true },
  { "griassdi-reseller.de", true },
  { "gricargo.com", true },
  { "grid.studio", true },
  { "gridpack.org", true },
  { "gridtennis.net", true },
  { "griechische-pfoetchen.de", true },
  { "griefheart.com", true },
  { "grieg-gaarden.no", true },
  { "grieg.no", false },
  { "griegfoundation.no", true },
  { "grieglogistics.no", true },
  { "griegshipbrokers.com", true },
  { "griegshipbrokers.no", true },
  { "griesser2.de", true },
  { "griffinsrfc.tk", true },
  { "grifomarchetti.com", true },
  { "grillen-darf-nicht-gesund-sein.de", true },
  { "grilllness.com", true },
  { "grillteller42.de", true },
  { "grimcalc.com", true },
  { "grimm-gastrobedarf.de", true },
  { "grimm.cz", true },
  { "grimneko.de", true },
  { "grimstveit.no", true },
  { "grinnellplanes.com", true },
  { "grinnellplans.com", true },
  { "grippe-impftermin.de", false },
  { "griswoldplumbingct.com", true },
  { "griswoldwellwaterct.com", true },
  { "gritte.ch", true },
  { "grizz.gdn", true },
  { "grizzlys.com", true },
  { "grocerybuild.com", true },
  { "grocock.me.uk", true },
  { "groenaquasolutions.nl", true },
  { "groentebesteld.nl", true },
  { "groepjam-usedcars.be", false },
  { "grog.pw", true },
  { "grokandtonic.com", true },
  { "grokker.com", true },
  { "groklearning.com", true },
  { "grolimur.ch", true },
  { "gronau-it-cloud-computing.de", true },
  { "grondius.com", true },
  { "groomershop.ru", false },
  { "groomscroft.co.uk", true },
  { "groomscroft.com", true },
  { "grootinadvies.nl", true },
  { "groovydisk.com", true },
  { "groovygoldfish.org", true },
  { "gropp.org", true },
  { "grosdebit.com", true },
  { "gross.business", true },
  { "grossberger-ge.org", true },
  { "grossiste-en-ligne.com", true },
  { "groszek.pl", true },
  { "groth.im", true },
  { "groth.xyz", true },
  { "grothoff.org", true },
  { "grottenthaler.eu", true },
  { "grouindev.net", true },
  { "groundmc.net", true },
  { "groundthumpingmotors.com", true },
  { "groundthumpingmotors.net", true },
  { "groundthumpinmotors.com", true },
  { "groundthumpinmotors.net", true },
  { "group4layers.net", true },
  { "groupe-neurologique-nord.lu", true },
  { "groupeatrium.net", true },
  { "groupem6.fr", true },
  { "groupescr.fr", true },
  { "groupghistelinck-cars.be", false },
  { "grouphomes.com.au", false },
  { "groupme.com", true },
  { "groups.google.com", true },
  { "groupseslogistic.com", true },
  { "grove-archiv.de", true },
  { "growingallthings.co.uk", true },
  { "growingsmiles.co.uk", true },
  { "growit.events", true },
  { "growth-rocket.com", true },
  { "growthseedconsulting.com", true },
  { "growwithdaylight.co.uk", true },
  { "growy.ch", false },
  { "grrmmll.com", true },
  { "grsecurity.net", true },
  { "gruble.de", true },
  { "gruebebraeu.ch", true },
  { "gruenderlehrstuhl.de", true },
  { "gruenderwoche-dresden.de", true },
  { "gruene-im-rvr.de", true },
  { "gruene-wattenscheid.de", true },
  { "gruenes-wp.de", true },
  { "gruenprint.de", true },
  { "gruenstreifen-ev.de", true },
  { "gruhn.email", true },
  { "grumpy.fr", true },
  { "grumpygamers.com", true },
  { "grumpyseb.com", true },
  { "grundlage.com.ua", true },
  { "grundschule-mittelbuch.de", true },
  { "grunwaldzki.center", true },
  { "grunwasser.fr", true },
  { "grupdedansa.tk", true },
  { "gruper.mk", true },
  { "grupoalpi.com", true },
  { "grupoattia.com", true },
  { "grupocata.com", true },
  { "grupodatco.com", true },
  { "grupog2i.com", true },
  { "grupoinassa.com", true },
  { "grupomakben.com", false },
  { "grupomedlegal.com", true },
  { "grupoparco.com", true },
  { "grupoproabienesraices.com.mx", true },
  { "gruposertaoveredas.com.br", true },
  { "gruselgrotte.com", true },
  { "grusenmeyer.be", true },
  { "gruver.de", true },
  { "gruwa.net", true },
  { "gruzoperevozki.ml", true },
  { "gs1pt.org", true },
  { "gs93.de", true },
  { "gsaj114.net", true },
  { "gscloud.xyz", true },
  { "gse.space", true },
  { "gsimagebank.co.uk", true },
  { "gslaw.edu.gh", true },
  { "gslink.me", true },
  { "gsmsale.nl", true },
  { "gsmsecurity.net", true },
  { "gsoc.se", true },
  { "gsrc.io", true },
  { "gst.name", true },
  { "gst.priv.at", true },
  { "gstand.tk", true },
  { "gt-himmel.com", true },
  { "gt-network.de", true },
  { "gta-arabs.com", true },
  { "gtacty.co", true },
  { "gtaforum.nl", true },
  { "gtcprojects.com", true },
  { "gtdgo.com", false },
  { "gtlfsonlinepay.com", true },
  { "gtmetrix.com", true },
  { "gtn-pravda.ru", true },
  { "gtoepfer.de", true },
  { "gtopala.com", true },
  { "gtopala.net", true },
  { "gtour.info", false },
  { "gtravers-basketmaker.co.uk", true },
  { "gtxbbs.com", true },
  { "gtxmail.de", true },
  { "guadagnare.info", true },
  { "guadalgrass.com", true },
  { "guancha.org", true },
  { "guangjiangk.com", true },
  { "guanyembadalona.org", true },
  { "guanzhong.ca", true },
  { "guardian360.nl", true },
  { "guardianportal.us", true },
  { "gubagoo.com", true },
  { "gubagoo.io", true },
  { "gudini.net", true },
  { "gudrunfit.dk", true },
  { "guegan.de", true },
  { "guenthereder.at", true },
  { "guenthernoack.de", true },
  { "guerard.info", true },
  { "guerrilla.technology", true },
  { "guesthouse-namaste.com", true },
  { "guevener.de", true },
  { "gueze-ardeche.fr", true },
  { "gueze-sas.fr", true },
  { "guffr.it", true },
  { "guge.ch", true },
  { "gugs.tk", true },
  { "guhei.net", true },
  { "guhenry3.tk", true },
  { "guiacursos.online", true },
  { "guiadamassagem.site", true },
  { "guiaextra.com", true },
  { "guiaswow.com", true },
  { "guichet-entreprises.fr", true },
  { "guichet-qualifications.fr", true },
  { "guid2steamid.com", true },
  { "guid2steamid.pw", true },
  { "guidebook.co.tz", true },
  { "guidedselling.net", true },
  { "guideline.gov", false },
  { "guidelines.gov", false },
  { "guideo.ch", false },
  { "guidepointsecurity.com", true },
  { "guidesacademe.com", true },
  { "guidesorbetiere.com", true },
  { "guidethailande.tk", true },
  { "guidetoiceland.is", false },
  { "guildbase.de", true },
  { "guilde-dissection.com", true },
  { "guildofmusicsupervisors.co.uk", true },
  { "guillaume-briand.fr", true },
  { "guillaumematheron.fr", true },
  { "guillaumeperrin.io", true },
  { "guillemaud.me", false },
  { "guillen.tk", true },
  { "guim.co.uk", true },
  { "guineapigmustach.es", true },
  { "guitarangel.tk", true },
  { "gujun-sky.com", true },
  { "gulchuk.com", true },
  { "gulcinulutuna.com", true },
  { "gulfstream.ru", true },
  { "gulleyperformancecenter.com", true },
  { "gulshankumar.net", true },
  { "gumeyamall.jp", true },
  { "gumi.ca", true },
  { "gummientchen.net", true },
  { "gunauc.net", true },
  { "gunbrig.com", true },
  { "gunerds.com.br", true },
  { "gunlukburc.net", true },
  { "gunn.ee", true },
  { "gunstatus.net", true },
  { "gunwatch.co.uk", true },
  { "gunworld.com.au", true },
  { "gunz.net", true },
  { "guodong.net", true },
  { "guohuageng.com", true },
  { "guoke.com", true },
  { "guolaw.ca", true },
  { "guoliang.me", true },
  { "guozeyu.com", true },
  { "gupfen.ch", true },
  { "guphi.net", true },
  { "gurmel.ru", true },
  { "guru-naradi.cz", true },
  { "gurucomi.com", true },
  { "gurunpa.com", true },
  { "gururi.com", true },
  { "gus.host", true },
  { "gustaff.de", true },
  { "gut8er.com.de", true },
  { "gute-schulen-porta.de", true },
  { "gutieli.com", true },
  { "gutools.co.uk", true },
  { "gutschein-spezialist.de", true },
  { "gutscheinemagic.de", true },
  { "gutscheingeiz.de", true },
  { "guyeskens.be", true },
  { "guyfletcher.com", true },
  { "guys-reviews.ml", true },
  { "guysauto.com", true },
  { "guytarrant.co.uk", true },
  { "guzdek.co", true },
  { "guzelforum.tk", true },
  { "guzlewski.pl", true },
  { "gv-neumann.de", true },
  { "gv-salto.nl", true },
  { "gvatas.in", true },
  { "gveh.de", true },
  { "gvi-timing.ch", false },
  { "gvitebsk.cf", true },
  { "gvitiming.ch", false },
  { "gvobgyn.ca", true },
  { "gvoetbaldagenalcides.nl", true },
  { "gvt2.com", true },
  { "gvt3.com", true },
  { "gvwgroup.cloud", true },
  { "gvwgroup.com", true },
  { "gvwparts.com", true },
  { "gw2efficiency.com", true },
  { "gw2treasures.com", true },
  { "gw2zone.net", true },
  { "gw66.cc", true },
  { "gwbet99.cc", true },
  { "gwerder.net", true },
  { "gwhois.org", true },
  { "gwo24.pl", true },
  { "gwrtech.com", true },
  { "gwsec.co.uk", true },
  { "gwynfryncottages.com", true },
  { "gxlrx.net", true },
  { "gxmyqy.net", true },
  { "gxpconsultora.com", true },
  { "gyas.nl", true },
  { "gymagine.ch", true },
  { "gymbunny.de", true },
  { "gymhero.me", true },
  { "gymjp.com", true },
  { "gymkirchenfeld.ch", true },
  { "gymlife.fr", true },
  { "gymnaserenens.ch", false },
  { "gymnasium-hittfeld.de", true },
  { "gymnastic.ga", true },
  { "gymnastikfitness.se", true },
  { "gymnchod.cz", true },
  { "gympap.de", true },
  { "gympass.com", true },
  { "gynaecology.co", true },
  { "gynem.de", true },
  { "gynoguide.com", true },
  { "gypsyreel.com", true },
  { "gyre.ch", false },
  { "gyrenens.ch", false },
  { "gyroscopicinvesting.com", true },
  { "gyu-raku.jp", true },
  { "gyulakerezsi.ro", true },
  { "gz-architekten.de", true },
  { "gz-benz.com", true },
  { "gz-bmw.com", true },
  { "gza.jp", true },
  { "gzom.ru", true },
  { "gzriedstadt.de", true },
  { "h-ealthy.net", true },
  { "h-jo.net", true },
  { "h-server.myfirewall.org", true },
  { "h001.ru", true },
  { "h09.eu", true },
  { "h10l.com", true },
  { "h11.io", false },
  { "h1ctf.com", true },
  { "h1z1swap.com", true },
  { "h24.org", true },
  { "h2b.me", true },
  { "h2rul.eu", true },
  { "h2s-design.de", true },
  { "h2u.tv", true },
  { "h365.vip", true },
  { "h36533.com", true },
  { "h36594.com", true },
  { "h3artbl33d.nl", true },
  { "h3x.net", true },
  { "h3z.jp", true },
  { "h404bi.com", true },
  { "h4kl4b.rs", true },
  { "h51365.com", true },
  { "h6852.com", true },
  { "h6853.com", true },
  { "h6895.com", true },
  { "h6913.com", true },
  { "h81818.com", true },
  { "h9386.com", true },
  { "ha-kunamatata.de", true },
  { "ha.com", true },
  { "ha3.eu", true },
  { "ha6.ru", true },
  { "haarigerrattenarsch.com", true },
  { "haarlemsesaxofoonschool.nl", true },
  { "haarstudiok99.nl", true },
  { "haavard.me", true },
  { "haazen.xyz", true },
  { "habarisoft.com", true },
  { "habbstars.org", true },
  { "haberer.me", true },
  { "habernet.tk", true },
  { "habitable.ga", true },
  { "habitat-domotique.fr", true },
  { "habr.com", true },
  { "habtium.es", true },
  { "hac2er.net", true },
  { "hacc.top", true },
  { "haccp.bergamo.it", true },
  { "haccp.milano.it", true },
  { "haccp.roma.it", true },
  { "hacertest.com", true },
  { "hacettepeteknokent.com.tr", true },
  { "hachre.de", false },
  { "hack.club", true },
  { "hackademix.net", true },
  { "hackadena.com", true },
  { "hackanders.com", true },
  { "hackattack.com", true },
  { "hackbarth.guru", true },
  { "hackbeil.name", true },
  { "hackdown.org", true },
  { "hackendoz.com", true },
  { "hackenkunjeleren.nl", true },
  { "hackenturet.dk", true },
  { "hacker.club", true },
  { "hacker.holiday", true },
  { "hacker.im", true },
  { "hacker.one", true },
  { "hacker1.com", true },
  { "hacker101.com", true },
  { "hackerchai.com", true },
  { "hackerco.com", true },
  { "hackereyes.com", true },
  { "hackerflare.com", true },
  { "hackergateway.com", true },
  { "hackernet.se", true },
  { "hackerone-ext-content.com", true },
  { "hackerone-user-content.com", true },
  { "hackerone.at", true },
  { "hackerone.blog", true },
  { "hackerone.com", true },
  { "hackerone.events", true },
  { "hackerone.live", true },
  { "hackerone.net", true },
  { "hackerone.org", true },
  { "hackgins.com", true },
  { "hackingand.coffee", false },
  { "hackingarise.com", true },
  { "hackingdh.com", true },
  { "hackingvision.com", true },
  { "hackintosh.eu", true },
  { "hackmd.io", true },
  { "hackmeimfamo.us", true },
  { "hackreone.com", true },
  { "hacksoc.co.uk", true },
  { "hackthat.tk", true },
  { "hackthissite.org", true },
  { "hacktivis.me", true },
  { "hacktober.dk", true },
  { "hackworx.com", false },
  { "hadaly.fr", true },
  { "haderecker.me", true },
  { "hadleighswimmingclub.co.uk", true },
  { "hadleyluker.com", true },
  { "hadouk.in", true },
  { "hadrons.org", true },
  { "hads0m.tech", true },
  { "hady.fr", true },
  { "haeckdesign.com", true },
  { "haefligermedia.ch", true },
  { "haehnel.xyz", true },
  { "haemka.de", true },
  { "haens.li", true },
  { "haerwu.biz", true },
  { "hafer.tech", true },
  { "haferman.net", true },
  { "haferman.org", true },
  { "hafniatimes.com", true },
  { "hag27.com", true },
  { "haggeluring.su", true },
  { "hagiati.gr", true },
  { "hagier.pl", true },
  { "hagueaustralia.com.au", true },
  { "haha-raku.com", true },
  { "haha.nl", true },
  { "hahay.es", true },
  { "haiboxu.com", true },
  { "hailstorm.nl", true },
  { "hainanstar.cc", true },
  { "haindlmuehle.eu", true },
  { "hair-guide.net", true },
  { "hair-reborn.be", true },
  { "haircode.gr", true },
  { "haircrazy.com", true },
  { "haircutideas.gq", true },
  { "hairfitwolvega.nl", true },
  { "hairpins.tk", true },
  { "hairplaybychenellekay.com", false },
  { "hairraisingphotobooths.co.uk", true },
  { "hairtonic-lab.com", true },
  { "haitaka.cc", true },
  { "hajekj.com", true },
  { "hajekj.cz", true },
  { "hajekj.net", true },
  { "haju.fi", true },
  { "haka.se", true },
  { "hakaru.org", true },
  { "hakase.pw", true },
  { "hakatabijin-mind.com", true },
  { "hake.me", true },
  { "hakimova.tk", true },
  { "hakkariradyo.tk", true },
  { "hakkasan.com", true },
  { "hakkasannightclub.com", true },
  { "halacs.hu", true },
  { "halbich.design", true },
  { "halfhosting.de", true },
  { "halihali.cc", true },
  { "halilweb.tk", true },
  { "halilyagcioglu.tk", true },
  { "halitopuroprodutos.com.br", true },
  { "halkirkbouncycastles.co.uk", true },
  { "hallaminternet.com", true },
  { "hallcouture.com", true },
  { "hallelujahsoftware.com", true },
  { "hallhireforevents.co.uk", true },
  { "hallhuber.com", true },
  { "halliday.work", true },
  { "halligladen.de", true },
  { "hallmarkestates.ca", true },
  { "hallme.com", true },
  { "halls.hu", true },
  { "hallucinogen.com", true },
  { "hallucinogens.org", true },
  { "halo.fr", true },
  { "halocredit.pl", true },
  { "haloria.com", true },
  { "haltegame.com", true },
  { "halyul.com", true },
  { "hamacho-kyudo.com", true },
  { "hamali.bg", true },
  { "hamarimarriage.tk", true },
  { "hambassadors.org", true },
  { "hamburg40grad.de", true },
  { "hamburgerbesteld.nl", true },
  { "hamburgobgyn.com", true },
  { "hamcocc.com", true },
  { "hamcram.io", true },
  { "hamiltonlinen.com", true },
  { "hamiltonmedical.nl", true },
  { "hamiltonweather.ca", true },
  { "hamiltonzinelibrary.cf", true },
  { "hammer-schnaps.com", true },
  { "hammer-sms.com", true },
  { "hammercast.fm", true },
  { "hammerpondkennels.co.uk", true },
  { "hampl.tv", true },
  { "hampshiretechservices.co.uk", true },
  { "hamsystems.eu", true },
  { "hana-groupsac.com", true },
  { "hana.ondemand.com", true },
  { "hanakaraku.com", true },
  { "hanazono.tokyo", true },
  { "hanbing.it", true },
  { "hancocklawfl.com", true },
  { "handbrake.fr", true },
  { "handcraft.eu.org", true },
  { "handgelenkbandage-test.de", true },
  { "handknit.com.np", true },
  { "handlecoin.com", true },
  { "handleidingkwijt.com", true },
  { "handy-reparatur-berlin.com", true },
  { "handymanbypolli.com", true },
  { "handymanlondonplease.co.uk", true },
  { "handynummer-info.ch", true },
  { "handynummer.online", true },
  { "handysex.live", true },
  { "handyticket.de", true },
  { "hanfox.co.uk", false },
  { "hanfverband-erfurt.de", true },
  { "hangar.hosting", true },
  { "hangcapnach.com", true },
  { "hangerphant.com", true },
  { "hangout", true },
  { "hangouts.google.com", true },
  { "hangtenseo.com", true },
  { "hanjuapp.com", true },
  { "hankr.com", true },
  { "hanksacservice.com", true },
  { "hannah.link", true },
  { "hannahi.com", true },
  { "hannasecret.de", true },
  { "hannes.paris", true },
  { "hannoluteijn.nl", true },
  { "hannover.de", true },
  { "hannywbarek.com", true },
  { "hanpenblog.com", true },
  { "hansbijster.nl", true },
  { "hanschventures.com", true },
  { "hansen-kronshagen.de", true },
  { "hansen.hn", true },
  { "hansgoes.it", true },
  { "hansgoes.nl", true },
  { "hansgoesit.nl", true },
  { "hansminten.com", true },
  { "hansmund.com", true },
  { "hansolrella.com", true },
  { "hansonian.com", true },
  { "hansvaneijsden.com", true },
  { "hansvaneijsden.nl", true },
  { "hanteln-fitness.de", true },
  { "hantse.com", true },
  { "hanu.la", true },
  { "hanxv.pw", true },
  { "hanyibo.com", true },
  { "hanzubon.jp", true },
  { "hao-zhang.com", true },
  { "hao6.ag", true },
  { "hao8.ag", true },
  { "haogoodair.ca", true },
  { "haozhang.org", true },
  { "haozhexie.com", true },
  { "haozhuanfa.com", true },
  { "hapheemraadssingel.nl", true },
  { "haplogroup.org", true },
  { "happist.com", true },
  { "happy-life-food.de", true },
  { "happyagain.de", true },
  { "happyagain.se", true },
  { "happyandrelaxeddogs.eu", true },
  { "happybirthdaywisher.com", true },
  { "happybounce.co.uk", true },
  { "happybrush.de", true },
  { "happycarb.de", true },
  { "happychat.io", true },
  { "happychungus.tk", true },
  { "happycoder.net", true },
  { "happydoq.ch", false },
  { "happygadget.me", true },
  { "happyhourboard.com", true },
  { "happykidscastles.co.uk", true },
  { "happylearning.com", true },
  { "happylifestyle.com", true },
  { "happyschnapper.com", true },
  { "happyteamlabs.com", true },
  { "happyukgo.com", true },
  { "hapsana.nl", true },
  { "haptemic.com", true },
  { "harabar.ml", true },
  { "haraj.com.sa", true },
  { "harald-d.dyndns.org", true },
  { "harald-pfeiffer.de", true },
  { "haramainbd.com", true },
  { "harapecorita.com", true },
  { "harbor-light.net", true },
  { "hardcoen.com", true },
  { "hardcore-bodybuilding.nl", true },
  { "hardeman.nu", true },
  { "hardenize.com", true },
  { "hardergayporn.com", true },
  { "hardertimes.com", true },
  { "hardfalcon.net", true },
  { "hardfloorcleaninglondon.co.uk", true },
  { "hardforum.com", true },
  { "hardh.at", true },
  { "hardhat.io", true },
  { "hardrain980.com", true },
  { "hardrock.tk", true },
  { "hardtfrieden.de", true },
  { "hardwareschotte.de", true },
  { "harelmallac.com", true },
  { "harelmallacglobal.com", true },
  { "hargamobilmu.com", true },
  { "haribilalic.com", true },
  { "harilova.fr", true },
  { "harington.fr", true },
  { "harion.fr", true },
  { "harisht.me", false },
  { "harititan.com", true },
  { "haritsa.co.id", true },
  { "harjitbhogal.com", true },
  { "harley-davidson-live.com", true },
  { "harmfarm.nl", true },
  { "harmoney.co.nz", true },
  { "harmoney.com", true },
  { "harmoney.com.au", true },
  { "harmonyplace.com", true },
  { "harms.io", true },
  { "harmsboone.org", true },
  { "harnov.dk", true },
  { "haroldsharpe.com", true },
  { "harp.gov", true },
  { "harpoo.jp", false },
  { "harringtonca.com", true },
  { "harrisandharris.com.au", true },
  { "harrisconsulting.ie", true },
  { "harrisonm.com", true },
  { "harrisonswebsites.com", true },
  { "harrygerritstransport.nl", true },
  { "harrymclaren.co.uk", true },
  { "harrysmallbones.co.uk", true },
  { "harrysqnc.co.uk", true },
  { "harschnitz.nl", false },
  { "hartie95.de", true },
  { "hartkampforkids.nl", true },
  { "hartleighclyde.com.au", true },
  { "hartlep.email", true },
  { "hartlieb.me", true },
  { "hartzer.com", true },
  { "haruhi.org.ua", true },
  { "harukakikuchi.com", true },
  { "harukawa.moe", true },
  { "haruue.moe", true },
  { "harvarddharma.org", true },
  { "harvestapp.com", true },
  { "harvestcookrepeat.com", true },
  { "harvester.fr", true },
  { "harveyauzorst.com", true },
  { "harveyplum.com", true },
  { "harveysautoservice.net", true },
  { "has-no-email-set.de", false },
  { "has.report", true },
  { "hasandeniz.uk", true },
  { "haschrebellen.de", true },
  { "hasecuritysolutions.com", true },
  { "haselsteiner.me", true },
  { "hash-archive.org", true },
  { "hash.army", true },
  { "hash.works", true },
  { "hashcashconsultants.com", true },
  { "hashcat.net", true },
  { "hashemian.com", true },
  { "hashes.org", true },
  { "hashi.dk", true },
  { "hashicorp.com", false },
  { "hashimah.ca", true },
  { "hashimoto-jimusho.com", true },
  { "hashinteractive.com", true },
  { "hashish.net", true },
  { "hashiura.jp", true },
  { "hashru.nl", true },
  { "hashtagpatriot.com", true },
  { "hashworks.net", true },
  { "hashxp.org", true },
  { "hasilocke.de", true },
  { "haskett.ca", true },
  { "haskovec.com", true },
  { "hasselbach-dellwig.de", true },
  { "hassra.org.uk", true },
  { "hastaneurunleri.com.tr", true },
  { "hatachan.site", true },
  { "hatarisecurity.co.ke", true },
  { "hatcher.cloud", true },
  { "hatpakha.com", true },
  { "hatter.ink", true },
  { "hatul.info", true },
  { "haucke.xyz", true },
  { "hauller.ch", true },
  { "hauntedhouserecords.co.uk", true },
  { "hauora.fyi", true },
  { "hauora.net", true },
  { "hauora.tech", true },
  { "haus-garten-test.de", true },
  { "haus-henne.de", true },
  { "haushaltsaufloesunghannover.de", true },
  { "haushenne.de", true },
  { "hausjugo.de", true },
  { "haustechnik-breu.de", true },
  { "hausundhof.com", true },
  { "hautaka.com", true },
  { "hautarztzentrum.ch", true },
  { "hauteslatitudes.com", false },
  { "havarijna-sluzba-bratislava.sk", true },
  { "havasigabor.hu", true },
  { "havasuinsurance.com", true },
  { "have.jp", true },
  { "haveabounce.co.uk", true },
  { "havedicewillsave.com", true },
  { "haveforeningen-enghaven.dk", true },
  { "havefunbiking.com", true },
  { "haveibeenpwned.com", true },
  { "havellab.de", true },
  { "havelland-obstler.de", true },
  { "havencyber.com", true },
  { "havenstrategies.com", true },
  { "havernbenefits.com", true },
  { "haverstack.com", true },
  { "havetherelationshipyouwant.com", true },
  { "hawaar.com", true },
  { "hawaiianchoice.com", true },
  { "hawaiioceanproject.com", true },
  { "hawaiiwho.com", true },
  { "hawickvets.co.uk", true },
  { "hawkeyeinsight.com", true },
  { "hawkinsonkiaparts.com", true },
  { "hawkofgeorgia.com", true },
  { "hawkon.dk", true },
  { "hawksguild.com", true },
  { "hawksracing.de", true },
  { "hax.to", true },
  { "haxdroid.com", true },
  { "haxo.nl", false },
  { "hayai.space", true },
  { "hayashi-rin.net", true },
  { "haydenjames.io", true },
  { "hayfordoleary.com", true },
  { "hayl.me.uk", true },
  { "haynes-davis.com", true },
  { "hayobethlehem.nl", true },
  { "hayonik.com", true },
  { "haystackrenovation.com.au", true },
  { "hayvid.com", true },
  { "haz.cat", true },
  { "hazelglow.com", true },
  { "hazeltime.com", true },
  { "hazeover.com", true },
  { "hazmijardin.es", true },
  { "hazukilab.com", true },
  { "hb6365.com", true },
  { "hb8522.com", true },
  { "hbaa.ml", true },
  { "hbcm70.fr", true },
  { "hbcu-colleges.com", true },
  { "hbkonsult.com", true },
  { "hboeck.de", true },
  { "hbpowell.com", true },
  { "hbudd.com", true },
  { "hbweb.io", true },
  { "hcbj.io", true },
  { "hceu-performance.com", true },
  { "hcie.pl", false },
  { "hcscrusaders.com", true },
  { "hd-gaming.com", true },
  { "hd-iptv.co", true },
  { "hd-offensive.at", false },
  { "hd-only.org", true },
  { "hd-outillage.com", true },
  { "hdbits.org", true },
  { "hdc.cz", true },
  { "hdcenter.cc", true },
  { "hdeaves.uk", true },
  { "hdf.world", true },
  { "hdfgroup.org", true },
  { "hdguru.com", true },
  { "hdhoang.space", true },
  { "hdkandsons.com", true },
  { "hdnastudio.com", true },
  { "hdrsource.com", true },
  { "hdrtranscon.com", true },
  { "hds-lan.de", true },
  { "hdtwinks.com", true },
  { "hdv.paris", true },
  { "hdwallpapers.net", true },
  { "he.kg", true },
  { "heaaart.com", true },
  { "head.ru", true },
  { "headforcloud.com", true },
  { "headjapan.com", true },
  { "headlinepublishing.be", true },
  { "healike.hk", true },
  { "healingourskin.com", true },
  { "health-and-beauty-news.net", true },
  { "health-booster.com", false },
  { "health-iq.com.au", true },
  { "health-plan-news.com", true },
  { "health.gov", true },
  { "health.graphics", true },
  { "health24world.ml", true },
  { "healthand-beautynews.net", true },
  { "healthandskinbeauty.com", true },
  { "healthcare.gov", false },
  { "healthcarereviews.tk", true },
  { "healthcaresuccess.com", true },
  { "healthcultureexpo.com", true },
  { "healthdata.gov", true },
  { "healtheffectsofasbestos.com", true },
  { "healthfinder.gov", true },
  { "healthfoam.com", true },
  { "healthgames.co.uk", true },
  { "healthiergenerations.co.uk", true },
  { "healthit.gov", true },
  { "healthplansamerica.org", true },
  { "healthstar-dev.io", true },
  { "healthstar.io", true },
  { "healththoroughfare.com", true },
  { "healthworksmarden.com.au", true },
  { "healthy-map.com", true },
  { "healthyfitfood.com", true },
  { "healthyhomesofmichigan.com", true },
  { "healthylifeelite.com", true },
  { "healthypeople.gov", true },
  { "healthyspirituality.org", true },
  { "healthystyle.tk", true },
  { "healthysuperhuman.com", true },
  { "healthyteame.com", true },
  { "heapkeeper.org", true },
  { "heardcountyathletics.com", true },
  { "hearmeraw.uk", true },
  { "heartbeat24.de", true },
  { "heartbound.wiki", true },
  { "heartcomms.com.au", true },
  { "hearthstonehungary.hu", true },
  { "heartlandbiomed.com", true },
  { "heartmdinstitute.com", true },
  { "heartsintrueharmony.com", true },
  { "hearttruth.gov", true },
  { "heartview.com.br", true },
  { "heartwoodart.com", true },
  { "hearty.eu.org", true },
  { "hearty.gq", true },
  { "hearty.me", true },
  { "hearty.ml", true },
  { "hearty.sg", true },
  { "hearty.tw", true },
  { "heartycorp.com", true },
  { "heartycraft.com", true },
  { "heatershop.co.uk", true },
  { "heathersmithcommercial.com", true },
  { "heatingandairconditioningdallastx.com", true },
  { "heatingpartswarehouse.co.uk", true },
  { "heavensattic.co.uk", true },
  { "heavensinferno.net", true },
  { "heavyequipments.org", true },
  { "hebamme-cranio.ch", true },
  { "hebbet.de", true },
  { "hebikhiv.nl", true },
  { "hebingying.cn", true },
  { "hec-espace-entreprise.ch", false },
  { "hec.global", true },
  { "heckelektro.de", true },
  { "heckerundknopp.de", true },
  { "hedge.fi", true },
  { "hedgeschool.ie", true },
  { "hedonism.org", true },
  { "hedonistic-imperative.com", true },
  { "hedonistic.org", true },
  { "hedonium.com", true },
  { "hedweb.co.uk", true },
  { "hedweb.com", true },
  { "hedweb.net", true },
  { "hedweb.org", true },
  { "hedys.de", true },
  { "heello.es", true },
  { "hefengautoparts.com", true },
  { "heftkaufen.de", true },
  { "hegen.com.pl", false },
  { "hegen.cz", false },
  { "hegen.sk", false },
  { "hegenshop.de", true },
  { "heh.ee", true },
  { "heha.co", false },
  { "heiaheia.com", true },
  { "heid.ws", true },
  { "heidisheroes.org", true },
  { "heighton.com.au", true },
  { "heightselectrical.com.au", true },
  { "heijdel.nl", true },
  { "heijmans.blog", true },
  { "heijmans.cloud", true },
  { "heijmans.email", true },
  { "heijmans.io", true },
  { "heijmans.pm", true },
  { "heijmans.xyz", true },
  { "heikegastmann.com", true },
  { "heikohessenkemper.de", true },
  { "heikorichter.name", true },
  { "heiland.io", true },
  { "heiliger-gral.info", true },
  { "heilpraxis-bgl.de", true },
  { "heimatverein-eitensheim.de", true },
  { "heimdallr.nl", true },
  { "heimonen.eu", true },
  { "heinemeier.dk", true },
  { "heino-peters.de", true },
  { "heinpost.nl", false },
  { "heinrich-kleyer-schule.de", true },
  { "heinzelmann.co", true },
  { "heiraten-gardasee.de", true },
  { "heiraten-venedig.de", true },
  { "heissluft-fritteuse.com", true },
  { "heistheguy.com", true },
  { "heitepriem.info", true },
  { "heitland-it.de", true },
  { "heiwa-valve.co.jp", false },
  { "heka.ai", true },
  { "helber-it-services.de", true },
  { "helbreath.tk", true },
  { "helden-spielen.de", true },
  { "heldenhalde.de", true },
  { "helderneves.pt", true },
  { "heldtech.services", true },
  { "heldundsexgott.de", true },
  { "heleendebruyne.be", true },
  { "helenaknowledge.com", true },
  { "helenekurtz.com", true },
  { "helenkellersimulator.org", true },
  { "helensmithpr.co.uk", true },
  { "helfordriversc.co.uk", true },
  { "helgaschultz.de", true },
  { "helichat.de", true },
  { "helifreak.club", true },
  { "helijobs.net", true },
  { "helikon.ro", true },
  { "helios4.com", true },
  { "heliosnet.com", true },
  { "heliosvoting.org", true },
  { "helix.am", true },
  { "helkyn.eu", true },
  { "helkyn.fr", true },
  { "helkyn.org", true },
  { "hell.sh", true },
  { "hella-secure.com", true },
  { "hellenicagora.co.uk", true },
  { "hellenicmusicacademy.com", true },
  { "hellerarko.de", true },
  { "hellersgas.com", true },
  { "helles-koepfchen.de", true },
  { "helloacm.com", true },
  { "helloafrica.ga", true },
  { "hellobrian.me", true },
  { "hellocyber.co.uk", true },
  { "hellofrom.com", true },
  { "hellomedian.com", true },
  { "hellomookie.com", true },
  { "hellomouse.net", true },
  { "hellosalmon.com", true },
  { "hellovillam.com", true },
  { "helloworldhost.com", false },
  { "helloyemek.com", true },
  { "hellsgamers.pw", true },
  { "hellsh.com", true },
  { "helm-pokale.at", true },
  { "helm-pokale.de", true },
  { "helm-trophy.com", true },
  { "help.simpletax.ca", true },
  { "helpconnect.com.au", true },
  { "helpkoil.com", true },
  { "helpscoutdocs.com", true },
  { "helpstarloja.com.br", true },
  { "helptasker.com", true },
  { "helptasker.net", true },
  { "helptasker.ru", true },
  { "helpwithadoption.com", true },
  { "helpwithinsomnia.org", false },
  { "helpwithmybank.gov", true },
  { "helsenorge.no", true },
  { "helsinki.dating", true },
  { "helvella.de", true },
  { "hematoonkologia.pl", true },
  { "hemdal.se", true },
  { "hemkoll.nu", true },
  { "hemnet.se", true },
  { "hemp.je", true },
  { "hems.si", true },
  { "hemtest.com", true },
  { "hen.ne.ke", true },
  { "hendersonvalleyautomotive.co.nz", true },
  { "hendranicholas.com", true },
  { "hendric.us", false },
  { "hendrickx.be", true },
  { "hendrik.li", true },
  { "hendrinortier.nl", true },
  { "hengroenet.de", true },
  { "hengstumone.com", true },
  { "henkboelman.com", true },
  { "henke-home.eu", true },
  { "henker.net", true },
  { "henkrensing.nl", true },
  { "henkverlinde.com", false },
  { "henley-computer-repairs.co.uk", true },
  { "henleybouncycastles.co.uk", true },
  { "henlich.de", true },
  { "hennecke-forstbetrieb.de", true },
  { "henneke.me", true },
  { "hennes-haan.de", true },
  { "hennes-shop.de", true },
  { "hennesshop.de", true },
  { "hennies.org", true },
  { "henningkerstan.de", true },
  { "henningkerstan.org", true },
  { "hennymerkel.com", true },
  { "henrik-bondtofte.dk", true },
  { "henrikwelk.de", true },
  { "henrilammers.nl", true },
  { "henry.gg", true },
  { "henryocallaghan.com", true },
  { "henrysautodetail.com", true },
  { "hentaigogo.com", true },
  { "hentaipornography.com", true },
  { "hentaiz.net", true },
  { "hentamanga.tk", true },
  { "hentavfall.no", true },
  { "hentschke-bau.de", true },
  { "hentschke-betonfertigteilwerk.de", true },
  { "hentschke-invest.de", true },
  { "henzenhoning.nl", true },
  { "hepla.de", true },
  { "heppler.net", true },
  { "heptafrogs.de", true },
  { "heraldik-wiki.de", true },
  { "herba-belgie.be", true },
  { "herberichfamily.com", true },
  { "herbert.io", true },
  { "herbertjanvandinther.nl", true },
  { "herbhuang.com", true },
  { "herbolarigranvida.com", true },
  { "herbweb.net", true },
  { "herbweb.org", true },
  { "herd-kaufen.com", true },
  { "herds.eu", true },
  { "herdserv.de", true },
  { "herecsrymy.cz", true },
  { "heren.fashion", true },
  { "heretic-guild.com", true },
  { "hereticle.com", true },
  { "heritagebaptistchurch.com.ph", true },
  { "heritagecoffee.co.uk", true },
  { "herkam.pl", true },
  { "hermanbrouwer.nl", true },
  { "herminghaus24.de", true },
  { "hermiu.com", true },
  { "herni-kupony.cz", true },
  { "herocentral.de", true },
  { "heroco.xyz", true },
  { "herofil.es", true },
  { "herohirehq.co.uk", true },
  { "heroiclove.com", true },
  { "heroicpixel.com", true },
  { "heroku.com", true },
  { "heroku.ga", true },
  { "heromuster.com", true },
  { "herpes-no.com", true },
  { "herranzramia.com", false },
  { "herrderzeit.de", true },
  { "herrenmuehle-wein.de", true },
  { "herrfirm.com", true },
  { "herringboneeats.com", true },
  { "herringsresidence.be", true },
  { "herrkaschke.com", true },
  { "herrschaftlich-durch-dresden.de", true },
  { "herrsmith.com", true },
  { "herrtxbias.net", false },
  { "hersdorf-eifel.de", true },
  { "hertsbouncycastles.com", true },
  { "hertz.bj", true },
  { "herz-und-gemuet.de", true },
  { "herzfuersoziales.at", true },
  { "herzig.cc", true },
  { "herzogglass.com", true },
  { "herzwacht.de", true },
  { "hes.com.cy", true },
  { "hesaplama.net", true },
  { "hessen-liebe.de", true },
  { "hesslag.com", true },
  { "hestervanderheijden.nl", true },
  { "hestia-systeme.be", true },
  { "hestia-systeme.com", true },
  { "hestia-systeme.eu", true },
  { "hestia-systeme.fr", true },
  { "hesyifei.com", true },
  { "hetene.nl", true },
  { "hethakhout.nl", true },
  { "hethely.ch", true },
  { "hetmer.cz", true },
  { "hetushu.com", true },
  { "heute-kaufen.de", true },
  { "heute.training", true },
  { "heutger.net", true },
  { "hevertonfreitas.com.br", true },
  { "hex.nl", true },
  { "hexagon-e.com", true },
  { "hexapt.com", true },
  { "hexcode.in", true },
  { "hexed.it", true },
  { "hexhu.com", true },
  { "hexiaohu.cn", true },
  { "hexicurity.com", true },
  { "hexieshe.com", true },
  { "hexo.io", false },
  { "hexony.com", true },
  { "hexr.org", true },
  { "hexsafe.io", true },
  { "hexstream.net", true },
  { "hexstream.xyz", true },
  { "hexstreamsoft.com", true },
  { "hexxagon.com", true },
  { "heyapakabar.com", true },
  { "heyboldface.com", true },
  { "heywood.cloud", true },
  { "hf51.nl", true },
  { "hg.gg", true },
  { "hg.python.org", true },
  { "hg0086.la", true },
  { "hg661.cc", true },
  { "hgbet.com", true },
  { "hgc369.com", true },
  { "hghanbarimd.com", true },
  { "hgmaranatha.nl", true },
  { "hgpowerglue.nl", true },
  { "hguandl.com", true },
  { "hgw168.com", true },
  { "hgyoseo.com", true },
  { "hh-medic.com", true },
  { "hh-wolke.dedyn.io", true },
  { "hhgdo.de", true },
  { "hhh1080.com", true },
  { "hhhdb.com", true },
  { "hhidr.org", true },
  { "hhmmmm.de", true },
  { "hhs.gov", true },
  { "hhtoners.com.br", true },
  { "hibari.moe", true },
  { "hiccupsandjuice.co.uk", true },
  { "hickorywinecellar.com", true },
  { "hicl.org", true },
  { "hicoria.com", true },
  { "hiczp.com", true },
  { "hidbo.de", true },
  { "hiddenhillselectric.com", true },
  { "hiddenhillselectrical.com", true },
  { "hiddenhillselectrician.com", true },
  { "hiddenhillsexteriorlighting.com", true },
  { "hiddenhillslandscapelighting.com", true },
  { "hiddenhillslighting.com", true },
  { "hiddenhillsoutdoorlighting.com", true },
  { "hiddenimage.ml", true },
  { "hiddenmalta.net", true },
  { "hiddenpalms.tk", true },
  { "hideallip.com", true },
  { "hideo54.com", true },
  { "hideouswebsite.com", true },
  { "hidroshop.com.br", true },
  { "hidroshoping.com.br", true },
  { "hieisuki.ga", true },
  { "hielscher.com", true },
  { "hieu.com.au", true },
  { "hif88.com", true },
  { "hiffo.de", true },
  { "hifumi.us", true },
  { "hig.gov", true },
  { "higgstools.org", true },
  { "highair.net", true },
  { "highclasseducation.com", true },
  { "highcorkett.com", true },
  { "highdesertroboticsurgery.com", true },
  { "highenergy.ro", true },
  { "highkick.jp", true },
  { "highlandparkcog.org", true },
  { "highlegshop.com", true },
  { "highlevelwoodlands.com", true },
  { "highpressuretech.com", true },
  { "highspeed-arnsberg.de", true },
  { "highspeedinternet.my", true },
  { "hightechreviews.ga", true },
  { "hightimes.com", true },
  { "highwaytohoell.de", true },
  { "hiimodel.com", true },
  { "hik-cloud.com", true },
  { "hikawa.top", true },
  { "hike.pics", true },
  { "hikerone.com", true },
  { "hikikomori-sos.site", true },
  { "hikingguy.com", true },
  { "hilahdih.cz", true },
  { "hilalnews.ga", true },
  { "hilarious.ga", true },
  { "hilaryhutler.com", true },
  { "hilchenba.ch", true },
  { "hildebrand.group", true },
  { "hilden.ws", true },
  { "hilfe-bei-krebs-vechta.de", true },
  { "hilfreiche-server.tips", true },
  { "hilhorst-uitvaartverzorging.nl", true },
  { "hillcrestswimclub.com", true },
  { "hillebrand.io", true },
  { "hillier-swift.co.uk", true },
  { "hillsandsaunders.co.uk", true },
  { "hillsandsaunders.com", true },
  { "hillsboroccpa.org", true },
  { "hillstrak.com.au", true },
  { "hillstrakwpg.com.au", true },
  { "hilltopcellar.com", true },
  { "hilnu.com", true },
  { "hiltonarubabeachservices.com", true },
  { "hiltonsydney.com.au", true },
  { "himalaya-masala.at", true },
  { "himalayanyogashram.com", true },
  { "himecorazon.com", true },
  { "himekomi.com", true },
  { "himiku.com", true },
  { "himpler.com", true },
  { "hin10.com", true },
  { "hinaryazan.com", true },
  { "hinata-hidetoshi.com", true },
  { "hindu-temple.tk", true },
  { "hingston.org", true },
  { "hintergrundbewegung.de", true },
  { "hinterhofbu.de", true },
  { "hinterposemuckel.de", true },
  { "hinyari.net", true },
  { "hiparish.org", true },
  { "hipeople.com.br", true },
  { "hipercultura.com", true },
  { "hipnos.net", true },
  { "hippiekiller.net", true },
  { "hippies.com.br", true },
  { "hippomovers.com", true },
  { "hippopotamuses.org", true },
  { "hips.com", true },
  { "hipstercat.fr", false },
  { "hiqfranchise.co.uk", true },
  { "hiqhub.co.uk", false },
  { "hiqonline.co.uk", true },
  { "hirakatakoyou.org", true },
  { "hirake55.com", true },
  { "hiratake.xyz", true },
  { "hire-a-coder.de", true },
  { "hireabouncycastle.net", true },
  { "hirel.gq", true },
  { "hiresteve.ca", true },
  { "hirevets.gov", true },
  { "hirevo.eu", true },
  { "hirevue.com", true },
  { "hirezzportal.com", true },
  { "hiromuogawa.com", true },
  { "hirotaka.org", true },
  { "hisbrucker.net", true },
  { "hisgifts.com.au", true },
  { "hisingensck.se", true },
  { "hisnet.de", true },
  { "hispadent.com.do", true },
  { "hispanic.dating", true },
  { "hisregistries.com", true },
  { "hisregistries.net", true },
  { "hisregistries.org", true },
  { "histkult.tk", true },
  { "histoire-cite.ch", false },
  { "histoiresdecontenu.com", true },
  { "histoiresdemotos.fr", true },
  { "historia-arte.com", true },
  { "historiasdepueblo.es", true },
  { "history-schools.com", true },
  { "history.google.com", false },
  { "history.gov", true },
  { "hitandhealth.nl", true },
  { "hitchpin.com", true },
  { "hitechgr.eu", true },
  { "hiteco.com", true },
  { "hiteshchandwani.com", true },
  { "hiteshjoshi.com", true },
  { "hitflow.fr", true },
  { "hitfront.com", true },
  { "hithardnews.com", true },
  { "hititgunesi-tr.com", true },
  { "hitmanstat.us", true },
  { "hitn.at", true },
  { "hitoapi.cc", true },
  { "hitocom.net.br", true },
  { "hitokoto-mania.com", true },
  { "hitokoto.cn", false },
  { "hitomecha.com", true },
  { "hitrost.com", true },
  { "hitsbola.club", true },
  { "hitter-lauzon.com", true },
  { "hitter.family", true },
  { "hitterfamily.com", true },
  { "hittop.tk", true },
  { "hiv-symptome.de", true },
  { "hiv.gov", true },
  { "hivatalinfo.hu", true },
  { "hiveopolis.eu", true },
  { "hiverlune.net", true },
  { "hiwannz.com", true },
  { "hiwiki.tk", true },
  { "hiyacar.co.uk", true },
  { "hiyobi.me", true },
  { "hiyoko-shokutaku.com", true },
  { "hiyuki2578.net", false },
  { "hizzacked.xxx", true },
  { "hj-mosaiques.be", true },
  { "hj.rs", true },
  { "hj555.cc", true },
  { "hj556.cc", true },
  { "hjartasmarta.se", true },
  { "hjertingfysioterapi.dk", true },
  { "hjort.land", true },
  { "hjortland.org", true },
  { "hjphoto.co.uk", true },
  { "hk.search.yahoo.com", false },
  { "hkas.org.hk", true },
  { "hkbsurgery.com", true },
  { "hkdobrev.com", true },
  { "hklbgd.org", true },
  { "hkmap.co", true },
  { "hkmap.com", true },
  { "hkmap.live", true },
  { "hkmap.net", true },
  { "hkr.at", true },
  { "hks-ffm.de", true },
  { "hks-projekt.at", true },
  { "hks.pw", true },
  { "hktech.com", true },
  { "hkustmbajp.com", true },
  { "hl8id.vip", true },
  { "hl8th.vip", true },
  { "hlavacek.us", true },
  { "hlavi.hu", true },
  { "hledejlevne.cz", true },
  { "hlfh.space", true },
  { "hlg66.cc", true },
  { "hlg88.cc", true },
  { "hlinformatics.nl", true },
  { "hloe0xff.ru", true },
  { "hlsmandarincentre.com", true },
  { "hlucas.de", true },
  { "hlx66.cc", true },
  { "hlx86.cc", true },
  { "hly0928.com", true },
  { "hm1ch.com", true },
  { "hm1ch.ovh", true },
  { "hmeonot.org.il", true },
  { "hmhotelec.com", false },
  { "hmnd.io", true },
  { "hmoegirl.com", true },
  { "hms-waldmann.de", true },
  { "hmsseahawk.com", true },
  { "hn.search.yahoo.com", false },
  { "hn122.cc", true },
  { "hn75.de", true },
  { "hnfertilizermachine.com", true },
  { "hnn.net.br", true },
  { "hnonline.sk", true },
  { "hnyp.hu", true },
  { "ho18.net", true },
  { "ho188.net", true },
  { "ho518.net", true },
  { "ho568.com", true },
  { "ho68.net", true },
  { "ho918.net", true },
  { "hoaas.no", true },
  { "hoahau.org", true },
  { "hoarding.me", true },
  { "hoathienthao.com", true },
  { "hoathienthao.vn", true },
  { "hobby-drechselei.de", true },
  { "hobby-freizeit.de", true },
  { "hobbyspeed.com", true },
  { "hoberg.ch", true },
  { "hochhaus.us", true },
  { "hochoukikikiraku.com", true },
  { "hochyi.com", true },
  { "hochzeit-dana-laurens.de", true },
  { "hochzeitsfotograf-deinfoto.ch", true },
  { "hochzeitsplanerin-hamburg.de", true },
  { "hodgephotography.com", true },
  { "hoe.re", true },
  { "hoeft-autolackierung.de", true },
  { "hoekvanholland.eu", true },
  { "hoeren.club", true },
  { "hoesnelwasik.nl", true },
  { "hoevenstein.nl", false },
  { "hoewler.ch", false },
  { "hof-mulin.ch", true },
  { "hofapp.de", true },
  { "hofauer.de", true },
  { "hoffmancorporation.com", true },
  { "hoffnungberlin.de", true },
  { "hoffnungdeutschland.de", true },
  { "hoflerlawfirm.com", true },
  { "hofstaetter.io", true },
  { "hogarthdavieslloyd.com", true },
  { "hoge.se", true },
  { "hogepad.com", true },
  { "hogl.dk", true },
  { "hogrebe.de", true },
  { "hogwarts.io", true },
  { "hohenleimbach.de", true },
  { "hohm.in", true },
  { "hoiquanadida.com", true },
  { "hoish.in", false },
  { "hoken-wakaru.jp", true },
  { "hokenselect.jp", true },
  { "hokioisecurity.com", true },
  { "hokung.xyz", true },
  { "holacannx.com", true },
  { "holacbdoils.com", true },
  { "holadinero.es", true },
  { "holadinero.mx", true },
  { "holboxwhalesharktours.com", false },
  { "holdengreene.com", true },
  { "holebedeljek.hu", true },
  { "holenergies.com", true },
  { "holenergies.fr", true },
  { "holgerlehner.com", true },
  { "holidayacademy.co.uk", true },
  { "holidaylocal.ga", true },
  { "holidaypackage.co", true },
  { "holidaysportugal.eu", true },
  { "holisticacupuncture.com.au", true },
  { "holistichealer.in", true },
  { "holisticon.de", true },
  { "holland-sailing.de", true },
  { "hollandsdiep.nl", true },
  { "hollermann.eu", true },
  { "hollowpoint.xyz", true },
  { "hollowrap.com", true },
  { "hollyforrest.ca", true },
  { "hollyforrestphotography.ca", true },
  { "hollywoodstars.tk", true },
  { "holmesian.org", true },
  { "holo.ovh", true },
  { "holofono.com", true },
  { "holofox.ru", true },
  { "holoxplor.space", true },
  { "holtackersleather.be", true },
  { "holtslander.ca", true },
  { "holunderbluetentee.de", true },
  { "holundersberg.de", true },
  { "holvonix.com", true },
  { "holycrossphl.org", true },
  { "holycrossverobeach.org", true },
  { "holydragoon.jp", true },
  { "holyfamilyphilly.org", true },
  { "holyfamilyrussell.org", true },
  { "holyghost-church.org", true },
  { "holygrail.games", true },
  { "holyhiphopdatabase.com", true },
  { "holymartyrschurch.org", true },
  { "holyriders.cf", true },
  { "holyspiritpalmyra.com", true },
  { "holyspiritweb.org", true },
  { "holyszko.com", true },
  { "holytransaction.com", true },
  { "holywhite.com", true },
  { "holz.nu", true },
  { "holzed.com", true },
  { "holzheizer-forum.de", true },
  { "holzheizerforum.de", true },
  { "holzschutz-holzbearbeitung.de", true },
  { "holzspielzeug-shop.ch", true },
  { "holzstueckwerk.de", true },
  { "holzundgarten.de", true },
  { "holzvergaser-forum.de", true },
  { "homatism.com", true },
  { "hombresconestilo.com", true },
  { "home-sud-renovation.com", true },
  { "homeable.io", true },
  { "homeandliving.it", true },
  { "homebank.kg", true },
  { "homebasedsalons.com.au", true },
  { "homebodyalberta.com", true },
  { "homecareassociatespa.com", true },
  { "homecareinterio.com", true },
  { "homecaring.com.au", true },
  { "homecheck.gr", true },
  { "homeehome.com", true },
  { "homegardeningforum.com", true },
  { "homegardenresort.nl", true },
  { "homegreenmark.com", true },
  { "homehunting.pt", true },
  { "homeimagician.com.au", true },
  { "homelab.farm", true },
  { "homelabalert.com", true },
  { "homelabquotes.com", true },
  { "homeland.ie", true },
  { "homeodynamics.com", true },
  { "homeoesp.org", true },
  { "homeogenium.com", false },
  { "homeownersinsurancenevada.com", true },
  { "homeownersinsurancenv.com", true },
  { "homepage.shiga.jp", true },
  { "homeporn.stream", true },
  { "homeportal.cz", true },
  { "homeprivate.de", true },
  { "homeprivate.net", true },
  { "homeseller.com", true },
  { "homeserver-kp.de", true },
  { "homeshowoff.com", true },
  { "homesteadandprepper.com", true },
  { "homesteadfarm.org", true },
  { "homeworkacers.com", true },
  { "homeyou.com", true },
  { "hommeatoutfaire.be", false },
  { "homoo.social", true },
  { "homophobia.tk", true },
  { "homophoni.com", true },
  { "hompus.nl", false },
  { "homs.design", true },
  { "homunyan.com", true },
  { "hon-matsuba.co.jp", true },
  { "honda-centrum.cz", true },
  { "hondart.cz", true },
  { "hondenoppasfraneker.nl", true },
  { "honey.beer", true },
  { "honey.is", true },
  { "honeybadger.io", false },
  { "honeybrooklibrary.org", true },
  { "honeycome.net", true },
  { "honeycreeper.com", true },
  { "honeyhaw.com", true },
  { "honeymaze.com", true },
  { "honeypot.net", true },
  { "hong.io", true },
  { "hongbomiao.com", true },
  { "hongki.tk", true },
  { "honglitrading.co.uk", true },
  { "hongoi.com", true },
  { "hongorw.tk", true },
  { "hongosdemexico.tk", true },
  { "honoka-seitai.jp", true },
  { "honovere.de", true },
  { "hontoir.eu", true },
  { "hoofdredacteuren.nl", true },
  { "hoogeveen.nl", false },
  { "hookany.com", true },
  { "hookbin.com", true },
  { "hookshotdesign.com", true },
  { "hookxlab.org", false },
  { "hoon.tk", true },
  { "hoooc.com", true },
  { "hooowl.com", true },
  { "hoop.la", true },
  { "hoopertechnicalsolutions.com", true },
  { "hooplessinseattle.com", true },
  { "hooray.beer", true },
  { "hoorr.com", true },
  { "hoosa.de", true },
  { "hoovism.com", true },
  { "hoowhen.cn", true },
  { "hopconseils.ch", false },
  { "hopconseils.com", false },
  { "hopecbd.com", true },
  { "hopemeet.me", true },
  { "hopeofmyheart.com", true },
  { "hopesanddreams.org.uk", true },
  { "hopeworld.pro", true },
  { "hoplongtech.com", true },
  { "hoponmedia.de", true },
  { "hopps.me", true },
  { "hoppyx.com", true },
  { "hopzone.net", true },
  { "horaceli.com", true },
  { "horackova.info", true },
  { "horairetrain.be", true },
  { "horairetrain.ch", true },
  { "horairetrain.fr", true },
  { "horairetrain.lu", true },
  { "horairetrain.nl", true },
  { "horclan.tk", true },
  { "hord.ca", true },
  { "horecaapparatuurkobezuijen.nl", true },
  { "horecatiger.eu", true },
  { "horeco.com", true },
  { "horeizai.net", true },
  { "horgenberg.com", true },
  { "horizon.ne.jp", true },
  { "horizonhomes-samui.com", true },
  { "horizonlawncare.tk", true },
  { "horizzon.cloud", true },
  { "horn.co", true },
  { "hornertranslations.com", true },
  { "horo.moe", true },
  { "horochx.org", true },
  { "horodance.dk", true },
  { "horrell.ca", true },
  { "horrendous-servers.com", true },
  { "horror-forum.de", true },
  { "horrormovies.gr", true },
  { "horsegateway.com", true },
  { "horsehunter.co.uk", true },
  { "horsky.me", true },
  { "horstmanshof.eu", true },
  { "horton-brasses.com", true },
  { "hory.me", true },
  { "horza.org", true },
  { "hoshimaq.com.br", true },
  { "hoshimaquinas.com.br", true },
  { "hoshinplan.com", true },
  { "hoshisato.com", true },
  { "hosiery.tk", true },
  { "hosiet.me", true },
  { "hosmussynergie.nl", false },
  { "hosoi-tax.com", true },
  { "hospeda1.com.br", true },
  { "hospitalhomelottery.org", true },
  { "hospitality-colleges.com", true },
  { "hostadvice.com", true },
  { "hostallacasamia.com", true },
  { "hostco.nl", true },
  { "hostcoz.com", true },
  { "hosteasy.nl", false },
  { "hostedtalkgadget.google.com", true },
  { "hosteleriauno.es", true },
  { "hosteons.com", true },
  { "hostfission.com", true },
  { "hostiberi.com", true },
  { "hostico.ro", true },
  { "hostinecpodlipou.cz", true },
  { "hosting-swiss.ch", true },
  { "hostingactive.it", true },
  { "hostingalternative.com", false },
  { "hostingdirectory.ga", true },
  { "hostinghelp.guru", true },
  { "hostinginnederland.nl", true },
  { "hostinglogin.net", true },
  { "hostingphp.ch", true },
  { "hostingpunt.be", true },
  { "hostingsolutions.cz", true },
  { "hostingsrv.nl", true },
  { "hostix.de", true },
  { "hostmark.pl", true },
  { "hostme.co.il", false },
  { "hostmijnpagina.nl", true },
  { "hostmodern.com.au", true },
  { "hostmywebsite.online", true },
  { "hosuronline.com", true },
  { "hot-spa.ch", false },
  { "hotartup.com", true },
  { "hotcandlestick.com", true },
  { "hotchillibox.com", true },
  { "hotcoin.io", true },
  { "hotel-alan.hr", true },
  { "hotel-kontorhaus-stralsund.de", true },
  { "hotel-kontorhaus.de", true },
  { "hotel-le-vaisseau.ch", true },
  { "hotel-pension-sonnalp.eu", true },
  { "hotel-rosner.at", true },
  { "hotel-schiller.de", true },
  { "hotel1926.com.mt", true },
  { "hotelamgarnmarkt.at", false },
  { "hotelbonacabol.com", true },
  { "hotelbretagne.dk", true },
  { "hotelcoliber.pl", true },
  { "hotelconsulado.com.br", true },
  { "hotelcorporate.codes", true },
  { "hotelcorporatecodes.com", true },
  { "hotelelaphusabrac.com", true },
  { "hoteles4you.com", true },
  { "hotelevershine.com", true },
  { "hotelflow.com.br", true },
  { "hotelident.de", true },
  { "hotelindraprasth.biz", true },
  { "hotelkaj.hr", true },
  { "hotellerssolutions.com", true },
  { "hotellilas.in", true },
  { "hotelmap.com", true },
  { "hotelmarinaadria.com", true },
  { "hotelmonal.in", true },
  { "hotelnatrajp.com", true },
  { "hotelneptundalmatien.com", true },
  { "hotelpalmas.com.br", true },
  { "hotelpostaorvieto.it", true },
  { "hotelpresident.co.in", true },
  { "hotelpromo.codes", true },
  { "hotels-insolites.com", true },
  { "hotels3d.com", true },
  { "hotels4teams.com", true },
  { "hotelsinbuxton.com", true },
  { "hotelsinformer.com", true },
  { "hotelsinncoventry.com", true },
  { "hotelsolinebrela.com", true },
  { "hotelsrit.tk", true },
  { "hotelstanford.com.co", true },
  { "hotelvalena.com", true },
  { "hotelvillaluisa.de", true },
  { "hothbricks.com", false },
  { "hotjuice.com", true },
  { "hotmann.de", true },
  { "hotnewhiphop.com", true },
  { "hoton.in", true },
  { "hotornot.com", true },
  { "hotplate.co.nz", true },
  { "hotplug.gr", true },
  { "hottaro.com", true },
  { "hottheme.net", true },
  { "hotting.nl", true },
  { "hottubhirenewcastle.co.uk", true },
  { "hottubspasnewcastle.co.uk", true },
  { "hotvideosgalleries.com", true },
  { "houby-studio.eu", true },
  { "houhuayuan.com", true },
  { "houraiteahouse.net", true },
  { "house-sparrow.com", true },
  { "houseandgarden.co.uk", true },
  { "houseboydesigns.com", true },
  { "housekeeperlondon.co.uk", true },
  { "houselocal.co.uk", true },
  { "houseofherbs.gr", true },
  { "houseofhouston.com", true },
  { "houseofpertijs.com", true },
  { "houseofyee.com", true },
  { "houser.lu", true },
  { "housese.at", true },
  { "housingneedz.com", true },
  { "houstonapartmentinsiders.com", true },
  { "houstonauthorizedrepair.com", true },
  { "houstoncreditlaw.com", true },
  { "houstonendodontics.com", true },
  { "houstongaragedoorsrepair.com", true },
  { "houstonlockout.com", true },
  { "houtinee.com", true },
  { "hoverboardbarato.com", true },
  { "how-to-simply.com", true },
  { "how2dev.tools", true },
  { "howa-n.net", true },
  { "howbehealthy.com", true },
  { "howbigismybuilding.com", true },
  { "howellaccounts.co.uk", true },
  { "howgoodwasmysex.com", true },
  { "howieisawesome.com", true },
  { "howlongtobeatsteam.com", true },
  { "howmanypeoplearethereinthe.world", true },
  { "howmanypeoplearethereintheworld.com", true },
  { "howsecureismypassword.net", true },
  { "howsmyssl.com", true },
  { "howsmytls.com", true },
  { "howson.me", true },
  { "howsyourhealth.org", true },
  { "howtogeek.com", true },
  { "howtogosolar.org", true },
  { "howtolaser.com", true },
  { "howtomovetheneedle.com", true },
  { "howtoteachviolin.com", true },
  { "howtotech.de", true },
  { "howtutu.click", true },
  { "howtutu.com", true },
  { "howtutu.email", true },
  { "howtutu.eu", true },
  { "howtutu.info", true },
  { "howtutu.link", true },
  { "howtutu.net", true },
  { "howtutu.org", true },
  { "hoxo.fr", true },
  { "hozana.si", false },
  { "hp-work.net", true },
  { "hp42.de", true },
  { "hpac-portal.com", true },
  { "hpage.com", true },
  { "hpbn.co", true },
  { "hpisavageforum.com", true },
  { "hpkp-faq.de", true },
  { "hplace.com.br", true },
  { "hps.digital", true },
  { "hps.hu", true },
  { "hpsdigital.hu", true },
  { "hpvtimmerwerken.nl", true },
  { "hq77.ru", true },
  { "hqon.com.br", true },
  { "hqq.tv", true },
  { "hquest.pro.br", true },
  { "hqwebhosting.tk", false },
  { "hqy.moe", true },
  { "hr-praemien-santander.de", true },
  { "hr-tech.shop", true },
  { "hr28.co.uk", true },
  { "hraesvelg.net", true },
  { "hrafnkellbaldurs.com", true },
  { "hranicka.cz", true },
  { "hrbanen.nl", true },
  { "hrbatypes.cz", true },
  { "hrbl.lc", true },
  { "hrbrt.nl", true },
  { "hrcrew.com.au", true },
  { "hrdns.de", false },
  { "hrebecek.cz", true },
  { "href.one", true },
  { "hreflang.info", true },
  { "hrjfeedstock.org", true },
  { "hrltech.com.br", true },
  { "hrmg.agency", true },
  { "hrna.moe", true },
  { "hro.to", true },
  { "hrobert.hu", true },
  { "hroling.nl", true },
  { "hroschyk.cz", true },
  { "hrpregnancy.com", true },
  { "hrsa.gov", true },
  { "hrtech.shop", true },
  { "hrumka.net", true },
  { "hrw66.cc", true },
  { "hryniewski.net", true },
  { "hryx.net", true },
  { "hs-arbeitsschutz.de", true },
  { "hs-group.net", true },
  { "hsappstatic.net", true },
  { "hschen.top", false },
  { "hscorp.de", true },
  { "hsg-kreuzberg.de", true },
  { "hsivonen.com", true },
  { "hsivonen.fi", true },
  { "hsivonen.iki.fi", true },
  { "hsiwen.com", true },
  { "hsjccconference.ca", true },
  { "hsmr.cc", true },
  { "hsn-tsn.com", true },
  { "hsn.com", true },
  { "hspinc.ca", true },
  { "hsr.gov", false },
  { "hsts.eu", true },
  { "hsts.me", true },
  { "hsts.ovh", true },
  { "hstsfail.appspot.com", true },
  { "hstspreload.appspot.com", true },
  { "hstspreload.com", true },
  { "hstspreload.de", true },
  { "hstspreload.org", true },
  { "hsturan.com", true },
  { "hsuan.pw", true },
  { "hszemi.de", true },
  { "ht.mk", true },
  { "htaccessbook.com", true },
  { "htaps.com", true },
  { "htb.click", true },
  { "htb.co.uk", true },
  { "htbplc.co.uk", true },
  { "htcvina.com", true },
  { "hte.ovh", true },
  { "hti.digital", true },
  { "htmanager.fr", true },
  { "htmdom.com", true },
  { "html.moe", true },
  { "html5.org", true },
  { "html5media.info", true },
  { "htmlacademy.ru", true },
  { "htmlvalidator.com", true },
  { "htmlyse.com", true },
  { "htsure.ma", false },
  { "http2.eu", true },
  { "http2.pro", true },
  { "http3.pro", true },
  { "https-rulesets.org", true },
  { "https.dk", true },
  { "https.jetzt", true },
  { "https4all.org", true },
  { "httpsarnemergan.ml", true },
  { "httpsecured.net", true },
  { "httpsecurityreport.com", true },
  { "httpsiseasy.com", true },
  { "httpsispisseasy.com", true },
  { "httpsnow.com", true },
  { "httpsnow.org", true },
  { "httpstest.com", true },
  { "httpstest.eu", true },
  { "httpstest.nl", true },
  { "httpswatch.ca", true },
  { "httpswatch.com", true },
  { "httpswatch.eu", true },
  { "httpswatch.nl", true },
  { "htxlaunch.sg", true },
  { "hu-a-u.com", true },
  { "hu.search.yahoo.com", false },
  { "hua-chuan.com.tw", true },
  { "hua-chuan.tw", true },
  { "huabantxt.com", true },
  { "huabanxs.com", true },
  { "huabianwa.com", true },
  { "huagati.com", true },
  { "huahinpropertylisting.com", true },
  { "huang-haitao.com", true },
  { "huang.nu", true },
  { "huangh.com", true },
  { "huangjiaint.com", true },
  { "huangjingjing.com", true },
  { "huangqifu.com", true },
  { "huangzenghao.cn", true },
  { "huaqian.art", true },
  { "huashan.co.uk", true },
  { "huawenyy.com", true },
  { "huaxingui.com", true },
  { "huaxueba.com", true },
  { "hub.org.ua", true },
  { "hub385.com", true },
  { "hubapi.com", true },
  { "hubchain.com", true },
  { "hubchain.com.br", true },
  { "hubchain.fr", true },
  { "hubchain.io", true },
  { "hubchain.org", true },
  { "huber-informatik.de", true },
  { "hubitt.com", true },
  { "hubok.net", true },
  { "hubspot.com", true },
  { "hubspot.de", true },
  { "hubspot.es", true },
  { "hubspot.fr", true },
  { "hubspot.jp", true },
  { "huchet.me", true },
  { "hudobniny.net", true },
  { "hudognik.com", true },
  { "hudrydum.cz", true },
  { "hudsonfaceandeye.com", true },
  { "huduser.gov", true },
  { "huendeleskopfhuette.de", true },
  { "huersch.com", true },
  { "hues-in-lee.de", true },
  { "huffduffer.com", true },
  { "hugi.is", true },
  { "huglen.info", true },
  { "hugo.pro", true },
  { "hugofs.com", true },
  { "hugolegrand.fr", true },
  { "hugolynx.fr", false },
  { "hugonote.cf", true },
  { "hugonote.ga", true },
  { "hugonote.gq", true },
  { "hugonote.ml", true },
  { "hugonote.tk", true },
  { "huguesblanchard.paris", true },
  { "huguesditciles.com", false },
  { "huh.gdn", true },
  { "huh.today", false },
  { "huihui.moe", true },
  { "huimiquan.com", true },
  { "huininga.com", true },
  { "huininga.nl", true },
  { "huininga.org", true },
  { "huipc.com", true },
  { "huirongis.me", true },
  { "huisartsenpraktijkheemraadssingel.nl", true },
  { "huisartsenpraktijksonmezer.nl", true },
  { "huisartsenpraktijkzonnehoed.nl", true },
  { "huisjeboompje-baby.nl", true },
  { "huislaw.com", true },
  { "huislijn.nl", true },
  { "huissier-vosges.com", true },
  { "huitaodang.com", true },
  { "huizenvlees.nl", true },
  { "hulaginswoodworking.com", true },
  { "hulet.tech", true },
  { "hulldevs.net", true },
  { "hullseals.space", true },
  { "hulpbijmarketing.nl", true },
  { "hulpmiddelenshop.nl", true },
  { "human-clone.com", true },
  { "humanenrich.com", true },
  { "humanesources.com", true },
  { "humanidad.tk", true },
  { "humanit.com.au", true },
  { "humanity.com", true },
  { "humaniza.com.mx", true },
  { "humanlocation.net", true },
  { "humans.io", true },
  { "humanzee.com", true },
  { "humass.nl", true },
  { "humblebee.at", true },
  { "humblebee.be", true },
  { "humblebee.co.uk", true },
  { "humblebee.cz", true },
  { "humblebee.dk", true },
  { "humblebee.es", true },
  { "humblebee.eu", true },
  { "humblebee.fr", true },
  { "humblebee.gr", true },
  { "humblebee.hu", true },
  { "humblebee.ie", true },
  { "humblebee.it", true },
  { "humblebee.nz", true },
  { "humblebee.pl", true },
  { "humblebee.uk", true },
  { "humblebee.us", true },
  { "humblebeeshop.ca", true },
  { "humblebeeshop.com.au", true },
  { "humbledot.com", true },
  { "humboldthomeguide.com", true },
  { "humboldtmfg.com", true },
  { "humdingersnj.com", true },
  { "humeur.de", true },
  { "humexe.com", true },
  { "humio.com", true },
  { "hummingbird.services", true },
  { "hummy.tv", true },
  { "humpchies.com", true },
  { "humpen.se", true },
  { "humppakone.com", true },
  { "hund.io", true },
  { "hundeverwaltung.de", true },
  { "hundhausen.de", true },
  { "hundter.com", true },
  { "hunger.im", true },
  { "huniverse.co", true },
  { "hunngard.com", true },
  { "hunqz.com", true },
  { "hunstoncanoeclub.co.uk", true },
  { "huntcraft.ru", true },
  { "hunter-read.com", true },
  { "hunter.io", true },
  { "hunterkehoe.com", true },
  { "huntertechsolution.com", true },
  { "huntexpired.com", true },
  { "huntingdonbouncers.co.uk", true },
  { "huntingdonlifesciences.com", true },
  { "huntshomeinspections.com", false },
  { "huntsmansecurity.com", true },
  { "huntsvillecottage.ca", true },
  { "huoduan.com", true },
  { "huonit.com.au", true },
  { "huoqibaike.club", true },
  { "huotuyouxi.com", true },
  { "huoyankan.com", true },
  { "hup.hu", false },
  { "hurbascooter.com", true },
  { "hurd.is", true },
  { "hurleyhomestead.com", true },
  { "huroji.com", true },
  { "hurricanelabs.com", true },
  { "hurtigtinternet.dk", true },
  { "husakbau.at", true },
  { "hushfile.it", true },
  { "husic.net", false },
  { "husk.house", true },
  { "huskyeye.de", true },
  { "huskyinc.us", false },
  { "husqvarnamoped.se", true },
  { "hussam.eu.org", true },
  { "hustlehope.com", true },
  { "huurwoordenaar.nl", true },
  { "huutonauru.net", true },
  { "huwcbjones.co.uk", true },
  { "huxcoconstruction.com", true },
  { "huxley.net", true },
  { "huynhviet.com", true },
  { "huyvu.nl", true },
  { "huzu.com", true },
  { "hv-huset.no", true },
  { "hvdbox.de", true },
  { "hvenetworks.net", true },
  { "hvgg.de", true },
  { "hvh.no", true },
  { "hvmk.nl", true },
  { "hvrint.de", true },
  { "hvt.com.au", true },
  { "hvtuananh.com", true },
  { "hw923.com", true },
  { "hwag-pb.de", true },
  { "hwlibre.com", true },
  { "hwsw.io", true },
  { "hwx8.com", true },
  { "hwxvip.com", true },
  { "hx53.de", true },
  { "hx56.cc", true },
  { "hx678.cc", true },
  { "hx77.cc", true },
  { "hx789.cc", true },
  { "hxp.io", true },
  { "hxying.com", true },
  { "hy88win.com", true },
  { "hyatt.com", true },
  { "hybridragon.net", true },
  { "hybridworx.com", true },
  { "hybridworx.de", true },
  { "hybridworx.eu", true },
  { "hybridworx.net", true },
  { "hybridworx.org", true },
  { "hybrydowe-samochody.pl", true },
  { "hybula.com", true },
  { "hycken.com", true },
  { "hyckenberg.com", true },
  { "hyderabadonlinegifts.com", true },
  { "hydrante.ch", false },
  { "hydro17.com", true },
  { "hydrographicsocietybenelux.eu", true },
  { "hydroponicglobal.com.au", true },
  { "hydroturbine.info", false },
  { "hydrozone.fr", true },
  { "hyec.jp", true },
  { "hygieneproclean.co.nz", true },
  { "hygo.com", true },
  { "hyhy1.com", true },
  { "hyhy2.com", true },
  { "hyhy7.com", true },
  { "hyhy80.com", true },
  { "hyhy81.com", true },
  { "hyhy82.com", true },
  { "hyhy83.com", true },
  { "hyhy85.com", true },
  { "hyhy89.com", true },
  { "hyhy98.com", true },
  { "hyk.me", true },
  { "hylemorphica.org", true },
  { "hyncice.com", true },
  { "hynek.me", true },
  { "hyparia.fr", true },
  { "hyparia.org", true },
  { "hype.ru", true },
  { "hyper-text.org", true },
  { "hyper.ai", true },
  { "hyper.lol", true },
  { "hyperactive.am", true },
  { "hyperalgesia.com", true },
  { "hyperautomotive.com.au", true },
  { "hyperd.sh", true },
  { "hyperion.io", true },
  { "hyperreal.biz", true },
  { "hypersomnia.com", true },
  { "hyperstack.org", true },
  { "hyperthymia.com", true },
  { "hyperv.fr", true },
  { "hypnovir.us", true },
  { "hypolineweb.de", true },
  { "hypotecnicentrum.cz", true },
  { "hypotheca.ca", true },
  { "hypothecairelening.net", true },
  { "hypotheekbond.nl", true },
  { "hypothes.is", true },
  { "hypothyroidmom.com", true },
  { "hyr.mn", true },
  { "hysh.jp", true },
  { "hysolate.com", true },
  { "hytale.com", true },
  { "hytopcp168.com", true },
  { "hyundai.no", true },
  { "hyvanilmankampaamo.fi", true },
  { "hyvinvointineuvoja.fi", true },
  { "hyyen.com", true },
  { "hztgzz.com", true },
  { "i--b.com", true },
  { "i-0v0.in", true },
  { "i-fastnet.net", true },
  { "i-geld.de", true },
  { "i-house.gq", true },
  { "i-hoz.ru", true },
  { "i-logic.co.jp", false },
  { "i-make.com", true },
  { "i-make.fr", true },
  { "i-meto.com", true },
  { "i-office.com.vn", true },
  { "i-pinged-everyone.today", true },
  { "i-proswiss.com", false },
  { "i-red.info", true },
  { "i-sports.cz", true },
  { "i-telligence.de", true },
  { "i-verbi.it", true },
  { "i-voting.pl", true },
  { "i00.eu", true },
  { "i1314.gdn", true },
  { "i2b.ro", true },
  { "i2verify.com", true },
  { "i36533.com", true },
  { "i36594.com", true },
  { "i4m1k0su.com", true },
  { "i51365.com", true },
  { "i5y.co.uk", true },
  { "i5y.org", true },
  { "i7sas.tk", true },
  { "i81818.com", true },
  { "i879.com", true },
  { "i95.me", false },
  { "i9s.in", true },
  { "ia.cafe", true },
  { "ia.net", true },
  { "iaco.li", true },
  { "iactu.info", true },
  { "iaeste.no", true },
  { "iaeste.or.jp", true },
  { "iaf.gov", true },
  { "iahemobile.net", true },
  { "iainsimms.co.uk", true },
  { "iainsimms.com", true },
  { "iainsimms.me", true },
  { "iaitouzi.com", true },
  { "ialis.me", true },
  { "ialps.cn", true },
  { "iam.lc", true },
  { "iam.soy", true },
  { "iamanewme.com", true },
  { "iambozboz.co.uk", true },
  { "iamhansen.xyz", true },
  { "iamhealthystore.com", true },
  { "iamjoshellis.com", true },
  { "iamlbk.com", true },
  { "iamlife.com", true },
  { "iamlizu.com", true },
  { "iamtheib.me", true },
  { "iamtonyarthur.com", true },
  { "iamusingtheinter.net", false },
  { "iamwill.io", true },
  { "iamwoodbeard.com", true },
  { "ianbrault.com", true },
  { "iancu.io", true },
  { "iancu.me", true },
  { "iandouglasscott.com", true },
  { "iane-ccs.com", true },
  { "ianix.com", true },
  { "ianjmoriarty.com", true },
  { "ianklug.com", true },
  { "iankmusic.com", true },
  { "ianmooreis.me", true },
  { "ianmoriarty.com.au", true },
  { "iansyst.co.uk", true },
  { "ianwalsh.org", false },
  { "iap.network", true },
  { "ias-gruppe.net", true },
  { "iassess.eu", true },
  { "iatfei.com", true },
  { "iautodily.cz", true },
  { "iavian.com", true },
  { "iba.community", true },
  { "ibacktraced.it", true },
  { "ibaq.nl", true },
  { "ibauruapan.com.mx", true },
  { "ibavaro.com", true },
  { "ibb.co", true },
  { "ibcl.us", true },
  { "ibcmed.org", true },
  { "ibe.de", true },
  { "ibeep.com", true },
  { "iberiaversicherungen.com", true },
  { "ibericaderedes.es", true },
  { "ibericarbenet.es", true },
  { "ibericarcuzco.es", true },
  { "ibericarcuzcomini.es", true },
  { "ibericarformula.es", true },
  { "ibericargestoso.es", true },
  { "ibericarmotors.es", true },
  { "ibericarmotorsmalaga.es", true },
  { "ibericarmovilcentro.es", true },
  { "ibericarmovilsur.es", true },
  { "ibericarreicomsa.es", true },
  { "ibericartechnik.es", true },
  { "iberion.pl", true },
  { "ibestproduct.com", true },
  { "ibestreview.com", true },
  { "ibexcore.com", true },
  { "ibhgospel.com", true },
  { "ibi.mt", true },
  { "ibidyoupeace.com", true },
  { "ibigawamizueco.com", true },
  { "ibin.co", true },
  { "ibiz.mk", true },
  { "iblackfriday.ro", true },
  { "ibloggospel.com", true },
  { "ibodyiq.com", true },
  { "ibps-recruitment.in", true },
  { "ibrainmedicine.org", true },
  { "ibraphotography.com", true },
  { "ibrom.eu", true },
  { "ibugone.com", true },
  { "ibuki.run", true },
  { "ibwc.gov", true },
  { "ibykos.com", true },
  { "ic-lighting.com.au", true },
  { "ic3.gov", true },
  { "icafecash.com", true },
  { "icanhas.report", true },
  { "icanhasht.ml", true },
  { "icanhazpass.com", true },
  { "icarlos.net", true },
  { "iccorporateinteriors.com.au", true },
  { "iccpublisher.com", true },
  { "icdp.org.ua", true },
  { "ice.xyz", true },
  { "iceandfiremechanical.com", true },
  { "iceberg.academy", false },
  { "icecars.net", true },
  { "icecontrol.ro", true },
  { "icecutethings.com", true },
  { "icedream.tech", true },
  { "icelandic.cf", true },
  { "icelandicasian.com", true },
  { "icetiger.eu", true },
  { "icetravellers.com", true },
  { "icewoman.net", true },
  { "ich-hab-die-schnauze-voll-von-der-suche-nach-ner-kurzen-domain.de", true },
  { "ich-tanke.de", true },
  { "icharme.fr", true },
  { "ichasco.com", true },
  { "ichbinein.org", true },
  { "ichbinkeinreh.de", true },
  { "ichitaso.com", true },
  { "iclinic.ua", true },
  { "icloud.st", true },
  { "icmhd.ch", false },
  { "icmp2018.org", true },
  { "icmshoptrend.com", true },
  { "icobench.com", true },
  { "icodeconnect.com", true },
  { "icoh.it", true },
  { "iconomi.net", true },
  { "icpc.pp.ua", true },
  { "icsfinomornasco.gov.it", true },
  { "ict-concept.nl", true },
  { "ict-crew.nl", true },
  { "ict-helpteam.nl", true },
  { "ict-radar.com", true },
  { "ict-radar.nl", true },
  { "ictbaneninnederland.nl", true },
  { "ictbiz.com.au", true },
  { "ictcareer.ch", true },
  { "ictindia.in", true },
  { "ictoniolopisa.it", true },
  { "ictradar.com", true },
  { "ictussistemas.com.br", true },
  { "icy.aq", true },
  { "icyapril.com", true },
  { "icymint.me", true },
  { "icynet.eu", true },
  { "iczc.cz", true },
  { "id-blog.ch", false },
  { "id.atlassian.com", false },
  { "id.mayfirst.org", false },
  { "id.search.yahoo.com", false },
  { "id3global.com", true },
  { "idaeus.eu", true },
  { "idahoansforliberty.net", true },
  { "idar-oberstein.de", false },
  { "idarv.com", true },
  { "idaspis.com", true },
  { "idatha.de", true },
  { "idconsult.nl", true },
  { "iddconnect.com", true },
  { "iddconnect.org", true },
  { "iddns.net", true },
  { "ideageek.net", true },
  { "ideal-envelopes.co.uk", false },
  { "idealcontabilidade.net", true },
  { "idealimplant.com", true },
  { "idealize.ml", true },
  { "idealog.id", true },
  { "idealsegurancaeletronica.com.br", true },
  { "idealtruss.com", true },
  { "idealtruss.com.tw", true },
  { "idealwhite.space", true },
  { "ideashop.com", true },
  { "ideatarmac.com", true },
  { "ideaweb.de", true },
  { "idee-lq.at", true },
  { "idee-lq.ch", true },
  { "idee-lq.com", true },
  { "idee-lq.de", true },
  { "idee-lq.net", true },
  { "ideiasefinancas.com.br", true },
  { "idenamaislami.com", true },
  { "idensys.nl", true },
  { "ident-clinic.be", true },
  { "identassist.com", true },
  { "identigraf.center", true },
  { "identity.plus", true },
  { "identitytheft.gov", true },
  { "idered.net", true },
  { "idesoft.cloud", true },
  { "idesoft.com", true },
  { "idesoft.eu", true },
  { "idesoft.net", true },
  { "idesoft.org", true },
  { "idesoftinnovacion.com", true },
  { "idesoftinnovacion.es", true },
  { "idexxpublicationportal.com", true },
  { "idgard.de", false },
  { "idgateway.co.uk", true },
  { "idhosts.co.id", true },
  { "idkidknow.com", true },
  { "idleleo.com", true },
  { "idlethoughtsandramblings.com", true },
  { "idlewildflowers.com", true },
  { "idmanagement.gov", true },
  { "idmobile.co.uk", true },
  { "idndx.com", true },
  { "idoc24.com", true },
  { "idodiandina.com", true },
  { "idolf.dk", true },
  { "idolish7.fun", false },
  { "idolknow.com", true },
  { "idontplaydarts.com", true },
  { "idoparadoxon.hu", true },
  { "idratherbequilting.com", true },
  { "idraulico-roma.it", true },
  { "idraulico-roma.org", true },
  { "idraulico.roma.it", true },
  { "idrissi.eu", true },
  { "idroserviceweb.com", true },
  { "idrycleaningi.com", true },
  { "idtheft.gov", true },
  { "idubaj.cz", true },
  { "idunno.org", true },
  { "idvl.de", true },
  { "idxforza.com", true },
  { "idyl.fr", true },
  { "idysse.com", true },
  { "ie.search.yahoo.com", false },
  { "iea-annex61.org", true },
  { "iedison.vip", true },
  { "ieeedeis.org", true },
  { "ieeesb.nl", true },
  { "ieeesbe.nl", true },
  { "ieeespmb.org", true },
  { "iegat.com", true },
  { "ieji.de", true },
  { "iemb.tk", true },
  { "ienakanote.com", false },
  { "ient.me", true },
  { "ies-italia.it", true },
  { "ies911.com", true },
  { "iesonline.co.in", true },
  { "ieval.ro", true },
  { "iexpert99.com", true },
  { "ifacservice.be", true },
  { "ifan.ws", true },
  { "ifbagro.in", true },
  { "ifconfig.se", true },
  { "ifelse.io", true },
  { "ifengge.cn", true },
  { "ifgcdn.com", true },
  { "ifibe.com", true },
  { "ifightsurveillance.com", true },
  { "ifightsurveillance.net", true },
  { "ifightsurveillance.org", true },
  { "ifiveglobal.com", true },
  { "ifixe.ch", false },
  { "iflyi.me", true },
  { "ifma.edu.br", true },
  { "ifoa.it", true },
  { "ifolder.ga", true },
  { "ifort.fr", true },
  { "ifosep.fr", false },
  { "ifoss.me", true },
  { "ifsac.org", true },
  { "ifsclist.com", true },
  { "ifsr.de", true },
  { "ift.cx", true },
  { "iftarsaati.org", true },
  { "iftrue.de", false },
  { "ifttl.com", true },
  { "ifxd.bid", true },
  { "ig.com", true },
  { "ig.me", true },
  { "iga-semi.jp", true },
  { "igap.pt", true },
  { "igarage.nl", true },
  { "igdn.de", true },
  { "igeh-immo.at", true },
  { "igglabs.com", true },
  { "iggprivate.com", true },
  { "iggsoft.com", true },
  { "iggsoftware.com", true },
  { "ighl.de", true },
  { "igiftcards.de", true },
  { "igiftcards.nl", true },
  { "igimusic.com", false },
  { "igk.nz", true },
  { "iglobus.cz", true },
  { "iglosujemy.pl", true },
  { "igmus.org", true },
  { "ignacjanskiednimlodziezy.pl", true },
  { "ignat-mag.com", true },
  { "ignat.by", true },
  { "ignatij.tk", true },
  { "ignatovich.by", true },
  { "ignatovich.me", true },
  { "ignet.gov", true },
  { "ignitedlocal.com", true },
  { "ignitelocal.com", true },
  { "ignition.gg", true },
  { "igondola.net", true },
  { "igorandandre.com", true },
  { "igorrealestate.com", true },
  { "igorw.org", true },
  { "igotoffer.com", false },
  { "igramfollower.com", true },
  { "igramming.com", true },
  { "igrarium.com.ua", true },
  { "igrivi.com", true },
  { "iguana.com.ec", false },
  { "ih8sn0w.com", true },
  { "iha6.com", true },
  { "ihacker.cn", true },
  { "ihacker.net", true },
  { "ihacklabs.com", false },
  { "ihasco.co.uk", true },
  { "ihcprofile.com", true },
  { "ihearmedical.com", true },
  { "ihempz.cz", true },
  { "ihkk.net", true },
  { "ihls.stream", true },
  { "ihmphila.org", true },
  { "ihollaback.org", true },
  { "ihorizon.jp", true },
  { "ihostup.net", true },
  { "ihotel.io", true },
  { "ihre-pflege-sachsen.de", true },
  { "ihrhost.com", true },
  { "ihtdenisjaccard.com", true },
  { "ihuan.me", true },
  { "ii74.com", true },
  { "ii918.com", true },
  { "iiax.net", true },
  { "iiax.org", true },
  { "iiit.pl", true },
  { "iimarckus.org", true },
  { "iinf.in", true },
  { "iinfin.org", true },
  { "iinix.com", true },
  { "iiong.com", true },
  { "iisjy.cn", true },
  { "iitowns.ir", true },
  { "iix.se", true },
  { "iiyama-bg.com", true },
  { "ijazjewelers.com", true },
  { "ijinus.com", true },
  { "ijm.io", true },
  { "ijohan.nl", true },
  { "ijsbaanwitten.nl", true },
  { "ijsblokjesvormen.nl", true },
  { "ijsclubdwarsgracht.nl", true },
  { "ijsclubtilburg.nl", true },
  { "ijsclubwanneperveen.nl", true },
  { "ijunohana.jp", true },
  { "ik-life.com", false },
  { "ikachalife.com", true },
  { "ikarate.ru", true },
  { "ikari-san.tk", true },
  { "ikaria.com.gr", true },
  { "ikeacareers.co.uk", true },
  { "ikebukuro-shame.com", true },
  { "ikedaquotes.org", true },
  { "ikespta.com", true },
  { "ikeyless.com", true },
  { "iki4you.com", true },
  { "ikigaiweb.com", true },
  { "ikiler.com", true },
  { "ikinokori-marketing.com", true },
  { "ikisser.de", true },
  { "ikk.me", true },
  { "ikkatsu-satei.jp", true },
  { "ikke-coach.nl", true },
  { "ikkev.de", true },
  { "ikkoku.de", true },
  { "iklive.org", false },
  { "iknet.top", true },
  { "ikparis.com", true },
  { "ikraenglish.com", false },
  { "ikulist.me", true },
  { "ikvts.de", true },
  { "ikwilthepiratebay.org", true },
  { "ikx.me", true },
  { "ila.fi", true },
  { "ilacrehberi.com", true },
  { "ilamparas.at", true },
  { "ilamparas.co.uk", true },
  { "ilamparas.com", true },
  { "ilamparas.com.co", true },
  { "ilamparas.com.ve", true },
  { "ilamparas.mx", true },
  { "ilard.fr", true },
  { "ilazycat.com", true },
  { "ilc510.com", true },
  { "ilc518.com", true },
  { "ilc519.com", true },
  { "ilc520.com", true },
  { "ilc525.com", true },
  { "ilc528.com", true },
  { "ilc552.com", true },
  { "ilc553.com", true },
  { "ilc568.com", true },
  { "ilc583.com", true },
  { "ilc588.com", true },
  { "ilc66.com", true },
  { "ilc666.com", true },
  { "ilc999.com", true },
  { "ildomani.it", true },
  { "ile-kalorii.pl", true },
  { "ile-sapporo.jp", true },
  { "ilektronika-farmakeia-online.gr", true },
  { "ilemonrain.com", true },
  { "ilformichiere.com", true },
  { "ilg.ink", true },
  { "ilgiornaledelticino.ch", true },
  { "ilhan.name", true },
  { "iliastsi.net", true },
  { "iligang.cn", true },
  { "iligang.com", true },
  { "iligang.com.cn", true },
  { "iligang.link", true },
  { "iligang.net", true },
  { "iligang.net.cn", true },
  { "iligang.xin", true },
  { "iliz-kafe.fr", true },
  { "ilkeakyildiz.com", false },
  { "illaadventure.com", true },
  { "illambias.ch", false },
  { "illange.info", true },
  { "illative.net", true },
  { "illegalpornography.com", true },
  { "illegalpornography.me", true },
  { "illerzell.de", true },
  { "illich.cz", true },
  { "illicitart.ca", true },
  { "illicitdigital.com", true },
  { "illinoiscaselaw.com", true },
  { "illorenese.fr", true },
  { "illsley.org", true },
  { "illumed.net", true },
  { "illuminationis.com", true },
  { "illusionephemere.com", false },
  { "illusionunlimited.com", true },
  { "illustrate.biz", true },
  { "illuxat.com", true },
  { "ilmainensanakirja.fi", true },
  { "ilmataat.ee", true },
  { "ilmiobusinessonline.it", true },
  { "ilmiogiardiniere.it", true },
  { "ilmuk.org", false },
  { "iloft.xyz", true },
  { "ilonewolfs.com", true },
  { "ilookz.nl", true },
  { "ilove.fish", true },
  { "ilove588.com", true },
  { "ilove618.com", true },
  { "ilove918.com", true },
  { "iloveherb.ru", true },
  { "ilovelwy.com", true },
  { "ilovequiz.ru", true },
  { "ilovesamara.tk", true },
  { "ilovestickers.gr", true },
  { "ilovethiscampsite.com", true },
  { "iloveyoutoo.tk", true },
  { "ilrg.com", true },
  { "iltec-prom.ru", true },
  { "iltec.ru", true },
  { "ilug-ktm.tk", true },
  { "ilumantio.tk", true },
  { "ilweb.es", true },
  { "ilya.pp.ua", true },
  { "im-a.cricket", true },
  { "im-c-shop.com", true },
  { "im-haus-sonnenschein.de", true },
  { "im-in.space", true },
  { "im2net.com", true },
  { "im4h.de", true },
  { "im4h.eu", true },
  { "im4h.info", true },
  { "im66.net", true },
  { "imacs.org", true },
  { "image-drive.de", true },
  { "image.tf", false },
  { "imagebin.ca", true },
  { "imagecurl.com", true },
  { "imagecurl.org", true },
  { "imagefu.com", true },
  { "imagerive.ch", false },
  { "imaginair.es", true },
  { "imaginary.ca", true },
  { "imaginary.stream", true },
  { "imaginationpathway.com", true },
  { "imagine-programming.com", true },
  { "imaginelab.club", true },
  { "imaginetricks.com", true },
  { "imagr.io", true },
  { "imanageproducts.co.uk", true },
  { "imanageproducts.uk", true },
  { "imanesdeviaje.com", true },
  { "imanolbarba.net", true },
  { "imap2imap.de", true },
  { "imarkethost.co.uk", true },
  { "imawhale.com", true },
  { "imbiancatura.milano.it", true },
  { "imbianchino.roma.it", true },
  { "imcassociation.com", true },
  { "imcsi.cn", true },
  { "imcsx.co", true },
  { "imdemos.com", true },
  { "ime-a-tolerancia-eredmenye.club", true },
  { "ime.moe", true },
  { "imed.com.pt", true },
  { "imed.pt", true },
  { "imedes.de", true },
  { "imedia.com.sg", false },
  { "imediafly.com", true },
  { "imedikament.de", true },
  { "imeds.pl", true },
  { "imex-dtp.com", true },
  { "imforza.com", true },
  { "img.com.ru", true },
  { "img.mg", true },
  { "img.ovh", true },
  { "img.ren", true },
  { "imga.ch", true },
  { "imgaa.com", true },
  { "imgal.vin", true },
  { "imgbb.com", true },
  { "imgg.es", true },
  { "imgup.co", true },
  { "imguploaden.nl", true },
  { "imhua.com", true },
  { "imi-rhapsody.eu", false },
  { "imiix.mx", true },
  { "iminshell.com", false },
  { "imirhil.fr", true },
  { "imisa.com.mx", true },
  { "imitza.com", false },
  { "imjad.cn", true },
  { "imjo.in", true },
  { "imjustcreative.com", true },
  { "imkerei-contento.de", true },
  { "imkerei-freilinger.de", false },
  { "imkereicontento.de", true },
  { "imkerverein-moenchswald.de", true },
  { "imkerverenigingzaanstreek.nl", true },
  { "imkindofabigdeal.com", true },
  { "imlec.net", true },
  { "immaterium.de", true },
  { "immatix.xyz", true },
  { "immedia.net", true },
  { "immersa.co.uk", true },
  { "immersion-pictures.com", true },
  { "immigrantdad.com", true },
  { "immivest.com", true },
  { "immo-agentur.com", false },
  { "immo-passion.net", false },
  { "immobilien-badlippspringe.de", true },
  { "immobilien-in-istanbul.de", true },
  { "immobilien-zirm.de", true },
  { "immobiliengutachter-holland.de", true },
  { "immobilier-nice.fr", true },
  { "immobilier92.net", true },
  { "immobiza.com", false },
  { "immortal-pc.info", true },
  { "immortal.run", true },
  { "immortec.com", true },
  { "immovit.be", true },
  { "imobile3.com", true },
  { "imoe.xyz", true },
  { "imokuri123.com", true },
  { "imolights.com", true },
  { "imolights.net", true },
  { "imoney.tw", true },
  { "imouto.my", false },
  { "imoveisavenda.rio.br", true },
  { "impact-fluids.com", true },
  { "impact.health.nz", true },
  { "impacter.eu", true },
  { "impactingsports.com", true },
  { "impactplumbingdrainage.com.au", true },
  { "impactpub.ch", false },
  { "impakho.com", true },
  { "impas.se", true },
  { "impelup.com", true },
  { "impera.at", true },
  { "imperial-legrand.com", true },
  { "imperialmiami.com", true },
  { "imperiumglass.com.au", true },
  { "impiantistica.org", true },
  { "implantologie-dr-loeck.de", true },
  { "impns.org", true },
  { "imponet.com.ar", true },
  { "import-shopping.de", true },
  { "importsagt.com", true },
  { "importsign.com", true },
  { "imposingoods.com", true },
  { "impossible.co", true },
  { "impossible.org", true },
  { "impossiblefitness.com", true },
  { "impossiblehq.com", true },
  { "impossiblenutrition.com", true },
  { "impossiblex.com", true },
  { "impotsimple.ca", true },
  { "imppac-schmuck.de", true },
  { "imppac.de", true },
  { "imprendo.co", true },
  { "imprendo.pro", true },
  { "impresa-di-pulizie.milano.it", true },
  { "impresa-di-pulizie.org", true },
  { "impresa-pulizie.it", true },
  { "impresadipulizia.roma.it", true },
  { "impresadipulizie.roma.it", true },
  { "impresadipulizieantonella.com", true },
  { "impresaedile.roma.it", true },
  { "impresapulizia.milano.it", true },
  { "impresapulizie.firenze.it", true },
  { "impresapuliziebergamo.it", true },
  { "imprezzor.com", true },
  { "imprimante-3d-store.fr", true },
  { "improfestival.ee", true },
  { "improklinikken.dk", true },
  { "improv.ee", true },
  { "improved-madness.de", true },
  { "improvision.eu", true },
  { "impulsocristiano.com", true },
  { "impyus.com", true },
  { "imququ.com", true },
  { "imreh.net", true },
  { "imrunner.com", true },
  { "imrunner.ru", true },
  { "ims-sargans.ch", true },
  { "imscompany.com", true },
  { "imstocker.com", true },
  { "imtikaib.ml", true },
  { "imwalking.de", true },
  { "imwjc.xyz", true },
  { "imy.rs", true },
  { "imydl.com", true },
  { "imydl.tech", true },
  { "imyjy.cn", true },
  { "imyrs.cn", true },
  { "imyunya.com", true },
  { "imyvm.com", true },
  { "imyz.tw", true },
  { "in-depthoutdoors.com", true },
  { "in-flames.com", true },
  { "in.search.yahoo.com", false },
  { "in.xero.com", false },
  { "in1000worten.de", true },
  { "in10tion.com", false },
  { "inabox.ro", true },
  { "inait.ai", true },
  { "inalvittile.cf", true },
  { "inanam.tk", true },
  { "inanyevent.london", true },
  { "inares.org", true },
  { "inbitcoin.it", true },
  { "inbound.menu", true },
  { "inbound.tk", true },
  { "inbounder.io", false },
  { "inbox.google.com", true },
  { "inboxceo.com", true },
  { "inbulgaria.info", true },
  { "incarceratedwombats.com", true },
  { "incarna.co", true },
  { "incert.cn", true },
  { "incertint.com", true },
  { "inche-ali.com", true },
  { "inchenaim.com", true },
  { "inchidi.id", true },
  { "incigma.com", false },
  { "includesubdomains.preloaded.test", true },
  { "includesubdomains2.preloaded.test", true },
  { "inclusion.tn", true },
  { "incoherent.ch", true },
  { "income.wiki", true },
  { "incomeproshoutr.com", true },
  { "incommon.io", true },
  { "incompliance.de", true },
  { "inconcerts.de", true },
  { "incontrixsingle.net", true },
  { "incore.nl", true },
  { "incosi.com", true },
  { "incowrimo.org", true },
  { "incparadise.net", true },
  { "increasetestosteronelevels.org", true },
  { "incrementation.net", true },
  { "incrom.com", true },
  { "incubos.org", true },
  { "incy.io", true },
  { "ind.ie", true },
  { "indasun.com", true },
  { "indecipherable.info", true },
  { "independencerecovery.com", true },
  { "independenttravelcats.com", true },
  { "index-mp3.com", true },
  { "indexcesmad.cz", true },
  { "indexmarket.ml", true },
  { "indiaflowermall.com", true },
  { "indiafm.tk", true },
  { "indian-elephant.com", true },
  { "indianaberry.com", true },
  { "indianafoundationpros.com", true },
  { "indianamoldrepairpros.com", true },
  { "indianapolisnews.ml", true },
  { "indianareflux.com", true },
  { "indianawaterdamagerepairpros.com", true },
  { "indianerschmuck24.de", true },
  { "indiansmartpanel.com", true },
  { "indianvisa.online", true },
  { "indiapur.com", true },
  { "indiatrademarkwatch.com", true },
  { "indiayogastudio.net", true },
  { "indicateurs-flash.fr", true },
  { "indie.dog", true },
  { "indiecongdr.it", true },
  { "indievelopment.nl", true },
  { "indigartbeading.ca", true },
  { "indigartbeading.com", true },
  { "indigitalagency.com", true },
  { "indigoblack.com.au", true },
  { "indigobooks.gq", true },
  { "indigoinflatables.com", true },
  { "indigojewelers.com", true },
  { "indigolawnscape.net", true },
  { "indigosakura.com", true },
  { "indigostudios.com", true },
  { "indigotreeservice.com", true },
  { "indika.pe", true },
  { "indio.co.jp", true },
  { "inditip.com", true },
  { "inditoot.com", true },
  { "individualizedwellness.net", true },
  { "indochina.io", true },
  { "indogermanstartup.com", true },
  { "indoor-kletterwald.de", true },
  { "indoorcomfortteam.com", true },
  { "indoorpaintball.co.uk", true },
  { "indospot.tk", true },
  { "indota.hu", true },
  { "indovinabank.com.vn", true },
  { "indusap.com", true },
  { "indusfastremit-us.com", true },
  { "indust.me", true },
  { "industriafranchini.com", true },
  { "industrial-remote-control.com", true },
  { "industrialstarter.com", true },
  { "industriemeister.io", true },
  { "indybay.org", true },
  { "ineardisplay.com", false },
  { "ineed.coffee", false },
  { "inefin.tk", true },
  { "inegol.mobi", true },
  { "inesfinc.es", true },
  { "inesta.nl", true },
  { "inet.se", true },
  { "inethost.eu", true },
  { "inetpub.cn", true },
  { "inetserver.eu", true },
  { "inetsoftware.de", true },
  { "inewroom.com", true },
  { "inf-fusion.ca", true },
  { "inf0sec.nl", true },
  { "infans.be", true },
  { "inference.biz.tr", true },
  { "infermiere.roma.it", true },
  { "inff.info", true },
  { "inffin-portal.de", true },
  { "inficom.org", true },
  { "infinipharm.com", true },
  { "infinitescript.com", true },
  { "infinitiofallentownparts.com", true },
  { "infinitioflynnwoodparts.com", true },
  { "infinitomaisum.com", true },
  { "infinity-uitvaartzorg.nl", true },
  { "infinity3dengine.com", true },
  { "infinitybas.com", true },
  { "infinitybc.se", true },
  { "infinityepos.co.uk", true },
  { "infinityvr.net", true },
  { "infirmiere-canadienne.com", true },
  { "infirmieredevie.ch", false },
  { "infivalle.gov.co", true },
  { "inflatablehire-scotland.co.uk", true },
  { "inflatablesny.com", true },
  { "inflatamania.com", true },
  { "inflatiecalculator.nl", true },
  { "inflationstation.net", true },
  { "inflexsys.com", true },
  { "influencerchampions.com", true },
  { "influo.com", true },
  { "infmed.com", true },
  { "info-beamer.com", true },
  { "info-bolivia.tk", true },
  { "info-o-zbozi.cz", true },
  { "info-screen-usercontent.me", true },
  { "info-screen.me", true },
  { "info-screw.com", true },
  { "infoamin.com", true },
  { "infobae.com", true },
  { "infobot.email", true },
  { "infobot.eu", true },
  { "infobot.nl", true },
  { "infobrain.net", true },
  { "infocity-tech.fr", true },
  { "infocoin.es", true },
  { "infocommsociety.com", true },
  { "infocon.org", true },
  { "infocus.company", true },
  { "infocusvr.net", true },
  { "infodesigners.eu", true },
  { "infodesk.at", true },
  { "infodiscus.com", true },
  { "infoduv.fr", true },
  { "infogram.com", true },
  { "infogym.com", true },
  { "infohub.com.ua", true },
  { "infoland.ml", true },
  { "infomasx.com", true },
  { "infomegastore.com", true },
  { "infomisto.com", true },
  { "infomundord.com", true },
  { "infopier.sg", true },
  { "infoprosnetwork.com", true },
  { "infor-allaitement.be", true },
  { "informace-zbozi.cz", true },
  { "informat.ga", true },
  { "informatiebeveiliging.nl", true },
  { "informatiger.net", true },
  { "informatik-handwerk.de", true },
  { "informationrx.org", true },
  { "informations-echafaudages.com", true },
  { "informhealth.com", true },
  { "informnapalm.org", true },
  { "informspb.tk", true },
  { "infosec-handbook.eu", true },
  { "infosec.exchange", false },
  { "infosec.wiki", true },
  { "infosecchicago.com", true },
  { "infosectalks.com", true },
  { "infosectekniques.com", true },
  { "infosective.org", true },
  { "infosenior.ch", true },
  { "infosexual.com", true },
  { "infosubasta.es", true },
  { "infotainworld.com", true },
  { "infotelecharge.com", true },
  { "infotune.nl", true },
  { "infovision-france.com", true },
  { "infra-se.com", true },
  { "infra.land", true },
  { "infraball.com", true },
  { "infrabeep.com", true },
  { "infrabeta.com", true },
  { "infrabind.com", true },
  { "infrabold.com", true },
  { "infrabond.com", true },
  { "infraboom.com", true },
  { "infraclass.com", true },
  { "infraclip.com", true },
  { "infracron.com", true },
  { "infradart.com", true },
  { "infradisk.com", true },
  { "infradrop.com", true },
  { "infraedifice.com", true },
  { "infrafile.com", true },
  { "infrafind.com", true },
  { "infrafire.com", true },
  { "infraflip.com", true },
  { "infraflux.com", true },
  { "infrafuse.com", true },
  { "infrafusion.com", true },
  { "infralira.com", true },
  { "infralist.com", true },
  { "infraloon.com", true },
  { "inframake.com", true },
  { "inframeet.com", true },
  { "inframenu.com", true },
  { "inframetro.com", true },
  { "inframint.com", true },
  { "infraname.com", true },
  { "infranest.com", true },
  { "infranium.com", true },
  { "infranium.eu", true },
  { "infranium.info", true },
  { "infranium.net", true },
  { "infranium.org", true },
  { "infranotes.com", true },
  { "infranoto.com", true },
  { "infranox.com", true },
  { "infrapass.com", true },
  { "infrapeer.com", true },
  { "infrapilot.com", true },
  { "infraping.com", true },
  { "infrapirtis.lt", true },
  { "infraplot.com", true },
  { "infrarank.com", true },
  { "infrarank.net", true },
  { "infraredradiant.com", true },
  { "infrarot-thermometer.info", true },
  { "infraspin.com", true },
  { "infratank.com", true },
  { "infratask.com", true },
  { "infrathink.com", true },
  { "infratrip.com", true },
  { "infravibe.com", true },
  { "infravideo.com", true },
  { "infravoce.com", true },
  { "infrazine.com", true },
  { "ing-buero-junk.de", true },
  { "ingadesign.it", true },
  { "ingatlanjogaszok.hu", true },
  { "ingber.com", true },
  { "inge-r.nl", true },
  { "ingeeibach.de", true },
  { "ingenias.es", true },
  { "ingenius.ws", true },
  { "ingermany.ml", true },
  { "ingestion.life", true },
  { "ingi.ga", true },
  { "ingjobs.ch", true },
  { "inglebycakes.co.uk", true },
  { "inglesencanada.cf", true },
  { "inglesnarede.com.br", true },
  { "ingo-schlueter.de", true },
  { "ingolonde.pw", true },
  { "ingoschlueter.de", true },
  { "ingressfs.pl", true },
  { "inh.gob.ve", true },
  { "inhaltsangabe.de", true },
  { "inheritestate.com", true },
  { "inhouseents.co.uk", true },
  { "iniby.com", true },
  { "inima.org", true },
  { "iningrui.com", true },
  { "inishbofin.ie", true },
  { "init.blog", true },
  { "initialization.tech", true },
  { "initramfs.io", true },
  { "initrd.net", true },
  { "injigo.com", false },
  { "injurylawyer.com", true },
  { "ink.horse", true },
  { "inkable.com.au", true },
  { "inkbunny.net", true },
  { "inkeliz.com", true },
  { "inkhor.se", true },
  { "inkontriamoci.com", true },
  { "inkopers.org", true },
  { "inksay.com", true },
  { "inkspire.co.uk", true },
  { "inkthreadable.co.uk", true },
  { "inkurz.de", true },
  { "inlabo.de", true },
  { "inline-sport.cz", true },
  { "inlinea.ch", true },
  { "inlineskating.ga", true },
  { "inlink.ee", true },
  { "inlt.com", true },
  { "inmaps.xyz", true },
  { "inmatefinancial.com", true },
  { "inmateintake.com", true },
  { "inmatesupport.org", true },
  { "inmedic.pl", true },
  { "inmedsm.com", true },
  { "inmigracion-florida.com", true },
  { "inmobillium.fr", true },
  { "inmueblescartagena.com.co", true },
  { "innatocol.com", true },
  { "innerfence.com", true },
  { "innerlightcrystals.co.uk", true },
  { "innermostparts.org", true },
  { "innersafe.com", true },
  { "innico.cf", true },
  { "inno.ch", false },
  { "innocenceseekers.net", true },
  { "innogen.fr", true },
  { "innohb.com", true },
  { "innolabfribourg.ch", true },
  { "innophate-security.com", true },
  { "innoraft.com", true },
  { "innot.net", true },
  { "innotas.com", true },
  { "innoteil.com", true },
  { "innotel.com.au", true },
  { "innovacoachgroup.com", true },
  { "innovairservices.ch", true },
  { "innovamag.com", true },
  { "innovaptor.at", true },
  { "innovaptor.com", true },
  { "innovate-indonesia.com", true },
  { "innovation-workshop.ro", true },
  { "innovation.gov", false },
  { "innover.se", true },
  { "innovere.co.uk", true },
  { "innovomuebles.com", true },
  { "innovum.cz", true },
  { "innsalzachsingles.de", true },
  { "innvisiondesign.net", true },
  { "innwan.com", true },
  { "inoa8.com", true },
  { "inobun.jp", true },
  { "inocelda.com", true },
  { "inodari.com", true },
  { "inoio.de", true },
  { "inondation.ch", false },
  { "inovatec.com", true },
  { "inovatecapi.com", true },
  { "inovatecsystems.com", true },
  { "inovitec.eu", false },
  { "inoxdesign.fr", true },
  { "inoxdesign.pro", true },
  { "inoxmavang.net", true },
  { "inpas.co.uk", true },
  { "inpatec.com", true },
  { "inpdp.tk", true },
  { "inpector.de", true },
  { "inphi.com", true },
  { "inprotec.com.co", true },
  { "input.pt", true },
  { "inputmodes.com", true },
  { "inqorp.ca", true },
  { "inquant.de", true },
  { "ins-kreativ.de", true },
  { "ins.to", true },
  { "ins1gn1a.com", true },
  { "insanelyelegant.com", true },
  { "inscomers.net", false },
  { "inscribe.ai", true },
  { "inscripcionessena.com", true },
  { "insecret.co.ua", true },
  { "insecret.com.ua", true },
  { "insecret.trade", true },
  { "insecure.org.je", true },
  { "insegne.roma.it", true },
  { "insertcoins.net", true },
  { "inserzioniticino.ch", true },
  { "insgesamt.net", true },
  { "inshapenutrition.com.br", true },
  { "insho.fashion", true },
  { "inshop.hu", true },
  { "insiberia.tk", true },
  { "inside19.com", true },
  { "insideaudit.com", true },
  { "insidebedroom.com", true },
  { "insideevs.com", true },
  { "insideevs.fr", true },
  { "insidesolutions.nl", true },
  { "insidethefirewall.tk", true },
  { "insights.is", true },
  { "insignificant.space", true },
  { "insinuator.net", true },
  { "insistel.com", true },
  { "insomniasec.com", true },
  { "inspiratienodig.nl", true },
  { "inspired-creations.co.za", true },
  { "inspired-lua.org", true },
  { "inspiredlife.fun", true },
  { "inspiredrealtyinc.com", true },
  { "inspiresurgery.com", true },
  { "insside.net", true },
  { "insta-drive.com", true },
  { "instafind.nl", true },
  { "instafuckfriend.com", true },
  { "instagc.com", true },
  { "instagram-atom.appspot.com", true },
  { "instagram.com", false },
  { "instagrammernews.com", true },
  { "instagramtweet.com", true },
  { "instagraph.cn", true },
  { "instahub.net", true },
  { "installatietechniekgresnigt.nl", true },
  { "installgentoo.net", true },
  { "instamojo.com", true },
  { "instant-clearance-sale.co.uk", true },
  { "instant-thinking.de", true },
  { "instant.io", true },
  { "instantdomainsearch.com", true },
  { "instantkhabar.com", true },
  { "instava.cz", true },
  { "instawierszyki.pl", true },
  { "instead.com.au", true },
  { "insteagle.com", true },
  { "instela.com", true },
  { "instelikes.com.br", true },
  { "instics.com", true },
  { "institut-confucius-montpellier.org", true },
  { "institut-uthyl.com", true },
  { "institutogiuseppe.com", true },
  { "institutogiuseppe.com.ar", true },
  { "institutointersistemico.com.br", true },
  { "institutolancaster.com", true },
  { "institutomaritimocolombiano.com", true },
  { "instrumart.ru", false },
  { "insult.es", true },
  { "insurance321.com", true },
  { "insuranceonlinenow.com", true },
  { "insurediy.com.sg", true },
  { "insureon.com", true },
  { "int64software.com", true },
  { "intafe.co.jp", true },
  { "intakesync.com", true },
  { "intal.info", true },
  { "intarweb.ca", true },
  { "intasky.cz", true },
  { "intasky.sk", true },
  { "integ.jp", true },
  { "integralblue.com", true },
  { "integralkk.com", true },
  { "integralsalud.xyz", true },
  { "integrata.de", true },
  { "integratedintegrations.xyz", true },
  { "integratedmedicalonline.com", true },
  { "integratemyschool.com", true },
  { "integrateur-web-paris.com", true },
  { "integritet.com.se", true },
  { "integrity.gov", true },
  { "integrityglobal.com", true },
  { "integrityokc.com", true },
  { "integrityoklahoma.com", true },
  { "integrogroup.com", true },
  { "integromat.com", true },
  { "integroof.com", true },
  { "integsystem.com", true },
  { "intelhost.cl", true },
  { "intelhost.com", true },
  { "intelhost.com.ar", true },
  { "intelhost.com.br", true },
  { "intelhost.com.co", true },
  { "intelhost.com.mx", true },
  { "intelhost.com.pe", true },
  { "inteli.com.pl", true },
  { "intellar.com", true },
  { "intellectdynamics.com", true },
  { "intelliance.eu", true },
  { "intelligence-explosion.com", true },
  { "intelligenetics.com", true },
  { "intelligentcontacts.com", true },
  { "intellihr.io", true },
  { "intellimatica.se", true },
  { "intellimax.ir", true },
  { "intellinetixvibration.com", true },
  { "intellitonic.com", true },
  { "intelly.nl", true },
  { "intelly365.nl", true },
  { "intelmed.info", true },
  { "intencje.pl", true },
  { "intensify.pictures", true },
  { "intensivpflege-sachsen.de", true },
  { "intentanalytica.com", true },
  { "inter-corporate.com", true },
  { "interaffairs.com", true },
  { "interaktiva.fi", true },
  { "interasistmen.se", true },
  { "interchanges.io", true },
  { "intercom.com", true },
  { "intercom.io", true },
  { "intercrosse.tk", true },
  { "interessengemeinschaft-pregelstrasse.tk", true },
  { "interessiert-uns.net", true },
  { "interflores.com.br", true },
  { "interfug.de", true },
  { "intergozd.si", true },
  { "interiery-waters.cz", true },
  { "interimages.fr", true },
  { "interior-design-colleges.com", true },
  { "interiordesignsconcept.com", true },
  { "interisaudit.com", true },
  { "interlijn.nl", true },
  { "interlingvo.biz", true },
  { "intermax.nl", true },
  { "intermedinet.nl", true },
  { "interminsk.tk", true },
  { "intern.tax", true },
  { "internalkmc.com", true },
  { "international-arbitration-attorney.com", true },
  { "international-books.org", false },
  { "international-nash-day.com", true },
  { "internationalfashionjobs.com", true },
  { "internationalschool.it", true },
  { "internationalstudentassociation.com", true },
  { "internationaltalento.it", true },
  { "internect.co.za", true },
  { "internet-aukcion.info", true },
  { "internet-pornografie.de", false },
  { "internet-software.eu", true },
  { "internet-tv4u.tk", true },
  { "internet42.tk", true },
  { "internetaanbieders.eu", true },
  { "internetanbieter-experte.de", true },
  { "internetbank.swedbank.se", true },
  { "internetbugbounty.com", true },
  { "internetbusiness-howto.com", true },
  { "internetcom.jp", true },
  { "internetfonden.se", true },
  { "internetgardener.co.uk", true },
  { "internetinhetbuitengebied.nl", true },
  { "internetk.tk", true },
  { "internetloansdirect.com", true },
  { "internetmagaz.tk", true },
  { "internetmedia.si", true },
  { "internetmuseum.se", true },
  { "internetmusicexchange.com", true },
  { "internetnz.nz", true },
  { "internetofdon.gs", true },
  { "internetoffensive.fail", true },
  { "internetofinsecurethings.com", true },
  { "internetovehazardnihry.cz", true },
  { "internetpro.me", true },
  { "internetstaff.com", true },
  { "internetstiftelsen.se", true },
  { "internetzentrale.net", true },
  { "internetzonei.com", true },
  { "interparcel.com", true },
  { "interphoto.by", true },
  { "interpol.gov", true },
  { "interracial.dating", true },
  { "interseller.io", true },
  { "interssl.com", true },
  { "interstateautomotiveinc.com", true },
  { "interstateremovalists.sydney", true },
  { "intertime.services", true },
  { "interviewme.pl", true },
  { "interways.de", true },
  { "intheater.de", true },
  { "inthepicture.com", true },
  { "inthouse.cloud", true },
  { "intimznakomstvo.tk", true },
  { "intita.com", true },
  { "intl-webs.com", true },
  { "intmissioncenter.org", false },
  { "into-the-mountain.com", true },
  { "into.technology", true },
  { "inton.biz", true },
  { "intoparking.com", true },
  { "intoparking.fi", true },
  { "intpforum.com", true },
  { "intr0.cf", true },
  { "intrack.net.au", true },
  { "intradayseasonals.com", true },
  { "intranet.dvag", true },
  { "intranetcrowd.com", true },
  { "intraobes.com", true },
  { "intrasoft.com.au", true },
  { "intraxia.com", true },
  { "intrepy.com", true },
  { "intrigue3d.com", true },
  { "intrixgroup.com", true },
  { "intrixlifestyle.com", true },
  { "introes.com", true },
  { "intropickup.ru", true },
  { "introspectivemarketresearch.com", true },
  { "intvonline.com", true },
  { "intxt.net", true },
  { "inu.codes", true },
  { "inumcoeli.com.br", true },
  { "inup.jp", true },
  { "inusasha.de", true },
  { "invadelabs.com", true },
  { "invalida.ru", true },
  { "invasion.com", true },
  { "invasivespeciesinfo.gov", true },
  { "invasmani.com", true },
  { "inventaire.ch", false },
  { "inventionsteps.com.au", true },
  { "inventix.nl", true },
  { "inventoryimages.co.uk", true },
  { "inventoryimages.com", true },
  { "inventtatte.com", true },
  { "inventtheworld.com.au", true },
  { "inventum.cloud", true },
  { "inverselink-user-content.com", true },
  { "inversionesgalindo.com", true },
  { "investactiv.tk", true },
  { "investarholding.nl", true },
  { "investforum.net", true },
  { "investigatore.it", true },
  { "investigatore.roma.it", true },
  { "investigatore.torino.it", true },
  { "investigazione.milano.it", true },
  { "investigazionimoretti.it", true },
  { "investinturkey.com.tr", true },
  { "investinweed.com", true },
  { "investor-academy.jp", true },
  { "investor.gov", true },
  { "investoren-beteiligung.de", true },
  { "investorforms.com", true },
  { "investpay.ru", true },
  { "investuji.net", true },
  { "invetep.sk", true },
  { "invidio.us", true },
  { "invinoaustria.com", true },
  { "invinoaustria.cz", true },
  { "invioinc.com", true },
  { "inviosolutions.com", true },
  { "invisible-college.com", true },
  { "invisiverse.com", true },
  { "invitacionesytarjetas.gratis", true },
  { "invitescene.com", true },
  { "invitethemhome.com", true },
  { "invkao.com", true },
  { "invoiced.com", true },
  { "involic.com", true },
  { "invuite.com", true },
  { "invuite.com.au", true },
  { "inwao.com", true },
  { "inwebo.com", true },
  { "inwestcorp.se", true },
  { "inyourcornerinsurance.com", true },
  { "inyourowntime.info", true },
  { "inyourowntime.zone", true },
  { "inyr.hu", true },
  { "inzdr.com", true },
  { "inzelabs.com", true },
  { "inzernettechnologies.com", true },
  { "ioactive.com", true },
  { "ioasync.com", true },
  { "iobint.com", true },
  { "iocheck.com", true },
  { "iochen.com", true },
  { "iocurrents.com", true },
  { "iofort.com", true },
  { "ioliver.co.uk", true },
  { "iomedia.ch", true },
  { "iompost.com", true },
  { "iomstamps.com", true },
  { "iondrey.cf", true },
  { "iondrey.fr", true },
  { "iondrey.ga", true },
  { "iondrey.gq", true },
  { "iondrey.ml", true },
  { "iondrey.tk", true },
  { "ionlabs.kr", true },
  { "ionplesalexandru.com", true },
  { "ionspin.com", true },
  { "ionx.co.uk", true },
  { "ioover.net", true },
  { "iop.intuit.com", false },
  { "ios11018.com", false },
  { "iosartstudios.gr", true },
  { "iosecurity.co.za", true },
  { "ioslo.net", true },
  { "iosnoops.com", true },
  { "iossifovlab.com", true },
  { "iostream.by", true },
  { "iotac.xyz", true },
  { "iotekha.tv", true },
  { "iotorq.com", true },
  { "iotsys.in", true },
  { "iowaent.com", true },
  { "iowaschoolofbeauty.com", true },
  { "iowen.cn", true },
  { "ip-address.me", true },
  { "ip-hahn.de", true },
  { "ip-life.net", true },
  { "ip-tanz.com", true },
  { "ip.sb", true },
  { "ip3office.com", false },
  { "ip40.com", true },
  { "ip6.li", true },
  { "ipadkaitori.jp", true },
  { "ipal.im", true },
  { "ipal.name", true },
  { "ipal.pl", true },
  { "ipal.tel", true },
  { "ipanchev.com", true },
  { "iparkki.com", true },
  { "ipcareers.net", true },
  { "ipcyb.com", true },
  { "ipdsols.co.za", true },
  { "ipemcomodoro.com.ar", true },
  { "iperconnessi.it", true },
  { "ipfire.org", true },
  { "ipfirebox.de", true },
  { "ipfs.io", true },
  { "iphonekaitori.tokyo", true },
  { "iphoneunlock.nu", true },
  { "ipinfo.tw", true },
  { "iplantom.com", true },
  { "iplaycraft.ru", true },
  { "iplayradio.net", false },
  { "ipleak.net", true },
  { "ipledgeonline.org", false },
  { "iplist.cc", true },
  { "iplog.info", false },
  { "ipmonitoring.hu", true },
  { "ipo-times.jp", true },
  { "ipoisk.com.ua", true },
  { "ipokabu.net", true },
  { "ipomue.com", false },
  { "ipop.gr", true },
  { "iposm.net", true },
  { "ippawards.com", false },
  { "ipplans.com", true },
  { "iprcenter.gov", true },
  { "ipresent.com", true },
  { "iprim.ru", true },
  { "ipripojeni.cz", true },
  { "iproducemusic.com", true },
  { "ips-consult.nl", true },
  { "ips-ihre-pflege-sachsen.de", true },
  { "ips-sachsen.de", true },
  { "ipschool.spb.ru", true },
  { "ipsecurelink.com", true },
  { "ipslsig.org", true },
  { "ipso.paris", true },
  { "ipstream.it", true },
  { "ipsum.dk", true },
  { "ipswitch.com.tw", true },
  { "iptvzoom.xyz", true },
  { "ipty.de", true },
  { "ipv4.cf", true },
  { "ipv4.co.il", true },
  { "ipv4.gr", true },
  { "ipv4.rip", true },
  { "ipv6-adresse.dk", true },
  { "ipv6-handbuch.de", true },
  { "ipv6.jetzt", true },
  { "ipv6alizer.se", true },
  { "ipv6vpn.net", true },
  { "ipvbook.com", true },
  { "iqboxy.com", true },
  { "iqsecurity.eu", true },
  { "iqskinclinics.com", true },
  { "iqsmn.org", true },
  { "ir1s.com", false },
  { "irajsingh.tk", true },
  { "iramellor.com", true },
  { "irandex.ga", true },
  { "iranfilmcity.tk", true },
  { "iranian.lgbt", true },
  { "iranianholiday.com", true },
  { "iranjeunesse.com", true },
  { "iranonline.tk", true },
  { "iranturkey.info", true },
  { "iranwiki.ovh", true },
  { "iraqinews.ga", true },
  { "irasandi.com", true },
  { "irayo.net", true },
  { "ircmett.de", true },
  { "ird.nz", true },
  { "ireaco.com", true },
  { "ireef.tv", true },
  { "ireland.gq", true },
  { "iren.ch", true },
  { "irenkuhn.ch", true },
  { "irequi.re", true },
  { "ireviewi.com", true },
  { "irf2.pl", true },
  { "irfan.id", true },
  { "irgendeine.cloud", true },
  { "irgit.pl", true },
  { "iridiumbrowser.de", true },
  { "irioka.be", true },
  { "iriomote.com", true },
  { "iris-design.info", true },
  { "iris-insa.com", true },
  { "irish.dating", true },
  { "irish.radio", true },
  { "irishradioplayer.radio", true },
  { "irishsessions.ch", true },
  { "irisjieun.com", true },
  { "irismq.fr", true },
  { "irkfap.com", true },
  { "irkutsk38.tk", true },
  { "irland-firma.com", true },
  { "irlfp.com", true },
  { "irmag.ru", true },
  { "irmgard-woelfle.de", true },
  { "irmgardkoch.com", true },
  { "irodorinet.com", true },
  { "iroise.ch", true },
  { "ironcarnival.com", true },
  { "ironfistdesign.com", true },
  { "ironfittings.com.br", true },
  { "ironhide.de", true },
  { "ironpeak.be", true },
  { "ironraven.ml", true },
  { "irose.am", true },
  { "irrewilse.se", true },
  { "irrigadorbucal.com", true },
  { "irritant.net", true },
  { "iruarts.ch", true },
  { "iruca.co", true },
  { "irvingramo.com", true },
  { "irxoo.com", true },
  { "iryodatumoguide.com", true },
  { "iryogakkai.jp", true },
  { "is-going-to-rickroll.me", true },
  { "is-in-hyper.space", true },
  { "is-rocket.science", true },
  { "is-socket.tk", true },
  { "isa357.com", true },
  { "isa5417.com", true },
  { "isaaccomputerscience.org", true },
  { "isaacdgoodman.com", false },
  { "isaackhor.com", true },
  { "isaacman.tech", true },
  { "isaacmorneau.com", true },
  { "isaacpartnership.co.uk", true },
  { "isaacphysics.org", true },
  { "isaaczais.com", true },
  { "isabelaflores.com", true },
  { "isabellavandijk.nl", true },
  { "isabelle-delpech.com", true },
  { "isabellehogarth.co.uk", true },
  { "isabelmurillo-ordonez.com", true },
  { "isakssons.com", true },
  { "isamay.es", true },
  { "isamiok.com", true },
  { "isaob.com", true },
  { "isara.com", true },
  { "isaropiping.fr", true },
  { "isavings.com", true },
  { "isayoga.de", true },
  { "isbaseballstillon.com", true },
  { "isbc-telecom.ru", true },
  { "isbengrumpy.com", true },
  { "iscert.org", true },
  { "isdn.jp", true },
  { "isecrets.se", true },
  { "iservicio.mx", true },
  { "isg-tech.com", true },
  { "isgp-studies.com", false },
  { "ishamf.com", true },
  { "ishet.al", true },
  { "ishigurodo.com", true },
  { "ishiharaken.com", true },
  { "ishimen.co.jp", true },
  { "ishland.com", true },
  { "ishome.org", true },
  { "ishtarfreya.com", true },
  { "isif-ostewg.org", true },
  { "isil.fi", true },
  { "isimonbrown.co.uk", true },
  { "isincheck.com", true },
  { "isiso.com.tr", true },
  { "isitchristmas.com", true },
  { "isitcoffeetime.com", true },
  { "isitdoneyet.gov", true },
  { "isitef.com", true },
  { "isitup.org", true },
  { "iskaron.de", true },
  { "iskaz.rs", true },
  { "iskogen.nu", true },
  { "islam.si", true },
  { "islamabadcourt.tk", true },
  { "islamicmarkets.com", true },
  { "islamicnews.tk", true },
  { "islamnewss.tk", true },
  { "islamonline.net", true },
  { "islandhosting.com", true },
  { "islandmapstore.com", true },
  { "islavolcan.cl", true },
  { "isletech.net", true },
  { "isliada.org", true },
  { "islief.com", true },
  { "islightdown.today", true },
  { "ismadgeintrouble.com", true },
  { "ismat.com", true },
  { "ismena.bg", true },
  { "ismywebsitepenalized.com", true },
  { "isn.cz", true },
  { "isocom.eu", true },
  { "isognattori.com", true },
  { "isolde.com", true },
  { "isolta.com", true },
  { "isolta.de", true },
  { "isolta.ee", true },
  { "isolta.fi", true },
  { "isolta.lv", true },
  { "isolta.se", true },
  { "isonet.fr", true },
  { "isopres.de", true },
  { "isotope.gov", true },
  { "isotopes.gov", true },
  { "isovideo.com", true },
  { "isowosi.com", true },
  { "ispfontela.es", true },
  { "ispmedipv6.se", true },
  { "ispringcloud.ru", true },
  { "israel-in-color.com", true },
  { "israelbiblicalstudies.com", true },
  { "israelbizreg.com", true },
  { "israelil-leumi.co.il", true },
  { "israelil-leumidev.azurewebsites.net", true },
  { "israelnewswire.tk", true },
  { "israelportalk.ml", true },
  { "isreedyinthe.uk", true },
  { "isreedyinthe.us", true },
  { "isreedyintheuk.com", true },
  { "issa.org.pl", false },
  { "issaias.net", true },
  { "issasfrissa.se", true },
  { "issforum.org", true },
  { "issio.net", true },
  { "issue.watch", true },
  { "issues.email", true },
  { "ist.cm", true },
  { "istanbul.systems", true },
  { "istdas.lol", true },
  { "istdieweltschonuntergegangen.de", true },
  { "isteinbaby.de", true },
  { "isterfaslur.com", true },
  { "istheapplestoredown.com", true },
  { "istheapplestoredown.de", true },
  { "isthedoorlocked.com", true },
  { "istheinternetdown.com", true },
  { "istheinternetonfire.com", true },
  { "isthephone.com", true },
  { "istheservicedown.co.uk", true },
  { "istheservicedown.com", true },
  { "istheservicedowncanada.com", true },
  { "isthnew.com", true },
  { "istitutoricci.it", true },
  { "istitutovivaldi.it", true },
  { "istogether.com", true },
  { "istormsolutions.co.uk", true },
  { "istorrent.is", true },
  { "istrazivac-istine.com", true },
  { "istschonsolangeinrente.de", true },
  { "istsi.org", true },
  { "isusemasa.com", false },
  { "isv.online", true },
  { "isvbscriptdead.com", true },
  { "isvsecwatch.org", true },
  { "isz.no", true },
  { "iszy.cc", true },
  { "it-academy.sk", true },
  { "it-boss.ro", true },
  { "it-faul.de", true },
  { "it-fernau.com", true },
  { "it-inside.ch", true },
  { "it-jobbank.dk", true },
  { "it-journal.de", true },
  { "it-kron.de", true },
  { "it-maker.eu", true },
  { "it-meneer.nl", true },
  { "it-rotter.de", true },
  { "it-schamans.de", true },
  { "it-service24.at", true },
  { "it-service24.ch", true },
  { "it-service24.com", true },
  { "it-shamans.de", true },
  { "it-shamans.eu", true },
  { "it-stack.de", true },
  { "it-support-nu.se", true },
  { "it-support-stockholm.se", true },
  { "it-support.one", true },
  { "it-supportistockholm.se", true },
  { "it-supportnu.se", true },
  { "it-swarm.net", true },
  { "it-tekniker.nu", true },
  { "it-ti.me", true },
  { "it-uws.com", false },
  { "it-zt.at", true },
  { "it.search.yahoo.com", false },
  { "it1b.com", true },
  { "it4sure.nl", true },
  { "itactiq.com", true },
  { "itaiferber.net", true },
  { "italbavaro.com", true },
  { "italia-store.com", true },
  { "italiachegioca.com", true },
  { "italian.dating", true },
  { "italianshoemanufacturers.com", true },
  { "italiansrent.com", true },
  { "italiataxi.ru", true },
  { "italiatopnews.tk", true },
  { "italieflydrive.nl", true },
  { "italiensk-tolk.dk", true },
  { "italik.co.uk", true },
  { "italserrande.it", true },
  { "italserver.com", true },
  { "italyinspires.com", true },
  { "itamservices.nl", true },
  { "itap.gov", true },
  { "itaporanga.se.gov.br", true },
  { "itb-online.co.uk", true },
  { "itbox.cl", true },
  { "itcbuerobedarf.de", true },
  { "itchy.nl", true },
  { "itchybrainscentral.com", true },
  { "itconsulting-wolfinger.de", true },
  { "itcs.services", true },
  { "itdashboard.gov", true },
  { "itdata.ro", false },
  { "itdutchie.com", true },
  { "itecor.net", false },
  { "iteecafe.hu", true },
  { "iteha.de", true },
  { "iteli.eu", true },
  { "itemcreator.tk", true },
  { "itemorder.com", true },
  { "itemstore.ir", true },
  { "iterader.com", true },
  { "iternalnetworks.com", true },
  { "iterror.co", true },
  { "itesign.de", true },
  { "itezu.ml", true },
  { "itfh.eu", true },
  { "itfix.cz", true },
  { "itgoesup.com", true },
  { "itgoesupent.com", true },
  { "itgoesupentertainment.com", true },
  { "ithakama.com", true },
  { "ithakama.cz", true },
  { "ithedgehog.co.uk", true },
  { "ithenrik.com", true },
  { "ithinc.net", true },
  { "ithink.cf", true },
  { "ithink.ml", true },
  { "ithjalpforetag.se", true },
  { "ithot.ro", true },
  { "itikon.com", true },
  { "itilo.de", true },
  { "itis.gov", true },
  { "itis4u.ch", true },
  { "itisyourmoney.co.uk", true },
  { "itkaufmann.at", true },
  { "itkonsultstockholm.se", true },
  { "itludens.com", true },
  { "itm-c.de", true },
  { "itmindscape.com", true },
  { "itmustbee.com", true },
  { "itmx.cc", true },
  { "itn.co.uk", true },
  { "itneeds.tech", true },
  { "itnota.com", true },
  { "itnow.ng", true },
  { "itochan.jp", true },
  { "itooky.com", true },
  { "itpanda.pl", true },
  { "itpro.ua", true },
  { "itraffic.tk", true },
  { "itraveille.fr", true },
  { "itreallyaddsup.com", true },
  { "itring.pl", false },
  { "itruss.com.tw", true },
  { "its-gutachten.de", true },
  { "its.gov", true },
  { "its420somewhere.com", true },
  { "its4living.com", true },
  { "itsabouncything.com", true },
  { "itsallaboutplumbing.com", true },
  { "itsallsotireso.me", true },
  { "itsaw.de", true },
  { "itsayardlife.com", true },
  { "itsblue.de", true },
  { "itsburning.nl", true },
  { "itschromeos.com", true },
  { "itsdcdn.com", true },
  { "itsecblog.de", true },
  { "itsecguy.com", true },
  { "itseeze.com", true },
  { "itsevident.com", true },
  { "itsfitlab.com", true },
  { "itsgoingdown.org", false },
  { "itshka.rv.ua", true },
  { "itsig-faq.de", true },
  { "itsmyparty.ie", true },
  { "itsnotquitethehilton.com", false },
  { "itsok.de", true },
  { "itsok.link", true },
  { "itspartytimeonline.co.uk", true },
  { "itspersonaltraining.nl", true },
  { "itsquiet.org", true },
  { "itsryan.com", true },
  { "itsstefan.eu", true },
  { "itstatic.tech", true },
  { "itsuitsyou.co.za", true },
  { "itsuki.nl", true },
  { "itsundef.in", true },
  { "itsupportnacka.se", true },
  { "itsv.at", true },
  { "itswincer.com", true },
  { "itsynergy.co.uk", true },
  { "ittgame.tk", true },
  { "itvaatlik.ee", true },
  { "itzap.com.au", true },
  { "itzer.de", true },
  { "itzkavin.tk", true },
  { "iubuniversity.tk", true },
  { "iurisnow.com", true },
  { "iuyos.com", true },
  { "ivact.co.jp", true },
  { "ivahbbiz.tk", true },
  { "ivais.mx", true },
  { "ivanaleksandrov.com", true },
  { "ivanbenito.com", true },
  { "ivanboi.com", true },
  { "ivancacic.com", false },
  { "ivanderevianko.com", true },
  { "ivanmeade.com", true },
  { "ivanovolive.ru", true },
  { "ivaoru.org", true },
  { "ivendi.com", true },
  { "ivetazivot.cz", true },
  { "ivfausland.de", true },
  { "ivfmeds.com", true },
  { "ivig.com.br", true },
  { "ivisitorinsurance.com", true },
  { "ivo.co.za", true },
  { "ivocopro.com", true },
  { "ivocotec.de", true },
  { "ivoid.cf", true },
  { "ivopetkov.com", true },
  { "ivor.io", true },
  { "ivor.is", true },
  { "ivorvanhese.com", true },
  { "ivorvanhese.nl", true },
  { "ivoryandgrace.com", true },
  { "ivpn.net", true },
  { "ivre.rocks", true },
  { "ivsign.net", true },
  { "ivusn.cz", true },
  { "ivvl.ru", true },
  { "ivy-league-colleges.com", true },
  { "iwader.co.uk", true },
  { "iwalton.com", true },
  { "iwanttoliveinabunker.com", true },
  { "iwanttrack.com", true },
  { "iwascoding.com", true },
  { "iwascoding.de", true },
  { "iwashealthy.com", true },
  { "iwatchcops.com", true },
  { "iwatchcops.org", true },
  { "iwatt.sk", true },
  { "iwch.tk", true },
  { "iwd.gc.ca", true },
  { "iwebolutions.com", true },
  { "iwell.de", true },
  { "iwizerunek.pl", true },
  { "iww.me", true },
  { "ixanis.net", true },
  { "ixds.org", true },
  { "ixio.cz", true },
  { "ixit.cz", true },
  { "ixix.org", true },
  { "ixquick-proxy.com", true },
  { "ixquick.co.uk", true },
  { "ixquick.com", true },
  { "ixquick.de", true },
  { "ixquick.eu", true },
  { "ixquick.fr", true },
  { "ixquick.info", true },
  { "ixquick.nl", true },
  { "iyassu.com", true },
  { "iyc.web.tr", true },
  { "iycharter.com", true },
  { "iyouewo.com", true },
  { "iz8mbw.net", true },
  { "izamulhakeem.tk", true },
  { "izevg.ru", true },
  { "izmirescort.tk", true },
  { "izntz.com", true },
  { "izodiacsigns.com", true },
  { "izolpoznan.pl", true },
  { "izs8.com", false },
  { "izt.tech", false },
  { "izttech.com", true },
  { "izuba.info", false },
  { "izumi-ryokan.com", true },
  { "izumi.tv", true },
  { "izxxs.com", true },
  { "izxxs.net", true },
  { "izxzw.net", true },
  { "izzys.casa", true },
  { "j-elliott.co.uk", true },
  { "j-k-fischer-verlag.de", true },
  { "j-l.pw", true },
  { "j-navi.com", true },
  { "j-ph.ovh", true },
  { "j-robertson.com", true },
  { "j-softlab.com", true },
  { "j0bs.org", true },
  { "j0e.com", true },
  { "j0hndball.com", true },
  { "j0rj.com", true },
  { "j0s.at", true },
  { "j0s.eu", true },
  { "j15h.nu", true },
  { "j1879.com", true },
  { "j1visahealthinsurance.com", true },
  { "j2h.de", true },
  { "j32663.com", true },
  { "j32664.com", true },
  { "j32665.com", true },
  { "j32771.com", true },
  { "j32772.com", true },
  { "j32773.com", true },
  { "j32774.com", true },
  { "j32775.com", true },
  { "j3349.com", true },
  { "j36533.com", true },
  { "j36594.com", true },
  { "j3e.de", true },
  { "j51365.com", true },
  { "j5563.com", true },
  { "j5573.com", true },
  { "j5lx.de", true },
  { "j5lx.eu", true },
  { "j5lx.io", true },
  { "j605.tk", true },
  { "j81818.com", true },
  { "j8846.com", true },
  { "j9504.com", true },
  { "j9507.com", true },
  { "j9508.com", true },
  { "j9511.com", true },
  { "j9514.com", true },
  { "j9515.com", true },
  { "j9516.com", true },
  { "j95app.com", true },
  { "j95cc.com", true },
  { "j95dd.com", true },
  { "j95ee.com", true },
  { "j95ios.com", true },
  { "j95ss.com", true },
  { "j95xx.com", true },
  { "j95zz.com", true },
  { "j9943.com", true },
  { "ja-gps.com.au", true },
  { "ja-hypnose.de", true },
  { "ja-no-me.ru", true },
  { "ja-publications.agency", true },
  { "ja-zur-gs.de", true },
  { "jaakkohannikainen.fi", true },
  { "jaalits.com", true },
  { "jaamaa.com", true },
  { "jaarvistech.com", true },
  { "jaba.hosting", true },
  { "jababu.cz", true },
  { "jabbari.io", true },
  { "jabber.at", true },
  { "jabber.uk", true },
  { "jabberd.org", true },
  { "jabberfr.org", true },
  { "jabbers.one", true },
  { "jabberzac.org", true },
  { "jaberg-rutschi.ch", true },
  { "jabergrutschi.ch", true },
  { "jabjab.de", true },
  { "jacarandafinance.com.au", true },
  { "jaccblog.com", true },
  { "jacekowski.org", true },
  { "jacik.cz", true },
  { "jack-p2.tech", true },
  { "jack2celebrities.com", true },
  { "jackassofalltrades.org", true },
  { "jackdawphoto.co.uk", true },
  { "jackf.me", true },
  { "jackflet.ch", true },
  { "jackgreenrealty.com", false },
  { "jackhoodtransportation.com", true },
  { "jackingsolutions.com", true },
  { "jackpothappy.com", true },
  { "jackrussel.tk", true },
  { "jacksanalytics.com", true },
  { "jacksball.com", true },
  { "jackson-quon.com", true },
  { "jackson.jp", true },
  { "jacksonhu.com", true },
  { "jacksonvillestation.com", true },
  { "jacksorrell.com", true },
  { "jackspub.net", true },
  { "jackwozny.com", true },
  { "jackyliao.me", true },
  { "jackyliao123.tk", true },
  { "jacobamunch.com", true },
  { "jacobi-server.de", true },
  { "jacobian.org", true },
  { "jacobjangles.com", true },
  { "jacobs-implantate.at", true },
  { "jacobsenarquitetura.com", true },
  { "jacquesdedixmude.eu", true },
  { "jacuzziprozone.com", true },
  { "jadchaar.me", true },
  { "jadehotel.nl", true },
  { "jadesong.net", true },
  { "jadopado.com", true },
  { "jaegerlacke.de", true },
  { "jaepinformatica.com", true },
  { "jaetech.org", true },
  { "jagbouncycastles.co.uk", true },
  { "jagerman.com", true },
  { "jagido.de", true },
  { "jaguarlandrover-asse.be", false },
  { "jaguarlandrover-occasions.be", false },
  { "jahanaisamu.com", true },
  { "jahner.xyz", true },
  { "jahofmann.de", false },
  { "jaiestate.com", true },
  { "jailbreakingisnotacrime.org", true },
  { "jailfood.ga", true },
  { "jaimesotelo.com", true },
  { "jaingynecology.com", true },
  { "jairbehr.com.br", true },
  { "jaisiam.co.th", true },
  { "jaispirit.com", true },
  { "jaitnetworking.com", false },
  { "jaja.wtf", true },
  { "jajsemjachym.cz", true },
  { "jak-na-les.cz", true },
  { "jakarta.dating", true },
  { "jakdelatseo.cz", true },
  { "jake.eu.org", true },
  { "jake.ml", true },
  { "jake.nom.za", true },
  { "jakecurtis.de", true },
  { "jakereynolds.co", true },
  { "jakerullman.com", true },
  { "jakeslab.tech", true },
  { "jaketremper.com", true },
  { "jakewalker.xyz", false },
  { "jakewestrip.com", true },
  { "jakob-server.tk", true },
  { "jakobejitblokaci.cz", true },
  { "jakobkrigovsky.com", true },
  { "jakobssystems.net", true },
  { "jakpremyslet.cz", true },
  { "jaksch.biz", true },
  { "jakse.fr", true },
  { "jakub-boucek.cz", true },
  { "jakubboucek.cz", true },
  { "jakubklimek.com", true },
  { "jakubsindelar.cz", true },
  { "jakubtopic.cz", true },
  { "jakubvrba.cz", true },
  { "jala.co.jp", true },
  { "jaleo.cn", true },
  { "jaluzelemoderne.ro", true },
  { "jamaat.hk", true },
  { "jamalfi.bio", true },
  { "james-bell.co.uk", true },
  { "james-loewen.com", true },
  { "jamesachambers.com", true },
  { "jamesaimonetti.com", true },
  { "jamesbillingham.com", true },
  { "jameschorlton.co.uk", true },
  { "jamesdorf.com", true },
  { "jamesedition.com", true },
  { "jamesgreenfield.com", true },
  { "jameshemmings.co.uk", true },
  { "jameshost.net", true },
  { "jameshunt.us", false },
  { "jamesj.me", false },
  { "jamesjboyer.com", true },
  { "jamesmarsh.net", true },
  { "jamesmilazzo.com", true },
  { "jamesrobertson.net", true },
  { "jamesrobertson.sh", true },
  { "jamesross.name", true },
  { "jamessmith.me.uk", true },
  { "jamestmartin.me", true },
  { "jamestown.de", true },
  { "jamesturnerstickley.com", true },
  { "jamesusandra.com", true },
  { "jameswarp.com", true },
  { "jamhost.org", true },
  { "jamie-read-photography.com", true },
  { "jamie.ie", true },
  { "jamielarter.ca", true },
  { "jamielinux.com", true },
  { "jamiemagee.co.uk", true },
  { "jamiemagee.dk", true },
  { "jamieweb.net", true },
  { "jamieweb.org", true },
  { "jamiewebb.net", true },
  { "jammucake.com", true },
  { "jammysplodgers.co.uk", true },
  { "jamon.ca", true },
  { "jamonsilva.com", true },
  { "jamstatic.fr", true },
  { "jan-and-maaret.de", true },
  { "jan-bucher.ch", true },
  { "jan-gerd.com", true },
  { "jan-hill.com", true },
  { "jan-reiss.de", true },
  { "jan-roenspies.de", true },
  { "jan-von.de", true },
  { "jan.gl", true },
  { "janaundgeorgsagenja.eu", true },
  { "janbrodda.de", true },
  { "jandev.de", true },
  { "jane.com", true },
  { "janehamelgardendesign.co.uk", true },
  { "janelauhomes.com", true },
  { "janelle-jamer.tk", true },
  { "janellequintana.tk", true },
  { "janeymac.com", true },
  { "jangl.com", true },
  { "janhermann.cz", true },
  { "janhuelsmann.com", true },
  { "jani.media", true },
  { "janiat.com", true },
  { "janik.xyz", false },
  { "janikrabe.com", true },
  { "janjoris.nl", true },
  { "jankamp.com", true },
  { "janker.me", true },
  { "jann.is", true },
  { "jannekekaasjager.nl", true },
  { "jannisfink.de", true },
  { "jannyrijneveld.nl", true },
  { "janokacer.sk", true },
  { "janome.club", true },
  { "janostheil.de", true },
  { "janschaumann.de", true },
  { "janterpstra.eu", true },
  { "jantinaboelens.nl", true },
  { "janvari.com", true },
  { "janvaribalint.com", true },
  { "jaot.info", true },
  { "japanese-cuisine.com", true },
  { "japanesemotorsports.net", true },
  { "japangids.nl", true },
  { "japaniac.de", false },
  { "japanphilosophy.com", false },
  { "japansm.com", true },
  { "japantravel.tk", true },
  { "japanwatches.xyz", true },
  { "japonyol.net", true },
  { "jaramilloconstrucciones.pe", true },
  { "jardineriaon.com", true },
  { "jaredfernandez.com", true },
  { "jarmala.lt", true },
  { "jarmandental.com", true },
  { "jarmatys.pl", true },
  { "jarniashop.se", true },
  { "jaroku.com", true },
  { "jarondl.net", true },
  { "jarrah-alsilawi.com", true },
  { "jarrettgraham.com", true },
  { "jarroba.com", true },
  { "jas-team.net", true },
  { "jashvaidya.com", true },
  { "jasmijnwagenaar.nl", true },
  { "jasminlive.cam", true },
  { "jasnowidzkajowi.pl", true },
  { "jasonamorrow.com", true },
  { "jasongerber.ch", false },
  { "jasonmili.online", true },
  { "jasonsplecoscichlids.com", true },
  { "jasonwei.nctu.me", true },
  { "jasper.link", true },
  { "jasperhammink.com", true },
  { "jasperhuttenmedia.com", true },
  { "jasperpatterson.me", true },
  { "jaspersreef.com", true },
  { "jastrow.me", true },
  { "jaszbereny-vechta.eu", true },
  { "javaexpert.tk", true },
  { "javamilk.com", true },
  { "javanguiano.mx", true },
  { "javaweb.site", true },
  { "javelin.cc", true },
  { "javfree.me", true },
  { "javhdmovies.com", true },
  { "javierburgos.net", true },
  { "javierlorente.es", true },
  { "javiermascherano.tk", true },
  { "javik.net", true },
  { "javiscoffee.com", true },
  { "jawo2008.pl", true },
  { "jaxfstk.com", true },
  { "jaxxnet.co.uk", true },
  { "jaxxnet.org", true },
  { "jaybrokers.com", true },
  { "jayden.tech", true },
  { "jayf.de", true },
  { "jayfreestone.com", false },
  { "jayharkess.uk", true },
  { "jaylineko.com", true },
  { "jaymecd.rocks", true },
  { "jayrl.com", true },
  { "jaysaw.me", true },
  { "jaytx.com", true },
  { "jayxon.com", true },
  { "jayxu.com", true },
  { "jazminguaramato.com", true },
  { "jazz-alliance.com", true },
  { "jazz-alliance.org", true },
  { "jazzanet.com", true },
  { "jazzncheese.com", true },
  { "jazzy-feet.com", true },
  { "jazzy.id.au", true },
  { "jazzy.pro", true },
  { "jazzysumi.com", true },
  { "jb138.cc", true },
  { "jbbd.fr", true },
  { "jbc88.cc", true },
  { "jblackweb.com", true },
  { "jbradaric.me", true },
  { "jbridal.com.au", true },
  { "jbs-jardins.ch", false },
  { "jbsinternational.com", true },
  { "jcadg.com", true },
  { "jcai.dk", true },
  { "jcaicedo.com", true },
  { "jcb.com", true },
  { "jcbgolfandcountryclub.com", true },
  { "jccrew.org", true },
  { "jci.cc", true },
  { "jclynne.com", true },
  { "jcontspoord.nl", true },
  { "jcsdevelopment.com", false },
  { "jcsesecuneta.com", true },
  { "jctf.team", true },
  { "jcus.co", true },
  { "jcwodan.nl", true },
  { "jd1.de", true },
  { "jdassets.com", true },
  { "jdc.io", true },
  { "jdd888.cc", true },
  { "jdefreitas.com", true },
  { "jdegbau.com", true },
  { "jdheysupplies.co.uk", true },
  { "jdjohnsonmedia.com", true },
  { "jdjohnsonwaterproofing.com", true },
  { "jdm.elk.pl", true },
  { "jdm.pl", true },
  { "jdmgarage.com.au", true },
  { "jdncr.com", true },
  { "jdoi.pw", true },
  { "jdpleisure.co.uk", true },
  { "jdproofing.com", true },
  { "jdscastlehire.co.uk", true },
  { "jdtic.com", true },
  { "je-vends.fr", false },
  { "je2050.de", true },
  { "jean-luc.org", true },
  { "jeancardeno.com", true },
  { "jeandanielfaessler.ch", true },
  { "jeankygourmet.com", true },
  { "jeanmarieayer.ch", true },
  { "jeannecalment.com", true },
  { "jeannelucienne.fr", true },
  { "jeanneret-combustibles.ch", false },
  { "jeans-shopping.tk", true },
  { "jeansdiscounter.de", true },
  { "jebengotai.com", true },
  { "jec-dekrone.be", true },
  { "jecho.cn", true },
  { "jecjacshop.com", true },
  { "jeda.ch", true },
  { "jedayoshi.com", true },
  { "jedepannetonordi.fr", true },
  { "jedipedia.net", true },
  { "jediweb.com.au", true },
  { "jedmud.com", true },
  { "jedwarddurrett.com", true },
  { "jeec.ist", true },
  { "jeepeg.com", true },
  { "jeeran.com", true },
  { "jeeranservices.com", true },
  { "jeff.forsale", true },
  { "jeffcloninger.net", true },
  { "jeffersonregan.co.uk", true },
  { "jeffersonregan.com", true },
  { "jeffersonregan.net", true },
  { "jeffhaferman.com", true },
  { "jeffmcneill.com", true },
  { "jeffreyhaferman.com", true },
  { "jeffri.me", true },
  { "jeffsanders.com", true },
  { "jefftickle.com", true },
  { "jeffwebb.com", true },
  { "jefrydco.id", true },
  { "jefsweden.eu", true },
  { "jehelpdesk.nl", true },
  { "jej.cz", true },
  { "jej.sk", true },
  { "jekhar.com", true },
  { "jelena-adeli.com", true },
  { "jelenkovic.rs", true },
  { "jell.ie", true },
  { "jelle.pro", true },
  { "jelleluteijn.com", true },
  { "jelleluteijn.eu", true },
  { "jelleluteijn.net", true },
  { "jelleluteijn.nl", true },
  { "jelleluteijn.pro", true },
  { "jelleraaijmakers.nl", true },
  { "jelly.cz", true },
  { "jellybeanbooks.com.au", true },
  { "jellyfloral.com", true },
  { "jellysquid.me", true },
  { "jelmer.uk", true },
  { "jelmoli-shop.ch", true },
  { "jem.gov", true },
  { "jemangeducheval.com", true },
  { "jembatankarir.com", true },
  { "jemefaisdesamis.com", true },
  { "jennethaarfotografie.nl", true },
  { "jennierobinson.com", true },
  { "jenniferengerwingaantrouwen.nl", true },
  { "jennifersauer.nl", true },
  { "jenniwiltz.com", true },
  { "jennysarl.ch", true },
  { "jennythebaker.com", true },
  { "jenolson.net", true },
  { "jenprace.cz", true },
  { "jensdesmeyter.be", true },
  { "jenslody.de", true },
  { "jensrex.dk", true },
  { "jeproteste.info", true },
  { "jeps.fi", true },
  { "jeremiahbenes.com", true },
  { "jeremy.hu", true },
  { "jeremybentham.com", true },
  { "jeremybloomfield.co.uk", true },
  { "jeremyc.ca", false },
  { "jeremycantu.com", true },
  { "jeremycrews.com", true },
  { "jeremynally.com", true },
  { "jeremyness.com", true },
  { "jeremypaul.me", true },
  { "jeremytcd.com", true },
  { "jericamacmillan.com", true },
  { "jering.tech", true },
  { "jerisandoval.tk", true },
  { "jermann.biz", true },
  { "jeroendeneef.com", true },
  { "jerome.to", true },
  { "jerret.de", true },
  { "jerrysretailstores.com", true },
  { "jerrywang.website", true },
  { "jerryweb.org", true },
  { "jerryyu.ca", true },
  { "jerseybikehire.co.uk", true },
  { "jerseyink.net", true },
  { "jerseyjumpingbeans.co.uk", true },
  { "jerseylvi2013.org", true },
  { "jerseyplantsdirect.com", true },
  { "jerusalempersonals.ml", true },
  { "jes.events", true },
  { "jesec.io", true },
  { "jesiensredniowiecza.pl", true },
  { "jesse3.com", true },
  { "jesseerbach.com", true },
  { "jessekaufman.com", true },
  { "jessem.fr", true },
  { "jesseonline.tk", true },
  { "jessesjumpingcastles.co.uk", true },
  { "jessgranger.com", true },
  { "jessicabenedictus.nl", false },
  { "jessicahrehor.com", true },
  { "jesters-court.net", true },
  { "jesuisadmin.fr", true },
  { "jesuisunpapageek.fr", true },
  { "jesusthegoodshepherd.org", true },
  { "jesusvasquez.tk", true },
  { "jesusvazquez.online", true },
  { "jet-stream.fr", true },
  { "jetbbs.com", true },
  { "jetfirenetworks.com", true },
  { "jetflex.de", true },
  { "jetkittens.co.uk", true },
  { "jetses.be", true },
  { "jetsetboyz.net", true },
  { "jetsieswerda.nl", true },
  { "jetswhiteout.com", true },
  { "jettlarue.com", true },
  { "jettshome.org", true },
  { "jetwhiz.com", true },
  { "jeurissen.co", true },
  { "jeuxerotiques.net", true },
  { "jeuxetcodes.fr", true },
  { "jewadvert.ml", true },
  { "jeweet.net", true },
  { "jewishboyscouts.com", true },
  { "jewishquotations.com", true },
  { "jezeravillage.com", true },
  { "jezibaba.info", true },
  { "jf886.cc", true },
  { "jfbst.net", true },
  { "jfgselbitztal.tk", true },
  { "jfr.im", true },
  { "jfreitag.de", false },
  { "jftw.org", true },
  { "jg-skid.me", true },
  { "jgid.de", true },
  { "jgke.fi", true },
  { "jgoguen.ca", true },
  { "jgoldgroup.com", true },
  { "jgonzalezm.com", true },
  { "jgregory.co.uk", true },
  { "jgwb.de", true },
  { "jgwb.eu", true },
  { "jhalderm.com", true },
  { "jhaveri.net", true },
  { "jhe.li", true },
  { "jhill.de", true },
  { "jhollandtranslations.com", true },
  { "jhuang.me", true },
  { "jhw3d.com", true },
  { "jhwestover.com", true },
  { "ji0vwl.net", true },
  { "jiahao.codes", true },
  { "jiangxu.site", true },
  { "jianji.de", true },
  { "jianny.me", true },
  { "jianshu.com", true },
  { "jianwei.wang", true },
  { "jianyuan.art", true },
  { "jiayi.eu.org", true },
  { "jiayi.life", true },
  { "jicaivvip.com", true },
  { "jichi.io", true },
  { "jichi000.win", true },
  { "jif.gc.ca", true },
  { "jigsawplanet.com", true },
  { "jiji.co.ke", true },
  { "jiji.co.tz", true },
  { "jiji.com.gh", true },
  { "jiji.ke", true },
  { "jiji.ng", true },
  { "jiji.ug", true },
  { "jijistatic.com", true },
  { "jimbraaten.com", true },
  { "jimbutlerkiaparts.com", true },
  { "jimdorf.com", true },
  { "jime-hlavou.cz", true },
  { "jimeaton.com", true },
  { "jimfranke.com", true },
  { "jimfranke.nl", true },
  { "jimmiestore.com", true },
  { "jimmycai.com", true },
  { "jimmycarterlibrary.gov", true },
  { "jimmyroura.ch", false },
  { "jimshaver.net", true },
  { "jimslop.nl", true },
  { "jinbijin.nl", true },
  { "jinbo123.com", false },
  { "jinbowiki.org", true },
  { "jinduoduo369.com", true },
  { "jinduoduo666.com", true },
  { "jinduoduo888.com", true },
  { "jing.su", true },
  { "jingbo.fan", true },
  { "jingjo.com.au", true },
  { "jingyunbank.com", true },
  { "jinja.ai", true },
  { "jinkuru.net", true },
  { "jino-jossy.appspot.com", true },
  { "jino.gq", true },
  { "jinshuju.net", true },
  { "jiogo.com", true },
  { "jirav.com", true },
  { "jiretvariedades.com", true },
  { "jiripudil.cz", true },
  { "jisai.net.cn", true },
  { "jisha.site", true },
  { "jitterbit.com", true },
  { "jittruckparts.com", true },
  { "jix.im", true },
  { "jixun.moe", true },
  { "jjhampton.com", true },
  { "jjj.blog", true },
  { "jjrstudio.com", true },
  { "jjspartyhire.co.uk", true },
  { "jjvanoorschot.nl", true },
  { "jk-entertainment.biz", true },
  { "jkchocolate.com", true },
  { "jkdhn.me", true },
  { "jkg.tw", true },
  { "jki.io", true },
  { "jkinteriorspa.com", true },
  { "jkland.com", true },
  { "jkrippen.com", true },
  { "jkvov.com", true },
  { "jldp.org", true },
  { "jlink.nl", true },
  { "jlkhosting.com", true },
  { "jloh.codes", true },
  { "jlponsetto.com", true },
  { "jlr-luxembourg.com", false },
  { "jltcsecuritygroup.com", true },
  { "jltctech.com", true },
  { "jm-bea.net", true },
  { "jmarciniak.it", true },
  { "jmbeautystudio.se", true },
  { "jmbelloteau.com", true },
  { "jmbmexico.com", true },
  { "jmcataffo.com", true },
  { "jmce.eu", true },
  { "jmcleaning.services", true },
  { "jmdiesel.com", true },
  { "jmedved.com", true },
  { "jmentertainment.co.uk", true },
  { "jmfjltd.com", true },
  { "jmk.hu", true },
  { "jmkrecords.fr", true },
  { "jmlogistica.com", true },
  { "jmorahan.net", true },
  { "jmpb.hu", true },
  { "jmsjms.org", true },
  { "jmsjms.top", true },
  { "jmsjms.xyz", true },
  { "jmsolodesigns.com", true },
  { "jmssg.jp", true },
  { "jnjdj.com", true },
  { "jnm-art.com", true },
  { "jnordell.com", true },
  { "jnsz.hu", true },
  { "joa-ebert.com", true },
  { "joanofarcmtcarmel.org", true },
  { "joaoaugusto.net", false },
  { "joaobautista.com", true },
  { "joaojunior.com", true },
  { "joaopenteado.com", true },
  { "joaosampaio.com.br", true },
  { "job-ofertas.info", true },
  { "job.biz.tr", true },
  { "jobalicious.nl", true },
  { "jobatus.com.br", true },
  { "jobatus.es", true },
  { "jobatus.it", true },
  { "jobatus.mx", true },
  { "jobatus.pt", true },
  { "jobbidag.se", true },
  { "jobbkk.com", true },
  { "jobbsafari.no", true },
  { "jobbsafari.se", true },
  { "jobcorpsy2y.com", true },
  { "jobfury.com", true },
  { "jobify.in", true },
  { "jobindex.dk", true },
  { "jobit.gr", true },
  { "joblab.com.ua", false },
  { "joblife.co.za", true },
  { "jobmi.com", true },
  { "jobmiplayground.com", true },
  { "jobs.at", true },
  { "jobs.ch", true },
  { "jobs.su", true },
  { "jobs4sales.ch", true },
  { "jobsarkari.com", false },
  { "jobseekeritalia.it", true },
  { "jobsindemedia.nl", true },
  { "jobsisbrown.com", true },
  { "jobsnet.eu", true },
  { "jobsuchmaschine.ch", true },
  { "jobtarget.com", true },
  { "jobty.net", true },
  { "jobwinner.ch", true },
  { "jobzninja.com", true },
  { "jockbusuttil.co.uk", true },
  { "jockbusuttil.com", true },
  { "jockbusuttil.uk", true },
  { "jodaniels.photography", true },
  { "jodbush.com", true },
  { "jodlajodla.si", true },
  { "joduska.me", true },
  { "jodyboucher.com", false },
  { "jodyshop.com", true },
  { "joe262.com", true },
  { "joebiden.com", true },
  { "joebobbriggs.net", true },
  { "joedavison.me", true },
  { "joedeblasio.com", true },
  { "joedinardo.com", true },
  { "joedoyle.us", true },
  { "joefixit.co", true },
  { "joehenry.co.uk", true },
  { "joejacobs.me", true },
  { "joel.coffee", true },
  { "joeldrapper.com", true },
  { "joelfries.com", true },
  { "joelj.org", true },
  { "joelle.me", true },
  { "joelleandpeter.co.uk", true },
  { "joellimberg.com", true },
  { "joellombardo.com", false },
  { "joelmarkhamphotography.com.au", true },
  { "joelmunch.com", true },
  { "joelnichols.uk", true },
  { "joelotu.com", true },
  { "joelving.dk", true },
  { "joepitt.co.uk", false },
  { "joergschneider.com", true },
  { "joernwendland.de", true },
  { "joerosca.com", true },
  { "joerss.at", true },
  { "joeskup.com", true },
  { "joespaintingpgh.com", true },
  { "joestead.codes", false },
  { "joetsutj.com", true },
  { "joetyson.me", true },
  { "joeyfelix.com", true },
  { "joeygitalian.com", true },
  { "joeyhoer.com", true },
  { "joeysmith.com", true },
  { "joeyvanvenrooij.nl", true },
  { "jogjacar.com", true },
  { "jogwitz.de", true },
  { "johan-koffeman.tk", true },
  { "johanli.com", true },
  { "johannes-bauer.com", true },
  { "johannes-sprink.de", false },
  { "johannes-zinke.de", true },
  { "johannes.io", true },
  { "johannes.wtf", true },
  { "johannesen.tv", true },
  { "johannfritsche.de", true },
  { "johanpeeters.com", true },
  { "johansf.tech", true },
  { "johego.org", true },
  { "johnaltamura.com", true },
  { "johnball.co", true },
  { "johnbeil.com", true },
  { "johnberan.com", true },
  { "johnblackbourn.com", true },
  { "johnbpodcast.com", true },
  { "johncam.tk", true },
  { "johncook.ltd.uk", true },
  { "johndball.co", true },
  { "johndball.com", true },
  { "johndball.info", true },
  { "johndball.net", true },
  { "johndball.org", true },
  { "johndeisher.com", true },
  { "johnfulgenzi.com", true },
  { "johngallias.com", true },
  { "johngmchenrymd.com", true },
  { "johnguant.com", true },
  { "johnhancocknypensions.com", true },
  { "johnhancockpensions.com", true },
  { "johnhgaunt.com", true },
  { "johnkastler.net", true },
  { "johnkraal.com", true },
  { "johnmcintosh.pro", true },
  { "johnmh.me", true },
  { "johnmichel.org", true },
  { "johnnybet.com", true },
  { "johnnybsecure.com", true },
  { "johnpenny.info", true },
  { "johnpenny.uk", true },
  { "johnroach.io", true },
  { "johnroberts.me", true },
  { "johnrockefeller.net", true },
  { "johnrosewicz.com", true },
  { "johnsanchez.io", true },
  { "johnsegovia.com", true },
  { "johnsongenealogy.net", true },
  { "johnvanhese.nl", true },
  { "johnyytb.be", true },
  { "joi-dhl.ch", false },
  { "joinhonor.com", true },
  { "jointotem.com", true },
  { "joinus-outfits.nl", true },
  { "jokedalderup.nl", true },
  { "jokequebec.com", true },
  { "jokesbykids.com", true },
  { "jokewignand.nl", true },
  { "jolee.ro", true },
  { "jolfamarket.com", true },
  { "joliettech.com", true },
  { "jolinebrussel.nl", true },
  { "joljeugdstad.nl", true },
  { "jollausers.de", true },
  { "jolle.io", true },
  { "jollykidswobbleworld.co.uk", true },
  { "jolo.software", true },
  { "jolokia.ch", true },
  { "jomagus.de", true },
  { "jomo.tv", true },
  { "jomsolat.tk", true },
  { "jonahperez.com", true },
  { "jonale.net", true },
  { "jonas-thelemann.de", true },
  { "jonas.me", true },
  { "jonaskarlssonfoto.se", true },
  { "jonaskjodt.com", true },
  { "jonasled.de", true },
  { "jonaswitmer.ch", true },
  { "jonathancarter.org", true },
  { "jonathandupree.com", true },
  { "jonathanha.as", true },
  { "jonathanlara.com", true },
  { "jonathanphoto.fr", true },
  { "jonathanreyes.com", false },
  { "jonathanscott.me", true },
  { "jonblankenship.com", true },
  { "jondarby.com", true },
  { "jondevin.com", true },
  { "jondowdle.com", false },
  { "jonespayne.com", false },
  { "jong030.nl", true },
  { "jongbloed.nl", true },
  { "jongcaxent.tk", true },
  { "jongcs.com", true },
  { "jongpay.com", true },
  { "jongtonghapkido.tk", true },
  { "jonilar.com", true },
  { "jonincharacter.com", true },
  { "jonirrings.com", true },
  { "jonkermedia.nl", false },
  { "jonlabelle.com", true },
  { "jonlu.ca", true },
  { "jonnasbeauty.com", true },
  { "jonny5.ru", true },
  { "jonnybarnes.uk", true },
  { "jonnystoten.com", true },
  { "jonoalderson.com", true },
  { "jonola.com", true },
  { "jonpads.com", true },
  { "jonpavelich.com", true },
  { "jonscaife.com", true },
  { "jonssheds.direct", true },
  { "joodari.fi", true },
  { "jooksms.com", true },
  { "jooksuratas.ee", true },
  { "joomla-leipzig.com", true },
  { "joompress.biz", true },
  { "joona.pw", true },
  { "joostrijneveld.nl", true },
  { "joostvanderlaan.nl", true },
  { "jopl.org", true },
  { "joran.org", true },
  { "jorcus.com", true },
  { "jordandevelopment.com", true },
  { "jordanhamilton.me", true },
  { "jordankmportal.com", true },
  { "jordanprogrammer.tk", true },
  { "jordans.co.uk", true },
  { "jordanscorporatelaw.com", true },
  { "jordanstrustcompany.com", true },
  { "jordibelgraver.email", true },
  { "jordibelgraver.eu", true },
  { "jordibelgraver.xyz", true },
  { "jorgeto.ddns.net", true },
  { "jorisdalderup.nl", true },
  { "jornalalerta.com.br", true },
  { "jorsev.com", true },
  { "josc.com.au", true },
  { "joscares.com", true },
  { "jose-alexand.re", true },
  { "jose-latino.tk", true },
  { "jose-lesson.com", true },
  { "jose-manuel-benito-alvarez.tk", true },
  { "josealonsodds.com", true },
  { "joseenriquegonzalez.tk", true },
  { "joseetesser.nl", true },
  { "josef-lotz.de", true },
  { "josefernandomorilloardila.tk", true },
  { "josefjanosec.com", true },
  { "josefottosson.se", true },
  { "josegdigital.com", true },
  { "joseitoda.org", true },
  { "josemikkola.fi", true },
  { "josepbel.com", true },
  { "josephbarela.com", true },
  { "josephbleroy.com", true },
  { "josephgeorge.com.au", true },
  { "josephquinaucho.com", true },
  { "josephre.es", false },
  { "josephsniderman.com", true },
  { "josephsniderman.org", true },
  { "josephv.website", true },
  { "joshgilson.com", true },
  { "joshgrancell.com", true },
  { "joshharmon.me", true },
  { "joshics.in", false },
  { "joshjanzen.com", true },
  { "joshlovephotography.co.uk", true },
  { "joshrickert.com", true },
  { "joshruppe.com", true },
  { "joshschmelzle.com", true },
  { "joshtriplett.org", true },
  { "joshua-kuepper.de", true },
  { "joshua.bio", true },
  { "joshuadmiller.info", true },
  { "joshuamessick.com", true },
  { "joshuameunier.com", true },
  { "joshuarogers.net", true },
  { "josoansi.de", true },
  { "jouons-aux-echecs.be", true },
  { "jourdain.pro", true },
  { "journalism-schools.com", true },
  { "journalof.tech", true },
  { "journeedesfilles.gc.ca", true },
  { "journeyfitness.com", true },
  { "journeyfriday.rocks", true },
  { "journeying.ca", true },
  { "journeyof1000hops.com", true },
  { "journeytomastery.net", true },
  { "joustsec.ca", true },
  { "joustsec.com", true },
  { "joustsecurity.com", true },
  { "jouwtechnischecoach.nl", true },
  { "jovani.com", false },
  { "jovenescontraelaburrimiento.tk", true },
  { "jovic.hamburg", true },
  { "joyful.house", true },
  { "joyfulexpressions.gallery", true },
  { "joyfulhealthyeats.com", true },
  { "joyinverse.com", true },
  { "joyofcookingandbaking.com", true },
  { "joyofhaskell.com", true },
  { "joyqi.com", true },
  { "joysinventingblog.com", true },
  { "jpbe-network.de", true },
  { "jpbe.de", true },
  { "jpbike.cz", false },
  { "jpdeharenne.be", false },
  { "jpeg.io", true },
  { "jpgangbang.com", true },
  { "jphandjob.com", true },
  { "jplennard.com", true },
  { "jplesbian.com", true },
  { "jpmelos.com", true },
  { "jpmelos.com.br", true },
  { "jpmguitarshop.com.br", true },
  { "jpod.cc", true },
  { "jppcadvertising.com", true },
  { "jpph.org", true },
  { "jpralves.net", true },
  { "jproxx.com", true },
  { "jps-selection.co.uk", true },
  { "jps-selection.com", true },
  { "jps-selection.eu", true },
  { "jpshop.ru", true },
  { "jpsinflatables.co.uk", true },
  { "jpslconsulting.ca", true },
  { "jpvtutoriales.com", true },
  { "jqk918.com", true },
  { "jquery.wtf", true },
  { "jrabasco.me", true },
  { "jrc9.ca", false },
  { "jrcmo.com", true },
  { "jreb.nl", true },
  { "jreiff.de", true },
  { "jross.me", true },
  { "jrt.ovh", true },
  { "jrtapsell.co.uk", true },
  { "jrxpress.com", true },
  { "js-web.eu", true },
  { "js0204.com", true },
  { "js636.com", true },
  { "js637.com", true },
  { "js638.com", true },
  { "js6868.cc", true },
  { "js80651.com", true },
  { "js86.de", true },
  { "js8855.com", true },
  { "jsbentertainment.nl", true },
  { "jschoi.org", true },
  { "jschumacher.info", true },
  { "jsd-cog.org", true },
  { "jsdelivr.com", true },
  { "jselby.net", true },
  { "jsent.co.uk", true },
  { "jshub.com", true },
  { "jsidefox.de", true },
  { "jsk26.ru", true },
  { "jskoelliken.ch", true },
  { "jsme.cz", true },
  { "jsmetallerie.fr", true },
  { "jsnfwlr.com", true },
  { "jsnfwlr.io", true },
  { "jss6868.cc", true },
  { "jsteward.moe", true },
  { "jstore.ch", true },
  { "jsxc.ch", true },
  { "jtcat.com", true },
  { "jtcjewelry.com", true },
  { "jtconsultancy.sg", true },
  { "jtl-pos.com", true },
  { "jtl-software.com", true },
  { "jtl-software.de", false },
  { "jtmar.me", true },
  { "jtp.id", true },
  { "jts3servermod.com", true },
  { "jtslay.com", true },
  { "jttech.se", true },
  { "ju.io", true },
  { "juan23.edu.uy", true },
  { "juanfrancisco.tech", true },
  { "juanjovega.com", true },
  { "juanmazzetti.com", true },
  { "juanxt.ddns.net", true },
  { "jubileum.online", true },
  { "jubobs.com", true },
  { "jucca-nautica.si", true },
  { "jucktehkeinen.de", true },
  { "jucocauca.tk", true },
  { "judge2020.com", true },
  { "judoprodeti.cz", true },
  { "judosaintdenis.fr", true },
  { "judybai.me", true },
  { "judytka.cz", true },
  { "juef.space", true },
  { "juegosycodigos.es", true },
  { "juegosycodigos.mx", true },
  { "juegosyolimpicos.com", true },
  { "juergen-elbert.de", true },
  { "juergenhecht.de", true },
  { "juergenklieber.de", true },
  { "juergenspecht.com", true },
  { "juergenspecht.de", true },
  { "jugendfeuerwehr-vechta.de", true },
  { "jugendhackt.org", true },
  { "jugendsuenden.info", true },
  { "jugh.de", true },
  { "jugwallonie.be", true },
  { "juhakoho.com", true },
  { "juice.codes", true },
  { "juk.life", false },
  { "juku-wing.jp", true },
  { "jule-spil.dk", true },
  { "julenlanda.com", false },
  { "julesroovers.nl", true },
  { "julestern.com", true },
  { "julia-clarete.tk", true },
  { "julia-thonig.de", true },
  { "juliaknightly.com", true },
  { "julian-post.de", true },
  { "julian-uphoff.de", true },
  { "julian-weigle.de", true },
  { "julianbroadway.com", true },
  { "juliangonggrijp.com", true },
  { "julianickel.de", true },
  { "julianmeyer.de", true },
  { "juliansimioni.com", true },
  { "julianskitchen.ch", false },
  { "julianvmodesto.com", true },
  { "julianweigle.de", true },
  { "julianxhokaxhiu.com", true },
  { "juliazeengardendesign.co.uk", true },
  { "julibear.com", true },
  { "julibon.com", true },
  { "julico.nl", true },
  { "julie-and-stevens-wedding.com", true },
  { "juliedecubber.com", true },
  { "juliekoubova.net", true },
  { "juliekproperties.com", true },
  { "juliemaurel.fr", true },
  { "julienc.io", true },
  { "juliendoco.com", true },
  { "julienpaterne.com", false },
  { "julienschmidt.com", true },
  { "julienstalder.ch", true },
  { "julientartarin.com", true },
  { "julius-zoellner.de", true },
  { "juliuseskola.org", true },
  { "jullensgroningen.com", true },
  { "julm.de", true },
  { "jultube.de", true },
  { "jumboquid.co.uk", true },
  { "jump-zone.co.uk", true },
  { "jump.wtf", true },
  { "jump4funinflatables.co.uk", true },
  { "jumpandbounce.co.uk", true },
  { "jumpandjivechildrensparties.co.uk", true },
  { "jumparoundbouncycastles.co.uk", true },
  { "jumparty.co.uk", true },
  { "jumpbuttonnorth.com", true },
  { "jumpeasy.com.au", true },
  { "jumpin-jax.co.uk", true },
  { "jumpinchat.com", true },
  { "jumpingbee.co.uk", true },
  { "jumpingcastlesonline.com.au", true },
  { "jumpingdeliege-vip.be", true },
  { "jumpingjacksbouncycastles.co.uk", true },
  { "jumpinjaes.co.uk", true },
  { "jumpinmonkeys.co.uk", true },
  { "jumpintogreenerpastures.com", true },
  { "jumpnplay.co.uk", true },
  { "jumprun.com", true },
  { "jundongwu.com", true },
  { "junethack.net", true },
  { "jungesforumkonstanz.de", true },
  { "junggesellmuc.de", true },
  { "jungidee.at", true },
  { "jungleadventuretours.net", true },
  { "jungleducks.ca", true },
  { "junglejackscastles.co.uk", true },
  { "junglememories.co.uk", true },
  { "junglevet.fr", true },
  { "junglist.org", true },
  { "jungyonghwa.tk", true },
  { "juni.io", true },
  { "junias-fenske.de", true },
  { "juniorhandball.com", true },
  { "juniperroots.ca", true },
  { "junjun-web.net", true },
  { "junkdrome.org", true },
  { "juno.co.uk", true },
  { "junodownload.com", true },
  { "junta.pl", true },
  { "juozasveza.lt", true },
  { "juppy.tk", true },
  { "jupuglia.com.br", true },
  { "jura-reiseschutz.de", true },
  { "juragan.ga", true },
  { "jurassicbarkharrogate.co.uk", true },
  { "jurassicgolf.nl", true },
  { "jurassicworldfilmen.cf", true },
  { "juridoc.com.br", true },
  { "juristique.fr", true },
  { "juristique.info", true },
  { "juristique.org", true },
  { "juristique.us", true },
  { "jurojin.net", true },
  { "jusos-goettingen.de", true },
  { "just-heberg.fr", true },
  { "just-keep-swimming.tk", true },
  { "just-vet-and-drive.fr", true },
  { "just-webdesign-berlin.de", true },
  { "just2trade.com", true },
  { "just3preety.com", true },
  { "justbelieverecoverypa.com", true },
  { "justbookexcursions.com", true },
  { "justbooktransfers.com", true },
  { "justboom.co", true },
  { "justbouncecastles.co.uk", true },
  { "justcalm.tk", true },
  { "justchunks.net", true },
  { "justeducationonline.com", true },
  { "justgalak.com", true },
  { "justgalak.org", true },
  { "justice.gov", true },
  { "justice4assange.com", true },
  { "justimports.com.br", true },
  { "justin-p.me", true },
  { "justinfreid.com", true },
  { "justinharrison.ca", true },
  { "justinho.com", true },
  { "justinmuturifoundation.org", true },
  { "justinstandring.com", true },
  { "justknigi.gq", true },
  { "justmysocks.xyz", true },
  { "justonce.net", true },
  { "justpaste.it", true },
  { "justquoteme.ga", true },
  { "justsmart.io", true },
  { "justsome.info", true },
  { "justthinktwice.gov", false },
  { "justupdate.me", true },
  { "justyy.com", true },
  { "juszczak.io", true },
  { "juszkiewicz.com.pl", true },
  { "jutella.de", false },
  { "jutlander-netbank.dk", true },
  { "jutlander.dk", true },
  { "juttaheitland.com", true },
  { "juusujanar.eu", false },
  { "juwelierstoopman.nl", true },
  { "juweliervanwillegen.nl", true },
  { "juxin08.com", true },
  { "juyunce.com", true },
  { "jvandenbroeck.com", true },
  { "jvanerp.nl", true },
  { "jvbouncycastlehire.co.uk", true },
  { "jvdham.nl", true },
  { "jvdz.nl", true },
  { "jvega.me", true },
  { "jvlandscapingservices.com", true },
  { "jvlfinance.cz", true },
  { "jvphotoboothhire.co.uk", true },
  { "jvrproductions.com", true },
  { "jvsticker.com", true },
  { "jw1.ca", true },
  { "jw66.cc", true },
  { "jw77.cc", true },
  { "jwatt.org", true },
  { "jwchords.org", true },
  { "jwe.nl", true },
  { "jwhite.network", true },
  { "jwilsson.com", true },
  { "jwimps.com", true },
  { "jwjwjw.com", true },
  { "jwmmarketing.com", true },
  { "jwnotifier.org", true },
  { "jwod.gov", true },
  { "jwr.me", true },
  { "jwschuepfheim.ch", true },
  { "jwtv2.com", true },
  { "jwz.org", true },
  { "jxir.de", true },
  { "jxltom.com", true },
  { "jxm.in", true },
  { "jydemarked.dk", true },
  { "jyk.me", true },
  { "jyoba.co.jp", true },
  { "jyoti-fairworks.org", true },
  { "jyrilaitinen.fi", true },
  { "jyvaskylantykkimies.fi", true },
  { "jzcapital.co", true },
  { "jzgj088.com", true },
  { "jzwebdesign.ie", true },
  { "k-bone.com", true },
  { "k-homes.net", true },
  { "k-jtan.ca", true },
  { "k-plant.com", true },
  { "k-pture.com", false },
  { "k-sails.com", true },
  { "k-scr.me", true },
  { "k-system.de", true },
  { "k-tube.com", true },
  { "k10.ag", true },
  { "k10.app", true },
  { "k10.best", true },
  { "k1024.org", true },
  { "k1958.com", true },
  { "k258059.net", true },
  { "k2mts.org", true },
  { "k36533.com", true },
  { "k36594.com", true },
  { "k3nny.fr", true },
  { "k4law.com", true },
  { "k4r.ru", true },
  { "k51365.com", true },
  { "k66.ag", true },
  { "k663.ag", true },
  { "k663.vip", true },
  { "k665.vip", true },
  { "k666.ag", true },
  { "k666.co", true },
  { "k6666.ag", true },
  { "k66666.ag", true },
  { "k6668.ag", true },
  { "k667.ag", true },
  { "k668.ag", true },
  { "k668.vip", true },
  { "k6688.ag", true },
  { "k669.ag", true },
  { "k7azx.com", true },
  { "k8-1.com", true },
  { "k8-2.com", true },
  { "k8-facai.com", true },
  { "k8.com", true },
  { "k8002.com", true },
  { "k80039.com", true },
  { "k801.co", true },
  { "k801.com", true },
  { "k8013.com", true },
  { "k8023.com", true },
  { "k8029.com", true },
  { "k8031.com", true },
  { "k8032.com", true },
  { "k8037.com", true },
  { "k8039.com", true },
  { "k805.com", true },
  { "k805.net", true },
  { "k8052.com", true },
  { "k8053.com", true },
  { "k8062.com", true },
  { "k8063.com", true },
  { "k8067.com", true },
  { "k807.com", true },
  { "k807.net", true },
  { "k8071.com", true },
  { "k8073.com", true },
  { "k8075.com", true },
  { "k8079.com", true },
  { "k8082.com", true },
  { "k8083.com", true },
  { "k8084.com", true },
  { "k8086.com", true },
  { "k809.net", true },
  { "k8097.com", true },
  { "k8098.com", true },
  { "k80998.com", true },
  { "k8100.com", true },
  { "k8102.com", true },
  { "k8103.com", true },
  { "k8105.com", true },
  { "k8106.com", true },
  { "k8107.com", true },
  { "k8109.com", true },
  { "k811.co", true },
  { "k811.com", true },
  { "k8111.com", true },
  { "k81111.com", true },
  { "k811111.com", true },
  { "k8121.com", true },
  { "k8125.com", true },
  { "k8158.com", true },
  { "k816.net", true },
  { "k81788.com", true },
  { "k818.co", true },
  { "k81818.com", true },
  { "k819.net", true },
  { "k821.net", true },
  { "k82222.com", true },
  { "k82222.net", true },
  { "k8268.net", true },
  { "k8270.com", true },
  { "k82999.com", true },
  { "k831.com", true },
  { "k83333.com", true },
  { "k8336.com", true },
  { "k8368.com", true },
  { "k8368.net", true },
  { "k8370.com", true },
  { "k8403.com", true },
  { "k8421.com", true },
  { "k8427.com", true },
  { "k8432.com", true },
  { "k8437.com", true },
  { "k846.com", true },
  { "k8463.com", true },
  { "k8487.com", true },
  { "k85.app", true },
  { "k851.co", true },
  { "k851.com", true },
  { "k852.co", true },
  { "k852.com", true },
  { "k8524.com", true },
  { "k8533.com", true },
  { "k8578.com", true },
  { "k86.app", true },
  { "k860.co", true },
  { "k86188.com", true },
  { "k865.co", true },
  { "k865.com", true },
  { "k865.net", true },
  { "k86666.com", true },
  { "k8668.com", true },
  { "k8668.net", true },
  { "k86681.com", true },
  { "k867.co", true },
  { "k867.com", true },
  { "k86788.com", true },
  { "k86810.com", true },
  { "k86813.com", true },
  { "k86814.com", true },
  { "k86830.com", true },
  { "k86833.com", true },
  { "k86834.com", true },
  { "k86835.com", true },
  { "k86836.com", true },
  { "k86837.com", true },
  { "k86838.com", true },
  { "k86839.com", true },
  { "k86848.com", true },
  { "k86849.com", true },
  { "k86851.com", true },
  { "k86852.com", true },
  { "k86853.com", true },
  { "k86854.com", true },
  { "k86855.com", true },
  { "k86856.com", true },
  { "k86869.com", true },
  { "k86870.com", true },
  { "k86871.com", true },
  { "k86880.com", true },
  { "k86887.com", true },
  { "k869.co", true },
  { "k86913.com", true },
  { "k86914.com", true },
  { "k86915.com", true },
  { "k86916.com", true },
  { "k86917.com", true },
  { "k86918.com", true },
  { "k86920.com", true },
  { "k86921.com", true },
  { "k86922.com", true },
  { "k86923.com", true },
  { "k86924.com", true },
  { "k86925.com", true },
  { "k86926.com", true },
  { "k86927.com", true },
  { "k86928.com", true },
  { "k86929.com", true },
  { "k86930.com", true },
  { "k86931.com", true },
  { "k86932.com", true },
  { "k8694.com", true },
  { "k86965.com", true },
  { "k86966.com", true },
  { "k86967.com", true },
  { "k86988.com", true },
  { "k86989.com", true },
  { "k86990.com", true },
  { "k86991.com", true },
  { "k87.app", true },
  { "k87017.com", true },
  { "k87018.com", true },
  { "k87019.com", true },
  { "k87020.com", true },
  { "k87021.com", true },
  { "k87022.com", true },
  { "k87023.com", true },
  { "k87024.com", true },
  { "k87025.com", true },
  { "k87026.com", true },
  { "k87027.com", true },
  { "k87028.com", true },
  { "k87067.com", true },
  { "k87071.com", true },
  { "k87072.com", true },
  { "k87073.com", true },
  { "k87074.com", true },
  { "k87075.com", true },
  { "k87076.com", true },
  { "k87077.com", true },
  { "k87078.com", true },
  { "k87079.com", true },
  { "k87080.com", true },
  { "k87081.com", true },
  { "k87082.com", true },
  { "k87083.com", true },
  { "k87084.com", true },
  { "k87100.com", true },
  { "k87119.com", true },
  { "k87120.com", true },
  { "k87121.com", true },
  { "k87126.com", true },
  { "k87127.com", true },
  { "k87128.com", true },
  { "k87129.com", true },
  { "k87130.com", true },
  { "k87131.com", true },
  { "k87132.com", true },
  { "k87133.com", true },
  { "k87134.com", true },
  { "k87135.com", true },
  { "k87136.com", true },
  { "k87137.com", true },
  { "k87138.com", true },
  { "k87183.com", true },
  { "k87288.com", true },
  { "k873.co", true },
  { "k873.com", true },
  { "k8736.com", true },
  { "k875.co", true },
  { "k8771.com", true },
  { "k8780.com", true },
  { "k8804.com", true },
  { "k88101.com", true },
  { "k88102.com", true },
  { "k88103.com", true },
  { "k88105.com", true },
  { "k88106.com", true },
  { "k88107.com", true },
  { "k88109.com", true },
  { "k88110.com", true },
  { "k88112.com", true },
  { "k88113.com", true },
  { "k88115.com", true },
  { "k88116.com", true },
  { "k88117.com", true },
  { "k88120.com", true },
  { "k88121.com", true },
  { "k88122.com", true },
  { "k88125.com", true },
  { "k88126.com", true },
  { "k88127.com", true },
  { "k88128.com", true },
  { "k88129.com", true },
  { "k88130.com", true },
  { "k88131.com", true },
  { "k88132.com", true },
  { "k88133.com", true },
  { "k88135.com", true },
  { "k88137.com", true },
  { "k88139.com", true },
  { "k88151.com", true },
  { "k88152.com", true },
  { "k88153.com", true },
  { "k88201.com", true },
  { "k88205.com", true },
  { "k88207.com", true },
  { "k88208.com", true },
  { "k88210.com", true },
  { "k88213.com", true },
  { "k88214.com", true },
  { "k88233.com", true },
  { "k88236.com", true },
  { "k88237.com", true },
  { "k88238.com", true },
  { "k88239.com", true },
  { "k88250.com", true },
  { "k88251.com", true },
  { "k88252.com", true },
  { "k88253.com", true },
  { "k88255.com", true },
  { "k88256.com", true },
  { "k88257.com", true },
  { "k88258.com", true },
  { "k88259.com", true },
  { "k88260.com", true },
  { "k88261.com", true },
  { "k88262.com", true },
  { "k88263.com", true },
  { "k88265.com", true },
  { "k88267.com", true },
  { "k88268.com", true },
  { "k88269.com", true },
  { "k88270.com", true },
  { "k88271.com", true },
  { "k88272.com", true },
  { "k88273.com", true },
  { "k88275.com", true },
  { "k88276.com", true },
  { "k88277.com", true },
  { "k88285.com", true },
  { "k88398.com", true },
  { "k88399.com", true },
  { "k884.co", true },
  { "k885.co", true },
  { "k886.co", true },
  { "k88601.com", true },
  { "k88602.com", true },
  { "k88603.com", true },
  { "k88605.com", true },
  { "k88606.com", true },
  { "k88607.com", true },
  { "k88608.com", true },
  { "k88609.com", true },
  { "k8861.com", true },
  { "k88635.com", true },
  { "k88636.com", true },
  { "k88637.com", true },
  { "k88638.com", true },
  { "k88639.com", true },
  { "k88650.com", true },
  { "k88651.com", true },
  { "k88652.com", true },
  { "k88653.com", true },
  { "k88655.com", true },
  { "k88656.com", true },
  { "k88657.com", true },
  { "k88658.com", true },
  { "k88659.com", true },
  { "k88660.com", true },
  { "k88661.com", true },
  { "k88662.com", true },
  { "k88663.com", true },
  { "k88665.com", true },
  { "k88667.com", true },
  { "k88668.com", true },
  { "k88670.com", true },
  { "k88671.com", true },
  { "k88672.com", true },
  { "k88673.com", true },
  { "k88675.com", true },
  { "k88676.com", true },
  { "k88677.com", true },
  { "k88679.com", true },
  { "k88680.com", true },
  { "k88681.com", true },
  { "k88682.com", true },
  { "k88683.com", true },
  { "k88684.com", true },
  { "k88685.com", true },
  { "k88686.com", true },
  { "k888.ag", true },
  { "k88801.com", true },
  { "k88870.com", true },
  { "k88881.com", true },
  { "k88890.com", true },
  { "k88891.com", true },
  { "k889.co", true },
  { "k8892.com", true },
  { "k89.app", true },
  { "k89188.com", true },
  { "k8927.com", true },
  { "k89388.com", true },
  { "k8955.com", true },
  { "k8974.com", true },
  { "k8994.com", true },
  { "k8dc01.com", true },
  { "k8dc13.com", true },
  { "k8dc17.com", true },
  { "k8gege.com", true },
  { "k8md01.com", true },
  { "k8md12.com", true },
  { "k8n.de", true },
  { "k8r.eu", true },
  { "k8slot.com", true },
  { "k8v02.com", true },
  { "k8v03.com", true },
  { "k8v04.com", true },
  { "k8v05.com", true },
  { "k8v06.com", true },
  { "k8v07.com", true },
  { "k8v08.com", true },
  { "k8v09.com", true },
  { "k8v12.com", true },
  { "k8v13.com", true },
  { "k8v14.com", true },
  { "k8v15.com", true },
  { "k8v16.com", true },
  { "k8v17.com", true },
  { "k8v19.com", true },
  { "k8v20.com", true },
  { "k8v21.com", true },
  { "k8v23.com", true },
  { "k8v24.com", true },
  { "k8v25.com", true },
  { "k8v26.com", true },
  { "k8v27.com", true },
  { "k8v29.com", true },
  { "k8v30.com", true },
  { "k9swx.com", true },
  { "kaamoscreations.com", true },
  { "kaanhaa.com", true },
  { "kaasbesteld.nl", true },
  { "kaatha-kamrater.se", true },
  { "kaatsen.tk", true },
  { "kab-s.de", true },
  { "kabachok.tk", true },
  { "kabarlinux.id", true },
  { "kabashop.com.br", true },
  { "kabellegger.nl", true },
  { "kabeltv.co.nz", true },
  { "kabeuchi.com", true },
  { "kabinett.cz", true },
  { "kabulpress.org", true },
  { "kabus.org", true },
  { "kacgal.com", true },
  { "kachelfm.nl", true },
  { "kachlikova2.cz", true },
  { "kack.website", true },
  { "kadhambam.in", true },
  { "kado-ya.jp", true },
  { "kadro.com.pl", true },
  { "kadvi.tk", true },
  { "kafeh-jazan.com", true },
  { "kafel-ufa.tk", true },
  { "kaffau.com", true },
  { "kaffeekrone.de", true },
  { "kaffeeringe.de", true },
  { "kafoom.de", true },
  { "kagicomb.org", true },
  { "kagitreklam.com", true },
  { "kagucho.net", true },
  { "kaheim.de", true },
  { "kai-ratzeburg.de", true },
  { "kai-ruecker.tk", true },
  { "kaibo.cz", true },
  { "kaibo.eu", true },
  { "kaidoblogi.eu", true },
  { "kaifa.gs", true },
  { "kaifa199.com", true },
  { "kaigojj.com", true },
  { "kaikei7.com", true },
  { "kaileymslusser.com", true },
  { "kaioken.bar", true },
  { "kais08.com", true },
  { "kais68.com", true },
  { "kais98.com", true },
  { "kaisab.com", true },
  { "kaisev.net", true },
  { "kaishi.ag", true },
  { "kaishi002.com", true },
  { "kaishi555.com", true },
  { "kaishi999.com", true },
  { "kaitol.click", true },
  { "kaitori-goods.shop", true },
  { "kaiusaltd.com", true },
  { "kaivac-emea.com", true },
  { "kaiwu.xyz", true },
  { "kaizencraft.ga", true },
  { "kaizenreporting.com", true },
  { "kaizeronion.com", true },
  { "kajak.land", true },
  { "kajakswaderki.pl", true },
  { "kak-pohudet-legko.ml", true },
  { "kaka.farm", true },
  { "kakacon.nz", true },
  { "kakao-karten.de", true },
  { "kakaravaara.fi", true },
  { "kakie-gobocha.jp", true },
  { "kakie-kolesa.ru", true },
  { "kakolightingmuseum.or.jp", true },
  { "kaktuskola.se", true },
  { "kalamos-psychiatrie.be", true },
  { "kalamos.tk", true },
  { "kalashcards.com", true },
  { "kalashnikov.ml", true },
  { "kalastus.com", true },
  { "kaleidlink.com", true },
  { "kaleidokollection.com.au", true },
  { "kaleidoscope.co.uk", true },
  { "kalender.com", true },
  { "kalevlamps.co.uk", true },
  { "kalex.nl", true },
  { "kalian.cz", true },
  { "kaliboairport.tk", true },
  { "kaliningrad.gq", true },
  { "kalisch.eu", true },
  { "kalkulacka-havarijni.cz", true },
  { "kall.is", true },
  { "kallies-net.de", true },
  { "kalmar.com", true },
  { "kalmykphilly.org", true },
  { "kalombo.ru", true },
  { "kalsa.ga", true },
  { "kaltenbrunner.it", true },
  { "kalterersee.ch", true },
  { "kalugadeti.ru", true },
  { "kalwestelectric.com", true },
  { "kalyanmatka.guru", false },
  { "kam-serwis.pl", true },
  { "kamagraerektion.eu", true },
  { "kamata-shinkyu-seikotsu.jp", true },
  { "kameari-za.space", true },
  { "kamen-master.ru", true },
  { "kamikaichimaru.com", false },
  { "kamikatse.net", true },
  { "kamildrozd.tk", true },
  { "kamilmagdziak.pl", true },
  { "kaminbau-laub.de", true },
  { "kamisato-ent.com", true },
  { "kamixa.se", true },
  { "kamppailusali.fi", true },
  { "kamranmirhazar.com", true },
  { "kamui.co.uk", true },
  { "kamuniang.org", true },
  { "kan3.de", true },
  { "kana-mono.biz", true },
  { "kanaete-uranai.com", true },
  { "kanag.pl", true },
  { "kanal-tv-haensch.de", true },
  { "kandalife.com", true },
  { "kandhamal.org", true },
  { "kandianshang.com", true },
  { "kandofu.com", true },
  { "kandoo.tech", true },
  { "kanecastles.com", true },
  { "kanehusky.com", false },
  { "kanetix.ca", true },
  { "kangaroo-bouncycastle.co.uk", true },
  { "kangarooislandholidayaccommodation.com.au", true },
  { "kangaroojacks.co.uk", true },
  { "kangaroos.org", true },
  { "kangaroovalleykayaks.com.au", true },
  { "kangaroovalleymuseum.com", true },
  { "kangaroovalleyolives.com.au", true },
  { "kangaroovalleyshow.org.au", true },
  { "kangaroovalleywoodcrafts.com.au", true },
  { "kanis.ag", true },
  { "kanis.me", true },
  { "kankimaru.com", true },
  { "kanna.cf", true },
  { "kannchen.de", true },
  { "kanootours.com", true },
  { "kanpian369.com", true },
  { "kansaiyamamoto.jp", true },
  { "kantankye.nl", true },
  { "kantanmt.com", true },
  { "kantoportraits.com", true },
  { "kantorosobisty.pl", true },
  { "kanuvu.de", true },
  { "kanyingba.com", true },
  { "kanzashi.com", true },
  { "kanzlei-gaengler.de", true },
  { "kanzlei-oehler.com", true },
  { "kanzlei-sixt.de", true },
  { "kap-genial.de", true },
  { "kap.pe", true },
  { "kapelya.gq", true },
  { "kapler.family", true },
  { "kappershuis-meppel.nl", true },
  { "kappharn.com", true },
  { "kappie.xyz", true },
  { "kapsalonlinds.nl", true },
  { "kapseli.net", true },
  { "kaptadata.com", true },
  { "kaptamedia.com", true },
  { "kaputtzich.duckdns.org", true },
  { "karabas.com", true },
  { "karabijnhaken.nl", false },
  { "karachi.dating", true },
  { "karalane.com", true },
  { "karamomo.net", true },
  { "karanjthakkar.com", true },
  { "karanlyons.com", true },
  { "karantholdings.ga", true },
  { "karapuzz.tk", true },
  { "karasik.by", true },
  { "karateka.org", true },
  { "karateka.ru", true },
  { "karatekit.co.uk", true },
  { "karawanken-tunnel.de", true },
  { "kareltrans.tk", true },
  { "karewan.ovh", true },
  { "karger.com", true },
  { "kargl.net", true },
  { "karguine.in", true },
  { "karimsaadati.tk", true },
  { "karina.gd", true },
  { "karinwerner.com", true },
  { "karit.nz", true },
  { "kariyam.com", true },
  { "karlbowden.com", true },
  { "karlic.net", true },
  { "karlloch.de", true },
  { "karlsmithmn.org", true },
  { "karlzotter.com", true },
  { "karmaassurance.ca", true },
  { "karmabaker.com", true },
  { "karmaflux.com", true },
  { "karmainsurance.ca", true },
  { "karmaplatform.com", true },
  { "karmaspa.se", true },
  { "karn.nu", true },
  { "karneid.info", true },
  { "karo.pc.pl", true },
  { "karodos.pl", true },
  { "karolak.fr", true },
  { "karopapier.de", true },
  { "karopc.com.pl", true },
  { "karopc.pl", true },
  { "karoverwaltung.de", true },
  { "karrot.world", true },
  { "karrselfstorage.com", true },
  { "karsten-voigt.de", true },
  { "karta-paliwowa.pl", true },
  { "kartacha.com", true },
  { "kartar.net", false },
  { "kartatopia.com", true },
  { "kartbird.com", true },
  { "kartec.com", true },
  { "karten-verlag.de", true },
  { "kartikmohta.com", true },
  { "kartoffel-tobi.de", true },
  { "kartonmodellbau.org", true },
  { "karula.org", true },
  { "karupp-did.net", true },
  { "kas.ie", true },
  { "kasei.im", true },
  { "kashbet.net", true },
  { "kashflowcoupon.co.uk", true },
  { "kashflowpromocode.co.uk", true },
  { "kashinavi.com", true },
  { "kashis.com.au", true },
  { "kasiafricagroup.org", true },
  { "kasinobonus.com", true },
  { "kasko.io", true },
  { "kaskocdn.com", true },
  { "kaskocloud.com", true },
  { "kaskodev.com", true },
  { "kaskojs.com", true },
  { "kaskoqa.com", true },
  { "kasnoffskinclinic.com", true },
  { "kasperstad.dk", true },
  { "kassa.at", true },
  { "kassa.expert", true },
  { "kassa.fr", true },
  { "kassarsoap.com", true },
  { "kastankaoffice.cz", true },
  { "kastelruth.biz", true },
  { "kastgroup.com", true },
  { "kastorsky.ru", true },
  { "kasual.id", true },
  { "kat.marketing", true },
  { "katagena.com", true },
  { "kataiszilveszter.hu", true },
  { "katalog-serverov.ga", true },
  { "katalog-tovarov.tk", true },
  { "katalogbajugamismu.com", true },
  { "katalogkapsli.pl", true },
  { "katapult.es", true },
  { "katarsisuib.no", true },
  { "katcleaning.com.au", false },
  { "katcr.co", true },
  { "katedra.de", true },
  { "katekligys.com", true },
  { "katemihalikova.cz", true },
  { "katericke.com", true },
  { "katex.org", true },
  { "kateysagal.tk", true },
  { "kathardt.de", true },
  { "kathegiraldo.com", true },
  { "katherineswynford.tk", true },
  { "kathleendeisher.com", true },
  { "kathy.lgbt", true },
  { "kati-raumplaner.de", true },
  { "katiechai.xyz", true },
  { "katieriker.com", true },
  { "katieskandy.co.uk", true },
  { "katieskastles.co.uk", true },
  { "kativa.it", true },
  { "katja-und-ronny.de", true },
  { "katjavoneysmondt.de", true },
  { "katka.info", true },
  { "katnunn.co.uk", true },
  { "kato-yane.com", true },
  { "katscastles.co.uk", true },
  { "katsiavarasorthopedics.gr", true },
  { "katsunet.com", true },
  { "kattelans.eu", true },
  { "katyl.info", false },
  { "katyusha.net", true },
  { "kau-boys.com", true },
  { "kau-boys.de", true },
  { "kaufberatung.community", true },
  { "kaufkraftkiel.de", true },
  { "kavatasygarety.tk", true },
  { "kavorka.me", true },
  { "kavovary-kava.cz", true },
  { "kawaii.su", true },
  { "kawaiicon.org", true },
  { "kawiarnia.xyz", true },
  { "kay.la", true },
  { "kayit.co.uk", true },
  { "kayo.digital", true },
  { "kayscs.com", true },
  { "kaysis.gov.tr", false },
  { "kazakov.lt", true },
  { "kazancci.com", true },
  { "kazand.lt", true },
  { "kazandaemon.ru", true },
  { "kazek.com.pl", true },
  { "kazekprzewozy.pl", true },
  { "kazumi.ro", true },
  { "kazvel.com", true },
  { "kazy111.info", true },
  { "kb0101.com", true },
  { "kb0283.com", true },
  { "kb036.com", true },
  { "kb0404.com", true },
  { "kb0505.com", true },
  { "kb059.com", true },
  { "kb0606.com", true },
  { "kb0707.com", true },
  { "kb09.net", true },
  { "kb096.com", true },
  { "kb1313.com", true },
  { "kb1515.com", true },
  { "kb1717.com", true },
  { "kb2626.com", true },
  { "kb283.com", true },
  { "kb2929.com", true },
  { "kb3232.com", true },
  { "kb3434.com", true },
  { "kb3535.com", true },
  { "kb3636.com", true },
  { "kb367.com", true },
  { "kb3939.com", true },
  { "kb415.com", true },
  { "kb4242.com", true },
  { "kb4393.com", true },
  { "kb4545.com", true },
  { "kb458.com", true },
  { "kb4747.com", true },
  { "kb481.com", true },
  { "kb486.com", true },
  { "kb5050.com", true },
  { "kb506.com", true },
  { "kb5252.com", true },
  { "kb545.com", true },
  { "kb5454.com", true },
  { "kb5648.com", true },
  { "kb5656.com", true },
  { "kb5959.com", true },
  { "kb6464.com", true },
  { "kb6565.com", true },
  { "kb6767.com", true },
  { "kb702.com", true },
  { "kb7272.com", true },
  { "kb7474.com", true },
  { "kb750.com", true },
  { "kb756.com", true },
  { "kb787.com", true },
  { "kb8.ag", true },
  { "kb8.best", true },
  { "kb8383.com", true },
  { "kb840.com", true },
  { "kb848.com", true },
  { "kb8484.com", true },
  { "kb8585.com", true },
  { "kb88.ag", true },
  { "kb88.best", true },
  { "kb88.com", true },
  { "kb88.us", true },
  { "kb8800.com", true },
  { "kb8803.com", true },
  { "kb881.cc", true },
  { "kb8815.com", true },
  { "kb8818.com", true },
  { "kb8819.com", true },
  { "kb882.cc", true },
  { "kb8820.com", true },
  { "kb883.cc", true },
  { "kb8830.com", true },
  { "kb8835.com", true },
  { "kb8837.com", true },
  { "kb8838.com", true },
  { "kb8839.com", true },
  { "kb8841.com", true },
  { "kb8843.com", true },
  { "kb8844.com", true },
  { "kb8848.com", true },
  { "kb8849.com", true },
  { "kb8852.com", true },
  { "kb8853.com", true },
  { "kb8854.com", true },
  { "kb8856.com", true },
  { "kb8857.com", true },
  { "kb8859.com", true },
  { "kb8860.com", true },
  { "kb8863.com", true },
  { "kb8864.com", true },
  { "kb8867.com", true },
  { "kb8871.com", true },
  { "kb8872.com", true },
  { "kb8874.com", true },
  { "kb8875.com", true },
  { "kb8878.com", true },
  { "kb888.ag", true },
  { "kb8880.com", true },
  { "kb8882.com", true },
  { "kb8885.com", true },
  { "kb8889.com", true },
  { "kb8890.com", true },
  { "kb8892.com", true },
  { "kb8897.com", true },
  { "kb88dc15.com", true },
  { "kb88dc23.com", true },
  { "kb88dc25.com", true },
  { "kb88dc26.com", true },
  { "kb88dc27.com", true },
  { "kb88dc30.com", true },
  { "kb88md12.com", true },
  { "kb88md26.com", true },
  { "kb88md27.com", true },
  { "kb890.com", true },
  { "kb9292.com", true },
  { "kb9494.com", true },
  { "kb957.com", true },
  { "kb965.com", true },
  { "kb9696.com", true },
  { "kb9797.com", true },
  { "kb991.com", true },
  { "kb9988.com", true },
  { "kba-online.de", true },
  { "kbb-ev.de", true },
  { "kbbouncycastlehire.co.uk", true },
  { "kbc.be", true },
  { "kbcequitas.hu", true },
  { "kbet168.com", true },
  { "kbjorklu.com", true },
  { "kbk4t.com", true },
  { "kbleventhire.co.uk", true },
  { "kbsinflatablekingdom.co.uk", true },
  { "kbterapicenter.se", true },
  { "kc-holzfaeller.de", true },
  { "kc1hbk.com", true },
  { "kc3.moe", true },
  { "kc5mpk.com", true },
  { "kcire.me", true },
  { "kcliner.com", true },
  { "kcmicapital.com", true },
  { "kcolford.com", false },
  { "kcshipping.co.uk", true },
  { "kcsordparticipation.org", true },
  { "kd.net.nz", true },
  { "kdex.de", true },
  { "kdw.cloud", true },
  { "ke.fo", true },
  { "ke7tlf.us", true },
  { "keakon.net", true },
  { "keane.space", true },
  { "keaysmillwork.com", true },
  { "keb.com.au", true },
  { "keb.net.au", true },
  { "kebabbesteld.nl", true },
  { "kebabbruce.com", false },
  { "kebhanamyanmar.com", false },
  { "kecht.at", true },
  { "kedarastudios.com", true },
  { "kedibizworx.com", true },
  { "kedv.es", true },
  { "kee.pm", true },
  { "keeleysam.com", true },
  { "keelove.net", true },
  { "keengamer.com", true },
  { "keepa.com", true },
  { "keepdecor.com", true },
  { "keepersecurity.com", true },
  { "keepingtheplot.co.uk", true },
  { "keepiteasy.eu", true },
  { "keepitsecure24.com", true },
  { "keepleft.gr", true },
  { "keepsight.org.au", true },
  { "keestalkstech.com", true },
  { "keevault.pm", true },
  { "keeweb.info", true },
  { "keezyavaleri.com", true },
  { "keganthorrez.com", true },
  { "kegelschiene.net", true },
  { "kehlenbach.net", true },
  { "keian.tk", true },
  { "keifel.de", true },
  { "kein-design.de", true },
  { "keinefilterblase.de", true },
  { "keisaku.org", true },
  { "keishiando.com", true },
  { "keithlomax.com", true },
  { "keithws.net", true },
  { "keke-shop.ch", true },
  { "kekku.li", true },
  { "keksi.io", true },
  { "keldan.fo", true },
  { "kelderwijnen.nl", true },
  { "kelgtermans-usedcars.be", false },
  { "kelheor.space", true },
  { "kelis.fr", true },
  { "keller-aarau.ch", true },
  { "keller-sports.be", true },
  { "kellerlan.org", true },
  { "kellimacconnell.com", true },
  { "kellygrenard.com", true },
  { "kellyskastles.co.uk", true },
  { "kelsa.io", true },
  { "kelsall39.com", true },
  { "kemerovo.gq", true },
  { "kemerovo.ml", true },
  { "kemerovo.tk", true },
  { "kemerovo42.tk", true },
  { "kemmerer-net.de", true },
  { "kempkens.io", true },
  { "kempo-sissach.ch", true },
  { "kemptown.co.uk", true },
  { "kemptown.com", true },
  { "kemptown.net", true },
  { "ken.fm", true },
  { "kenalsworld.com", true },
  { "kenbonny.net", true },
  { "kendermore.it", true },
  { "kengilmour.com", false },
  { "kenguntokku.jp", true },
  { "kenia-vakantie.nl", true },
  { "keniff.gq", true },
  { "kenkou-kitakyusyu.jp", true },
  { "kennedy.ie", true },
  { "kennedyinsurancesolutions.com", true },
  { "kenners.org", true },
  { "kennethandersen.com", true },
  { "kennethlim.me", true },
  { "kenneths.org", true },
  { "kenny-peck.com", true },
  { "keno.im", true },
  { "kenokallinger.at", true },
  { "kenoschwalb.com", false },
  { "kenrogers.co", false },
  { "kens.pics", true },
  { "kensbouncycastles.co.uk", true },
  { "kenscustomfloors.com", true },
  { "kentdalevets.co.uk", true },
  { "kentec.net", false },
  { "kenterlis.gr", true },
  { "kenvix.com", true },
  { "keoliz.com", true },
  { "keops-spine.fr", true },
  { "kepkonyvtar.hu", true },
  { "keponews.com", true },
  { "keralit.nl", true },
  { "keramed.ga", true },
  { "kerebro.com", true },
  { "kerijacoby.com", true },
  { "kermadec.com", true },
  { "kermadec.fr", true },
  { "kermadec.net", true },
  { "kernel-error.de", true },
  { "kernel-panik.me", true },
  { "kernelpanics.nl", true },
  { "kernelprogrammer.com", true },
  { "kernkompas.nl", true },
  { "kerrnel.com", true },
  { "kerrydavisguitars.tk", true },
  { "kerstkaart.nl", true },
  { "kersvers.agency", true },
  { "kerus.net", true },
  { "kesef.org.il", true },
  { "kessawear.com", true },
  { "kesslerwine.com", true },
  { "ketamine.co.uk", true },
  { "ketaminecareclinic.com", true },
  { "ketoconazole.gq", true },
  { "ketosecology.co.uk", true },
  { "ketotadka.com", true },
  { "kettinggeleider.be", true },
  { "kettlebellkrusher.com", true },
  { "kettlemetalbbq.com", true },
  { "kettner.com", true },
  { "keutel.net", true },
  { "kevchia.com", true },
  { "kevertje.net", true },
  { "kevin-darmor.eu", true },
  { "kevin-ta.com", true },
  { "kevin.tw", true },
  { "kevinapease.com", true },
  { "kevinbusse.de", true },
  { "kevincox.ca", false },
  { "kevincramer.net", true },
  { "kevindavid.org", true },
  { "kevindienst.blog", true },
  { "kevinhill.nl", true },
  { "kevinhq.com", true },
  { "kevinkla.es", true },
  { "kevinlocke.name", true },
  { "kevinmeijer.nl", true },
  { "kevinmoreland.com", true },
  { "kevinmorssink.nl", true },
  { "kevinpatel.com", true },
  { "kevinpirnie.com", false },
  { "kevinquintero.co", true },
  { "kevinrandles.com", false },
  { "kevinvanderperren.tk", true },
  { "kevyn.lu", true },
  { "kexino.com", true },
  { "key-form.fr", true },
  { "keybase.io", true },
  { "keybored.co", true },
  { "keybored.me", true },
  { "keycdn.com", true },
  { "keycenter.com.br", true },
  { "keycontainers.co.za", true },
  { "keyex.com.br", true },
  { "keygen.sh", true },
  { "keyhani.tk", true },
  { "keyholdingservices.co.uk", true },
  { "keyhomechecker.com", true },
  { "keyihao.cn", true },
  { "keyinfo.io", true },
  { "keylaserinstitute.com", true },
  { "keylength.com", true },
  { "keymaster.lookout.com", false },
  { "keymicrosystems.com", true },
  { "keynes.id.au", true },
  { "keyphotojs.cf", true },
  { "keys247.co.uk", true },
  { "keysofart.com", true },
  { "keysso.net", true },
  { "keystoneok.com", false },
  { "keysupport.org", true },
  { "keywalker.co.jp", true },
  { "keywebdesign.nl", true },
  { "keyworth-meadow.tk", true },
  { "kf-slot.com", true },
  { "kf0000.com", true },
  { "kf0000g.com", true },
  { "kf005.com", true },
  { "kf006.com", true },
  { "kf009.com", true },
  { "kf0101.com", true },
  { "kf016.com", true },
  { "kf020.com", true },
  { "kf026.com", true },
  { "kf030.com", true },
  { "kf0606g.com", true },
  { "kf068.com", true },
  { "kf0808.com", true },
  { "kf086.com", true },
  { "kf098.com", true },
  { "kf099.com", true },
  { "kf0q.com", true },
  { "kf108.com", true },
  { "kf117.com", true },
  { "kf1288.com", true },
  { "kf130.com", true },
  { "kf1313.com", true },
  { "kf172.com", true },
  { "kf188.com", true },
  { "kf196.com", true },
  { "kf199.com", true },
  { "kf200.vip", true },
  { "kf2000.vip", true },
  { "kf201988.com", true },
  { "kf2020g.com", true },
  { "kf2121g.com", true },
  { "kf2222g.com", true },
  { "kf260.com", true },
  { "kf268.com", true },
  { "kf282.com", true },
  { "kf2828.com", true },
  { "kf296.com", true },
  { "kf3131g.com", true },
  { "kf319.com", true },
  { "kf327.com", true },
  { "kf3333g.com", true },
  { "kf338.com", true },
  { "kf355.com", true },
  { "kf356.com", true },
  { "kf388.com", true },
  { "kf3u.com", true },
  { "kf4040.com", true },
  { "kf4343g.com", true },
  { "kf5201314.com", true },
  { "kf5252.com", true },
  { "kf5288.com", true },
  { "kf5656.com", true },
  { "kf5858.com", true },
  { "kf5858g.com", true },
  { "kf588.com", true },
  { "kf6161.com", true },
  { "kf6161g.com", true },
  { "kf618.com", true },
  { "kf6262.com", true },
  { "kf633.com", true },
  { "kf6464.com", true },
  { "kf6565.com", true },
  { "kf6622.com", true },
  { "kf6623.com", true },
  { "kf6625.com", true },
  { "kf6626.com", true },
  { "kf6627.com", true },
  { "kf6628.com", true },
  { "kf6631.com", true },
  { "kf6633.com", true },
  { "kf6635.com", true },
  { "kf6636.com", true },
  { "kf6637.com", true },
  { "kf6638.com", true },
  { "kf6639.com", true },
  { "kf6666g.com", true },
  { "kf66888.com", true },
  { "kf680.com", true },
  { "kf6800.com", true },
  { "kf6801.com", true },
  { "kf6802.com", true },
  { "kf6803.com", true },
  { "kf6805.com", true },
  { "kf6806.com", true },
  { "kf6807.com", true },
  { "kf6808.com", true },
  { "kf6809.com", true },
  { "kf6811.com", true },
  { "kf6812.com", true },
  { "kf6813.com", true },
  { "kf6815.com", true },
  { "kf6816.com", true },
  { "kf6817.com", true },
  { "kf6818.com", true },
  { "kf6819.com", true },
  { "kf6820.com", true },
  { "kf6821.com", true },
  { "kf6822.com", true },
  { "kf6823.com", true },
  { "kf6825.com", true },
  { "kf6826.com", true },
  { "kf6827.com", true },
  { "kf6828.com", true },
  { "kf6829.com", true },
  { "kf6830.com", true },
  { "kf6831.com", true },
  { "kf6835.com", true },
  { "kf6868.com", true },
  { "kf688.com", true },
  { "kf707.com", true },
  { "kf7171.com", true },
  { "kf7272.com", true },
  { "kf759.com", true },
  { "kf7676.com", true },
  { "kf7676g.com", true },
  { "kf77.app", true },
  { "kf772.com", true },
  { "kf780.com", true },
  { "kf7979.com", true },
  { "kf7979g.com", true },
  { "kf7joz.com", true },
  { "kf8181.com", true },
  { "kf820.com", true },
  { "kf826.com", true },
  { "kf8282g.com", true },
  { "kf8383.com", true },
  { "kf846.com", true },
  { "kf848.com", true },
  { "kf8484g.com", true },
  { "kf8611.com", true },
  { "kf8612.com", true },
  { "kf8613.com", true },
  { "kf8615.com", true },
  { "kf8616.com", true },
  { "kf8617.com", true },
  { "kf8619.com", true },
  { "kf8621.com", true },
  { "kf8622.com", true },
  { "kf8623.com", true },
  { "kf8625.com", true },
  { "kf8626.com", true },
  { "kf8627.com", true },
  { "kf8628.com", true },
  { "kf8629.com", true },
  { "kf8631.com", true },
  { "kf8632.com", true },
  { "kf8635.com", true },
  { "kf8636.com", true },
  { "kf8637.com", true },
  { "kf8638.com", true },
  { "kf8639.com", true },
  { "kf8651.com", true },
  { "kf8652.com", true },
  { "kf8653.com", true },
  { "kf8655.com", true },
  { "kf8656.com", true },
  { "kf8657.com", true },
  { "kf8658.com", true },
  { "kf8659.com", true },
  { "kf8686.com", true },
  { "kf8787g.com", true },
  { "kf8801.com", true },
  { "kf8803.com", true },
  { "kf8805.com", true },
  { "kf8809.com", true },
  { "kf8810.com", true },
  { "kf8812.com", true },
  { "kf8813.com", true },
  { "kf8817.com", true },
  { "kf8819.com", true },
  { "kf8820.com", true },
  { "kf8821.com", true },
  { "kf8825.com", true },
  { "kf8828.com", true },
  { "kf8830.com", true },
  { "kf8835.com", true },
  { "kf8850.com", true },
  { "kf8851.com", true },
  { "kf8857.com", true },
  { "kf8858.com", true },
  { "kf8865.com", true },
  { "kf88666.com", true },
  { "kf8867.com", true },
  { "kf8868.com", true },
  { "kf8869.com", true },
  { "kf8871.com", true },
  { "kf8872.com", true },
  { "kf8873.com", true },
  { "kf8876.com", true },
  { "kf8878.com", true },
  { "kf8879.com", true },
  { "kf8891.com", true },
  { "kf8892.com", true },
  { "kf8895.com", true },
  { "kf8896.com", true },
  { "kf8897.com", true },
  { "kf908.com", true },
  { "kf909.com", true },
  { "kf9191.com", true },
  { "kf955.com", true },
  { "kf968.com", true },
  { "kf9696.com", true },
  { "kf9797.com", true },
  { "kf981.com", true },
  { "kf997.com", true },
  { "kfa6.com", true },
  { "kfassessment.eu", true },
  { "kff7.com", true },
  { "kffs.ru", true },
  { "kfirba.me", true },
  { "kfkf999.com", true },
  { "kfo.com.br", true },
  { "kforesund.se", true },
  { "kfv-kiel.de", false },
  { "kfz-hantschel.de", true },
  { "kfz-service-wachtmann.de", true },
  { "kgm-irm.be", true },
  { "kgnk.ru", true },
  { "kgt10.ru", true },
  { "kgv-schlauroth.de", true },
  { "khaganat.net", true },
  { "khairul-zamri.com", false },
  { "khakasiya.ml", true },
  { "khakasiya.tk", true },
  { "khakassia.cf", true },
  { "khakassia.ga", true },
  { "khakassia.gq", true },
  { "khakassia.tk", true },
  { "khaledgarbaya.net", false },
  { "khamphafood.com", true },
  { "khanovaskola.cz", true },
  { "khas.co.uk", true },
  { "khasiatmanfaat.com", true },
  { "khedmatazma.com", true },
  { "kheshtar.pl", true },
  { "khetmaal.com", true },
  { "khetzal.info", true },
  { "khg-orchester.de", true },
  { "khipu.com", true },
  { "khmb.ru", false },
  { "khmh.co.uk", true },
  { "khojhealth.com", true },
  { "khokey.com", true },
  { "khorne.me", true },
  { "khoury-dulla.ch", true },
  { "khouryalexandre.com", false },
  { "khramtsov.org", true },
  { "khs1994.com", true },
  { "khslaw.com", true },
  { "khudothiswanpark.vn", true },
  { "khushiandjoel.com", true },
  { "kiadoapartman.hu", true },
  { "kiahalchemy.com", true },
  { "kiahoriane.com", true },
  { "kiano.net", true },
  { "kiarayoga.com", true },
  { "kibibit.net", true },
  { "kibriscicek.net", true },
  { "kick-in.nl", true },
  { "kickasscanadians.ca", true },
  { "kickedmycat.com", true },
  { "kickingpixels.com.au", true },
  { "kickstart.com.pk", false },
  { "kicou.info", false },
  { "kiczela.eu", true },
  { "kidaptive.com", true },
  { "kiddieschristian.academy", true },
  { "kiddyboom.ua", true },
  { "kidneydonation.com", true },
  { "kids-castles.com", true },
  { "kids-world.dk", true },
  { "kidsareatrip.com", true },
  { "kidsclub.photos", true },
  { "kidsdaysout.co.uk", true },
  { "kidsdinefree.com", true },
  { "kidsforsavingearth.org", true },
  { "kidsinwoods-interfacesouth.org", true },
  { "kidsneversleep.com", false },
  { "kidspaper.nl", true },
  { "kidsphysiotherapy.co.uk", true },
  { "kidsplay-plymouth.co.uk", true },
  { "kidsplaybouncycastles.co.uk", true },
  { "kidswallstickers.com.au", true },
  { "kidtoyshop.ru", true },
  { "kidzpartiesllp.co.uk", true },
  { "kidzsmile.co.uk", true },
  { "kiebel.de", true },
  { "kiekin.org", true },
  { "kiekko.pro", true },
  { "kieran.de", true },
  { "kieskundig.nl", true },
  { "kiesuwkerstkaart.nl", true },
  { "kigmbh.com", true },
  { "kii91.com", true },
  { "kiir.net", true },
  { "kiisu.club", true },
  { "kik.ee", true },
  { "kikbb.com", true },
  { "kiki-voice.jp", true },
  { "kiknudes.co", true },
  { "kilbi-reussbuehl.ch", true },
  { "kilianvalkhof.com", true },
  { "kiliframework.org", true },
  { "kill.trade", true },
  { "killaraapartments.com.au", true },
  { "killdeer.com", true },
  { "killerkink.net", true },
  { "killerrobots.com", true },
  { "killymoonbouncycastles.com", true },
  { "kilo-files.tk", true },
  { "kilobyte22.de", true },
  { "kilogram.nl", true },
  { "kilometertje.nl", true },
  { "kimathilegal.com", true },
  { "kimbal.co.uk", true },
  { "kimberleythomson.tk", true },
  { "kimdumaine.com", true },
  { "kimiris.com", true },
  { "kimis.gr", true },
  { "kimisia.net", true },
  { "kimitang.com", true },
  { "kimkuhlmanphoto.com", true },
  { "kimkyzcrs.com", true },
  { "kimmel.com", false },
  { "kimmel.in", true },
  { "kimochi.info", true },
  { "kimono-rental-one.com", true },
  { "kimotodental.com", true },
  { "kimsnagelstudio.nl", true },
  { "kimtran.kim", true },
  { "kimtstore.com", true },
  { "kin-to-kin.ca", true },
  { "kinaesthetics-forschung.net", true },
  { "kinautas.com", true },
  { "kindconcentrates.com", false },
  { "kinderarzt-berlin-zia.de", true },
  { "kinderbasar-luhe.de", true },
  { "kinderchor-bayreuth.de", true },
  { "kinderergotherapie-ik.nl", true },
  { "kinderkleding.news", true },
  { "kinderopvangthuis.nl", true },
  { "kinderpneumologie.ch", true },
  { "kindertagespflege-rasselbande-halle.de", true },
  { "kindertherapie-wesel.de", true },
  { "kinderzahn-bogenhausen.de", true },
  { "kindesfreude.ch", true },
  { "kindlezs.com", true },
  { "kine-duthil.fr", true },
  { "kinepolis-studio.be", true },
  { "kinerd.me", true },
  { "kinesiomed-cryosauna.gr", true },
  { "kinetiq.com", true },
  { "kinfolkcoffee.com", true },
  { "king-of-the-castles.com", true },
  { "kingant.net", true },
  { "kinganywhere.eu", true },
  { "kingdoms.gg", true },
  { "kingfast.eu.org", true },
  { "kingiescastles.co.uk", true },
  { "kingjamesbibleonline.org", true },
  { "kingjamesgospel.com", true },
  { "kinglier.ga", true },
  { "kingofshooting.com", true },
  { "kingofthecastlecoventry.co.uk", true },
  { "kingofthecastlesentertainments.co.uk", true },
  { "kingofthecastlesouthwales.co.uk", true },
  { "kingofthecastlesrhyl.co.uk", true },
  { "kingsblueblue.com", true },
  { "kingsfoot.com", true },
  { "kingsgateseptic.com", true },
  { "kingshome.gr", true },
  { "kingsofkauffman.com", true },
  { "kingstake.network", true },
  { "kingtreeexperts.com", true },
  { "kingwoodtxlocksmith.com", true },
  { "kini24.ru", true },
  { "kinkcafe.net", true },
  { "kinkenonline.com", true },
  { "kinkyhookup.com", true },
  { "kinmunity.com", true },
  { "kinnikinnick.com", true },
  { "kinniyaonlus.com", false },
  { "kino-doma.tk", true },
  { "kinocheck.de", true },
  { "kinodrom.kiev.ua", true },
  { "kinodrom.tk", true },
  { "kinohled.cz", true },
  { "kinomagia.cf", true },
  { "kinos.nl", true },
  { "kinosha.tk", true },
  { "kinoshki.ga", true },
  { "kinothek.at", true },
  { "kinovsem.ml", true },
  { "kinozal-tv.appspot.com", true },
  { "kinozone.tk", true },
  { "kinsights.com", false },
  { "kinsmenhomelottery.com", true },
  { "kintana.ovh", true },
  { "kintone.com", true },
  { "kintore.tv", true },
  { "kiocloud.com", true },
  { "kiomara.com", true },
  { "kionetworks.es", true },
  { "kiot.eu", true },
  { "kiousis.me", true },
  { "kip-ribbetjes-bestellen.be", true },
  { "kipa.at", true },
  { "kipiradio.com", true },
  { "kippenbart.gq", true },
  { "kipsu.com", true },
  { "kipwells32.com", true },
  { "kiragameforum.net", true },
  { "kirainmoe.com", true },
  { "kiraku.co", true },
  { "kirbear.com", true },
  { "kirchen-im-web.de", false },
  { "kirchenchor-olzheim.de", true },
  { "kirchengemeinde-markt-erlbach.de", true },
  { "kirchhoff-getraenke.de", true },
  { "kircp.com", true },
  { "kirei.se", true },
  { "kireilign.com", true },
  { "kirgistan.tk", true },
  { "kirig.ph", true },
  { "kirikira.moe", true },
  { "kirill.ws", true },
  { "kirillaristov.com", true },
  { "kirillpokrovsky.de", true },
  { "kirinas.com", true },
  { "kirinuki.jp", true },
  { "kirkae.com", true },
  { "kirkforcongress.com", true },
  { "kirkforillinois.com", true },
  { "kirklandtriallawyer.com", true },
  { "kirkwood-smith.com", true },
  { "kirkwoodfence.com", true },
  { "kiro-ku.com", true },
  { "kiropraktorvard.se", true },
  { "kirov.ml", true },
  { "kirovcity.tk", true },
  { "kirovgrad.tk", true },
  { "kirrie.pe.kr", true },
  { "kirsch-gestaltung.de", true },
  { "kirschbaum.me", true },
  { "kirscrb.ru", true },
  { "kirstenbos.ca", true },
  { "kirstin-peters.de", true },
  { "kirwandigital.com", true },
  { "kisallatorvos.hu", true },
  { "kisel.org", true },
  { "kisiselveri.com", true },
  { "kiskeedeesailing.com", true },
  { "kisma.de", true },
  { "kisser.name", true },
  { "kissflow.com", true },
  { "kissgyms.com", true },
  { "kisskiss.ch", true },
  { "kissmycreative.com", true },
  { "kissoft.ro", true },
  { "kita-freie-schule.de", true },
  { "kita-sun.com", true },
  { "kitabmimpi.com", true },
  { "kitabnamabayi.com", true },
  { "kitacoffee.com", true },
  { "kitchen-profi.by", true },
  { "kitchen-profi.com.ua", true },
  { "kitchen-profi.kz", true },
  { "kitchenpunx.com", false },
  { "kitchenwarestore.xyz", true },
  { "kiteadventure.nl", true },
  { "kiteschooledam.nl", true },
  { "kiteschoolijmuiden.nl", true },
  { "kiteschoolkatwijk.nl", true },
  { "kiteschoolnoordwijk.nl", true },
  { "kiteschoolschellinkhout.nl", true },
  { "kiteschoolwijkaanzee.nl", true },
  { "kiteschoolzandvoort.nl", true },
  { "kitevalley.tk", true },
  { "kitpartners.com", true },
  { "kitsapsolutions.com", true },
  { "kittmedia.com", true },
  { "kittpress.com", true },
  { "kiumie.com", true },
  { "kivitelezesbiztositas.hu", true },
  { "kiwi.digital", true },
  { "kiwi.wiki", true },
  { "kiwibird.tokyo", true },
  { "kiwiflowershop.com.ua", true },
  { "kiyotatsu.com", true },
  { "kizomba.info", true },
  { "kizzedbykelz.com", true },
  { "kj-prince.com", true },
  { "kj1396.net", true },
  { "kj1397.com", true },
  { "kjaer.io", true },
  { "kjarrval.is", true },
  { "kjchernov.info", true },
  { "kjellner.com", true },
  { "kjelltitulaer.com", true },
  { "kjellvn.net", true },
  { "kjfaudio.com", true },
  { "kjmedia.dk", true },
  { "kjnotes.com", true },
  { "kk-neudorf-duissern.de", false },
  { "kk.in.th", true },
  { "kk.sb", true },
  { "kkcinemas.in", true },
  { "kki.org", true },
  { "kkovacs.eu", true },
  { "kkr-bridal.net", true },
  { "kks-karlstadt.de", true },
  { "kksg.com", true },
  { "kkyy.me", true },
  { "kkzxak47.com", true },
  { "kl-diaetist.dk", true },
  { "klaasmeijerbodems.nl", true },
  { "klaim.us", true },
  { "klanggut.at", true },
  { "klarika.com", true },
  { "klarmobil-empfehlen.de", true },
  { "klassika.tk", true },
  { "klauke-enterprises.com", true },
  { "klausbrinch.dk", false },
  { "klausen.dk", true },
  { "klauswissmann.com", true },
  { "klaver.it", true },
  { "klaw.xyz", true },
  { "klaxon.me", true },
  { "klcreations.co.uk", true },
  { "kle.cz", true },
  { "kleaning.by", true },
  { "klebeband.eu", true },
  { "klebetape.de", true },
  { "kleidermarkt-vintage.de", true },
  { "kleim.fr", true },
  { "kleinblogje.nl", false },
  { "kleine-dingen.nl", true },
  { "kleine-strandburg-heringsdorf.de", true },
  { "kleine-strandburg.com", true },
  { "kleine-strolche-lich.de", true },
  { "kleine-viecherei.de", true },
  { "kleineanfragen.de", true },
  { "kleinestrandburg-heringsdorf.de", true },
  { "kleinestrandburg-usedom.de", true },
  { "kleineviecherei.de", true },
  { "kleinhaneveld.tk", true },
  { "kleinreich.de", true },
  { "kleinsys.com", true },
  { "kleintransporte.net", true },
  { "klemkow.net", true },
  { "klemkow.org", true },
  { "klempin.net", true },
  { "klempin.se", true },
  { "kleor.com", true },
  { "kleppe.co", true },
  { "kleteckova.cz", true },
  { "klev.su", true },
  { "kleyer.eu", true },
  { "kli.is", true },
  { "klickstdu.com", true },
  { "kliemann.me", true },
  { "klimaloven.no", true },
  { "klimapartner.de", true },
  { "klimmzugstange-fitness.de", true },
  { "klingenundmesser.com", true },
  { "klinik-fuer-aesthetische-zahnheilkunde.de", true },
  { "klinikac.co.id", false },
  { "klinkenberg.ws", true },
  { "klishyn.com", true },
  { "klitmoeller.de", true },
  { "klitmoeller.dk", true },
  { "kliu.io", true },
  { "klm-huisjes.nl", true },
  { "klmhouses.com", true },
  { "klocast.com", true },
  { "klocker-ausserlechner.com", true },
  { "klocksnack.se", false },
  { "kloclabs.com", true },
  { "kloia.com", true },
  { "klop.info", true },
  { "klose.family", true },
  { "klosko.net", true },
  { "kloudboy.com", true },
  { "klssn.com", true },
  { "klu.io", true },
  { "klub.tk", true },
  { "kluck.me", true },
  { "klugemedia.de", true },
  { "klumba.org", true },
  { "klustermedia.com", true },
  { "klusweb-merenwijk.nl", true },
  { "klva.cz", true },
  { "kmashworth.co.uk", true },
  { "kmkz.jp", true },
  { "kmucsu.com", true },
  { "kn007.net", true },
  { "kn40la.com", true },
  { "kn4ivj.com", true },
  { "kn4ola.com", true },
  { "knab-networks.com", true },
  { "knapp.noip.me", true },
  { "knarcraft.net", true },
  { "kncg.pw", true },
  { "kndkv.com", true },
  { "kndrd.io", true },
  { "kneblinghausen.de", true },
  { "knechtology.com", true },
  { "knegten-agilis.com", true },
  { "kneli.co.il", true },
  { "knep.me", true },
  { "kneppe.me", true },
  { "knetterbak.nl", true },
  { "kngk-azs.ru", true },
  { "kngk-group.ru", true },
  { "kngk.org", true },
  { "kngkng.com", true },
  { "knightsbridge.net", true },
  { "knightsbridgewine.com", true },
  { "knihovnajablonne.cz", true },
  { "knip.ch", true },
  { "knispel-online.de", true },
  { "knitfarious.com", true },
  { "knmv.nl", true },
  { "knnet.ch", true },
  { "knoji.com", true },
  { "knop.info", false },
  { "knowarth.com", true },
  { "knowledgebuilds.com", true },
  { "knowledgehook.com", true },
  { "knowyourday.ai", true },
  { "knoxvilleimplants.com", true },
  { "knrt.de", true },
  { "knrt.eu", true },
  { "knthost.com", true },
  { "knulla.me", true },
  { "knulle.me", true },
  { "knurps.de", true },
  { "knuterikskare.no", true },
  { "knuthildebrandt.de", false },
  { "knygos.lt", true },
  { "ko-sys.com", true },
  { "koalas.org", true },
  { "koba.jp", true },
  { "kobejet.com", true },
  { "kobofarm.com", true },
  { "kobolya.hu", true },
  { "kobudo49.fr", true },
  { "kochbar.de", true },
  { "kocherev.org", true },
  { "kochereva.com", true },
  { "kochhar.net", true },
  { "kochinke.com", true },
  { "kochinke.us", true },
  { "kocka.cf", true },
  { "kocka.tech", true },
  { "kockanakocko.si", true },
  { "kodak-ism.com", true },
  { "kodamail.com", true },
  { "kodden.com.br", true },
  { "kode-it.de", true },
  { "kode.ch", false },
  { "kodify.net", true },
  { "kodkollen.com", true },
  { "kodkollen.se", true },
  { "kodomo.live", true },
  { "koe.hn", true },
  { "koebbes.de", true },
  { "koecollege.com", true },
  { "koeeusa.org", true },
  { "koef.nl", true },
  { "koehlhoff.de", true },
  { "koehn.com", true },
  { "koeldezomerdoor.nl", true },
  { "koelnmafia.de", true },
  { "koenigsbrunner-tafel.de", true },
  { "koenleemans.nl", true },
  { "koenrh.com", true },
  { "koenrh.net", true },
  { "koenrh.nl", true },
  { "koenrouwhorst.com", true },
  { "koenrouwhorst.nl", true },
  { "koenzk.nl", true },
  { "koerperkult.ch", true },
  { "koertner-muth.com", true },
  { "koertner-muth.de", true },
  { "koethen-markt.de", true },
  { "koetjesenkanker.nl", true },
  { "koffie-enzo.com", true },
  { "koflegend.com", true },
  { "kofler.info", true },
  { "kogak.ninja", true },
  { "kogax.com", true },
  { "kogi.fr", true },
  { "kogro.de", true },
  { "kogudesi.com", true },
  { "kohlchan.net", true },
  { "koho.fi", true },
  { "kohoutsautomotive.com", true },
  { "kohsandra.com", false },
  { "kohu.nz", true },
  { "koi-lexikon.de", true },
  { "koicenter-thuine.de", true },
  { "koifish.org", true },
  { "koji-tsujitani.net", true },
  { "kojip.com", true },
  { "kojy.fr", true },
  { "koka-shop.de", true },
  { "koketteriet.se", true },
  { "koki.cl", true },
  { "kokobaba.com", true },
  { "kokomu.com", true },
  { "kokona.ch", true },
  { "kokosnusswasser.de", true },
  { "kokumoto.com", true },
  { "kolania.de", true },
  { "kolania.net", true },
  { "kolaprestaurant.com", true },
  { "kolas.in", true },
  { "kolbeinsson.se", true },
  { "kolcsey.eu", true },
  { "kolibrisolutions.nl", true },
  { "kolin.org", true },
  { "kolitel.com", true },
  { "kolizaskrap.bg", true },
  { "kolja-engelmann.de", true },
  { "kolkataflowermall.com", true },
  { "kolkinn.no", true },
  { "kollect.ie", true },
  { "kollega.it", true },
  { "kollegamenti.it", true },
  { "kollross.io", true },
  { "kolmann.at", true },
  { "kolmann.eu", true },
  { "kolpingsfamilie-vechta-maria-frieden.de", true },
  { "kolrami.com", true },
  { "koluke.co", true },
  { "koluke.com", true },
  { "komall.net", true },
  { "komelin.com", true },
  { "komenamanda.de", true },
  { "kometia.com", true },
  { "komicloud.com", true },
  { "komidoc.com", true },
  { "komiksbaza.pl", true },
  { "kominfo.go.id", true },
  { "kominfo.net", false },
  { "kominki-sauny.pl", true },
  { "komintek.ru", true },
  { "komischkeszeug.de", true },
  { "kommaer.dk", true },
  { "kommune42.org", true },
  { "kommunermeddnssec.se", true },
  { "kommunermedipv6.se", true },
  { "kommx.de", true },
  { "komoju.com", true },
  { "komok.co.uk", true },
  { "komp247.pl", true },
  { "kompetenzkurs.de", true },
  { "komplet.sk", true },
  { "kon-sil.de", true },
  { "kondi.net", true },
  { "kondomshop.org", true },
  { "kondou-butsudan.com", true },
  { "konfekcjonowanie.com", true },
  { "kongar.org", true },
  { "kongress-hostessen.de", true },
  { "koniecfica.sk", false },
  { "konijntjes.nl", true },
  { "konings.it", false },
  { "koningskwartiertje.nl", true },
  { "konklone.com", true },
  { "konosuke.jp", true },
  { "konplott.shop", true },
  { "konpyuta.nl", true },
  { "konst.se", true },
  { "konstanz.tk", true },
  { "konstructdigital.com", true },
  { "konsul.tk", true },
  { "kontaxis.org", true },
  { "kontorhaus-stralsund.de", true },
  { "konventa.net", true },
  { "konyaescortsiteler.net", true },
  { "konyalian.com", true },
  { "konzertheld.de", true },
  { "koodaklife.com", true },
  { "koodimasin.ee", true },
  { "koodimasin.eu", true },
  { "kooer.org", true },
  { "koof.win", true },
  { "koolauwomenshealthcare.com", true },
  { "koolerbythelake.org", true },
  { "kooli.ee", true },
  { "koolikatsed.ee", true },
  { "koolitee.ee", true },
  { "kooliveeb.ee", true },
  { "koop-bremen.de", true },
  { "kooponline.eu", true },
  { "koot.nl", true },
  { "kooxdiving.com", true },
  { "koozal.de", true },
  { "kopfgeld.tk", true },
  { "kopfkrieg.org", true },
  { "kopfundseele.de", true },
  { "kopidingin.xyz", true },
  { "kopjethee.nl", true },
  { "koplancpa.com", true },
  { "koplax-online.com", true },
  { "kopplin.family", true },
  { "koptev.ru", true },
  { "kopteva.ru", true },
  { "korancode.tk", true },
  { "korbel-loziska.cz", true },
  { "korben.info", true },
  { "kordamed.ee", true },
  { "korea-dpr.org", true },
  { "korea.dating", true },
  { "koreaboo.com", true },
  { "koreaninhd.com", true },
  { "koreanrandom.com", true },
  { "koreanrandom.ru", true },
  { "koretech.nl", true },
  { "korinar.com", true },
  { "kornrunner.net", true },
  { "korob-ok.com.ua", true },
  { "korobkovsky.ru", false },
  { "koroknaimedical.hu", true },
  { "koroleva.ml", true },
  { "korosiprogram.hu", true },
  { "korp.fr", true },
  { "korrelzout.nl", true },
  { "kortgebyr.dk", true },
  { "korund.tk", true },
  { "korup.com", true },
  { "koryfi.com", true },
  { "kos4all.com", true },
  { "koscielniak-nieruchomosci.pl", true },
  { "kosherjava.com", true },
  { "kosho.org", true },
  { "kosinc.org", true },
  { "kosmos.org.tw", true },
  { "kosmosfestival.tk", true },
  { "kost-magazin.de", true },
  { "kostal.com", true },
  { "kostecki.com", true },
  { "kostecki.org", true },
  { "kostecki.tel", true },
  { "kostya.ws", true },
  { "kosuzu.moe", true },
  { "kother.org", true },
  { "kotilinkki.fi", true },
  { "kotitesti.fi", true },
  { "kotke.ru", true },
  { "kotly-marten.com.ua", true },
  { "kotobox.net", true },
  { "kotois.com", true },
  { "kotomei.moe", true },
  { "kotonoha.cafe", true },
  { "kotori.love", true },
  { "kotuwa.tk", true },
  { "kouki-food.com", true },
  { "koumakan.cc", true },
  { "koumuwin.com", true },
  { "koushinjo.org", true },
  { "kouten-jp.com", true },
  { "kov.space", true },
  { "kovachica.tk", true },
  { "koval.io", true },
  { "kovals.sk", true },
  { "kovehitus.ee", true },
  { "kovspace.com", true },
  { "kowalmik.tk", true },
  { "kowalstwo.com.pl", true },
  { "kowarschick.de", true },
  { "koyo.kr", true },
  { "kozawa.tokyo", true },
  { "kozlekedes.info", true },
  { "kozuch.biz", true },
  { "kp0808.cc", true },
  { "kp0809.com", true },
  { "kpfanworld.com", true },
  { "kpforme.org", true },
  { "kpinvest.eu", true },
  { "kplasticsurgery.com", true },
  { "kplnet.net", true },
  { "kpmgclientcollab.co.nz", true },
  { "kpop.re", true },
  { "kpopsource.com", true },
  { "kprem.com", true },
  { "kpumuk.info", true },
  { "kr.cm", true },
  { "kr.search.yahoo.com", false },
  { "kr0n.dk", true },
  { "krachtinverbinding.nl", true },
  { "kradalby.no", true },
  { "kraft.blog", true },
  { "kraft.im", true },
  { "kraftfleisch.de", true },
  { "kraftpc.com", true },
  { "kraftzeiten.de", true },
  { "krag.be", true },
  { "kraga.sk", true },
  { "kraken.io", true },
  { "kraken.site", true },
  { "krakozyabra.gq", true },
  { "kralik.io", true },
  { "kralovskapradelna.cz", true },
  { "kralovstvimap.cz", true },
  { "kram.nz", true },
  { "krambeutel.de", true },
  { "kramer-edelstahl.de", true },
  { "kramsj.uk", true },
  { "krang.org.uk", true },
  { "kranjnakolo.ml", true },
  { "krankenpflege-haushaltshilfe.de", true },
  { "krasnodar-avia.ru", true },
  { "krasnodar-pravoved.ru", true },
  { "krasnodar24.tk", true },
  { "krasovsky.me", true },
  { "kratochvilovi.net", true },
  { "krautomat.com", true },
  { "kravmagaangers.fr", true },
  { "kraynik.com", true },
  { "krayx.com", true },
  { "krazykastles.co.uk", true },
  { "krazykoolkastles.com", true },
  { "krazyphotobooths.co.uk", true },
  { "kreationnext.com", false },
  { "kreativbande.com", true },
  { "kreativelabs.ch", false },
  { "kreativklinik.at", true },
  { "kreativstrecke.de", true },
  { "kreatorbus.com", true },
  { "kredit-abzocke.com", true },
  { "kredita.dk", true },
  { "kreditkacs.cz", true },
  { "kreditkoll.nu", true },
  { "kredytzen.pl", true },
  { "kreen.org", true },
  { "krehl.io", true },
  { "kremalicious.com", true },
  { "kresimir-blazevic.tk", true },
  { "kretschmann.consulting", true },
  { "kreuzpfadfinder.de", true },
  { "kreyolgym.fr", true },
  { "kriechel.de", true },
  { "krikorianconstruction.com", true },
  { "krillz.se", true },
  { "krinetzki.de", true },
  { "kringloopwinkelsteenwijk.nl", true },
  { "krinnovations.ie", true },
  { "kriptokereso.com", true },
  { "kriptosec.com", true },
  { "kriptoworld.hu", true },
  { "kris.click", true },
  { "krise-chance.ch", true },
  { "krisftp.fr", true },
  { "krishnenduayur.org", true },
  { "krishofer.com", true },
  { "kriskras99.nl", true },
  { "krismurray.co.uk", true },
  { "krisstarkey.co.uk", true },
  { "kristall-energie.at", true },
  { "kristiehill.com", true },
  { "kristikala.nl", true },
  { "kristinbailey.com", true },
  { "kristofba.ch", true },
  { "kristofdv.be", true },
  { "kritikahotels.com", true },
  { "kritikawebu.cz", true },
  { "kritikos.io", true },
  { "krizevci.info", true },
  { "krmeni.cz", false },
  { "kroell.net", true },
  { "krokedil.se", true },
  { "kromamoveis.com.br", true },
  { "kromax.it", true },
  { "kromonos.net", true },
  { "kroon.email", true },
  { "kropkait.pl", true },
  { "krossakorven.tk", true },
  { "krovatka.tk", true },
  { "kroy.io", true },
  { "krrn.de", false },
  { "krsaustralia.com.au", true },
  { "krsn.de", true },
  { "krsvrs.nl", true },
  { "krugersdorpplumber24-7.co.za", true },
  { "kruin.net", true },
  { "kruisselbrink.com", true },
  { "kruk.co", true },
  { "krumberconsulting.com", true },
  { "krumpf.de", true },
  { "krupa.net.pl", false },
  { "krupacars.pl", true },
  { "kruselegal.com.au", true },
  { "krutka.cz", true },
  { "kry.no", true },
  { "kry.se", true },
  { "kryglik.com", true },
  { "krypsys.com", true },
  { "krypt.com", true },
  { "kryptera.se", true },
  { "krypto-geld.eu", true },
  { "kryptologie.tk", true },
  { "kryptomech.com", true },
  { "kryptux.xyz", true },
  { "kryx.de", true },
  { "krzyzowki123.pl", true },
  { "ks-watch.de", true },
  { "ks009.com", true },
  { "ks0098.com", true },
  { "ks016.com", true },
  { "ks0168.com", true },
  { "ks017.com", true },
  { "ks0188.com", true },
  { "ks023.com", true },
  { "ks0288.com", true },
  { "ks038.com", true },
  { "ks0388.com", true },
  { "ks05.cc", true },
  { "ks051.com", true },
  { "ks053.com", true },
  { "ks0550.com", true },
  { "ks0558.com", true },
  { "ks0566.com", true },
  { "ks0577.com", true },
  { "ks058.com", true },
  { "ks0588.com", true },
  { "ks059.com", true },
  { "ks0599.com", true },
  { "ks06.cc", true },
  { "ks061.com", true },
  { "ks0618.com", true },
  { "ks062.com", true },
  { "ks063.com", true },
  { "ks065.com", true },
  { "ks0660.com", true },
  { "ks0668.com", true },
  { "ks068.com", true },
  { "ks0688.com", true },
  { "ks0718.com", true },
  { "ks0766.com", true },
  { "ks0768.com", true },
  { "ks0770.com", true },
  { "ks0776.com", true },
  { "ks0778.com", true },
  { "ks078.com", true },
  { "ks0788.com", true },
  { "ks080.com", true },
  { "ks081.com", true },
  { "ks0816.com", true },
  { "ks082.com", true },
  { "ks0855.com", true },
  { "ks0858.com", true },
  { "ks086.com", true },
  { "ks0877.com", true },
  { "ks0878.com", true },
  { "ks0886.com", true },
  { "ks093.com", true },
  { "ks096.com", true },
  { "ks0977.com", true },
  { "ks098.com", true },
  { "ks0990.com", true },
  { "ks0996.com", true },
  { "ks10.ag", true },
  { "ks10.vip", true },
  { "ks105.com", true },
  { "ks15.net", true },
  { "ks1519.com", true },
  { "ks16.cc", true },
  { "ks16.net", true },
  { "ks1608.com", true },
  { "ks161.com", true },
  { "ks162.com", true },
  { "ks18.cc", true },
  { "ks182.com", true },
  { "ks191.com", true },
  { "ks20.vip", true },
  { "ks200.vip", true },
  { "ks2000.vip", true },
  { "ks202.com", true },
  { "ks2020.vip", true },
  { "ks204.com", true },
  { "ks206.com", true },
  { "ks208.com", true },
  { "ks2099.com", true },
  { "ks257.com", true },
  { "ks262.com", true },
  { "ks28.cc", true },
  { "ks28.net", true },
  { "ks281.com", true },
  { "ks2888.com", true },
  { "ks2888.net", true },
  { "ks291.com", true },
  { "ks299.net", true },
  { "ks30.vip", true },
  { "ks308.com", true },
  { "ks32.cc", true },
  { "ks329.com", true },
  { "ks330.com", true },
  { "ks335.com", true },
  { "ks335.net", true },
  { "ks337.net", true },
  { "ks339.net", true },
  { "ks36.net", true },
  { "ks3636.com", true },
  { "ks3737.com", true },
  { "ks380.com", true },
  { "ks381.com", true },
  { "ks388.com", true },
  { "ks3888.com", true },
  { "ks3939.com", true },
  { "ks40.vip", true },
  { "ks410.com", true },
  { "ks50.vip", true },
  { "ks5000.com", true },
  { "ks502.com", true },
  { "ks503.com", true },
  { "ks509.com", true },
  { "ks515.com", true },
  { "ks516.com", true },
  { "ks531.com", true },
  { "ks539.com", true },
  { "ks541.com", true },
  { "ks549.com", true },
  { "ks55.net", true },
  { "ks571.com", true },
  { "ks58.net", true },
  { "ks5808.com", true },
  { "ks5888.com", true },
  { "ks5888.net", true },
  { "ks597.com", true },
  { "ks60.vip", true },
  { "ks600.com", true },
  { "ks6008.com", true },
  { "ks608.com", true },
  { "ks610.com", true },
  { "ks6225.com", true },
  { "ks628.com", true },
  { "ks629.com", true },
  { "ks635.com", true },
  { "ks636.com", true },
  { "ks637.com", true },
  { "ks641.com", true },
  { "ks6522.com", true },
  { "ks6525.com", true },
  { "ks6533.com", true },
  { "ks6535.com", true },
  { "ks657.com", true },
  { "ks66.la", true },
  { "ks6600.com", true },
  { "ks6601.com", true },
  { "ks6602.com", true },
  { "ks6603.com", true },
  { "ks6605.com", true },
  { "ks6607.com", true },
  { "ks6609.com", true },
  { "ks6612.com", true },
  { "ks6615.com", true },
  { "ks6617.com", true },
  { "ks6618.com", true },
  { "ks6619.com", true },
  { "ks6620.com", true },
  { "ks6621.com", true },
  { "ks6623.com", true },
  { "ks6625.com", true },
  { "ks6626.com", true },
  { "ks6627.com", true },
  { "ks6628.com", true },
  { "ks6629.com", true },
  { "ks6630.com", true },
  { "ks6631.com", true },
  { "ks6632.com", true },
  { "ks6635.com", true },
  { "ks6637.com", true },
  { "ks6638.com", true },
  { "ks6650.com", true },
  { "ks6651.com", true },
  { "ks6652.com", true },
  { "ks6653.com", true },
  { "ks6656.com", true },
  { "ks6657.com", true },
  { "ks6658.com", true },
  { "ks6659.com", true },
  { "ks6665.com", true },
  { "ks6670.com", true },
  { "ks6671.com", true },
  { "ks668.com", true },
  { "ks6681.com", true },
  { "ks6685.com", true },
  { "ks6686.com", true },
  { "ks6687.com", true },
  { "ks6733.com", true },
  { "ks6735.com", true },
  { "ks6799.com", true },
  { "ks68.net", true },
  { "ks680.com", true },
  { "ks6800.com", true },
  { "ks6805.com", true },
  { "ks6806.com", true },
  { "ks6807.com", true },
  { "ks6808.com", true },
  { "ks6809.com", true },
  { "ks681.com", true },
  { "ks6810.com", true },
  { "ks6812.com", true },
  { "ks6813.com", true },
  { "ks6815.com", true },
  { "ks6816.com", true },
  { "ks6817.com", true },
  { "ks6819.com", true },
  { "ks6820.com", true },
  { "ks6821.com", true },
  { "ks6822.com", true },
  { "ks6823.com", true },
  { "ks6825.com", true },
  { "ks6826.com", true },
  { "ks6827.com", true },
  { "ks6828.com", true },
  { "ks6829.com", true },
  { "ks6830.com", true },
  { "ks6831.com", true },
  { "ks6832.com", true },
  { "ks6833.com", true },
  { "ks6835.com", true },
  { "ks6836.com", true },
  { "ks6837.com", true },
  { "ks6838.com", true },
  { "ks6839.com", true },
  { "ks6850.com", true },
  { "ks6851.com", true },
  { "ks6852.com", true },
  { "ks6853.com", true },
  { "ks6857.com", true },
  { "ks6860.com", true },
  { "ks6861.com", true },
  { "ks6862.com", true },
  { "ks6863.com", true },
  { "ks6867.com", true },
  { "ks6870.com", true },
  { "ks6871.com", true },
  { "ks6880.com", true },
  { "ks6887.com", true },
  { "ks695.com", true },
  { "ks698.com", true },
  { "ks6998.com", true },
  { "ks70.vip", true },
  { "ks7272.com", true },
  { "ks7373.com", true },
  { "ks8.ag", true },
  { "ks8.net", true },
  { "ks80.vip", true },
  { "ks806.com", true },
  { "ks8086.com", true },
  { "ks81.cc", true },
  { "ks8126.com", true },
  { "ks8127.com", true },
  { "ks86.cc", true },
  { "ks86.net", true },
  { "ks8600.com", true },
  { "ks8787.com", true },
  { "ks88.ag", true },
  { "ks88.best", true },
  { "ks88.com", true },
  { "ks88.org", true },
  { "ks8802.com", true },
  { "ks8805.com", true },
  { "ks8812.com", true },
  { "ks8819.com", true },
  { "ks8825.com", true },
  { "ks883.com", true },
  { "ks8831.com", true },
  { "ks8851.com", true },
  { "ks8852.com", true },
  { "ks8860.com", true },
  { "ks888.ag", true },
  { "ks888.la", true },
  { "ks8881.com", true },
  { "ks8882.com", true },
  { "ks8883.com", true },
  { "ks8892.com", true },
  { "ks8895.com", true },
  { "ks89.cc", true },
  { "ks89.net", true },
  { "ks8915.com", true },
  { "ks90.vip", true },
  { "ks902.com", true },
  { "ks905.com", true },
  { "ks907.com", true },
  { "ks912.com", true },
  { "ks921.com", true },
  { "ks9211.com", true },
  { "ks9393.com", true },
  { "ks958.com", true },
  { "ks98.cc", true },
  { "ks9888.com", true },
  { "ks996.com", true },
  { "ksbet.ag", true },
  { "kscarlett.com", true },
  { "kschv-rdeck.de", true },
  { "kselenia.ee", true },
  { "ksero.center", true },
  { "ksero.wroclaw.pl", true },
  { "ksham.net", true },
  { "kshlm.in", true },
  { "ksmmmo.org.tr", true },
  { "ksoc.com", true },
  { "ksopp.si", true },
  { "kssk.de", true },
  { "kst-service.tk", true },
  { "kstr.us", true },
  { "ksukelife.com", true },
  { "ksvip10.com", true },
  { "kt-events.de", true },
  { "kt-zoe.com", true },
  { "kt3i.com", true },
  { "ktbnetbank.com", true },
  { "kthnxbai.xyz", true },
  { "ktm-troxler.de", true },
  { "ktmclubitalia.it", true },
  { "kts-thueringen.de", true },
  { "ktsee.eu.org", true },
  { "ktuluweb.tk", true },
  { "ktw.lv", true },
  { "ku-7.club", true },
  { "kuadey.com", true },
  { "kuaikan1.com", true },
  { "kuaimen.bid", true },
  { "kuaiyaojing.com", true },
  { "kualiti.net", true },
  { "kualo.co.uk", true },
  { "kualo.com", true },
  { "kualo.in", true },
  { "kuaza.com", true },
  { "kub.hr", true },
  { "kubabrussel.be", true },
  { "kubanitoscali.com", true },
  { "kubkprf.ru", true },
  { "kublis.ch", true },
  { "kuchen-am-stiel.de", true },
  { "kucnibudzet.com", true },
  { "kudinilam.tk", true },
  { "kuditel.net", true },
  { "kudo.co.id", true },
  { "kuechenprofi-group.de", false },
  { "kuechenserver.de", true },
  { "kuechenserver.org", true },
  { "kuehndel.org", true },
  { "kuehnel-bs.de", true },
  { "kuehnel-online.eu", true },
  { "kuemmerlin.eu", true },
  { "kuemmling.eu", true },
  { "kuhn-elektrotechnik.de", true },
  { "kuhne-electronic.de", true },
  { "kuhnelautorepair.com", true },
  { "kuhnerts.eu", true },
  { "kujadin.de", true },
  { "kukal.cz", true },
  { "kukeri-karlovo.tk", true },
  { "kuketz-blog.de", true },
  { "kuketz-security.de", true },
  { "kuketz-suche.de", true },
  { "kukoon.de", false },
  { "kulde.net", true },
  { "kulinaristi.fi", true },
  { "kulivps.com", true },
  { "kulpakko.com", true },
  { "kulthist.tk", true },
  { "kultsar.com", true },
  { "kulturmel.ch", true },
  { "kuma.es", true },
  { "kumachan.biz", true },
  { "kumalog.com", true },
  { "kumasanda.jp", true },
  { "kumpulannamabayi.com", true },
  { "kunaldesai.blog", true },
  { "kunda.ovh", true },
  { "kundenerreichen.com", true },
  { "kundenerreichen.de", true },
  { "kungerkueken.de", true },
  { "kunra.de", true },
  { "kunstdrucke-textildruck.de", true },
  { "kunsthandel-augustus-rex.de", true },
  { "kunstkieken.nl", true },
  { "kunstundunrat.de", true },
  { "kunzesoftware.com.br", true },
  { "kuoruan.com", true },
  { "kupaa.ink", true },
  { "kupferschmids.ch", true },
  { "kupferstichshop.com", true },
  { "kupiclub.com", true },
  { "kupid.com", true },
  { "kupiewszystkieauta.pl", true },
  { "kupimlot.ru", true },
  { "kupinska.pl", true },
  { "kupislivki.tk", true },
  { "kupleno.com", true },
  { "kuponydoher.cz", true },
  { "kupriy-coach.ru", true },
  { "kupschke.net", true },
  { "kupu.maori.nz", true },
  { "kurdishphotography.tk", true },
  { "kuretru.com", true },
  { "kurhotel-am-reischberg.de", true },
  { "kurido-anime.tk", true },
  { "kurierwilenski.lt", true },
  { "kurniadwin.to", true },
  { "kurofuku.me", true },
  { "kuroha.co.uk", true },
  { "kuroinu.jp", true },
  { "kuroisalva.xyz", false },
  { "kurona.ga", true },
  { "kuronekogaro.com", true },
  { "kurschies.de", true },
  { "kurserne.dk", true },
  { "kursk-otoplenie.ru", true },
  { "kurswahl-online.de", true },
  { "kursypolska.pl", true },
  { "kurtschlatzer.com", true },
  { "kuruma-ex.jp", true },
  { "kuruppa.xyz", true },
  { "kusadasiforum.com", true },
  { "kuscheln.com", true },
  { "kuschku.de", true },
  { "kuscu.co", true },
  { "kusdaryanto.web.id", true },
  { "kusochi.eu", true },
  { "kustod.io", true },
  { "kutinsoft.com", true },
  { "kutip.id", true },
  { "kutny.cz", true },
  { "kutsankaplan.com", true },
  { "kuttler.eu", true },
  { "kutus.ee", true },
  { "kuwichitagastro.com", true },
  { "kuwichitaim.com", true },
  { "kuznica.tk", true },
  { "kvadratnimeter.si", true },
  { "kvalita-1a.cz", true },
  { "kvalitetsaktiepodden.se", true },
  { "kvalitnitesneni.cz", true },
  { "kvantel.no", true },
  { "kvcc.com.au", true },
  { "kvest-v-moskve.ga", true },
  { "kvestiks.ru", true },
  { "kvetinymilt.cz", true },
  { "kvetinyumarkety.cz", true },
  { "kvhile.com", true },
  { "kvilt.dk", true },
  { "kvnsport.ru", true },
  { "kvpc.com.au", true },
  { "kwat.chat", true },
  { "kwbresidential.com", true },
  { "kwcolville.com", true },
  { "kweb.ml", true },
  { "kwedo.com", true },
  { "kwench.com", true },
  { "kwickshop.co.nz", true },
  { "kwoll.de", true },
  { "kwyxz.org", true },
  { "kx197.com", true },
  { "kxah35.com", true },
  { "kxnrl.com", true },
  { "kybi.sk", true },
  { "kycisrael.com", true },
  { "kydara.com", true },
  { "kyledrake.net", true },
  { "kylegutschow.com", true },
  { "kylejohnson.io", true },
  { "kylianvermeulen.com", true },
  { "kylie-pomada.tk", true },
  { "kylinj.com", false },
  { "kynaston.org.uk", true },
  { "kynastonwedding.co.uk", true },
  { "kyochon.fr", true },
  { "kyoko.org", true },
  { "kyosaku.org", true },
  { "kyoto-k9.com", false },
  { "kyoto-mic.com", true },
  { "kyoto-tomoshibi.jp", true },
  { "kyotokitsune.com", true },
  { "kyprexxo.com", true },
  { "kyras-castles.co.uk", true },
  { "kyrylych.tk", true },
  { "kys.host", true },
  { "kysil.org", true },
  { "kyunyuki.com", true },
  { "kyusyu.org", true },
  { "kyy.me", false },
  { "kz.search.yahoo.com", false },
  { "kzar.co.uk", true },
  { "kzmhk.cz", true },
  { "kzsdabas.hu", true },
  { "l-atelier-c.com", true },
  { "l-lab.org", true },
  { "l0re.com", true },
  { "l0v0l.com", true },
  { "l10n.site", true },
  { "l17r.eu", true },
  { "l214.com", true },
  { "l2guru.ru", true },
  { "l33te.net", true },
  { "l36533.com", true },
  { "l36594.com", true },
  { "l4n-clan.de", true },
  { "l66.io", true },
  { "l7plumbing.com.au", true },
  { "l7world.com", true },
  { "l81818.com", true },
  { "la-baldosa.fr", false },
  { "la-bolle.fr", true },
  { "la-compagnie-des-elfes.fr", true },
  { "la-fenice-neheim.de", true },
  { "la-ganiere.com", true },
  { "la-kaz-a-velo.fr", true },
  { "la-laitonnerie.com", true },
  { "la-maison.ch", false },
  { "la-maison.eu", true },
  { "la-manufacture-du-nettoyage.com", true },
  { "la-paco.tk", true },
  { "la-petite-entreprise.com", true },
  { "laab.gv.at", true },
  { "laan247.dk", true },
  { "laatikko.io", true },
  { "laatjeniethackmaken.nl", true },
  { "labandadelamente.tk", true },
  { "labande-annonce.fr", true },
  { "labanochjonas.se", true },
  { "labanote.com", true },
  { "labanskoller.se", true },
  { "labanskollermark.se", true },
  { "labastidedesaromes.com", true },
  { "labavn.com", true },
  { "labavn.org", true },
  { "labcenter.com", true },
  { "labcoat.jp", true },
  { "labeled.vn", true },
  { "labibikids.com.br", true },
  { "labiblioafronebrulepas.com", false },
  { "lablnet.tk", true },
  { "labobooks.com", true },
  { "laboiteare.fr", true },
  { "laboratoriodemarketingb3.com", true },
  { "labortogether.com", true },
  { "labouncycastlehire.co.uk", true },
  { "labourreedevergheas.fr", true },
  { "laboutiquedejuliette.com", true },
  { "labrat.mobi", false },
  { "labsys.xyz", true },
  { "labworks.org", true },
  { "laby.life", true },
  { "lacaey.se", true },
  { "lacantine.xyz", true },
  { "lacaveducinquantenaire.com", true },
  { "lacentral.com", false },
  { "lacetsfun.com", true },
  { "lacetsroses.ch", true },
  { "laceysfarm.ie", true },
  { "lachainedesentrepreneurs.fr", true },
  { "lachawoj.de", true },
  { "lachlan-harris.com", true },
  { "lachlan.com", true },
  { "lachlanallison.com", true },
  { "lachosetypo.com", true },
  { "lachyoga-schwieberdingen.de", true },
  { "lackierereischmitt.de", true },
  { "laclaque.ch", false },
  { "lacledeslan.com", false },
  { "lacledor.ch", false },
  { "laclefdor.ch", false },
  { "lacoast.gov", true },
  { "lacochinacounselor.com", true },
  { "lacocina.nl", true },
  { "lacoquette.gr", true },
  { "lacyc3.eu", true },
  { "lada-granta.tk", true },
  { "lada-plus.tk", true },
  { "ladadate.com", true },
  { "ladakhtrip.tours", true },
  { "ladanmokhtari.tk", true },
  { "ladbroke.net", false },
  { "ladenzeile.at", true },
  { "ladenzeile.de", true },
  { "ladiesofvietnam.net", true },
  { "ladislavbrezovnik.com", true },
  { "lado.ltd", true },
  { "ladocs.tk", true },
  { "ladotech.cn", true },
  { "ladotech.com", true },
  { "ladraiglaan.com", true },
  { "ladyanna.de", true },
  { "ladyofhopeparish.org", true },
  { "ladyofsongstv.com", true },
  { "laencina.tk", true },
  { "laermschmiede.de", true },
  { "laextra.mx", true },
  { "lafansite.tk", true },
  { "lafantasticatravel.com", true },
  { "lafayette-rushford.com", true },
  { "lafcheta.info", true },
  { "lafema.de", true },
  { "lafermegourmande.fr", true },
  { "lafillepolyvalente.ca", true },
  { "lafillepolyvalente.com", true },
  { "lafka.org", true },
  { "laflash.com", true },
  { "lagazzettadigitale.it", true },
  { "lagerauftrag.info", true },
  { "lagit.in", true },
  { "laglab.org", false },
  { "lagout.org", true },
  { "lagriffeduservice.fr", true },
  { "lagsoftware.com", true },
  { "laguinguette.fr", true },
  { "lagunakitchenandbath.com", true },
  { "lahipotesisgaia.com", true },
  { "lahnau-akustik.de", true },
  { "lahora.com.ec", true },
  { "lai.is", true },
  { "lai.zone", true },
  { "laibcoms.com", true },
  { "laimut.com", true },
  { "lain.at", true },
  { "laindonleisure.co.uk", true },
  { "lajkatheme.com", true },
  { "lakeandriverrestoration.com", true },
  { "lakedavid.com.au", true },
  { "lakeee.com", true },
  { "lakehavasuwebsites.com", true },
  { "lakelandbank.com", true },
  { "lakeoswegotowncar.com", true },
  { "lakersview.com", true },
  { "lakesherwoodelectric.com", true },
  { "lakesherwoodelectrical.com", true },
  { "lakesherwoodelectrician.com", true },
  { "lakesherwoodexteriorlighting.com", true },
  { "lakesherwoodlandscapelighting.com", true },
  { "lakesherwoodlighting.com", true },
  { "lakesherwoodoutdoorlighting.com", true },
  { "lakeshowlife.com", true },
  { "lakewoodcityglass.com", true },
  { "lakiernictwo.auto.pl", true },
  { "lakkt.de", true },
  { "lakonia.com.br", true },
  { "lalalab.com", true },
  { "lalaloe.be", true },
  { "lalaya.fr", true },
  { "laled.ch", false },
  { "lalegria.tk", true },
  { "lalucepulsata.it", true },
  { "lalucioledigitale.com", true },
  { "lalunecreative.com", true },
  { "lalyre-corcelles.ch", false },
  { "lamakat.de", true },
  { "lamaletarural.es", true },
  { "lamapoll.de", true },
  { "lamargheritalruoto.it", true },
  { "lamasacre.tk", true },
  { "lambangcapgiare.com", true },
  { "lambauer.com", true },
  { "lambda.sx", true },
  { "lambertshealthcare.co.uk", true },
  { "lambertz.xyz", true },
  { "lamboo.be", true },
  { "lamclam.site", true },
  { "lamconnect.com", true },
  { "lamikvah.org", true },
  { "laminine.info", true },
  { "laminsaho.tk", true },
  { "lammersmarketing.com", true },
  { "lamontre.ru", true },
  { "lamp.re", false },
  { "lamp24.se", true },
  { "lampade.it", true },
  { "lampara.es", true },
  { "lampegiganten.dk", true },
  { "lampegiganten.no", true },
  { "lampen24.be", true },
  { "lampen24.nl", true },
  { "lampenwelt.at", true },
  { "lampenwelt.ch", true },
  { "lampenwelt.de", true },
  { "lampposthomeschool.com", true },
  { "lampy.pl", true },
  { "lamujerquesoy.com", false },
  { "lamunyon.com", true },
  { "lan.biz.tr", true },
  { "lana.swedbank.se", true },
  { "lanahallen.com", true },
  { "lanbroa.eu", true },
  { "lancelafontaine.com", true },
  { "lancelhoff.com", true },
  { "lancemanion.com", true },
  { "lancers.jp", true },
  { "lanceyip.com", true },
  { "lancyvbc.ch", false },
  { "land.nrw", false },
  { "landassessmentservices.com", true },
  { "landbetweenthelakes.us", true },
  { "landchecker.com.au", true },
  { "landegge.nl", true },
  { "landflair-magazin.de", false },
  { "landhaus-christmann.de", true },
  { "landhaus-havelse.de", true },
  { "landinfo.no", true },
  { "landingear.com", true },
  { "landlordy.com", true },
  { "landofelves.net", false },
  { "landoncreekapartments.com", true },
  { "landsbankinn.com", true },
  { "landscape-photography.org", true },
  { "landscapelightingagoura.com", true },
  { "landscapelightingagourahills.com", true },
  { "landscapelightingcalabasas.com", true },
  { "landscapelightingcamarillo.com", true },
  { "landscapelightingconejovalley.com", true },
  { "landscapelightingdosvientos.com", true },
  { "landscapelightinghiddenhills.com", true },
  { "landscapelightinglakesherwood.com", true },
  { "landscapelightingmalibu.com", true },
  { "landscapelightingmoorpark.com", true },
  { "landscapelightingnewburypark.com", true },
  { "landscapelightingoakpark.com", true },
  { "landscapelightingsimivalley.com", true },
  { "landscapelightingthousandoaks.com", true },
  { "landscapelightingwestlakevillage.com", true },
  { "landscapephotography.org.au", true },
  { "landyparts.nl", true },
  { "lanetix.com", true },
  { "lanforalla.se", true },
  { "lang-php.com", true },
  { "langadeduero.tk", true },
  { "langatang.com", true },
  { "langbein.org", true },
  { "langduytinh.com", true },
  { "langgasse-baar.ch", true },
  { "langhun.me", true },
  { "langkawitrip.com", true },
  { "langleyporter.com", true },
  { "langsam-dator.se", true },
  { "langstreckensaufen.de", true },
  { "languagecourse.net", true },
  { "languageterminal.com", true },
  { "langworth.com", true },
  { "langzijn.nl", true },
  { "lanna.io", true },
  { "lannainnovation.com", true },
  { "lannamontessori.com", true },
  { "lannatefl.com", true },
  { "lanodan.eu", true },
  { "lanostrasalute.it", true },
  { "lanre.org", true },
  { "lanroamer.de", true },
  { "lansechensilu.com", true },
  { "lanselot.com", true },
  { "lansewu.com", true },
  { "lansoftware.eu", true },
  { "lanternalauth.com", true },
  { "lanternhealth.org", true },
  { "lantian.pub", true },
  { "lanturtle.com", true },
  { "lanuovariviera.it", true },
  { "lanzalex.com", true },
  { "lanzamientovirtual.es", true },
  { "lanzarote-online.info", true },
  { "laoliang.ml", true },
  { "laopcionb.net", true },
  { "laos.dating", true },
  { "lapacho-tee.de", true },
  { "lapageamelkor.org", true },
  { "lapassiondutrading.com", false },
  { "lapatio.dk", true },
  { "lapelpinsandcoins.com", true },
  { "lapicena.eu", true },
  { "lapidge.net", true },
  { "laplacesicherheit.de", true },
  { "laplanetebleue.com", true },
  { "lapolla.com", true },
  { "lapolvora.ga", true },
  { "laportedufutur.org", true },
  { "lapotagere.ch", false },
  { "lapparente-aise.ch", false },
  { "lappari.com", false },
  { "lapseofsanity.net", true },
  { "lapshore.com", true },
  { "lara.photography", true },
  { "larabergmann.de", true },
  { "laracode.eu", true },
  { "laraeph.com", true },
  { "laramewa.tk", true },
  { "laranara.se", true },
  { "laranjada.org", true },
  { "larasm.tk", true },
  { "laraveldirectory.com", true },
  { "larbertbaptist.org", true },
  { "larch.me", true },
  { "lareclame.fr", true },
  { "larepublicacultural.es", true },
  { "lares.com", true },
  { "larete.ch", true },
  { "largescaleforums.com", true },
  { "largeviewer.com", true },
  { "lariposte.org", true },
  { "lariscus.eu", true },
  { "larondinedisinfestazione.com", true },
  { "larotayogaming.com", false },
  { "larpkalender.ch", true },
  { "larraz.es", true },
  { "larryandprisca.it", true },
  { "larryli.cn", true },
  { "larrysalibra.com", true },
  { "lars-ewald.com", true },
  { "lars-kusch.de", true },
  { "lars-mense.de", true },
  { "lars.cloud", true },
  { "lars.moi", true },
  { "larsklene.nl", true },
  { "larsklint.com", true },
  { "larsnittve.tk", true },
  { "larsson-ornmark.se", true },
  { "lartduportrait.fr", true },
  { "laruga.co.uk", true },
  { "lasabina.it", true },
  { "lasabubillas.es", true },
  { "lasalle.wa.edu.au", true },
  { "lasarmas.com", true },
  { "lasavonnerieducroisic.fr", true },
  { "lascana.co.uk", true },
  { "lasdelgadas.tk", true },
  { "lasereyess.net", true },
  { "laserhealthsolutions.com", true },
  { "laserpc.net", true },
  { "laserplaza.de", true },
  { "laserplaza.net", true },
  { "lask.in", true },
  { "laskas.pl", true },
  { "lasowy.com", true },
  { "laspequenassemillas.com", true },
  { "lasranas.es", true },
  { "lasrecetascocina.com", true },
  { "lassovideos.com", true },
  { "last-strike.org", true },
  { "lastpass.com", false },
  { "lasuzefc.fr", true },
  { "lasvegasescortmagazine.com", true },
  { "lat.sk", true },
  { "latabaccheria.net", true },
  { "late.am", false },
  { "latecnosfera.com", true },
  { "latedeals.co.uk", true },
  { "latenitefilms.com", false },
  { "lateralsecurity.com", true },
  { "laterremotodealcorcon.tk", true },
  { "latestdeals.co.uk", true },
  { "latiendauno.com", true },
  { "latiendawapa.com", true },
  { "latino.dating", true },
  { "latitudesign.com", false },
  { "latremebunda.com", true },
  { "lattyware.co.uk", true },
  { "lattyware.com", true },
  { "laubacher.io", true },
  { "lauchundei.at", true },
  { "laudableapps.com", true },
  { "laudablesites.com", true },
  { "lauensteiner.de", false },
  { "laufpix.de", true },
  { "lauftreff-himmelgeist.de", true },
  { "laukstein.com", true },
  { "launayflorian.net", true },
  { "launch-subtitle.com", true },
  { "launcher-minecraft.com", true },
  { "launchgroup.com.au", true },
  { "launchkey.com", false },
  { "launchmylifend.com", true },
  { "launchpad-app2.com", true },
  { "launchpadder2.com", true },
  { "lauraandwill.wedding", false },
  { "laurable.com", true },
  { "lauraenvoyage.fr", true },
  { "laurajeandesigns.com", true },
  { "laurakashiwase.com", true },
  { "lauralep.sy", true },
  { "lauralinde.de", true },
  { "lauraofrank.com", true },
  { "lauraohagan.com", true },
  { "laurasplacefamilysupport.org.au", true },
  { "lauravaindumentaria.com", true },
  { "laurelblack.com", true },
  { "laurenball.com", true },
  { "laurencball.com", true },
  { "laurenceplouffe.com", true },
  { "laurenlobue.com", true },
  { "laurensvanderblom.nl", true },
  { "lauresta.lt", true },
  { "lauresta.lv", true },
  { "lauriemilne.com", true },
  { "laurineprice.com", true },
  { "lauriuc.sk", true },
  { "lausannedentiste.ch", false },
  { "lausannelovers.ch", false },
  { "laussat.de", true },
  { "laut.digital", true },
  { "lauzon-hitter.com", true },
  { "lavabit.com", true },
  { "lavabit.no", true },
  { "lavaggista.it", true },
  { "lavalite.de", true },
  { "lavalon.tk", true },
  { "lavamob.com", true },
  { "lavanderia.roma.it", true },
  { "lavaux.lv", true },
  { "laviedalex.ovh", true },
  { "lavinaec.com", true },
  { "lavinya.net", true },
  { "lavita.de", true },
  { "lavitaura.com", true },
  { "lavitrine-une-collection.be", true },
  { "lavoieducoeur.be", true },
  { "lavoiepharmd.com", true },
  { "lavolte.net", true },
  { "lavozdelamusicachilena.tk", true },
  { "lavril.fr", true },
  { "law-colleges.com", true },
  { "law-peters.de", true },
  { "law-profile.com", true },
  { "law.co.il", true },
  { "law22.com", true },
  { "lawabidingcactus.com", true },
  { "lawda.ml", true },
  { "lawlessenglish.com", true },
  { "lawlessfrench.com", true },
  { "lawlessrepublic.com", true },
  { "lawlessspanish.com", true },
  { "lawn-seeds.com", true },
  { "lawnuk.com", true },
  { "lawrenceberg.nl", true },
  { "lawrencemurgatroyd.com", true },
  { "lawrencewhiteside.com", true },
  { "lawservice.com.ua", true },
  { "lawyer.cf", true },
  { "lawyerkf.com", true },
  { "layazc.com", true },
  { "laylo.io", true },
  { "laylo.nl", true },
  { "layordesign.co.uk", true },
  { "layoutsatzunddruck.de", true },
  { "lazau.com", true },
  { "lazer.cf", true },
  { "lazerengravingpros.com", true },
  { "lazistance.com", true },
  { "lazurit.com", true },
  { "lazyboston.com", true },
  { "lazyclock.com", true },
  { "lazyframe.com", true },
  { "lazyhelp.com", true },
  { "lazytux.org", true },
  { "lb-toner.de", true },
  { "lb266.net", true },
  { "lb366.cc", true },
  { "lb369.cc", true },
  { "lbayer.com", true },
  { "lbc-podcast.tk", true },
  { "lbc.gr", true },
  { "lbda.net", true },
  { "lbgconsultores.com", true },
  { "lbihrhelpdesk.com", true },
  { "lbls.me", true },
  { "lbmblaasmuziek.nl", true },
  { "lbs-logics.com", true },
  { "lbsistemas.com.mx", true },
  { "lbux.org", true },
  { "lc-cs.com", false },
  { "lc-promiss.de", true },
  { "lc0101.com", true },
  { "lc0188.com", true },
  { "lc040.com", true },
  { "lc0404g.com", true },
  { "lc044.com", true },
  { "lc0606g.com", true },
  { "lc0808.com", true },
  { "lc08080.com", true },
  { "lc10086.com", true },
  { "lc1010g.com", true },
  { "lc1212g.com", true },
  { "lc1313.com", true },
  { "lc1414.com", true },
  { "lc1588.com", true },
  { "lc1616.com", true },
  { "lc1616g.com", true },
  { "lc171.com", true },
  { "lc1717.com", true },
  { "lc18.fun", true },
  { "lc18.ph", true },
  { "lc18.vip", true },
  { "lc1800.com", true },
  { "lc1818.net", true },
  { "lc1904.com", true },
  { "lc204.com", true },
  { "lc2121g.com", true },
  { "lc221.com", true },
  { "lc2222g.com", true },
  { "lc2323g.com", true },
  { "lc2424.com", true },
  { "lc245.com", true },
  { "lc2500.com", true },
  { "lc2525.com", true },
  { "lc2727.com", true },
  { "lc2828.com", true },
  { "lc287.com", true },
  { "lc3131.com", true },
  { "lc3131g.com", true },
  { "lc3232g.com", true },
  { "lc3434g.com", true },
  { "lc3708.com", true },
  { "lc3709.com", true },
  { "lc3710.com", true },
  { "lc3711.com", true },
  { "lc3712.com", true },
  { "lc3713.com", true },
  { "lc3714.com", true },
  { "lc3715.com", true },
  { "lc3716.com", true },
  { "lc3717.com", true },
  { "lc3718.com", true },
  { "lc3719.com", true },
  { "lc3720.com", true },
  { "lc3723.com", true },
  { "lc3724.com", true },
  { "lc3725.com", true },
  { "lc3726.com", true },
  { "lc3727.com", true },
  { "lc3728.com", true },
  { "lc3729.com", true },
  { "lc3731.com", true },
  { "lc3732.com", true },
  { "lc3733.com", true },
  { "lc3736.com", true },
  { "lc3738.com", true },
  { "lc3739.com", true },
  { "lc3741.com", true },
  { "lc3742.com", true },
  { "lc3743.com", true },
  { "lc3744.com", true },
  { "lc3745.com", true },
  { "lc3746.com", true },
  { "lc3747.com", true },
  { "lc3748.com", true },
  { "lc3751.com", true },
  { "lc3752.com", true },
  { "lc3757.com", true },
  { "lc3759.com", true },
  { "lc3760.com", true },
  { "lc3763.com", true },
  { "lc3772.com", true },
  { "lc3774.com", true },
  { "lc3776.com", true },
  { "lc3778.com", true },
  { "lc3779.com", true },
  { "lc3780.com", true },
  { "lc3781.com", true },
  { "lc3782.com", true },
  { "lc3783.com", true },
  { "lc3793.com", true },
  { "lc3794.com", true },
  { "lc3795.com", true },
  { "lc3798.com", true },
  { "lc3801.com", true },
  { "lc3802.com", true },
  { "lc3838g.com", true },
  { "lc389.com", true },
  { "lc3939.com", true },
  { "lc432.com", true },
  { "lc4343g.com", true },
  { "lc460.com", true },
  { "lc50000.com", true },
  { "lc5081.com", true },
  { "lc5188.net", true },
  { "lc530.com", true },
  { "lc5353.com", true },
  { "lc5454.com", true },
  { "lc5454g.com", true },
  { "lc555.net", true },
  { "lc5555g.com", true },
  { "lc5668.com", true },
  { "lc58588.com", true },
  { "lc5998.com", true },
  { "lc6.fun", true },
  { "lc60000.com", true },
  { "lc6060.com", true },
  { "lc6161.com", true },
  { "lc6161g.com", true },
  { "lc6262.com", true },
  { "lc6363.com", true },
  { "lc6363g.com", true },
  { "lc6464.com", true },
  { "lc6565g.com", true },
  { "lc6601.com", true },
  { "lc6602.com", true },
  { "lc6603.com", true },
  { "lc6605.com", true },
  { "lc6607.com", true },
  { "lc6609.com", true },
  { "lc6621.com", true },
  { "lc6623.com", true },
  { "lc6625.com", true },
  { "lc6626.com", true },
  { "lc6627.com", true },
  { "lc6629.com", true },
  { "lc6631.com", true },
  { "lc6632.com", true },
  { "lc6635.com", true },
  { "lc6636.com", true },
  { "lc6637.com", true },
  { "lc6638.com", true },
  { "lc6639.com", true },
  { "lc6651.com", true },
  { "lc6652.com", true },
  { "lc6653.com", true },
  { "lc6656.com", true },
  { "lc6657.com", true },
  { "lc6659.com", true },
  { "lc6662.com", true },
  { "lc6663.com", true },
  { "lc6665.com", true },
  { "lc6666g.com", true },
  { "lc6667.com", true },
  { "lc6668.com", true },
  { "lc6669.com", true },
  { "lc6681.com", true },
  { "lc6683.com", true },
  { "lc6698.com", true },
  { "lc6767.com", true },
  { "lc68.net", true },
  { "lc6800.com", true },
  { "lc6801.com", true },
  { "lc6802.com", true },
  { "lc6803.com", true },
  { "lc6805.com", true },
  { "lc6806.com", true },
  { "lc6807.com", true },
  { "lc6808.com", true },
  { "lc6809.com", true },
  { "lc6810.com", true },
  { "lc6811.com", true },
  { "lc6812.com", true },
  { "lc6813.com", true },
  { "lc6815.com", true },
  { "lc6816.com", true },
  { "lc6817.com", true },
  { "lc68686.com", true },
  { "lc68688.com", true },
  { "lc6868g.com", true },
  { "lc68690.com", true },
  { "lc68692.com", true },
  { "lc68693.com", true },
  { "lc68694.com", true },
  { "lc68695.com", true },
  { "lc68696.com", true },
  { "lc68697.com", true },
  { "lc68698.com", true },
  { "lc68699.com", true },
  { "lc6880.com", true },
  { "lc68880.com", true },
  { "lc68881.com", true },
  { "lc68882.com", true },
  { "lc68884.com", true },
  { "lc68888.com", true },
  { "lc690.com", true },
  { "lc7.fun", true },
  { "lc7171g.com", true },
  { "lc7373.com", true },
  { "lc7575.com", true },
  { "lc7676.com", true },
  { "lc7676g.com", true },
  { "lc777.net", true },
  { "lc7979.com", true },
  { "lc7979g.com", true },
  { "lc8.com", true },
  { "lc8.fun", true },
  { "lc8.life", true },
  { "lc8.live", true },
  { "lc8.tv", true },
  { "lc80000.com", true },
  { "lc8003.com", true },
  { "lc8005.com", true },
  { "lc8020.com", true },
  { "lc8023.com", true },
  { "lc8032.com", true },
  { "lc8033.com", true },
  { "lc8036.com", true },
  { "lc8038.com", true },
  { "lc8050.com", true },
  { "lc8052.com", true },
  { "lc818.net", true },
  { "lc8181.com", true },
  { "lc8282.com", true },
  { "lc8383g.com", true },
  { "lc8585g.com", true },
  { "lc859.com", true },
  { "lc861.com", true },
  { "lc862.com", true },
  { "lc863.com", true },
  { "lc869.com", true },
  { "lc871.com", true },
  { "lc873.com", true },
  { "lc875.com", true },
  { "lc876.com", true },
  { "lc8787.com", true },
  { "lc879.com", true },
  { "lc88.fun", true },
  { "lc8812.com", true },
  { "lc8813.com", true },
  { "lc8815.com", true },
  { "lc8816.com", true },
  { "lc8817.com", true },
  { "lc8819.com", true },
  { "lc8820.com", true },
  { "lc8823.com", true },
  { "lc8825.com", true },
  { "lc8826.com", true },
  { "lc8835.com", true },
  { "lc8836.com", true },
  { "lc8838.com", true },
  { "lc8839.com", true },
  { "lc8841.com", true },
  { "lc88508.com", true },
  { "lc8856.com", true },
  { "lc8859.com", true },
  { "lc8861.com", true },
  { "lc8862.com", true },
  { "lc8863.com", true },
  { "lc8865.com", true },
  { "lc8866.com", true },
  { "lc8868.net", true },
  { "lc8869.com", true },
  { "lc8870.com", true },
  { "lc8874.com", true },
  { "lc8878.com", true },
  { "lc8881.com", true },
  { "lc8882.com", true },
  { "lc8885.com", true },
  { "lc8887.com", true },
  { "lc8888g.com", true },
  { "lc8890.com", true },
  { "lc8891.com", true },
  { "lc8892.com", true },
  { "lc8893.com", true },
  { "lc8896.com", true },
  { "lc8898.net", true },
  { "lc8900.com", true },
  { "lc8905.com", true },
  { "lc8906.com", true },
  { "lc891.com", true },
  { "lc8910.com", true },
  { "lc8911.com", true },
  { "lc8912.com", true },
  { "lc8913.com", true },
  { "lc8914.com", true },
  { "lc8915.com", true },
  { "lc8916.com", true },
  { "lc8917.com", true },
  { "lc8918.com", true },
  { "lc892.com", true },
  { "lc8920.com", true },
  { "lc8921.com", true },
  { "lc8922.com", true },
  { "lc8923.com", true },
  { "lc8924.com", true },
  { "lc8925.com", true },
  { "lc8926.com", true },
  { "lc8927.com", true },
  { "lc8928.com", true },
  { "lc8929.com", true },
  { "lc893.com", true },
  { "lc8930.com", true },
  { "lc8931.com", true },
  { "lc8932.com", true },
  { "lc8934.com", true },
  { "lc8935.com", true },
  { "lc8936.com", true },
  { "lc895.com", true },
  { "lc896.com", true },
  { "lc897.com", true },
  { "lc8a.com", true },
  { "lc8c.com", true },
  { "lc8dc04.com", true },
  { "lc8dc08.com", true },
  { "lc8dc10.com", true },
  { "lc8dc11.com", true },
  { "lc8dc12.com", true },
  { "lc8dc13.com", true },
  { "lc8dc14.com", true },
  { "lc8dc15.com", true },
  { "lc8dc16.com", true },
  { "lc8dc17.com", true },
  { "lc8dc20.com", true },
  { "lc8dc21.com", true },
  { "lc8dc22.com", true },
  { "lc8dc24.com", true },
  { "lc8dc26.com", true },
  { "lc8dc27.com", true },
  { "lc8dc28.com", true },
  { "lc8dc29.com", true },
  { "lc8guidance.com", true },
  { "lc8md00.com", true },
  { "lc8md01.com", true },
  { "lc8md02.com", true },
  { "lc8md03.com", true },
  { "lc8md08.com", true },
  { "lc8md11.com", true },
  { "lc8md26.com", true },
  { "lc8md28.com", true },
  { "lc8md30.com", true },
  { "lc8md31.com", true },
  { "lc8md33.com", true },
  { "lc8md35.com", true },
  { "lc8md55.com", true },
  { "lc8md77.com", true },
  { "lc8md88.com", true },
  { "lc9.app", true },
  { "lc90000.com", true },
  { "lc9090.com", true },
  { "lc9108.com", true },
  { "lc9251.com", true },
  { "lc9253.com", true },
  { "lc9256.com", true },
  { "lc9292.com", true },
  { "lc9393g.com", true },
  { "lc9494.com", true },
  { "lc9494g.com", true },
  { "lc9797.com", true },
  { "lc98.net", true },
  { "lc9852.com", true },
  { "lc9862.com", true },
  { "lc9899.com", true },
  { "lc9900.com", true },
  { "lc9910.com", true },
  { "lc9920.com", true },
  { "lc9930.com", true },
  { "lc9938.com", true },
  { "lc9939.com", true },
  { "lc9940.com", true },
  { "lc9950.com", true },
  { "lc9960.com", true },
  { "lc9968.com", true },
  { "lc9986.com", true },
  { "lc9999g.com", true },
  { "lca-pv.de", true },
  { "lcacommons.gov", true },
  { "lcars-sv.info", true },
  { "lce-events.com", true },
  { "lcgaj.com", true },
  { "lcv.psc.br", true },
  { "lcvip4.com", true },
  { "lcvip5.com", true },
  { "lcvip7.com", true },
  { "lcvip8.net", true },
  { "lcvip9.com", true },
  { "lcx.cc", true },
  { "lcy.im", false },
  { "lcy.moe", true },
  { "ld-begunjscica.si", true },
  { "ld66999.com", true },
  { "ld6999.com", true },
  { "ldesignweb.com", true },
  { "ldjb.jp", true },
  { "ldm2468.com", true },
  { "ldsun.com", true },
  { "le-bar.org", true },
  { "le-cameleon.fr", true },
  { "le-controle-parental.fr", true },
  { "le-creux-du-van.ch", false },
  { "le-drive-de-just-vet.fr", true },
  { "le-fumoir.com", true },
  { "le-h.de", false },
  { "le-page.info", false },
  { "le-palantir.com", true },
  { "le-traiteur-parisien.fr", false },
  { "le-upfitter.com", true },
  { "le056.com", true },
  { "le23.fr", true },
  { "le42mars.fr", true },
  { "le518.net", true },
  { "le802.com", true },
  { "leadbook.ru", true },
  { "leadbox.cz", true },
  { "leadership-conference.net", true },
  { "leadinfo.com", true },
  { "leadquest.nl", true },
  { "leaf-consulting.de", true },
  { "leafandseed.co.uk", true },
  { "leafans.tk", false },
  { "leafinote.com", true },
  { "leafland.co.nz", true },
  { "leakforums.net", true },
  { "leamsigc.com", false },
  { "leankit.com", true },
  { "leanplando.com", true },
  { "leap-it.be", false },
  { "leapandjump.co.uk", true },
  { "leapworks.io", true },
  { "learncrypto.vip", true },
  { "learnflakes.net", true },
  { "learnhowtoplayguitar.tk", true },
  { "learning-id.com", true },
  { "learningis1.st", true },
  { "learningladderacademy.net", true },
  { "learninglaw.com", true },
  { "learningman.top", true },
  { "learningselfreliance.com", true },
  { "learnlux.com", true },
  { "learnpianogreece.com", true },
  { "learnplayground.com", true },
  { "learntohack.me", true },
  { "leaseplan.com", true },
  { "leastsignificantbit.de", true },
  { "leatam.fr", true },
  { "leatherfurnitureexpo.com", true },
  { "leathersofacleaning.co.uk", true },
  { "leatherwood.nl", true },
  { "lebanesearmy.gov.lb", true },
  { "lebanonbitcoin.com", true },
  { "lebarmy.gov.lb", true },
  { "lebedata.com", true },
  { "lebendige-heilkunst.de", true },
  { "lebens-fluss.at", true },
  { "lebensraum-fitness-toenisvorst.de", true },
  { "lebensraum-kurse.ch", true },
  { "lebihan.pl", true },
  { "leblanc.io", true },
  { "lebosse.me", true },
  { "lebourgeo.is", true },
  { "lecannabis.com", true },
  { "lecannabiste.com", true },
  { "lecheng.in", true },
  { "lecheng08.com", true },
  { "lecheng2.com", true },
  { "lecheng3.com", true },
  { "lecheng31.com", true },
  { "lecheng518.com", true },
  { "lecheng5288.com", true },
  { "lecheng5888.com", true },
  { "lecheng66.com", true },
  { "lecheng7.com", true },
  { "lecheng88.com", true },
  { "lecheng88.net", true },
  { "lecheng888.com", true },
  { "lecheng98.com", true },
  { "lecheng98.net", true },
  { "lecheng988.com", true },
  { "lectricecorrectrice.com", true },
  { "led-jihlava.cz", true },
  { "ledburyvets.co.uk", true },
  { "leddingplasticsurgery.com", true },
  { "ledecologie.com.br", true },
  { "ledeguisement.com", true },
  { "lederer-it.com", true },
  { "lederkleren.nl", true },
  { "ledlight.com", true },
  { "ledlights.ca", true },
  { "ledscontato.com.br", true },
  { "ledspadova.eu", true },
  { "ledwereld.nl", true },
  { "lee-fuller.co.uk", true },
  { "leeaaronsrealestate.com", true },
  { "leeannescreations.com", true },
  { "leebiblestudycentre.co.uk", true },
  { "leeclemens.net", false },
  { "leedev.org", true },
  { "leekspin.ml", true },
  { "leelaylay.com", true },
  { "leemankuiper.nl", true },
  { "leerliga.de", true },
  { "leertipp.de", true },
  { "leesilvey.com", true },
  { "leesyal.org", true },
  { "leet2.com", true },
  { "leetcode.com", true },
  { "leetcode.net", true },
  { "leetgamers.asia", true },
  { "leevealdc.com", true },
  { "leeyoungaeph.tk", true },
  { "lefcoaching.nl", false },
  { "lefebvristes.com", true },
  { "lefebvristes.fr", true },
  { "leflibustier.ru", true },
  { "lefonddeloeil.com", false },
  { "left-baggage.co.uk", true },
  { "leftbrainsolutions.com.au", true },
  { "legabot.fr", true },
  { "legacyiohs.org", true },
  { "legaillart.fr", true },
  { "legalatlanta.com", true },
  { "legalband.club", true },
  { "legalcontrol.info", true },
  { "legaldesk.com", false },
  { "legalforms.ng", true },
  { "legalinmotion.es", true },
  { "legalplace.fr", true },
  { "legalrobot.com", true },
  { "legalsearch.nl", true },
  { "legalsoftware.net", true },
  { "legend-v.life", true },
  { "legendcatz.com", true },
  { "legendesdechine.ch", false },
  { "legendofkrystal.com", true },
  { "legends-game.ru", false },
  { "legible.es", true },
  { "legioniv.org", true },
  { "legionminecraft.com", true },
  { "legiscontabilidade.com.br", true },
  { "legit.nz", true },
  { "legjobblogo.hu", true },
  { "legland.fr", true },
  { "legnami24.it", true },
  { "legoutdesplantes.be", true },
  { "legrandvtc.fr", true },
  { "legumeinfo.org", true },
  { "legyenkianegykereked.hu", true },
  { "lehighmathcircle.org", true },
  { "lehighvalleypeds.com", true },
  { "lehmitz-weinstuben.de", true },
  { "lehti-tarjous.net", true },
  { "leibniz-gymnasium-altdorf.de", true },
  { "leideninternationalreview.com", true },
  { "leighneithardt.com", true },
  { "leignier.org", true },
  { "leilonorte.com", true },
  { "leipzig.photo", true },
  { "leipziger-triathlon.de", true },
  { "leisure-blog.com", true },
  { "leisure-supplies-show.co.uk", true },
  { "leisurepools.com.au", true },
  { "lejardindesmesanges.fr", true },
  { "lektier.cf", true },
  { "lelac-capfrance.com", true },
  { "lelubre.info", true },
  { "lelux.fi", true },
  { "lelux.site", true },
  { "lemagauto.fr", true },
  { "lemarcheelagrandeguerra.it", true },
  { "lemazol.fr", true },
  { "lemilane.it", true },
  { "leminhduong.com", true },
  { "lemni.top", true },
  { "lemoine.at", true },
  { "lemondenumerique.com", true },
  { "lemonlawnow.com", true },
  { "lemonop.com", true },
  { "lemonparty.co", true },
  { "lemonrockbiketours.com", true },
  { "lemonrotools.com", true },
  { "lemonthy.com", true },
  { "lenafonster.se", true },
  { "lenagroben.de", true },
  { "lenalio.fr", true },
  { "lenaneva.ru", true },
  { "lence.net", true },
  { "lencia.ga", true },
  { "lendingclub.com", true },
  { "lenget.com", true },
  { "lenguajedeprogramacion.com", true },
  { "lenidh.de", true },
  { "leninalbertop.com.ve", true },
  { "lenn-blaschke.com", true },
  { "lenostech.gr", true },
  { "lenou.nl", true },
  { "lenovovietnam.net", true },
  { "lenr-forum.com", true },
  { "lensdoctor.com", true },
  { "lenspirations.com", true },
  { "lensual.space", true },
  { "lentivo.com", true },
  { "lenuagebauche.org", true },
  { "lenyip.com", true },
  { "lenyip.me", true },
  { "lenyip.works", true },
  { "leoandpeto.com", true },
  { "leodraxler.at", true },
  { "leola.cz", true },
  { "leola.sk", true },
  { "leominstercu.com", false },
  { "leomwilson.com", true },
  { "leon-tec.co.jp", true },
  { "leon-tech.com", true },
  { "leonbuitendam.nl", true },
  { "leondenard.com", true },
  { "leonklingele.de", true },
  { "leonmahler.consulting", true },
  { "leontiekoetter.de", true },
  { "leontyev.tk", true },
  { "leopoldina.net", true },
  { "leoservicos.etc.br", true },
  { "leoservicosetc.com", true },
  { "leoservicosetc.com.br", true },
  { "leoservicosetc.email", true },
  { "leoservicosetc.live", true },
  { "leoservicosetc.net", true },
  { "leoservicosetc.online", true },
  { "leoservicosetc.org", true },
  { "leoservicosetc.rio.br", true },
  { "leoservicosetc.world", true },
  { "leovanna.co.uk", true },
  { "leowkahman.com", true },
  { "lep.gov", true },
  { "lepartiecomemoracoes.com.br", true },
  { "lepenetapeti.com", true },
  { "lepidum.jp", true },
  { "lepsos.com", false },
  { "lequerceagriturismo.com", true },
  { "lequest.dk", true },
  { "lequocthai.com", true },
  { "lerasenglish.com", true },
  { "lereporter.ma", true },
  { "leretour.ch", false },
  { "lerku.com", true },
  { "lernenamsee.ch", true },
  { "lernerspersonalinjury.ca", true },
  { "lernorteuropa.com", true },
  { "lernorteuropa.de", true },
  { "lernorteuropa.eu", true },
  { "lernplattform-akademie.de", true },
  { "leruevintage.com", true },
  { "les-ateliers-de-melineo.be", false },
  { "les-explos.com", true },
  { "les-inoxydables.com", true },
  { "lesaffre.es", true },
  { "lesancheslibres.fr", true },
  { "lesarts.com", true },
  { "lesberger.ch", false },
  { "lesbi-porno-video.ru", true },
  { "lesbianlovers.tk", true },
  { "lesbofight.com", true },
  { "lesbrillantsdaristide.com", true },
  { "lesconteursavis.org", true },
  { "lescrapdesfilles.fr", true },
  { "leseditionsbraquage.com", true },
  { "lesfilmsavivre.com", true },
  { "lesgarianes.com", true },
  { "lesgoodnews.fr", true },
  { "leshervelines.com", true },
  { "leshok.tk", true },
  { "lesjardinsdubanchet.fr", true },
  { "lesmamy.ch", false },
  { "lesmontagne.net", true },
  { "lesnet.co.uk", true },
  { "lespagesweb.ch", false },
  { "lespecialiste-pradelexcellence.com", true },
  { "lesplatanes.ch", false },
  { "lespoesiesdheloise.fr", true },
  { "lespret.nl", true },
  { "lesptitspasdelyne.fr", true },
  { "lesptitstutos.fr", true },
  { "lesquerda.cat", false },
  { "lessis.moe", true },
  { "lesterchan.net", true },
  { "lesterrassesdusoleil.ch", false },
  { "lesummeira.is", true },
  { "lesyndicat.info", false },
  { "leszonderstress.nl", true },
  { "letaman.tk", true },
  { "letdownloads.tk", true },
  { "letemps.ch", true },
  { "letempsdujasmin.fr", true },
  { "letertrefleuri.com", true },
  { "lethosdesigns.co.uk", true },
  { "lethosdesigns.com", true },
  { "leticia.ml", true },
  { "letni-kurzy.cz", true },
  { "leto12.xyz", true },
  { "letranif.net", true },
  { "lets-bounce.com", true },
  { "lets-go-acoustic.de", true },
  { "lets-ktai.jp", true },
  { "lets.nu", true },
  { "letsbounceuk.com", true },
  { "letsbrand.com", true },
  { "letsdebug.net", true },
  { "letsencrypt-for-cpanel.com", true },
  { "letsflyinto.space", true },
  { "letsgame.nl", true },
  { "letsgetchecked.com", true },
  { "letsgowhilewereyoung.com", true },
  { "letsorganise.uk", true },
  { "letspartyrugby.co.uk", true },
  { "letsprint3d.net", true },
  { "letssackcancer.org", true },
  { "letstalkcounseling.com", true },
  { "letterbox-online.de", true },
  { "letterdance.de", true },
  { "letteringinstitute.com", true },
  { "lettersblogatory.com", true },
  { "lettings101.org", true },
  { "lettori.club", true },
  { "lettres-motivation.net", true },
  { "leuchtmann.ch", true },
  { "leuenhagen.com", true },
  { "leulu.com", true },
  { "leumi-how-to.co.il", true },
  { "leutgeb.xyz", true },
  { "leuthardtfamily.com", true },
  { "lev103.com", true },
  { "levans.fr", true },
  { "level-10.de", true },
  { "level6.me", true },
  { "level9hvac.com", true },
  { "levelonetrainingandfitness.com", true },
  { "levels.one", true },
  { "leveluplv.com", true },
  { "leveluprails.com", true },
  { "leveluprankings.com", true },
  { "levendwater.org", true },
  { "levensbron.nl", true },
  { "leventismotors.com.ng", true },
  { "leveragedtokens.com", true },
  { "leverj.io", true },
  { "levermann.eu", true },
  { "leviaan.nl", true },
  { "leviathan-studio.com", true },
  { "levineteamestates.com", true },
  { "levinus.de", true },
  { "leviscop.com", true },
  { "leviscop.de", true },
  { "levittasaude.com.br", true },
  { "lew.im", true },
  { "lewdawson.com", true },
  { "lewdgamer.com", true },
  { "lewiatan.opole.pl", true },
  { "lewiscollard.com", true },
  { "lewisdatasecurity.com", true },
  { "lewislaw.com", true },
  { "lewisllewellyn.me", true },
  { "lewismcyoutube.uk", true },
  { "lexautoservice.nl", true },
  { "lexdigital.pl", true },
  { "lexic.co", true },
  { "lexico.pt", true },
  { "lexicography.online", true },
  { "lexikon24.tk", true },
  { "lexoo.co.uk", true },
  { "lexpierce.social", true },
  { "lexway.pk", true },
  { "leymaritima.com", true },
  { "lfashion.eu", true },
  { "lfgss.com", true },
  { "lfrconseil.com", true },
  { "lfyhokk.tk", true },
  { "lg-waps.go.jp", true },
  { "lg-waps.jp", true },
  { "lg.gz.cn", true },
  { "lg2.com", true },
  { "lgbt-colleges.com", true },
  { "lgbt.io", true },
  { "lgbtq.cool", true },
  { "lghfinancialstrategy.ch", false },
  { "lgpecasoriginais.com.br", true },
  { "lgygf.com", true },
  { "lhamaths.online", true },
  { "lhconsult.tk", false },
  { "lhero.org", true },
  { "lhgavarain.com", true },
  { "lhost.su", true },
  { "lhr.wiki", true },
  { "li-ke.co.jp", true },
  { "li.gz.cn", true },
  { "li.search.yahoo.com", false },
  { "li680.com", true },
  { "lialion.de", true },
  { "liam-w.com", true },
  { "liam-w.io", true },
  { "liamelliott.me", true },
  { "liamlin.me", true },
  { "liandongyoupin.com", true },
  { "liangxingai.com", true },
  { "lianhongrui.com", true },
  { "liaronce.com", true },
  { "liautard.fr", true },
  { "lib64.net", true },
  { "libble.eu", true },
  { "libbywinberginteriors.com.au", true },
  { "liberapay.com", true },
  { "liberation2020.com", true },
  { "liberationist.org", true },
  { "liberationschool.org", true },
  { "liberdademg.com.br", true },
  { "liberhk.com", true },
  { "liberhk.info", true },
  { "liberhk.net", true },
  { "liberhk.org", true },
  { "liberta-me.org", true },
  { "libertarian-party.com", true },
  { "libertas.co.jp", true },
  { "liberty-city.tk", true },
  { "liberty-med.ru", true },
  { "libertyachts.com", true },
  { "libgame.com", true },
  { "libmpq.org", true },
  { "libnull.com", true },
  { "libo766.com", true },
  { "libo766.net", true },
  { "liborburda.cz", true },
  { "libportal.cf", true },
  { "libra.com", true },
  { "librarium.tk", true },
  { "library-quest.com", true },
  { "libraryextension.com", true },
  { "libraryofcode.org", true },
  { "librarytools.com", false },
  { "libravatar.org", true },
  { "librazy.org", true },
  { "libre-innovation.org", true },
  { "libre-service.de", true },
  { "libre.cr", true },
  { "libreboot.org", true },
  { "librebox.de", true },
  { "libreduca.com", true },
  { "librehk.com", true },
  { "librehk.info", true },
  { "librehk.net", true },
  { "librehk.org", true },
  { "librelamp.com", true },
  { "libremail.nl", true },
  { "libreoffice-from-collabora.com", true },
  { "libreofficefromcollabora.com", true },
  { "libreria-ouroboros.tk", true },
  { "librerias-he.com.pe", true },
  { "librervac.org", true },
  { "librisulibri.it", true },
  { "librofilia.com", true },
  { "libscode.com", false },
  { "libskia.so", true },
  { "libsodium.org", true },
  { "libstock.si", true },
  { "lichess.org", true },
  { "lichtmetzger.de", false },
  { "lichtspot.de", true },
  { "lichttechnik-tumler.com", true },
  { "lichttraeumer.de", true },
  { "lickthesalt.com", true },
  { "licloud.homeip.net", true },
  { "lida-vets.co.uk", true },
  { "lidavidm.me", true },
  { "lidel.org", true },
  { "lideradigital.com", true },
  { "liderwalut.pl", false },
  { "lidl-blumen.de", true },
  { "lidl-foto.it", true },
  { "lidl-fotos.at", true },
  { "lidl-fotos.de", true },
  { "lidl-gewinnspiel.de", true },
  { "lidl-holidays.com", true },
  { "lidl-menubox.ch", true },
  { "lidl-shop.be", true },
  { "lidl-shop.cz", true },
  { "lidl-shop.nl", true },
  { "lidl-shop.sk", true },
  { "lidl-sklep.pl", true },
  { "lidl-stikeez.si", true },
  { "lidl-tour.ro", true },
  { "lidlonline.es", true },
  { "lidogr.com", true },
  { "lidong.me", true },
  { "lidow.eu", true },
  { "lidtkemotors.com", true },
  { "liduan.net", false },
  { "lie.as", true },
  { "liebel.org", true },
  { "lieberwirth.biz", true },
  { "liehuojun.com", true },
  { "liemen.net", true },
  { "lienhardtconstruction.fr", true },
  { "lieren4x4.nl", true },
  { "lierohell.tk", true },
  { "lieuu.com", false },
  { "lifanov.com", true },
  { "life-emotions.pt", true },
  { "life-in-hell.tk", true },
  { "life-time.nl", true },
  { "life29.com", true },
  { "lifeartstudios.net", true },
  { "lifebetweenlives.com.au", true },
  { "lifeboxhealthcare.co.uk", true },
  { "lifecism.com", true },
  { "lifefoto.de", true },
  { "lifeguatemala.com", true },
  { "lifeinhex.com", true },
  { "lifeinsurancepro.org", true },
  { "lifekirov.tk", true },
  { "lifelenz.com", true },
  { "lifematenutrition.com", true },
  { "lifemcserver.com", true },
  { "lifemstyle.com", true },
  { "lifeqa.net", true },
  { "lifesafety.com.br", true },
  { "lifesavvy.com", true },
  { "lifeset.pp.ua", true },
  { "lifeslonglist.com", true },
  { "lifestorage.com", true },
  { "lifestylecent.com", true },
  { "lifestylefinancial.ca", true },
  { "lifestylefoto.cz", true },
  { "lifestyletravel.co.za", true },
  { "lifetoolscdc.com", true },
  { "lifetree.network", true },
  { "lifewithdyna.com", true },
  { "lifi.digital", true },
  { "lifi.is", true },
  { "lift-wise.com", true },
  { "liftie.info", true },
  { "liftmastercloud.com", true },
  { "ligadosgames.com", true },
  { "light-up.xyz", true },
  { "light.mail.ru", true },
  { "lightbox.co", true },
  { "lightcraftmc.tk", true },
  { "lightfoot.co.uk", true },
  { "lighthouseglobal.com", true },
  { "lighting-centres.co.uk", true },
  { "lightingagoura.com", true },
  { "lightingagourahills.com", true },
  { "lightingcalabasas.com", true },
  { "lightingconejovalley.com", true },
  { "lightingdosvientos.com", true },
  { "lightinghiddenhills.com", true },
  { "lightinglakesherwood.com", true },
  { "lightingmalibu.com", true },
  { "lightingmoorpark.com", true },
  { "lightingnewburypark.com", true },
  { "lightingoakpark.com", true },
  { "lightingsimivalley.com", true },
  { "lightingthousandoaks.com", true },
  { "lightingwestlakevillage.com", true },
  { "lightme.us", true },
  { "lightning-wallet.com", true },
  { "lightning.community", true },
  { "lightning.engineering", true },
  { "lightningwirelabs.com", true },
  { "lightography.com", true },
  { "lights.co.uk", true },
  { "lights.ie", true },
  { "lightscale.com", true },
  { "lightsfromspace.com", true },
  { "lightsheep.no", false },
  { "lightspeed.com", false },
  { "lightspeedta.co", true },
  { "lighttp.com", true },
  { "lightweighthr.com", true },
  { "lightyear.no", true },
  { "ligmadrive.com", true },
  { "lignesante.com", true },
  { "lignite.com", true },
  { "lignoma.com", true },
  { "ligonier.com", true },
  { "lihaul.dnsalias.net", true },
  { "lije-creative.com", true },
  { "lijncoaching.nl", true },
  { "lijstje.be", true },
  { "lijstje.nl", true },
  { "likc.me", true },
  { "likeablehub.com", true },
  { "likeabox.de", true },
  { "likebee.gr", true },
  { "likegeeks.com", true },
  { "likehifi.de", true },
  { "likemovies.de", true },
  { "likeometer.co", true },
  { "likere.com", true },
  { "likesforinsta.com", true },
  { "likestudio.com.ua", true },
  { "likui.me", true },
  { "lilai107.com", true },
  { "lilai116.com", true },
  { "lilai18.ph", true },
  { "lilai2211.com", true },
  { "lilai3366.com", true },
  { "lilai634.com", true },
  { "lilai6677.com", true },
  { "lilai838.com", true },
  { "lilai8866.com", true },
  { "lilai9966.com", true },
  { "lilianejuchli.ch", true },
  { "liliang13.com", true },
  { "liljohnsanitary.net", true },
  { "lillepuu.com", true },
  { "lilliputpreschool.co.nz", true },
  { "lilomatrixcorner.fr", true },
  { "lily-bearing.com", true },
  { "lily-inn.com", true },
  { "lilyfarmfreshskincare.com", true },
  { "lilysbouncycastles.com", true },
  { "lilysgrill.com", true },
  { "lilyvet.com", true },
  { "lim-light.com", true },
  { "limap.ch", true },
  { "limasartes.com.br", true },
  { "limawi.io", true },
  { "limbaido.tk", true },
  { "limberg.me", true },
  { "limbo.services", true },
  { "limeres.com", true },
  { "limereslaw.com", true },
  { "limit.xyz", true },
  { "limitededitioncomputers.com", true },
  { "limitededitionsolutions.com", true },
  { "limitlessinteractive.com", true },
  { "limitxyz.com", true },
  { "limnt.cn", true },
  { "limo.pl", true },
  { "limoshka.ru", true },
  { "limpid.nl", true },
  { "limstash.com", true },
  { "limstash.me", true },
  { "limules.ch", true },
  { "limx.win", true },
  { "lin.fi", true },
  { "linaklein.de", true },
  { "lincdavis.com", true },
  { "lince-bonares.tk", true },
  { "lincnaarzorg.nl", true },
  { "lincoln.com.cn", true },
  { "lincoln.mx", true },
  { "lincolnboolefoundation.org", true },
  { "lincolnfinewines.com", true },
  { "lincolnpedsgroup.com", true },
  { "lincolnsfh.com", true },
  { "lincolnwayflorist.com", true },
  { "lincore.ru", true },
  { "lindajahn.de", true },
  { "lindalap.fi", true },
  { "lindaolsson.com", true },
  { "linden.me", true },
  { "lindeskar.se", true },
  { "lindgrenracing.tk", true },
  { "lindnerhof-taktik.de", true },
  { "lindnerhof.info", true },
  { "lindo.ru", true },
  { "lindon.pw", true },
  { "lindquistnet.us", true },
  { "lindsaygorski.com", true },
  { "lindskogen.se", true },
  { "lindy.co", false },
  { "line-wise.com", true },
  { "line.biz", true },
  { "line.co.nz", false },
  { "lineageos.org", true },
  { "linearaudio.net", true },
  { "linearmap.com", true },
  { "lineshop.ml", true },
  { "linestep.jp", true },
  { "linfamilygc.com", true },
  { "linge-ma.ro", true },
  { "lingerie.com.br", true },
  { "lingeriesilhouette.com", true },
  { "lingotaxi.com", true },
  { "link-net.ga", true },
  { "link-sanitizer.com", true },
  { "link2serve.com", true },
  { "link9.net", true },
  { "linkdr.uk", true },
  { "linkedinbackground.com", true },
  { "linkedpipes.com", true },
  { "linkenheil.org", true },
  { "linklocker.co", true },
  { "linkmaker.co.uk", true },
  { "linkmauve.fr", true },
  { "linko-pomoika.tk", true },
  { "linkopia.com", true },
  { "linksphotograph.com", true },
  { "linkthis.me", true },
  { "linktio.com", true },
  { "linkuva.tk", true },
  { "linkwheel.tk", true },
  { "linkycat.com", true },
  { "linnaeusgroup.co.uk", true },
  { "linonin.tk", true },
  { "linosky.ch", true },
  { "linost.com", true },
  { "linpx.com", true },
  { "linqhost.nl", true },
  { "linss.com", true },
  { "lintasi.com", true },
  { "lintelliftusa.com", true },
  { "lintmx.com", true },
  { "linux-audit.com", true },
  { "linux-florida.com", true },
  { "linux-help.org", true },
  { "linux-mint-czech.cz", true },
  { "linux-taganrog.tk", true },
  { "linux-vme.org", true },
  { "linux.cn", true },
  { "linux.conf.au", true },
  { "linux.farm", true },
  { "linux.fi", true },
  { "linux.im", true },
  { "linux.pizza", true },
  { "linux3.org", true },
  { "linuxadictos.com", true },
  { "linuxbabe.com", true },
  { "linuxbg.eu", true },
  { "linuxbierwanderung.com", true },
  { "linuxchick.se", true },
  { "linuxcommand.ru", true },
  { "linuxdays.cz", true },
  { "linuxforum.ch", true },
  { "linuxgiggle.com", true },
  { "linuxhilux.com", true },
  { "linuxhostsupport.com", true },
  { "linuxincluded.com", true },
  { "linuxiuvat.de", true },
  { "linuxlounge.net", true },
  { "linuxos.org", true },
  { "linuxsecurity.expert", true },
  { "linx.net", true },
  { "linzgau.de", true },
  { "linzyjx.com", true },
  { "lion7.de", true },
  { "lionlyrics.com", true },
  { "lionsdeal.com", true },
  { "lipacom.ga", true },
  { "lipartydepot.com", true },
  { "lipex.com", true },
  { "lipighor.com", true },
  { "lipighor.xyz", true },
  { "lipoabaltimore.org", true },
  { "lippu1.fi", true },
  { "lipthink.com", true },
  { "liqd.net", true },
  { "liqueur.wiki", true },
  { "liquid.cz", true },
  { "liquidhost.co", true },
  { "liquidinternet.co", true },
  { "liquipedia.net", true },
  { "liress.gq", true },
  { "lirion.de", true },
  { "lirlandais.ch", false },
  { "lirnberger.com", true },
  { "lisadelbo.tk", true },
  { "lisahh-jayne.com", true },
  { "lisamccorrie.com", true },
  { "lisanzauomo.com", true },
  { "lisasc.gq", true },
  { "lisasworkshop.co.uk", true },
  { "lisburnhottubnbounce.co.uk", true },
  { "lisius.ga", true },
  { "liskgdt.net", true },
  { "lislan.org.uk", true },
  { "lisowski-development.com", false },
  { "lissabon.guide", true },
  { "lissajouss.tk", true },
  { "lissauer.com", true },
  { "list-gymnasium.de", true },
  { "listahu.org", true },
  { "listekdo.fr", true },
  { "listen.dk", true },
  { "lister-kirchweg.de", true },
  { "listisima.com", true },
  { "listminut.be", true },
  { "lists.fedoraproject.org", true },
  { "lists.stg.fedoraproject.org", true },
  { "listsothebysrealtyhk.com", true },
  { "listyourinfo.com", true },
  { "litarvan.com", true },
  { "litchidova.nl", true },
  { "litebit.de", true },
  { "litebit.eu", true },
  { "litebit.nl", true },
  { "litebitcdn.eu", true },
  { "litebits.com", true },
  { "litemind.com", false },
  { "literaki123.pl", true },
  { "literarymachin.es", true },
  { "literature-schools.com", true },
  { "litfin.name", true },
  { "lithan.com", true },
  { "lithesalar.se", true },
  { "lithianissaneugeneparts.com", true },
  { "litsovet.com", true },
  { "little-brother.eu", true },
  { "little-cake.com", true },
  { "little-news.gq", true },
  { "littlebestfriend.de", true },
  { "littleblackfish.se", true },
  { "littleboutiqueshop.co.uk", true },
  { "littledev.nl", true },
  { "littleduck.xyz", true },
  { "littlefairy.no", true },
  { "littlefamilyadventure.com", true },
  { "littlegreece.ae", true },
  { "littlelife.co.uk", true },
  { "littlelucifercafe.tk", true },
  { "littlenina.nz", false },
  { "littlenlargeevents.co.uk", true },
  { "littlepigcreek.com.au", true },
  { "littleprincessandmascotparties.co.uk", true },
  { "littleredpenguin.com", true },
  { "littleredsbakeshop.com", true },
  { "littlericket.me", true },
  { "littles.moe", true },
  { "littlescallywagsplay.co.uk", true },
  { "littleswitch.co.jp", true },
  { "littlewatcher.com", true },
  { "littleyokohamakennel.tk", true },
  { "liturgical.net", true },
  { "liturkey.tk", true },
  { "litvideoserver.de", true },
  { "litz.ca", true },
  { "litzenberger.ca", true },
  { "liu0hy.cn", true },
  { "liubliu.co.uk", true },
  { "liudon.org", true },
  { "liuliuya.com.tw", true },
  { "liv3d.stream", true },
  { "livada.fr", true },
  { "live4k.media", false },
  { "live8811.com", true },
  { "live8899.cn", true },
  { "live8899.co", true },
  { "live8899.net", true },
  { "live9922.com", true },
  { "livebandphotos.com", true },
  { "livebetterwith.com", true },
  { "livebythesun.de", true },
  { "livecards.es", true },
  { "livecards.eu", true },
  { "livecards.it", true },
  { "livecchi.cloud", true },
  { "livechat-ag777.com", true },
  { "livedesign.at", true },
  { "livedesign24.de", true },
  { "liveflightapp.com", true },
  { "liveforspeed.se", true },
  { "livehomecams.co.uk", true },
  { "liveint.org", true },
  { "livejasmin.dk", true },
  { "livejh.tk", true },
  { "livekaarten.be", true },
  { "livekaarten.nl", true },
  { "livekarten.at", true },
  { "livekarten.de", true },
  { "livekort.com", true },
  { "livekort.dk", true },
  { "livekort.no", true },
  { "livekort.se", true },
  { "livekortti.com", true },
  { "livekortti.fi", true },
  { "livela.jp", true },
  { "livelifewithintent.com", true },
  { "livelink.tk", true },
  { "livelondon.fr", true },
  { "livenewsrussia.tk", true },
  { "livepaperhelp.com", true },
  { "liveregistratie.nl", true },
  { "liverider.co.jp", true },
  { "livesheep.com", true },
  { "liveslides.com", true },
  { "livesure.com", true },
  { "livetopknigi.gq", true },
  { "livetoride.co.za", true },
  { "livfcshop.com", true },
  { "livi.co", true },
  { "livi.co.uk", true },
  { "livi.fr", true },
  { "living-space.co.nz", true },
  { "living-with-outlook-2010.com", true },
  { "living.digital", true },
  { "living.video", true },
  { "living24.de", true },
  { "livingafrugallife.com", true },
  { "livingforreal.com", true },
  { "livinginhimalone.com", true },
  { "livingkingsinc.net", true },
  { "livingspace.co.nz", true },
  { "livingword.in", true },
  { "livingworduk.org", true },
  { "livive.com", true },
  { "livogeva.dk", true },
  { "livresetmanuscrits.com", true },
  { "livv88.com", true },
  { "lixtick.com", true },
  { "liyang.pro", false },
  { "liz-fry.com", true },
  { "liz.ee", true },
  { "lizardsystems.com", true },
  { "lizheng.de", true },
  { "lizhi.io", true },
  { "lizmooredestinationweddings.com", true },
  { "liztattoo.se", true },
  { "lizzaran.io", true },
  { "lizzian.uk", true },
  { "lizzwood.com", true },
  { "lizzythepooch.com", true },
  { "ljason.cn", true },
  { "ljc.ro", true },
  { "ljoonal.xyz", true },
  { "ljs.io", true },
  { "ljskatt.no", true },
  { "lk-hardware.cz", true },
  { "lk1.bid", true },
  { "lkellar.org", true },
  { "lknw.de", true },
  { "lkw-servis.sk", true },
  { "ll.gr", true },
  { "ll8807.com", true },
  { "ll8819.com", true },
  { "llamasweet.tech", true },
  { "llandudnochristmasfayre.co.uk", true },
  { "llbcpa.com", true },
  { "lldy88.com", true },
  { "llemoz.com", true },
  { "llgj888.com", true },
  { "llgw8.com", true },
  { "llm-guide.com", true },
  { "llnl.gov", true },
  { "lloyd-day.me", true },
  { "llslb.com", false },
  { "llw0x.com", true },
  { "lm-landscapes.co.uk", true },
  { "lm-pumpen.de", false },
  { "lm1628.com", true },
  { "lm228.cn", true },
  { "lm228.com", true },
  { "lm338.cn", true },
  { "lm338.com", true },
  { "lmbyrne.co.uk", true },
  { "lmbyrne.com", true },
  { "lmddgtfy.net", true },
  { "lmintlcx.com", true },
  { "lmmi.nl", true },
  { "lmmtfy.io", true },
  { "lms-luch.ru", true },
  { "lmsptfy.com", true },
  { "lmtls.me", true },
  { "lmtm.eu", true },
  { "lmvsci.gov", true },
  { "lng-17.org", true },
  { "lnhequipmentltd.com", true },
  { "lnhydy.cn", true },
  { "lnrsoft.ddns.net", true },
  { "load-ev.de", true },
  { "loader.us.com", true },
  { "loadlow.me", true },
  { "loadwallet.com", true },
  { "loanaway.ca", true },
  { "loanmatch.sg", true },
  { "loansharkpro.com", true },
  { "loanstreet.nl", true },
  { "lob-assets-staging.com", true },
  { "lob-assets.com", true },
  { "lob-staging.com", true },
  { "lob.com", true },
  { "lobivia.de", true },
  { "lobosdomain.hopto.org", true },
  { "lobsangstudio.com", true },
  { "lobstr.co", true },
  { "loca-voiture.fr", true },
  { "locabir.cf", true },
  { "local360.net", true },
  { "localbandz.com", true },
  { "localbitcoins.com", true },
  { "localblitz.com", true },
  { "localblock.co.za", true },
  { "localbouncycastle.com", true },
  { "localcryptopremium.com", true },
  { "locald.at", true },
  { "localdecor.com.br", true },
  { "localethereum.com", true },
  { "localhorst.duckdns.org", true },
  { "localhost.cat", true },
  { "localhost.ee", true },
  { "localnet.site", true },
  { "localpov.com", true },
  { "localsearch.homes", true },
  { "localseo.repair", true },
  { "localseorepair.co", true },
  { "localseorepair.design", true },
  { "localseorepair.digital", true },
  { "localseorepair.life", true },
  { "localseorepair.ltd", true },
  { "localseorepair.net", true },
  { "localseorepair.network", true },
  { "localseorepair.rocks", true },
  { "localseorepair.services", true },
  { "localseorepair.world", true },
  { "localspot.pl", true },
  { "localtownhouses.ga", true },
  { "locapos.com", true },
  { "location-appartement-dakar.com", true },
  { "locatorplus.gov", true },
  { "locauxrama.fr", true },
  { "lock.me", true },
  { "lock23.ca", true },
  { "lockaby.org", true },
  { "locker.email", true },
  { "locker.plus", true },
  { "lockerroomstories.com", true },
  { "locklock.com.br", true },
  { "locklockbrasil.com.br", true },
  { "lockme.at", true },
  { "lockme.ch", true },
  { "lockme.de", true },
  { "lockme.pl", true },
  { "locknlock.com.br", true },
  { "locknlockbrasil.com.br", true },
  { "lockoutgroup.com", true },
  { "lockpick.nl", true },
  { "lockpicks.se", true },
  { "lockr.jp", true },
  { "locksmith--richmond.com", true },
  { "locksmith--sanantoniotx.com", true },
  { "locksmith-pasadenatx.com", true },
  { "locksmith-sanantonio-tx.com", true },
  { "locksmith-springtx.com", true },
  { "locksmithbalchsprings.com", true },
  { "locksmithballito.com", true },
  { "locksmithbluff.co.za", true },
  { "locksmithdearborn.com", true },
  { "locksmithdickinson-tx.com", true },
  { "locksmithdriftwood.com", true },
  { "locksmithdrippingspringstx.com", true },
  { "locksmithedmonds.com", true },
  { "locksmithforcarshoustontx.com", true },
  { "locksmithfourways24-7.co.za", true },
  { "locksmithfriendswoodtexas.com", true },
  { "locksmithgarland-tx.com", true },
  { "locksmithgrapevinetx.com", true },
  { "locksmithhumbletx.com", true },
  { "locksmithindurban.co.za", true },
  { "locksmithlakewaytx.com", true },
  { "locksmithlivoniami.com", true },
  { "locksmithmadisonheights.com", true },
  { "locksmithmesquitetexas.com", true },
  { "locksmithmesquitetx.com", true },
  { "locksmithmissouricity.com", true },
  { "locksmithresidentialspringtx.com", true },
  { "locksmithsammamishwa.com", true },
  { "locksmithsbuda.com", true },
  { "locksmithscottsdaleaz.com", true },
  { "locksmithseattleco.com", true },
  { "locksmithservice-cypress.com", true },
  { "locksmithservice-humble.com", true },
  { "locksmithsinsanantoniotx.com", true },
  { "locksmithspring.com", true },
  { "locksmithspringtx.com", true },
  { "locksmithssanmarcostx.com", true },
  { "locksmithstaffordtx.com", true },
  { "locksmithswestville.com", true },
  { "locksmiththewoodlands.com", true },
  { "lockwoodchristmastreefarm.com", true },
  { "locomore.com", true },
  { "locomotionds.com", true },
  { "locomotive.net.br", true },
  { "locoserver.net", true },
  { "locurimunca.co", true },
  { "locus-dashboard.com", true },
  { "locusmap.eu", true },
  { "lodash.com", false },
  { "loddeke.eu", true },
  { "lodewijkict.nl", true },
  { "lodus.io", true },
  { "loenshotel.de", true },
  { "loew.de", true },
  { "loforo.com", true },
  { "lofstad.se", true },
  { "lofttravel.com", true },
  { "logactiond.org", true },
  { "loganmarchione.com", true },
  { "loganparkneighborhood.org", true },
  { "logbot.info", true },
  { "logement-saisonnier.com", true },
  { "logentries.com", false },
  { "logexplorer.net", true },
  { "logfile.at", true },
  { "logfile.ch", true },
  { "logicaccountingsolutions.com", true },
  { "logical-invest.com", true },
  { "logicdream.tk", true },
  { "logiciel-entreprise-seurann.fr", true },
  { "logicio.ch", false },
  { "logicio.de", false },
  { "logicio.net", false },
  { "logicne-hise.si", true },
  { "logico.ar", true },
  { "logicoma.com", true },
  { "login.corp.google.com", true },
  { "login.gov", false },
  { "login.launchpad.net", true },
  { "login.ooo", true },
  { "login.raiffeisen.ch", true },
  { "login.sapo.pt", true },
  { "login.ubuntu.com", true },
  { "login.yahoo.com", false },
  { "logitel.de", true },
  { "logo-vogtland.de", true },
  { "logoglo.com", true },
  { "logojoes.net", true },
  { "logopedistalanni.it", true },
  { "logophiliapress.com", true },
  { "logopoeia.com", true },
  { "logostock.jp", true },
  { "logtalk.org", true },
  { "logtalk.pt", true },
  { "logtywardrobe.com", true },
  { "logue.be", true },
  { "logze.nl", true },
  { "lohanaflores.com.br", true },
  { "loheprobado.com", true },
  { "lohmeier.it", true },
  { "lohmeyer.cc", true },
  { "lohr.net", true },
  { "lohvinau.by", true },
  { "loic.gr", true },
  { "loichot.ch", false },
  { "loisircreatif.net", true },
  { "lojadamimo.com.br", true },
  { "lojadanidrea.com.br", true },
  { "lojadarenda.com.br", true },
  { "lojadewhisky.com.br", true },
  { "lojadoarcomprimido.com.br", true },
  { "lojadoprazer.com.br", true },
  { "lojadosomautomotivo.com.br", true },
  { "lojafazendoarte.com.br", true },
  { "lojafilipaper.com.br", true },
  { "lojamagicalx.com", true },
  { "lojamascate.com.br", true },
  { "lojamoleco.com.br", true },
  { "lojaprojetoagua.com.br", true },
  { "lojas25online.com.br", true },
  { "lojaterrazul.com.br", true },
  { "lojavisamed.com.br", true },
  { "lojix.com", false },
  { "lojj.pt", true },
  { "lok.space", true },
  { "lokaal.org", true },
  { "lokal-speisen.de", true },
  { "lokalna.net", true },
  { "loker.id", true },
  { "loket.nl", true },
  { "lolas-vip.com", true },
  { "lolaseuropeancafe.com", true },
  { "lolcloud.ru", true },
  { "lolcow.farm", true },
  { "loli.com", true },
  { "loli.net", true },
  { "loli.pet", true },
  { "loli.ski", true },
  { "loli.today", true },
  { "loli.tube", true },
  { "loli.world", true },
  { "lolibrary.org", true },
  { "lolic.xyz", true },
  { "lolicon.eu", true },
  { "lolivpn.com", true },
  { "lolkot.ru", true },
  { "lolly.cc", true },
  { "lolnames.gg", true },
  { "lolpatrol.de", true },
  { "lolpatrol.wtf", true },
  { "loma.ml", false },
  { "lomaem-nsk.ru", true },
  { "lomayko.ml", true },
  { "lombri-agro.com", true },
  { "lomerhouse.com", true },
  { "lommeregneren.dk", true },
  { "lommyfleet.com", true },
  { "lon-so.com", true },
  { "lona.io", true },
  { "lonasdigital.com", true },
  { "lonavla.tk", true },
  { "london-mafia.tk", true },
  { "london-transfers.com", true },
  { "london.dating", true },
  { "londongallery.net", true },
  { "londongynaecologist.co", true },
  { "londonindustry.it", true },
  { "londonkeyholdingcompany.co.uk", true },
  { "londonlegaltranslation.ae", true },
  { "londonpropertymatch.com", true },
  { "londonseedcentre.co.uk", true },
  { "londontaxipr.com", true },
  { "lonelyhaoss.com", true },
  { "lonelypawn.com", true },
  { "lonelystoner.design", false },
  { "lonelytweets.com", true },
  { "lonesomecosmonaut.com", true },
  { "lonestarlandandcommercial.com", true },
  { "long-journey.com", true },
  { "long008.com", true },
  { "long116.com", true },
  { "long139.com", true },
  { "long18.cc", true },
  { "long226.com", true },
  { "long228.com", true },
  { "long266.com", true },
  { "long288.com", true },
  { "long388.com", true },
  { "long510.com", true },
  { "long510.net", true },
  { "long566.net", true },
  { "long788.com", true },
  { "long8039.com", true },
  { "long8097.com", true },
  { "long918.com", true },
  { "long988.com", true },
  { "longboard-vergleich.com", true },
  { "longboat.io", true },
  { "longhaircareforum.com", true },
  { "longhorn-imports.com", true },
  { "longhorn.id.au", true },
  { "longma168.cn", true },
  { "longma168.com", true },
  { "longstride.net", true },
  { "longtermcare.gov", true },
  { "lonniec.com", true },
  { "lonniemason.net", true },
  { "lonny.ee", true },
  { "lonwan.ru", true },
  { "look.co.il", true },
  { "lookagain.co.uk", true },
  { "lookasik.eu", true },
  { "lookastic.co.uk", true },
  { "lookastic.com", true },
  { "lookastic.de", true },
  { "lookastic.es", true },
  { "lookastic.fr", true },
  { "lookastic.mx", true },
  { "lookastic.ru", true },
  { "lookatmysco.re", true },
  { "lookbetweenthelines.com", true },
  { "looker.wang", false },
  { "lookgadgets.com", true },
  { "lookingstores.fr", true },
  { "lookup-dns.net", true },
  { "lookzook.com", true },
  { "loonylatke.com", true },
  { "loopback.kr", true },
  { "loopstart.org", true },
  { "looseleafsecurity.com", true },
  { "loothole.com", true },
  { "lopes.com.br", true },
  { "loposchokk.com", true },
  { "loqu8.com", true },
  { "loquo.com", true },
  { "loqyu.com", true },
  { "lord.sh", true },
  { "lordjevington.co.uk", true },
  { "lore-seeker.cards", true },
  { "loremipsum.info", true },
  { "lorenadumitrascu.ro", true },
  { "lorenz-hundler.co", true },
  { "lorenzocampagna.myqnapcloud.com", true },
  { "lorenzocompeticion.com", true },
  { "loreofthenorth.com", true },
  { "loreofthenorth.nl", true },
  { "loricozengeller.com", true },
  { "lorimullins.com", true },
  { "lorisfnotary.com", true },
  { "loritaboegl.de", true },
  { "losangelestown.com", true },
  { "losaucas.tk", true },
  { "loshogares.mx", true },
  { "losingweight.coach", true },
  { "losreyesdeldescanso.com.ar", true },
  { "loss.no", true },
  { "lossaicos.tk", true },
  { "lost.host", true },
  { "lost.report", true },
  { "lostandfound.mu", true },
  { "lostinlegends.com", true },
  { "lostinweb.eu", true },
  { "lostkeys.co.uk", true },
  { "lostsandal.com", true },
  { "lostsandal.io", true },
  { "lostserver.com", true },
  { "lostwithdan.com", true },
  { "lotc.cc", true },
  { "lothlorien.ca", false },
  { "lotl.ru", true },
  { "lotn.mobi", true },
  { "lotn.nl", true },
  { "lotnonline.com", true },
  { "lotnonline.nl", true },
  { "lotro-wiki.com", true },
  { "lotsofbargains.com", true },
  { "lottoland.pt", true },
  { "lottospielen24.org", false },
  { "lotw.de", true },
  { "lotz.li", true },
  { "lou-castelet.com", true },
  { "lou.ist", true },
  { "lou.lt", true },
  { "louange-reconvilier.ch", false },
  { "loucanfixit.com", true },
  { "louerunhacker.fr", true },
  { "louisdefunes.tk", true },
  { "louisemisellinteriors.co.uk", true },
  { "louisvillecarguys.com", true },
  { "louisvillefibroids.com", true },
  { "louiza.tk", true },
  { "loune.net", true },
  { "loungecafe.net", true },
  { "loungecafe.org", true },
  { "loungepapillon.com", true },
  { "louremedi.fr", true },
  { "love-books.ga", true },
  { "love-spells-tarot.com", true },
  { "love4musik.com", true },
  { "love4taylor.me", true },
  { "lovebeingsexy.co.uk", true },
  { "lovebigisland.com", true },
  { "loveismystyle.tk", true },
  { "loveisourweapon.com", true },
  { "lovelive.tools", true },
  { "lovelo.store", true },
  { "lovelovenavi.jp", true },
  { "lovemanagementaccounts.co.uk", true },
  { "lovemen.cc", true },
  { "lovemomiji.com", true },
  { "lovemybubbles.com", true },
  { "lovenwishes.com", true },
  { "loveph.one", true },
  { "lover-bg.com", true },
  { "loverepublic.ru", true },
  { "loverngifts.com", true },
  { "lovesmagical.com", false },
  { "lovesupremefestival.com", true },
  { "loveweddingphotosandfilm.co.uk", true },
  { "loveysa.ch", false },
  { "lovg.ren", true },
  { "lovingbody.yoga", true },
  { "lovingearth.co", true },
  { "lovingthermo.com", true },
  { "low-diets.com", true },
  { "lowbidders.com", true },
  { "lowcost.to", true },
  { "lowcostvehicleinsurance.com", true },
  { "lowcostwire.com.au", true },
  { "lowerpricefinder.com", true },
  { "lowestpriceremovals.com.au", true },
  { "lowmagnitude.com", true },
  { "lowsec.space", true },
  { "lowsidetna.com", true },
  { "lowson.ca", true },
  { "loyaltyondemand.club", true },
  { "loyaltyondemand.eu", true },
  { "loyisa.cn", true },
  { "lp-support.nl", true },
  { "lpt-nebreziny.eu", true },
  { "lq.hr", true },
  { "lrdo.net", true },
  { "lriese.ch", true },
  { "lrs.lt", true },
  { "lrssystems.com", true },
  { "lrumeq.com", true },
  { "ls-alarm.de", true },
  { "ls-mapping-team.de", true },
  { "ls-modcompany.com", true },
  { "lsbricks.com", true },
  { "lsc-dillingen.de", true },
  { "lsc.gov", true },
  { "lsh1688.com", true },
  { "lshiy.com", true },
  { "lsiq.io", true },
  { "lsl.eu", true },
  { "lsmentor.com", true },
  { "lsmpx.com", true },
  { "lspdonline.gq", true },
  { "lsquo.com", true },
  { "lsscreens.de", true },
  { "lstlx.com", true },
  { "lsy.cn", true },
  { "lsys.ac", true },
  { "lt.search.yahoo.com", false },
  { "ltaake.com", true },
  { "ltcwaterwijk.nl", true },
  { "ltecode.com", true },
  { "ltheinrich.de", true },
  { "ltib.com.au", true },
  { "ltlec.cn", true },
  { "ltlec.com", true },
  { "ltls.org", true },
  { "ltn-tom-morel.fr", true },
  { "ltprtz.co.uk", true },
  { "lts-tec.de", true },
  { "ltservers.net", true },
  { "lu.search.yahoo.com", false },
  { "luan.ma", true },
  { "luav.org", true },
  { "lubar.me", true },
  { "lubbockyounglawyers.org", true },
  { "lubot.net", true },
  { "luc-oberson.ch", false },
  { "luca-steeb.com", true },
  { "lucacastelnuovo.nl", true },
  { "lucafontana.net", true },
  { "lucafrancesca.me", true },
  { "lucasbergen.ca", true },
  { "lucasdamasceno.com", true },
  { "lucasem.com", true },
  { "lucasgymnastics.com", true },
  { "lucasit.com", true },
  { "lucaslarson.net", true },
  { "lucassoler.com.ar", false },
  { "luce.life", true },
  { "luchscheider.de", false },
  { "luchthavenmaastricht.nl", true },
  { "lucid-light.de", true },
  { "lucid-reality.ch", true },
  { "lucidframeworks.com", true },
  { "lucidlight.de", true },
  { "lucidlink.com", true },
  { "lucie-parizkova.cz", true },
  { "lucie.jp", true },
  { "lucielavickova.com", true },
  { "lucille-thomas.fr", true },
  { "lucky-frog.co.uk", true },
  { "luckycastles.co.uk", true },
  { "luckyfrog.hk", true },
  { "luckystorevn.com", true },
  { "luclu7.fr", true },
  { "luctam.com", true },
  { "lucybles.com", true },
  { "lucyhancock.tech", true },
  { "lucymontebello-arte.com", true },
  { "lucyparsonslabs.com", true },
  { "lucz.co", true },
  { "luda.me", true },
  { "ludek.biz", true },
  { "ludikovsky.name", true },
  { "ludofantasy.fr", true },
  { "ludogue.net", true },
  { "ludolust.tk", true },
  { "ludothek-burgdorf.ch", true },
  { "ludovic-frank.fr", true },
  { "ludovic-muller.fr", true },
  { "ludum-polus.xyz", true },
  { "ludwig.im", true },
  { "ludwiggrill.de", true },
  { "ludwigjohnson.se", true },
  { "ludwigpro.net", true },
  { "luedeke-bremen.eu", true },
  { "lueersen.homedns.org", true },
  { "luehne.de", true },
  { "luelistan.net", true },
  { "luenwarneke.com", true },
  { "luera1959.de", true },
  { "lueurexterne-audiovisuel.com", true },
  { "lueurexterne.com", true },
  { "luffyhair.com", true },
  { "luftbild-siegerland.de", true },
  { "luftreiniger.biz", true },
  { "lugbb.org", true },
  { "luginbuehl.be", true },
  { "luginbuehl.eu", true },
  { "lugui.in", true },
  { "luisa-birkner.de", true },
  { "luiscapelo.info", true },
  { "luisfariasgrupo.com", true },
  { "luismaier.de", true },
  { "luissotodesign.com", true },
  { "luisyr.com", true },
  { "luizkowalski.net", true },
  { "luizlopes.com", false },
  { "luk.earth", true },
  { "lukas-gorr.de", true },
  { "lukas-meixner.com", true },
  { "lukas-schauer.de", true },
  { "lukas.im", true },
  { "lukas2511.de", true },
  { "lukasberan.com", true },
  { "lukasberan.cz", true },
  { "lukasfunk.com", true },
  { "lukasrod.cz", true },
  { "lukasschauer.de", true },
  { "lukasschick.de", false },
  { "lukaszuk.net", true },
  { "lukaszuk.pl", true },
  { "lukaszwojcik.com", true },
  { "lukaszwojcik.net", true },
  { "luke.ch", true },
  { "luke6887.me", true },
  { "lukeistschuld.de", true },
  { "lukem.net", true },
  { "lukeng.net", true },
  { "lukesbouncycastlehire.com", true },
  { "lukestebbing.com", true },
  { "lukezweb.tk", true },
  { "lukin.ga", true },
  { "lukull-pizza.de", true },
  { "lulua.pl", true },
  { "lumbercartel.ca", true },
  { "lumen.sh", true },
  { "lumenbrowser.com", true },
  { "lumi.pw", true },
  { "lumierewithinspirato.com", true },
  { "luminaire.fr", true },
  { "luminary.pl", true },
  { "lumitop.com", true },
  { "lumiwellnessshop.com", true },
  { "lumminary.com", true },
  { "lumomongoose.com", true },
  { "lunakit.org", true },
  { "lunalove.de", true },
  { "lunanova.moe", true },
  { "lunapps.com", true },
  { "lunar6.ch", false },
  { "lunarflake.com", true },
  { "lunarlog.com", true },
  { "lunarshark.com", true },
  { "lunarsoft.net", true },
  { "lunartail.nl", true },
  { "lunasqu.ee", true },
  { "lunazacharias.com", true },
  { "lunchbunch.me", true },
  { "lundberghealthadvocates.com", true },
  { "lune-indigo.ch", false },
  { "lunepieters.co.za", true },
  { "lunidea.ch", false },
  { "lunidea.com", false },
  { "lunis.net", true },
  { "lunite.net", true },
  { "lunix.io", true },
  { "luoe.me", true },
  { "luoh.cc", true },
  { "luoh.me", true },
  { "luongvu.com", true },
  { "luowu.cc", true },
  { "lupa.cz", true },
  { "lupecode.com", true },
  { "lupinencyclopedia.com", true },
  { "lupinenorthamerica.com", true },
  { "lushan.me", true },
  { "lusitom.com", true },
  { "luso-livros.net", true },
  { "lustin.fr", true },
  { "lustrum.ch", true },
  { "luteijn.biz", true },
  { "luteijn.cloud", true },
  { "luteijn.email", true },
  { "luteijn.pro", true },
  { "luthierunatespalermo.com", true },
  { "lutoma.org", true },
  { "luu.moe", true },
  { "luukdebruincv.nl", true },
  { "luukklene.nl", true },
  { "luukuton.fi", true },
  { "luuppi.fi", true },
  { "luv-scent.com", true },
  { "luv.asn.au", true },
  { "luv2watchmycam.com", true },
  { "luvare.com", true },
  { "luvbridal.com.au", true },
  { "luvhacks.com", true },
  { "luvplay.co.uk", true },
  { "luvscent.com", true },
  { "lux-house.tk", true },
  { "luxecalendar.com", true },
  { "luxhome.tk", true },
  { "luxsci.com", true },
  { "luxur.is", true },
  { "luxurydistribution.cz", true },
  { "luxurynsight.net", false },
  { "luxuryweddingsindonesia.com", true },
  { "luxusnivoucher.cz", true },
  { "luxusnyvoucher.sk", true },
  { "luxvacuos.net", true },
  { "luyckx.net", true },
  { "luzat.com", true },
  { "luzfaltex.com", true },
  { "lv.search.yahoo.com", false },
  { "lv0.it", true },
  { "lvcshu.com", true },
  { "lvftw.com", true },
  { "lvguitars.com", true },
  { "lvmoo.com", true },
  { "lvrsystems.com", true },
  { "lvtrafficticketguy.com", true },
  { "lw-addons.net", true },
  { "lwl12.com", true },
  { "lwsl.ink", true },
  { "lx-blog.cn", true },
  { "lxai.net", true },
  { "lxd.cc", true },
  { "lxx4380.com", true },
  { "lyax.be", true },
  { "lycly.me", true },
  { "lydudlejning.net", true },
  { "lyfebotanicals.com", true },
  { "lyftrideestimate.com", true },
  { "lykai.ca", true },
  { "lykope.com", true },
  { "lymia.moe", true },
  { "lyna.ml", true },
  { "lynero.dk", true },
  { "lyness.io", true },
  { "lyness.uk", true },
  { "lyngvaer.no", true },
  { "lynnellneri.com", true },
  { "lynnlaytonnissanparts.com", true },
  { "lynsec.com", true },
  { "lynthium.com", true },
  { "lynx.nl", true },
  { "lynxbroker.de", true },
  { "lynxpro.nl", true },
  { "lyon-interactive.com", true },
  { "lyon-synergie.com", true },
  { "lyonslawlink.com", true },
  { "lyrical-nonsense.com", true },
  { "lyricfm.ie", true },
  { "lyriksidan.ga", true },
  { "lys.ch", true },
  { "lysbed.com", true },
  { "lyscnd.com", true },
  { "lyst.co.uk", true },
  { "lyuda.tk", true },
  { "lyuly.com", true },
  { "lyx.dk", true },
  { "lzcreation.com", true },
  { "lzh.one", true },
  { "lzwc.nl", true },
  { "m-16.ml", true },
  { "m-22.com", true },
  { "m-beshr.tk", true },
  { "m-chemical.com.hk", true },
  { "m-cont.cz", true },
  { "m-gh.info", true },
  { "m-idea.jp", true },
  { "m-kleinert.de", true },
  { "m-kugpn.ru", true },
  { "m-mail.fr", true },
  { "m-monitor.pl", true },
  { "m-net.de", true },
  { "m-orthodontic.com", true },
  { "m-ses.fr", true },
  { "m-team.cc", true },
  { "m.facebook.com", true },
  { "m.mail.ru", true },
  { "m.me", true },
  { "m0t0k1ch1.com", true },
  { "m132.eu", true },
  { "m134.eu", true },
  { "m1gun.tk", true },
  { "m23cal.eu", true },
  { "m2epro.com", true },
  { "m2h-fiscaliste.fr", true },
  { "m2il.co", true },
  { "m2os.com", true },
  { "m2tm.fr", true },
  { "m36533.com", true },
  { "m36594.com", true },
  { "m3windowsanddoors.com", true },
  { "m4all.gr", true },
  { "m4g.ru", true },
  { "m51365.com", true },
  { "m6pub.fr", true },
  { "m81818.com", true },
  { "m8593.com", true },
  { "ma-eir.nl", true },
  { "ma-maison-container.fr", true },
  { "ma-maison-ossature-bois.fr", true },
  { "ma-ze-linux.tk", true },
  { "ma2t.com", true },
  { "maartenderaedemaeker.be", true },
  { "maartenvandekamp.nl", true },
  { "maatwerkzorgcoaching.nl", true },
  { "maaya.jp", true },
  { "maayogashram.com", true },
  { "mabankonline.com", true },
  { "mabulledu.net", true },
  { "mac-i-tea.ch", false },
  { "mac-service-stockholm.se", true },
  { "mac-servicen.se", true },
  { "mac-support.nu", true },
  { "mac-support.se", true },
  { "mac-world.pl", true },
  { "mac.biz.tr", true },
  { "mac.osaka.jp", true },
  { "macangus-wainwright.com", true },
  { "macaos.com", true },
  { "macappstudio.com", true },
  { "macaroonshindig.tk", true },
  { "macaws.org", true },
  { "macbook.es", true },
  { "macedonian-hotels.com", true },
  { "macedonian-hotels.com.mk", true },
  { "macedonian-hotels.mk", true },
  { "maceinturecuir.com", true },
  { "maces-net.de", true },
  { "macgeneral.de", false },
  { "macgenius.com", true },
  { "mach-politik.ch", true },
  { "macha.cloud", true },
  { "macha.love", true },
  { "machbach.com", true },
  { "machetewp.com", true },
  { "machidaclip.com", true },
  { "machikka.com", false },
  { "machine.email", true },
  { "machinetransport.com", true },
  { "machon.biz", true },
  { "macht-elektro.de", true },
  { "machtweb.de", true },
  { "machu-picchu.nl", true },
  { "macil.tech", true },
  { "macji-raj.si", true },
  { "macker.io", true },
  { "mackeysack.com", true },
  { "macksproductions.in", true },
  { "maclemon.at", true },
  { "macleod.io", true },
  { "macnemo.de", true },
  { "macnetwork.eu", false },
  { "macnetwork.fr", false },
  { "macnetwork.net", false },
  { "macnugget.org", true },
  { "maco.org.uk", true },
  { "macon.de", true },
  { "maconnerie-dcs.ch", true },
  { "macpress.com.br", true },
  { "macreosolutions.com", true },
  { "macros.co.jp", true },
  { "macroseo.tk", true },
  { "macsupportnacka.se", true },
  { "macsupportstockholm.se", true },
  { "mactools.com.co", true },
  { "madae.nl", true },
  { "madamegarage.nl", true },
  { "madars.org", false },
  { "madbin.com", true },
  { "madbouncycastles.co.uk", true },
  { "maddi.biz", true },
  { "maddistonevangelical.co.uk", true },
  { "maddreefer.com", true },
  { "made-in-earth.co.jp", true },
  { "made-to-usb.com", true },
  { "madebydusk.com", true },
  { "madebyshore.com", true },
  { "madeinolive.com", true },
  { "madeinrussia.com", true },
  { "madeinstudio3.com", true },
  { "madeira.gov.pt", true },
  { "madeitwor.se", true },
  { "madeloc.com", true },
  { "mademoe.com", true },
  { "mademoiselledemargaux.com", true },
  { "mader.jp", true },
  { "madewithopendata.org", true },
  { "madgeandpaul.com", true },
  { "madgech.com", true },
  { "madgeisawesome.com", true },
  { "madin.ru", true },
  { "madirc.net", true },
  { "madisoncountyhelps.com", true },
  { "madisonent-facialplasticsurgery.com", true },
  { "madisonsquarerealestate.com", true },
  { "madmar.ee", true },
  { "madmax-store.gr", true },
  { "madoka.nu", true },
  { "madpsy.uk", true },
  { "madrants.net", true },
  { "madreluna.it", true },
  { "madreshoy.com", true },
  { "madridagency.com", true },
  { "madridartcollection.com", true },
  { "madscientistwebdesign.com", true },
  { "madskauts.tk", true },
  { "madsstorm.dk", true },
  { "madtec.de", true },
  { "maduradas.info", true },
  { "maduradas.net", true },
  { "maedchenflohmarkt.at", true },
  { "maedchenflohmarkt.de", true },
  { "maekha.in.th", true },
  { "maeln.com", true },
  { "maelstrom-fury.eu", true },
  { "maelstrom.ninja", true },
  { "maeplasticsurgery.com", true },
  { "maesinox.be", true },
  { "maewongaming.tk", true },
  { "maff.co.uk", true },
  { "maff.scot", true },
  { "mafia.network", true },
  { "mafiaforum.de", true },
  { "mafiapenguin.club", true },
  { "mafiasi.de", true },
  { "magaconnection.com", true },
  { "magasindejouets.com", true },
  { "magasinsalledebain.be", true },
  { "magasinsalledebain.fr", true },
  { "magasinsalledebains.be", true },
  { "magasinsalledebains.fr", true },
  { "magasinsenfrance.com", true },
  { "magazilla.ga", true },
  { "magazin3513.com", true },
  { "magazinecards.ga", true },
  { "magazinedotreino.com.br", true },
  { "magdic.eu", true },
  { "magebit.com", true },
  { "magebrawl.com", true },
  { "magenda.sk", true },
  { "magentaize.net", true },
  { "magentapinkinteriors.co.uk", true },
  { "magentoeesti.eu", true },
  { "magepro.fr", true },
  { "magestionfinanciere.com", true },
  { "magewell.nl", true },
  { "maggie.com", true },
  { "maggot.cf", true },
  { "magi-cake.com", true },
  { "magic-cards.info", true },
  { "magic-cheerleading.tk", true },
  { "magic-photo-events.fr", true },
  { "magical-secrets.com", true },
  { "magical.rocks", true },
  { "magicball.co", true },
  { "magicbeanschool.com", true },
  { "magicbroccoli.de", true },
  { "magiccards.info", true },
  { "magicdaysomagh.co.uk", true },
  { "magicdlp.com", true },
  { "magicjudges.org", true },
  { "magiclen.org", true },
  { "magicnethosting.com", true },
  { "magicroom.it", true },
  { "magicsms.pl", true },
  { "magicspaceninjapirates.de", true },
  { "magicstay.com", true },
  { "magictable.com", true },
  { "magicvodi.at", true },
  { "magisternegi.tk", true },
  { "magnacarebroker.com", true },
  { "magnate.co", true },
  { "magnatronic.com.br", true },
  { "magnes.priv.pl", true },
  { "magnesium-biomed.ch", true },
  { "magnesy-neodymowe.com.pl", true },
  { "magnesy-neodymowe.pl", true },
  { "magnesy-tanio.net", true },
  { "magnesy.de", true },
  { "magnesy.net.pl", true },
  { "magnesy.priv.pl", true },
  { "magnetgaming.com", true },
  { "magneticattraction.com.au", true },
  { "magnetoscopio.tk", true },
  { "magnetpass.uk", true },
  { "magnets.jp", true },
  { "magnificatwellnesscenter.com", true },
  { "magnificentdata.com", true },
  { "magniflood.com", true },
  { "magnoliastrong.com", true },
  { "magnumwallet.co", true },
  { "magnunbaterias.com.br", true },
  { "magonote-nk.com", true },
  { "magravsitalia.com", true },
  { "magu.kz", true },
  { "maguire.email", true },
  { "maguire.tk", true },
  { "magwin.co.uk", true },
  { "magyarepitok.hu", true },
  { "mahadulmuneer.org", true },
  { "mahalux.com", true },
  { "mahalux.cz", true },
  { "mahatmayoga.org", true },
  { "mahawi.sk", true },
  { "mahjong-navi.com", true },
  { "mahjong.org", true },
  { "mahjongrush.com", true },
  { "mahler.io", true },
  { "mahrer.net", true },
  { "maiaimobiliare.ro", true },
  { "maichun.info", true },
  { "maidenliput.fi", true },
  { "maidoty.net", true },
  { "maiebanatulfruncea.com", true },
  { "maiet.net", true },
  { "maijia800.com", true },
  { "maikolfish.it", true },
  { "maikoloc.com", true },
  { "mail-de.jp", true },
  { "mail-rotter.de", true },
  { "mail-settings.google.com", true },
  { "mail.com", true },
  { "mail.de", true },
  { "mail.google.com", true },
  { "mail.storage", true },
  { "mail.yahoo.com", false },
  { "mail180.com", true },
  { "mail4you.in", true },
  { "mailbox.mg", true },
  { "mailbox.org", true },
  { "mailbro.de", true },
  { "mailer.site", true },
  { "mailfence.com", true },
  { "mailflank.com", true },
  { "mailhardener.com", true },
  { "mailinabox.email", true },
  { "mailinaitor.tk", true },
  { "mailingproduct.tk", true },
  { "mailjunky.de", true },
  { "maillady-susume.com", true },
  { "mailmag.net", true },
  { "mailmaster.tk", true },
  { "mailnara.co.kr", true },
  { "mailsend.ml", true },
  { "mailstart.ga", true },
  { "mailtelligent.com", true },
  { "mailto.space", true },
  { "mailtobiz.tk", true },
  { "mailtrap.io", true },
  { "mailum.org", false },
  { "mailwala.tk", true },
  { "mailxpress.ga", true },
  { "main-freedom.ru", true },
  { "mainechiro.com", true },
  { "mainframeserver.space", true },
  { "mainhattan-handwerker.de", true },
  { "mainlined.org", true },
  { "mainone.net", true },
  { "mainquest.org", true },
  { "mainston.com", true },
  { "maintenance-traceur-hp.fr", true },
  { "mainzelmaennchen.net", true },
  { "maioresemelhores.com", true },
  { "mairie-sornay.fr", true },
  { "maisan.best", true },
  { "maiscelular.com.br", true },
  { "maisgasolina.com", true },
  { "maison-haimard.fr", true },
  { "maisondoree.be", true },
  { "maisonpaulmier.fr", true },
  { "maispa.com", true },
  { "maisretorno.com", true },
  { "maisvitaminas.com.br", true },
  { "maisy.io", true },
  { "maitheme.com", true },
  { "maiti.info", true },
  { "maitrise-orthopedique.com", true },
  { "majahoidja.ee", true },
  { "majaweb.cz", true },
  { "majemedia.com", false },
  { "majesnix.org", true },
  { "majid.info", true },
  { "majkassab.com", true },
  { "majkassab.net", true },
  { "majkassab.org", true },
  { "majkl.me", true },
  { "majkl.xyz", true },
  { "majkl578.cz", true },
  { "majkyto.cz", true },
  { "majlovesreg.one", true },
  { "majolka.com", true },
  { "majorpaintingco.com", true },
  { "majorpussycum.com", true },
  { "makaleci.com", true },
  { "makalu.me", true },
  { "make-your-own-song.com", true },
  { "makeaboldmove.com", true },
  { "makechanges.com.au", true },
  { "makedin.net", true },
  { "makefoodrecipes.com", true },
  { "makejusticework.org.uk", true },
  { "makenaiyo-fx.com", true },
  { "makerdao.com", true },
  { "makermiles.com", true },
  { "makermiles.net", true },
  { "makermiles.org", true },
  { "makersatwork.com", true },
  { "maketheneighborsjealous.com", true },
  { "makeurbiz.com", true },
  { "maki-chan.de", true },
  { "makinen.ru", true },
  { "makita-online.kz", true },
  { "makkusu.photo", true },
  { "makkyon.com", true },
  { "maklerinfo.biz", true },
  { "makos.jp", true },
  { "makowitz.cz", true },
  { "maktoob.search.yahoo.com", false },
  { "maku.edu.tr", true },
  { "malachiteauth.com", true },
  { "maladie-autoimmune.fr", true },
  { "malariaadvice.gq", true },
  { "malash.me", false },
  { "malasuk.com", true },
  { "malaysia.search.yahoo.com", false },
  { "malaysian.dating", true },
  { "malaysianews.ml", true },
  { "maldives.cx", true },
  { "malediven.biz", true },
  { "malenaamatomd.com", true },
  { "malenyflorist.com.au", true },
  { "maleperformancepills.com", true },
  { "maler-marschalleck.de", true },
  { "malermeister-haussmann.de", true },
  { "malezan.com", true },
  { "maliar.fr", true },
  { "malibu-electric.com", true },
  { "malibuelectrical.com", true },
  { "malibuexteriorlighting.com", true },
  { "malibumodas.com.br", true },
  { "malik.id", true },
  { "malikussa.id", true },
  { "malikussaid.com", true },
  { "malikzinad.com", true },
  { "malinaclub.com", true },
  { "malinheadview.ie", true },
  { "malkoun.com", true },
  { "mall.cz", true },
  { "mall.hr", true },
  { "mall.hu", true },
  { "mall.pl", true },
  { "mall.sk", true },
  { "mallach.net", true },
  { "mallonline.com.br", true },
  { "malnex.de", true },
  { "malond.com", true },
  { "malta-firma.com", true },
  { "maltasite.tk", true },
  { "maltaultrastifo.tk", true },
  { "malte-kiefer.de", true },
  { "malufs.com.br", true },
  { "malvertise.xyz", true },
  { "malware.watch", true },
  { "malwareinvestigator.gov", true },
  { "malwarekillers.com", true },
  { "malwaretips.com", true },
  { "malyshata.com", true },
  { "malysvet.net", false },
  { "mamabepo.com", true },
  { "mamadoma.com.ua", true },
  { "mamaisondefamille.info", true },
  { "mamamoet.ru", true },
  { "mamanakormit.tk", true },
  { "mamanecesitaungintonic.com", true },
  { "mamasorganizedchaos.com", true },
  { "mambas.cn", true },
  { "mame.cl", true },
  { "mammals.net", true },
  { "mammaw.com", true },
  { "mammooc.org", true },
  { "mammothlakesmls.net", true },
  { "mamospienas.lt", true },
  { "mamot.fr", false },
  { "mamsds.com", true },
  { "mamtapark.tk", true },
  { "mamuko.nl", true },
  { "man-stuff.co.uk", true },
  { "man3s.jp", false },
  { "mana.ee", true },
  { "manach.net", true },
  { "manage.cm", true },
  { "manage4all.de", true },
  { "manageathome.co.uk", true },
  { "managedhosting.de", true },
  { "managedservicesraleighnc.com", true },
  { "management-companie.ro", true },
  { "managementboek.nl", true },
  { "managementfeedback.com", true },
  { "managementforstartups.com", true },
  { "manageprefs.com", true },
  { "manageprojects.com", false },
  { "manager-efficacement.com", true },
  { "manager.linode.com", false },
  { "managewp.org", true },
  { "manantialdevida1450.com", true },
  { "manatees.com.au", true },
  { "manatees.net", true },
  { "manawill.jp", true },
  { "manawithtea.com", true },
  { "manchestercleaner.co.uk", true },
  { "mancrates.com", true },
  { "mandcbouncycastlehire.co.uk", true },
  { "mandela-effect-wiki.tk", true },
  { "mandilabeachhotel.com", true },
  { "mandynamic.gr", true },
  { "maneggio.milano.it", true },
  { "manelli.fr", true },
  { "maneql.co.jp", true },
  { "maneql.info", true },
  { "manesht.ir", true },
  { "manfredgruber.net", true },
  { "manfredi.io", true },
  { "manfredimatteo.com", true },
  { "manfredschafer.ch", true },
  { "mangabank.net", true },
  { "mangabank.org", true },
  { "mangaboxes.ml", true },
  { "mangahigh.com", true },
  { "mangareactor.tk", true },
  { "mangaristica.com", false },
  { "mangaworld.gq", true },
  { "mangotwoke.co.uk", true },
  { "manhattanchoralensemble.org", true },
  { "manhole.club", true },
  { "manhuagui.com", true },
  { "mani.tw", true },
  { "manicbouncycastles.co.uk", true },
  { "manicode.com", true },
  { "manicur-salon.tk", true },
  { "manicuradegel.com", true },
  { "manicuradegel.es", true },
  { "manilaprinciples.org", true },
  { "maniorpedi.com", true },
  { "maniosglass.gr", true },
  { "manipil.ch", true },
  { "manipurmatka.net", false },
  { "manitaggarwal.com", true },
  { "manja-und-martin.de", true },
  { "manjaro.ru", true },
  { "mankans.com", false },
  { "mankomarketing.com", true },
  { "manmeetgill.com", true },
  { "manneguiden.no", true },
  { "mannheimbloggt.tk", true },
  { "manns-solutions.co.uk", true },
  { "mannschafft.ch", true },
  { "manoirdecontres.com", true },
  { "manonamission.de", true },
  { "manonandre-avocat.fr", true },
  { "manoro.de", true },
  { "mansarda-life.net", true },
  { "mansdell.net", true },
  { "mansfeld.pl", true },
  { "manshatech.com", true },
  { "manski.net", true },
  { "mansora.net", true },
  { "mantabiofuel.com", true },
  { "mantachiepharmacy.com", true },
  { "mantenimientoimpresoras.com", true },
  { "manti.by", true },
  { "mantor.org", false },
  { "mantul.top", true },
  { "manualidadeson.com", true },
  { "manuall.co.uk", true },
  { "manuall.cz", true },
  { "manuall.de", true },
  { "manuall.dk", true },
  { "manuall.es", true },
  { "manuall.fi", true },
  { "manuall.fr", true },
  { "manuall.info.tr", true },
  { "manuall.it", true },
  { "manuall.jp", true },
  { "manuall.kr", true },
  { "manuall.no", true },
  { "manuall.pl", true },
  { "manuall.pt", true },
  { "manuall.ro", true },
  { "manuall.se", true },
  { "manualscollection.com", true },
  { "manuel-herrmann.de", true },
  { "manuel-schefczyk.de", true },
  { "manuel7espejo.com", true },
  { "manuelguerra.pt", true },
  { "manueli.de", true },
  { "manuelpinto.in", true },
  { "manufacturing.gov", false },
  { "manufacturinginmexico.org", true },
  { "manufacturingusa.com", false },
  { "manuscripteditorial.com", true },
  { "manuscriptlink.com", true },
  { "manusiasosial.tk", true },
  { "manutd.org.np", true },
  { "manuth.life", true },
  { "manwish.cn", true },
  { "manwithavan.co.uk", true },
  { "manylots.ru", true },
  { "maoi.re", true },
  { "maomihz.com", true },
  { "maone.net", true },
  { "maorx.cn", true },
  { "maosensanguentadasdejesus.net", true },
  { "maowtm.org", true },
  { "maozedong.red", true },
  { "map-patho.com", true },
  { "map4erfurt.de", true },
  { "map4jena.de", true },
  { "mapasmundi.com.br", true },
  { "mapblender.com", true },
  { "mapchange.org", true },
  { "mapeo.io", true },
  { "maplebgm.cc", true },
  { "maplegate.info", true },
  { "mapletime.com", true },
  { "mapresidentielle.fr", true },
  { "mapstack.org", true },
  { "maquinariaspesadas.org", true },
  { "maquinariastitan.com", true },
  { "maquinasdecoserplus.com", true },
  { "mar-eco.no", true },
  { "marabumadrid.com", false },
  { "marabunta.io", true },
  { "marakovits.net", true },
  { "marble.com", true },
  { "marblemosaics.ga", true },
  { "marbogardenlidkoping.se", true },
  { "marbree.eu", true },
  { "marbrerie-segur.fr", true },
  { "marc-beninca.fr", true },
  { "marc-hammer.de", true },
  { "marc-hoffrichter.de", true },
  { "marc-schlagenhauf.de", true },
  