# Auto-generated by asn1ate v.0.6.1.dev0 from rfc4120.asn1
# (last modified on 2023-07-04 13:41:26.112349)

# KerberosV5Spec2
from pyasn1.type import univ, char, namedtype, namedval, tag, constraint, useful


def _OID(*components):
    output = []
    for x in tuple(components):
        if isinstance(x, univ.ObjectIdentifier):
            output.extend(list(x))
        else:
            output.append(int(x))

    return univ.ObjectIdentifier(output)


class Int32(univ.Integer):
    pass


Int32.subtypeSpec = constraint.ValueRangeConstraint(-2147483648, 2147483647)


class AuthDataType(Int32):
    pass


class AuthorizationData(univ.SequenceOf):
    pass


AuthorizationData.componentType = univ.Sequence(componentType=namedtype.NamedTypes(
    namedtype.NamedType('ad-type', AuthDataType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('ad-data', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
))


class AD_AND_OR(univ.Sequence):
    pass


AD_AND_OR.componentType = namedtype.NamedTypes(
    namedtype.NamedType('condition-count', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('elements', AuthorizationData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class AD_IF_RELEVANT(AuthorizationData):
    pass


class ExternalPrincipalIdentifier(univ.Sequence):
    pass


ExternalPrincipalIdentifier.componentType = namedtype.NamedTypes(
    namedtype.OptionalNamedType('subjectName', univ.OctetString().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('issuerAndSerialNumber', univ.OctetString().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('subjectKeyIdentifier', univ.OctetString().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2)))
)


class AD_INITIAL_VERIFIED_CAS(univ.SequenceOf):
    pass


AD_INITIAL_VERIFIED_CAS.componentType = ExternalPrincipalIdentifier()


class ChecksumType(Int32):
    pass


class Checksum(univ.Sequence):
    pass


Checksum.componentType = namedtype.NamedTypes(
    namedtype.NamedType('cksumtype', ChecksumType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('checksum', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class KerberosString(char.GeneralString):
    pass


class NameType(Int32):
    pass


class PrincipalName(univ.Sequence):
    pass


PrincipalName.componentType = namedtype.NamedTypes(
    namedtype.NamedType('name-type', NameType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('name-string', univ.SequenceOf(componentType=KerberosString()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class Realm(KerberosString):
    pass


class AD_KDCIssued(univ.Sequence):
    pass


AD_KDCIssued.componentType = namedtype.NamedTypes(
    namedtype.NamedType('ad-checksum', Checksum().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.OptionalNamedType('i-realm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('i-sname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.NamedType('elements', AuthorizationData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3)))
)


class AD_MANDATORY_FOR_KDC(AuthorizationData):
    pass


class EncryptionType(Int32):
    pass


class EncryptedData(univ.Sequence):
    pass


EncryptedData.componentType = namedtype.NamedTypes(
    namedtype.NamedType('etype', EncryptionType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('kvno', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('cipher', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2)))
)


class AP_REP(univ.Sequence):
    pass


AP_REP.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 15))
AP_REP.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pvno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('msg-type', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(15)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('enc-part', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2)))
)


class KerberosFlags(univ.BitString):
    pass


KerberosFlags.subtypeSpec=constraint.ValueSizeConstraint(1, 32)


class APOptions(KerberosFlags):
    pass


class Ticket(univ.Sequence):
    pass


Ticket.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 1))
Ticket.componentType = namedtype.NamedTypes(
    namedtype.NamedType('tkt-vno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('realm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('sname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.NamedType('enc-part', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3)))
)


class AP_REQ(univ.Sequence):
    pass


AP_REQ.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 14))
AP_REQ.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pvno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('msg-type', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(14)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('ap-options', APOptions().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.NamedType('ticket', Ticket().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.NamedType('authenticator', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4)))
)


class APOptionsValues(univ.BitString):
    pass


APOptionsValues.namedValues = namedval.NamedValues(
    ('reserved', 0),
    ('use-session-key', 1),
    ('mutual-required', 2)
)


class APOptionsSequence(univ.Sequence):
    pass


APOptionsSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', APOptionsValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class PADataType(Int32):
    pass


class PA_DATA(univ.Sequence):
    pass


PA_DATA.componentType = namedtype.NamedTypes(
    namedtype.NamedType('padata-type', PADataType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('padata-value', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2)))
)


class KDC_REP(univ.Sequence):
    pass


KDC_REP.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pvno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('msg-type', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(11, 13)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('padata', univ.SequenceOf(componentType=PA_DATA()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.NamedType('crealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.NamedType('cname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4))),
    namedtype.NamedType('ticket', Ticket().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 5))),
    namedtype.NamedType('enc-part', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 6)))
)


class AS_REP(KDC_REP):
    pass


AS_REP.tagSet = KDC_REP.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 11))


class HostAddress(univ.Sequence):
    pass


HostAddress.componentType = namedtype.NamedTypes(
    namedtype.NamedType('addr-type', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('address', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class HostAddresses(univ.SequenceOf):
    pass


HostAddresses.componentType = HostAddress()


class KDCOptions(KerberosFlags):
    pass


class KerberosTime(useful.GeneralizedTime):
    pass


class UInt32(univ.Integer):
    pass


UInt32.subtypeSpec = constraint.ValueRangeConstraint(0, 4294967295)


class KDC_REQ_BODY(univ.Sequence):
    pass


KDC_REQ_BODY.componentType = namedtype.NamedTypes(
    namedtype.NamedType('kdc-options', KDCOptions().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('cname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1))),
    namedtype.NamedType('realm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('sname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3))),
    namedtype.OptionalNamedType('from', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 4))),
    namedtype.NamedType('till', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 5))),
    namedtype.OptionalNamedType('rtime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 6))),
    namedtype.NamedType('nonce', UInt32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 7))),
    namedtype.NamedType('etype', univ.SequenceOf(componentType=EncryptionType()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 8))),
    namedtype.OptionalNamedType('addresses', HostAddresses().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 9))),
    namedtype.OptionalNamedType('enc-authorization-data', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 10))),
    namedtype.OptionalNamedType('additional-tickets', univ.SequenceOf(componentType=Ticket()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 11)))
)


class KDC_REQ(univ.Sequence):
    pass


KDC_REQ.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pvno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('msg-type', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(10, 12)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('padata', univ.SequenceOf(componentType=PA_DATA()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.NamedType('req-body', KDC_REQ_BODY().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4)))
)


class AS_REQ(KDC_REQ):
    pass


AS_REQ.tagSet = KDC_REQ.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 10))


ub_domain_name_length = univ.Integer(16)


class AdministrationDomainName(univ.Choice):
    pass


AdministrationDomainName.tagSet = univ.Choice.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 2))
AdministrationDomainName.componentType = namedtype.NamedTypes(
    namedtype.NamedType('numeric', char.NumericString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, ub_domain_name_length))),
    namedtype.NamedType('printable', char.PrintableString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, ub_domain_name_length)))
)


class AlgorithmIdentifier(univ.Sequence):
    pass


AlgorithmIdentifier.componentType = namedtype.NamedTypes(
    namedtype.NamedType('algorithm', univ.ObjectIdentifier()),
    namedtype.OptionalNamedType('parameters', univ.Any())
)


class DirectoryString(univ.Choice):
    pass


DirectoryString.componentType = namedtype.NamedTypes(
    namedtype.NamedType('teletexString', char.TeletexString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 256))),
    namedtype.NamedType('printableString', char.PrintableString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 256))),
    namedtype.NamedType('universalString', char.UniversalString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 256))),
    namedtype.NamedType('utf8String', char.UTF8String().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 256))),
    namedtype.NamedType('bmpString', char.BMPString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 256)))
)


class EDIPartyName(univ.Sequence):
    pass


EDIPartyName.componentType = namedtype.NamedTypes(
    namedtype.OptionalNamedType('nameAssigner', DirectoryString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.NamedType('partyName', DirectoryString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1)))
)


class AttributeType(univ.ObjectIdentifier):
    pass


class AttributeValue(univ.Any):
    pass


class AttributeTypeAndValue(univ.Sequence):
    pass


AttributeTypeAndValue.componentType = namedtype.NamedTypes(
    namedtype.NamedType('type', AttributeType()),
    namedtype.NamedType('value', AttributeValue())
)


class RelativeDistinguishedName(univ.SetOf):
    pass


RelativeDistinguishedName.componentType = AttributeTypeAndValue()
RelativeDistinguishedName.subtypeSpec=constraint.ValueSizeConstraint(1, 256)


class RDNSequence(univ.SequenceOf):
    pass


RDNSequence.componentType = RelativeDistinguishedName()


class Name(univ.Choice):
    pass


Name.componentType = namedtype.NamedTypes(
    namedtype.NamedType('rdnSequence', RDNSequence())
)


ub_domain_defined_attribute_type_length = univ.Integer(8)


ub_domain_defined_attribute_value_length = univ.Integer(128)


class BuiltInDomainDefinedAttribute(univ.Sequence):
    pass


BuiltInDomainDefinedAttribute.componentType = namedtype.NamedTypes(
    namedtype.NamedType('type', char.PrintableString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, ub_domain_defined_attribute_type_length))),
    namedtype.NamedType('value', char.PrintableString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, ub_domain_defined_attribute_value_length)))
)


ub_domain_defined_attributes = univ.Integer(4)


class BuiltInDomainDefinedAttributes(univ.SequenceOf):
    pass


BuiltInDomainDefinedAttributes.componentType = BuiltInDomainDefinedAttribute()
BuiltInDomainDefinedAttributes.subtypeSpec=constraint.ValueSizeConstraint(1, ub_domain_defined_attributes)


ub_country_name_alpha_length = univ.Integer(2)


ub_country_name_numeric_length = univ.Integer(3)


class CountryName(univ.Choice):
    pass


CountryName.tagSet = univ.Choice.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 1))
CountryName.componentType = namedtype.NamedTypes(
    namedtype.NamedType('x121-dcc-code', char.NumericString().subtype(subtypeSpec=constraint.ValueSizeConstraint(ub_country_name_numeric_length, ub_country_name_numeric_length))),
    namedtype.NamedType('iso-3166-alpha2-code', char.PrintableString().subtype(subtypeSpec=constraint.ValueSizeConstraint(ub_country_name_alpha_length, ub_country_name_alpha_length)))
)


ub_x121_address_length = univ.Integer(16)


class X121Address(char.NumericString):
    pass


X121Address.subtypeSpec = constraint.ValueSizeConstraint(1, ub_x121_address_length)


class NetworkAddress(X121Address):
    pass


ub_numeric_user_id_length = univ.Integer(32)


class NumericUserIdentifier(char.NumericString):
    pass


NumericUserIdentifier.subtypeSpec = constraint.ValueSizeConstraint(1, ub_numeric_user_id_length)


ub_organization_name_length = univ.Integer(64)


class OrganizationName(char.PrintableString):
    pass


OrganizationName.subtypeSpec = constraint.ValueSizeConstraint(1, ub_organization_name_length)


ub_organizational_unit_name_length = univ.Integer(32)


class OrganizationalUnitName(char.PrintableString):
    pass


OrganizationalUnitName.subtypeSpec = constraint.ValueSizeConstraint(1, ub_organizational_unit_name_length)


ub_organizational_units = univ.Integer(4)


class OrganizationalUnitNames(univ.SequenceOf):
    pass


OrganizationalUnitNames.componentType = OrganizationalUnitName()
OrganizationalUnitNames.subtypeSpec=constraint.ValueSizeConstraint(1, ub_organizational_units)


ub_generation_qualifier_length = univ.Integer(3)


ub_given_name_length = univ.Integer(16)


ub_initials_length = univ.Integer(5)


ub_surname_length = univ.Integer(40)


class PersonalName(univ.Set):
    pass


PersonalName.componentType = namedtype.NamedTypes(
    namedtype.NamedType('surname', char.PrintableString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, ub_surname_length)).subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('given-name', char.PrintableString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, ub_given_name_length)).subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('initials', char.PrintableString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, ub_initials_length)).subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('generation-qualifier', char.PrintableString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, ub_generation_qualifier_length)).subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3)))
)


class PrivateDomainName(univ.Choice):
    pass


PrivateDomainName.componentType = namedtype.NamedTypes(
    namedtype.NamedType('numeric', char.NumericString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, ub_domain_name_length))),
    namedtype.NamedType('printable', char.PrintableString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, ub_domain_name_length)))
)


ub_terminal_id_length = univ.Integer(24)


class TerminalIdentifier(char.PrintableString):
    pass


TerminalIdentifier.subtypeSpec = constraint.ValueSizeConstraint(1, ub_terminal_id_length)


class BuiltInStandardAttributes(univ.Sequence):
    pass


BuiltInStandardAttributes.componentType = namedtype.NamedTypes(
    namedtype.OptionalNamedType('country-name', CountryName()),
    namedtype.OptionalNamedType('administration-domain-name', AdministrationDomainName()),
    namedtype.OptionalNamedType('network-address', NetworkAddress().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('terminal-identifier', TerminalIdentifier().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('private-domain-name', PrivateDomainName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.OptionalNamedType('organization-name', OrganizationName().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.OptionalNamedType('numeric-user-identifier', NumericUserIdentifier().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 4))),
    namedtype.OptionalNamedType('personal-name', PersonalName().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 5))),
    namedtype.OptionalNamedType('organizational-unit-names', OrganizationalUnitNames().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 6)))
)


ub_extension_attributes = univ.Integer(256)


class ExtensionAttribute(univ.Sequence):
    pass


ExtensionAttribute.componentType = namedtype.NamedTypes(
    namedtype.NamedType('extension-attribute-type', univ.Integer().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, ub_extension_attributes)).subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('extension-attribute-value', univ.Any().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class ExtensionAttributes(univ.SetOf):
    pass


ExtensionAttributes.componentType = ExtensionAttribute()
ExtensionAttributes.subtypeSpec=constraint.ValueSizeConstraint(1, ub_extension_attributes)


class ORAddress(univ.Sequence):
    pass


ORAddress.componentType = namedtype.NamedTypes(
    namedtype.NamedType('built-in-standard-attributes', BuiltInStandardAttributes()),
    namedtype.OptionalNamedType('built-in-domain-defined-attributes', BuiltInDomainDefinedAttributes()),
    namedtype.OptionalNamedType('extension-attributes', ExtensionAttributes())
)


class OtherName(univ.Sequence):
    pass


OtherName.componentType = namedtype.NamedTypes(
    namedtype.NamedType('type-id', univ.ObjectIdentifier()),
    namedtype.NamedType('value', univ.Any().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class GeneralName(univ.Choice):
    pass


GeneralName.componentType = namedtype.NamedTypes(
    namedtype.NamedType('otherName', OtherName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.NamedType('rfc822Name', char.IA5String().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('dNSName', char.IA5String().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.NamedType('x400Address', ORAddress().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3))),
    namedtype.NamedType('directoryName', Name().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4))),
    namedtype.NamedType('ediPartyName', EDIPartyName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 5))),
    namedtype.NamedType('uniformResourceIdentifier', char.IA5String().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 6))),
    namedtype.NamedType('iPAddress', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 7))),
    namedtype.NamedType('registeredID', univ.ObjectIdentifier().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 8)))
)


class GeneralNames(univ.SequenceOf):
    pass


GeneralNames.componentType = GeneralName()
GeneralNames.subtypeSpec=constraint.ValueSizeConstraint(1, 256)


class CertificateSerialNumber(univ.Integer):
    pass


class UniqueIdentifier(univ.BitString):
    pass


class IssuerSerial(univ.Sequence):
    pass


IssuerSerial.componentType = namedtype.NamedTypes(
    namedtype.NamedType('issuer', GeneralNames()),
    namedtype.NamedType('serial', CertificateSerialNumber()),
    namedtype.OptionalNamedType('issuerUID', UniqueIdentifier())
)


class ObjectDigestInfo(univ.Sequence):
    pass


ObjectDigestInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('digestedObjectType', univ.Enumerated(namedValues=namedval.NamedValues(('publicKey', 0), ('publicKeyCert', 1), ('otherObjectTypes', 2)))),
    namedtype.OptionalNamedType('otherObjectTypeID', univ.ObjectIdentifier()),
    namedtype.NamedType('digestAlgorithm', AlgorithmIdentifier()),
    namedtype.NamedType('objectDigest', univ.BitString())
)


class V2Form(univ.Sequence):
    pass


V2Form.componentType = namedtype.NamedTypes(
    namedtype.OptionalNamedType('issuerName', GeneralNames()),
    namedtype.OptionalNamedType('baseCertificateID', IssuerSerial().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.OptionalNamedType('objectDigestInfo', ObjectDigestInfo().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1)))
)


class AttCertIssuer(univ.Choice):
    pass


AttCertIssuer.componentType = namedtype.NamedTypes(
    namedtype.NamedType('v1Form', GeneralNames()),
    namedtype.NamedType('v2Form', V2Form().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0)))
)


class AttCertValidityPeriod(univ.Sequence):
    pass


AttCertValidityPeriod.componentType = namedtype.NamedTypes(
    namedtype.NamedType('notBeforeTime', useful.GeneralizedTime()),
    namedtype.NamedType('notAfterTime', useful.GeneralizedTime())
)


class AttCertVersion(univ.Integer):
    pass


AttCertVersion.namedValues = namedval.NamedValues(
    ('v2', 1)
)


class AttCertVersionV1(univ.Integer):
    pass


AttCertVersionV1.namedValues = namedval.NamedValues(
    ('v1', 0)
)


class Attribute(univ.Sequence):
    pass


Attribute.componentType = namedtype.NamedTypes(
    namedtype.NamedType('type', AttributeType()),
    namedtype.NamedType('values', univ.SetOf(componentType=AttributeValue()))
)


class Attribute(univ.Sequence):
    pass


Attribute.componentType = namedtype.NamedTypes(
    namedtype.NamedType('attrType', univ.ObjectIdentifier()),
    namedtype.NamedType('attrValues', univ.SetOf(componentType=AttributeValue()))
)


class Extension(univ.Sequence):
    pass


Extension.componentType = namedtype.NamedTypes(
    namedtype.NamedType('extnID', univ.ObjectIdentifier()),
    namedtype.DefaultedNamedType('critical', univ.Boolean().subtype(value=0)),
    namedtype.NamedType('extnValue', univ.OctetString())
)


class Extensions(univ.SequenceOf):
    pass


Extensions.componentType = Extension()
Extensions.subtypeSpec=constraint.ValueSizeConstraint(1, 256)


class Holder(univ.Sequence):
    pass


Holder.componentType = namedtype.NamedTypes(
    namedtype.OptionalNamedType('baseCertificateID', IssuerSerial().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.OptionalNamedType('entityName', GeneralNames().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('objectDigestInfo', ObjectDigestInfo().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2)))
)


class AttributeCertificateInfo(univ.Sequence):
    pass


AttributeCertificateInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('version', AttCertVersion()),
    namedtype.NamedType('holder', Holder()),
    namedtype.NamedType('issuer', AttCertIssuer()),
    namedtype.NamedType('signature', AlgorithmIdentifier()),
    namedtype.NamedType('serialNumber', CertificateSerialNumber()),
    namedtype.NamedType('attrCertValidityPeriod', AttCertValidityPeriod()),
    namedtype.NamedType('attributes', univ.SequenceOf(componentType=Attribute())),
    namedtype.OptionalNamedType('issuerUniqueID', UniqueIdentifier()),
    namedtype.OptionalNamedType('extensions', Extensions())
)


class AttributeCertificate(univ.Sequence):
    pass


AttributeCertificate.componentType = namedtype.NamedTypes(
    namedtype.NamedType('acinfo', AttributeCertificateInfo()),
    namedtype.NamedType('signatureAlgorithm', AlgorithmIdentifier()),
    namedtype.NamedType('signatureValue', univ.BitString())
)


class AttributeCertificateInfoV1(univ.Sequence):
    pass


AttributeCertificateInfoV1.componentType = namedtype.NamedTypes(
    namedtype.DefaultedNamedType('version', AttCertVersionV1().subtype(value=1)),
    namedtype.NamedType('subject', univ.Choice(componentType=namedtype.NamedTypes(
        namedtype.NamedType('baseCertificateID', IssuerSerial().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
        namedtype.NamedType('subjectName', GeneralNames().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
    ))
    ),
    namedtype.NamedType('issuer', GeneralNames()),
    namedtype.NamedType('signature', AlgorithmIdentifier()),
    namedtype.NamedType('serialNumber', CertificateSerialNumber()),
    namedtype.NamedType('attCertValidityPeriod', AttCertValidityPeriod()),
    namedtype.NamedType('attributes', univ.SequenceOf(componentType=Attribute())),
    namedtype.OptionalNamedType('issuerUniqueID', UniqueIdentifier()),
    namedtype.OptionalNamedType('extensions', Extensions())
)


class AttributeCertificateV1(univ.Sequence):
    pass


AttributeCertificateV1.componentType = namedtype.NamedTypes(
    namedtype.NamedType('acInfo', AttributeCertificateInfoV1()),
    namedtype.NamedType('signatureAlgorithm', AlgorithmIdentifier()),
    namedtype.NamedType('signature', univ.BitString())
)


class AttributeCertificateV2(AttributeCertificate):
    pass


class AttributeValue(univ.Any):
    pass


class AuthDataTypeValues(univ.Integer):
    pass


AuthDataTypeValues.namedValues = namedval.NamedValues(
    ('kRB5-AUTHDATA-IF-RELEVANT', 1),
    ('kRB5-AUTHDATA-INTENDED-FOR-SERVER', 2),
    ('kRB5-AUTHDATA-INTENDED-FOR-APPLICATION-CLASS', 3),
    ('kRB5-AUTHDATA-KDC-ISSUED', 4),
    ('kRB5-AUTHDATA-AND-OR', 5),
    ('kRB5-AUTHDATA-MANDATORY-TICKET-EXTENSIONS', 6),
    ('kRB5-AUTHDATA-IN-TICKET-EXTENSIONS', 7),
    ('kRB5-AUTHDATA-MANDATORY-FOR-KDC', 8),
    ('kRB5-AUTHDATA-INITIAL-VERIFIED-CAS', 9),
    ('kRB5-AUTHDATA-OSF-DCE', 64),
    ('kRB5-AUTHDATA-SESAME', 65),
    ('kRB5-AUTHDATA-OSF-DCE-PKI-CERTID', 66),
    ('kRB5-AUTHDATA-WIN2K-PAC', 128),
    ('kRB5-AUTHDATA-GSS-API-ETYPE-NEGOTIATION', 129),
    ('kRB5-AUTHDATA-SIGNTICKET-OLDER', -17),
    ('kRB5-AUTHDATA-SIGNTICKET-OLD', 142),
    ('kRB5-AUTHDATA-SIGNTICKET', 512)
)


class AuthDataTypeSequence(univ.Sequence):
    pass


AuthDataTypeSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', AuthDataTypeValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class DHNonce(univ.OctetString):
    pass


class PKAuthenticator(univ.Sequence):
    pass


PKAuthenticator.componentType = namedtype.NamedTypes(
    namedtype.NamedType('cusec', univ.Integer().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 999999)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('ctime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('nonce', univ.Integer().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('paChecksum', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.OptionalNamedType('freshnessToken', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 4)))
)


class SubjectPublicKeyInfo(univ.Sequence):
    pass


SubjectPublicKeyInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('algorithm', AlgorithmIdentifier()),
    namedtype.NamedType('subjectPublicKey', univ.BitString())
)


class AuthPack(univ.Sequence):
    pass


AuthPack.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pkAuthenticator', PKAuthenticator().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.OptionalNamedType('clientPublicValue', SubjectPublicKeyInfo().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1))),
    namedtype.OptionalNamedType('supportedCMSTypes', univ.SequenceOf(componentType=AlgorithmIdentifier()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('clientDHNonce', DHNonce().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3)))
)


class PKAuthenticator_Win2k(univ.Sequence):
    pass


PKAuthenticator_Win2k.componentType = namedtype.NamedTypes(
    namedtype.NamedType('kdcName', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.NamedType('kdcRealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('cusec', univ.Integer().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.NamedType('ctime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.NamedType('nonce', univ.Integer().subtype(subtypeSpec=constraint.ValueRangeConstraint(-2147483648, 2147483647)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 4)))
)


class AuthPack_Win2k(univ.Sequence):
    pass


AuthPack_Win2k.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pkAuthenticator', PKAuthenticator_Win2k().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0)))
)


class EncryptionKey(univ.Sequence):
    pass


EncryptionKey.componentType = namedtype.NamedTypes(
    namedtype.NamedType('keytype', EncryptionType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('keyvalue', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class Microseconds(univ.Integer):
    pass


Microseconds.subtypeSpec = constraint.ValueRangeConstraint(0, 999999)


class Authenticator(univ.Sequence):
    pass


Authenticator.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 2))
Authenticator.componentType = namedtype.NamedTypes(
    namedtype.NamedType('authenticator-vno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('crealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('cname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.OptionalNamedType('cksum', Checksum().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3))),
    namedtype.NamedType('cusec', Microseconds().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 4))),
    namedtype.NamedType('ctime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 5))),
    namedtype.OptionalNamedType('subkey', EncryptionKey().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 6))),
    namedtype.OptionalNamedType('seq-number', UInt32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 7))),
    namedtype.OptionalNamedType('authorization-data', AuthorizationData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 8)))
)


class CMSAttributes(univ.SetOf):
    pass


CMSAttributes.componentType = Attribute()


class CMSCBCParameter(univ.OctetString):
    pass


class CMSVersion(univ.Integer):
    pass


CMSVersion.namedValues = namedval.NamedValues(
    ('v0', 0),
    ('v1', 1),
    ('v2', 2),
    ('v3', 3),
    ('v4', 4),
    ('v5', 5)
)


class SerialNumber(univ.Integer):
    pass


class CRLEntry(univ.Sequence):
    pass


CRLEntry.componentType = namedtype.NamedTypes(
    namedtype.NamedType('userCertificate', SerialNumber()),
    namedtype.NamedType('revocationDate', useful.UTCTime())
)


class Time(univ.Choice):
    pass


Time.componentType = namedtype.NamedTypes(
    namedtype.NamedType('utcTime', useful.UTCTime()),
    namedtype.NamedType('generalTime', useful.GeneralizedTime())
)


class Validity(univ.Sequence):
    pass


Validity.componentType = namedtype.NamedTypes(
    namedtype.NamedType('notBefore', Time()),
    namedtype.NamedType('notAfter', Time())
)


class Version(univ.Integer):
    pass


Version.namedValues = namedval.NamedValues(
    ('v1', 0),
    ('v2', 1),
    ('v3', 2)
)


class TBSCertificate(univ.Sequence):
    pass


TBSCertificate.componentType = namedtype.NamedTypes(
    namedtype.DefaultedNamedType('version', Version().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)).subtype(value=1)),
    namedtype.NamedType('serialNumber', CertificateSerialNumber()),
    namedtype.NamedType('signature', AlgorithmIdentifier()),
    namedtype.NamedType('issuer', Name()),
    namedtype.NamedType('validity', Validity()),
    namedtype.NamedType('subject', Name()),
    namedtype.NamedType('subjectPublicKeyInfo', SubjectPublicKeyInfo()),
    namedtype.OptionalNamedType('issuerUniqueID', UniqueIdentifier().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('subjectUniqueID', UniqueIdentifier().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('extensions', Extensions().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3)))
)


class Certificate(univ.Sequence):
    pass


Certificate.componentType = namedtype.NamedTypes(
    namedtype.NamedType('tbsCertificate', TBSCertificate()),
    namedtype.NamedType('signatureAlgorithm', AlgorithmIdentifier()),
    namedtype.NamedType('signatureValue', univ.BitString())
)


class UnauthAttributes(univ.SetOf):
    pass


UnauthAttributes.componentType = Attribute()
UnauthAttributes.subtypeSpec=constraint.ValueSizeConstraint(1, 256)


class ExtendedCertificateInfo(univ.Sequence):
    pass


ExtendedCertificateInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('version', CMSVersion()),
    namedtype.NamedType('certificate', Certificate()),
    namedtype.NamedType('attributes', UnauthAttributes())
)


class Signature(univ.BitString):
    pass


class SignatureAlgorithmIdentifier(AlgorithmIdentifier):
    pass


class ExtendedCertificate(univ.Sequence):
    pass


ExtendedCertificate.componentType = namedtype.NamedTypes(
    namedtype.NamedType('extendedCertificateInfo', ExtendedCertificateInfo()),
    namedtype.NamedType('signatureAlgorithm', SignatureAlgorithmIdentifier()),
    namedtype.NamedType('signature', Signature())
)


class OtherCertificateFormat(univ.Sequence):
    pass


OtherCertificateFormat.componentType = namedtype.NamedTypes(
    namedtype.NamedType('otherCertFormat', univ.ObjectIdentifier()),
    namedtype.NamedType('otherCert', univ.Any())
)


class CertificateChoices(univ.Choice):
    pass


CertificateChoices.componentType = namedtype.NamedTypes(
    namedtype.NamedType('certificate', Certificate()),
    namedtype.NamedType('extendedCertificate', ExtendedCertificate().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.NamedType('v1AttrCert', AttributeCertificateV1().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1))),
    namedtype.NamedType('v2AttrCert', AttributeCertificateV2().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.NamedType('other', OtherCertificateFormat().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3)))
)


class TBSCertList(univ.Sequence):
    pass


TBSCertList.componentType = namedtype.NamedTypes(
    namedtype.OptionalNamedType('version', Version()),
    namedtype.NamedType('signature', AlgorithmIdentifier()),
    namedtype.NamedType('issuer', Name()),
    namedtype.NamedType('thisUpdate', Time()),
    namedtype.OptionalNamedType('nextUpdate', Time()),
    namedtype.OptionalNamedType('revokedCertificates', univ.SequenceOf(componentType=univ.Sequence(componentType=namedtype.NamedTypes(
        namedtype.NamedType('userCertificate', CertificateSerialNumber()),
        namedtype.NamedType('revocationDate', Time()),
        namedtype.OptionalNamedType('crlEntryExtensions', Extensions())
    ))
    )),
    namedtype.OptionalNamedType('crlExtensions', Extensions().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class CertificateList(univ.Sequence):
    pass


CertificateList.componentType = namedtype.NamedTypes(
    namedtype.NamedType('tbsCertList', TBSCertList()),
    namedtype.NamedType('signatureAlgorithm', AlgorithmIdentifier()),
    namedtype.NamedType('signatureValue', univ.BitString())
)


class CertificateRevocationList(univ.Sequence):
    pass


CertificateRevocationList.componentType = namedtype.NamedTypes(
    namedtype.NamedType('signature', AlgorithmIdentifier()),
    namedtype.NamedType('issuer', Name()),
    namedtype.NamedType('lastUpdate', useful.UTCTime()),
    namedtype.NamedType('nextUpdate', useful.UTCTime()),
    namedtype.OptionalNamedType('revokedCertificates', univ.SequenceOf(componentType=CRLEntry()))
)


class CertificateRevocationLists(univ.SetOf):
    pass


CertificateRevocationLists.componentType = CertificateRevocationList()


class CertificateSet(univ.SetOf):
    pass


CertificateSet.componentType = CertificateChoices()


class ChangePasswdDataMS(univ.Sequence):
    pass


ChangePasswdDataMS.componentType = namedtype.NamedTypes(
    namedtype.NamedType('newpasswd', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('targname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1))),
    namedtype.OptionalNamedType('targrealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2)))
)


class ChecksumTypeValues(univ.Integer):
    pass


ChecksumTypeValues.namedValues = namedval.NamedValues(
    ('kRB5-CKSUMTYPE-NONE', 0),
    ('kRB5-CKSUMTYPE-CRC32', 1),
    ('kRB5-CKSUMTYPE-RSA-MD4', 2),
    ('kRB5-CKSUMTYPE-RSA-MD4-DES', 3),
    ('kRB5-CKSUMTYPE-DES-MAC', 4),
    ('kRB5-CKSUMTYPE-DES-MAC-K', 5),
    ('kRB5-CKSUMTYPE-RSA-MD4-DES-K', 6),
    ('kRB5-CKSUMTYPE-RSA-MD5', 7),
    ('kRB5-CKSUMTYPE-RSA-MD5-DES', 8),
    ('kRB5-CKSUMTYPE-RSA-MD5-DES3', 9),
    ('kRB5-CKSUMTYPE-SHA1-OTHER', 10),
    ('kRB5-CKSUMTYPE-HMAC-SHA1-DES3', 12),
    ('kRB5-CKSUMTYPE-SHA1', 14),
    ('kRB5-CKSUMTYPE-HMAC-SHA1-96-AES-128', 15),
    ('kRB5-CKSUMTYPE-HMAC-SHA1-96-AES-256', 16),
    ('kRB5-CKSUMTYPE-GSSAPI', 32771),
    ('kRB5-CKSUMTYPE-HMAC-MD5', -138),
    ('kRB5-CKSUMTYPE-HMAC-MD5-ENC', -1138)
)


class ChecksumTypeSequence(univ.Sequence):
    pass


ChecksumTypeSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', ChecksumTypeValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class ContentEncryptionAlgorithmIdentifier(AlgorithmIdentifier):
    pass


class ContentType(univ.ObjectIdentifier):
    pass


class ContentInfo(univ.Sequence):
    pass


ContentInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('contentType', ContentType()),
    namedtype.OptionalNamedType('content', univ.Any().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class DHPublicKey(univ.Integer):
    pass


class DHRepInfo(univ.Sequence):
    pass


DHRepInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dhSignedData', univ.OctetString().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('serverDHNonce', DHNonce().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class DigestAlgorithmIdentifier(AlgorithmIdentifier):
    pass


class DigestAlgorithmIdentifiers(univ.SetOf):
    pass


DigestAlgorithmIdentifiers.componentType = DigestAlgorithmIdentifier()


class ValidationParms(univ.Sequence):
    pass


ValidationParms.componentType = namedtype.NamedTypes(
    namedtype.NamedType('seed', univ.BitString()),
    namedtype.NamedType('pgenCounter', univ.Integer())
)


class DomainParameters(univ.Sequence):
    pass


DomainParameters.componentType = namedtype.NamedTypes(
    namedtype.NamedType('p', univ.Integer()),
    namedtype.NamedType('g', univ.Integer()),
    namedtype.OptionalNamedType('q', univ.Integer()),
    namedtype.OptionalNamedType('j', univ.Integer()),
    namedtype.OptionalNamedType('validationParms', ValidationParms())
)


class ETYPE_INFO_ENTRY(univ.Sequence):
    pass


ETYPE_INFO_ENTRY.componentType = namedtype.NamedTypes(
    namedtype.NamedType('etype', EncryptionType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('salt', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class ETYPE_INFO(univ.SequenceOf):
    pass


ETYPE_INFO.componentType = ETYPE_INFO_ENTRY()


class ETYPE_INFO2_ENTRY(univ.Sequence):
    pass


ETYPE_INFO2_ENTRY.componentType = namedtype.NamedTypes(
    namedtype.NamedType('etype', EncryptionType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('salt', KerberosString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('s2kparams', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2)))
)


class ETYPE_INFO2(univ.SequenceOf):
    pass


ETYPE_INFO2.componentType = ETYPE_INFO2_ENTRY()
ETYPE_INFO2.subtypeSpec=constraint.ValueSizeConstraint(1, 256)


class EncAPRepPart(univ.Sequence):
    pass


EncAPRepPart.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 27))
EncAPRepPart.componentType = namedtype.NamedTypes(
    namedtype.NamedType('ctime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('cusec', Microseconds().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('subkey', EncryptionKey().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.OptionalNamedType('seq-number', UInt32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3)))
)


class LastReq(univ.SequenceOf):
    pass


LastReq.componentType = univ.Sequence(componentType=namedtype.NamedTypes(
    namedtype.NamedType('lr-type', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('lr-value', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
))


class METHOD_DATA(univ.SequenceOf):
    pass


METHOD_DATA.componentType = PA_DATA()


class TicketFlags(KerberosFlags):
    pass


class EncKDCRepPart(univ.Sequence):
    pass


EncKDCRepPart.componentType = namedtype.NamedTypes(
    namedtype.NamedType('key', EncryptionKey().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.NamedType('last-req', LastReq().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('nonce', UInt32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('key-expiration', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.NamedType('flags', TicketFlags().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 4))),
    namedtype.NamedType('authtime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 5))),
    namedtype.OptionalNamedType('starttime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 6))),
    namedtype.NamedType('endtime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 7))),
    namedtype.OptionalNamedType('renew-till', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 8))),
    namedtype.NamedType('srealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 9))),
    namedtype.NamedType('sname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 10))),
    namedtype.OptionalNamedType('caddr', HostAddresses().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 11))),
    namedtype.OptionalNamedType('encrypted-pa-data', METHOD_DATA().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 12)))
)


class EncASRepPart(EncKDCRepPart):
    pass


EncASRepPart.tagSet = EncKDCRepPart.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 25))


class KrbCredInfo(univ.Sequence):
    pass


KrbCredInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('key', EncryptionKey().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.OptionalNamedType('prealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('pname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.OptionalNamedType('flags', TicketFlags().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.OptionalNamedType('authtime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 4))),
    namedtype.OptionalNamedType('starttime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 5))),
    namedtype.OptionalNamedType('endtime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 6))),
    namedtype.OptionalNamedType('renew-till', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 7))),
    namedtype.OptionalNamedType('srealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 8))),
    namedtype.OptionalNamedType('sname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 9))),
    namedtype.OptionalNamedType('caddr', HostAddresses().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 10)))
)


class EncKrbCredPart(univ.Sequence):
    pass


EncKrbCredPart.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 29))
EncKrbCredPart.componentType = namedtype.NamedTypes(
    namedtype.NamedType('ticket-info', univ.SequenceOf(componentType=KrbCredInfo()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('nonce', UInt32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('timestamp', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('usec', Microseconds().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.OptionalNamedType('s-address', HostAddress().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4))),
    namedtype.OptionalNamedType('r-address', HostAddress().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 5)))
)


class EncKrbPrivPart(univ.Sequence):
    pass


EncKrbPrivPart.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 28))
EncKrbPrivPart.componentType = namedtype.NamedTypes(
    namedtype.NamedType('user-data', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('timestamp', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('usec', Microseconds().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('seq-number', UInt32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.NamedType('s-address', HostAddress().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4))),
    namedtype.OptionalNamedType('r-address', HostAddress().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 5)))
)


class EncTGSRepPart(EncKDCRepPart):
    pass


EncTGSRepPart.tagSet = EncKDCRepPart.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 26))


class TransitedEncoding(univ.Sequence):
    pass


TransitedEncoding.componentType = namedtype.NamedTypes(
    namedtype.NamedType('tr-type', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('contents', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class EncTicketPart(univ.Sequence):
    pass


EncTicketPart.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 3))
EncTicketPart.componentType = namedtype.NamedTypes(
    namedtype.NamedType('flags', TicketFlags().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('key', EncryptionKey().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1))),
    namedtype.NamedType('crealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.NamedType('cname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3))),
    namedtype.NamedType('transited', TransitedEncoding().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4))),
    namedtype.NamedType('authtime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 5))),
    namedtype.OptionalNamedType('starttime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 6))),
    namedtype.NamedType('endtime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 7))),
    namedtype.OptionalNamedType('renew-till', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 8))),
    namedtype.OptionalNamedType('caddr', HostAddresses().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 9))),
    namedtype.OptionalNamedType('authorization-data', AuthorizationData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 10)))
)


class EncapsulatedContentInfo(univ.Sequence):
    pass


EncapsulatedContentInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('eContentType', ContentType()),
    namedtype.OptionalNamedType('eContent', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class EncryptedContent(univ.OctetString):
    pass


class EncryptedContentInfo(univ.Sequence):
    pass


EncryptedContentInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('contentType', ContentType()),
    namedtype.NamedType('contentEncryptionAlgorithm', ContentEncryptionAlgorithmIdentifier()),
    namedtype.OptionalNamedType('encryptedContent', EncryptedContent().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class EncryptedKey(univ.OctetString):
    pass


class EncryptionTypeValues(univ.Integer):
    pass


EncryptionTypeValues.namedValues = namedval.NamedValues(
    ('kRB5-ENCTYPE-NULL', 0),
    ('kRB5-ENCTYPE-DES-CBC-CRC', 1),
    ('kRB5-ENCTYPE-DES-CBC-MD4', 2),
    ('kRB5-ENCTYPE-DES-CBC-MD5', 3),
    ('kRB5-ENCTYPE-DES3-CBC-MD5', 5),
    ('kRB5-ENCTYPE-OLD-DES3-CBC-SHA1', 7),
    ('kRB5-ENCTYPE-SIGN-DSA-GENERATE', 8),
    ('kRB5-ENCTYPE-ENCRYPT-RSA-PRIV', 9),
    ('kRB5-ENCTYPE-ENCRYPT-RSA-PUB', 10),
    ('kRB5-ENCTYPE-DES3-CBC-SHA1', 16),
    ('kRB5-ENCTYPE-AES128-CTS-HMAC-SHA1-96', 17),
    ('kRB5-ENCTYPE-AES256-CTS-HMAC-SHA1-96', 18),
    ('kRB5-ENCTYPE-ARCFOUR-HMAC-MD5', 23),
    ('kRB5-ENCTYPE-ARCFOUR-HMAC-MD5-56', 24),
    ('kRB5-ENCTYPE-ENCTYPE-PK-CROSS', 48),
    ('kRB5-ENCTYPE-ARCFOUR-MD4', -128),
    ('kRB5-ENCTYPE-ARCFOUR-HMAC-OLD', -133),
    ('kRB5-ENCTYPE-ARCFOUR-HMAC-OLD-EXP', -135),
    ('kRB5-ENCTYPE-DUMMY', -1111)
)


class EncryptionTypeSequence(univ.Sequence):
    pass


EncryptionTypeSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', EncryptionTypeValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class OtherRevocationInfoFormat(univ.Sequence):
    pass


OtherRevocationInfoFormat.componentType = namedtype.NamedTypes(
    namedtype.NamedType('otherRevInfoFormat', univ.ObjectIdentifier()),
    namedtype.NamedType('otherRevInfo', univ.Any())
)


class RevocationInfoChoice(univ.Choice):
    pass


RevocationInfoChoice.componentType = namedtype.NamedTypes(
    namedtype.NamedType('crl', CertificateList()),
    namedtype.NamedType('other', OtherRevocationInfoFormat().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1)))
)


class RevocationInfoChoices(univ.SetOf):
    pass


RevocationInfoChoices.componentType = RevocationInfoChoice()


class OriginatorInfo(univ.Sequence):
    pass


OriginatorInfo.componentType = namedtype.NamedTypes(
    namedtype.OptionalNamedType('certs', CertificateSet().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('crls', RevocationInfoChoices().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class OtherKeyAttribute(univ.Sequence):
    pass


OtherKeyAttribute.componentType = namedtype.NamedTypes(
    namedtype.NamedType('keyAttrId', univ.ObjectIdentifier()),
    namedtype.OptionalNamedType('keyAttr', univ.Any())
)


class KEKIdentifier(univ.Sequence):
    pass


KEKIdentifier.componentType = namedtype.NamedTypes(
    namedtype.NamedType('keyIdentifier', univ.OctetString()),
    namedtype.OptionalNamedType('date', useful.GeneralizedTime()),
    namedtype.OptionalNamedType('other', OtherKeyAttribute())
)


class KeyEncryptionAlgorithmIdentifier(AlgorithmIdentifier):
    pass


class KEKRecipientInfo(univ.Sequence):
    pass


KEKRecipientInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('version', CMSVersion()),
    namedtype.NamedType('kekid', KEKIdentifier()),
    namedtype.NamedType('keyEncryptionAlgorithm', KeyEncryptionAlgorithmIdentifier()),
    namedtype.NamedType('encryptedKey', EncryptedKey())
)


class IssuerAndSerialNumber(univ.Sequence):
    pass


IssuerAndSerialNumber.componentType = namedtype.NamedTypes(
    namedtype.NamedType('issuer', Name()),
    namedtype.NamedType('serialNumber', CertificateSerialNumber())
)


class OriginatorPublicKey(univ.Sequence):
    pass


OriginatorPublicKey.componentType = namedtype.NamedTypes(
    namedtype.NamedType('algorithm', AlgorithmIdentifier()),
    namedtype.NamedType('publicKey', univ.BitString())
)


class SubjectKeyIdentifier(univ.OctetString):
    pass


class OriginatorIdentifierOrKey(univ.Choice):
    pass


OriginatorIdentifierOrKey.componentType = namedtype.NamedTypes(
    namedtype.NamedType('issuerAndSerialNumber', IssuerAndSerialNumber()),
    namedtype.NamedType('subjectKeyIdentifier', SubjectKeyIdentifier().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('originatorKey', OriginatorPublicKey().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1)))
)


class RecipientKeyIdentifier(univ.Sequence):
    pass


RecipientKeyIdentifier.componentType = namedtype.NamedTypes(
    namedtype.NamedType('subjectKeyIdentifier', SubjectKeyIdentifier()),
    namedtype.OptionalNamedType('date', useful.GeneralizedTime()),
    namedtype.OptionalNamedType('other', OtherKeyAttribute())
)


class KeyAgreeRecipientIdentifier(univ.Choice):
    pass


KeyAgreeRecipientIdentifier.componentType = namedtype.NamedTypes(
    namedtype.NamedType('issuerAndSerialNumber', IssuerAndSerialNumber()),
    namedtype.NamedType('rKeyId', RecipientKeyIdentifier().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0)))
)


class RecipientEncryptedKey(univ.Sequence):
    pass


RecipientEncryptedKey.componentType = namedtype.NamedTypes(
    namedtype.NamedType('rid', KeyAgreeRecipientIdentifier()),
    namedtype.NamedType('encryptedKey', EncryptedKey())
)


class RecipientEncryptedKeys(univ.SequenceOf):
    pass


RecipientEncryptedKeys.componentType = RecipientEncryptedKey()


class UserKeyingMaterial(univ.OctetString):
    pass


class KeyAgreeRecipientInfo(univ.Sequence):
    pass


KeyAgreeRecipientInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('version', CMSVersion()),
    namedtype.NamedType('originator', OriginatorIdentifierOrKey().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.OptionalNamedType('ukm', UserKeyingMaterial().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('keyEncryptionAlgorithm', KeyEncryptionAlgorithmIdentifier()),
    namedtype.NamedType('recipientEncryptedKeys', RecipientEncryptedKeys())
)


class RecipientIdentifier(univ.Choice):
    pass


RecipientIdentifier.componentType = namedtype.NamedTypes(
    namedtype.NamedType('issuerAndSerialNumber', IssuerAndSerialNumber()),
    namedtype.NamedType('subjectKeyIdentifier', SubjectKeyIdentifier().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class KeyTransRecipientInfo(univ.Sequence):
    pass


KeyTransRecipientInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('version', CMSVersion()),
    namedtype.NamedType('rid', RecipientIdentifier()),
    namedtype.NamedType('keyEncryptionAlgorithm', KeyEncryptionAlgorithmIdentifier()),
    namedtype.NamedType('encryptedKey', EncryptedKey())
)


class OtherRecipientInfo(univ.Sequence):
    pass


OtherRecipientInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('oriType', univ.ObjectIdentifier()),
    namedtype.NamedType('oriValue', univ.Any())
)


class KeyDerivationAlgorithmIdentifier(AlgorithmIdentifier):
    pass


class PasswordRecipientInfo(univ.Sequence):
    pass


PasswordRecipientInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('version', CMSVersion()),
    namedtype.OptionalNamedType('keyDerivationAlgorithm', KeyDerivationAlgorithmIdentifier().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.NamedType('keyEncryptionAlgorithm', KeyEncryptionAlgorithmIdentifier()),
    namedtype.NamedType('encryptedKey', EncryptedKey())
)


class RecipientInfo(univ.Choice):
    pass


RecipientInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('ktri', KeyTransRecipientInfo()),
    namedtype.NamedType('kari', KeyAgreeRecipientInfo().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1))),
    namedtype.NamedType('kekri', KEKRecipientInfo().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.NamedType('pwri', PasswordRecipientInfo().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3))),
    namedtype.NamedType('ori', OtherRecipientInfo().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4)))
)


class RecipientInfos(univ.SetOf):
    pass


RecipientInfos.componentType = RecipientInfo()
RecipientInfos.subtypeSpec=constraint.ValueSizeConstraint(1, 256)


class UnprotectedAttributes(univ.SetOf):
    pass


UnprotectedAttributes.componentType = Attribute()
UnprotectedAttributes.subtypeSpec=constraint.ValueSizeConstraint(1, 256)


class EnvelopedData(univ.Sequence):
    pass


EnvelopedData.componentType = namedtype.NamedTypes(
    namedtype.NamedType('version', CMSVersion()),
    namedtype.OptionalNamedType('originatorInfo', OriginatorInfo().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.NamedType('recipientInfos', RecipientInfos()),
    namedtype.NamedType('encryptedContentInfo', EncryptedContentInfo()),
    namedtype.OptionalNamedType('unprotectedAttrs', UnprotectedAttributes().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class ExtendedCertificateOrCertificate(univ.Choice):
    pass


ExtendedCertificateOrCertificate.componentType = namedtype.NamedTypes(
    namedtype.NamedType('certificate', Certificate()),
    namedtype.NamedType('extendedCertificate', ExtendedCertificate().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0)))
)


class ExtendedCertificatesAndCertificates(univ.SetOf):
    pass


ExtendedCertificatesAndCertificates.componentType = ExtendedCertificateOrCertificate()


class FastOptions(univ.BitString):
    pass


FastOptions.namedValues = namedval.NamedValues(
    ('reserved', 0),
    ('hide-client-names', 1),
    ('kdc-follow-referrals', 16)
)


class KDCDHKeyInfo(univ.Sequence):
    pass


KDCDHKeyInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('subjectPublicKey', univ.BitString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('nonce', univ.Integer().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('dhKeyExpiration', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2)))
)


class KDCOptionsValues(univ.BitString):
    pass


KDCOptionsValues.namedValues = namedval.NamedValues(
    ('reserved', 0),
    ('forwardable', 1),
    ('forwarded', 2),
    ('proxiable', 3),
    ('proxy', 4),
    ('allow-postdate', 5),
    ('postdated', 6),
    ('unused7', 7),
    ('renewable', 8),
    ('unused9', 9),
    ('unused10', 10),
    ('opt-hardware-auth', 11),
    ('unused12', 12),
    ('unused13', 13),
    ('cname-in-addl-tkt', 14),
    ('canonicalize', 15),
    ('disable-transited-check', 26),
    ('renewable-ok', 27),
    ('enc-tkt-in-skey', 28),
    ('renew', 30),
    ('validate', 31)
)


class KDCOptionsSequence(univ.Sequence):
    pass


KDCOptionsSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', KDCOptionsValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class KERB_AD_RESTRICTION_ENTRY(univ.Sequence):
    pass


KERB_AD_RESTRICTION_ENTRY.componentType = namedtype.NamedTypes(
    namedtype.NamedType('restriction-type', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('restriction', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class KerbErrorDataType(univ.Integer):
    pass


class KERB_ERROR_DATA(univ.Sequence):
    pass


KERB_ERROR_DATA.componentType = namedtype.NamedTypes(
    namedtype.NamedType('data-type', KerbErrorDataType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('data-value', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2)))
)


class KERB_KEY_LIST_REP(univ.SequenceOf):
    pass


KERB_KEY_LIST_REP.componentType = EncryptionKey()


class KERB_KEY_LIST_REQ(univ.SequenceOf):
    pass


KERB_KEY_LIST_REQ.componentType = EncryptionType()


class KERB_LOCAL(univ.OctetString):
    pass


class KERB_PA_PAC_REQUEST(univ.Sequence):
    pass


KERB_PA_PAC_REQUEST.componentType = namedtype.NamedTypes(
    namedtype.NamedType('include-pac', univ.Boolean().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class KRB_CRED(univ.Sequence):
    pass


KRB_CRED.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 22))
KRB_CRED.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pvno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('msg-type', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(22)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('tickets', univ.SequenceOf(componentType=Ticket()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.NamedType('enc-part', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3)))
)


class KRB_ERROR(univ.Sequence):
    pass


KRB_ERROR.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 30))
KRB_ERROR.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pvno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('msg-type', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(30)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('ctime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('cusec', Microseconds().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.NamedType('stime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 4))),
    namedtype.NamedType('susec', Microseconds().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 5))),
    namedtype.NamedType('error-code', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 6))),
    namedtype.OptionalNamedType('crealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 7))),
    namedtype.OptionalNamedType('cname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 8))),
    namedtype.NamedType('realm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 9))),
    namedtype.NamedType('sname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 10))),
    namedtype.OptionalNamedType('e-text', KerberosString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 11))),
    namedtype.OptionalNamedType('e-data', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 12)))
)


class KRB_PRIV(univ.Sequence):
    pass


KRB_PRIV.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 21))
KRB_PRIV.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pvno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('msg-type', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(21)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('enc-part', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3)))
)


class KRB_SAFE_BODY(univ.Sequence):
    pass


KRB_SAFE_BODY.componentType = namedtype.NamedTypes(
    namedtype.NamedType('user-data', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('timestamp', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('usec', Microseconds().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('seq-number', UInt32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.NamedType('s-address', HostAddress().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4))),
    namedtype.OptionalNamedType('r-address', HostAddress().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 5)))
)


class KRB_SAFE(univ.Sequence):
    pass


KRB_SAFE.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 20))
KRB_SAFE.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pvno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('msg-type', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(20)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('safe-body', KRB_SAFE_BODY().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.NamedType('cksum', Checksum().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3)))
)


class KRB5PrincipalName(univ.Sequence):
    pass


KRB5PrincipalName.componentType = namedtype.NamedTypes(
    namedtype.NamedType('realm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('principalName', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1)))
)


class KerbErrorDataTypeValues(univ.Integer):
    pass


KerbErrorDataTypeValues.namedValues = namedval.NamedValues(
    ('kERB-AP-ERR-TYPE-SKEW-RECOVERY', 2),
    ('kERB-ERR-TYPE-EXTENDED', 3)
)


class KerbErrorDataTypeSequence(univ.Sequence):
    pass


KerbErrorDataTypeSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', KerbErrorDataTypeValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class KrbFastArmor(univ.Sequence):
    pass


KrbFastArmor.componentType = namedtype.NamedTypes(
    namedtype.NamedType('armor-type', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('armor-value', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class KrbFastArmoredRep(univ.Sequence):
    pass


KrbFastArmoredRep.componentType = namedtype.NamedTypes(
    namedtype.NamedType('enc-fast-rep', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0)))
)


class KrbFastArmoredReq(univ.Sequence):
    pass


KrbFastArmoredReq.componentType = namedtype.NamedTypes(
    namedtype.OptionalNamedType('armor', KrbFastArmor().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.NamedType('req-checksum', Checksum().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1))),
    namedtype.NamedType('enc-fast-req', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2)))
)


class KrbFastFinished(univ.Sequence):
    pass


KrbFastFinished.componentType = namedtype.NamedTypes(
    namedtype.NamedType('timestamp', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('usec', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('crealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.NamedType('cname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3))),
    namedtype.NamedType('ticket-checksum', Checksum().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4)))
)


class KrbFastReq(univ.Sequence):
    pass


KrbFastReq.componentType = namedtype.NamedTypes(
    namedtype.NamedType('fast-options', FastOptions().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('padata', univ.SequenceOf(componentType=PA_DATA()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('req-body', KDC_REQ_BODY().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2)))
)


class KrbFastResponse(univ.Sequence):
    pass


KrbFastResponse.componentType = namedtype.NamedTypes(
    namedtype.NamedType('padata', univ.SequenceOf(componentType=PA_DATA()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('strengthen-key', EncryptionKey().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1))),
    namedtype.OptionalNamedType('finished', KrbFastFinished().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.NamedType('nonce', UInt32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3)))
)


class MS_UPN_SAN(char.UTF8String):
    pass


class MessageDigest(univ.OctetString):
    pass


class MessageTypeValues(univ.Integer):
    pass


MessageTypeValues.namedValues = namedval.NamedValues(
    ('krb-as-req', 10),
    ('krb-as-rep', 11),
    ('krb-tgs-req', 12),
    ('krb-tgs-rep', 13),
    ('krb-ap-req', 14),
    ('krb-ap-rep', 15),
    ('krb-safe', 20),
    ('krb-priv', 21),
    ('krb-cred', 22),
    ('krb-error', 30)
)


class MessageTypeSequence(univ.Sequence):
    pass


MessageTypeSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', MessageTypeValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class NameTypeValues(univ.Integer):
    pass


NameTypeValues.namedValues = namedval.NamedValues(
    ('kRB5-NT-UNKNOWN', 0),
    ('kRB5-NT-PRINCIPAL', 1),
    ('kRB5-NT-SRV-INST', 2),
    ('kRB5-NT-SRV-HST', 3),
    ('kRB5-NT-SRV-XHST', 4),
    ('kRB5-NT-UID', 5),
    ('kRB5-NT-X500-PRINCIPAL', 6),
    ('kRB5-NT-SMTP-NAME', 7),
    ('kRB5-NT-ENTERPRISE-PRINCIPAL', 10),
    ('kRB5-NT-WELLKNOWN', 11),
    ('kRB5-NT-ENT-PRINCIPAL-AND-ID', -130),
    ('kRB5-NT-MS-PRINCIPAL', -128),
    ('kRB5-NT-MS-PRINCIPAL-AND-ID', -129)
)


class NameTypeSequence(univ.Sequence):
    pass


NameTypeSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', NameTypeValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class PA_ENC_TIMESTAMP(EncryptedData):
    pass


class PA_ENC_TS_ENC(univ.Sequence):
    pass


PA_ENC_TS_ENC.componentType = namedtype.NamedTypes(
    namedtype.NamedType('patimestamp', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('pausec', Microseconds().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class PA_FX_FAST_REPLY(univ.Choice):
    pass


PA_FX_FAST_REPLY.componentType = namedtype.NamedTypes(
    namedtype.NamedType('armored-data', KrbFastArmoredRep().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0)))
)


class PA_FX_FAST_REQUEST(univ.Choice):
    pass


PA_FX_FAST_REQUEST.componentType = namedtype.NamedTypes(
    namedtype.NamedType('armored-data', KrbFastArmoredReq().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0)))
)


class PACOptionFlags(KerberosFlags):
    pass


class PA_PAC_OPTIONS(univ.Sequence):
    pass


PA_PAC_OPTIONS.componentType = namedtype.NamedTypes(
    namedtype.NamedType('options', PACOptionFlags().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class PA_PK_AS_REP(univ.Choice):
    pass


PA_PK_AS_REP.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dhInfo', DHRepInfo().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.NamedType('encKeyPack', univ.OctetString().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class PA_PK_AS_REP_Win2k(univ.Choice):
    pass


PA_PK_AS_REP_Win2k.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dhSignedData', univ.OctetString().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('encKeyPack', univ.OctetString().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class PA_PK_AS_REQ(univ.Sequence):
    pass


PA_PK_AS_REQ.componentType = namedtype.NamedTypes(
    namedtype.NamedType('signedAuthPack', univ.OctetString().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('trustedCertifiers', univ.SequenceOf(componentType=ExternalPrincipalIdentifier()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('kdcPkId', univ.OctetString().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2)))
)


class TrustedCA_Win2k(univ.Choice):
    pass


TrustedCA_Win2k.componentType = namedtype.NamedTypes(
    namedtype.NamedType('caName', univ.Any().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('issuerAndSerial', IssuerAndSerialNumber().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2)))
)


class PA_PK_AS_REQ_Win2k(univ.Sequence):
    pass


PA_PK_AS_REQ_Win2k.componentType = namedtype.NamedTypes(
    namedtype.NamedType('signedAuthPack', univ.OctetString().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('trustedCertifiers', univ.SequenceOf(componentType=TrustedCA_Win2k()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('kdcCert', univ.OctetString().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.OptionalNamedType('encryptionCert', univ.OctetString().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 4)))
)


class PA_S4U2Self(univ.Sequence):
    pass


PA_S4U2Self.componentType = namedtype.NamedTypes(
    namedtype.NamedType('name', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.NamedType('realm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('cksum', Checksum().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.NamedType('auth', KerberosString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3)))
)


class PA_SUPPORTED_ENCTYPES(Int32):
    pass


class PACOptionFlagsValues(univ.BitString):
    pass


PACOptionFlagsValues.namedValues = namedval.NamedValues(
    ('claims', 0),
    ('branch-aware', 1),
    ('forward-to-full-dc', 2),
    ('resource-based-constrained-delegation', 3)
)


class PACOptionFlagsSequence(univ.Sequence):
    pass


PACOptionFlagsSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', PACOptionFlagsValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class PADataTypeValues(univ.Integer):
    pass


PADataTypeValues.namedValues = namedval.NamedValues(
    ('kRB5-PADATA-NONE', 0),
    ('kRB5-PADATA-KDC-REQ', 1),
    ('kRB5-PADATA-ENC-TIMESTAMP', 2),
    ('kRB5-PADATA-PW-SALT', 3),
    ('kRB5-PADATA-ENC-UNIX-TIME', 5),
    ('kRB5-PADATA-SANDIA-SECUREID', 6),
    ('kRB5-PADATA-SESAME', 7),
    ('kRB5-PADATA-OSF-DCE', 8),
    ('kRB5-PADATA-CYBERSAFE-SECUREID', 9),
    ('kRB5-PADATA-AFS3-SALT', 10),
    ('kRB5-PADATA-ETYPE-INFO', 11),
    ('kRB5-PADATA-SAM-CHALLENGE', 12),
    ('kRB5-PADATA-SAM-RESPONSE', 13),
    ('kRB5-PADATA-PK-AS-REQ-19', 14),
    ('kRB5-PADATA-PK-AS-REP-19', 15),
    ('kRB5-PADATA-PK-AS-REQ', 16),
    ('kRB5-PADATA-PK-AS-REP', 17),
    ('kRB5-PADATA-PA-PK-OCSP-RESPONSE', 18),
    ('kRB5-PADATA-ETYPE-INFO2', 19),
    ('kRB5-PADATA-SVR-REFERRAL-INFO', 20),
    ('kRB5-PADATA-SAM-REDIRECT', 21),
    ('kRB5-PADATA-GET-FROM-TYPED-DATA', 22),
    ('kRB5-PADATA-SAM-ETYPE-INFO', 23),
    ('kRB5-PADATA-SERVER-REFERRAL', 25),
    ('kRB5-PADATA-ALT-PRINC', 24),
    ('kRB5-PADATA-SAM-CHALLENGE2', 30),
    ('kRB5-PADATA-SAM-RESPONSE2', 31),
    ('kRB5-PA-EXTRA-TGT', 41),
    ('kRB5-PADATA-TD-KRB-PRINCIPAL', 102),
    ('kRB5-PADATA-PK-TD-TRUSTED-CERTIFIERS', 104),
    ('kRB5-PADATA-PK-TD-CERTIFICATE-INDEX', 105),
    ('kRB5-PADATA-TD-APP-DEFINED-ERROR', 106),
    ('kRB5-PADATA-TD-REQ-NONCE', 107),
    ('kRB5-PADATA-TD-REQ-SEQ', 108),
    ('kRB5-PADATA-PA-PAC-REQUEST', 128),
    ('kRB5-PADATA-FOR-USER', 129),
    ('kRB5-PADATA-FOR-X509-USER', 130),
    ('kRB5-PADATA-FOR-CHECK-DUPS', 131),
    ('kRB5-PADATA-AS-CHECKSUM', 132),
    ('kRB5-PADATA-FX-COOKIE', 133),
    ('kRB5-PADATA-AUTHENTICATION-SET', 134),
    ('kRB5-PADATA-AUTH-SET-SELECTED', 135),
    ('kRB5-PADATA-FX-FAST', 136),
    ('kRB5-PADATA-FX-ERROR', 137),
    ('kRB5-PADATA-ENCRYPTED-CHALLENGE', 138),
    ('kRB5-PADATA-OTP-CHALLENGE', 141),
    ('kRB5-PADATA-OTP-REQUEST', 142),
    ('kBB5-PADATA-OTP-CONFIRM', 143),
    ('kRB5-PADATA-OTP-PIN-CHANGE', 144),
    ('kRB5-PADATA-EPAK-AS-REQ', 145),
    ('kRB5-PADATA-EPAK-AS-REP', 146),
    ('kRB5-PADATA-PKINIT-KX', 147),
    ('kRB5-PADATA-PKU2U-NAME', 148),
    ('kRB5-PADATA-REQ-ENC-PA-REP', 149),
    ('kRB5-PADATA-AS-FRESHNESS', 150),
    ('kRB5-PADATA-SUPPORTED-ETYPES', 165),
    ('kRB5-PADATA-PAC-OPTIONS', 167),
    ('kRB5-PADATA-GSS', 655)
)


class PADataTypeSequence(univ.Sequence):
    pass


PADataTypeSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', PADataTypeValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class ReplyKeyPack(univ.Sequence):
    pass


ReplyKeyPack.componentType = namedtype.NamedTypes(
    namedtype.NamedType('replyKey', EncryptionKey().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.NamedType('asChecksum', Checksum().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1)))
)


class ReplyKeyPack_Win2k(univ.Sequence):
    pass


ReplyKeyPack_Win2k.componentType = namedtype.NamedTypes(
    namedtype.NamedType('replyKey', EncryptionKey().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.NamedType('nonce', univ.Integer().subtype(subtypeSpec=constraint.ValueRangeConstraint(-2147483648, 2147483647)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class SignatureValue(univ.OctetString):
    pass


class SignedAttributes(univ.SetOf):
    pass


SignedAttributes.componentType = Attribute()
SignedAttributes.subtypeSpec=constraint.ValueSizeConstraint(1, 256)


class SignerIdentifier(univ.Choice):
    pass


SignerIdentifier.componentType = namedtype.NamedTypes(
    namedtype.NamedType('issuerAndSerialNumber', IssuerAndSerialNumber()),
    namedtype.NamedType('subjectKeyIdentifier', SubjectKeyIdentifier().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class UnsignedAttributes(univ.SetOf):
    pass


UnsignedAttributes.componentType = Attribute()
UnsignedAttributes.subtypeSpec=constraint.ValueSizeConstraint(1, 256)


class SignerInfo(univ.Sequence):
    pass


SignerInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('version', CMSVersion()),
    namedtype.NamedType('sid', SignerIdentifier()),
    namedtype.NamedType('digestAlgorithm', DigestAlgorithmIdentifier()),
    namedtype.OptionalNamedType('signedAttrs', SignedAttributes().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('signatureAlgorithm', SignatureAlgorithmIdentifier()),
    namedtype.NamedType('signature', SignatureValue()),
    namedtype.OptionalNamedType('unsignedAttrs', UnsignedAttributes().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class SignerInfos(univ.SetOf):
    pass


SignerInfos.componentType = SignerInfo()


class SignedData(univ.Sequence):
    pass


SignedData.componentType = namedtype.NamedTypes(
    namedtype.NamedType('version', CMSVersion()),
    namedtype.NamedType('digestAlgorithms', DigestAlgorithmIdentifiers()),
    namedtype.NamedType('encapContentInfo', EncapsulatedContentInfo()),
    namedtype.OptionalNamedType('certificates', CertificateSet().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('crls', RevocationInfoChoices().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('signerInfos', SignerInfos())
)


class Version_RFC2315(univ.Integer):
    pass


class SignedData_RFC2315(univ.Sequence):
    pass


SignedData_RFC2315.componentType = namedtype.NamedTypes(
    namedtype.NamedType('version', Version_RFC2315()),
    namedtype.NamedType('digestAlgorithms', DigestAlgorithmIdentifiers()),
    namedtype.NamedType('contentInfo', ContentInfo()),
    namedtype.OptionalNamedType('certificates', CertificateSet().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('crls', RevocationInfoChoices().subtype(implicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('signerInfos', SignerInfos())
)


class SubjectAltName(GeneralNames):
    pass


class SubjectKeyIdentifier(univ.OctetString):
    pass


class TD_DH_PARAMETERS(univ.SequenceOf):
    pass


TD_DH_PARAMETERS.componentType = AlgorithmIdentifier()


class TD_INVALID_CERTIFICATES(univ.SequenceOf):
    pass


TD_INVALID_CERTIFICATES.componentType = ExternalPrincipalIdentifier()


class TD_TRUSTED_CERTIFIERS(univ.SequenceOf):
    pass


TD_TRUSTED_CERTIFIERS.componentType = ExternalPrincipalIdentifier()


class TGS_REP(KDC_REP):
    pass


TGS_REP.tagSet = KDC_REP.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 13))


class TGS_REQ(KDC_REQ):
    pass


TGS_REQ.tagSet = KDC_REQ.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 12))


class TYPED_DATA(univ.SequenceOf):
    pass


TYPED_DATA.componentType = univ.Sequence(componentType=namedtype.NamedTypes(
    namedtype.NamedType('data-type', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('data-value', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
))

TYPED_DATA.subtypeSpec=constraint.ValueSizeConstraint(1, 256)


class TicketFlagsValues(univ.BitString):
    pass


TicketFlagsValues.namedValues = namedval.NamedValues(
    ('reserved', 0),
    ('forwardable', 1),
    ('forwarded', 2),
    ('proxiable', 3),
    ('proxy', 4),
    ('may-postdate', 5),
    ('postdated', 6),
    ('invalid', 7),
    ('renewable', 8),
    ('initial', 9),
    ('pre-authent', 10),
    ('hw-authent', 11),
    ('transited-policy-checked', 12),
    ('ok-as-delegate', 13),
    ('enc-pa-rep', 15)
)


class TicketFlagsSequence(univ.Sequence):
    pass


TicketFlagsSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', TicketFlagsValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


nistAlgorithms = _OID(2, 16, 840, 1, 101, 3, 4)


aes = _OID(nistAlgorithms, 1)


aes256_CBC_PAD = _OID(aes, 42)


rsadsi = _OID(1, 2, 840, 113549)


encryptionAlgorithm = _OID(rsadsi, 3)


des_EDE3_CBC = _OID(encryptionAlgorithm, 7)


dhpublicnumber = _OID(1, 2, 840, 10046, 2, 1)


id_ce = _OID(2, 5, 29)


id_ce_subjectAltName = _OID(id_ce, 17)


id_contentType = _OID(1, 2, 840, 113549, 1, 9, 3)


id_data = _OID(1, 2, 840, 113549, 1, 7, 1)


id_envelopedData = _OID(1, 2, 840, 113549, 1, 7, 3)


id_krb5 = _OID(1, 3, 6, 1, 5, 2)


id_messageDigest = _OID(1, 2, 840, 113549, 1, 9, 4)


id_pkcs1_sha256WithRSAEncryption = _OID(1, 2, 840, 113549, 1, 1, 11)


id_pkinit = _OID(1, 3, 6, 1, 5, 2, 3)


id_pkinit_DHKeyData = _OID(id_pkinit, 2)


id_pkinit_authData = _OID(id_pkinit, 1)


id_pkinit_ms_san = _OID(1, 3, 6, 1, 4, 1, 311, 20, 2, 3)


id_pkinit_rkeyData = _OID(id_pkinit, 3)


id_sha1 = _OID(1, 3, 14, 3, 2, 26)


id_sha512 = _OID(2, 16, 840, 1, 101, 3, 4, 2, 3)


id_signedData = _OID(1, 2, 840, 113549, 1, 7, 2)


kdc_authentication = _OID(id_pkinit, 5)


md2 = _OID(1, 2, 840, 113549, 2, 2)


md5 = _OID(1, 2, 840, 113549, 2, 5)


rsaEncryption = _OID(1, 2, 840, 113549, 1, 1, 1)


sha1WithRSAEncryption = _OID(1, 2, 840, 113549, 1, 1, 5)


smartcard_logon = _OID(1, 3, 6, 1, 4, 1, 311, 20, 2, 2)


szOID_NTDS_CA_SECURITY_EXT = _OID(1, 3, 6, 1, 4, 1, 311, 25, 2)


szOID_NTDS_OBJECTSID = _OID(1, 3, 6, 1, 4, 1, 311, 25, 2, 1)


ub_common_name = univ.Integer(64)


ub_common_name_length = univ.Integer(64)


ub_e163_4_number_length = univ.Integer(15)


ub_e163_4_sub_address_length = univ.Integer(40)


ub_emailaddress_length = univ.Integer(255)


ub_integer_options = univ.Integer(256)


ub_locality_name = univ.Integer(128)


ub_match = univ.Integer(128)


ub_name = univ.Integer(32768)


ub_organization_name = univ.Integer(64)


ub_organizational_unit_name = univ.Integer(64)


ub_pds_name_length = univ.Integer(16)


ub_pds_parameter_length = univ.Integer(30)


ub_pds_physical_address_lines = univ.Integer(6)


ub_postal_code_length = univ.Integer(16)


ub_pseudonym = univ.Integer(128)


ub_serial_number = univ.Integer(64)


ub_state_name = univ.Integer(128)


ub_title = univ.Integer(64)


ub_unformatted_address_length = univ.Integer(180)


