/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*****************************************************************************/
/* This is an automatically generated file. If you're not                    */
/* nsSiteSecurityService.cpp, you shouldn't be #including it.     */
/*****************************************************************************/

#include <stdint.h>
const PRTime gPreloadListExpirationTime = INT64_C(1554207118864000);

class nsSTSPreload
{
  public:
    const char *mHost;
    const bool mIncludeSubdomains;
};

static const nsSTSPreload kSTSPreloadList[] = {
  { "0010100.net", true },
  { "0086286.com", true },
  { "00dani.me", true },
  { "00f.net", true },
  { "0100dev.com", false },
  { "0100dev.nl", false },
  { "01011970.xyz", true },
  { "01110000011100110111001001100111.com", true },
  { "01electronica.com.ar", true },
  { "01seguridad.com.ar", true },
  { "022367.com", true },
  { "022379.com", true },
  { "022391.com", true },
  { "022501.com", true },
  { "022503.com", true },
  { "022507.com", true },
  { "022561.com", true },
  { "022571.com", true },
  { "022601.com", true },
  { "022609.com", true },
  { "022610.com", true },
  { "02327.net", true },
  { "02375.net", true },
  { "023sec.com", true },
  { "026122.com", true },
  { "02638.net", true },
  { "0391315.com", true },
  { "046569.com", true },
  { "050.ca", true },
  { "050media.nl", true },
  { "0511315.net", true },
  { "0513c.com", true },
  { "0573wk.com", true },
  { "06091994.xyz", true },
  { "06se.com", true },
  { "0788yh.com", true },
  { "0792112.com", true },
  { "0809yh.com", true },
  { "081752.com", true },
  { "081763.com", true },
  { "081769.com", true },
  { "081783.com", true },
  { "081925.com", true },
  { "081927.com", true },
  { "081957.com", true },
  { "081967.com", true },
  { "082157.com", true },
  { "082159.com", true },
  { "082167.com", true },
  { "082173.com", true },
  { "082175.com", true },
  { "082179.com", true },
  { "082187.com", true },
  { "082192.com", true },
  { "082193.com", true },
  { "082195.com", true },
  { "082359.com", true },
  { "083903.com", true },
  { "083905.com", true },
  { "083907.com", true },
  { "083912.com", true },
  { "083957.com", true },
  { "083960.com", true },
  { "083965.com", true },
  { "083967.com", true },
  { "08detaxe.fr", true },
  { "0916app.com", true },
  { "09892.net", true },
  { "0au.de", true },
  { "0c3.de", true },
  { "0day.agency", true },
  { "0des.com", true },
  { "0ik.de", true },
  { "0knowledge.de", false },
  { "0o0.edu.pl", true },
  { "0paste.com", true },
  { "0wx.cat", true },
  { "0wx.es", true },
  { "0wx.eu", true },
  { "0wx.org", true },
  { "0x.cx", true },
  { "0x.sk", true },
  { "0x0.cloud", true },
  { "0x0.li", true },
  { "0x00ff00ff.com", true },
  { "0x17.de", true },
  { "0x378.net", true },
  { "0x48.pw", true },
  { "0x52.net", true },
  { "0x7d.com", true },
  { "0x7fffffff.net", true },
  { "0x90.io", true },
  { "0xabe.io", true },
  { "0xacab.org", true },
  { "0xda.de", true },
  { "0xdc.io", false },
  { "0xdefaced.de", true },
  { "0xee.eu", true },
  { "0xfc.de", true },
  { "0xn.de", true },
  { "0yen.org", true },
  { "1-2-3bounce.co.uk", true },
  { "100-downloads.com", true },
  { "10000v.ru", true },
  { "1000minds.com", true },
  { "1000serien.com", true },
  { "1001carats.fr", true },
  { "1001firms.com", true },
  { "1001kartini.com", true },
  { "1001kerstpakketten.com", false },
  { "1001mv.com", true },
  { "10086.nl", true },
  { "10086.ru", true },
  { "100and1.jp", true },
  { "100kredite.de", true },
  { "100lat.pl", true },
  { "100mani.it", true },
  { "100pounds.co.uk", true },
  { "100rembourse.be", true },
  { "101.qa", true },
  { "1011100.com", true },
  { "101sauna.kz", true },
  { "101sauna.ru", true },
  { "1041263497.rsc.cdn77.org", true },
  { "10430.net", true },
  { "10435.net", true },
  { "10436.net", true },
  { "10438.net", true },
  { "10439.net", true },
  { "10453.net", true },
  { "10495.net", true },
  { "10774.net", true },
  { "10840.net", true },
  { "10hz.de", true },
  { "10og.de", true },
  { "10ppm.com", true },
  { "112app.nl", true },
  { "112hz.com", true },
  { "114514ss.com", true },
  { "1177107.com", true },
  { "11dzon.com", true },
  { "11loc.de", true },
  { "11thstreetcoffee.com", true },
  { "11urss.com", true },
  { "1212873467.rsc.cdn77.org", true },
  { "1218641649.rsc.cdn77.org", true },
  { "123.gg", true },
  { "1231212.com", true },
  { "123123q.com", true },
  { "123123qq.com", true },
  { "123apps.net", true },
  { "123bearing.co.uk", true },
  { "123bearing.com", true },
  { "123bearing.eu", true },
  { "123comparer.fr", true },
  { "123djdrop.com", true },
  { "123midterm.com", true },
  { "123opstalverzekeringen.nl", true },
  { "123pay.ir", false },
  { "123plons.nl", true },
  { "123roulement.be", true },
  { "123roulement.com", true },
  { "123writings.com", true },
  { "124133.com", true },
  { "124633.com", true },
  { "125m125.de", true },
  { "1288fc.com", true },
  { "12photos.eu", true },
  { "12thmanrising.com", true },
  { "12train.com", true },
  { "12vpn.net", true },
  { "130.ua", true },
  { "132kv.ch", true },
  { "1359826938.rsc.cdn77.org", true },
  { "13th-dover.uk", true },
  { "143533.com", true },
  { "143633.com", true },
  { "143733.com", true },
  { "143933.com", true },
  { "1453914078.rsc.cdn77.org", true },
  { "145433.com", true },
  { "145733.com", true },
  { "146233.com", true },
  { "146433.com", true },
  { "1464424382.rsc.cdn77.org", true },
  { "146533.com", true },
  { "146733.com", true },
  { "149433.com", true },
  { "149733.com", true },
  { "14it.de", true },
  { "14x3.de", true },
  { "15-10.com", true },
  { "1511774230.rsc.cdn77.org", true },
  { "152433.com", true },
  { "1527web.com", true },
  { "154233.com", true },
  { "154633.com", true },
  { "154933.com", true },
  { "156433.com", true },
  { "1590284872.rsc.cdn77.org", true },
  { "159cp.com", true },
  { "1600esplanade.com", true },
  { "160887.com", true },
  { "1644091933.rsc.cdn77.org", true },
  { "1661237.com", true },
  { "1750studios.com", false },
  { "1768calc.com.au", true },
  { "1811559.com", true },
  { "1844329061.rsc.cdn77.org", true },
  { "1876996.com", true },
  { "188da.com", true },
  { "188dv.com", true },
  { "1895media.com", true },
  { "189fc.com", true },
  { "18celebration.com", true },
  { "18celebration.org", true },
  { "18f.gov", true },
  { "18f.gsa.gov", false },
  { "1911trust.com", true },
  { "192168ll.repair", true },
  { "192433.com", true },
  { "1972969867.rsc.cdn77.org", true },
  { "1981612088.rsc.cdn77.org", true },
  { "19area.cn", true },
  { "19hundert84.de", true },
  { "1a-diamantscheiben.de", true },
  { "1a-vermessung.at", true },
  { "1a-werkstattgeraete.de", true },
  { "1ab-machinery.com", true },
  { "1c-power.ru", true },
  { "1cover.co.nz", true },
  { "1cover.com.au", true },
  { "1cswd.com", true },
  { "1e9.nl", true },
  { "1f123.net", true },
  { "1fach-digital.de", true },
  { "1hourproofreading.com", true },
  { "1it.click", true },
  { "1js.de", true },
  { "1kando.com", false },
  { "1km.ro", true },
  { "1kmi.co", true },
  { "1ll.uk", true },
  { "1lord1faith.com", true },
  { "1montre.fr", true },
  { "1morebounce.co.uk", true },
  { "1nfr.com", false },
  { "1oaklasvegas.com", true },
  { "1of16.de", true },
  { "1on1on1.de", true },
  { "1on1on1.tv", true },
  { "1panorama.ru", true },
  { "1para.net", true },
  { "1password.ca", true },
  { "1password.com", true },
  { "1password.eu", true },
  { "1pw.ca", true },
  { "1px.tv", true },
  { "1r.is", true },
  { "1rs.nl", true },
  { "1scope.com", true },
  { "1se.co", true },
  { "1se2or3.com", true },
  { "1st-bounce.co.uk", true },
  { "1st-community.de", true },
  { "1stchoicefun.co.uk", true },
  { "1stclassbouncycastles.co.uk", true },
  { "1stforfun.co.uk", true },
  { "1stpeninsulabouncers.co.uk", true },
  { "1volcano.ru", true },
  { "1way.faith", true },
  { "1whw.co.uk", true },
  { "1wirelog.de", true },
  { "1wl.uk", true },
  { "2.wtf", true },
  { "200.network", true },
  { "2012.ovh", true },
  { "20188088.com", true },
  { "20at.com", true },
  { "20denier.com", true },
  { "215dy.net", true },
  { "21sthammersmith.org.uk", true },
  { "21stnc.us", true },
  { "21x9.org", true },
  { "222001.com", true },
  { "2222yh.com", true },
  { "22vetter.st", true },
  { "230beats.com", true },
  { "23333.link", true },
  { "2333666.xyz", true },
  { "2333blog.com", true },
  { "233abc.com", true },
  { "233blog.com", true },
  { "233boy.com", true },
  { "233bwg.com", true },
  { "233hugo.com", true },
  { "233ss.net", true },
  { "233vps.com", true },
  { "233yes.com", true },
  { "24-7.jp", true },
  { "245meadowvistaway.com", true },
  { "246060.ru", true },
  { "247exchange.com", true },
  { "247healthshop.com", true },
  { "247medplan.com", true },
  { "2495dentalimplants.com", true },
  { "24dian30.com", true },
  { "24hour-locksmithsanantonio.com", true },
  { "24hourcyclist.co.uk", true },
  { "24hourlocksmithbaltimore.com", true },
  { "24hourlocksmithdallastx.com", true },
  { "24hourlocksmithdetroit.com", true },
  { "24hourlocksmithshouston.com", true },
  { "24hoursanantoniolocksmiths.com", true },
  { "24hourscienceprojects.com", true },
  { "24ip.com", true },
  { "24ip.de", true },
  { "24ip.fr", true },
  { "24timeravis.dk", true },
  { "24zpravy.cz", true },
  { "256pages.com", false },
  { "25reinyan25.net", true },
  { "2600edinburgh.org", true },
  { "2600hq.com", true },
  { "260887.com", true },
  { "263.info", true },
  { "2718282.net", true },
  { "28-industries.com", true },
  { "281180.de", true },
  { "2858958.com", true },
  { "286.com", true },
  { "28peaks.com", true },
  { "28spots.net", true },
  { "291167.xyz", true },
  { "2912.nl", true },
  { "2948.ca", true },
  { "297computers.com", true },
  { "2991236.com", true },
  { "2au.ru", true },
  { "2bas.nl", true },
  { "2bcompany.ch", true },
  { "2bis10.de", true },
  { "2bougie.com", true },
  { "2c-b.com", true },
  { "2c-d.com", true },
  { "2c-e.com", true },
  { "2c-t-2.com", true },
  { "2c-t-7.com", true },
  { "2c-t-8.com", true },
  { "2cash.ru", true },
  { "2chan.eu", true },
  { "2chan.jp", true },
  { "2cv-fahrer.de", true },
  { "2fm.ie", true },
  { "2fm.radio", true },
  { "2fraud.pro", true },
  { "2g1s.net", true },
  { "2gen.com", true },
  { "2h-nagoya.org", true },
  { "2heartsbookings.co.uk", true },
  { "2hypeenterprises.com", true },
  { "2kgwf.fi", true },
  { "2krueger.de", true },
  { "2manydots.nl", true },
  { "2mb.solutions", true },
  { "2mir.com", true },
  { "2nains.ch", true },
  { "2nerds1bit.com", true },
  { "2nics.net", true },
  { "2pay.fr", true },
  { "2programmers.net", true },
  { "2rsc.com", true },
  { "2rsc.net", true },
  { "2stv.net", true },
  { "2ulcceria.nl", true },
  { "2wheel.com", true },
  { "2y.fi", true },
  { "3-dot-careapp1-146314.appspot.com", true },
  { "300m.com", false },
  { "302422.com", true },
  { "303422.com", true },
  { "304122.com", true },
  { "304322.com", true },
  { "304622.com", true },
  { "304squadron.org", true },
  { "3056999.com", true },
  { "309422.com", true },
  { "30hzcollective.com", true },
  { "310422.com", true },
  { "313422.com", true },
  { "314022.com", true },
  { "314122.com", true },
  { "314322.com", true },
  { "314522.com", true },
  { "314553.com", true },
  { "314622.com", true },
  { "314633.com", true },
  { "314922.com", true },
  { "315422.com", true },
  { "316433.com", true },
  { "319422.com", true },
  { "319k3.com", true },
  { "31klabs.com", true },
  { "320281.net", true },
  { "321live.nl", true },
  { "324022.com", true },
  { "324122.com", true },
  { "324133.com", true },
  { "324522.com", true },
  { "324533.com", true },
  { "324922.com", true },
  { "325422.com", true },
  { "326422.com", true },
  { "326433.com", true },
  { "329422.com", true },
  { "32h.de", true },
  { "33-km.ru", true },
  { "3333yh.com", true },
  { "33445.com", true },
  { "33445111.com", true },
  { "33445222.com", true },
  { "33445333.com", true },
  { "33445444.com", true },
  { "33jiasu.com", true },
  { "340422.com", true },
  { "340622.com", true },
  { "340922.com", true },
  { "341422.com", true },
  { "341433.com", true },
  { "341533.com", true },
  { "341633.com", true },
  { "341733.com", true },
  { "341922.com", true },
  { "342022.com", true },
  { "342033.com", true },
  { "342133.com", true },
  { "342633.com", true },
  { "342733.com", true },
  { "342922.com", true },
  { "342933.com", true },
  { "343022.com", true },
  { "343622.com", true },
  { "343722.com", true },
  { "343922.com", true },
  { "346022.com", true },
  { "346033.com", true },
  { "346122.com", true },
  { "346233.com", true },
  { "346322.com", true },
  { "346422.com", true },
  { "346522.com", true },
  { "346533.com", true },
  { "346722.com", true },
  { "346922.com", true },
  { "3473-wiki.de", true },
  { "348233.com", true },
  { "348433.com", true },
  { "348533.com", true },
  { "349022.com", true },
  { "349033.com", true },
  { "349233.com", true },
  { "349433.com", true },
  { "349533.com", true },
  { "350422.com", true },
  { "354022.com", true },
  { "354133.com", true },
  { "354233.com", true },
  { "354622.com", true },
  { "354633.com", true },
  { "354922.com", true },
  { "354933.com", true },
  { "356433.com", true },
  { "357maelai.co", true },
  { "360live.fr", true },
  { "360rail.nl", true },
  { "360vrs.com", true },
  { "364553.com", true },
  { "365365.com", true },
  { "365beautyworld.com", true },
  { "365daysreview.com", true },
  { "365healthworld.com", true },
  { "365propertybuyer.co.uk", true },
  { "365skulls.com", true },
  { "370422.com", true },
  { "371422.com", true },
  { "371cloud.com", true },
  { "373422.com", true },
  { "374933.com", true },
  { "375422.com", true },
  { "379700.com", true },
  { "380422.com", true },
  { "388da.com", true },
  { "390422.com", true },
  { "392422.com", true },
  { "393335.ml", true },
  { "393422.com", true },
  { "394022.com", true },
  { "394122.com", true },
  { "394322.com", true },
  { "394522.com", true },
  { "394553.com", true },
  { "394622.com", true },
  { "394922.com", true },
  { "396422.com", true },
  { "398.info", true },
  { "39sihu.com", false },
  { "3aandl.com", true },
  { "3ags.de", true },
  { "3amtoolbox.se", true },
  { "3ank.in", true },
  { "3bakayottu.com", true },
  { "3bigking.com", true },
  { "3c-d.de", true },
  { "3chat.org", true },
  { "3circlefunding.ch", true },
  { "3countiescastlehire.co.uk", true },
  { "3cs.ch", true },
  { "3d-fotoservice.de", true },
  { "3de5.nl", true },
  { "3deeplearner.com", true },
  { "3djuegos.com", true },
  { "3dmedium.de", true },
  { "3dmusiclab.nl", true },
  { "3do3dont.com", true },
  { "3dprintsondemand.eu", true },
  { "3drenaline.com", true },
  { "3haeuserprojekt.org", true },
  { "3haueserprojekt.org", true },
  { "3logic.ru", true },
  { "3lot.ru", true },
  { "3n5b.com", true },
  { "3os.ooo", true },
  { "3phase.pw", true },
  { "3plusdesign.gr", true },
  { "3prn.com", true },
  { "3queens.cz", true },
  { "3queens.io", true },
  { "3r.org.uk", true },
  { "3s-datasolution.de", true },
  { "3s-datasolutions.de", true },
  { "3s-ddns.de", true },
  { "3s-dns.de", true },
  { "3s-hosting.de", true },
  { "3s-mail.de", true },
  { "3sdatasolution.de", true },
  { "3sdatasolutions.de", true },
  { "3sddns.de", true },
  { "3sdns.de", true },
  { "3shosting.de", true },
  { "3smail.de", true },
  { "3timegear.com", true },
  { "3trees.tk", true },
  { "3tribes.co.uk", true },
  { "3typen.tv", true },
  { "3v4l.org", true },
  { "4-1-where.com", true },
  { "4-it.de", true },
  { "4000milestare.com", false },
  { "403.ch", true },
  { "404notfound.com.br", true },
  { "4096b.com", true },
  { "4096bit.de", false },
  { "40acts.org.uk", true },
  { "41-where.com", true },
  { "411416.com", true },
  { "41199.com", true },
  { "411film.com", true },
  { "411movie.com", true },
  { "414553.com", true },
  { "41studio.com", true },
  { "41where.com", true },
  { "420java.com", true },
  { "42ch.com", true },
  { "42day.info", true },
  { "439050.com", true },
  { "440887.com", true },
  { "441jj.com", false },
  { "442887.com", true },
  { "443887.com", true },
  { "4444yh.com", true },
  { "444887.com", true },
  { "445887.com", true },
  { "44sec.com", true },
  { "451.ooo", true },
  { "4553s.com", true },
  { "4553vip.com", true },
  { "4706666.com", true },
  { "4716666.com", true },
  { "4726666.com", true },
  { "4736666.com", true },
  { "4756666.com", true },
  { "4786666.com", true },
  { "491mhz.net", true },
  { "49889.com", true },
  { "49dollaridahoregisteredagent.com", true },
  { "4c-haircare.com", true },
  { "4everproxy.com", true },
  { "4eyes.ch", true },
  { "4fit.ro", true },
  { "4flex.info", true },
  { "4freepress.com", true },
  { "4g-server.eu", false },
  { "4garage.com.br", true },
  { "4host.ch", true },
  { "4kprojektory.cz", true },
  { "4mm.org", true },
  { "4plebs.moe", true },
  { "4project.co.il", true },
  { "4share.tv", true },
  { "4sics.se", true },
  { "4th-ave-studio.com", true },
  { "4thdc.com", true },
  { "4u.services", true },
  { "4u2ore.net", true },
  { "4vector.com", true },
  { "4vf.de", true },
  { "4x.fi", true },
  { "4x4.lk", true },
  { "4x4tt.com", true },
  { "4xlabs.co", true },
  { "50.gd", true },
  { "50.pe", true },
  { "500a500.com", true },
  { "500b500.com", true },
  { "500c500.com", true },
  { "500d500.com", true },
  { "500e500.com", true },
  { "500f500.com", true },
  { "500g500.com", true },
  { "500h500.com", true },
  { "500i500.com", true },
  { "500j500.com", true },
  { "500k500.com", true },
  { "500l500.com", true },
  { "500m500.com", true },
  { "500n500.com", true },
  { "500o500.com", true },
  { "500p.xyz", true },
  { "500p500.com", true },
  { "500pingtai.com", true },
  { "500q500.com", true },
  { "500r500.com", true },
  { "500s500.com", true },
  { "500t500.com", true },
  { "500u500.com", true },
  { "500y500.com", true },
  { "500z500.com", true },
  { "504122.com", true },
  { "504322.com", true },
  { "504622.com", true },
  { "504922.com", true },
  { "506422.com", true },
  { "506pay.com", true },
  { "50lakeshore.com", true },
  { "50north.de", true },
  { "514122.com", true },
  { "514522.com", true },
  { "514622.com", true },
  { "514922.com", true },
  { "515422.com", true },
  { "516422.com", true },
  { "51877.net", true },
  { "519422.com", true },
  { "51acg.eu.org", true },
  { "524022.com", true },
  { "524622.com", true },
  { "524922.com", true },
  { "525.info", true },
  { "52hentai.ml", true },
  { "52kb365.com", true },
  { "52ncp.net", true },
  { "52sykb.com", true },
  { "531422.com", true },
  { "534122.com", true },
  { "534622.com", true },
  { "534922.com", true },
  { "536422.com", true },
  { "5364b.com", true },
  { "5364c.com", true },
  { "5364d.com", true },
  { "5364jc.com", true },
  { "53ningen.com", true },
  { "540922.com", true },
  { "541022.com", true },
  { "541622.com", true },
  { "541722.com", true },
  { "541922.com", true },
  { "545922.com", true },
  { "546802.com", true },
  { "54below.com", true },
  { "5518k3.com", true },
  { "5533445.com", true },
  { "5555yh.com", true },
  { "55639.com", true },
  { "55797.com", true },
  { "558da.com", true },
  { "566380.com", true },
  { "575380.com", true },
  { "576422.com", true },
  { "578380.com", true },
  { "579422.com", true },
  { "57wilkie.net", true },
  { "583422.com", true },
  { "585380.com", true },
  { "585422.com", true },
  { "586422.com", true },
  { "588da.com", true },
  { "591380.com", true },
  { "591422.com", true },
  { "592380.com", true },
  { "592422.com", true },
  { "5930593.com", true },
  { "593380.com", true },
  { "594022.com", true },
  { "594622.com", true },
  { "595422.com", true },
  { "596422.com", true },
  { "598380.com", true },
  { "5986fc.com", true },
  { "5997891.com", true },
  { "5apps.com", true },
  { "5c1fd0f31022cbc40af9f785847baaf9.space", true },
  { "5crowd.com", true },
  { "5dm.tv", true },
  { "5dwin.com", true },
  { "5dwin.net", true },
  { "5francs.com", true },
  { "5gb.space", true },
  { "5kraceforals.com", true },
  { "5percentperweek.com", true },
  { "5thchichesterscouts.org.uk", true },
  { "5y.fi", true },
  { "602422.com", true },
  { "604122.com", true },
  { "604322.com", true },
  { "604522.com", true },
  { "604622.com", true },
  { "605422.com", true },
  { "606422.com", true },
  { "609422.com", true },
  { "609avenue.com", true },
  { "614022.com", true },
  { "614322.com", true },
  { "614922.com", true },
  { "61730123.com", true },
  { "621422.com", true },
  { "624022.com", true },
  { "624122.com", true },
  { "624322.com", true },
  { "624522.com", true },
  { "624922.com", true },
  { "626380.com", true },
  { "626422.com", true },
  { "630422.com", true },
  { "631422.com", true },
  { "634022.com", true },
  { "634322.com", true },
  { "634622.com", true },
  { "634922.com", true },
  { "635422.com", true },
  { "636422.com", true },
  { "639422.com", true },
  { "640622.com", true },
  { "640722.com", true },
  { "640922.com", true },
  { "641022.com", true },
  { "641322.com", true },
  { "641422.com", true },
  { "641522.com", true },
  { "641622.com", true },
  { "641722.com", true },
  { "641822.com", true },
  { "641922.com", true },
  { "642022.com", true },
  { "642322.com", true },
  { "642422.com", true },
  { "642722.com", true },
  { "642822.com", true },
  { "642922.com", true },
  { "643022.com", true },
  { "643122.com", true },
  { "643722.com", true },
  { "643922.com", true },
  { "645022.com", true },
  { "645122.com", true },
  { "645322.com", true },
  { "645722.com", true },
  { "645822.com", true },
  { "645922.com", true },
  { "646022.com", true },
  { "646322.com", true },
  { "646722.com", true },
  { "649022.com", true },
  { "649622.com", true },
  { "649722.com", true },
  { "649822.com", true },
  { "651422.com", true },
  { "652422.com", true },
  { "6541166.com", true },
  { "6542277.com", true },
  { "6543399.com", true },
  { "65477.com", true },
  { "6547700.com", true },
  { "6547711.com", true },
  { "6547722.com", true },
  { "6547733.com", true },
  { "6547744.com", true },
  { "6547755.com", true },
  { "6547766.com", true },
  { "6548855.com", true },
  { "6548877.com", true },
  { "656088.com", true },
  { "659422.com", true },
  { "66136.com", true },
  { "6616fc.com", true },
  { "6633445.com", true },
  { "6652566.com", true },
  { "6660111.ru", true },
  { "6664553.com", true },
  { "666668722.com", true },
  { "6666yh.com", true },
  { "666omg.com", true },
  { "66b.com", true },
  { "66bwf.com", true },
  { "670422.com", true },
  { "671422.com", true },
  { "672422.com", true },
  { "673422.com", true },
  { "676422.com", true },
  { "679422.com", true },
  { "680226.com", true },
  { "680422.com", true },
  { "68277.me", true },
  { "686848.com", true },
  { "690422.com", true },
  { "691422.com", true },
  { "692422.com", true },
  { "693422.com", true },
  { "694322.com", true },
  { "694622.com", true },
  { "694922.com", true },
  { "6969.us", true },
  { "698da.com", true },
  { "69928.com", true },
  { "6997896.com", true },
  { "69butterfly.com", true },
  { "69fps.gg", true },
  { "69wasted.net", true },
  { "6ird.com", true },
  { "6lo.zgora.pl", true },
  { "6pm.com", true },
  { "6t-montjoye.org", true },
  { "700.az", true },
  { "704233.com", true },
  { "7045.com", true },
  { "704533.com", true },
  { "7045h.com", true },
  { "704633.com", true },
  { "712433.com", true },
  { "713433.com", true },
  { "714133.com", true },
  { "714533.com", true },
  { "714633.com", true },
  { "715433.com", true },
  { "718433.com", true },
  { "719433.com", true },
  { "724233.com", true },
  { "726433.com", true },
  { "728433.com", true },
  { "729433.com", true },
  { "730433.com", true },
  { "731433.com", true },
  { "732433.com", true },
  { "735433.com", true },
  { "736433.com", true },
  { "738433.com", true },
  { "739433.com", true },
  { "740833.com", true },
  { "741833.com", true },
  { "742833.com", true },
  { "743833.com", true },
  { "74th.jp", true },
  { "755k3.com", true },
  { "762.ch", true },
  { "7733445.com", true },
  { "7777yh.com", true },
  { "777coin.com", true },
  { "783lab.com", true },
  { "787k3.com", true },
  { "7885765.com", true },
  { "7891553.com", true },
  { "7891997.com", true },
  { "79ch.com", true },
  { "7careconnect.com", true },
  { "7delights.com", true },
  { "7delights.in", true },
  { "7geese.com", true },
  { "7graus.pt", true },
  { "7kicks.com", true },
  { "7qly.com", true },
  { "7sons.de", true },
  { "7thcircledesigns.com", true },
  { "7trade8.com", true },
  { "7x24servis.com", true },
  { "804322.com", true },
  { "8086.cf", true },
  { "809422.com", true },
  { "80993.net", true },
  { "814022.com", true },
  { "81818app.com", true },
  { "8189196.com", true },
  { "818bwf.com", true },
  { "818da.com", true },
  { "8349822.com", true },
  { "850226.com", true },
  { "8522.com", true },
  { "8522club.com", true },
  { "8522hk.com", true },
  { "8522ph.com", true },
  { "8522tw.com", true },
  { "8522usa.com", true },
  { "86286286.com", true },
  { "86499.com", true },
  { "8649955.com", true },
  { "8649966.com", true },
  { "8649977.com", true },
  { "8722.am", true },
  { "8722am.com", true },
  { "8722cn.com", true },
  { "8722hk.com", true },
  { "8722ph.com", true },
  { "8722tw.com", true },
  { "8722usa.com", true },
  { "88-line.com", true },
  { "88-line.net", true },
  { "881-line.com", true },
  { "881-line.net", true },
  { "8818k3.com", true },
  { "8833445.com", true },
  { "88522am.com", true },
  { "887.ag", true },
  { "8876007.com", true },
  { "8876008.com", true },
  { "8876009.com", true },
  { "8876138.com", true },
  { "8876205.com", true },
  { "8876278.com", true },
  { "8876289.com", true },
  { "8876290.com", true },
  { "8876353.com", true },
  { "8876389.com", true },
  { "8876520.com", true },
  { "8876578.com", true },
  { "8876598.com", true },
  { "8876655.com", true },
  { "8876660.com", true },
  { "8876687.com", true },
  { "8876764.com", true },
  { "8876770.com", true },
  { "8876775.com", true },
  { "8876776.com", true },
  { "8876779.com", true },
  { "8876808.com", true },
  { "8876818.com", true },
  { "8876822.com", true },
  { "8876832.com", true },
  { "8876835.com", true },
  { "8876838.com", true },
  { "8876858.com", true },
  { "8876859.com", true },
  { "8876866.com", true },
  { "8876878.com", true },
  { "8876879.com", true },
  { "8876881.com", true },
  { "8876882.com", true },
  { "8876883.com", true },
  { "8876898.com", true },
  { "8876900.com", true },
  { "8876955.com", true },
  { "8876979.com", true },
  { "8876987.com", true },
  { "8876989.com", true },
  { "8876991.com", true },
  { "8876992.com", true },
  { "8876996.com", true },
  { "8880013.com", true },
  { "8880021.com", true },
  { "8880023.com", true },
  { "8880025.com", true },
  { "8880057.com", true },
  { "8880059.com", true },
  { "8880067.com", true },
  { "8880083.com", true },
  { "8880100.com", true },
  { "8884553.com", true },
  { "8886737.com", true },
  { "8886739.com", true },
  { "8886793.com", true },
  { "8886806.com", true },
  { "8886860.com", true },
  { "888888722.com", true },
  { "88889822.com", true },
  { "8888yh.com", true },
  { "8889457.com", true },
  { "8889458.com", true },
  { "8889466.com", true },
  { "8889563.com", true },
  { "8889709.com", true },
  { "8889729.com", true },
  { "8889792.com", true },
  { "8889807.com", true },
  { "8889809.com", true },
  { "8889819.com", true },
  { "8889870.com", true },
  { "8889881.com", true },
  { "8889890.com", true },
  { "8889893.com", true },
  { "8889903.com", true },
  { "8889910.com", true },
  { "888bwf.com", true },
  { "888funcity.com", true },
  { "888funcity.net", true },
  { "88bwf.com", true },
  { "88yule11.com", true },
  { "88yule112.com", true },
  { "88yule113.com", true },
  { "88yule12.com", true },
  { "88yule13.com", true },
  { "88yule15.com", true },
  { "88yule16.com", true },
  { "88yule6.com", true },
  { "88yule7.com", true },
  { "88yule9.com", true },
  { "8ack.de", true },
  { "8ackprotect.com", true },
  { "8da188.com", true },
  { "8da222.com", true },
  { "8da88.com", true },
  { "8da999.com", true },
  { "8dabet.com", true },
  { "8hrs.net", true },
  { "8maerz.at", true },
  { "8t8.eu", true },
  { "8tech.com.hk", true },
  { "8thportsmouth.org.uk", true },
  { "8tuffbeers.com", true },
  { "8xxbet.net", true },
  { "8y.network", true },
  { "9-11commission.gov", true },
  { "903422.com", true },
  { "905422.com", true },
  { "90r.jp", true },
  { "910kj.com", true },
  { "9118.com", true },
  { "911commission.gov", true },
  { "912422.com", true },
  { "913422.com", true },
  { "914122.com", true },
  { "918116.com", true },
  { "918gd.com", true },
  { "918yy.com", true },
  { "919422.com", true },
  { "91966.com", true },
  { "91tianmi.com", false },
  { "91travel.info", true },
  { "924122.com", true },
  { "924322.com", true },
  { "924622.com", true },
  { "926422.com", true },
  { "92url.com", true },
  { "931422.com", true },
  { "932422.com", true },
  { "934122.com", true },
  { "943022.com", true },
  { "9449-27a1-22a1-e0d9-4237-dd99-e75e-ac85-2f47-9d34.de", true },
  { "946022.com", true },
  { "946422.com", true },
  { "949022.com", true },
  { "949122.com", true },
  { "949622.com", true },
  { "949722.com", true },
  { "94cs.cn", false },
  { "9679693.com", true },
  { "9681909.com", true },
  { "972422.com", true },
  { "9788876.com", true },
  { "97bros.com", true },
  { "9822.am", true },
  { "9822.bz", true },
  { "9822am.com", true },
  { "9822cn.com", true },
  { "9822hk.com", true },
  { "9822ph.com", true },
  { "9822tw.com", true },
  { "9822usa.com", true },
  { "98laba.com", true },
  { "98laba.net", true },
  { "9918883.com", true },
  { "9933445.com", true },
  { "99599.fi", true },
  { "9994553.com", true },
  { "9998722.com", true },
  { "99998522.com", true },
  { "99999822.com", true },
  { "999998722.com", true },
  { "99rst.org", true },
  { "99wxt.com", true },
  { "9farm.com", true },
  { "9fvip.net", true },
  { "9jajuice.com", true },
  { "9pkfz.com", true },
  { "9riddles.com", true },
  { "9tolife.be", true },
  { "9uelle.jp", true },
  { "9vx.org", true },
  { "9yw.me", true },
  { "a-1basements.com", true },
  { "a-1indianawaterproofing.com", true },
  { "a-allard.be", true },
  { "a-classinflatables.co.uk", true },
  { "a-invest.de", true },
  { "a-little-linux-box.at", true },
  { "a-msystems.com", true },
  { "a-oben.org", true },
  { "a-wife.net", true },
  { "a-ztransmission.com", true },
  { "a0print.nl", true },
  { "a1bouncycastlehire.com", true },
  { "a1jumpandbounce.co.uk", true },
  { "a1moldsolutions.com", true },
  { "a1scuba.com", true },
  { "a1scubastore.com", true },
  { "a2a.me", true },
  { "a2a.net", true },
  { "a2nutrition.com.au", true },
  { "a2os.club", true },
  { "a4sound.com", true },
  { "a632079.me", true },
  { "a7la-chat.com", true },
  { "aa-tour.ru", true },
  { "aa1718.net", true },
  { "aaapl.com", true },
  { "aabanet.com.br", true },
  { "aaben-bank.dk", true },
  { "aabenbank.dk", true },
  { "aacfree.com", true },
  { "aaex.cloud", true },
  { "aagetransport.no", true },
  { "aalalbayt.com", true },
  { "aalalbayt.net", true },
  { "aalstmotors-usedcars.be", true },
  { "aaltocapital.com", true },
  { "aamwa.com", true },
  { "aandeautobody.com", true },
  { "aandkevents.co.uk", true },
  { "aanmpc.com", true },
  { "aaomidi.com", true },
  { "aapar.nl", true },
  { "aapas.org.ar", true },
  { "aarklendoia.com", true },
  { "aarkue.eu", true },
  { "aaron.cm", true },
  { "aaron.xin", true },
  { "aaronhorler.com", true },
  { "aaronhorler.com.au", true },
  { "aaronkimmig.de", true },
  { "aaronroyle.com", true },
  { "aaronsilber.me", true },
  { "aatf.us", true },
  { "aati.be", true },
  { "aati.info", true },
  { "aavienna.com", true },
  { "abaapplianceservice.com", true },
  { "abaaustin.com", true },
  { "ababyco.com.hr", true },
  { "abacusbouncycastle.co.uk", true },
  { "abacustech.co.jp", true },
  { "abandonedmines.gov", true },
  { "abateroad66.it", true },
  { "abbadabbabouncycastles.co.uk", true },
  { "abbas.ch", true },
  { "abborsjo.fi", true },
  { "abbotsparties.co.uk", true },
  { "abbottscastles.co.uk", true },
  { "abbradar.net", true },
  { "abbruch-star.de", true },
  { "abc-rz.de", true },
  { "abc.li", true },
  { "abc8081.net", true },
  { "abcbouncycastlessurrey.co.uk", true },
  { "abcbouncyfactory.co.uk", true },
  { "abcdef.be", true },
  { "abcheck.se", true },
  { "abckam.com", true },
  { "abcpartyhire.com", true },
  { "abcstudio.com.au", true },
  { "abdel.me", true },
  { "abdelsater.net", true },
  { "abdullah.pw", true },
  { "abdulwahaab.ca", true },
  { "abe-elektro.de", true },
  { "abe-medical.jp", true },
  { "abeestrada.com", false },
  { "abeilles-idapi.fr", true },
  { "abenteuer-ahnenforschung.de", true },
  { "abeontech.com", true },
  { "aberdeencastles.co.uk", true },
  { "aberdeenjudo.co.uk", true },
  { "abeus.com", true },
  { "abhisharma.me", true },
  { "abi-2017.tk", true },
  { "abiapp.net", true },
  { "abibruce.co.uk", true },
  { "abidinginhesed.com", true },
  { "abigisp.com", true },
  { "abilitycaresoftware.com", true },
  { "abilitynet.org.uk", true },
  { "abilityone.gov", true },
  { "abilma.com", true },
  { "abilymp06.net", true },
  { "abimelec.com", true },
  { "abinferis.com", true },
  { "abinyah.com", true },
  { "abitidalavoro.roma.it", true },
  { "abitur97ag.de", true },
  { "abiturma.de", true },
  { "ablak-nyilaszaro.info", true },
  { "ableprop.net", true },
  { "abmc.gov", true },
  { "abmledger.ca", true },
  { "abmtax.ca", true },
  { "abn-consultants.ie", true },
  { "abnehmen.com", true },
  { "abobuch.de", true },
  { "aboces.org", true },
  { "aboderenovation.co.uk", true },
  { "abolicionistas.com", true },
  { "abolition.net", true },
  { "abolitionism.ca", true },
  { "abolitionism.co.uk", true },
  { "abolitionism.com", true },
  { "abolitionism.in", true },
  { "abolitionism.net", true },
  { "abolitionism.us", true },
  { "abolitionist-project.com", true },
  { "abolitionist-society.com", true },
  { "abolitionist.ca", true },
  { "abolitionist.co.uk", true },
  { "abolitionist.com", true },
  { "abolitionist.in", true },
  { "abolitionist.net", true },
  { "abolitionist.us", true },
  { "abolitionistparty.com", true },
  { "abolitionistproject.com", true },
  { "abolitionistsociety.com", true },
  { "abolitionniste.com", true },
  { "abolizionista.com", true },
  { "abonilla.com", true },
  { "abos.eu", true },
  { "abouncycastleman.co.uk", true },
  { "abouthrm.nl", true },
  { "aboutict.nl", true },
  { "aboutlegal.nl", true },
  { "aboutmedia.nl", true },
  { "aboutmyproperty.ca", true },
  { "aboutspice.com", true },
  { "aboutyou.at", true },
  { "aboutyou.be", true },
  { "aboutyou.ch", true },
  { "aboutyou.de", true },
  { "aboutyou.nl", true },
  { "aboveaverageplumbing.com", true },
  { "abox-kb.com", true },
  { "abpis.hr", true },
  { "abracadabra.co.jp", false },
  { "abrakidabra.com.br", true },
  { "abrilect.com", true },
  { "abristolgeek.co.uk", true },
  { "abseits.org", true },
  { "absolem.cc", true },
  { "absolutcruceros.com", true },
  { "absoluteautobody.com", true },
  { "absolutedouble.co.uk", true },
  { "absolutehaitian.com", true },
  { "absolutehosting.co.za", true },
  { "absolutelyinflatables.co.uk", true },
  { "absoluterush.net", true },
  { "absolutewebdesigns.com", true },
  { "absolutviajes.com", true },
  { "abstractbarista.net", true },
  { "abstraction21.com", true },
  { "absturztau.be", true },
  { "absturztaube.ch", true },
  { "absynthe-inquisition.fr", true },
  { "abthorpe.org", true },
  { "abublog.com", true },
  { "abulanov.com", true },
  { "abundanteconomy.com", true },
  { "abundent.com", true },
  { "abuse.fi", true },
  { "abuse.io", true },
  { "abvent.net", true },
  { "abvlbasketviganello.ch", true },
  { "abyssproject.net", true },
  { "ac-admin.pl", true },
  { "ac-epmservices.com", true },
  { "ac-town.com", true },
  { "ac0g.dyndns.org", true },
  { "aca-creative.co.uk", true },
  { "academiadebomberosonline.com", true },
  { "academicexperts.us", true },
  { "academichealthscience.net", true },
  { "academie-de-police.ch", true },
  { "academkin.com", true },
  { "academytv.com.au", true },
  { "acaeum.com", true },
  { "acampar.com.br", true },
  { "acaptureservices.com", true },
  { "acara-yoga.de", true },
  { "acareer.in", true },
  { "acat.io", true },
  { "acbrussels-used.be", true },
  { "accelaway.com", true },
  { "acceleratenetworks.com", true },
  { "accelerateyourworld.org", true },
  { "accelerator.net", true },
  { "accentthailand.com", true },
  { "accesloges.com", true },
  { "accessacab.co.uk", true },
  { "accessauto-occasions.be", true },
  { "accessibility.gov", true },
  { "accesskeycloning.com", true },
  { "accessmy.net", true },
  { "accessoirescheveuxchic.com", true },
  { "accessoripersmartphone.it", true },
  { "accme.co", true },
  { "accoladescreens.com.au", true },
  { "accord-application.com", true },
  { "accordiondoor.com", true },
  { "accounts.firefox.com", true },
  { "accounts.google.com", true },
  { "accpl.co", true },
  { "accpodcast.com", true },
  { "accredit.ly", true },
  { "accudraftpaintbooths.com", true },
  { "accurateautobodywa.com", true },
  { "accuritconsulting.com", true },
  { "accuritpresence.com", true },
  { "accutint.com", true },
  { "ace.media", true },
  { "ace.one", true },
  { "acealters.com", true },
  { "aceanswering.com", true },
  { "acecerts.co.uk", true },
  { "acecolleges.edu.au", true },
  { "acedog.co", true },
  { "aceinflatables.com", true },
  { "aceinstituteonline.com", true },
  { "acem.org.au", true },
  { "acemobileforce.com", true },
  { "acen.eu", true },
  { "acendealuz.com.br", true },
  { "acerentalandsales.com", true },
  { "acerislaw.com", true },
  { "acessoeducacao.com", true },
  { "acevik.de", true },
  { "acfo.org", true },
  { "acg.social", true },
  { "acgtalktw.com", true },
  { "achalay.org", true },
  { "acheconcursos.com.br", true },
  { "achenar.net", true },
  { "acheter-ethylotest.fr", true },
  { "achromatisch.de", true },
  { "achterblog.de", true },
  { "achterstieg.dedyn.io", true },
  { "achtzehn.eu", true },
  { "achtzehnterachter.de", true },
  { "achtzig20.de", true },
  { "achwo.de", true },
  { "acid.ninja", true },
  { "acidbin.co", true },
  { "aciety.com", true },
  { "aciksite.com", true },
  { "ackermann.ch", true },
  { "ackis.duckdns.org", false },
  { "acklandstainless.com.au", true },
  { "acl.gov", true },
  { "aclu.org", false },
  { "acluva.org", false },
  { "acme.beer", true },
  { "acmexyz123.info", true },
  { "acnpacific.com", true },
  { "acodess.com", true },
  { "aconnor.xyz", true },
  { "acordes.online", true },
  { "acorncastles.co.uk", true },
  { "acorntreecare.com", true },
  { "acoshift.com", true },
  { "acoshift.me", true },
  { "acourse.io", true },
  { "acousti-tech.com", true },
  { "acousticalsolutions.com", true },
  { "acoustics.network", true },
  { "acoustics.tech", true },
  { "acoustique-tardy.com", true },
  { "acpcoils.com", true },
  { "acperu.ch", true },
  { "acquisition.gov", true },
  { "acquistareviagragenericoitalia.net", true },
  { "acrealux.lu", true },
  { "acrepairgeorgetown.com", true },
  { "acrepairhutto.com", true },
  { "acrepairroundrocktx.com", true },
  { "acrevalue.com", true },
  { "acriticismlab.org", true },
  { "acrolife.cz", true },
  { "acroso.me", true },
  { "acrosstheblvd.com", true },
  { "acroyoga-nuernberg.de", true },
  { "acrylbilder-acrylmalerei.de", true },
  { "acrylicwifi.com", true },
  { "acs-chantal.com", true },
  { "acsbbs.org", true },
  { "acsc.gov.au", true },
  { "acscbasket.com", true },
  { "acsemb.org", true },
  { "acsports.ca", true },
  { "actc.org.uk", true },
  { "actgruppe.de", true },
  { "actheater.com", true },
  { "actiefgeld.nl", true },
  { "actioncleaningnd.com", true },
  { "actionfinancialservices.net", true },
  { "actionlabs.net", true },
  { "actionmadagascar.ch", true },
  { "actionsack.com", true },
  { "actionselling.com", true },
  { "activatemyiphone.com", true },
  { "activateudid.com", true },
  { "active-tluszcz.pl", true },
  { "active.hu", false },
  { "activecare-monitor.com", true },
  { "activeexcavator.com", true },
  { "activehire.co.uk", true },
  { "activeleisure.ie", true },
  { "activeworld.net", false },
  { "activiteithardenberg.nl", true },
  { "activitesaintnicaise.org", true },
  { "activityeventhire.co.uk", true },
  { "actom.cc", true },
  { "actonwoodworks.com", true },
  { "actors-cafe.net", true },
  { "actorsroom.com", true },
  { "actserv.co.ke", true },
  { "actualadmins.com", true },
  { "actualidadblog.com", true },
  { "actualidadecommerce.com", true },
  { "actualidadgadget.com", true },
  { "actualidadiphone.com", true },
  { "actualidadkd.com", true },
  { "actualidadliteratura.com", true },
  { "actualidadmotor.com", true },
  { "actualidadviajes.com", true },
  { "actuatemedia.com", true },
  { "acuica.co.uk", false },
  { "acul.me", true },
  { "acupofsalt.tv", true },
  { "acus.gov", true },
  { "acwcerts.co.uk", true },
  { "acwi.gov", true },
  { "acy.com", true },
  { "acyfxasia.com", true },
  { "ad-notam.asia", true },
  { "ad-notam.ch", true },
  { "ad-notam.co.uk", true },
  { "ad-notam.com", true },
  { "ad-notam.de", true },
  { "ad-notam.fr", true },
  { "ad-notam.it", true },
  { "ad-notam.pt", true },
  { "ad-notam.us", true },
  { "ada.gov", true },
  { "adaera.com", true },
  { "adalis.org", true },
  { "adam-ant.co.uk", true },
  { "adam-kostecki.de", true },
  { "adam-wilson.me", true },
  { "adam.lgbt", true },
  { "adamas-magicus.ru", true },
  { "adambalogh.net", true },
  { "adambyers.com", true },
  { "adamek.online", true },
  { "adamfontenot.com", true },
  { "adamh.us", true },
  { "adamjoycegames.co.uk", true },
  { "adamkaminski.com", true },
  { "adamkostecki.de", true },
  { "adamoutler.com", true },
  { "adamradocz.com", true },
  { "adams.dk", true },
  { "adamsbouncycastles.co.uk", true },
  { "adamstas.com", true },
  { "adamwallington.co.uk", true },
  { "adamwilcox.org", true },
  { "adamyuan.xyz", true },
  { "adapt-elektronik.com", true },
  { "adapt.de", true },
  { "adaptablesecurity.org", true },
  { "adapti.de", true },
  { "adaptivemechanics.edu.au", true },
  { "adarshthapa.in", true },
  { "adawolfa.cz", true },
  { "adayinthelifeof.nl", true },
  { "adblockextreme.com", true },
  { "adblockextreme.net", true },
  { "adblockextreme.org", true },
  { "addeekt.com", true },
  { "adderall.space", true },
  { "addicional.com", true },
  { "addictionresource.com", true },
  { "addictively.com", true },
  { "addiko.net", true },
  { "addisoncrump.info", true },
  { "addnine.com", true },
  { "addon.watch", true },
  { "addones.net", true },
  { "addtoany.com", true },
  { "adduono.com", true },
  { "addvalue-renovations.co.uk", true },
  { "addydari.us", true },
  { "adelebeals.com", true },
  { "adelightfulglow.com", true },
  { "adeline.mobi", true },
  { "adentalsolution.com", true },
  { "adept.org.pl", true },
  { "adesa.co.uk", true },
  { "adevel.eu", true },
  { "adex.network", true },
  { "adf-safetytools.com", true },
  { "adftrasporti.it", true },
  { "adhd-inattentive.com", true },
  { "adhesivelaundry.co.uk", true },
  { "adhoc.is", true },
  { "adimaja.com", true },
  { "adinariversloveschool.com", true },
  { "adingenierie.fr", true },
  { "adiponectinsupplement.info", true },
  { "adiponectinsupplement.net", true },
  { "adjagu.org", true },
  { "adlerneves.com", true },
  { "adlerneves.com.br", true },
  { "adlerosn.com", true },
  { "adlerosn.com.br", true },
  { "adlershop.ch", true },
  { "adlignum.se", true },
  { "adm-sarov.ru", true },
  { "adme.co.il", true },
  { "admin-serv.net", true },
  { "admin.casa", true },
  { "admin.fedoraproject.org", true },
  { "admin.google.com", true },
  { "admin.stg.fedoraproject.org", true },
  { "adminforge.de", true },
  { "administratorserwera.pl", true },
  { "adminlinux.pl", true },
  { "admino.cz", true },
  { "admins.tech", true },
  { "adminwerk.net", true },
  { "adminwiki.fr", true },
  { "admirable.one", true },
  { "admirable.pro", true },
  { "admody.com", true },
  { "admongo.gov", true },
  { "adnanoktar.com", true },
  { "adnanotoyedekparca.com", true },
  { "adnot.am", true },
  { "adnseguros.es", true },
  { "adonizer.science", true },
  { "adonnante.com", true },
  { "adoptionlink.co.uk", true },
  { "adorai.tk", true },
  { "adorecricket.com", true },
  { "adorewe.com", true },
  { "adoriasoft.com", false },
  { "adorno-gymnasium.de", true },
  { "adoucisseur.shop", true },
  { "adquisitio.co.uk", true },
  { "adquisitio.es", true },
  { "adquisitio.fr", true },
  { "adquisitio.it", true },
  { "adr.gov", true },
  { "adra.com", true },
  { "adrafinil.wiki", true },
  { "adrianbechtold.de", true },
  { "adriancitu.com", true },
  { "adriancostin.ro", true },
  { "adrianjensen.com", true },
  { "adrianmejias.com", true },
  { "adrienkohlbecker.com", true },
  { "adriennesmiles.com", true },
  { "adrup.com", true },
  { "adsamcik.com", true },
  { "adsbouncycastles.co.uk", true },
  { "adsbtc.org", true },
  { "adsl2meg.fr", true },
  { "adtgroup.com", true },
  { "adurra.com", true },
  { "aduvi.de", true },
  { "advance.hr", true },
  { "advanced-fleet-services.com", true },
  { "advanced-scribes.com", true },
  { "advanced.info", true },
  { "advanceddieselspokane.com", true },
  { "advanceddisposables.co.uk", true },
  { "advancedoneroofing.com", true },
  { "advancedprotectionkey.com", true },
  { "advancedprotectionsecuritykey.com", true },
  { "advancedsurgicalconsultantsllc.com", true },
  { "advancedweb.hu", true },
  { "advanceworx.com", true },
  { "advancis.net", true },
  { "advancyte.com", true },
  { "advantagehomeexteriors.com", true },
  { "advara.com", true },
  { "advenacs.com.au", true },
  { "advenapay.com", true },
  { "adventaholdings.com", true },
  { "advento.bg", true },
  { "adventure-inn.com", true },
  { "adventureally.com", true },
  { "adventureforest.co.nz", true },
  { "adventureforest.de", false },
  { "adventureforest.nz", true },
  { "adventuregamers.com", true },
  { "adventurenow.nl", true },
  { "adventures.de", true },
  { "adventureswithlillie.ca", true },
  { "adventurousway.com", true },
  { "advertis.biz", true },
  { "advicepro.org.uk", true },
  { "advocate-europe.eu", true },
  { "advocaten-avocats.be", true },
  { "advocatenalkmaar.org", true },
  { "advocator.ca", true },
  { "advocoeurdehaan.nl", true },
  { "advogatech.com.br", true },
  { "advokat-romanov.com", true },
  { "advtran.com", true },
  { "adware.pl", true },
  { "adwokatzdunek.pl", true },
  { "adws.io", true },
  { "adxperience.com", true },
  { "adzuna.at", true },
  { "adzuna.ca", true },
  { "adzuna.co.nz", true },
  { "adzuna.co.za", true },
  { "adzuna.com", true },
  { "adzuna.com.au", true },
  { "adzuna.com.br", true },
  { "adzuna.de", true },
  { "adzuna.fr", true },
  { "adzuna.in", true },
  { "adzuna.it", true },
  { "adzuna.nl", true },
  { "adzuna.pl", true },
  { "adzuna.ru", true },
  { "adzuna.sg", true },
  { "ae-construction.co.uk", true },
  { "aebian.org", true },
  { "aecexpert.fr", true },
  { "aedollon.com", true },
  { "aefcleaning.com", true },
  { "aegee-utrecht.nl", true },
  { "aegisalarm.co.uk", true },
  { "aegisalarm.com", true },
  { "aegisalarms.co.uk", true },
  { "aegisalarms.com", true },
  { "aegisinsight.com", true },
  { "aegrel.ee", true },
  { "aehe.us", true },
  { "aei.co.uk", true },
  { "aeon.co", true },
  { "aep-digital.com", true },
  { "aeradesign.com", true },
  { "aerandir.fr", true },
  { "aerapass.io", true },
  { "aereco.com", true },
  { "aergia.eu", true },
  { "aerisnetwork.com", true },
  { "aero-pioneer.com", true },
  { "aerobasegroup.com", true },
  { "aerobotz.com", true },
  { "aeronautix.com", true },
  { "aeropole.de", true },
  { "aeropole.eu", true },
  { "aerosimexperience.com", true },
  { "aerospace-schools.com", true },
  { "aerotechcoatings.com", true },
  { "aertel.ie", true },
  { "aessencia.com.br", true },
  { "aestheticdr.org", true },
  { "aesthetx.com", true },
  { "aestore.by", true },
  { "aeternus.tech", true },
  { "aetherc0r3.eu", true },
  { "aetoscg.com", true },
  { "aetoscg.com.au", true },
  { "aextron.com", true },
  { "aextron.de", true },
  { "aextron.org", true },
  { "aeyoun.com", true },
  { "afavre.io", true },
  { "afb24.de", true },
  { "afbeelding.im", true },
  { "afbeeldinguploaden.nl", true },
  { "afcmrs.org", true },
  { "afcompany.it", true },
  { "afcurgentcarelyndhurst.com", true },
  { "affichagepub3.com", true },
  { "affiliatefeatures.com", true },
  { "affiliateroyale.com", true },
  { "affiliatetest.azurewebsites.net", true },
  { "affilie.de", true },
  { "affinitysync.com", true },
  { "affissioni.roma.it", true },
  { "affittacamere.roma.it", true },
  { "affittialmare.it", true },
  { "affittisalento.it", true },
  { "affloc.com", true },
  { "affordableazdivorce.com", true },
  { "affordableblindsexpress.com", true },
  { "affordableenergyadvocates.com", true },
  { "affordableenvironmental.net", true },
  { "affordablehealthquotesforyou.com", true },
  { "affordablekilimanjaro.com", true },
  { "affordablemudjacking.com", true },
  { "affordableracingparts.com.au", true },
  { "affping.com", true },
  { "affvps.net", true },
  { "afghan.dating", true },
  { "afi-business-consulting.com", true },
  { "aficionados.com.br", true },
  { "afinadoronline.com.br", true },
  { "afinaudio.com", true },
  { "aflfreebets.com", true },
  { "aflowershop.ca", true },
  { "afmt.fr", true },
  { "afmtevents.com", true },
  { "afonso.io", true },
  { "afp548.com", true },
  { "afri.cc", true },
  { "africa.dating", true },
  { "africanexponent.com", true },
  { "africanimpact.com", true },
  { "africantourer.com", true },
  { "africatravel.de", true },
  { "afrikarl.de", true },
  { "afrodigital.uk", true },
  { "afs-asso.org", true },
  { "afscheidsportret.nl", true },
  { "aftab-alam.de", true },
  { "after.digital", true },
  { "afterhate.fr", true },
  { "afuh.de", true },
  { "afva.net", true },
  { "afwd.international", true },
  { "ag-websolutions.de", true },
  { "ag8-game.com", true },
  { "agalliasis.ch", true },
  { "agamsecurity.ch", true },
  { "agatajanik.de", true },
  { "agate.pw", true },
  { "age.hk", true },
  { "agechecker.net", true },
  { "ageg.ca", true },
  { "agemfis.com", true },
  { "agencewebstreet.com", true },
  { "agenciadeempregosdourados.com.br", true },
  { "agenciafiscal.pe", true },
  { "agencyinmotion.com", true },
  { "agenda-loto.net", false },
  { "agenda21senden.de", true },
  { "agendatelefonica.com.br", true },
  { "agent-grow.com", true },
  { "agent6.com.au", true },
  { "agentprocessing.com", true },
  { "agenziaimmobiliarezeta.it", true },
  { "agfmedia.com", true },
  { "agglo-sion.ch", true },
  { "aggr.pw", true },
  { "agia.ad", true },
  { "agiapelagia.com", true },
  { "agic-geneve.ch", true },
  { "agic.io", true },
  { "agilebits.com", true },
  { "agilecraft.com", true },
  { "agileui.com", true },
  { "agiley.se", true },
  { "agilizing.us", true },
  { "agilob.net", true },
  { "aging.gov", true },
  { "agingstats.gov", true },
  { "aginion.net", true },
  { "agiserv.fr", true },
  { "agliamici.it", true },
  { "agnesk.blog", true },
  { "agoodmind.com", true },
  { "agoravox.fr", true },
  { "agoravox.it", true },
  { "agoravox.tv", true },
  { "agostinhoenascimento.com.br", true },
  { "agotnes.com", true },
  { "agouraelectrical.com", true },
  { "agouraelectrician.com", true },
  { "agouraexteriorlighting.com", true },
  { "agourahillselectric.com", true },
  { "agourahillselectrical.com", true },
  { "agourahillselectrician.com", true },
  { "agourahillsexteriorlighting.com", true },
  { "agourahillslandscapelighting.com", true },
  { "agourahillslighting.com", true },
  { "agourahillsoutdoorlighting.com", true },
  { "agouralandscapelighting.com", true },
  { "agouralighting.com", true },
  { "agouraoutdoorlighting.com", true },
  { "agr.asia", true },
  { "agracan.com", true },
  { "agrajag.nl", true },
  { "agrarking.com", true },
  { "agrarking.de", true },
  { "agrarshop4u.de", true },
  { "agrekov.ru", true },
  { "agreor.com", true },
  { "agrichamber.com.ua", true },
  { "agricolo.ch", true },
  { "agriculture-schools.com", true },
  { "agridir.site", true },
  { "agrilinks.org", true },
  { "agrios.de", true },
  { "agro-forestry.net", true },
  { "agroline.by", true },
  { "agroxxi.ru", false },
  { "agroyard.com.ua", true },
  { "agsb.ch", true },
  { "agscinemas.com", true },
  { "agscinemasapp.com", true },
  { "agung-furniture.com", true },
  { "agwa.name", true },
  { "agy.cl", true },
  { "ahawkesrealtors.com", true },
  { "ahd.com", false },
  { "ahegao.ca", true },
  { "aheng.me", true },
  { "ahero4all.org", true },
  { "ahkubiak.ovh", true },
  { "ahlaejaba.com", true },
  { "ahlz.sk", true },
  { "ahmad.works", true },
  { "ahmadly.com", true },
  { "ahmedabadflowermall.com", true },
  { "ahmedcharles.com", true },
  { "ahmerjamilkhan.org", true },
  { "ahmetozer.org", true },
  { "ahosi.com", true },
  { "ahoy.travel", true },
  { "ahoyconference.com", true },
  { "ahtuxpk.ru", true },
  { "ahughes03.com", true },
  { "ahxxm.com", true },
  { "ai-english.jp", true },
  { "ai-soft.co.jp", true },
  { "ai.gov", true },
  { "ai.je", true },
  { "aia.de", true },
  { "aiasesoriainmobiliaria.com", true },
  { "aibenzi.com", true },
  { "aibiying.com", true },
  { "aicial.co.uk", true },
  { "aidanapple.com", true },
  { "aidanmitchell.co.uk", true },
  { "aidanmitchell.uk", true },
  { "aidanmontare.net", true },
  { "aidanpr.com", true },
  { "aidanpr.net", true },
  { "aiden.link", true },
  { "aidhan.net", true },
  { "aidi-ahmi.com", true },
  { "aids.gov", true },
  { "aie.de", true },
  { "aiforsocialmedia.com", true },
  { "aifriccampbell.com", true },
  { "aigcev.org", true },
  { "aigenpul.se", true },
  { "aignermunich.com", true },
  { "aignermunich.de", true },
  { "aignermunich.jp", true },
  { "aiheisi.com", true },
  { "aiho.stream", true },
  { "aiicy.org", true },
  { "aiida.se", true },
  { "aijsk.com", true },
  { "aikenpromotions.com", true },
  { "aiki.de", true },
  { "aiki.do", true },
  { "aiki.tk", true },
  { "aikido-club-limburg.de", true },
  { "aikido-kiel.de", true },
  { "aikido-linz.at", true },
  { "aikido-wels.at", true },
  { "ailitonia.com", true },
  { "ailitonia.xyz", true },
  { "aimax.com", true },
  { "aimeeandalec.com", true },
  { "aimerworld.com", true },
  { "aimgroup.co.tz", true },
  { "aimi-salon.com", true },
  { "aimotive.com", true },
  { "aimstoreglobal.com", true },
  { "aintevenmad.ch", true },
  { "ainutrition.co.uk", true },
  { "ainvest.de", true },
  { "aiois.com", true },
  { "aipbarcelona.com", true },
  { "air-craftglass.com", true },
  { "air-shots.ch", true },
  { "air-techniques.fr", true },
  { "air-we-go.co.uk", true },
  { "airbnb.ae", true },
  { "airbnb.at", true },
  { "airbnb.be", true },
  { "airbnb.biz", true },
  { "airbnb.ca", true },
  { "airbnb.cat", true },
  { "airbnb.ch", true },
  { "airbnb.cl", true },
  { "airbnb.cn", true },
  { "airbnb.co.cr", true },
  { "airbnb.co.id", true },
  { "airbnb.co.il", true },
  { "airbnb.co.in", true },
  { "airbnb.co.kr", true },
  { "airbnb.co.nz", true },
  { "airbnb.co.uk", true },
  { "airbnb.co.ve", true },
  { "airbnb.com", true },
  { "airbnb.com.ar", true },
  { "airbnb.com.au", true },
  { "airbnb.com.bo", true },
  { "airbnb.com.br", true },
  { "airbnb.com.bz", true },
  { "airbnb.com.cn", true },
  { "airbnb.com.co", true },
  { "airbnb.com.ec", true },
  { "airbnb.com.gt", true },
  { "airbnb.com.hk", true },
  { "airbnb.com.hn", true },
  { "airbnb.com.hr", true },
  { "airbnb.com.kh", true },
  { "airbnb.com.mt", true },
  { "airbnb.com.my", true },
  { "airbnb.com.ni", true },
  { "airbnb.com.pa", true },
  { "airbnb.com.pe", true },
  { "airbnb.com.ph", true },
  { "airbnb.com.py", true },
  { "airbnb.com.sg", true },
  { "airbnb.com.sv", true },
  { "airbnb.com.tr", true },
  { "airbnb.com.tw", true },
  { "airbnb.com.ua", true },
  { "airbnb.com.vn", true },
  { "airbnb.cz", true },
  { "airbnb.de", true },
  { "airbnb.dk", true },
  { "airbnb.es", true },
  { "airbnb.fi", true },
  { "airbnb.fr", true },
  { "airbnb.gr", true },
  { "airbnb.gy", true },
  { "airbnb.hu", true },
  { "airbnb.ie", true },
  { "airbnb.is", true },
  { "airbnb.it", true },
  { "airbnb.jp", true },
  { "airbnb.la", true },
  { "airbnb.lu", true },
  { "airbnb.mx", true },
  { "airbnb.nl", true },
  { "airbnb.no", true },
  { "airbnb.pl", true },
  { "airbnb.pt", true },
  { "airbnb.ru", true },
  { "airbnb.se", true },
  { "airbnb.tools", true },
  { "airbnbchina.cn", true },
  { "airbnbopen.com", true },
  { "airborne-inflatables.co.uk", true },
  { "airbossofamerica.com", true },
  { "airclass.com", true },
  { "aircomms.com", true },
  { "airductclean.com", false },
  { "airductcleaning-fresno.com", true },
  { "airductcleaninggrandprairie.com", true },
  { "airductcleaningirving.com", true },
  { "airdur.eu", true },
  { "aireaseleaks.org", true },
  { "airetvie.com", true },
  { "airhart.me", true },
  { "airhelp.com", true },
  { "airhorn.de", true },
  { "airi-tabei.com", true },
  { "airicy.com", true },
  { "airikai.com", true },
  { "airlibre-parachutisme.com", true },
  { "airmail.cc", true },
  { "airmaxinflatables.com", true },
  { "airnow.gov", true },
  { "airpbx.com", true },
  { "airplay-inflatable-hire.co.uk", true },
  { "airplayradio.nl", true },
  { "airpurifierproductsonline.com", true },
  { "airrestoration.ch", true },
  { "airsnore.com", true },
  { "airsoft.ch", true },
  { "airswap.io", true },
  { "airtimerewards.co.uk", true },
  { "airtoolaccessoryo.com", true },
  { "airvpn.org", true },
  { "airvuz.com", true },
  { "airware.com", true },
  { "airwaystorage.net", true },
  { "airweb.top", true },
  { "airwegobouncycastles.co.uk", true },
  { "airwolfthemes.com", true },
  { "airwrenchei.com", true },
  { "ais.fashion", true },
  { "aisance-co.com", true },
  { "aisi316l.net", true },
  { "aisr.nl", true },
  { "aistockcharts.com", true },
  { "aistrope.com", true },
  { "ait.com.ar", true },
  { "aiticon.com", true },
  { "aitosoftware.com", true },
  { "aiutodomestico.ch", true },
  { "aivd.lol", true },
  { "aiwdirect.com", true },
  { "aixvox.com", false },
  { "aizxxs.com", true },
  { "ajapaik.ee", true },
  { "ajarope.com", true },
  { "ajaxed.net", true },
  { "ajbouncycastles.co.uk", true },
  { "ajces.com", true },
  { "ajdiaz.me", true },
  { "ajeventhire.co.uk", true },
  { "ajiaojr.info", true },
  { "ajiaojr.io", true },
  { "ajiaojr.me", true },
  { "ajiaojr.net", true },
  { "ajiboye.com", true },
  { "ajnasz.hu", true },
  { "ajsb85.com", true },
  { "ak-varazdin.hr", true },
  { "ak-webit.de", true },
  { "aka.ms", true },
  { "akachanikuji.com", true },
  { "akademeia.moe", true },
  { "akademie-frankfurt.de", true },
  { "akalashnikov.ru", true },
  { "akamon.ac.jp", true },
  { "akaoma.com", true },
  { "akasha.world", true },
  { "akazakov.info", true },
  { "akdusekbudil.cz", true },
  { "akelius.de", false },
  { "akfoundationindia.com", true },
  { "akhealthconnection.com", true },
  { "akhomesforyou.com", true },
  { "akihito.com", true },
  { "akijo.de", true },
  { "akilli-devre.com", true },
  { "akiym.com", true },
  { "akj.io", true },
  { "akkbouncycastles.co.uk", true },
  { "akostecki.de", true },
  { "akovana.com", true },
  { "akoww.de", false },
  { "akoya.fi", true },
  { "akplates.org", true },
  { "akpwebdesign.com", true },
  { "akr.io", true },
  { "akr.services", true },
  { "akronet.cz", false },
  { "akropol.cz", false },
  { "akropolis-ravensburg.de", true },
  { "aksehir.bel.tr", true },
  { "akselinurmio.fi", false },
  { "akshi.in", true },
  { "aktin.cz", true },
  { "aktin.sk", true },
  { "aktiv-naturheilmittel.at", true },
  { "aktiv-naturheilmittel.ch", true },
  { "aktiv-naturheilmittel.de", true },
  { "aktivace.eu", true },
  { "aktivierungscenter.de", true },
  { "akuislam.com", true },
  { "akukas.com", true },
  { "akustik.tech", true },
  { "akutun.cl", true },
  { "akvorrat.at", true },
  { "akyildiz.net", true },
  { "al3366.tech", true },
  { "al3xpro.com", true },
  { "alab.space", true },
  { "alabamadebtrelief.org", true },
  { "alaboard.com", true },
  { "aladdin.ie", true },
  { "aladdinschools.appspot.com", true },
  { "alainbaechlerphotography.ch", true },
  { "alainfrancois.eu", true },
  { "alainfrancois.nl", true },
  { "alainmargot.ch", true },
  { "alainodea.com", true },
  { "alainwolf.ch", true },
  { "alainwolf.net", true },
  { "alair.cn", false },
  { "alamancetv.com", true },
  { "alamgir.works", true },
  { "alanberger.me.uk", true },
  { "alanhua.ng", true },
  { "alaninkenya.org", true },
  { "alaricfavier.eu", false },
  { "alarmcomplete.co.uk", true },
  { "alarna.de", true },
  { "alasdelalma.com.co", true },
  { "alaskafishinglodges.net", true },
  { "alaskajewelry.com", true },
  { "alastairs-place.net", true },
  { "alaxyjewellers.co.za", true },
  { "alb-flirt.de", true },
  { "albanboye.info", true },
  { "albanesi.it", true },
  { "albbounce.co.uk", true },
  { "albersdruck.de", true },
  { "albertathome.org", true },
  { "albertbogdanowicz.pl", true },
  { "albertcuyp-markt.amsterdam", true },
  { "albertinum-goettingen.de", true },
  { "albinma.com", true },
  { "albion2.org", true },
  { "alboweb.nl", true },
  { "albrocar.com", true },
  { "alca31.com", true },
  { "alchimic.ch", true },
  { "alcnutrition.com", true },
  { "alco-united.com", true },
  { "alcoholapi.com", true },
  { "alcolecapital.com", true },
  { "aldiabcs.com", true },
  { "aldien.com.br", true },
  { "aldo-vandini.de", true },
  { "aldomedia.com", true },
  { "aldorr.net", false },
  { "aldous-huxley.com", true },
  { "alecpap.com", true },
  { "alecpapierniak.com", true },
  { "alecrust.com", true },
  { "alek.in", true },
  { "aleksejjocic.tk", true },
  { "aleksib.fi", true },
  { "alerbon.net", true },
  { "alertboxx.com", true },
  { "alertonline.nl", true },
  { "alerts.sg", true },
  { "alertwire.com", true },
  { "alesia-formation.fr", true },
  { "alessandroonline.com.br", true },
  { "aletm.it", true },
  { "alex-ross.co.uk", true },
  { "alex97000.de", true },
  { "alexander-beck.eu", true },
  { "alexanderb.info", true },
  { "alexandermuetzel.de", true },
  { "alexanderneng.de", true },
  { "alexanderschimpf.de", true },
  { "alexanderzinn.com", true },
  { "alexandra-schulze.de", true },
  { "alexandrastorm.com", true },
  { "alexandrastylist.com", false },
  { "alexandre-blond.fr", true },
  { "alexandros.io", true },
  { "alexbaker.org", true },
  { "alexberts.ch", true },
  { "alexbogovich.com", true },
  { "alexbresnahan.com", true },
  { "alexcoman.com", true },
  { "alexdaniel.org", true },
  { "alexei.su", false },
  { "alexey-shamara.ru", true },
  { "alexeykopytko.com", true },
  { "alexgaynor.net", true },
  { "alexgebhard.com", true },
  { "alexhd.de", true },
  { "alexio.ml", true },
  { "alexisabarca.com", true },
  { "alexiskoustoulidis.com", true },
  { "alexkott.com", true },
  { "alexlouden.com", true },
  { "alexmerkel.com", true },
  { "alexmerkel.me", true },
  { "alexmerkel.xyz", true },
  { "alexmroberts.net", true },
  { "alexn.org", true },
  { "alexpavel.com", true },
  { "alexpotter.net", true },
  { "alexs.de", true },
  { "alexschroeder.ch", true },
  { "alexsergeyev.com", true },
  { "alexsexton.com", true },
  { "alexsinnott.me", true },
  { "alextaffe.com", true },
  { "alexthayne.co.uk", true },
  { "alextjam.es", true },
  { "alextsang.net", true },
  { "alexvdveen.nl", true },
  { "alexvetter.de", true },
  { "alexwardweb.com", true },
  { "alexwilliams.tech", true },
  { "alexyang.me", true },
  { "alfa-tech.su", true },
  { "alfaperfumes.com.br", true },
  { "alfred-figge.de", true },
  { "alftrain.com", true },
  { "algbee.com", true },
  { "algeriepart.com", true },
  { "alghanimcatering.com", true },
  { "algoaware.eu", true },
  { "algoentremanos.com", true },
  { "algofactory.de", true },
  { "algolia.com", true },
  { "algorithmofsuccess.com", true },
  { "algoritmus-uspechu.cz", true },
  { "aliacraft.net", true },
  { "aliantsoft.pl", true },
  { "aliaswp.com", true },
  { "alibangash.com", true },
  { "alibiloungelv.com", true },
  { "alice-noutore.com", true },
  { "alice.tw", true },
  { "alicemaywebdesign.com.au", true },
  { "alicestudio.it", true },
  { "alicetone.net", true },
  { "alieke.design", true },
  { "alienation.biz", true },
  { "alienflight.com", true },
  { "alienslab.net", true },
  { "alienstat.com", true },
  { "alienvision.com.br", true },
  { "alignrs.com", true },
  { "aliim.gdn", true },
  { "alijammusic.com", true },
  { "alikulov.me", true },
  { "alinasmusicstudio.com", true },
  { "alinbu.net", true },
  { "aliorange.com", true },
  { "alis-test.tk", true },
  { "alisonisrealestate.com", true },
  { "alisonlitchfield.com", true },
  { "alistairstowing.com", true },
  { "alix-board.de", true },
  { "alize-theatre.ch", true },
  { "aljaspod.com", true },
  { "aljaspod.hu", true },
  { "aljaspod.net", true },
  { "all-connect.net", false },
  { "all-fashion-schools.com", true },
  { "all-markup-news.com", true },
  { "all4hardware4u.de", true },
  { "allaboutfunuk.com", true },
  { "allaboutswing.co.uk", true },
  { "allaboutswing.com", true },
  { "allaboutthekink.org", true },
  { "allactioneventhire.co.uk", true },
  { "allamericanmuslim.com", true },
  { "allamericanprotection.net", true },
  { "allamericatrans.com", true },
  { "allangirvan.net", true },
  { "allarmi.roma.it", true },
  { "allbenjoy.de", true },
  { "allbounceandplay.co.uk", true },
  { "allbouncesurrey.co.uk", true },
  { "allbrandbrand.com", true },
  { "allbursaries.co.za", true },
  { "allbusiness.com", true },
  { "allcapa.org", true },
  { "allcarecorrectionalpharmacy.com", true },
  { "allcarepharmacy.com", true },
  { "allcleanservices.ca", true },
  { "allcloud.com", true },
  { "allcovered.nl", true },
  { "alldewall.de", true },
  { "alldigitalsolutions.com", true },
  { "alle.bg", true },
  { "allemoz.com", true },
  { "allemoz.fr", true },
  { "allenosgood.com", true },
  { "allenscaravans.co.uk", true },
  { "allensun.org", true },
  { "allesisonline.nl", true },
  { "alleskomtgoed.org", true },
  { "allesrocknroll.de", true },
  { "allforyou.at", true },
  { "allfreelancers.su", false },
  { "allfundsconnect.com", true },
  { "allgaragefloors.com", true },
  { "allgreenturf.com.au", true },
  { "alliance-psychiatry.com", true },
  { "alliances-globalsolutions.com", true },
  { "alliedfrozenstorage.com", true },
  { "alligatorge.de", true },
  { "allinagency.com", true },
  { "allincoin.shop", true },
  { "allinone-ranking150.com", true },
  { "allis.studio", true },
  { "allius.de", true },
  { "alljamin.com", true },
  { "allmebel.ru", true },
  { "allmend-ru.de", true },
  { "allns.fr", true },
  { "allo-credit.ch", true },
  { "allofthestops.com", true },
  { "allontanamentovolatili.it", true },
  { "allontanamentovolatili.milano.it", true },
  { "alloverthehill.com", true },
  { "alloydevil.nl", true },
  { "allplayer.tk", true },
  { "allpointsblog.com", true },
  { "allpointsheating.com", true },
  { "allproptonline.com", true },
  { "allroundpvp.net", true },
  { "allsaints.church", true },
  { "allsearch.io", true },
  { "allshousedesigns.com", true },
  { "allstakesupply.com.au", true },
  { "allstarautokiaparts.com", true },
  { "allstarcashforcars.com", true },
  { "allstarpartyinflatables.co.uk", true },
  { "allstarquilts.com", true },
  { "allsync.com", true },
  { "allsync.nl", true },
  { "allteach.co.uk", true },
  { "allterrainfence.com", true },
  { "allthecryptonews.com", true },
  { "allthethings.co.nz", true },
  { "allthings.me", true },
  { "allthingswild.co.uk", true },
  { "allurebikerental.com", true },
  { "allurescarves.com", true },
  { "alluvion.studio", true },
  { "allweatherlandscaping.net", true },
  { "almaatlantica.com", true },
  { "almavios.com", false },
  { "almayadeen.education", true },
  { "almorafestival.com", true },
  { "almut-zielonka.de", true },
  { "aloesoluciones.com.ar", true },
  { "alohapartyevents.co.uk", true },
  { "alonetone.com", true },
  { "alp.od.ua", true },
  { "alpca.org", true },
  { "alpencams.com", true },
  { "alpengreis.ch", true },
  { "alpenjuice.com", true },
  { "alpertron.com.ar", true },
  { "alpes-deis-tools.com", true },
  { "alpha-assistant.com", true },
  { "alpha-force.net", false },
  { "alpha.ch", true },
  { "alpha88uat.com", true },
  { "alphaantileak.net", true },
  { "alphabetsigns.com", true },
  { "alphabouncycastles.co.uk", true },
  { "alphabrock.cn", true },
  { "alphachat.net", true },
  { "alphadote.com", true },
  { "alphaetomega3d.fr", true },
  { "alphafiduciaryservices.ch", true },
  { "alphafitnesslibya.com", true },
  { "alphagateanddoor.com", true },
  { "alphainflatablehire.com", true },
  { "alphaman.ooo", true },
  { "alphapengu.in", true },
  { "alpharotary.com", true },
  { "alphasall.com", false },
  { "alphassl.de", true },
  { "alphatrash.de", true },
  { "alphavote-avex.com", true },
  { "alphavote.com", true },
  { "alphera.nl", true },
  { "alphie.me", true },
  { "alphipneux.fr", true },
  { "alpinechaletrental.com", true },
  { "alpinehighlandrealty.com", true },
  { "alpineplanet.com", true },
  { "alpinepubliclibrary.org", true },
  { "alpinestarmassage.com", true },
  { "alpinetrek.co.uk", true },
  { "alpiniste.fr", true },
  { "alqassam.net", true },
  { "alquiaga.com", true },
  { "alquiladoramexico.com", true },
  { "alroniks.com", true },
  { "als-japan.com", true },
  { "alstertouch.com", true },
  { "alstertouch.de", true },
  { "alstroemeria.org", true },
  { "alt-three.com", true },
  { "alt.org", true },
  { "altair.fi", true },
  { "altapina.com", false },
  { "altaplana.be", true },
  { "altedirect.com", true },
  { "alter-news.fr", true },
  { "alterbaum.net", true },
  { "alternador.com.br", true },
  { "alternative.bike", true },
  { "alternativebit.fr", true },
  { "alternativedev.ca", true },
  { "alternativeinternet.ca", true },
  { "alternativet.party", true },
  { "alterspalter.de", true },
  { "altes-sportamt.de", true },
  { "altesses.eu", true },
  { "altestore.com", true },
  { "altisdev.com", true },
  { "altkremsmuensterer.at", true },
  { "altmaestrat.es", true },
  { "altoa.cz", true },
  { "altopartners.com", true },
  { "altopia.com", true },
  { "altphotos.com", true },
  { "alts.li", true },
  { "altstipendiaten.de", true },
  { "alttrackr.com", true },
  { "altunbas.info", true },
  { "alumni-kusa.jp", true },
  { "alupferd.de", true },
  { "aluro.info", true },
  { "aluroof.eu", true },
  { "alvcs.com", true },
  { "alviano.com", true },
  { "alvicom.hu", true },
  { "alvosec.com", true },
  { "alwaysdry.com.au", true },
  { "alwayslookingyourbest.com", true },
  { "alwaysmine.fi", true },
  { "alwaysonssl.com", true },
  { "alxpresentes.com.br", true },
  { "alyoung.com", true },
  { "alza.at", true },
  { "alza.co.uk", true },
  { "alza.cz", true },
  { "alza.de", true },
  { "alza.hu", true },
  { "alza.sk", true },
  { "alzashop.com", true },
  { "alzonaprinting.com", true },
  { "am-dd.com", true },
  { "am-executive-consulting.com", true },
  { "am2s.fr", true },
  { "am3.se", true },
  { "ama.ne.jp", true },
  { "amadvice.com", true },
  { "amagdic.com", true },
  { "amagical.net", false },
  { "amaiz.com", true },
  { "amalfi5stars.com", true },
  { "amalficoastchauffeur.com", true },
  { "amalfilapiazzetta.it", true },
  { "amalfipositanoboatrental.com", true },
  { "amalfirock.it", true },
  { "amalfitabula.it", true },
  { "amanatrustbooks.org.uk", true },
  { "amandadamsphotography.com", true },
  { "amandasage.ca", true },
  { "amani-kinderdorf.de", true },
  { "amardham.org", true },
  { "amaresq.com", true },
  { "amartinz.at", true },
  { "amateurchef.co.uk", true },
  { "amateurradionotes.com", true },
  { "amateurvoicetalent.com", true },
  { "amati.solutions", true },
  { "amato.tk", true },
  { "amatsuka.com", true },
  { "amauf.de", true },
  { "amautorepairwa.com", true },
  { "amazili-communication.com", true },
  { "amazing-castles.co.uk", true },
  { "amazinginflatables.co.uk", true },
  { "amb.tf", true },
  { "amberalert.gov", true },
  { "amberglowleisure.co.uk", true },
  { "amberlightleisure.com", true },
  { "ambholding-usedcars.be", true },
  { "ambiente.one", true },
  { "ambiq.nl", true },
  { "ambouncyhire.com", true },
  { "amcangroup.com", true },
  { "amcchemical.com", true },
  { "amcfirst.com", true },
  { "amchainitiative.org", true },
  { "amcs.website", true },
  { "amdouglas.com", true },
  { "amechancez.work", true },
  { "amedtest.org", true },
  { "ameego.com", true },
  { "ameego.it", true },
  { "ameego.net", true },
  { "ameego.nl", true },
  { "ameego.org", true },
  { "amees.me", false },
  { "amelandadventure.nl", true },
  { "amello.de", true },
  { "amend-friseur-schwabing.de", true },
  { "america.gov", true },
  { "americafamilylawcenter.org", true },
  { "american-school-search.com", true },
  { "american.dating", true },
  { "americandetour.com", true },
  { "americanfoundationbr.com", true },
  { "americanindiannursing.com", true },
  { "americanmediainstitute.com", true },
  { "americasbasementcontractor.com", true },
  { "americkykongres.cz", true },
  { "amerigroup.com", true },
  { "ameriikanpoijat.org", true },
  { "amerika-forum.de", true },
  { "amerimarkdirect.com", true },
  { "amerimex.cc", true },
  { "amesgen.de", true },
  { "amesvacuumrepair.com", true },
  { "amethystdevelopment.co.uk", true },
  { "amf.to", true },
  { "amg-exterieur.fr", true },
  { "amg-microwave.com", true },
  { "amh-entertainments.co.uk", true },
  { "ami-de-bastanes.fr", true },
  { "amica-travel.com", true },
  { "amicalecanyon.ch", true },
  { "amiciidogrescue.org.uk", true },
  { "amicimar.it", true },
  { "amielucha.com", true },
  { "amifoundation.net", true },
  { "amikootours.com", true },
  { "aminafrance.com", true },
  { "amineptine.com", true },
  { "aminorth.com", true },
  { "amionvpn.com", true },
  { "amirautos.com", true },
  { "amirmahdy.com", true },
  { "amisderodin.fr", true },
  { "amitabhsirkiclasses.org.in", true },
  { "amitpatra.com", true },
  { "amiu.org", true },
  { "ammanagingdirectors.com", true },
  { "amministratore.biz", true },
  { "amministratore.roma.it", true },
  { "amministratorecondominio.roma.it", true },
  { "amnesty-bf.org", true },
  { "amnesty.org.au", true },
  { "amnesy.fr", true },
  { "amoozesh98.com", true },
  { "amoozesh98.ir", true },
  { "amorgos-aegialis.com", true },
  { "amorim.ca", true },
  { "amosng.com", true },
  { "ampersandnbspsemicolon.com", true },
  { "amphetamines.org", true },
  { "amphibo.ly", true },
  { "ampol-agd.pl", true },
  { "ampproject.com", true },
  { "ampproject.org", true },
  { "amrcaustin.com", true },
  { "amrcla.com", true },
  { "ams.co.rs", true },
  { "amsportuk.com", true },
  { "amsterdamian.com", true },
  { "amuq.net", true },
  { "amuraimpianti.it", true },
  { "amyfoundhermann.com", true },
  { "amyharrisonline.com", true },
  { "amyrussellhair.com", true },
  { "amyyeung.com", true },
  { "amzn.rocks", true },
  { "anabolic.co", true },
  { "anacreon.de", true },
  { "anadiyogacentre.com", true },
  { "anaethelion.fr", true },
  { "analbleachingguide.com", true },
  { "analgesia.net", true },
  { "analisilaica.it", true },
  { "analogist.net", true },
  { "analyticsinmotion.com", true },
  { "analyticum.at", true },
  { "analyticum.com", true },
  { "analyticum.de", true },
  { "analyticum.eu", true },
  { "analyticum.net", true },
  { "ananas.gq", true },
  { "ananke.io", true },
  { "anankecosmetics.com", true },
  { "anantshri.info", true },
  { "ananyoo.com", true },
  { "anarchistischegroepnijmegen.nl", false },
  { "anarchyrp.life", true },
  { "anassiriphotography.com", false },
  { "anastasia-shamara.ru", true },
  { "anaveragehuman.eu.org", true },
  { "ancestramil.fr", true },
  { "anchev.net", true },
  { "anchorit.gov", true },
  { "anchovy.nz", false },
  { "anciens.org", true },
  { "ancientcraft.eu", true },
  { "ancientnorth.com", true },
  { "ancientnorth.nl", true },
  { "ancolies-andre.com", true },
  { "anconaswine.com", true },
  { "and-stuff.nl", true },
  { "and.com", true },
  { "andalusierondreizen.nl", true },
  { "andariegocusco.com", true },
  { "andarpersassi.it", true },
  { "andel.info", false },
  { "anders.hamburg", true },
  { "anderskp.dk", false },
  { "andersonshatch.com", true },
  { "andiplusben.com", true },
  { "andisadhdspot.com", true },
  { "anditi.com", true },
  { "andoms.fi", true },
  { "andre-ballensiefen.de", true },
  { "andre-lategan.com", true },
  { "andre-otto.com", true },
  { "andrea-kiaora.de", true },
  { "andrea-m.me", true },
  { "andrea-wirthensohn.at", true },
  { "andreaboero.it", true },
  { "andreadraghetti.it", true },
  { "andreagourmet.it", true },
  { "andreahruby.it", true },
  { "andreamcnett.com", true },
  { "andreas-hecht.com", true },
  { "andreaseracleous.com", true },
  { "andreasfeusi.ch", true },
  { "andreashecht-blog.de", true },
  { "andreaskrasa.com", true },
  { "andreaslicht.nl", true },
  { "andreasmuelhaupt.de", true },
  { "andreasolsson.se", true },
  { "andree.cloud", true },
  { "andrehansen.de", true },
  { "andrei-nakov.org", true },
  { "andrelauzier.com", true },
  { "andreoliveira.io", true },
  { "andrespaz.com", true },
  { "andreundnina.de", true },
  { "andrew.fi", true },
  { "andrew.london", true },
  { "andrewbdesign.com", true },
  { "andrewdaws.io", true },
  { "andrewensley.com", true },
  { "andrewhowden.com", true },
  { "andrewimeson.com", true },
  { "andrewin.ru", true },
  { "andrewmichaud.com", true },
  { "andrewmichaud.me", true },
  { "andrewpeng.net", true },
  { "andrewprokos.com", true },
  { "andrewrgoss.com", true },
  { "andrewryno.com", true },
  { "andrewsun.com", true },
  { "andrewtchin.com", true },
  { "andrewx.net", true },
  { "andrezadnik.com", true },
  { "andro2id.com", true },
  { "andro4all.com", true },
  { "android.re", true },
  { "androide.com", true },
  { "androidhry.cz", true },
  { "androidkatalog.cz", true },
  { "androidnovinky.cz", true },
  { "androidservicetool.com", true },
  { "androidsis.com", true },
  { "androidtamer.com", true },
  { "androidtelefony.cz", true },
  { "androidzone.me", true },
  { "andromedacenter.com", true },
  { "androticsdirect.com", true },
  { "andruvision.cz", true },
  { "andsat.org", true },
  { "andschwa.com", true },
  { "andso.cn", true },
  { "anduril.de", true },
  { "anduril.eu", true },
  { "andybrett.com", true },
  { "andyc.cc", true },
  { "andycrockett.io", true },
  { "andymoore.info", true },
  { "andys-place.co.uk", true },
  { "andysroom.dynu.net", true },
  { "andyt.eu", true },
  { "andzia.art.pl", true },
  { "anedot-sandbox.com", true },
  { "anedot.com", true },
  { "anedot.space", true },
  { "anedot.xyz", true },
  { "aneebahmed.com", true },
  { "anegabawa.com", true },
  { "aneslix.com", false },
  { "anetaben.nl", true },
  { "anextraordinaryday.net", true },
  { "angehardy.com", true },
  { "angel-body.com", true },
  { "angelcojuelo.com", true },
  { "angelesydemonios.es", true },
  { "angelicare.co.uk", true },
  { "angelinahair.com", true },
  { "angeljmadrid.com", true },
  { "angeloryndon.com", true },
  { "angelremigene.com", true },
  { "angelsgirl.eu.org", true },
  { "anginf.de", true },
  { "anglesgirl.eu.org", true },
  { "anglesya.win", true },
  { "anglictina-sojcak.cz", true },
  { "anglictinasojcak.cz", true },
  { "anglingactive.co.uk", true },
  { "anglirl.eu.org", true },
  { "angrapa.ru", true },
  { "angristan.fr", true },
  { "angristan.xyz", true },
  { "angry.im", true },
  { "angrysnarl.com", true },
  { "angryteeth.net", true },
  { "angularjs.org", false },
  { "angusmak.com", true },
  { "anhaffen.lu", true },
  { "ani-man.de", true },
  { "anicam.fr", true },
  { "aniforprez.net", true },
  { "animacurse.moe", true },
  { "animaemundi.be", true },
  { "animal-liberation.com", true },
  { "animal-nature-human.com", true },
  { "animal-rights.com", true },
  { "animalistic.io", true },
  { "animaltesting.fr", true },
  { "animan.ca", true },
  { "animationsmusicales.ch", true },
  { "anime-culture.com", true },
  { "anime-rg.com", true },
  { "anime-tip.com", true },
  { "anime.my", false },
  { "anime1.me", true },
  { "anime1.moe", true },
  { "anime1.pw", true },
  { "animeai.com", true },
  { "animefluxxx.com", true },
  { "animeinsights.net", true },
  { "animes-portal.info", true },
  { "animesharp.com", true },
  { "animetriad.com", true },
  { "animorphsfanforum.com", true },
  { "anipassion.com", false },
  { "anitaalbersen.nl", true },
  { "anitube.ch", true },
  { "aniwhen.com", true },
  { "anjoola.com", true },
  { "ankane.org", true },
  { "ankarakart.com.tr", true },
  { "ankaraprofesyonelwebtasarim.com", true },
  { "ankaraseo.name.tr", true },
  { "ankarauzmanlarnakliyat.com", true },
  { "ankarayilmaznakliyat.com", true },
  { "ankarayucelnakliyat.com", true },
  { "ankenbrand.me", true },
  { "ankitpati.in", true },
  { "ankiuser.net", true },
  { "ankiweb.net", true },
  { "ankwanoma.com", true },
  { "anleitung-deutsch-lernen.de", true },
  { "anleitung-zum-flechten.de", true },
  { "anleitung-zum-haekeln.de", true },
  { "anleitung-zum-schreiben.de", true },
  { "anleitung-zum-schweissen.de", true },
  { "anleitung-zum-toepfern.de", true },
  { "anna.info", true },
  { "annaenemma.nl", true },
  { "annafiore.com.br", true },
  { "annangela.moe", true },
  { "annarokina.com", true },
  { "annasvapor.se", true },
  { "annawagner.pl", true },
  { "annedaniels.co.uk", true },
  { "anneeden.de", true },
  { "annejan.com", true },
  { "anneliesonline.nl", true },
  { "annema.biz", true },
  { "annemakeslovelycandles.co.uk", true },
  { "annetta.com", true },
  { "annettewindlin.ch", true },
  { "annevankesteren.nl", true },
  { "anniversary-cruise.com", true },
  { "annmariewaltsphotography.com", true },
  { "annonasoftware.com", true },
  { "annoyingasfuk.com", true },
  { "annuaire-jcb.com", true },
  { "annuaire-photographe.fr", false },
  { "annunciationbvmchurch.org", true },
  { "anohana.org", true },
  { "anojan.com", true },
  { "anon-next.de", true },
  { "anoncom.net", true },
  { "anoncrypto.org", true },
  { "anongoth.pl", true },
  { "anons.fr", true },
  { "anonym-surfen.de", true },
  { "anonyme-spieler.at", true },
  { "anorak.tech", true },
  { "another.ch", true },
  { "anotherchef.com", true },
  { "anotherfatgeek.net", true },
  { "anothervps.com", true },
  { "anowicki.pl", false },
  { "anoxinon.de", false },
  { "ans-delft.nl", true },
  { "ans-ge.ch", true },
  { "ansas.eu", true },
  { "ansas.net", true },
  { "ansdell.net", true },
  { "ansermet.net", true },
  { "ansgar-sonntag.de", true },
  { "ansgarsonntag.de", true },
  { "anshar.eu", true },
  { "ansichtssache.at", true },
  { "ansogning-sg.dk", true },
  { "anstaskforce.gov", true },
  { "antama.eu", true },
  { "antama.nl", true },
  { "antani.cloud", true },
  { "antarcti.co", true },
  { "antarees.net", true },
  { "antaresmedia.com.py", true },
  { "antarespc.com", true },
  { "antcas.com", true },
  { "antennista.bari.it", true },
  { "antennista.catania.it", true },
  { "antennista.milano.it", true },
  { "antennista.pavia.it", true },
  { "antennista.roma.it", true },
  { "antennista.tv", true },
  { "antennisti.milano.it", true },
  { "antennisti.roma.it", true },
  { "anteprima.info", true },
  { "antfie.com", true },
  { "anthedesign.fr", true },
  { "anthisis.tv", true },
  { "anthony.codes", true },
  { "anthonycarbonaro.com", true },
  { "anthonyfontanez.com", true },
  { "anthonygaidot.fr", true },
  { "anthonyvadala.me", true },
  { "anthropoid.ca", true },
  { "anti-bible.com", true },
  { "anti-radar.org", true },
  { "antibioticshome.com", true },
  { "anticopyright.com", true },
  { "antiekboerderijgraafland.nl", true },
  { "antihype.space", true },
  { "antik-trodelmarkt.de", true },
  { "antikvariat.ru", true },
  { "antikvarius.ro", true },
  { "antiled.by", true },
  { "antimine.me", true },
  { "antipolygraph.org", true },
  { "antique-pedalcars.ch", true },
  { "antirepressionbayarea.com", true },
  { "antispeciesism.com", true },
  { "antispeciesist.com", true },
  { "antivirusprotection.reviews", true },
  { "antocom.com", true },
  { "antoga.eu", true },
  { "antoinedeschenes.com", true },
  { "antoinemary.com", true },
  { "antonchen.com", true },
  { "antonellabb.eu", true },
  { "antonin.one", true },
  { "antonio-gartenbau.de", true },
  { "antonjuulnaber.dk", true },
  { "antota.lt", true },
  { "antragsgruen.de", true },
  { "antroposofica.com.br", true },
  { "anttitenhunen.com", true },
  { "antvklik.com", true },
  { "antyblokada.pl", true },
  { "anulowano.pl", true },
  { "anvartay.com", false },
  { "anwalt.us", true },
  { "anwaltsindex.com", true },
  { "anxietyspace.com", true },
  { "anxiolytics.com", true },
  { "anymetrix.io", true },
  { "anynode.net", true },
  { "anyon.com", true },
  { "anypeer.net", true },
  { "anyquestions.govt.nz", true },
  { "anystack.xyz", true },
  { "anzeiger.ag", true },
  { "ao-dev.com", true },
  { "ao2.it", true },
  { "aoa.gov", true },
  { "aoadatacommunity.us", true },
  { "aoaprograms.net", true },
  { "aoeuaoeu.com", true },
  { "aofusa.net", true },
  { "aoil.gr", true },
  { "aoku3d.com", true },
  { "aopedeure.nl", true },
  { "aopsy.de", true },
  { "aos-llc.com", true },
  { "aosc.io", false },
  { "aosus.org", true },
  { "aotearoa.maori.nz", true },
  { "aotearoaleaks.org", true },
  { "ap-swiss.ch", true },
  { "apac-tech.com", false },
  { "apache-portal.com", true },
  { "apachehaus.de", false },
  { "apachelounge.com", true },
  { "apadvantage.com", true },
  { "aparaatti.org", true },
  { "apartmanicg.me", true },
  { "apartment-in-rijeka.com", true },
  { "apartment-natik.fr", true },
  { "apartmentkroatien.at", true },
  { "apartmentregister.com.au", true },
  { "apasaja.tech", true },
  { "apbox.de", true },
  { "apcemporium.co.uk", true },
  { "apcube.com", true },
  { "apdx.com", true },
  { "apef.ch", true },
  { "apercloud.es", true },
  { "apertis.org", true },
  { "aperturesciencelabs.de", true },
  { "apervita.net", true },
  { "apexitsolutions.ca", true },
  { "apfelcholest.de", true },
  { "apgw.jp", true },
  { "aphelionentertainment.com", true },
  { "aphotrax.eu", true },
  { "api-connect.com", true },
  { "api-geek.com", true },
  { "api.biz.tr", true },
  { "api.cloudflare.com", true },
  { "api.intercom.io", true },
  { "api.lookout.com", false },
  { "api.recurly.com", true },
  { "api.simple.com", false },
  { "api.xero.com", false },
  { "apiary.blog", true },
  { "apiary.clothing", true },
  { "apiary.shop", true },
  { "apiary.store", true },
  { "apiary.supplies", true },
  { "apiary.supply", true },
  { "apila.care", true },
  { "apila.us", true },
  { "apination.com", true },
  { "apio.systems", true },
  { "apis.google.com", true },
  { "apis.moe", true },
  { "apisyouwonthate.com", true },
  { "apk.li", true },
  { "apk4fun.com", true },
  { "apkmod.id", true },
  { "aplikaceproandroid.cz", true },
  { "aplpackaging.co.uk", true },
  { "aplu.fr", true },
  { "aplus-usa.net", true },
  { "aplusdownload.com", true },
  { "apluswaterservices.com", true },
  { "apm.com.tw", true },
  { "apn-dz.org", true },
  { "apn-einstellungen.de", true },
  { "apobot.de", true },
  { "apogeephoto.com", true },
  { "apoil.org", true },
  { "apoly.de", true },
  { "aponkral.net", true },
  { "aporia.io", true },
  { "aposke.com", true },
  { "aposke.net", true },
  { "aposke.org", true },
  { "apotheke-ch.org", true },
  { "apothes.is", true },
  { "app-at.work", true },
  { "app.lookout.com", true },
  { "app.recurly.com", true },
  { "app.simpletax.ca", true },
  { "app.yinxiang.com", false },
  { "app2get.de", true },
  { "appapi.link", true },
  { "apparelfashionwiki.com", true },
  { "appartement-andrea.at", true },
  { "appartement-evolene.net", true },
  { "appartementhaus-badria.de", true },
  { "appartementmarsum.nl", true },
  { "appearance-plm.de", true },
  { "appel-aide.ch", true },
  { "appelaprojets.fr", true },
  { "appelboomdefilm.nl", true },
  { "appengine.google.com", true },
  { "apperio.com", true },
  { "appformacpc.com", true },
  { "appgeek.com.br", true },
  { "appharbor.com", true },
  { "appify.org", true },
  { "appinn.com", true },
  { "applelife.ru", true },
  { "applemon.com", true },
  { "appleoosa.com", true },
  { "appleranch.com", true },
  { "applesana.es", true },
  { "applesencia.com", true },
  { "applian.jp", true },
  { "applicationmanager.gov", true },
  { "apply.eu", true },
  { "appmeas.co.uk", true },
  { "appmobile.io", true },
  { "appninjas.com", true },
  { "apponic.com", true },
  { "apponline.com", true },
  { "apprank.in", true },
  { "apprenticeship.gov", true },
  { "apprenticeships.gov", true },
  { "approbo.com", true },
  { "approvedtreecare.com", true },
  { "apps.co", true },
  { "apps.facebook.com", false },
  { "apps.fedoraproject.org", true },
  { "apps.stg.fedoraproject.org", true },
  { "apps4inter.net", true },
  { "appscloudplus.com", true },
  { "appseccalifornia.org", false },
  { "appsforlondon.com", true },
  { "appshuttle.com", true },
  { "appt.ch", true },
  { "apptomics.com", true },
  { "appuals.com", true },
  { "appui-de-fenetre.fr", true },
  { "appveyor.com", true },
  { "appxcrypto.com", true },
  { "appzoojoo.be", true },
  { "apratimsaha.com", true },
  { "apretatuercas.es", true },
  { "aprikaner.de", true },
  { "aprogend.com.br", true },
  { "aproposcomputing.com", true },
  { "aprovpn.com", true },
  { "aprr.org", true },
  { "aprsdroid.org", true },
  { "aprz.de", true },
  { "apsa.paris", true },
  { "apstudynotes.org", true },
  { "aptitudetests.org", true },
  { "apu-board.de", true },
  { "apv-ollon.ch", true },
  { "aqdun.com", true },
  { "aqsiq.net", true },
  { "aqua-fitness-nacht.de", true },
  { "aqua-fotowelt.de", true },
  { "aquabar.co.il", true },
  { "aquabio.ch", true },
  { "aquadonis.ch", true },
  { "aquagarden.com.pl", true },
  { "aquahomo.com", true },
  { "aquainfo.net", true },
  { "aqualife.com.gr", true },
  { "aqualifeprojects.com", true },
  { "aqualysis.nl", true },
  { "aquapoint.kiev.ua", true },
  { "aquarium-supplement.net", true },
  { "aquaron.com", true },
  { "aquatechnologygroup.com", true },
  { "aquaundine.net", true },
  { "aquavitaedayspa.com.au", true },
  { "aquelarreweb.com", true },
  { "aquila.co.uk", true },
  { "aquitainebrasserie.com.au", true },
  { "aquitroc.com", true },
  { "ar-informatique.ch", true },
  { "arab.dating", true },
  { "arabicxz.com", true },
  { "arachina.com", true },
  { "arackiralama.name.tr", true },
  { "arados.de", true },
  { "arai21.net", true },
  { "araleeniken.com", true },
  { "aramado.com", true },
  { "aramido.de", true },
  { "aranchhomes.com", true },
  { "aranycsillag.net", true },
  { "araraexpress.com.br", true },
  { "araratour.com", true },
  { "araro.ch", true },
  { "araseifudousan.com", true },
  { "arawaza.com", false },
  { "araxis.com", true },
  { "arbeitsch.eu", true },
  { "arbeitskreis-asyl-eningen.de", true },
  { "arbeitslosenverwaltung.de", true },
  { "arbejdsdag.dk", true },
  { "arbitrarion.com", true },
  { "arbitrary.ch", true },
  { "arboworks.com", true },
  { "arbu.eu", false },
  { "arcaik.net", true },
  { "arcbouncycastles.co.uk", true },
  { "arcenergy.co.uk", true },
  { "archaeoadventures.com", true },
  { "archimedicx.com", true },
  { "archined.nl", true },
  { "architectryan.com", true },
  { "architecture-colleges.com", true },
  { "architectureandgovernance.com", true },
  { "archivero.es", true },
  { "archivesdelavieordinaire.ch", true },
  { "archlinux.de", true },
  { "archlinux.org", true },
  { "arclandholdings.com.au", true },
  { "arcobalabs.ca", true },
  { "arcridge.ca", true },
  { "arctic.gov", true },
  { "arcueil-cachan.fr", false },
  { "arcusnova.de", true },
  { "arda-audio.pt", true },
  { "ardor.noip.me", true },
  { "ardtrade.ru", true },
  { "area4pro.com", true },
  { "area536.com", true },
  { "areaclienti.net", true },
  { "areafiftylan.nl", true },
  { "areatrend.com", true },
  { "arefidgetspinnersgay.com", true },
  { "arekatieandchrisgettingmarried.com", true },
  { "arekatieandchrisgettingmarried.today", true },
  { "arekatieandchrismarriedyet.com", true },
  { "arendburgers.nl", true },
  { "arenlor.com", true },
  { "arenlor.info", true },
  { "arenns.com", true },
  { "areqgaming.com", true },
  { "ares-trading.de", true },
  { "arethsu.se", true },
  { "arfad.ch", true },
  { "arg.zone", true },
  { "argama-nature.com", true },
  { "arganaderm.ch", true },
  { "argb.de", true },
  { "argekultur.at", true },
  { "argonium.com.au", true },
  { "argot.com", true },
  { "argovpay.com", true },
  { "ariadermspa.com", true },
  { "arian.io", true },
  { "ariana.wtf", true },
  { "arias.re", true },
  { "ariba.info", true },
  { "ariege-pyrenees.net", true },
  { "arieswdd.com", true },
  { "arigato-java.download", true },
  { "arijitdg.net", true },
  { "arikar.eu", true },
  { "arima.co.ke", true },
  { "arinde.ee", true },
  { "arise19.com", true },
  { "arisevendor.net", true },
  { "aristocrates.co", true },
  { "aritec-la.com", true },
  { "arivo.com.br", true },
  { "arizonaautomobileclub.com", true },
  { "arizonabondedtitle.com", true },
  { "arizonahomeownerinsurance.com", true },
  { "arjandejong.eu", true },
  { "arjanvaartjes.net", true },
  { "arjunasdaughter.pub", true },
  { "arjweb.co.uk", true },
  { "arkacrao.org", true },
  { "arkadiyt.com", true },
  { "arkaic.dyndns.org", true },
  { "arkulagunak.com", false },
  { "arlatools.com", true },
  { "arlen.tv", true },
  { "arlenarmageddon.com", true },
  { "arletalibrary.com", true },
  { "arlingtonelectric.com", true },
  { "arm-host.com", true },
  { "armadaquadrat.com", true },
  { "armandsdiscount.com", true },
  { "armanozak.com", true },
  { "armansfinejewellery.com", true },
  { "armansfinejewellery.com.au", true },
  { "armarinhovirtual.com.br", true },
  { "armazemgourmetbrasil.com.br", true },
  { "armbrust.me", true },
  { "armedpoet.com", true },
  { "armeo.top", true },
  { "armil.it", true },
  { "armin-cme.de", true },
  { "armin-cpe.de", true },
  { "arminc.tk", true },
  { "arminpech.de", true },
  { "armleads.com", true },
  { "armor.ai", true },
  { "armstrongsengineering.com", true },
  { "army24.cz", true },
  { "armyprodej.cz", true },
  { "arnaudb.net", true },
  { "arnaudfeld.de", true },
  { "arne.codes", true },
  { "arnevankauter.com", true },
  { "arniescastles.co.uk", true },
  { "arno-klein.de", true },
  { "arno-klein.eu", true },
  { "arno-klein.fr", true },
  { "arno.pm", true },
  { "arnoldkontz-occasions.lu", true },
  { "arnonerba.com", true },
  { "arnor.org", true },
  { "arnoudraeven.nl", true },
  { "arnoudvandalen.nl", true },
  { "arnsmedia.nl", true },
  { "arod.tk", true },
  { "arogov.com", true },
  { "arokha.com", true },
  { "aromacos.ch", true },
  { "aromatlas.com", true },
  { "aron.host", true },
  { "aroonchande.com", true },
  { "aros.pl", true },
  { "arose.io", true },
  { "arox.eu", true },
  { "arpamip.org", true },
  { "arpnet.co.jp", true },
  { "arqueo-ecuatoriana.ec", true },
  { "arquitetura.pt", true },
  { "arrakis.se", true },
  { "arraudi.be", true },
  { "arrazane.com.br", true },
  { "arresttracker.com", true },
  { "arrive.by", true },
  { "arrmaforum.com", true },
  { "arroba.digital", true },
  { "arrow-analytics.nl", true },
  { "arrow-api.nl", true },
  { "arrowfastener.com", true },
  { "arrowheadaddict.com", true },
  { "arrowheadflats.com", true },
  { "arrowwebprojects.nl", true },
  { "arschkrebs.org", true },
  { "arsplus.ru", false },
  { "arswb.men", true },
  { "art-auction.jp", true },
  { "art-et-culture.ch", true },
  { "artboja.com", true },
  { "artdeco-photo.com", true },
  { "arte-soft.co", true },
  { "artea.ga", true },
  { "arteaga.co.uk", true },
  { "arteaga.eu", true },
  { "arteaga.me", true },
  { "arteaga.tech", true },
  { "arteaga.uk", true },
  { "arteaga.xyz", true },
  { "artebel.com.br", true },
  { "artecat.ch", true },
  { "artedellavetrina.it", true },
  { "artedona.com", true },
  { "artefakt.es", true },
  { "artefeita.com.br", true },
  { "arteinstudio.it", true },
  { "artelt.com", true },
  { "artemis.re", true },
  { "arterienundvenen.ch", true },
  { "arteshow.ch", true },
  { "artetrama.com", false },
  { "artfabrics.com", true },
  { "artforum.sk", true },
  { "artfullyelegant.com", true },
  { "arthan.me", true },
  { "arthermitage.org", true },
  { "arthur.cn", true },
  { "arthurlaw.ca", true },
  { "artificial.army", true },
  { "artificialgrassandlandscaping.com", true },
  { "artik.cloud", true },
  { "artimpact.ch", true },
  { "artioml.net", true },
  { "artionet.ch", true },
  { "artis-game.net", true },
  { "artisan-cheminees-poeles-design.fr", true },
  { "artisans-libres.com", true },
  { "artisansoftaste.com", true },
  { "artistagenda.com", true },
  { "artistrunwebsite.com", true },
  { "artlantis.nl", true },
  { "artleading.ru", true },
  { "artlifeisgood.com", true },
  { "artlogo.biz", true },
  { "artlogo.cz", true },
  { "artlogo.sk", true },
  { "artmanager.dk", true },
  { "artmarketingnews.com", true },
  { "artmoney.com", true },
  { "artofcode.co.uk", true },
  { "artofmonitoring.com", false },
  { "artofwhere.com", true },
  { "artratio.net", true },
  { "artroot.jp", true },
  { "artroscopiaperlosport.it", true },
  { "arts.gov", true },
  { "artschmidtoptical.com", true },
  { "artspac.es", true },
  { "arturkohut.com", true },
  { "arturrossa.de", true },
  { "arturszalak.com", true },
  { "artweby.cz", true },
  { "artworxbathrooms.com.au", true },
  { "arty.name", true },
  { "arubasunsetbeach.com", true },
  { "arveron.ch", true },
  { "arvid.io", true },
  { "arviksa.co.uk", true },
  { "arvindhariharan.com", true },
  { "arvindhariharan.me", true },
  { "arvutiladu.ee", true },
  { "arw.me", true },
  { "arxell.com", true },
  { "aryalaroca.de", true },
  { "aryan-nation.com", true },
  { "aryasenna.net", true },
  { "arzid.com", true },
  { "arzinfo.pw", true },
  { "as200753.com", true },
  { "as200753.net", true },
  { "as44222.net", true },
  { "asadatec.de", true },
  { "asadzulfahri.com", true },
  { "asafaweb.com", true },
  { "asafilm.co", true },
  { "asandu.eu", true },
  { "asanger.biz", true },
  { "asato-jewelry.com", true },
  { "asbestosthedarkarts.com", true },
  { "asbito.de", true },
  { "ascamso.com", true },
  { "ascendprime.com", true },
  { "ascension.run", true },
  { "ascensori.biz", true },
  { "ascgathering.com", true },
  { "ascii.moe", true },
  { "asciitable.tips", true },
  { "asciiwwdc.com", true },
  { "asd.gov.au", true },
  { "asdyx.de", true },
  { "asec01.net", true },
  { "asegem.es", true },
  { "aseko.gr", true },
  { "asenno.com", true },
  { "aserver.co", true },
  { "asexualitat.cat", true },
  { "asgapps.co.za", true },
  { "asge-handel.de", true },
  { "ashastalent.com", true },
  { "ashd1.goip.de", true },
  { "ashd2.goip.de", true },
  { "ashd3.goip.de", true },
  { "ashkan-rechtsanwalt-arbeitsrecht-paderborn.de", true },
  { "ashleyedisonuk.com", true },
  { "ashlocklawgroup.com", true },
  { "ashmportfolio.com", true },
  { "ashutoshmishra.org", true },
  { "asia-gazette.com", true },
  { "asia-global-risk.com", true },
  { "asia.dating", true },
  { "asiaheavens.com", true },
  { "asialeonding.at", true },
  { "asian-industry.eu", true },
  { "asianodor.com", true },
  { "asianshops.net", true },
  { "asianspa.co.uk", true },
  { "asiba.com.au", true },
  { "asiesvenezuela.com", true },
  { "asiinc-tex.com", true },
  { "asile-colis.fr", true },
  { "asinetasima.com", true },
  { "asisee.photography", true },
  { "ask.fi", true },
  { "ask1.org", true },
  { "askcaisse.com", true },
  { "askcascade.com", true },
  { "askizzy.org.au", true },
  { "askkaren.gov", true },
  { "askme24.de", true },
  { "askv6.net", true },
  { "askvg.com", true },
  { "askwhy.cz", true },
  { "askwhy.eu", true },
  { "asmbsurvey.com", true },
  { "asmdz.com", true },
  { "asmood.net", true },
  { "asoul.tw", true },
  { "aspargesgaarden.no", true },
  { "aspatrimoine.com", true },
  { "aspcl.ch", true },
  { "aspectcontext.com", true },
  { "asperti.com", true },
  { "aspformacion.com", true },
  { "asphyxia.su", true },
  { "aspiescentral.com", true },
  { "aspiradorasbaratas.net", true },
  { "aspirateur-anti-pollution.fr", true },
  { "aspires.co.jp", true },
  { "aspisdata.com", true },
  { "asproni.it", true },
  { "asr.cloud", true },
  { "asr.li", true },
  { "asr.rocks", true },
  { "asr.solar", true },
  { "asra.gr", true },
  { "asseenfromthesidecar.org", true },
  { "assemble-together.org", true },
  { "assempsaibiza.com", true },
  { "assertion.de", true },
  { "assessoriati.com.br", true },
  { "assetict.com", true },
  { "assetvault.co.za", true },
  { "assguidesporrentruy.ch", true },
  { "assign-it.co.uk", true },
  { "assistel.com", true },
  { "assistenzaferrodastiro.org", true },
  { "assistenzafrigorifero.org", true },
  { "assistenzalavatrice.org", true },
  { "assistenzamicroonde.org", true },
  { "assodigitale.it", true },
  { "assumptionpj.org", true },
  { "astal.rs", true },
  { "astarbouncycastles.co.uk", true },
  { "astarforu.com", true },
  { "astarmathsandphysics.com", true },
  { "astec-informatica.com", true },
  { "astengox.com", true },
  { "astenotarili.online", true },
  { "astenretail.com", true },
  { "astral-imperium.uk", true },
  { "astral.org.pl", true },
  { "astrology42.com", true },
  { "astroscopy.ch", true },
  { "astrovandalistas.cc", true },
  { "astural.org", true },
  { "astutikhonda.com", true },
  { "asuclassfinder.com", true },
  { "asucrews.com", true },
  { "asuka.io", true },
  { "asun.co", true },
  { "asurbernardo.com", true },
  { "asurepay.cc", false },
  { "asustreiber.de", true },
  { "asvsa.ch", true },
  { "asws.nl", true },
  { "asystent-dzierzawy.pl", true },
  { "at.search.yahoo.com", false },
  { "ataber.pw", true },
  { "atac.no", true },
  { "atacadocervejeiro.com.br", true },
  { "atacadodesandalias.com.br", true },
  { "atallo.com", true },
  { "atallo.es", true },
  { "ataton.ch", true },
  { "atc.io", true },
  { "atchleyjazz.com", true },
  { "atchleyjazz.org", true },
  { "atchleylab.org", true },
  { "atcom.cl", true },
  { "atds.ch", true },
  { "ateamsport.dk", true },
  { "atease-salon.jp", true },
  { "atedificacion.com", true },
  { "ateli.com", true },
  { "atelier-coiffure.ch", true },
  { "atelier-naruby.cz", true },
  { "atelieraphelion.com", true },
  { "atelierbw.com", true },
  { "atelierdefrancais.ch", true },
  { "atelierdeloulou.fr", true },
  { "atelierdesflammesnoires.fr", true },
  { "atelierfantazie.sk", true },
  { "atelierhsn.com", true },
  { "ateliernaruby.cz", true },
  { "ateliers-veronese-nantes.fr", true },
  { "atelierssud.ch", true },
  { "atelierssud.swiss", true },
  { "atencionbimbo.com", false },
  { "atendimentodelta.com.br", true },
  { "aterskapa-data.se", true },
  { "atgoetschel.ch", true },
  { "atgroup.gr", true },
  { "atgseed.co.uk", true },
  { "atgseed.uk", true },
  { "ath0.org", false },
  { "atheist-refugees.com", true },
  { "athena-bartholdi.com", true },
  { "athena-garage.co.uk", true },
  { "athenadynamics.com", true },
  { "athenaneuro.com", true },
  { "atherosense.ga", true },
  { "athlin.de", true },
  { "atigerseye.com", true },
  { "atimbertownservices.com", true },
  { "atishchenko.com", true },
  { "atisoft.biz", true },
  { "atisoft.com.tr", true },
  { "atisoft.net", true },
  { "atisoft.net.tr", true },
  { "atisoft.web.tr", true },
  { "atisystem.com", true },
  { "atitude.com", true },
  { "ativapsicologia.com.br", true },
  { "atl-paas.net", true },
  { "atlantahairsurgeon.com", true },
  { "atlantareroof.com", true },
  { "atlantaspringroll.com", true },
  { "atlantichomes.com.au", true },
  { "atlanticpediatricortho.com", true },
  { "atlantis-kh.noip.me", true },
  { "atlantischild.hu", true },
  { "atlantishq.de", true },
  { "atlantiswaterproofing.com", true },
  { "atlas-heritage.com", true },
  { "atlasbrown.com", true },
  { "atlaschiropractic.org", true },
  { "atlascultural.com", true },
  { "atlasdev.nl", true },
  { "atlasone.us", true },
  { "atlassian.io", true },
  { "atlassignsandplaques.com", true },
  { "atletika.hu", true },
  { "atmschambly.com", true },
  { "atnis.com", true },
  { "ato4sound.com", true },
  { "atolm.net", true },
  { "atom-china.org", true },
  { "atom.solutions", true },
  { "atom86.net", true },
  { "atombase.org", true },
  { "atomic-bounce.com", true },
  { "atomicbounce.co.uk", true },
  { "atomism.com", true },
  { "atorcidabrasileira.com.br", true },
  { "atplonline.co", true },
  { "atpnutrition.com", true },
  { "atraining.ru", true },
  { "atraverscugy.ch", true },
  { "atrinik.org", true },
  { "atsoftware.de", true },
  { "atspeeds.com", true },
  { "attac.us", true },
  { "atte.fi", true },
  { "attendantdesign.com", true },
  { "attendu.cz", true },
  { "attention.horse", true },
  { "attilavandervelde.nl", true },
  { "attinderdhillon.com", true },
  { "attitudes-bureaux.fr", true },
  { "attogtech.com", true },
  { "attorney.org.il", true },
  { "attwood.org", true },
  { "atulhost.com", true },
  { "atviras.lt", false },
  { "atvirtual.at", true },
  { "atvsafety.gov", true },
  { "atwar-mod.com", true },
  { "atwonline.org", true },
  { "atxchirocoverage.com", true },
  { "atyourprice.net", true },
  { "atypicom.es", true },
  { "atypicom.fr", true },
  { "atypicom.it", true },
  { "atypicom.pt", true },
  { "atzenchefin.de", true },
  { "au-be.net", true },
  { "au2pb.org", true },
  { "aubergegilly.ch", true },
  { "aubg.org", true },
  { "aubio.org", true },
  { "aubonmanger.fr", true },
  { "aucielrose.com", true },
  { "aucklandcastles.co.uk", true },
  { "aucubin.de", true },
  { "audialbuquerqueparts.com", true },
  { "audiblox.co.za", true },
  { "audiense.com", false },
  { "audio-detector.com", true },
  { "audiobookboo.com", true },
  { "audiolibri.org", true },
  { "audiolot.com", true },
  { "audion.cc", true },
  { "audion.hr", true },
  { "audiophile.ch", true },
  { "audiophix.com", true },
  { "audiorecording.me", true },
  { "audiorental.net", true },
  { "audioschoolonline.com", true },
  { "audiotechniker.de", true },
  { "audirsq3.de", true },
  { "audisto.com", true },
  { "auditmatrix.com", true },
  { "auditos.com", true },
  { "audits.io", true },
  { "auditsquare.com", true },
  { "audreyjudson.com", true },
  { "auenhof-agrar.de", true },
  { "auerbach-verlag.de", true },
  { "auf-feindgebiet.de", true },
  { "augen-seite.de", true },
  { "augmentable.de", false },
  { "augmented-portal.com", true },
  { "august-don.site", true },
  { "augustian-life.cz", true },
  { "augustiner-kantorei-erfurt.de", true },
  { "augustiner-kantorei.de", true },
  { "aukaraoke.su", true },
  { "aulaschrank.gq", true },
  { "aulo.in", false },
  { "aumilieudumonde.gf", true },
  { "aunali1.com", true },
  { "auntie-eileens.com.au", true },
  { "aupasdecourses.com", true },
  { "auplidespages.fr", true },
  { "aurelieburn.fr", true },
  { "aurelienaltarriba.fr", true },
  { "aureus.pw", true },
  { "auri.ga", true },
  { "auricblue.com", true },
  { "auriko-games.de", true },
  { "aurnik.com", true },
  { "aurora-multimedia.co.uk", true },
  { "auroraassociationofrealtors.com", true },
  { "aurosa.cz", true },
  { "auroware.com", true },
  { "auroz.tech", true },
  { "auroz.video", true },
  { "aus-ryugaku.info", true },
  { "ausmwoid.de", true },
  { "auspicacious.org", true },
  { "ausrecord.com", true },
  { "aussiefunadvisor.com", true },
  { "aussiegreenmarks.com.au", true },
  { "aussieservicedown.com", true },
  { "aussiestoresonline.com", true },
  { "austenplumbing.com", true },
  { "austin-pearce.com", true },
  { "austin-security-cameras.com", true },
  { "austincardiac.com", true },
  { "austinheap.com", false },
  { "austinlockout.com", true },
  { "austintxacrepairtoday.com", true },
  { "austintxlocksmiths.com", true },
  { "austinuniversityhouse.com", true },
  { "australian.dating", true },
  { "australianarmedforces.org", true },
  { "australianattractions.com.au", true },
  { "australianimmigrationadvisors.com.au", true },
  { "australien-tipps.info", true },
  { "austromorph.space", true },
  { "auszeit-lanzarote.com", true },
  { "auszeit-walsrode.de", true },
  { "auszeit.bio", true },
  { "auth.adult", true },
  { "authenticwoodcraft.com", true },
  { "authinity.com", true },
  { "authland.com", false },
  { "author24.biz", true },
  { "author24.info", true },
  { "authoritysolutions.com", true },
  { "autimatisering.nl", true },
  { "auto-anleitung.de", true },
  { "auto-dealership-news.com", true },
  { "auto-motor-i-sport.pl", true },
  { "auto-plus.tn", true },
  { "auto-spurgo.com", true },
  { "auto.nl", true },
  { "autoauctionsohio.com", true },
  { "autoauctionsvirginia.com", true },
  { "autobahnco.com", true },
  { "autobarn.co.nz", true },
  { "autobedrijfgarant.nl", true },
  { "autobelle.it", true },
  { "autobourcier.com", true },
  { "autoclean-plus.ch", true },
  { "autocmall.com", true },
  { "autocontrol.online", true },
  { "autocorner.com", true },
  { "autocrypt.org", true },
  { "autod.hu", true },
  { "autodalmacija.com", true },
  { "autodidactic.ai", true },
  { "autodidacticstudios.com", true },
  { "autodidacticstudios.net", true },
  { "autodidacticstudios.org", true },
  { "autoentrepreneurinfo.com", true },
  { "autoepc.ro", true },
  { "autohaus-snater.de", true },
  { "autoinsurancehavasu.com", true },
  { "autokeyreplacementsanantonio.com", true },
  { "autoledky.sk", true },
  { "automaan.nl", true },
  { "automacity.com", true },
  { "automatethis.com.au", true },
  { "automatic.com", true },
  { "automationpro.me", true },
  { "automotivegroup-usedcars.be", true },
  { "automotivemechanic.org", true },
  { "automoto-tom.net", true },
  { "automy.de", true },
  { "autonewssite.com", true },
  { "autoosijek.com", true },
  { "autopapo.com.br", true },
  { "autoparts.im", true },
  { "autoparts.sh", true },
  { "autoparts.wf", true },
  { "autoprice.info", false },
  { "autoprogconsortium.ga", true },
  { "autoproshouston.com", true },
  { "autorando.com", true },
  { "autorijschoolrichardschut.nl", true },
  { "autoschadeschreuder.nl", true },
  { "autoscuola.roma.it", true },
  { "autosecurityfinance.com", true },
  { "autoshinka72.ru", true },
  { "autoshopsolutions.com", true },
  { "autoshun.org", true },
  { "autoskola.hr", true },
  { "autoskole.hr", true },
  { "autospurgo.it", true },
  { "autospurgo.milano.it", true },
  { "autostodulky.cz", true },
  { "autotechschool.com", true },
  { "autoteplo.org", true },
  { "autoterminus-used.be", true },
  { "autoto.hr", true },
  { "autotransportquoteservices.com", true },
  { "autoverzekeringafsluiten.com", true },
  { "autowerkstatt-puchheim.de", true },
  { "autozane.com", true },
  { "autres-talents.fr", true },
  { "autshir.com", true },
  { "auux.com", true },
  { "auvernet.org", true },
  { "aux-arts-de-la-table.com", true },
  { "auxiliame.com", true },
  { "auxille.com", true },
  { "auxquatrevents.ch", true },
  { "av-yummy.com", true },
  { "av0ndale.de", true },
  { "ava-creative.de", false },
  { "ava-software.at", true },
  { "avaaz.org", true },
  { "avabouncehire.co.uk", true },
  { "avacariu.me", true },
  { "availablecastles.com", true },
  { "avalon-island.ru", true },
  { "avalon-rpg.com", true },
  { "avalon-studios.de", true },
  { "avanet.ch", true },
  { "avanet.com", true },
  { "avanovum.de", true },
  { "avantitualatin.com", true },
  { "avarty.com", true },
  { "avarty.net", true },
  { "avatardiffusion.com", true },
  { "avatarrecruit.co.uk", true },
  { "avcd.cz", true },
  { "avdagic.net", true },
  { "ave.zone", true },
  { "aveapps.com", false },
  { "avedesk.org", false },
  { "aventurische-allianz.de", true },
  { "avenueeyecare.com", true },
  { "avepol.cz", true },
  { "avepol.eu", true },
  { "averageinspired.com", true },
  { "averam.net", true },
  { "averen.co.uk", true },
  { "avernis.de", true },
  { "avexon.com", true },
  { "avia-krasnoyarsk.ru", true },
  { "avia-ufa.ru", true },
  { "aviapoisk.kz", true },
  { "aviationstrategy.aero", true },
  { "avid.blue", true },
  { "avidmode-dev.com", true },
  { "avidmode-staging.com", true },
  { "avidmode.com", true },
  { "avidthink.com", true },
  { "avietech.com", true },
  { "aviv.nyc", true },
  { "avlhostel.com", true },
  { "avmrc.nl", true },
  { "avnet.ws", true },
  { "avocadooo.stream", true },
  { "avocatbeziau.com", true },
  { "avocode.com", true },
  { "avova.de", true },
  { "avpres.net", true },
  { "avptp.org", true },
  { "avqueen.cn", true },
  { "avs-building-services.co.uk", true },
  { "avsox.com", true },
  { "avticket.ru", false },
  { "avtoforex.ru", true },
  { "avtogara-isperih.com", true },
  { "avtomarket.ru", true },
  { "avtovokzaly.ru", true },
  { "avv.li", true },
  { "avvaterra.ch", true },
  { "avvcorda.com", true },
  { "avvocato.bologna.it", true },
  { "awardplatform.com", true },
  { "awardsplatform.com", true },
  { "awaremi-tai.com", true },
  { "awaresec.com", true },
  { "awaresec.no", true },
  { "awarify.io", true },
  { "awarify.me", true },
  { "awaro.net", true },
  { "awbouncycastlehire.com", true },
  { "awecademy.org", true },
  { "awesomebouncycastles.co.uk", true },
  { "awesomesit.es", true },
  { "awk.tw", true },
  { "awksolutions.com", true },
  { "awningcanopyus.com", true },
  { "awningsaboveus.com", true },
  { "awningsatlantaga.com", true },
  { "awomaninherprime.com", true },
  { "awsmdev.de", true },
  { "awsome-books.co.uk", true },
  { "awxg.com", true },
  { "ax25.org", true },
  { "axchap.ir", true },
  { "axelname.ru", true },
  { "axelteichmann.net", true },
  { "axiatancell.com", true },
  { "axiomer.com", true },
  { "axiomer.es", true },
  { "axiomer.eu", true },
  { "axiomer.me", true },
  { "axiomer.net", true },
  { "axiomer.org", true },
  { "axisfleetmanagement.co.uk", true },
  { "axolotlfarm.org", false },
  { "axon-toumpa.gr", true },
  { "axonholdingse.eu", true },
  { "axre.de", true },
  { "axrec.de", true },
  { "ay-net.jp", true },
  { "ayahya.me", true },
  { "ayanomimi.com", true },
  { "aycomba.de", true },
  { "ayesh.me", true },
  { "aykutcevik.com", true },
  { "aylak.com", true },
  { "aylesburycastlehire.co.uk", true },
  { "aymerick.fr", true },
  { "aymericlagier.com", true },
  { "ayothemes.com", true },
  { "ayrohq.com", true },
  { "ayrshirebouncycastlehire.co.uk", true },
  { "ayumindev.net", true },
  { "ayurveda-mantry.com", true },
  { "az-moga.bg", true },
  { "az.search.yahoo.com", false },
  { "azadliq.info", true },
  { "azane.ga", true },
  { "azarus.ch", true },
  { "azazy.net", false },
  { "azgfd.com", true },
  { "aziende.com.ar", true },
  { "azimut.fr", true },
  { "azizfirat.com", true },
  { "azizvicdan.com", true },
  { "azlk-team.ru", true },
  { "azort.com", true },
  { "azrazalea.net", true },
  { "azso.pro", true },
  { "azsupport.com", true },
  { "aztraslochi.it", true },
  { "aztrix.me", true },
  { "azu-l.com", true },
  { "azu-l.jp", true },
  { "azuki.cloud", true },
  { "azurecrimson.com", true },
  { "azuriasky.com", true },
  { "azuriasky.net", true },
  { "azzorti.com", true },
  { "azzurrapelletterie.it", true },
  { "b-b-law.com", true },
  { "b-boom.nl", true },
  { "b-cyclesshop.ch", true },
  { "b-f-s.pl", true },
  { "b-freerobux.ga", true },
  { "b-landia.net", true },
  { "b-root-force.de", true },
  { "b-services.net", true },
  { "b-ticket.ch", true },
  { "b0k.org", true },
  { "b0rk.com", true },
  { "b1788.net", false },
  { "b1c1l1.com", true },
  { "b1rd.tk", true },
  { "b2and.com", false },
  { "b2bmuzikbank.com", true },
  { "b303.me", true },
  { "b4bouncycastles.co.uk", true },
  { "b4ckbone.de", true },
  { "b4r7.de", true },
  { "b4z.eu", true },
  { "b64.club", true },
  { "b72.com", true },
  { "b72.net", true },
  { "baalsworld.de", true },
  { "baazee.de", true },
  { "babacasino.net", true },
  { "babai.ru", true },
  { "babeleo.com", true },
  { "bablodel.biz", true },
  { "bablodel.com", true },
  { "babsbibs.com", true },
  { "baby-bath-tub.com", true },
  { "baby-digne.com", true },
  { "baby-fotografie-muenchen.de", true },
  { "babybauch-shooting-muenchen.de", true },
  { "babyboom.pl", true },
  { "babycamapp.com", true },
  { "babyfotograf-schweiz.ch", true },
  { "babymasaze.cz", true },
  { "babyphototime.com", true },
  { "babypibu.com", true },
  { "babyshoprimini.com", true },
  { "bachata.info", true },
  { "baches-piscines.com", true },
  { "baciu.ch", true },
  { "backeby.eu", true },
  { "backmountaingas.com", true },
  { "backpacker.dating", true },
  { "backschues.com", true },
  { "backschues.de", true },
  { "backschues.net", true },
  { "backseatbandits.com", true },
  { "backsideverbier.ch", true },
  { "backterris.com", true },
  { "backtest.org", true },
  { "backupcloud.ru", true },
  { "bacon-monitoring.org", true },
  { "baconismagic.ca", true },
  { "bacontreeconsulting.com", true },
  { "bacoux.com", true },
  { "bacsituvansuckhoe.com", true },
  { "bacula.jp", true },
  { "bad.horse", true },
  { "bad.pet", true },
  { "badam.co", true },
  { "badanteinfamiglia.it", true },
  { "badaparda.com", true },
  { "badblock.fr", true },
  { "badboyzclub.de", true },
  { "badf00d.de", true },
  { "badgersystems.de", true },
  { "badges.fedoraproject.org", true },
  { "badges.stg.fedoraproject.org", true },
  { "badgesenpatches.nl", true },
  { "badhusky.com", true },
  { "badlink.org", true },
  { "badmania.fr", true },
  { "badmintonbible.com", true },
  { "badoo.com", true },
  { "badoo.de", true },
  { "badoo.eu", true },
  { "badoo.us", true },
  { "badpackets.net", true },
  { "badrequest.me", true },
  { "badseacoffee.com", true },
  { "baeder-luboss.de", true },
  { "baer.im", false },
  { "baer.one", false },
  { "baer.space", true },
  { "bag.bg", true },
  { "bageez.us", true },
  { "bagelcraft.net", true },
  { "bagelsbakery.com", false },
  { "bageluncle.com", true },
  { "baggy.me.uk", true },
  { "bagheera.me.uk", true },
  { "baglu.com", true },
  { "bagsofbounce.co.uk", true },
  { "bagspecialist.nl", true },
  { "bah.im", false },
  { "bahaiprayers.io", true },
  { "bahnbonus-praemienwelt.de", true },
  { "bahnenimbild.de", true },
  { "bahnenimbild.eu", true },
  { "bahnhelden.de", true },
  { "bahninrotweissrot.at", true },
  { "bahnmagazine.de", true },
  { "baiduo.com", true },
  { "baifubao.com", true },
  { "baiker.info", true },
  { "bailakomigo.com.br", true },
  { "baildonbouncycastles.co.uk", true },
  { "baileebee.com", true },
  { "bailonga.com", true },
  { "baitulongbaycruises.com", true },
  { "baiyangliu.com", true },
  { "bajajfinserv.in", true },
  { "bajic.ch", true },
  { "baka-gamer.net", true },
  { "baka.network", true },
  { "baka.org.cn", true },
  { "bakaproxy.moe", true },
  { "bakermen.com", true },
  { "bakersafari.co", true },
  { "bakeup.be", true },
  { "bakibal.com", true },
  { "bakim.li", true },
  { "bakingstone.com", true },
  { "bakkerinjebuurt.be", true },
  { "balade-commune.ch", true },
  { "baladecommune.ch", true },
  { "balancascia.com.br", true },
  { "balance7.jp", true },
  { "balancedbrawl.net", true },
  { "balancenaturalhealthclinic.ca", true },
  { "balboa.io", true },
  { "balcaonet.com.br", true },
  { "balcarek.pl", true },
  { "balconnr.com", true },
  { "balconsverdun.com", true },
  { "baldur.cc", true },
  { "baldwin.com.au", true },
  { "balia.de", true },
  { "balicekzdravi.cz", true },
  { "balidesignshop.com.br", true },
  { "balikonos.cz", true },
  { "balinese.dating", true },
  { "balist.es", true },
  { "balivillassanur.com", true },
  { "balkonien.org", true },
  { "ball-bizarr.de", true },
  { "ball.holdings", true },
  { "ball3d.es", true },
  { "ballarin.cc", true },
  { "balle.dk", true },
  { "ballejaune.com", true },
  { "balletcenterofhouston.com", true },
  { "ballinarsl.com.au", true },
  { "ballmerpeak.org", true },
  { "ballonsportclub-erlangen.de", true },
  { "ballotapi.com", true },
  { "ballothero.com", true },
  { "ballparkbuns.com", false },
  { "ballroom.info", true },
  { "balmofgilead.org.uk", true },
  { "balslev.io", true },
  { "balticer.de", true },
  { "balticmed.pl", true },
  { "balticnetworks.com", true },
  { "bamahammer.com", true },
  { "bambooforest.nl", true },
  { "bamboorelay.com", true },
  { "bambumania.com.br", true },
  { "bamily.rocks", true },
  { "bananavapes.com", true },
  { "banburybid.com", true },
  { "bancacrs.it", true },
  { "bancaolhares.com.br", true },
  { "bancobai.ao", true },
  { "bancoctt.pt", true },
  { "bancor.network", true },
  { "bandagastrica.es", true },
  { "bandeira1.com.br", true },
  { "bandgap.io", true },
  { "bandiga.it", true },
  { "bandito.re", true },
  { "banes.ch", true },
  { "bangdream.ga", true },
  { "bangkok-dark-night.com", true },
  { "bangkok.dating", true },
  { "bangkokcity.de", true },
  { "bangorfederal.com", false },
  { "bangridho.com", true },
  { "bangumi.co", true },
  { "bangyu.wang", true },
  { "banham.co.uk", true },
  { "banham.com", true },
  { "banjostringiz.com", true },
  { "bank.simple.com", false },
  { "bankbranchlocator.com", true },
  { "bankcardoffer.com", true },
  { "bankee.us", true },
  { "bankerbuch.de", true },
  { "bankersonline.com", true },
  { "banketbesteld.nl", true },
  { "bankgradesecurity.com", true },
  { "bankin.com", true },
  { "bankinter.pt", true },
  { "bankio.se", true },
  { "banknet.gov", true },
  { "bankofdenton.com", true },
  { "bankpolicies.com", true },
  { "banksiaparkcottages.com.au", true },
  { "bankstownapartments.com.au", true },
  { "bankvanbreda.be", true },
  { "banned-bitches.tk", true },
  { "bannermarquees.ie", true },
  { "bannsecurity.com", true },
  { "banquevanbreda.be", true },
  { "banter.city", true },
  { "baobeiglass.com", true },
  { "baofengtech.com", true },
  { "baopublishing.it", true },
  { "baptistedeleris.fr", true },
  { "bar-harcourt.com", true },
  { "barabrume.fr", true },
  { "barans2239.com", true },
  { "baravalle.com", true },
  { "barbarabowersrealty.com", true },
  { "barbarafabbri.com", true },
  { "barbarafeldman.com", true },
  { "barbarians.com", false },
  { "barbate.fr", true },
  { "barberlegalcounsel.com", true },
  { "barbershop-harmony.org", true },
  { "barbershop-lasvillas.com", true },
  { "barbiere.it", true },
  { "barbu.family", true },
  { "barburas.com", true },
  { "barcamp.koeln", true },
  { "barcel.com.mx", true },
  { "barclays.net", true },
  { "barcodeberlin.com", true },
  { "barcoderealty.com", true },
  { "bardes.org", true },
  { "bardiharborow.com", true },
  { "bardiharborow.tk", true },
  { "baresquare.com", true },
  { "baripedia.org", true },
  { "bariseau-mottrie.be", true },
  { "barisi.me", true },
  { "bariskaragoz.nl", true },
  { "baristador.com", true },
  { "barkerjr.xyz", true },
  { "barlex.pl", true },
  { "barlotta.net", true },
  { "barnabycolby.io", true },
  { "barnel.com", true },
  { "barnfotografistockholm.se", true },
  { "barpodsosnami.pl", true },
  { "barracuda.com.tr", true },
  { "barrera.io", true },
  { "barriofut.com", true },
  { "barrydenicola.com", true },
  { "barryswebdesign.co.uk", true },
  { "bars.kh.ua", true },
  { "barsashop.com.br", true },
  { "barsil.de", true },
  { "barslecht.com", true },
  { "barslecht.nl", true },
  { "bart-f.com", true },
  { "barta.me", true },
  { "bartel.ws", true },
  { "bartelt.name", true },
  { "barter4crypto.com", true },
  { "barthonia-showroom.de", true },
  { "bartkramer.nl", true },
  { "bartlamboo.nl", true },
  { "bartolomebellido.com", true },
  { "bartula.de", true },
  { "bartzutow.xyz", true },
  { "baruch.me", true },
  { "bas.co.jp", true },
  { "base-autonome-durable.com", true },
  { "baseballrampage.com", true },
  { "baseballsavings.com", true },
  { "baseballwarehouse.com", true },
  { "baseconvert.com", true },
  { "basedonline.nl", true },
  { "baselang.com", true },
  { "baseline.ba", true },
  { "basementdoctor.com", true },
  { "basementdoctornorthwest.com", true },
  { "basementfinishingohio.com", true },
  { "basementwaterproofingdesmoines.com", true },
  { "baserverz.ga", true },
  { "bashing-battlecats.com", true },
  { "bashstreetband.co.uk", true },
  { "basicapparel.de", true },
  { "basicattentiontoken.org", true },
  { "basketball-brannenburg.de", true },
  { "basnoslovno.com.ua", false },
  { "basnoslovno.ru", true },
  { "basonlinemarketing.nl", true },
  { "bass-pro.ru", true },
  { "bassblog.net", true },
  { "bassment.ph", true },
  { "bassresource.com", true },
  { "bassrider.eu", true },
  { "bassys.com.co", true },
  { "bastelzauberwelt.de", true },
  { "bastianstalder.ch", true },
  { "bastiv.com", true },
  { "bastolino.de", true },
  { "basw.eu", true },
  { "baswetter.photography", true },
  { "basyspro.net", true },
  { "batcave.tech", true },
  { "batch.com", true },
  { "bati-alu.fr", true },
  { "batiburrillo.net", true },
  { "batipresta.ch", true },
  { "batistareisfloresonline.com.br", true },
  { "batlab.ch", true },
  { "batolis.com", true },
  { "batook.org", true },
  { "batschu.de", true },
  { "batterystaple.pw", true },
  { "battle-game.com", true },
  { "battleboxx.com", false },
  { "battleofthegridiron.com", true },
  { "bauer.network", true },
  { "bauernmarkt-fernitz.at", true },
  { "baugeldspezi.de", true },
  { "baugemeinschaftbernstein.de", true },
  { "baumannfabrice.com", true },
  { "baur.de", true },
  { "bausep.de", true },
  { "baustils.com", true },
  { "bauthier-occasions.be", true },
  { "bautied.de", true },
  { "bauunternehmen-herr.de", true },
  { "bauwens.cloud", true },
  { "bavartec.de", true },
  { "bayareaenergyevents.com", true },
  { "baychimo.com", true },
  { "bayden.com", true },
  { "bayer-stefan.com", true },
  { "bayer-stefan.de", true },
  { "bayer-stefan.eu", true },
  { "bayerhazard.de", true },
  { "bayerstefan.com", true },
  { "bayerstefan.de", true },
  { "bayerstefan.eu", true },
  { "bayherbalist.com", true },
  { "bayilelakiku.com", true },
  { "baykatre.com", true },
  { "bayly.eu", true },
  { "baymard.com", true },
  { "bayportbotswana.com", true },
  { "bayportfinance.com", true },
  { "bayportghana.com", true },
  { "bayporttanzania.com", true },
  { "bayportuganda.com", true },
  { "bayportzambia.com", true },
  { "baytalebaa.com", true },
  { "baywatch.io", true },
  { "bayz.de", true },
  { "bazaarbhaav.com", true },
  { "bazaarcompass.com", true },
  { "bazdell.com", true },
  { "bazos.at", true },
  { "bazos.cz", true },
  { "bazos.pl", true },
  { "bazos.sk", true },
  { "bazziergraphik.com", true },
  { "bb1718.net", true },
  { "bb37roma.it", true },
  { "bbalposticino.it", true },
  { "bbcastles.com", true },
  { "bbgeschenke.ch", true },
  { "bbimarketing.com", true },
  { "bbinsure.com", true },
  { "bbka.org.uk", true },
  { "bbkaforum.co.uk", true },
  { "bbkworldwide.jp", true },
  { "bbld.de", true },
  { "bblove.me", true },
  { "bblsa.ch", true },
  { "bbnbb.de", true },
  { "bbnx.net", true },
  { "bbuio.com", false },
  { "bbw.dating", true },
  { "bbwcs.co.uk", true },
  { "bc-bd.org", false },
  { "bc-diffusion.com", true },
  { "bcansw.com.au", true },
  { "bcbulle.ch", true },
  { "bcdonadio.com", true },
  { "bcdonadio.com.br", true },
  { "bcdonadio.org", true },
  { "bceventhire.co.uk", true },
  { "bch7al.ma", true },
  { "bchep.com", true },
  { "bck-koethen.de", true },
  { "bck-lelystad.nl", true },
  { "bck.me", true },
  { "bckaccompressoroz.com", true },
  { "bclogandtimberbuilders.com", true },
  { "bclrk.us", true },
  { "bcmainland.ca", true },
  { "bcmguide.com", true },
  { "bcmhire.co.uk", true },
  { "bcpc-ccgpfcheminots.com", true },
  { "bcrook.com", true },
  { "bcs.adv.br", true },
  { "bcswampcabins.com", true },
  { "bcyw56.live", true },
  { "bd2positivo.com", true },
  { "bda-boulevarddesairs.com", true },
  { "bdbxml.net", true },
  { "bdd.fi", true },
  { "bdpachicago.tech", true },
  { "bdvg.org", true },
  { "be-a-password.ninja", true },
  { "be-ka-tec.de", true },
  { "be-real.life", false },
  { "be-up-developpement.com", true },
  { "be-webdesign.com", true },
  { "be.search.yahoo.com", false },
  { "be2cloud.de", true },
  { "beacham.online", true },
  { "beachcitycastles.com", true },
  { "beachfutbolclub.com", true },
  { "beadare.com", true },
  { "beadare.nl", true },
  { "beaglesecurity.com", true },
  { "bealpha.pl", true },
  { "beamer-discount.de", true },
  { "beamstat.com", true },
  { "beanbagaa.com", true },
  { "beanilla.com", true },
  { "beanjuice.me", true },
  { "beans-one.com", false },
  { "bearcms.com", true },
  { "bearcosports.com.br", true },
  { "bearded.sexy", true },
  { "beardic.cn", true },
  { "bearingworks.com", true },
  { "beastiejob.com", true },
  { "beastowner.li", true },
  { "beatfeld.de", true },
  { "beatnikbreaks.com", true },
  { "beatrizaebischer.ch", true },
  { "beaumelcosmetiques.fr", true },
  { "beaute-eternelle.ch", true },
  { "beauty-hippie-schmuck.de", true },
  { "beauty-italy.ru", true },
  { "beauty-yan-enterprise.com", true },
  { "beauty24.de", true },
  { "beautybear.dk", true },
  { "beautyby.tv", true },
  { "beautyevent.fr", true },
  { "beautykat.ru", true },
  { "beaverdamautos.com", true },
  { "bebef.de", true },
  { "bebefofuxo.com.br", true },
  { "bebes.uno", true },
  { "bebest.gov", false },
  { "bebetrotteur.com", true },
  { "bebout.domains", true },
  { "bebout.pw", true },
  { "beckenhamcastles.co.uk", true },
  { "beckerantiques.com", true },
  { "beckon.com", true },
  { "becs.ch", true },
  { "becydog.cz", true },
  { "bedamedia.com", true },
  { "bedandbreakfast.dk", true },
  { "bedandbreakfasteuropa.com", true },
  { "bedandbreakfasthoekvanholland.com", true },
  { "bedels.nl", true },
  { "bedfordnissanparts.com", true },
  { "bednar.co", true },
  { "bedrijfsfotoreportages.nl", true },
  { "bedrijfsportaal.nl", true },
  { "bedrocklinux.org", true },
  { "bedste10.dk", true },
  { "bee-creative.nl", true },
  { "bee-line.org.uk", true },
  { "bee.clothing", true },
  { "bee.tools", true },
  { "beechwoodmetalworks.com", true },
  { "beehive.govt.nz", true },
  { "beehive42.com", true },
  { "beehive42.eu", true },
  { "beehive42.net", true },
  { "beehive42.nl", true },
  { "beehive42.org", true },
  { "beehosting.pro", true },
  { "beekbier.nl", true },
  { "beekeeper.blog", true },
  { "beekeeper.clothing", true },
  { "beekeeper.supplies", true },
  { "beekeeper.supply", true },
  { "beekeeper.tools", true },
  { "beekeeping.clothing", true },
  { "beekeeping.tools", true },
  { "beeksnetwork.nl", true },
  { "beelen.fr", true },
  { "beelit.com", true },
  { "beeming.net", true },
  { "beer9.com", true },
  { "beercandle.com", true },
  { "beergazetteer.com", true },
  { "beerians.com", true },
  { "beerjet.bg", true },
  { "beerjet.cz", true },
  { "beerjet.ro", true },
  { "beerjet.sk", true },
  { "beerjetcz.cz", true },
  { "beerly.eu", true },
  { "beerradar.no", true },
  { "beerradar.party", true },
  { "beersconf.com", true },
  { "beerview.ga", true },
  { "beeswax-orgone.com", true },
  { "beethoveninlove.com", true },
  { "beetman.net", true },
  { "beeutifulparties.co.uk", true },
  { "beexfit.com", true },
  { "beezkneezcastles.co.uk", true },
  { "beeznest.com", true },
  { "befoodsafe.gov", true },
  { "beforeyoueatoc.com", true },
  { "beframed.ch", true },
  { "befreewifi.info", true },
  { "befundonline.de", true },
  { "begabungsfoerderung.info", true },
  { "begbie.com", true },
  { "beginatzero.com", true },
  { "beginner.nl", true },
  { "beginwp.top", true },
  { "behamepresrdce.sk", true },
  { "behamzdarma.cz", true },
  { "behindthethrills.com", true },
  { "behna24hodin.cz", true },
  { "behoerden-online-dienste.de", true },
  { "behoreal.cz", true },
  { "bei18.com", true },
  { "beichtgenerator.de", true },
  { "beijing.dating", true },
  { "beijinglug.club", true },
  { "beimchristoph.de", true },
  { "beinad.com", true },
  { "beinad.ru", true },
  { "beisance.com", true },
  { "bejarano.io", true },
  { "belacapa.com.br", true },
  { "belanglos.de", true },
  { "belani.eu", true },
  { "belarto.be", true },
  { "belarto.de", true },
  { "belarto.es", true },
  { "belarto.fr", true },
  { "belarto.it", true },
  { "belarto.nl", true },
  { "belarto.pl", true },
  { "belastingdienst-in-beeld.nl", false },
  { "belastingmiddeling.nl", true },
  { "belavis.com", true },
  { "beleggingspanden-financiering.nl", true },
  { "belegit.org", true },
  { "belfastbounce.co.uk", true },
  { "belfastlocks.com", true },
  { "belfasttechservices.co.uk", true },
  { "belge.rs", true },
  { "belgers.com", true },
  { "belhopro.be", true },
  { "belics.com", true },
  { "belien-tweedehandswagens.be", true },
  { "believablebook.com", false },
  { "believersweb.org", true },
  { "bell.id.au", true },
  { "bella.network", true },
  { "bellaklein.de", true },
  { "bellamodeling.com", true },
  { "bellinghamdetailandglass.com", true },
  { "belloy.ch", true },
  { "belloy.net", true },
  { "bellthrogh.com", true },
  { "bellthrough.com", true },
  { "belly-button-piercings.com", true },
  { "bellyandbrain.amsterdam", true },
  { "belmontgoessolar.org", true },
  { "belouga.org", true },
  { "belt.black", true },
  { "belvoirbouncycastles.co.uk", true },
  { "bely-mishka.by", true },
  { "belyvly.com", true },
  { "bemcorp.de", true },
  { "bemindly.com", true },
  { "bemsoft.pl", true },
  { "ben-energy.com", false },
  { "ben-jarvis.co.uk", true },
  { "ben-stock.de", true },
  { "ben.ninja", true },
  { "ben2.co.il", true },
  { "benabrams.it", true },
  { "benary.org", true },
  { "benbozsa.ca", true },
  { "benburwell.com", true },
  { "benc.io", true },
  { "benceskorka.com", true },
  { "benchling.com", true },
  { "benchmarkmonument.com", true },
  { "benchstoolo.com", true },
  { "bencorby.com", true },
  { "bendemaree.com", true },
  { "bendigoland.com.au", true },
  { "bendix.co", true },
  { "bendyworks.com", true },
  { "beneathvt.com", true },
  { "benedict-balzer.de", true },
  { "benepiscinas.com.br", true },
  { "beneri.se", true },
  { "benevita.bio", true },
  { "benewpro.com", true },
  { "bengalurugifts.com", true },
  { "bengisureklam.com", true },
  { "benhaney.com", true },
  { "benhartmann.de", true },
  { "benhavenarchives.org", true },
  { "benjamin-hering.com", true },
  { "benjamin.pe", true },
  { "benjaminblack.net", true },
  { "benjamindietrich.de", true },
  { "benjaminjurke.com", true },
  { "benjaminkopelke.com", true },
  { "benjaminpiquet.fr", true },
  { "benjamins.com", true },
  { "benjaminvasel.de", true },
  { "benjii.me", true },
  { "benleemd.com", true },
  { "benmatthews.com.au", true },
  { "benmillett.us", false },
  { "benmorecentre.co.uk", true },
  { "bennettsbouncycastlehire.co.uk", true },
  { "bennettshire.co.uk", true },
  { "benni1.eu", true },
  { "bennierobinson.com", true },
  { "bennink.me", true },
  { "benno.frl", true },
  { "bennygommers.nl", true },
  { "bennythink.com", true },
  { "benriya.shiga.jp", true },
  { "bensbouncycastles.co.uk", true },
  { "benschnarr.com", true },
  { "benscobie.com", true },
  { "benshoof.org", true },
  { "bensinflatables.co.uk", true },
  { "bentertain.de", true },
  { "bentley.blog", true },
  { "bentley.link", true },
  { "bentongroup.co.uk", true },
  { "bentonweatherstone.co.uk", true },
  { "bentrask.com", true },
  { "benz-hikaku.com", true },
  { "benzi.io", true },
  { "beoordelingen.be", true },
  { "bepenak.com", true },
  { "bephoenix.org.uk", true },
  { "bequiia.com", true },
  { "beranovi.com", true },
  { "berasavocate.com", true },
  { "bergenhave.nl", true },
  { "berger-chiro.com", true },
  { "bergevoet-fa.nl", true },
  { "bergfreunde.de", true },
  { "bergfreunde.dk", true },
  { "bergfreunde.es", true },
  { "bergfreunde.eu", true },
  { "bergfreunde.fi", true },
  { "bergfreunde.it", true },
  { "bergfreunde.nl", true },
  { "bergfreunde.no", true },
  { "bergfreunde.se", true },
  { "berglust-pur.de", true },
  { "bergmanbeachproperties.com", true },
  { "bergmann-fotografin-berlin.de", true },
  { "bergmann-fotografin-dortmund.de", true },
  { "bergmann-fotografin-duesseldorf.de", true },
  { "bergmann-fotografin-essen.de", true },
  { "bergmann-fotografin-frankfurt.de", true },
  { "bergmann-fotografin-hamburg.de", true },
  { "bergmann-fotografin-koeln.de", true },
  { "bergmann-fotografin-muenchen.de", true },
  { "bergmann-fotografin-stuttgart.de", true },
  { "bergstoneware.com", true },
  { "berichtsheft-vorlage.de", true },
  { "berikod.ru", true },
  { "berlin-flirt.de", true },
  { "berlin.dating", true },
  { "bermeitinger.eu", true },
  { "berna.fr", true },
  { "bernadetteanderes.ch", true },
  { "bernardcontainers.be", true },
  { "bernarddickens.com", true },
  { "bernardez-photo.com", true },
  { "bernardfischer.fr", true },
  { "bernardgo.com", true },
  { "bernardo.fm", true },
  { "bernat.ch", true },
  { "bernat.im", true },
  { "bernd-leitner-fotodesign.com", true },
  { "bernd-leitner-fotodesign.de", true },
  { "bernd-leitner.de", true },
  { "berndklaus.at", true },
  { "bernhard-seidenspinner.de", true },
  { "bernhardkau.de", true },
  { "bernhardluginbuehl.ch", true },
  { "bernhardluginbuehl.com", true },
  { "berodes.be", true },
  { "berr.yt", true },
  { "berra.se", true },
  { "berruezoabogados.com", true },
  { "berrus.com", true },
  { "berry.cat", true },
  { "berrypay.com", true },
  { "bersierservices.ch", true },
  { "bersotavocats.fr", true },
  { "berst.cz", true },
  { "berthabailey.com", true },
  { "bertholdsson.com", true },
  { "bertold.org", true },
  { "bertoliniodontoiatria.it", true },
  { "bertrand.bio", true },
  { "bertrandkeller.info", true },
  { "bertsmithvwparts.com", true },
  { "beryl.net", true },
  { "besb.io", true },
  { "besb66.com", true },
  { "beschriftung-metz.de", true },
  { "bescover.com", true },
  { "beserberg.tk", true },
  { "besole.ch", true },
  { "bespaarenergie.click", true },
  { "bespokestraps.com", true },
  { "besser-beissen.de", true },
  { "bessettenotaire.com", true },
  { "best-accounting-schools.com", true },
  { "best-art-colleges.com", true },
  { "best-baptist-colleges.com", true },
  { "best-beauty-schools.com", true },
  { "best-business-colleges.com", true },
  { "best-catholic-colleges.com", true },
  { "best-community-colleges.com", true },
  { "best-culinary-colleges.com", true },
  { "best-education-schools.com", true },
  { "best-engineering-colleges.com", true },
  { "best-essay-service.com", true },
  { "best-graduate-programs.com", true },
  { "best-hvac-schools.com", true },
  { "best-lutheran-colleges.com", true },
  { "best-management-schools.com", true },
  { "best-marketing-schools.com", true },
  { "best-music-colleges.com", true },
  { "best-nursing-colleges.com", true },
  { "best-pharmacy-schools.com", true },
  { "best-tickets.co.uk", true },
  { "best-trucking-schools.com", true },
  { "best-wallpaper.net", true },
  { "best10websitebuilders.com", true },
  { "best2pay.net", true },
  { "best66.me", true },
  { "bestattungen-kammerer.de", true },
  { "bestattungshaus-kammerer.de", true },
  { "bestautoinsurance.com", true },
  { "bestbatteriesonline.com", true },
  { "bestbefore.com", true },
  { "bestbrakes.com", true },
  { "bestbridal.top", true },
  { "bestbyte.com.br", true },
  { "bestcellular.com", false },
  { "bestdating.today", false },
  { "bestdownloadscenter.com", true },
  { "bestelectricnd.com", true },
  { "bestemailmarketingsoftware.org", true },
  { "bestessaycheap.com", true },
  { "bestessayhelp.com", true },
  { "bestfriendsequality.org", true },
  { "bestgiftever.ca", true },
  { "bestgifts4you.com", true },
  { "bestinductioncooktop.us", true },
  { "bestinshowing.com", true },
  { "bestinver.es", true },
  { "bestjumptrampolines.be", true },
  { "bestkenmoredentists.com", true },
  { "bestlashesandbrows.com", true },
  { "bestlashesandbrows.hu", true },
  { "bestmotherfucking.website", true },
  { "bestoffert.club", true },
  { "bestoliveoils.com", true },
  { "bestpal.eu", true },
  { "bestpartyhire.com", true },
  { "bestperfumebrands.com", true },
  { "bestpig.fr", true },
  { "bestplumbing.com", true },
  { "bestschools.io", true },
  { "bestschools.top", true },
  { "bestseries.tv", true },
  { "bestshoesmix.com", true },
  { "bestwebsite.gallery", true },
  { "betaal.my", true },
  { "betacavi.com", true },
  { "betacloud.io", true },
  { "betaclouds.net", true },
  { "betalenviainternet.nl", true },
  { "betaprofiles.com", true },
  { "betaworx.de", true },
  { "betaworx.eu", true },
  { "betecnet.de", true },
  { "bethpage.net", true },
  { "betleakbot.com", true },
  { "betobaccofree.gov", true },
  { "betonbit.com", true },
  { "betpamm.com", true },
  { "betrallyarabia.com", true },
  { "bets.gg", true },
  { "betseybuckheit.com", true },
  { "betsharpangles.com", true },
  { "betsyshilling.com", true },
  { "bett1.de", true },
  { "better-bounce.co.uk", true },
  { "better.com", true },
  { "better.fyi", true },
  { "betterbabyshop.com.au", true },
  { "betterconsult.com", true },
  { "bettercrypto.org", true },
  { "betterhelp.com", true },
  { "betterjapanese.blog", true },
  { "betterjapanese.com", true },
  { "betterjapanese.org", true },
  { "betterjapanese.xyz", true },
  { "betterna.me", true },
  { "betterscience.org", true },
  { "bettertechinterviews.com", true },
  { "bettertest.it", true },
  { "bettertime.de", true },
  { "bettertime.jetzt", true },
  { "betterweb.fr", true },
  { "betterworldinternational.org", true },
  { "bettflaschen.ch", true },
  { "bettingbusiness.ru", true },
  { "bettingsider.dk", true },
  { "bettolinokitchen.com", true },
  { "bettrlifeapp.com", true },
  { "betulashop.ch", true },
  { "betwalker.com", true },
  { "beulen.email", true },
  { "beulen.link", true },
  { "beulen.pro", true },
  { "beuteugeu.com", true },
  { "bevedo.cz", true },
  { "beveiligingscamerawestland.nl", true },
  { "bevelpix.com", true },
  { "beverlyinternational.com", true },
  { "bevinco2020.com", true },
  { "bevinsco.org", true },
  { "bevnut.com", true },
  { "bewegungsfluss.com", false },
  { "bewerbungsfoto-deinfoto.ch", true },
  { "bewonderen.com", true },
  { "bexit.nl", true },
  { "bexleycastles.co.uk", true },
  { "beybiz.com", true },
  { "beyerautomation.com", true },
  { "beyond-infinity.org", false },
  { "beyond-rational.com", true },
  { "beyondalderaan.net", true },
  { "beyondbounce.co.uk", true },
  { "beyondpricing.com", true },
  { "beyondthecode.io", true },
  { "beyondtodaymediagroup.com", true },
  { "beyondtrust.com", true },
  { "beyondweb.net", true },
  { "beyonic.com", true },
  { "beyours.be", true },
  { "bezemkast.nl", true },
  { "bezpecnostsiti.cf", true },
  { "bezr.co.uk", true },
  { "bezzia.com", true },
  { "bf7088.com", true },
  { "bf7877.com", true },
  { "bfam.tv", true },
  { "bfem.gov", true },
  { "bfgcdn.com", true },
  { "bfi.wien", false },
  { "bflix.tv", true },
  { "bforb.sk", true },
  { "bfpg.org", true },
  { "bft-media.com", true },
  { "bftbradio.com", true },
  { "bfw-online.de", true },
  { "bgbhsf.top", true },
  { "bgeo.io", true },
  { "bgfoto.info", true },
  { "bghost.xyz", true },
  { "bgkoleda.bg", true },
  { "bglsingles.de", true },
  { "bgp.space", true },
  { "bgr34.cz", true },
  { "bgs-game.com", true },
  { "bgtgames.com", true },
  { "bgtoyou.com", true },
  { "bguidinger.com", true },
  { "bgwfans.com", true },
  { "bh-oberland.de", true },
  { "bh.sb", true },
  { "bharath-g.in", true },
  { "bhodisoft.com", true },
  { "bhost.net", true },
  { "bhtelecom.ba", true },
  { "bhuntr.com", true },
  { "bhxch.moe", true },
  { "bi.search.yahoo.com", false },
  { "biaggeo.com", true },
  { "biancolievito.it", true },
  { "biano-ai.com", true },
  { "biasmath.es", true },
  { "bible-maroc.com", true },
  { "bible.ru", true },
  { "bibleonline.ru", true },
  { "bibliaon.com", true },
  { "biblio.wiki", true },
  { "biblioblog.fr", true },
  { "bibliomarkt.ch", true },
  { "biblionaut.net", true },
  { "biblioporn.com", true },
  { "bibliotekarien.se", true },
  { "biboumail.fr", true },
  { "bibuch.com", true },
  { "bicecontracting.com", true },
  { "bicha.net", true },
  { "bicifanaticos.com", true },
  { "bicranial.io", true },
  { "bicycle-events.com", true },
  { "bicycleframeiz.com", true },
  { "biddl.com", true },
  { "biddle.co", true },
  { "bidman.cz", true },
  { "bidman.eu", true },
  { "bidu.com.br", true },
  { "bie.edu", false },
  { "biegal.ski", true },
  { "biegner-technik.de", true },
  { "biehl.tech", true },
  { "biehlsoft.info", true },
  { "bielefailed.de", true },
  { "bien-etre-sante.info", true },
  { "bienici.com", true },
  { "bienoubien.org", true },
  { "biensenvue.com", true },
  { "bienstar.tv", true },
  { "bierbaumer.net", true },
  { "biergaizi.info", true },
  { "bieser.ch", true },
  { "biester.pro", true },
  { "bieumau.net", true },
  { "bifrost.cz", true },
  { "biftin.net", true },
  { "big-andy.co.uk", true },
  { "big-bounce.co.uk", true },
  { "big-fluglaerm-hamburg.de", true },
  { "bigbendguide.com", true },
  { "bigbluedoor.net", true },
  { "bigbouncebouncycastles.co.uk", true },
  { "bigbouncetheory.co.uk", true },
  { "bigbounceuk.com", true },
  { "bigbrotherawards.nl", true },
  { "bigcakes.dk", true },
  { "bigclassaction.com", true },
  { "bigdinosaur.org", true },
  { "biggreenexchange.com", true },
  { "bigideasnetwork.com", true },
  { "bigio.com.br", true },
  { "biglou.com", false },
  { "bignumworks.com", true },
  { "bigorbitgallery.org", true },
  { "bigserp.com", true },
  { "bigsisterchannel.com", true },
  { "bigskylifestylerealestate.com", true },
  { "bigskymontanalandforsale.com", true },
  { "bigwiseguide.com", true },
  { "bihub.io", true },
  { "biilo.com", true },
  { "bijouxcherie.com", true },
  { "biju-neko.jp", true },
  { "bike-discount.de", true },
  { "bike-kurse.ch", true },
  { "bike-shack.com", true },
  { "bikebay.it", true },
  { "bikehistory.org", true },
  { "biker.dating", true },
  { "bikerebel.com", true },
  { "bikeshopitalia.com", true },
  { "bikiniatoll.com", true },
  { "bikiniseli.com", true },
  { "bikkelbroeders.com", false },
  { "bikkelbroeders.nl", false },
  { "bilalic.com", true },
  { "bilalkilic.de", true },
  { "bilbayt.com", true },
  { "bilder-designs.de", true },
  { "bildiri.ci", true },
  { "bildkomponist.de", true },
  { "bildschirmflackern.de", true },
  { "biletru.net", true },
  { "biletyplus.by", true },
  { "biletyplus.com", true },
  { "biletyplus.ua", true },
  { "bilgo.com", true },
  { "bilibili.link", true },
  { "bilimoe.com", true },
  { "bilke.org", true },
  { "billaud.eu.org", true },
  { "billgoldstein.name", true },
  { "billhartzer.com", true },
  { "billiger-mietwagen.de", true },
  { "billigerfinder.de", true },
  { "billigpoker.dk", true },
  { "billin.net", true },
  { "billionaire365.com", true },
  { "billionairemailinglist.com", false },
  { "billionkiaparts.com", true },
  { "billkochman.com", true },
  { "billogram.com", true },
  { "billpro.com", false },
  { "billrhodesbakery.com", true },
  { "billsqualityautocare.com", true },
  { "billy.pictures", true },
  { "billyoh.com", true },
  { "billysbouncycastlehire.co.uk", true },
  { "billywig.stream", true },
  { "biloplysninger.dk", true },
  { "bilsho.com", true },
  { "biltullen.com", true },
  { "bimbo.com", false },
  { "bimbo.com.ar", false },
  { "bimbobakeriesusa.com", false },
  { "bimmerlabs.com", true },
  { "bin95.com", true },
  { "bina.az", true },
  { "binans.co", true },
  { "binans.com", true },
  { "binans.com.tr", true },
  { "binans.io", true },
  { "binans.net", true },
  { "binans.xyz", true },
  { "binarization.com", true },
  { "binaryapparatus.com", true },
  { "binaryappdev.com", true },
  { "binarycreations.scot", true },
  { "binarydream.fi", true },
  { "binaryrebel.net", true },
  { "binarystud.io", true },
  { "binding-problem.com", true },
  { "binfind.com", true },
  { "bing.com", true },
  { "bingobank.org", true },
  { "binhex.net", true },
  { "binkconsulting.be", true },
  { "binnenmeer.de", true },
  { "binsp.net", true },
  { "bintangsyurga.com", true },
  { "bintelligence.info", true },
  { "bintelligence.nl", true },
  { "binti.com", true },
  { "bintooshoots.com", true },
  { "bio-disinfestazione.it", true },
  { "bio-feed.org", true },
  { "bio24.si", true },
  { "bioatelier.it", true },
  { "biobuttons.ch", true },
  { "biocheminee.com", true },
  { "biodiagnostiki.clinic", true },
  { "biodieseldata.com", true },
  { "biodots.at", true },
  { "biodots.eu", true },
  { "biodots.info", true },
  { "biodots.it", true },
  { "bioemsan.cz", true },
  { "bioequivalence.design", true },
  { "bioetco.ch", true },
  { "bioexploratorium.pl", true },
  { "biogecho.ch", true },
  { "biogecho.swiss", true },
  { "biogeist.de", true },
  { "biogeniq.ca", true },
  { "biohappiness.com", true },
  { "bioharmony.ca", true },
  { "biointelligence-explosion.com", true },
  { "bioknowme.com", true },
  { "bioleev.sklep.pl", true },
  { "bioligo.ch", true },
  { "biologis.ch", true },
  { "biology-colleges.com", true },
  { "biomag.it", true },
  { "biomasscore.com", true },
  { "biomed-hospital.ch", true },
  { "biomed.ch", true },
  { "biometrics.es", true },
  { "biomodra.cz", true },
  { "biopsychiatry.com", true },
  { "bioresonanz-ibiza.com", true },
  { "biosafe.ch", true },
  { "biosbits.org", true },
  { "bioshine.com.sg", true },
  { "biosignalanalytics.com", true },
  { "biosphere.cc", true },
  { "biospw.com", true },
  { "biotechware.com", true },
  { "biotin.ch", true },
  { "bipyo.com", true },
  { "birbaumer.li", true },
  { "birchbarkfurniture.ch", true },
  { "birchbarkfurniture.com", true },
  { "birchbarkfurniture.fr", true },
  { "birdbrowser.com", true },
  { "birdfeeder.online", true },
  { "birdiehosting.nl", true },
  { "birdslabel.com", true },
  { "birdymanbestreviews.com", true },
  { "birgerschwarz.de", true },
  { "birgit-rydlewski.de", true },
  { "birgitandmerlin.com", true },
  { "birkenstab.de", true },
  { "birkhoff.me", true },
  { "birminghamcastlehire.co.uk", true },
  { "birminghamsunset.com", true },
  { "birthdaytip.com", true },
  { "birthmatters.us", true },
  { "birthright.website", true },
  { "birzan.org", true },
  { "bisa-sis.net", true },
  { "bischoff-mathey.family", true },
  { "biscoint.io", true },
  { "biscuitcute.com.br", true },
  { "biser-borisov.eu", true },
  { "biso.ga", true },
  { "bison.co", true },
  { "bisq.community", true },
  { "bissalama.org", true },
  { "bisschopssteeg.nl", true },
  { "bistrocean.com", true },
  { "bistroservice.de", true },
  { "bistrotdelagare.fr", true },
  { "bit-cloud.de", true },
  { "bit-rapid.com", true },
  { "bit-sentinel.com", true },
  { "bit-service-aalter.be", true },
  { "bit.biz.tr", true },
  { "bit8.com", true },
  { "bitaccelerate.com", true },
  { "bitbank.cc", true },
  { "bitbeans.de", true },
  { "bitbox.me", true },
  { "bitbucket.com", true },
  { "bitbucket.io", true },
  { "bitbucket.org", true },
  { "bitburner.de", true },
  { "bitcalt.eu.org", true },
  { "bitcalt.ga", true },
  { "bitchigo.com", true },
  { "bitcoin-india.net", true },
  { "bitcoin-india.org", true },
  { "bitcoin.asia", true },
  { "bitcoin.ch", true },
  { "bitcoin.co.nz", true },
  { "bitcoin.de", true },
  { "bitcoin.im", true },
  { "bitcoin.info", true },
  { "bitcoin.org", true },
  { "bitcoin.us", true },
  { "bitcoinbitcoin.com", true },
  { "bitcoincore.org", true },
  { "bitcoinfees.net", true },
  { "bitcoinindia.com", true },
  { "bitcoinkarlsruhe.de", true },
  { "bitcoinrealestate.com.au", true },
  { "bitcointhefts.com", true },
  { "bitcoinwalletscript.tk", true },
  { "bitcoinx.gr", true },
  { "bitcoinx.ro", true },
  { "bitcork.io", true },
  { "bitcqr.io", true },
  { "bitex.la", true },
  { "bitfasching.de", false },
  { "bitfehler.net", true },
  { "bitfence.io", true },
  { "bitfinder.nl", true },
  { "bitfolio.org", true },
  { "bitfuse.net", true },
  { "bitgo.com", true },
  { "bitgrapes.com", true },
  { "bithap.com", true },
  { "bithir.co.uk", true },
  { "bititrain.com", true },
  { "bitlish.com", true },
  { "bitlo.com", true },
  { "bitlo.com.tr", true },
  { "bitlo.io", true },
  { "bitlo.org", true },
  { "bitmainwarranty.com", true },
  { "bitmarket.net", true },
  { "bitmarket.pl", true },
  { "bitmask.me", true },
  { "bitmessage.ch", true },
  { "bitmidi.com", true },
  { "bitminter.com", true },
  { "bitmoe.com", true },
  { "bitok.com", true },
  { "bitpoll.de", true },
  { "bitpoll.org", true },
  { "bitpumpe.net", true },
  { "bitref.com", true },
  { "bitrush.nl", true },
  { "bits-hr.de", true },
  { "bitsafe.com.my", true },
  { "bitsburg.ru", true },
  { "bitski.com", true },
  { "bitskins.co", true },
  { "bitskrieg.net", true },
  { "bitso.com", true },
  { "bitsoffreedom.nl", true },
  { "bitstep.ca", true },
  { "bitstorm.nl", true },
  { "bitstorm.org", true },
  { "bitsum.com", true },
  { "bitsy.com", true },
  { "bitsync.nl", true },
  { "bitten.pw", true },
  { "bittersweetcandybowl.com", true },
  { "bittylicious.com", true },
  { "bitvest.io", true },
  { "bitwarden.com", true },
  { "bitwolk.nl", true },
  { "bitxel.com.co", true },
  { "biupay.com.br", true },
  { "biurokarier.edu.pl", true },
  { "bixservice.com", true },
  { "biyori.moe", true },
  { "biyou-homme.com", true },
  { "biz4x.com", true },
  { "bizbudding.com", true },
  { "bizcash.co.za", true },
  { "bizeau.ch", true },
  { "bizniskatalog.mk", true },
  { "biznpro.ru", true },
  { "bizstarter.cz", true },
  { "biztera.com", true },
  { "biztok.eu", true },
  { "biztouch.work", true },
  { "bjarnerest.de", true },
  { "bjmgeek.science", true },
  { "bjmun.cn", true },
  { "bjolanta.pl", true },
  { "bjornhelmersson.se", true },
  { "bjornjohansen.no", true },
  { "bjs.gov", true },
  { "bjsbouncycastles.com", true },
  { "bkentertainments.co.uk", true },
  { "bkhpilates.co.uk", true },
  { "bkkposn.com", true },
  { "bklaindia.com", true },
  { "bkositspartytime.co.uk", true },
  { "bl4ckb0x.biz", true },
  { "bl4ckb0x.com", true },
  { "bl4ckb0x.de", true },
  { "bl4ckb0x.eu", true },
  { "bl4ckb0x.info", true },
  { "bl4ckb0x.net", true },
  { "bl4ckb0x.org", true },
  { "blaauwgeers.pro", true },
  { "blabber.im", true },
  { "blablacar.co.uk", true },
  { "blablacar.com", true },
  { "blablacar.com.tr", true },
  { "blablacar.com.ua", true },
  { "blablacar.de", true },
  { "blablacar.es", true },
  { "blablacar.fr", true },
  { "blablacar.hr", true },
  { "blablacar.hu", true },
  { "blablacar.in", true },
  { "blablacar.it", true },
  { "blablacar.mx", true },
  { "blablacar.nl", true },
  { "blablacar.pl", true },
  { "blablacar.pt", true },
  { "blablacar.ro", true },
  { "blablacar.rs", true },
  { "blablacar.ru", true },
  { "black-khat.com", true },
  { "black-mail.nl", true },
  { "black-pool.net", true },
  { "black-raven.fr", true },
  { "black.dating", true },
  { "black.host", true },
  { "blackandpony.de", true },
  { "blackbag.nl", true },
  { "blackbase.de", true },
  { "blackbird-whitebird.com", true },
  { "blackcat.ca", true },
  { "blackcatinformatics.ca", true },
  { "blackcatinformatics.com", true },
  { "blackcicada.com", true },
  { "blackdotbrewery.com", true },
  { "blackdown.de", true },
  { "blackedbyte.com", true },
  { "blackevent.be", true },
  { "blackfire.io", true },
  { "blackgamelp.de", true },
  { "blackgate.org", true },
  { "blackhat.dk", true },
  { "blackhelicopters.net", true },
  { "blackhell.xyz", true },
  { "blackhillsinfosec.com", true },
  { "blackilli.de", true },
  { "blackislegroup.com", true },
  { "blackjackballroomcasino.info", true },
  { "blackkeg.ca", true },
  { "blackl.net", true },
  { "blacklightparty.be", true },
  { "blackmonday.gr", true },
  { "blacknetwork.eu", true },
  { "blacknova.io", true },
  { "blackonion.com", true },
  { "blackpapermoon.de", true },
  { "blackpayment.ru", true },
  { "blackphoenix.de", true },
  { "blackpi.dedyn.io", true },
  { "blackroadphotography.de", true },
  { "blackroot.eu", true },
  { "blackscytheconsulting.com", true },
  { "blackseals.net", true },
  { "blackyau.cc", true },
  { "blackys-chamber.de", true },
  { "blaise.io", true },
  { "blakecoin.org", true },
  { "blakekhan.com", true },
  { "blameomar.com", true },
  { "blancodent.com", true },
  { "blankersfamily.com", true },
  { "blanket.technology", true },
  { "blasorchester-runkel.de", true },
  { "blastentertainment.com.au", true },
  { "blastersklan.com", true },
  { "blastzoneentertainments.co.uk", true },
  { "blaudev.es", true },
  { "blayne.me", true },
  { "blayneallan.com", true },
  { "blazing.cz", true },
  { "blazor.nl", true },
  { "bleaching-tipps.de", true },
  { "bleche-onlineshop.at", true },
  { "bleche-onlineshop.de", true },
  { "blechinger.io", true },
  { "blechschmidt.saarland", true },
  { "blenderinsider.com", true },
  { "blenderrecipereviews.com", true },
  { "blending.kr", true },
  { "blendle.com", true },
  { "blendle.nl", true },
  { "blendr.com", true },
  { "blenheimears.com", true },
  { "blenneros.net", false },
  { "blessedguy.com", true },
  { "blessedguy.net", false },
  { "blewebprojects.com", true },
  { "blichmann.eu", true },
  { "blidz.com", true },
  { "blieque.co.uk", true },
  { "bliesekow.net", true },
  { "blikk.no", true },
  { "blinder.com.co", true },
  { "blindpigandtheacorn.com", true },
  { "blinds-unlimited.com", true },
  { "blingsparkleshine.com", true },
  { "blink-security.com", true },
  { "blinking.link", true },
  { "blinkspeed.eu", true },
  { "blio.tk", true },
  { "blip.website", true },
  { "blissjoe.com", true },
  { "blissplan.com", true },
  { "blitzprog.org", true },
  { "blitzvendor.com", true },
  { "blivawesome.dk", true },
  { "blivvektor.dk", true },
  { "blizhost.com", true },
  { "blizhost.com.br", true },
  { "blizora.com", true },
  { "blkbx.eu", true },
  { "blm.gov", true },
  { "blo-melchiorshausen.de", true },
  { "blobfolio.com", true },
  { "block-this.com", true },
  { "block65.com", true },
  { "blockchain.com", true },
  { "blockchain.info", true },
  { "blockchainced.com", true },
  { "blockchaindaigakko.jp", true },
  { "blockchainwhiz.com", true },
  { "blockcheck.network", true },
  { "blockedyourcar.com", true },
  { "blockedyourcar.net", true },
  { "blockedyourcar.org", true },
  { "blockified.io", true },
  { "blockmetry.com", true },
  { "blockstream.com", true },
  { "blockxit.de", true },
  { "bloemenbesteld.nl", true },
  { "bloemendal.me", true },
  { "blog-grupom2.es", true },
  { "blog.gov.uk", true },
  { "blog.linode.com", false },
  { "blog.lookout.com", false },
  { "blogaid.net", true },
  { "blogarts.net", true },
  { "blogbooker.com", true },
  { "blogconcours.net", true },
  { "blogdelosjuguetes.com", true },
  { "blogexpert.ca", true },
  { "bloggermumofthreeboys.com", true },
  { "blogging-life.com", true },
  { "bloggingwithchildren.com", true },
  { "bloggytalky.com", true },
  { "bloginbeeld.nl", true },
  { "bloglines.co.za", true },
  { "bloglogistics.com", true },
  { "blogom.at", true },
  { "blogpentrusuflet.ro", true },
  { "blogreen.org", true },
  { "blogsdna.com", true },
  { "blogthedayaway.com", true },
  { "blogtroterzy.pl", true },
  { "blok56.nl", true },
  { "blokmy.com", true },
  { "blood4pets.tk", true },
  { "bloodhunt.pl", true },
  { "bloodsports.org", true },
  { "bloom-avenue.com", true },
  { "bltc.co.uk", true },
  { "bltc.com", true },
  { "bltc.net", true },
  { "bltc.org", true },
  { "bltc.org.uk", true },
  { "bltdirect.com", true },
  { "blubberladen.de", true },
  { "bludnykoren.ml", true },
  { "blue-gmbh-erfahrungen.de", true },
  { "blue-gmbh.de", true },
  { "blue-leaf81.net", true },
  { "blue42.net", true },
  { "blueblou.com", true },
  { "bluechilli.com", true },
  { "bluecon.ninja", true },
  { "bluecrazii.nl", true },
  { "blued.moe", true },
  { "bluedata.ltd", true },
  { "bluedeck.org", true },
  { "blueflare.org", true },
  { "bluefrag.com", true },
  { "bluefuzz.nl", true },
  { "blueimp.net", true },
  { "bluekrypt.com", true },
  { "blueliquiddesigns.com.au", true },
  { "bluemeda.web.id", true },
  { "bluemosh.com", true },
  { "bluemtnrentalmanagement.ca", true },
  { "bluenote9.com", true },
  { "blueoakart.com", true },
  { "blueoceantech.us", true },
  { "blueperil.de", true },
  { "bluepoint.one", true },
  { "bluepostbox.de", true },
  { "bluerootsmarketing.com", true },
  { "blues-and-pictures.com", true },
  { "blueskycoverage.com", true },
  { "bluestardiabetes.com", true },
  { "bluesuncamping.com", true },
  { "bluesunhotels.com", true },
  { "bluetexservice.com", true },
  { "bluewavewebdesign.com", true },
  { "bluex.im", true },
  { "bluex.info", true },
  { "bluex.net", true },
  { "bluex.org", true },
  { "blueyed.eu", true },
  { "blui.ml", true },
  { "bluimedia.com", true },
  { "blumenfeldart.com", true },
  { "blumiges-fischbachtal.de", false },
  { "bluntandsnakes.com", true },
  { "blupig.net", true },
  { "bluproducts.com.es", true },
  { "blurringexistence.net", true },
  { "blusens.com", true },
  { "blusmurf.net", true },
  { "blyat.science", true },
  { "blyth.me.uk", true },
  { "blzrk.com", true },
  { "bm-immo.ch", true },
  { "bmhglobal.com.au", true },
  { "bminton.is-a-geek.net", true },
  { "bmone.net", true },
  { "bmriv.com", true },
  { "bmros.com.ar", true },
  { "bmw-motorradclub-seefeld.de", true },
  { "bmwcolors.com", true },
  { "bn1digital.co.uk", true },
  { "bn4t.me", true },
  { "bnbsinflatablehire.co.uk", true },
  { "bngs.pl", true },
  { "bnin.org", true },
  { "bnjscastles.co.uk", true },
  { "bnstree.com", true },
  { "bnty.net", true },
  { "bnzblowermotors.com", true },
  { "bo4tracker.com", true },
  { "boardgamegeeks.de", true },
  { "boards.ie", true },
  { "boat-engines.eu", true },
  { "boatme.de", true },
  { "boattrader.com", true },
  { "boattrader.com.au", true },
  { "bobaly.es", true },
  { "bobancoamigo.com", true },
  { "bobaobei.net", true },
  { "bobazar.com", true },
  { "bobcopeland.com", true },
  { "bobkidbob.com", true },
  { "bobkoetsier.nl", true },
  { "bobnbouncedublin.ie", true },
  { "bobobox.net", true },
  { "boboolo.com", true },
  { "bobstronomie.fr", true },
  { "bocamo.it", true },
  { "bochs.info", true },
  { "bockenauer.at", true },
  { "bocloud.eu", true },
  { "bocreation.fr", true },
  { "bodhi.fedoraproject.org", true },
  { "bodis.nl", true },
  { "bodsch.com", true },
  { "bodybuildingworld.com", true },
  { "bodyconshop.com", true },
  { "bodygearguide.com", true },
  { "bodypainter.pl", true },
  { "bodypainting.waw.pl", true },
  { "bodyshopnews.net", true },
  { "bodyweb.com.br", true },
  { "bodyworkbymichael.com", true },
  { "bodyworksautorebuild.com", true },
  { "boeddhashop.nl", true },
  { "boekenlegger.nl", true },
  { "boem.gov", true },
  { "boernecancerfonden.dk", true },
  { "bogdancornianu.com", true },
  { "bogdanepureanu.ro", true },
  { "bogner.sh", true },
  { "bogobeats.com", true },
  { "bogosity.se", true },
  { "bohan.co", true },
  { "bohramt.de", true },
  { "boimmobilier.ch", true },
  { "boincstats.com", true },
  { "boiseonlinemall.com", true },
  { "boisewaldorf.org", true },
  { "bokadoktorn-test.net", true },
  { "boke112.com", true },
  { "bokka.com", true },
  { "bokkeriders.com", true },
  { "bokutake.com", true },
  { "boldmediagroup.com", true },
  { "boldt-metallbau.de", true },
  { "bolektro.de", true },
  { "bolgarnyelv.hu", true },
  { "bologna-disinfestazioni.it", true },
  { "bolovegna.it", true },
  { "bolt.cm", false },
  { "boltbeat.com", true },
  { "bolte.org", true },
  { "bomb.codes", true },
  { "bombe-lacrymogene.fr", true },
  { "bonaccorso.eu", true },
  { "bonami.cz", true },
  { "bonami.hu", true },
  { "bonami.pl", true },
  { "bonami.ro", true },
  { "bonami.sk", true },
  { "bonawehouse.co.uk", true },
  { "bonbonmania.com", true },
  { "bondank.com", true },
  { "bondarenko.dn.ua", true },
  { "bondingwithbaby.ca", true },
  { "bondlink.com", true },
  { "bondoer.fr", true },
  { "bondskampeerder.nl", true },
  { "bonebunny.de", true },
  { "bonesserver.com", true },
  { "bonfi.net", true },
  { "bongo.cat", true },
  { "bonibuty.com", true },
  { "bonifacius.be", true },
  { "bonita.com.br", true },
  { "bonito.pl", true },
  { "bonnant-associes.ch", true },
  { "bonnant-partners.ch", true },
  { "bonnebouffe.fr", true },
  { "bonniecoloring.com", true },
  { "bonniedraw.com", true },
  { "bonnieradvocaten.nl", true },
  { "bonnsustainabilityportal.de", true },
  { "bonnyprints.at", true },
  { "bonnyprints.ch", true },
  { "bonnyprints.es", true },
  { "bonnyprints.fr", true },
  { "bonprix.co.uk", true },
  { "bonqoeur.ca", true },
  { "bonrecipe.com", true },
  { "bonsaimedia.nl", true },
  { "bonsi.net", true },
  { "bonux.co", true },
  { "boodmo.com", true },
  { "boogaerdtmakelaars.nl", true },
  { "boogiebouncecastles.co.uk", true },
  { "book-in-hotel.com", true },
  { "booker.ly", true },
  { "bookingapp.be", true },
  { "bookingapp.nl", true },
  { "bookingdeluxesp.com", true },
  { "bookingready.com", true },
  { "bookingslog.com", true },
  { "bookingworldspeakers.com", true },
  { "bookluk.com", true },
  { "bookmein.in", true },
  { "booksearch.jp", true },
  { "booksinthefridge.at", true },
  { "booktracker-org.appspot.com", true },
  { "bool.be", true },
  { "boombv.com", true },
  { "boomersurf.com", true },
  { "boomshelf.com", true },
  { "boomshelf.org", true },
  { "boonbox.com", true },
  { "booox.biz", true },
  { "booox.cc", true },
  { "booox.info", true },
  { "booox.net", true },
  { "booox.org", true },
  { "booox.pw", true },
  { "boop.gq", true },
  { "boop.pro", true },
  { "booq.org", true },
  { "booquiz.com", true },
  { "boosinflatablegames.co.uk", true },
  { "boost.fyi", true },
  { "boost.ink", true },
  { "bootjp.me", false },
  { "bopiweb.com", true },
  { "bopp.org", true },
  { "borahan.net", true },
  { "bordadoenpedreria.com", true },
  { "bordes.me", true },
  { "boredhackers.com", true },
  { "borg.cloud", true },
  { "boringsmith.com", true },
  { "boris64.net", true },
  { "borisenko.by", true },
  { "borisschapira.com", true },
  { "borja.io", true },
  { "born2bounce.co.uk", true },
  { "bornandgrazed.com", true },
  { "borneodictionary.com", true },
  { "bornfiber.dk", true },
  { "bornhack.dk", true },
  { "borrelpartybus.nl", true },
  { "borysek.net", true },
  { "bosabosa.org", true },
  { "boscoyacht.ch", true },
  { "boskeopolis-stories.com", true },
  { "boss.az", true },
  { "bostadsportal.se", true },
  { "bostonadvisors.com", true },
  { "bosufitness.cz", true },
  { "bosun.io", true },
  { "bot-manager.pl", true },
  { "botezdepoveste.ro", true },
  { "botguard.net", true },
  { "bothellwaygarage.net", true },
  { "botoes-primor.pt", true },
  { "botserver.de", true },
  { "botsindiscord.me", true },
  { "botstack.host", true },
  { "bottaerisposta.net", true },
  { "bottineauneighborhood.org", true },
  { "bou.lt", true },
  { "bouah.net", true },
  { "bouchard-mathieux.com", true },
  { "bouchonville-knifemaker.com", true },
  { "bouckaert-usedcars.be", true },
  { "boudah.pl", true },
  { "bougeret.fr", true },
  { "boukoubengo.com", true },
  { "boulderswap.com", true },
  { "boulzicourt.fr", true },
  { "bounce-a-mania.co.uk", true },
  { "bounce-a-roo.co.uk", true },
  { "bounce-abouts.com", true },
  { "bounce-n-go.co.uk", true },
  { "bounce-on.co.uk", true },
  { "bounce-r-us.co.uk", true },
  { "bounce-xtreme.co.uk", true },
  { "bounce4fun.co.uk", true },
  { "bounce4fun.ie", true },
  { "bounce4kidz.com", true },
  { "bounce4less.ie", true },
  { "bouncea-bout.com", true },
  { "bounceaboutandplay.co.uk", true },
  { "bounceaboutnewark.co.uk", true },
  { "bounceaboutsussex.co.uk", true },
  { "bouncealotcastlehire.co.uk", true },
  { "bouncealotnorthwest.co.uk", true },
  { "bounceandwobble.co.uk", true },
  { "bounceapp.com", true },
  { "bouncearoundevents.co.uk", true },
  { "bouncearoundsheffield.co.uk", true },
  { "bounceawaycastles.com", true },
  { "bouncebackcastles.co.uk", true },
  { "bouncebookings.com.au", true },
  { "bouncecrazy.ie", true },
  { "bouncejumpboston.co.uk", true },
  { "bouncekingdom.co.uk", true },
  { "bouncemania.org", true },
  { "bouncemaniaevents.co.uk", true },
  { "bouncemaniainflatables.co.uk", true },
  { "bouncemonkeys.co.uk", true },
  { "bouncenortheast.co.uk", true },
  { "bouncenpaint.co.uk", true },
  { "bouncenslidenortheast.co.uk", true },
  { "bouncepartycastles.com", true },
  { "bounceroosevents.co.uk", true },
  { "bouncers-bouncycastlehire.co.uk", true },
  { "bouncesouthwales.co.uk", true },
  { "bouncesquad.co.uk", true },
  { "bouncetasticuk.co.uk", true },
  { "bouncetheparty.co.uk", true },
  { "bounceunlimited.co.uk", true },
  { "bouncewrightcastles.co.uk", true },
  { "bouncincastles.co.uk", true },
  { "bouncing-bugs.co.uk", true },
  { "bouncingbairnsinflatables.co.uk", true },
  { "bouncingbeansinflatables.co.uk", true },
  { "bouncingbobsinflatables.co.uk", true },
  { "bouncingbuddiesleicester.co.uk", true },
  { "bouncinghigher.co.uk", true },
  { "bouncingscotland.com", true },
  { "bouncourseplanner.net", true },
  { "bouncy-castles-surrey.co.uk", true },
  { "bouncy-tots.co.uk", true },
  { "bouncybaileys.co.uk", true },
  { "bouncyball.eu", true },
  { "bouncyballs.org", true },
  { "bouncyballscastles.co.uk", true },
  { "bouncybouncyboocastlehire.co.uk", true },
  { "bouncycastle.net.au", true },
  { "bouncycastlehire-norwich.com", true },
  { "bouncycastlehire-sheffield.co.uk", true },
  { "bouncycastlehire.co.uk", true },
  { "bouncycastlehireauckland.co.nz", true },
  { "bouncycastlehirebarnstaple.co.uk", true },
  { "bouncycastlehirebexley.co.uk", true },
  { "bouncycastlehirechelmsford.org.uk", true },
  { "bouncycastlehirehull.co.uk", true },
  { "bouncycastlehireinglasgow.co.uk", true },
  { "bouncycastlehirelouth.co.uk", true },
  { "bouncycastlehiremalvern.co.uk", true },
  { "bouncycastlehireoldham.co.uk", true },
  { "bouncycastlehirestroud.co.uk", true },
  { "bouncycastlehiresurrey.co.uk", true },
  { "bouncycastlehiretameside.co.uk", true },
  { "bouncycastlehirewinchester.co.uk", true },
  { "bouncycastleman.co.uk", true },
  { "bouncycastlemangloucestershire.co.uk", true },
  { "bouncycastleparade.com", true },
  { "bouncycastlesgalway.com", true },
  { "bouncycastleshire.co.uk", true },
  { "bouncycastleshireleeds.co.uk", true },
  { "bouncycastlesin.co.uk", true },
  { "bouncycastlesinderby.co.uk", true },
  { "bouncycastlesinleeds.co.uk", true },
  { "bouncycastlesisleofwight.co.uk", true },
  { "bouncycastlesmonaghan.com", true },
  { "bouncycastlessheerness.co.uk", true },
  { "bouncydays.co.uk", true },
  { "bouncyfeet.co.uk", true },
  { "bouncygiggles.com.au", true },
  { "bouncyhigher.co.uk", true },
  { "bouncyhousecastlehire.co.uk", true },
  { "bouncykingdom.co.uk", true },
  { "bouncykings.co.uk", true },
  { "bouncykingsnortheast.co.uk", true },
  { "bouncymacs.co.uk", true },
  { "bouncyrainbows.co.uk", true },
  { "bouncytime.co.uk", true },
  { "bouncytown.co.uk", true },
  { "bouncywouncy.co.uk", true },
  { "bound2bounce.co.uk", true },
  { "boundarybrighton.com", true },
  { "bountyfactory.io", true },
  { "bourasse.fr", true },
  { "bourdon.fr.eu.org", true },
  { "bourgdepabos.com", true },
  { "bourhis.info", true },
  { "bournefun.co.uk", true },
  { "bourqu.in", true },
  { "boutiquedecanetas.com.br", true },
  { "boutiquefutebol.com.br", true },
  { "boutiqueguenaelleverdin.com", true },
  { "bouw.live", true },
  { "bouzouada.com", true },
  { "bouzouks.net", true },
  { "bovenwebdesign.nl", true },
  { "bowdens.me", true },
  { "bowedwallcrackrepair.com", true },
  { "boweryandvine.com", true },
  { "bowlcake.fr", true },
  { "bowling.com", true },
  { "bownty.be", true },
  { "bownty.co.uk", true },
  { "bownty.de", true },
  { "bownty.dk", true },
  { "bownty.es", true },
  { "bownty.fr", true },
  { "bownty.it", true },
  { "bownty.nl", true },
  { "bowntycdn.net", true },
  { "boxpeg.com", true },
  { "boxpirates.to", true },
  { "boxvergelijker.nl", true },
  { "boyerassoc.com", true },
  { "boyfriendcookbook.com", true },
  { "boyhost.cn", true },
  { "boyinglanguage.com", true },
  { "boyntonobserver.org", true },
  { "boz.nl", false },
  { "bozdoz.com", true },
  { "bozit.com.au", true },
  { "bozosbouncycastles.co.uk", true },
  { "bpa.gov", true },
  { "bpaste.net", true },
  { "bpastudies.org", true },
  { "bpo.ovh", true },
  { "bpol-forum.de", true },
  { "bqp.io", true },
  { "bqr.ch", true },
  { "br.search.yahoo.com", false },
  { "br3in.nl", false },
  { "br7.ru", true },
  { "braams.nl", true },
  { "braathe.no", true },
  { "bracho.xyz", true },
  { "brackets-salad.com", true },
  { "bradbrockmeyer.com", true },
  { "bradfergusonrealestate.com", true },
  { "bradfordhottubhire.co.uk", true },
  { "bradfordmascots.co.uk", true },
  { "bradkovach.com", true },
  { "bradler.net", true },
  { "bradlinder.org", true },
  { "bradypatterson.com", true },
  { "braeunlich-gmbh.com", true },
  { "brage.info", true },
  { "brahmins.com", true },
  { "brahmstaedt.de", true },
  { "braiampeguero.xyz", true },
  { "brailsford.xyz", true },
  { "brain-e.co", true },
  { "brain-force.ch", true },
  { "brainball.fr", true },
  { "brainfork.org", true },
  { "brainhub.nl", true },
  { "brainserve.ch", true },
  { "brainserve.com", true },
  { "brainserve.swiss", true },
  { "brainsik.net", true },
  { "brainster.co", true },
  { "brainvation.de", true },
  { "brainvoyagermusic.com", true },
  { "brainwav.es", true },
  { "brainwork.space", true },
  { "brakemanpro.com", true },
  { "brakpanplumber24-7.co.za", true },
  { "brakstad.org", true },
  { "bralnik.com", true },
  { "brambogaerts.nl", true },
  { "bramburek.net", true },
  { "bramhallsamusements.com", true },
  { "brammingfys.dk", true },
  { "bramsikkens.be", true },
  { "bramstaps.nl", true },
  { "bramvanaken.be", true },
  { "bramygrozy.pl", true },
  { "bran.land", true },
  { "branch-bookkeeper.com", true },
  { "branchtrack.com", true },
  { "brandand.co.uk", true },
  { "brandbil.dk", true },
  { "brandcodeconsulting.com", true },
  { "brandcodestyle.com", true },
  { "brandingclic.com", true },
  { "brando753.xyz", true },
  { "brandongomez.me", true },
  { "brandonhubbard.com", true },
  { "brandonwalker.me", true },
  { "brandrocket.dk", true },
  { "brandstead.com", true },
  { "brandtrapselfie.nl", true },
  { "brandweerfraneker.nl", true },
  { "brandweertrainingen.nl", true },
  { "brandweeruitgeest.nl", true },
  { "brank.as", true },
  { "branw.xyz", true },
  { "brasal.ma", true },
  { "brasalcosmetics.com", true },
  { "brashear.me", true },
  { "brasilbombas.com.br", true },
  { "brasildxn.com.br", true },
  { "brasileiro.ca", true },
  { "brasserie-mino.fr", true },
  { "brasspipedreams.org", true },
  { "bratislava-airport-taxi.com", true },
  { "bratteng.me", true },
  { "bratteng.xyz", true },
  { "bratvanov.com", true },
  { "brau-ingenieur.de", true },
  { "braudoktor.de", true },
  { "brauingenieur.de", true },
  { "braunsteinpc.com", true },
  { "braunwarth.info", true },
  { "brava.bg", true },
  { "brave-foods.ch", true },
  { "brave-foods.com", true },
  { "brave.com", true },
  { "bravebaby.com.au", true },
  { "bravehearts.org.au", true },
  { "braviskindenjeugd.nl", true },
  { "bravisziekenhuis.nl", false },
  { "brazenfol.io", true },
  { "brazilian.dating", true },
  { "brazillens.com", true },
  { "brck.nl", true },
  { "brd.ro", true },
  { "breadandlife.org", true },
  { "breakingtech.it", true },
  { "breakpoint.at", true },
  { "breaky.de", true },
  { "breathedreamgo.com", true },
  { "breathingblanket.com", true },
  { "brecht.ch", true },
  { "breckle.com.ua", true },
  { "brecknell.biz", true },
  { "brecknell.com", true },
  { "brecknell.info", true },
  { "brecknell.name", true },
  { "brecknell.net", true },
  { "brecknell.org", true },
  { "breda.computer", true },
  { "bredvid.no", true },
  { "breest.net", true },
  { "breeyn.com", true },
  { "brefy.com", true },
  { "brege.org", true },
  { "breitband.bz.it", true },
  { "breitbild-beamer.de", true },
  { "brejoc.com", true },
  { "bremen-restaurants.de", true },
  { "bremerfriedensforum.de", true },
  { "brendanbatliner.com", true },
  { "brendanscherer.com", true },
  { "brentacampbell.com", true },
  { "brentnewbury.com", true },
  { "bressier.fr", true },
  { "bretcarmichael.com", true },
  { "brettabel.com", true },
  { "brettelliff.com", true },
  { "brettlawyer.com", true },
  { "brettw.xyz", true },
  { "bretzner.fr", true },
  { "brevboxar.se", true },
  { "brewsouth.com", true },
  { "brewtrackr.com", true },
  { "breznet.com", true },
  { "brgins.com", true },
  { "brian-gordon.name", true },
  { "brianalaway.com", true },
  { "brianalawayconsulting.com", true },
  { "briandwells.com", true },
  { "brianfoshee.com", true },
  { "brianjohnson.co.za", true },
  { "brianlanders.us", true },
  { "brianroadifer.com", true },
  { "briansmith.org", true },
  { "briantkatch.com", true },
  { "brianwesaala.com", true },
  { "briarproject.org", true },
  { "brickftp.com", true },
  { "brickheroes.com", true },
  { "brickstreettrio.com", true },
  { "brickvortex.com", true },
  { "bricolajeux.ch", true },
  { "brid.gy", false },
  { "bridalshoes.com", true },
  { "brideandgroomdirect.ie", true },
  { "bridgedirectoutreach.com", true },
  { "bridgeglobalmarketing.com", true },
  { "bridgehomeloans.com", true },
  { "bridgement.com", true },
  { "bridgevest.com", true },
  { "bridgingdirectory.com", true },
  { "bridltaceng.com", true },
  { "brie.tech", true },
  { "briefassistant.com", true },
  { "briefhansa.de", true },
  { "briefvorlagen-papierformat.de", true },
  { "brier.me", true },
  { "briffoud.fr", true },
  { "briggsleroux.com", true },
  { "brighouse-leisure.co.uk", true },
  { "brightday.bz", true },
  { "brightendofleasecleaning.com.au", true },
  { "brightlifedirect.com", true },
  { "brightonbank.com", true },
  { "brightonbouncycastles.net", true },
  { "brightonchilli.org.uk", true },
  { "brightonzhang.com", true },
  { "brightworkcreative.com", true },
  { "brigidaarie.com", true },
  { "brilliantbouncyfun.co.uk", true },
  { "brilliantproductions.co.nz", true },
  { "brimspark.systems", true },
  { "brio-shop.ch", true },
  { "brisbanelogistics.com.au", true },
  { "bristebein.com", true },
  { "bristolandwestonsuperbounce.com", true },
  { "britanniapandi.com", true },
  { "britelocate.com", true },
  { "britishbeef.com", true },
  { "britishbookmakers.co.uk", true },
  { "britishgroupsg.com", true },
  { "britishpearl.com", true },
  { "britishsciencefestival.org", true },
  { "britishscienceweek.org", true },
  { "britishsnoring.co.uk", true },
  { "britneyclause.com", true },
  { "brittanyferriesnewsroom.com", true },
  { "britton-photography.com", true },
  { "brk.st", true },
  { "brmsalescommunity.com", true },
  { "brn.by", true },
  { "brnojebozi.cz", true },
  { "bro.hk", true },
  { "broadleft.org", true },
  { "broadsheet.com.au", true },
  { "brockmeyer.net", true },
  { "brockmeyer.org", true },
  { "brodowski.cc", true },
  { "brody.digital", true },
  { "brody.ninja", true },
  { "broersma.com", true },
  { "broeselei.at", true },
  { "brokenhands.io", true },
  { "brokenjoysticks.net", true },
  { "brokervalues.com", true },
  { "brompton-cocktail.com", true },
  { "bronetb2b.com.br", true },
  { "bronevichok.ru", true },
  { "bronwynlewis.com", true },
  { "broodbesteld.nl", true },
  { "brooke-fan.com", true },
  { "brookehatton.com", false },
  { "brooklynrealestateblog.com", true },
  { "brookworth.com", true },
  { "brossmanit.com", true },
  { "brother-printsmart.nl", true },
  { "brouillard.ch", true },
  { "brouwerijdeblauweijsbeer.nl", true },
  { "brovelton.com", true },
  { "brown-devost.com", true },
  { "brownfieldstsc.org", true },
  { "brownihc.com", true },
  { "browntowncountryclub.com", true },
  { "browsemycity.com", true },
  { "browserleaks.com", true },
  { "brring.com", true },
  { "brrr.fr", true },
  { "bru6.de", true },
  { "brucekovner.com", true },
  { "brucemartin.net", true },
  { "brucemobile.de", false },
  { "bruck.me", true },
  { "brudkista.se", true },
  { "brudkistan.nu", true },
  { "brudkistan.se", true },
  { "bruna-cdn.nl", true },
  { "brunick.de", false },
  { "brunn.email", true },
  { "brunner.ninja", true },
  { "brunohenc.from.hr", true },
  { "brunoproduit.ch", true },
  { "brunoramos.com", true },
  { "brunoramos.org", true },
  { "brunosouza.org", true },
  { "brush.ninja", true },
  { "bruun.co", true },
  { "bryankaplan.com", true },
  { "bryanquigley.com", true },
  { "bryansmith.net", true },
  { "bryansmith.tech", true },
  { "brycecanyon.net", true },
  { "brycecanyonnationalpark.com", true },
  { "bryggebladet.dk", true },
  { "brztec.com", true },
  { "brzy-svoji.cz", true },
  { "bs-network.net", true },
  { "bs-security.com", true },
  { "bs.sb", true },
  { "bs.to", true },
  { "bs12v.ru", true },
  { "bsa157.org", true },
  { "bsatroop794.org", true },
  { "bsc-rietz.at", true },
  { "bscc.support", true },
  { "bsd-box.net", true },
  { "bsdes.net", true },
  { "bsdfreak.dk", true },
  { "bsdlab.com", true },
  { "bsdracing.ca", true },
  { "bsdunix.xyz", true },
  { "bsee.gov", true },
  { "bserved.de", true },
  { "bsg.ro", true },
  { "bsgamanet.ro", true },
  { "bsidesf.com", true },
  { "bsidesf.org", true },
  { "bsidessf.com", true },
  { "bsimerch.com", true },
  { "bslim-e-boutique.com", true },
  { "bso-buitengewoon.nl", true },
  { "bsociabl.com", true },
  { "bsp-southpool.com", true },
  { "bsquared.org", true },
  { "bst.gg", true },
  { "bstoked.net", true },
  { "bsw-solution.de", true },
  { "bt123.xyz", true },
  { "bta.lv", false },
  { "btcarmory.com", true },
  { "btcbolsa.com", true },
  { "btcontract.com", true },
  { "btcpop.co", true },
  { "btcycle.org", true },
  { "btine.tk", true },
  { "btio.pw", true },
  { "btmstore.com.br", true },
  { "btnissanparts.com", true },
  { "btorrent.xyz", true },
  { "btsapem.com", true },
  { "btsoft.eu", true },
  { "btsow.com", true },
  { "bttc.co.uk", true },
  { "btth.live", true },
  { "btth.pl", true },
  { "btth.tv", true },
  { "btth.xyz", true },
  { "bttorj45.com", true },
  { "buayacorp.com", true },
  { "bubblegumblog.com", true },
  { "bubblespetspa.com", true },
  { "bubblin.io", true },
  { "bubblinghottubs.co.uk", true },
  { "bubblybouncers.co.uk", true },
  { "bubhub.io", true },
  { "bubulazi.com", false },
  { "bubulazy.com", false },
  { "bucek.cz", true },
  { "buch-angucken.de", true },
  { "buchhandlungkilgus.de", true },
  { "buchwegweiser.com", true },
  { "buckelewrealtygroup.com", true },
  { "bucketlist.co.ke", true },
  { "buckypaper.com", true },
  { "buddhismus.net", true },
  { "buddie5.com", true },
  { "buddlycrafts.com", true },
  { "buddyworks.net", true },
  { "budeanu.com", true },
  { "buderus-family.be", true },
  { "budger.nl", true },
  { "budget.gov", true },
  { "budgetalk.com", true },
  { "budgetcastlehire.co.uk", true },
  { "budgetlob.gov", true },
  { "budgetlovers.nl", true },
  { "budgiesballoons.com", true },
  { "budntod.com", true },
  { "budolfs.de", true },
  { "bueltge.de", true },
  { "buena-vista.cz", true },
  { "buena.me", true },
  { "bueny.com", true },
  { "bueny.net", true },
  { "bueroplus.de", true },
  { "bueroschwarz.design", true },
  { "bueroshop24.de", true },
  { "buettgens.net", true },
  { "buffaloautomation.com", true },
  { "buffaloturf.com.au", true },
  { "buffetbouc.com", true },
  { "bug.blue", true },
  { "bug.ee", true },
  { "bugcrowd.com", true },
  { "bugginslab.co.uk", true },
  { "bugs.chromium.org", true },
  { "bugsmashed.com", true },
  { "bugwie.com", true },
  { "bugzil.la", true },
  { "bugzilla.mozilla.org", true },
  { "build.chromium.org", true },
  { "buildbox.io", true },
  { "buildbytes.com", true },
  { "buildhoscaletraingi.com", true },
  { "building-cost-estimators.com", true },
  { "buildingclouds.de", true },
  { "buildingcostestimators.co.uk", true },
  { "builditsolutions.net", true },
  { "buildkite.com", true },
  { "buildmorebuslanes.com", true },
  { "buildplease.com", true },
  { "buildrightbuildingservicesltd.co.uk", true },
  { "buileo.com", true },
  { "builtory.my", true },
  { "builtvisible.com", true },
  { "builtwith.com", true },
  { "buissonchardin.fr", true },
  { "bukkenfan.jp", true },
  { "bul3seas.eu", true },
  { "bulario.com", true },
  { "bulario.net", true },
  { "bulbcompare.com", true },
  { "bulkcandystore.com", true },
  { "bulkingtime.com", true },
  { "bulkowespacerkowo.nl", true },
  { "bulktrade.de", true },
  { "bulktshirtsjohannesburg.co.za", true },
  { "bulkwholesalesweets.co.uk", true },
  { "bull.id.au", true },
  { "bulldog-hosting.de", true },
  { "bulledair-savons.ch", true },
  { "bullettags.com", true },
  { "bullpendaily.com", true },
  { "bullshitmail.nl", true },
  { "bullterrier.nu", true },
  { "bulwarkhost.com", true },
  { "bunbun.be", false },
  { "bund-von-theramore.de", true },
  { "bundespolizei-forum.de", true },
  { "bungee.pw", true },
  { "bungee.systems", true },
  { "bungeetaco.com", true },
  { "bunkyo-life.com", true },
  { "bunny-rabbits.com", true },
  { "bunnycarenotes.com", true },
  { "bunnydiamond.de", true },
  { "bunnyvishal.com", true },
  { "bunzy.ca", true },
  { "bupropion.com", true },
  { "bupu.ml", true },
  { "buradangonder.com", true },
  { "burcevo.info", true },
  { "burfordbedandbreakfast.co.uk", true },
  { "burg-hohnstein.com", true },
  { "burgernet.nl", true },
  { "burgers.io", true },
  { "burghardt.pl", true },
  { "buri.be", false },
  { "burialinsurancenetwork.com", true },
  { "burke.services", true },
  { "burlapsac.ca", true },
  { "burncorp.org", true },
  { "burnerfitness.com", true },
  { "burnhamonseabouncycastles.co.uk", true },
  { "burningbird.net", true },
  { "burningflipside.com", false },
  { "burningmarket.de", true },
  { "burntfish.com", true },
  { "burnworks.com", true },
  { "buronwater.com", true },
  { "burotec-sarl.com", true },
  { "burr.is", true },
  { "bursaries-southafrica.co.za", true },
  { "burtplasticsurgery.com", true },
  { "burtrum.family", true },
  { "burtrum.me", true },
  { "burtrum.name", true },
  { "burtrum.org", true },
  { "burzcast.ro", true },
  { "burzmali.com", true },
  { "burzmedia.com", true },
  { "burzstudios.com", true },
  { "busanhs.win", true },
  { "bushbaby.com", true },
  { "busindre.com", true },
  { "business-garden.com", true },
  { "business.facebook.com", false },
  { "businesscentermarin.ch", true },
  { "businessesdirectory.eu", true },
  { "businessfactors.de", true },
  { "businessimmigration-eu.com", true },
  { "businessimmigration-eu.ru", true },
  { "businessloanconnection.org", false },
  { "businessmadeeasypodcast.com", true },
  { "businessmarketingblog.org", true },
  { "businessplanexperts.ca", true },
  { "businessradar.com.au", true },
  { "businesswebadmin.com", true },
  { "busit.be", true },
  { "busold.ws", true },
  { "bustadice.com", true },
  { "bustimes.org", true },
  { "bustup-tips.com", true },
  { "busuttil.org.uk", true },
  { "busyon.cloud", true },
  { "butarque.es", true },
  { "buthowdoyoubuygroceries.com", true },
  { "butikpris.se", true },
  { "butikvip.ru", true },
  { "butteramotors.com", true },
  { "buttonline.ch", true },
  { "buttonrun.com", true },
  { "buturyu.net", true },
  { "buurtgenotencollectief.nl", true },
  { "buurtpreventiefraneker.nl", true },
  { "buxum-communication.ch", true },
  { "buy-out.jp", true },
  { "buybike.shop", true },
  { "buycarpet.shop", true },
  { "buycbd.store", true },
  { "buycook.shop", true },
  { "buydissertations.com", true },
  { "buyebook.xyz", true },
  { "buyerdocs.com", true },
  { "buyhealth.shop", true },
  { "buyinginvestmentproperty.com", true },
  { "buyjewel.shop", true },
  { "buymindhack.com", true },
  { "buypapercheap.net", true },
  { "buyplussize.shop", true },
  { "buyprofessional.shop", true },
  { "buyritefairview.com", true },
  { "buysellinvestproperties.com", true },
  { "buyseo.store", true },
  { "buysuisse.shop", true },
  { "buytermpaper.com", true },
  { "buytheway.co.za", true },
  { "buywine.shop", true },
  { "buzz.tools", true },
  { "buzzconf.io", true },
  { "buzzcontent.com", true },
  { "buzzprint.it", true },
  { "bvalle.com", true },
  { "bvgg.eu", true },
  { "bvl.aero", true },
  { "bw.codes", true },
  { "bwcscorecard.org", true },
  { "bwe-seminare.de", true },
  { "bwfc.nl", true },
  { "bwh1.net", false },
  { "bwilkinson.co.uk", true },
  { "bwl-earth.club", true },
  { "bws16.de", true },
  { "bwserhoscaletrainaz.com", true },
  { "bx-n.de", true },
  { "bxdev.me", true },
  { "bxp40.at", true },
  { "byange.pro", true },
  { "byatte.com", true },
  { "byeskille.no", true },
  { "bygningsregistrering.dk", true },
  { "byhe.me", true },
  { "byiu.info", false },
  { "byken.cn", true },
  { "bymark.co", true },
  { "bymike.co", true },
  { "bynder.com", true },
  { "bynet.cz", true },
  { "bynumlaw.net", true },
  { "bypass.sh", true },
  { "byr.moe", true },
  { "byrko.cz", true },
  { "byrko.sk", true },
  { "byrtz.de", true },
  { "bytanchan.com", true },
  { "byte-time.com", true },
  { "byte128.com", true },
  { "bytearts.net", false },
  { "bytebucket.org", true },
  { "bytecode.no", true },
  { "bytecrafter.com", true },
  { "bytecrafter.net", true },
  { "bytejail.com", true },
  { "bytema.cz", true },
  { "bytema.eu", true },
  { "bytema.re", true },
  { "bytema.sk", true },
  { "bytemix.cloud", true },
  { "byteowls.com", false },
  { "bytepark.de", true },
  { "bytepen.com", true },
  { "bytes.co", true },
  { "bytes.fyi", true },
  { "bytesatwork.de", true },
  { "byteshark.org", true },
  { "bytesign.de", true },
  { "bytesizedalex.com", true },
  { "bytesunlimited.com", true },
  { "bytesystems.com", true },
  { "bythen.cn", true },
  { "bythisverse.com", true },
  { "bytrain.net", true },
  { "byvshie.com", true },
  { "bziaks.xyz", true },
  { "bzsparks.com", true },
  { "bztech.com.br", true },
  { "bztraveler.com", true },
  { "bztraveler.net", true },
  { "bzv-fr.eu", true },
  { "c-aeroconsult.com", true },
  { "c-path.org", true },
  { "c-rom.fr", true },
  { "c-rtx.com", true },
  { "c-shock.org", true },
  { "c-webdesign.net", true },
  { "c-world.co.uk", true },
  { "c.cc", true },
  { "c0rporation.com", true },
  { "c2design.it", true },
  { "c2o-library.net", true },
  { "c3sign.de", true },
  { "c3vo.de", true },
  { "c3w.at", true },
  { "c3wien.at", true },
  { "c3woc.de", true },
  { "c4539.com", true },
  { "c4k3.net", true },
  { "c5h8no4na.net", true },
  { "c7dn.com", true },
  { "ca-key.de", true },
  { "ca-terminal-multiservices.fr", true },
  { "ca.gparent.org", true },
  { "ca.search.yahoo.com", false },
  { "ca5.de", true },
  { "caaps.org.au", true },
  { "caarecord.org", true },
  { "caasd.org", true },
  { "cabaladada.org", true },
  { "cabarave.com", true },
  { "cabforum.org", true },
  { "cabineritten.nl", true },
  { "cabinet-bedin.com", true },
  { "cabinetfurnituree.com", true },
  { "cablemod.com", true },
  { "cablesandkits.com", true },
  { "cabotfinancial.co.uk", true },
  { "cacao-chocolate.com", true },
  { "cacao.supply", true },
  { "cacaolalina.com", true },
  { "cacaumidade.com.br", true },
  { "caceis.bank", true },
  { "cachacacha.com", true },
  { "cachedview.nl", true },
  { "cachetagalong.com", true },
  { "cachetur.no", true },
  { "cackette.com", true },
  { "cad-noerdlingen.de", true },
  { "cadacoon.com", true },
  { "cadafamilia.de", true },
  { "cadams.io", true },
  { "cadcreations.co.ke", true },
  { "cadetsge.ch", true },
  { "cadmail.nl", true },
  { "cadman.pw", true },
  { "cadooz.com", true },
  { "cadorama.fr", true },
  { "cadoth.net", true },
  { "cadra.nl", false },
  { "cadre.com", true },
  { "cadsys.net", true },
  { "cadusilva.com", true },
  { "caesarkabalan.com", true },
  { "cafedupont.be", true },
  { "cafedupont.co.uk", true },
  { "cafedupont.de", true },
  { "cafedupont.nl", true },
  { "cafeimsueden.de", true },
  { "cafelandia.net", true },
  { "cafeobscura.nl", true },
  { "caferagazzi.de", true },
  { "cafericoy.com", true },
  { "cafeterasbaratas.net", true },
  { "caffeinatedcode.com", true },
  { "cagalogluyayinevi.com", true },
  { "caglarcakici.com", true },
  { "caijunyi.net", true },
  { "cainhosting.com", false },
  { "caitcs.com", true },
  { "caiwenjian.xyz", true },
  { "caizx.com", false },
  { "caja-pdf.es", true },
  { "cajio.ru", true },
  { "cajunuk.co.uk", true },
  { "cake-time.co.uk", true },
  { "cakestart.net", true },
  { "caketoindia.com", true },
  { "cakingandbaking.com", true },
  { "cal9000.com", true },
  { "calaad.net", true },
  { "calabasaselectric.com", true },
  { "calabasaselectrical.com", true },
  { "calabasaselectrician.com", true },
  { "calabasasexteriorlighting.com", true },
  { "calabasaslandscapelighting.com", true },
  { "calabasaslighting.com", true },
  { "calabasasoutdoorlighting.com", true },
  { "calaborlawnews.com", true },
  { "calafont.cat", false },
  { "calatoruldigital.ro", true },
  { "calc.pw", true },
  { "calcedge.com", true },
  { "calcinacci.com", true },
  { "calcoolator.pl", true },
  { "calculadoraconversor.com", true },
  { "calcularis.ch", true },
  { "calculateaspectratio.com", true },
  { "calculator-imt.com", true },
  { "calculator.tf", true },
  { "calcworkshop.com", true },
  { "caldaro.de", true },
  { "caldoletto.com", true },
  { "caleb.cx", true },
  { "caleb.host", true },
  { "calebennett.com", true },
  { "calebthompson.io", true },
  { "calehoo.com", true },
  { "calendar.cf", true },
  { "calendarr.com", true },
  { "calendarsnow.com", true },
  { "calendly.com", true },
  { "calenfil.com", true },
  { "calentadores-solares-sunshine.com", true },
  { "caletka.cz", true },
  { "calgoty.com", true },
  { "calibreapp.com", true },
  { "calibso.net", true },
  { "caliderumba.com", true },
  { "calixte-concept.fr", true },
  { "call.me", true },
  { "callanan.nl", true },
  { "callantonia.com", true },
  { "callawayracing.se", false },
  { "callear.org", true },
  { "callhub.io", true },
  { "callidus-vulpes.de", true },
  { "calltoar.ms", true },
  { "calltothepen.com", true },
  { "callumsilcock.com", true },
  { "callumsilcock.me", true },
  { "calluna.nl", true },
  { "calmtech.com", true },
  { "calotte-academy.com", true },
  { "calrotaract.org", true },
  { "calvin.my", true },
  { "calvinallen.net", false },
  { "calyxengineers.com", true },
  { "calyxinstitute.org", false },
  { "camara360grados.com", true },
  { "camaradivisas.com", true },
  { "camaras.uno", true },
  { "camarilloelectric.com", true },
  { "camarilloelectrical.com", true },
  { "camarilloexteriorlighting.com", true },
  { "camarillolandscapelighting.com", true },
  { "camarillolighting.com", true },
  { "camarillooutdoorlighting.com", true },
  { "camashop.de", true },
  { "camastowncar.com", true },
  { "cambier.org", true },
  { "cambiowatch.ch", true },
  { "cambodian.dating", true },
  { "cambridge-security.com", true },
  { "cambridgebouncers.co.uk", true },
  { "cambridgesecuritygroup.org", true },
  { "camcapital.com", true },
  { "camconn.cc", true },
  { "camda.online", true },
  { "camdesign.pl", true },
  { "camelservers.com", true },
  { "cameo-membership.uk", true },
  { "cameraviva.com.br", true },
  { "camerweb.es", true },
  { "camilomodzz.net", true },
  { "camolist.com", true },
  { "camomile.desi", true },
  { "camp-pleinsoleil.ch", true },
  { "camp.co.uk", true },
  { "campaign-ad.com", true },
  { "campaign.gov.uk", true },
  { "campaignagent.com.au", true },
  { "campaignhelpdesk.org", true },
  { "campaignwiki.org", true },
  { "campamentos.info", true },
  { "campbellapplianceheatingandair.com", true },
  { "campcambodia.org", true },
  { "campcanada.org", true },
  { "camperdays.de", true },
  { "camperlist.com", true },
  { "campermanaustralia.com", true },
  { "campertrailerfinance.com.au", true },
  { "camperverzekerd.nl", true },
  { "campfiretails.org", true },
  { "camping-seilershof.de", true },
  { "campinghuntingshooting.com", true },
  { "campingskyhooks.com", true },
  { "campistry.net", true },
  { "campula.cz", true },
  { "campus-discounts.com", true },
  { "campus-finance.com", true },
  { "campusdrugprevention.gov", false },
  { "campuswire.com", true },
  { "campvana.com", true },
  { "campwabashi.org", true },
  { "camshowstorage.com", true },
  { "camshowverse.com", true },
  { "camsky.de", false },
  { "canada-tourisme.ch", true },
  { "canadabread.com", false },
  { "canadalife.de", true },
  { "canadasmotorcycle.ca", true },
  { "canadian-nurse.com", true },
  { "canadian.dating", true },
  { "canadianchristianity.com", false },
  { "canadianoutdoorequipment.com", true },
  { "canadiantouristboard.com", true },
  { "canal-onanismo.org", true },
  { "canalsidehouse.be", true },
  { "canalsidehouse.com", true },
  { "canariculturacolor.com", true },
  { "canarymod.net", true },
  { "cancerdata.nhs.uk", true },
  { "candaceplayforth.com", true },
  { "candelec.com", true },
  { "candeo-books.nl", true },
  { "candex.com", true },
  { "candguchocolat.com", true },
  { "candicecity.com", true },
  { "candidasa.com", true },
  { "candidaturedunprix.com", true },
  { "candlcastles.co.uk", true },
  { "cando.eu", true },
  { "candyout.com", true },
  { "canerkorkmaz.com", true },
  { "cangelloplasticsurgery.com", true },
  { "cangku.in", true },
  { "cangku.moe", false },
  { "canglong.net", true },
  { "canhazip.com", true },
  { "canicaprice.com", true },
  { "canihavesome.coffee", true },
  { "canker.org", true },
  { "canlidoviz.com", true },
  { "canmipai.com", true },
  { "cannabis-marijuana.com", true },
  { "cannabismd.com", true },
  { "cannacards.ca", true },
  { "cannahealth.com", true },
  { "cannoli.london", true },
  { "cannyfoxx.me", true },
  { "canoonic.se", true },
  { "cant.at", true },
  { "cantatio.ch", true },
  { "canterberry.cc", true },
  { "canterburybouncycastlehire.co.uk", true },
  { "cantrack.com", true },
  { "canva.com", true },
  { "canx.org", true },
  { "canyonshoa.com", true },
  { "canyoupwn.me", true },
  { "cao.gov", true },
  { "cao.la", true },
  { "caodesantohumberto.com.br", true },
  { "caoshan60.com", true },
  { "capachitos.cl", true },
  { "capacityproject.org", true },
  { "capebretonpiper.com", true },
  { "capekeen.com", true },
  { "capellidipremoli.com", true },
  { "caphane.com", true },
  { "capimlimaoflores.com.br", true },
  { "capitainebaggy.ch", true },
  { "capital-match.com", true },
  { "capitalcap.com", true },
  { "capitalcollections.org.uk", true },
  { "capitalfps.com", true },
  { "capitalibre.com", true },
  { "capitalism.party", true },
  { "capitalmediaventures.co.uk", true },
  { "capitalp.jp", true },
  { "capitalquadatv.org.nz", true },
  { "capitolpathways.org", true },
  { "caplinbouncycastles.co.uk", true },
  { "capper.de", true },
  { "capriccio.to", true },
  { "caprichosdevicky.com", true },
  { "caps.is", true },
  { "capsogusto.com", true },
  { "capstansecurity.co.uk", true },
  { "capstansecurity.com", true },
  { "capstoneinsights.com", true },
  { "capsulesubs.fr", true },
  { "captain-dandelion.com", true },
  { "captainark.net", true },
  { "captainsinn.com", true },
  { "captivationtheory.com", true },
  { "capturapp.com", false },
  { "capture-app.com", true },
  { "captured-symphonies.com", true },
  { "capuchinox.com", true },
  { "caputo.com", true },
  { "caputodesign.com", true },
  { "car-shop.top", true },
  { "car.info", true },
  { "car24.de", true },
  { "car24portal.de", true },
  { "carassure.de", true },
  { "carauctionnetwork.com", true },
  { "carauctionsalabama.com", true },
  { "carauctionscarolina.com", true },
  { "carauctionsgeorgia.com", true },
  { "carauctionsillinois.com", true },
  { "carbon-designz.com", true },
  { "carbon-project.org", true },
  { "carbon12.org", true },
  { "carbon12.software", true },
  { "carboneselectricosnettosl.info", false },
  { "carbonmade.com", false },
  { "carbono.uy", true },
  { "carbontv.com", true },
  { "carburetorcycleoi.com", true },
  { "carck.co.uk", true },
  { "carck.uk", true },
  { "cardboard.cx", true },
  { "cardcaptorsakura.jp", true },
  { "carddreams.be", true },
  { "carddreams.de", true },
  { "carddreams.es", true },
  { "carddreams.nl", true },
  { "cardelmar.com", true },
  { "cardelmar.de", true },
  { "cardelmar.es", true },
  { "cardexchangesolutions.com", true },
  { "cardgames.com", true },
  { "cardios.srv.br", true },
  { "cardranking.jp", true },
  { "cardrecovery.fr", true },
  { "cardse.net", true },
  { "cardsolutionsbh.com.br", true },
  { "cardxl.be", true },
  { "cardxl.de", true },
  { "cardxl.fr", true },
  { "cardxl.nl", true },
  { "care4all.com", true },
  { "careeapp.com", true },
  { "career.support", true },
  { "careeroptionscoach.com", true },
  { "careerpower.co.in", true },
  { "careers.plus", true },
  { "carefour.nl", true },
  { "caremad.io", true },
  { "carepassport.com", true },
  { "caretta.co.uk", true },
  { "careyshop.cn", true },
  { "carezone.com", false },
  { "carfinancehelp.com", true },
  { "carfraemill.co.uk", true },
  { "cargobay.net", true },
  { "cargomaps.com", true },
  { "cargorestraintsystems.com.au", true },
  { "carhunters.cz", true },
  { "caribbean.dating", true },
  { "caribbeanarthritisfoundation.org", true },
  { "caribbeanexams.com", true },
  { "carigami.fr", true },
  { "caringladies.org", true },
  { "carinsurance.es", true },
  { "carinthia.eu", true },
  { "cariocacooking.com", true },
  { "carisenda.com", true },
  { "carkeysanantonio.com", true },
  { "carlandfaith.com", true },
  { "carlgo11.com", true },
  { "carlife-at.jp", true },
  { "carlili.fr", true },
  { "carlingfordapartments.com.au", true },
  { "carlinmack.com", true },
  { "carlmjohnson.net", true },
  { "carlo.mx", false },
  { "carlobiagi.de", true },
  { "carlocksmith--dallas.com", true },
  { "carlocksmithbaltimore.com", true },
  { "carlocksmithellicottcity.com", true },
  { "carlocksmithfallbrook.com", true },
  { "carlocksmithkey.com", true },
  { "carlocksmithlewisville.com", true },
  { "carlocksmithmesquite.com", true },
  { "carlocksmithtucson.com", true },
  { "carlosfelic.io", true },
  { "carlosjeurissen.com", true },
  { "carlot-j.com", true },
  { "carnaticalifornia.com", true },
  { "carnet-du-voyageur.com", true },
  { "carnildo.com", true },
  { "caroes.be", true },
  { "caroffer.ch", true },
  { "carol-lambert.com", true },
  { "carolcappelletti.com", true },
  { "carolcestas.com", true },
  { "caroli.com", true },
  { "caroli.name", true },
  { "caroli.net", true },
  { "carolina.cz", true },
  { "carolinaclimatecontrolsc.com", true },
  { "carolynjoyce.com.au", true },
  { "carpetandhardwoodflooringpros.com", true },
  { "carpetcleaningtomball.com", true },
  { "carrando.com", true },
  { "carre-lutz.com", true },
  { "carriedin.com", true },
  { "carrierplatform.com", true },
  { "carringtonrealtygroup.com", true },
  { "carroattrezzimilanodaluiso.it", true },
  { "carroceriascarluis.com", true },
  { "carrollservicecompany.com", true },
  { "carrosserie-dubois.com", true },
  { "carseatchecks.ca", true },
  { "carshippingcarriers.com", true },
  { "carson-aviation-adventures.com", true },
  { "carson-matthews.co.uk", true },
  { "carsoug.com", true },
  { "carspneu.cz", true },
  { "cartadeviajes.cl", true },
  { "cartadeviajes.co", true },
  { "cartadeviajes.com", true },
  { "cartadeviajes.com.ar", true },
  { "cartadeviajes.com.ve", true },
  { "cartadeviajes.de", true },
  { "cartadeviajes.ec", true },
  { "cartadeviajes.es", true },
  { "cartadeviajes.fr", true },
  { "cartadeviajes.mx", true },
  { "cartadeviajes.pe", true },
  { "cartadeviajes.uk", true },
  { "carteirasedistintivos.com.br", true },
  { "carterstad.se", true },
  { "cartertonscouts.org.nz", true },
  { "cartesentreprises-unicef.fr", true },
  { "carthedral.com", true },
  { "cartierplan.ga", true },
  { "carto.la", true },
  { "cartongesso.roma.it", true },
  { "cartooncastles.ie", true },
  { "cartoonhd.cc", true },
  { "cartouche-deal.fr", true },
  { "cartouche24.eu", true },
  { "cartucce24.it", true },
  { "cartwrightrealestate.com", true },
  { "carun.us", true },
  { "carusorealestate.com", true },
  { "caryefurd.com", true },
  { "casa-app.de", true },
  { "casa-due-pur.com", true },
  { "casa-due-pur.de", true },
  { "casa-due.com", true },
  { "casa-lunch-break.de", true },
  { "casa-lunchbreak.de", true },
  { "casa-mea-inteligenta.ro", true },
  { "casa-su.casa", true },
  { "casaanastasia.ro", true },
  { "casabouquet.com", true },
  { "casacameo.com", false },
  { "casacochecurro.com", true },
  { "casadasportasejanelas.com", true },
  { "casadoarbitro.com.br", true },
  { "casadowifi.com.br", true },
  { "casaessencias.com.br", true },
  { "casalindamex.com", true },
  { "casalunchbreak.de", true },
  { "casamariposaspi.com", true },
  { "casapalla.com.br", true },
  { "casasuara.com", true },
  { "casbia.info", true },
  { "casbuijs.nl", true },
  { "casburggraaf.com", true },
  { "casc.cz", true },
  { "cascadesjobcorpscca.com", true },
  { "cascavelle.fr", true },
  { "cascavelle.nl", true },
  { "case-vacanza-salento.com", true },
  { "casecoverkeygi.com", true },
  { "casecurity.org", true },
  { "caseof.tk", true },
  { "caseplus-daem.de", true },
  { "caseycapitalpartners.com", true },
  { "cash-4x4.com", true },
  { "cashati.com", true },
  { "cashbook.co.tz", true },
  { "cashbot.cz", true },
  { "cashfazz.com", true },
  { "cashlink.de", true },
  { "cashlink.io", true },
  { "cashlogic.ch", true },
  { "cashmaxtexas.com", true },
  { "cashplk.com", true },
  { "casino-cash-flow.su", true },
  { "casino-cashflow.ru", true },
  { "casino-online.info", true },
  { "casino-trio.com", true },
  { "casinobonuscodes.online", true },
  { "casinomucho.com", true },
  { "casinomucho.org", true },
  { "casinomucho.se", true },
  { "casinoonlinesicuri.com", true },
  { "casinovergleich.com", true },
  { "casio-caisses-enregistreuses.fr", true },
  { "casirus.com", true },
  { "casjay.cloud", true },
  { "casjay.info", true },
  { "casjay.us", true },
  { "casjaygames.com", true },
  { "caspar.ai", true },
  { "casperpanel.com", true },
  { "caspicards.com", true },
  { "cassimo.com", true },
  { "castbulletassoc.org", false },
  { "casteloinformatica.com.br", true },
  { "castible.de", true },
  { "castle-engine.io", true },
  { "castlecapers.com.au", true },
  { "castlecms.io", true },
  { "castleking.net", true },
  { "castlekingdomstockport.co.uk", true },
  { "castlekingkent.co.uk", true },
  { "castleparty.co.uk", true },
  { "castles-in-the-sky.co.uk", true },
  { "castles4kidz.com", true },
  { "castles4rascalsiow.co.uk", true },
  { "castlesrus-kent.com", true },
  { "casualdesignsfurniture.com", true },
  { "casusgrillcaribbean.com", true },
  { "cat-blum.com", true },
  { "cat-box.de", true },
  { "cat.net", true },
  { "cat73.org", true },
  { "catalog.beer", true },
  { "catalogobiblioteca.com", true },
  { "catalogoreina.com", true },
  { "catalogosvirtualesonline.com", true },
  { "catalyconv.com", true },
  { "catalystapp.co", true },
  { "catbold.space", true },
  { "catbull.com", true },
  { "catburton.co.uk", true },
  { "catchers.cc", true },
  { "catchersgear.com", true },
  { "catchfotografie.nl", true },
  { "catchhimandkeephim.com", true },
  { "catchief.com", true },
  { "catcoxx.de", true },
  { "catdecor.ru", true },
  { "catenacondos.com", true },
  { "catering-xanadu.cz", true },
  { "catfooddispensersreviews.com", true },
  { "catgirl.science", true },
  { "catharinesomerville.com", true },
  { "catharisme.eu", true },
  { "catharisme.net", true },
  { "catherinejf.com", true },
  { "catherinescastles.co.uk", true },
  { "catholics.dating", true },
  { "cathosa.nl", true },
  { "cathy.guru", true },
  { "cathy.website", true },
  { "cathyfitzpatrick.com", true },
  { "cathyjf.ca", true },
  { "cathyjf.com", true },
  { "cathyjf.net", true },
  { "cathyjf.org", true },
  { "cathyjfitzpatrick.com", true },
  { "cativa.net", true },
  { "catl.st", true },
  { "catmoose.ca", true },
  { "catnet.dk", false },
  { "cattivo.nl", false },
  { "catuniverse.org", true },
  { "catveteran.com", true },
  { "caughtredhanded.co.nz", true },
  { "caulfieldeastapartments.com.au", true },
  { "caulfieldracecourseapartments.com.au", true },
  { "caulong-ao.net", true },
  { "cav.ac", true },
  { "cavac.at", true },
  { "cave-reynard.ch", true },
  { "cavevinsdefrance.fr", true },
  { "cavzodiaco.com.br", true },
  { "caxalt.com", true },
  { "caylercapital.com", true },
  { "cazaviajes.es", true },
  { "cazes.info", true },
  { "cb-crochet.com", true },
  { "cbbank.com", true },
  { "cbc-hire.co.uk", true },
  { "cbcf.info", true },
  { "cbd.casa", true },
  { "cbd.supply", true },
  { "cbdev.de", true },
  { "cbdmarket.space", true },
  { "cbecrft.net", true },
  { "cbhq.net", true },
  { "cbin168.com", true },
  { "cbintermountainrealty.com", true },
  { "cbk-connect.com", true },
  { "cbr-xml-daily.ru", true },
  { "cbsdeheidevlinder.nl", true },
  { "cbw.sh", true },
  { "cc-brantomois.fr", true },
  { "ccac.gov", true },
  { "ccavenue.com", true },
  { "ccc-ch.ch", true },
  { "cccwien.at", true },
  { "ccgx.de", true },
  { "ccoooss.com", true },
  { "ccprwebsite.org", true },
  { "ccsource.org", true },
  { "ccss-cces.com", true },
  { "ccsys.com", true },
  { "cctvcanada.net", true },
  { "cctvview.info", true },
  { "ccu.plus", true },
  { "ccv-deutschland.de", true },
  { "ccv.ch", true },
  { "ccv.nl", true },
  { "cd-shopware.de", true },
  { "cd-sport.com", true },
  { "cd.search.yahoo.com", false },
  { "cd5k.net", true },
  { "cda-aigle.ch", true },
  { "cda-nw.co.uk", true },
  { "cdasenegal.com", true },
  { "cdasiaonline.com", false },
  { "cdbf.ch", true },
  { "cdbtech.com", true },
  { "cdburnerxp.se", true },
  { "cdda.ch", true },
  { "cdepot.eu", true },
  { "cdkeykopen.com", true },
  { "cdn.ampproject.org", true },
  { "cdn6.de", true },
  { "cdncompanies.com", true },
  { "cdnjs.com", true },
  { "cdns.cloud", true },
  { "cdnsys.net", true },
  { "cdom.de", true },
  { "cdsdigital.de", true },
  { "cdshining.com", true },
  { "cdu-wilgersdorf.de", true },
  { "cduckett.net", true },
  { "cdvl.org", true },
  { "ce-pimkie.fr", true },
  { "ceagriproducts.com", true },
  { "cebz.org", true },
  { "cecame.ch", true },
  { "ceciliacolombara.com", true },
  { "cecipu.gob.cl", true },
  { "ced-services.nl", true },
  { "cedarcitydining.com", true },
  { "cedarslodge.com", true },
  { "cedriccassimo.ch", true },
  { "cedriccassimo.com", true },
  { "cedricmartineau.com", true },
  { "ceebee.com", true },
  { "cejhon.cz", false },
  { "celcomhomefibre.com.my", true },
  { "celebmasta.com", true },
  { "celebrityhealthcritic.com", true },
  { "celebrityscope.net", true },
  { "celectro-pro.com", true },
  { "celiendev.ch", true },
  { "celine-patisserie.fr", true },
  { "cellebrite.com", true },
  { "celltek-server.de", false },
  { "celltesequ.com", true },
  { "celluliteorangeskin.com", true },
  { "celluliteremovaldiet.com", true },
  { "celtadigital.com", true },
  { "celti.ie.eu.org", true },
  { "celti.name", true },
  { "celuliteonline.com", true },
  { "cementscience.com", true },
  { "cemeteriat.com", true },
  { "ceml.ch", true },
  { "cenatorium.pl", true },
  { "cennelley.com", true },
  { "cennelly.com", true },
  { "censurfridns.dk", true },
  { "censurfridns.nu", true },
  { "censys.io", true },
  { "centa-am.com", true },
  { "centaur.de", true },
  { "centennialradon.com", true },
  { "centennialseptic.com", true },
  { "centerpereezd.ru", false },
  { "centerpoint.ovh", true },
  { "centio.bg", true },
  { "centos.tips", true },
  { "centralbank.ae", true },
  { "centralebigmat.eu", true },
  { "centralegedimat.eu", true },
  { "centralmarket.com", true },
  { "centralmissourifoundationrepair.com", true },
  { "centralpoint.be", false },
  { "centralpoint.nl", false },
  { "centralstatecu.org", true },
  { "centrationgame.com", true },
  { "centredaccueil.fr", true },
  { "centreoeil.ch", true },
  { "centrobill.com", true },
  { "centrodoinstalador.com.br", true },
  { "centrojovencuenca.es", true },
  { "centromasterin.com", true },
  { "centroperugia.gr", true },
  { "centrosocialferrel.pt", true },
  { "centrumhodinek.cz", true },
  { "centruvechisv.ro", true },
  { "centrym.top", true },
  { "centum.no", true },
  { "centura.de", true },
  { "centurialeonina.com", true },
  { "centurioninfosec.com", true },
  { "centurioninfosec.com.sg", true },
  { "centurioninfosec.hk", true },
  { "centurioninfosec.sg", true },
  { "centurionunderground.com", true },
  { "ceopedia.org", true },
  { "ceramixcoating.nl", true },
  { "ceramiya.com", true },
  { "cerastar.com", true },
  { "cerber.us", true },
  { "cerberis.com", true },
  { "cerberusinformatica.it", true },
  { "cerebelo.info", true },
  { "cerena-silver.ru", true },
  { "ceres-corp.org", true },
  { "cerivo.co.uk", true },
  { "cermak.photos", true },
  { "cernakova.eu", true },
  { "cerpus-course.com", true },
  { "cerrajeriaamericadelquindio.com", true },
  { "cert.govt.nz", true },
  { "cert.or.id", true },
  { "certaintelligence.com", true },
  { "certcenter.ch", true },
  { "certcenter.co.uk", true },
  { "certcenter.com", true },
  { "certcenter.de", true },
  { "certchannel.com", true },
  { "certevia.com", true },
  { "certfa.com", true },
  { "certible.com", true },
  { "certificatedetails.com", true },
  { "certificatespending.com", true },
  { "certificatetools.com", true },
  { "certifiedfieldassociate.com", true },
  { "certifiednurses.org", true },
  { "certmonitor.com.au", true },
  { "certmonitor.net", true },
  { "certnazionale.it", true },
  { "certspotter.com", true },
  { "certspotter.org", true },
  { "cervejista.com", true },
  { "ces-ltd.co.uk", true },
  { "cesantias.co", true },
  { "cesboard.com", true },
  { "cesdb.com", true },
  { "cesipagano.com", true },
  { "ceskepivnesety.sk", true },
  { "ceskepivnisety.cz", true },
  { "ceso-saco.com", true },
  { "cesobaly.cz", true },
  { "cestasedelicias.com.br", true },
  { "cestunmetier.ch", true },
  { "cetamol.com", true },
  { "cetangarana.com", true },
  { "ceu.edu", false },
  { "cevo.com.hr", true },
  { "ceyizlikelisleri.com", true },
  { "cf-ide.de", true },
  { "cf-tm.net", true },
  { "cfa.gov", true },
  { "cfan.space", true },
  { "cfda.gov", true },
  { "cfdcre5.org", true },
  { "cfh.com", true },
  { "cflsystems.com", true },
  { "cfno.org", true },
  { "cfo.gov", true },
  { "cfpa-formation.fr", true },
  { "cfsh.tk", true },
  { "cftc.gov", true },
  { "cftcarouge.com", true },
  { "cfttt.com", true },
  { "cfurl.cf", true },
  { "cfxdesign.com", true },
  { "cg-goerlitz.de", true },
  { "cg-systems.hu", true },
  { "cg.al", true },
  { "cg.search.yahoo.com", false },
  { "cgal.org", true },
  { "cgan.de", true },
  { "cgan.pw", true },
  { "cgbassurances.ch", true },
  { "cgbilling.com", true },
  { "cgcookiemarkets.com", true },
  { "cgnparts.com", true },
  { "cgpe.com", true },
  { "cgsmart.com", true },
  { "cgurtner.ch", true },
  { "ch-laborit.fr", true },
  { "ch-sc.de", true },
  { "ch.bzh", true },
  { "ch.search.yahoo.com", false },
  { "ch47f.com", true },
  { "chabaudparfum.com", true },
  { "chabert-provence.fr", true },
  { "chabik.com", true },
  { "chad.ch", true },
  { "chadstoneapartments.com.au", true },
  { "chaffeyconstruction.com", true },
  { "chaifeng.com", true },
  { "chainedunion.info", true },
  { "chaip.org", true },
  { "chaisystems.net", true },
  { "chaletdemontagne.org", true },
  { "chaletmanager.com", true },
  { "chaletpierrot.ch", true },
  { "chaleur.com", true },
  { "chalker.io", true },
  { "challengeblog.org", true },
  { "challstrom.com", true },
  { "chamathellawala.com", true },
  { "chambion.ch", true },
  { "chamicro.com", true },
  { "champdogs.co.uk", true },
  { "champdogs.com", true },
  { "champicreuse.fr", true },
  { "championcastles.ie", true },
  { "champions.co", true },
  { "championsofpowerfulliving.com", true },
  { "championweb.co.nz", true },
  { "championweb.com", true },
  { "championweb.com.au", true },
  { "championweb.com.sg", true },
  { "championweb.nz", true },
  { "championweb.sg", true },
  { "champonthis.de", true },
  { "champserver.net", false },
  { "chancekorte.com", true },
  { "chanddriving.co.uk", true },
  { "chandr1000.ga", true },
  { "chang-feng.info", true },
  { "changecopyright.ru", true },
  { "changes.jp", true },
  { "changesfor.life", true },
  { "changethislater.com", true },
  { "channeladam.com", true },
  { "chanoyu-gakkai.jp", true },
  { "chanshiyu.com", false },
  { "chantalguggenbuhl.ch", true },
  { "chanz.com", true },
  { "chaos-games.org", true },
  { "chaos-inc.de", true },
  { "chaos.run", true },
  { "chaoschemnitz.de", true },
  { "chaosdorf.de", true },
  { "chaosfield.at", true },
  { "chaoslab.org", true },
  { "chaospott.de", true },
  { "chaosriftgames.com", true },
  { "chaoswars.ddns.net", true },
  { "chaotichive.com", true },
  { "chapelaria.tf", true },
  { "chapelfordbouncers.co.uk", true },
  { "chapiteauxduleman.fr", true },
  { "chaplain.co", true },
  { "charbonnel.eu", true },
  { "charcoal-se.org", true },
  { "charcoalvenice.com", true },
  { "charge.co", true },
  { "chargedmonkey.com", true },
  { "chargify.com", true },
  { "charisma.ai", true },
  { "charissadescande.com", true },
  { "charitylog.co.uk", true },
  { "charlenevondell.com", true },
  { "charles-darwin.com", true },
  { "charlesbwise.com", true },
  { "charlesmilette.net", true },
  { "charlespitonltd.com", true },
  { "charlesrogers.co.uk", true },
  { "charlesstover.com", true },
  { "charlestonfacialplastic.com", true },
  { "charliedillon.com", true },
  { "charliegarrod.com", true },
  { "charliehr.com", true },
  { "charlierogers.co.uk", true },
  { "charlierogers.com", true },
  { "charlotte-touati.ch", true },
  { "charlotteomnes.com", true },
  { "charlottesvillegolfcommunities.com", true },
  { "charlottesvillehorsefarms.com", true },
  { "charlotteswimmingpoolbuilder.com", true },
  { "charmander.me", true },
  { "charmanterelefant.at", true },
  { "charmingsaul.com", true },
  { "charr.xyz", true },
  { "chars.ga", true },
  { "charta-digitale-vernetzung.de", true },
  { "charteroak.org", true },
  { "chartkick.com", true },
  { "chartpen.com", true },
  { "chartsy.de", true },
  { "chartwellestate.com", true },
  { "charuru.moe", false },
  { "chascrazycreations.com", true },
  { "chaseandzoey.de", true },
  { "chasetrails.co.uk", true },
  { "chat-house-adell.com", true },
  { "chat-libera.org", true },
  { "chat-senza-registrazione.net", true },
  { "chat.cz", true },
  { "chat2.cf", true },
  { "chat40.net", true },
  { "chatbelgie.eu", true },
  { "chatbotclic.com", true },
  { "chatbotclick.com", true },
  { "chatbots.systems", true },
  { "chatear.social", true },
  { "chateau-de-lisle.fr", true },
  { "chateaudestrainchamps.com", true },
  { "chatfacile.org", true },
  { "chatgrape.com", true },
  { "chatint.com", true },
  { "chatitaly.org", true },
  { "chatme.im", false },
  { "chatnederland.eu", true },
  { "chatsworthelectrical.com", true },
  { "chatt-gratis.net", true },
  { "chatt-gratis.org", true },
  { "chattanoogaface.com", true },
  { "chattergalerie.eu", true },
  { "chattergallery.com", true },
  { "chattersworld.nl", true },
  { "chatu.io", true },
  { "chatu.me", true },
  { "chatucomputers.com", true },
  { "chatxsingle.net", true },
  { "chatxtutti.com", true },
  { "chatzimanolis.com", true },
  { "chatzimanolis.gr", true },
  { "chauffage-budget.fr", true },
  { "chaurocks.com", true },
  { "chaussenot.net", true },
  { "chavetaro.com", true },
  { "chaz6.com", true },
  { "chazalet.fr", true },
  { "chazay.net", false },
  { "chazgie.se", true },
  { "chbk.co", true },
  { "chbs.me", true },
  { "chch.it", true },
  { "chci-web.cz", true },
  { "chcoc.gov", true },
  { "chcsct.com", true },
  { "chd-expert.fr", true },
  { "cheap-colleges.com", true },
  { "cheapalarmparts.com.au", true },
  { "cheapcaribbean.com", true },
  { "cheapessay.net", true },
  { "cheapestgamecards.at", true },
  { "cheapestgamecards.be", true },
  { "cheapestgamecards.co.uk", true },
  { "cheapestgamecards.com", true },
  { "cheapestgamecards.de", true },
  { "cheapestgamecards.fi", true },
  { "cheapestgamecards.fr", true },
  { "cheapestgamecards.nl", true },
  { "cheapestgamecards.no", true },
  { "cheapestgamecards.se", true },
  { "cheapgeekts.com", false },
  { "cheapgoa.com", true },
  { "cheapiesystems.com", true },
  { "cheapssl.com.tr", true },
  { "cheapticket.in", true },
  { "cheatengine.pro", true },
  { "check.torproject.org", false },
  { "checkecert.nl", true },
  { "checkjelinkje.nl", true },
  { "checkmyessay.com", true },
  { "checkmyessays.com", true },
  { "checkmyip.com", true },
  { "checkmypsoriasis.com", true },
  { "checkout.google.com", true },
  { "checkpoint-tshirt.com", true },
  { "checkrente.nl", true },
  { "checkspf.net", true },
  { "checktype.com", true },
  { "checkui.com", true },
  { "checkyourmath.com", true },
  { "checkyourprivilege.org", true },
  { "checkyourreps.org", true },
  { "checos.co.uk", true },
  { "cheddarpayments.com", true },
  { "cheekycharliessoftplay.co.uk", true },
  { "cheekymonkeysinflatables.co.uk", true },
  { "cheela.org", true },
  { "cheeseemergency.co.uk", true },
  { "cheez.systems", true },
  { "cheezflix.uk", true },
  { "chefwear.com", true },
  { "chehalemgroup.com", true },
  { "cheladmin.ru", true },
  { "cheltenhambounce.co.uk", true },
  { "cheltenhambouncycastles.co.uk", true },
  { "cheltik.ru", true },
  { "chemicalcrux.org", true },
  { "chemiphys.com", true },
  { "chemistry-schools.com", true },
  { "chenapartment.com", true },
  { "chengxindong.com", true },
  { "chenkun.pro", true },
  { "chenna.me", true },
  { "chennien.com", true },
  { "chenpei.org", true },
  { "chenqinghua.com", true },
  { "chentianyi.cn", true },
  { "chenzhekl.me", true },
  { "chenzhipeng.com.cn", true },
  { "cheolguso.com", true },
  { "cherevoiture.com", true },
  { "cherie-belle.com", true },
  { "cherrett.digital", true },
  { "cherry-green.ch", true },
  { "cherryonit.com", true },
  { "cherrywoodtech.com", true },
  { "chertseybouncycastles.co.uk", true },
  { "chesapeakebaychristmas.com", true },
  { "chess.com", true },
  { "chessboardao.com", true },
  { "chesscoders.com", true },
  { "chesskid.com", true },
  { "chesspoint.ch", true },
  { "chesterlestreetasc.co.uk", false },
  { "chestnut.cf", true },
  { "chevy37.com", true },
  { "chevymotor-occasions.be", true },
  { "chewey.de", true },
  { "chewey.org", true },
  { "chewingucand.com", true },
  { "chez-oim.org", true },
  { "chez.moe", true },
  { "chfr.search.yahoo.com", false },
  { "chhory.com", true },
  { "chhy.at", true },
  { "chiaraiuola.com", false },
  { "chiaseeds24.com", true },
  { "chiboard.co", true },
  { "chibr.eu", true },
  { "chic-leather.com", true },
  { "chicagolug.org", true },
  { "chicagostudentactivists.org", true },
  { "chicisimo.com", true },
  { "chicolawfirm.com", true },
  { "chiemgauflirt.de", true },
  { "chif16.at", true },
  { "chikazawa.info", true },
  { "childcare.gov", true },
  { "childcounseling.org", true },
  { "childcustodylegalaid.org", true },
  { "childno.de", true },
  { "childrenandmedia.org.au", true },
  { "childrenfirstalways.org", true },
  { "childreninadversity.gov", true },
  { "childrens-room.com", true },
  { "childrensentertainmentleicester.co.uk", true },
  { "childrenspartiesrus.com", true },
  { "childstats.gov", true },
  { "childvisitationassistance.org", true },
  { "childwelfare.gov", true },
  { "chilihosting.eu", true },
  { "chilimath.com", true },
  { "chilimathwords.com", true },
  { "chilio.net", true },
  { "chillebever.nl", true },
  { "chima.net", true },
  { "chima.us", true },
  { "chimeratool.com", true },
  { "chimerity.com", true },
  { "chimpanzee.net", true },
  { "chinahighlights.ru", true },
  { "chinaspaceflight.com", true },
  { "chinatrademarkoffice.com", true },
  { "ching.tv", true },
  { "chint.ai", true },
  { "chinwag.im", true },
  { "chinwag.org", true },
  { "chipcore.com", false },
  { "chipglobe.com", true },
  { "chippy.ch", false },
  { "chips-scheduler.de", true },
  { "chiralsoftware.com", true },
  { "chireiden.net", true },
  { "chiro-neuchatel.ch", true },
  { "chiropractic.gr", true },
  { "chiropracticwpb.com", true },
  { "chiropraktik-riemann.de", true },
  { "chiropraticien-neuchatel.ch", true },
  { "chiropratique-neuchatel.ch", true },
  { "chirosphere.ch", true },
  { "chirpstory.com", true },
  { "chiru.no", true },
  { "chisago-isantidfl.com", true },
  { "chit.search.yahoo.com", false },
  { "chitoku.jp", false },
  { "chksite.com", true },
  { "chl.la", true },
  { "chloescastles.co.uk", true },
  { "chlth.com", true },
  { "chmielarz.it", true },
  { "chmsoft.com.ua", true },
  { "chmsoft.ru", true },
  { "chmurakotori.ml", true },
  { "choc-o-lush.co.uk", true },
  { "chocgu.com", true },
  { "chocodecor.com.br", true },
  { "chocolah.com.au", false },
  { "chocolat.work", true },
  { "chocolatesandhealth.com", true },
  { "chocolatier-tristan.ch", true },
  { "chocolytech.info", true },
  { "chocotough.nl", true },
  { "choiceautoloan.com", true },
  { "chokladfantasi.net", true },
  { "chomp.life", true },
  { "chon.io", true },
  { "chonghe.org", true },
  { "chook.as", true },
  { "choootto.club", true },
  { "choosemypc.net", true },
  { "chopperdesign.com", true },
  { "chorkley.co.uk", true },
  { "chorkley.com", true },
  { "chorkley.uk", true },
  { "chorpinkpoemps.de", true },
  { "chosenplaintext.org", true },
  { "chotlo.com", true },
  { "chourishi-shigoto.com", true },
  { "chovancova.sk", true },
  { "chowii.com", true },
  { "choyri.com", true },
  { "chris-edwards.net", true },
  { "chrisaitch.com", true },
  { "chrisb.me", true },
  { "chrisb.xyz", true },
  { "chrisbryant.me.uk", true },
  { "chrisburnell.com", true },
  { "chriscarey.com", true },
  { "chriscowley.me.uk", true },
  { "chrisdecairos.ca", true },
  { "chrisirwin.ca", true },
  { "chrisjean.com", true },
  { "chrislane.com", true },
  { "chrismathys.com", true },
  { "chrismcclendon.com", true },
  { "chrismckee.co.uk", true },
  { "chrismorgan.info", true },
  { "chrismurrayfilm.com", true },
  { "chrisnekarda.com", true },
  { "chrisplankhomes.com", true },
  { "chrispstreet.com", true },
  { "christadelphiananswers.org", true },
  { "christadelphians.eu", true },
  { "christchurchbouncycastles.co.uk", true },
  { "christec.net", true },
  { "christensenplace.us", true },
  { "christerwaren.fi", true },
  { "christiaanconover.com", true },
  { "christian-fischer.pictures", true },
  { "christian-folini.ch", true },
  { "christian-gredig.de", true },
  { "christian-host.com", true },
  { "christian-liebel.com", true },
  { "christian-stadelmann.de", true },
  { "christianbargon.de", false },
  { "christiancleva.com", true },
  { "christiancoleman.info", true },
  { "christianfaq.org", true },
  { "christianforums.com", true },
  { "christiangehring.org", true },
  { "christianillies.de", true },
  { "christianjens.com", true },
  { "christianliebel.com", true },
  { "christianlis.org.uk", true },
  { "christianlis.uk", true },
  { "christianpeltier.com", true },
  { "christianpilgrimage.com.au", true },
  { "christians.dating", true },
  { "christianscholz.de", false },
  { "christiehawkes.com", true },
  { "christiesantiques.com", true },
  { "christmascard.be", true },
  { "christmaspartyhire.co.uk", true },
  { "christoph-conrads.name", true },
  { "christophbartschat.com", true },
  { "christopher-simon.de", true },
  { "christopher.sh", true },
  { "christopherandcharlotte.uk", true },
  { "christopherburg.com", true },
  { "christopherkennelly.com", true },
  { "christopherl.com", true },
  { "christopherstocks.online", true },
  { "christophertruncer.com", true },
  { "christophsackl.de", true },
  { "christthekingparish.net", true },
  { "christtheredeemer.us", true },
  { "christwaycounseling.com", true },
  { "chriswald.com", true },
  { "chriswarrick.com", true },
  { "chriswbarry.com", true },
  { "chriswells.io", true },
  { "chromcraft-revington.com", true },
  { "chrome-devtools-frontend.appspot.com", true },
  { "chrome.com", false },
  { "chrome.google.com", true },
  { "chromebookchart.com", true },
  { "chromebooksforwork.com", true },
  { "chromiumbugs.appspot.com", true },
  { "chromiumcodereview.appspot.com", false },
  { "chroniclesofgeorge.com", true },
  { "chronology.no", true },
  { "chronoshop.cz", true },
  { "chrpaul.de", true },
  { "chrstn.eu", true },
  { "chrysanthos.net", true },
  { "chshouyu.com", true },
  { "chsterz.de", true },
  { "chuchote-moi.fr", true },
  { "chuck.ovh", true },
  { "chuill.com", true },
  { "chun.pro", true },
  { "chunche.net", true },
  { "chunk.science", true },
  { "chupadelfrasco.com", true },
  { "chuppa.com.au", true },
  { "churchofsaintrocco.org", true },
  { "churchofscb.org", true },
  { "churchthemes.com", true },
  { "churchwebcanada.ca", true },
  { "churchwebsupport.com", true },
  { "churningtracker.com", true },
  { "chybeck.net", true },
  { "chyen.cc", true },
  { "chytraauta.cz", true },
  { "chziyue.com", true },
  { "ci-fo.org", true },
  { "ci-suite.com", true },
  { "ci5.me", true },
  { "ciancode.com", true },
  { "ciania.pl", true },
  { "cianmawhinney.me", true },
  { "ciansc.com", true },
  { "ciaracode.com", true },
  { "ciat.no", false },
  { "cibercactus.com", true },
  { "cidbot.com", true },
  { "cidersus.com.ec", true },
  { "cie-theatre-montfaucon.ch", true },
  { "cielbleu.org", true },
  { "cielly.com", true },
  { "cierreperimetral.com", true },
  { "cifop-numerique.fr", true },
  { "ciftlikesintisi.com", true },
  { "cig-dem.com", true },
  { "cigar-cartel.com", true },
  { "ciiex.co", true },
  { "cilloc.be", true },
  { "cima-idf.fr", true },
  { "cimballa.com", true },
  { "cimfax.com", true },
  { "cinafilm.com", true },
  { "cindydudley.com", true },
  { "cine-music.de", true },
  { "cine.to", true },
  { "cinefilzonen.se", true },
  { "cinefun.net", true },
  { "cinemarxism.com", true },
  { "cinemasetfree.com", true },
  { "cinemysticism.com", true },
  { "cineplex.my", true },
  { "cinerama.com.br", false },
  { "cinnabon.com", true },
  { "cinq-elements.com", true },
  { "cinq-elements.fr", true },
  { "cinq-elements.net", true },
  { "cinsects.de", true },
  { "cinteo.com", true },
  { "cio-ciso-interchange.org", true },
  { "cio-cisointerchange.org", true },
  { "cio.go.jp", true },
  { "cio.gov", false },
  { "cioscloud.com", true },
  { "cip.md", true },
  { "cipartyhire.co.uk", true },
  { "cipher.team", true },
  { "cipherboy.com", true },
  { "ciphersuite.info", true },
  { "ciphrex.com", true },
  { "cipri.com", true },
  { "cipri.net", true },
  { "cipri.nl", true },
  { "cipri.org", true },
  { "cipria.no", true },
  { "cipy.com", true },
  { "cir.is", true },
  { "circady.com", true },
  { "circara.com", true },
  { "circle-people.com", true },
  { "circu.ml", true },
  { "circulatedigital.com", true },
  { "circule.cc", true },
  { "ciri.com.co", true },
  { "cirope.com", true },
  { "cirrus0.de", true },
  { "cirugiasplasticas.com.mx", true },
  { "cirujanooral.com", true },
  { "cirurgicagervasio.com.br", true },
  { "cirurgicalucena.com.br", true },
  { "cirurgicasalutar.com.br", true },
  { "ciscodude.net", true },
  { "cisoaid.com", true },
  { "cisofy.com", true },
  { "cispeo.org", true },
  { "ciss.ltd", true },
  { "cisum-cycling.com", true },
  { "cisy.me", true },
  { "citcuit.in", true },
  { "cities.cl", true },
  { "citimarinestore.com", true },
  { "citizen-cam.de", true },
  { "citizensbankal.com", true },
  { "citizenscience.gov", false },
  { "citizenslasvegas.com", true },
  { "citizensleague.org", true },
  { "citizenspact.eu", true },
  { "citizing.org", true },
  { "citrusui.me", true },
  { "cittadesign.com", false },
  { "citton.com.br", true },
  { "city-adm.lviv.ua", true },
  { "city-walks.info", true },
  { "citya.com", true },
  { "citybeat.de", true },
  { "cityfloorsupply.com", true },
  { "citylights.eu", true },
  { "citymoobel.ee", true },
  { "cityoftitans.com", true },
  { "cityoftitansmmo.com", true },
  { "citysportapp.com", true },
  { "cityworksonline.com", true },
  { "ciubotaru.tk", true },
  { "ciurcasdan.eu", true },
  { "civicforum.pl", true },
  { "civilbikes.com", true },
  { "civilg20.org", true },
  { "civillines.nl", true },
  { "civiltoday.com", true },
  { "cj-espace-vert.fr", true },
  { "cj-jackson.com", true },
  { "cjdby.net", true },
  { "cjdpenterprises.com", true },
  { "cjdpenterprises.com.au", true },
  { "cjean.fr", true },
  { "cjey.me", true },
  { "cjhzp.net", true },
  { "cjr.host", true },
  { "ck.cx", true },
  { "ckenelley.com", true },
  { "ckenelly.com", true },
  { "ckenely.com", true },
  { "ckenneley.com", true },
  { "ckennelley.com", true },
  { "ckennelly.com", true },
  { "ckennely.com", true },
  { "ckleemann.de", true },
  { "cklie.de", true },
  { "ckliemann.com", true },
  { "ckliemann.net", true },
  { "ckostecki.de", true },
  { "cktennis.com", true },
  { "cl.search.yahoo.com", false },
  { "cl0ud.space", true },
  { "clacetandil.com.ar", true },
  { "claimconnect.com", true },
  { "claimconnect.us", true },
  { "claimjeidee.be", true },
  { "claimnote.com", true },
  { "clairegold.com", true },
  { "clairescastles.co.uk", true },
  { "clanebouncycastles.com", true },
  { "clangwarnings.com", true },
  { "clanrose.org.uk", true },
  { "clanwarz.com", true },
  { "clarkeaward.com", true },
  { "clarkwinkelmann.com", true },
  { "clase3.tk", true },
  { "clash-movies.de", true },
  { "clash.lol", true },
  { "class.com.au", true },
  { "classdojo.com", true },
  { "classicalpilates.ca", true },
  { "classics.io", true },
  { "classictheatrecumbria.co.uk", true },
  { "classpoint.cz", true },
  { "classroom.google.com", true },
  { "classroomconductor.com", true },
  { "classroomcountdown.co.nz", true },
  { "classteaching.com.au", true },
  { "classyvaper.de", true },
  { "claster.it", true },
  { "claude-leveille.com", true },
  { "claude.tech", true },
  { "claudia-urio.com", true },
  { "claus-bahr.de", true },
  { "clauseriksen.net", true },
  { "clawe.de", true },
  { "clawhammer.dk", true },
  { "clayandcottonkirkwood.com", true },
  { "claygregory.com", true },
  { "clayprints.com", true },
  { "claytonstowing.com.au", true },
  { "clazzrooms.com", true },
  { "cldfile.com", true },
  { "cldly.com", true },
  { "cleanapproachnw.com", true },
  { "cleanbrowsing.org", true },
  { "cleancode.club", true },
  { "cleandetroit.org", true },
  { "cleandogsnederland.nl", true },
  { "cleanfiles.us", true },
  { "cleanhouse2000.us", true },
  { "cleaningbyrosie.com", true },
  { "cleaningservicejulai.com", true },
  { "cleansewellness.com", true },
  { "clearance365.co.uk", true },
  { "clearblueday.co.uk", true },
  { "clearbookscdn.uk", true },
  { "clearbreezesecuritydoors.com.au", true },
  { "clearip.com", true },
  { "clearkonjac.com", true },
  { "clearsettle-admin.com", true },
  { "clearvoice.com", true },
  { "clemenscompanies.com", true },
  { "clement-beaufils.fr", true },
  { "clementfevrier.fr", true },
  { "cles-asso.fr", true },
  { "cles.jp", true },
  { "clevergod.net", true },
  { "clevertarget.ru", true },
  { "clevisto.com", true },
  { "cleysense.com", true },
  { "clic-et-site.com", true },
  { "clicandfioul.com", true },
  { "clicecompre.com.br", true },
  { "clicheshishalounge.co.uk", true },
  { "click-licht.de", true },
  { "click4web.com", true },
  { "clickclock.cc", true },
  { "clickenergy.com.au", true },
  { "clickingmad.com", true },
  { "clickphish.com", true },
  { "clicksaveandprint.com", true },
  { "clien.net", true },
  { "client.coach", true },
  { "clientboss.com", true },
  { "clientsecure.me", true },
  { "clifflu.net", true },
  { "climaprecio.es", true },
  { "climateinteractive.org", true },
  { "climatestew.com", true },
  { "clindoeilmontagne.com", true },
  { "clingout.com", true },
  { "clinicadam.com", true },
  { "clinicadelogopedia.net", true },
  { "clinicalrehabilitation.info", true },
  { "clinicaltrials.gov", true },
  { "clinicasmedicas.com.br", true },
  { "clinicminds.com", true },
  { "cliniquecomplementaire.com", true },
  { "cliniquevethuy.be", true },
  { "clintonlibrary.gov", true },
  { "clintonplasticsurgery.com", true },
  { "clipclip.com", true },
  { "clippings.com", true },
  { "clive.io", true },
  { "clmde.de", true },
  { "clnc.to", true },
  { "clnnet.ch", true },
  { "cloaked.ch", true },
  { "clochix.net", true },
  { "clockcaster.com", true },
  { "clockworksms.com", true },
  { "clod-hacking.com", true },
  { "cloppenburg-autmobil.com", true },
  { "cloppenburg-automobil.com", true },
  { "clorophilla.net", true },
  { "closeli.cn", true },
  { "closelinksecurity.co.uk", true },
  { "closelinksecurity.com", true },
  { "closetemail.com", true },
  { "cloud-surfer.net", false },
  { "cloud.bugatti", true },
  { "cloud.fail", true },
  { "cloud.google.com", true },
  { "cloud.gov", true },
  { "cloud42.ch", false },
  { "cloud9bouncycastlehire.com", true },
  { "cloudapps.digital", true },
  { "cloudbolin.es", true },
  { "cloudbrothers.info", true },
  { "cloudcactuar.com", false },
  { "cloudcaprice.net", true },
  { "cloudchart.site", true },
  { "cloudcite.net", true },
  { "cloudcloudcloud.cloud", true },
  { "cloudcrux.net", true },
  { "cloudey.net", true },
  { "cloudflare-dns.com", true },
  { "cloudflare.com", true },
  { "cloudflareonazure.com", true },
  { "cloudia.org", true },
  { "cloudily.com", true },
  { "cloudkeep.nl", true },
  { "cloudkit.pro", false },
  { "cloudland.club", true },
  { "cloudlessdreams.com", true },
  { "cloudlight.biz", true },
  { "cloudnote.cc", true },
  { "cloudns.net", true },
  { "cloudoptimizedsmb.com", true },
  { "cloudoptimus.com", true },
  { "cloudpipes.com", true },
  { "cloudse.co.uk", true },
  { "cloudsecurityalliance.org", true },
  { "cloudservice.io", true },
  { "cloudservices.nz", true },
  { "cloudsign.jp", true },
  { "cloudspace-analytics.com", true },
  { "cloudspeedy.net", true },
  { "cloudspire.net", true },
  { "cloudtocloud.tk", true },
  { "cloudtropia.de", true },
  { "cloudtskr.com", true },
  { "cloudup.com", true },
  { "clouz.de", true },
  { "cloveros.ga", true },
  { "clownindeklas.nl", true },
  { "cloxy.com", true },
  { "clr3.com", true },
  { "clsfoundationrepairandwaterproofing.com", true },
  { "clsimage.com", true },
  { "clsoft.ch", true },
  { "clu-in.org", true },
  { "club-adulti.ro", true },
  { "club-climate.com", true },
  { "club-corsicana.de", true },
  { "club-creole.com", true },
  { "club-duomo.com", true },
  { "club-is.ru", true },
  { "club-premiere.com", true },
  { "club-reduc.com", true },
  { "club-slow.jp", true },
  { "club-yy.com", true },
  { "club103.ch", true },
  { "clubcorsavenezuela.com", true },
  { "clubdelzapato.com", true },
  { "clubedalutashop.com", true },
  { "clubefiel.com.br", true },
  { "clubempleos.com", true },
  { "clubeohara.com", true },
  { "clubfamily.de", true },
  { "clubgalaxy.futbol", true },
  { "clubiconkenosha.com", true },
  { "clubmate.rocks", true },
  { "clubmini.jp", true },
  { "clubnoetig-ink2g.de", true },
  { "clubon.space", true },
  { "clueful.ca", true },
  { "cluster.biz.tr", true },
  { "clusteranalyse.net", true },
  { "clusterfuck.nz", true },
  { "clustermaze.net", true },
  { "clweb.ch", true },
  { "cm.center", true },
  { "cmacacias.ch", true },
  { "cmadeangelis.it", true },
  { "cmc.pt", true },
  { "cmcelectrical.com", true },
  { "cmcressy.ch", true },
  { "cmdline.org", true },
  { "cme-colleg.de", true },
  { "cmf.qc.ca", true },
  { "cmfaccounting.com", true },
  { "cmftech.com", true },
  { "cmgacheatcontrol.com", true },
  { "cmillrehab.com", true },
  { "cmitao.com", true },
  { "cmlachapelle.ch", true },
  { "cmlancy.ch", true },
  { "cmlignon.ch", true },
  { "cmn-group.com", true },
  { "cmn-groupe.com", true },
  { "cmngroup.com", true },
  { "cmngroupe.com", true },
  { "cmplainpalais.ch", true },
  { "cms-weble.jp", true },
  { "cmskeyholding.co.uk", true },
  { "cmskeyholding.com", true },
  { "cmv.gr", true },
  { "cmylife.nl", true },
  { "cn.search.yahoo.com", false },
  { "cn8522.com", true },
  { "cna-aiic.ca", true },
  { "cna5.cc", true },
  { "cnam-idf.fr", true },
  { "cnatraining.network", true },
  { "cnbs.ch", true },
  { "cnc-lehrgang.de", true },
  { "cncado.net", true },
  { "cncbazar365.com", true },
  { "cncrans.ch", true },
  { "cnet-hosting.com", true },
  { "cni-certing.it", true },
  { "cnnet.in", true },
  { "cnre.eu", true },
  { "cnvt.fr", true },
  { "co-factor.ro", true },
  { "co-founder-stuttgart.de", true },
  { "co.search.yahoo.com", false },
  { "co50.com", true },
  { "coachezmoi.ch", true },
  { "coachfederation.ro", true },
  { "coaching-impulse.ch", true },
  { "coalitionministries.org", true },
  { "coalpointcottage.com", true },
  { "coam.co", true },
  { "coastline.net.au", true },
  { "coathangastrangla.com", true },
  { "coathangastrangler.com", true },
  { "coathangerstrangla.com", true },
  { "coathangerstrangler.com", true },
  { "coatl-industries.com", false },
  { "cobalt.io", true },
  { "cobaltgp.com", true },
  { "cobaltis.co.uk", true },
  { "cobracastles.co.uk", true },
  { "cocaine-import.agency", true },
  { "cocaine.ninja", true },
  { "cocalc.com", true },
  { "cocareonline.com", true },
  { "cocinoyo.com", true },
  { "cock.li", true },
  { "cocktail-shaken.nl", true },
  { "cockybot.com", true },
  { "coco-line.ch", true },
  { "cocoaheads.at", false },
  { "cocoamexico.com", true },
  { "cocodroid.com", true },
  { "coconutoil24.com", true },
  { "cocoscastles.co.uk", true },
  { "cocquyt-usedcars.be", true },
  { "cocubes.com", true },
  { "coda.io", true },
  { "coda.moe", true },
  { "coda.today", true },
  { "coda.world", true },
  { "codabix.com", true },
  { "codabix.de", true },
  { "code-golf.io", true },
  { "code-poets.co.uk", true },
  { "code-vikings.de", true },
  { "code-well.com", true },
  { "code.facebook.com", false },
  { "code.fm", true },
  { "code.google.com", true },
  { "code.taxi", true },
  { "code67.com", true },
  { "codeandpeace.com", true },
  { "codebrahma.com", false },
  { "codebreaking.org", true },
  { "codecommunity.io", true },
  { "codedelarouteenligne.fr", true },
  { "codedump.net", true },
  { "codeeclipse.com", true },
  { "codeferm.com", true },
  { "codefordus.de", true },
  { "codefordus.nrw", true },
  { "codehz.one", true },
  { "codein.ca", true },
  { "codeine.co.uk", true },
  { "codeit.guru", true },
  { "codeit.us", true },
  { "codejots.com", true },
  { "codemill.se", true },
  { "codemonster.eu", true },
  { "codenode.io", true },
  { "codeofthenorth.com", true },
  { "codepoints.net", true },
  { "codepref.com", true },
  { "codepult.com", true },
  { "codera.co.uk", true },
  { "codercross.com", true },
  { "codereview.appspot.com", false },
  { "codereview.chromium.org", false },
  { "coderme.com", true },
  { "coderware.co.uk", true },
  { "codes.pk", true },
  { "codesplain.in", true },
  { "codesport.io", true },
  { "codespromo.be", true },
  { "codestudies.net", true },
  { "codesyncro.com", true },
  { "codetheworld.com", true },
  { "codetripping.net", true },
  { "codeux.com", false },
  { "codeux.info", false },
  { "codeux.net", false },
  { "codevat.com", true },
  { "codeventure.de", true },
  { "codeversetech.com", true },
  { "codewild.de", true },
  { "codexpo.net", true },
  { "codeyellow.nl", true },
  { "codific.com", true },
  { "codific.eu", true },
  { "codigo-bonus-bet.es", true },
  { "codigosddd.com.br", true },
  { "codimaker.com", true },
  { "coding-minds.com", true },
  { "coding.lv", true },
  { "coding.net", true },
  { "codingforspeed.com", true },
  { "codingfromhell.net", true },
  { "codinginfinity.me", true },
  { "codingrobots.com", true },
  { "codxg.org", true },
  { "codyevanscomputer.com", true },
  { "codyqx4.com", true },
  { "codyscafesb.com", true },
  { "coens.me.uk", true },
  { "coentropic.com", true },
  { "cofbev.com", true },
  { "coffee-mamenoki.jp", true },
  { "coffeeandteabrothers.com", true },
  { "coffeetime.fun", true },
  { "cogala.eu", true },
  { "cogent.cc", true },
  { "cogilog.com", true },
  { "cogitoltd.com", true },
  { "cognicom-gaming.com", true },
  { "cognitip.com", true },
  { "cognitivecomputingconsortium.com", true },
  { "cognitohq.com", true },
  { "cogsquad.house", true },
  { "coi-verify.com", true },
  { "coiffeurschnittstelle.ch", true },
  { "coigach-assynt.org", true },
  { "coimmvest.com", true },
  { "coin-quest.net", true },
  { "coin.dance", true },
  { "coinapult.com", true },
  { "coinbase.com", true },
  { "coinbit.trade", true },
  { "coincealed.com", true },
  { "coinchat.im", true },
  { "coincoele.com.br", true },
  { "coincoin.eu.org", true },
  { "coincolors.co", true },
  { "coindatabase.net", true },
  { "coindeal.com", true },
  { "coinf.it", true },
  { "coinflux.com", true },
  { "coingate.com", true },
  { "coinlist.co", false },
  { "coinloan.io", true },
  { "coinmewallet.com", true },
  { "coinpit.io", true },
  { "coinroom.com", true },
  { "coins2001.ru", true },
  { "coinx.pro", true },
  { "coisasdemulher.org", true },
  { "cojam.ru", true },
  { "cojo.eu", true },
  { "cokebar.info", true },
  { "col.la", true },
  { "colaborativa.tv", true },
  { "colapsys.net", true },
  { "colasjourdain.fr", true },
  { "coldawn.com", false },
  { "coldcardwallet.com", true },
  { "coldfff.com", false },
  { "coldhak.ca", true },
  { "coldstreamcreekfarm.com", true },
  { "colectivointerconductual.com", true },
  { "colegiocierp.com.br", true },
  { "colemak.com", true },
  { "colengo.com", true },
  { "colf.online", true },
  { "colibris.xyz", true },
  { "colinchartier.com", true },
  { "colincogle.name", true },
  { "colinsnaith.co.uk", true },
  { "colinstark.ca", true },
  { "collabora-office.com", true },
  { "collabora.ca", true },
  { "collabora.co.kr", true },
  { "collabora.co.uk", true },
  { "collabora.com", true },
  { "collabora.kr", true },
  { "collabora.ninja", true },
  { "collabora.social", true },
  { "collabora.uk", true },
  { "collaboracloudsuite.com", true },
  { "collaboraoffice.co.uk", true },
  { "collaboraoffice.com", true },
  { "collabornation.net", true },
  { "collaction.hk", true },
  { "collada.org", true },
  { "collectdocs.com", true },
  { "collectfood.com", true },
  { "collectiblebeans.com", true },
  { "collectivesupply.com", true },
  { "collectorknives.net", true },
  { "collectorsystems.com", true },
  { "collegeconnexxions.com.au", true },
  { "collegenavigator.gov", true },
  { "collegeprospectsofcentralindiana.com", true },
  { "collegestationhomes.com", true },
  { "collinel-hossari.com", true },
  { "collinelhossari.com", true },
  { "collinklippel.com", true },
  { "collinmbarrett.com", true },
  { "colombian.dating", true },
  { "coloppe.com", true },
  { "coloraid.net", true },
  { "colorblindprogramming.com", true },
  { "colorbrush.ru", true },
  { "colorcodedlyrics.com", true },
  { "colorectalcompounding.com", true },
  { "colorfuldots.com", true },
  { "colorhexa.com", true },
  { "coloristcafe.com", true },
  { "colorsbycarin.com", true },
  { "colossal-events.co.uk", true },
  { "colotimes.com", true },
  { "colourfulcastles.co.uk", true },
  { "colpacpackaging.com", true },
  { "colson-occasions.be", true },
  { "coltellisurvival.com", true },
  { "coltonrb.com", true },
  { "columbuswines.com", true },
  { "colyakootees.com", true },
  { "com-in.de", true },
  { "comalia.com", true },
  { "comandofilmes.club", true },
  { "comarkinstruments.net", true },
  { "combatircelulitis.com", true },
  { "combattrecellulite.com", true },
  { "combron.be", true },
  { "combron.co.uk", true },
  { "combron.com", true },
  { "combron.nl", true },
  { "comcol.nl", true },
  { "comdurav.com", true },
  { "comeals.com", true },
  { "comefollowme2016.com", true },
  { "comeoishii.com", true },
  { "comercialtpv.com", true },
  { "comerford.net", true },
  { "comestoarra.com", true },
  { "cometcache.com", true },
  { "cometonovascotia.ca", true },
  { "comff.net", true },
  { "comfintouch.com", true },
  { "comflores.com.br", true },
  { "comfortmastersinsulation.com", true },
  { "comfun.net", true },
  { "comhack.com", true },
  { "comicspornos.com", true },
  { "comicspornoxxx.com", true },
  { "comicwiki.dk", true },
  { "comidasperuanas.net", true },
  { "comiteaintriathlon.fr", true },
  { "comm.cx", true },
  { "commania.co.kr", true },
  { "commco.nl", true },
  { "commechezvous.ch", true },
  { "commerce.gov", true },
  { "commercial-academy.fr", true },
  { "commeunamour.com", true },
  { "commissionagenda.com", true },
  { "commitsandrebases.com", true },
  { "common.io", true },
  { "commoncode.com.au", true },
  { "commoncode.io", true },
  { "commoncore4kids.com", true },
  { "commonspace.la", true },
  { "communityblog.fedoraproject.org", true },
  { "communitycodeofconduct.com", true },
  { "communitymanagertorrejon.com", true },
  { "communote.net", true },
  { "como-se-escribe.com", true },
  { "comocurarlagastritistratamientonatural.com", true },
  { "comodo.nl", true },
  { "comodormirmasrapido.com", true },
  { "comodosslstore.com", true },
  { "comoeliminarlaspapulasperladasenelglande.com", true },
  { "comogene.com", true },
  { "comohacerblog.net", true },
  { "comohacerpara.com", true },
  { "comoimportar.net", true },
  { "comopuededejardefumar.net", true },
  { "comosatisfaceraunhombreenlacamaydejarloloco.com", true },
  { "comosecarabarriga.net", true },
  { "comoseduzir.net", true },
  { "comosefazisto.com.br", true },
  { "comp2go.com.au", true },
  { "compactchess.cc", true },
  { "compagnia-buffo.de", true },
  { "compagniemartin.com", true },
  { "comparatif-moto.fr", true },
  { "compareandrecycle.co.uk", true },
  { "compareandrecycle.com", false },
  { "compareinsurance.com.au", true },
  { "comparesoft.com", true },
  { "comparexcloudcenter.com", true },
  { "compartir.party", true },
  { "compassdirectportal.com", true },
  { "compassfinance.com", true },
  { "compassintladv.com", true },
  { "compasslos.com", true },
  { "compeat.com", true },
  { "comphare.nl", true },
  { "compibus.fr", true },
  { "compilenix.org", true },
  { "compleetondernemen.nl", true },
  { "completefloorcoverings.com", true },
  { "completesecurityessex.co.uk", true },
  { "completesecurityessex.com", true },
  { "completionist.me", true },
  { "complexart.ro", true },
  { "complexorganizations.com", true },
  { "complexsystems.fail", true },
  { "compliance-management.ch", true },
  { "compliance-systeme.de", true },
  { "compliancedictionary.com", true },
  { "compliancerisksoftware.co.uk", true },
  { "compostatebien.com.ar", true },
  { "compoundingrxusa.com", true },
  { "compraneta.com", false },
  { "comprasoffie.com.br", true },
  { "compreautomacao.com.br", true },
  { "compree.com", true },
  { "compservice.in.ua", true },
  { "comptu.com", true },
  { "compubench.com", true },
  { "compucastell.ch", true },
  { "compucorner.mx", true },
  { "compunetwor.com", true },
  { "compuplast.cz", true },
  { "computehealth.com", true },
  { "computer-acquisti.com", true },
  { "computer-science-schools.com", true },
  { "computeracademy.co.za", true },
  { "computerassistance.co.uk", true },
  { "computerbas.nl", true },
  { "computerbase.de", true },
  { "computercamaccgi.com", true },
  { "computeremergency.com.au", false },
  { "computerfreunde-barmbek.de", true },
  { "computerhilfe-feucht.de", true },
  { "computernetwerkwestland.nl", true },
  { "computerslotopschool.nl", true },
  { "computersystems.guru", false },
  { "computop.com", true },
  { "comtily.com", true },
  { "comunidadmontepinar.es", true },
  { "comvos.de", true },
  { "comw.cc", true },
  { "conalcorp.com", true },
  { "conatus.ai", true },
  { "conaudisa.com", false },
  { "concept-web.ch", true },
  { "concertengine.com", true },
  { "concerto.amsterdam", true },
  { "concertsenboite.fr", true },
  { "concertsto.com", true },
  { "conciliumnotaire.ca", true },
  { "concordsoftwareleasing.com", true },
  { "concretelevelingsystems.com", true },
  { "concreterepairatlanta.com", true },
  { "concursopublico.com.br", true },
  { "concursos.com.br", true },
  { "concursosabertos.com.br", true },
  { "concursuri.biz", true },
  { "condecom.com.br", true },
  { "condepenalba.com", false },
  { "condesaelectronics.com", true },
  { "condolencemessages.net", true },
  { "condominioweb.com", true },
  { "condosforcash.com", true },
  { "condroz-motors.be", true },
  { "conectadev.com", true },
  { "conectar.ru", true },
  { "conectumfinanse.pl", true },
  { "conejovalleyelectrical.com", true },
  { "conejovalleyelectrician.com", true },
  { "conejovalleyexteriorlighting.com", true },
  { "conejovalleylandscapelighting.com", true },
  { "conejovalleylighting.com", true },
  { "conejovalleyoutdoorlighting.com", true },
  { "conexiontransporte.com", true },
  { "conference.dnsfor.me", true },
  { "confiancefoundation.org", true },
  { "config.schokokeks.org", false },
  { "confiwall.de", true },
  { "conformax.com.br", true },
  { "congineer.com", true },
  { "congobunkering.com", true },
  { "conju.cat", true },
  { "conjugacao.com.br", true },
  { "conkret.de", true },
  { "conmedapps.com", true },
  { "conn.cx", true },
  { "connect-ed.network", true },
  { "connect-me.com", true },
  { "connect.dating", true },
  { "connect.facebook.net", true },
  { "connecta.store", true },
  { "connectavid.com", true },
  { "connectedcare.md", true },
  { "connectmath.com", true },
  { "connectmy.car", true },
  { "connecto-data.com", true },
  { "connectum.eu", true },
  { "conner.work", true },
  { "connexas.eu", true },
  { "connext.de", true },
  { "connictro.de", true },
  { "connorhatch.com", true },
  { "connorsmith.co", true },
  { "connyduck.at", true },
  { "conociendosalama.com", true },
  { "conocimientosdigitales.com", true },
  { "conorboyd.info", true },
  { "conory.com", true },
  { "conpath.net", true },
  { "conpins.nl", true },
  { "conrad-kostecki.de", true },
  { "conradkostecki.de", true },
  { "conradsautotransmissionrepair.com", true },
  { "conrail.blue", true },
  { "consagracionamariasantisima.org", true },
  { "consciousbrand.co", true },
  { "consciouschoices.net", true },
  { "consciousnesschange.com", true },
  { "consec-systems.de", true },
  { "consegnafioridomicilio.net", true },
  { "consejosdenutricion.com", true },
  { "consensoprivacy.it", true },
  { "conservados.com.br", true },
  { "conservatoriesincornwall.com", true },
  { "consideredgifts.com", true },
  { "consilium-vitae.ch", true },
  { "consiliumvitae.ch", true },
  { "consill.com", true },
  { "console.ninja", true },
  { "console.rest", true },
  { "consommateuraverti.com", true },
  { "consonare.de", true },
  { "conspiracyservers.com", true },
  { "constancechen.me", true },
  { "constant-rough.de", true },
  { "constares.de", true },
  { "constitution.website", true },
  { "constructexpres.ro", true },
  { "constructieve.nl", true },
  { "construction-colleges.com", true },
  { "construction-student.co.uk", true },
  { "constructionjobs.com", true },
  { "constructive.men", true },
  { "consul.io", true },
  { "consulenza.pro", true },
  { "consultation.biz.tr", true },
  { "consultimator.com", true },
  { "consultimedia.de", true },
  { "consultoriadeseguranca.com.br", true },
  { "consultoriosodontologicos.com.br", true },
  { "consultpetkov.com", true },
  { "consulvation.com", true },
  { "consumeractionlawgroup.com", true },
  { "consumerfiles.com", true },
  { "consumersentinel.gov", true },
  { "consuwijzer.nl", true },
  { "contactsingapore.sg", true },
  { "contaquanto.com.br", true },
  { "contemplativeeducation.org", true },
  { "content-api-dev.azurewebsites.net", false },
  { "content-design.de", true },
  { "contentcoms.co.uk", true },
  { "contentdesign.de", true },
  { "contentpass.net", true },
  { "contessa32experience.com", true },
  { "contextplatform.com", true },
  { "conti-profitlink.co.uk", true },
  { "continuum.memorial", true },
  { "contrabass.net", true },
  { "contractormountain.com", true },
  { "contractwriters.com", true },
  { "contraspin.co.nz", true },
  { "contratatupoliza.com", true },
  { "contributor.google.com", false },
  { "controlarlaansiedad.com", true },
  { "controlautocom.com.br", true },
  { "controlbooth.com", true },
  { "controle.net", true },
  { "controleer-maar-een-ander.nl", true },
  { "controltickets.com.br", true },
  { "conv2pdf.com", true },
  { "convergence.fi", true },
  { "convergencela.com", true },
  { "convergnce.com", true },
  { "conversiones.com", true },
  { "conversionsciences.com", true },
  { "convert.im", true },
  { "convert.zone", true },
  { "converticacommerce.com", false },
  { "convexset.org", true },
  { "convocatoriafundacionpepsicomexico.org", false },
  { "cookeatup.com", true },
  { "cooker.fr", true },
  { "cookescastles.co.uk", true },
  { "cookicons.co", true },
  { "cookie4.com", true },
  { "cookieandkate.com", true },
  { "cookiecrook.com", true },
  { "cookielab.io", true },
  { "cookiesoft.de", true },
  { "cooking-sun.com", true },
  { "cookingcrusade.com", true },
  { "cookinglife.nl", false },
  { "cookingreporter.com", true },
  { "cookmedical.com", false },
  { "cooko.at", true },
  { "cooksbookscorks.com", true },
  { "cookwithmanali.com", true },
  { "cool-parties.co.uk", true },
  { "cool-wallpapers.jp", true },
  { "cool.haus", true },
  { "cool110.tk", true },
  { "cool110.xyz", true },
  { "coolattractions.co.uk", true },
  { "coolbitx.com", true },
  { "coolcamping.com", true },
  { "cooldan.com", true },
  { "coole-fete.de", true },
  { "coolerssr.space", true },
  { "coolgifs.de", true },
  { "coolprylar.se", true },
  { "coolwallet.io", true },
  { "coonawarrawines.com.au", true },
  { "coopens.com", true },
  { "cooperativehandmade.com", true },
  { "cooperativehandmade.pe", true },
  { "coore.jp", true },
  { "coorpacademy.com", true },
  { "copdfoundation.org", true },
  { "copinstant.com", true },
  { "copperandtileroofing.com", true },
  { "copperhead.co", true },
  { "copperheados.com", true },
  { "coppermein.co.za", true },
  { "copplaw.com", true },
  { "copta-imagefilme-und-drohnenvideos.de", true },
  { "coptkm.cz", true },
  { "copycaught.co", true },
  { "copycaught.net", true },
  { "copycaught.org", true },
  { "copycaught.xyz", true },
  { "copycrafter.net", true },
  { "copydz.com", true },
  { "copypoison.com", true },
  { "copyright-watch.org", true },
  { "coquibus.net", true },
  { "corbi.net.au", true },
  { "cordejong.nl", true },
  { "cordep.biz", true },
  { "corder.tech", true },
  { "cordeydesign.ch", true },
  { "cordis.io", true },
  { "cordis.tk", true },
  { "cordlessdog.com", true },
  { "core-concepts.de", false },
  { "core-networks.de", true },
  { "core.mx", true },
  { "core.org.pt", true },
  { "coreapm.org", true },
  { "corecodec.com", true },
  { "coredump.gr", true },
  { "coreless-stretchfilm.com", true },
  { "corelia.net", true },
  { "corepartners.com.ua", true },
  { "coresolutions.ca", true },
  { "coreum.ca", true },
  { "coreyjmahler.com", true },
  { "corgi.party", true },
  { "coribi.com", true },
  { "corinastefan.ro", true },
  { "corintech.net", true },
  { "corisu.co", true },
  { "corkedwinebar.com", true },
  { "corksoncolumbus.com", true },
  { "corlija.com", true },
  { "corlinde.nl", true },
  { "corlitocaffe.de", true },
  { "cornercircle.co.uk", true },
  { "cornerstonecmc.org", true },
  { "corniche.com", true },
  { "corningcu.org", true },
  { "cornodo.com", true },
  { "corona-academy.com", true },
  { "corona-renderer.cloud", true },
  { "corona-renderer.com", true },
  { "corourbano.es", true },
  { "corpfin.net", true },
  { "corpio.nl", true },
  { "corpkitnw.com", true },
  { "corpoflow.nl", true },
  { "corporacioninternacionallideres.org", true },
  { "corporateclash.net", true },
  { "corporatecomputingsolutions.com", true },
  { "corporateinfluencers.com", true },
  { "corporativoarval.info", true },
  { "corpsepaint.life", true },
  { "corpulant.coffee", true },
  { "corpulantcoffee.com", true },
  { "corpulent.coffee", true },
  { "corpulentcoffee.com", true },
  { "corpuschristisouthriver.org", true },
  { "corpusslayer.com", true },
  { "corrbee.com", true },
  { "correctiv.org", true },
  { "corrick.io", true },
  { "corrupted.io", true },
  { "corsa-b.uk", true },
  { "corscanplus.com", true },
  { "corsectra.com", true },
  { "corsihaccpsicurezzalavoro.it", true },
  { "cortexitrecruitment.com", true },
  { "cortexx.nl", true },
  { "cortis-consulting.ch", true },
  { "cortisolsupplement.com", true },
  { "corvax.kiev.ua", true },
  { "corvus.eu.org", true },
  { "coryadum.com", true },
  { "corytyburski.com", true },
  { "cosasque.com", true },
  { "cosciamoos.com", true },
  { "cosirex.com", true },
  { "coslinker.com", true },
  { "cosmechic.fr", true },
  { "cosmekaitori.jp", true },
  { "cosmeticappraisal.com", true },
  { "cosmeticasimple.com", true },
  { "cosmeticos-naturales.com", true },
  { "cosmic-os.org", true },
  { "cosmicnavigator.com", true },
  { "cosmintataru.ro", true },
  { "cosmodacollection.com", true },
  { "cosmofunnel.com", true },
  { "cosmundi.de", true },
  { "cosni.co", true },
  { "cosplayer.com", true },
  { "cospol.ch", true },
  { "costa-rica-reisen.ch", true },
  { "costa-rica-reisen.de", true },
  { "costablanca.villas", true },
  { "costablancavoorjou.com", true },
  { "costcoinsider.com", true },
  { "costellofc.co.uk", true },
  { "costinstefan.eu", true },
  { "costreportdata.com", false },
  { "costulessdirect.com", true },
  { "coteries.com", true },
  { "cotoacc.com", true },
  { "cotonmusic.ch", true },
  { "cotta.dk", true },
  { "cotwe-ge.ch", true },
  { "cougar.dating", true },
  { "counsellingtime.com", true },
  { "counstellor.com", true },
  { "counter-team.ch", true },
  { "counterglobal.com", true },
  { "counterhack.nl", true },
  { "countermail.com", false },
  { "countermats.net", true },
  { "countersolutions.co.uk", true },
  { "countetime.com", true },
  { "countingto.one", true },
  { "countryattire.com", true },
  { "countrybrewer.com.au", true },
  { "countryfrog.uk", true },
  { "countryhouseresort.com", true },
  { "countybankdel.com", true },
  { "countyjailinmatesearch.com", true },
  { "coupe-bordure.com", true },
  { "couplay.org", true },
  { "couponcodesme.com", true },
  { "cour4g3.me", true },
  { "couragefound.org", true },
  { "coursables.com", true },
  { "coursera.org", true },
  { "courtlistener.com", true },
  { "couscous.recipes", true },
  { "cousincouples.com", false },
  { "coussinsky.net", true },
  { "couvreur-hinault.fr", true },
  { "covbounce.co.uk", true },
  { "covenantoftheriver.org", true },
  { "covermytrip.com.au", true },
  { "covershousing.nl", true },
  { "covery.ai", true },
  { "covoiturage.fr", false },
  { "covve.com", true },
  { "covybrat.cz", true },
  { "cowbird.org", true },
  { "cowboyim.com", true },
  { "coweo.cz", true },
  { "cowo.group", true },
  { "coworking-luzern.ch", true },
  { "coxcapitalmanagement.com", true },
  { "coxxs.me", true },
  { "coxxs.moe", true },
  { "cozo.me", true },
  { "cozyeggdesigns.com", true },
  { "cp-st-martin.be", true },
  { "cpahunt.com", false },
  { "cpap.com", true },
  { "cpasperdu.com", true },
  { "cpbapremiocaduceo.com.ar", true },
  { "cpcheats.co", true },
  { "cpd-education.co.uk", true },
  { "cpe-colleg.de", true },
  { "cpgarmor.com", true },
  { "cphpvb.net", true },
  { "cplala.com", true },
  { "cplus.me", true },
  { "cplusplus.se", true },
  { "cppan.org", true },
  { "cppressinc.com", true },
  { "cpqcol.gov.co", true },
  { "cprheartcenter.com", true },
  { "cprnearme.com", true },
  { "cpsc.gov", true },
  { "cpsq.fr", true },
  { "cptoon.com", true },
  { "cpu.biz.tr", true },
  { "cpvmatch.eu", true },
  { "cpy.pt", true },
  { "cqn.ch", true },
  { "cr.search.yahoo.com", false },
  { "cr0nus.net", true },
  { "cr9499.com", true },
  { "cra-bank.com", true },
  { "cra-search.net", true },
  { "craazzyman21.at", true },
  { "crackcat.de", true },
  { "cracker.in.th", true },
  { "crackers4cheese.com", true },
  { "crackle.io", true },
  { "crackorsquad.in", true },
  { "crackstation.net", true },
  { "cradlepointecm.com", true },
  { "craft-verlag.de", true },
  { "craftandbuild.de", true },
  { "craftcommerce.com", true },
  { "craftinginredlipstick.com", true },
  { "craftist.de", true },
  { "craftsmandruggets.com", true },
  { "craftsmany.net", true },
  { "craftyguy.net", true },
  { "craftyphotons.net", true },
  { "crag.com.tw", true },
  { "craigary.net", true },
  { "craigbates.co.uk", true },
  { "craigfrancis.co.uk", true },
  { "craigleclaireteam.com", true },
  { "craigrouse.com", true },
  { "craigwfox.com", true },
  { "cralarm.de", true },
  { "crandall.io", true },
  { "cranforddental.com", true },
  { "cranshafengin.com", true },
  { "crapouill.es", true },
  { "cratss.co.uk", true },
  { "crawcial.de", true },
  { "crawford.cloud", true },
  { "crawfordcountytcc.org", true },
  { "crawl.report", true },
  { "crawler.ninja", true },
  { "crawleybouncycastles.co.uk", true },
  { "crawlspaceandbasementsolutions.com", true },
  { "crazy-bulks.com", true },
  { "crazy-cat.net", true },
  { "crazy-coders.com", true },
  { "crazybulk.co.uk", true },
  { "crazybulk.com", true },
  { "crazybulk.fr", true },
  { "crazycastles.ie", true },
  { "crazydomains.ae", true },
  { "crazydomains.co.nz", true },
  { "crazydomains.co.uk", true },
  { "crazydomains.com.au", true },
  { "crazydomains.in", true },
  { "crazymeeshu.com", true },
  { "crazynoisybizarre.town", true },
  { "crazypaul.com", true },
  { "crbug.com", true },
  { "crc-bank.com", true },
  { "crc-search.com", true },
  { "crdmendoza.net", true },
  { "crea-etc.net", true },
  { "crea-shops.ch", true },
  { "crea.bg", true },
  { "creadstudy.com", true },
  { "creamcastles.co.uk", true },
  { "creared.edu.co", true },
  { "createcos.com", true },
  { "createme.com.pl", true },
  { "createursdefilms.com", true },
  { "creatieven.com", true },
  { "creation-contemporaine.com", true },
  { "creative-wave.fr", true },
  { "creativebites.de", true },
  { "creativecaptiv.es", true },
  { "creativecommons.gr", true },
  { "creativecommons.org", true },
  { "creativeconceptsvernon.com", true },
  { "creativedigital.co.nz", true },
  { "creativefolks.co.uk", true },
  { "creativefreedom.ca", true },
  { "creativeglassgifts.com.au", true },
  { "creativeground.com.au", true },
  { "creativeimagery.com.au", true },
  { "creativeink.de", true },
  { "creativekkids.com", true },
  { "creativelaw.eu", true },
  { "creativeliquid.com", true },
  { "creativerezults.com", true },
  { "creativesprite.com", true },
  { "creativesurvey.com", true },
  { "creativeweb.biz", true },
  { "creativewolf.net", true },
  { "creativlabor.ch", true },
  { "creatixx-network.de", false },
  { "creators-design.com", true },
  { "creators.direct", true },
  { "creatujoya.com", true },
  { "credential.eu", true },
  { "credex.bg", true },
  { "credigo.se", true },
  { "crediteo.pl", true },
  { "creditkarma.com", true },
  { "creditos-rapidos.com", true },
  { "creditozen.es", true },
  { "creditozen.mx", true },
  { "creditproautos.com", false },
  { "creditscoretalk.com", true },
  { "creditta.com", true },
  { "credittoken.io", true },
  { "creeks-coworking.com", true },
  { "creep.im", true },
  { "creepycraft.nl", true },
  { "creepypastas.com", true },
  { "creepypastas.net", true },
  { "creer-une-boutique-en-ligne.com", true },
  { "creerunsitepro.com", true },
  { "crefelder.com", true },
  { "crem.in", false },
  { "cremepassion.de", true },
  { "crena.ch", true },
  { "crepa.ch", true },
  { "crepererum.net", true },
  { "crescent.gr.jp", true },
  { "crestasantos.com", true },
  { "cretdupuy.com", true },
  { "creteangle.com", true },
  { "cretica.no", true },
  { "creusalp.ch", true },
  { "crew505.org", true },
  { "crgalvin.com", true },
  { "crgm.net", true },
  { "cribcore.com", true },
  { "criena.com", true },
  { "criena.net", true },
  { "crimefreeliving.com", true },
  { "crimesolutions.gov", true },
  { "crimevictims.gov", true },
  { "criminal-attorney.ru", true },
  { "criminal.enterprises", true },
  { "crinesdanzantes.be", true },
  { "criptolog.com", true },
  { "criscitos.it", true },
  { "crisisactual.com", true },
  { "crisisnextdoor.gov", true },
  { "crisp.chat", true },
  { "crisp.email", true },
  { "crisp.help", true },
  { "crisp.im", true },
  { "crisp.watch", true },
  { "crispinusphotography.com", true },
  { "cristarta.com", true },
  { "cristau.org", true },
  { "cristiandeluxe.com", false },
  { "critical.today", false },
  { "criticalsurveys.co.uk", true },
  { "crizin.io", true },
  { "crm.onlime.ch", false },
  { "crm114d.com", true },
  { "crochetnerd.com", true },
  { "croisedanslemetro.com", true },
  { "croixblanche-haguenau.fr", true },
  { "cromefire.myds.me", true },
  { "croncron.io", true },
  { "cronix.cc", true },
  { "cronologie.de", true },
  { "cronometer.com", true },
  { "cronoscentral.be", true },
  { "cropdiagnosis.com", true },
  { "crosbug.com", true },
  { "crose.co.uk", true },
  { "cross-led-sign.com", true },
  { "cross-link.ch", true },
  { "cross-view.com", true },
  { "cross-x.com", true },
  { "cross.lol", true },
  { "crossborderreturns.com", true },
  { "crossedwires.net", true },
  { "crossfitblackwater.com", true },
  { "crossfunctional.com", true },
  { "crosslifenutrition.co.uk", true },
  { "crossorig.in", true },
  { "crossoverit.com", true },
  { "crosssellguide.com", true },
  { "crowd.supply", true },
  { "crowdbox.net", true },
  { "crowdcloud.be", true },
  { "crowdliminal.com", true },
  { "crowdsim3d.com", true },
  { "crowdsupply.com", true },
  { "crownaffairs.ch", true },
  { "crowncastles.co.uk", true },
  { "crownchessclub.com", true },
  { "crownmarqueehire.co.uk", true },
  { "crownpoint.com", true },
  { "crows.io", true },
  { "croydonapartments.com.au", true },
  { "croydonbouncycastles.co.uk", true },
  { "crrev.com", true },
  { "crsmsodry.cz", true },
  { "crstat.ru", true },
  { "crt.cloud", true },
  { "crt2014-2024review.gov", true },
  { "cruisemoab.com", true },
  { "crumbcontrol.com", true },
  { "crunchrapps.com", true },
  { "crunchy.rocks", true },
  { "crustytoothpaste.net", true },
  { "crute.me", true },
  { "crvv.me", true },
  { "cry.nu", false },
  { "cryogenix.net", true },
  { "cryoit.com", true },
  { "cryothanasia.com", true },
  { "cryp.no", true },
  { "crypt.is-by.us", true },
  { "cryptagio.com", true },
  { "cryptearth.de", true },
  { "crypted.chat", true },
  { "crypteianetworks.com", true },
  { "crypticshell.co.uk", true },
  { "crypto.cat", false },
  { "crypto.graphics", true },
  { "crypto.is", false },
  { "cryptobin.co", true },
  { "cryptocon.org", true },
  { "cryptoegg.ca", true },
  { "cryptofan.org", true },
  { "cryptofrog.co", true },
  { "cryptography.ch", true },
  { "cryptography.io", true },
  { "cryptoguidemap.com", true },
  { "cryptoisnotacrime.org", true },
  { "cryptojacks.io", true },
  { "cryptojourney.com", true },
  { "cryptolinc.com", true },
  { "cryptology.ch", true },
  { "cryptolosophy.io", true },
  { "cryptolosophy.org", true },
  { "cryptomaniaks.com", true },
  { "cryptonym.com", true },
  { "cryptoparty.at", true },
  { "cryptoparty.tv", true },
  { "cryptopartyutah.org", true },
  { "cryptophobia.nl", true },
  { "cryptorival.com", true },
  { "cryptoseb.pw", true },
  { "cryptoshot.pw", true },
  { "cryptoya.io", true },
  { "cryptract.co", true },
  { "crys.cloud", true },
  { "crys.hu", true },
  { "crystal-zone.com", true },
  { "crystalapp.ca", true },
  { "crystalchandelierservices.com", true },
  { "crystalgrid.net", true },
  { "crystallizedcouture.com", true },
  { "crystaloscillat.com", true },
  { "crystalzoneshop.com", true },
  { "crystone.me", true },
  { "cryz.ru", true },
  { "cs2016.ch", true },
  { "csabg.org", true },
  { "csbs.fr", true },
  { "csbuilder.io", true },
  { "csca.me", true },
  { "cscdn.net", true },
  { "csd-sevnica.si", true },
  { "csfcloud.com", true },
  { "csfd.cz", true },
  { "csfm.com", true },
  { "csgo.design", true },
  { "csgo.su", false },
  { "csgoswap.com", true },
  { "csharpmarc.net", true },
  { "cshub.nl", true },
  { "csi.lk", true },
  { "csinterstargeneve.ch", true },
  { "cskentertainment.co.uk", true },
  { "csmainframe.com", true },
  { "csokolade.hu", true },
  { "csovek-idomok.hu", true },
  { "csp.ch", true },
  { "cspeti.hu", true },
  { "cspvalidator.org", true },
  { "csrichter.com", true },
  { "css.direct", false },
  { "css.net", true },
  { "cssai.eu", true },
  { "cssaunion.com", true },
  { "cstanley.net", true },
  { "cstb.ch", true },
  { "cstp-marketing.com", true },
  { "cstrong.nl", true },
  { "csu.st", true },
  { "csust.ac.cn", true },
  { "csuw.net", true },
  { "csvalpha.nl", true },
  { "ct.search.yahoo.com", false },
  { "ctc-transportation.com", true },
  { "ctcom-peru.com", true },
  { "ctcue.com", true },
  { "ctf.link", true },
  { "ctj.im", true },
  { "ctkwwri.org", true },
  { "ctl.email", true },
  { "ctliu.com", true },
  { "ctnguyen.de", true },
  { "ctnguyen.net", true },
  { "ctns.de", true },
  { "ctoforhire.com.au", true },
  { "ctomp.io", false },
  { "ctoresms.com", true },
  { "ctpe.net", true },
  { "ctrl.blog", true },
  { "ctrld.me", true },
  { "cu247secure.ie", true },
  { "cub-bouncingcastles.co.uk", true },
  { "cube-cloud.com", true },
  { "cube.builders", true },
  { "cube.de", true },
  { "cubebot.io", true },
  { "cubebuilders.net", true },
  { "cubecart-demo.co.uk", true },
  { "cubecart-hosting.co.uk", true },
  { "cubecraft.net", true },
  { "cubecraftcdn.com", true },
  { "cubekrowd.net", true },
  { "cubetech.co.jp", true },
  { "cubia.de", true },
  { "cubia3.com", true },
  { "cubia4.com", true },
  { "cubile.xyz", true },
  { "cubing.net", true },
  { "cublick.com", true },
  { "cubos.io", false },
  { "cubostecnologia.com", false },
  { "cubostecnologia.com.br", false },
  { "cubua.com", true },
  { "cuckoopalace.cn", true },
  { "cuddlecomfort.com", true },
  { "cuddlingyaks.com", true },
  { "cueca.com.br", true },
  { "cuecasonline.com.br", true },
  { "cuentasmutualamr.org.ar", true },
  { "cuetoems.com", true },
  { "cuibonobo.com", true },
  { "cuisinezest.com", true },
  { "cultiv.nl", true },
  { "cultivo.bio", true },
  { "cultofd50.org", true },
  { "cultofperf.org.uk", true },
  { "cultura10.com", true },
  { "culture-school.top", true },
  { "culturedcode.com", true },
  { "culturerain.com", true },
  { "culturesouthwest.org.uk", true },
  { "cumberlandrivertales.com", true },
  { "cumparama.com", true },
  { "cumplegenial.com", true },
  { "cuoc.org.uk", true },
  { "cup.al", true },
  { "cupcakesandcrinoline.com", true },
  { "cupcao.gov", true },
  { "cupi.co", true },
  { "cupom.net", true },
  { "cuppycakes.fi", true },
  { "cur.by", true },
  { "curacao-firma.com", true },
  { "curamail.co.uk", true },
  { "curareldolordeespalda.com", true },
  { "curatedgeek.com", true },
  { "curbside.com", true },
  { "curieux.digital", true },
  { "curio-shiki.com", true },
  { "curiosity-driven.org", true },
  { "curiouspeddler.com", true },
  { "curlybracket.co.uk", true },
  { "currency-strength.com", true },
  { "currentlystreaming.com", true },
  { "currentlyusa.com", true },
  { "currentobserver.com", true },
  { "currynissanmaparts.com", true },
  { "cursos-trabajadores.net", true },
  { "cursos.com", true },
  { "cursosforex.com", true },
  { "cursosingles.com", true },
  { "cursossena.co", true },
  { "cursuri-de-actorie.ro", true },
  { "curtacircuitos.com.br", false },
  { "curtis-smith.me.uk", true },
  { "curtis-smith.uk", true },
  { "curtislaw-pllc.com", true },
  { "curtislinville.net", true },
  { "curtissmith.me.uk", true },
  { "curtissmith.uk", true },
  { "curva.co", true },
  { "curveprotect.com", true },
  { "curveprotect.cz", true },
  { "curveprotect.net", true },
  { "curveprotect.org", true },
  { "curvesandwords.com", true },
  { "curvissa.co.uk", true },
  { "custodyxchange.com", true },
  { "custombikes.cl", true },
  { "customdissertation.com", true },
  { "customerbox.ir", true },
  { "customfitbymj.net", true },
  { "customfitmarketing.com", true },
  { "customgear.com.au", true },
  { "customizeyoursink.com", true },
  { "customwritingservice.com", true },
  { "customwritten.com", true },
  { "cutimbo.ovh", true },
  { "cutner.co", true },
  { "cuvva.co", true },
  { "cuvva.co.uk", true },
  { "cuvva.com", true },
  { "cuvva.eu", true },
  { "cuvva.io", true },
  { "cuvva.it", true },
  { "cuvva.me", true },
  { "cuvva.net", true },
  { "cuvva.org", true },
  { "cuvva.uk", true },
  { "cuvva.us", true },
  { "cuxpool.net", true },
  { "cvc.digital", true },
  { "cvchomes.com", true },
  { "cvcoders.com", true },
  { "cve-le-carrousel.ch", true },
  { "cviip.ca", true },
  { "cviip.com", true },
  { "cvjd.me", true },
  { "cvl.ch", true },
  { "cvlibrary.co.uk", true },
  { "cvmu.jp", true },
  { "cvr.dk", true },
  { "cvursache.com", true },
  { "cvv.cn", true },
  { "cw.center", true },
  { "cwagner.me", true },
  { "cwarren.org", true },
  { "cwbrtrust.ca", true },
  { "cwgaming.co.uk", true },
  { "cwinfo.fi", true },
  { "cwmart.in", true },
  { "cwrau.com", true },
  { "cwrau.de", true },
  { "cwrau.info", true },
  { "cwrau.io", true },
  { "cwrau.me", true },
  { "cwrau.name", true },
  { "cwrau.rocks", true },
  { "cwrau.tech", true },
  { "cwrcoding.com", true },
  { "cxadd.com", true },
  { "cy.ax", true },
  { "cyanghost.com", true },
  { "cyber.je", true },
  { "cyberatlantis.com", true },
  { "cybercareers.gov", true },
  { "cybercloud.cc", true },
  { "cybercocoon.com", true },
  { "cybercrew.cc", true },
  { "cybercrime-forschung.de", true },
  { "cybercrime.gov", true },
  { "cyberdos.de", false },
  { "cyberduck.io", true },
  { "cyberexplained.info", true },
  { "cybergrx.com", true },
  { "cyberguerrilla.info", true },
  { "cyberguerrilla.org", true },
  { "cyberhipsters.nl", true },
  { "cyberianhusky.com", true },
  { "cyberkov.com", true },
  { "cyberlab.kiev.ua", false },
  { "cyberlightapp.com", true },
  { "cybermeldpunt.nl", true },
  { "cyberogism.com", true },
  { "cyberoptic.de", true },
  { "cyberpioneer.net", false },
  { "cyberpubonline.com", true },
  { "cyberregister.nl", true },
  { "cyberregister.org", true },
  { "cybersafesolutions.com", true },
  { "cyberscan.io", true },
  { "cybersecurity.nz", true },
  { "cybersecurity.run", true },
  { "cybersecuritychallenge.be", false },
  { "cybersecurityketen.nl", true },
  { "cyberseguranca.com.br", true },
  { "cybersins.com", true },
  { "cybersmartdefence.com", true },
  { "cyberspace.community", true },
  { "cyberspect.com", true },
  { "cyberspect.io", true },
  { "cyberstatus.de", true },
  { "cybertorsk.org", true },
  { "cybertu.be", true },
  { "cyberwars.dk", true },
  { "cyberwire.nl", true },
  { "cyberxpert.nl", true },
  { "cybit.io", true },
  { "cybozu.cn", true },
  { "cybozu.com", true },
  { "cybozulive-dev.com", true },
  { "cybozulive.com", true },
  { "cybrary.it", true },
  { "cyclebeads.com", true },
  { "cycleluxembourg.lu", true },
  { "cyclinggoodso.com", true },
  { "cyclisjumper.gallery", true },
  { "cyclop-editorial.fr", true },
  { "cydetec.com", true },
  { "cyfly.org", true },
  { "cygnaltech.com", true },
  { "cygnan.com", true },
  { "cygnatus.com", true },
  { "cygnius.net", true },
  { "cyhour.com", true },
  { "cykelbanor.se", true },
  { "cyl6.com", true },
  { "cylindehea.com", true },
  { "cylindricity.com", true },
  { "cyon.ch", true },
  { "cypad.cn", true },
  { "cyph.audio", true },
  { "cyph.com", true },
  { "cyph.healthcare", true },
  { "cyph.im", true },
  { "cyph.io", true },
  { "cyph.me", true },
  { "cyph.video", true },
  { "cyph.ws", true },
  { "cypherpunk.at", true },
  { "cypherpunk.com", true },
  { "cypherpunk.observer", true },
  { "cypressinheritancesaga.com", true },
  { "cypresslegacy.com", true },
  { "cyprus-company-service.com", true },
  { "cyrating.com", true },
  { "cysec.biz", true },
  { "cysmo.de", true },
  { "cyson.tech", true },
  { "cytech.com.tr", true },
  { "cytegic-update-packages.com", true },
  { "cytotecforsale.com", true },
  { "cyumus.com", true },
  { "czakey.net", true },
  { "czbix.com", true },
  { "czbtm.com", true },
  { "czc.cz", true },
  { "czechamlp.com", true },
  { "czechcrystals.co.uk", true },
  { "czechvirus.cz", true },
  { "czerno.com", true },
  { "czfa.pl", true },
  { "czk.mk", true },
  { "d-20.fr", true },
  { "d-designerin.de", true },
  { "d-eisenbahn.com", true },
  { "d-loop.de", true },
  { "d-msg.com", true },
  { "d-parts.de", true },
  { "d-parts24.de", true },
  { "d-quantum.com", true },
  { "d-toys.com.ua", true },
  { "d-training.de", true },
  { "d.nf", true },
  { "d.nr", true },
  { "d00d.de", true },
  { "d0g.cc", true },
  { "d0m41n.name", true },
  { "d0xq.com", true },
  { "d2.gg", true },
  { "d2ph.com", true },
  { "d2s.uk", true },
  { "d3lab.net", true },
  { "d3xt3r01.tk", true },
  { "d42.no", true },
  { "d4done.com", true },
  { "d4x.de", true },
  { "d66.nl", true },
  { "d6c5yfulmsbv6.cloudfront.net", true },
  { "d8.io", true },
  { "d88988.com", true },
  { "da42foripad.com", true },
  { "daallexx.eu", true },
  { "dabasstacija.lv", true },
  { "dabneydriveanimalhospital.com", true },
  { "dabuttonfactory.com", true },
  { "dachb0den.net", true },
  { "dachdecker-ranzenberger.de", true },
  { "dachdeckermeister-egon-weiss.de", true },
  { "dachtechnik-windschuettl.de", true },
  { "daciaforum.nl", true },
  { "daciamodellen.nl", true },
  { "dado.fr", true },
  { "dado.me", true },
  { "dado.virtual.museum", true },
  { "dadons-laserdiscs.com", true },
  { "dadosch.de", true },
  { "dadrian.io", true },
  { "daduke.org", true },
  { "daemen.org", true },
  { "daemwool.ch", true },
  { "daevel.fr", true },
  { "dafnik.me", true },
  { "dafont.com", true },
  { "dafricapress.com", true },
  { "dag-hebergement.fr", true },
  { "dag-konsult.com", true },
  { "dagensannonser.se", true },
  { "dagmar2018.cz", true },
  { "dahlberg.cologne", true },
  { "dai.top", true },
  { "daigakujuken-plus.com", true },
  { "daikoz.com", true },
  { "dailybits.be", true },
  { "dailyblogged.com", true },
  { "dailyemailinboxing.com", true },
  { "dailyenglishchallenge.com", true },
  { "dailyhealthguard.com", true },
  { "dailykos.com", true },
  { "dailyrover.com", true },
  { "dailyxenang.com", true },
  { "daintymeal.com", true },
  { "dairyshrine.org", true },
  { "daisakuikeda.org", true },
  { "daisidaniels.co.uk", true },
  { "daisy-peanut.com", true },
  { "daisypeanut.com", true },
  { "daiweihu.com", true },
  { "daiyuu.jp", true },
  { "dajiadu.net", true },
  { "dak.org", true },
  { "daknob.net", true },
  { "daktarisys.com", true },
  { "daladubbeln.se", true },
  { "dalaran.city", true },
  { "dalb.in", true },
  { "dale-electric.com", true },
  { "dalek.co.nz", true },
  { "dalepresencia.com", true },
  { "dalfsennet.nl", true },
  { "dalingk.com", true },
  { "dallaslu.com", true },
  { "dallinbryce.com", true },
  { "dallmeier.net", true },
  { "dalmatiersheusden.be", true },
  { "damaged.org", true },
  { "damasexpress.com", true },
  { "damedrogy.cz", true },
  { "damejidlo.cz", true },
  { "dameocio.com", true },
  { "damghaem.ir", true },
  { "damicris.ro", true },
  { "damienoreilly.org", true },
  { "daminiphysio.ca", true },
  { "damip.net", true },
  { "damirsystems.com", true },
  { "dammekens.be", true },
  { "damngoodpepper.com", false },
  { "damongant.de", true },
  { "damonline.dk", true },
  { "dampedia.com", true },
  { "dan-informacijske-varnosti.si", true },
  { "dan.me.uk", true },
  { "danaketh.com", true },
  { "danamica.dk", true },
  { "danandrum.com", true },
  { "danarozmarin.com", true },
  { "danbaldwinart.com", true },
  { "danburycampervans.co.uk", true },
  { "dance-colleges.com", true },
  { "danchen.org", true },
  { "dancingcubs.co.uk", true },
  { "dancingshiva.at", true },
  { "dandenongroadapartments.com.au", true },
  { "daneandthepain.com", true },
  { "dangmai.tk", true },
  { "dangr.zone", true },
  { "danhalliday.com", true },
  { "danholloway.online", true },
  { "daniel-baumann.ch", true },
  { "daniel-cholewa.de", true },
  { "daniel-kulbe.de", true },
  { "daniel-milnes.uk", true },
  { "daniel-ruf.de", true },
  { "daniel-wildhaber.ch", true },
  { "danielalvarez.net", true },
  { "danielas.boutique", true },
  { "danielehniss.de", true },
  { "danielepestilli.com", true },
  { "danielgorr.de", true },
  { "danielgray.email", true },
  { "danielheal.net", true },
  { "danielhinterlechner.eu", true },
  { "danielhochleitner.de", true },
  { "danieljamesscott.org", true },
  { "danieljireh.com", true },
  { "danieljstevens.com", true },
  { "danielkoster.nl", true },
  { "daniellockyer.com", true },
  { "danielmartin.de", true },
  { "danielmoch.com", true },
  { "danielmorell.com", true },
  { "danielmostertman.com", true },
  { "danielmostertman.nl", true },
  { "danielnaaman.com", true },
  { "danielnaaman.net", true },
  { "danielnaaman.org", true },
  { "danielpeukert.cz", true },
  { "danielran.com", true },
  { "danielrozenberg.com", true },
  { "danielsblog.org", true },
  { "danielschreurs.com", true },
  { "danielsfirm.com", true },
  { "danielstach.cz", true },
  { "danielsteiner.net", true },
  { "danielstiner.me", true },
  { "danielthompson.info", true },
  { "danieltollot.de", true },
  { "danielvoogsgerd.nl", true },
  { "danielwildhaber.ch", true },
  { "danifabi.eu", true },
  { "danilapisarev.com", true },
  { "danjesensky.com", true },
  { "dank.ninja", true },
  { "dankim.de", false },
  { "danla.nl", true },
  { "danmaby.com", true },
  { "danmarksbedstefredagsbar.dk", true },
  { "danmarksflyttemand.dk", true },
  { "danmassarano.com", true },
  { "danminkevitch.com", true },
  { "danna-salary.com", true },
  { "dannhanks.com", true },
  { "danny-tittel.de", true },
  { "danny.fm", true },
  { "dannycairns.com", true },
  { "dannyrohde.de", true },
  { "dannystevens.co.uk", true },
  { "danonsecurity.com", true },
  { "danotage.tv", true },
  { "danpiel.net", true },
  { "dansage.co", true },
  { "danscomp.com", true },
  { "dansdiscounttools.com", true },
  { "danselibre.net", true },
  { "danselibre.org", true },
  { "danseressen.nl", true },
  { "dansk-skole.de", true },
  { "dansk777.dk", true },
  { "danskoferie.dk", true },
  { "danslan.org", true },
  { "danstillman.com", true },
  { "dantelistan.com", true },
  { "dantransports.fr", true },
  { "danw.io", true },
  { "danwin1210.me", true },
  { "danwolff.se", true },
  { "danyabanya.com", true },
  { "danzac.com", true },
  { "dao.spb.su", true },
  { "daoro.net", true },
  { "daphne.informatik.uni-freiburg.de", true },
  { "daplie.com", true },
  { "dapps.earth", true },
  { "dappworld.com", true },
  { "daracokorilo.com", true },
  { "daravk.ch", true },
  { "darbi.org", true },
  { "darbtech.net", true },
  { "darc-mak.de", true },
  { "darchoods.net", false },
  { "darcymarshall.com", true },
  { "daren.com.br", true },
  { "dareyou.be", true },
  { "dariaburger.de", true },
  { "darinkotter.com", true },
  { "darioackermann.ch", true },
  { "darioclip.com", true },
  { "darioturchetti.me", true },
  { "darisni.me", true },
  { "dark-infection.de", true },
  { "dark-vision.cz", true },
  { "dark.ninja", true },
  { "darkag.ovh", true },
  { "darkcores.net", true },
  { "darkengine.io", true },
  { "darkengine.net", true },
  { "darkerlystormy.com", true },
  { "darkerstormy.com", true },
  { "darkeststar.org", true },
  { "darkfire.ch", true },
  { "darklaunch.com", true },
  { "darknessflickers.com", true },
  { "darknetlive.com", true },
  { "darknight.blog", true },
  { "darkrisks.com", true },
  { "darkroomsaredead.com", true },
  { "darkserver.fedoraproject.org", true },
  { "darkserver.stg.fedoraproject.org", true },
  { "darkshop.nl", true },
  { "darkside.re", true },
  { "darkspacelab.com", true },
  { "darktime.ru", true },
  { "darkwater.info", true },
  { "darkwebnews.com", true },
  { "darkx.me", true },
  { "darmgesundheit.ch", true },
  { "darom.jp", true },
  { "darookee.net", false },
  { "daropia.org", true },
  { "darshnam.com", true },
  { "dartcode.org", true },
  { "dartetdemetiers.fr", true },
  { "darth-sonic.de", true },
  { "dartsdon.jp", true },
  { "dartshopmn.nl", true },
  { "darwinkel.net", true },
  { "darwinsearch.org", true },
  { "daryl.moe", true },
  { "darylcrouse.com", true },
  { "darylcumbo.net", true },
  { "das-forum24.de", true },
  { "das-mediale-haus.de", true },
  { "das-sommercamp.de", true },
  { "dasgeestig.nl", true },
  { "dashboard.run", true },
  { "dashnearby.com", true },
  { "dashwebconsulting.com", true },
  { "dasignsource.com", true },
  { "dasinternetluegt.at", true },
  { "dasteichwerk.at", true },
  { "dasug.de", true },
  { "data-detox.de", true },
  { "data-wing.ga", true },
  { "data.gov", true },
  { "data.govt.nz", true },
  { "data3w.nl", true },
  { "databionix.com", true },
  { "databutlr.com", true },
  { "databutlr.net", true },
  { "datacalle.com", true },
  { "datacandy.com", true },
  { "datadit.hu", true },
  { "datadyne.technology", true },
  { "datafd.com", true },
  { "datafd.net", true },
  { "dataformers.at", true },
  { "datagrail.io", true },
  { "dataguidance.com", true },
  { "dataharvest.at", true },
  { "datahjalp.nu", true },
  { "datahoarder.xyz", true },
  { "datajobs.ai", true },
  { "datakick.org", true },
  { "datalife.gr", true },
  { "datalysis.ch", true },
  { "dataprivacysolution.com", true },
  { "dataprotectionadvisors.com", true },
  { "datapun.ch", true },
  { "datapure.net", true },
  { "dataregister.info", true },
  { "datascience.cafe", true },
  { "datascience.ch", true },
  { "dataskydd.net", true },
  { "dataspace.pl", true },
  { "datasupport-stockholm.se", true },
  { "datasupport.one", true },
  { "dataswamp.org", true },
  { "datatekniikka.fi", false },
  { "datatekniker.nu", true },
  { "datateknologsektionen.se", false },
  { "datatree.nl", true },
  { "datatruckers.com", true },
  { "datatruckers.eu", true },
  { "datatruckers.net", true },
  { "datatruckers.org", true },
  { "datememe.com", true },
  { "datengrab.xyz", true },
  { "datenkeks.de", true },
  { "dateno1.com", true },
  { "datenreiter.org", true },
  { "datenschutz-consult.de", true },
  { "datenschutz-individuell.de", true },
  { "datenschutzgrundverordnung.de", true },
  { "datenschutztag.org", true },
  { "datenschutzzentrum.de", true },
  { "datenwerkstatt.net", true },
  { "datewon.net", false },
  { "datingticino.ch", true },
  { "datmancrm.com", true },
  { "dator-test.se", true },
  { "datorhjalp-stockholm.se", true },
  { "datorhjalptaby.se", true },
  { "datorservice-stockholm.se", true },
  { "datovyaudit.cz", true },
  { "datumou-osusume.com", true },
  { "datumou-recipe.com", true },
  { "datumstudio.jp", true },
  { "daubecity.de", true },
  { "daubehosting.de", true },
  { "dave-pearce.com", true },
  { "daveaglick.com", true },
  { "davecardwell.com", true },
  { "davelynes.com", true },
  { "daveoc64.co.uk", true },
  { "davepage.me.uk", true },
  { "davepearce.com", true },
  { "davepermen.net", true },
  { "davescomputertips.com", true },
  { "davesharpe.com", true },
  { "davesinclair.com.au", true },
  { "davetempleton.com", true },
  { "davevelopment.net", true },
  { "davewardle.com", true },
  { "david-corry.com", true },
  { "david-jeffery.co.uk", true },
  { "david-pearce.com", true },
  { "david-reess.de", true },
  { "david-schiffmann.de", true },
  { "david.kitchen", true },
  { "davidadrian.org", true },
  { "davidandersson.se", true },
  { "davidbranco.me", true },
  { "davidcrx.net", true },
  { "daviddever.net", true },
  { "davidfetveit.com", true },
  { "davidforward.com", true },
  { "davidforward.net", true },
  { "davidfrancoeur.com", true },
  { "davidgouveia.net", true },
  { "davidgow.net", true },
  { "davidhanle.com", true },
  { "davidkennardphotography.com", true },
  { "davidking.xyz", true },
  { "davidlamprea.com", true },
  { "davidlane.io", true },
  { "davidlyness.com", true },
  { "davidmcevoy.org.uk", true },
  { "davidmessenger.co.uk", true },
  { "davidmn.org", true },
  { "davidnadaski.com", true },
  { "davidpearce.com", true },
  { "davidpearce.org", true },
  { "davidpescarolo.it", true },
  { "davidschadlich.com", true },
  { "davidschlachter.com", true },
  { "davidsimner.me.uk", true },
  { "davidsopas.com", true },
  { "davidtiffany.com", true },
  { "davidundetiwan.com", true },
  { "davie3.com", true },
  { "davisdieselandautorepair.com", true },
  { "davisroi.com", true },
  { "davo-usedcars.be", true },
  { "davy-server.com", true },
  { "davypropper.com", true },
  { "dawena.de", true },
  { "dawgs.ga", true },
  { "dawnbringer.eu", true },
  { "dawnbringer.net", true },
  { "dawnofeden.net", true },
  { "dawoud.org", true },
  { "dawson-floridavilla.co.uk", true },
  { "day-peak.com", true },
  { "daycontactlens.com", true },
  { "daydream.team", true },
  { "daylight-dream.ee", true },
  { "daylightpirates.org", true },
  { "dayman.net", true },
  { "daymprove.life", true },
  { "dayofdays.be", true },
  { "daysoftheyear.com", true },
  { "db-works.nl", true },
  { "db.ci", true },
  { "dbapress.org", true },
  { "dbaron.org", true },
  { "dbas.cz", true },
  { "dbcom.ru", true },
  { "dbdc.us", true },
  { "dbentertainment.co.uk", true },
  { "dbgamestudio.com", true },
  { "dbjc.tk", true },
  { "dblcastles.co.uk", true },
  { "dbldub.net", true },
  { "dbmiller.org", true },
  { "dbmteam.com", true },
  { "dborcard.com", true },
  { "dbpkg.com", true },
  { "dbq.com", true },
  { "dbrgn.ch", true },
  { "dbtsai.com", true },
  { "dc-elektro.com", true },
  { "dc-elektro.de", true },
  { "dc-elektro.eu", true },
  { "dc-occasies.be", true },
  { "dc-solution.de", false },
  { "dc1.com.br", true },
  { "dc562.org", true },
  { "dc585.info", true },
  { "dcain.me", true },
  { "dcards.in.th", true },
  { "dcautomacao.com.br", true },
  { "dcbouncycastles.co.uk", true },
  { "dcc.cat", true },
  { "dccommunity.de", true },
  { "dcepler.net", true },
  { "dchatelain.ch", true },
  { "dchest.org", true },
  { "dckd.nl", true },
  { "dclaisse.fr", true },
  { "dcmediahosting.com", true },
  { "dcmt.co", true },
  { "dcpower.eu", true },
  { "dcrdev.com", true },
  { "dcw.io", true },
  { "ddays2008.org", true },
  { "ddel.de", true },
  { "dden.ca", true },
  { "ddepot.us", true },
  { "ddholdingservices.com", true },
  { "ddhosted.com", true },
  { "ddns-test.de", true },
  { "ddnsweb.com", true },
  { "ddoser.cn", true },
  { "ddosolitary.org", true },
  { "ddproxy.cf", true },
  { "ddracepro.net", true },
  { "dds.mil", true },
  { "ddy.tw", true },
  { "de-gucci.com", true },
  { "de-mail.info", true },
  { "de-medici.nl", true },
  { "de-rwa.de", true },
  { "de-spil.be", true },
  { "de.search.yahoo.com", false },
  { "deadbeef.ninja", true },
  { "deadc0de.re", true },
  { "deadinsi.de", false },
  { "deaf.dating", true },
  { "deaf.eu.org", true },
  { "dealapp.nl", true },
  { "dealbanana.at", true },
  { "dealbanana.be", true },
  { "dealbanana.ch", true },
  { "dealbanana.co.uk", true },
  { "dealbanana.com", true },
  { "dealbanana.de", true },
  { "dealbanana.fi", true },
  { "dealbanana.fr", true },
  { "dealbanana.it", true },
  { "dealbanana.se", true },
  { "dealcruiser.nl", true },
  { "dealerselectric.com", true },
  { "dealinflatables.co.uk", true },
  { "dealpass.no", true },
  { "deamuseum.org", true },
  { "deanbank.com", true },
  { "deanisa.ninja", true },
  { "deanjerkovich.com", true },
  { "deanmorgan.org", true },
  { "deano-s.co.uk", true },
  { "deanosplace.net", true },
  { "deanpearce.net", true },
  { "dearfcc.com", true },
  { "dearfcc.net", true },
  { "dearfcc.org", true },
  { "dearktiel.nl", true },
  { "dearly.com", true },
  { "dearnevalleybouncycastles.co.uk", true },
  { "deathofspring.com", true },
  { "deathy.ro", true },
  { "debarrasantony.com", true },
  { "debarrasasnieressurseine.com", true },
  { "debarrasboulognebillancourt.com", true },
  { "debarrasclichy.com", true },
  { "debarrascolombes.com", true },
  { "debarrasnanterre.com", true },
  { "debbyefurd.com", true },
  { "debie-usedcars.be", true },
  { "debigare.com", true },
  { "debkleinteam.com", true },
  { "debora-singkreis.de", true },
  { "debron-ot.nl", true },
  { "debrusoft.ch", true },
  { "debt.com", true },
  { "debtrecycling.com.au", true },
  { "debuemon.com", true },
  { "debuis.nl", true },
  { "decaffeinated.io", true },
  { "decalquai.ch", true },
  { "decay24.de", true },
  { "dechat.nl", true },
  { "decher.de", true },
  { "decidetreatment.org", true },
  { "decis.fr", true },
  { "decisivetactics.com", true },
  { "deckbuilderamerica.com", true },
  { "declivitas.com", true },
  { "decoating.pl", true },
  { "decock-usedcars.be", true },
  { "decodeanddestroy.com", true },
  { "decoder.link", true },
  { "decompiled.de", true },
  { "decoora.com", true },
  { "decor-d.com", true },
  { "decoratingadvice.co.uk", true },
  { "decoratore.roma.it", true },
  { "decoratrix.com", true },
  { "decorauvent.ca", true },
  { "decorestilo.com.br", true },
  { "decosoftware.com", true },
  { "decrousaz-ceramique.ch", true },
  { "decs.es", true },
  { "dedelta.net", true },
  { "dedg3.com", true },
  { "dedge.org", true },
  { "dedicatedtowomenobgyn.com", true },
  { "dedimax.de", true },
  { "dedmorozrzn.ru", false },
  { "deduijventil.nl", true },
  { "dee.pe", true },
  { "dee.su", true },
  { "deechtebakkers.nl", true },
  { "deegeeinflatables.co.uk", true },
  { "deejayevents.ro", true },
  { "deelmijnreis.nl", true },
  { "deep-chess.com", true },
  { "deep.club", true },
  { "deepaero.com", true },
  { "deeparamaraj.com", true },
  { "deepbluecrafting.co.uk", true },
  { "deepblueemail.com", true },
  { "deepcode.io", true },
  { "deeperxh.com", true },
  { "deephill.com", true },
  { "deepinsight.io", true },
  { "deeployr.io", true },
  { "deeps.me", true },
  { "deepserve.info", true },
  { "deepsouthsounds.com", true },
  { "deepspace.dedyn.io", true },
  { "deepwealth.institute", true },
  { "deepz.pt", true },
  { "deepzz.com", true },
  { "def-pos.ru", true },
  { "defcon.org", true },
  { "defcongroups.org", true },
  { "defeestboek.nl", true },
  { "defendas.com", true },
  { "defender-pro.com", true },
  { "defendinnovation.org", true },
  { "defendtheweb.co.uk", true },
  { "defero.io", true },
  { "deflect.ca", true },
  { "deflumeri.com", true },
  { "deflumeriker.com", true },
  { "defman.me", true },
  { "defme.eu", true },
  { "defont.nl", true },
  { "defrax.com", true },
  { "defrax.de", true },
  { "defreitas.no", true },
  { "deftek.com", true },
  { "deftig-und-fein.de", true },
  { "deftnerd.com", true },
  { "defuse.ca", true },
  { "defxing.net", true },
  { "degata.com", true },
  { "degeberg.com", true },
  { "degeberg.dk", true },
  { "degen-elektrotechnik.de", true },
  { "degestamptepot.nl", true },
  { "degosoft.nl", true },
  { "degoulet.net", true },
  { "degracetechnologie.com", true },
  { "degressif.com", true },
  { "dehopre.com", true },
  { "deidee.nl", true },
  { "deinballon.de", true },
  { "deinewebsite.de", true },
  { "deinfoto.ch", true },
  { "deinserverhost.de", true },
  { "deitti.net", true },
  { "dejan.media", true },
  { "dejandayoff.com", true },
  { "dejure.org", true },
  { "dejw.cz", true },
  { "dekasiba.com", true },
  { "dekeurslagers.nl", true },
  { "dekka.cz", true },
  { "dekkercreativedesign.nl", true },
  { "dekko.io", true },
  { "dekoh-shouyu.com", true },
  { "dekonix.ru", true },
  { "dekulk.nl", true },
  { "delahrzolder.nl", true },
  { "delbecqvo.be", true },
  { "delbrouck.ch", true },
  { "deleidscheflesch.nl", true },
  { "delfic.org", true },
  { "delfino.cr", true },
  { "delhionlinegifts.com", true },
  { "deliacreates.com", true },
  { "deliandiver.org", true },
  { "deliciisanatoase.ro", true },
  { "deliciousmedia.co.uk", true },
  { "deliciousmedia.net", true },
  { "delicioustable.com", true },
  { "delid.cz", true },
  { "delitto.top", true },
  { "delivery.co.at", true },
  { "dellipaoli.com", true },
  { "delogo.nl", true },
  { "delorenzi.dk", true },
  { "delphine.dance", true },
  { "delta-data.ch", true },
  { "delta-smart.ch", true },
  { "delta.ru", true },
  { "delta23.de", false },
  { "deltaacademy.org", true },
  { "deltadata.ch", true },
  { "deltafinanceiro.com.br", true },
  { "deltanio.nl", true },
  { "deltaonlineguards.com", true },
  { "deltaservers.com.br", true },
  { "deltasigmachi.org", true },
  { "deltasmart.ch", true },
  { "deltava.org", true },
  { "demarle.ch", true },
  { "dementiapraecox.de", true },
  { "demeyere-usedcars.be", true },
  { "demfloro.ru", true },
  { "demijn.nl", true },
  { "demilletech.net", true },
  { "demiranda.com", true },
  { "demmer.one", true },
  { "demo9.ovh", true },
  { "democracychronicles.com", true },
  { "democracyineurope.eu", true },
  { "democraziaineuropa.eu", true },
  { "demolandia.net", true },
  { "demoniak.ch", true },
  { "demonwav.com", true },
  { "demonwolfdev.com", true },
  { "demotivatorbi.ru", true },
  { "dempsters.ca", false },
  { "demuzere.be", true },
  { "demuzere.com", true },
  { "demuzere.eu", true },
  { "demuzere.net", true },
  { "demuzere.org", true },
  { "denabot.pw", true },
  { "denaehula.com", true },
  { "denardbrewing.com", true },
  { "denbkh.ru", true },
  { "dengode.eu", true },
  { "denimtoday.com", true },
  { "denis-martinez.photos", true },
  { "denisewakeman.com", true },
  { "denistruffaut.fr", false },
  { "deniszczuk.pl", true },
  { "denizdesign.co.uk", true },
  { "denkubator.de", true },
  { "dennisang.com", true },
  { "dennisdoes.net", false },
  { "denniskoot.nl", true },
  { "dennismurphy.biz", true },
  { "dennisvandenbos.nl", true },
  { "dennogumi.org", true },
  { "denous.nl", true },
  { "dent.uy", true },
  { "dental-colleges.com", true },
  { "dentallaborgeraeteservice.de", true },
  { "dentfix.ro", false },
  { "dentistesdarveauetrioux.com", true },
  { "dentistglasgow.com", true },
  { "dentrassi.de", true },
  { "dentystabirmingham.co.uk", true },
  { "denwauranailab.com", true },
  { "deontology.com", true },
  { "depaddestoeltjes.be", true },
  { "depannage-traceur.fr", true },
  { "deparis.me", true },
  { "depeces.com", true },
  { "depechemode-live.com", true },
  { "depedncr.com", true },
  { "depedtalks.com", true },
  { "depicus.com", true },
  { "depone.net", true },
  { "depot-leipzig.de", true },
  { "depotsquarekerrville.com", true },
  { "depotter-usedcars.be", true },
  { "deprecate.de", true },
  { "depth-co.jp", true },
  { "depthe.gr", true },
  { "der-bank-blog.de", true },
  { "der-fliesenzauberer.de", true },
  { "der-gardinenmann.de", true },
  { "der-lan.de", true },
  { "der-rudi.eu", true },
  { "der-stein-fluesterer.de", true },
  { "der-windows-papst.de", true },
  { "derattizzazione.name", true },
  { "derattizzazioni.biz", true },
  { "derattizzazioni.milano.it", true },
  { "derattizzazioni.org", true },
  { "derbuntering.de", true },
  { "derbybouncycastles.com", true },
  { "derdewereldrommelmarkt.nl", true },
  { "derechosdigitales.org", true },
  { "dereddingsklos.nl", true },
  { "dereferenced.net", true },
  { "derehamcastles.co.uk", true },
  { "derekheld.com", true },
  { "derekseaman.com", true },
  { "derekseaman.studio", true },
  { "dergeilstestammderwelt.de", true },
  { "derhil.de", true },
  { "derk-jan.com", true },
  { "derkuki.de", true },
  { "derma-expert.eu", true },
  { "dermapuur.nl", true },
  { "dermato.floripa.br", true },
  { "dermatologie-morges.ch", true },
  { "dermediq.nl", true },
  { "dermot.org.uk", true },
  { "dermscc.com", true },
  { "deroo.org", true },
  { "derp.army", true },
  { "derp.chat", true },
  { "derre.fr", true },
  { "derreichesack.com", true },
  { "dersix.com", true },
  { "dersoundhunter.de", true },
  { "derstulle.de", true },
  { "des-hommes-et-des-clous.com", true },
  { "desagaz.com", true },
  { "desarrollowp.com", true },
  { "descartes-finance.com", true },
  { "desec.io", true },
  { "desertsounds.org", true },
  { "desgenst.ch", true },
  { "design-in-bad.eu", true },
  { "design-tooning.de", true },
  { "designdevs.eu", true },
  { "designed-cybersecurity.com", true },
  { "designedbygeniuses.com", true },
  { "designedcybersecurity.com", true },
  { "designer-drug.com", true },
  { "designera.se", true },
  { "designhotel-kronjuwel.de", true },
  { "designsbyjanith.com", true },
  { "designskin.ch", true },
  { "designville.cz", true },
  { "designville.sk", true },
  { "desila.jp", true },
  { "deskdesign.nl", true },
  { "deskeen.fr", true },
  { "desktopd.eu.org", true },
  { "desktopfx.net", false },
  { "deskture.com", true },
  { "deskvip.com", true },
  { "desmaakvanplanten.be", true },
  { "desmo.gg", true },
  { "despachomartinyasociados.com", true },
  { "despertadoronline.com.es", true },
  { "desplats.com.ar", true },
  { "dessinemoilademocratie.ch", true },
  { "destech.nl", true },
  { "desterman.ru", true },
  { "destileria.net.br", true },
  { "destinationsofnewyorkstate.com", true },
  { "destinattorneyjohngreene.com", true },
  { "destinoytarot.com", true },
  { "destinyofthephoenix.me", false },
  { "desu.ne.jp", true },
  { "desuchan.eu", true },
  { "desuchan.org", true },
  { "desuperheroes.co", true },
  { "det-te.ch", true },
  { "detalika.ru", true },
  { "detalyedesigngroup.com", true },
  { "detecmon.com", true },
  { "detectify.com", false },
  { "detectivedesk.com.au", true },
  { "detekenmuze.nl", true },
  { "dethemium.com", true },
  { "detodojuegos.com", true },
  { "detoxetmoi.com", true },
  { "detoxic.vn", true },
  { "detoxsinutritie.ro", true },
  { "detroit-english.de", true },
  { "detroitstylepizza.com", true },
  { "detroitzoo.org", true },
  { "detski.center", true },
  { "detskysad.com", true },
  { "detuinmuze.nl", true },
  { "detype.nl", true },
  { "deuchnord.fr", true },
  { "deude.de", true },
  { "deukie.nl", true },
  { "deurenfabriek.nl", true },
  { "deutsch-vietnamesisch-dolmetscher.com", true },
  { "deutsche-seniorenbetreuung.de", true },
  { "deutsche-tageszeitungen.de", true },
  { "deutschebusiness.com", true },
  { "deutscher-bericht.de", true },
  { "deutscher-rollenspielpreis.de", true },
  { "deutscheshoponline.com", true },
  { "deutschland-dsl.de", true },
  { "deuxmetrescubes.fr", true },
  { "dev-brandywineglobal.com", true },
  { "dev-gutools.co.uk", true },
  { "dev-pulse-mtn.pantheonsite.io", true },
  { "dev-sev-web.pantheonsite.io", true },
  { "dev-tek.de", true },
  { "devagency.fr", true },
  { "devalps.eu", true },
  { "devb.nl", true },
  { "devcf.com", true },
  { "devct.cz", false },
  { "devcu.com", true },
  { "devcu.net", true },
  { "devel.cz", true },
  { "developer.android.com", true },
  { "developer.mydigipass.com", false },
  { "developerdan.com", true },
  { "developerfair.com", true },
  { "developermail.io", false },
  { "developers.facebook.com", false },
  { "developfx.com", true },
  { "developmentaid.org", true },
  { "developmentsites.melbourne", true },
  { "develops.co.il", true },
  { "developyourelement.com", true },
  { "develux.com", true },
  { "develux.net", true },
  { "devh.net", true },
  { "deviant.email", true },
  { "devillers-occasions.be", true },
  { "devilshakerz.com", true },
  { "deviltraxxx.de", true },
  { "devinfo.net", false },
  { "devirc.net", true },
  { "deviser.wang", true },
  { "devisnow.fr", true },
  { "devkid.net", true },
  { "devklog.net", true },
  { "devlamvzw.org", false },
  { "devlatron.net", true },
  { "devlogr.com", true },
  { "devnull.zone", true },
  { "devonsawatzky.ca", true },
  { "devopers.com.br", true },
  { "devops-survey.com", true },
  { "devpsy.info", true },
  { "devragu.com", true },
  { "devrandom.net", true },
  { "devries.one", true },
  { "devsjournal.com", true },
  { "devsrvr.ru", true },
  { "devstaff.gr", true },
  { "devstroke.io", true },
  { "devtty.org", true },
  { "devyn.ca", false },
  { "devzero.io", true },
  { "dewaard.de", true },
  { "dewalch.net", true },
  { "dewapress.com", true },
  { "dewinter.com", true },
  { "dex.top", true },
  { "dexalo.de", true },
  { "dexigner.com", true },
  { "deyute.com", true },
  { "dez-online.de", true },
  { "dezeregio.nl", true },
  { "dezet-ev.de", true },
  { "dezintranet.com", true },
  { "dezmembrariromania.ro", true },
  { "dezshop24.de", true },
  { "df1paw.de", true },
  { "dfctaiwan.org", true },
  { "dfekt.no", true },
  { "dfektlan.no", true },
  { "dfl.mn", true },
  { "dflcares.com", true },
  { "dfmn.berlin", true },
  { "dfranke.com", true },
  { "dg7.in", true },
  { "dgblaw.com.au", false },
  { "dgbouncycastlehire.com", true },
  { "dgeex.eu", true },
  { "dggm.ru", true },
  { "dgitup.com", true },
  { "dgportals.co.uk", true },
  { "dgpot.com", true },
  { "dgt-portal.de", true },
  { "dharveydev.com", true },
  { "dhautefeuille.eu", true },
  { "dhauwer.nl", true },
  { "dhaynes.xyz", true },
  { "dhconcept.ch", true },
  { "dheart.net", true },
  { "dhhs.gov", true },
  { "dhinflatables.co.uk", true },
  { "dhlinux.org", true },
  { "dhome.at", true },
  { "dhuy.net", false },
  { "di2pra.com", true },
  { "di2pra.fr", true },
  { "dia-de.com", true },
  { "diablovalleytech.com", true },
  { "diadorafitness.es", true },
  { "diadorafitness.it", true },
  { "diagnostix.org", true },
  { "dialapicnic.co.za", true },
  { "dialoegue.com", true },
  { "diamante.ro", true },
  { "diamantovaburza.cz", true },
  { "diamond-hairstyle.dk", true },
  { "diamondsleepsolutions.com", true },
  { "diamondyze.nl", true },
  { "diamorphine.com", true },
  { "diamsmedia.ch", true },
  { "dianafaraj.de", true },
  { "dianefriedli.ch", true },
  { "dianurse.com", true },
  { "diare-na-miru.cz", true },
  { "diario-egipto.com", true },
  { "diarynote.jp", true },
  { "diasdasemana.com", true },
  { "diasp.org", true },
  { "diatrofi-ygeia.gr", true },
  { "diba.org.cn", true },
  { "dibiphp.com", true },
  { "diccionarioabierto.com", true },
  { "diccionariodedudas.com", true },
  { "dice.tokyo", true },
  { "dicelab.co.uk", true },
  { "dicesites.com", true },
  { "dicionario.org", true },
  { "dicionariodegirias.com.br", true },
  { "dicionariodelatim.com.br", true },
  { "dicionariodenomesproprios.com.br", true },
  { "dicionariodesimbolos.com.br", true },
  { "dicionarioetimologico.com.br", true },
  { "dicionariofinanceiro.com", true },
  { "dicionariopopular.com", true },
  { "dickieslife.com", true },
  { "dickord.club", true },
  { "dickpics.ru", true },
  { "dicksakowicz.com", true },
  { "dicoding.com", true },
  { "dictionaryofnumbers.com", true },
  { "dictzone.com", true },
  { "didacte.com", true },
  { "didche.net", true },
  { "diddens.de", true },
  { "dideeducacion.com", true },
  { "didefamilia.com", true },
  { "didesalud.com", true },
  { "didierghez.com", true },
  { "didigotoffer.com", true },
  { "die-bergfuehrer.de", true },
  { "die-blahuts.de", true },
  { "die-borts.ch", true },
  { "die-partei-reutlingen.de", true },
  { "die-pizzabaeckerei.de", true },
  { "die-seide.de", true },
  { "die-sinlosen.de", true },
  { "die-speisekammer-reutlingen.de", true },
  { "diedrich.co", true },
  { "diedrich.me", true },
  { "dieecpd.org", true },
  { "diegelernten.de", true },
  { "diegerbers.de", true },
  { "diegobarrosmaia.com.br", true },
  { "diegogelin.com", true },
  { "diegorbaquero.com", true },
  { "diehl.io", true },
  { "diekperaiwseis.gr", true },
  { "diem-project.org", true },
  { "diemattels.at", true },
  { "dienchaninstitute.com", true },
  { "dienstplan.cc", true },
  { "dienstplan.one", true },
  { "dierenartsdeconinck.be", true },
  { "dieselanimals.lt", true },
  { "dieselgalleri.com", true },
  { "diesteppenreiter.de", true },
  { "dietaanticelulitica.com", true },
  { "dietaanticelulitis.com", true },
  { "dietacelulitis.com", true },
  { "dietafeliz.com", true },
  { "dietbrand.eu", true },
  { "dieterglas.de", true },
  { "dieterstinglhamber.me", true },
  { "dieti.net", true },
  { "dietlin.com", true },
  { "dietrich.cx", true },
  { "dieumfrage.com", true },
  { "different.cz", false },
  { "differenta.ro", false },
  { "diffnow.com", true },
  { "difoosion.com", true },
  { "difusordeambientes.com.br", true },
  { "digcit.org", true },
  { "digdata.de", true },
  { "dighans.com", true },
  { "digiarc.net", true },
  { "digibild.ch", true },
  { "digibones.be", true },
  { "digibull.email", true },
  { "digibull.link", true },
  { "digicert-support.com", true },
  { "digicert.nl", true },
  { "digicy.cloud", true },
  { "digideli.ee", true },
  { "digidroom.be", true },
  { "digilicious.com", true },
  { "digimagical.com", true },
  { "digimedia.cd", false },
  { "digimomedia.co.uk", true },
  { "digioccumss.ddns.net", true },
  { "digipitch.com", true },
  { "digital-compounds.com", true },
  { "digital-eastside.de", true },
  { "digital-liberal.ch", true },
  { "digital-muscle.com.au", true },
  { "digital.gov", false },
  { "digital.govt.nz", true },
  { "digital1st.co.uk", true },
  { "digital2web.com", false },
  { "digitalarchitecture.com", true },
  { "digitalbitbox.com", true },
  { "digitalcash.cf", true },
  { "digitalcitizen.life", true },
  { "digitalcitizen.ro", true },
  { "digitalcraftmarketing.co.uk", true },
  { "digitalcreationclass.com", true },
  { "digitaldashboard.gov", true },
  { "digitaldatacenter.net", true },
  { "digitaldeli.com", true },
  { "digitaldeli.org", true },
  { "digitaldeli.tv", true },
  { "digitaldeli.us", true },
  { "digitaldeliarchive.com", true },
  { "digitaldem.it", true },
  { "digitalehandtekeningen.nl", true },
  { "digitaleoverheid.nl", true },
  { "digitaletanker.com", true },
  { "digitalezukunft-hagen.de", true },
  { "digitalezukunft.nrw", true },
  { "digitalfishfun.com", true },
  { "digitalfury.co.uk", true },
  { "digitalfuturenow.com", true },
  { "digitalgov.gov", false },
  { "digitalhabit.at", true },
  { "digitalhabitat.io", true },
  { "digitalliteracy.gov", true },
  { "digitalmarketingindallas.com", true },
  { "digitalposition.com", true },
  { "digitalrights.center", true },
  { "digitalrights.fund", true },
  { "digitalskillswap.com", true },
  { "digitalsurge.io", true },
  { "digitaltcertifikat.dk", true },
  { "digitaltechnologies.ltd.uk", true },
  { "digitkon.com", true },
  { "digitreads.com", true },
  { "digminecraft.com", true },
  { "digwp.com", true },
  { "dihesan.com", true },
  { "dijitaller.com", true },
  { "dijkmanmuziek.nl", false },
  { "dijkmanvandoorn.nl", false },
  { "diju.ch", true },
  { "dildoexperten.se", true },
  { "diligo.ch", true },
  { "dillewijnzwapak.nl", true },
  { "dillonkorman.com", true },
  { "diluv.com", true },
  { "dimanss47.net", true },
  { "dimdom.com.br", true },
  { "dime-staging.com", true },
  { "dime.io", true },
  { "dimeponline.com.br", true },
  { "dimeshop.nl", true },
  { "dimez.ru", true },
  { "dimiskovska.de", true },
  { "dimitrihomes.com", true },
  { "dimmersagourahills.com", true },
  { "dimmerscalabasas.com", true },
  { "dimmersdosvientos.com", true },
  { "dimmershiddenhills.com", true },
  { "dimmerslakesherwood.com", true },
  { "dimmersnewburypark.com", true },
  { "dimmersoakpark.com", true },
  { "dimmersthousandoaks.com", true },
  { "dimmerswestlakevillage.com", true },
  { "dimonb.com", true },
  { "dimseklubben.dk", true },
  { "din-hkd.jp", true },
  { "dineachook.com.au", true },
  { "dinepont.fr", true },
  { "dinerroboticurology.com", true },
  { "dingcc.me", true },
  { "dingsbums.shop", true },
  { "dinheirolucrar.com", true },
  { "dinkommunikasjon.no", true },
  { "dinmtb.dk", true },
  { "dinocarrozzeria.com", true },
  { "dinstec.cl", true },
  { "dintrafic.net", true },
  { "diodeled.com", true },
  { "diodo.me", true },
  { "dionysos-ios.gr", true },
  { "diozoid.com", true },
  { "dipalma.me", true },
  { "dipdaq.com", true },
  { "dipling.de", true },
  { "diplona.de", true },
  { "dipulse.it", true },
  { "dir2epub.com", true },
  { "dir2epub.org", true },
  { "dirba.io", true },
  { "direct-sel.com", true },
  { "direct365.es", true },
  { "directebanking.com", true },
  { "directelectricalltd.co.uk", true },
  { "directlinkfunding.co.uk", true },
  { "directnews.be", true },
  { "directorioz.com", true },
  { "directreal.sk", true },
  { "directspa.fr", true },
  { "direktvermarktung-schmitzberger.at", true },
  { "dirk-scheele.de", true },
  { "dirk-weise.de", true },
  { "dirkdoering.de", true },
  { "dirkjonker.nl", true },
  { "dirko.net", true },
  { "dirkwolf.de", true },
  { "dirtcraft.ca", true },
  { "dirtygeek.ovh", true },
  { "dirtyincest.com", true },
  { "dirtyprettyartwear.com", true },
  { "disability.gov", true },
  { "disabled.dating", true },
  { "disanteimpianti.com", true },
  { "disavow.tools", true },
  { "disc.uz", true },
  { "discarica.bari.it", true },
  { "discarica.bologna.it", true },
  { "discarica.it", true },
  { "discarica.roma.it", true },
  { "discha.net", true },
  { "dischempharmacie.com", true },
  { "disciples.io", true },
  { "disciplina.io", true },
  { "discipul.nl", true },
  { "discofitta.com", true },
  { "disconformity.net", true },
  { "discord.gg", true },
  { "discord4j.com", true },
  { "discordapp.com", true },
  { "discordghost.space", true },
  { "discordia.me", true },
  { "discotek.club", true },
  { "discount24.de", true },
  { "discountlumberspokane.com", true },
  { "discountplush.com", true },
  { "discover-shaken.com", true },
  { "discoverthreejs.com", true },
  { "discoveryaima.com", true },
  { "discoveryottawa.ca", true },
  { "discoveryrom.org", true },
  { "discreet-condooms.nl", true },
  { "discrypt.ca", true },
  { "dise-online.de", true },
  { "disinclined.org", true },
  { "disinfesta.it", true },
  { "disinfestando.info", true },
  { "disinfestatori.com", true },
  { "disinfestazione.brescia.it", true },
  { "disinfestazione.torino.it", true },
  { "disinfestazione.venezia.it", true },
  { "disinfestazione.verona.it", true },
  { "disinfestazione24.it", true },
  { "disinfestazioneblatte.it", true },
  { "disinfestazionecimici.roma.it", true },
  { "disinfestazioni-umbria.it", true },
  { "disinfestazioni.bari.it", true },
  { "disinfestazioni.bergamo.it", true },
  { "disinfestazioni.catania.it", true },
  { "disinfestazioni.co", true },
  { "disinfestazioni.firenze.it", true },
  { "disinfestazioni.genova.it", true },
  { "disinfestazioni.gorizia.it", true },
  { "disinfestazioni.info", true },
  { "disinfestazioni.milano.it", true },
  { "disinfestazioni.net", true },
  { "disinfestazioni.padova.it", true },
  { "disinfestazioni.rimini.it", true },
  { "disinfestazioni.torino.it", true },
  { "disinfestazioni.treviso.it", true },
  { "disinfestazioni.udine.it", true },
  { "disinfestazioni.venezia.it", true },
  { "disinfestazioni.verona.it", true },
  { "disinfestazionivespe.milano.it", true },
  { "disinfestazionizanzare.milano.it", true },
  { "disinisharing.com", true },
  { "disk.do", true },
  { "diskbit.com", true },
  { "diskbit.nl", true },
  { "disking.co.uk", true },
  { "dismail.de", true },
  { "dispatchitsolutions.com", true },
  { "dispatchitsolutions.io", true },
  { "disposable.link", true },
  { "disroot.org", true },
  { "disrupters.ch", true },
  { "dissertationhelp.com", true },
  { "dissidence.ovh", true },
  { "dissident.host", true },
  { "dist-it.com", true },
  { "dist.torproject.org", false },
  { "disti.com", true },
  { "distiduffer.org", true },
  { "distillery.com", true },
  { "distinguishedprisoner.com", true },
  { "distribuidoracristal.com.br", true },
  { "distribuidoraplus.com", true },
  { "distribuidorveterinario.es", true },
  { "distro.fr", true },
  { "ditelbat.com", true },
  { "diti.me", true },
  { "ditisabc.nl", true },
  { "div.im", true },
  { "diva.nl", true },
  { "divari.nl", true },
  { "divcoder.com", true },
  { "dive-japan.com", true },
  { "divedowntown.com", true },
  { "divegearexpress.com", true },
  { "divegearexpress.net", true },
  { "diveidc.com", true },
  { "diveplan.org", true },
  { "divergenz.org", true },
  { "diversityflags.com", true },
  { "diversityflags.com.au", true },
  { "diversityflags.nz", true },
  { "divertiagua.com.br", true },
  { "divi-experte.de", true },
  { "divinasaiamodas.com.br", true },
  { "divinegames.studio", true },
  { "divinemercyparishvld.com", true },
  { "divinemercyparishvlds.com", true },
  { "diving.photo", true },
  { "divorcelawyersformen.com", true },
  { "divorciosmurcia.com", true },
  { "diwei.vip", true },
  { "dixi.fi", true },
  { "dixibox.com", true },
  { "diybook.at", true },
  { "diycc.org", true },
  { "diygod.me", true },
  { "diymediahome.org", true },
  { "diyosun.com", true },
  { "diytechguides.com", true },
  { "diyvideoeditor.com", true },
  { "dizzythewizard.co.uk", true },
  { "dj-leszwolle.nl", true },
  { "dj-x.info", true },
  { "dj3dub.com", true },
  { "djangobirthday.com", true },
  { "djangogolf.com", true },
  { "djangoproject.com", true },
  { "djangosnippets.org", true },
  { "djbbouncycastles.co.uk", true },
  { "djboekingskantoor.nl", true },
  { "djc.me", true },
  { "djcursuszwolle.nl", true },
  { "djdavid98.hu", true },
  { "djeung.org", true },
  { "djipanov.com", true },
  { "djleon.net", true },
  { "djlive.pl", true },
  { "djlnetworks.co.uk", true },
  { "djroynomden.nl", true },
  { "djsbouncycastlehire.com", true },
  { "djt-vom-chausseehaus.de", true },
  { "djursland-psykologen.dk", true },
  { "djvintagevinyl.nl", true },
  { "djwaynepryke.com", true },
  { "djz4music.com", false },
  { "dk-kromeriz.cz", true },
  { "dk.com", true },
  { "dk.search.yahoo.com", false },
  { "dkcomputers.com.au", true },
  { "dkds.us", true },
  { "dko-steiermark.ml", true },
  { "dkstage.com", true },
  { "dkwedding.gr", true },
  { "dl.google.com", true },
  { "dlabouncycastlehire.co.uk", true },
  { "dlaspania.pl", true },
  { "dlde.ru", true },
  { "dldl.fr", true },
  { "dlfsymposium.nl", true },
  { "dlitz.net", true },
  { "dll4free.com", true },
  { "dlld.com", true },
  { "dlrsp.org", true },
  { "dlscomputers.com.au", true },
  { "dlui.xyz", true },
  { "dlunch.net", true },
  { "dlyanxs.com", true },
  { "dlz149.me", true },
  { "dlzz.net", true },
  { "dm.lookout.com", false },
  { "dm.mylookout.com", false },
  { "dm4productions.com", true },
  { "dm7ds.de", true },
  { "dmaglobal.com", true },
  { "dmailshop.ro", true },
  { "dmarc.dk", true },
  { "dmatrix.xyz", true },
  { "dmd.lv", true },
  { "dmdd.org.uk", true },
  { "dmeevalumate.com", true },
  { "dmess.ru", true },
  { "dmi.es", true },
  { "dmitry.sh", true },
  { "dmmultionderhoud.nl", true },
  { "dmparish.com", true },
  { "dmschilderwerken.nl", true },
  { "dmx.xyz", true },
  { "dmxledlights.com", true },
  { "dn3s.me", true },
  { "dn42.eu", false },
  { "dn42.us", true },
  { "dna.li", true },
  { "dnacloud.pl", true },
  { "dnakids.co.uk", true },
  { "dnc.org.nz", true },
  { "dndtools.net", true },
  { "dne.lu", true },
  { "dnlr.tech", true },
  { "dnmlab.it", true },
  { "dnplegal.com", true },
  { "dns-control.eu", true },
  { "dns-swiss.ch", true },
  { "dns.google.com", true },
  { "dns8.online", true },
  { "dnscrawler.com", true },
  { "dnscrypt.info", true },
  { "dnscurve.io", true },
  { "dnshallinta.fi", true },
  { "dnsinfo.ml", true },
  { "dnsipv6.srv.br", true },
  { "dnsman.se", true },
  { "dnspod.ml", true },
  { "dnstwister.report", true },
  { "do-prod.com", true },
  { "do.gd", true },
  { "do.search.yahoo.com", false },
  { "do13.net", true },
  { "do67.de", true },
  { "do67.net", true },
  { "dobraprace.cz", true },
  { "dobrisan.ro", true },
  { "dobsnet.net", true },
  { "doc.python.org", true },
  { "doc.to", true },
  { "doc8643.com", true },
  { "docabo.ch", true },
  { "docbox.ch", true },
  { "doceamoraviverbem.com", true },
  { "docemeldoces.com", true },
  { "dochimera.com", true },
  { "dochitaceahlau.ro", true },
  { "dockerbook.com", false },
  { "dockerup.net", true },
  { "docline.gov", true },
  { "docloh.de", true },
  { "docloudu.info", true },
  { "docplexus.com", true },
  { "docs.google.com", false },
  { "docs.python.org", true },
  { "docs.re", true },
  { "docs.tw", true },
  { "doctabaila.com", true },
  { "doctafit.com", true },
  { "doctor-locks.co.uk", true },
  { "doctor.dating", true },
  { "doctorbini.com", true },
  { "doctorfox.co.uk", true },
  { "doctorsonmaps.com", true },
  { "doctorwho.cz", true },
  { "docubox.info", true },
  { "docucopies.com", true },
  { "documaniatv.com", true },
  { "docupet.com", true },
  { "docusearch.com", true },
  { "dodopri.com", true },
  { "doenjoylife.com", true },
  { "does.one", true },
  { "doesburg-comp.nl", true },
  { "dofuspvp.com", true },
  { "dofux.org", true },
  { "dog-blum.com", true },
  { "dogadayiz.net", true },
  { "dogan.ch", false },
  { "dogcontrol.ca", true },
  { "doge.me", true },
  { "doge.town", true },
  { "dogear.ch", true },
  { "dogft.com", true },
  { "doggedbyirs.com", true },
  { "doggroomingcourse.com", true },
  { "dogmap.jp", true },
  { "dogoo.com", true },
  { "dogpawstudio.com", true },
  { "dogrescuegreece.nl", true },
  { "dogworld.com.br", true },
  { "dohanews.co", true },
  { "doihavetoputonpants.com", true },
  { "doitauto.de", true },
  { "dojozendebourges.fr", true },
  { "dokelio-idf.fr", true },
  { "doki.space", true },
  { "dokipy.no", true },
  { "doku-gilde.de", true },
  { "dokuboard.com", true },
  { "dokuraum.de", true },
  { "dolci-delizie.de", true },
  { "dolciterapie.com", true },
  { "doleta.gov", true },
  { "doli.se", true },
  { "dolice.net", true },
  { "dolinathome.com", true },
  { "dollemore.com", true },
  { "dollhousetoyo.com", true },
  { "dolorism.com", true },
  { "dolphin-it.de", true },
  { "dom-medicina.ru", true },
  { "doma.in", true },
  { "domadillo.com", true },
  { "domain-ermittlung.de", true },
  { "domain-swiss.ch", true },
  { "domain001.info", true },
  { "domainedemiolan.ch", true },
  { "domainexpress.de", false },
  { "domainhacks.io", true },
  { "domainkauf.de", true },
  { "domainoo.com", true },
  { "domains.autos", true },
  { "domains.boats", true },
  { "domains.google.com", true },
  { "domains.homes", true },
  { "domains.motorcycles", true },
  { "domains.yachts", true },
  { "domainsilk.com", true },
  { "domainspeicher.one", true },
  { "domainstaff.com", true },
  { "domainwatch.me", true },
  { "domakidis.com", true },
  { "domaxpoker.com", true },
  { "domeconseil.fr", true },
  { "domein-direct.nl", true },
  { "domenic.me", true },
  { "domenicam.com", true },
  { "domesticcleaners.co.uk", true },
  { "domhaase.me", true },
  { "domian.cz", true },
  { "dominationgame.co.uk", true },
  { "dominicself.co.uk", true },
  { "dominik-schlueter.de", true },
  { "dominikaner-vechta.de", true },
  { "dominikkulaga.pl", true },
  { "dominionregistries.domains", true },
  { "dominique-haas.fr", true },
  { "dominoknihy.cz", true },
  { "dominomatrix.com", true },
  { "domix.fun", true },
  { "domizx.de", true },
  { "dommascate.com.br", true },
  { "domob.eu", true },
  { "domodeco.fr", true },
  { "domodedovo.travel", true },
  { "domprojects.com", true },
  { "domquixoteepi.com.br", true },
  { "domscripting.com", true },
  { "domster.com", true },
  { "domus-global.com", true },
  { "domus-global.cz", true },
  { "domwkwiatach.pl", true },
  { "domyassignments.com", true },
  { "domycasestudy.com", true },
  { "domycoursework.com", true },
  { "domycreativewritings.com", true },
  { "domydissertations.com", true },
  { "domyessay.net", true },
  { "domyessays.com", true },
  { "domyhomeworks.net", true },
  { "domynetwork.com", true },
  { "domypapers.com", true },
  { "domyresearchpaper.com", true },
  { "domyreview.net", true },
  { "domyspeech.com", true },
  { "domythesis.net", true },
  { "domyzitrka.cz", true },
  { "donabeneko.jp", true },
  { "donaldm.co.uk", true },
  { "donateaday.net", true },
  { "donateway.com", true },
  { "donboscogroep.nl", true },
  { "donfelino.tk", false },
  { "dongxuwang.com", true },
  { "donjusto.nl", true },
  { "donkennedyandsons.com", true },
  { "donkeytrekkingkefalonia.com", true },
  { "donmaldeamores.com", true },
  { "donna-bellini-fotografie-berlin.de", true },
  { "donna-bellini-fotografie-erfurt.de", true },
  { "donna-bellini-fotografie-frankfurt.de", true },
  { "donna-bellini-fotografie-hamburg.de", true },
  { "donna-bellini-fotografie-koeln.de", true },
  { "donna-bellini-fotografie-muenchen.de", true },
  { "donna-bellini-fotografie-nuernberg.de", true },
  { "donna-bellini-fotografie-stuttgart.de", true },
  { "donna-bellini-fotografie-wien.de", true },
  { "donna-bellini-hochzeitsfotograf-frankfurt.de", true },
  { "donna-bellini-hochzeitsfotograf-muenchen.de", true },
  { "donnaandscottmcelweerealestate.com", true },
  { "donnacha.blog", true },
  { "donnachie.net", true },
  { "donner-reuschel.de", true },
  { "donnons.org", false },
  { "donnoval.ru", false },
  { "donotcall.gov", true },
  { "donotlink.it", true },
  { "donovand.info", true },
  { "donovankraag.nl", true },
  { "dont.re", true },
  { "dont.watch", true },
  { "dontbubble.me", true },
  { "dontcageus.org", true },
  { "dontpayfull.com", true },
  { "donttrust.me", true },
  { "donutcompany.co.jp", true },
  { "donzool.es", true },
  { "dooby.fr", true },
  { "dooleylabs.com", true },
  { "dooleytackaberry.com", true },
  { "doomoo.com", true },
  { "doomsworld.com", true },
  { "doomtech.net", true },
  { "doomus.me", true },
  { "doooooops.com", true },
  { "doop.im", true },
  { "doordecor.bg", true },
  { "doorflow.com", true },
  { "doorhandlese.com", true },
  { "doorshingekit.com", true },
  { "dopesoft.de", true },
  { "dopetrue.com", true },
  { "doppenpost.nl", true },
  { "dopply.com", true },
  { "dopravni-modely.cz", true },
  { "dopsi.ch", true },
  { "dora.moe", true },
  { "dorde.eu", true },
  { "dorfbaeck.at", true },
  { "dorfbrunnen.eu", true },
  { "dorfzittig.de", true },
  { "doriangirod.ch", true },
  { "dorianharmans.nl", true },
  { "dorianmuthig.com", true },
  { "doridian.com", true },
  { "doridian.de", true },
  { "doridian.net", true },
  { "doridian.org", true },
  { "dormirmucho.com", true },
  { "dormiu.com", true },
  { "dormiu.com.br", true },
  { "dornhecker.me", true },
  { "dorpshuis-dwarsgracht.nl", true },
  { "dorpshuiskesteren.nl", true },
  { "dorquelle.com", true },
  { "dorsetentertainments.co.uk", true },
  { "dorth.nl", true },
  { "dosdediez.com", true },
  { "dosenbierrepublik.com", true },
  { "dosenkiwi.at", true },
  { "doska.by", true },
  { "doska.ru", true },
  { "dosomeworks.biz", true },
  { "dossplumbing.co.za", true },
  { "dostalsecurity.com", true },
  { "dostlar.fr", true },
  { "dostrece.net", true },
  { "dosvientoselectric.com", true },
  { "dosvientoselectrical.com", true },
  { "dosvientoselectrician.com", true },
  { "dosvientosexteriorlighting.com", true },
  { "dosvientoslandscapelighting.com", true },
  { "dosvientoslighting.com", true },
  { "dosvientosoutdoorlighting.com", true },
  { "doswap.com", true },
  { "dosyauzantisi.com", true },
  { "dot42.no", true },
  { "dota2huds.com", true },
  { "dotacni-parazit.cz", true },
  { "dotbigbang.com", true },
  { "dotbox.org", true },
  { "dotcircle.co", true },
  { "dotconnor.com", true },
  { "dotgov.gov", true },
  { "dothebangthingsalon.com", true },
  { "dothydesign.com", true },
  { "dotjesper.com", true },
  { "dotjesper.dk", true },
  { "dotjesper.net", true },
  { "dotjs.party", true },
  { "dotkniseandroida.cz", true },
  { "dotkod.pl", true },
  { "dotneko.net", true },
  { "dotphoto.com", true },
  { "dotplex.com", true },
  { "dotplex.de", true },
  { "dotrox.net", true },
  { "dotshule.ug", true },
  { "dotsiam.co.th", true },
  { "dotsiam.com", true },
  { "dotsiam.in.th", true },
  { "douai.me", true },
  { "doubleaste.com", true },
  { "doubleavineyards.com", true },
  { "doublefun.net", true },
  { "doublestat.me", true },
  { "doubleup.com.au", true },
  { "doucheba.gs", false },
  { "dougley.com", true },
  { "dougsautobody.com", true },
  { "doujinshi.info", true },
  { "doujinspot.com", true },
  { "dounats.com", true },
  { "douzer.de", true },
  { "douzer.industries", true },
  { "dovenzorgmalawi.nl", true },
  { "dovro.de", true },
  { "dowell.media", true },
  { "dowellconsulting.com", true },
  { "dowhatmakegood.de", true },
  { "dowling.nz", true },
  { "downloadaja.com", true },
  { "downloadgamemods.com", true },
  { "downloadgram.com", true },
  { "downloadhindimovie.com", true },
  { "downloadhindimovie.net", true },
  { "downloadhindimovies.net", true },
  { "downloads.zdnet.com", true },
  { "downloadsoftwaregratisan.com", true },
  { "downrightcute.com", true },
  { "downtimerobot.com", true },
  { "downtimerobot.nl", true },
  { "downtownautospecialists.com", true },
  { "downtownvernon.com", true },
  { "doyoucheck.com", false },
  { "doyouedc.com", true },
  { "doyoutax.com", true },
  { "doypacky.cz", true },
  { "doze-cloud.tech", true },
  { "dozecloud.com", true },
  { "dp.cx", true },
  { "dpd.com.pl", true },
  { "dpecuador.com", true },
  { "dperson.net", true },
  { "dpfsolutionsfl.com", true },
  { "dpg.no", true },
  { "dpi-design.de", true },
  { "dpisecuretests.com", true },
  { "dpm-ident.de", true },
  { "dprb.biz", true },
  { "dprd-wonogirikab.go.id", false },
  { "dps.srl", true },
  { "dpsg-roden.de", true },
  { "dpwsweeps.co.uk", true },
  { "dr-becarelli-philippe.chirurgiens-dentistes.fr", true },
  { "dr-bodendorf.de", true },
  { "dr-it.co.uk", true },
  { "dr-jakob-zahnaerzte.de", true },
  { "dr-klotz.info", true },
  { "dr-krebs.net", true },
  { "dr-marlen-nystroem.de", true },
  { "dr-moldovan.de", true },
  { "dr-nystroem.de", true },
  { "dr-schlamminger.de", true },
  { "dr-schmutzer.de", true },
  { "dr-schuessler.de", true },
  { "dr-stoetter.de", true },
  { "dr-www.de", true },
  { "dr2dr.ca", true },
  { "drabadir.com", true },
  { "drabim.org", true },
  { "drach.xyz", true },
  { "drachenleder.de", true },
  { "dracisvet.cz", true },
  { "dracon.es", true },
  { "dracox.com", true },
  { "draftguru.com.au", true },
  { "drafton.com", true },
  { "drageeparadise.fr", true },
  { "dragfiles.com", true },
  { "draghetti.it", true },
  { "draghive.asia", true },
  { "draghive.ca", true },
  { "draghive.co", true },
  { "draghive.co.uk", true },
  { "draghive.com", true },
  { "draghive.org", true },
  { "draghive.tv", true },
  { "dragon-chem.eu", true },
  { "dragon-hearts.co.uk", true },
  { "dragoncave.me", true },
  { "dragonclean.gr", true },
  { "dragonfly.co.uk", true },
  { "dragonheartsrpg.com", true },
  { "dragonkin.net", true },
  { "dragonprogrammer.com", true },
  { "dragonschool.org", true },
  { "dragonsunited.at", true },
  { "dragonsunited.ch", true },
  { "dragonsunited.de", true },
  { "dragonsunited.eu", true },
  { "dragonsunited.info", true },
  { "dragonsunited.net", true },
  { "dragonsunited.org", true },
  { "dragonwolfpackaquaria.com", true },
  { "dragonwork.me", true },
  { "drahcro.uk", true },
  { "drakecommercial.com", true },
  { "drakeluce.com", true },
  { "drakenson.de", true },
  { "draliabadi.com", true },
  { "dramaticpeople.com", true },
  { "dramyalderman.com", true },
  { "dranderle.com", true },
  { "dras.hu", true },
  { "draugr.de", true },
  { "draw.uy", true },
  { "drawesome.uy", true },
  { "drawingcode.net", true },
  { "drawtwo.gg", true },
  { "drawxp.com", true },
  { "drbethanybarnes.com", true },
  { "drbriones.com", true },
  { "drcarolynquist.com", true },
  { "drchrislivingston.com", true },
  { "drchristinehatfield.ca", true },
  { "drchristophepanthier.com", true },
  { "drdipilla.com", true },
  { "dreamcreator108.com", true },
  { "dreamday-with-dreamcar.de", true },
  { "dreamdivers.com", true },
  { "dreamhack.com", true },
  { "dreamhostremixer.com", true },
  { "dreamithost.com.au", true },
  { "dreamkitchenbath.com", true },
  { "dreamlandmagic.com", true },
  { "dreamlinehost.com", false },
  { "dreamlordpress.it", true },
  { "dreamlux.cz", true },
  { "dreamlux.sk", true },
  { "dreammaker-nw.com", true },
  { "dreammakerremodelil.com", true },
  { "dreammakerutah.com", true },
  { "dreamof.net", true },
  { "dreamonkey.com", true },
  { "dreamrae.net", true },
  { "dreamstream.network", true },
  { "dreamstream.nl", true },
  { "dreamstream.tv", true },
  { "dreamstream.video", true },
  { "dreamtechie.com", true },
  { "dreatho.com", true },
  { "dreemurr.com", true },
  { "drei01.com", true },
  { "drei01.de", true },
  { "dreid.org", true },
  { "dreiweiden.de", true },
  { "dresden-kaffee-24.de", true },
  { "dresden-kaffeeroesterei.de", true },
  { "dresdener-mandelstollen.de", true },
  { "dresdens-pfefferkuchenprinzessin.de", true },
  { "dresdner-christstollen-von-reimann.de", true },
  { "dresdner-kaffeeroesterei.de", true },
  { "dresdner-mandelstollen.de", true },
  { "dresdner-stollen.shop", true },
  { "dress-cons.com", true },
  { "dressify.co", true },
  { "dressify.in", true },
  { "drevanbeale.com", true },
  { "drevo-door.cz", true },
  { "drew.beer", true },
  { "drew.red", true },
  { "drewapianostudio.com", true },
  { "dreweryinc.com", true },
  { "drewsilcock.co.uk", true },
  { "dreyfussplasticsurgery.com", true },
  { "drezzy.it", true },
  { "drfranciscofonseca.com.br", true },
  { "drfrey.ch", true },
  { "drgdrp.com", true },
  { "drgn.no", true },
  { "drhathazi.hu", true },
  { "drheibel.com", true },
  { "driesjtuver.nl", true },
  { "driessoftsec.tk", true },
  { "driftdude.nl", true },
  { "drighes.com", true },
  { "drillingsupply.info", true },
  { "drillingsupplystore.com", true },
  { "drillion.net", true },
  { "drillshackresort.com", true },
  { "drinkcontrolapp.com", true },
  { "drinkgas-jihlava.cz", true },
  { "drive.google.com", false },
  { "driven2shine.eu", true },
  { "drivenes.net", true },
  { "driver.ru", true },
  { "driver61.com", true },
  { "driverless.id", true },
  { "driverprofiler.co.uk", true },
  { "driverscollection.com", true },
  { "drivinghorror.com", true },
  { "drivingtestpro.com", true },
  { "drivinhors.com", true },
  { "drivya.com", true },
  { "drixn.cn", true },
  { "drixn.com", true },
  { "drizz.com.br", false },
  { "drjacquesmalan.com", true },
  { "drjenafernandez.com", true },
  { "drjoe.ca", true },
  { "drjuanitacollier.com", false },
  { "drjulianneil.com", true },
  { "drkhsh.at", false },
  { "drkmtrx.xyz", true },
  { "drlandis.com", true },
  { "drlangsdon.com", true },
  { "drlinkcheck.com", true },
  { "drlutfi.com", true },
  { "drmayakato.com", true },
  { "drmcdaniel.com", true },
  { "drms.us", true },
  { "drmtransit.com", true },
  { "drnow.ru", true },
  { "drogueriaelbarco.com", true },
  { "droidapp.nl", true },
  { "droidgyan.com", true },
  { "droidhere.com", true },
  { "droidim.com", false },
  { "droidwave.com", true },
  { "droidwiki.de", true },
  { "drone-it.net", true },
  { "dronebl.org", true },
  { "dronepit.dk", true },
  { "droni.cz", true },
  { "dronnet.com", false },
  { "dronografia.es", true },
  { "dronova-art.ru", true },
  { "drop.com", true },
  { "dropbox.com", true },
  { "dropboxer.net", true },
  { "dropistic.com", true },
  { "dropq.nl", true },
  { "dropscloud.spdns.de", true },
  { "dropshare.cloud", true },
  { "dropshell.net", true },
  { "droso.dk", true },
  { "drown.photography", true },
  { "drpetervoigt.ddns.net", true },
  { "drpetervoigt.de", true },
  { "drpico.com.au", true },
  { "drpure.top", true },
  { "drrodina.com", true },
  { "drrr.chat", true },
  { "drrr.wiki", true },
  { "drsajjadian.com", true },
  { "drsamuelkoo.com", true },
  { "drschlarb.eu", true },
  { "drschruefer.de", true },
  { "drsturgeonfreitas.com", true },
  { "drtimmarch.com", true },
  { "drtimothybradley.com", true },
  { "druckerei-huesgen.de", true },
  { "drugs.com", true },
  { "drumbe.at", true },
  { "drummondframing.com", true },
  { "drupal-expert.it", true },
  { "drupal.org", true },
  { "drupalspb.org", true },
  { "drusantia.net", true },
  { "drusillas.co.uk", true },
  { "druwe.net", false },
  { "druznek.me", true },
  { "drwang.group", true },
  { "drweissbrot.net", true },
  { "drwxr.org", true },
  { "dryan.com", false },
  { "drybjed.net", true },
  { "drycleancoalition.org", true },
  { "drycreekphoto.com", true },
  { "drydrydry.com", true },
  { "dryerventcleaningarlington.com", true },
  { "dryerventcleaningcarrollton.com", true },
  { "dryjersey.com", true },
  { "drywallresponse.gov", true },
  { "ds67.de", true },
  { "dsancomics.com", true },
  { "dsanraffleshangbai.xyz", true },
  { "dsayce.com", true },
  { "dsbrowser.com", true },
  { "dschwarzachtaler.de", true },
  { "dsdalismerkezi.com", true },
  { "dsebastien.net", true },
  { "dsektionen.se", false },
  { "dsgarms.com", true },
  { "dsgholsters.com", true },
  { "dsgnet.hu", true },
  { "dsgvo.name", true },
  { "dshield.org", true },
  { "dsm5.com", true },
  { "dsmjs.com", true },
  { "dso-imaging.co.uk", true },
  { "dso-izlake.si", true },
  { "dsol.hu", true },
  { "dssale.com", true },
  { "dstamou.de", true },
  { "dsteiner.at", true },
  { "dstvinstallalberton.co.za", true },
  { "dstvinstallfourways.co.za", true },
  { "dstvinstallrandburg.co.za", true },
  { "dt27.org", true },
  { "dtbouncycastles.co.uk", true },
  { "dtdsh.com", true },
  { "dte.co.uk", true },
  { "dtg-fonds.com", true },
  { "dtg-fonds.de", true },
  { "dtg-fonds.net", true },
  { "dtk-vom-chausseehaus.de", true },
  { "dtnx.eu", true },
  { "dtnx.net", true },
  { "dtnx.org", true },
  { "dtoweb.be", true },
  { "dtp-mstdn.jp", false },
  { "dtpak.cz", true },
  { "dtuaarsfest.dk", true },
  { "dtx.sk", true },
  { "dualascent.com", true },
  { "dub.cz", true },
  { "dubaieveningsafari.com", true },
  { "dubbingkursus.dk", true },
  { "dubious-website.com", true },
  { "dublin-traceroute.net", true },
  { "dubrovnik-dental.clinic", true },
  { "dubrovskiy.net", true },
  { "dubrovskiy.pro", true },
  { "dubtrack.fm", true },
  { "ducalendars.com", true },
  { "duch.cloud", true },
  { "ducius.net", true },
  { "duckbase.com", true },
  { "duckduck.horse", true },
  { "duckduckstart.com", true },
  { "duckeight.win", true },
  { "duckinc.net", true },
  { "duct.me", true },
  { "due-diligence-security.com", true },
  { "duerlund-falkenberg.dk", true },
  { "duernberg.at", true },
  { "duesee.org", true },
  { "duesterhus.eu", true },
  { "dufrei.com", true },
  { "dugnet.com", false },
  { "dugnet.io", false },
  { "dugnet.net", false },
  { "dugnet.org", false },
  { "dugunedavet.com", true },
  { "duh.se", true },
  { "dui805.com", true },
  { "duijf.info", true },
  { "duijfathome.nl", true },
  { "duitang.com", true },
  { "dukan-recepty.ru", true },
  { "dukatek.cz", true },
  { "dukegat.de", false },
  { "dukesatqueens.com", true },
  { "dukun.de", true },
  { "dulcinela.es", true },
  { "dulei.si", true },
  { "dullapp.com", true },
  { "dumax.xyz", true },
  { "dumbeartech.com", true },
  { "dumberger-bau.de", true },
  { "dumbfunded.co.uk", true },
  { "dumbomove.com.au", true },
  { "dumino.bg", true },
  { "dumont.ovh", true },
  { "dumpsters.com", true },
  { "duncancmt.com", true },
  { "duncanfamilytrust.org", true },
  { "duncanmoffat.com", true },
  { "duncanwinfrey.com", true },
  { "duncm.com", true },
  { "dundalkdonnie.com", true },
  { "dunesadventure.net", true },
  { "dungeon-bbs.de", true },
  { "dunkle-seite.org", true },
  { "dunloptrade.com", true },
  { "dunmanelectric.com", true },
  { "duobus.nl", true },
  { "duoluodeyu.com", true },
  { "duonganhtuan.com", true },
  { "duoquadragintien.fr", true },
  { "dupisces.com.tw", true },
  { "dupree.co", true },
  { "dupree.pe", true },
  { "durand.tf", true },
  { "duranthon.eu", true },
  { "durbanlocksmiths.co.za", true },
  { "durchblick-shop.de", true },
  { "durdle.com", true },
  { "dureuil.info", true },
  { "durexwinkel.nl", true },
  { "durfteparticiperen.nl", true },
  { "duria.de", true },
  { "duriaux-dentiste.ch", true },
  { "duroterm.ro", true },
  { "durys.be", true },
  { "dusmomente.com", true },
  { "dusnan.com", true },
  { "dustplanet.de", true },
  { "dustri.org", true },
  { "dustycloth.com", true },
  { "dustygroove.com", true },
  { "dustyspokesbnb.ca", true },
  { "dutch.desi", true },
  { "dutchdare.nl", true },
  { "dutchessuganda.com", true },
  { "dutchforkrunners.com", true },
  { "dutchrank.nl", true },
  { "dutchwanderers.nl", true },
  { "dutchweballiance.nl", true },
  { "duval.paris", true },
  { "dv189.com", true },
  { "dvbris.co.uk", true },
  { "dvbris.com", true },
  { "dvdinmotion.com", true },
  { "dvdland.com.au", true },
  { "dvhosting.be", true },
  { "dvipadmin.com", true },
  { "dvnatura.ch", true },
  { "dvorupotocnych.sk", true },
  { "dvwc.org", true },
  { "dvx.cloud", true },
  { "dw-loewe.de", true },
  { "dwbtoftshit.com", true },
  { "dwgf.xyz", true },
  { "dwi-sued.de", true },
  { "dwienzek.de", true },
  { "dworekhetmanski.pl", true },
  { "dworzak.ch", true },
  { "dwscdv3.com", true },
  { "dwtm.ch", true },
  { "dwworld.co.uk", true },
  { "dx-revision.com", true },
  { "dxgl.info", true },
  { "dxgl.org", true },
  { "dxm.no-ip.biz", true },
  { "dybuster.at", true },
  { "dybuster.ch", true },
  { "dybuster.com", true },
  { "dybuster.de", true },
  { "dybuster.es", true },
  { "dybuster.it", true },
  { "dybuster.se", true },
  { "dycoa.com", true },
  { "dyeager.org", true },
  { "dyktig.as", true },
  { "dyktig.no", true },
  { "dylanboudro.com", true },
  { "dylancl.cf", true },
  { "dylankatz.com", true },
  { "dylanknoll.ca", true },
  { "dylanspcrepairs.com", true },
  { "dylanwise.net", true },
  { "dylmye.me", true },
  { "dym.asia", true },
  { "dym.bz", true },
  { "dym2012.com", true },
  { "dym2013.com", true },
  { "dym2014.com", true },
  { "dym2017.com", true },
  { "dymersion.com", true },
  { "dymfbbs.com", true },
  { "dymmovie.com", true },
  { "dymowski.de", false },
  { "dyn-dnhensel.de", true },
  { "dyn-nserve.net", true },
  { "dyn.im", true },
  { "dynaloop.net", false },
  { "dynamicdesignuk.com", true },
  { "dynamicnet.net", false },
  { "dynamics-365.no", true },
  { "dynamics365.no", true },
  { "dynamicsnetwork.net", true },
  { "dynamicsretailnotes.com", true },
  { "dynamictostatic.com", true },
  { "dynamicyou.co.uk", true },
  { "dynamo.city", true },
  { "dynapptic.com", true },
  { "dynastic.co", true },
  { "dynastyarena.com", true },
  { "dynastybullpen.com", true },
  { "dynastycalculator.com", true },
  { "dynastycentral.com", true },
  { "dynastychalkboard.com", true },
  { "dynastyclubhouse.com", true },
  { "dynastycrate.com", true },
  { "dynastyduel.com", true },
  { "dynastyfan.com", true },
  { "dynastygoal.com", true },
  { "dynastylocker.com", true },
  { "dynastyredline.com", true },
  { "dynastyredzone.com", true },
  { "dynn.be", true },
  { "dynorphin.com", true },
  { "dynorphins.com", true },
  { "dynx.pl", true },
  { "dyrenesverden.no", true },
  { "dyrkar.com", true },
  { "dyrstad.net", true },
  { "dyscalculia-blog.com", true },
  { "dysthymia.com", true },
  { "dyyn.de", true },
  { "dzeina.ch", true },
  { "dzet.de", true },
  { "dziary.com", true },
  { "dziurdzia.pl", true },
  { "dzivniekubriviba.lv", true },
  { "dzndk.com", true },
  { "dznn.nl", true },
  { "dzomo.org", true },
  { "dzsi.bi", true },
  { "dzsibi.com", true },
  { "dzsula.hu", true },
  { "dzyabchenko.com", true },
  { "dzyszla.pl", true },
  { "e-apack.com.br", true },
  { "e-bikesdirect.co.uk", true },
  { "e-biografias.net", true },
  { "e-borneoshop.com", true },
  { "e-briancon.com", true },
  { "e-colle.info", true },
  { "e-cottage.com.br", true },
  { "e-enterprise.gov", false },
  { "e-gemeinde.at", true },
  { "e-hon.link", true },
  { "e-id.ee", true },
  { "e-imzo.uz", true },
  { "e-kontakti.fi", true },
  { "e-lambre.com", true },
  { "e-learningbs.com", true },
  { "e-lifetechnology.com", true },
  { "e-ptn.com", true },
  { "e-speak24.pl", true },
  { "e-standardstore.org", true },
  { "e-surveillant.nl", true },
  { "e-sw.co.jp", true },
  { "e-teacher.pl", true },
  { "e-teachers.me", true },
  { "e-tech-solution.com", true },
  { "e-tech-solution.net", true },
  { "e-techsolution.com", true },
  { "e-techsolutions.net", true },
  { "e-tonery.cz", true },
  { "e-traceur-france.fr", true },
  { "e-tresor.at", true },
  { "e-tune-mt.net", true },
  { "e-typ.eu", true },
  { "e-verify.gov", false },
  { "e-worksmedia.com", true },
  { "e.mail.ru", true },
  { "e11even.nl", false },
  { "e15r.co", true },
  { "e2feed.com", true },
  { "e30.ee", true },
  { "e4metech.com", true },
  { "e5tv.hu", true },
  { "e64.com", true },
  { "e6e.io", true },
  { "e6ex.com", true },
  { "e7d.io", true },
  { "e7fun.net", true },
  { "e965.ru", true },
  { "e9a.at", true },
  { "ea2drocks.com", true },
  { "eacero.com", true },
  { "ead-italia.it", true },
  { "eagle.net", true },
  { "eagleindustriesltd.com", true },
  { "eaglemessaging.com", true },
  { "eaglesecurity.com", true },
  { "eagletechz.com.br", true },
  { "eaglewreck.info", true },
  { "eaglexiang.org", true },
  { "eagleyecs.com", true },
  { "eaimty.com", true },
  { "ealev.de", true },
  { "eapestudioweb.com", true },
  { "earl.org.uk", true },
  { "earlydocs.com", true },
  { "earlyyearshub.com", true },
  { "earmarks.gov", true },
  { "earn.com", true },
  { "earthsystemprediction.gov", true },
  { "earticleblog.com", true },
  { "earvinkayonga.com", false },
  { "easelforart.com", true },
  { "easez.net", true },
  { "eashwar.com", true },
  { "eastarm.net", true },
  { "eastblue.org", true },
  { "easterncapebirding.co.za", true },
  { "eastlothianbouncycastles.co.uk", true },
  { "eastmanbusinessinstitute.com", true },
  { "eastnorschool.co.uk", true },
  { "eastplan.co.kr", true },
  { "eastsidecottages.co.uk", true },
  { "eastsideroofingcontractor.com", true },
  { "easy-rpg.org", false },
  { "easy2bathe.co.uk", true },
  { "easyadsnbanners.tk", false },
  { "easycoding.org", true },
  { "easyconstat.com", true },
  { "easycosmetic.ch", true },
  { "easycup.com", false },
  { "easydumpsterrental.com", false },
  { "easyeigo.com", true },
  { "easyfiles.ch", true },
  { "easyhaul.com", true },
  { "easymun.com", true },
  { "easyocm.hu", true },
  { "easyoutdoor.nl", true },
  { "easypay.bg", true },
  { "easyproperty.com", true },
  { "easypv.ch", true },
  { "easyqr.codes", true },
  { "easyroad.fr", true },
  { "easyslide.be", true },
  { "easyssl.com.cn", true },
  { "easystore.co", true },
  { "easytechguides.com", true },
  { "easytechsecurity.com", true },
  { "easyweenies.com", true },
  { "eat-sleep-code.com", true },
  { "eatery.co.il", true },
  { "eatmebudapest.hu", true },
  { "eaton-works.com", true },
  { "eatry.io", true },
  { "eats.soy", true },
  { "eatsleeprepeat.net", true },
  { "eatson.com", true },
  { "eatz-and-treatz.com", true },
  { "eatz.com", true },
  { "eaucube.com", true },
  { "eauxdespleiades.ch", true },
  { "eb-net.de", true },
  { "eb7.jp", true },
  { "ebanking.indovinabank.com.vn", true },
  { "ebankingabersicher.ch", true },
  { "ebankingbutsecure.ch", true },
  { "ebankingentoutesecurite.ch", true },
  { "ebankingmasicuro.ch", true },
  { "ebas.ch", true },
  { "ebataw.com", true },
  { "ebayinc.com", true },
  { "ebaymotorssucks.com", true },
  { "ebene-bpo.com", true },
  { "ebenezersbarnandgrill.com", true },
  { "ebenvloedaanleggen.nl", true },
  { "ebermannstadt.de", false },
  { "eberwe.in", true },
  { "ebest.co.jp", true },
  { "ebiebievidence.com", true },
  { "ebiografia.com", true },
  { "ebisi.be", true },
  { "ebizarts.com", true },
  { "eboek.info", true },
  { "ebonyriddle.com", true },
  { "ebooki.eu.org", true },
  { "ebooklaunchers.com", true },
  { "eboutic.ch", true },
  { "eboyer.com", true },
  { "ebpglobal.com", false },
  { "ebrnd.de", true },
  { "ec-current.com", true },
  { "ec.mine.nu", true },
  { "eca.edu.au", true },
  { "ecacollege.nsw.edu.au", true },
  { "ecardoo.com", true },
  { "ecardoo.de", true },
  { "ecardoo.net", true },
  { "ecardoo.org", true },
  { "ecchidreams.com", true },
  { "ecclesia-koeln.de", true },
  { "ecco-verde.com", false },
  { "ecdn.cz", true },
  { "ecfnorte.com.br", true },
  { "echatta.net", true },
  { "echatta.org", true },
  { "echi.pw", true },
  { "echidna-rocktools.eu", true },
  { "echo-security.co", true },
  { "echo.cc", true },
  { "echoanalytics.com", true },
  { "echobridgepartners.com", true },
  { "echodio.com", true },
  { "echofoxtrot.co", true },
  { "echoit.net", true },
  { "echoit.net.au", true },
  { "echoit.services", true },
  { "echopaper.com", true },
  { "echosim.io", true },
  { "echosixmonkey.com", true },
  { "echosystem.fr", true },
  { "echoteam.gq", true },
  { "echoteen.com", true },
  { "echoworld.ch", true },
  { "echternach-immobilien.de", true },
  { "echtes-hutzelbrot.de", true },
  { "echtgeld-casinos.de", true },
  { "ecir.pro", true },
  { "ecir.ru", true },
  { "ecirtam.net", true },
  { "eckel.co", true },
  { "eclanet.ca", true },
  { "eclipse.ws", true },
  { "ecliptic.cc", true },
  { "ecnetworker.com", true },
  { "eco-derattizzazione.it", true },
  { "eco-work.it", true },
  { "eco2u.ru", true },
  { "ecobee.com", false },
  { "ecobergerie.fr", true },
  { "ecobin.nl", true },
  { "ecoccinelles.ch", true },
  { "ecoccinelles.com", true },
  { "ecococon.fr", true },
  { "ecocreativity.org", true },
  { "ecodedi.com", true },
  { "ecodesigns.nl", true },
  { "ecodigital.social", true },
  { "ecofabrica.com.br", true },
  { "ecofac-bs.com", true },
  { "ecogen.com.au", true },
  { "ecogen.net.au", true },
  { "ecoheatcool.co.uk", true },
  { "ecohostingservices.uk", true },
  { "ecolala.my", true },
  { "ecole-attalens.ch", true },
  { "ecoledusabbat.org", true },
  { "ecolemathurincordier.com", true },
  { "ecombustibil.ro", true },
  { "ecomycie.com", true },
  { "economiafinanzas.com", true },
  { "economias.pt", true },
  { "economic-sanctions.com", true },
  { "economicinclusion.gov", true },
  { "economics-colleges.com", true },
  { "economiefidu.ch", true },
  { "economies.ch", true },
  { "econsumer.gov", true },
  { "econverter.cloud", true },
  { "ecorp.cc", true },
  { "ecos-ev.de", true },
  { "ecos.srl", true },
  { "ecoshare.info", true },
  { "ecoskif.ru", true },
  { "ecosm.com.au", true },
  { "ecosound.ch", true },
  { "ecostruxureit.com", true },
  { "ecosystem.atlassian.net", true },
  { "ecosystemmanager-uat1.azurewebsites.net", true },
  { "ecosystemmanager.azurewebsites.net", true },
  { "ecoterramedia.com", true },
  { "ecotur.org", true },
  { "ecovision.com.br", true },
  { "ecpannualmeeting.com", true },
  { "ecrandouble.ch", true },
  { "ecuinformacion.com", true },
  { "ecupcafe.com", false },
  { "ecuteam.com", true },
  { "ecxforum.com", true },
  { "ed.gs", true },
  { "ed4becky.net", true },
  { "edakoe.ru", true },
  { "edanni.io", true },
  { "edd-miles.com", true },
  { "eddesign.ch", true },
  { "eddmil.es", true },
  { "eddokloosterman.com", true },
  { "eddyn.net", true },
  { "edeca.net", true },
  { "edehsa.com", true },
  { "edeka-jbl-treueaktion.de", true },
  { "eden-eu.com", true },
  { "eden.co.uk", true },
  { "edenming.info", true },
  { "edesseglabor.hu", true },
  { "edfinancial.com", true },
  { "edge-cloud.net", false },
  { "edgedynasty.com", true },
  { "edgefantasy.com", true },
  { "edgeservices.co.uk", true },
  { "edgetalk.net", true },
  { "edgevelder.com", true },
  { "edhesive.com", true },
  { "edholm.pub", true },
  { "edi-gate.com", true },
  { "edi-gate.de", true },
  { "edibarcode.com", true },
  { "edicct.com", true },
  { "edilane.com", true },
  { "edilane.de", true },
  { "edilservizi.it", true },
  { "edilservizivco.it", true },
  { "edinburghsportsandoutdoorlearning.com", true },
  { "edincmovie.com", true },
  { "ediscomp.sk", true },
  { "edisonlee55.com", true },
  { "edisonluiz.com", true },
  { "edisonnissanparts.com", true },
  { "edit.co.uk", true },
  { "edit.yahoo.com", false },
  { "edited.de", true },
  { "edition-bambou.com", true },
  { "edition-sonblom.de", true },
  { "edlinger.at", true },
  { "edlinger.mobi", true },
  { "edlinus.cn", true },
  { "edmodo.com", true },
  { "edmoncu.com", true },
  { "edmundcelis.com", true },
  { "edoss.co.za", true },
  { "edp-collaborative.com", true },
  { "edplan.io", true },
  { "edragneainpuscarie.ro", true },
  { "edsby.com", true },
  { "edservicing.com", true },
  { "edsm.net", true },
  { "edstep.com", true },
  { "edtech-hub.com", true },
  { "edtechwebb.com", true },
  { "edu-kingdom.com", true },
  { "edu6.cloud", true },
  { "eduard-dopler.de", true },
  { "edubras.com.br", true },
  { "educatek.es", true },
  { "educationevolving.org", true },
  { "educationfutures.com", true },
  { "educationmalaysia.co.uk", true },
  { "educationunlimited.com", true },
  { "educator-one.com", true },
  { "eductf.org", true },
  { "eduid.se", false },
  { "edumundo.nl", true },
  { "edupool.in", true },
  { "eduroam.no", true },
  { "eduroam.uy", true },
  { "edusanjal.com", true },
  { "edusantorini.com", true },
  { "eduvpn.no", true },
  { "eduxpert.in", true },
  { "edv-bv.de", true },
  { "edv-kohls.de", true },
  { "edv-lehrgang.de", true },
  { "edv-schmittner.de", true },
  { "edvgarbe.de", true },
  { "edvmesstec.de", true },
  { "edwar.do", true },
  { "edwarddekker.nl", true },
  { "edwards.me.uk", true },
  { "edwardsnowden.com", true },
  { "edwardspeyer.com", true },
  { "edwardwall.me", true },
  { "edwellbrook.com", true },
  { "edwinmattiacci.com", true },
  { "edwinyrkuniversity.de", true },
  { "edxg.de", false },
  { "edxn.de", true },
  { "edyou.eu", true },
  { "edzilla.info", true },
  { "eelcapone.nl", true },
  { "eellak.gr", true },
  { "eelsden.net", true },
  { "eelzak.nl", true },
  { "eemcevn.com", true },
  { "eentweevijf.be", true },
  { "eer.io", true },
  { "eerlijktransport.nl", true },
  { "eerstejaarsweekend.nl", true },
  { "eery.de", true },
  { "eesti.xyz", true },
  { "eewna.org", true },
  { "ef-georgia.org", true },
  { "ef.gy", true },
  { "efa-football.com", true },
  { "efaas.nl", true },
  { "efag.com", true },
  { "efcross.com", true },
  { "efeen.nl", true },
  { "eff-bee-eye.de", true },
  { "eff.org", true },
  { "effdocs.com", true },
  { "effe.ch", true },
  { "effective-altruist.com", true },
  { "effectivecoffee.com", true },
  { "effero.net", true },
  { "effex.ru", true },
  { "effinfun.com", true },
  { "effizienta.ch", true },
  { "efflam.net", true },
  { "effortlesshr.com", true },
  { "efg-darmstadt.de", false },
  { "efinity.io", true },
  { "efipsactiva.com", true },
  { "eflorashop.be", true },
  { "eflorashop.ch", true },
  { "eflorashop.co.uk", true },
  { "eflorashop.com", true },
  { "eflorashop.de", true },
  { "eflorashop.es", true },
  { "eflorashop.fr", true },
  { "eflorashop.it", true },
  { "eflorashop.mx", true },
  { "eflorashop.net", true },
  { "eflorashop.us", true },
  { "efmcredentialing.org", true },
  { "eft.boutique", true },
  { "eftelingcraft.net", true },
  { "egablo.black", true },
  { "egamespw.com", true },
  { "egami.ch", true },
  { "eganassociates.com.au", true },
  { "egarden.it", true },
  { "egb.at", false },
  { "egbert.net", true },
  { "egeozcan.com", true },
  { "egg-ortho.ch", true },
  { "eggblast.com", true },
  { "eggert.org", false },
  { "eggplant.today", true },
  { "egiftcards.be", true },
  { "egles.eu", true },
  { "ego4u.com", true },
  { "ego4u.de", true },
  { "egoroof.ru", true },
  { "egov4.ch", true },
  { "egovernment-podcast.com", true },
  { "egres.xyz", true },
  { "egrojsoft.info", true },
  { "egrp365.ru", true },
  { "egumenita.ro", true },
  { "egw-ceramica.de", true },
  { "egweb.tv", true },
  { "ehaccp.it", true },
  { "ehandel.com", true },
  { "ehazi.hu", true },
  { "ehbssl.com", true },
  { "eheliche-disziplin.schule", true },
  { "ehertz.uk", true },
  { "ehipaa.com", true },
  { "ehlacademy.org", true },
  { "ehmsen.nu", true },
  { "ehmtheblueline.com", true },
  { "ehne.de", true },
  { "ehomusicgear.com", true },
  { "ehrenburg.info", true },
  { "ehsellert.com", true },
  { "ehub.cz", true },
  { "ehub.hu", true },
  { "ehub.pl", true },
  { "ehub.sk", true },
  { "eichel.eu", true },
  { "eichler.work", true },
  { "eichornenterprises.com", true },
  { "eickemeyer.nl", true },
  { "eickhof.co", true },
  { "eickhof.us", true },
  { "eickhofcolumbaria.com", true },
  { "eidolons.org", true },
  { "eifel.website", true },
  { "eifelindex.de", true },
  { "eigenpul.se", true },
  { "eigenpulse.com", true },
  { "eighty-aid.com", true },
  { "eigpropertyauctions.co.uk", true },
  { "eihaikyo.com", true },
  { "eika.as", true },
  { "eilandprojectkeukens.nl", true },
  { "eilhan.com", true },
  { "eimacs.com", true },
  { "einaros.is", true },
  { "einfachbahn.de", true },
  { "einheft.info", true },
  { "einheizpreis.de", true },
  { "einrichtwerk.de", true },
  { "einrichtwerk.shop", true },
  { "einsatzstellenverwaltung.de", true },
  { "einser.com", true },
  { "einsteinathome.org", true },
  { "einsteincapital.ca", true },
  { "eintageinzug.de", true },
  { "eintragsservice24.de", true },
  { "eioperator.com", true },
  { "eipione.com", true },
  { "eirastudios.co.uk", false },
  { "eirb.fr", true },
  { "eisaev.ru", true },
  { "eiskratzer-bedrucken.de", true },
  { "eit-web.de", false },
  { "eitler.cx", true },
  { "eiyoushi-shigoto.com", true },
  { "ejdv-anmeldung.de", true },
  { "ejeff.org", true },
  { "ejkmedia.nl", true },
  { "ejkmuseum.nl", true },
  { "ejknet.nl", true },
  { "ejkwebdesign.nl", true },
  { "ek-networks.de", true },
  { "ekaigotenshoku.com", true },
  { "ekati.ru", true },
  { "ekb-avia.ru", true },
  { "ekd.de", true },
  { "ekedc.com", true },
  { "ekedp.com", true },
  { "eklepka.com", true },
  { "eklitzke.org", true },
  { "ekodevices.com", true },
  { "ekokontakt.cz", true },
  { "ekonbenefits.com", true },
  { "ekostecki.de", true },
  { "ekostrateg.com", true },
  { "ekpyroticfrood.net", true },
  { "ekrana.info", true },
  { "eksisozluk.com", true },
  { "ekuatorial.com", true },
  { "ekyu.moe", true },
  { "ekz-crosstour.ch", true },
  { "ekzarta.ru", true },
  { "ekzcrosstour.ch", true },
  { "el-cell.com", true },
  { "el-hossari.com", true },
  { "el-news.de", true },
  { "eladgames.com", true },
  { "elagplus.com", true },
  { "elainerock.com", true },
  { "elaon.de", true },
  { "elars.de", true },
  { "elarvee.xyz", true },
  { "elb500ttl.nl", true },
  { "elbetech.net", true },
  { "elcambiador.es", true },
  { "elcontadorsac.com", true },
  { "eldapoint.co.uk", true },
  { "eldenelesat.com", true },
  { "eldercare.gov", true },
  { "elderjustice.gov", true },
  { "elderoost.com", true },
  { "eldertons.co.uk", true },
  { "eldinhadzic.com", true },
  { "eldisagjapi.com", true },
  { "eldrid.ge", true },
  { "eldritchfiction.net", true },
  { "eleaut.com.br", true },
  { "electionsbycounty.com", true },
  { "electionsdatabase.com", true },
  { "electmikewaters.com", true },
  { "electr0sheep.com", true },
  { "electragirl.com", true },
  { "electric-vault.co.uk", true },
  { "electricagoura.com", true },
  { "electricagourahills.com", true },
  { "electrical-schools.com", true },
  { "electricalagoura.com", true },
  { "electricalagourahills.com", true },
  { "electricalcalabasas.com", true },
  { "electricalcamarillo.com", true },
  { "electricalconejovalley.com", true },
  { "electricaldosvientos.com", true },
  { "electricalfencingbedfordview.co.za", true },
  { "electricalfencingedenvale.co.za", true },
  { "electricalhiddenhills.com", true },
  { "electricallakesherwood.com", true },
  { "electricalmalibu.com", true },
  { "electricalmoorpark.com", true },
  { "electricalnewburypark.com", true },
  { "electricaloakpark.com", true },
  { "electricalpacificpalisades.com", true },
  { "electricalsimivalley.com", true },
  { "electricalthousandoaks.com", true },
  { "electricalwestlakevillage.com", true },
  { "electriccalabasas.com", true },
  { "electriccamarillo.com", true },
  { "electricconejovalley.com", true },
  { "electricdosvientos.com", true },
  { "electricfencealberton.co.za", true },
  { "electricfencebenoni.co.za", true },
  { "electricfencingballito.co.za", true },
  { "electricgatemotorgermiston.co.za", true },
  { "electricgatemotorrandburg.co.za", true },
  { "electricgatemotorskemptonpark.co.za", true },
  { "electricgatemotorsroodepoort.co.za", true },
  { "electrichiddenhills.com", true },
  { "electricianagoura.com", true },
  { "electricianagourahills.com", true },
  { "electriciancalabasas.com", true },
  { "electriciancamarillo.com", true },
  { "electricianconejovalley.com", true },
  { "electriciandosvientos.com", true },
  { "electricianhiddenhills.com", true },
  { "electriciankemptonpark24-7.co.za", true },
  { "electricianlakesherwood.com", true },
  { "electricianmalibu.com", true },
  { "electricianmoorpark.com", true },
  { "electriciannewburypark.com", true },
  { "electricianoakpark.com", true },
  { "electricianpacificpalisades.com", true },
  { "electriciansimivalley.com", true },
  { "electricianthousandoaks.com", true },
  { "electricianwestlakevillage.com", true },
  { "electricienasnieres.fr", true },
  { "electricimagination.co.uk", true },
  { "electriclakesherwood.com", true },
  { "electricmalibu.com", true },
  { "electricmoorpark.com", true },
  { "electricnewburypark.com", true },
  { "electricoakpark.com", true },
  { "electricsimivalley.com", true },
  { "electricthousandoaks.com", true },
  { "electricwestlakevillage.com", true },
  { "electro-pak.com.pk", true },
  { "electroinkoophardenberg.nl", true },
  { "electronic-ignition-system.com", true },
  { "electronicafacil.net", true },
  { "electronicfasteners.com", true },
  { "electrostatics.com", true },
  { "electrotainment.com", true },
  { "elefandt.com", true },
  { "elefantevoador.com", true },
  { "eleicoes2014.com.br", true },
  { "eleicoes2016.com.br", true },
  { "eleicoes2018.com", true },
  { "elekharris.com", true },
  { "elektro-adam.de", true },
  { "elektro-collee.de", true },
  { "elektro-diehm.de", true },
  { "elektro-doerr.com", true },
  { "elektro-hammes.net", true },
  { "elektro-hofmann-gmbh.de", true },
  { "elektro-hornetz.de", true },
  { "elektro-kahlen.de", true },
  { "elektro-koehl.de", true },
  { "elektro-liebeskind.de", true },
  { "elektro-metz.de", true },
  { "elektro-pfeiffer.de", true },
  { "elektro-praha10.cz", true },
  { "elektro-rossbach.de", true },
  { "elektro-roth.de", true },
  { "elektro-stock.de", true },
  { "elektro-woerdehoff.de", true },
  { "elektrobusch.com", true },
  { "elektrofinke.de", true },
  { "elektrokarges.de", true },
  { "elektrometz.de", true },
  { "elektronickakancelar.cz", true },
  { "elektronische-post.org", true },
  { "elektropartner.nu", true },
  { "elektropost.org", true },
  { "elektrotechnik-heisel.de", true },
  { "elektrotechnik-kaetzel.de", true },
  { "elemental.software", true },
  { "elementalsoftware.net", true },
  { "elementalsoftware.org", true },
  { "elementarty.com", true },
  { "elementarywave.com", true },
  { "elements.guide", true },
  { "elementshop.co.uk", true },
  { "elena-baykova.ru", false },
  { "elenatranslations.nl", true },
  { "elephants.net", true },
  { "elephpant.cz", true },
  { "elepover.com", true },
  { "elerizoentintado.es", true },
  { "eletesstilus.hu", true },
  { "eletor.com", true },
  { "eletor.pl", true },
  { "elettricista-roma.it", true },
  { "elettricista-roma.org", true },
  { "eleusis-zur-verschwiegenheit.de", true },
  { "elevator.ee", true },
  { "elevatoraptitudetest.com", true },
  { "elexel.ru", true },
  { "elexprimidor.com", true },
  { "elexwong.com", true },
  { "elfe.de", true },
  { "elfnon.com", true },
  { "elfring.eu", true },
  { "elfussports.com", true },
  { "elgalponazo.com.ar", true },
  { "elglobo.com.mx", false },
  { "elgosblanc.com", false },
  { "elguadia.faith", true },
  { "elhamadimi.com", true },
  { "elhorizontal.com", true },
  { "elhossari.com", true },
  { "elia.cloud", true },
  { "elian-art.de", true },
  { "elias-nicolas.com", true },
  { "eliaskordelakos.com", true },
  { "elibom.com", true },
  { "elie.net", true },
  { "elielaloum.com", true },
  { "elifesciences.org", true },
  { "eligibilis.com", true },
  { "eligible.com", true },
  { "eligibleapi.com", true },
  { "eligrey.com", true },
  { "elijahgrey.com", true },
  { "eliminercellulite.com", true },
  { "elinevanhaaften.nl", true },
  { "elinvention.ovh", true },
  { "eliolita.com", true },
  { "elisa.ee", false },
  { "elisabeth-kostecki.de", true },
  { "elisabeth-strunz.de", true },
  { "elisabethkostecki.de", true },
  { "elisabethrene.com", true },
  { "elisechristie.com", true },
  { "elite12.de", true },
  { "elitebouncingfun.com", true },
  { "elitegameservers.net", true },
  { "elitehosting.de", false },
  { "elitenutritionoficial.com", true },
  { "elixi.re", true },
  { "elixir.bzh", true },
  { "eliyah.co.il", true },
  { "elizabethbuitrago.com", true },
  { "elizabethgreenfield.com", true },
  { "elizabethrominski.com", true },
  { "eljef.me", true },
  { "elkoy.org", true },
  { "ell-net.tokyo", true },
  { "ella-kwikmed.com", false },
  { "ellak.gr", true },
  { "ellegaard.dk", true },
  { "ellemental.me", true },
  { "ellencorddry.com", true },
  { "ellevit.ch", true },
  { "elliesbouncers.co.uk", true },
  { "elliot.cat", true },
  { "elliriehl.at", true },
  { "ellisamusements.co.uk", true },
  { "ellisleisure.co.uk", true },
  { "ellsinger.me", true },
  { "elmermx.ch", true },
  { "elnan.do", true },
  { "elnoorandelmohanad.com", true },
  { "elo-forum.org", true },
  { "elodieclerc.ch", true },
  { "elohellp.com", false },
  { "elonaspitze.de", true },
  { "elosrah.com", true },
  { "elosuite.com", true },
  { "elpado.de", true },
  { "elpo.net", true },
  { "elpoderdelespiritu.org", true },
  { "elradix.be", true },
  { "elrinconderovica.com", true },
  { "elsagradocoran.org", true },
  { "elshou.com", true },
  { "elstopstelten.nl", true },
  { "elsvanderlugt.nl", true },
  { "eltagroup.co.uk", true },
  { "eltair.com", true },
  { "eltern-verein.ch", true },
  { "elternbeiratswahl.online", true },
  { "elternforum-birmensdorf.ch", true },
  { "elternverein-utzenstorf.ch", true },
  { "eltip.click", true },
  { "eltlaw.com", true },
  { "elucron.com", true },
  { "eluhome.de", true },
  { "eluvio.com", true },
  { "elvcino.com", false },
  { "elvidence.com.au", true },
  { "elviraszabo.com", true },
  { "elvispresley.net", true },
  { "elvisripley.com", true },
  { "elvn.tokyo", true },
  { "elwave.org", true },
  { "elwix.com", true },
  { "elxsi.de", true },
  { "elyasweb.com", true },
  { "elysiria.fr", true },
  { "elysiumware.com", true },
  { "em-biotek.cz", true },
  { "emaging-productions.fr", true },
  { "emaging.fr", true },
  { "emailalaperformance.fr", true },
  { "emailconfiguration.com", true },
  { "emailfuermich.de", true },
  { "emailhunter.co", true },
  { "emailing.alsace", true },
  { "emailprivacytester.com", true },
  { "emailtools.io", true },
  { "emaily.eu", true },
  { "emanuel.photography", true },
  { "emanuela-gabriela.co.uk", true },
  { "emanuelduss.ch", true },
  { "emanueleanastasio.com", true },
  { "emanuelemazzotta.com", true },
  { "emarketingmatters.com", true },
  { "embassycargo.eu", true },
  { "emberlife.com", true },
  { "embox.net", true },
  { "embraceni.org", true },
  { "embroideryexpress.co.uk", true },
  { "emby.cloud", true },
  { "emcspotlight.com", true },
  { "emdrupholm.dk", true },
  { "emecew.com", true },
  { "emeliefalk.se", true },
  { "ememsei.com", true },
  { "emeraldcbdshop.com", false },
  { "emeraldcityswagger.com", true },
  { "emeraldcoastrideshare.com", true },
  { "emeraldonion.org", true },
  { "emergenzalavoro.com", true },
  { "emero.de", true },
  { "emex.ro", true },
  { "emi-air-comprime.com", true },
  { "emi.im", true },
  { "emielraaijmakers.nl", true },
  { "emil-dein-baecker.com", true },
  { "emil-dein-baecker.de", true },
  { "emil-reimann.com", true },
  { "emil.click", true },
  { "emilecourriel.com", true },
  { "emiliendevos.be", true },
  { "emilong.com", true },
  { "emilreimann.de", true },
  { "emils-1910.de", true },
  { "emils-chemnitz.de", true },
  { "emils1910.de", true },
  { "emilstahl.dk", true },
  { "emilvarga.com", true },
  { "emily.moe", true },
  { "emilyjohnson.ga", true },
  { "emirabiz.com", false },
  { "emirichardson.com", true },
  { "emisia.com", true },
  { "emivauthey.com", true },
  { "emkanrecords.com", true },
  { "emkei.cz", true },
  { "emkrivoy.com", true },
  { "emma.ca", true },
  { "emmababy420.com", true },
  { "emmagraystore.com", true },
  { "emobilityforum.org", true },
  { "emoji.bzh", false },
  { "emolafarm.com", true },
  { "emond-usedcars.net", true },
  { "empathogen.com", true },
  { "empathogens.com", true },
  { "empathy.ca", true },
  { "emperola.com", true },
  { "emperor-penguin.com", true },
  { "emperor-penguins.com", true },
  { "empese.com", true },
  { "empherino.net", true },
  { "emploi-collectivites.fr", true },
  { "employeeexpress.gov", true },
  { "employer.gov", true },
  { "employer.guru", true },
  { "employer411.com", true },
  { "emporiodascalcinhas.com.br", true },
  { "emporiodosperfumes.com.br", true },
  { "emporioonline.com.br", true },
  { "emporiopatanegra.com.br", true },
  { "emporioviverbem.com.br", false },
  { "empower.net", true },
  { "empowerdb.com", true },
  { "emprego.pt", true },
  { "emprunterlivre.ci", true },
  { "empyrean-advisors.com", true },
  { "emresaglam.com", true },
  { "emtradingacademy.com", true },
  { "emultiagent.pl", true },
  { "emvoice.net", true },
  { "emvoiceapp.com", true },
  { "emw3.com", true },
  { "emyr.net", true },
  { "en-booster.jp", true },
  { "en-crypt.me", true },
  { "en-maktoob.search.yahoo.com", false },
  { "en4rab.co.uk", true },
  { "enaim.de", true },
  { "enalean.com", true },
  { "enamae.net", true },
  { "enbecom.net", true },
  { "encfs.win", true },
  { "encircleapp.com", true },
  { "encnet.de", true },
  { "encode.host", true },
  { "encouragemarketing.com", true },
  { "encredible.de", false },
  { "encredible.org", false },
  { "encretplomb.ch", true },
  { "encrypt.org.uk", true },
  { "encryptallthethings.net", true },
  { "encrypted.google.com", true },
  { "encryptmy.site", true },
  { "encryptmycard.com", true },
  { "encryptmysite.net", true },
  { "encuentraprecios.es", true },
  { "encycarpedia.com", true },
  { "endeal.nl", true },
  { "ender.co.at", true },
  { "enderbycamping.com", true },
  { "enderszone.com", true },
  { "endingthedocumentgame.gov", true },
  { "endlessvideo.com", true },
  { "endoftenancycleaninglondon.co.uk", true },
  { "endoftennancycleaning.co.uk", true },
  { "endpointsystems.com", true },
  { "enduranceday.be", true },
  { "endzeit-architekten.com", false },
  { "enemiesoflight.de", true },
  { "energie-sante.ch", true },
  { "energiekeurplus.nl", true },
  { "energy-drink-magazin.de", true },
  { "energy-in-balance.eu", true },
  { "energy-infra.nl", true },
  { "energy-initiative.com", true },
  { "energyatlas.com", true },
  { "energyaupair.se", true },
  { "energycodes.gov", true },
  { "energydrinkblog.de", true },
  { "energyefficientservices.com", true },
  { "energyelephant.com", true },
  { "energyled.com.br", true },
  { "energystar.gov", true },
  { "enet-navigator.de", true },
  { "enfantsdelarue.ch", true },
  { "enfield-kitchens.co.uk", true },
  { "enflow.nl", true },
  { "enfu.se", true },
  { "engarde.net", true },
  { "engaugetools.com", true },
  { "engelke-optik.de", true },
  { "engelundlicht.ch", true },
  { "engelwerbung.com", true },
  { "engg.ca", true },
  { "engie-laadpalen.nl", true },
  { "engiedev.net", true },
  { "enginepit.com", true },
  { "enginsight.com", true },
  { "englishbulgaria.net", true },
  { "englishcast.com.br", true },
  { "englishforums.com", true },
  { "englishlol.com", true },
  { "englishphonopass.com", true },
  { "englishstudio.com", true },
  { "engvid.com", true },
  { "enigma.swiss", true },
  { "enijew.com", true },
  { "enitso.de", true },
  { "enjin.io", true },
  { "enjincoin.io", true },
  { "enjinwallet.io", true },
  { "enjinx.io", true },
  { "enjoy-drive.com", true },
  { "enjoy-israel.ru", true },
  { "enjoyphoneblog.it", true },
  { "enlight.no", true },
  { "enlighten10x.ga", true },
  { "enlightenedhr.com", true },
  { "enlightenment.org", true },
  { "enlnf.link", true },
  { "enloestatebank.com", true },
  { "ennea-mediation.fr", true },
  { "enness.co.uk", true },
  { "ennori.jp", true },
  { "enomada.net", true },
  { "enord.fr", true },
  { "enorekcah.com", true },
  { "enot32.ru", true },
  { "enotecastore.it", true },
  { "enpasenerji.com.tr", true },
  { "enquos.com", true },
  { "enrich.email", true },
  { "enriquepiraces.com", true },
  { "enrollapp.com", true },
  { "ensage.io", true },
  { "enscosupply.com", true },
  { "ensemble-rubato.de", true },
  { "ensembling.com", true },
  { "ensley.tech", true },
  { "ensons.de", true },
  { "ensured.com", true },
  { "ensured.nl", true },
  { "ensurtec.com", true },
  { "ent-london.com", true },
  { "entabe.jp", true },
  { "entactogen.com", true },
  { "entactogens.com", true },
  { "entercenter.ru", true },
  { "enterprisey.enterprises", true },
  { "entersoftsecurity.com", true },
  { "entersynapse.com", false },
  { "entheogens.com", true },
  { "enthusiaformazione.com", true },
  { "entradaweb.cl", true },
  { "entrainr.com", true },
  { "entrecieletpierres.com", true },
  { "entreprise-toiture-clement.fr", true },
  { "entropia.de", false },
  { "entrusted.io", true },
  { "entryboss.cc", true },
  { "entrypoint.sh", true },
  { "enuchi.jp", true },
  { "envant.co.uk", true },
  { "enveloppenopmaat.nl", true },
  { "envescent.com", true },
  { "enviatufoto.com", true },
  { "enviaya.com.mx", true },
  { "environmental-colleges.com", true },
  { "environmentkirklees.org", true },
  { "enviroprobasements.com", true },
  { "envirotech.com.au", true },
  { "envoie.moi", true },
  { "envoyez.moi", true },
  { "eocservices.co.uk", true },
  { "eoitek.com", true },
  { "eonhive.com", true },
  { "eoonglobalresources.jp", true },
  { "eopugetsound.org", false },
  { "eosol.de", true },
  { "eosol.net", true },
  { "epa.com.es", true },
  { "epassafe.com", true },
  { "epay.bg", true },
  { "epdeveloperchallenge.com", true },
  { "ephesusbreeze.com", true },
  { "epi-lichtblick.de", true },
  { "epi.one", true },
  { "epic-vistas.com", true },
  { "epic-vistas.de", true },
  { "epicbouncycastlehirenorwich.co.uk", true },
  { "epicbouncycastles.co.uk", true },
  { "epicdowney.com", true },
  { "epicenter.work", true },
  { "epicenter.works", true },
  { "epicentre.works", true },
  { "epichouse.net", false },
  { "epicinflatables.co.uk", true },
  { "epickitty.co.uk", true },
  { "epicpages.com", true },
  { "epicsecure.de", true },
  { "epicvistas.com", true },
  { "epicvistas.de", true },
  { "epicwalnutcreek.com", true },
  { "epidauros.be", true },
  { "epigrafes-led-farmakeia.gr", true },
  { "epilis.gr", true },
  { "epiphanyofourlordchurch.com", true },
  { "epiphyte.network", true },
  { "episkevh-plaketas.gr", true },
  { "epistas.com", true },
  { "epistas.de", true },
  { "epitesz.co", true },
  { "epiteugma.com", true },
  { "epizentrum.work", true },
  { "epizentrum.works", true },
  { "epmcentroitalia.it", true },
  { "epo32.ru", true },
  { "epoch.com", true },
  { "epolitiker.com", true },
  { "epos-distributor.co.uk", true },
  { "epos.az", true },
  { "eposbirmingham.co.uk", true },
  { "eposbrighton.co.uk", true },
  { "eposbristol.co.uk", true },
  { "eposcardiff.co.uk", true },
  { "eposig.net", true },
  { "eposkent.co.uk", true },
  { "eposleeds.co.uk", true },
  { "eposleicester.co.uk", true },
  { "eposliverpool.co.uk", true },
  { "eposlondon.co.uk", true },
  { "epossheffield.co.uk", true },
  { "eposswansea.co.uk", true },
  { "epossystems.co.uk", true },
  { "epostplus.li", true },
  { "eposyork.co.uk", true },
  { "eppelblei.lu", true },
  { "eppelduerferjugend.lu", true },
  { "eppelpress.lu", true },
  { "epreskripce.cz", true },
  { "epsilon.dk", true },
  { "epspolymer.com", true },
  { "epublibre.org", true },
  { "epyonsuniverse.net", true },
  { "eq-serve.com", true },
  { "eqibank.com", true },
  { "equalcloud.com", true },
  { "equallove.me", true },
  { "equeim.ru", true },
  { "equidam.com", true },
  { "equinecoaching.ca", true },
  { "equinetherapy.ca", true },
  { "equinox.io", true },
  { "equipandoloja.net.br", true },
  { "equipedefrance.tv", true },
  { "equipeferramentas.com.br", true },
  { "equk.co.uk", true },
  { "er-mgmt.com", true },
  { "er.tl", true },
  { "er1s.xyz", true },
  { "erasmusplusrooms.com", true },
  { "erate.fi", true },
  { "erath.fr", true },
  { "erdethamburgeronsdag.no", true },
  { "ereader.uno", true },
  { "erethon.com", true },
  { "erf-neuilly.com", true },
  { "ergo-open.de", true },
  { "ergobyte.eu", true },
  { "ergobyte.gr", true },
  { "ergodark.com", true },
  { "ergovita.com.br", true },
  { "ergovitanet.com.br", true },
  { "eriador.io", true },
  { "ericabrahamsen.net", true },
  { "ericairwin.com", true },
  { "ericdiao.com", true },
  { "erichogue.ca", true },
  { "erichorstmanshof.nl", true },
  { "ericisaweso.me", true },
  { "ericjohnltd.com", true },
  { "erick.blog", true },
  { "ericleuthardt.com", true },
  { "erico.jp", true },
  { "ericoc.com", true },
  { "erics.site", true },
  { "ericschwartzlive.com", true },
  { "ericspeidel.de", true },
  { "ericvaughn-flam.com", true },
  { "ericwie.se", true },
  { "eridanus.uk", true },
  { "erigrid.eu", true },
  { "eriix.org", true },
  { "erikheemskerk.nl", true },
  { "erikhubers.nl", true },
  { "erikkruithof.nl", true },
  { "erikserver2.tk", true },
  { "erikseth.de", true },
  { "erikwalther.eu", true },
  { "erinaceinae.com", true },
  { "eriner.me", true },
  { "erinn.io", true },
  { "erisrenee.com", true },
  { "erixschueler.de", true },
  { "erkaelderbarenaaben.dk", true },
  { "ernest.ly", true },
  { "ero.ink", true },
  { "eron.info", true },
  { "eroskines.com", true },
  { "eroticforce.com", true },
  { "erp-band.ru", true },
  { "erp.band", true },
  { "erpax.com", true },
  { "erpband.ru", true },
  { "erpcargo.com", false },
  { "erperium.com", true },
  { "errietta.me", true },
  { "errlytics.com", true },
  { "error418.nl", false },
  { "ers35.com", true },
  { "ersa-shop.com", true },
  { "ershiwo.com", true },
  { "ersindemirtas.com", true },
  { "ersinerce.com", true },
  { "erstehilfeprodukte.at", true },
  { "eru.im", false },
  { "eru.me", true },
  { "eru.moe", true },
  { "erudicia.com", true },
  { "erudicia.de", true },
  { "erudicia.es", true },
  { "erudicia.fr", true },
  { "erudicia.it", true },
  { "erudicia.nl", true },
  { "erudicia.se", true },
  { "erudicia.uk", true },
  { "erudikum.cz", true },
  { "ervaarjapan.nl", true },
  { "erverydown.ml", true },
  { "erwanlepape.com", true },
  { "erwin.saarland", true },
  { "erwinpaal.nl", true },
  { "erwinschmaeh.ch", true },
  { "erwinwensveen.nl", true },
  { "erythroxylum-coca.com", true },
  { "es-geenen.de", true },
  { "es.search.yahoo.com", false },
  { "esaborit.ddns.net", true },
  { "esafar.cz", false },
  { "esagente.com", true },
  { "esailinggear.com", true },
  { "esalesdata.com", true },
  { "esamievalori.com", true },
  { "esample.info", true },
  { "esb9588.info", false },
  { "esc.chat", true },
  { "esc.gov", true },
  { "escael.org", true },
  { "escape2rooms.fr", true },
  { "escapeplaza.de", true },
  { "escapetalk.nl", true },
  { "escargotbistro.com", true },
  { "escavador.com", true },
  { "esclear.de", true },
  { "escolibri.com", true },
  { "escontact.ch", true },
  { "escortmantra.com", true },
  { "escritoriodearte.com", false },
  { "escuelabiblica.com", true },
  { "escxtra.com", true },
  { "escyr.top", true },
  { "esdenera.com", true },
  { "esdiscuss.org", true },
  { "eservices-greece.com", true },
  { "esg-abi2001.de", true },
  { "esgen.org", true },
  { "esgr.in", true },
  { "eshigami.com", true },
  { "eshop-prices.com", true },
  { "eshspotatoes.com", true },
  { "esibun.net", true },
  { "esigmbh.de", true },
  { "esipublications.com", true },
  { "esite.ch", true },
  { "eskdale.net", true },
  { "eskriett.com", true },
  { "eslint.org", true },
  { "esoa.net", true },
  { "esoko.eu", true },
  { "esolcourses.com", true },
  { "esolitos.com", true },
  { "esono.de", true },
  { "esote.net", true },
  { "esoterikerforum.de", true },
  { "espace-caen.fr", true },
  { "espace-gestion.fr", true },
  { "espace.network", true },
  { "espacecuisine.ca", true },
  { "espacetemps.ch", true },
  { "espacetheosophie.fr", true },
  { "espacio-cultural.com", true },
  { "espacioantiguo.com", true },
  { "espanol.search.yahoo.com", false },
  { "espanolseguros.com", true },
  { "espanova.com", true },
  { "espci.fr", true },
  { "especificosba.com.ar", true },
  { "espehus.dk", true },
  { "espenandersen.no", true },
  { "espgg.org", true },
  { "esphigmenou.gr", true },
  { "espigol.org", true },
  { "espiritugay.com", true },
  { "esport-battlefield.com", true },
  { "esports-network.de", true },
  { "espower.com.sg", true },
  { "espritrait.com", true },
  { "esquirou-trieves.fr", true },
  { "esquisse.fr", true },
  { "esrhd.com", true },
  { "esrinfo.com", true },
  { "ess-cert.ru", true },
  { "essayace.co.uk", true },
  { "essayads.com", true },
  { "essaybrand.com", true },
  { "essaychecker.com", true },
  { "essaydirectory.com", true },
  { "essayforsale.net", true },
  { "essaynews.com", true },
  { "essaypro.net", true },
  { "essaytalk.com", true },
  { "essaywriting.biz", true },
  { "essca.fr", true },
  { "essenalablog.de", true },
  { "essencesdeprana.org", true },
  { "essenciasparis.com.br", true },
  { "essex.cc", true },
  { "essite.net", true },
  { "esslm.sk", true },
  { "essoduke.org", true },
  { "essteebee.ch", true },
  { "establo.pro", true },
  { "estada.ch", true },
  { "estafallando.es", true },
  { "estafallando.mx", true },
  { "estaleiro.org", true },
  { "estate360.co.tz", true },
  { "estateczech-eu.ru", true },
  { "estcequejailaflemme.fr", false },
  { "estcequonmetenprodaujourdhui.info", true },
  { "esteam.se", true },
  { "estedafah.com", true },
  { "esterilizacion-perros.es", true },
  { "esteticanorte.com.br", true },
  { "estetista.net", true },
  { "estherlew.is", true },
  { "esthesoleil.jp", true },
  { "estilopack-loja.com.br", true },
  { "estoic.net", true },
  { "estoniantrade.ee", true },
  { "estonoentraenelexamen.com", true },
  { "estudiarparaser.com", true },
  { "estudiserradal.com", true },
  { "estufitas.com", true },
  { "esu.zone", true },
  { "esurety.net", true },
  { "esuretynew.azurewebsites.net", true },
  { "esw00.com", true },
  { "esw06.com", true },
  { "esw07.com", true },
  { "esw08.com", true },
  { "esw09.com", true },
  { "eswap.cz", true },
  { "et-inf.de", true },
  { "eta.cz", true },
  { "etaes.eu", true },
  { "etajerka-spb.ru", true },
  { "etaoinwu.win", true },
  { "etasigmaphi.org", true },
  { "etath.com", true },
  { "etax.com.au", true },
  { "etaxi.tn", true },
  { "etccooperative.org", true },
  { "etch.co", true },
  { "etd-glasfaser.de", true },
  { "etda.or.th", true },
  { "etech-solution.com", true },
  { "etech-solution.net", true },
  { "etech-solutions.com", true },
  { "etechsolution.net", true },
  { "eteesheet.com", true },
  { "eternal-warriors.de", true },
  { "eternalabyss.int.eu.org", true },
  { "eternalflame.cn", true },
  { "eternit.roma.it", true },
  { "etfacta.com", true },
  { "eth-faucet.net", true },
  { "eth0.nl", true },
  { "ethack.org", true },
  { "ethaligan.fr", true },
  { "ethan.pm", true },
  { "ethanjones.me", true },
  { "ethercalc.com", true },
  { "ethercalc.org", true },
  { "ethergeist.de", false },
  { "etherium.org", true },
  { "etherpad.fr", true },
  { "etherpad.nl", true },
  { "ethers.news", true },
  { "ethicaldata.co.uk", true },
  { "ethicalpolitics.org", true },
  { "ethicsburg.gov", true },
  { "ethika.com", true },
  { "ethiopian.dating", true },
  { "ethiopiannews247.com", true },
  { "ethitter.com", true },
  { "ethosinfo.com", true },
  { "etienne.cc", true },
  { "etikus-hacker.hu", true },
  { "etiquetaunica.com.br", true },
  { "etoile-usedcars.com", true },
  { "etre-soi.ch", true },
  { "etre-vivant.fr", true },
  { "etrecosmeticderm.com", true },
  { "etresmant.es", true },
  { "etrker.com", true },
  { "etrolleybizstore.com", true },
  { "etskinner.com", true },
  { "etskinner.net", true },
  { "etssquare.com", true },
  { "etudesbibliques.fr", true },
  { "etudesbibliques.net", true },
  { "etudesbibliques.org", true },
  { "etv.cx", true },
  { "etyd.org", true },
  { "etzi.myds.me", true },
  { "eu-darlehen-finanzierung.de", true },
  { "eu-datenbank.de", true },
  { "eu-gamers.com", true },
  { "eu-stellenangebot.de", true },
  { "euaggelion.blog.br", true },
  { "euanbarrett.com", true },
  { "euchre.us", true },
  { "eugenechae.com", true },
  { "eugenekay.com", true },
  { "eugenetech.org", true },
  { "eujuicers.bg", true },
  { "eujuicers.com", true },
  { "eujuicers.com.hr", true },
  { "eujuicers.com.ua", true },
  { "eujuicers.cz", true },
  { "eujuicers.de", true },
  { "eujuicers.es", true },
  { "eujuicers.fr", true },
  { "eujuicers.hu", true },
  { "eujuicers.it", true },
  { "eujuicers.pl", true },
  { "eujuicers.pt", true },
  { "eujuicers.ro", true },
  { "eujuicers.rs", true },
  { "eujuicers.ru", true },
  { "eujuicers.si", true },
  { "eujuicers.sk", true },
  { "eulenschmiede.de", true },
  { "eupay.de", true },
  { "eureka.archi", true },
  { "eurekaarchi.com", true },
  { "eurekaarchitecture.com", true },
  { "eurheilu.com", true },
  { "euro-servers.de", true },
  { "euroalter.com", true },
  { "eurocars2000.es", true },
  { "eurocenterobuda.hu", true },
  { "euroconthr.ro", true },
  { "eurodentaire.com", true },
  { "euroflora.com", true },
  { "euroflora.mobi", true },
  { "eurofrank.eu", true },
  { "eurolocarno.es", true },
  { "europapier.hu", true },
  { "europapier.net", true },
  { "europapier.sk", true },
  { "europarts-sd.com", true },
  { "europastudien.de", true },
  { "european-agency.org", true },
  { "europeancupinline.eu", true },
  { "europeantimberconnectors.ca", true },
  { "europeantransportmanagement.com", true },
  { "europeanwineresource.com", true },
  { "europeos.es", true },
  { "europetravelservice.co.uk", true },
  { "europop.com", true },
  { "eurora.de", true },
  { "euroscot.de", true },
  { "euroshop.or.at", true },
  { "euroskano.nl", true },
  { "eurotime.ua", true },
  { "eurotramp.com", true },
  { "eurotravelstar.eu", true },
  { "eurousa.us", true },
  { "eurovision.ie", true },
  { "euteamo.cn", true },
  { "eutotal.com", true },
  { "eutram.com", true },
  { "euwid-energie.de", true },
  { "euwid.de", true },
  { "ev-zertifikate.de", true },
  { "eva-select.com", true },
  { "eva.cz", true },
  { "evaartinger.de", true },
  { "evadifranco.com", true },
  { "evafojtova.cz", true },
  { "evailoil.ee", true },
  { "evailoil.eu", true },
  { "evalesc.com", true },
  { "evamachkova.cz", true },
  { "evamathil.de", true },
  { "evamira.com", true },
  { "evanfiddes.com", true },
  { "evangelicalmagazine.com", true },
  { "evansdesignstudio.com", true },
  { "evantageglobal.com", true },
  { "evanwang0.com", true },
  { "evapp.org", true },
  { "evasioncreole.com", true },
  { "evasovova.cz", true },
  { "evavolfova.cz", true },
  { "eve.ac", true },
  { "eve0s.com", true },
  { "evelienzorgt.nl", true },
  { "evelyndayman.com", true },
  { "evemarketer.com", true },
  { "evemodx.com", true },
  { "evenementenhoekvanholland.nl", true },
  { "evenstargames.com", true },
  { "event4fun.no", true },
  { "eventaro.com", true },
  { "eventide.space", true },
  { "eventive.org", true },
  { "eventnexus.co.uk", true },
  { "eventosenmendoza.com.ar", true },
  { "events-hire.co.uk", true },
  { "eventtech.com", false },
  { "evenwallet.com", true },
  { "eveonline.com", true },
  { "ever.sale", true },
  { "everain.me", true },
  { "everettsautorepair.com", true },
  { "everfine.com.tw", true },
  { "evergladesrestoration.gov", true },
  { "evergreenmichigan.com", true },
  { "everhome.de", true },
  { "everitoken.io", true },
  { "everling.lu", true },
  { "everlong.org", true },
  { "evermarkstudios.com", true },
  { "everpcpc.com", true },
  { "evertonarentwe.com", true },
  { "everwaking.com", false },
  { "everybodyhertz.co.uk", true },
  { "everyday.eu.org", true },
  { "everydaygary.com", true },
  { "everydaywot.com", true },
  { "everydaywp.com", true },
  { "everyex.com", true },
  { "everyfad.com", true },
  { "everygayporn.com", false },
  { "everything-everywhere.com", true },
  { "everythingaccess.com", true },
  { "everythingstech.com", true },
  { "everythinq.com", true },
  { "everytrycounts.gov", false },
  { "everywhere.cloud", true },
  { "eveshamglass.co.uk", true },
  { "eveswell.com", true },
  { "evexia.xyz", true },
  { "evidence-based.review", true },
  { "evidencebased.net", true },
  { "evidenceusa.com.br", true },
  { "evidencija.ba", true },
  { "evidentiasoftware.com", true },
  { "evilarmy.com", true },
  { "evilbunnyfufu.com", true },
  { "evilized.de", true },
  { "evilmartians.com", true },
  { "evilsite.cf", true },
  { "evion.nl", true },
  { "evlear.com", true },
  { "evoco.vc", true },
  { "evodation.com", true },
  { "evodation.org", true },
  { "evodia-spirits.de", true },
  { "evok.com.co", false },
  { "evokepk.com", true },
  { "evolutioninflatables.co.uk", true },
  { "evolutionlending.co.uk", true },
  { "evolutionpets.com", true },
  { "evolutionsmedicalspa.com", true },
  { "evolvetechnologies.co.uk", true },
  { "evolvingthoughts.net", true },
  { "evony.eu", true },
  { "evosyn.com", true },
  { "evotec.pl", true },
  { "evotec.xyz", true },
  { "evoting.ch", true },
  { "evrial.com", true },
  { "evrica.me", true },
  { "evromandie.ch", true },
  { "evrotrust.com", true },
  { "evstatus.com", true },
  { "evtasima.name.tr", true },
  { "evtripping.com", true },
  { "evtscan.io", true },
  { "ewaipiotr.pl", true },
  { "ewanm89.co.uk", true },
  { "ewanm89.com", true },
  { "ewanm89.uk", true },
  { "ewe2.ninja", true },
  { "ewhitehat.com", true },
  { "ewie.name", true },
  { "ewizmo.com", true },
  { "ewout.io", true },
  { "ewsfeed.com", true },
  { "ewtl.es", true },
  { "ewus.de", true },
  { "ewycena.pl", true },
  { "ex-deli.jp", true },
  { "exactlyinfinite.com", true },
  { "exactphilosophy.net", true },
  { "exagoni.com.au", true },
  { "exagoni.com.my", true },
  { "examedge.com", true },
  { "example.sc", true },
  { "example.wf", true },
  { "examsmate.in", true },
  { "exaplac.com", true },
  { "exarpy.com", true },
  { "exatmiseis.net", false },
  { "exceed.global", true },
  { "exceedagency.com", true },
  { "excel-utbildning.nu", true },
  { "excelhot.com", true },
  { "excelkurs.one", true },
  { "exceltechdubai.com", true },
  { "exceltechoman.com", true },
  { "exceltobarcode.com", true },
  { "excentos.com", true },
  { "exceptionalservers.com", true },
  { "excessamerica.com", true },
  { "excesssecurity.com", true },
  { "exchaser.com", true },
  { "exclusivebouncycastles.co.uk", true },
  { "exclusivecarcare.co.uk", true },
  { "exdamo.de", false },
  { "exe-boss.tech", true },
  { "execution.biz.tr", true },
  { "exehack.net", true },
  { "exeintel.com", true },
  { "exekutori.com", true },
  { "exemples-de-stands.com", true },
  { "exerforge.com", true },
  { "exerforge.net", true },
  { "exeria.de", true },
  { "exexcarriers.com", true },
  { "exgen.io", true },
  { "exhaledayspa.com.au", true },
  { "exhalespa.com", true },
  { "exhibityour.com", true },
  { "exiahost.com", true },
  { "exit9wineandliquor.com", true },
  { "exitooutdoor.com", true },
  { "exmoe.com", true },
  { "exon.io", true },
  { "exoplatform.com", true },
  { "exordiumconcepts.com", true },
  { "exoscale.ch", true },
  { "exoscale.com", true },
  { "exoten-spezialist.de", true },
  { "exousiakaidunamis.pw", true },
  { "exp.de", true },
  { "expancio.com", false },
  { "expanddigital.media", true },
  { "expandeco.com", true },
  { "expatmortgage.uk", true },
  { "expe.voyage", true },
  { "expeditiegrensland.nl", true },
  { "experienceoutdoors.org.uk", true },
  { "experienceoz.com.au", true },
  { "experise.fr", true },
  { "expert-korovin.ru", true },
  { "expert.cz", true },
  { "experteasy.com.au", true },
  { "expertofficefitouts.com.au", true },
  { "expertohomestaging.com", true },
  { "expertsverts.com", true },
  { "expertvagabond.com", true },
  { "expertviolinteacher.com", true },
  { "expiscor.solutions", true },
  { "explodie.org", true },
  { "exploflex.com.br", true },
  { "exploit-db.com", true },
  { "exploit.cz", true },
  { "exploit.party", true },
  { "exploit.ph", true },
  { "exploited.cz", true },
  { "exploitit.com.au", true },
  { "exploodo.rocks", true },
  { "exploravacations.in", true },
  { "exploremonero.com", true },
  { "exploringenderby.com", true },
  { "expo-america.ru", true },
  { "expo-asia.ru", true },
  { "expo-europe.ru", true },
  { "expo-larionov.org", true },
  { "exponentialnews.net", true },
  { "expoort.co.uk", true },
  { "expoort.com", true },
  { "expoort.es", true },
  { "expoort.fr", true },
  { "expoort.it", true },
  { "expopodium.com", true },
  { "exporta.cz", true },
  { "express-shina.ru", true },
  { "express-vpn.com", true },
  { "expressemotion.net", true },
  { "expresshosting.org", true },
  { "expressmarket.ru", true },
  { "expresstinte.de", true },
  { "expressvpn.com", true },
  { "expresswins.co.uk", true },
  { "expxkcd.com", true },
  { "exs.lv", true },
  { "exside.com", true },
  { "exsora.com", true },
  { "extasic.com", true },
  { "extendwings.com", true },
  { "extensia.it", true },
  { "extensibility.biz.tr", true },
  { "extensiblewebmanifesto.org", true },
  { "extensiblewebreportcard.org", true },
  { "extensiblewebsummit.org", true },
  { "extensionschallenge.com", true },
  { "extensiontree.com", true },
  { "exteriorlightingagoura.com", true },
  { "exteriorlightingagourahills.com", true },
  { "exteriorlightingcalabasas.com", true },
  { "exteriorlightingcamarillo.com", true },
  { "exteriorlightingconejovalley.com", true },
  { "exteriorlightingdosvientos.com", true },
  { "exteriorlightinghiddenhills.com", true },
  { "exteriorlightinglakesherwood.com", true },
  { "exteriorlightingmalibu.com", true },
  { "exteriorlightingmoorpark.com", true },
  { "exteriorlightingnewburypark.com", true },
  { "exteriorlightingoakpark.com", true },
  { "exteriorlightingsimivalley.com", true },
  { "exteriorlightingthousandoaks.com", true },
  { "exteriorlightingwestlakevillage.com", true },
  { "extintormadrid.com", true },
  { "extradesktops.com", false },
  { "extradivers-worldwide.com", true },
  { "extranetpuc.com.br", true },
  { "extrapagetab.com", true },
  { "extreemhost.nl", true },
  { "extreme-gaming.de", true },
  { "extreme-gaming.us", true },
  { "extreme-players.com", true },
  { "extreme-players.de", true },
  { "extreme.co.th", true },
  { "exultcosmetics.co.uk", true },
  { "exxo.tk", true },
  { "exyplis.com", true },
  { "eydesignguidelines.com", true },
  { "eyeandfire.com", true },
  { "eyecandy.gr", true },
  { "eyeglasses.com", false },
  { "eyelashconcept.com", true },
  { "eyeonid.com", true },
  { "eyep.me", true },
  { "eyes-berg.ch", true },
  { "eyes-berg.com", true },
  { "eyesandearsrescue.org", true },
  { "eynio.com", true },
  { "eyona.com", true },
  { "eyps.net", true },
  { "eyyit.com", false },
  { "eyyubyilmaz.com", true },
  { "ez3d.eu", true },
  { "ezakazivanje.rs", true },
  { "ezdog.press", true },
  { "ezequiel-garzon.net", true },
  { "ezesec.com", true },
  { "ezgif.com", true },
  { "ezhik-din.ru", true },
  { "eztvtorrent.com", true },
  { "ezwritingservice.com", true },
  { "ezzhole.net", true },
  { "f-be.com", true },
  { "f-droid.org", true },
  { "f-hd.net", true },
  { "f-thie.de", true },
  { "f-u-c-k.wien", true },
  { "f00.fr", true },
  { "f0x.es", true },
  { "f13cybertech.cz", true },
  { "f1classement.com", true },
  { "f1fever.co.uk", true },
  { "f1fever.net", true },
  { "f1minute.com", true },
  { "f2h.io", true },
  { "f3nws.com", true },
  { "f43.me", true },
  { "f5.hk", true },
  { "f5nu.com", true },
  { "f5w.de", true },
  { "f88-line.com", true },
  { "f88-line.net", true },
  { "f88line.com", true },
  { "f88line.net", true },
  { "f88yule1.com", true },
  { "f88yule5.com", true },
  { "f88yule6.com", true },
  { "f88yule7.com", true },
  { "f88yule8.com", true },
  { "fa-works.com", true },
  { "fabbro-roma.org", true },
  { "fabbro.roma.it", true },
  { "faber.org.ru", true },
  { "fabian-fingerle.de", true },
  { "fabian-klose.com", true },
  { "fabian-klose.de", true },
  { "fabian-klose.net", true },
  { "fabian-koeppen.de", true },
  { "fabianackle.ch", true },
  { "fabianbeiner.com", false },
  { "fabianbeiner.de", false },
  { "fabianfranke.de", true },
  { "fabiankoeppen.com", true },
  { "fabienne-roux.org", true },
  { "fabiobier.com", true },
  { "fabjansisters.eu", true },
  { "fableforge.nl", true },
  { "fabmart.com", true },
  { "fabrica360.com", true },
  { "fabriceleroux.com", true },
  { "fabriziocavaliere.it", true },
  { "fabriziorocca.it", true },
  { "fabrysociety.org", true },
  { "fabse.net", true },
  { "facanabota.com", true },
  { "facanabota.com.br", true },
  { "faccess.it", true },
  { "facciadastile.it", true },
  { "face-mania.com", true },
  { "facealacrise.fr", true },
  { "facebook-atom.appspot.com", true },
  { "facebook.com", true },
  { "facebydrh.com", true },
  { "facebylouise.co.uk", true },
  { "facekungfu.com", true },
  { "facepainting.gr", true },
  { "facerepo.com", true },
  { "faceresources.org", true },
  { "fach-journalist.de", true },
  { "fachschaftslisten.at", true },
  { "fachschaftslisten.org", true },
  { "facialexercising.com", true },
  { "facil.services", false },
  { "faciledireto.com.br", true },
  { "facilities.fr", true },
  { "facilitiessurvey.org", true },
  { "facility-service-muenchen.de", true },
  { "fackovcova.cz", true },
  { "fackovcova.eu", true },
  { "fackovcova.sk", true },
  { "fackovec.cz", true },
  { "fackovec.eu", true },
  { "fackovec.sk", true },
  { "factbytefactbox.com", true },
  { "factcool.com", true },
  { "factor.cc", false },
  { "factuur.pro", true },
  { "factuursturen.be", true },
  { "factuursturen.nl", true },
  { "factys.do", true },
  { "factys.es", true },
  { "facua.org", true },
  { "facucosta.com.ar", true },
  { "faderweb.de", true },
  { "faehler.de", true },
  { "faelix.net", true },
  { "faerb.it", true },
  { "faerie-art.com", true },
  { "fahnamporn.com", true },
  { "fahnen-fanwelt.de", true },
  { "fahrenwal.de", true },
  { "fahrenwalde.de", true },
  { "fahrschule-laux.de", true },
  { "fahrwerk.io", true },
  { "fai.gov", true },
  { "faidanoi.it", true },
  { "faidatefacile.it", true },
  { "fail.coach", true },
  { "fail4free.de", true },
  { "failover.de", true },
  { "failover.eu", true },
  { "failoverplan.it", true },
  { "fairbill.com", true },
  { "fairedeseconomies.info", true },
  { "fairgolfteams.com", true },
  { "fairleighcrafty.com", true },
  { "fairmarketing.com", true },
  { "fairplay.im", true },
  { "fairssl.dk", true },
  { "fairssl.se", true },
  { "fairviewmotel-simcoe.com", true },
  { "fairydust.space", true },
  { "faithcentercogop.net", true },
  { "faithgrowth.com", true },
  { "faithindemocracy.eu", false },
  { "faithleaks.org", true },
  { "faithmissionaries.com", true },
  { "faithwatch.org", true },
  { "faixaazul.com", true },
  { "fakeapple.nl", true },
  { "fakerli.com", true },
  { "fakti.bg", true },
  { "faktotum.tech", true },
  { "fakturi.com", true },
  { "fakturoid.cz", true },
  { "falaeapp.org", true },
  { "falaowang.com", true },
  { "falbros.com", true },
  { "falcona.io", true },
  { "falconfrag.com", true },
  { "falconvintners.com", true },
  { "falcoz.co", true },
  { "faldoria.de", true },
  { "falegname-roma.it", true },
  { "falkhusemann.de", true },
  { "falldennismarketing.com", true },
  { "fallenangeldrinks.co.uk", true },
  { "fallenangeldrinks.com", true },
  { "fallenangelspirits.co.uk", true },
  { "fallenangelspirits.com", true },
  { "fallenmystic.com", true },
  { "fallenspirits.co.uk", true },
  { "falling.se", true },
  { "fallofthecitadel.com", true },
  { "falsum.net", true },
  { "fam-kreibich.de", true },
  { "fam-stemmer.de", false },
  { "fam-weyer.de", true },
  { "famcloud.de", true },
  { "fameng.nl", true },
  { "fameus.fr", true },
  { "famfi.co", true },
  { "familiaperez.net", true },
  { "familie-keil.de", true },
  { "familie-kruithof.nl", true },
  { "familie-kupschke.de", true },
  { "familie-leu.ch", true },
  { "familie-monka.de", true },
  { "familie-poeppinghaus.de", true },
  { "familie-remke.de", true },
  { "familieholme.de", true },
  { "familiekiekjes.nl", true },
  { "familjenfrodlund.se", true },
  { "familjenm.se", true },
  { "familylawhotline.org", true },
  { "familyparties.co.uk", true },
  { "familyreal.ru", true },
  { "familytreehq.com", true },
  { "familyworld.gr", true },
  { "famososnaweb.com", true },
  { "famousbirthdays.com", true },
  { "famoushostels.com", true },
  { "famvangelder.nl", true },
  { "famvsomeren.nl", true },
  { "fan.gov", true },
  { "fanactu.com", true },
  { "fanatical.com", true },
  { "fanatik.io", true },
  { "fanboi.ch", true },
  { "fancy-bridge.com", true },
  { "fancy.org.uk", true },
  { "fancygaming.dk", true },
  { "fander.it", true },
  { "fandler.cz", true },
  { "fandomservices.com", true },
  { "fanfareunion.ch", true },
  { "fangs.ink", true },
  { "fanhouwan.com", true },
  { "fanjoe.be", true },
  { "fansided.com", true },
  { "fantasiapainter.com", true },
  { "fantasiatravel.hr", true },
  { "fantasticcleaners.com.au", true },
  { "fantastichandymanmelbourne.com.au", true },
  { "fantastici.de", true },
  { "fantasticservices.com", true },
  { "fantasticservicesgroup.com.au", true },
  { "fantasycastles.co.uk", true },
  { "fantasycdn.com", true },
  { "fantasydrop.com", true },
  { "fantasyescortsbirmingham.co.uk", true },
  { "fantasymina.de", true },
  { "fantasypartyhire.com.au", true },
  { "fantasyspectrum.com", true },
  { "fantopia.club", true },
  { "fanvoice.com", true },
  { "fanyina.cn", true },
  { "fanyina.com", true },
  { "fanyue123.tk", true },
  { "fanz.pro", true },
  { "fanzlive.com", true },
  { "faq.ie", true },
  { "fara.gov", true },
  { "faradji.nu", true },
  { "faradome.ws", true },
  { "faraslot8.com", true },
  { "farcecrew.de", true },
  { "farfallapets.com.br", true },
  { "farfetchos.com", true },
  { "fargtorget.se", true },
  { "farhadexchange.com", true },
  { "farhood.org", true },
  { "farid.is", true },
  { "farmacia-discreto.com", true },
  { "farmaciadejaime.es", true },
  { "farmacialaboratorio.it", true },
  { "farmer.dating", true },
  { "farmers.gov", false },
  { "farmkazuto.com", true },
  { "faroebusinessreport.com", true },
  { "faroes.net", true },
  { "faroes.org", true },
  { "farrel-f.cf", true },
  { "farrel-f.id", true },
  { "farrel-f.tk", true },
  { "farrelf.blog", true },
  { "farsil.eu", true },
  { "fart.wtf", true },
  { "farthing.xyz", true },
  { "farwat.ru", true },
  { "faschingmd.com", true },
  { "fascia.fit", true },
  { "fashion-stoff.de", true },
  { "fashion24.de", true },
  { "fashion4ever.pl", true },
  { "fashionhijabers.com", true },
  { "fashionunited.be", true },
  { "fashionunited.cl", true },
  { "fashionunited.com", true },
  { "fashionunited.com.ar", true },
  { "fashionunited.de", true },
  { "fashionunited.fi", true },
  { "fashionunited.hk", true },
  { "fashionunited.hu", true },
  { "fashionunited.ie", true },
  { "fashionunited.lu", true },
  { "fashionunited.mx", true },
  { "fashionunited.nl", true },
  { "fashionunited.no", true },
  { "fashionunited.nz", true },
  { "fashionunited.pl", true },
  { "fashionunited.se", true },
  { "fashionweekweb.com", true },
  { "fashtic.nl", true },
  { "faspirits.co.uk", true },
  { "faspirits.com", true },
  { "fassaden-selleng.de", true },
  { "fassadenverkleidung24.de", true },
  { "fassi-sport.it", true },
  { "fast-host.net", true },
  { "fast-pro.co.jp", true },
  { "fastblit.com", true },
  { "fastcash.com.br", true },
  { "fastcomcorp.com", true },
  { "fastcommerce.org", true },
  { "fastcp.top", true },
  { "fastest-hosting.co.uk", true },
  { "fastforwardthemes.com", true },
  { "fastlike.co", true },
  { "fastmail.com", false },
  { "fastonline.ro", true },
  { "fastpresence.com", true },
  { "fastrevision.com", true },
  { "fastvistorias.com.br", true },
  { "faszienrollen-info.de", false },
  { "fateandirony.com", true },
  { "fatecdevday.com.br", true },
  { "fatedata.com", true },
  { "fateitalia.it", true },
  { "fathers4equalrights.org", true },
  { "fatidique.com", true },
  { "fatimamoldes.com.br", true },
  { "fatmixx.com", true },
  { "fatowltees.com", true },
  { "faucetbox.com", false },
  { "faui2k17.de", false },
  { "faultlines.org", true },
  { "faulty.equipment", true },
  { "fauvettes.be", true },
  { "favirei.com", true },
  { "fawong.com", true },
  { "faxite.com", true },
  { "faxvorlagen-druckvorlagen.de", true },
  { "fb.me", true },
  { "fbcdn.net", true },
  { "fbcopy.com", true },
  { "fbi.gov", true },
  { "fbigame.com", true },
  { "fbiic.gov", true },
  { "fbijobs.gov", true },
  { "fbo.gov", true },
  { "fbsbx.com", true },
  { "fbtholdings.com", true },
  { "fburl.com", true },
  { "fc.media", true },
  { "fca-tools.com", true },
  { "fcburk.de", true },
  { "fccarbon.com", true },
  { "fcdn.nl", true },
  { "fcforum.net", true },
  { "fcingolstadt.de", true },
  { "fckd.net", true },
  { "fcosinus.com", true },
  { "fcprovadia.com", true },
  { "fcsic.gov", true },
  { "fdalawboston.com", true },
  { "fdaregs.com", true },
  { "fdevs.ch", true },
  { "fdicig.gov", true },
  { "fdicoig.gov", true },
  { "fdlibre.eu", true },
  { "fdms.gov", true },
  { "fdn.one", true },
  { "fdos.me", true },
  { "fdp-brig-glis.ch", true },
  { "fdresearch.ca", true },
  { "fdsys.gov", false },
  { "feac.us", true },
  { "feaden.me", true },
  { "feandc.com", true },
  { "fearby.com", true },
  { "fearghus.org", true },
  { "fearsomegaming.com", true },
  { "feastr-dev.de", true },
  { "feastr.de", true },
  { "feastr.io", true },
  { "featherweightlabs.com", true },
  { "featuredmen.com", false },
  { "feb.gov", true },
  { "fedcenter.gov", true },
  { "federaljobs.gov", true },
  { "federalreserve.gov", true },
  { "federalreserveconsumerhelp.gov", true },
  { "federatedbank.com", true },
  { "federicomigliavacca.it", true },
  { "fedjobs.gov", true },
  { "fedorahosted.org", true },
  { "fedoramagazine.org", true },
  { "fedorapeople.org", true },
  { "fedoraproject.org", true },
  { "fedpartnership.gov", true },
  { "fedramp.gov", false },
  { "fedrtc.org", true },
  { "fedshirevets.gov", true },
  { "fedux.com.ar", true },
  { "fedvan.com", true },
  { "fee-hosting.com", true },
  { "feedbin.com", false },
  { "feedfall.com", true },
  { "feedhq.org", true },
  { "feedkovacs.hu", true },
  { "feedough.com", true },
  { "feedthefuture.gov", true },
  { "feeeei.com", true },
  { "feek.fit", true },
  { "feel-events.com", true },
  { "feel.aero", true },
  { "feelgood-workouts.de", true },
  { "feelmom.com", true },
  { "feeltennis.net", true },
  { "feen.us", true },
  { "feepod.com", true },
  { "feetpa.ws", true },
  { "feezmodo.com", false },
  { "fefelovalex.ru", true },
  { "fegame.eu", true },
  { "fegame.mobi", true },
  { "fegame.net", true },
  { "fegame.nl", true },
  { "fegli.gov", true },
  { "fehngarten.de", true },
  { "fehnladen.de", true },
  { "feigling.net", false },
  { "feildel.fr", true },
  { "feilen.de", true },
  { "feisbed.com", true },
  { "feisim.com", true },
  { "feisim.org", true },
  { "feistyduck.com", true },
  { "feizhujianzhi.com", true },
  { "fejes.house", true },
  { "feld.design", true },
  { "feld.saarland", true },
  { "feldhousen.com", true },
  { "felett.es", true },
  { "feli.games", true },
  { "felicifia.org", true },
  { "felinepc.com", true },
  { "felistirnavia.sk", true },
  { "felixaufreisen.de", true },
  { "felixbarta.de", true },
  { "felixcrux.com", true },
  { "felixgenicio.com", true },
  { "felixkauer.de", true },
  { "felixqu.com", true },
  { "felixsanz.com", true },
  { "felixseele.de", true },
  { "felsing.net", true },
  { "felsmalerei.net", true },
  { "femanca.com", true },
  { "femastudios.com", true },
  { "femiluna.com", true },
  { "feminina.pt", true },
  { "femradio.es", true },
  { "femtomind.com", true },
  { "fence-stlouis.com", true },
  { "feng-hhcm.com", true },
  { "feng.si", true },
  { "fengyi.tel", true },
  { "fenster-bank.at", true },
  { "fenster-bank.de", true },
  { "feragon.net", true },
  { "ferdies.co.za", true },
  { "fergtm.com", true },
  { "fergusoncastle.com", true },
  { "ferien-netzwerk.de", true },
  { "ferienchalet-wallis.ch", true },
  { "ferienhaeuser-krummin.de", true },
  { "ferienhaus-polchow-ruegen.de", false },
  { "ferienhausprovence.ch", true },
  { "ferienwohnung-hafeninsel-stralsund.de", true },
  { "ferienwohnung-wiesengrund.eu", true },
  { "feriespotter.dk", true },
  { "ferm-rotterdam.nl", true },
  { "fermabel.com.br", true },
  { "fernandes.org", true },
  { "fernandob.com", true },
  { "fernandobarata.pt", true },
  { "fernandobarillas.com", true },
  { "fernandomiguel.net", true },
  { "feross.org", true },
  { "ferrariadvisor.it", true },
  { "ferret.zone", true },
  { "ferreteriaxerez.com", true },
  { "ferrolatino.ch", true },
  { "ferrousmoon.com", true },
  { "ferry.tw", true },
  { "ferticare.pt", true },
  { "fertila.de", true },
  { "festaprylar.se", true },
  { "festival-tipps.com", true },
  { "festivaljapon.com", true },
  { "festx.co.za", true },
  { "fettlaus.de", true },
  { "feudalisten.de", true },
  { "feuerhuhn.de", true },
  { "feuerloescher-arten.de", true },
  { "feuerloescher-test.de", true },
  { "feuerwehr-coesfeld.de", true },
  { "feuerwehr-gebirge.de", true },
  { "feuerwehr-heiligenberg.de", true },
  { "feuerwehr-illmensee.de", true },
  { "feuerwehr-mehring.de", true },
  { "feuerwehr-oberkotzau.de", true },
  { "feuerwehr-offenbach-bieber.de", false },
  { "feuerwehr-vechta.de", true },
  { "feuerwehrbadwurzach.de", true },
  { "feuerwerksmanufaktur.de", true },
  { "feuetgloire.com", true },
  { "fewo-hafeninsel-stralsund.de", true },
  { "fewo-thueringer-wald.de", true },
  { "fexco.com", true },
  { "feybiblia.com", true },
  { "feyermedia.de", true },
  { "ff-bad-hoehenstadt.de", true },
  { "ff-getzersdorf.at", true },
  { "ff-obersunzing-niedersunzing.de", true },
  { "ff14-mstdn.xyz", false },
  { "ffb.gov", false },
  { "ffbans.org", true },
  { "ffbsee.net", true },
  { "ffiec.gov", true },
  { "ffis.me", true },
  { "ffkoenigsberg.de", true },
  { "ffmradio.de", true },
  { "ffprofile.com", true },
  { "ffta.eu", true },
  { "ffw-zeven.de", true },
  { "ffzeven.de", true },
  { "fgdc.gov", true },
  { "fhba.com.au", true },
  { "fhcdn.xyz", true },
  { "fhconseil.fr", true },
  { "fhdhelp.de", false },
  { "fhdhilft.de", false },
  { "fhfaoig.gov", true },
  { "fhmkh.cn", true },
  { "fi.google.com", true },
  { "fi.search.yahoo.com", false },
  { "fialat.cz", true },
  { "fiam.me", true },
  { "fiareapp.red", false },
  { "fiasgo.com", true },
  { "fiasgo.dk", true },
  { "fiasgo.i.ng", true },
  { "fibabanka.com.tr", true },
  { "fibo-forex.org", true },
  { "fibra.click", true },
  { "fibretv.co.nz", true },
  { "fibretv.tv", true },
  { "fibromuebles.com", true },
  { "fichier-pdf.fr", true },
  { "fickweiler.nl", true },
  { "ficlab.com", true },
  { "ficus.io", true },
  { "fid-elite.ch", true },
  { "fidanza.eu", true },
  { "fidelapp.com", true },
  { "fidelis-it.ch", true },
  { "fidelis-it.net", true },
  { "fidhouriet.ch", true },
  { "fiduciaire-ratio.ch", true },
  { "fieldwork-paysage.com", true },
  { "fierlafijn.net", true },
  { "fierscleaning.nl", true },
  { "fiery.me", true },
  { "fifautstore.com", true },
  { "fifei.de", true },
  { "fifichachnil.paris", true },
  { "fifieldtech.com", true },
  { "fifr.nl", true },
  { "fiftynorth.eu", true },
  { "fiftyonetielt.be", true },
  { "figan.cz", true },
  { "fight215.com", true },
  { "fight215.org", true },
  { "figinstitute.org", true },
  { "figliasons.com", true },
  { "figshare.com", true },
  { "figurasdelinguagem.com.br", true },
  { "figure.nz", true },
  { "fiilr.com", true },
  { "fiissh.tech", true },
  { "fiix.io", true },
  { "fijnefeestdageneneengelukkignieuwjaar.nl", true },
  { "fijnewoensdag.nl", true },
  { "fiken.no", true },
  { "fikst.com", true },
  { "fil-tec-rixen.com", true },
  { "fil.fi", true },
  { "filanthropystar.org", true },
  { "file-cloud.eu", true },
  { "file-pdf.it", true },
  { "filecopa.com", true },
  { "files.from-me.org", true },
  { "fileservicios.com.ar", true },
  { "filestar.io", true },
  { "filestartest.io", true },
  { "filetransfer.one", true },
  { "filezilla-project.org", true },
  { "filezilla.cn", true },
  { "filhin.es", true },
  { "filhodohomem.com", true },
  { "fili.org", true },
  { "filidorwiese.nl", true },
  { "filiio.com", true },
  { "filingsmadeeasy.com", true },
  { "filiosoft.cloud", true },
  { "filip-prochazka.com", false },
  { "filippo.io", true },
  { "filipsebesta.com", true },
  { "filleritemsindia.com", true },
  { "fillo.sk", true },
  { "film-colleges.com", true },
  { "film-storyboards.fr", true },
  { "film-tutorial.com", true },
  { "filme-onlines.com", true },
  { "filmers.net", true },
  { "filmesonline.online", true },
  { "filmitis.com", true },
  { "filmreviewonline.com", true },
  { "filmserver.de", true },
  { "filmsite-studio.com", true },
  { "filmsphoto.com", true },
  { "filoo.de", true },
  { "filstop.com", true },
  { "filterlists.com", true },
  { "filtr.me", true },
  { "fimsquad.com", true },
  { "finagosolo.com", true },
  { "final-expense-quotes.com", true },
  { "finalprice.net", true },
  { "finalrewind.org", true },
  { "finalx.nl", true },
  { "finance-colleges.com", true },
  { "financejobs.ch", true },
  { "financepark.ch", true },
  { "financniexperti.sk", true },
  { "finansa.no", true },
  { "finanstilsynet.dk", true },
  { "finch.am", true },
  { "finchi.de", true },
  { "finchnest.co.uk", true },
  { "find-job-in.com", true },
  { "find-mba.com", true },
  { "findapinball.com", true },
  { "findcarspecs.com", true },
  { "findhoustonseniorcare.com", true },
  { "findingkorea.com", true },
  { "finditez.com", true },
  { "findmynudes.com", true },
  { "findoon.de", true },
  { "findrejsepartner.dk", true },
  { "findstorenearme.ca", true },
  { "findstorenearme.co.uk", true },
  { "findstorenearme.us", true },
  { "findthatnude.com", true },
  { "findyourtrainer.com", true },
  { "findyourvoice.ca", true },
  { "fine-services.paris", true },
  { "finecocoin.io", true },
  { "finefriends.nl", true },
  { "finelovedolls.com", true },
  { "finenet.com.tw", true },
  { "finevegashomes.com", true },
  { "finfev.de", true },
  { "finflix.net", true },
  { "finform.ch", true },
  { "fini-de-jouer.ch", true },
  { "finisron.in", true },
  { "finkelstein.fr", true },
  { "finkmartin.com", true },
  { "finn.io", true },
  { "finnclass.cz", true },
  { "finnwea.com", true },
  { "finpt.com", false },
  { "finsprings.org", true },
  { "fintandunleavy.com", false },
  { "fintechnics.com", false },
  { "fintry.ca", true },
  { "finvantage.com", true },
  { "finwe.info", true },
  { "fionafuchs.de", true },
  { "fionamcbride.com", true },
  { "fioristionline.it", true },
  { "fioristionline.net", true },
  { "fioulmarket.fr", true },
  { "fir3net.com", true },
  { "fire-schools.com", true },
  { "firebaseio.com", true },
  { "firebirdrangecookers.com", true },
  { "firebounty.com", true },
  { "fireboxfood.com", true },
  { "firebugmusic.com", true },
  { "firechip.cc", true },
  { "firecore.com", true },
  { "firecry.org", true },
  { "firefart.at", true },
  { "firefighters.dating", true },
  { "firefly-iii.org", true },
  { "firegoby.jp", true },
  { "firegore.com", true },
  { "fireleadership.gov", true },
  { "firemudfm.com", true },
  { "firenza.org", true },
  { "fireplex.co.uk", true },
  { "fireportal.cz", true },
  { "fireportal.sk", true },
  { "fireshellsecurity.team", true },
  { "firesofheaven.org", true },
  { "firesuite.net", true },
  { "firetotheprisons.org", true },
  { "firevap.org", true },
  { "firewallconsultants.com", true },
  { "fireworksshowvr.com", true },
  { "firma-cerny.cz", true },
  { "firma-offshore.com", true },
  { "firmament.space", true },
  { "firmapi.com", true },
  { "firmen-assekuranz.de", true },
  { "firmenwerbung-vermarktung.de", true },
  { "firmware.science", true },
  { "first-house.no", true },
  { "first.org", true },
  { "first4it.com", true },
  { "firstchoicebouncycastlehire.co.uk", true },
  { "firstchoicecandy.com", true },
  { "firstclasscastles.com", true },
  { "firstclassleisure.co.uk", true },
  { "firstderm.com", true },
  { "firstdry.com.br", true },
  { "firstfinca.de", true },
  { "firstinnovation.co.jp", true },
  { "firstinnovationltd.com", true },
  { "firstmall.de", true },
  { "firstq.xyz", true },
  { "fischer-its.com", false },
  { "fischer-kundendienst.de", true },
  { "fischers.cc", true },
  { "fischers.it", true },
  { "fischers.srv.br", true },
  { "fise.cz", true },
  { "fish-hook.ru", true },
  { "fishbattle.io", true },
  { "fishbattle.net", true },
  { "fishermailbox.net", true },
  { "fishermansbend.apartments", true },
  { "fishermansbendcorporation.com.au", true },
  { "fishermansbendtownhouses.com.au", true },
  { "fishexport.eu", true },
  { "fishgen.no", true },
  { "fishserver.net", true },
  { "fishtacos.blog", true },
  { "fisinfomanagerdr.com", true },
  { "fistu.la", true },
  { "fit-4u.ch", true },
  { "fit-mit-nina.com", true },
  { "fit-mit-system.eu", true },
  { "fit365.jp", true },
  { "fitchannel.com", true },
  { "fitinclass.com", true },
  { "fitkram.cz", true },
  { "fitmeat.at", true },
  { "fitness-challenge.co.uk", true },
  { "fitness.gov", true },
  { "fittelo.cz", true },
  { "fitzsim.org", true },
  { "fiuxy.bz", true },
  { "fiuxy.co", true },
  { "fiuxy.me", true },
  { "fivethirtyeight.com", true },
  { "fixatom.com", true },
  { "fixed.supply", true },
  { "fixel.express", true },
  { "fixforce.nl", true },
  { "fixhotsauce.com", true },
  { "fixingscrews.co.uk", true },
  { "fixitfelix.us", true },
  { "fixlasvegas.com", true },
  { "fixmyalarmpanel.co.uk", true },
  { "fixmycomputerdude.com", true },
  { "fiziktedavi.name.tr", true },
  { "fizyoterapi.name.tr", true },
  { "fizz.buzz", false },
  { "fj.je", true },
  { "fj.search.yahoo.com", false },
  { "fj.simple.com", false },
  { "fjdekermadec.com", true },
  { "fjharcu.com", true },
  { "fjordboge.dk", true },
  { "fjugstad.com", true },
  { "fjzone.org", true },
  { "fkcdn.de", true },
  { "fkfev.de", true },
  { "fktpm.ru", true },
  { "flaemig42.de", false },
  { "flagburningworld.com", true },
  { "flagfox.net", true },
  { "flagshop.jp", true },
  { "flagspot.net", false },
  { "flamer-scene.com", false },
  { "flamero.fi", true },
  { "flamet.eu", true },
  { "flamingkeys.com", true },
  { "flamme-von-anor.de", true },
  { "flana.com", true },
  { "flanga.io", true },
  { "flanga.org", true },
  { "flangaapis.com", true },
  { "flapoverspeed.com", true },
  { "flare.cloud", true },
  { "flashback.org", true },
  { "flashbeing.com", true },
  { "flashcomp.cz", true },
  { "flashgot.net", true },
  { "flat.io", true },
  { "flatmail.pl", true },
  { "flatmatehub.com.au", true },
  { "flatpackmates.co.uk", true },
  { "flauschig.net", true },
  { "flavinus.fr", true },
  { "flaviu.co.uk", true },
  { "flavo.io", true },
  { "flavr.be", true },
  { "flawlesscowboy.xyz", true },
  { "fleep.io", true },
  { "fleesty.dynv6.net", true },
  { "fleetcor.at", true },
  { "fleetcor.ch", true },
  { "fleetcor.cz", true },
  { "fleetcor.de", true },
  { "fleetcor.fr", true },
  { "fleetcor.hu", true },
  { "fleetcor.lu", true },
  { "fleetcor.nl", true },
  { "fleetcor.pl", true },
  { "fleetcor.sk", true },
  { "fleetcorcards.be", true },
  { "fleetsmith.com", true },
  { "fleetssl.com", true },
  { "flehm.de", true },
  { "fleisch.club", true },
  { "flers-agglo.fr", true },
  { "flerstourisme.fr", true },
  { "fletchto99.com", true },
  { "fletemaritimo.online", true },
  { "flets-ms.com", true },
  { "fleurenplume.fr", true },
  { "fleuryfleury.com", true },
  { "flexapplications.se", true },
  { "flexfunding.com", true },
  { "fleximal.com", true },
  { "fleximus.org", false },
  { "flexport.com", true },
  { "flexstart.me", true },
  { "flextrack.dk", true },
  { "fliacuello.com.ar", true },
  { "flickcritter.com", true },
  { "fliesen-waldschmidt.de", true },
  { "flight.school", true },
  { "flightdeckfriend.com", true },
  { "flightmedx.com", true },
  { "flightschoolbooking.com", true },
  { "flightschoolcandidates.gov", true },
  { "flightzero.cf", true },
  { "fliino.com", true },
  { "fliino.eu", true },
  { "fliino.info", true },
  { "fliino.net", true },
  { "fliino.org", true },
  { "fliio.com", true },
  { "flinch.io", true },
  { "flip.kim", true },
  { "flipneus.net", true },
  { "fliptable.org", true },
  { "flirt-norden.de", true },
  { "flirtee.net", true },
  { "flirtfaces.de", true },
  { "flirtos.de", true },
  { "flixports.com", true },
  { "flmortgagebank.com", true },
  { "floatationlocations.com", true },
  { "floaternet.com", true },
  { "flockbox.club", true },
  { "flocktofedora.org", true },
  { "floersheimer-openair.de", true },
  { "floffi.media", true },
  { "floify.com", true },
  { "floj.tech", true },
  { "flokinet.is", true },
  { "floless.co.uk", true },
  { "flomeyer.de", true },
  { "floobits.com", true },
  { "floogulinc.com", true },
  { "floorballpoint.cz", true },
  { "flooringnightmares.com", true },
  { "flooringsourcetx.com", true },
  { "floors4lessbay.com", true },
  { "floort.net", false },
  { "floraclick.net", true },
  { "floraexpress.it", true },
  { "florence.uk.net", true },
  { "florenceapp.co.uk", true },
  { "florent-tatard.fr", true },
  { "florentynadawn.co.uk", true },
  { "floresvilleedc.org", true },
  { "florian-bachelet.fr", true },
  { "florian-thie.de", true },
  { "florian2833z.de", true },
  { "floriankarmen.com", true },
  { "floriankeller.de", true },
  { "florianmitrea.uk", true },
  { "florianschmitt.ca", true },
  { "floriantanner.ch", true },
  { "floridafabrication.net", true },
  { "floridafieros.org", true },
  { "floridagulfbeachrealty.com", true },
  { "floridahomesinvest.com", true },
  { "floridasexhealth.com", true },
  { "florinlungu.it", true },
  { "florismoo.nl", true },
  { "florismouwen.com", false },
  { "florisvdk.net", true },
  { "floriswesterman.nl", true },
  { "flosch.at", false },
  { "floskelwolke.de", true },
  { "flourishtogether.com", true },
  { "flow.su", true },
  { "flowair24.ru", true },
  { "flowcom.de", true },
  { "flowersbylegacy.com", true },
  { "flowinvoice.com", true },
  { "flowreader.com", true },
  { "flra.gov", true },
  { "flucky.xyz", true },
  { "fluffycloud.de", true },
  { "fluggesellschaft.de", true },
  { "fluhrers.de", true },
  { "fluidmeterusa.com", true },
  { "fluids.ac.uk", true },
  { "flumble.nl", true },
  { "flunschi.goip.de", true },
  { "fluoxetine.net", true },
  { "flurp.de", false },
  { "flushlife.com", true },
  { "fluteandpianoteaching.co.uk", true },
  { "flux.by", true },
  { "flux.healthcare", true },
  { "fluxent.de", false },
  { "fluxfingers.net", true },
  { "fluxforge.com", true },
  { "fluxi.fi", true },
  { "fluxoid.com", true },
  { "flw365365.com", true },
  { "fly-en-drive.nl", true },
  { "fly.moe", true },
  { "flyawayantennas.com", true },
  { "flyboyfpv.com", true },
  { "flydrivesicilie.nl", true },
  { "flyer.tools", true },
  { "flygon.pink", true },
  { "flyinglocksmiths.com", true },
  { "flyingpackets.net", true },
  { "flyingrub.me", true },
  { "flymns.fr", true },
  { "flynn.io", true },
  { "flyp.me", true },
  { "flypenge.dk", true },
  { "flyserver.co.il", true },
  { "flyshe.co.uk", true },
  { "flyssh.net", true },
  { "flyswoop.com", true },
  { "flyt.online", true },
  { "flytoadventures.com", true },
  { "fm-cdn.de", true },
  { "fm.ie", true },
  { "fmarchal.fr", true },
  { "fmc.gov", true },
  { "fmdance.cl", true },
  { "fminsight.net", true },
  { "fmodoux.biz", true },
  { "fmussatmd.com", true },
  { "fnanen.net", true },
  { "fnb-griffinonline.com", true },
  { "fnbnokomis.com", true },
  { "fnh-expert.net", true },
  { "fnkr.net", true },
  { "fnof.ch", true },
  { "fnordserver.eu", true },
  { "fnpro.eu", true },
  { "fnzc.co.nz", true },
  { "foairbus.fr", true },
  { "foairbussas.fr", true },
  { "focanamoda.com.br", true },
  { "focusmark.jp", false },
  { "focusministries1.org", true },
  { "focuspointtechnologies.com", true },
  { "foej-aktiv.de", true },
  { "foej.net", true },
  { "fogpublishingph.com", true },
  { "fogway.net", true },
  { "foia.gov", true },
  { "foiaonline.gov", true },
  { "foixet.com", true },
  { "fojing.com", true },
  { "fojt.cz", true },
  { "fojtova.cz", true },
  { "fojtovi.cz", true },
  { "fokan.be", true },
  { "fokep.no", true },
  { "fokkusu.fi", true },
  { "folio.no", true },
  { "foljeton.dk", true },
  { "folk.as", true },
  { "follandviolins.com", true },
  { "followback.net", true },
  { "follower98.ir", true },
  { "followerrocket.com", true },
  { "followersya.com", true },
  { "followings-live.com", true },
  { "followthatpage.com", true },
  { "followthedog.co.uk", true },
  { "foluomeng.net", true },
  { "folv.es", true },
  { "folwark.krakow.pl", true },
  { "fomopop.com", true },
  { "fondationwiggli.ch", true },
  { "fondsdiscountbroker.de", true },
  { "fondy.eu", true },
  { "fondy.ua", true },
  { "fonga.ch", true },
  { "fonolo.com", true },
  { "fonseguin.ca", true },
  { "font-converter.net", true },
  { "fonte-trading.com", true },
  { "fontein.de", true },
  { "fontlibrary.org", true },
  { "fonts4free.net", true },
  { "foo.fo", true },
  { "foo.hamburg", true },
  { "foodattitude.ch", true },
  { "foodblogger.club", true },
  { "foodev.de", true },
  { "foodsafety.gov", true },
  { "foodsafetyjobs.gov", true },
  { "foodsouvenirs.it", true },
  { "foodtable.at", true },
  { "foodwise.marketing", true },
  { "foolip.org", true },
  { "foolwealth.com", true },
  { "foorack.com", true },
  { "fooster.io", true },
  { "foot.fr", true },
  { "footagecrate.com", true },
  { "football.de", true },
  { "footballforum.de", true },
  { "footloose.co.uk", true },
  { "for.care", true },
  { "foray-jero.me", true },
  { "forbusiness.ca", true },
  { "forcelink.eu", true },
  { "forcelinkamerica.com", true },
  { "forcelinkamerica.nl", true },
  { "forces.army", true },
  { "forcewave.com", true },
  { "ford-shop.by", true },
  { "fordlibrarymuseum.gov", true },
  { "foreachcode.com", true },
  { "forecastcity.com", true },
  { "foreclosureattorneyhouston.com", true },
  { "forefrontcloud.com", true },
  { "foregroundweb.com", true },
  { "foreign-language-colleges.com", true },
  { "forellenpark.com", true },
  { "forento.be", true },
  { "foresdon.jp", true },
  { "foresthillhomes.ca", true },
  { "forestraven.net", true },
  { "foreversummertime.com", true },
  { "forewordreviews.com", true },
  { "forex.ee", true },
  { "forexchef.de", true },
  { "forexee.com", true },
  { "forexsignals7.com", true },
  { "forextickler.com", true },
  { "forextimes.ru", false },
  { "forfunssake.co.uk", true },
  { "forge-goerger.eu", true },
  { "forgotten-legends.org", true },
  { "form3w.nl", true },
  { "formacionyestudios.com", true },
  { "forman.store", true },
  { "formapi.io", true },
  { "format-paysage.ch", true },
  { "formation-assureur.com", true },
  { "formation-mac.ch", true },
  { "formationseeker.com", true },
  { "formini.dz", true },
  { "formsbyair.com", true },
  { "formula-ot.ru", true },
  { "formulacionquimica.com", true },
  { "formulastudent.de", true },
  { "fornoreason.net.au", true },
  { "fornwall.net", true },
  { "foro.io", false },
  { "forodeespanol.com", true },
  { "forodieta.com", true },
  { "forokd.com", true },
  { "forologikidilosi.com.gr", true },
  { "forourselves.com", true },
  { "forpc.us", true },
  { "forrestheller.com", true },
  { "forro.berlin", true },
  { "forro.info", true },
  { "forsakringsarkivet.se", true },
  { "forschbach-janssen.de", true },
  { "forsec.nl", true },
  { "forstbetrieb-hennecke.de", true },
  { "forstprodukte.de", true },
  { "forteggz.nl", true },
  { "fortesanshop.it", true },
  { "fortnine.ca", true },
  { "fortnitemagic.ga", true },
  { "fortran.io", true },
  { "fortress.no", true },
  { "fortress.sk", true },
  { "fortuna-apotheke-lahnstein.de", true },
  { "forty-two.nl", true },
  { "forty8creates.com", true },
  { "fortytwo.cloud", true },
  { "forum-bonn.de", true },
  { "forum-heg.ch", true },
  { "forum-kinozal-tv.appspot.com", true },
  { "forum-kinozal.appspot.com", true },
  { "forum.quantifiedself.com", false },
  { "forum3.ru", true },
  { "forumvoordemocratie.nl", true },
  { "forvisualdesign.com", true },
  { "forward-fly-fishing.ch", true },
  { "foryouandyourcustomers.com", true },
  { "foryourhealthybody.com", true },
  { "fosaudit.com", true },
  { "foscamcanada.com", true },
  { "fosdem.org", true },
  { "foshanshequ.com", false },
  { "fossforward.com", true },
  { "fossilfreeyale.org", true },
  { "fotella.com", true },
  { "fotikpro.ru", true },
  { "foto-janvanaefst.nl", true },
  { "foto-leistenschneider.de", true },
  { "foto-leitner.com", true },
  { "foto-leitner.de", true },
  { "foto-robitsch.at", true },
  { "foto-roma.ru", true },
  { "foto.by", true },
  { "fotoboxvysocina.cz", true },
  { "fotofaerie.net", true },
  { "fotoflits.net", true },
  { "fotografechristha.nl", true },
  { "fotografiadellalucerossa.com", true },
  { "fotografiamakro.pl", true },
  { "fotohome.dk", true },
  { "fotokomorkomania.pl", true },
  { "fotoleitner.com", true },
  { "fotoleitner.de", true },
  { "fotonjan.com", true },
  { "fotostudio-leitner.com", true },
  { "fotostudio-leitner.de", true },
  { "fotostudio-schweiz.ch", true },
  { "fotowettbewerb.co", true },
  { "fotowolfy.com", true },
  { "fougner.co", true },
  { "found.website", true },
  { "foundationrepairnebraska.com", true },
  { "foundationspecialisteast.com", true },
  { "foundationspecialistmi.com", true },
  { "foundchurch.co.uk", true },
  { "foundsounds.me", true },
  { "fourashesgolfcentre.co.uk", true },
  { "fourashesgolfcentre.com", true },
  { "fourashesgolfcentre.uk", true },
  { "fourdesignstudio.com", true },
  { "foutrelis.com", true },
  { "fowlervwparts.com", true },
  { "fowlsmurf.net", true },
  { "foxbnc.co.uk", true },
  { "foxdev.co", true },
  { "foxesare.sexy", true },
  { "foxing.club", true },
  { "foxo.blue", true },
  { "foxontheinter.net", true },
  { "foxphotography.ch", true },
  { "foxquill.com", true },
  { "foxstreetcomms.co.za", true },
  { "fpaci.org", true },
  { "fpc.gov", false },
  { "fpersona.com", true },
  { "fpgradosuperior.com", true },
  { "fpsclasico.de", true },
  { "fpt-technojapan.com", true },
  { "fptravelling.com", false },
  { "fpvr.org", true },
  { "fpy.cz", true },
  { "fq.mk", true },
  { "fr.search.yahoo.com", false },
  { "fr33tux.org", true },
  { "frack.nl", true },
  { "fracreazioni.it", true },
  { "fraesentest.de", true },
  { "fragmentspuren.de", true },
  { "fragstore.net", true },
  { "fraho.eu", true },
  { "framapiaf.org", true },
  { "framboise314.fr", true },
  { "framedpaws.com", true },
  { "framezdakkapellen.nl", true },
  { "fran.cr", true },
  { "francescopalazzo.com", true },
  { "francescopandolfibalbi.it", true },
  { "francescoservida.ch", true },
  { "francetraceur.fr", true },
  { "franchini.email", true },
  { "franchini.engineer", true },
  { "francis.tokyo", true },
  { "francisli.net", false },
  { "franckgirard.net", true },
  { "franckyz.com", true },
  { "francois-gaillard.fr", true },
  { "francois-occasions.be", true },
  { "francoisbelangerboisclair.com", true },
  { "francoiscarrier.com", true },
  { "francoise-paviot.com", true },
  { "francoisharvey.ca", true },
  { "francoislepage.com", true },
  { "francoz.me", true },
  { "frandor.co.uk", true },
  { "frank.fyi", true },
  { "frankbellamy.co.uk", true },
  { "franke-chemie.de", true },
  { "franken-lehrmittel.de", true },
  { "frankenhost.de", true },
  { "frankenlehrmittel.de", true },
  { "frankhaala.com", true },
  { "frankierfachmann.de", true },
  { "frankierprofi.de", true },
  { "frankierstar.de", true },
  { "frankinteriordesign.co.uk", true },
  { "frankl.in", true },
  { "frankmorrow.com", true },
  { "frankopol-sklep.pl", true },
  { "frankpalomeque.com", true },
  { "franksiler.com", true },
  { "frankslaughterinsurance.com", true },
  { "frankwei.xyz", true },
  { "frankyan.com", true },
  { "frantic1048.com", true },
  { "franz-vatter.de", true },
  { "franz.beer", true },
  { "franziska-pascal.de", true },
  { "franzknoll.de", true },
  { "frappant.cc", true },
  { "fraselab.ru", true },
  { "frasesconemocion.com", true },
  { "frasesdodia.com", true },
  { "frasesparaface.com.br", true },
  { "frasesytarjetas.com", true },
  { "frasys.net", true },
  { "frattaroli.org", true },
  { "frau-inge.de", true },
  { "frau-sucht-bauer.de", true },
  { "fraudmarc.com", true },
  { "frauenarzt-niendorf.de", true },
  { "frauenarzt-zinke.de", true },
  { "frauenlob.rocks", true },
  { "fraurichter.net", true },
  { "fraye.net", true },
  { "frbracch.it", true },
  { "frccsgo.tk", true },
  { "frdl.ch", true },
  { "freaksites.dk", true },
  { "freaksports.com.au", true },
  { "freakyaweso.me", true },
  { "freakyawesome.band", true },
  { "freakyawesome.blog", true },
  { "freakyawesome.club", true },
  { "freakyawesome.co", true },
  { "freakyawesome.company", true },
  { "freakyawesome.email", true },
  { "freakyawesome.events", true },
  { "freakyawesome.fashion", true },
  { "freakyawesome.fitness", true },
  { "freakyawesome.fm", true },
  { "freakyawesome.fun", true },
  { "freakyawesome.fyi", true },
  { "freakyawesome.games", true },
  { "freakyawesome.guide", true },
  { "freakyawesome.guru", true },
  { "freakyawesome.info", true },
  { "freakyawesome.io", true },
  { "freakyawesome.life", true },
  { "freakyawesome.live", true },
  { "freakyawesome.marketing", true },
  { "freakyawesome.me", true },
  { "freakyawesome.media", true },
  { "freakyawesome.network", true },
  { "freakyawesome.news", true },
  { "freakyawesome.online", true },
  { "freakyawesome.org", true },
  { "freakyawesome.photography", true },
  { "freakyawesome.photos", true },
  { "freakyawesome.press", true },
  { "freakyawesome.recipes", true },
  { "freakyawesome.rentals", true },
  { "freakyawesome.reviews", true },
  { "freakyawesome.services", true },
  { "freakyawesome.shop", true },
  { "freakyawesome.site", true },
  { "freakyawesome.social", true },
  { "freakyawesome.software", true },
  { "freakyawesome.solutions", true },
  { "freakyawesome.store", true },
  { "freakyawesome.team", true },
  { "freakyawesome.tips", true },
  { "freakyawesome.today", true },
  { "freakyawesome.tours", true },
  { "freakyawesome.tv", true },
  { "freakyawesome.video", true },
  { "freakyawesome.website", true },
  { "freakyawesome.work", true },
  { "freakyawesome.world", true },
  { "freakyawesome.xyz", true },
  { "frebi.org", true },
  { "frebib.co.uk", true },
  { "frebib.com", true },
  { "frebib.net", true },
  { "freddieonfire.tk", false },
  { "freddyfazbearspizzeria.com", true },
  { "freddysfuncastles.co.uk", true },
  { "fredericcote.com", true },
  { "frederik-braun.com", false },
  { "frederikvig.com", true },
  { "fredloya.com", true },
  { "fredriksslaktforskning.se", true },
  { "fredtec.ru", true },
  { "fredvoyage.fr", true },
  { "free-ss.site", true },
  { "free.ac.cn", true },
  { "free.com.tw", true },
  { "freeasyshop.com", true },
  { "freebarrettbrown.org", true },
  { "freebcard.com", true },
  { "freebetoffers.co.uk", true },
  { "freebookmakersbetsandbonuses.com.au", true },
  { "freeboson.org", true },
  { "freebus.org", true },
  { "freecam2cam.site", true },
  { "freecloud.at", true },
  { "freecookies.nl", true },
  { "freecycleusa.com", true },
  { "freedev.cz", true },
  { "freedom.nl", true },
  { "freedom.press", true },
  { "freedom35.org", true },
  { "freedomfinance.se", true },
  { "freedomflotilla.org", true },
  { "freedomfrontier.tk", true },
  { "freedomkiaparts.com", true },
  { "freedomonline.bg", true },
  { "freedomrahoitus.fi", true },
  { "freeenglishhelp.com", true },
  { "freeform4u.de", true },
  { "freegame-mugen.jp", true },
  { "freegutters.com", true },
  { "freeiconspng.com", true },
  { "freeinoutboard.com", true },
  { "freejasongoudlock.org", true },
  { "freejeremy.net", true },
  { "freela.ch", true },
  { "freelance.boutique", true },
  { "freelance.guide", true },
  { "freelance.nl", true },
  { "freelanceessaywriters.com", true },
  { "freelancehunt.com", true },
  { "freelauri.com", true },
  { "freelifer.jp", true },
  { "freelo.cz", true },
  { "freelysurf.cf", true },
  { "freemania.eu", true },
  { "freemania.nl", true },
  { "freemanlogistics.com", true },
  { "freemans.com", true },
  { "freemomhugs.org", true },
  { "freemyipod.org", true },
  { "freend.me", false },
  { "freenetproject.org", true },
  { "freeonplate.com", true },
  { "freepnglogos.com", true },
  { "freepoints.us", true },
  { "freepublicprofile.com", true },
  { "freergform.org", true },
  { "freeshell.de", true },
  { "freeshkre.li", true },
  { "freesitemapgenerator.com", true },
  { "freesms-online.de", true },
  { "freesnowden.is", true },
  { "freesoft-board.to", true },
  { "freesoftlab.com", true },
  { "freesolitaire.win", true },
  { "freesourcestl.org", true },
  { "freesquare.net", true },
  { "freessl.tech", true },
  { "freesslcertificate.me", true },
  { "freethetv.ie", true },
  { "freetsa.org", true },
  { "freevps.us", false },
  { "freeweibo.com", true },
  { "freeyourmusic.com", true },
  { "freezion.com", true },
  { "frei.social", true },
  { "freie-software.net", true },
  { "freifahrt.de", true },
  { "freifamily.ch", true },
  { "freifunk-burgaltendorf.de", true },
  { "freifunk-essen.de", true },
  { "freifunk-in-solingen.de", true },
  { "freifunk-lindlar.net", true },
  { "freifunk-luenen.de", true },
  { "freifunk-nrw.de", true },
  { "freifunk-remscheid.de", true },
  { "freimeldungen.de", true },
  { "freims.cc", true },
  { "freitasul.com.br", true },
  { "freitasul.io", true },
  { "freiwurst.net", true },
  { "freizeitbad-riff.de", true },
  { "freizeitplaza.de", true },
  { "frejasdal.dk", true },
  { "frenchcreekcog.org", true },
  { "frenchmusic.fr", true },
  { "frequencebanane.ch", true },
  { "frequentflyerapp.com", true },
  { "fresh-hotel.org", true },
  { "fresh-networks.net", true },
  { "fresh.co.il", true },
  { "freshdesigns.de", true },
  { "freshdns.nl", true },
  { "freshempire.gov", true },
  { "freshislandfish.com", true },
  { "freshlymind.com", true },
  { "freshmaza.net", true },
  { "fretscha.com", true },
  { "frettirnar.is", true },
  { "fretworksec.com", true },
  { "freundinnen-ausflug.de", true },
  { "freundinnen-kurzurlaub.de", true },
  { "freundinnen-urlaub.de", true },
  { "friarsonbase.com", true },
  { "fribourgviking.net", true },
  { "frickelboxx.de", true },
  { "frickelmeister.de", true },
  { "fridayfoucoud.ma", true },
  { "fridolinka.cz", true },
  { "friedenauer-herbstfest.de", true },
  { "friederes.lu", true },
  { "friederloch.de", true },
  { "friedrich-foto-art.de", true },
  { "friedsamphotography.com", true },
  { "friendowment.us", true },
  { "friends-of-naz.com", true },
  { "friends-socialgroup.org", true },
  { "friends24.cz", true },
  { "friendship-quotes.co.uk", true },
  { "friendshipismagicsquad.com", true },
  { "friendsofgfwpc.org", true },
  { "frieslandrail.nl", true },
  { "friet.org", true },
  { "frietbesteld.nl", true },
  { "friezy.ru", true },
  { "frigi.ch", true },
  { "frigolit.net", true },
  { "frillip.com", true },
  { "fringeintravel.com", true },
  { "frinkiac.com", true },
  { "frino.de", true },
  { "frippz.se", true },
  { "friss.com", true },
  { "fritzrepair.com", true },
  { "frizo.com", true },
  { "frly.de", true },
  { "frob.nl", true },
  { "froehliche-hessen.de", true },
  { "frogatto.com", true },
  { "frogeye.fr", true },
  { "froggitt.com", true },
  { "frogsonamission.de", true },
  { "froh.co.jp", true },
  { "frolova.org", true },
  { "from-the-net.com", true },
  { "fromscratch.rocks", true },
  { "fronteers.nl", false },
  { "frontier-ad.co.jp", true },
  { "frontier.bet", true },
  { "frontiers.nl", true },
  { "frontlinemessenger.com", true },
  { "fropky.com", true },
  { "frostprotection.co.uk", true },
  { "frostwarning.com", true },
  { "frostysummers.com", true },
  { "frothy.coffee", true },
  { "froufe.com", true },
  { "frownonline.co.uk", true },
  { "frozen-geek.net", true },
  { "frozen-solid.net", true },
  { "frozenjam.com", true },
  { "frpg.gov", true },
  { "frprn.es", true },
  { "frtn.com", true },
  { "frtr.gov", true },
  { "frtrains.com", true },
  { "fruchthof24.de", true },
  { "fruchtikus.net", true },
  { "fruend-hausgeraeteshop.de", true },
  { "frugalfamilyhome.com", true },
  { "frugalmechanic.com", true },
  { "frugro.be", true },
  { "fruition.co.jp", true },
  { "fruitscale.com", true },
  { "frusky.de", true },
  { "fruttini.de", true },
  { "frydrychit.cz", true },
  { "fs-community.nl", true },
  { "fs-g.org", true },
  { "fs-maistadt.de", true },
  { "fs257.com", true },
  { "fsapubs.gov", false },
  { "fsbn.eu", true },
  { "fsbnh.bank", true },
  { "fsbpaintrock.com", true },
  { "fsbturton.com", true },
  { "fsck.cz", true },
  { "fsck.jp", true },
  { "fsckd.com", true },
  { "fscott.de", true },
  { "fsdress.com", true },
  { "fsfxpackages.com", true },
  { "fsg.one", true },
  { "fsk.fo", true },
  { "fsky.info", true },
  { "fsm2016.org", true },
  { "fsps.ch", true },
  { "fsstyle.com", true },
  { "fsty.uk", true },
  { "fsvt.ch", true },
  { "ft.com", false },
  { "ftc.gov", false },
  { "ftccomplaintassistant.gov", true },
  { "ftcefile.gov", true },
  { "ftf.agency", true },
  { "fthat.link", true },
  { "ftng.se", true },
  { "ftptest.net", true },
  { "ftrsecure.com", true },
  { "ftv.re", true },
  { "fu898.top", true },
  { "fuantaishenhaimuli.net", true },
  { "fuck-your-false-positive.de", true },
  { "fuckav.ru", true },
  { "fuckcie.com", true },
  { "fucklife.ch", true },
  { "fuckonthefirst.date", true },
  { "fuckup.dk", true },
  { "fuckyoupaypal.me", true },
  { "fuechschen.org", true },
  { "fuelfirebrand.com", true },
  { "fuelingyourdreams.com", true },
  { "fuerstenfelder-immobilien.de", true },
  { "fuglede.dk", true },
  { "fuite.ch", true },
  { "fuites.ch", true },
  { "fujiwaraqol.com", true },
  { "fukakukeiba.com", true },
  { "fukikaeru.com", true },
  { "fukuiedu.com", true },
  { "fukushimacoffee.com", true },
  { "fulfilmentcrowd.com", true },
  { "fulgenzis.com", true },
  { "fuliwang.info", true },
  { "fuliwang.us", true },
  { "full-race.com", true },
  { "full-stack.ninja", true },
  { "fullautomotivo.com.br", true },
  { "fullbundle.com", true },
  { "fullereno.com", true },
  { "fullerlife.org.uk", true },
  { "fullhost.com", true },
  { "fullhub.ru", true },
  { "fullmatch.net", true },
  { "fullstack.love", true },
  { "fullstacknotes.com", true },
  { "fumblers.ca", true },
  { "fumerolles.ch", true },
  { "fumo.se", false },
  { "fun-bounce.co.uk", true },
  { "fun-tasia.co.uk", true },
  { "fun4kidzbouncycastles.co.uk", true },
  { "fun4tomorrow.com", true },
  { "fun4ubouncycastles.co.uk", true },
  { "fun888city.com", true },
  { "fun888city.net", true },
  { "funadvisor.ca", true },
  { "funadvisorfrance.com", true },
  { "funandbounce.com", true },
  { "funatic.nl", true },
  { "funbouncelincs.co.uk", true },
  { "funchestra.at", false },
  { "functional.cc", true },
  { "functions-online.com", true },
  { "fundays.nl", true },
  { "fundchan.com", true },
  { "fundeego.com", true },
  { "fundingempire.com", true },
  { "fundort.ch", true },
  { "funds.ddns.net", true },
  { "funfactorleeds.co.uk", true },
  { "funfair.io", true },
  { "funfoodco.co.uk", true },
  { "funfunmstdn.tokyo", true },
  { "fungames.com", true },
  { "funhouse-inflatables.co.uk", true },
  { "funinbeds.org.uk", true },
  { "funken-networks.de", true },
  { "funkner.ru", true },
  { "funktionel.co", true },
  { "funktionsverket.se", true },
  { "funkygamer1.de", true },
  { "funniestclip.com", true },
  { "funnybikini.com", true },
  { "funsochi.ru", true },
  { "funspins.com", true },
  { "funtasticinflatablesdurham.co.uk", true },
  { "funtime-inflatables.co.uk", true },
  { "funtime.com.ua", true },
  { "funtime.kiev.ua", true },
  { "funtimeentertainment.co.uk", true },
  { "funtimesbouncycastles.co.uk", true },
  { "fur.red", true },
  { "furaje-iasi.com", true },
  { "furcdn.net", true },
  { "furcity.me", true },
  { "furgo.love", true },
  { "furigana.info", true },
  { "furkancaliskan.com", true },
  { "furkot.com", true },
  { "furkot.de", true },
  { "furkot.es", true },
  { "furkot.fr", true },
  { "furkot.it", true },
  { "furkot.pl", true },
  { "furlan.co", true },
  { "furlog.it", true },
  { "furnfurs.com", true },
  { "furnishedproperty.com.au", true },
  { "furry.cat", true },
  { "furry.dk", true },
  { "furrybot.me", true },
  { "furrytech.network", true },
  { "furrytf.club", true },
  { "furryyiff.site", true },
  { "fursuitbutts.com", true },
  { "fusa-miyamoto.jp", true },
  { "fuselight.nl", true },
  { "fuseos.net", true },
  { "fushee.com", true },
  { "fusiongaming.de", true },
  { "fussball-xxl.de", true },
  { "fussell.io", true },
  { "futa.moe", true },
  { "futaba-works.com", true },
  { "futagro.com", true },
  { "futbomb.com", true },
  { "futcre.com", true },
  { "futrou.com", true },
  { "future-moves.com", true },
  { "futureaudiographics.com", true },
  { "futurefund.com", true },
  { "futuregrowthva.com", true },
  { "futurehack.io", true },
  { "futurenda.com", true },
  { "futureoceans.org", true },
  { "futuretimes.io", true },
  { "futurezone.at", true },
  { "futurope.com", true },
  { "fuwafuwa.moe", true },
  { "fuyu.moe", true },
  { "fuzzing-project.org", true },
  { "fveevaete.com", true },
  { "fwdx.net", true },
  { "fwest.ovh", true },
  { "fwest98.nl", true },
  { "fwest98.ovh", true },
  { "fx-rk.com", true },
  { "fx24.uk", true },
  { "fx5.de", true },
  { "fxislamic.com", true },
  { "fxmarketing.com.au", true },
  { "fxmarketing.net.au", true },
  { "fxopen.co.uk", true },
  { "fxopen.com", true },
  { "fxopen.com.au", true },
  { "fxopen.com.br", true },
  { "fxopen.com.mx", true },
  { "fxopen.my", true },
  { "fxopen.ru", true },
  { "fxp.co.il", true },
  { "fxseo.com.au", true },
  { "fxtalk.cn", true },
  { "fxthai.com", true },
  { "fxtrade-lab.com", true },
  { "fxweb.co", true },
  { "fxwebsites.com.au", true },
  { "fxwebsites.net.au", true },
  { "fxwebstudio.net.au", true },
  { "fydjbsd.cn", true },
  { "fyfywka.com", true },
  { "fyksen.me", true },
  { "fyn.nl", true },
  { "fyol.xyz", false },
  { "fyreek.me", true },
  { "fyretrine.com", true },
  { "fysesbjerg.dk", true },
  { "fysio123.nl", true },
  { "fysiomassageoosterhout.nl", true },
  { "fysiotherapieapeldoornzuid.nl", true },
  { "fysiotherapieholtenbroek.nl", true },
  { "fysiotherapienieuwveen.nl", true },
  { "fysiovdberg.nl", true },
  { "fysuite.com", true },
  { "fytcart.com", true },
  { "fzbrweb.cz", true },
  { "fzhyzamt.com", true },
  { "fzx750.ru", true },
  { "g-ds.de", true },
  { "g-m-w.eu", true },
  { "g-p-design.com", true },
  { "g-rom.net", true },
  { "g.co", true },
  { "g0881.com", true },
  { "g0man.com", true },
  { "g1.ie", true },
  { "g10e.ch", true },
  { "g2links.com", true },
  { "g2pla.net", true },
  { "g2ship.com", true },
  { "g2soft.net", true },
  { "g3d.ro", true },
  { "g3dev.ch", true },
  { "g3rv4.com", true },
  { "g4w.co", true },
  { "g5.gov", true },
  { "g6666g.tk", true },
  { "g8energysolutions.co.uk", true },
  { "gaaz.fr", true },
  { "gabe565.com", true },
  { "gabeb1920.com", true },
  { "gabecook.com", true },
  { "gabemack.com", true },
  { "gabinetpsychoterapii.krakow.pl", true },
  { "gabriel.to", true },
  { "gabriele.tips", true },
  { "gabrielsteens.nl", true },
  { "gachimuchi.ru", true },
  { "gachiyase.com", true },
  { "gachter.name", true },
  { "gadabit.pl", true },
  { "gadgethacks.com", true },
  { "gadse.games", true },
  { "gae123.com", true },
  { "gaengler.com", true },
  { "gaest.com", true },
  { "gaestehaus-monika.com", true },
  { "gaetanosonline.com", true },
  { "gaff-rig.co.uk", true },
  { "gaflooring.com", true },
  { "gafunds.com", true },
  { "gagliarducci.it", true },
  { "gagne-enterprises.com", true },
  { "gagne.tk", true },
  { "gagnerplusdargent.info", true },
  { "gagniard.org", true },
  { "gagor.pl", true },
  { "gagygnole.ch", true },
  { "gaiavanderzeyp.com", true },
  { "gaichon.com", true },
  { "gailfellowsphotography.com", true },
  { "gaines-sodiamex.fr", true },
  { "gaio-automobiles.fr", true },
  { "gaireg.de", true },
  { "gaitandmobility.com", true },
  { "gaitrehabilitation.com", true },
  { "gaitresearch.com", true },
  { "gakkainavi-epsilon.jp", true },
  { "gakkainavi-epsilon.net", true },
  { "gakkainavi.jp", true },
  { "gakkainavi4.jp", true },
  { "gakkainavi4.net", true },
  { "gaku-architect.com", true },
  { "gala.kiev.ua", false },
  { "galabau-maurmann.de", true },
  { "galacg.me", true },
  { "galactic-crew.org", true },
  { "galak.ch", true },
  { "galanight.cz", true },
  { "galaxy.edu.pe", true },
  { "galecia.com", true },
  { "galeria42.com", true },
  { "galerialottus.com.br", true },
  { "galeriarr.pl", true },
  { "galeriart.xyz", true },
  { "galeries.photo", true },
  { "galilahiskye.com", true },
  { "galileanhome.org", true },
  { "galilel.cloud", true },
  { "galinas-blog.de", true },
  { "galinos.gr", true },
  { "galle.cz", true },
  { "gallerify.eu", true },
  { "galletasgabi.com.mx", false },
  { "galleyfoods.com", true },
  { "gallicrooster.com", true },
  { "gallifreyapp.co.uk", true },
  { "gallifreypermaculture.com.au", true },
  { "gallun-shop.com", true },
  { "galpaoap.com.br", true },
  { "gamberorosso.menu", true },
  { "gambetti.fr", true },
  { "gambit.pro", true },
  { "gambitboard.com", true },
  { "gambitnash.co.uk", true },
  { "gambitnash.com", true },
  { "gambitprint.com", true },
  { "gamblerhealing.com", true },
  { "gamblersgaming.eu", true },
  { "game4less.com", true },
  { "game7.de", true },
  { "game88city.net", true },
  { "gameanalytics.com", true },
  { "gameblabla.nl", true },
  { "gamebrott.com", true },
  { "gamecard-shop.nl", true },
  { "gamechefpummarola.eu", true },
  { "gameclue.jp", true },
  { "gamecollector.be", true },
  { "gameconservation.org.uk", true },
  { "gamedevelopers.pl", true },
  { "gamegix.com", true },
  { "gameguardian.net", true },
  { "gameindustry.de", true },
  { "gameisbest.jp", true },
  { "gamekaitori.jp", true },
  { "gamekeepers.cz", true },
  { "gamemodding.com", true },
  { "gamenerd.net", true },
  { "gamepad.com.br", true },
  { "gameplaysforkids.com", true },
  { "gamepreorders.com", true },
  { "gamequest.info", true },
  { "gamer-portal.com", true },
  { "gamercredo.com", true },
  { "gamereader.de", true },
  { "gamerezo.com", true },
  { "gamerzdot.com", true },
  { "games4theworld.org", true },
  { "gamesaviour.com", true },
  { "gamesdepartment.co.uk", true },
  { "gameserver-sponsor.me", true },
  { "gameshowchallenge.ie", true },
  { "gamesided.com", true },
  { "gamesplanet.com", true },
  { "gamesputnik.ru", true },
  { "gamestats.gg", true },
  { "gametilt.com", true },
  { "gametube.website", true },
  { "gamilab.com", true },
  { "gamilab.no", true },
  { "gamingexodus.com", true },
  { "gamingmedley.com", true },
  { "gamingrealms.net", true },
  { "gamingwithcromulent.com", true },
  { "gamingzoneservers.com", true },
  { "gamishou.fr", true },
  { "gamismodernshop.com", true },
  { "gamismurahonline.com", true },
  { "gamivo.com", true },
  { "gamoloco.com", true },
  { "gan.wtf", true },
  { "ganado.org", true },
  { "ganaenergia.com", true },
  { "ganasoku.net", true },
  { "gancedo.com.es", true },
  { "gandalfservice.com", true },
  { "gandalfthefeline.com", true },
  { "gandc.co", false },
  { "gandgliquors.com", true },
  { "ganggalbichler.at", true },
  { "gansleit.com", false },
  { "ganztagplus.de", true },
  { "gao.ci", true },
  { "gao.rocks", true },
  { "gaojianli.me", true },
  { "gaojianli.tk", true },
  { "gaos.org", true },
  { "gapdirect.com", true },
  { "gapfa.org", true },
  { "gaphag.ddns.net", true },
  { "garage-leone.com", true },
  { "garage-meynard.com", true },
  { "garagedejan.ch", true },
  { "garageenginuity.com", true },
  { "garagegoossens.be", true },
  { "garagemhermetica.org", true },
  { "garagevanhulle-used.be", true },
  { "garanteasy.com", true },
  { "garbomuffin.com", true },
  { "garciagerman.com", true },
  { "garda-see.mobi", true },
  { "gardedenfantspourtous.fr", true },
  { "gardengameshireuk.com", true },
  { "garderobche.eu", true },
  { "gardikagigih.com", true },
  { "gardinte.com", true },
  { "gardis.ua", true },
  { "garedtech.com", false },
  { "garethbowker.com", true },
  { "garethkirk.com", true },
  { "garethkirkreviews.com", true },
  { "garethrhugh.es", true },
  { "garforthgolfclub.co.uk", true },
  { "gargazon.net", true },
  { "garnuchbau.de", true },
  { "garron.net", true },
  { "garrowmediallc.com", true },
  { "gartenbaur.de", true },
  { "gartenplanung-brendes.de", true },
  { "garycarmell.com", true },
  { "garycwaite.com", true },
  { "garyjones.co.uk", true },
  { "garyrh.com", true },
  { "garystallman.com", true },
  { "garyswine.com", true },
  { "garywhittington.com", true },
  { "gashalot.com", true },
  { "gastoudererenda.nl", true },
  { "gastromedicalcenter.com.br", true },
  { "gastrotiger.at", true },
  { "gastrotiger.de", true },
  { "gate2home.com", true },
  { "gateaucreation.fr", true },
  { "gatekiller.co.uk", true },
  { "gatewaybridal.com", true },
  { "gatewaybronco.com", true },
  { "gauche.com", true },
  { "gaudeamus-folklor.cz", true },
  { "gaudere.co.jp", true },
  { "gaurl.ga", true },
  { "gaussianwaves.com", true },
  { "gauthier.dk", true },
  { "gautvedt.no", true },
  { "gavins.stream", true },
  { "gavinsblog.com", true },
  { "gawrimanecuta.com", true },
  { "gaycc.cc", true },
  { "gaymerconnect.net", true },
  { "gaymerx.com", true },
  { "gaymerx.net", true },
  { "gaymerx.org", true },
  { "gaysexpositions.guide", true },
  { "gayukai.net", true },
  { "gazachallenge.org", true },
  { "gazellegames.net", false },
  { "gazete.org", true },
  { "gazette.govt.nz", true },
  { "gbc-radio.nl", true },
  { "gbcsummercamps.com", true },
  { "gbl.selfip.net", true },
  { "gboys.net", true },
  { "gc-mc.de", true },
  { "gc.gy", true },
  { "gc.ru.net", true },
  { "gcbit.dk", true },
  { "gcfadvisors.com", true },
  { "gcgeeks.com.au", true },
  { "gcguild.net", true },
  { "gchq.wtf", true },
  { "gcoded.de", true },
  { "gcs-ventures.com", true },
  { "gcsepod.com", true },
  { "gdax.com", true },
  { "gdb-tutorial.net", true },
  { "gdgrzeszow.pl", true },
  { "gdhzcgs.com", true },
  { "gdiary.net", true },
  { "gdngs.de", true },
  { "gdoce.es", true },
  { "gdpr-pohotovost.cz", true },
  { "gdv.me", true },
  { "gdz-spishy.com", true },
  { "gdz.tv", true },
  { "ge3k.net", false },
  { "gear4you.shop", true },
  { "gearallnews.com", true },
  { "gearboxhero.com", true },
  { "gearev.net", true },
  { "gearfinder.nl", true },
  { "gearset.com", true },
  { "geba-online.de", true },
  { "gebn.co.uk", true },
  { "gebn.uk", true },
  { "geboortestoeltje.com", true },
  { "geborgen-wachsen.de", true },
  { "gebruikershandleiding.com", true },
  { "gecem.org", true },
  { "gechr.io", true },
  { "geckler-ee.de", true },
  { "geder.at", true },
  { "gedlingcastlehire.co.uk", true },
  { "gedlingtherapy.co.uk", true },
  { "gee.is", true },
  { "geecrat.com", true },
  { "geek-hub.de", true },
  { "geek.ch", true },
  { "geek1.de", true },
  { "geekabit.nl", true },
  { "geekandi.com", true },
  { "geekariom.com", true },
  { "geekclubbooks.com", true },
  { "geeklair.net", true },
  { "geeklan.co.uk", true },
  { "geekles.net", true },
  { "geeknik.com", true },
  { "geekpad.com", true },
  { "geekshirts.cz", true },
  { "geektopia.es", true },
  { "geekwhack.org", true },
  { "geekwithabudget.com", true },
  { "geekwu.org", true },
  { "geekz.sk", true },
  { "geekzone.co.nz", true },
  { "geekzone.fr", true },
  { "geeq.ch", true },
  { "geerdsen.net", true },
  { "geertdegraaf.nl", true },
  { "geertswei.nl", true },
  { "gegeco.ch", true },
  { "geh.li", true },
  { "gehaowu.com", true },
  { "gehas-wein-shop.de", true },
  { "gehirn.co.jp", true },
  { "gehirn.jp", true },
  { "gehopft.de", true },
  { "gehreslaw.com", true },
  { "gehrke.in", true },
  { "gehsicht.de", true },
  { "geigenbauer.in", false },
  { "geiser-family.ch", true },
  { "geisser-elektronikdata.de", true },
  { "gelb-computer.de", true },
  { "geld-im-blick.de", true },
  { "geld24.nl", true },
  { "geldimblick.de", true },
  { "geleenbeekdal.nl", true },
  { "geleia-real.com", true },
  { "gelis.ch", true },
  { "gelodosul.com.br", true },
  { "gelog-software.de", false },
  { "gelonghui.com", true },
  { "geloofindemocratie.nl", false },
  { "geluidsstudio.com", true },
  { "geluk.io", true },
  { "gem-indonesia.net", false },
  { "gemeentemolenwaard.nl", true },
  { "gemeinsam-ideen-verwirklichen.de", true },
  { "gemgroups.in", true },
  { "gemini.com", true },
  { "gemquery.com", true },
  { "genbright.com", true },
  { "genchev.io", true },
  { "gencmedya.com", true },
  { "genderidentiteit.nl", true },
  { "gendrin.com", true },
  { "gendundrupa.ch", true },
  { "gene-drive.com", true },
  { "gene-drives.com", true },
  { "genealorand.com", true },
  { "geneau.net", true },
  { "genehightower.com", true },
  { "genehome.com.au", true },
  { "generace-id.org", true },
  { "generador-electrico.com", true },
  { "general-anaesthesia.com", true },
  { "general-anaesthetics.com", true },
  { "general-anesthesia.com", true },
  { "generali-worldwide.com", true },
  { "generalinsuranceservices.com", true },
  { "generationgoat.com", true },
  { "generationsweldom.com", true },
  { "generator.creditcard", true },
  { "generic.cx", true },
  { "genesiseureka.com", true },
  { "genesismachina.ca", true },
  { "genesistrading.com", true },
  { "genesysmi.com", true },
  { "genetargetsolutions.com.au", true },
  { "genetidyne.com", true },
  { "genevachauffeur.com", true },
  { "geneve-naturisme.ch", true },
  { "genevoise-entretien.ch", true },
  { "genfaerd.dk", true },
  { "geniush.ovh", true },
  { "geniushost.in", true },
  { "geniusteacher.in", true },
  { "geniuszone.biz", true },
  { "genocidediary.org", true },
  { "genodeftest.de", true },
  { "genome.gov", true },
  { "genomequestlive.com", true },
  { "genosse-einhorn.de", true },
  { "genoveve.de", true },
  { "gensend.com", true },
  { "gensenwedding.jp", true },
  { "genshiken-itb.org", true },
  { "gensicke.de", true },
  { "genslerapps.com", true },
  { "genslerwisp.com", true },
  { "gensokyo.re", true },
  { "gensonline.eu", true },
  { "gentianes.ch", true },
  { "gentoo-blog.de", true },
  { "gentooblog.de", true },
  { "genusshotel-riegersburg.at", true },
  { "genuxtsg.com", true },
  { "geocar.com", true },
  { "geocompass.at", true },
  { "geofox.org", true },
  { "geography-schools.com", true },
  { "geoinstinct.com", true },
  { "geoip.fedoraproject.org", true },
  { "geoip.stg.fedoraproject.org", true },
  { "geojs.io", true },
  { "geology-schools.com", true },
  { "geometra.roma.it", true },
  { "geomex.be", true },
  { "geomonkeys.com", true },
  { "geoponika.gr", true },
  { "geoport.al", true },
  { "georadar-algerie.com", true },
  { "george-brighton.co.uk", true },
  { "george-orwell.com", true },
  { "georgebrighton.co.uk", true },
  { "georgecolgrove.com", true },
  { "georgehalachev.com", true },
  { "georgemaschke.com", true },
  { "georgemaschke.net", true },
  { "georgepancescu.ro", true },
  { "georgescarryout.com", true },
  { "georgewbushlibrary.gov", true },
  { "georgiaautoglass.net", true },
  { "georgiaglassrepair.com", true },
  { "georgiastuartyoga.co.uk", true },
  { "georgiaurologist.com", true },
  { "georgioskontaxis.com", true },
  { "georgioskontaxis.net", true },
  { "georgioskontaxis.org", true },
  { "georgmayer.eu", true },
  { "geoscan.aero", true },
  { "geoscope.ch", true },
  { "geosphereservices.com", true },
  { "geotab.com", true },
  { "gepgroup.gr", true },
  { "gepps.de", true },
  { "geraintwhite.co.uk", true },
  { "gerald-zojer.com", true },
  { "geraldsonrealty.com", true },
  { "gerardinden.nl", true },
  { "gerardobsd.com", true },
  { "gerardozamudio.mx", true },
  { "gerbyte.co.uk", true },
  { "gerbyte.com", true },
  { "gerbyte.uk", true },
  { "germancraft.net", true },
  { "germandarknes.net", true },
  { "germanssky.de", true },
  { "germanticz.de", true },
  { "gernert-server.de", true },
  { "gero.io", true },
  { "gerritcodereview.com", true },
  { "gerwinvanderkamp.nl", true },
  { "ges-bo.de", true },
  { "geschichtscheck.de", true },
  { "geschmacksache.online", true },
  { "geschwinder.net", true },
  { "gesica.cloud", true },
  { "gessettirotti.it", true },
  { "gestorehotel.com", true },
  { "gestormensajeria.com", true },
  { "gesundheitmassage.com", true },
  { "gesundheitswelt24.de", true },
  { "gesundheitszentrum-am-reischberg.de", true },
  { "get-erp.ru", true },
  { "get-it-live.com", true },
  { "get-it-live.de", true },
  { "get-on.bid", true },
  { "get-refer.com", true },
  { "get.how", true },
  { "get2getha.org", true },
  { "get4x.com", true },
  { "geta.pub", true },
  { "getbonfire.com", true },
  { "getbooks.co.il", true },
  { "getbox.me", true },
  { "getbreadcrumbs.com", true },
  { "getbutterfly.com", true },
  { "getcloak.com", false },
  { "getcolq.com", true },
  { "getcommande.com", true },
  { "getdash.io", true },
  { "getdeveloper.de", true },
  { "geteckeld.nl", true },
  { "geteduroam.no", true },
  { "getenv.io", true },
  { "geterp.ru", true },
  { "getfedora.org", true },
  { "getfirstalert.com", true },
  { "getfittedstore.com", true },
  { "getflorence.co.uk", true },
  { "getfoundquick.com", true },
  { "getgeek.es", true },
  { "gethow.org", true },
  { "gethttpsforfree.com", true },
  { "geti2p.com", true },
  { "getidmcc.com", true },
  { "getimgs.com", true },
  { "getinphase.com", true },
  { "getitlive.de", true },
  { "getitpeople.com", true },
  { "getmango.com", true },
  { "getmdl.io", true },
  { "getmerch.eu", true },
  { "getmovil.com", true },
  { "getnib.com", true },
  { "getnikola.com", true },
  { "getoutofdebt.org", true },
  { "getpagespeed.com", true },
  { "getpanelapp.com", true },
  { "getpei.com", true },
  { "getprivacy.de", true },
  { "getprivacy.net", true },
  { "getpublii.com", true },
  { "getpuck.com", true },
  { "getrambling.com", true },
  { "getresilience.org", true },
  { "getsecure.nl", true },
  { "getsensibill.com", true },
  { "getsetbounce.co.uk", true },
  { "getsilknow.com", true },
  { "getsmartaboutdrugs.gov", false },
  { "getsport.mobi", true },
  { "getswadeshi.com", true },
  { "getteamninja.com", true },
  { "getthefriendsyouwant.com", true },
  { "getticker.com", true },
  { "gettopquality.com", true },
  { "getts.ro", true },
  { "getupandbounce.co.uk", true },
  { "getvdownloader.com", true },
  { "getwemap.com", true },
  { "getwisdom.io", true },
  { "getyeflask.com", true },
  { "getyourlifestraight.com", true },
  { "gevelreinigingtiel.nl", true },
  { "geyduschek.be", true },
  { "gf-franken.de", true },
  { "gf5fcalc.com", true },
  { "gfahnen.de", true },
  { "gfast.ru", true },
  { "gfcleisure.co.uk", true },
  { "gfe.li", true },
  { "gfe.link", true },
  { "gfelite.de", true },
  { "gfestival.fo", true },
  { "gfk-kunststoff-luebben.de", true },
  { "gflame.de", true },
  { "gfms.ru", true },
  { "gfnetfun.cf", true },
  { "gforce.ninja", true },
  { "gfoss.eu", true },
  { "gfournier.ca", true },
  { "gfxbench.com", true },
  { "ggdcpt.com", true },
  { "gginin.today", true },
  { "ggl-luzern.ch", true },
  { "ggma.co.uk", true },
  { "ggmmontascale.it", true },
  { "ggp2.com", true },
  { "ggs-marschallstrasse.de", true },
  { "ggs.jp", true },
  { "ggservers.com", true },
  { "ggx.us", true },
  { "gha.st", true },
  { "ghaglund.se", true },
  { "ghettonetflix.de", true },
  { "ghfip.com.au", true },
  { "ghini.com", true },
  { "ghislainphu.fr", true },
  { "ghostblog.info", false },
  { "ghostcir.com", true },
  { "ghou.me", true },
  { "ghrelinblocker.info", true },
  { "ghrelinblocker.org", true },
  { "ghuntley.com", false },
  { "giac.org", true },
  { "giacomodrago.com", true },
  { "giacomodrago.it", true },
  { "giacomopelagatti.it", true },
  { "giaithich.net", true },
  { "giakki.eu", false },
  { "giannademartini.com", true },
  { "gianproperties.com", true },
  { "giant-panda.com", true },
  { "giant-tortoise.com", true },
  { "gianttree.de", true },
  { "giardinaggio.milano.it", true },
  { "giardinaggio.napoli.it", true },
  { "giardiniere.bologna.it", true },
  { "giardiniere.milano.it", true },
  { "gibraltar.at", true },
  { "gichigamigames.com", true },
  { "gicl.dk", true },
  { "giebel.it", true },
  { "gierds.de", true },
  { "giethoorn.com", true },
  { "gietvloergarant.nl", false },
  { "giftcard.net", true },
  { "giftcardgranny.com", true },
  { "giftedconsortium.com", true },
  { "giftking.nl", false },
  { "giftmaniabrilhos.com.br", true },
  { "gifts.best", true },
  { "gifts365.co.uk", true },
  { "gifudodo.com", true },
  { "gig-raiffeisen.de", true },
  { "giga.nl", true },
  { "gigabitz.pw", true },
  { "gigacog.com", true },
  { "gigantar.com", true },
  { "gigantism.com", true },
  { "gigawa.lt", true },
  { "giggletotz.co.uk", true },
  { "gigime.com", true },
  { "gigin.eu", true },
  { "gigin.me", true },
  { "gigis-pizzeria.de", true },
  { "gigis.cloud", true },
  { "giglink.club", true },
  { "gigseekr.com", true },
  { "gigtroll.eu", true },
  { "gijsbertus.com", true },
  { "gijswesterman.nl", true },
  { "gikovatelojavirtual.com.br", true },
  { "gilangcp.com", true },
  { "gileadpac.com", true },
  { "giliamor.com", true },
  { "gilium.com", true },
  { "gillesdesnoyers.com", true },
  { "gillesmorelle.com", true },
  { "gillfamily.de", true },
  { "gillmanandsoame.co.uk", true },
  { "gillyscastles.co.uk", true },
  { "gilmoreid.com.au", true },
  { "gilmourluna.com", true },
  { "gilnet.be", true },
  { "gilpinmanagement.com", true },
  { "gimme.money", true },
  { "gina-architektur.design", true },
  { "ginabaum.com", true },
  { "ginacat.de", true },
  { "gingersutton.com", true },
  { "ginionusedcars.be", true },
  { "ginja.co.th", true },
  { "ginnegappen.nl", true },
  { "ginniemae.gov", true },
  { "gino-gelati.de", true },
  { "ginza-luce.net", true },
  { "ginza-viola.com", true },
  { "ginzadelunch.jp", true },
  { "ginzaj.com", true },
  { "giochi-online.ws", true },
  { "giochiecodici.it", true },
  { "gioielleriamolena.com", true },
  { "gippert-klein.de", true },
  { "giraffeduck.com", true },
  { "giraffeinflatables.co.uk", true },
  { "giraffenland.de", true },
  { "giraffes.org", true },
  { "giri.co", true },
  { "girlan.net", true },
  { "girlsforum.com", true },
  { "girlsgenerationgoods.com", true },
  { "girlz.jp", true },
  { "girsa.org", true },
  { "girvas.ru", true },
  { "gisch.tk", true },
  { "gisgov.be", true },
  { "gisher.news", true },
  { "gisher.org", true },
  { "gisher.video", true },
  { "gishiko.net", true },
  { "gistr.io", true },
  { "git.market", true },
  { "git.sb", true },
  { "git.tt", true },
  { "gitep.org.uk", true },
  { "gites-alizea.com", true },
  { "gitesdeshautescourennes.com", true },
  { "github.com", true },
  { "githubber.com", true },
  { "githubber.tv", true },
  { "gitla.in", true },
  { "gitstuff.tk", true },
  { "gittigidiyor.com", true },
  { "gittr.ch", true },
  { "giuem.com", true },
  { "giulianosdeli.com", true },
  { "giunchi.net", true },
  { "giuseppemacario.men", true },
  { "givastar.com", true },
  { "give2charity.co", true },
  { "give2charityapp.com", true },
  { "giveattheoffice.org", false },
  { "giveaways.ph", true },
  { "giveme.online", true },
  { "given2.com", true },
  { "givesunlight.com", true },
  { "givingnexus.org", false },
  { "givip.eu", true },
  { "gixtools.com", true },
  { "gixtools.net", true },
  { "gj-bochum.de", true },
  { "gjcampbell.co.uk", true },
  { "gjengset.com", true },
  { "gjspunk.de", false },
  { "gkimanyar.org", true },
  { "gkoenig-innenausbau.de", true },
  { "gkralik.eu", true },
  { "gl.search.yahoo.com", false },
  { "gla-hyperloop.com", false },
  { "glaciernursery.com", true },
  { "gladiatorboost.com", true },
  { "gladwellentertainments.co.uk", true },
  { "glahcks.com", true },
  { "glamguru.co.il", true },
  { "glamguru.world", true },
  { "glamour4you.de", true },
  { "glamourdaze.com", true },
  { "glasdon.com", true },
  { "glasen-hardt.de", true },
  { "glasfaser-im-hanseviertel.de", true },
  { "glasgestaltung.biz", true },
  { "glasner.photo", true },
  { "glaspe.com", true },
  { "glass.google.com", true },
  { "glasschmuck-millefiori.de", true },
  { "glassexpertswa.com", true },
  { "glassrainbowtrust.org.je", true },
  { "glasweld.com", true },
  { "glavsudexpertiza.ru", true },
  { "glazedmag.fr", true },
  { "glcastlekings.co.uk", true },
  { "gleanview.com", true },
  { "gleich-aluminium-shop.de", true },
  { "glenberviegolfclub.com", true },
  { "glencarbide.com", true },
  { "glendarraghbouncycastles.co.uk", true },
  { "glenhuntlyapartments.com.au", true },
  { "glenshere.com", true },
  { "glevolution.com", true },
  { "glidingshop.cz", true },
  { "glidingshop.de", true },
  { "glidingshop.eu", true },
  { "glitzerstuecke.de", true },
  { "glloq.org", true },
  { "glob-coin.com", true },
  { "global-adult-webcams.com", true },
  { "global-lights.ma", true },
  { "global-office.com", true },
  { "global-village.koeln", true },
  { "global.hr", true },
  { "globalcanineregistry.com", true },
  { "globalchokepoints.org", true },
  { "globalcomix.com", true },
  { "globalgovernancewatch.org", true },
  { "globalhealth.gov", true },
  { "globalhorses.de", true },
  { "globalipaction.ch", true },
  { "globalisierung-fakten.de", true },
  { "globalitac.com", true },
  { "globalityinvestment.com", true },
  { "globalonetechnology.com", true },
  { "globalprojetores.com.br", true },
  { "globalresearchcouncil.org", true },
  { "globalresistancecorporation.com", true },
  { "globalventil.com", true },
  { "globcoin.io", true },
  { "globelink-group.com", true },
  { "glocalworks.jp", true },
  { "glofox.com", true },
  { "gloneta.com", false },
  { "gloning.name", true },
  { "gloria.tv", true },
  { "glosiko.com", true },
  { "glossopnorthendafc.co.uk", true },
  { "glotech.co.uk", true },
  { "glotechkitchens.co.uk", true },
  { "glotechrepairs.co.uk", true },
  { "glu3cifer.rocks", true },
  { "glueck-im-norden.de", true },
  { "glueckskindter.de", true },
  { "gluedtomusic.com", true },
  { "gluit.de", true },
  { "glutenfreelife.co.nz", true },
  { "glutenfreevr.com", true },
  { "glykofridis.nl", true },
  { "glyph.ws", true },
  { "glyxins.com", true },
  { "gm-net.jp", true },
  { "gm.search.yahoo.com", false },
  { "gmacedo.com", true },
  { "gmail.com", false },
  { "gmbh-kiekin.de", true },
  { "gmc.uy", true },
  { "gmccar.it", true },
  { "gmcd.co", true },
  { "gmdu.net", true },
  { "gme.one", true },
  { "gmind.ovh", true },
  { "gmod.de", true },
  { "gmpark.dk", true },
  { "gmpartsdb.com", true },
  { "gmslparking.co.uk", true },
  { "gmta.nl", true },
  { "gmtplus.co.za", true },
  { "gmw-hannover.de", true },
  { "gmw-ingenieurbuero.de", true },
  { "gmx.at", true },
  { "gmx.ch", true },
  { "gmx.co.uk", true },
  { "gmx.com", true },
  { "gmx.de", true },
  { "gmx.es", true },
  { "gmx.fr", true },
  { "gmx.net", true },
  { "gn00.com", true },
  { "gnax.jp", false },
  { "gndh.net", true },
  { "gnetion.com", true },
  { "gnetwork.eu", true },
  { "gnfrazier.me", true },
  { "gnhub.org", true },
  { "gnilebein.de", true },
  { "gnk.io", true },
  { "gnuand.me", true },
  { "gnucashtoqif.us", true },
  { "gnunet.org", true },
  { "gnuplus.me", true },
  { "go-dutch.eu", true },
  { "go-embedded.de", true },
  { "go-propiedades.cl", true },
  { "go-wild.co.uk", true },
  { "go-zh.org", true },
  { "go.microsoft.com", true },
  { "go.xero.com", false },
  { "go2ubl.nl", true },
  { "goa8.xyz", true },
  { "goalbookapp.com", true },
  { "goalongtravels.com", true },
  { "goanalyse.co.uk", true },
  { "goand.run", true },
  { "goarmy.eu", true },
  { "goatbot.xyz", true },
  { "goatcloud.com", true },
  { "gobarrelroll.com", true },
  { "gobouncy.co.uk", true },
  { "gobouncy.com", true },
  { "gobranding.com.vn", true },
  { "gocher.me", true },
  { "gochu.se", true },
  { "gocleanerslondon.co.uk", true },
  { "god-clan.hu", true },
  { "godaxen.tv", true },
  { "godclan.hu", true },
  { "godesigner.ru", true },
  { "godofnea.com", true },
  { "godrive.ga", true },
  { "godsofhell.com", true },
  { "godsofhell.de", true },
  { "goededoelkerstkaarten.nl", true },
  { "goedkoopstecartridges.nl", true },
  { "goedkopecartridgeskopen.nl", true },
  { "goedkopelaptopshardenberg.nl", true },
  { "goedkopeonesies.nl", true },
  { "goedkopetonerkopen.nl", true },
  { "goedverzekerd.net", true },
  { "goemail.me", true },
  { "goerlitz-zgorzelec.org", true },
  { "goerres2014.de", true },
  { "goetemp.de", true },
  { "goetic.space", true },
  { "goettinger-biergarten.de", true },
  { "goffrie.com", true },
  { "gofigure.fr", false },
  { "goflipr.com", true },
  { "goflo.net", true },
  { "gofoiayourself.org", true },
  { "gogle-analytics.com", true },
  { "gogleapis.com", true },
  { "gogonano.com", true },
  { "gogoodyear.eu", true },
  { "gogroopie.com", true },
  { "gogroopie.ie", true },
  { "gogrow.com", true },
  { "gogsat.com", true },
  { "gohon.org", true },
  { "gohongi-katakori.com", true },
  { "goingreen.com.au", true },
  { "gokhankesici.com", true },
  { "gokmenguresci.com", true },
  { "golang.org", true },
  { "golang.zone", true },
  { "golangnews.com", true },
  { "gold24.ru", true },
  { "goldcoastasian.com", true },
  { "goldcoasthypnotherapyhypnosis.com.au", true },
  { "goldcoastphotographycourses.com", true },
  { "goldcoaststumpbusters.com", true },
  { "goldegg-training.com", false },
  { "goldenbadger.de", true },
  { "goldendawnapersonalaffair.com", true },
  { "goldenhillsoftware.com", true },
  { "goldenhost.ca", true },
  { "goldenplate.com.sg", true },
  { "goldenruleemail.com", true },
  { "goldfmromania.ro", true },
  { "goldmark.com.au", true },
  { "goldpreisfinder.at", true },
  { "goldsecurity.com", true },
  { "goldsilver.org.ua", true },
  { "goldstein.tel", true },
  { "goldytechspecialists.com", true },
  { "golf18network.com", true },
  { "golf18staging.com", true },
  { "golfhausmallorca.com", true },
  { "golfmeile.de", true },
  { "golfpark-bostalsee.de", true },
  { "golfscape.com", true },
  { "golighthouse.com", true },
  { "golik.net.pl", false },
  { "golser-schuh.at", true },
  { "golser.info", true },
  { "gomasy.jp", true },
  { "gomelchat.com", true },
  { "gomena.io", true },
  { "gommista.roma.it", true },
  { "gondawa.com", true },
  { "gondelvaartdwarsgracht.nl", true },
  { "gongjianwei.com", true },
  { "gongjuhao.com", true },
  { "gonx.dk", true },
  { "goo.gl", true },
  { "gooby.co", false },
  { "good-tips.pro", true },
  { "gooday.life", true },
  { "goodenough.nz", true },
  { "goodhealthtv.com", true },
  { "goodquote.gq", true },
  { "goodryb.top", true },
  { "goodshepherdmv.com", true },
  { "goodth.ink", true },
  { "google", true },
  { "google-analytics.com", true },
  { "googleandroid.cz", true },
  { "googlemail.com", false },
  { "googleplex.com", true },
  { "googlesource.com", true },
  { "goombi.fr", true },
  { "goonersworld.co.uk", true },
  { "goontopia.com", true },
  { "goooo.info", true },
  { "gootlijsten.nl", true },
  { "goover.de", true },
  { "goow.in", true },
  { "goozp.com", true },
  { "gopher.tk", true },
  { "goproallaccess.com", true },
  { "goproinspectiongroup.com", true },
  { "goquiq.com", true },
  { "gordeijnsbouw.nl", true },
  { "gordonscouts.com.au", true },
  { "gorealya.com", true },
  { "gorf.chat", true },
  { "gorf.club", true },
  { "gorgias.me", true },
  { "gorky.media", true },
  { "gorn.ch", true },
  { "gorschenin.com", true },
  { "gosccs.com", true },
  { "gosciencegirls.com", true },
  { "gosforthdentalsurgery.co.uk", true },
  { "goshawkdb.io", true },
  { "goshin-group.co.jp", true },
  { "gospelfollower.com", true },
  { "gospelofmark.ch", true },
  { "gospelvestcination.de", true },
  { "gostaffer.com", true },
  { "gostest.org", false },
  { "gosu.pro", true },
  { "gosuland.org", true },
  { "got-tty.de", true },
  { "goteborgsklassikern.se", true },
  { "gotech.com.eg", false },
  { "gothamlimo.com", true },
  { "gothic.dating", true },
  { "gotirupati.com", false },
  { "gotmalk.org", true },
  { "goto.google.com", true },
  { "goto.msk.ru", true },
  { "goto.world", true },
  { "goto10.se", true },
  { "gotomi.info", true },
  { "gotoxy.at", true },
  { "gotrail.fr", true },
  { "gottcode.org", false },
  { "goudenharynck.be", true },
  { "gouforit.com", true },
  { "gouldcooksey.com", true },
  { "goup.co", true },
  { "goup.com.tr", true },
  { "gouptime.ml", true },
  { "gourmetfestival.de", true },
  { "gourmetspalencia.com", true },
  { "gov.tc", true },
  { "governmentjobs.gov", true },
  { "governorhub.com", true },
  { "govisitcostarica.co.cr", true },
  { "govisitcostarica.com", true },
  { "govtrack.us", true },
  { "govype.com", true },
  { "gowe.wang", false },
  { "gowildrodeo.co.uk", true },
  { "gowithflo.de", true },
  { "gozenhost.com", true },
  { "gpcsolutions.fr", true },
  { "gpdimaranathasiantar.org", false },
  { "gpfclan.de", true },
  { "gpgscoins.com", true },
  { "gplans.us", true },
  { "gpm.ltd", true },
  { "gprs.uk.com", true },
  { "gpscamera.nl", true },
  { "gpsfix.cz", true },
  { "gpsolarpanels.com", true },
  { "gpsvideocanada.com", true },
  { "gpureport.cz", true },
  { "gpws.ovh", true },
  { "gqmstore.com.br", true },
  { "gr.search.yahoo.com", false },
  { "gra2.com", true },
  { "graasp.net", false },
  { "grabacabpa.com", true },
  { "grace-wan.com", true },
  { "gracebaking.com", false },
  { "gracedays.org", true },
  { "gracethrufaith.com", true },
  { "gracetini.com", true },
  { "graciousmay.com", true },
  { "gradecam.com", true },
  { "gradienthosting.co.uk", true },
  { "gradients.com", true },
  { "gradingcontractornc.com", true },
  { "gradualgram.com", true },
  { "graeber.com", true },
  { "graecum.org", true },
  { "graetnew.com", true },
  { "graf-igor.ch", true },
  { "graf.re", true },
  { "grafcaps.com", true },
  { "graffen.dk", true },
  { "grafmag.pl", true },
  { "grafmurr.de", true },
  { "grafoteka.pl", true },
  { "graft.community", true },
  { "graft.observer", true },
  { "grahambaker.ca", true },
  { "grahamcarruthers.co.za", true },
  { "grahamcluley.com", true },
  { "grailians.com", true },
  { "grailify.com", true },
  { "graingert.co.uk", true },
  { "graliv.net", false },
  { "gram.tips", true },
  { "gramati.com.br", true },
  { "grammysgrid.com", true },
  { "granary-demo.appspot.com", false },
  { "grancellconsulting.com", true },
  { "grandcafecineac.nl", true },
  { "grandcafetwist.nl", true },
  { "grandcapital.cn", true },
  { "grandcapital.id", true },
  { "grandcapital.net", true },
  { "grandcapital.ru", true },
  { "grandcastles.co.uk", true },
  { "grandchene.ch", true },
  { "grande.coffee", true },
  { "grandefratellonews.com", true },
  { "grandeto.com", true },
  { "grandjunctionbrewing.com", true },
  { "grandmusiccentral.com.au", true },
  { "grandpadusercontent.com", true },
  { "granfort.es", false },
  { "granishe.com", true },
  { "graniteind.com", true },
  { "grannys-stats.com", true },
  { "grannyshouse.de", true },
  { "grantcooper.com", true },
  { "grantdb.ca", true },
  { "grantmorrison.net", true },
  { "grantplatform.com", true },
  { "grantsplatform.com", true },
  { "granular.ag", true },
  { "graonatural.com.br", true },
  { "grapee.jp", true },
  { "grapeintentions.com", true },
  { "graphcommons.com", true },
  { "graphene.software", true },
  { "graphic-schools.com", true },
  { "graphic-shot.com", true },
  { "grapholio.net", true },
  { "grasmark.com", true },
  { "grassenberg.de", true },
  { "grasshoppervape.com", true },
  { "grasso.io", true },
  { "grassreinforcement.com.au", true },
  { "gratis-lovecheck.de", true },
  { "gratisgamecards.nl", true },
  { "gratisrollenspieltag.de", true },
  { "gratiswifivoorjegasten.nl", true },
  { "gratitudeabundancepassion.com", true },
  { "grattan.co.uk", true },
  { "graumeier.de", true },
  { "gravilink.com", true },
  { "gravitascreative.net", true },
  { "gravitechthai.com", true },
  { "gravity-inc.net", true },
  { "gravityformspdfextended.com", true },
  { "gravitypdf.com", true },
  { "grawe-blog.at", true },
  { "grayclub.co.il", true },
  { "grayhatter.com", true },
  { "grayiron.io", true },
  { "graymalk.in", true },
  { "grayowlworks.com", true },
  { "grayscale.co", true },
  { "grayson.sh", true },
  { "grazieitalian.com", true },
  { "grc.com", false },
  { "greatagain.gov", true },
  { "greatestwebsiteonearth.com", true },
  { "greatfire.org", true },
  { "greathairtransplants.com", true },
  { "greathosts.biz", true },
  { "greatislandarts.ca", true },
  { "greatlakeside.de", true },
  { "greatlifeinsurancegroup.com", true },
  { "greatskillchecks.com", true },
  { "greboid.co.uk", true },
  { "greboid.com", true },
  { "greditsoft.com", true },
  { "greek.dating", true },
  { "greeklish.gr", true },
  { "green-attitude.be", true },
  { "green-care.nl", true },
  { "green-light.co.nz", true },
  { "greenaddress.it", true },
  { "greenapproach.ca", true },
  { "greenbaysecuritysolutions.com", true },
  { "greencircleplantnursery.com.au", true },
  { "greencircleplantnursery.net.au", true },
  { "greener.pl", true },
  { "greenglam.biz", true },
  { "greengoblindev.com", true },
  { "greenhats.de", true },
  { "greenliquidsystem.com", true },
  { "greenliv.pl", true },
  { "greenlungs.net", true },
  { "greenmachines.com", true },
  { "greenoutdoor.dk", false },
  { "greenpanda.de", true },
  { "greenpartyofnewmilford.org", true },
  { "greenpeace-magazin.de", true },
  { "greenpeace.berlin", true },
  { "greenroach.ru", true },
  { "greenrushdaily.com", true },
  { "greensborosecuritycameras.com", true },
  { "greensdictofslang.com", true },
  { "greensquare.tk", true },
  { "greenteamtwente.nl", true },
  { "greenwaylog.net", true },
  { "greenwithdecor.com", true },
  { "greer.ru", true },
  { "greg.red", true },
  { "gregbrimble.com", true },
  { "greger.me", true },
  { "gregmarziomedia-dev.com", true },
  { "gregmarziomedia.com", true },
  { "gregmote.com", true },
  { "grego.pt", true },
  { "gregoirow.be", true },
  { "gregorians.org", true },
  { "gregorkofler.com", true },
  { "gregory-kramer.fr", true },
  { "gregorykelleher.com", true },
  { "gregoryrealestategroup.com", true },
  { "gregorywiest.com", true },
  { "greice.de", true },
  { "grenadiercorps-kaarst.de", true },
  { "grenadiere-kaarst.de", true },
  { "grenadierkorps-kaarst.de", true },
  { "grenadierkorps.de", true },
  { "grendel.no", true },
  { "grengine.ch", true },
  { "grepmaste.rs", true },
  { "grepular.com", true },
  { "gresak.io", true },
  { "grexx.co.uk", true },
  { "grexx.de", true },
  { "grexx.nl", true },
  { "grey.house", true },
  { "greyhash.se", true },
  { "greymattertechs.com", true },
  { "greysky.me", true },
  { "greyskymedia.com", true },
  { "greysolutions.it", true },
  { "greywizard.com", true },
  { "greywolf.cz", true },
  { "grh.am", true },
  { "griassdi-reseller.de", true },
  { "gricargo.com", true },
  { "griechische-pfoetchen.de", true },
  { "griecopelino.com", true },
  { "grieg-gaarden.no", true },
  { "grieg.com", true },
  { "grieg.net", true },
  { "grieg.no", true },
  { "grieg.org", true },
  { "griegfoundation.no", true },
  { "grieglogistics.no", true },
  { "griegshipbrokers.com", true },
  { "griegshipbrokers.no", true },
  { "griesser2.de", true },
  { "grillen-darf-nicht-gesund-sein.de", true },
  { "grillteller42.de", true },
  { "grimcalc.com", true },
  { "grimm-gastrobedarf.de", true },
  { "grimneko.de", true },
  { "grimstveit.no", true },
  { "grinnellplans.com", true },
  { "grippe-impftermin.de", true },
  { "gritte.ch", true },
  { "grizzlys.com", true },
  { "grmp.fr", true },
  { "grocerybuild.com", true },
  { "grocock.me.uk", true },
  { "groenaquasolutions.nl", true },
  { "groenewoud.me", true },
  { "groentebesteld.nl", true },
  { "groenteclub.nl", true },
  { "groepjam-usedcars.be", true },
  { "grog.pw", true },
  { "grokker.com", true },
  { "groklearning.com", true },
  { "grolimur.ch", true },
  { "gronau-it-cloud-computing.de", true },
  { "grondius.com", true },
  { "groomershop.ru", true },
  { "grootinadvies.nl", true },
  { "groovydisk.com", true },
  { "groovygoldfish.org", true },
  { "gropp.org", true },
  { "gross.business", true },
  { "grossberger-ge.org", true },
  { "groszek.pl", true },
  { "groth.im", true },
  { "groth.xyz", true },
  { "grothoff.org", true },
  { "grottenthaler.eu", true },
  { "groundlevelup.com", true },
  { "group4layers.net", true },
  { "groupe-neurologique-nord.lu", true },
  { "groupebaillargeon.com", true },
  { "groupghistelinck-cars.be", true },
  { "grouphomes.com.au", false },
  { "groupme.com", true },
  { "groups.google.com", true },
  { "grove-archiv.de", true },
  { "growingallthings.co.uk", true },
  { "growit.events", true },
  { "growy.ch", true },
  { "grozter.se", true },
  { "grrmmll.com", true },
  { "grsecurity.net", true },
  { "gruble.de", true },
  { "gruebebraeu.ch", true },
  { "gruenderlehrstuhl.de", true },
  { "gruenderwoche-dresden.de", true },
  { "gruene-im-rvr.de", true },
  { "gruene-wattenscheid.de", true },
  { "gruenes-wp.de", true },
  { "gruenprint.de", true },
  { "gruenstreifen-ev.de", true },
  { "grumpy.fr", true },
  { "grumpygamers.com", true },
  { "grunwaldzki.center", true },
  { "grunwasser.fr", true },
  { "grupomakben.com", true },
  { "grupomedlegal.com", true },
  { "grupoparco.com", true },
  { "grupoproabienesraices.com.mx", true },
  { "gruselgrotte.com", true },
  { "grusenmeyer.be", true },
  { "grusig-geil.ch", true },
  { "gruver.de", true },
  { "gruwa.net", true },
  { "gs93.de", true },
  { "gsaj114.net", true },
  { "gscloud.xyz", true },
  { "gsi-network.com", true },
  { "gsimagebank.co.uk", true },
  { "gslink.me", true },
  { "gsmbrick.com", true },
  { "gsmsecurity.net", true },
  { "gsoc.se", true },
  { "gsrc.io", true },
  { "gst.name", true },
  { "gst.priv.at", true },
  { "gt-mp.net", true },
  { "gt-network.de", true },
  { "gta-arabs.com", true },
  { "gtaforum.nl", true },
  { "gtchipsi.org", true },
  { "gtcprojects.com", true },
  { "gtlaun.ch", true },
  { "gtlfsonlinepay.com", true },
  { "gtmasterclub.it", false },
  { "gtmetrix.com", true },
  { "gtoepfer.de", true },
  { "gtopala.com", true },
  { "gtopala.net", true },
  { "gtour.info", false },
  { "gtravers-basketmaker.co.uk", true },
  { "gts-dp.de", true },
  { "gtxbbs.com", true },
  { "gtxmail.de", true },
  { "guajars.cl", true },
  { "guannan.net.cn", true },
  { "guanyembadalona.org", true },
  { "guanzhong.ca", true },
  { "guardian360.nl", true },
  { "guardianportal.us", true },
  { "guardianproject.info", true },
  { "guardiansoftheearth.org", true },
  { "gubagoo.com", true },
  { "gubagoo.io", true },
  { "gudini.net", true },
  { "gudrunfit.dk", true },
  { "guegan.de", true },
  { "guelo.ch", true },
  { "guenthereder.at", true },
  { "guenthernoack.de", true },
  { "guerard.info", true },
  { "guerrilla.technology", true },
  { "guesthouse-namaste.com", true },
  { "guevener.de", true },
  { "gueze-ardeche.fr", true },
  { "gueze-sas.fr", true },
  { "guffr.it", true },
  { "guge.ch", true },
  { "gugert.net", true },
  { "guhei.net", true },
  { "guhenry3.tk", true },
  { "guiacidade.com.br", true },
  { "guiaswow.com", true },
  { "guichet-entreprises.fr", true },
  { "guichet-qualifications.fr", true },
  { "guid2steamid.com", true },
  { "guid2steamid.pw", true },
  { "guida.org", true },
  { "guide-peche-cantal.com", true },
  { "guidebook.co.tz", true },
  { "guidedselling.net", true },
  { "guideline.gov", false },
  { "guidelines.gov", false },
  { "guideo.ch", true },
  { "guidepointsecurity.com", true },
  { "guides-peche64.com", true },
  { "guidetoiceland.is", false },
  { "guildbase.de", true },
  { "guildofmusicsupervisors.co.uk", true },
  { "guillaume-briand.fr", true },
  { "guillaumeperrin.io", true },
  { "guillemaud.me", true },
  { "guim.co.uk", true },
  { "guineapigmustach.es", true },
  { "guishem.com", true },
  { "guitarvolume.com", true },
  { "gulchuk.com", true },
  { "gulenbase.no", true },
  { "gulfstream.ru", true },
  { "gumballs.com", true },
  { "gume4you.com", true },
  { "gumi.ca", true },
  { "gunauc.net", true },
  { "gunceloyunhileleri.com", true },
  { "gunn.ee", true },
  { "gunsofshadowvalley.com", true },
  { "gunwatch.co.uk", true },
  { "gunworld.com.au", true },
  { "guochang.xyz", true },
  { "guodong.net", true },
  { "guoke.com", true },
  { "guoliang.me", true },
  { "guozeyu.com", true },
  { "gupfen.ch", true },
  { "guphi.net", false },
  { "gurkan.in", true },
  { "gurmel.ru", true },
  { "gurpusmaximus.com", true },
  { "guru-naradi.cz", true },
  { "gurucomi.com", true },
  { "gurueffect.com", true },
  { "gururi.com", true },
  { "gus.host", true },
  { "gustaff.de", true },
  { "gustiaux.com", true },
  { "gustom.io", true },
  { "gut8er.com.de", true },
  { "gutools.co.uk", true },
  { "guts.me", true },
  { "guts.moe", true },
  { "gutschein-spezialist.de", true },
  { "gutscheingeiz.de", true },
  { "gutuia.blue", true },
  { "guus-thijssen.nl", true },
  { "guusvandewal.nl", true },
  { "guyeskens.be", true },
  { "gv-neumann.de", true },
  { "gv-salto.nl", true },
  { "gvatas.in", true },
  { "gvc-it.tk", true },
  { "gveh.de", true },
  { "gvi-timing.ch", true },
  { "gviedu.com", true },
  { "gvitiming.ch", true },
  { "gvobgyn.ca", true },
  { "gvt2.com", true },
  { "gvt3.com", true },
  { "gvwgroup.com", true },
  { "gw2efficiency.com", true },
  { "gw2treasures.com", true },
  { "gw2zone.net", true },
  { "gwerder.net", true },
  { "gwhois.org", true },
  { "gwrtech.com", true },
  { "gwsec.co.uk", true },
  { "gxmyqy.net", true },
  { "gyara.moe", true },
  { "gyas.nl", true },
  { "gymagine.ch", true },
  { "gymbunny.de", true },
  { "gymhero.me", true },
  { "gymjp.com", true },
  { "gymkirchenfeld.ch", true },
  { "gymnaserenens.ch", true },
  { "gymnasium-farmsen.de", true },
  { "gymnasium-hittfeld.de", true },
  { "gympap.de", true },
  { "gynaecology.co", true },
  { "gynoguide.com", true },
  { "gypsyreel.com", true },
  { "gyre.ch", true },
  { "gyrenens.ch", true },
  { "gyu-raku.jp", true },
  { "gyulakerezsi.ro", true },
  { "gz-architekten.de", true },
  { "gz-benz.com", true },
  { "gz-bmw.com", true },
  { "gza.jp", true },
  { "gzom.ru", true },
  { "h-jo.net", true },
  { "h-suppo.com", true },
  { "h001.ru", true },
  { "h09.eu", true },
  { "h0r.st", true },
  { "h10l.com", true },
  { "h11.io", true },
  { "h11.moe", true },
  { "h1ctf.com", true },
  { "h1z1swap.com", true },
  { "h24.org", true },
  { "h2s-design.de", true },
  { "h2u.tv", true },
  { "h3artbl33d.nl", true },
  { "h3b.nl", true },
  { "h3z.jp", true },
  { "h404bi.com", true },
  { "ha-kunamatata.de", true },
  { "ha3.eu", true },
  { "ha6.ru", true },
  { "haarlemsesaxofoonschool.nl", true },
  { "haavard.me", true },
  { "haazen.xyz", true },
  { "habarisoft.com", true },
  { "habbig.cc", true },
  { "habbos.es", true },
  { "haberer.me", true },
  { "habitat-domotique.fr", true },
  { "habr.com", true },
  { "habtium.com", true },
  { "habtium.es", true },
  { "habview.net", true },
  { "hacc.top", true },
  { "haccp.bergamo.it", true },
  { "haccp.milano.it", true },
  { "haccp.roma.it", true },
  { "hacertest.com", true },
  { "hacettepeteknokent.com.tr", true },
  { "hachre.de", false },
  { "hack.club", true },
  { "hackademix.net", true },
  { "hackanders.com", true },
  { "hackattack.com", true },
  { "hackbarth.guru", true },
  { "hackbeil.name", true },
  { "hackcraft.net", true },
  { "hackdown.me", true },
  { "hackenkunjeleren.nl", true },
  { "hackenturet.dk", true },
  { "hacker.club", true },
  { "hacker.holiday", true },
  { "hacker.im", true },
  { "hacker.one", true },
  { "hacker.parts", true },
  { "hacker1.com", true },
  { "hacker101.com", true },
  { "hackerchai.com", true },
  { "hackerco.com", true },
  { "hackereyes.com", true },
  { "hackergateway.com", true },
  { "hackernet.se", true },
  { "hackerone-ext-content.com", true },
  { "hackerone-user-content.com", true },
  { "hackerone.at", true },
  { "hackerone.com", true },
  { "hackerone.net", true },
  { "hackerone.org", true },
  { "hackerschat.net", true },
  { "hackerstxt.org", true },
  { "hackettrecipes.com", true },
  { "hackgins.com", true },
  { "hackingand.coffee", false },
  { "hackingdh.com", true },
  { "hackmd.io", true },
  { "hackmeimfamo.us", true },
  { "hackreone.com", true },
  { "hacksecu.re", true },
  { "hacksoc.co.uk", true },
  { "hackthissite.org", true },
  { "hacktic.info", true },
  { "hacktivis.me", true },
  { "hackworx.com", false },
  { "hadaly.fr", true },
  { "hadleighswimmingclub.co.uk", true },
  { "hadouk.in", true },
  { "hadrons.org", true },
  { "haefligermedia.ch", true },
  { "haemka.de", true },
  { "haens.li", true },
  { "haerwu.biz", true },
  { "haferman.net", true },
  { "haferman.org", true },
  { "hafniatimes.com", true },
  { "haggeluring.su", true },
  { "hagiati.gr", true },
  { "hagier.pl", true },
  { "hagueaustralia.com.au", true },
  { "haha-raku.com", true },
  { "hahay.es", true },
  { "haiboxu.com", true },
  { "haidihai.ro", true },
  { "hailer.com", true },
  { "hailstorm.nl", true },
  { "haim.bio", true },
  { "haimablog.ooo", true },
  { "hairbeautyartists.it", true },
  { "haircrazy.com", true },
  { "hairplaybychenellekay.com", false },
  { "hairraisingphotobooths.co.uk", true },
  { "hairtonic-lab.com", true },
  { "haixihui.cn", true },
  { "hajekdavid.cz", true },
  { "hajekj.net", true },
  { "hajnzic.at", true },
  { "hak5.org", true },
  { "hakaru.org", true },
  { "hakase.io", true },
  { "hakase.pw", true },
  { "hakatabijin-mind.com", true },
  { "hake.me", true },
  { "hakkasangroup.com", true },
  { "hakkasannightclub.com", true },
  { "halacs.hu", true },
  { "halbich.design", true },
  { "haleo.net", true },
  { "half.host", true },
  { "halfco.de", true },
  { "halfhosting.de", true },
  { "halitopuroprodutos.com.br", true },
  { "halkirkbouncycastles.co.uk", true },
  { "halkyon.net", true },
  { "halledesprix.fr", true },
  { "hallelujahsoftware.com", true },
  { "hallettxn.com", true },
  { "hallhuber.com", true },
  { "halliday.work", true },
  { "halligladen.de", true },
  { "hallmarkestates.ca", true },
  { "hallucinogen.com", true },
  { "hallucinogens.org", true },
  { "hallumlaw.com", true },
  { "halo.fr", true },
  { "halocredit.pl", true },
  { "halongbaybackpackertour.com", true },
  { "haloobaloo.com", true },
  { "haloria.com", true },
  { "haltegame.com", true },
  { "hamacho-kyudo.com", true },
  { "hamali.bg", true },
  { "hamburgerbesteld.nl", true },
  { "hamcocc.com", true },
  { "hamcram.io", true },
  { "hamiltonlinen.com", true },
  { "hamiltonmedical.nl", true },
  { "hammer-schnaps.com", true },
  { "hammer-sms.com", true },
  { "hampl.tv", true },
  { "hampshiretechservices.co.uk", true },
  { "hamsters-uk.org", true },
  { "hana.ondemand.com", true },
  { "hanakaraku.com", true },
  { "hanashi.eu", true },
  { "hanbing.it", true },
  { "handbrake.fr", true },
  { "handcraft.eu.org", true },
  { "handgelenkbandage-test.de", true },
  { "handknit.com.np", true },
  { "handlecoin.com", true },
  { "handleidingkwijt.com", true },
  { "handmade-workshop.de", true },
  { "handmadehechoamano.com", true },
  { "handy-center.net", true },
  { "handymanlondonplease.co.uk", true },
  { "handysex.live", true },
  { "handyticket.de", true },
  { "hanfox.co.uk", false },
  { "hanfverband-erfurt.de", true },
  { "hangar.hosting", true },
  { "hangcapnach.com", true },
  { "hangouts.google.com", true },
  { "hangtenseo.com", true },
  { "hankr.com", true },
  { "hanksacservice.com", true },
  { "hannah.link", true },
  { "hannahi.com", true },
  { "hannasecret.de", true },
  { "hannoluteijn.nl", true },
  { "hannover.de", true },
  { "hanoibuffet.com", true },
  { "hanpenblog.com", true },
  { "hansahome.ddns.net", true },
  { "hansbijster.nl", true },
  { "hanschventures.com", true },
  { "hansen-kronshagen.de", true },
  { "hansen.hn", true },
  { "hansmund.com", true },
  { "hansolrella.com", true },
  { "hansonian.com", true },
  { "hansvaneijsden.com", true },
  { "hansvaneijsden.nl", true },
  { "hantse.com", true },
  { "hanu.la", true },
  { "hanyibo.com", true },
  { "hanzubon.jp", true },
  { "hao-zhang.com", true },
  { "haogoodair.ca", true },
  { "haoqi.men", true },
  { "haorenka.cc", true },
  { "haotown.cn", true },
  { "haozhang.org", true },
  { "haozhexie.com", true },
  { "haozi.me", true },
  { "haozijing.com", true },
  { "hapheemraadssingel.nl", true },
  { "hapijs.cn", true },
  { "happndin.com", true },
  { "happy-baby.info", true },
  { "happy-end-shukatsu.com", true },
  { "happyagain.de", true },
  { "happyagain.se", true },
  { "happyandrelaxeddogs.eu", true },
  { "happybeerdaytome.com", true },
  { "happybirthdaywisher.com", true },
  { "happybounce.co.uk", true },
  { "happycarb.de", true },
  { "happycoder.net", false },
  { "happydietplan.com", true },
  { "happydoq.ch", true },
  { "happygadget.me", true },
  { "happyhealthylifestyle.com", true },
  { "happykidscastles.co.uk", true },
  { "happylifestyle.com", true },
  { "happyschnapper.com", true },
  { "happyteamlabs.com", true },
  { "happyukgo.com", true },
  { "hapsana.nl", true },
  { "haptemic.com", true },
  { "haraj.com.sa", true },
  { "harald-d.dyndns.org", true },
  { "harald-pfeiffer.de", true },
  { "harapecorita.com", true },
  { "harbor-light.net", true },
  { "hardeman.nu", true },
  { "hardenize.com", true },
  { "hardergayporn.com", true },
  { "hardertimes.com", true },
  { "hardesec.com", true },
  { "hardez.de", true },
  { "hardfalcon.net", true },
  { "hardforum.com", true },
  { "hardh.at", true },
  { "hardloopfysio.nl", true },
  { "hardrain980.com", true },
  { "hardtfrieden.de", true },
  { "hardwareschotte.de", true },
  { "harekaze.info", true },
  { "haribilalic.com", true },
  { "harilova.fr", true },
  { "harion.fr", true },
  { "harisht.me", false },
  { "harjitbhogal.com", true },
  { "harlor.de", true },
  { "harmfarm.nl", true },
  { "harmoney.co.nz", true },
  { "harmoney.com", true },
  { "harmoney.com.au", true },
  { "harmonyplace.com", true },
  { "haroldsharpe.com", true },
  { "harp.gov", true },
  { "harrcostl.com", true },
  { "harringtonca.com", true },
  { "harrisonswebsites.com", true },
  { "harrisonvillenaz.org", true },
  { "harry-baker.com", true },
  { "harrymclaren.co.uk", true },
  { "harryphoto.fr", true },
  { "harrysgardengamehire.co.uk", true },
  { "harrysmallbones.co.uk", true },
  { "harrysqnc.co.uk", true },
  { "hartie95.de", true },
  { "hartlep.email", true },
  { "hartlieb.me", true },
  { "hartzer.com", true },
  { "harukakikuchi.com", true },
  { "haruue.moe", true },
  { "harvarddharma.org", true },
  { "harvestapp.com", true },
  { "harvester.fr", true },
  { "harveyauzorst.com", true },
  { "harveysautoservice.net", true },
  { "has-no-email-set.de", false },
  { "has.work", true },
  { "hasdf.de", true },
  { "hasecuritysolutions.com", true },
  { "haselsteiner.me", true },
  { "hash-archive.org", true },
  { "hash.army", true },
  { "hash.works", true },
  { "hashcat.net", true },
  { "hashemian.com", true },
  { "hashes.org", true },
  { "hashi.dk", true },
  { "hashiconf.eu", true },
  { "hashicorp.com", true },
  { "hashimah.ca", true },
  { "hashimoto-jimusho.com", true },
  { "hashinteractive.com", true },
  { "hashish.net", true },
  { "hashiura.jp", true },
  { "hashnode.com", true },
  { "hashru.nl", true },
  { "hashworks.net", true },
  { "hashxp.org", true },
  { "hasilocke.de", true },
  { "haskovec.com", true },
  { "hasselbach-dellwig.de", true },
  { "hatarisecurity.co.ke", true },
  { "hatpakha.com", true },
  { "hatul.info", true },
  { "haucke.xyz", true },
  { "hauntedhouserecords.co.uk", true },
  { "haus-garten-test.de", true },
  { "haus-henne.de", true },
  { "haus-zeitlos.de", true },
  { "hausarztpraxis-linn.de", true },
  { "haushenne.de", true },
  { "hausjugo.de", true },
  { "haustechnik-breu.de", true },
  { "hausundhof.com", true },
  { "hausverbrauch.de", true },
  { "hautaka.com", true },
  { "hautarztzentrum.ch", true },
  { "hauteslatitudes.com", true },
  { "havarijna-sluzba-bratislava.sk", true },
  { "havasuhomepage.com", true },
  { "havasuinsurance.com", true },
  { "havasutacohacienda.com", true },
  { "have.jp", true },
  { "haveabounce.co.uk", true },
  { "haveacry.com", true },
  { "haveforeningen-enghaven.dk", true },
  { "havefunbiking.com", true },
  { "haveibeenpwned.com", true },
  { "havellab.de", true },
  { "havelland-obstler.de", true },
  { "havencyber.com", true },
  { "havenstrategies.com", true },
  { "havernbenefits.com", true },
  { "haverstack.com", true },
  { "havetherelationshipyouwant.com", true },
  { "hawaar.com", true },
  { "hawaya.com", true },
  { "hawkeyeinsight.com", true },
  { "hawkinsonkiaparts.com", true },
  { "hawkofgeorgia.com", true },
  { "hawkon.dk", true },
  { "hawksguild.com", true },
  { "hawksracing.de", true },
  { "hax.to", true },
  { "haxdroid.com", true },
  { "haxo.nl", false },
  { "hayai.space", true },
  { "hayashi-rin.net", true },
  { "hayden.one", false },
  { "haydenjames.io", true },
  { "haydentomas.com", true },
  { "hayfordoleary.com", true },
  { "haynes-davis.com", true },
  { "hayvid.com", true },
  { "haz.cat", true },
  { "haze.productions", true },
  { "hazeltime.se", true },
  { "hazeover.com", true },
  { "hazukilab.com", true },
  { "hb8522.com", true },
  { "hbcu-colleges.com", true },
  { "hbkonsult.com", true },
  { "hboeck.de", true },
  { "hbpowell.com", true },
  { "hcaz.io", true },
  { "hcbj.io", true },
  { "hcie.pl", false },
  { "hcscrusaders.com", true },
  { "hd-gaming.com", true },
  { "hd-offensive.at", false },
  { "hd-only.org", true },
  { "hd-outillage.com", true },
  { "hdc.cz", true },
  { "hdcamvids.com", true },
  { "hdcenter.cc", true },
  { "hddrecovery.net.au", true },
  { "hdeaves.uk", true },
  { "hdf.world", true },
  { "hdfgroup.org", true },
  { "hdguru.com", true },
  { "hdhoang.space", true },
  { "hdkandsons.com", true },
  { "hdnastudio.com", true },
  { "hdrsource.com", true },
  { "hdrtranscon.com", true },
  { "hds-lan.de", true },
  { "hdv.paris", true },
  { "heaaart.com", true },
  { "head.ru", true },
  { "headjapan.com", true },
  { "headlinepublishing.be", true },
  { "headshopinternational.com", true },
  { "headshotharp.de", true },
  { "healey.io", true },
  { "health-and-beauty-news.net", true },
  { "health-booster.com", true },
  { "health-plan-news.com", true },
  { "health.gov", true },
  { "health.graphics", true },
  { "healthand-beautynews.net", true },
  { "healthandskinbeauty.com", true },
  { "healthcare.gov", false },
  { "healthcultureexpo.com", true },
  { "healthdata.gov", true },
  { "healtheals.com", true },
  { "healtheffectsofasbestos.com", true },
  { "healthery.com", true },
  { "healthfinder.gov", true },
  { "healthfoam.com", true },
  { "healthgames.co.uk", true },
  { "healthiercompany.com", true },
  { "healthiergenerations.co.uk", true },
  { "healthit.gov", true },
  { "healthplansamerica.org", true },
  { "healthstar-dev.io", true },
  { "healthstar.io", true },
  { "healththoroughfare.com", true },
  { "healthy-map.com", true },
  { "healthybeterlife.click", true },
  { "healthyfitfood.com", true },
  { "healthypeople.gov", true },
  { "healthyteame.com", true },
  { "heap.zone", true },
  { "heapkeeper.org", true },
  { "hearinghelpexpress.com", true },
  { "hearmeraw.uk", true },
  { "heartbeat24.de", true },
  { "heartgames.pl", true },
  { "heartlandbiomed.com", true },
  { "heartmdinstitute.com", true },
  { "heartsintrueharmony.com", true },
  { "heartsucker.com", false },
  { "hearttruth.gov", true },
  { "heartview.com.br", true },
  { "heartwoodart.com", true },
  { "hearty.blog", true },
  { "hearty.ga", true },
  { "hearty.gq", true },
  { "hearty.me", true },
  { "hearty.ml", true },
  { "hearty.ooo", true },
  { "hearty.org.tw", true },
  { "hearty.taipei", true },
  { "hearty.tw", true },
  { "hearty.us", true },
  { "heartyapp.tw", true },
  { "heartycraft.com", true },
  { "heatershop.co.uk", true },
  { "heatingandairconditioningdallastx.com", true },
  { "heatingpartswarehouse.co.uk", true },
  { "heavensattic.co.uk", true },
  { "heavensinferno.net", true },
  { "heavyequipments.org", true },
  { "heayao.com", true },
  { "hebamme-cranio.ch", true },
  { "hebergeurssd.com", true },
  { "hebikhiv.nl", true },
  { "hebingying.cn", true },
  { "hebocon.nl", true },
  { "hec-espace-entreprise.ch", true },
  { "hec.global", true },
  { "hechamano.es", true },
  { "heckelektro.de", true },
  { "heckerundknopp.de", true },
  { "heckticmedia.com", true },
  { "hedgeschool.ie", true },
  { "hedonism.org", true },
  { "hedonistic-imperative.com", true },
  { "hedonistic.org", true },
  { "hedonium.com", true },
  { "hedweb.co.uk", true },
  { "hedweb.net", true },
  { "hedweb.org", true },
  { "heello.es", true },
  { "hefengautoparts.com", true },
  { "heftkaufen.de", true },
  { "hegen.com.pl", false },
  { "hegen.cz", false },
  { "hegen.sk", false },
  { "hegenshop.de", true },
  { "heh.ee", true },
  { "heha.co", false },
  { "heiaheia.com", true },
  { "heid.ws", true },
  { "heidisheroes.org", true },
  { "heijblok.com", true },
  { "heijdel.nl", true },
  { "heikegastmann.com", true },
  { "heikorichter.name", true },
  { "heiland.io", true },
  { "heiliger-gral.info", true },
  { "heilpraxis-bgl.de", true },
  { "heimatverein-eitensheim.de", true },
  { "heimdallr.nl", true },
  { "heimonen.eu", true },
  { "heimprofis.de", true },
  { "heinemann.io", true },
  { "heinemeier.dk", true },
  { "heinpost.nl", false },
  { "heinzelmann.co", true },
  { "heiraten-gardasee.de", true },
  { "heiraten-venedig.de", true },
  { "heissluft-fritteuse.com", true },
  { "heistheguy.com", true },
  { "heitland-it.de", true },
  { "heiwa-valve.co.jp", true },
  { "hejahanif.se", true },
  { "hejianpeng.cn", true },
  { "heka.ai", true },
  { "helber-it-services.de", true },
  { "helden-spielen.de", true },
  { "heldenhalde.de", true },
  { "heldundsexgott.de", true },
  { "heleendebruyne.be", true },
  { "helenaknowledge.com", true },
  { "helenekurtz.com", true },
  { "helenelefauconnier.com", true },
  { "helenkellersimulator.org", true },
  { "helfordriversc.co.uk", true },
  { "helichat.de", true },
  { "helikon.ro", true },
  { "helioanodyne.eu", true },
  { "helios4.com", true },
  { "heliosnet.com", true },
  { "heliosvoting.org", true },
  { "helix.am", true },
  { "hellenicagora.co.uk", true },
  { "hellerarko.de", true },
  { "hellersgas.com", true },
  { "hellerup.net", true },
  { "helles-koepfchen.de", true },
  { "helloacm.com", true },
  { "hellobrian.me", true },
  { "hellomouse.net", true },
  { "helloworldhost.com", false },
  { "hellsgamers.pw", true },
  { "hellsh.com", true },
  { "helmut-a-binser.de", true },
  { "help.simpletax.ca", true },
  { "helpconnect.com.au", true },
  { "helpgoabroad.com", true },
  { "helpmij.cf", true },
  { "helpscoutdocs.com", true },
  { "helpstarloja.com.br", true },
  { "helsinki.dating", true },
  { "helvella.de", true },
  { "hematoonkologia.pl", true },
  { "hemdal.se", true },
  { "hemnet.se", true },
  { "hemtest.com", true },
  { "hen.ne.ke", true },
  { "henchman.io", true },
  { "hendersonvalleyautomotive.co.nz", true },
  { "hendric.us", false },
  { "hendrik.li", true },
  { "hendrinortier.nl", true },
  { "hendyisaac.com", true },
  { "hengelsportdeal.com", true },
  { "hengstumone.com", true },
  { "henkboelman.com", true },
  { "henke-home.eu", true },
  { "henker.net", true },
  { "henkverlinde.com", false },
  { "henley-computer-repairs.co.uk", true },
  { "henleybouncycastles.co.uk", true },
  { "hennadesigns.org", true },
  { "hennecke-forstbetrieb.de", true },
  { "henneke.me", true },
  { "hennies.org", true },
  { "henningkerstan.de", true },
  { "hennymerkel.com", true },
  { "henok.eu", true },
  { "henriksen.is", true },
  { "henrikwelk.de", true },
  { "henrilammers.nl", true },
  { "henry.gg", true },
  { "henryphan.com", false },
  { "henrysautodetail.com", true },
  { "hentaiworld.cc", true },
  { "hentschke-bau.de", true },
  { "hentschke-betonfertigteilwerk.de", true },
  { "hentschke-invest.de", true },
  { "henzenhoning.nl", true },
  { "heppler.net", true },
  { "heptafrogs.de", true },
  { "her25.com", false },
  { "heracles-hotel.eu", true },
  { "herberichfamily.com", true },
  { "herbert.io", true },
  { "herbhuang.com", true },
  { "herbweb.net", true },
  { "herbweb.org", true },
  { "herculex.fi", true },
  { "herds.eu", true },
  { "herdserv.de", true },
  { "herebedragons.io", true },
  { "herecsrymy.cz", true },
  { "heren.fashion", true },
  { "heritagebaptistchurch.com.ph", true },
  { "herkam.pl", true },
  { "hermanbrouwer.nl", true },
  { "hermes-net.de", true },
  { "hermes.cat", true },
  { "herminghaus24.de", true },
  { "herndl.org", true },
  { "herni-kupony.cz", true },
  { "hernn.com", true },
  { "herocentral.de", true },
  { "herofil.es", true },
  { "herohirehq.co.uk", true },
  { "heroiclove.com", true },
  { "heroicpixel.com", true },
  { "heroku.com", true },
  { "heromuster.com", true },
  { "herpes-no.com", true },
  { "herranzramia.com", false },
  { "herrderzeit.de", true },
  { "herrenmuehle-wein.de", true },
  { "herringboneeats.com", true },
  { "herringsresidence.be", true },
  { "herrkaschke.com", true },
  { "herrsmith.com", true },
  { "herrtxbias.net", false },
  { "hertsbouncycastles.com", true },
  { "hertz.bj", true },
  { "herzbotschaft.de", true },
  { "herzfuersoziales.at", true },
  { "herzig.cc", true },
  { "herzogglass.com", true },
  { "hesaplama.net", true },
  { "hessen-liebe.de", true },
  { "hesslag.com", true },
  { "hestervanderheijden.nl", true },
  { "hestia-systeme.be", true },
  { "hestia-systeme.com", true },
  { "hestia-systeme.eu", true },
  { "hestia-systeme.fr", true },
  { "hesyifei.com", true },
  { "hetene.nl", true },
  { "hetluisterbos.be", true },
  { "heute-kaufen.de", true },
  { "heute.training", true },
  { "hevertonfreitas.com.br", true },
  { "hex.nl", true },
  { "hexagon-e.com", true },
  { "hexapt.com", true },
  { "hexclock.io", true },
  { "hexcode.in", true },
  { "hexed.it", true },
  { "hexiaohu.cn", true },
  { "hexicurity.com", true },
  { "hexid.me", true },
  { "hexo.io", false },
  { "hexony.com", true },
  { "hexr.org", true },
  { "hexstream.net", true },
  { "hexstream.xyz", true },
  { "hexstreamsoft.com", true },
  { "hexxagon.com", true },
  { "heywood.cloud", true },
  { "hf-tekst.nl", true },
  { "hf51.nl", true },
  { "hfox.org", true },
  { "hg.gg", true },
  { "hg.python.org", true },
  { "hgbet.com", true },
  { "hgvnet.de", true },
  { "hgw168.com", true },
  { "hh-medic.com", true },
  { "hh-wolke.dedyn.io", true },
  { "hhgdo.de", true },
  { "hhhdb.com", true },
  { "hhidr.org", true },
  { "hhmmmm.de", true },
  { "hhs.gov", true },
  { "hibari.moe", true },
  { "hiccupsandjuice.co.uk", true },
  { "hickorywinecellar.com", true },
  { "hicl.org", true },
  { "hicoria.com", true },
  { "hidbo.de", true },
  { "hiddendepth.ie", true },
  { "hiddenhillselectric.com", true },
  { "hiddenhillselectrical.com", true },
  { "hiddenhillselectrician.com", true },
  { "hiddenhillsexteriorlighting.com", true },
  { "hiddenhillslandscapelighting.com", true },
  { "hiddenhillslighting.com", true },
  { "hiddenhillsoutdoorlighting.com", true },
  { "hiddenmalta.net", true },
  { "hideallip.com", true },
  { "hideouswebsite.com", true },
  { "hidroshop.com.br", true },
  { "hieu.com.au", true },
  { "higgsboson.tk", true },
  { "higgstools.org", true },
  { "higherpress.org", true },
  { "highlatitudestravel.com", true },
  { "highlegshop.com", true },
  { "highlevelwoodlands.com", true },
  { "highlightsfootball.com", true },
  { "highlnk.com", true },
  { "highspeed-arnsberg.de", true },
  { "highspeedinternet.my", true },
  { "hightechbasementsystems.com", true },
  { "highwaytohoell.de", true },
  { "higilopocht.li", true },
  { "hijackpost.com", true },
  { "hikarukujo.com", true },
  { "hike.pics", true },
  { "hikerone.com", true },
  { "hikinggearlab.com", true },
  { "hikingguy.com", true },
  { "hilahdih.cz", true },
  { "hilaryhutler.com", true },
  { "hilchenba.ch", true },
  { "hilde.link", true },
  { "hildegardis-schule.de", true },
  { "hilfe-bei-krebs-vechta.de", true },
  { "hilfreiche-server.tips", true },
  { "hilhorst-uitvaartverzorging.nl", true },
  { "hillcountryoralsurgery.com", true },
  { "hillsboroccpa.org", true },
  { "hillstrak.com.au", true },
  { "hilltopcellar.com", true },
  { "hilnu.com", true },
  { "hiltonarubabeachservices.com", true },
  { "himcy.ga", true },
  { "himecorazon.com", true },
  { "himekomi.com", true },
  { "himens.com", true },
  { "hin10.com", true },
  { "hinata-hidetoshi.com", true },
  { "hindi-movie.org", true },
  { "hindimoviedownload.net", true },
  { "hindimovieonline.net", true },
  { "hintergrundbewegung.de", true },
  { "hinterhofbu.de", true },
  { "hinterposemuckel.de", true },
  { "hiparish.org", true },
  { "hiphop.ren", true },
  { "hippies.com.br", true },
  { "hippo.ge", true },
  { "hippomovers.com", true },
  { "hippopotamuses.org", true },
  { "hips.com", true },
  { "hipstercat.fr", true },
  { "hiqfleet.co.uk", true },
  { "hiqfranchise.co.uk", true },
  { "hiqhub.co.uk", false },
  { "hiqonline.co.uk", true },
  { "hirakatakoyou.org", true },
  { "hirake55.com", true },
  { "hiratake.xyz", true },
  { "hire-a-coder.de", true },
  { "hireabouncycastle.net", true },
  { "hiresteve.ca", true },
  { "hirevo.eu", true },
  { "hirezzportal.com", true },
  { "hiring-process.com", true },
  { "hiromuogawa.com", true },
  { "hirotaka.org", true },
  { "hirtzfr.eu", true },
  { "hirzaconsult.ro", true },
  { "hisbrucker.net", true },
  { "hisgifts.com.au", true },
  { "hisingensck.se", true },
  { "hispanic.dating", true },
  { "histocamp.de", true },
  { "histoire-cite.ch", true },
  { "historia-arte.com", true },
  { "history-schools.com", true },
  { "history.google.com", false },
  { "hitandhealth.nl", true },
  { "hiteco.com", true },
  { "hiteshbrahmbhatt.com", true },
  { "hititgunesi-tr.com", true },
  { "hitmanstat.us", true },
  { "hitn.at", true },
  { "hitoapi.cc", true },
  { "hitocom.net.br", true },
  { "hitokoto-mania.com", true },
  { "hitokoto.cn", true },
  { "hitomecha.com", true },
  { "hitrek.ml", true },
  { "hitter-lauzon.com", true },
  { "hitter.family", true },
  { "hitterfamily.com", true },
  { "hiv-symptome.de", true },
  { "hiv.com.tw", true },
  { "hiv.gov", true },
  { "hivatalinfo.hu", true },
  { "hiverlune.net", false },
  { "hiwiki.tk", true },
  { "hiyacar.co.uk", true },
  { "hiyobi.me", true },
  { "hiyuki2578.net", true },
  { "hizzacked.xxx", true },
  { "hj-mosaiques.be", true },
  { "hj.rs", true },
  { "hj3455.com", true },
  { "hj99vip.com", true },
  { "hjartasmarta.se", true },
  { "hjkbm.cn", true },
  { "hjort.land", true },
  { "hjortland.org", true },
  { "hjphoto.co.uk", true },
  { "hjtky.cn", true },
  { "hjw-kunstwerk.de", true },
  { "hjyl9898.com", true },
  { "hk.search.yahoo.com", false },
  { "hkbsurgery.com", true },
  { "hkdobrev.com", true },
  { "hkr.at", true },
  { "hks-projekt.at", true },
  { "hks.pw", true },
  { "hktkl.com", true },
  { "hkustmbajp.com", true },
  { "hl7999.com", true },
  { "hl8999.com", true },
  { "hlavacek.us", true },
  { "hlavi.hu", true },
  { "hledejlevne.cz", true },
  { "hledejpravnika.cz", true },
  { "hlfh.space", true },
  { "hlidacnajemneho.cz", true },
  { "hlin.cloud", true },
  { "hlinformatics.nl", true },
  { "hloe0xff.ru", true },
  { "hlsmandarincentre.com", true },
  { "hlucas.de", true },
  { "hm773.net", true },
  { "hm773.org", true },
  { "hmcdj.cn", true },
  { "hmhotelec.com", false },
  { "hmoegirl.com", true },
  { "hms-waldmann.de", true },
  { "hmsseahawk.com", true },
  { "hn.search.yahoo.com", false },
  { "hnfertilizermachine.com", true },
  { "hnn.net.br", true },
  { "hnonline.sk", true },
  { "hnwebi.com", true },
  { "hnyp.hu", true },
  { "hoaas.no", true },
  { "hoahau.org", true },
  { "hoarding.me", true },
  { "hobby-drechselei.de", true },
  { "hobbyspeed.com", true },
  { "hochhaus.us", true },
  { "hochoukikikiraku.com", true },
  { "hochyi.com", true },
  { "hochzeit-dana-laurens.de", true },
  { "hochzeitsfotograf-deinfoto.ch", true },
  { "hochzeitsgezwitscher.de", true },
  { "hochzeitsplanerin-hamburg.de", true },
  { "hockeyapp.ch", true },
  { "hockeymotion.ch", true },
  { "hodgephotography.com", true },
  { "hodnos.com", true },
  { "hoe.re", true },
  { "hoeft-autolackierung.de", true },
  { "hoekvanholland.eu", true },
  { "hoepli.it", true },
  { "hoeren.club", true },
  { "hoesnelwasik.nl", true },
  { "hoeveiligismijn.nl", true },
  { "hoevenstein.nl", false },
  { "hoewler.ch", true },
  { "hoezzi.nl", true },
  { "hof-mulin.ch", true },
  { "hofapp.de", true },
  { "hofauer.de", true },
  { "hoflerlawfirm.com", true },
  { "hogarthdavieslloyd.com", true },
  { "hogepad.com", true },
  { "hogl.dk", true },
  { "hogrebe.de", true },
  { "hogwarts.io", true },
  { "hohenleimbach.de", true },
  { "hohm.in", true },
  { "hoikuen-now.top", true },
  { "hoiquanadida.com", true },
  { "hoish.in", true },
  { "hoken-wakaru.jp", true },
  { "hokieprivacy.org", true },
  { "hokioisecurity.com", true },
  { "holad.de", true },
  { "holadinero.es", true },
  { "holadinero.mx", true },
  { "holboxwhalesharktours.com", true },
  { "holebedeljek.hu", true },
  { "holidaysportugal.eu", true },
  { "holisticacupuncture.com.au", true },
  { "holistichealer.in", true },
  { "holisticon.de", true },
  { "hollandsdiep.nl", true },
  { "hollermann.eu", true },
  { "hollo.me", true },
  { "hollowpoint.xyz", true },
  { "hollowrap.com", true },
  { "hollyforrest.ca", true },
  { "hollyforrestphotography.ca", true },
  { "holmesian.org", true },
  { "holmq.dk", true },
  { "holo.ovh", true },
  { "holodeck.us", true },
  { "holofono.com", true },
  { "holofox.ru", true },
  { "holoxplor.space", true },
  { "holvonix.com", true },
  { "holycrossphl.org", true },
  { "holycrossverobeach.org", true },
  { "holydragoon.jp", true },
  { "holyfamilyphilly.org", true },
  { "holyfamilyrussell.org", true },
  { "holyghost-church.org", true },
  { "holygrail.games", true },
  { "holyhiphopdatabase.com", true },
  { "holymartyrschurch.org", true },
  { "holyspiritpalmyra.com", true },
  { "holyspiritweb.org", true },
  { "holytransaction.com", true },
  { "holywhite.com", true },
  { "holz.nu", true },
  { "holzheizer-forum.de", true },
  { "holzheizerforum.de", true },
  { "holzschutz-holzbearbeitung.de", true },
  { "holzspielzeug-shop.ch", true },
  { "holzstueckwerk.de", true },
  { "holzundgarten.de", true },
  { "holzvergaser-forum.de", true },
  { "homatism.com", true },
  { "hombresconestilo.com", true },
  { "home-handymen.co.uk", true },
  { "homeautomated.com", true },
  { "homebasedsalons.com.au", true },
  { "homebodyalberta.com", true },
  { "homecareassociatespa.com", true },
  { "homecheck.gr", true },
  { "homefacialpro.com", false },
  { "homegardeningforum.com", true },
  { "homegardenresort.nl", true },
  { "homegreenmark.com", true },
  { "homehuntertoronto.com", true },
  { "homeimagician.com.au", true },
  { "homem-viril.com", true },
  { "homeodynamics.com", true },
  { "homeofjones.net", true },
  { "homeogenium.com", true },
  { "homeownersinsurancenevada.com", true },
  { "homeownersinsurancenv.com", true },
  { "homepage.shiga.jp", true },
  { "homeporn.stream", true },
  { "homeprivate.de", true },
  { "homes-in-norcal.com", true },
  { "homes-in-stockton.com", true },
  { "homeseller.com", true },
  { "homeserver-kp.de", true },
  { "homestay.id", true },
  { "homesteadandprepper.com", true },
  { "homesteadfarm.org", true },
  { "homewatt.co.uk", true },
  { "homeyou.com", true },
  { "hommeatoutfaire.be", true },
  { "homophoni.com", true },
  { "hompus.nl", false },
  { "homyremedies.com", true },
  { "hon-matsuba.co.jp", true },
  { "honda-centrum.cz", true },
  { "hondart.cz", true },
  { "hondenoppasfraneker.nl", true },
  { "honey.beer", true },
  { "honey.is", true },
  { "honeybadger.io", false },
  { "honeycome.net", true },
  { "honeycreeper.com", true },
  { "honeyhaw.com", true },
  { "honeypot.net", true },
  { "hong.io", true },
  { "hongoi.com", true },
  { "honkion.net", true },
  { "honovere.de", true },
  { "hontoir.eu", true },
  { "hoodtrader.com", true },
  { "hoofddorp-centraal.nl", true },
  { "hookany.com", true },
  { "hookbin.com", true },
  { "hoooc.com", true },
  { "hooowl.com", true },
  { "hoop.la", true },
  { "hoopertechnicalsolutions.com", true },
  { "hooplessinseattle.com", true },
  { "hooray.beer", true },
  { "hoorr.com", true },
  { "hoosa.de", true },
  { "hootworld.net", false },
  { "hoovism.com", true },
  { "hoowhen.cn", true },
  { "hopconseils.ch", true },
  { "hopconseils.com", true },
  { "hope-line-earth.jp", true },
  { "hopemeet.info", true },
  { "hopemeet.me", true },
  { "hopesanddreams.org.uk", true },
  { "hopla.sg", true },
  { "hoplongtech.com", true },
  { "hoponmedia.de", true },
  { "hopps.me", true },
  { "hoppyx.com", true },
  { "hopzone.net", true },
  { "hor.website", true },
  { "horaceli.com", true },
  { "horackova.info", true },
  { "horairetrain.fr", true },
  { "hord.ca", true },
  { "horecaapparatuurkobezuijen.nl", true },
  { "horecatiger.eu", true },
  { "horeco.com", true },
  { "horeizai.net", true },
  { "horizonhomes-samui.com", true },
  { "horizonlawncare.tk", true },
  { "horizonresourcesinc.com", true },
  { "horizonshypnosis.ca", true },
  { "horn.co", true },
  { "hornertranslations.com", true },
  { "hornyforhanzo.com", true },
  { "horodance.dk", true },
  { "horrell.ca", true },
  { "horror-forum.de", true },
  { "horrormovies.gr", true },
  { "horsehunter.co.uk", true },
  { "horstmanshof.eu", true },
  { "horton-brasses.com", true },
  { "hory.me", true },
  { "horza.org", true },
  { "hoshimaq.com.br", true },
  { "hoshimaquinas.com.br", true },
  { "hoshinplan.com", true },
  { "hoshisato.com", true },
  { "hosiet.me", true },
  { "hosmussynergie.nl", false },
  { "hospitalhomelottery.org", true },
  { "hospitality-colleges.com", true },
  { "hostadvice.com", true },
  { "hostarea51.com", true },
  { "hostcoz.com", true },
  { "hosteasy.nl", false },
  { "hostedcomments.com", true },
  { "hostedtalkgadget.google.com", true },
  { "hostfission.com", true },
  { "hostgigz.com", true },
  { "hostico.ro", true },
  { "hostinecpodlipou.cz", true },
  { "hosting-swiss.ch", true },
  { "hostingactive.it", true },
  { "hostinghelp.guru", true },
  { "hostinginnederland.nl", true },
  { "hostinglogin.net", true },
  { "hostingphp.ch", true },
  { "hostingpunt.be", true },
  { "hostingsolutions.cz", true },
  { "hostix.de", true },
  { "hostma.ma", true },
  { "hostmark.pl", true },
  { "hostme.co.il", true },
  { "hostmijnpagina.nl", true },
  { "hostmodern.com.au", true },
  { "hosts.cf", true },
  { "hostworkz.com", true },
  { "hotcandlestick.com", true },
  { "hotchillibox.com", true },
  { "hotcoin.io", true },
  { "hotdoc.com.au", true },
  { "hotel-kontorhaus-stralsund.de", true },
  { "hotel-kontorhaus.de", true },
  { "hotel-kronjuwel.de", true },
  { "hotel-le-vaisseau.ch", true },
  { "hotel-pension-sonnalp.eu", true },
  { "hotel-rosner.at", true },
  { "hotelamgarnmarkt.at", false },
  { "hotelarevalo.com", true },
  { "hotelbretagne.dk", true },
  { "hotelcoliber.pl", true },
  { "hoteles4you.com", true },
  { "hotelflow.com.br", true },
  { "hotelident.de", true },
  { "hotello.io", true },
  { "hotelmap.com", true },
  { "hotelpostaorvieto.it", true },
  { "hotelromacuernavaca.com.mx", true },
  { "hotels-insolites.com", true },
  { "hotels3d.com", true },
  { "hotels4teams.com", true },
  { "hotelsinbuxton.com", true },
  { "hotelsinformer.com", true },
  { "hotelsinncoventry.com", true },
  { "hotelvalena.com", true },
  { "hotelvillaluisa.de", true },
  { "hothbricks.com", true },
  { "hotnewhiphop.com", true },
  { "hoto.us", true },
  { "hoton.in", true },
  { "hotplate.co.nz", true },
  { "hotplug.gr", true },
  { "hottaro.com", true },
  { "hottheme.net", true },
  { "hotting.nl", true },
  { "hottubhirenewcastle.co.uk", true },
  { "hottubspasnewcastle.co.uk", true },
  { "houdremont-la-courneuve.info", true },
  { "houraiteahouse.net", true },
  { "house-of-japan.co.jp", true },
  { "house-sparrow.com", true },
  { "houseboydesigns.com", true },
  { "housekeeperlondon.co.uk", true },
  { "houseofherbs.gr", true },
  { "houseofhouston.com", true },
  { "houseofyee.com", true },
  { "houser.lu", true },
  { "housese.at", true },
  { "houstonapartmentinsiders.com", true },
  { "houstonauthorizedrepair.com", true },
  { "houstoncreditlaw.com", true },
  { "houstontxlocksmiths.com", true },
  { "houtinee.com", true },
  { "hoverboardbarato.com", true },
  { "how2play.pl", true },
  { "howa-n.net", true },
  { "howardtyson.com", true },
  { "howbehealthy.com", true },
  { "howbigismybuilding.com", true },
  { "howellaccounts.co.uk", true },
  { "howgoodwasmysex.com", true },
  { "howieisawesome.com", true },
  { "howlongtobeatsteam.com", true },
  { "howmanymilesfrom.com", true },
  { "howsecureismypassword.net", true },
  { "howsmyssl.com", true },
  { "howsyourhealth.org", true },
  { "howtocommunicate.com.au", true },
  { "howtogeek.com", true },
  { "howtogeekpro.com", true },
  { "howtogosolar.org", true },
  { "howtolaser.com", true },
  { "howtoteachviolin.com", true },
  { "howtotech.de", true },
  { "hozana.si", false },
  { "hp-work.net", true },
  { "hp42.de", true },
  { "hpac-portal.com", true },
  { "hpage.com", true },
  { "hpbn.co", true },
  { "hpisavageforum.com", true },
  { "hpkp-faq.de", true },
  { "hps.digital", true },
  { "hps.hu", true },
  { "hpsdigital.hu", true },
  { "hqhh.org", true },
  { "hquest.pro.br", true },
  { "hqwebhosting.tk", false },
  { "hqy.moe", true },
  { "hr-tech.shop", true },
  { "hrabogados.com", true },
  { "hraesvelg.net", true },
  { "hranicka.cz", true },
  { "hrbatypes.cz", true },
  { "hrbl.lc", true },
  { "hrdns.de", false },
  { "href.one", true },
  { "hreflang.info", true },
  { "hrjfeedstock.org", true },
  { "hrltech.com.br", true },
  { "hrobert.hu", true },
  { "hroling.nl", true },
  { "hroschyk.cz", true },
  { "hrsa.gov", true },
  { "hrstapps-dev.com", true },
  { "hrtech.shop", true },
  { "hryniewski.net", true },
  { "hryx.net", true },
  { "hs-arbeitsschutz.de", true },
  { "hs-group.net", true },
  { "hs-umformtechnik.de", true },
  { "hsappstatic.net", true },
  { "hscorp.de", true },
  { "hsivonen.com", true },
  { "hsivonen.fi", true },
  { "hsivonen.iki.fi", true },
  { "hsmr.cc", true },
  { "hsr.gov", false },
  { "hsts.eu", true },
  { "hsts.me", true },
  { "hstsfail.appspot.com", true },
  { "hstspreload.appspot.com", true },
  { "hstspreload.com", true },
  { "hstspreload.de", true },
  { "hstspreload.org", true },
  { "hsulei.com", true },
  { "hszemi.de", true },
  { "htaccessbook.com", true },
  { "htaps.com", true },
  { "hte.ovh", true },
  { "hti.digital", true },
  { "html.moe", true },
  { "html5.org", true },
  { "html5media.info", true },
  { "htmlacademy.ru", true },
  { "htmlvalidator.com", true },
  { "htmlyse.com", true },
  { "htmue.net", true },
  { "htmue.org", true },
  { "htsure.ma", true },
  { "http2.eu", true },
  { "http2.pro", true },
  { "https-rulesets.org", true },
  { "https.dk", true },
  { "https.jetzt", true },
  { "https4all.org", true },
  { "httpsalarm.com", true },
  { "httpsecured.net", true },
  { "httpsecurityreport.com", true },
  { "httpsiseasy.com", true },
  { "httpsispisseasy.com", true },
  { "httpsnow.com", true },
  { "httpsnow.org", true },
  { "httpswatch.ca", true },
  { "httpswatch.com", true },
  { "hu.search.yahoo.com", false },
  { "hu8188.com", true },
  { "hu8518.com", true },
  { "hu8555.com", true },
  { "hu8588.com", true },
  { "hu8777.com", true },
  { "hu8bet.com", true },
  { "hu8hu8.com", true },
  { "huagati.com", true },
  { "huahinpropertylisting.com", true },
  { "huang-haitao.com", true },
  { "huangjia71.com", true },
  { "huangjia72.com", true },
  { "huangjia73.com", true },
  { "huangjia74.com", true },
  { "huangjia75.com", true },
  { "huangjia76.com", true },
  { "huangjia77.com", true },
  { "huangjia78.com", true },
  { "huangjia79.com", true },
  { "huangjia99.com", true },
  { "huangjiaint.com", true },
  { "huangjingjing.com", true },
  { "huangzenghao.cn", false },
  { "huaqian.art", true },
  { "huashan.co.uk", true },
  { "hub.org.ua", true },
  { "hub385.com", true },
  { "hubapi.com", true },
  { "huber-informatik.de", true },
  { "hubok.net", true },
  { "hubspot.com", true },
  { "huchet.me", true },
  { "hudebnibazarmixer.cz", true },
  { "hudrydum.cz", true },
  { "hudsonfaceandeye.com", true },
  { "huduser.gov", true },
  { "huendeleskopfhuette.de", true },
  { "huersch.com", true },
  { "hues-in-lee.de", true },
  { "huffduffer.com", true },
  { "huffsinsurance.com", true },
  { "hughtodd.ink", true },
  { "hugi.is", true },
  { "hugizrecords.com", true },
  { "huglen.info", true },
  { "hugo.pro", true },
  { "hugo6.com", true },
  { "hugofs.com", true },
  { "hugolynx.fr", true },
  { "huguesblanchard.paris", true },
  { "huguesditciles.com", true },
  { "huh.gdn", true },
  { "huh.today", true },
  { "huihui.moe", true },
  { "huininga.com", true },
  { "huininga.nl", true },
  { "huininga.org", true },
  { "huirongis.me", true },
  { "huisartsenpraktijkheemraadssingel.nl", true },
  { "huisartsenpraktijksonmezer.nl", true },
  { "huisartsenpraktijkzonnehoed.nl", true },
  { "huisjeboompje-baby.nl", true },
  { "huislaw.com", true },
  { "huislijn.nl", true },
  { "huissier-vosges.com", true },
  { "huitaodang.com", true },
  { "hukutuu.com", true },
  { "hulet.tech", true },
  { "hulldevs.net", true },
  { "hulpbijmarketing.nl", true },
  { "hulpmiddelenshop.nl", true },
  { "human-clone.com", true },
  { "humanenrich.com", true },
  { "humanesources.com", true },
  { "humanity.com", true },
  { "humans.io", true },
  { "humanzee.com", true },
  { "humass.nl", true },
  { "humblebee.at", true },
  { "humblebee.be", true },
  { "humblebee.bg", true },
  { "humblebee.ch", true },
  { "humblebee.co.in", true },
  { "humblebee.co.uk", true },
  { "humblebee.com.mx", true },
  { "humblebee.com.ph", true },
  { "humblebee.cz", true },
  { "humblebee.dk", true },
  { "humblebee.eu", true },
  { "humblebee.foundation", true },
  { "humblebee.fr", true },
  { "humblebee.gr", true },
  { "humblebee.hu", true },
  { "humblebee.ie", true },
  { "humblebee.it", true },
  { "humblebee.me.uk", true },
  { "humblebee.nz", true },
  { "humblebee.pl", true },
  { "humblebee.uk", true },
  { "humblebee.us", true },
  { "humblebeeshop.ca", true },
  { "humblebeeshop.com.au", true },
  { "humbledot.com", true },
  { "humboldthomeguide.com", true },
  { "humboldtmfg.com", true },
  { "humeur.de", true },
  { "humexe.com", true },
  { "hummy.tv", true },
  { "humorcaliente.com", true },
  { "humpchies.com", true },
  { "humpen.se", true },
  { "humppakone.com", true },
  { "hund.io", true },
  { "hundeformel.de", true },
  { "hundesport-psvhalle.de", true },
  { "hundeverwaltung.de", true },
  { "hundter.com", true },
  { "hunger.im", true },
  { "huniverse.co", true },
  { "hunstoncanoeclub.co.uk", true },
  { "hunter-read.com", true },
  { "hunter.io", true },
  { "hunterkehoe.com", true },
  { "huntexpired.com", true },
  { "huntingdonbouncers.co.uk", true },
  { "huntingdonlifesciences.com", true },
  { "huntshomeinspections.com", false },
  { "huntsmansecurity.com", true },
  { "huntsvillecottage.ca", true },
  { "huonit.com.au", true },
  { "hup.hu", true },
  { "hupp.se", true },
  { "hurd.is", true },
  { "huren.nl", true },
  { "huroji.com", true },
  { "hurtigtinternet.dk", true },
  { "husakbau.at", true },
  { "hushfile.it", true },
  { "husic.net", false },
  { "huskyeye.de", true },
  { "huskyinc.us", true },
  { "hussam.eu.org", true },
  { "hustlehope.com", true },
  { "hustunique.com", true },
  { "huto.ml", true },
  { "huurwoordenaar.nl", true },
  { "huutonauru.net", true },
  { "huwcbjones.co.uk", true },
  { "huwcbjones.uk", true },
  { "huxcoconstruction.com", true },
  { "huxley.net", true },
  { "huynhviet.com", true },
  { "huyvu.nl", true },
  { "hvdbox.de", true },
  { "hveradistributions.com", true },
  { "hverdagogkink.no", true },
  { "hvh.no", true },
  { "hvmk.nl", true },
  { "hvrint.de", true },
  { "hvtuananh.com", true },
  { "hwaddress.com", true },
  { "hwag-pb.de", true },
  { "hwlibre.com", true },
  { "hx53.de", true },
  { "hxp.io", true },
  { "hxsf.me", true },
  { "hxying.com", true },
  { "hybridworx.com", true },
  { "hybridworx.de", true },
  { "hybridworx.eu", true },
  { "hybridworx.net", true },
  { "hybridworx.org", true },
  { "hybula.com", true },
  { "hycken.com", true },
  { "hyckenberg.com", true },
  { "hyderabadonlinegifts.com", true },
  { "hydrasolutions.de", true },
  { "hydrazin.pw", true },
  { "hydro17.com", true },
  { "hydroagro.pl", true },
  { "hydrographicsocietybenelux.eu", true },
  { "hydroturbine.info", true },
  { "hydrozone.fr", true },
  { "hyec.jp", true },
  { "hygo.com", true },
  { "hyk.me", true },
  { "hylemorphica.org", true },
  { "hynek.me", true },
  { "hyparia.fr", true },
  { "hype.ru", true },
  { "hypeitems.pl", true },
  { "hypemgmt.com", true },
  { "hyper-text.org", true },
  { "hyperalgesia.com", true },
  { "hyperautomotive.com.au", true },
  { "hyperbolic-mayonnaise-interceptor.ovh", true },
  { "hyperion.io", true },
  { "hyperreal.biz", true },
  { "hypersomnia.com", true },
  { "hyperstack.org", true },
  { "hyperthymia.com", true },
  { "hyphen.co.za", true },
  { "hyphenpda.co.za", true },
  { "hypotecnicentrum.cz", true },
  { "hypothecairelening.net", true },
  { "hypotheekbond.nl", true },
  { "hypothes.is", true },
  { "hypothyroidmom.com", true },
  { "hyr.mn", true },
  { "hytzongxuan.com", true },
  { "hyundai.no", true },
  { "hyvanilmankampaamo.fi", true },
  { "hyvinvointineuvoja.fi", true },
  { "hztgzz.com", true },
  { "i-aloks.ru", true },
  { "i-geld.de", true },
  { "i-hakul.net", true },
  { "i-logic.co.jp", false },
  { "i-meto.com", true },
  { "i-office.com.vn", true },
  { "i-proswiss.com", true },
  { "i-red.info", true },
  { "i-scream.space", true },
  { "i-sports.cz", true },
  { "i-stuff.site", true },
  { "i-telligence.de", true },
  { "i-verbi.it", true },
  { "i00.eu", true },
  { "i1314.gdn", true },
  { "i1place.com", true },
  { "i2b.ro", true },
  { "i2gether.org.uk", true },
  { "i5y.co.uk", true },
  { "i5y.org", true },
  { "i66.me", true },
  { "i879.com", true },
  { "ia.net", true },
  { "iaco.li", true },
  { "iacono.com.br", false },
  { "iactu.info", true },
  { "iaeste.no", true },
  { "iaeste.or.jp", true },
  { "iaf.gov", true },
  { "iahemobile.net", false },
  { "iainsimms.co.uk", true },
  { "iainsimms.com", true },
  { "iainsimms.me", true },
  { "iaitouzi.com", true },
  { "ialis.me", true },
  { "iam.lc", true },
  { "iam.soy", true },
  { "iamanewme.com", true },
  { "iambozboz.co.uk", true },
  { "iamcarrico.com", true },
  { "iamcryptoki.com", true },
  { "iamhansen.xyz", true },
  { "iaminashittymood.today", true },
  { "iamjoshellis.com", true },
  { "iamlbk.com", true },
  { "iamlzh.com", true },
  { "iamtheib.me", true },
  { "iamtonyarthur.com", true },
  { "iamusingtheinter.net", true },
  { "iamwoodbeard.com", true },
  { "ianbrault.com", true },
  { "iandouglasscott.com", true },
  { "iane-ccs.com", true },
  { "ianix.com", true },
  { "ianjmoriarty.com", true },
  { "ianklug.com", true },
  { "iankmusic.com", true },
  { "ianmooreis.me", true },
  { "ianmoriarty.com.au", true },
  { "ianwalsh.org", false },
  { "iap.network", true },
  { "ias-gruppe.net", true },
  { "iassess.eu", true },
  { "iatfei.com", true },
  { "iavian.com", true },
  { "iba.community", true },
  { "ibacktraced.it", true },
  { "ibaq.nl", true },
  { "ibauruapan.com.mx", true },
  { "ibcmed.org", true },
  { "ibe.de", true },
  { "ibeep.com", true },
  { "iberiaversicherungen.com", true },
  { "ibericaderedes.es", true },
  { "ibexcore.com", true },
  { "ibigawamizueco.com", true },
  { "ibin.co", true },
  { "ibiu.xyz", true },
  { "ibiz.mk", true },
  { "iblackfriday.ro", true },
  { "ibodyiq.com", true },
  { "ibrainmedicine.org", true },
  { "ibrom.eu", true },
  { "ibstyle.tk", true },
  { "ibuki.run", true },
  { "ibutikk.no", true },
  { "ibwc.gov", true },
  { "ibykos.com", true },
  { "ic-lighting.com.au", true },
  { "ic-spares.com", true },
  { "ic3.gov", true },
  { "icafecash.com", true },
  { "icanhasht.ml", true },
  { "icarlos.net", true },
  { "icasture.top", true },
  { "icbemp.gov", true },
  { "iccpublisher.com", true },
  { "ice.xyz", true },
  { "iceberg.academy", true },
  { "icebook.co.uk", true },
  { "icecars.net", true },
  { "icetiger.eu", true },
  { "ich-hab-die-schnauze-voll-von-der-suche-nach-ner-kurzen-domain.de", true },
  { "ich-tanke.de", true },
  { "ichbinein.org", true },
  { "ichbinkeinreh.de", true },
  { "ichmachdas.net", true },
  { "iclart.com", true },
  { "iclinic.ua", true },
  { "icloudlogin.com", true },
  { "icmhd.ch", true },
  { "icmp2018.org", true },
  { "icnsoft.cf", true },
  { "icobench.com", true },
  { "icodeconnect.com", true },
  { "icoh.it", true },
  { "iconomi.net", true },
  { "icowhitepapers.co", true },
  { "icpc.pp.ua", true },
  { "icq-project.net", true },
  { "icsadviseurs.nl", true },
  { "icsfinomornasco.gov.it", true },
  { "icsfinomornasco.it", true },
  { "ict-concept.nl", false },
  { "ict-crew.nl", true },
  { "ict-radar.com", true },
  { "ict-radar.nl", true },
  { "ictcareer.ch", true },
  { "ictl.eu", true },
  { "ictradar.com", true },
  { "icyapril.com", true },
  { "icymint.me", true },
  { "icynet.eu", true },
  { "iczc.cz", true },
  { "id-blog.ch", true },
  { "id.atlassian.com", true },
  { "id.mayfirst.org", false },
  { "id.search.yahoo.com", false },
  { "id0-rsa.pub", true },
  { "id7.fr", true },
  { "idaeus.eu", true },
  { "idahoansforliberty.net", true },
  { "idarv.com", true },
  { "idaspis.com", true },
  { "idatha.de", true },
  { "idc-business.be", true },
  { "idconsult.nl", true },
  { "idealimplant.com", true },
  { "idealinflatablehire.co.uk", true },
  { "idealninajemce.cz", false },
  { "idealsegurancaeletronica.com.br", false },
  { "idealtruss.com", true },
  { "idealtruss.com.tw", true },
  { "idealwhite.space", true },
  { "ideaman924.com", true },
  { "ideasenfoto.com", true },
  { "ideashop.com", true },
  { "ideaweb.de", true },
  { "idenamaislami.com", true },
  { "idensys.nl", false },
  { "ident-clinic.be", true },
  { "identassist.com", true },
  { "identifyme.net", true },
  { "identigraf.center", true },
  { "identity.plus", true },
  { "identitytheft.gov", true },
  { "idered.net", true },
  { "idesignstudio.de", true },
  { "idesoft.cloud", true },
  { "idesoftinnovacion.com", true },
  { "idesoftinnovacion.es", true },
  { "idexxpublicationportal.com", true },
  { "idfy.io", true },
  { "idgard.de", false },
  { "idgateway.co.uk", true },
  { "idhosts.co.id", true },
  { "idid.tk", true },
  { "idiotentruppe.de", true },
  { "idisposable.co.uk", true },
  { "idlethoughtsandramblings.com", true },
  { "idmanagement.gov", true },
  { "idmobile.co.uk", true },
  { "idndx.com", true },
  { "idoc24.com", true },
  { "idodiandina.com", true },
  { "idolf.dk", true },
  { "idolknow.com", true },
  { "idolshop.dk", true },
  { "idolshop.me", true },
  { "idontplaydarts.com", true },
  { "idoparadoxon.hu", true },
  { "idranktoomuch.coffee", true },
  { "idratherbequilting.com", true },
  { "idraulico-roma.it", true },
  { "idraulico-roma.org", true },
  { "idraulico.roma.it", true },
  { "idrinktoomuch.coffee", true },
  { "idrissi.eu", true },
  { "idrottsnaprapaten.se", true },
  { "idrycleaningi.com", true },
  { "idtheft.gov", true },
  { "idubaj.cz", true },
  { "idunno.org", true },
  { "idvl.de", true },
  { "idxforza.com", true },
  { "ie.search.yahoo.com", false },
  { "iea-annex61.org", true },
  { "ieedes.com", true },
  { "ieeedeis.org", true },
  { "ieeesb.nl", true },
  { "ieeesbe.nl", true },
  { "ieeespmb.org", true },
  { "ieffalot.me", true },
  { "ieji.de", false },
  { "iemb.tk", true },
  { "ienakanote.com", false },
  { "ies-italia.it", true },
  { "iesonline.co.in", true },
  { "ieval.ro", true },
  { "iewar.com", true },
  { "ifangpei.cn", true },
  { "ifangpei.com.cn", true },
  { "ifcfg.jp", true },
  { "ifelse.io", true },
  { "ifengge.cn", true },
  { "ifengge.me", true },
  { "ifgcdn.com", true },
  { "ifibe.com", true },
  { "ifightsurveillance.com", true },
  { "ifightsurveillance.net", true },
  { "ifightsurveillance.org", true },
  { "ifixe.ch", true },
  { "iflare.de", true },
  { "ifort.fr", true },
  { "ifosep.fr", true },
  { "ifoss.me", true },
  { "ifsac.org", true },
  { "ifsclist.com", true },
  { "ifsr.de", true },
  { "iftarsaati.org", true },
  { "iftrue.de", true },
  { "ifttl.com", false },
  { "ifxd.bid", true },
  { "ifyou.live", true },
  { "ig.com", true },
  { "iga-semi.jp", true },
  { "igcc.jp", true },
  { "igeh-immo.at", true },
  { "igglabs.com", true },
  { "iggprivate.com", true },
  { "iggsoft.com", true },
  { "iggsoftware.com", true },
  { "igiftcards.de", true },
  { "igimusic.com", true },
  { "igk.nz", true },
  { "igm-be.ch", true },
  { "igmus.org", true },
  { "ignace72.eu", true },
  { "ignacjanskiednimlodziezy.pl", true },
  { "ignat-mag.com", true },
  { "ignat.by", true },
  { "ignatovich.by", true },
  { "ignatovich.me", true },
  { "ignet.gov", true },
  { "ignitedlocal.com", true },
  { "ignitedmindz.in", true },
  { "ignitelocal.com", true },
  { "igorrealestate.com", true },
  { "igorw.org", true },
  { "igotoffer.com", false },
  { "igrivi.com", true },
  { "igsmgmt.com", true },
  { "iguana.com.ec", false },
  { "ih8sn0w.com", true },
  { "ihacklabs.com", true },
  { "ihakkitekin.com", true },
  { "ihatethissh.it", true },
  { "ihcprofile.com", true },
  { "iheartmary.org", true },
  { "ihkk.net", true },
  { "ihls.stream", true },
  { "ihmphila.org", true },
  { "ihoey.com", true },
  { "ihollaback.org", true },
  { "ihopeit.works", true },
  { "ihostup.net", true },
  { "ihotel.io", false },
  { "ihrhost.com", true },
  { "ihtdenisjaccard.com", true },
  { "ihuan.me", true },
  { "ii74.com", true },
  { "iiit.pl", true },
  { "iimarckus.org", true },
  { "iiong.com", true },
  { "iirii.com", true },
  { "iix.se", true },
  { "ijm.io", true },
  { "ijohan.nl", true },
  { "ijr.com", true },
  { "ijsbaanwitten.nl", true },
  { "ijsblokjesvormen.nl", true },
  { "ijsclubtilburg.nl", true },
  { "ijsclubwanneperveen.nl", true },
  { "ijunohana.jp", true },
  { "ik-life.com", true },
  { "ikachalife.com", true },
  { "ikarate.ru", true },
  { "ikarr.com", true },
  { "ikeacareers.co.uk", true },
  { "ikebuku.ro", true },
  { "ikebukuro-shame.com", true },
  { "ikedaquotes.org", true },
  { "ikespta.com", true },
  { "ikeyless.com", true },
  { "ikigaiweb.com", true },
  { "ikiler.com", true },
  { "ikinokori-marketing.com", true },
  { "ikk.me", true },
  { "ikkatsu-satei.jp", true },
  { "ikkbb.de", true },
  { "ikke-coach.nl", true },
  { "ikkev.de", true },
  { "ikkoku.de", true },
  { "iklive.org", false },
  { "ikraenglish.com", true },
  { "ikulist.me", true },
  { "ikumi.us", true },
  { "ikuuuu.com", true },
  { "ikvts.de", true },
  { "ikwilthepiratebay.org", true },
  { "ikxkx.com", true },
  { "ila.fi", true },
  { "ilamparas.at", true },
  { "ilamparas.co.uk", true },
  { "ilamparas.com", true },
  { "ilamparas.com.co", true },
  { "ilamparas.com.ve", true },
  { "ilamparas.mx", true },
  { "ilard.fr", true },
  { "ilazycat.com", true },
  { "ile-kalorii.pl", true },
  { "ile-sapporo.jp", true },
  { "ileci.de", true },
  { "ilektronika-farmakeia-online.gr", true },
  { "ilemonrain.com", true },
  { "ilformichiere.com", true },
  { "ilhan.name", true },
  { "ilhansubasi.com", true },
  { "iliastsi.net", true },
  { "iligang.cn", true },
  { "iligang.com", true },
  { "iligang.link", true },
  { "iligang.xin", true },
  { "ilkeakyildiz.com", true },
  { "illambias.ch", true },
  { "illative.net", true },
  { "illegalpornography.com", true },
  { "illegalpornography.me", true },
  { "illerzell.de", true },
  { "illich.cz", true },
  { "illicitart.ca", true },
  { "illicitdigital.com", true },
  { "illjinx.info", true },
  { "illorenese.fr", true },
  { "illsley.org", true },
  { "illumed.net", true },
  { "illuminationis.com", true },
  { "illusionephemere.com", true },
  { "illusionunlimited.com", true },
  { "illustrate.biz", true },
  { "illuxat.com", true },
  { "ilmataat.ee", true },
  { "ilmiobusinessonline.it", true },
  { "ilmiogiardiniere.it", true },
  { "ilmuk.org", false },
  { "ilonewolfs.com", true },
  { "ilookz.nl", true },
  { "ilove.fish", true },
  { "ilovequiz.ru", true },
  { "ilovethiscampsite.com", true },
  { "ilrg.com", true },
  { "iltec-prom.ru", true },
  { "iltec.ru", true },
  { "ilweb.es", true },
  { "ilya.pp.ua", true },
  { "im-c-shop.com", true },
  { "im-haus-sonnenschein.de", true },
  { "im2net.com", true },
  { "im4h.de", true },
  { "im4h.eu", true },
  { "im4h.info", true },
  { "im66.net", true },
  { "ima-tourcoing.fr", true },
  { "imacs.org", true },
  { "image-drive.de", true },
  { "imagebin.ca", true },
  { "imagefu.com", true },
  { "imageination.co", true },
  { "imagenesdedibujosalapizfacilesdehacer.com", true },
  { "imagerive.ch", true },
  { "imagescostumes.com", true },
  { "imaginair.es", true },
  { "imaginary.ca", true },
  { "imaginary.stream", true },
  { "imagine-programming.com", true },
  { "imaginetricks.com", true },
  { "imagr.io", true },
  { "imanageproducts.co.uk", true },
  { "imanageproducts.uk", true },
  { "imanesdeviaje.com", true },
  { "imanolbarba.net", true },
  { "imap2imap.de", true },
  { "imarkethost.co.uk", true },
  { "imask.ml", true },
  { "imawhale.com", true },
  { "imbianchino.roma.it", true },
  { "imbushuo.net", true },
  { "imcsx.co", true },
  { "imdemos.com", true },
  { "ime.moe", true },
  { "imedes.de", true },
  { "imediafly.com", true },
  { "imedikament.de", true },
  { "imeds.pl", true },
  { "imefuniversitario.org", true },
  { "imeid.de", false },
  { "imex-dtp.com", true },
  { "imforza.com", true },
  { "img.mg", true },
  { "img.ovh", true },
  { "imga.ch", true },
  { "imgaa.com", true },
  { "imgbb.com", true },
  { "imgg.es", true },
  { "imgup.co", true },
  { "imguploaden.nl", true },
  { "imhua.com", true },
  { "imi-rhapsody.eu", true },
  { "iminshell.com", true },
  { "imirhil.fr", true },
  { "imitza.com", true },
  { "imjad.cn", true },
  { "imjo.in", true },
  { "imjustcreative.com", true },
  { "imkerei-freilinger.de", false },
  { "imkerverein-moenchswald.de", true },
  { "immarypoppinsyall.tk", true },
  { "immaterium.de", true },
  { "immatix.xyz", true },
  { "immersa.co.uk", true },
  { "immersion-pictures.com", true },
  { "immersionwealth.com", true },
  { "immigrantdad.com", true },
  { "immigrationdirect.com.au", true },
  { "immo-agentur.com", true },
  { "immo-passion.net", true },
  { "immo-vk.de", true },
  { "immobilien-badlippspringe.de", true },
  { "immobilien-in-istanbul.de", true },
  { "immobilien-zirm.de", true },
  { "immobilier-nice.fr", true },
  { "immobilier92.net", true },
  { "immobiza.com", false },
  { "immortal.run", true },
  { "imobile3.com", true },
  { "imokuri123.com", true },
  { "imouto.my", false },
  { "imouyang.com", true },
  { "impact.health.nz", true },
  { "impacter.eu", true },
  { "impactfestival.be", true },
  { "impactpub.ch", true },
  { "impakho.com", true },
  { "impas.se", true },
  { "impelup.com", true },
  { "impendulo.org", true },
  { "impera.at", true },
  { "imperdin.com", true },
  { "imperial-legrand.com", true },
  { "imperialmiami.com", true },
  { "imperiumglass.com.au", true },
  { "imperiumnova.info", true },
  { "impex.com.bd", true },
  { "impiantistica.org", true },
  { "implantologie-dr-loeck.de", true },
  { "implicitdenial.com", true },
  { "imponet.com.ar", true },
  { "import-shopping.de", true },
  { "importsagt.com", true },
  { "impotsimple.ca", true },
  { "imppac-schmuck.de", true },
  { "imppac.de", true },
  { "imprendo.co", true },
  { "imprendo.pro", true },
  { "impresa-di-pulizie.org", true },
  { "impresa-pulizie.it", true },
  { "impresadipulizie.roma.it", true },
  { "impresaedile.roma.it", true },
  { "impressivebison.eu", true },
  { "imprimante-3d-store.fr", true },
  { "improfestival.ee", true },
  { "improklinikken.dk", true },
  { "improved-madness.de", true },
  { "impulsionsa.com", true },
  { "impyus.com", true },
  { "imququ.com", true },
  { "imreh.net", true },
  { "imrejonk.nl", true },
  { "imrunner.com", true },
  { "imrunner.ru", true },
  { "ims-sargans.ch", true },
  { "imscompany.com", true },
  { "imwalking.de", true },
  { "imwnk.cn", true },
  { "imydl.com", true },
  { "imydl.tech", true },
  { "imyjy.cn", true },
  { "imyrs.cn", true },
  { "imyunya.com", true },
  { "imyvm.com", true },
  { "imyz.tw", true },
  { "in-depthoutdoors.com", true },
  { "in-flames.com", true },
  { "in.search.yahoo.com", false },
  { "in.xero.com", false },
  { "in10tion.com", false },
  { "inabox.ro", true },
  { "inait.ai", true },
  { "inanyevent.london", true },
  { "inares.org", true },
  { "inbitcoin.it", true },
  { "inbounder.io", false },
  { "inbox-group.com", true },
  { "inbox.google.com", true },
  { "inbulgaria.info", true },
  { "incarna.co", true },
  { "incco.ir", true },
  { "incert.cn", true },
  { "incertint.com", true },
  { "inchcape-fleet-autobid.co.uk", true },
  { "inche-ali.com", true },
  { "inchenaim.com", true },
  { "inchidi.id", true },
  { "incigma.com", true },
  { "includesubdomains.preloaded.test", true },
  { "includesubdomains2.preloaded.test", true },
  { "incoherent.ch", true },
  { "incommon.io", true },
  { "incompliance.de", true },
  { "inconcerts.de", true },
  { "incontrixsingle.net", true },
  { "incore.nl", true },
  { "incowrimo.org", true },
  { "incparadise.net", true },
  { "incubos.org", true },
  { "incy.io", true },
  { "ind.ie", true },
  { "indarceky.sk", false },
  { "indecipherable.info", true },
  { "independencerecovery.com", true },
  { "independent-operators.com", true },
  { "index-games.com", true },
  { "index-mp3.com", true },
  { "indiaflowermall.com", true },
  { "indian-elephant.com", true },
  { "indianaantlersupply.com", true },
  { "indianaberry.com", true },
  { "indianafoundationpros.com", true },
  { "indianapolislocksmithinc.com", true },
  { "indiatrademarkwatch.com", true },
  { "indiayogastudio.net", true },
  { "indicateurs-flash.fr", true },
  { "indie.dog", true },
  { "indiecongdr.it", true },
  { "indiegame.space", true },
  { "indievelopment.nl", true },
  { "indigitalagency.com", true },
  { "indigoinflatables.com", true },
  { "indigosakura.com", true },
  { "indigotreeservice.com", true },
  { "inditip.com", true },
  { "indochina.io", true },
  { "indogermanstartup.com", true },
  { "indoorcomfortteam.com", true },
  { "indoorplantsexpert.com", true },
  { "indovinabank.com.vn", true },
  { "indusap.com", true },
  { "indusfastremit-us.com", true },
  { "indusfastremit.com", true },
  { "indust.me", true },
  { "industriafranchini.com", true },
  { "industrialstarter.com", true },
  { "industriasrenova.com", true },
  { "industriemeister.io", true },
  { "indybay.org", true },
  { "ineardisplay.com", true },
  { "inebula.it", true },
  { "ineed.coffee", false },
  { "inertianetworks.com", true },
  { "inesfinc.es", true },
  { "inessoftsec.be", true },
  { "inesta.nl", true },
  { "inet.se", true },
  { "inethost.eu", true },
  { "inetserver.eu", true },
  { "inetsoftware.de", true },
  { "inf-fusion.ca", true },
  { "inference.biz.tr", true },
  { "infermiere.roma.it", true },
  { "inff.info", true },
  { "inficom.org", true },
  { "infinite.hosting", true },
  { "infinitegroup.info", true },
  { "infinitescript.com", true },
  { "infinitiofallentownparts.com", true },
  { "infinitiofaugustaparts.com", true },
  { "infinitioflynnwoodparts.com", true },
  { "infinitomaisum.com", true },
  { "infinitybas.com", true },
  { "infinitybc.se", true },
  { "infinityengine.org", true },
  { "infinityepos.co.uk", true },
  { "infirmiere-canadienne.com", true },
  { "infirmieredevie.ch", true },
  { "inflatablehire-scotland.co.uk", true },
  { "inflatablesny.com", true },
  { "inflatadays.co.uk", true },
  { "inflatamania.com", true },
  { "inflationstation.net", true },
  { "inflexsys.com", true },
  { "influencerchampions.com", true },
  { "influo.com", true },
  { "infmed.com", true },
  { "info-beamer.com", true },
  { "info-d-74.com", true },
  { "info-screen-usercontent.me", true },
  { "info-screen.me", true },
  { "info-screw.com", true },
  { "infobae.com", true },
  { "infocity-tech.fr", true },
  { "infocommsociety.com", true },
  { "infocon.org", true },
  { "infocusvr.net", true },
  { "infoduv.fr", true },
  { "infogram.com", true },
  { "infogrfx.com", true },
  { "infomegastore.com", true },
  { "infomir.eu", true },
  { "infomisto.com", true },
  { "infopagina.es", true },
  { "infopier.sg", true },
  { "infopulsa.com", true },
  { "infopuntzorg.nl", true },
  { "infor-allaitement.be", true },
  { "informatiebeveiliging.nl", true },
  { "informatik-handwerk.de", true },
  { "informationrx.org", true },
  { "informations-echafaudages.com", true },
  { "informhealth.com", true },
  { "informnapalm.org", true },
  { "infosec-handbook.eu", true },
  { "infosec.exchange", false },
  { "infosec.pizza", true },
  { "infosec.wiki", true },
  { "infosectalks.com", true },
  { "infosenior.ch", true },
  { "infotainworld.com", true },
  { "infotolium.com", false },
  { "infotrac.net", true },
  { "infotune.nl", true },
  { "infovision-france.com", true },
  { "infoweb.ee", true },
  { "infr.red", true },
  { "infra.land", true },
  { "infra.press", true },
  { "infrabeep.com", true },
  { "infraclass.com", true },
  { "infradrop.com", true },
  { "infrafire.com", true },
  { "infraflip.com", true },
  { "infraflux.com", true },
  { "infrafusion.com", true },
  { "infralist.com", true },
  { "inframetro.com", true },
  { "inframint.com", true },
  { "infranium.com", true },
  { "infranium.eu", true },
  { "infranium.info", true },
  { "infranium.net", true },
  { "infranium.org", true },
  { "infranotes.com", true },
  { "infranoto.com", true },
  { "infranox.com", true },
  { "infrapass.com", true },
  { "infrapeer.com", true },
  { "infrapilot.com", true },
  { "infraping.com", true },
  { "infrapirtis.lt", true },
  { "infrarank.com", true },
  { "infrarank.net", true },
  { "infraspin.com", true },
  { "infratank.com", true },
  { "infrathink.com", true },
  { "infravideo.com", true },
  { "infrazine.com", true },
  { "infuzeit.com.au", true },
  { "ing-buero-junk.de", true },
  { "ingatlanjogaszok.hu", true },
  { "ingatlanneked.hu", true },
  { "ingatlanrobot.hu", true },
  { "ingber.com", true },
  { "inge-r.nl", true },
  { "ingeeibach.de", true },
  { "ingenium.si", true },
  { "ingenius.ws", true },
  { "ingerhy.com", true },
  { "ingi.ga", true },
  { "ingjobs.ch", true },
  { "inglebycakes.co.uk", true },
  { "inglesnarede.com.br", true },
  { "ingo-schlueter.de", true },
  { "ingoschlueter.de", true },
  { "ingredientdaddy.ro", true },
  { "inhaltsangabe.de", true },
  { "inheritestate.com", true },
  { "inhouseents.co.uk", true },
  { "inima.org", true },
  { "inios.fr", true },
  { "inishbofin.ie", true },
  { "initq.net", true },
  { "initramfs.io", true },
  { "initrd.net", true },
  { "inixal.com", true },
  { "ink.horse", true },
  { "inkable.com.au", true },
  { "inkeliz.com", true },
  { "inkhor.se", true },
  { "inkontriamoci.com", true },
  { "inksay.com", true },
  { "inkspire.co.uk", true },
  { "inkurz.de", true },
  { "inlabo.de", true },
  { "inline-sport.cz", true },
  { "inlink.ee", true },
  { "inmaps.xyz", true },
  { "inmatefinancial.com", true },
  { "inmateintake.com", true },
  { "inmobillium.fr", true },
  { "inmoodforsex.com", true },
  { "innerfence.com", true },
  { "innerlightcrystals.co.uk", true },
  { "innermostparts.org", true },
  { "innersafe.com", true },
  { "inno.ch", true },
  { "innocenceseekers.net", true },
  { "innogen.fr", true },
  { "innohb.com", true },
  { "innolabfribourg.ch", true },
  { "innoloop.com", true },
  { "innophate-security.com", true },
  { "innot.net", true },
  { "innotas.com", true },
  { "innoteil.com", true },
  { "innotel.com.au", true },
  { "innovaptor.at", true },
  { "innovaptor.com", true },
  { "innovate-indonesia.com", true },
  { "innovation-workshop.ro", true },
  { "innovation.gov", false },
  { "innover.se", true },
  { "innovum.cz", false },
  { "innsalzachsingles.de", true },
  { "inoa8.com", true },
  { "inobun.jp", true },
  { "inovat.ma", true },
  { "inovatecsystems.com", true },
  { "inpas.co.uk", true },
  { "inputmag.com", true },
  { "inquant.de", true },
  { "ins-kreativ.de", true },
  { "ins.to", true },
  { "ins1gn1a.com", true },
  { "insblauehinein.nl", true },
  { "inscomers.net", true },
  { "inscripcionessena.com", true },
  { "insecret.com.ua", true },
  { "insecret.trade", true },
  { "insecure.org.je", true },
  { "insertcoins.net", true },
  { "insgesamt.net", true },
  { "inshapenutrition.com.br", true },
  { "insho.fashion", true },
  { "inside19.com", true },
  { "insideaudit.com", true },
  { "insidebedroom.com", true },
  { "insidesolutions.nl", true },
  { "insidethefirewall.tk", true },
  { "insightera.co.th", true },
  { "insighti.com", true },
  { "insighti.eu", true },
  { "insighti.org", true },
  { "insighti.sk", true },
  { "insignificant.space", true },
  { "insinuator.net", true },
  { "insistel.com", true },
  { "insofttransfer.com", true },
  { "insolent.ch", true },
  { "insolved.com", true },
  { "insping.com", true },
  { "inspirationalquotesuk.co.uk", true },
  { "inspired-creations.co.za", true },
  { "inspired-lua.org", true },
  { "inspiredrealtyinc.com", true },
  { "insrt.uk", true },
  { "insside.net", true },
  { "instafind.nl", true },
  { "instagram-atom.appspot.com", true },
  { "instagrammernews.com", true },
  { "instagramtweet.com", true },
  { "installatietechniekgresnigt.nl", true },
  { "installgentoo.net", true },
  { "instamojo.com", true },
  { "instant-thinking.de", true },
  { "instant.io", true },
  { "instantkhabar.com", true },
  { "instantluxe.cn", true },
  { "instantluxe.co.uk", true },
  { "instantluxe.com", true },
  { "instantluxe.de", true },
  { "instantluxe.it", true },
  { "instantphotocamera.com", true },
  { "instava.cz", true },
  { "instead.com.au", true },
  { "insteagle.com", true },
  { "instela.com", true },
  { "instelikes.com.br", true },
  { "instics.com", true },
  { "instinctive.io", true },
  { "instinctiveads.com", true },
  { "institut-confucius-montpellier.org", true },
  { "institutmaupertuis.hopto.org", true },
  { "institutogiuseppe.com", true },
  { "institutogiuseppe.com.ar", true },
  { "institutolancaster.com", true },
  { "instrumart.ru", false },
  { "insult.es", true },
  { "insurance321.com", true },
  { "insureon.com", true },
  { "insurgentsmustdie.com", true },
  { "int64software.com", true },
  { "intae.it", true },
  { "intafe.co.jp", true },
  { "intal.info", true },
  { "intarweb.ca", true },
  { "intasky.cz", true },
  { "intasky.sk", true },
  { "integralblue.com", true },
  { "integralkk.com", true },
  { "integratedintegrations.xyz", true },
  { "integratedmedicalonline.com", true },
  { "integrateur-web-paris.com", true },
  { "integrity.gov", true },
  { "integrityokc.com", true },
  { "integrityoklahoma.com", true },
  { "integrogroup.com", true },
  { "integromat.com", true },
  { "integroof.com", true },
  { "intelhost.cl", true },
  { "intelhost.com", true },
  { "intelhost.com.ar", true },
  { "intelhost.com.br", true },
  { "intelhost.com.co", true },
  { "intelhost.com.mx", true },
  { "intelhost.com.pe", true },
  { "intellar.com", true },
  { "intellectdynamics.com", true },
  { "intelligence-explosion.com", true },
  { "intellinetixvibration.com", true },
  { "intelly.nl", true },
  { "intelly365.nl", true },
  { "intencje.pl", true },
  { "intensifyrsvp.com.au", true },
  { "inter-corporate.com", true },
  { "inter-culinarium.com", true },
  { "interabbit.com", true },
  { "interaffairs.com", true },
  { "interaktiva.fi", true },
  { "interasistmen.se", true },
  { "interchangedesign.com", true },
  { "intercom.com", true },
  { "intercom.io", true },
  { "interessiert-uns.net", true },
  { "interfesse.net", true },
  { "interflores.com.br", true },
  { "interfug.de", true },
  { "intergozd.si", true },
  { "interguard.net", true },
  { "interiery-waters.cz", true },
  { "interimages.fr", true },
  { "interior-design-colleges.com", true },
  { "interiordesignsconcept.com", true },
  { "interiorprofesional.com.ar", true },
  { "interisaudit.com", true },
  { "interlijn.nl", true },
  { "interlingvo.biz", true },
  { "intermax.nl", true },
  { "intermedinet.nl", true },
  { "internalkmc.com", true },
  { "internaluse.net", true },
  { "international-arbitration-attorney.com", true },
  { "international-books.org", true },
  { "international-nash-day.com", true },
  { "internationalfashionjobs.com", true },
  { "internationalschool.it", true },
  { "internationaltalento.it", true },
  { "internect.co.za", true },
  { "internet-aukcion.info", true },
  { "internet-pornografie.de", false },
  { "internet-software.eu", true },
  { "internetaanbieders.eu", true },
  { "internetbank.swedbank.se", true },
  { "internetbugbounty.com", true },
  { "internetbusiness-howto.com", true },
  { "internetcom.jp", true },
  { "internetfonden.se", true },
  { "internethealthreport.org", true },
  { "internethering.de", true },
  { "internetinhetbuitengebied.nl", true },
  { "internetmuseum.se", true },
  { "internetofdon.gs", true },
  { "internetoffensive.fail", true },
  { "internetofinsecurethings.com", true },
  { "internetovehazardnihry.cz", true },
  { "internetpro.me", true },
  { "internetstaff.com", true },
  { "internetzentrale.net", true },
  { "interpol.gov", true },
  { "interracial.dating", true },
  { "interseller.io", true },
  { "interserved.com", false },
  { "interstateautomotiveinc.com", true },
  { "intertime.services", true },
  { "interview-suite.com", true },
  { "interways.de", true },
  { "intheater.de", true },
  { "inthepicture.com", true },
  { "inthouse.cloud", true },
  { "intimastoreatacado.com.br", true },
  { "intita.com", true },
  { "intl-webs.com", true },
  { "intmissioncenter.org", true },
  { "into.technology", true },
  { "intocities.de", false },
  { "inton.biz", true },
  { "intoparking.com", false },
  { "intpforum.com", true },
  { "intracom.com", true },
  { "intradayseasonals.com", true },
  { "intramanager.dk", true },
  { "intranetsec-regionra.fr", true },
  { "intraobes.com", true },
  { "intrasoft.com.au", true },
  { "intraxia.com", true },
  { "introverted.ninja", true },
  { "intune.life", true },
  { "intvonline.com", true },
  { "intxt.net", true },
  { "inumcoeli.com.br", true },
  { "inup.jp", true },
  { "inusasha.de", true },
  { "inuyasha-petition.tk", true },
  { "invadelabs.com", true },
  { "invasion.com", true },
  { "invasivespeciesinfo.gov", true },
  { "invasmani.com", true },
  { "inventaire.ch", true },
  { "inventionsteps.com.au", true },
  { "inventix.nl", true },
  { "inventoryimages.co.uk", true },
  { "inventoryimages.com", true },
  { "inventtatte.com", true },
  { "inventtheworld.com.au", true },
  { "inventum.cloud", true },
  { "inverselink-user-content.com", true },
  { "inversioneseconomicas.com", true },
  { "investarholding.nl", true },
  { "investigatore.it", true },
  { "investigazionimoretti.it", true },
  { "investir.ch", true },
  { "investor-academy.jp", true },
  { "investor.gov", true },
  { "investoren-beteiligung.de", true },
  { "investorforms.com", true },
  { "investosure.com", true },
  { "investpay.ru", true },
  { "invinoaustria.com", true },
  { "invinoaustria.cz", true },
  { "invioinc.com", true },
  { "inviosolutions.com", true },
  { "invisible-college.com", true },
  { "invisibles.ch", true },
  { "invisionita.com", true },
  { "invisiverse.com", true },
  { "invitacionesytarjetas.gratis", true },
  { "invitethemhome.com", true },
  { "invkao.com", true },
  { "invoiced.com", true },
  { "invoicefinance.com", true },
  { "invoicefinance.nl", true },
  { "invoicehippo.nl", true },
  { "invuite.com", true },
  { "inwao.com", true },
  { "inwestcorp.se", true },
  { "inzdr.com", true },
  { "inzelabs.com", true },
  { "inzestfreunde.de", true },
  { "ioactive.com", true },
  { "iobint.com", true },
  { "iocheck.com", false },
  { "iochen.com", true },
  { "iocurrents.com", true },
  { "iodine.com", true },
  { "ioerror.us", true },
  { "iofort.com", true },
  { "iojo.net", true },
  { "ioliver.co.uk", true },
  { "iomedia.ch", true },
  { "iompost.com", true },
  { "iomstamps.com", true },
  { "ionlabs.kr", true },
  { "ionovia.de", true },
  { "ionx.co.uk", true },
  { "ioover.net", true },
  { "iosartstudios.gr", true },
  { "iosjailbreakiphone.com", true },
  { "ioslo.net", true },
  { "iosmods.com", true },
  { "iosnoops.com", true },
  { "iossifovlab.com", true },
  { "iostream.by", true },
  { "iowaent.com", true },
  { "iowaschoolofbeauty.com", true },
  { "ip-blacklist.net", true },
  { "ip-hahn.de", true },
  { "ip-tanz.com", true },
  { "ip.sb", true },
  { "ip2country.info", true },
  { "ip3office.com", true },
  { "ip6.li", false },
  { "ipad.li", true },
  { "ipadkaitori.jp", true },
  { "ipal.im", true },
  { "ipal.name", true },
  { "ipal.pl", true },
  { "ipal.tel", true },
  { "ipcareers.net", true },
  { "ipconsulting.se", true },
  { "ipemcomodoro.com.ar", true },
  { "ipfire.org", true },
  { "ipfirebox.de", true },
  { "ipfs.ink", true },
  { "ipfs.io", true },
  { "iphonekaitori.tokyo", true },
  { "iphoneunlock.nu", true },
  { "iphonote.com", true },
  { "ipid.me", true },
  { "ipintel.io", true },
  { "iplabs.de", true },
  { "iplantom.com", true },
  { "iplayradio.net", false },
  { "ipleak.net", true },
  { "ipledgeonline.org", false },
  { "ipmonitoring.hu", true },
  { "ipo-times.jp", true },
  { "ipokabu.net", true },
  { "ipomue.com", false },
  { "ipop.gr", true },
  { "iposm.net", true },
  { "ipplans.com", true },
  { "ipresent.com", true },
  { "iprim.ru", true },
  { "iproducemusic.com", true },
  { "ipsec.pl", true },
  { "ipssl.li", true },
  { "ipstoragesolutions.com", true },
  { "ipstream.it", true },
  { "ipswitch.com.tw", true },
  { "iptvzoom.xyz", true },
  { "ipty.de", true },
  { "ipura.ch", true },
  { "ipv4.cf", true },
  { "ipv4.co.il", true },
  { "ipv4.gr", true },
  { "ipv6-adresse.dk", true },
  { "ipv6-handbuch.de", true },
  { "ipv6.gr", true },
  { "ipv6.jetzt", true },
  { "ipv6vpn.net", true },
  { "ipv6wallofshame.com", true },
  { "ipv8.net", true },
  { "iqboxy.com", true },
  { "iqsmn.org", true },
  { "ir1s.com", true },
  { "iramellor.com", true },
  { "iranian.lgbt", true },
  { "iranianholiday.com", true },
  { "iranjeunesse.com", true },
  { "irasandi.com", true },
  { "irayo.net", true },
  { "irc-results.com", true },
  { "irdvb.com", true },
  { "ireef.tv", true },
  { "iren.ch", true },
  { "irenekauer.com", true },
  { "irf2.pl", true },
  { "irfan.id", true },
  { "irgendeine.cloud", true },
  { "irgit.pl", true },
  { "irgwebsites.com", true },
  { "iridiumbrowser.de", true },
  { "iridiumflare.de", true },
  { "iriomote.com", true },
  { "iris-design.info", true },
  { "iris-insa.com", true },
  { "irish.dating", true },
  { "irish.radio", true },
  { "irishradioplayer.radio", true },
  { "irisjieun.com", true },
  { "irkfap.com", true },
  { "irland-firma.com", true },
  { "irmgard-woelfle.de", true },
  { "irmgardkoch.com", true },
  { "iro-iro.xyz", true },
  { "iroise.ch", true },
  { "ironbelly.pro", true },
  { "ironcarnival.com", true },
  { "ironfistdesign.com", true },
  { "ironhide.de", true },
  { "ironpeak.be", true },
  { "irrewilse.se", true },
  { "irritant.net", true },
  { "iruarts.ch", true },
  { "iruca.co", true },
  { "is-going-to-rickroll.me", true },
  { "is-sw.net", true },
  { "isaac.world", true },
  { "isaacdgoodman.com", true },
  { "isaackhor.com", true },
  { "isaacman.tech", true },
  { "isaacmorneau.com", true },
  { "isaacpartnership.co.uk", true },
  { "isaacpartnership.com", true },
  { "isaacphysics.org", true },
  { "isaaczais.com", true },
  { "isabelaflores.com", true },
  { "isabellavandijk.nl", true },
  { "isabelle-delpech.com", true },
  { "isabellehogarth.co.uk", true },
  { "isakssons.com", true },
  { "isamiok.com", true },
  { "isara.com", true },
  { "isarklinikum.de", true },
  { "isastylish.com", true },
  { "isavings.com", true },
  { "isayoga.de", true },
  { "isbaseballstillon.com", true },
  { "isbc-telecom.ru", true },
  { "isbengrumpy.com", true },
  { "isc2chapter-cny.org", true },
  { "iscert.org", true },
  { "isdn.jp", true },
  { "isecrets.se", true },
  { "iservicio.mx", true },
  { "iseulde.com", true },
  { "isfff.com", true },
  { "isg-tech.com", true },
  { "isgp-studies.com", true },
  { "ishamf.com", true },
  { "ishangirdhar.com", true },
  { "ishet.al", true },
  { "ishiharaken.com", true },
  { "ishtarfreya.com", true },
  { "isil.fi", true },
  { "isimonbrown.co.uk", true },
  { "isincheck.com", true },
  { "isinolsun.com", true },
  { "isistomie.com", true },
  { "isitchristmas.com", true },
  { "isitcoffeetime.com", true },
  { "isitdoneyet.gov", true },
  { "isitpatchtuesday.com", true },
  { "isitrest.info", true },
  { "isitup.org", true },
  { "iskanderbroere.nl", true },
  { "iskaron.de", true },
  { "iskaz.rs", true },
  { "iskogen.nu", true },
  { "islam.si", true },
  { "islamonline.net", true },
  { "islandhosting.com", true },
  { "islavolcan.cl", true },
  { "isletech.net", true },
  { "isliada.org", true },
  { "islief.com", true },
  { "islykaithecutest.cf", true },
  { "islykaithecutest.ml", true },
  { "ismailkarsli.com", true },
  { "ismat.com", true },
  { "ismena.bg", true },
  { "ismetroonfiretoday.com", true },
  { "ismywebsitepenalized.com", true },
  { "isn.cz", true },
  { "iso27032.com", true },
  { "isognattori.com", true },
  { "isolta.com", true },
  { "isolta.de", true },
  { "isolta.ee", true },
  { "isolta.fi", true },
  { "isolta.lv", true },
  { "isolta.se", true },
  { "isonet.fr", true },
  { "isopres.de", true },
  { "isotope.gov", true },
  { "isotopes.gov", true },
  { "isowosi.com", true },
  { "ispfontela.es", true },
  { "ispitrade.com", true },
  { "ispo.com.tw", true },
  { "ispsoft.pro", true },
  { "isqrl.de", true },
  { "israelbiblicalstudies.com", true },
  { "israelbizreg.com", true },
  { "isreedyinthe.uk", true },
  { "isreedyinthe.us", true },
  { "isreedyintheuk.com", true },
  { "issa.org.pl", false },
  { "issasfrissa.se", true },
  { "issforum.org", true },
  { "issio.net", true },
  { "issue.watch", true },
  { "issues.email", true },
  { "issuesofconcern.in", true },
  { "ist-intim.de", true },
  { "istanbul.systems", true },
  { "istdieweltschonuntergegangen.de", true },
  { "isteinbaby.de", true },
  { "istheapplestoredown.com", true },
  { "istheapplestoredown.de", true },
  { "isthedoorlocked.com", true },
  { "istheinternetdown.com", true },
  { "istheinternetonfire.com", true },
  { "istheservicedown.co.uk", true },
  { "istheservicedown.com", true },
  { "istheservicedowncanada.com", true },
  { "isthisus.org", true },
  { "isthnew.com", true },
  { "istogether.com", true },
  { "istore.lt", true },
  { "istorrent.is", true },
  { "istrazivac-istine.com", true },
  { "istschonsolangeinrente.de", true },
  { "istsi.org", true },
  { "isuzupartscenter.com", true },
  { "isvbscriptdead.com", true },
  { "isvsecwatch.org", true },
  { "isyu.xyz", true },
  { "isz-berlin.de", true },
  { "isz.no", true },
  { "iszy.me", true },
  { "it-academy.sk", true },
  { "it-boss.ro", true },
  { "it-faul.de", true },
  { "it-fernau.com", true },
  { "it-jobbank.dk", true },
  { "it-maker.eu", true },
  { "it-rotter.de", true },
  { "it-schamans.de", true },
  { "it-seems-to.work", true },
  { "it-service24.at", true },
  { "it-service24.ch", true },
  { "it-service24.com", true },
  { "it-shamans.de", true },
  { "it-shamans.eu", true },
  { "it-stack.de", true },
  { "it-support-nu.se", true },
  { "it-support-stockholm.se", true },
  { "it-support.one", true },
  { "it-supportistockholm.se", true },
  { "it-sysoft.com", true },
  { "it-tekniker.nu", true },
  { "it-ti.me", true },
  { "it-uws.com", true },
  { "it-world.eu", true },
  { "it.search.yahoo.com", false },
  { "itactiq.com", true },
  { "itactiq.info", true },
  { "itaiferber.net", true },
  { "ital-gamma.be", true },
  { "italia-store.com", true },
  { "italiachegioca.com", true },
  { "italian.dating", true },
  { "italianjourneys.com.au", true },
  { "italianshoemanufacturers.com", true },
  { "italieflydrive.nl", true },
  { "italserrande.it", true },
  { "italyinspires.com", true },
  { "itamservices.nl", true },
  { "itap.gov", true },
  { "itb-online.co.uk", true },
  { "itcko.sk", true },
  { "itdashboard.gov", true },
  { "itecor.net", true },
  { "iteecafe.hu", true },
  { "iteha.de", true },
  { "iteke.ml", true },
  { "iteke.tk", true },
  { "iterader.com", true },
  { "iterasoft.de", true },
  { "itesign.de", true },
  { "itfh.eu", true },
  { "itfix.cz", true },
  { "itforge.nl", true },
  { "itgirls.rs", true },
  { "ithakama.cz", true },
  { "ithenrik.com", true },
  { "ithinc.net", true },
  { "ithink.cf", true },
  { "ithjalpforetag.se", true },
  { "itikon.com", true },
  { "itilo.de", true },
  { "itis.gov", true },
  { "itis4u.ch", true },
  { "itjob.ma", true },
  { "itkaufmann.at", true },
  { "itlitera.com", true },
  { "itludens.com", true },
  { "itm-c.de", true },
  { "itmanie.cz", true },
  { "itmindscape.com", true },
  { "itn.co.uk", true },
  { "itneeds.tech", true },
  { "itnota.com", true },
  { "itochan.jp", true },
  { "itooky.com", true },
  { "itouriria.com", true },
  { "itpro.ua", true },
  { "itraveille.fr", true },
  { "itreallyaddsup.com", true },
  { "itring.pl", false },
  { "itruss.com.tw", true },
  { "itruth.tk", true },
  { "its-future.com", true },
  { "its-gutachten.de", true },
  { "its4living.com", true },
  { "itsabouncything.com", true },
  { "itsanicedoor.co.uk", true },
  { "itsasaja.com", true },
  { "itsaw.de", true },
  { "itsayardlife.com", true },
  { "itsblue.de", true },
  { "itsdcdn.com", true },
  { "itsecblog.de", true },
  { "itsecguy.com", true },
  { "itsense.fr", true },
  { "itsevident.com", true },
  { "itsgoingdown.org", true },
  { "itskayla.com", true },
  { "itsmyparty.ie", true },
  { "itsnotquitethehilton.com", true },
  { "itsok.de", true },
  { "itspartytimeonline.co.uk", true },
  { "itspartytimesweetinflations.com", true },
  { "itspecialista.eu", true },
  { "itspersonaltraining.nl", true },
  { "itsryan.com", true },
  { "itsstefan.eu", true },
  { "itstatic.tech", true },
  { "itsuitsyou.co.za", true },
  { "itsundef.in", true },
  { "itsupportnacka.se", true },
  { "itsv.at", true },
  { "itswincer.com", true },
  { "itzap.com.au", true },
  { "iurisnow.com", true },
  { "iusedtosmoke.com", true },
  { "iuyos.com", true },
  { "ivact.co.jp", true },
  { "ivanbenito.com", true },
  { "ivanboi.com", true },
  { "ivancacic.com", false },
  { "ivanmeade.com", true },
  { "ivaoru.org", true },
  { "ivfausland.de", true },
  { "ivfmeds.com", true },
  { "ivi-fertilite.fr", true },
  { "ivi-fruchtbarkeit.de", true },
  { "ivi.com.ar", true },
  { "ivi.com.pa", true },
  { "ivi.mx", true },
  { "ivi.net.br", true },
  { "ivi.pt", true },
  { "ivig.com.br", true },
  { "ivinet.cl", true },
  { "ivitalia.it", true },
  { "ivo.co.za", true },
  { "ivopetkov.com", true },
  { "ivor.io", true },
  { "ivor.is", true },
  { "ivorvanhese.com", true },
  { "ivorvanhese.nl", true },
  { "ivpn.net", true },
  { "ivre.rocks", true },
  { "ivsign.net", true },
  { "ivusn.cz", true },
  { "ivvl.ru", true },
  { "ivy-league-colleges.com", true },
  { "ivy.show", true },
  { "iwader.co.uk", true },
  { "iwalton.com", true },
  { "iwantexchange.com", true },
  { "iwantpayments.com", true },
  { "iwanttoliveinabunker.com", true },
  { "iwanttrack.com", true },
  { "iwascoding.com", true },
  { "iwch.tk", true },
  { "iwebolutions.com", true },
  { "iwell.de", true },
  { "iwizerunek.pl", true },
  { "iworos.com", true },
  { "iww.me", true },
  { "iwyc.cn", true },
  { "ixds.org", true },
  { "ixnext.de", true },
  { "ixquick-proxy.com", true },
  { "ixquick.co.uk", true },
  { "ixquick.com", true },
  { "ixquick.de", true },
  { "ixquick.eu", true },
  { "ixquick.fr", true },
  { "ixquick.info", true },
  { "ixquick.nl", true },
  { "iyassu.com", true },
  { "iyinolaashafa.com", true },
  { "iyouewo.com", true },
  { "iyuanbao.net", true },
  { "iz8mbw.net", true },
  { "izaakbeekman.com", true },
  { "izevg.ru", true },
  { "izhaojie.com", true },
  { "izodiacsigns.com", true },
  { "izuba.info", true },
  { "izumi.tv", true },
  { "izxxs.com", true },
  { "izxxs.net", true },
  { "izxzw.net", true },
  { "izzys.casa", true },
  { "j-elliott.co.uk", true },
  { "j-navi.com", true },
  { "j0bs.org", true },
  { "j0m.de", true },
  { "j0s.at", true },
  { "j0s.eu", true },
  { "j15h.nu", true },
  { "j2h.de", true },
  { "j3e.de", true },
  { "ja-dyck.de", true },
  { "ja-gps.com.au", true },
  { "ja-publications.agency", true },
  { "ja.md", true },
  { "jaakkohannikainen.fi", true },
  { "jaalits.com", true },
  { "jaarvistech.com", true },
  { "jaba.hosting", true },
  { "jababu.cz", true },
  { "jabbari.io", true },
  { "jabbas.eu", true },
  { "jabber.at", true },
  { "jabberfr.org", true },
  { "jabbers.one", true },
  { "jabberzac.org", true },
  { "jaberg-rutschi.ch", true },
  { "jabergrutschi.ch", true },
  { "jabjab.de", true },
  { "jaccblog.com", true },
  { "jacekowski.org", true },
  { "jacik.cz", true },
  { "jack2celebrities.com", true },
  { "jackassofalltrades.org", true },
  { "jackdawphoto.co.uk", true },
  { "jackdelik.de", true },
  { "jackf.me", true },
  { "jackhoodtransportation.com", true },
  { "jackingramnissanparts.com", true },
  { "jackpothappy.com", true },
  { "jackson-quon.com", true },
  { "jackson.jp", true },
  { "jacksonhu.com", true },
  { "jacksonvillestation.com", true },
  { "jacksorrell.com", true },
  { "jacksutton.info", true },
  { "jackyliao123.tk", true },
  { "jacobamunch.com", true },
  { "jacobdevans.com", true },
  { "jacobhaug.com", false },
  { "jacobi-server.de", true },
  { "jacobian.org", true },
  { "jacobjangles.com", true },
  { "jacobphono.com", true },
  { "jacobsenarquitetura.com", true },
  { "jacuzziprozone.com", true },
  { "jadchaar.me", true },
  { "jadopado.com", true },
  { "jaegerlacke.de", true },
  { "jaetech.org", true },
  { "jagbouncycastles.co.uk", true },
  { "jagerman.com", true },
  { "jaguarlandrover-asse.be", true },
  { "jaguarlandrover-occasions.be", true },
  { "jaguarwong.xyz", true },
  { "jahanaisamu.com", true },
  { "jahmusic.net", true },
  { "jahner.xyz", true },
  { "jahofmann.de", false },
  { "jailbreakingisnotacrime.org", true },
  { "jaion.xyz", true },
  { "jaispirit.com", false },
  { "jaitnetworking.com", false },
  { "jakarta.dating", true },
  { "jakdelatseo.cz", true },
  { "jake.eu.org", true },
  { "jake.ml", true },
  { "jake.nom.za", true },
  { "jakebeardsley.com", true },
  { "jakecurtis.de", true },
  { "jakereynolds.co", true },
  { "jakerullman.com", true },
  { "jaketremper.com", true },
  { "jakewestrip.com", true },
  { "jakob-server.tk", true },
  { "jakobejitblokaci.cz", true },
  { "jakobkrigovsky.com", true },
  { "jakobssystems.net", true },
  { "jakpremyslet.cz", true },
  { "jaksch.biz", true },
  { "jakub-boucek.cz", true },
  { "jakubboucek.cz", true },
  { "jakubklimek.com", true },
  { "jakubtopic.cz", true },
  { "jakubvrba.cz", true },
  { "jala.co.jp", true },
  { "jaleo.cn", true },
  { "jalogisch.de", true },
  { "jamaat.hk", true },
  { "jamacha.org", true },
  { "jamalfi.bio", true },
  { "jamberrynails.co.uk", true },
  { "james-bell.co.uk", true },
  { "james-digital.com", true },
  { "james-loewen.com", true },
  { "jamesachambers.com", true },
  { "jamesaimonetti.com", true },
  { "jamesandpame.la", true },
  { "jamesbillingham.com", true },
  { "jameschorlton.co.uk", true },
  { "jamesclark.com", true },
  { "jamesdorf.com", true },
  { "jamesgreenfield.com", true },
  { "jameshemmings.co.uk", true },
  { "jameshost.net", true },
  { "jameshunt.us", false },
  { "jamesj.me", false },
  { "jamesjboyer.com", true },
  { "jamesmarsh.net", true },
  { "jamesmilazzo.com", true },
  { "jamesmorrison.me", true },
  { "jamesmurphy.com.au", true },
  { "jamesrobertson.io", true },
  { "jamesrobertson.net", true },
  { "jamesross.name", true },
  { "jamesrussellward.co.uk", true },
  { "jamessmith.me.uk", true },
  { "jamesturnerstickley.com", true },
  { "jamhost.org", true },
  { "jamie-read-photography.com", true },
  { "jamie.ie", true },
  { "jamielarter.ca", true },
  { "jamielinux.com", true },
  { "jamiemagee.co.uk", true },
  { "jamiemagee.dk", true },
  { "jamiepeters.nl", true },
  { "jamieweb.net", true },
  { "jamieweb.org", true },
  { "jamiewebb.net", true },
  { "jamjestsimon.pl", true },
  { "jammucake.com", true },
  { "jammysplodgers.co.uk", true },
  { "jamon.ca", true },
  { "jamonsilva.com", true },
  { "jamstatic.fr", true },
  { "jan-and-maaret.de", true },
  { "jan-bucher.ch", true },
  { "jan-hill.com", true },
  { "jan-rieger.de", true },
  { "jan-roenspies.de", true },
  { "jan-von.de", true },
  { "janada.cz", true },
  { "janaundgeorgsagenja.eu", true },
  { "janbrodda.de", true },
  { "jandev.de", true },
  { "janduchene.ch", true },
  { "jane.com", true },
  { "janehamelgardendesign.co.uk", true },
  { "janelauhomes.com", true },
  { "janhuelsmann.com", true },
  { "jani.media", true },
  { "janiat.com", true },
  { "janik.xyz", false },
  { "janikrabe.com", true },
  { "janjoris.nl", true },
  { "jankamp.com", true },
  { "janker.me", true },
  { "jankoepsel.com", true },
  { "jann.is", true },
  { "jannekekaasjager.nl", true },
  { "jannisfink.de", true },
  { "jannyrijneveld.nl", true },
  { "janoberst.com", true },
  { "janokacer.sk", true },
  { "janschaumann.de", true },
  { "jansen-schilders.nl", true },
  { "janssenwigman.nl", true },
  { "janterpstra.eu", true },
  { "jantinaboelens.nl", true },
  { "janvari.com", true },
  { "janvaribalint.com", true },
  { "jaot.info", true },
  { "japanesemotorsports.net", true },
  { "japangids.nl", true },
  { "japaniac.de", false },
  { "japanphilosophy.com", false },
  { "japanwatches.xyz", true },
  { "japon-japan.com", true },
  { "jardin-exotique-rennes.fr", true },
  { "jardinderline.ch", true },
  { "jardineriaon.com", true },
  { "jardiniersduminotaure.fr", true },
  { "jaredeberle.org", false },
  { "jaredfernandez.com", true },
  { "jarniashop.se", true },
  { "jaroku.com", true },
  { "jarondl.net", true },
  { "jaroslavc.eu", true },
  { "jarrettgraham.com", true },
  { "jarroba.com", true },
  { "jas-team.net", true },
  { "jashvaidya.com", true },
  { "jasl.works", true },
  { "jasmijnwagenaar.nl", true },
  { "jasminefields.net", true },
  { "jason.re", true },
  { "jasonamorrow.com", true },
  { "jasongerber.ch", true },
  { "jasonmili.online", true },
  { "jasonsansone.com", true },
  { "jasper.link", true },
  { "jasperhammink.com", true },
  { "jasperhuttenmedia.com", true },
  { "jasperpatterson.me", true },
  { "jaszbereny-vechta.eu", true },
  { "javalestari.com", true },
  { "javamilk.com", true },
  { "javierburgos.net", true },
  { "javierlorente.es", true },
  { "javik.net", true },
  { "jaxfstk.com", true },
  { "jaxxnet.co.uk", true },
  { "jaxxnet.org", true },
  { "jaycouture.com", true },
  { "jayf.de", true },
  { "jayfreestone.com", true },
  { "jaymecd.rocks", true },
  { "jayrl.com", true },
  { "jaysaw.me", true },
  { "jaytx.com", true },
  { "jayxon.com", true },
  { "jayxu.com", true },
  { "jazminguaramato.com", true },
  { "jazz-alliance.com", true },
  { "jazz-alliance.org", true },
  { "jazzanet.com", true },
  { "jazzfeet.co.uk", true },
  { "jazzncheese.com", true },
  { "jazzy-feet.com", true },
  { "jazzy.id.au", true },
  { "jazzy.pro", true },
  { "jazzysumi.com", true },
  { "jbbd.fr", true },
  { "jbradaric.me", true },
  { "jbs-jardins.ch", true },
  { "jbsinternational.com", true },
  { "jbt-stl.com", true },
  { "jcadg.com", true },
  { "jcai.dk", true },
  { "jcaicedo.com", true },
  { "jcb.com", true },
  { "jcbgolfandcountryclub.com", true },
  { "jci.cc", true },
  { "jclynne.com", true },
  { "jcra.net", true },
  { "jcsesecuneta.com", true },
  { "jctf.team", true },
  { "jcwodan.nl", true },
  { "jd-group.co.uk", true },
  { "jd1.de", true },
  { "jdassets.com", true },
  { "jdc.io", true },
  { "jdcdirectsales.com", true },
  { "jdcgroup.com.ph", true },
  { "jdegbau.com", true },
  { "jdheysupplies.co.uk", true },
  { "jdjohnsonmedia.com", true },
  { "jdjohnsonwaterproofing.com", true },
  { "jdm.elk.pl", true },
  { "jdncr.com", true },
  { "jdoi.pw", true },
  { "jdoiron.me", true },
  { "jdpleisure.co.uk", true },
  { "jdscastlehire.co.uk", true },
  { "jdtic.com", true },
  { "jdubya.info", true },
  { "je-vends.fr", true },
  { "je2050.de", true },
  { "jeancardeno.com", true },
  { "jeandanielfaessler.ch", true },
  { "jeankygourmet.com", true },
  { "jeanmarieayer.ch", true },
  { "jeannecalment.com", true },
  { "jeannelucienne.fr", true },
  { "jeanneret-combustibles.ch", true },
  { "jeda.ch", true },
  { "jedayoshi.tk", true },
  { "jedepannetonordi.fr", true },
  { "jedidiah.eu", false },
  { "jedipedia.net", true },
  { "jediweb.com.au", true },
  { "jedmud.com", true },
  { "jedwarddurrett.com", true },
  { "jeec.ist", true },
  { "jeemain.org", true },
  { "jeepeg.com", true },
  { "jeeran.com", true },
  { "jeeranservices.com", true },
  { "jeffcasavant.com", false },
  { "jeffcloninger.net", true },
  { "jeffersonregan.co.uk", true },
  { "jeffersonregan.com", true },
  { "jeffersonregan.net", true },
  { "jeffhaferman.com", true },
  { "jeffmcneill.com", true },
  { "jeffreyhaferman.com", true },
  { "jeffrhinelander.com", true },
  { "jeffri.me", true },
  { "jeffsanders.com", true },
  { "jefftickle.com", true },
  { "jeffwebb.com", true },
  { "jefrydco.id", true },
  { "jehovahsays.net", true },
  { "jej.cz", true },
  { "jej.sk", true },
  { "jekhar.com", true },
  { "jekkt.com", false },
  { "jelena-adeli.com", true },
  { "jelenkovic.rs", true },
  { "jell.ie", true },
  { "jelle.pro", true },
  { "jelleluteijn.com", true },
  { "jelleluteijn.eu", true },
  { "jelleluteijn.net", true },
  { "jelleluteijn.nl", true },
  { "jelleluteijn.pro", true },
  { "jelleraaijmakers.nl", true },
  { "jelleschneiders.com", false },
  { "jelly.cz", true },
  { "jellybeanbooks.com.au", true },
  { "jelmer.co.uk", true },
  { "jelmer.uk", true },
  { "jelmoli-shop.ch", true },
  { "jem.gov", true },
  { "jemangeducheval.com", true },
  { "jembatankarir.com", true },
  { "jemefaisdesamis.com", true },
  { "jena.space", true },
  { "jennierobinson.com", true },
  { "jenniferengerwingaantrouwen.nl", true },
  { "jennifermason.eu", true },
  { "jennifersauer.nl", true },
  { "jennythebaker.com", true },
  { "jenolson.net", true },
  { "jenprace.cz", true },
  { "jensrex.dk", true },
  { "jeparamedia.com", true },
  { "jepertinger-itconsulting.de", true },
  { "jeproteste.info", true },
  { "jeremiahbenes.com", true },
  { "jeremy-chen.org", true },
  { "jeremy.hu", true },
  { "jeremybentham.com", true },
  { "jeremyc.ca", false },
  { "jeremycantu.com", true },
  { "jeremycrews.com", true },
  { "jeremynally.com", true },
  { "jeremyness.com", true },
  { "jeremypaul.me", true },
  { "jeremytcd.com", true },
  { "jericamacmillan.com", true },
  { "jering.tech", true },
  { "jeroendeneef.com", true },
  { "jeroensangers.com", true },
  { "jerret.de", true },
  { "jerryweb.org", true },
  { "jerryyu.ca", true },
  { "jerseybikehire.co.uk", true },
  { "jerseyjumpingbeans.co.uk", true },
  { "jerseylvi2013.org", true },
  { "jes.events", true },
  { "jesec.io", true },
  { "jesse3.com", true },
  { "jesseerbach.com", true },
  { "jessekaufman.com", true },
  { "jessesjumpingcastles.co.uk", true },
  { "jessevictors.com", true },
  { "jessgranger.com", false },
  { "jessicabenedictus.nl", false },
  { "jessicahrehor.com", true },
  { "jesters-court.net", true },
  { "jesuisadmin.fr", true },
  { "jet-stream.fr", true },
  { "jetbbs.com", true },
  { "jetflex.de", true },
  { "jetkittens.co.uk", true },
  { "jetsetboyz.net", true },
  { "jetsieswerda.nl", true },
  { "jetwhiz.com", true },
  { "jeuxetcodes.fr", true },
  { "jeweet.net", true },
  { "jewishboyscouts.com", true },
  { "jewishquotations.com", true },
  { "jexler.net", true },
  { "jf-fotos.de", true },
  { "jfbst.net", true },
  { "jfmhero.me", true },
  { "jfreitag.de", true },
  { "jfsa.jp", true },
  { "jgid.de", true },
  { "jgke.fi", true },
  { "jglover.com", true },
  { "jgoldgroup.com", true },
  { "jgregory.co.uk", true },
  { "jgwb.de", true },
  { "jgwb.eu", true },
  { "jhalderm.com", true },
  { "jhaveri.net", true },
  { "jhe.li", true },
  { "jhf.io", true },
  { "jhill.de", true },
  { "jhollandtranslations.com", true },
  { "jhuang.me", true },
  { "jhwestover.com", true },
  { "jiahao.codes", true },
  { "jiangxu.site", true },
  { "jianji.de", true },
  { "jianshu.com", true },
  { "jianyuan.pro", true },
  { "jiatingtrading.com", true },
  { "jiazhao.ga", true },
  { "jicaivvip.com", true },
  { "jichi.io", true },
  { "jichi000.win", true },
  { "jieyang2016.com", true },
  { "jimbiproducts.com", true },
  { "jimbraaten.com", true },
  { "jimbutlerkiaparts.com", true },
  { "jimdorf.com", true },
  { "jimfranke.com", true },
  { "jimfranke.nl", true },
  { "jimizhou.xyz", true },
  { "jimmycai.com", false },
  { "jimmycn.com", false },
  { "jimmyroura.ch", true },
  { "jimshaver.net", true },
  { "jimslop.nl", true },
  { "jinanshen.com", true },
  { "jinbo123.com", false },
  { "jinbowiki.org", true },
  { "jing.su", true },
  { "jingjo.com.au", true },
  { "jinja.ai", true },
  { "jinkuru.net", true },
  { "jino-jossy.appspot.com", true },
  { "jinshuju.net", true },
  { "jintaiyang123.org", true },
  { "jiogo.com", true },
  { "jirav.com", true },
  { "jiripudil.cz", true },
  { "jirosworld.com", true },
  { "jisai.net.cn", true },
  { "jisha.site", true },
  { "jixun.moe", true },
  { "jiyusu.com", true },
  { "jiyuu-ni.com", true },
  { "jiyuu-ni.net", true },
  { "jjhampton.com", true },
  { "jjj.blog", true },
  { "jjjconnection.com", true },
  { "jjlvk.nl", true },
  { "jjmarketing.co.uk", true },
  { "jjspartyhire.co.uk", true },
  { "jjspartytime.co.uk", true },
  { "jjsummerboatparty.co.uk", true },
  { "jjvanoorschot.nl", true },
  { "jk-entertainment.biz", true },
  { "jkchocolate.com", true },
  { "jki.io", true },
  { "jkinteriorspa.com", true },
  { "jkirsche.com", true },
  { "jkrippen.com", true },
  { "jkyuan.tk", true },
  { "jl-dns.eu", true },
  { "jl-dns.nl", true },
  { "jl-exchange.nl", true },
  { "jl-mail.nl", true },
  { "jlink.nl", true },
  { "jlkhosting.com", true },
  { "jloh.codes", true },
  { "jlot.org", true },
  { "jlpn.eu", true },
  { "jlpn.nl", true },
  { "jlponsetto.com", true },
  { "jlr-luxembourg.com", true },
  { "jltctech.com", true },
  { "jm-bea.net", true },
  { "jmalarcon.es", true },
  { "jmarciniak.it", true },
  { "jmatt.org", true },
  { "jmbeautystudio.se", true },
  { "jmbelloteau.com", true },
  { "jmcashngold.com.au", true },
  { "jmcataffo.com", true },
  { "jmce.eu", true },
  { "jmcleaning.services", true },
  { "jmdekker.it", true },
  { "jmedved.com", true },
  { "jmentertainment.co.uk", true },
  { "jmfjltd.com", true },
  { "jmk.hu", true },
  { "jmorahan.net", true },
  { "jmoreau.ddns.net", true },
  { "jmpb.hu", true },
  { "jmsolodesigns.com", true },
  { "jmssg.jp", true },
  { "jnjdj.com", true },
  { "jnm-art.com", true },
  { "jnordell.com", true },
  { "joa-ebert.com", true },
  { "joacimeldre.com", true },
  { "joanofarcmtcarmel.org", true },
  { "joaoaugusto.net", true },
  { "joaosampaio.com.br", true },
  { "joaquimgoliveira.pt", true },
  { "job-ofertas.info", true },
  { "job-offer.de", true },
  { "job.biz.tr", true },
  { "jobatus.com.br", true },
  { "jobatus.es", true },
  { "jobatus.it", true },
  { "jobatus.mx", true },
  { "jobatus.pt", true },
  { "jobbkk.com", true },
  { "jobbsafari.no", true },
  { "jobbsafari.se", true },
  { "jobcorpsy2y.com", true },
  { "jobify.in", true },
  { "jobindex.dk", true },
  { "joblab.com.ua", true },
  { "joblife.co.za", true },
  { "jobmi.com", true },
  { "jobmiplayground.com", true },
  { "jobs-in-tech.com", true },
  { "jobs.at", true },
  { "jobs.ch", true },
  { "jobs4sales.ch", true },
  { "jobseekeritalia.it", true },
  { "jobsisbrown.com", true },
  { "jobsnet.eu", true },
  { "jobsuchmaschine.ch", true },
  { "jobwinner.ch", true },
  { "jobzninja.com", true },
  { "jockbusuttil.co.uk", true },
  { "jockbusuttil.com", true },
  { "jockbusuttil.uk", true },
  { "jodaniels.photography", true },
  { "jodlajodla.si", true },
  { "joduska.me", true },
  { "jodyboucher.com", false },
  { "joe262.com", true },
  { "joedavison.me", true },
  { "joedinardo.com", true },
  { "joedoyle.us", true },
  { "joefixit.co", true },
  { "joehenry.co.uk", true },
  { "joejohnson.name", true },
  { "joel.coffee", true },
  { "joelcoustrain.com", true },
  { "joeldrapper.com", true },
  { "joelfries.com", true },
  { "joelj.org", true },
  { "joelle.me", true },
  { "joelleandpeter.co.uk", true },
  { "joellimberg.com", true },
  { "joellombardo.com", false },
  { "joelmarkhamphotography.com.au", true },
  { "joelmunch.com", true },
  { "joelnichols.uk", true },
  { "joelotu.com", true },
  { "joemotherfuckingjohnson.com", true },
  { "joepitt.co.uk", false },
  { "joergschneider.com", true },
  { "joerosca.com", true },
  { "joerss.at", true },
  { "joeskup.com", true },
  { "joespaintingpgh.com", true },
  { "joestead.codes", true },
  { "joetsutj.com", true },
  { "joetyson.me", true },
  { "joeyfelix.com", true },
  { "joeygitalian.com", true },
  { "joeyhoer.com", true },
  { "joeysmith.com", true },
  { "joeyvanvenrooij.nl", true },
  { "joeyvilaro.com", true },
  { "jogi-server.de", true },
  { "jogorama.com.br", false },
  { "jogwitz.de", true },
  { "johanli.com", true },
  { "johannes-bauer.com", true },
  { "johannes-zinke.de", true },
  { "johannes.io", true },
  { "johannes.wtf", true },
  { "johannesburg-escorts.co.za", true },
  { "johannesen.tv", true },
  { "johanneskonrad.de", true },
  { "johannespichler.com", false },
  { "johanpeeters.com", true },
  { "johansf.tech", true },
  { "johego.org", true },
  { "johnaltamura.com", true },
  { "johnbeil.com", true },
  { "johnberan.com", true },
  { "johnblackbourn.com", true },
  { "johnbpodcast.com", true },
  { "johncook.ltd.uk", true },
  { "johndball.com", true },
  { "johnfulgenzi.com", true },
  { "johngallias.com", true },
  { "johngo.tk", false },
  { "johnguant.com", true },
  { "johnkastler.net", true },
  { "johnmcc.net", true },
  { "johnmcintosh.pro", true },
  { "johnmh.me", true },
  { "johnno.be", true },
  { "johnnybet.com", true },
  { "johnnybsecure.com", true },
  { "johnroach.io", true },
  { "johnroberts.me", true },
  { "johnrockefeller.net", true },
  { "johnsanchez.io", true },
  { "johnsegovia.com", true },
  { "johnsiu.com", true },
  { "johnsonho.net", true },
  { "johnvanhese.nl", true },
  { "johnyytb.be", true },
  { "joi-dhl.ch", true },
  { "joinhonor.com", true },
  { "jointotem.com", true },
  { "joinus-outfits.nl", true },
  { "jojosplaycentreandcafeteria.co.uk", true },
  { "jokedalderup.nl", true },
  { "joker.menu", true },
  { "jokerice.co.uk", true },
  { "jokesbykids.com", true },
  { "jokewignand.nl", true },
  { "joliettech.com", true },
  { "jollausers.de", true },
  { "jolle.io", true },
  { "jollygoodspudz.ca", true },
  { "jollykidswobbleworld.co.uk", true },
  { "jolokia.ch", true },
  { "jomo.tv", true },
  { "jomofojo.co", true },
  { "jomofojo.com", true },
  { "jonahperez.com", true },
  { "jonale.net", true },
  { "jonandnoraswedding.com", true },
  { "jonas-thelemann.de", true },
  { "jonas-wenk.de", false },
  { "jonaskjodt.com", true },
  { "jonasled.de", true },
  { "jonaswitmer.ch", true },
  { "jonathan-apps.com", true },
  { "jonathancarter.org", true },
  { "jonathandupree.com", true },
  { "jonathanha.as", true },
  { "jonathanj.nl", true },
  { "jonathanlara.com", true },
  { "jonathanschle.de", true },
  { "jonathanselea.se", true },
  { "jonblankenship.com", true },
  { "jondarby.com", true },
  { "jondevin.com", true },
  { "jondowdle.com", true },
  { "jonespayne.com", false },
  { "jonferwerda.net", true },
  { "jong030.nl", true },
  { "jongbloed.nl", true },
  { "jongcs.com", true },
  { "jonilar.com", true },
  { "jonincharacter.com", true },
  { "jonirrings.com", true },
  { "jonkermedia.nl", false },
  { "jonlabelle.com", true },
  { "jonlu.ca", true },
  { "jonnybarnes.uk", true },
  { "jonnystoten.com", true },
  { "jonoalderson.com", true },
  { "jonola.com", true },
  { "jonpads.com", true },
  { "jonpavelich.com", true },
  { "jons.org", true },
  { "jonscaife.com", true },
  { "jooksms.com", true },
  { "jooksuratas.ee", true },
  { "joomlant.org", true },
  { "joompress.biz", true },
  { "joonatoona.me", true },
  { "joostrijneveld.nl", true },
  { "joostvanderlaan.nl", true },
  { "jopsens.de", true },
  { "joran.org", true },
  { "jorcus.com", true },
  { "jordan-jungk.de", true },
  { "jordandevelopment.com", true },
  { "jordanhamilton.me", true },
  { "jordankmportal.com", true },
  { "jordans.co.uk", true },
  { "jordanscorporatelaw.com", true },
  { "jordanstrustcompany.com", true },
  { "jordhy.com", true },
  { "jorgerosales.org", true },
  { "jorisdalderup.nl", true },
  { "jornalalerta.com.br", true },
  { "joscares.com", true },
  { "jose-alexand.re", true },
  { "jose-lesson.com", true },
  { "joseetesser.nl", true },
  { "josef-lotz.de", true },
  { "josefjanosec.com", true },
  { "josefottosson.se", true },
  { "joseitoda.org", true },
  { "josepbel.com", true },
  { "josephbleroy.com", true },
  { "josephgeorge.com.au", true },
  { "josephre.es", false },
  { "josephsniderman.com", true },
  { "josephsniderman.net", true },
  { "josephsniderman.org", true },
  { "josephv.website", true },
  { "joshgilson.com", true },
  { "joshgrancell.com", true },
  { "joshharkema.com", true },
  { "joshharmon.me", true },
  { "joshics.in", true },
  { "joshlovephotography.co.uk", true },
  { "joshpanter.com", false },
  { "joshrickert.com", true },
  { "joshruppe.com", true },
  { "joshschmelzle.com", true },
  { "joshtriplett.org", true },
  { "joshua-kuepper.de", true },
  { "joshua.bio", true },
  { "joshuadmiller.info", true },
  { "joshuajohnson.ca", true },
  { "joshuameunier.com", true },
  { "joshuarogers.net", true },
  { "josoansi.de", true },
  { "journalism-schools.com", true },
  { "journeyfriday.rocks", true },
  { "journeytomastery.net", true },
  { "jouwpaardenbak.nl", true },
  { "jovani.com", false },
  { "jovic.hamburg", true },
  { "joyful.house", true },
  { "joyfulexpressions.gallery", true },
  { "joynadvisors.com", true },
  { "joyofcookingandbaking.com", true },
  { "joysinventingblog.com", true },
  { "jpbe.de", true },
  { "jpdeharenne.be", true },
  { "jpeg.io", true },
  { "jphandjob.com", true },
  { "jplesbian.com", true },
  { "jpmelos.com", true },
  { "jpmelos.com.br", true },
  { "jpmguitarshop.com.br", true },
  { "jpod.cc", true },
  { "jpralves.net", true },
  { "jps-selection.co.uk", true },
  { "jps-selection.com", true },
  { "jps-selection.eu", true },
  { "jpshop.ru", true },
  { "jpsinflatables.co.uk", true },
  { "jpslconsulting.ca", true },
  { "jquery.wtf", true },
  { "jr5devdoug.xyz", true },
  { "jr5devdouglas.xyz", true },
  { "jr5proxdoug.xyz", true },
  { "jrabasco.me", true },
  { "jrc9.ca", true },
  { "jrchaseify.xyz", true },
  { "jreb.nl", true },
  { "jreinert.com", true },
  { "jrflorian.com", true },
  { "jrlopezoficial.com", true },
  { "jross.me", true },
  { "jrtapsell.co.uk", true },
  { "jrxpress.com", true },
  { "js-web.eu", true },
  { "js3311.com", true },
  { "js8855.com", true },
  { "js93029.com", true },
  { "jschoi.org", true },
  { "jschumacher.info", true },
  { "jsd-cog.org", true },
  { "jsdelivr.com", true },
  { "jselby.net", true },
  { "jsent.co.uk", true },
  { "jsevilleja.org", true },
  { "jskier.com", false },
  { "jskoelliken.ch", true },
  { "jsmetallerie.fr", true },
  { "jsnfwlr.com", true },
  { "jsnfwlr.io", true },
  { "jsonsinc.com", true },
  { "jsteward.moe", true },
  { "jtcat.com", true },
  { "jtconsultancy.sg", true },
  { "jthackery.com", false },
  { "jtl-software.com", true },
  { "jtmar.me", true },
  { "jtp.id", true },
  { "jts3servermod.com", true },
  { "jtslay.com", true },
  { "ju.io", true },
  { "juan23.edu.uy", true },
  { "juanfrancisco.tech", true },
  { "juanjovega.com", true },
  { "juanmaguitar.com", true },
  { "juanmazzetti.com", true },
  { "juanxt.ddns.net", true },
  { "jubileum.online", true },
  { "jubileumfotograaf.nl", true },
  { "jucca-nautica.si", true },
  { "juch.cc", true },
  { "juchit.at", true },
  { "judc-ge.ch", true },
  { "judge2020.com", true },
  { "judge2020.me", true },
  { "judoprodeti.cz", true },
  { "judosaintdenis.fr", true },
  { "judytka.cz", true },
  { "juef.space", true },
  { "juegosycodigos.es", true },
  { "juegosycodigos.mx", true },
  { "juegosyolimpicos.com", true },
  { "juelda.com", true },
  { "juergen-elbert.de", true },
  { "juergen-roehrig.de", true },
  { "juergenhecht.de", true },
  { "juergenklieber.de", true },
  { "juergenspecht.com", true },
  { "juergenspecht.de", true },
  { "jugendfeuerwehr-vechta.de", true },
  { "jugendhackt.org", true },
  { "jugendsuenden.info", true },
  { "jugh.de", true },
  { "juhakoho.com", true },
  { "juice.codes", true },
  { "juk.life", false },
  { "juku-info.top", true },
  { "juku-wing.jp", true },
  { "jule-spil.dk", true },
  { "julenlanda.com", false },
  { "julian-uphoff.de", true },
  { "julian-weigle.de", true },
  { "juliangonggrijp.com", true },
  { "julianickel.de", true },
  { "julianmeyer.de", true },
  { "julianmp.info", true },
  { "juliansimioni.com", true },
  { "julianskitchen.ch", true },
  { "julianvmodesto.com", true },
  { "julianweigle.de", true },
  { "julianxhokaxhiu.com", true },
  { "juliazeengardendesign.co.uk", true },
  { "julibear.com", true },
  { "julibon.com", true },
  { "julico.nl", true },
  { "julie-and-stevens-wedding.com", true },
  { "juliedecubber.com", true },
  { "juliekoubova.net", true },
  { "juliekproperties.com", true },
  { "juliemaurel.fr", true },
  { "julienc.io", true },
  { "julienpaterne.com", true },
  { "julienschmidt.com", true },
  { "julientartarin.com", true },
  { "julius-zoellner.de", true },
  { "jullensgroningen.com", true },
  { "juls.cloud", true },
  { "jultube.de", true },
  { "jumbopan.net", true },
  { "jumboquid.co.uk", true },
  { "jump-zone.co.uk", true },
  { "jump.bg", false },
  { "jump.wtf", true },
  { "jump4funinflatables.co.uk", true },
  { "jumpandbounce.co.uk", true },
  { "jumpandjivechildrensparties.co.uk", true },
  { "jumparoundbouncycastles.co.uk", true },
  { "jumparty.co.uk", true },
  { "jumpeasy.com.au", true },
  { "jumperoos.co.uk", true },
  { "jumpin-jax.co.uk", true },
  { "jumpinchat.com", true },
  { "jumpingbee.co.uk", true },
  { "jumpingcastlesonline.com.au", true },
  { "jumpingjacksbouncycastles.co.uk", true },
  { "jumpinjaes.co.uk", true },
  { "jumpinmonkeys.co.uk", true },
  { "jumpintogreenerpastures.com", true },
  { "jumpnplay.co.uk", true },
  { "jundongwu.com", true },
  { "junespina.com", true },
  { "junethack.net", true },
  { "jungaa.fr", true },
  { "jungesforumkonstanz.de", true },
  { "junggesellmuc.de", true },
  { "jungleducks.ca", true },
  { "junglejackscastles.co.uk", true },
  { "junglememories.co.uk", true },
  { "junglist.org", true },
  { "jungundwild-design.de", false },
  { "juni.io", true },
  { "junias-fenske.de", true },
  { "juniperroots.ca", true },
  { "junjhome.com", true },
  { "junjun-web.net", true },
  { "junkdrome.org", true },
  { "juno.co.uk", true },
  { "junodownload.com", true },
  { "jura-reiseschutz.de", true },
  { "jurassicbarkharrogate.co.uk", true },
  { "jurassicgolf.nl", true },
  { "juridoc.com.br", true },
  { "jurijbuga.de", true },
  { "jurriaan.ninja", true },
  { "just-a-clanpage.de", true },
  { "just-vet-and-drive.fr", true },
  { "justanothercompany.name", true },
  { "justbelieverecoverypa.com", true },
  { "justbookexcursions.com", true },
  { "justbookhotels.com", true },
  { "justbooktransfers.com", true },
  { "justboom.co", true },
  { "justbouncecastles.co.uk", true },
  { "justchunks.net", true },
  { "justgalak.com", true },
  { "justgalak.org", true },
  { "justice.gov", true },
  { "justice4assange.com", true },
  { "justin-tech.com", false },
  { "justinharrison.ca", true },
  { "justinho.com", true },
  { "justinmuturifoundation.org", true },
  { "justinribeiro.com", true },
  { "justinstandring.com", true },
  { "justmensgloves.com", true },
  { "justpaste.it", true },
  { "justsmart.io", true },
  { "justsome.info", true },
  { "justtalk.site", true },
  { "justthinktwice.gov", false },
  { "justupdate.me", true },
  { "justyy.com", true },
  { "juszkiewicz.com.pl", true },
  { "jutlander-netbank.dk", true },
  { "jutlander.dk", true },
  { "juttaheitland.com", true },
  { "juusujanar.eu", true },
  { "juvenex.co", true },
  { "juwelierstoopman.nl", true },
  { "jva-wuerzburg.de", true },
  { "jvandenbroeck.com", true },
  { "jvanerp.nl", true },
  { "jvbouncycastlehire.co.uk", true },
  { "jvega.me", true },
  { "jvlandscapingservices.com", true },
  { "jvphotoboothhire.co.uk", true },
  { "jvsticker.com", true },
  { "jvwdev.nl", true },
  { "jwallet.cc", true },
  { "jwatt.org", true },
  { "jwe.nl", true },
  { "jwilsson.com", true },
  { "jwjwjw.com", true },
  { "jwmmarketing.com", true },
  { "jwnotifier.org", true },
  { "jwod.gov", true },
  { "jwplay.ml", true },
  { "jwschuepfheim.ch", true },
  { "jwsoft.nl", true },
  { "jxltom.com", true },
  { "jxm.in", true },
  { "jydemarked.dk", true },
  { "jyggen.com", true },
  { "jym.fit", true },
  { "jyoti-fairworks.org", true },
  { "jzbk.org", true },
  { "k-bone.com", true },
  { "k-homes.net", true },
  { "k-netz.de", true },
  { "k-pan.com", true },
  { "k-plant.com", true },
  { "k-pture.com", true },
  { "k-scr.me", true },
  { "k-system.de", true },
  { "k-tube.com", true },
  { "k1024.org", true },
  { "k258059.net", true },
  { "k2mts.org", true },
  { "k3508.com", true },
  { "k3nny.fr", true },
  { "k4law.com", true },
  { "k4r.ru", true },
  { "k7azx.com", true },
  { "k82.org", true },
  { "k8n.de", true },
  { "k8r.eu", true },
  { "k9swx.com", true },
  { "kaamoscreations.com", true },
  { "kaangenc.me", true },
  { "kaany.io", true },
  { "kaasbesteld.nl", true },
  { "kaatha-kamrater.se", true },
  { "kab-s.de", true },
  { "kabaca.design", true },
  { "kabarlinux.id", true },
  { "kabashop.com.br", true },
  { "kabat-fans.cz", true },
  { "kabeltv.co.nz", true },
  { "kabeuchi.com", true },
  { "kaboom.pw", true },
  { "kabu-abc.com", true },
  { "kabulpress.org", true },
  { "kacgal.com", true },
  { "kachelfm.nl", true },
  { "kachlikova2.cz", true },
  { "kack.website", true },
  { "kadhambam.in", true },
  { "kado-ya.jp", true },
  { "kaeru-seitai.com", true },
  { "kaffeekrone.de", true },
  { "kafoom.de", true },
  { "kagitreklam.com", true },
  { "kaheim.de", true },
  { "kai-ratzeburg.de", true },
  { "kaigojj.com", true },
  { "kaikei7.com", true },
  { "kaileymslusser.com", true },
  { "kairion.de", false },
  { "kaisakura.net", true },
  { "kaisev.net", false },
  { "kaitol.click", true },
  { "kaiusaltd.com", true },
  { "kaivac-emea.com", true },
  { "kaizenreporting.com", true },
  { "kaizeronion.com", true },
  { "kajak.land", true },
  { "kaka.farm", true },
  { "kakao-karten.de", true },
  { "kakaravaara.fi", true },
  { "kakie-gobocha.jp", true },
  { "kakie-kolesa.ru", true },
  { "kakolightingmuseum.or.jp", true },
  { "kalakarclub.com", true },
  { "kalamos-psychiatrie.be", true },
  { "kalastus.com", true },
  { "kaleidoscope.co.uk", true },
  { "kalender.com", true },
  { "kalevlamps.co.uk", true },
  { "kaliaa.fi", true },
  { "kalian.cz", true },
  { "kalifornien-tourismus.de", true },
  { "kalkulacka-havarijni.cz", true },
  { "kall.is", true },
  { "kallies-net.de", true },
  { "kalmar.com", true },
  { "kalolina.com", true },
  { "kalombo.ru", true },
  { "kalsbouncies.com", true },
  { "kaltenbrunner.it", true },
  { "kalterersee.ch", true },
  { "kalwestelectric.com", true },
  { "kam-serwis.pl", true },
  { "kamikaichimaru.com", false },
  { "kamikatse.net", true },
  { "kaminbau-laub.de", true },
  { "kamisato-ent.com", true },
  { "kamixa.se", true },
  { "kamppailusali.fi", true },
  { "kampunginggris-ue.com", true },
  { "kamranmirhazar.com", true },
  { "kamui.co.uk", true },
  { "kan3.de", true },
  { "kana-mono.biz", true },
  { "kana.me", true },
  { "kanaete-uranai.com", true },
  { "kanag.pl", true },
  { "kanal-schaefer.de", true },
  { "kanal-tv-haensch.de", true },
  { "kandianshang.com", true },
  { "kanecastles.com", true },
  { "kanehusky.com", true },
  { "kanetix.ca", true },
  { "kangaroo-bouncycastle.co.uk", true },
  { "kangarooislandholidayaccommodation.com.au", true },
  { "kangaroojacks.co.uk", true },
  { "kangaroos.org", true },
  { "kangaroovalleykayaks.com.au", true },
  { "kangaroovalleymuseum.com", true },
  { "kangaroovalleyolives.com.au", true },
  { "kangaroovalleyshow.org.au", true },
  { "kangaroovalleywoodcrafts.com.au", true },
  { "kangkai.me", true },
  { "kangooroule.fr", true },
  { "kanis.ag", true },
  { "kankimaru.com", true },
  { "kanna.cf", true },
  { "kanobu.ru", true },
  { "kansaiyamamoto.jp", true },
  { "kantankye.nl", true },
  { "kantanmt.com", true },
  { "kantorkita.net", true },
  { "kantorosobisty.pl", true },
  { "kanuvu.de", true },
  { "kany.me", false },
  { "kanzakiranko.jp", false },
  { "kanzashi.com", true },
  { "kanzlei-gaengler.de", true },
  { "kanzlei-myca.de", true },
  { "kanzlei-oehler.com", true },
  { "kanzlei-sixt.de", true },
  { "kap-genial.de", true },
  { "kapgy-moto.com", true },
  { "kappenstein.org", false },
  { "kapseli.net", true },
  { "kaptadata.com", true },
  { "kaptamedia.com", true },
  { "kara-fabian.com", true },
  { "kara-fabian.de", true },
  { "karabas.com", true },
  { "karabijnhaken.nl", false },
  { "karachi.dating", true },
  { "karaface.com", true },
  { "karalane.com", true },
  { "karamomo.net", true },
  { "karanjthakkar.com", true },
  { "karasik.by", true },
  { "karateka.org", true },
  { "karateka.ru", true },
  { "kardize24.pl", true },
  { "kardolocksmith.com", true },
  { "karewan.ovh", true },
  { "kargl.net", true },
  { "karguine.in", true },
  { "karhm.com", true },
  { "karina.gd", true },
  { "karit.nz", true },
  { "karlbowden.com", true },
  { "karlic.net", true },
  { "karlin.run", true },
  { "karlloch.de", true },
  { "karlsmithmn.org", true },
  { "karlzotter.com", true },
  { "karmaassurance.ca", true },
  { "karmabaker.com", true },
  { "karmaflux.com", true },
  { "karmainsurance.ca", true },
  { "karmaplatform.com", true },
  { "karmaspa.se", true },
  { "karn.nu", true },
  { "karneid.info", true },
  { "karoverwaltung.de", true },
  { "karsofsystems.com", true },
  { "karsten-voigt.de", true },
  { "karta-paliwowa.pl", true },
  { "kartacha.com", true },
  { "kartar.net", false },
  { "kartatopia.com", true },
  { "kartec.com", true },
  { "karten-verlag.de", true },
  { "kartonmodellbau.org", true },
  { "karula.org", true },
  { "karupp-did.net", true },
  { "kasadara.com", true },
  { "kasei.im", true },
  { "kashinavi.com", true },
  { "kashmirobserver.net", true },
  { "kasko.io", true },
  { "kasnoffskinclinic.com", true },
  { "kassa.at", true },
  { "kastankaoffice.cz", true },
  { "kastelruth.biz", true },
  { "kastemperaturen.ga", true },
  { "kastorsky.ru", true },
  { "kat.marketing", true },
  { "katagena.com", true },
  { "katalogbajugamismu.com", true },
  { "katata-kango.ac.jp", true },
  { "katcleaning.com.au", true },
  { "katedra.de", true },
  { "kateduggan.net", true },
  { "katekligys.com", true },
  { "katemihalikova.cz", true },
  { "katericke.com", true },
  { "katex.org", true },
  { "kathardt.de", true },
  { "kathegiraldo.com", true },
  { "kati-raumplaner.de", true },
  { "katiechai.xyz", true },
  { "katieskandy.co.uk", true },
  { "katieskastles.co.uk", true },
  { "katja-und-ronny.de", true },
  { "katka.info", true },
  { "katnunn.co.uk", true },
  { "kato-yane.com", true },
  { "katscastles.co.uk", true },
  { "kattelans.eu", true },
  { "katyl.info", false },
  { "katyusha.net", false },
  { "katzenbrunnen-test.de", true },
  { "katzensklave.me", true },
  { "katzrkool.xyz", true },
  { "kau-boys.com", true },
  { "kau-boys.de", true },
  { "kaufberatung.community", true },
  { "kaufmanbankruptcylaw.com", true },
  { "kavovary-kava.cz", true },
  { "kawaii.io", true },
  { "kaweus.de", true },
  { "kay.la", true },
  { "kayakabovegroundswimmingpools.com", true },
  { "kayscs.com", true },
  { "kazakov.lt", true },
  { "kazancci.com", true },
  { "kazand.lt", true },
  { "kazandaemon.ru", true },
  { "kazek.com.pl", true },
  { "kazekprzewozy.pl", true },
  { "kazu.click", true },
  { "kazuhirohigashi.com", true },
  { "kazumi.ro", true },
  { "kazy111.info", true },
  { "kb3.net", true },
  { "kb88.com", true },
  { "kba-online.de", true },
  { "kbb-ev.de", true },
  { "kbbouncycastlehire.co.uk", true },
  { "kbcequitas.hu", true },
  { "kbit.dk", true },
  { "kbjorklu.com", true },
  { "kbleventhire.co.uk", true },
  { "kbterapicenter.se", true },
  { "kc-holzfaeller.de", true },
  { "kc1hbk.com", true },
  { "kc3.moe", true },
  { "kc5mpk.com", true },
  { "kcc.sh", true },
  { "kcliner.com", true },
  { "kcmicapital.com", true },
  { "kcolford.com", false },
  { "kcshipping.co.uk", true },
  { "kcsordparticipation.org", true },
  { "kd.net.nz", true },
  { "kdex.de", true },
  { "kdfans.com", true },
  { "kdw.cloud", true },
  { "kdyby.org", true },
  { "ke.fo", true },
  { "ke7tlf.us", true },
  { "keakon.net", true },
  { "keane.space", true },
  { "keaneokelley.com", true },
  { "keaysmillwork.com", true },
  { "keb.com.au", true },
  { "keb.net.au", true },
  { "kebabbesteld.nl", true },
  { "kebabbruce.com", true },
  { "kecht.at", true },
  { "kedarastudios.com", true },
  { "kedibizworx.com", true },
  { "kediri.win", true },
  { "kedv.es", true },
  { "keeleysam.com", true },
  { "keelove.net", true },
  { "keematdekho.com", true },
  { "keengamer.com", true },
  { "keepa.com", true },
  { "keeperapp.com", true },
  { "keeperklan.com", false },
  { "keepersecurity.com", true },
  { "keepingtheplot.co.uk", true },
  { "keepiteasy.eu", true },
  { "keevitaja.com", true },
  { "keeweb.info", true },
  { "keezin.ga", true },
  { "keganthorrez.com", true },
  { "kehlenbach.net", true },
  { "keifel.de", true },
  { "kein-design.de", true },
  { "keinanung.nl", true },
  { "keinefilterblase.de", true },
  { "keisaku.org", true },
  { "keishiando.com", true },
  { "keithlomax.com", true },
  { "keithws.net", true },
  { "kejar.id", true },
  { "keke-shop.ch", true },
  { "kekgame.com", true },
  { "kekku.li", true },
  { "keksi.io", true },
  { "kela.jp", true },
  { "keldan.fo", true },
  { "kelderwijnen.nl", true },
  { "kelgtermans-usedcars.be", true },
  { "kelheor.space", true },
  { "kellerlan.org", true },
  { "kelleymcchesney.us", true },
  { "kellimacconnell.com", true },
  { "kellygrenard.com", true },
  { "kellyskastles.co.uk", true },
  { "kellyssportsbarandgrill.com", true },
  { "kelsa.io", true },
  { "kelvinfichter.com", true },
  { "kemmerer-net.de", true },
  { "kempkens.io", true },
  { "kempo-sissach.ch", true },
  { "kemptown.co.uk", true },
  { "kemptown.com", true },
  { "kemptown.net", true },
  { "ken.fm", true },
  { "kenalsworld.com", true },
  { "kenbillionsyuan.tk", true },
  { "kenbonny.net", true },
  { "kengilmour.com", true },
  { "kenguntokku.jp", true },
  { "kenia-vakantie.nl", true },
  { "kenners.org", true },
  { "kennethaasan.no", true },
  { "kennethferguson.com", true },
  { "kennethlim.me", true },
  { "kenneths.org", true },
  { "kenny-peck.com", true },
  { "kennynet.co.uk", true },
  { "keno.im", true },
  { "kenokallinger.at", true },
  { "kenoschwalb.com", false },
  { "kenrogers.co", false },
  { "kens.pics", true },
  { "kensbouncycastles.co.uk", true },
  { "kenscustomfloors.com", true },
  { "kentec.net", true },
  { "kenterlis.gr", true },
  { "kenvix.com", true },
  { "kenx5.eu.org", true },
  { "kenyons.info", true },
  { "keops-spine.fr", true },
  { "keops-spine.us", true },
  { "kepkonyvtar.hu", true },
  { "keralit.nl", true },
  { "kerebro.com", true },
  { "kerforhome.com", true },
  { "kerijacoby.com", true },
  { "kermadec.com", true },
  { "kermadec.fr", true },
  { "kermadec.net", true },
  { "kernel-error.de", true },
  { "kernelpanics.nl", true },
  { "kerrfrequencycombs.org", true },
  { "kerrnel.com", true },
  { "kersbergen.nl", true },
  { "kerstkaart.nl", true },
  { "kersvers.agency", true },
  { "kerus.net", true },
  { "kerzyte.net", true },
  { "kescher.site", true },
  { "kessawear.com", true },
  { "kesslerwine.com", true },
  { "kesteren.org", true },
  { "ketamine.co.uk", true },
  { "ketaminecareclinic.com", true },
  { "ketosecology.co.uk", true },
  { "ketotadka.com", true },
  { "kettlebellkrusher.com", true },
  { "kettner.com", true },
  { "ketty-voyance.com", true },
  { "keutel.net", true },
  { "kevin-darmor.eu", true },
  { "kevin-ta.com", true },
  { "kevinapease.com", true },
  { "kevinbowers.me", true },
  { "kevinbusse.de", true },
  { "kevincox.ca", false },
  { "kevingsky.com", true },
  { "kevinheslinphoto.com", true },
  { "kevinhill.nl", true },
  { "kevinhq.com", true },
  { "kevinkla.es", true },
  { "kevinlocke.name", true },
  { "kevinmeijer.nl", true },
  { "kevinmorssink.nl", true },
  { "kevinpirnie.com", false },
  { "kevinrandles.com", true },
  { "kevinratcliff.com", true },
  { "kevyn.lu", true },
  { "kexueboy.com", true },
  { "keybase.io", true },
  { "keybored.co", true },
  { "keybored.me", true },
  { "keycdn.com", true },
  { "keycenter.com.br", true },
  { "keycontainers.co.za", true },
  { "keyerror.com", true },
  { "keygen.sh", true },
  { "keyholdingservices.co.uk", true },
  { "keyhomechecker.com", true },
  { "keyihao.cn", true },
  { "keyinfo.io", true },
  { "keylaserinstitute.com", true },
  { "keylength.com", true },
  { "keymach.com", true },
  { "keypersonins.com", true },
  { "keys.jp", true },
  { "keystoneok.com", false },
  { "keysupport.org", true },
  { "keywebdesign.nl", true },
  { "kf7joz.com", true },
  { "kfassessment.com", true },
  { "kffs.ru", true },
  { "kfirba.me", true },
  { "kfm.ink", true },
  { "kforesund.se", true },
  { "kfv-kiel.de", false },
  { "kfz-hantschel.de", true },
  { "kgm-irm.be", true },
  { "kgnk.ru", true },
  { "kgv-schlauroth.de", true },
  { "khaledgarbaya.net", false },
  { "khanovaskola.cz", true },
  { "khas.co.uk", true },
  { "khasiatmanfaat.com", true },
  { "kheshtar.pl", true },
  { "khetzal.info", true },
  { "khipu.com", true },
  { "khlee.net", true },
  { "khmb.ru", true },
  { "khoury-dulla.ch", true },
  { "khs1994.com", true },
  { "khslaw.com", true },
  { "khudothiswanpark.vn", true },
  { "khushiandjoel.com", true },
  { "kiadoapartman.hu", true },
  { "kiahoriane.com", true },
  { "kiano.net", true },
  { "kiapartscenter.net", true },
  { "kiapartsdepartment.com", true },
  { "kiapps.ovh", true },
  { "kibea.net", true },
  { "kibibit.net", true },
  { "kibriscicek.net", true },
  { "kick-in.nl", true },
  { "kickasscanadians.ca", true },
  { "kickedmycat.com", true },
  { "kickstart.com.pk", false },
  { "kicou.info", true },
  { "kiddieschristian.academy", true },
  { "kiddyboom.ua", true },
  { "kids-at-home.ch", true },
  { "kids-castles.com", true },
  { "kids-ok.com", true },
  { "kids2day.in", true },
  { "kidsareatrip.com", true },
  { "kidsclub.photos", true },
  { "kidsforsavingearth.org", true },
  { "kidsinwoods-interfacesouth.org", true },
  { "kidsmark.net", true },
  { "kidsneversleep.com", true },
  { "kidsplay-plymouth.co.uk", true },
  { "kidsplaybouncycastles.co.uk", true },
  { "kidtoyshop.ru", true },
  { "kidzpartiesllp.co.uk", true },
  { "kidzsmile.co.uk", true },
  { "kiebel.de", true },
  { "kiehls.pt", true },
  { "kiekin.org", true },
  { "kiekko.pro", true },
  { "kiel-kind.de", true },
  { "kieran.ie", true },
  { "kieranjones.uk", true },
  { "kiesuwkerstkaart.nl", true },
  { "kiffmarks.com", true },
  { "kigmbh.com", true },
  { "kiisu.club", true },
  { "kikbb.com", true },
  { "kiki-voice.jp", true },
  { "kikimilyatacado.com.br", true },
  { "kiku.pw", true },
  { "kilerd.me", true },
  { "kilianvalkhof.com", true },
  { "killaraapartments.com.au", true },
  { "killdeer.com", true },
  { "killedbynlp.com", true },
  { "killerit.in", true },
  { "killerkink.net", true },
  { "killerrobots.com", true },
  { "killymoonbouncycastles.com", true },
  { "kilobyte22.de", true },
  { "kilogram.nl", true },
  { "kilometertje.nl", true },
  { "kimamass.com", true },
  { "kimdumaine.com", true },
  { "kimiris.com", true },
  { "kimis.gr", true },
  { "kimisia.net", true },
  { "kimmel.com", true },
  { "kimmel.in", true },
  { "kimono-rental-one.com", true },
  { "kimotodental.com", true },
  { "kimsufi-jordi.tk", true },
  { "kimtran.kim", true },
  { "kin.life", true },
  { "kin.pet", true },
  { "kinautas.com", true },
  { "kinderbasar-luhe.de", true },
  { "kinderchor-bayreuth.de", true },
  { "kinderjugendfreizeitverein.de", true },
  { "kinderkleding.news", true },
  { "kinderpneumologie.ch", true },
  { "kindertagespflege-rasselbande-halle.de", true },
  { "kinderzahn-bogenhausen.de", true },
  { "kindfotografie.nl", true },
  { "kindleworth.com", true },
  { "kindlezs.com", true },
  { "kine-duthil.fr", true },
  { "kinepolis-studio.be", true },
  { "kinerd.me", true },
  { "kinesiomed-cryosauna.gr", true },
  { "kinetiq.com", true },
  { "king-of-the-castles.com", true },
  { "kingant.net", true },
  { "kinganywhere.eu", true },
  { "kingbird.me", true },
  { "kingdoms.gg", true },
  { "kingiescastles.co.uk", true },
  { "kingofshooting.com", true },
  { "kingofthecastlecoventry.co.uk", true },
  { "kingofthecastlesentertainments.co.uk", true },
  { "kingofthecastlesouthwales.co.uk", true },
  { "kingofthecastlesrhyl.co.uk", true },
  { "kingsfoot.com", true },
  { "kingsgateseptic.com", true },
  { "kingsley.cc", true },
  { "kingstclinic.com", true },
  { "kingtecservices.com", true },
  { "kingwoodtxlocksmith.com", true },
  { "kini24.ru", true },
  { "kinkcafe.net", true },
  { "kinkenonline.com", true },
  { "kinnikinnick.com", true },
  { "kinniyaonlus.com", true },
  { "kinocheck.de", true },
  { "kinohled.cz", true },
  { "kinomoto.me", true },
  { "kinomoto.ovh", false },
  { "kinos.nl", true },
  { "kinozal-tv.appspot.com", true },
  { "kinsights.com", false },
  { "kintawifi.com", false },
  { "kintone.com", true },
  { "kintore.tv", true },
  { "kiocloud.com", true },
  { "kionetworks.es", true },
  { "kipa.at", true },
  { "kipiradio.com", true },
  { "kippenbart.gq", true },
  { "kiragameforum.net", true },
  { "kiraku.co", true },
  { "kirbear.com", true },
  { "kirche-dortmund-ost.de", true },
  { "kirchen-im-web.de", false },
  { "kirchengemeinde-markt-erlbach.de", true },
  { "kircp.com", true },
  { "kirei.se", true },
  { "kirig.ph", true },
  { "kirikira.moe", true },
  { "kirill.ws", true },
  { "kirillaristov.com", true },
  { "kirinas.com", true },
  { "kirinuki.jp", true },
  { "kirkforcongress.com", true },
  { "kirkforillinois.com", true },
  { "kirkify.com", true },
  { "kirkovsky.com", true },
  { "kirsch-gestaltung.de", true },
  { "kirschbaum.me", true },
  { "kirslis.com", true },
  { "kirstenbos.ca", true },
  { "kirstin-peters.de", true },
  { "kirwandigital.com", true },
  { "kis-toitoidixi.de", true },
  { "kisallatorvos.hu", true },
  { "kisalt.im", true },
  { "kisel.org", true },
  { "kisiselveri.com", true },
  { "kiskeedeesailing.com", true },
  { "kisma.de", true },
  { "kissflow.com", true },
  { "kissgyms.com", true },
  { "kissmycreative.com", true },
  { "kissoft.ro", true },
  { "kitabnamabayi.com", true },
  { "kitacoffee.com", true },
  { "kitbag.com.au", true },
  { "kitchen-profi.by", true },
  { "kitchen-profi.com.ua", true },
  { "kitchen-profi.kz", true },
  { "kitchenpunx.com", false },
  { "kiteadventure.nl", true },
  { "kiteschooledam.nl", true },
  { "kiteschoolijmuiden.nl", true },
  { "kiteschoolkatwijk.nl", true },
  { "kiteschoolnoordwijk.nl", true },
  { "kiteschoolschellinkhout.nl", true },
  { "kiteschoolwijkaanzee.nl", true },
  { "kiteschoolzandvoort.nl", true },
  { "kitsapsolutions.com", true },
  { "kittmedia.com", true },
  { "kittpress.com", true },
  { "kittyhacker101.tk", true },
  { "kivitelezesbiztositas.hu", true },
  { "kiwi-bird.xyz", true },
  { "kiwi.com", true },
  { "kiwi.digital", true },
  { "kiwi.wiki", true },
  { "kiyotatsu.com", true },
  { "kj-prince.com", true },
  { "kjaer.io", true },
  { "kjarni.cc", true },
  { "kjarrval.is", true },
  { "kjchernov.info", true },
  { "kjellner.com", true },
  { "kjelltitulaer.com", true },
  { "kjellvn.net", true },
  { "kjg-ummeln.de", true },
  { "kk-neudorf-duissern.de", false },
  { "kkaefer.com", true },
  { "kki.org", true },
  { "kkovacs.eu", true },
  { "kkr-bridal.net", true },
  { "kkren.me", true },
  { "kks-karlstadt.de", true },
  { "kksg.com", true },
  { "kkyy.me", true },
  { "kkzxak47.com", true },
  { "kl-diaetist.dk", true },
  { "klaasmeijerbodems.nl", true },
  { "klaim.us", true },
  { "klamathrestoration.gov", true },
  { "klanggut.at", true },
  { "klares-licht.de", true },
  { "klarika.com", true },
  { "klarmobil-empfehlen.de", true },
  { "klasfauseweh.de", true },
  { "klausbrinch.dk", false },
  { "klausen.dk", true },
  { "klaver.it", true },
  { "klaw.xyz", true },
  { "klaxon.me", true },
  { "klcreations.co.uk", true },
  { "kle.cz", true },
  { "kleaning.by", true },
  { "klebeband.eu", true },
  { "klebetape.de", true },
  { "kleding.website", true },
  { "kledingrekken.nl", false },
  { "kleim.fr", true },
  { "kleinblogje.nl", false },
  { "kleine-dingen.nl", true },
  { "kleine-strandburg-heringsdorf.de", true },
  { "kleine-strandburg.com", true },
  { "kleine-strolche-lich.de", true },
  { "kleineanfragen.de", true },
  { "kleinestrandburg-heringsdorf.de", true },
  { "kleinestrandburg-usedom.de", true },
  { "kleineviecherei.de", true },
  { "kleinfein.co", true },
  { "kleinreich.de", true },
  { "kleinsys.com", true },
  { "kleintransporte.net", true },
  { "kleppe.co", true },
  { "kleteckova.cz", true },
  { "klicke-gemeinsames.de", true },
  { "klickstdu.com", true },
  { "kliemann.me", true },
  { "klif1.nl", true },
  { "klimaloven.no", true },
  { "klimapartner.de", true },
  { "klimapartner.net", true },
  { "klimchuk.by", true },
  { "klimchuk.com", true },
  { "klingenundmesser.com", true },
  { "klinikac.co.id", false },
  { "klinkenberg.ws", true },
  { "klinkerstreet.com.ua", false },
  { "klm-huisjes.nl", true },
  { "klmhouses.com", true },
  { "klocker-ausserlechner.com", true },
  { "klocksnack.se", true },
  { "kloia.com", true },
  { "klose.family", true },
  { "klosko.net", true },
  { "kloudboy.com", true },
  { "kls-agency.com.ua", false },
  { "klseet.com", true },
  { "klssn.com", true },
  { "klubxanadu.cz", true },
  { "kluck.me", true },
  { "klugemedia.de", true },
  { "klustermedia.com", true },
  { "klusweb-merenwijk.nl", true },
  { "klva.cz", true },
  { "klzwzhi.com", true },
  { "kmashworth.co.uk", true },
  { "kmkz.jp", true },
  { "kmsci.com.ph", true },
  { "kn007.net", true },
  { "knaake.net", true },
  { "knab-networks.com", true },
  { "knapp.noip.me", true },
  { "knapp.servehttp.com", true },
  { "knarcraft.net", true },
  { "kncg.pw", true },
  { "kndkv.com", true },
  { "kndrd.io", true },
  { "kneblinghausen.de", true },
  { "knechtology.com", true },
  { "knep.me", true },
  { "knetterbak.nl", true },
  { "kngk-group.ru", true },
  { "kngk-transavto.ru", true },
  { "kngk.org", true },
  { "kngkng.com", true },
  { "kniga.market", false },
  { "knight-industries.org", true },
  { "knightsblog.de", true },
  { "knightsbridge.net", true },
  { "knightsbridgewine.com", true },
  { "knihovnajablonne.cz", true },
  { "knip.ch", true },
  { "knispel-online.de", true },
  { "knitfarious.com", true },
  { "knmv.nl", true },
  { "knnet.ch", true },
  { "knockendarroch.co.uk", true },
  { "knop.info", true },
  { "knot-store.com", true },
  { "knowarth.com", true },
  { "knowledgeforce.com", true },
  { "knowlevillagecc.co.uk", true },
  { "knthost.com", true },
  { "knurps.de", true },
  { "knuthildebrandt.de", true },
  { "knutur.is", true },
  { "knygos.lt", true },
  { "ko-sys.com", true },
  { "ko.si", true },
  { "koalapress.fr", true },
  { "koalas.org", true },
  { "kobejet.com", true },
  { "kobezda.net", true },
  { "kobofarm.com", true },
  { "kobolya.hu", true },
  { "kocherev.org", true },
  { "kochereva.com", true },
  { "kochhar.net", true },
  { "kochinke.com", true },
  { "kochinke.us", true },
  { "kockanakocko.si", true },
  { "kodak-ism.com", true },
  { "kodden.com.br", true },
  { "kode-it.de", true },
  { "kode.ch", true },
  { "kodify.net", true },
  { "koe.hn", true },
  { "koebbes.de", true },
  { "koecollege.com", true },
  { "koehn.com", true },
  { "koelbli.ch", true },
  { "koelnmafia.de", true },
  { "koenen-bau.de", true },
  { "koenigsbrunner-tafel.de", true },
  { "koenleemans.nl", true },
  { "koenrouwhorst.nl", true },
  { "koenzk.nl", true },
  { "koerperkult.ch", true },
  { "koertner-muth.com", true },
  { "koertner-muth.de", true },
  { "koethen-markt.de", true },
  { "koetjesenkanker.nl", true },
  { "kofler.info", true },
  { "kogak.ninja", true },
  { "kogax.com", true },
  { "kogcoder.com", true },
  { "kogi.fr", true },
  { "kogro.de", true },
  { "kogudesi.com", true },
  { "koha.be", true },
  { "kohlchan.net", true },
  { "kohlistkool.tk", true },
  { "koho.fi", true },
  { "kohoutsautomotive.com", true },
  { "kohsandra.com", true },
  { "kohu.nz", true },
  { "koi-lexikon.de", true },
  { "koi-sama.net", true },
  { "koicenter-thuine.de", true },
  { "koifish.org", true },
  { "koirala.email", true },
  { "koka-shop.de", true },
  { "kokensupport.com", true },
  { "koketteriet.se", true },
  { "kokobaba.com", true },
  { "kokona.ch", true },
  { "kokumoto.com", true },
  { "kolania.de", true },
  { "kolbeinsson.se", true },
  { "kolcsey.eu", true },
  { "koldanews.com", true },
  { "kolin.org", true },
  { "kolizaskrap.bg", true },
  { "kolja-engelmann.de", true },
  { "kolkataflowermall.com", true },
  { "kollect.ie", true },
  { "kollega.it", true },
  { "kolmann.at", true },
  { "kolmann.eu", true },
  { "kolonie-am-stadtpark.de", true },
  { "kolorbon.com", true },
  { "kolpingsfamilie-vechta-maria-frieden.de", true },
  { "koluke.co", true },
  { "koluke.com", true },
  { "komall.net", true },
  { "komandakovalchuk.com", false },
  { "kombidorango.com.br", true },
  { "komelin.com", true },
  { "komenamanda.de", true },
  { "komicloud.com", true },
  { "komidoc.com", true },
  { "komiksbaza.pl", true },
  { "kominfo.go.id", true },
  { "kominfo.net", false },
  { "kominki-sauny.pl", true },
  { "komintek.ru", true },
  { "komischkeszeug.de", true },
  { "kommaer.dk", true },
  { "kommune42.org", true },
  { "komoju.com", true },
  { "komok.co.uk", true },
  { "kompetenzkurs.de", true },
  { "komplet.sk", true },
  { "kon-sil.de", true },
  { "kondi.net", true },
  { "kondou-butsudan.com", true },
  { "kongar.org", true },
  { "koniecfica.sk", true },
  { "konijntjes.nl", true },
  { "koningskwartiertje.nl", true },
  { "koninkrijk.net", true },
  { "konkai.store", true },
  { "konklone.com", true },
  { "konoe.studio", true },
  { "konosuke.jp", true },
  { "konplott.shop", true },
  { "konpyuta.nl", true },
  { "konsertoversikt.no", true },
  { "konst.se", true },
  { "kontaxis.org", true },
  { "kontorhaus-schlachte.de", true },
  { "kontorhaus-stralsund.de", true },
  { "kontrolapovinnosti.cz", true },
  { "konventa.net", true },
  { "konyalian.com", true },
  { "konzertheld.de", true },
  { "koodaklife.com", true },
  { "koodimasin.ee", true },
  { "koodimasin.eu", true },
  { "kooer.org", true },
  { "kooli.ee", true },
  { "koolikatsed.ee", true },
  { "koolitee.ee", true },
  { "kooliveeb.ee", true },
  { "kooponline.eu", true },
  { "koot.nl", true },
  { "koozal.de", true },
  { "kopfkrieg.org", true },
  { "kopfundseele.de", true },
  { "kopjethee.nl", true },
  { "koplancpa.com", true },
  { "koptev.ru", true },
  { "kopteva.ru", true },
  { "korben.info", true },
  { "korea.dating", true },
  { "koreaboo.com", true },
  { "koretech.nl", true },
  { "korinar.com", true },
  { "kornrunner.net", true },
  { "korobi.io", true },
  { "korobkovsky.ru", true },
  { "koroknaimedical.hu", true },
  { "korono.de", true },
  { "korosiprogram.hu", true },
  { "korp.fr", true },
  { "korrelzout.nl", true },
  { "kortgebyr.dk", true },
  { "kortic.com", true },
  { "koryfi.com", true },
  { "kosaki.moe", true },
  { "koscielniak-nieruchomosci.pl", true },
  { "kosho.org", true },
  { "kosonaudioteca.com", true },
  { "kost-magazin.de", true },
  { "kostal.com", false },
  { "kostecki.com", true },
  { "kostecki.org", true },
  { "kostecki.tel", true },
  { "kostya.ws", true },
  { "kosuzu.moe", true },
  { "kother.org", true },
  { "kotilinkki.fi", true },
  { "kotitesti.fi", true },
  { "kotly-marten.com.ua", true },
  { "kotobox.net", true },
  { "kotois.com", true },
  { "kotonoha.cafe", true },
  { "kotori.love", true },
  { "kouki-food.com", true },
  { "koumakan.cc", true },
  { "koumuwin.com", true },
  { "koushinjo.org", true },
  { "kouten-jp.com", true },
  { "kov.space", true },
  { "koval.io", true },
  { "kovaldo.ru", true },
  { "kovals.sk", true },
  { "kovehitus.ee", true },
  { "kovspace.com", true },
  { "kovuthehusky.com", true },
  { "kowalmik.tk", true },
  { "kowalstwo.com.pl", true },
  { "kowarschick.de", true },
  { "kowshiksundararajan.com", true },
  { "koyaanis.com", true },
  { "koyo.kr", true },
  { "kozuch.biz", true },
  { "kpfanworld.com", true },
  { "kpforme.org", true },
  { "kpinvest.eu", true },
  { "kplasticsurgery.com", true },
  { "kplnet.net", true },
  { "kpop.re", true },
  { "kpopsource.com", true },
  { "kpumuk.info", true },
  { "kpx1.de", true },
  { "kr.search.yahoo.com", false },
  { "kr0n.dk", true },
  { "krachtinverbinding.nl", true },
  { "kradalby.no", true },
  { "kraft.blog", true },
  { "kraft.im", true },
  { "kraftfleisch.de", true },
  { "kraftzeiten.de", true },
  { "krag.be", true },
  { "kraga.sk", true },
  { "kraiwon.com", true },
  { "kraken.io", true },
  { "kraken.site", true },
  { "kralik.io", true },
  { "kralovskapradelna.cz", true },
  { "kralovstvimap.cz", true },
  { "kram.nz", true },
  { "krambeutel.de", true },
  { "krampus-fischamend.at", true },
  { "kramsj.uk", true },
  { "krang.org.uk", true },
  { "krankenpflege-haushaltshilfe.de", true },
  { "kranz.space", true },
  { "krasnodar-avia.ru", true },
  { "krasovsky.me", true },
  { "krautomat.com", true },
  { "krayx.com", true },
  { "krazyboi.com", true },
  { "krazykastles.co.uk", true },
  { "krazykoolkastles.com", true },
  { "krazyphotobooths.co.uk", true },
  { "kreationnext.com", true },
  { "kreativelabs.ch", true },
  { "kreativstrecke.de", true },
  { "kredigram.com", true },
  { "kredit-abzocke.com", true },
  { "kredita.dk", true },
  { "kreditkacs.cz", true },
  { "kredytzen.pl", true },
  { "kreen.org", true },
  { "krehl.io", true },
  { "kremalicious.com", true },
  { "kretschmann.consulting", true },
  { "kreuzpfadfinder.de", true },
  { "krey.is", true },
  { "krfuli.com", true },
  { "kriechel.de", true },
  { "krinetzki.de", true },
  { "kringloopwinkelsteenwijk.nl", true },
  { "kriptosec.com", true },
  { "kris.click", true },
  { "krise-chance.ch", true },
  { "krisftp.fr", true },
  { "krishnenduayur.org", true },
  { "krishofer.com", true },
  { "krishouse.fr", true },
  { "krislamoureux.com", true },
  { "krismurray.co.uk", true },
  { "krisstarkey.co.uk", true },
  { "kristenpaigejohnson.com", true },
  { "kristiehill.com", true },
  { "kristikala.nl", true },
  { "kristinbailey.com", false },
  { "kristofba.ch", true },
  { "kristofdv.be", true },
  { "kritikos.io", true },
  { "krizevci.info", true },
  { "krmeni.cz", false },
  { "krokedil.se", true },
  { "kromamoveis.com.br", true },
  { "kromonos.net", true },
  { "krony.de", true },
  { "kroon.email", true },
  { "kropkait.pl", true },
  { "kroy.io", true },
  { "krsn.de", true },
  { "krsvrs.nl", true },
  { "krugermillions.org", true },
  { "kruin.net", true },
  { "kruisselbrink.com", true },
  { "kruk.co", true },
  { "krukhmer.com", true },
  { "krumberconsulting.com", true },
  { "krupa.net.pl", false },
  { "kruselegal.com.au", true },
  { "krutka.cz", true },
  { "kruu.de", true },
  { "kruzhki-s-kartinkami.ru", true },
  { "kry.no", true },
  { "kry.se", true },
  { "kryglik.com", true },
  { "krypmonet.com", true },
  { "krypsys.com", true },
  { "krypt.com", true },
  { "kryptera.se", true },
  { "krytykawszystkiego.com", true },
  { "krytykawszystkiego.pl", true },
  { "kryx.de", true },
  { "ks-watch.de", true },
  { "kschv-rdeck.de", true },
  { "kselenia.ee", true },
  { "ksero.center", true },
  { "ksero.wroclaw.pl", true },
  { "ksham.net", true },
  { "kshlm.in", true },
  { "kspg.tv", true },
  { "kssk.de", true },
  { "ksukelife.com", true },
  { "kt-zoe.com", true },
  { "ktbnetbank.com", true },
  { "kthnxbai.xyz", true },
  { "kts-thueringen.de", true },
  { "ktsee.eu.org", true },
  { "ktsofas.gr", true },
  { "ktw.lv", true },
  { "ku-7.club", true },
  { "ku.io", false },
  { "kuaimen.bid", true },
  { "kuaitiyu.org", true },
  { "kualiti.net", true },
  { "kualo.co.uk", true },
  { "kualo.com", true },
  { "kualo.in", true },
  { "kuaza.com", true },
  { "kub.hr", true },
  { "kubica.ch", true },
  { "kubierecki.pl", true },
  { "kubik-rubik.de", false },
  { "kubkprf.ru", true },
  { "kublis.ch", true },
  { "kuchen-am-stiel.de", true },
  { "kuchenfeelisa.de", true },
  { "kuchentraum.eu", true },
  { "kucnibudzet.com", true },
  { "kucukayvaz.com", true },
  { "kudo.co.id", true },
  { "kuechenprofi-group.de", false },
  { "kuehndel.org", true },
  { "kuehnel-bs.de", true },
  { "kuehnel-online.eu", true },
  { "kuehnel.org", false },
  { "kuemmerlin.eu", true },
  { "kuemmling.eu", true },
  { "kugelblitz.co", true },
  { "kuhn-elektrotechnik.de", true },
  { "kuhne-electronic.de", true },
  { "kuhnelautorepair.com", true },
  { "kujadin.de", true },
  { "kukal.cz", true },
  { "kuketz-blog.de", true },
  { "kuketz-security.de", true },
  { "kulde.net", true },
  { "kulickovy-pojezd.cz", true },
  { "kulivps.com", true },
  { "kuma.es", true },
  { "kumachan.biz", true },
  { "kumalog.com", true },
  { "kumasanda.jp", true },
  { "kumilasvegas.com", true },
  { "kungerkueken.de", true },
  { "kunra.de", true },
  { "kunstdrucke-textildruck.de", true },
  { "kunstundunrat.de", true },
  { "kuoruan.com", true },
  { "kupferstichshop.com", true },
  { "kupid.com", true },
  { "kupiec.eu.org", true },
  { "kupimlot.ru", true },
  { "kupinska.pl", true },
  { "kuponrazzi.com", true },
  { "kuponydoher.cz", true },
  { "kupschke.net", true },
  { "kurashino-mall.com", true },
  { "kuro.link", true },
  { "kurofuku.me", true },
  { "kuroha.co.uk", true },
  { "kuroinu.jp", true },
  { "kurona.ga", true },
  { "kuronekogaro.com", true },
  { "kurschies.de", true },
  { "kurserne.dk", true },
  { "kurswahl-online.de", true },
  { "kurtschlatzer.com", true },
  { "kuruppa.xyz", true },
  { "kuschku.de", true },
  { "kusdaryanto.web.id", true },
  { "kushtikidsparties.co.uk", true },
  { "kusochi.eu", true },
  { "kutinsoft.com", true },
  { "kutny.cz", true },
  { "kutsankaplan.com", true },
  { "kuttler.eu", true },
  { "kutukupret.com", true },
  { "kutus.ee", true },
  { "kuzbass-pwl.ru", true },
  { "kvadratnimeter.si", true },
  { "kvalita-1a.cz", true },
  { "kvalitetsaktiepodden.se", true },
  { "kvalitnitesneni.cz", true },
  { "kvantel.no", true },
  { "kvcc.com.au", true },
  { "kvetinymilt.cz", true },
  { "kvhile.com", true },
  { "kvilt.dk", true },
  { "kvn.tf", true },
  { "kvnsport.ru", true },
  { "kvpc.com.au", true },
  { "kwat.chat", true },
  { "kwbresidential.com", true },
  { "kwcolville.com", true },
  { "kwedo.com", true },
  { "kwench.com", true },
  { "kwoll.de", true },
  { "kwyxz.org", true },
  { "kx197.com", true },
  { "kxah35.com", true },
  { "kxline.com", true },
  { "kxnrl.com", false },
  { "kxway.com", true },
  { "kybi.sk", true },
  { "kydara.com", true },
  { "kyledrake.net", true },
  { "kylegutschow.com", true },
  { "kylejohnson.io", true },
  { "kylelaker.com", true },
  { "kylinj.com", false },
  { "kynastonwedding.co.uk", true },
  { "kyobostory-events.com", true },
  { "kyoko.org", true },
  { "kyosaku.org", true },
  { "kyoto-mic.com", true },
  { "kyoto-tomikawa.jp", true },
  { "kyoto-tomoshibi.jp", true },
  { "kyprexxo.com", true },
  { "kyras-castles.co.uk", true },
  { "kyunyuki.com", true },
  { "kyusyu.org", true },
  { "kyy.me", true },
  { "kz.search.yahoo.com", false },
  { "kzar.co.uk", true },
  { "kzsdabas.hu", true },
  { "l-lab.org", true },
  { "l0re.com", true },
  { "l17r.eu", true },
  { "l2guru.ru", true },
  { "l33te.net", true },
  { "l4n-clan.de", true },
  { "l7plumbing.com.au", true },
  { "l7world.com", true },
  { "l9.fr", false },
  { "la-baldosa.fr", true },
  { "la-cave-a-nodo.fr", true },
  { "la-compagnie-des-elfes.fr", true },
  { "la-fenice-neheim.de", true },
  { "la-ganiere.com", true },
  { "la-kaz-a-velo.fr", true },
  { "la-maison.ch", true },
  { "la-maison.eu", true },
  { "la-petite-entreprise.com", true },
  { "la-tourmaline.ch", true },
  { "laac.io", true },
  { "laassari.me", false },
  { "laatikko.io", true },
  { "laatjeniethackmaken.nl", true },
  { "labande-annonce.fr", true },
  { "labanochjonas.se", true },
  { "labanskoller.se", true },
  { "labanskollermark.se", true },
  { "labcenter.com", true },
  { "labcoat.jp", true },
  { "labms.com.au", true },
  { "labobooks.com", true },
  { "laboitebio-logique.ca", true },
  { "labortogether.com", true },
  { "labouncycastlehire.co.uk", true },
  { "labourreedevergheas.fr", true },
  { "laboutiquedejuliette.com", true },
  { "laboxfaitsoncinema.com", true },
  { "labradorpuppiesforsalebyregisteredlabradorbreeders.com", false },
  { "labrat.mobi", false },
  { "labspack.com", true },
  { "labtest.ltd", true },
  { "lacantine.xyz", true },
  { "lacaserita.org", true },
  { "lacaveducinquantenaire.com", true },
  { "lacetsfun.com", true },
  { "lacetsroses.ch", true },
  { "lachainedesentrepreneurs.fr", true },
  { "lachawoj.de", true },
  { "lachlan-harris.com", true },
  { "lachlan.com", true },
  { "lachosetypo.com", true },
  { "lachyoga-schwieberdingen.de", true },
  { "lacicloud.net", true },
  { "lacigf.org", true },
  { "laclaque.ch", true },
  { "lacledelareussite.com", true },
  { "lacledeslan.com", false },
  { "lacledor.ch", true },
  { "laclefdor.ch", true },
  { "lacliniquefinanciere.com", true },
  { "lacoast.gov", true },
  { "lacocinadelila.com", true },
  { "lacoquette.gr", true },
  { "lacyc3.eu", true },
  { "ladbroke.net", true },
  { "ladenzeile.at", true },
  { "ladenzeile.de", true },
  { "ladislavbrezovnik.com", true },
  { "ladraiglaan.com", true },
  { "lady-2.jp", true },
  { "ladyanna.de", true },
  { "ladyofhopeparish.org", true },
  { "laermschmiede.de", true },
  { "laeso.es", true },
  { "laextra.mx", true },
  { "lafayette-rushford.com", true },
  { "lafcheta.info", true },
  { "lafillepolyvalente.ca", true },
  { "lafillepolyvalente.com", true },
  { "lafka.org", true },
  { "lafkor.de", true },
  { "laflash.com", true },
  { "lagarderob.ru", false },
  { "lagazzettadigitale.it", true },
  { "lagerauftrag.info", true },
  { "lagit.in", true },
  { "laglab.org", false },
  { "lagout.org", true },
  { "lagriffeduservice.fr", true },
  { "laguiadelvaron.com", true },
  { "laguinguette.fr", true },
  { "lagunacoastrealestate.com", true },
  { "lahipotesisgaia.com", true },
  { "lahnau-akustik.de", true },
  { "lahora.com.ec", true },
  { "lai.is", true },
  { "laibcoms.com", true },
  { "lain.at", true },
  { "lain.li", true },
  { "laindonleisure.co.uk", true },
  { "lak-berlin.de", true },
  { "lakarwebb.se", true },
  { "lakedavid.com.au", true },
  { "lakehavasucityhomebuyerscredit.com", true },
  { "lakehavasucitynews.com", true },
  { "lakehavasuhomebuyercredit.com", true },
  { "lakehavasuhomes.info", true },
  { "lakehavasuhouses.com", true },
  { "lakehavasuwebsites.com", true },
  { "lakelandbank.com", true },
  { "lakeoswegotowncar.com", true },
  { "lakesherwoodelectric.com", true },
  { "lakesherwoodelectrical.com", true },
  { "lakesherwoodelectrician.com", true },
  { "lakesherwoodexteriorlighting.com", true },
  { "lakesherwoodlandscapelighting.com", true },
  { "lakesherwoodlighting.com", true },
  { "lakesherwoodoutdoorlighting.com", true },
  { "lakeshowlife.com", true },
  { "lakewoodcityglass.com", true },
  { "lakhesis.net", true },
  { "lakonia.com.br", true },
  { "lalalab.com", true },
  { "lalaya.fr", true },
  { "laled.ch", true },
  { "lalucioledigitale.com", true },
  { "lalunecreative.com", true },
  { "lalyre-corcelles.ch", true },
  { "lamaisondelatransformationculturelle.com", true },
  { "lamakat.de", true },
  { "lamanwebinfo.com", true },
  { "lamapoll.de", true },
  { "lamarieealhonneur.com", false },
  { "lambauer.com", true },
  { "lambertshealthcare.co.uk", true },
  { "lamboo.be", true },
  { "lamclam.site", true },
  { "lame1337.xyz", true },
  { "lamed.se", true },
  { "lamikvah.org", true },
  { "laminine.info", true },
  { "lamontre.ru", true },
  { "lamp.re", false },
  { "lamp24.se", true },
  { "lampade.it", true },
  { "lampara.es", true },
  { "lampegiganten.dk", true },
  { "lampegiganten.no", true },
  { "lampen24.be", true },
  { "lampen24.nl", true },
  { "lampenwelt.at", true },
  { "lampenwelt.ch", true },
  { "lampenwelt.de", true },
  { "lampposthomeschool.com", true },
  { "lampy.pl", true },
  { "lamunyon.com", true },
  { "lan.biz.tr", true },
  { "lanahallen.com", true },
  { "lanbroa.eu", true },
  { "lancashirecca.org.uk", true },
  { "lancejames.com", true },
  { "lancelafontaine.com", true },
  { "lanceyip.com", true },
  { "lancyvbc.ch", true },
  { "land.nrw", false },
  { "landbetweenthelakes.us", true },
  { "landchecker.com.au", true },
  { "landflair-magazin.de", true },
  { "landhaus-christmann.de", true },
  { "landhaus-havelse.de", true },
  { "landinfo.no", true },
  { "landingear.com", true },
  { "landlordy.com", true },
  { "landofelves.net", true },
  { "landrovermerriamparts.com", true },
  { "landscape-photography.org", true },
  { "landscapelightingagoura.com", true },
  { "landscapelightingagourahills.com", true },
  { "landscapelightingcalabasas.com", true },
  { "landscapelightingcamarillo.com", true },
  { "landscapelightingconejovalley.com", true },
  { "landscapelightingdosvientos.com", true },
  { "landscapelightinghiddenhills.com", true },
  { "landscapelightinglakesherwood.com", true },
  { "landscapelightingmalibu.com", true },
  { "landscapelightingmoorpark.com", true },
  { "landscapelightingnewburypark.com", true },
  { "landscapelightingoakpark.com", true },
  { "landscapelightingpacificpalisades.com", true },
  { "landscapelightingsimivalley.com", true },
  { "landscapelightingthousandoaks.com", true },
  { "landscapelightingwestlakevillage.com", true },
  { "landscapephotography.org.au", true },
  { "landyparts.nl", true },
  { "lanetix.com", true },
  { "lanforalla.se", true },
  { "lang-php.com", true },
  { "langatang.com", true },
  { "langbein.org", true },
  { "langguth.io", true },
  { "langkahteduh.com", true },
  { "langkawitrip.com", true },
  { "langotie.com.br", true },
  { "langsam-dator.se", true },
  { "langstreckensaufen.de", true },
  { "languagecourse.net", true },
  { "languageterminal.com", true },
  { "langworth.com", true },
  { "langzijn.nl", true },
  { "lanhhuyet510.tk", true },
  { "lanna.io", true },
  { "lannainnovation.com", true },
  { "lanodan.eu", true },
  { "lanostrasalute.it", true },
  { "lanre.org", true },
  { "lanroamer.de", true },
  { "lansechensilu.com", true },
  { "lanternalauth.com", true },
  { "lanternhealth.org", true },
  { "lantian.pub", true },
  { "lanturtle.com", true },
  { "lanuovariviera.it", true },
  { "lanyang.tk", true },
  { "lanzamientovirtual.es", true },
  { "lanzarote-online.info", true },
  { "laos.dating", true },
  { "laozhu.me", true },
  { "laparoscopia.com.mx", true },
  { "lapassiondutrading.com", true },
  { "lapetition.be", true },
  { "lapicena.eu", true },
  { "lapidge.net", true },
  { "laplacesicherheit.de", true },
  { "laplanetebleue.com", true },
  { "lapolla.com", true },
  { "lapotagere.ch", true },
  { "lapparente-aise.ch", true },
  { "lappari.com", true },
  { "lara.photography", true },
  { "larabergmann.de", true },
  { "laracode.eu", true },
  { "laraeph.com", true },
  { "laraigneedusoir.com", true },
  { "laranara.se", true },
  { "laranjada.org", true },
  { "laraveldirectory.com", true },
  { "laravelsaas.com", true },
  { "larbertbaptist.org", true },
  { "lareclame.fr", true },
  { "larepublicacultural.es", true },
  { "largescaleforums.com", true },
  { "largeviewer.com", true },
  { "lariposte.org", true },
  { "lariscus.eu", true },
  { "larky.top", true },
  { "larondinedisinfestazione.com", true },
  { "larptreff.de", true },
  { "larraz.es", true },
  { "larryli.cn", true },
  { "larrysalibra.com", true },
  { "lars-ewald.com", true },
  { "lars-mense.de", true },
  { "lars.cloud", true },
  { "lars.moi", true },
  { "larsbauer.xyz", true },
  { "larsklene.nl", true },
  { "larsklint.com", true },
  { "laruga.co.uk", true },
  { "larvatoken.org", true },
  { "lasalle.wa.edu.au", true },
  { "lasarmas.com", true },
  { "lasavonnerieducroisic.fr", true },
  { "lascana.co.uk", true },
  { "lasereyess.net", true },
  { "laserfuchs.de", true },
  { "laserpc.net", true },
  { "laserplaza.de", true },
  { "laserplaza.net", true },
  { "lasertechsolutions.com", true },
  { "lask.in", true },
  { "laskas.pl", true },
  { "lasowy.com", true },
  { "laspequenassemillas.com", true },
  { "lasrecetascocina.com", true },
  { "lasrecetasdeguada.com", true },
  { "lasse-it.dk", true },
  { "lasseleegaard.com", true },
  { "lasseleegaard.dk", true },
  { "lasseleegaard.net", true },
  { "lasseleegaard.org", true },
  { "lassesworld.com", true },
  { "lassesworld.se", true },
  { "lastbutnotyeast.com", true },
  { "lastchancetraveler.com", true },
  { "lastharo.com", true },
  { "lastpass.com", false },
  { "lastrada-minden.de", true },
  { "lastweekinaws.com", true },
  { "lasuzefc.fr", true },
  { "lat.sk", true },
  { "latabledemontebello.com", true },
  { "late.am", true },
  { "latecnosfera.com", true },
  { "latedeals.co.uk", true },
  { "latemodern.com", true },
  { "latenitefilms.com", false },
  { "lateral.dog", true },
  { "lateralsecurity.com", true },
  { "latestbuy.com.au", true },
  { "latestdeals.co.uk", true },
  { "latiendadelbebefeliz.com", true },
  { "latiendauno.com", true },
  { "latiendawapa.com", true },
  { "latino.dating", true },
  { "latinphone.com", true },
  { "latintoy.com", true },
  { "latitudesign.com", true },
  { "latremebunda.com", true },
  { "latrine.cz", true },
  { "lattyware.co.uk", true },
  { "lattyware.com", true },
  { "laubacher.io", true },
  { "lauchundei.at", true },
  { "lauensteiner.de", false },
  { "laufers.pl", true },
  { "laufpix.de", true },
  { "lauftreff-himmelgeist.de", true },
  { "laughinggrapepublishing.com", true },
  { "laukstein.com", true },
  { "launayflorian.net", true },
  { "launchkey.com", false },
  { "launchmylifend.com", true },
  { "launchpad-app2.com", true },
  { "launchpadder2.com", true },
  { "lauraandwill.wedding", false },
  { "lauraenvoyage.fr", true },
  { "laurakashiwase.com", true },
  { "lauraofrank.com", true },
  { "laurasplacefamilysupport.org.au", true },
  { "laurelblack.com", true },
  { "laurenceplouffe.com", true },
  { "laurenlobue.com", true },
  { "lauriemilne.com", true },
  { "lauriuc.sk", true },
  { "lausannedentiste.ch", true },
  { "lausannelovers.ch", true },
  { "laussat.de", true },
  { "laut.digital", true },
  { "lauxzahnheilkunde.de", true },
  { "lauzon-hitter.com", true },
  { "lavabit.no", true },
  { "lavalite.de", true },
  { "lavamob.com", true },
  { "lavanderia.roma.it", true },
  { "lavasing.eu.org", true },
  { "lavaux.lv", true },
  { "lavenderx.org", true },
  { "laviedalex.ovh", true },
  { "lavinya.net", true },
  { "lavishlooksstudio.com.au", true },
  { "lavita.de", true },
  { "lavitaura.com", true },
  { "lavitrine-une-collection.be", true },
  { "lavoieducoeur.be", true },
  { "lavoiepharmd.com", true },
  { "lavolte.net", true },
  { "law-colleges.com", true },
  { "law-peters.de", true },
  { "law.co.il", true },
  { "law22.com", true },
  { "lawbirduk.com", true },
  { "lawformt.com", true },
  { "lawn-seeds.com", true },
  { "lawnuk.com", true },
  { "lawrenceberg.nl", true },
  { "lawrencemurgatroyd.com", true },
  { "lawrencewhiteside.com", true },
  { "lawyerdigital.co.bw", true },
  { "lawyerkf.com", true },
  { "laylo.io", false },
  { "laylo.nl", false },
  { "layoutsatzunddruck.de", true },
  { "lazistance.com", true },
  { "lazowik.pl", true },
  { "lazyboston.com", true },
  { "lazyclock.com", true },
  { "lazyframe.com", true },
  { "lazyhelp.com", true },
  { "lazytux.org", true },
  { "lb-toner.de", true },
  { "lbayer.com", true },
  { "lbc.gr", true },
  { "lbgconsultores.com", true },
  { "lbihrhelpdesk.com", true },
  { "lbls.me", true },
  { "lbmblaasmuziek.nl", true },
  { "lbphacker.pw", true },
  { "lbs-logics.com", true },
  { "lbsi-nordwest.de", true },
  { "lbux.org", true },
  { "lc-cs.com", false },
  { "lc-promiss.de", true },
  { "lca-pv.de", true },
  { "lca.gov", true },
  { "lcacommons.gov", true },
  { "lcars-sv.info", true },
  { "lcbizsolutions.com", true },
  { "lce-events.com", true },
  { "lcgaj.com", true },
  { "lcht.ch", false },
  { "lcrmscp.gov", true },
  { "lcy.cat", true },
  { "lcy.im", true },
  { "lcy.moe", true },
  { "lcybox.com", true },
  { "ld-begunjscica.si", true },
  { "ldc.com.br", false },
  { "ldjb.jp", true },
  { "ldsun.com", true },
  { "le-bar.org", true },
  { "le-blog.ch", true },
  { "le-controle-parental.fr", true },
  { "le-creux-du-van.ch", true },
  { "le-dev.de", false },
  { "le-drive-de-just-vet.fr", true },
  { "le-h.de", true },
  { "le-hosting.de", true },
  { "le-page.info", true },
  { "le-palantir.com", true },
  { "le-traiteur-parisien.fr", true },
  { "le0.me", true },
  { "le0yn.ml", true },
  { "le130rb.com", true },
  { "le23.fr", true },
  { "le42mars.fr", true },
  { "leadbox.cz", true },
  { "leaderoftheresistance.com", false },
  { "leaderoftheresistance.net", false },
  { "leadership9.com", true },
  { "leadgenie.me", true },
  { "leadinfo.com", true },
  { "leadingsalons.com", true },
  { "leadplan.ru", true },
  { "leadquest.nl", true },
  { "leafandseed.co.uk", true },
  { "leafans.tk", false },
  { "leafinote.com", true },
  { "leakforums.net", true },
  { "leamsigc.com", true },
  { "leandre.cn", true },
  { "leankit.com", true },
  { "leanplando.com", true },
  { "leap-it.be", true },
  { "leapandjump.co.uk", true },
  { "learn-smart.uk", true },
  { "learndev.info", true },
  { "learnflakes.net", true },
  { "learnforestry.com", true },
  { "learning-id.com", true },
  { "learningis1.st", true },
  { "learninglaw.com", true },
  { "learningman.top", true },
  { "learnlux.com", true },
  { "learnpianogreece.com", true },
  { "learnplayground.com", true },
  { "learntube.cz", true },
  { "leaseit24.com", true },
  { "leaseit24.de", true },
  { "leaseplan.com", true },
  { "leasit.at", true },
  { "leasit.de", true },
  { "leastsignificantbit.de", true },
  { "leatam.fr", true },
  { "leatherfurnitureexpo.com", true },
  { "leatherwood.nl", true },
  { "leavesofchangeweekly.org", true },
  { "lebanesearmy.gov.lb", true },
  { "lebarbatruc.com", true },
  { "lebarmy.gov.lb", true },
  { "lebendige-heilkunst.de", true },
  { "lebens-fluss.at", true },
  { "lebensraum-fitness-toenisvorst.de", true },
  { "lebensraum-im-garten.de", true },
  { "lebensraum-kurse.ch", true },
  { "lebihan.pl", true },
  { "leblanc.io", true },
  { "lebourgeo.is", true },
  { "lechaudrondupertuis.ch", true },
  { "leclaire.com.br", true },
  { "lecoinchocolat.com", true },
  { "lectricecorrectrice.com", true },
  { "led-jihlava.cz", true },
  { "ledecologie.com.br", true },
  { "ledeguisement.com", true },
  { "lederer-it.com", true },
  { "ledlight.com", true },
  { "ledscontato.com.br", true },
  { "ledzom.ru", false },
  { "lee-fuller.co.uk", true },
  { "leeaaronsrealestate.com", true },
  { "leebiblestudycentre.co.uk", true },
  { "leeclemens.net", false },
  { "leedev.org", true },
  { "leekspin.ml", true },
  { "leelaylay.com", true },
  { "leere.me", true },
  { "leerliga.de", true },
  { "leertipp.de", true },
  { "leesilvey.com", true },
  { "leetcode.com", true },
  { "leetcode.net", true },
  { "leetgamers.asia", true },
  { "leevealdc.com", true },
  { "lefcoaching.nl", true },
  { "lefebvristes.com", true },
  { "lefebvristes.fr", true },
  { "leflibustier.ru", true },
  { "lefonddeloeil.com", true },
  { "leftclick.cloud", true },
  { "leftclick.eu", true },
  { "lega-dental.com", true },
  { "legacy.bank", true },
  { "legadental.com", true },
  { "legaillart.fr", true },
  { "legalcontrol.info", true },
  { "legaldesk.com", true },
  { "legalinmotion.es", true },
  { "legalrobot.com", true },
  { "legendesdechine.ch", true },
  { "legendofkrystal.com", true },
  { "legends-game.ru", false },
  { "legible.es", true },
  { "legilimens.de", true },
  { "legioniv.org", true },
  { "legiscontabilidade.com.br", true },
  { "legissa.ovh", true },
  { "legit.nz", true },
  { "legjobblogo.hu", true },
  { "legland.fr", true },
  { "legoutdesplantes.be", true },
  { "legrandvtc.fr", true },
  { "legumeinfo.org", true },
  { "lehighmathcircle.org", true },
  { "lehti-tarjous.net", true },
  { "leibniz-remscheid.de", false },
  { "leideninternationalreview.com", true },
  { "leilautourdumon.de", true },
  { "leilonorte.com", true },
  { "leinfelder.in", true },
  { "leipzig.photo", true },
  { "leipziger-triathlon.de", true },
  { "leisure-blog.com", true },
  { "leisure-supplies-show.co.uk", true },
  { "leiyun.me", true },
  { "lejardindesmesanges.fr", true },
  { "lektier.cf", true },
  { "lel.ovh", true },
  { "lelambiental.com.br", true },
  { "lemarcheelagrandeguerra.it", true },
  { "lemazol.fr", true },
  { "lemni.top", true },
  { "lemoine.at", true },
  { "lemondenumerique.com", true },
  { "lemonlawnow.com", true },
  { "lemonop.com", true },
  { "lemonparty.co", true },
  { "lemonrockbiketours.com", true },
  { "lemonthy.ca", true },
  { "lemonthy.com", true },
  { "lemouillour.fr", true },
  { "lemuslimpost.com", true },
  { "lenagroben.de", true },
  { "lenaneva.ru", true },
  { "lence.net", true },
  { "lendahandmissionteams.org", true },
  { "lendingclub.com", true },
  { "lenget.com", true },
  { "lengzzz.com", true },
  { "lenidh.de", true },
  { "leninalbertop.com.ve", true },
  { "lennyobez.be", true },
  { "lenou.nl", true },
  { "lenr-forum.com", true },
  { "lensdoctor.com", true },
  { "lenspirations.com", true },
  { "lensual.space", true },
  { "lenuagebauche.org", true },
  { "lenyip.com", true },
  { "lenyip.me", true },
  { "lenyip.works", true },
  { "leoandpeto.com", true },
  { "leodraxler.at", true },
  { "leola.cz", true },
  { "leola.sk", true },
  { "leolana.com", true },
  { "leominstercu.com", false },
  { "leon-tech.com", true },
  { "leon.net", true },
  { "leonauto.de", true },
  { "leonax.net", true },
  { "leonbuitendam.nl", true },
  { "leondenard.com", true },
  { "leonklingele.de", true },
  { "leontiekoetter.de", true },
  { "leopoldina.net", true },
  { "leovanna.co.uk", true },
  { "leowkahman.com", true },
  { "lep.gov", true },
  { "lepenetapeti.com", true },
  { "lepidum.jp", true },
  { "leponton-lorient.fr", true },
  { "leppis-it.de", true },
  { "lepsos.com", true },
  { "lequerceagriturismo.com", true },
  { "lereporter.ma", true },
  { "leretour.ch", true },
  { "lerku.com", true },
  { "lernenamsee.ch", true },
  { "lernerspersonalinjury.ca", true },
  { "lernorteuropa.com", true },
  { "lernorteuropa.de", true },
  { "lernorteuropa.eu", true },
  { "lernplattform-akademie.de", true },
  { "lerp.me", true },
  { "les-ateliers-de-melineo.be", true },
  { "les-inoxydables.com", true },
  { "les-pingouins.com", true },
  { "lesaffre.es", true },
  { "lesancheslibres.fr", true },
  { "lesarts.com", true },
  { "lesberger.ch", true },
  { "lesbrillantsdaristide.com", true },
  { "lescourtiersbordelais.com", true },
  { "leseditionsbraquage.com", true },
  { "lesfilmsavivre.com", true },
  { "lesgoodnews.fr", true },
  { "leshervelines.com", true },
  { "lesjardinsdemathieu.net", true },
  { "lesmamy.ch", true },
  { "lesmontagne.net", true },
  { "lesnet.co.uk", true },
  { "lespagesweb.ch", true },
  { "lespecialiste-pradelexcellence.com", true },
  { "lesplatanes.ch", true },
  { "lespret.nl", true },
  { "lesscloud.com", true },
  { "lessets-graphiques.com", true },
  { "lessis.moe", true },
  { "lesterchan.net", true },
  { "lesterrassesdusoleil.ch", true },
  { "lesyndicat.info", true },
  { "letemps.ch", true },
  { "leto12.xyz", true },
  { "letraba.com", true },
  { "letranif.net", true },
  { "lets-bounce.com", true },
  { "lets-go-acoustic.de", true },
  { "lets-ktai.jp", true },
  { "lets.ninja", true },
  { "lets.nu", true },
  { "letsbounceuk.com", true },
  { "letsdebug.net", true },
  { "letsencrypt-for-cpanel.com", true },
  { "letsgame.nl", true },
  { "letsgetchecked.com", true },
  { "letsgowhilewereyoung.com", true },
  { "letskick.ru", true },
  { "letspartyrugby.co.uk", true },
  { "letssackcancer.org", true },
  { "letstalkcounseling.com", true },
  { "letterbox-online.de", true },
  { "letterdance.de", true },
  { "letteringinstitute.com", true },
  { "lettersblogatory.com", true },
  { "lettori.club", true },
  { "letzchange.org", true },
  { "leuenhagen.com", true },
  { "leulu.com", true },
  { "leumi-how-to.co.il", true },
  { "leuthardtfamily.com", true },
  { "levans.fr", true },
  { "levanscatering.com", true },
  { "levelaccordingly.com", true },
  { "levelcheat.com", true },
  { "levelonetrainingandfitness.com", true },
  { "leveluplv.com", true },
  { "leveluprails.com", true },
  { "levendwater.org", true },
  { "levensbron.nl", true },
  { "leverj.io", true },
  { "levermann.eu", true },
  { "leviaan.nl", true },
  { "levineteamestates.com", true },
  { "levinus.de", true },
  { "leviscop.com", true },
  { "leviscop.de", true },
  { "lew.im", true },
  { "lewdawson.com", true },
  { "lewis.li", true },
  { "lewiscollard.com", true },
  { "lewisdatasecurity.com", true },
  { "lewislaw.com", true },
  { "lewisllewellyn.me", true },
  { "lexdigital.pl", true },
  { "lexico.pt", true },
  { "lexicography.online", true },
  { "lexpierce.social", true },
  { "lexway.pk", true },
  { "lexxyn.nl", true },
  { "leymaritima.com", true },
  { "lezard-com.fr", true },
  { "lfashion.eu", true },
  { "lfgss.com", true },
  { "lfklzw.com", true },
  { "lfrconseil.com", true },
  { "lfullerdesign.com", true },
  { "lg-waps.go.jp", true },
  { "lg-waps.jp", true },
  { "lg0.site", true },
  { "lgbt-colleges.com", true },
  { "lgbt.io", true },
  { "lgbt.ventures", true },
  { "lghfinancialstrategy.ch", true },
  { "lgpecasoriginais.com.br", true },
  { "lhajn.cz", true },
  { "lhakustik.se", true },
  { "lhalbert.xyz", true },
  { "lhamaths.online", true },
  { "lhconsult.tk", false },
  { "lhgavarain.com", true },
  { "lhost.su", true },
  { "li-ke.co.jp", true },
  { "li.search.yahoo.com", false },
  { "lialion.de", true },
  { "liam-w.io", true },
  { "liamelliott.me", true },
  { "liamlin.me", true },
  { "lianye1.cc", true },
  { "lianye2.cc", true },
  { "lianye3.cc", true },
  { "lianye4.cc", true },
  { "lianye5.cc", true },
  { "lianye6.cc", true },
  { "lib64.net", true },
  { "libbitcoin.org", true },
  { "libble.eu", true },
  { "liberapay.com", true },
  { "liberdademg.com.br", true },
  { "libgame.com", true },
  { "libmpq.org", true },
  { "libnull.com", true },
  { "libra.com", true },
  { "library-quest.com", true },
  { "libraryextension.com", true },
  { "libraryfreedomproject.org", false },
  { "librarytools.com", false },
  { "librazy.org", true },
  { "libre-service.de", true },
  { "libre.cr", true },
  { "libre.university", true },
  { "libreboot.org", true },
  { "librebox.de", true },
  { "libreduca.com", true },
  { "librelamp.com", true },
  { "libremail.nl", true },
  { "libreoffice-from-collabora.com", true },
  { "libreofficefromcollabora.com", true },
  { "librervac.org", true },
  { "librosdescargas.club", true },
  { "libscode.com", false },
  { "libskia.so", true },
  { "libsodium.org", true },
  { "libstock.si", true },
  { "libzik.com", true },
  { "lichess.org", true },
  { "lichtmetzger.de", true },
  { "lichtspot.de", true },
  { "lichttechnik-tumler.com", true },
  { "lichttraeumer.de", true },
  { "lickthesalt.com", true },
  { "lidavidm.me", true },
  { "lidel.org", true },
  { "liderwalut.pl", false },
  { "lidl-gewinnspiel.de", true },
  { "lidl-holidays.com", true },
  { "lidl-menubox.ch", true },
  { "lidl-shop.be", true },
  { "lidl-shop.cz", true },
  { "lidl-shop.nl", true },
  { "lidl-tour.ro", true },
  { "lidlovajogurteka.si", true },
  { "lidogr.com", true },
  { "lidong.me", true },
  { "lidow.eu", true },
  { "lidtkemotors.com", true },
  { "liduan.net", false },
  { "lie.as", true },
  { "liebel.org", true },
  { "lieberwirth.biz", true },
  { "liemen.net", true },
  { "lierrmm.space", true },
  { "lieuu.com", true },
  { "lifanov.com", true },
  { "life-emotions.pt", true },
  { "lifeartstudios.net", true },
  { "lifebetweenlives.com.au", true },
  { "lifeboxhealthcare.co.uk", true },
  { "lifecism.com", true },
  { "lifeenrichmentnc.com", true },
  { "lifegrip.com.au", true },
  { "lifeinhex.com", true },
  { "lifeinsurancepro.org", true },
  { "lifelenz.com", true },
  { "lifematenutrition.com", true },
  { "lifemstyle.com", true },
  { "lifeqa.net", true },
  { "lifequotes-uk.co.uk", true },
  { "lifereset.it", true },
  { "lifesafety.com.br", true },
  { "lifestyle7788.com", true },
  { "lifestylecent.com", true },
  { "lifestylefinancial.ca", true },
  { "lifetree.network", true },
  { "lifi.digital", true },
  { "lifi.is", true },
  { "liftie.info", true },
  { "ligadosgames.com", true },
  { "light-up.xyz", true },
  { "light.mail.ru", true },
  { "lightbox.co", true },
  { "lightdark.xyz", true },
  { "lightdream.tech", true },
  { "lighting-centres.co.uk", true },
  { "lightingagoura.com", true },
  { "lightingagourahills.com", true },
  { "lightingcalabasas.com", true },
  { "lightingconejovalley.com", true },
  { "lightingdosvientos.com", true },
  { "lightinghiddenhills.com", true },
  { "lightinglakesherwood.com", true },
  { "lightingmalibu.com", true },
  { "lightingmoorpark.com", true },
  { "lightingnewburypark.com", true },
  { "lightingoakpark.com", true },
  { "lightingpacificpalisades.com", true },
  { "lightingsimivalley.com", true },
  { "lightingthousandoaks.com", true },
  { "lightingwestlakevillage.com", true },
  { "lightme.us", true },
  { "lightning.community", true },
  { "lightning.engineering", true },
  { "lightpics.net", true },
  { "lights.co.uk", true },
  { "lights.ie", true },
  { "lightscale.com", true },
  { "lightsheep.no", true },
  { "lightspeed.com", false },
  { "lightspeedta.co", true },
  { "lightupcollective.co.uk", true },
  { "lignite.com", true },
  { "lignoma.com", true },
  { "ligonier.com", true },
  { "lihaul.dnsalias.net", true },
  { "lijncoaching.nl", true },
  { "lijstje.be", true },
  { "lijstje.nl", true },
  { "likeablehub.com", true },
  { "likeabox.de", true },
  { "likebee.gr", true },
  { "likegeeks.com", true },
  { "likehifi.de", true },
  { "likemovies.de", true },
  { "likenewhearing.com.au", true },
  { "likere.com", true },
  { "likesforinsta.com", true },
  { "likui.me", true },
  { "lilaccakeboutique.com", true },
  { "liliang13.com", true },
  { "liljohnsanitary.net", true },
  { "lillepuu.com", true },
  { "lilliangray.co.za", true },
  { "lily-bearing.com", true },
  { "lily-inn.com", true },
  { "lilyfarmfreshskincare.com", true },
  { "lilylasvegas.com", true },
  { "lilysbouncycastles.com", true },
  { "lim-light.com", true },
  { "limap.ch", true },
  { "limawi.io", true },
  { "limberg.me", true },
  { "limbo.services", true },
  { "limeburst.net", true },
  { "limelabs.de", true },
  { "limelabs.io", true },
  { "limeres.com", true },
  { "limereslaw.com", true },
  { "limitededitioncomputers.com", true },
  { "limitededitionsolutions.com", true },
  { "limitxyz.com", true },
  { "limoairporttoronto.net", true },
  { "limousineservicezurich.com", true },
  { "limpid.nl", true },
  { "limules.ch", true },
  { "lin.fi", true },
  { "linan.blog", true },
  { "lincdavis.com", true },
  { "linchpin-it.com", true },
  { "lincnaarzorg.nl", true },
  { "lincolnfinewines.com", true },
  { "lincolnpedsgroup.com", true },
  { "lincolnsfh.com", true },
  { "lincolnwayflorist.com", true },
  { "lindalap.fi", true },
  { "lindaolsson.com", true },
  { "lindemann.space", true },
  { "linden.me", true },
  { "lindeskar.se", true },
  { "lindholmen.club", true },
  { "lindnerhof-taktik.de", true },
  { "lindnerhof.info", true },
  { "lindo.ru", true },
  { "lindon.pw", true },
  { "lindsayanderson.com", true },
  { "lindsaygorski.com", true },
  { "lindskogen.se", true },
  { "lindy.co", false },
  { "line.biz", true },
  { "line.co.nz", true },
  { "lineageos.org", true },
  { "linearaudio.net", true },
  { "linearaudio.nl", true },
  { "linearmap.com", true },
  { "linfamilygc.com", true },
  { "lingerie.com.br", true },
  { "lingeriesilhouette.com", true },
  { "lingotaxi.com", true },
  { "linguamilla.com", true },
  { "linguatrip.com", false },
  { "lingvo-svoboda.ru", true },
  { "linherest.tk", true },
  { "link-sanitizer.com", true },
  { "link2serve.com", true },
  { "linkat4.cz", true },
  { "linkdr.uk", true },
  { "linkedinbackground.com", true },
  { "linkedpipes.com", true },
  { "linkenheil.org", true },
  { "linklocker.co", true },
  { "linkmaker.co.uk", true },
  { "linkmauve.fr", true },
  { "linkstream.live", true },
  { "linkthis.me", true },
  { "linkthis.ml", true },
  { "linkthisstatus.ml", true },
  { "linktio.com", true },
  { "linky.tk", true },
  { "linkycat.com", true },
  { "linode.com", false },
  { "linost.com", true },
  { "linqhost.nl", true },
  { "linss.com", true },
  { "lintellift.com", true },
  { "lintmx.com", true },
  { "linusdrop.tips", true },
  { "linux-audit.com", true },
  { "linux-florida.com", true },
  { "linux-mint-czech.cz", true },
  { "linux-vme.org", true },
  { "linux.cn", true },
  { "linux.conf.au", true },
  { "linux.fi", true },
  { "linux.im", true },
  { "linux.pizza", true },
  { "linux3.org", true },
  { "linuxadictos.com", true },
  { "linuxbabe.com", true },
  { "linuxbierwanderung.com", true },
  { "linuxchick.se", true },
  { "linuxcommand.ru", true },
  { "linuxdays.cz", true },
  { "linuxforum.ch", true },
  { "linuxhostsupport.com", true },
  { "linuxiuvat.de", true },
  { "linuxlounge.net", true },
  { "linuxos.org", true },
  { "linuxproperties.com", true },
  { "linuxsecurity.expert", true },
  { "linx.li", true },
  { "linx.net", true },
  { "linzgau.de", true },
  { "linzyjx.com", true },
  { "lionhosting.nl", true },
  { "lionsdeal.com", true },
  { "lipartydepot.com", true },
  { "lipex.com", true },
  { "lipoabaltimore.org", true },
  { "lipthink.com", true },
  { "liqd.net", true },
  { "liquid.cz", true },
  { "liquidhost.co", true },
  { "liquidinternet.co", true },
  { "liquidradio.pro", true },
  { "liquipedia.net", true },
  { "lirion.de", true },
  { "liris-beautywelt.de", true },
  { "lirlandais.ch", true },
  { "lirnberger.com", true },
  { "lisamccorrie.com", true },
  { "lisamortimore.com", true },
  { "lisanzauomo.com", true },
  { "lisburnhottubnbounce.co.uk", true },
  { "liskgdt.net", true },
  { "lisky.ru", true },
  { "lislan.org.uk", true },
  { "lisowski-development.com", false },
  { "listahu.org", true },
  { "listekdo.fr", true },
  { "listen.dk", true },
  { "lister-kirchweg.de", true },
  { "listminut.be", true },
  { "lists.fedoraproject.org", true },
  { "lists.stg.fedoraproject.org", true },
  { "litchidova.nl", true },
  { "litebit.eu", true },
  { "litebitanalytics.eu", true },
  { "litebits.com", true },
  { "litemind.com", true },
  { "literarymachin.es", true },
  { "literature-schools.com", true },
  { "literaturpreis-bad-wurzach.de", true },
  { "litfin.name", true },
  { "lithan.com", true },
  { "lithesalar.se", true },
  { "lithianissaneugeneparts.com", true },
  { "litsovet.com", true },
  { "little-cake.com", true },
  { "littlebestfriend.de", true },
  { "littleboutiqueshop.co.uk", true },
  { "littleboutiqueshop.com", true },
  { "littleboutiqueshop.uk", true },
  { "littlefairy.no", true },
  { "littlefamilyadventure.com", true },
  { "littlegreece.ae", true },
  { "littlejumpers.co.uk", true },
  { "littlenina.nz", false },
  { "littlepigcreek.com.au", true },
  { "littlepincha.fr", true },
  { "littleprincessandmascotparties.co.uk", true },
  { "littleqiu.net", true },
  { "littleredpenguin.com", true },
  { "littleredsbakeshop.com", true },
  { "littlericket.me", false },
  { "littlescallywagsplay.co.uk", true },
  { "littleswitch.co.jp", true },
  { "littlewatcher.com", true },
  { "litvideoserver.de", true },
  { "litz.ca", true },
  { "litzenberger.ca", true },
  { "liuboznaiko.eu", true },
  { "liudon.org", true },
  { "liufengyu.cn", true },
  { "liul.in", true },
  { "liupeicheng.top", true },
  { "liv3d.stream", true },
  { "live4k.media", false },
  { "livebandphotos.com", true },
  { "livebetterwith.com", true },
  { "livebythesun.de", true },
  { "livecards.co.uk", true },
  { "livecards.es", true },
  { "livecards.eu", true },
  { "livecards.it", true },
  { "livedesign.at", true },
  { "livedesign24.de", true },
  { "liveflightapp.com", true },
  { "liveforspeed.se", true },
  { "livekaarten.be", true },
  { "livekaarten.nl", true },
  { "livekarten.at", true },
  { "livekarten.de", true },
  { "livekort.com", true },
  { "livekort.dk", true },
  { "livekort.no", true },
  { "livekort.se", true },
  { "livekortti.com", true },
  { "livekortti.fi", true },
  { "livela.jp", true },
  { "livelexi.com", true },
  { "livelifewithintent.com", true },
  { "livepaperhelp.com", true },
  { "livepath.ch", true },
  { "liveperformersmeeting.net", true },
  { "liveregistratie.nl", true },
  { "liverider.co.jp", true },
  { "livesheep.com", true },
  { "livesure.com", true },
  { "livetoride.co.za", true },
  { "livetube.tv", true },
  { "livi.co", true },
  { "livi.co.uk", true },
  { "livi.fr", true },
  { "living-space.co.nz", true },
  { "living.digital", true },
  { "living.video", true },
  { "living24.de", true },
  { "livingafrugallife.com", true },
  { "livingforreal.com", true },
  { "livinginhimalone.com", true },
  { "livingkingsinc.net", true },
  { "livinglocalnashville.com", true },
  { "livingworduk.org", true },
  { "livnev.me", true },
  { "livnev.xyz", true },
  { "livolett.de", true },
  { "livres-et-stickers.com", true },
  { "livroseuniformes.com.br", true },
  { "lixiaoyu.live", true },
  { "lixtick.com", true },
  { "liyang.pro", false },
  { "liyin.date", true },
  { "liyunbin.com", true },
  { "liz.ee", true },
  { "lizardsystems.com", true },
  { "lizhi.io", true },
  { "lizhi123.net", true },
  { "lizmooredestinationweddings.com", true },
  { "lizzaran.io", true },
  { "lizzwood.com", true },
  { "ljason.cn", true },
  { "ljc.ro", true },
  { "ljs.io", true },
  { "ljskool.com", true },
  { "ljusdalsnaprapatklinik.se", true },
  { "lk-hardware.cz", true },
  { "lknw.de", true },
  { "lkp111138.me", true },
  { "llamacuba.com", true },
  { "llamasweet.tech", true },
  { "llemoz.com", true },
  { "ller.xyz", true },
  { "llm-guide.com", true },
  { "llnl.gov", true },
  { "lloyd-day.me", true },
  { "llslb.com", false },
  { "lm-pumpen.de", false },
  { "lmbyrne.co.uk", true },
  { "lmbyrne.com", true },
  { "lmcm.io", true },
  { "lmddgtfy.net", true },
  { "lmerza.com", true },
  { "lmintlcx.com", true },
  { "lmmi.nl", true },
  { "lmmtfy.io", true },
  { "lmsptfy.com", true },
  { "lmtls.me", true },
  { "lmtm.eu", true },
  { "lng-17.org", true },
  { "lnhequipmentltd.com", true },
  { "lnmp.me", true },
  { "lntu.org", true },
  { "lnx.li", true },
  { "lnyltx.cn", true },
  { "load-ev.de", true },
  { "loadlow.me", true },
  { "loadwallet.com", true },
  { "loanaway.ca", true },
  { "loancompare.co.za", true },
  { "loandolphin.com.au", true },
  { "loanreadycredit.com", true },
  { "loanstreet.nl", true },
  { "lob-assets-staging.com", true },
  { "lob-assets.com", true },
  { "lob-staging.com", true },
  { "lob.com", true },
  { "lobivia.de", true },
  { "lobsangstudio.com", true },
  { "lobstr.co", true },
  { "local360.net", true },
  { "localbandz.com", true },
  { "localbitcoins.com", true },
  { "localblock.co.za", true },
  { "localbouncycastle.com", true },
  { "localdecor.com.br", true },
  { "localethereum.com", true },
  { "localhorst.duckdns.org", true },
  { "localhorst.xyz", true },
  { "localhost.ee", true },
  { "localprideart.com", true },
  { "localspot.pl", true },
  { "locapos.com", true },
  { "locationvoitureallemagne.com", true },
  { "locationvoitureangleterre.com", true },
  { "locationvoitureaustralie.com", true },
  { "locationvoiturebelgique.com", true },
  { "locationvoitureespagne.com", true },
  { "locationvoitureitalie.com", true },
  { "locationvoitureportugal.com", true },
  { "locatorplus.gov", true },
  { "locauxrama.fr", true },
  { "locker.plus", true },
  { "lockpick.nl", true },
  { "lockpicks.se", true },
  { "lockr.io", true },
  { "locksmith-sanantonio-tx.com", true },
  { "locksmithbalchsprings.com", true },
  { "locksmithballito.com", true },
  { "locksmithbluff.co.za", true },
  { "locksmithdearborn.com", true },
  { "locksmithedmonds.com", true },
  { "locksmithfriendswoodtexas.com", true },
  { "locksmithgarland-tx.com", true },
  { "locksmithgrapevinetx.com", true },
  { "locksmithhumbletx.com", true },
  { "locksmithindurban.co.za", true },
  { "locksmithlivoniami.com", true },
  { "locksmithmadisonheights.com", true },
  { "locksmithmesquitetx.com", true },
  { "locksmithmissouricity.com", true },
  { "locksmithopen.com", true },
  { "locksmithsammamishwa.com", true },
  { "locksmithsanantoniotexas.com", true },
  { "locksmithscottsdaleaz.com", true },
  { "locksmithseattleco.com", true },
  { "locksmithservice-houston.com", true },
  { "locksmithspring.com", true },
  { "locksmithspringtx.com", true },
  { "locksmithswestville.com", true },
  { "locksmiththewoodlands.com", true },
  { "locomocosec.com", true },
  { "locomore.com", true },
  { "locomotionds.com", true },
  { "locomotive.net.br", true },
  { "locurimunca.co", true },
  { "lodash.com", false },
  { "loddeke.eu", true },
  { "lodewijkict.nl", true },
  { "loenshotel.de", true },
  { "loew.de", true },
  { "loforo.com", true },
  { "lofttravel.com", true },
  { "logaldeveloper.com", true },
  { "loganmarchione.com", true },
  { "loganparkneighborhood.org", true },
  { "logbook.ch", true },
  { "logbot.info", true },
  { "logement-saisonnier.com", true },
  { "logement.com", true },
  { "logentries.com", false },
  { "logexplorer.net", true },
  { "logfile.at", true },
  { "logfile.ch", true },
  { "logiciel-entreprise-seurann.fr", true },
  { "logicio.ch", false },
  { "logicio.de", false },
  { "logicio.net", false },
  { "logicne-hise.si", true },
  { "logicoma.com", true },
  { "logicz.top", true },
  { "login.corp.google.com", true },
  { "login.gov", false },
  { "login.launchpad.net", true },
  { "login.sapo.pt", true },
  { "login.ubuntu.com", true },
  { "login.xero.com", false },
  { "login.yahoo.com", false },
  { "loginsentinel.eu", true },
  { "logitank.net", true },
  { "logitel.de", true },
  { "logoesun.com", true },
  { "logoglo.com", true },
  { "logojoes.net", true },
  { "logopaediereinhard.de", true },
  { "logopedistalanni.it", true },
  { "logophiliapress.com", true },
  { "logopoeia.com", true },
  { "logostock.jp", true },
  { "logtalk.org", true },
  { "logtalk.pt", true },
  { "logue.be", true },
  { "logze.nl", true },
  { "lohanaflores.com.br", true },
  { "lohmeier.it", true },
  { "loichot.ch", true },
  { "loigiai.net", true },
  { "loihay.net", true },
  { "lojadamimo.com.br", true },
  { "lojadanidrea.com.br", true },
  { "lojadarenda.com.br", true },
  { "lojadewhisky.com.br", true },
  { "lojadoarcomprimido.com.br", true },
  { "lojadosomautomotivo.com.br", true },
  { "lojafazendoarte.com.br", true },
  { "lojafilipaper.com.br", true },
  { "lojamagicalx.com", true },
  { "lojamascate.com.br", true },
  { "lojamoleco.com.br", true },
  { "lojaprimemed.com.br", true },
  { "lojaprojetoagua.com.br", true },
  { "lojasceletro.com.br", true },
  { "lojaterrazul.com.br", true },
  { "lojavirtualfc.com.br", true },
  { "lojavirtualfct.com.br", true },
  { "lojavisamed.com.br", true },
  { "lojix.com", true },
  { "lojj.pt", true },
  { "lok.space", true },
  { "lokaal.org", true },
  { "loket.nl", true },
  { "lolcorp.pl", true },
  { "lolcow.farm", true },
  { "loli.net", true },
  { "loli.pet", true },
  { "loli.tube", true },
  { "loli.world", true },
  { "lolibrary.org", true },
  { "lolic.xyz", true },
  { "lolico.moe", true },
  { "lolicon.eu", true },
  { "lolkot.ru", true },
  { "lolnames.gg", true },
  { "lolpatrol.de", true },
  { "lolpatrol.wtf", true },
  { "loma.ml", true },
  { "lommeregneren.dk", true },
  { "lommyfleet.com", true },
  { "lon-so.com", true },
  { "lona.io", true },
  { "lonal.com", true },
  { "london-transfers.com", true },
  { "london.dating", true },
  { "londongallery.net", true },
  { "londongynaecologist.co", true },
  { "londonkan.jp", true },
  { "londonkeyholdingcompany.co.uk", true },
  { "lonelytweets.com", true },
  { "lonesomecosmonaut.com", true },
  { "lonestarlandandcommercial.com", true },
  { "long-journey.com", true },
  { "long18.cc", true },
  { "longboat.io", true },
  { "longhaircareforum.com", true },
  { "longhorn-imports.com", true },
  { "longhorn.id.au", true },
  { "longstride.net", true },
  { "longtermcare.gov", true },
  { "lonniec.com", true },
  { "lonniemason.net", true },
  { "look.co.il", true },
  { "looka.ch", true },
  { "looka.photo", true },
  { "lookagain.co.uk", true },
  { "lookart.ch", true },
  { "lookasik.eu", true },
  { "lookastic.co.uk", true },
  { "lookastic.com", true },
  { "lookastic.de", true },
  { "lookastic.es", true },
  { "lookastic.fr", true },
  { "lookastic.mx", true },
  { "lookastic.ru", true },
  { "lookatmysco.re", true },
  { "lookbetweenthelines.com", true },
  { "looker.wang", true },
  { "lookup-dns.net", true },
  { "lookyman.net", true },
  { "lookzook.com", true },
  { "loom.no", true },
  { "loopstart.org", true },
  { "looseleafsecurity.com", true },
  { "loothole.com", true },
  { "loovto.net", true },
  { "loposchokk.com", true },
  { "loqu8.com", true },
  { "loquo.com", true },
  { "lord.sh", true },
  { "lordofthebrick.com", true },
  { "lore.azurewebsites.net", true },
  { "lorenadumitrascu.ro", true },
  { "loreofthenorth.com", true },
  { "loreofthenorth.nl", true },
  { "loricozengeller.com", true },
  { "lorientlejour.com", true },
  { "loritaboegl.de", true },
  { "losangelestown.com", true },
  { "losless.fr", true },
  { "losreyesdeldescanso.com.ar", true },
  { "lost.host", true },
  { "lost.report", true },
  { "lostkeys.co.uk", true },
  { "lostserver.com", true },
  { "loteamentomontereiitu.com.br", true },
  { "lothlorien.ca", false },
  { "lotl.ru", true },
  { "lotn.mobi", true },
  { "lotn.nl", true },
  { "lotnonline.com", true },
  { "lotnonline.nl", true },
  { "lotro-wiki.com", true },
  { "lottospielen24.org", false },
  { "lotw.de", true },
  { "lotz.li", true },
  { "lou.lt", true },
  { "louange-reconvilier.ch", true },
  { "loucanfixit.com", true },
  { "louerunhacker.fr", true },
  { "louisemisellinteriors.co.uk", true },
  { "louisvillecarguys.com", true },
  { "loune.net", true },
  { "loungecafe.net", true },
  { "loungecafe.org", true },
  { "loungepapillon.com", true },
  { "love4taylor.me", true },
  { "loveai.org", true },
  { "loveandadoreboutique.com", true },
  { "lovebigisland.com", true },
  { "lovecrystal.co.uk", true },
  { "loveislandgames.com", true },
  { "loveisourweapon.com", true },
  { "lovelens.li", false },
  { "lovelivewiki.com", true },
  { "lovelovenavi.jp", true },
  { "lovemanagementaccounts.co.uk", true },
  { "lovemiku.info", true },
  { "lovemomiji.com", true },
  { "lovenwishes.com", true },
  { "loveph.one", true },
  { "lover-bg.com", true },
  { "loverepublic.ru", true },
  { "lovesmagical.com", true },
  { "lovesupremefestival.com", true },
  { "lovetravel360.com", true },
  { "lovevape.co", true },
  { "loveyounastya.com", true },
  { "loveysa.ch", true },
  { "lovg.ren", true },
  { "lovingearth.co", true },
  { "lovingthermo.com", true },
  { "lovizaim.ru", true },
  { "low-diets.com", true },
  { "lowcarblab.com", true },
  { "lowcostwire.com.au", true },
  { "lowerpricefinder.com", true },
  { "lowmagnitude.com", true },
  { "lowsec.space", true },
  { "lowsidetna.com", true },
  { "lowson.ca", true },
  { "loxal.net", true },
  { "loyaleco.it", true },
  { "loyaltyondemand.club", true },
  { "loyaltyondemand.eu", true },
  { "lpcom.de", true },
  { "lprcommunity.co.za", true },
  { "lpt-nebreziny.eu", true },
  { "lqs.me", true },
  { "lra-cloud.de", true },
  { "lrdo.net", true },
  { "lrssystems.com", true },
  { "ls-alarm.de", true },
  { "lsal.me", true },
  { "lsc-dillingen.de", true },
  { "lsc.gov", true },
  { "lshiy.com", true },
  { "lsmpx.com", true },
  { "lsquo.com", true },
  { "lsscreens.de", true },
  { "lsy.cn", true },
  { "lt.search.yahoo.com", false },
  { "ltaake.com", true },
  { "ltecode.com", true },
  { "ltib.com.au", true },
  { "ltls.org", true },
  { "ltn-tom-morel.fr", true },
  { "lu.search.yahoo.com", false },
  { "luav.org", true },
  { "lubar.me", true },
  { "lubbockyounglawyers.org", true },
  { "lublin.toys", true },
  { "lubomirkazakov.com", true },
  { "luc-oberson.ch", true },
  { "luca-steeb.com", true },
  { "luca.swiss", true },
  { "lucacastelnuovo.nl", false },
  { "lucafontana.net", true },
  { "lucafrancesca.me", true },
  { "lucasantarella.com", true },
  { "lucasbergen.ca", true },
  { "lucasem.com", true },
  { "lucasgaland.com", true },
  { "lucasgymnastics.com", true },
  { "lucaslarson.net", true },
  { "luce.life", true },
  { "luchscheider.de", false },
  { "lucianoalbanes.com", true },
  { "lucid-light.de", true },
  { "lucidframeworks.com", true },
  { "lucidlight.de", true },
  { "lucidoccult.com", true },
  { "lucie.jp", true },
  { "lucielavickova.com", true },
  { "luckycastles.co.uk", true },
  { "luckyfrog.hk", true },
  { "luckyxf.com", true },
  { "lucy.science", true },
  { "lucyparsonslabs.com", true },
  { "lucysan.net", true },
  { "lucz.co", true },
  { "ludek.biz", true },
  { "ludikovsky.name", true },
  { "ludogue.net", true },
  { "ludovic-muller.fr", true },
  { "ludum.pl", true },
  { "ludwig.im", true },
  { "ludwiggrill.de", true },
  { "ludwigjohnson.se", true },
  { "ludwigpro.net", true },
  { "luedeke-bremen.eu", true },
  { "luehne.de", true },
  { "luelistan.net", true },
  { "luenwarneke.com", true },
  { "luera1959.de", true },
  { "luffyhair.com", true },
  { "luftbild-siegerland.de", true },
  { "luftreiniger.biz", true },
  { "lufu.io", true },
  { "lugbb.org", true },
  { "lugimax.com", true },
  { "luginbuehl.be", true },
  { "lugui.in", true },
  { "lui.pink", true },
  { "luiscapelo.info", true },
  { "luismaier.de", true },
  { "luisyr.com", true },
  { "luizkowalski.net", true },
  { "luk.earth", true },
  { "lukas-gorr.de", true },
  { "lukas-meixner.com", true },
  { "lukas-oppermann.de", true },
  { "lukasberan.com", true },
  { "lukasberan.cz", true },
  { "lukasfunk.com", true },
  { "lukasoppermann.com", true },
  { "lukasoppermann.de", true },
  { "lukasschick.de", false },
  { "lukaszorn.de", true },
  { "lukaszwojcik.net", true },
  { "lukatz.de", true },
  { "luke.ch", true },
  { "luke6887.me", true },
  { "lukeistschuld.de", true },
  { "lukem.net", true },
  { "lukeng.net", true },
  { "lukesbouncycastlehire.com", true },
  { "lukestebbing.com", true },
  { "lukesutton.info", true },
  { "lukmanulhakim.id", true },
  { "lukull-pizza.de", true },
  { "luloboutique.com", true },
  { "lumen.sh", true },
  { "lumi.pw", true },
  { "lumiere.com", true },
  { "luminaire.fr", true },
  { "luminaires-online.fr", true },
  { "lumitop.com", true },
  { "lumminary.com", true },
  { "lunafag.ru", true },
  { "lunakit.org", true },
  { "lunalove.de", true },
  { "lunanova.moe", true },
  { "lunapps.com", true },
  { "lunar6.ch", true },
  { "lunarichter.de", true },
  { "lunarlog.com", true },
  { "lunarshark.com", true },
  { "lunartail.nl", true },
  { "lunasqu.ee", true },
  { "lunastrail.com", true },
  { "lunazacharias.com", true },
  { "lunchbunch.me", true },
  { "lune-indigo.ch", true },
  { "lungta.pro", true },
  { "lunidea.ch", true },
  { "lunidea.com", true },
  { "lunis.net", true },
  { "lunorian.is", true },
  { "luodaoyi.com", true },
  { "luody.info", true },
  { "luoe.me", true },
  { "luoh.cc", true },
  { "luoh.me", true },
  { "luohua.im", true },
  { "luongvu.com", true },
  { "luoshifeng.com", true },
  { "luowu.cc", true },
  { "lupecode.com", true },
  { "lupinencyclopedia.com", true },
  { "lupinenorthamerica.com", true },
  { "lusitom.com", true },
  { "luso-livros.net", true },
  { "lusoft.cz", true },
  { "lusteniny.cz", true },
  { "lustige-zitate.com", true },
  { "lustin.fr", true },
  { "lustrum.ch", true },
  { "lusynth.com", true },
  { "luteijn.biz", true },
  { "luteijn.cloud", true },
  { "luteijn.email", true },
  { "luteijn.pro", true },
  { "lutizi.com", false },
  { "lutoma.org", true },
  { "luukdebruincv.nl", true },
  { "luukklene.nl", true },
  { "luukuton.fi", true },
  { "luuppi.fi", true },
  { "luvare.com", true },
  { "luvbridal.com.au", true },
  { "luxcraft.eng.br", true },
  { "luxescreenprotector.nl", false },
  { "luxfosdecoenterprise.com", true },
  { "luxsci.com", true },
  { "luxurynsight.net", true },
  { "luxurytimepieces.net", true },
  { "luxuryweddingsindonesia.com", true },
  { "luxusnivoucher.cz", true },
  { "luxusnyvoucher.sk", true },
  { "luxvacuos.net", true },
  { "luxwatch.com", true },
  { "luyckx.net", true },
  { "luzat.com", true },
  { "luzfaltex.com", true },
  { "lv.search.yahoo.com", false },
  { "lv0.it", true },
  { "lvftw.com", true },
  { "lvguitars.com", true },
  { "lvmoo.com", true },
  { "lvrsystems.com", true },
  { "lw-addons.net", true },
  { "lwl.moe", true },
  { "lwl12.com", true },
  { "lxd.cc", true },
  { "lxd.pm", true },
  { "lyam.fr", true },
  { "lycee-saintjoseph-mesnieres.fr", true },
  { "lychankiet.name.vn", false },
  { "lydudlejning.net", true },
  { "lyftrideestimate.com", true },
  { "lykai.ca", true },
  { "lymia.moe", true },
  { "lynero.dk", true },
  { "lyness.io", true },
  { "lyngvaer.no", true },
  { "lynnlaytonnissanparts.com", true },
  { "lynnmosher.com", true },
  { "lynsec.com", true },
  { "lynthium.com", true },
  { "lynx.nl", true },
  { "lynxbroker.de", true },
  { "lynxpro.nl", true },
  { "lyon-interactive.com", true },
  { "lyon-synergie.com", true },
  { "lyoness.digital", true },
  { "lyrical-nonsense.com", true },
  { "lyricfm.ie", true },
  { "lys.ch", true },
  { "lysdeau.be", true },
  { "lyst.co.uk", true },
  { "lyukaacom.ru", true },
  { "lyuly.com", true },
  { "lyx.dk", true },
  { "lzcreation.com", true },
  { "lzh.one", true },
  { "lzwc.nl", true },
  { "m-22.com", true },
  { "m-chemical.com.hk", true },
  { "m-gh.info", true },
  { "m-idea.jp", true },
  { "m-kleinert.de", true },
  { "m-mail.fr", true },
  { "m-monitor.pl", true },
  { "m-orthodontic.com", true },
  { "m-ses.fr", true },
  { "m.facebook.com", true },
  { "m.mail.ru", true },
  { "m.me", true },
  { "m0t0k1ch1.com", true },
  { "m132.eu", true },
  { "m134.eu", true },
  { "m2epro.com", true },
  { "m2il.co", true },
  { "m2os.com", true },
  { "m4g.ru", true },
  { "m4rcus.de", true },
  { "ma-eir.nl", true },
  { "ma2t.com", true },
  { "maartenderaedemaeker.be", true },
  { "maartenvandekamp.nl", true },
  { "maatwerkopruimcoaching.nl", true },
  { "maatwerkzorgcoaching.nl", true },
  { "maaya.jp", true },
  { "maayogashram.com", true },
  { "mabankonline.com", true },
  { "mabulledu.net", true },
  { "mac-i-tea.ch", true },
  { "mac-service-stockholm.se", true },
  { "mac-servicen.se", true },
  { "mac.biz.tr", true },
  { "mac1.net", true },
  { "macaw.nl", true },
  { "macaws.org", true },
  { "macbook.es", true },
  { "maceinturecuir.com", true },
  { "maces-net.de", true },
  { "macgenius.com", true },
  { "mach-politik.ch", true },
  { "macha.cloud", true },
  { "machbach.com", true },
  { "machetewp.com", true },
  { "machijun.net", true },
  { "machikka.com", false },
  { "machinetransport.com", true },
  { "macht-elektro.de", true },
  { "machtweb.de", true },
  { "machu-picchu.nl", true },
  { "macil.tech", true },
  { "macinyasha.net", true },
  { "macker.io", true },
  { "mackey7.net", true },
  { "mackeysack.com", true },
  { "mackiehouse.ca", true },
  { "macksproductions.in", true },
  { "maclemon.at", true },
  { "macleod.io", true },
  { "macnemo.de", true },
  { "macnetwork.eu", true },
  { "macnetwork.fr", true },
  { "macnetwork.net", true },
  { "maco.org.uk", true },
  { "maconnerie-dcs.ch", true },
  { "macosxfilerecovery.com", true },
  { "macoun.de", true },
  { "macros.co.jp", true },
  { "macsupportnacka.se", true },
  { "macsupportstockholm.se", true },
  { "mactools.com.co", true },
  { "mad.ninja", true },
  { "madae.nl", true },
  { "madandpissedoff.com", true },
  { "madars.org", false },
  { "madbicicletas.com", true },
  { "madbin.com", true },
  { "madbouncycastles.co.uk", true },
  { "maddi.biz", true },
  { "maddistonevangelical.co.uk", true },
  { "maddistonparentcouncil.co.uk", true },
  { "maddistonpsa.co.uk", true },
  { "maddreefer.com", true },
  { "made-in-earth.co.jp", true },
  { "made-to-usb.com", true },
  { "madebydusk.com", true },
  { "madebyshore.com", true },
  { "madeinchezmoi.net", true },
  { "madeinstudio3.com", true },
  { "madeitwor.se", true },
  { "madeloc.com", true },
  { "mademoiselledemargaux.com", true },
  { "mader.jp", true },
  { "madin.ru", true },
  { "madirc.net", true },
  { "madisonent-facialplasticsurgery.com", true },
  { "madisonsquarerealestate.com", true },
  { "madmar.ee", true },
  { "madmax-store.gr", true },
  { "madoka.nu", true },
  { "madokami.pw", true },
  { "madreacqua.org", true },
  { "madrecha.com", true },
  { "madreshoy.com", true },
  { "madridartcollection.com", true },
  { "madscientistwebdesign.com", true },
  { "madtec.de", true },
  { "madusecurity.com", true },
  { "mae-berlinistanbul.com", true },
  { "maedchenflohmarkt.at", true },
  { "maedchenflohmarkt.de", true },
  { "maeln.com", true },
  { "maelstrom-fury.eu", true },
  { "maelstrom.ninja", true },
  { "maeplasticsurgery.com", true },
  { "maestrano.com", true },
  { "maff.co.uk", true },
  { "mafia.network", true },
  { "mafiaforum.de", true },
  { "mafiapenguin.club", true },
  { "mafiasi.de", true },
  { "magasindejouets.com", true },
  { "magasinsalledebain.be", true },
  { "magasinsalledebain.fr", true },
  { "magasinsalledebains.be", true },
  { "magasinsalledebains.fr", true },
  { "magasinsenfrance.com", true },
  { "magazin3513.com", true },
  { "magazinedotreino.com.br", true },
  { "magdic.eu", true },
  { "magebit.com", true },
  { "magenda.sk", true },
  { "magentaize.net", true },
  { "magentapinkinteriors.co.uk", true },
  { "magentoeesti.eu", true },
  { "magewell.nl", true },
  { "maggie.com", true },
  { "magi-cake.com", true },
  { "magi.systems", true },
  { "magic-cards.info", true },
  { "magical-secrets.com", true },
  { "magical.rocks", true },
  { "magicalcircuslv.com", true },
  { "magicalshuttle.fr", true },
  { "magicamulet.me", true },
  { "magicbroccoli.de", true },
  { "magiccards.info", true },
  { "magicdaysomagh.co.uk", true },
  { "magiclen.org", true },
  { "magicspaceninjapirates.de", true },
  { "magictable.com", true },
  { "magicvodi.at", true },
  { "magilio.com", true },
  { "magnacarebroker.com", true },
  { "magnate.co", true },
  { "magnatronic.com.br", true },
  { "magneticattraction.com.au", true },
  { "magnetpass.uk", true },
  { "magnets.jp", true },
  { "magnettracker.com", true },
  { "magnificatwellnesscenter.com", true },
  { "magnificentdata.com", true },
  { "magnoliadoulas.com", true },
  { "magnoliastrong.com", true },
  { "magnunbaterias.com.br", true },
  { "magodaoferta.com.br", true },
  { "magonote-nk.com", true },
  { "magravsitalia.com", true },
  { "magu.kz", true },
  { "maguire.email", true },
  { "magwin.co.uk", true },
  { "mah-nig.ga", true },
  { "mahai.me", true },
  { "mahatmayoga.org", true },
  { "mahefa.co.uk", true },
  { "mahjong-navi.com", true },
  { "mahjong.org", true },
  { "mahjongrush.com", true },
  { "mahrer.net", true },
  { "maiaimobiliare.ro", true },
  { "maidoty.net", true },
  { "maiebanatulfruncea.com", true },
  { "maijia800.com", true },
  { "maikolfish.it", true },
  { "mail-de.jp", true },
  { "mail-rotter.de", true },
  { "mail-settings.google.com", true },
  { "mail.com", true },
  { "mail.de", true },
  { "mail.google.com", true },
  { "mail.storage", true },
  { "mail.yahoo.com", false },
  { "mail180.com", true },
  { "mail4you.in", true },
  { "mailbox.mg", true },
  { "mailbox.org", true },
  { "mailer-dot.de", true },
  { "mailfence.com", true },
  { "mailflank.com", true },
  { "mailinabox.email", true },
  { "mailjet.tech", true },
  { "maillady-susume.com", true },
  { "mailmag.net", false },
  { "mailnara.co.kr", true },
  { "mailto.space", true },
  { "mailum.org", false },
  { "mainechiro.com", true },
  { "mainframeserver.space", true },
  { "mainlined.org", true },
  { "maintenance-traceur-hp.fr", true },
  { "mainzelmaennchen.net", true },
  { "maioresemelhores.com", true },
  { "maisgasolina.com", true },
  { "maison-haimard.fr", true },
  { "maisondoree.be", true },
  { "maisonpaulmier.fr", true },
  { "maispa.com", true },
  { "maisretorno.com", true },
  { "maisvitaminas.com.br", true },
  { "maitheme.com", true },
  { "maitrechaton.fr", true },
  { "maitrise-orthopedique.com", true },
  { "majahoidja.ee", true },
  { "majaweb.cz", true },
  { "majemedia.com", false },
  { "majesnix.org", true },
  { "majid.info", true },
  { "majkassab.com", true },
  { "majkassab.net", true },
  { "majkassab.org", true },
  { "majkl.me", true },
  { "majkl.xyz", true },
  { "majkl578.cz", true },
  { "majkyto.cz", true },
  { "majlovesreg.one", true },
  { "majolka.com", true },
  { "majorpaintingco.com", true },
  { "makaleci.com", true },
  { "makalu.me", true },
  { "make-your-own-song.com", true },
  { "makeaboldmove.com", true },
  { "makechanges.com.au", true },
  { "makedin.net", true },
  { "makem-bounce.co.uk", true },
  { "makenaiyo-fx.com", true },
  { "makera.ga", true },
  { "makersatwork.com", true },
  { "maketheneighborsjealous.com", true },
  { "makeurbiz.com", true },
  { "maki-chan.de", true },
  { "makinen.ru", true },
  { "makkusu.photo", true },
  { "makkyon.com", true },
  { "makos.jp", true },
  { "makowitz.cz", true },
  { "maktoob.search.yahoo.com", false },
  { "maku.edu.tr", true },
  { "malachiteauth.com", true },
  { "malash.me", true },
  { "malasuk.com", true },
  { "malaysia.search.yahoo.com", false },
  { "malaysian.dating", true },
  { "maldives.cx", true },
  { "malenyflorist.com.au", true },
  { "maler-marschalleck.de", true },
  { "malermeister-haussmann.de", true },
  { "malesoowki.blog", true },
  { "malezan.com", true },
  { "maliar.fr", true },
  { "malibu-electric.com", true },
  { "malibuelectrical.com", true },
  { "malibuexteriorlighting.com", true },
  { "malik.holdings", true },
  { "malik.id", true },
  { "malikussa.id", true },
  { "malikussaid.com", true },
  { "malikzinad.com", true },
  { "malinator.net", false },
  { "malinheadview.ie", true },
  { "maljaars-fotografie.nl", true },
  { "mall.cz", true },
  { "mall.hr", true },
  { "mall.hu", true },
  { "mall.pl", true },
  { "mall.sk", true },
  { "mallach.net", true },
  { "mallhonda.com", true },
  { "mallonline.com.br", true },
  { "malmoesport.se", true },
  { "malnex.de", true },
  { "malscan.com", true },
  { "malscan.org", true },
  { "malta-firma.com", true },
  { "malte-kiefer.de", true },
  { "malufs.com.br", true },
  { "malware.watch", true },
  { "malwareinvestigator.gov", true },
  { "malwarekillers.com", true },
  { "malwaretips.com", false },
  { "maly.cz", true },
  { "malyshata.com", true },
  { "malysvet.net", true },
  { "mamaasia.info", true },
  { "mamadea.be", true },
  { "mamadoma.com.ua", true },
  { "mamafit.club", true },
  { "mamamoet.ru", true },
  { "mamanecesitaungintonic.com", true },
  { "mambas.cn", true },
  { "mamiecouscous.com", true },
  { "mammals.net", true },
  { "mammaw.com", true },
  { "mammeitalianeavienna.com", true },
  { "mammooc.org", true },
  { "mammothlakesmls.net", true },
  { "mamospienas.lt", true },
  { "mamot.fr", false },
  { "mamuko.nl", true },
  { "man3s.jp", false },
  { "mana.ee", true },
  { "manach.net", true },
  { "manage.cm", true },
  { "manage4all.de", true },
  { "manageathome.co.uk", true },
  { "management-companie.ro", true },
  { "managementboek.nl", true },
  { "managementfeedback.com", true },
  { "managementforstartups.com", true },
  { "manageprojects.com", false },
  { "manager-efficacement.com", true },
  { "manager.linode.com", false },
  { "managewp.org", true },
  { "manatees.com.au", true },
  { "manatees.net", true },
  { "manavgabhawala.com", true },
  { "manawill.jp", true },
  { "mandcbouncycastlehire.co.uk", true },
  { "mandynamic.gr", true },
  { "maneggio.milano.it", true },
  { "manesht.ir", true },
  { "manfredgruber.net", true },
  { "manfredi.io", true },
  { "manfredimatteo.com", true },
  { "manfredschafer.ch", true },
  { "mangahigh.com", true },
  { "mangaristica.com", false },
  { "mangnhuapvc.com.vn", true },
  { "mangotwoke.co.uk", true },
  { "manhattanchoralensemble.org", true },
  { "manhole.club", true },
  { "manhuagui.com", true },
  { "manicbouncycastles.co.uk", true },
  { "manicode.com", true },
  { "maniorpedi.com", true },
  { "maniosglass.gr", true },
  { "manipil.ch", true },
  { "maniw.com", true },
  { "manja-und-martin.de", true },
  { "manjaro.ru", true },
  { "mankans.com", true },
  { "manmeetgill.com", true },
  { "manneguiden.no", true },
  { "mannheimbloggt.tk", true },
  { "manns-solutions.co.uk", true },
  { "mannschafft.ch", true },
  { "manoirdecontres.com", true },
  { "manonandre-avocat.fr", true },
  { "manoro.de", true },
  { "manowarus.com", true },
  { "mansdell.net", true },
  { "mansfeld.pl", true },
  { "manski.net", true },
  { "mantabiofuel.com", true },
  { "manti.by", true },
  { "mantor.org", false },
  { "mantra.pictures", true },
  { "manualidadeson.com", true },
  { "manuall.co.uk", true },
  { "manuall.de", true },
  { "manuall.fr", true },
  { "manuall.info.tr", true },
  { "manuall.it", true },
  { "manuall.ro", true },
  { "manuall.se", true },
  { "manualscollection.com", true },
  { "manuel-herrmann.de", true },
  { "manuel-schefczyk.de", true },
  { "manuelahidalgo.org", true },
  { "manueldopheide.com", true },
  { "manueli.de", true },
  { "manuelpinto.in", false },
  { "manufacturing.gov", true },
  { "manufacturinginmexico.org", true },
  { "manufacturingusa.com", true },
  { "manuscript.com", true },
  { "manuscriptlink.com", true },
  { "manutd.org.np", true },
  { "manuth.life", true },
  { "manwithavan.co.uk", true },
  { "manyetikboya.com", true },
  { "manyiu.com", true },
  { "manylots.ru", true },
  { "manyue.org", true },
  { "maoi.re", true },
  { "maomihz.com", true },
  { "maone.net", true },
  { "maorseo.com", true },
  { "maosensanguentadasdejesus.net", true },
  { "maowtm.org", true },
  { "maozedong.red", true },
  { "map4erfurt.de", true },
  { "map4jena.de", true },
  { "mapasmundi.com.br", true },
  { "mapblender.com", true },
  { "mapchange.org", true },
  { "mapeo.io", true },
  { "maplanetebeaute.fr", true },
  { "maplehome.tk", true },
  { "mapletime.com", true },
  { "maps.net", true },
  { "mapstack.org", true },
  { "maquettage.com", true },
  { "maquinariaspesadas.org", true },
  { "maquinasdecoserplus.com", true },
  { "mar-eco.no", true },
  { "marabumadrid.com", false },
  { "marabunta.io", true },
  { "marakovits.net", true },
  { "marble.com", true },
  { "marbogardenlidkoping.se", true },
  { "marbree.eu", true },
  { "marc-hammer.de", true },
  { "marc-schlagenhauf.de", true },
  { "marcaixala.me", true },
  { "marcbeije.com", true },
  { "marcberndtgen.de", true },
  { "marcceleiro.cat", true },
  { "marcceleiro.com", true },
  { "marceau.ovh", true },
  { "marcel-preuss.de", true },
  { "marcel-veronetzki.de", true },
  { "marcel-waldvogel.ch", true },
  { "marcelinofranchini.com", true },
  { "marcelinofranchini.eu", true },
  { "marcelinofranchini.info", true },
  { "marcelinofranchini.net", true },
  { "marcelinofranchini.org", true },
  { "marcelkooiman.com", true },
  { "marcelpreuss.de", true },
  { "marcelsiegert.com", true },
  { "marcelwaldvogel.ch", true },
  { "marcelwiedemeier.com", true },
  { "marcelwolf.coach", true },
  { "marcgoertz.de", true },
  { "marche-contre-monsanto.ch", true },
  { "marchukov.com", true },
  { "marchwj.pl", true },
  { "marciaimportados.com.br", true },
  { "marcianoandtopazio.com", true },
  { "marclay.co.uk", true },
  { "marco-goltz.de", true },
  { "marco-hegenberg.net", true },
  { "marco-polo-reisen.com", true },
  { "marcocasoni.com", true },
  { "marcoherten.com", true },
  { "marcoklomp.nl", true },
  { "marcoslater.com", true },
  { "marcusds.ca", true },
  { "marcuskoh.com", true },
  { "marcusstafford.com", true },
  { "marechal-company.com", true },
  { "marek.pro", true },
  { "marek.su", true },
  { "marelijah.org", true },
  { "margagriesser.de", true },
  { "margecommunication.com", true },
  { "margo-co.ch", true },
  { "margotlondon.co.uk", true },
  { "margots.biz", true },
  { "margots.life", true },
  { "margots.tech", true },
  { "marguerite-maison.fr", true },
  { "mariacorzo.com", true },
  { "mariage-photo.ch", true },
  { "mariaheidemann.nl", true },
  { "marianatherapy.com", true },
  { "marianelaisashi.com", true },
  { "marianhoenscheid.de", true },
  { "mariannenan.nl", true },
  { "mariannethijssen.nl", true },
  { "mariapietropola.com", true },
  { "mariatash.com", true },
  { "marie-elisabeth.dk", false },
  { "mariehane.com", true },
  { "mariemiramont.fr", true },
  { "mariereichl.cz", true },
  { "marijnfidder.nl", true },
  { "marikafranke.de", true },
  { "marilsnijders.nl", true },
  { "marilynmartin.com.au", true },
  { "marilynstreats.com", true },
  { "marin-business-center.ch", true },
  { "marin-dom.ru", true },
  { "marin-tullet.com", true },
  { "marinazarza.es", true },
  { "marinbusinesscenter.ch", true },
  { "marine.gov", true },
  { "marinekaplama.com", true },
  { "marinela.com.mx", false },
  { "marinelausa.com", false },
  { "marines-shop.com", true },
  { "mariogeckler.de", true },
  { "mariposah.ch", true },
  { "marisamorby.com", false },
  { "mariskavankasbergen.nl", true },
  { "maritim.go.id", false },
  { "mariushubatschek.de", true },
  { "mariviolin.com", true },
  { "marjeta-gurtner.ch", true },
  { "marjoleindens.be", true },
  { "marjoriecarvalho.com.br", true },
  { "mark-dietzer.de", true },
  { "mark-semmler.de", true },
  { "mark1998.com", true },
  { "markaconnor.com", true },
  { "markandrosalind.co.uk", true },
  { "markantoffice.com", true },
  { "markbiesheuvel.nl", true },
  { "markdain.net", true },
  { "markdescande.com", true },
  { "markel.com.es", true },
  { "markepps.com", true },
  { "market.android.com", true },
  { "marketespace.fr", false },
  { "marketindex.com.au", true },
  { "marketing-2.de", true },
  { "marketing.limited", true },
  { "marketing91.com", true },
  { "marketingbrandingnews.com", true },
  { "marketingbrandingnews.net", true },
  { "marketingco.nl", true },
  { "marketingconverts.com", true },
  { "marketingeinnovacion.com", true },
  { "marketingforfood.com", true },
  { "marketinggenerators.nl", true },
  { "marketingtrendnews.com", true },
  { "marketingvirtuales.com", true },
  { "marketizare.ro", true },
  { "marketlinks.org", true },
  { "marketnsight.com", true },
  { "markfordelegate.com", true },
  { "markhaehnel.de", true },
  { "markhenrick.site", true },
  { "markholden.guru", true },
  { "markhoodphoto.com", true },
  { "markido.com", true },
  { "markitzeroday.com", true },
  { "markkirkforillinois.com", true },
  { "markkirkforsenate.com", true },
  { "marklauman.ca", true },
  { "markoh.co.uk", true },
  { "markom.rs", true },
  { "markprof.ru", true },
  { "markri.nl", true },
  { "markridgwell.co.uk", true },
  { "markridgwell.com", true },
  { "markridgwellcom.appspot.com", true },
  { "markrobin.de", true },
  { "markscastles.co.uk", true },
  { "marksm.it", true },
  { "marksmanhomes.com", true },
  { "marksmit.co", true },
  { "marksouthall.com", true },
  { "markspres.org", true },
  { "markstickley.co.uk", true },
  { "markt-heiligenstadt.de", false },
  { "marktcontact.com", true },
  { "marktissink.nl", true },
  { "markup-ua.com", true },
  { "markus-blog.de", true },
  { "markus-dev.com", true },
  { "markus-keppeler.de", true },
  { "markus-musiker.de", true },
  { "markus-ullmann.de", true },
  { "markus.design", true },
  { "markusehrlicher.de", true },
  { "markusgran.de", true },
  { "markuskeppeler.de", true },
  { "markuskeppeler.no-ip.biz", true },
  { "marl.fr", true },
  { "marloncommunications.com", true },
  { "marlonlosurdopictures.com", true },
  { "marlosoft.net", true },
  { "marmista.roma.it", true },
  { "marmolesromero.com", true },
  { "marmolrain.cl", true },
  { "marmotte.love", true },
  { "maroc-bivouac.com", true },
  { "marocemploi.co", true },
  { "marocmail.ma", true },
  { "marotero.com", true },
  { "marpa-wohnen.de", true },
  { "marqueswines.co.uk", true },
  { "marrai.de", true },
  { "marriage-shrine.jp", true },
  { "marrickvilleapartments.com.au", true },
  { "marsanvet.com", true },
  { "marseillekiteclub.com", true },
  { "marshallscastles.com", true },
  { "marshallwilson.com", true },
  { "marshmallow.co", true },
  { "marshmallow.com", true },
  { "marshyplay.live", true },
  { "marsikelektro.cz", true },
  { "martasibaja.com", true },
  { "martel-innovate.com", true },
  { "martelange.ovh", true },
  { "marten-buer.de", true },
  { "martensmxservice.nl", true },
  { "martensson.io", true },
  { "marti201.ga", true },
  { "martialarts-wels.at", true },
  { "martide.com", true },
  { "martiestrimsalon.nl", true },
  { "martijn.site", true },
  { "martijnhielema.nl", true },
  { "martijnvanderzande.nl", true },
  { "martin-loewer.de", true },
  { "martin-smith.info", true },
  { "martin.vet", true },
  { "martindimitrov.cz", true },
  { "martine.nu", true },
  { "martineweitweg.de", true },
  { "martinfranc.eu", true },
  { "martinkus.eu", true },
  { "martinmuc.de", true },
  { "martinreed.net", true },
  { "martinvillalba.com", true },
  { "martinvillalba.com.ar", true },
  { "martinvillalba.info", true },
  { "martinvillalba.net", true },
  { "martinvillalba.org", true },
  { "martonmihaly.hu", true },
  { "martynhare.co.uk", true },
  { "martynhare.uk", true },
  { "maru-life.com", true },
  { "maruhoi.com", true },
  { "marustat.ru", true },
  { "marvelmoviemarathon.com", true },
  { "marxmyths.org", true },
  { "marycliffpress.com", true },
  { "maryeclark.com", true },
  { "maryeileen90.party", true },
  { "maryhaze.net", true },
  { "maryjaneroach.com", true },
  { "maryjruggles.com", true },
  { "marykatrinaphotography.com", true },
  { "marylandbasementandcrawlspacewaterproofing.com", true },
  { "marzio.co.za", true },
  { "masarik.sh", true },
  { "masatotaniguchi.jp", true },
  { "masautonomo.com", true },
  { "masayahost.com", true },
  { "mascosolutions.com", true },
  { "masdillah.com", true },
  { "maservant.net", true },
  { "mashandco.it", true },
  { "mashandco.tv", true },
  { "masiniunelte.store.ro", true },
  { "masiul.is", true },
  { "maskim.fr", true },
  { "maslin.io", true },
  { "masrur.org", true },
  { "massaboutique.com", true },
  { "massage-colleges.com", true },
  { "massage-vitalite.fr", true },
  { "massage4u.net", true },
  { "massagecupping.com", true },
  { "massagetainha-hanoi.com", true },
  { "massdrop.com", true },
  { "masse.org", true },
  { "massflix.com", true },
  { "massfone.com", true },
  { "masshiro.blog", true },
  { "massive.tk", true },
  { "massoni.pl", true },
  { "massotherapeutique.com", true },
  { "massvow.com", true },
  { "masta.ch", true },
  { "mastafu.info", true },
  { "mastah.fr", true },
  { "mastd.me", false },
  { "mastellone.us", true },
  { "mastepinnelaand.nl", true },
  { "master-net.org", true },
  { "mastercardpac.com", true },
  { "masterdemolitioninc.com", true },
  { "masterdigitale.com", true },
  { "masterhelenaroma.com", true },
  { "masterofallscience.com", true },
  { "masterofbytes.ch", true },
  { "masterpc.co.uk", true },
  { "masterplc.com", true },
  { "masters.black", true },
  { "masterstuff.de", true },
  { "mastodon.at", true },
  { "mastodon.host", true },
  { "mastodon.rocks", true },
  { "mastodon.top", true },
  { "mat.tt", true },
  { "matanz.de", true },
  { "matatabimix.com", true },
  { "matatall.com", true },
  { "matbad.de", true },
  { "match.audio", true },
  { "matcha-iga.jp", true },
  { "matchatea24.com", true },
  { "matchboxdesigngroup.com", true },
  { "matdogs.com", true },
  { "matejgroma.com", true },
  { "matel.org", true },
  { "materassi.roma.it", true },
  { "materiaischiquinho.com.br", true },
  { "material-ui.com", true },
  { "material-world-fuyouhin.com", true },
  { "materialism.com", true },
  { "materialyinzynierskie.pl", true },
  { "maternalsafety.org", true },
  { "maternum.com", true },
  { "mateuszchyla.pl", true },
  { "math-colleges.com", true },
  { "math.hamburg", true },
  { "mathalexservice.info", true },
  { "mathematik.rocks", false },
  { "mathembedded.com", true },
  { "matheo-schefczyk.de", true },
  { "matheusmacedo.ddns.net", true },
  { "mathfinder.org", true },
  { "mathhire.org", true },
  { "mathias.is", true },
  { "mathiasbynens.be", true },
  { "mathiasgarbe.de", true },
  { "mathiaswagner.org", true },
  { "mathieuguimond.com", true },
  { "mathieui.net", true },
  { "mathis.com.tr", true },
  { "maths.network", true },
  { "mathsource.ga", true },
  { "mathspace.co", true },
  { "mathsweek.nz", true },
  { "mathsweek.org.nz", true },
  { "mathsweek.school.nz", true },
  { "mathys.io", true },
  { "matildajaneclothing.com", true },
  { "matjaz.it", true },
  { "matlss.com", true },
  { "matok.me.uk", true },
  { "matome-surume.com", true },
  { "matomeathena.com", true },
  { "matoutepetiteboutique.com", true },
  { "matratzentester.com", true },
  { "matridiana.com", true },
  { "matrimoni.uk", true },
  { "matriterie-sdv.ro", true },
  { "matrixim.cc", true },
  { "matrixmedia.ro", true },
  { "matrixreq.com", true },
  { "matsu-semi.com", true },
  { "matsu-walk.com", true },
  { "matt-brooks.com", true },
  { "matt-royal.com.cy", true },
  { "matt-royal.gr", true },
  { "matt.re", true },
  { "mattandyana.com", true },
  { "mattari-app.com", true },
  { "mattatoio.eu", true },
  { "mattbagley.me", true },
  { "mattbsg.xyz", true },
  { "mattcarr.net", false },
  { "mattcoles.io", true },
  { "mattconstruction.com", true },
  { "mattcorp.com", true },
  { "mattdbarton.com", true },
  { "matteomarescotti.it", true },
  { "mattessons.co.uk", true },
  { "mattferderer.com", true },
  { "mattfin.ch", true },
  { "mattforster.ca", true },
  { "matthecat.com", true },
  { "matthewchapman.co.uk", false },
  { "matthewfells.com", true },
  { "matthewgallagher.co.uk", true },
  { "matthewgrow.com", true },
  { "matthewj.ca", true },
  { "matthewkenny.co.uk", true },
  { "matthewohare.com", true },
  { "matthewsetter.com", true },
  { "matthey.nl", true },
  { "matthi.coffee", true },
  { "matthias-muenzner.de", true },
  { "matthiasadler.info", true },
  { "matthiasbeck.com", true },
  { "matthiasheil.de", true },
  { "matthiasott.com", true },
  { "matthiasschwab.de", true },
  { "matthieuschlosser.fr", true },
  { "matthijssen.info", true },
  { "mattiascibien.net", true },
  { "mattlaks.com", true },
  { "mattli.us", true },
  { "mattmccutchen.net", true },
  { "mattmcshane.com", true },
  { "mattonline.me", true },
  { "mattprojects.com", true },
  { "mattwservices.co.uk", true },
  { "matviet.vn", true },
  { "matway.com", true },
  { "matway.net", true },
  { "matze.co", true },
  { "mauerwerkstag.info", true },
  { "mauldincookfence.com", true },
  { "mauran.me", true },
  { "maurice-walker.com", false },
  { "mauricedb.nl", true },
  { "maurovacca.com", true },
  { "maury-moteurs.com", true },
  { "mavenclinic.com", true },
  { "mavensecurity.com", true },
  { "maveris.com", true },
  { "mavobiz.at", true },
  { "mavobiz.de", true },
  { "mavoprax.at", true },
  { "mavoprax.de", true },
  { "mavora.at", true },
  { "mavora.de", true },
  { "mavotax.at", true },
  { "mavotax.de", true },
  { "mawidabp.com", true },
  { "mawidaca.com", true },
  { "mawo.olkusz.pl", true },
  { "max-moeglich.de", true },
  { "max-went.pl", true },
  { "max.gov", true },
  { "maxb.fm", true },
  { "maxbeenen.de", true },
  { "maxbruckner.de", true },
  { "maxbruckner.org", true },
  { "maxchan.info", true },
  { "maxdev72.freeboxos.fr", true },
  { "maxh.me.uk", true },
  { "maxhamon.ovh", true },
  { "maxhoechtl.at", true },
  { "maximdeboiserie.be", true },
  { "maximdens.be", true },
  { "maximeferon.fr", true },
  { "maximilian-graf.de", true },
  { "maximilian-greger.com", true },
  { "maximiliankaul.de", true },
  { "maximiliankrieg.de", true },
  { "maxims-travel.com", true },
  { "maxinesbydennees.com", true },
  { "maxipcalls.com", true },
  { "maxisito.it", true },
  { "maxkaul.de", true },
  { "maxmatthe.ws", true },
  { "maxmilton.com", true },
  { "maxmind.com", true },
  { "maxp.info", true },
  { "maxpl0it.com", true },
  { "maxr1998.de", true },
  { "maxrandolph.com", true },
  { "maxtruxa.com", true },
  { "maxundlara.at", true },
  { "maxwaellenergie.de", true },
  { "maxwell-english.co.jp", false },
  { "maxwellflynn.com", true },
  { "maxwellmoore.co.uk", true },
  { "may24.tw", true },
  { "mayaimplant.com", true },
  { "mayavi.co.in", true },
  { "maydex.info", true },
  { "mayerbrownllz.com", true },
  { "mayoimobiliare.ro", true },
  { "mayomarquees.com", true },
  { "mayopartyhire.com", true },
  { "maypolevilla.co.uk", true },
  { "mayrhofer.eu.org", true },
  { "mazda-mps.de", true },
  { "mazda-thermote.com", true },
  { "mazda626.net", true },
  { "mazdaofgermantown.com", true },
  { "maze.design", false },
  { "maze.fr", true },
  { "mazenjobs.com", true },
  { "mazternet.ru", true },
  { "mazurlabs.tk", true },
  { "mazzotta.me", true },
  { "mb-is.info", true },
  { "mbaasy.com", true },
  { "mbaestlein.de", true },
  { "mbainflatables.co.uk", true },
  { "mbanq.com", true },
  { "mbardot.com", true },
  { "mbasic.facebook.com", false },
  { "mbcars.be", true },
  { "mbda.gov", false },
  { "mbeo.ch", true },
  { "mbilker.us", true },
  { "mbinf.de", false },
  { "mbits.solutions", true },
  { "mbk.net.pl", true },
  { "mblankhorst.nl", true },
  { "mble.mg", true },
  { "mbmcatering.com", true },
  { "mbp.banking.co.at", false },
  { "mbr-net.de", true },
  { "mbrooks.info", true },
  { "mbs-journey.com", true },
  { "mburaks.com", true },
  { "mburns.duckdns.org", true },
  { "mbweir.com", true },
  { "mbwis.net", true },
  { "mc-jobs.net", true },
  { "mc-ruempel-firmen-und-haushaltsaufloesungen.de", true },
  { "mc-venture.net", false },
  { "mc4free.cc", true },
  { "mcatnnlo.org", true },
  { "mccarty.io", false },
  { "mccoolesredlioninn.com", true },
  { "mccordsvillelocksmith.com", true },
  { "mccrackon.com", true },
  { "mcculloughjchris.com", true },
  { "mcdermottautomotive.com", true },
  { "mcdonalds.be", true },
  { "mcdonalds.design", true },
  { "mce.eu", true },
  { "mce.nyc", true },
  { "mce55.eu", true },
  { "mcea-hld.jp", true },
  { "mceconferencecentre.eu", true },
  { "mcfedries.com", true },
  { "mcfipvt.com", true },
  { "mcfx.us", true },
  { "mcgaccountancy.co.uk", true },
  { "mcgarderen.nl", true },
  { "mcgovernance.com", true },
  { "mchel.net", true },
  { "mchopkins.net", true },
  { "mchristopher.com", true },
  { "mchuiji.com", true },
  { "mcinterface.de", true },
  { "mcit.gov.ws", true },
  { "mcivor.me", true },
  { "mckenry.net", false },
  { "mckernan.in", true },
  { "mckinley.school", true },
  { "mcl.de", false },
  { "mclinflatables.co.uk", true },
  { "mclmotors.co.uk", true },
  { "mcmillansedationdentistry.com", false },
  { "mcmillanskiclub.com.au", true },
  { "mcneill.io", true },
  { "mcnext.net", true },
  { "mcon.se", true },
  { "mcpaoffice.com", true },
  { "mcpart.land", true },
  { "mcplayman.de", true },
  { "mcpro.games", true },
  { "mcprocdn.com", true },
  { "mcrn.jp", true },
  { "mcsinflatables.co.uk", true },
  { "mcsports.es", true },
  { "mcsrvstat.us", true },
  { "mctools.org", true },
  { "mcuuid.net", true },
  { "mcversions.net", true },
  { "mcynews.com", true },
  { "mcyukon.com", true },
  { "md-clinica.com.ua", true },
  { "md5file.com", true },
  { "md5hashing.net", true },
  { "mdazo.net", true },
  { "mdbouncycastlehirelondon.co.uk", true },
  { "mdcloudpracticesolutions.com", true },
  { "mdcloudps.com", true },
  { "mdek.at", true },
  { "mdewendt.de", true },
  { "mdf-bis.com", true },
  { "mdg-online.de", true },
  { "mdiv.pl", true },
  { "mdkr.nl", true },
  { "mdlayher.com", true },
  { "mdma.net", true },
  { "mdmed.clinic", true },
  { "mdoering.de", true },
  { "mdosch.de", true },
  { "mdpraha.cz", true },
  { "mdrthmcs.io", true },
  { "mds-paris.com", true },
  { "mdsave.com", true },
  { "mdx.no", true },
  { "mdxdave.de", true },
  { "mdxn.org", true },
  { "mdzservers.com", true },
  { "me-center.com", true },
  { "me-groups.com", true },
  { "me-soft.nl", true },
  { "me.net.nz", true },
  { "meadowfen.farm", true },
  { "meadowfenfarm.com", true },
  { "mealgoo.com", true },
  { "meamod.com", false },
  { "meany.xyz", true },
  { "meap.xyz", true },
  { "measureyourpenis.today", true },
  { "meat.org.uk", true },
  { "mebaneattorney.com", true },
  { "mebanesteakhouse.com", true },
  { "mecanicoautomotriz.org", true },
  { "mecaniquemondor.com", true },
  { "mechanics-schools.com", true },
  { "mechanus.io", true },
  { "mechaspartans6648.com", true },
  { "mechmk1.me", true },
  { "med-colleges.com", true },
  { "med-otzyv.ru", true },
  { "med360.at", true },
  { "medba.se", true },
  { "medcir.com.br", true },
  { "medcrowd.com", true },
  { "meddelare.com", true },
  { "meddigital.com", false },
  { "mede-handover.azurewebsites.net", true },
  { "medecine-esthetique-du-calaisis.fr", true },
  { "medeinos.lt", true },
  { "medellinapartamentos.com", true },
  { "medexpress.co.uk", true },
  { "medhy.fr", true },
  { "medi-link.co.il", true },
  { "medi.com.br", true },
  { "media-credit.eu", true },
  { "media-instance.ru", true },
  { "media-library.co.uk", true },
  { "media-pi.com", true },
  { "media-service.fr", true },
  { "media-serwis.com", true },
  { "mediaarea.net", true },
  { "mediabackoffice.co.jp", true },
  { "mediablaster.com", true },
  { "mediabm.jp", true },
  { "mediabogen.net", true },
  { "mediaburst.co.uk", true },
  { "mediadex.be", true },
  { "mediaexpert.fr", true },
  { "mediafly.com", true },
  { "mediafocus.biz", true },
  { "mediagenic.ch", true },
  { "mediagold.it", true },
  { "mediagrand.net", true },
  { "mediahaus.de", true },
  { "mediajurnal.com", true },
  { "medialab.nrw", true },
  { "mediamarkt.pl", true },
  { "mediapart.fr", true },
  { "mediapath.gr", true },
  { "mediarithmics.com", true },
  { "mediarithmics.io", true },
  { "mediarocks.de", true },
  { "mediaselection.eu", true },
  { "mediathekview.de", true },
  { "mediationculturelleclp.ch", true },
  { "mediatorzy.waw.pl", true },
  { "mediaukkies.nl", true },
  { "mediavault.tech", true },
  { "mediawijsheid.nl", true },
  { "mediawijzer.net", true },
  { "mediawiki.org", true },
  { "mediawin.pl", true },
  { "medic-world.com", true },
  { "medical-assistant-colleges.com", true },
  { "medicalabroad.org", true },
  { "medicalcountermeasures.gov", true },
  { "medicare-providers.net", true },
  { "medicarecoveragefinder.com", true },
  { "medicareinfo.org", true },
  { "medicinesfast.com", false },
  { "medicinia.com.br", true },
  { "medicocompetente.it", true },
  { "medicoresponde.com.br", true },
  { "medienweite.de", true },
  { "medifi.com", true },
  { "medigap-quote.net", true },
  { "medik8.com.cy", true },
  { "medikalakademi.com.tr", true },
  { "medikuma.com", true },
  { "medino.com", true },
  { "medinside.ch", true },
  { "medinside.li", true },
  { "medinsider.ch", true },
  { "medinsider.li", true },
  { "medireport.fr", true },
  { "meditadvisors.com", true },
  { "meditel.nl", true },
  { "medium.com", true },
  { "medja.net", true },
  { "medlineplus.gov", true },
  { "medmarkt24.com", true },
  { "medo64.com", true },
  { "medovea.ru", true },
  { "medpeer.co.jp", true },
  { "medpeer.jp", true },
  { "medpics.com", true },
  { "medschat.com", true },
  { "medtalents.ch", true },
  { "medtehnika.ua", true },
  { "medusa.wtf", true },
  { "meduza.io", true },
  { "medvedikorenka.cz", true },
  { "medvet.com.es", true },
  { "medwaybouncycastlehire.co.uk", true },
  { "medyotan.ga", true },
  { "meeco.kr", true },
  { "meedoenhartvanwestbrabant.nl", true },
  { "meedoennoordkop.nl", false },
  { "meehle.com", true },
  { "meeko.cc", true },
  { "meereskunst.de", true },
  { "meerman.nl", true },
  { "meermantechnischburo.nl", true },
  { "meerutcake.com", true },
  { "meesteresmisty.nl", true },
  { "meet.google.com", true },
  { "meetawesomepeople.net", true },
  { "meetbot.fedoraproject.org", true },
  { "meetingapplication.com", true },
  { "meetingfriends.ch", true },
  { "meetingmanage.nl", true },
  { "meetingmanager.ovh", true },
  { "meetings2.com", true },
  { "meetmygoods.com", true },
  { "meetscompany.jp", true },
  { "meeusen-usedcars.be", true },
  { "meeztertom.nl", true },
  { "meg-a-bounce.co.uk", true },
  { "mega-byte.nl", true },
  { "mega-feeling.de", true },
  { "mega.co.nz", true },
  { "mega.nz", true },
  { "megablogging.org", true },
  { "megabounce.co.uk", true },
  { "megabounceni.co.uk", true },
  { "megabouncingcastles.com", true },
  { "megafilmesplay.net", true },
  { "megaflowers.ru", true },
  { "megagifs.de", true },
  { "megainflatables.co.uk", true },
  { "megakoncert90.cz", true },
  { "megamisja.pl", true },
  { "megamp3.eu", true },
  { "meganandmarc.us", true },
  { "meganreel.com", false },
  { "megapixel.cz", true },
  { "megaplan.cz", true },
  { "megaplan.ru", true },
  { "megaplonk.com", true },
  { "megarex.jp", true },
  { "megasslstore.com", true },
  { "megauction.tk", true },
  { "megaxchange.com", true },
  { "mego.cloud", true },
  { "megumico.net", true },
  { "megustariasaber.com", true },
  { "megztosidejos.lt", true },
  { "meh.is", true },
  { "mehalick.com", true },
  { "mehhh.xyz", true },
  { "mehmetakif.edu.tr", true },
  { "mehmetince.net", true },
  { "mehostdd.com", false },
  { "mehr-schulferien.de", true },
  { "mehrleben.at", true },
  { "mehrwert.de", true },
  { "meia.ir", true },
  { "meierhofer.net", true },
  { "meikan.moe", true },
  { "meillard-auto-ecole.ch", true },
  { "meilleur.info", true },
  { "mein-kuechenhelfer.de", true },
  { "mein-muehlhausen.bayern", true },
  { "mein-webportal.de", true },
  { "meinbetriebsrat24.de", true },
  { "meincenter-meinemeinung.de", true },
  { "meincoach.at", true },
  { "meine-email-im.net", true },
  { "meine-finanzanalyse.de", true },
  { "meine-immofinanzierung.de", true },
  { "meinezwangsversteigerung.de", true },
  { "meinstartinsleben.com", true },
  { "meinstartinsleben.de", true },
  { "meintragebaby.de", true },
  { "meinv.asia", true },
  { "meiqia.cn", true },
  { "meiqia.com", true },
  { "meisterlabs.com", true },
  { "meistertask.com", true },
  { "meitan.gz.cn", true },
  { "mekatro.tech", true },
  { "mekatrotekno.com", true },
  { "mekesh.com", true },
  { "mekesh.net", true },
  { "mekesh.ru", true },
  { "meklon.net", true },
  { "mekongeye.com", true },
  { "melaniebernhardt.com", true },
  { "melaniegruber.de", true },
  { "melbourne.dating", true },
  { "melbourneapartments.website", true },
  { "melchizedek-forum.de", true },
  { "meldcode-assistent.nl", true },
  { "melearning.university", false },
  { "melerpaine.com", true },
  { "melhoresdominios.com", true },
  { "melhoresmarcasdenotebook.com.br", true },
  { "melillaorienta.es", true },
  { "melina-schefczyk.de", true },
  { "melissaadkins.com", true },
  { "melissaauclaire.com", true },
  { "melissameuwszen.nl", true },
  { "melnessgroup.com", true },
  { "melnikov.ch", true },
  { "melodicprogressivehouse.com", true },
  { "melodiouscode.co.uk", true },
  { "melodiouscode.com", true },
  { "melodiouscode.net", true },
  { "melodiouscode.uk", true },
  { "melodrom.de", true },
  { "melopie.com", true },
  { "melted.me", true },
  { "members-arbourlake.com", true },
  { "members-only-shopping.com", true },
  { "members.nearlyfreespeech.net", false },
  { "membershipservices.org.uk", true },
  { "memberstweets.com", true },
  { "meme-photostudio.com.tw", true },
  { "meme.fi", true },
  { "meme.institute", true },
  { "memememememememe.me", true },
  { "memepasmal.net", true },
  { "memesbee.com", true },
  { "memfrob.org", true },
  { "memiux.com", true },
  { "memo-linux.com", true },
  { "memo.ee", true },
  { "memoire-resistance-ariege.fr", true },
  { "memorycards.ie", true },
  { "memoryex.net", true },
  { "memrise.com", true },
  { "menanwc.org", true },
  { "menden.com", true },
  { "mendipbouncycastles.co.uk", true },
  { "mendozagenevieve.com", true },
  { "mendy.jp", true },
  { "menielias.com", true },
  { "menkyo-blog.com", true },
  { "mennace.com", true },
  { "menole.com", true },
  { "menole.de", true },
  { "menole.net", true },
  { "menotag.com", true },
  { "mensagemaniversario.com.br", true },
  { "mensagemdaluz.com", true },
  { "mensagensaniversario.com.br", true },
  { "mensagensdeconforto.com.br", true },
  { "mensagensperfeitas.com.br", true },
  { "mensch-peter.me", true },
  { "mentalhealthmn.org", true },
  { "mentaltraining-fuer-musiker.ch", true },
  { "mentiq.az", true },
  { "mentz.info", true },
  { "menudieta.com", true },
  { "menuel.me", true },
  { "menuonlineordering.com", true },
  { "menzietti.it", true },
  { "mephedrone.org", true },
  { "meps.net", true },
  { "mer.gd", true },
  { "merakilp.com", true },
  { "meransuedtirol.com", true },
  { "meraseo.com", true },
  { "mercadobitcoin.com.br", true },
  { "mercadobitcoin.net", true },
  { "mercadoleal.com.br", true },
  { "mercadopago.com", true },
  { "mercamaris.es", true },
  { "mercari.com", true },
  { "mercedes-benz.io", true },
  { "mercedes-ig.de", true },
  { "mercedespartscenter.com", true },
  { "merchant-automotive.com", true },
  { "mercier-auto.com", true },
  { "mercier-cars.co.uk", true },
  { "mercredifiction.io", true },
  { "mercury.photo", true },
  { "mercuryamericas.com", false },
  { "meremeti-online.gr", true },
  { "meremobil.dk", true },
  { "merenbach.com", true },
  { "merenita.com", true },
  { "merenita.eu", true },
  { "merenita.net", true },
  { "merenita.nl", true },
  { "meric-graphisme.info", true },
  { "meridianfresno.com", true },
  { "meridianmetals.com", true },
  { "meridianstore.com.br", true },
  { "merkel.me", true },
  { "merlet.eu", true },
  { "merlinsoap.com", true },
  { "merloat.com", true },
  { "merojob.com", true },
  { "meronberry.jp", true },
  { "mers.one", true },
  { "merson.org", true },
  { "merson.tv", true },
  { "mertarauh.com", true },
  { "mertcangokgoz.com", true },
  { "meruri.com", true },
  { "mes-bouquins.fr", true },
  { "mes-finances.be", true },
  { "mes10doigts.ovh", true },
  { "mesappros.com", true },
  { "mescaline.com", true },
  { "mescaline.org", true },
  { "mesh.gov", true },
  { "meshok.info", true },
  { "mesicka.com", true },
  { "mesomeds.com", true },
  { "messagevortex.com", true },
  { "messagevortex.net", true },
  { "messdorferfeld.de", true },
  { "messenger.co.tz", true },
  { "messenger.com", true },
  { "messengerwebbrands.com", true },
  { "messer24.ch", true },
  { "messymom.com", true },
  { "mestazitrka.cz", true },
  { "mestr.es", true },
  { "mesvt.com", true },
  { "meta-db.com", true },
  { "meta-word.com", true },
  { "meta.sc", true },
  { "metachris.com", true },
  { "metacoda.com", true },
  { "metacode.biz", true },
  { "metadatawiki.com", true },
  { "metaether.net", true },
  { "metafurquest.net", true },
  { "metallosajding.ru", true },
  { "metalu.ch", true },
  { "metanic.services", true },
  { "metanodo.com", true },
  { "metapeen.nl", true },
  { "metasquare.com.au", true },
  { "metasquare.nyc", true },
  { "metasysteminfo.com", true },
  { "metaurl.io", true },
  { "metavetted.com", true },
  { "metaword.com", true },
  { "metaword.net", true },
  { "metaword.org", true },
  { "metebalci.com", false },
  { "meteenonline.nl", true },
  { "meteo-parc.com", true },
  { "meteo-r.ovh", true },
  { "meteobox.co", true },
  { "meteobox.cz", true },
  { "meteobox.de", true },
  { "meteobox.es", true },
  { "meteobox.fr", true },
  { "meteobox.mx", true },
  { "meteobox.pl", true },
  { "meteobox.sk", true },
  { "meteocat.net", true },
  { "meteorapp.space", true },
  { "meteorologiaenred.com", true },
  { "meteosherbrooke.com", true },
  { "meteosmit.it", true },
  { "meter.md", true },
  { "meterhost.com", true },
  { "methamphetamine.co.uk", true },
  { "methylone.com", true },
  { "metric.ai", true },
  { "metricmutt.com", true },
  { "metro-lawn-care.com", true },
  { "metro-web.net", true },
  { "metroairvirtual.com", true },
  { "metrobriefs.com", true },
  { "metrolush.com", true },
  { "metron-eging.com", true },
  { "metron-networks.com", true },
  { "metron-online.com", true },
  { "metronaut.de", true },
  { "metropop.ch", true },
  { "metsasta.com", true },
  { "mettekopp.dk", true },
  { "meu-solutions.com", true },
  { "meujeitodigital.com.br", false },
  { "meupainel.me", true },
  { "meurisse.org", true },
  { "mevo.xyz", true },
  { "mevs.cz", true },
  { "mexican.dating", true },
  { "mexicanjokes.net", true },
  { "mexico.sh", true },
  { "mexicom.org", true },
  { "meyash.co", true },
  { "mf-fischer.de", true },
  { "mfacko.cz", true },
  { "mfen.de", true },
  { "mfgusa.com", true },
  { "mfits.co.uk", true },
  { "mflodin.se", true },
  { "mfxbe.de", true },
  { "mfxxx.cn", true },
  { "mgi.gov", true },
  { "mgknet.com", true },
  { "mglink.be", true },
  { "mgrossklaus.de", true },
  { "mgrt.net", true },
  { "mgsisk.com", true },
  { "mgtbaas.eu", true },
  { "mhadot.com", true },
  { "mhalfter.de", true },
  { "mhand.org", true },
  { "mhatero.com", true },
  { "mhatlaw.com", true },
  { "mheistermann.de", true },
  { "mhermans.nl", true },
  { "mhi.web.id", true },
  { "mhjuma.com", true },
  { "mhmfoundationrepair.com", true },
  { "mi-beratung.de", true },
  { "mi-so-ji.com", true },
  { "mi80.com", true },
  { "miadennees.com", true },
  { "miagexport.com", true },
  { "mialquilerdecoches.com", true },
  { "miaonagemi.com", true },
  { "miaoubox.com", true },
  { "miaowo.org", true },
  { "miasarafina.de", true },
  { "miavierra.org", true },
  { "mibuiin.com", true },
  { "micado-software.com", true },
  { "micalodeal.ch", true },
  { "micbase.com", true },
  { "michadenheijer.com", true },
  { "michael-schefczyk.de", true },
  { "michael-schilling.de", true },
  { "michael-steinhauer.eu", true },
  { "michael.band", true },
  { "michaelasawyer.com", true },
  { "michaelband.co", true },
  { "michaelband.com", true },
  { "michaeleichorn.com", true },
  { "michaelhrehor.com", true },
  { "michaeliscorp.com", true },
  { "michaelismold.com", true },
  { "michaeljdennis.com", true },
  { "michaelkuchta.me", true },
  { "michaelleibundgut.com", true },
  { "michaelpelletterie.it", true },
  { "michaelpfrommer.de", true },
  { "michaelpfrommer.pub", true },
  { "michaelschmidt.ch", true },
  { "michaelschubert.com", true },
  { "michaelschule-rheine.de", true },
  { "michaelslatkine.com", true },
  { "michaelsnoeren.nl", true },
  { "michaelsweater.com", true },
  { "michaeltaboada.me", true },
  { "michaeltroger.com", true },
  { "michaeltruskowski.com", true },
  { "michaelwermeester.com", true },
  { "michal-s.net", true },
  { "michal-spacek.com", true },
  { "michal-spacek.cz", true },
  { "michalp.pl", true },
  { "michalspacek.com", true },
  { "michalspacek.cz", true },
  { "michalwiglasz.cz", true },
  { "michaonline.de", true },
  { "michel-wein.de", true },
  { "michele.ml", true },
  { "michellavat.com", true },
  { "michelskovbo.dk", true },
  { "michiganstateuniversityonline.com", true },
  { "michiganunionoptout.com", true },
  { "michmexguides.com.mx", true },
  { "michu.pl", true },
  { "mickelvaessen.com", true },
  { "micomi.co", true },
  { "miconcinemas.com", true },
  { "micopal.com", true },
  { "micr.io", true },
  { "micr0lab.org", true },
  { "microbiote-insectes-vecteurs.group", true },
  { "microco.sm", true },
  { "microcomploja.com.br", true },
  { "microdots.de", true },
  { "microlinks.org", true },
  { "microlog.org", true },
  { "micromata.de", true },
  { "microneedlingstudio.se", true },
  { "microsoftaffiliates.azurewebsites.net", true },
  { "microvb.com", true },
  { "microwesen.de", true },
  { "microzubr.com", true },
  { "midair.io", true },
  { "midasjewellery.com.au", true },
  { "midgawash.com", true },
  { "midislandrealty.com", true },
  { "midistop.org", true },
  { "midkam.ca", true },
  { "midlandgate.de", true },
  { "midlandleisuresales.co.uk", true },
  { "midlandroofingri.com", true },
  { "midlandsfundays.co.uk", true },
  { "midlandsphotobooths.co.uk", true },
  { "midlgx.com", true },
  { "midnight-visions.de", true },
  { "midnightmango.co.uk", true },
  { "midnightmango.de", true },
  { "midnightmechanism.com", true },
  { "midrandplumber24-7.co.za", true },
  { "midress.club", true },
  { "midstatebasement.com", true },
  { "midtowndentistry.com", true },
  { "midwestbloggers.org", true },
  { "midwestplus.com", true },
  { "midweststructuralrepair.com", true },
  { "miegl.com", true },
  { "miembarcacion.com", true },
  { "miemus.eu", true },
  { "mietwohnungen-vermietung.com", true },
  { "mieuxgrandir.ch", true },
  { "mieuxvivreadarvoy.fr", true },
  { "miffy.me", true },
  { "mig5.net", true },
  { "miggy.org", true },
  { "mightysighty.com", true },
  { "miguel.pw", true },
  { "migueldemoura.com", true },
  { "migueldominguez.ch", true },
  { "miguelgaton.es", true },
  { "miguelmartinez.ch", true },
  { "miguelmenendez.pro", true },
  { "miguelmoura.com", true },
  { "miguia.tv", true },
  { "mihnea.net", true },
  { "mijailovic.net", true },
  { "mijcorijneveld.nl", true },
  { "mijn-financien.be", true },
  { "mijnetickets.nl", false },
  { "mijnetz.nl", true },
  { "mijnkerstkaarten.be", true },
  { "mijnkinderkleding.com", true },
  { "mijnpartijhandel.nl", true },
  { "mijnreisoverzicht.nl", true },
  { "mijnstembureau.nl", true },
  { "mijntransacties.nl", true },
  { "mika.moe", true },
  { "mikadoe.nl", true },
  { "mikakalathil.ca", true },
  { "mikakalevi.com", true },
  { "mikalikes.men", true },
  { "mike-bland.com", true },
  { "mike2k.de", true },
  { "mikebelanger.ca", true },
  { "mikeblog.site", true },
  { "mikebutcher.ca", true },
  { "mikecb.org", true },
  { "mikegarnett.co.uk", true },
  { "mikegerwitz.com", true },
  { "mikeguy.co.uk", true },
  { "mikehamburg.com", true },
  { "mikehilldesign.co.uk", true },
  { "mikekreuzer.com", true },
  { "mikerichards.photography", true },
  { "miketabor.com", true },
  { "miketheuer.com", true },
  { "mikevesch.com", true },
  { "mikewest.org", true },
  { "mikewillia.ms", true },
  { "mikewritesstuff.com", true },
  { "mikeybailey.org", true },
  { "mikhirev.ru", true },
  { "mikhlevich.ru", true },
  { "miki-boras.de", true },
  { "miki.it", true },
  { "mikkelladegaard.dk", true },
  { "mikkelscheike.com", true },
  { "mikkelvej.dk", true },
  { "mikkonen.bio", true },
  { "miklcct.com", true },
  { "miknight.com", true },
  { "mikonmaa.fi", true },
  { "mikropixel.de", true },
  { "mikroskeem.eu", true },
  { "mikumaycry.com", true },
  { "mikupic.com", true },
  { "mikywow.eu", true },
  { "mil-spec.ch", true },
  { "mil0.com", true },
  { "milania.de", true },
  { "milanstephan.de", true },
  { "milcahsmusings.com", true },
  { "milchbuchstabe.de", true },
  { "mileme.com", true },
  { "milenaria.es", true },
  { "milesapart.dating", true },
  { "milhoazul.com.br", true },
  { "milionshop.sk", true },
  { "milkandcookies.ca", true },
  { "milkingit.co.uk", true },
  { "millanova.wedding", false },
  { "milldyke.com", true },
  { "milldyke.nl", true },
  { "millefleurs.eu", true },
  { "millennium-thisiswhoweare.net", true },
  { "millenniumweb.com", false },
  { "millersminibarns.com", true },
  { "millettable.com", true },
  { "millhousenchurch.com", true },
  { "million5.com", true },
  { "million6.com", true },
  { "million8.com", true },
  { "millionairegames.com", true },
  { "millions1.com", true },
  { "millions11.com", true },
  { "millions13.com", true },
  { "millions14.com", true },
  { "millions15.com", true },
  { "millions16.com", true },
  { "millions17.com", true },
  { "millions19.com", true },
  { "millions20.com", true },
  { "millions22.com", true },
  { "millions25.com", true },
  { "millions26.com", true },
  { "millions27.com", true },
  { "millions28.com", true },
  { "millions29.com", true },
  { "millions31.com", true },
  { "millions32.com", true },
  { "millions33.com", true },
  { "millions35.com", true },
  { "millions36.com", true },
  { "millions37.com", true },
  { "millions38.com", true },
  { "millions39.com", true },
  { "millions40.com", true },
  { "millions41.com", true },
  { "millions42.com", true },
  { "millions43.com", true },
  { "millions5.com", true },
  { "millions50.com", true },
  { "millions51.com", true },
  { "millions52.com", true },
  { "millions53.com", true },
  { "millions55.com", true },
  { "millions56.com", true },
  { "millions57.com", true },
  { "millions58.com", true },
  { "millions59.com", true },
  { "millions6.com", true },
  { "millions60.com", true },
  { "millions61.com", true },
  { "millions62.com", true },
  { "millions63.com", true },
  { "millions66.com", true },
  { "millions7.com", true },
  { "millions70.com", true },
  { "millions71.com", true },
  { "millions72.com", true },
  { "millions77.com", true },
  { "millions8.com", true },
  { "millions80.com", true },
  { "millions81.com", true },
  { "millions82.com", true },
  { "millions88.com", true },
  { "millions9.com", true },
  { "millions99.com", true },
  { "millistream.com", true },
  { "milnes.org", true },
  { "milsonhypnotherapyservices.com", true },
  { "mim.am", true },
  { "mimemo.io", true },
  { "mimemoriadepez.com", true },
  { "mimeo.digital", true },
  { "mimithedog.com", true },
  { "mimobile.website", true },
  { "mimocad.io", true },
  { "mimovrste.com", true },
  { "min-datorsupport.se", true },
  { "min-sky.no", true },
  { "minakov.pro", true },
  { "minakova.pro", true },
  { "minami.xyz", true },
  { "minamo.io", true },
  { "minaprine.com", true },
  { "mind-box.ch", true },
  { "mind-hochschul-netzwerk.de", true },
  { "mind-moves.es", true },
  { "mindatasupport.nu", true },
  { "mindatasupport.se", true },
  { "mindcoding.ro", true },
  { "mindercasso.nl", true },
  { "mindfactory.de", true },
  { "mindleaking.org", true },
  { "mindmeister.com", true },
  { "mindoktor.se", false },
  { "mindorbs.com", true },
  { "mindox.com.br", true },
  { "mindstretchers.co.uk", true },
  { "mine-craftlife.com", true },
  { "mine-pixl.de", true },
  { "mine260309.me", true },
  { "minebier.dk", true },
  { "minecraft-forum.eu", true },
  { "minecraft-server.eu", true },
  { "minecraftforum.de", true },
  { "minecraftforum.ovh", true },
  { "minecraftjson.com", true },
  { "minecraftstal.com", true },
  { "minehattan.de", true },
  { "minehub.de", true },
  { "minei.me", true },
  { "minenash.com", true },
  { "minepack.net", true },
  { "minepay.net", true },
  { "minepic.org", true },
  { "minepod.fr", true },
  { "minerstat.com", true },
  { "minerva2015.it", true },
  { "minesouls.fr", true },
  { "minetracker.dk", true },
  { "minez-nightswatch.com", false },
  { "minf3-games.de", true },
  { "minfin.gov.ua", true },
  { "mingky.net", true },
  { "mingram.net", true },
  { "mingtreerealty.com", true },
  { "mingwah.ch", true },
  { "minh.at", false },
  { "mini2.fi", true },
  { "minigames.com", true },
  { "miniglueck.net", true },
  { "minigolf-reisinger.com", true },
  { "minigolfandgames.co.uk", true },
  { "minikidz.es", true },
  { "minikneet.com", true },
  { "minilions.fr", true },
  { "minimal-apps.de", true },
  { "minimaltimer.com", true },
  { "minimayhemsoftplay.co.uk", true },
  { "minimbah.com.au", true },
  { "minimvc.com", true },
  { "miningtronics.com", true },
  { "ministeriumfuerinternet.de", true },
  { "minitruckin.net", true },
  { "minitrucktalk.com", true },
  { "minivaro.de", true },
  { "miniwallaby.com", true },
  { "minkymoon.jp", true },
  { "minnesotakinkyyouth.org", true },
  { "minnesotamathcorps.org", true },
  { "minnesotareadingcorps.org", true },
  { "minnit.chat", true },
  { "minobar.com", true },
  { "minorshadows.net", true },
  { "minpingvin.dk", true },
  { "minschuns.ch", true },
  { "mintclass.com", true },
  { "mintosherbs.com", true },
  { "mintrak2.com", true },
  { "mintse.com", true },
  { "minu.link", true },
  { "minube.co.cr", true },
  { "minutashop.ru", true },
  { "minux.info", true },
  { "mipapo.de", true },
  { "mipla.ch", true },
  { "miproximopaso.org", true },
  { "mipueblohoy.com", true },
  { "mipymesenlinea.com", true },
  { "mir.pe", true },
  { "mirabalphoto.es", true },
  { "miraheze.org", true },
  { "miraidenshi.com", true },
  { "miraiex.com", true },
  { "mirch.com", true },
  { "mirco-grams.de", true },
  { "mireiaseuba.com", true },
  { "mirepublic.co.nz", true },
  { "mireservaonline.es", true },
  { "mirfire.com", true },
  { "mirkofranz.de", true },
  { "mironet.cz", true },
  { "mirrorbot.ga", true },
  { "mirrorsedgearchive.de", true },
  { "mirshak.com", true },
  { "mirtes.cz", true },
  { "mirtouf.fr", true },
  { "misakacloud.net", true },
  { "misakiya.co.jp", true },
  { "misanci.cz", true },
  { "misclick.nl", true },
  { "mishkovskyi.net", true },
  { "misinstrumentos.com", true },
  { "miskatonic.org", true },
  { "misoji-resist.com", true },
  { "misol.kr", true },
  { "misrv.com", true },
  { "miss-inventory.co.uk", true },
  { "miss-platinum.net", true },
  { "miss.com.tw", true },
  { "missdream.org", true },
  { "misseguf.dk", true },
  { "missevent.pl", true },
  { "missguidedus.com", true },
  { "mission-orange.de", true },
  { "missionsgemeinde.de", true },
  { "missip.nl", true },
  { "missjoias.com.br", true },
  { "misskey.jp", true },
  { "misskey.site", true },
  { "misskey.xyz", true },
  { "missoy.me", true },
  { "misssex.de", true },
  { "missualready.com", true },
  { "missyou.link", true },
  { "mistacms.com", true },
  { "mister-matthew.de", true },
  { "mistreaded.com", true },
  { "mistybox.com", true },
  { "misupport.dk", true },
  { "misura.re", true },
  { "misuzu.moe", true },
  { "misxvenelantro.com", true },
  { "mit-dem-rad-zur-arbeit.de", true },
  { "mit-dem-rad-zur-uni.de", true },
  { "mit-uns.org", true },
  { "mita.me", true },
  { "mitabu.net", true },
  { "mitaines.ch", true },
  { "mitarbeitermotivation-anleitungen.de", true },
  { "mitchellhandymanservices.co.uk", true },
  { "mitchelmore.ca", true },
  { "mitdip-mit-group-ch.azurewebsites.net", true },
  { "miticobikes.com", true },
  { "mitigationcommission.gov", true },
  { "mitnetz-gas.de", true },
  { "mitnetz-strom.de", true },
  { "mitrax.com.br", true },
  { "mitre10.com.au", true },
  { "mitrecaasd.org", true },
  { "mitremai.org", true },
  { "mitrostudios.com", true },
  { "mitsu-szene.de", true },
  { "mitsukabose.com", true },
  { "mittagonggardencentre.com.au", true },
  { "mittagonghomestead.com.au", true },
  { "mittelunsachlich.de", true },
  { "mittenofficesystems.com", true },
  { "mitylite.com", true },
  { "mitzpettel.com", true },
  { "miui-germany.de", true },
  { "mivzak.im", true },
  { "mivzakim.biz", true },
  { "mivzakim.info", true },
  { "mivzakim.mobi", true },
  { "mivzakim.net", true },
  { "mivzakim.org", true },
  { "mivzakim.tv", true },
  { "miweb.cr", false },
  { "mixinglight.com", true },
  { "mixnshake.com", true },
  { "mixposure.com", true },
  { "mixrepairs.co.uk", true },
  { "mixtafrica.com", true },
  { "mixtape.moe", true },
  { "mixx.com.hk", true },
  { "miyatore.com", true },
  { "miyoshi-kikaku.com", true },
  { "miyugirls.com", true },
  { "mizipack.com", true },
  { "mizque.ch", true },
  { "mizu.coffee", true },
  { "mizucoffee.net", true },
  { "mizuho-trade.net", true },
  { "mj420.com", true },
  { "mjacobson.net", true },
  { "mjanja.ch", true },
  { "mjasm.org", true },
  { "mjec.net", true },
  { "mjlaurindo.pt", true },
  { "mjmedia.co.za", true },
  { "mjmnagy.info", true },
  { "mjscustomcreations.com.au", true },
  { "mjt.me.uk", true },
  { "mk89.de", true },
  { "mkaciuba.com", true },
  { "mkakh.com", true },
  { "mkasu.org", false },
  { "mkbouncycastles.co.uk", true },
  { "mkbouncyhire.co.uk", true },
  { "mkcert.org", true },
  { "mkchandler.com", true },
  { "mkd.mk", true },
  { "mkes.com", true },
  { "mkg-chirurgie-bruchsal.de", true },
  { "mkg-scherer.de", true },
  { "mkg-wiebelskirchen.de", true },
  { "mkhsoft.eu", true },
  { "mkimage.com", true },
  { "mkjl.ml", true },
  { "mkk.de", true },
  { "mkkkrc.ru", true },
  { "mklpedia.de", true },
  { "mkoppmann.at", true },
  { "mkpef.org", true },
  { "mksac.co.uk", true },
  { "mksdarchitects.com", true },
  { "mkse.com", true },
  { "mkset.ru", true },
  { "mktdigital.info", true },
  { "mktemp.org", true },
  { "mkuznets.com", true },
  { "mlarte.com", true },
  { "mlcnfriends.com", true },
  { "mlemay.com", true },
  { "mlmjam.com", true },
  { "mlp.ee", true },
  { "mlpvector.club", true },
  { "mlundberg.se", true },
  { "mlvbphotography.com", true },
  { "mlytics.com", true },
  { "mm404.com", true },
  { "mma-acareporting.com", true },
  { "mmalisz.com", true },
  { "mmaps.org", true },
  { "mmbb.org", true },
  { "mmin.us", false },
  { "mmmarco.com", true },
  { "mmmaximaliselmeny.hu", true },
  { "mmogah.com", true },
  { "mmonit.com", true },
  { "mms.is", true },
  { "mmt.my", true },
  { "mmucha.de", true },
  { "mncloud.de", true },
  { "mncr.nl", true },
  { "mnd.sc", true },
  { "mne.moe", true },
  { "mnedc.org", true },
  { "mnemonic.ninja", true },
  { "mnguyen.io", true },
  { "mnitro.com", true },
  { "mnium.de", true },
  { "mnml.art", true },
  { "mnml.jp", true },
  { "mnnknz.de", true },
  { "mnsure.org", true },
  { "mnt-tech.fr", true },
  { "mnt9.de", true },
  { "mo-journal.com", true },
  { "mo.nl", true },
  { "mo2021.de", true },
  { "moa.moe", true },
  { "moahmo.com", true },
  { "mobal.com", true },
  { "mobidea.com", true },
  { "mobifinans.ru", true },
  { "mobil-bei-uns.de", true },
  { "mobila-chisinau.md", true },
  { "mobilcom-debitel-empfehlen.de", true },
  { "mobilcom-debitel.de", true },
  { "mobile-holzofenpizza.de", true },
  { "mobile.united.com", false },
  { "mobile.usaa.com", false },
  { "mobile360.ph", true },
  { "mobilebingoclub.co.uk", true },
  { "mobilecasinoclub.co.uk", true },
  { "mobilecontractcomparison.com", true },
  { "mobilelooper.com", true },
  { "mobilemedics.com", true },
  { "mobileread.com", true },
  { "mobilesector.de", true },
  { "mobiletraff.co", true },
  { "mobiletry.com", true },
  { "mobilewikiserver.com", true },
  { "mobilinnov.it", true },
  { "mobilisation-generale.org", true },
  { "mobility-events.ch", true },
  { "mobilux.lv", true },
  { "mobio.net", true },
  { "mobiproj.com", true },
  { "mobisaar-cloud.de", true },
  { "mobius.network", true },
  { "mobobe.com", true },
  { "mobsender.com", true },
  { "mobycoders.com", true },
  { "moc.ac", true },
  { "mocarps.hk", true },
  { "mochanstore.com", true },
  { "mockerel.com", true },
  { "mococo.co.uk", true },
  { "modaexecutiva.com.br", true },
  { "modafinil.com", true },
  { "modafinil.wiki", true },
  { "modafo.com", true },
  { "modalogi.com", true },
  { "modav.org", true },
  { "modcasts.video", true },
  { "modding-forum.com", true },
  { "modding-welt.com", true },
  { "mode-hautnah.de", true },
  { "mode-individuell.de", true },
  { "modehaus-marionk.de", true },
  { "modelcase.co.jp", false },
  { "modelclub-draveil.eu", true },
  { "modelcube.com", true },
  { "modelisme-rc.net", true },
  { "modelisme-voiture-rc.fr", true },
  { "modelservis.cz", true },
  { "modemaille.com", true },
  { "modemchild.net", true },
  { "modeportaal.nl", true },
  { "moderatoren.org", true },
  { "moderatorenpool.org", true },
  { "modern-family.tv", true },
  { "modernapprenticeships.org", true },
  { "moderncoinmart.com", true },
  { "moderncommercialrealestate.com", true },
  { "modifiedmind.com", true },
  { "modistry.com", true },
  { "modistryusercontent.com", true },
  { "modmountain.com", true },
  { "modosaude.com.br", true },
  { "modul21.com", true },
  { "modul21.eu", true },
  { "module.market", true },
  { "modulex-gmbh.de", true },
  { "moe-max.jp", true },
  { "moebel-vergleichen.com", true },
  { "moechel.com", true },
  { "moeclue.com", true },
  { "moefactory.com", true },
  { "moehrke.cc", true },
  { "moekes.amsterdam", true },
  { "moeking.me", true },
  { "moellers.systems", true },
  { "moenew.top", true },
  { "moeqing.net", true },
  { "moetrack.com", true },
  { "moeyoo.net", true },
  { "mofohome.dyndns.org", true },
  { "moha-swiss.com", true },
  { "mohanmekap.com", true },
  { "mohela.com", true },
  { "mohr-maschinenservice.de", true },
  { "moin.jp", true },
  { "moipourtoit.ch", true },
  { "moipourtoit.com", true },
  { "moipourtoit.org", true },
  { "moisesbarrio.es", true },
  { "mojaknjiznica.com", false },
  { "mojarada.nl", true },
  { "mojavenissanofbarstowparts.com", true },
  { "mojeco2.cz", true },
  { "mojefedora.cz", true },
  { "mojilitygroup.com", true },
  { "mojizuri.com", true },
  { "mojnet.eu", true },
  { "mojnet.net", true },
  { "mojoco.co.za", true },
  { "mojzis.com", true },
  { "mojzis.cz", true },
  { "mojzisova.com", true },
  { "mok.pw", true },
  { "mokeedev.review", true },
  { "mokhtarmial.com", false },
  { "mokote.com", true },
  { "mokum-organics.com", false },
  { "molb.org", true },
  { "molecularbiosystems.org", true },
  { "molinero.xyz", true },
  { "mollaretsmeningitis.org", true },
  { "mollie.com", true },
  { "molokai.org", true },
  { "molti.hu", true },
  { "molun.net", false },
  { "molunerfinn.com", true },
  { "molwick.com", true },
  { "momentsofimpact.info", true },
  { "momentum.photos", true },
  { "momentumdash.com", true },
  { "momirfarooq.com", true },
  { "momjoyas.com", true },
  { "momo0v0.club", true },
  { "momozeit.de", true },
  { "momstableonline.com", true },
  { "momut.org", true },
  { "momy-genealogie.info", true },
  { "mon-partage.fr", true },
  { "mon-trafic.com", false },
  { "mon22.ch", true },
  { "mona-antenna.com", true },
  { "mona-dress.com", true },
  { "monachatdeco.com", true },
  { "monaco-automaten.de", true },
  { "monad.io", true },
  { "monakasatmasr.com", true },
  { "monalyse.com", true },
  { "monarchcleanersnc.com", true },
  { "monbudget.org", true },
  { "moncoach.ch", true },
  { "mondedesnovels.com", true },
  { "mondedie.fr", true },
  { "mondial-movers.nl", true },
  { "mondo-it.ch", true },
  { "moneni.com", true },
  { "moneybird.com", true },
  { "moneybird.nl", true },
  { "moneychangersoftware.com", true },
  { "moneycredit.eu", true },
  { "moneygo.se", true },
  { "moneyhouse.de", true },
  { "moneypark.ch", true },
  { "moneytoday.se", true },
  { "mongolieenfrance.fr", true },
  { "moniquedekermadec.com", true },
  { "moniquemunhoz.com.br", true },
  { "monitman.com", true },
  { "monitoring.kalisz.pl", true },
  { "monitzer.com", true },
  { "monix.io", true },
  { "monkay.de", true },
  { "monkeybusiness.agency", true },
  { "monkeydust.net", true },
  { "monkeyhill.us", true },
  { "monkeytek.ca", true },
  { "monkieteel.com", true },
  { "monlabs.com", true },
  { "monloyer.quebec", true },
  { "monnyonle.hu", true },
  { "mono.cafe", true },
  { "mono0x.net", true },
  { "monobank.no", true },
  { "monodukuri.com", true },
  { "monokoo.com", true },
  { "monolithapps.com", true },
  { "monolithindustries.com", true },
  { "monolithinteractive.com", true },
  { "monothesis.com", true },
  { "monotributo.online", true },
  { "monoworks.co.jp", true },
  { "monpc-pro.fr", true },
  { "monpermismoto.com", true },
  { "monpermisvoiture.com", true },
  { "monpetitforfait.com", true },
  { "monpetitmobile.com", true },
  { "monsieurbureau.com", true },
  { "monsieursavon.ch", true },
  { "monstermashentertainments.co.uk", true },
  { "monsterx.cn", true },
  { "montage-kaika.de", false },
  { "montagne-tendance.ch", true },
  { "montanasky.tv", true },
  { "montanteaesthetics.com", true },
  { "montanwerk.de", true },
  { "montarfotoaki.com", true },
  { "montas.io", true },
  { "montazer.net", true },
  { "montemanik.com", true },
  { "montenero.pl", true },
  { "montessori.edu.vn", true },
  { "montgomeryfirm.com", true },
  { "montgomerysoccer.net", true },
  { "montopolis.com", true },
  { "montpreveyres.ch", true },
  { "montredeal.fr", true },
  { "montsaintaignan.fr", true },
  { "montychristie.com", true },
  { "monzo.com", true },
  { "monzo.me", true },
  { "moo.la", true },
  { "moobo.co.jp", true },
  { "moodfoods.com", true },
  { "moodforsex.com", true },
  { "moodzshop.com", true },
  { "moojp.co.jp", true },
  { "moolah.rocks", true },
  { "moon.fish", true },
  { "moonagic.com", true },
  { "moonbench.xyz", true },
  { "moonbot.io", true },
  { "moonchart.co.uk", true },
  { "moondrop.org", true },
  { "moonkin.eu", true },
  { "moonmelo.com", true },
  { "moonraptor.co.uk", true },
  { "moonraptor.com", true },
  { "moonshyne.org", true },
  { "moontaj.com", true },
  { "moonvpn.org", true },
  { "moorewelliver.com", true },
  { "moorfunevents.co.uk", true },
  { "moorparkelectrical.com", true },
  { "moorparkelectrician.com", true },
  { "moorparkexteriorlighting.com", true },
  { "moorparklandscapelighting.com", true },
  { "moorparklighting.com", true },
  { "moorparkoutdoorlighting.com", true },
  { "mooselook.de", true },
  { "moosmann-moehrle.de", true },
  { "moot-info.co.za", true },
  { "moovablestorage.com", true },
  { "moparcraft.net", true },
  { "moparisthebest.com", true },
  { "moparisthebest.net", true },
  { "moparisthebest.org", true },
  { "moparscape.net", true },
  { "mopedreifen.de", false },
  { "mopie.de", true },
  { "mople71.cz", true },
  { "moppeleinhorn.de", true },
  { "moppy.org", true },
  { "morbatex.com", true },
  { "morbiceramicindustry.com", true },
  { "morbitzer.de", true },
  { "morbius.cz", true },
  { "morbotron.com", true },
  { "morchino.ch", true },
  { "morchstore.com", true },
  { "mordrum.com", true },
  { "more-hikkoshi.com", true },
  { "more-terrain.de", true },
  { "moreal.co", true },
  { "moreniche.com", true },
  { "morepablo.com", true },
  { "morepay.cn", true },
  { "moresw.com", true },
  { "morethanautodealers.com", true },
  { "morethancode.be", true },
  { "morethandigital.info", true },
  { "morganino.it", true },
  { "morgansjewelerspv.com", true },
  { "morgansleisure.co.uk", true },
  { "morgner.com", true },
  { "moritz-baestlein.de", true },
  { "moritztremmel.de", true },
  { "moriz.de", true },
  { "moriz.net", true },
  { "mormon-colleges.com", true },
  { "mormonleaks.io", true },
  { "morningcurve.com", true },
  { "morningstar.moe", true },
  { "morphy2k.io", true },
  { "morrisby.com", true },
  { "morteruelo.net", true },
  { "mortgagecalculator.biz", true },
  { "mortgagecentersmo.com", true },
  { "mortis.eu", true },
  { "mosaic-design.ru", true },
  { "mosaicadvisors.com", true },
  { "mosaicmarble.com", true },
  { "moscatalogue.net", true },
  { "moscow.dating", true },
  { "mosfet.cz", true },
  { "moshwire.com", true },
  { "mosin.org", true },
  { "moskeedieren.nl", true },
  { "mosos.de", true },
  { "mosquitojoe.com", true },
  { "mosscade.com", true },
  { "mosshi.be", true },
  { "mosstier.com", true },
  { "mostholynameofjesus.org", true },
  { "mostlyoverhead.com", true },
  { "motd.ch", true },
  { "motd.today", true },
  { "motekforce.link", true },
  { "motekforcelink.com", true },
  { "motekforcelink.eu", true },
  { "motekforcelink.nl", true },
  { "motekmedical.com", true },
  { "motekmedical.eu", true },
  { "motekmedical.nl", true },
  { "motekrysen.com", true },
  { "moteksystems.com", true },
  { "motezazer.fr", true },
  { "mothereff.in", false },
  { "motifstudio.com.ua", true },
  { "motionless.nl", true },
  { "motiweb.fr", true },
  { "motocollection.pl", true },
  { "motohell.com", true },
  { "motojato.com.br", true },
  { "motonauticaibiza.com", true },
  { "motoreflex.com", true },
  { "motorpointarenacardiff.co.uk", true },
  { "motorring.ru", true },
  { "motorsplus.com", false },
  { "motoryachtclub-radolfzell.de", true },
  { "motosikletevi.com", true },
  { "motostorie.blog", false },
  { "motovated.co.nz", true },
  { "motowilliams.com", true },
  { "motransportinfo.com", true },
  { "motstats.co.uk", true },
  { "moulinaparoles.ca", true },
  { "mountain-rock.ru", true },
  { "mountainactivitysection.org.uk", true },
  { "mountainchalet.blue", true },
  { "mountainroseherbs.com", true },
  { "mountainspringsrentals.ca", true },
  { "mountfarmer.de", true },
  { "mousepotato.uk", true },
  { "moutiezhaller.com", true },
  { "movacare.de", true },
  { "move.mil", true },
  { "moveltix.net", true },
  { "movember.com", false },
  { "movewellnesslab.com", true },
  { "movie-cross.net", true },
  { "movie-infos.net", true },
  { "movie1000.com", true },
  { "movie4kto.stream", true },
  { "movieboost.nl", true },
  { "moviedeposit.com", true },
  { "moviefreeze.com", true },
  { "movieguys.org", true },
  { "movienized.de", true },
  { "moviepilot.com", true },
  { "moviesetc.net", true },
  { "moviko.nz", true },
  { "movil.uno", true },
  { "moviltronix.com", true },
  { "movimento-terra.it", true },
  { "movinglogistics.nl", false },
  { "movingtohttps.com", true },
  { "movingtojapan.life", true },
  { "movlib.org", true },
  { "moy.cat", true },
  { "moyer.pub", true },
  { "moylen.eu", true },
  { "mozartgroup.hu", true },
  { "mozektevidi.net", true },
  { "mozilla.cz", true },
  { "mozzez.de", true },
  { "mpa-pro.fr", true },
  { "mpac.ca", false },
  { "mpc-hc.org", true },
  { "mpcompliance.com", true },
  { "mpetroff.net", true },
  { "mpg-universal.com", true },
  { "mpgaming.pro", true },
  { "mpkrachtig.nl", true },
  { "mpkshop.com.br", true },
  { "mplanetphl.fr", true },
  { "mplant.io", true },
  { "mplicka.cz", true },
  { "mplusm.eu", true },
  { "mpnpokertour.com", true },
  { "mprsco.eu", true },
  { "mpsgarage.com.au", true },
  { "mpsoundcraft.com", true },
  { "mpu-vorbereitung.com", true },
  { "mr-anderson.org", true },
  { "mr-designer-oman.com", true },
  { "mr-nachhilfe.de", true },
  { "mr-wolf.nl", false },
  { "mrbmafrica.com", true },
  { "mrbounce.com", true },
  { "mrbouncescrazycastles.co.uk", true },
  { "mrbouncycastle.com", true },
  { "mrbuckykat.com", true },
  { "mrca-sharp.com", true },
  { "mrcoolevents.com", true },
  { "mrd.ninja", true },
  { "mrdayman.com", true },
  { "mremallin.ca", true },
  { "mrevolution.eu", true },
  { "mrgasfires.co.uk", true },
  { "mrgiveaways.com", true },
  { "mrhc.ru", true },
  { "mrinalpurohit.in", true },
  { "mrjhnsn.com", true },
  { "mrjooz.com", true },
  { "mrkapowski.com", true },
  { "mrketolocksmith.com", true },
  { "mrknee.gr", true },
  { "mrkrabat.de", true },
  { "mrnh.de", true },
  { "mrning.com", true },
  { "mrprintables.com", true },
  { "mrs-labo.jp", true },
  { "mrs-shop.com", true },
  { "mrsbairds.com", false },
  { "mrserge.lv", true },
  { "mrsk.me", true },
  { "mrstat.co.uk", true },
  { "mrtunnel.club", true },
  { "mruczek.ga", true },
  { "mrv.li", true },
  { "mrx.one", true },
  { "mrxn.net", true },
  { "ms-ch.ch", true },
  { "ms-host.fr", true },
  { "msa-aesch.ch", true },
  { "mscc.mu", true },
  { "mscc.org", true },
  { "mscenter.cf", true },
  { "msch.pw", true },
  { "mschuessler.org", true },
  { "msebera.cz", true },
  { "msh100.uk", true },
  { "mshemailmarketer.com.au", true },
  { "msi-zlin.cz", true },
  { "msiegmund.com", true },
  { "msize48.ch", true },
  { "msmails.de", true },
  { "msno.no", true },
  { "msnr.net", true },
  { "mspsocial.net", true },
  { "msquadrat.de", true },
  { "msroot.de", true },
  { "mssora.com", true },
  { "mssys.de", true },
  { "mstdn.blue", true },
  { "mstdn.club", true },
  { "mstdn.fr", true },
  { "mstdn.io", true },
  { "mstdn.onl", false },
  { "msuna.net", true },
  { "msv-limpezas.pt", true },
  { "msx.org", true },
  { "mszavodumiru.cz", true },
  { "mt-bank.jp", true },
  { "mt.search.yahoo.com", false },
  { "mt2414.com", true },
  { "mta.fail", true },
  { "mta.org.ua", true },
  { "mtane0412.com", true },
  { "mtasa.com", true },
  { "mtasa.hu", true },
  { "mtauburnassociates.com", true },
  { "mtb.wtf", true },
  { "mtcq.jp", true },
  { "mtd.org", true },
  { "mtg-tutor.de", true },
  { "mtgeni.us", true },
  { "mtgenius.com", true },
  { "mtgsuomi.fi", true },
  { "mthode.org", true },
  { "mthrbrd.com", true },
  { "mthrbrd.net", true },
  { "mths.be", false },
  { "mticareportal.com", true },
  { "mtiryaki.com", true },
  { "mtlconcerts.com", true },
  { "mtltransport.com", true },
  { "mtnz.co.za", true },
  { "mtouch.facebook.com", false },
  { "mtravelers.net", true },
  { "mtrip.com", true },
  { "mtrock.ru", true },
  { "mts-energia.eu", true },
  { "mts-server.com", true },
  { "mtsolar.es", true },
  { "mu.search.yahoo.com", false },
  { "muabannhanh.com", false },
  { "muahahahaha.co.uk", true },
  { "mubiflex.nl", true },
  { "muckingabout.eu", true },
  { "muckrack.com", true },
  { "mucmail.de", true },
  { "muctool.de", true },
  { "mud-status.de", true },
  { "mudbenesov.cz", true },
  { "mudcrab.us", false },
  { "muehlemann.net", true },
  { "muelhau.pt", true },
  { "muell-weg.de", true },
  { "muellapp.com", true },
  { "muenchberger.com", true },
  { "mufibot.net", true },
  { "muguayuan.com", true },
  { "muh.io", true },
  { "mui.jp", true },
  { "muitadica.com", true },
  { "mujerfutura.com", true },
  { "muk-kobetsu.com", true },
  { "mukilteodentalarts.com", true },
  { "mukilteoeuropeanautorepair.com", true },
  { "mulaccosmetics.com", true },
  { "mulaisehat.com", true },
  { "mulej.net", true },
  { "muling.lu", true },
  { "mullens-usedcars.be", true },
  { "multi-vpn.biz", true },
  { "multibit.org", true },
  { "multibomasm.com.br", true },
  { "multicomhost.com", true },
  { "multigamecard.com", true },
  { "multigeist.de", true },
  { "multikalender.de", false },
  { "multimail.work", true },
  { "multimatte.com", false },
  { "multimed.krakow.pl", true },
  { "multimedia-pool.com", true },
  { "multiplayernow.com", true },
  { "multipleservers.com", true },
  { "multiplexcy.com", true },
  { "multirep.ch", true },
  { "multiroom-streaming.de", true },
  { "multisite.ovh", true },
  { "multitec.nl", true },
  { "multitek.no", true },
  { "multitenantlaravel.com", true },
  { "multitheftauto.com", true },
  { "multrier.fr", true },
  { "mum.ceo", true },
  { "mumakil.fi", true },
  { "mumbaionlinegifts.com", true },
  { "muminkoykiran.com", true },
  { "mumolabs.com", true },
  { "munch.me", true },
  { "munchcorp.com", true },
  { "mundoarabe.com.br", true },
  { "mundoconejos.com", true },
  { "mundodapoesia.com", true },
  { "mundodasmensagens.com", true },
  { "mundodoscarbonos.com.br", true },
  { "mundogamers.top", true },
  { "mundokinderland.com.br", true },
  { "mundolarraz.es", true },
  { "mundomagicotv.com", true },
  { "mundoperros.es", true },
  { "mundotortugas.com", true },
  { "mundschenk.at", true },
  { "mundtec.com.br", true },
  { "munduch.cz", true },
  { "munduch.eu", true },
  { "munirajiwa.com", true },
  { "munki.org", true },
  { "munkibuilds.org", true },
  { "munwr.com", true },
  { "muqu.co", true },
  { "mur-vegetal-interieur.fr", true },
  { "murakami-sah.com", true },
  { "murashun.jp", true },
  { "muratore-roma.it", true },
  { "murfy.nz", true },
  { "murmel.it", false },
  { "murof.com.br", true },
  { "murray.xyz", true },
  { "murraya.cn", true },
  { "murzik.space", true },
  { "musa.gallery", true },
  { "musaccostore.com", true },
  { "muscle-tg.com", true },
  { "musclecarresearch.com", true },
  { "muscolinomusic.com", true },
  { "musehelix.com", true },
  { "muses-success.info", true },
  { "musettishop.com", true },
  { "mush-room.co.jp", true },
  { "mushfiqweb.com", true },
  { "mushikabu.net", true },
  { "music-is-my-life.de", true },
  { "music-project.eu", true },
  { "music-world.pl", true },
  { "music.amazon.com", true },
  { "musica.com", true },
  { "musicalive.nl", true },
  { "musicall.com", true },
  { "musicalschwarzenburg.ch", true },
  { "musicapara.net", true },
  { "musicasbr.com.br", true },
  { "musicchris.de", true },
  { "musicdemons.com", true },
  { "musicfromgod.com", true },
  { "musicgamegalaxy.de", true },
  { "musician.dating", true },
  { "musickhouseleveling.com", true },
  { "musicompare.com", true },
  { "musicschoolonline.com", true },
  { "musicstudio.pro", true },
  { "musicwear.cz", true },
  { "musicworkout.de", true },
  { "musik-mentaltraining.ch", true },
  { "musikverein-elten.de", true },
  { "musikzentrale.net", true },
  { "musique2nuit.com", true },
  { "musketonhaken.nl", false },
  { "muslim.singles", true },
  { "musmann.io", true },
  { "muspla.com", true },
  { "muspla.com.br", true },
  { "musselsblog.com", true },
  { "mustafa.space", true },
  { "mustafaturhan.com", true },
  { "mustard.co.uk", true },
  { "mustardking.me", true },
  { "mustasj.no", true },
  { "mustat.com", true },
  { "muster-folien.de", true },
  { "muster-schablonen.de", true },
  { "mustertexte-musterbewerbung.de", true },
  { "musthavesforreal.com", true },
  { "mutantmonkey.in", true },
  { "mutantmonkey.info", true },
  { "mutantmonkey.sexy", true },
  { "muthai.in.th", true },
  { "mutuals.cool", true },
  { "mutuelle.fr", true },
  { "muurlingoogzorg.nl", true },
  { "muusikoiden.net", true },
  { "muwatenraqamy.org", true },
  { "muz2u.ru", true },
  { "muzeumkomiksu.eu", true },
  { "muzhijy.com", false },
  { "muzikantine.nl", true },
  { "mv-schnuppertage.de", true },
  { "mv-wohnen.de", true },
  { "mvandek.nl", true },
  { "mvbits.com", true },
  { "mvisioncorp.com", true },
  { "mvistatic.com", true },
  { "mvno.io", true },
  { "mvp-stars.com", true },
  { "mw.search.yahoo.com", false },
  { "mwainc.org", true },
  { "mwalz.com", true },
  { "mware-staging.azurewebsites.net", true },
  { "mwavuli.co.ke", true },
  { "mwba.org", true },
  { "mwe.st", true },
  { "mwezi-foundation.org", true },
  { "mwezi.org", true },
  { "mwtdev.se", true },
  { "mww.moe", true },
  { "mx-quad.fr", true },
  { "mx.org.ua", true },
  { "mx.search.yahoo.com", false },
  { "mx5international.com", true },
  { "mxdanggui.org", true },
  { "mxihan.xyz", true },
  { "mxn8.com", true },
  { "my-aftershave-store.co.uk", true },
  { "my-best-wishes.com", true },
  { "my-cdn.de", true },
  { "my-contract.ch", true },
  { "my-contract.info", true },
  { "my-contract.net", true },
  { "my-dns.co.il", true },
  { "my-ebook.es", true },
  { "my-floor.com", true },
  { "my-gode.fr", true },
  { "my-host.ovh", true },
  { "my-hps.de", true },
  { "my-ip.work", true },
  { "my-new-bikini.de", true },
  { "my-nextcloud.at", true },
  { "my-stuff-online.com", true },
  { "my.onlime.ch", false },
  { "my.usa.gov", false },
  { "my.xero.com", false },
  { "my4g.net", true },
  { "my4thtelco.com.sg", true },
  { "my4thtelco.sg", true },
  { "myabcm.com", true },
  { "myaccount.google.com", false },
  { "myactivity.google.com", false },
  { "myadpost.com", true },
  { "myadself.com", true },
  { "myaggic.com", true },
  { "myalliancechurch.com", true },
  { "myamend.com", true },
  { "myamihealth.com", true },
  { "myamity.info", true },
  { "myammo.ru", true },
  { "myanimelist.net", true },
  { "myapexcard.com", true },
  { "myaspenheights.com", true },
  { "mybagofcoffee.com", true },
  { "mybasementdoctor.com", true },
  { "mybb.com", true },
  { "mybb.de", true },
  { "mybeautyjobs.de", true },
  { "mybicc.org", true },
  { "myblockchain.cloud", true },
  { "mybloggedlife.com", true },
  { "mybodylife.com", true },
  { "mybon.at", false },
  { "mybonfire.com", true },
  { "myboothang.com", true },
  { "mybreastcancerjourney.com", true },
  { "mybus.ro", true },
  { "mybusiness.wien", true },
  { "mycamda.com", true },
  { "mycard.moe", true },
  { "mycareersfuture.sg", true },
  { "mycarwashers.com", true },
  { "mycc.be", true },
  { "mycieokien.info", false },
  { "mycinema.pro", true },
  { "mycircleworks.com", true },
  { "myclasscam.com", true },
  { "myclasscam.org", true },
  { "myclinicalstudybuddy.com", true },
  { "mycloud-system.com", true },
  { "mycofairtrade.com", true },
  { "mycompanion.cz", true },
  { "myconan.net", true },
  { "myconnect.cn", true },
  { "myconsulting.ch", true },
  { "mycookrecetas.com", true },
  { "mycr.eu", true },
  { "mycreativeartsconsulting.com", true },
  { "mycreativenook.com", true },
  { "mycreditcardcenter.com", true },
  { "mycrypnet.io", true },
  { "mycrypto.com", true },
  { "mycrystalgrove.com", true },
  { "mycuco.it", true },
  { "mycustomwriting.com", true },
  { "mydarkstar.net", true },
  { "mydatadoneright.eu", true },
  { "mydaywebapp.com", true },
  { "mydebian.in.ua", true },
  { "mydentalplan.gr", true },
  { "mydevolo.com", true },
  { "mydevolo.de", true },
  { "mydigitalweek.com", true },
  { "mydjsongbook.com", true },
  { "mydna.bio", true },
  { "mydoc.fr", true },
  { "mydocserve.com", true },
  { "mydomaindesk.com", true },
  { "mydreamlifelab.com", true },
  { "mydreamshaadi.in", true },
  { "mydroneservices.ca", true },
  { "mydroneservices.com", true },
  { "myeasybooking.de", true },
  { "myeberspaecher.com", true },
  { "myeffect.today", true },
  { "myeisenbahn.de", true },
  { "myetherwallet.com", true },
  { "myf.cloud", true },
  { "myfantasysportstalk.com", true },
  { "myfedloan.org", true },
  { "myfirenet.com", true },
  { "myfloridadeferredcomp.com", true },
  { "myforfaitmobile.com", true },
  { "myfreemp3.click", true },
  { "myfrenchtattoo.fr", true },
  { "myg21.com", true },
  { "mygadgetguardian.lookout.com", false },
  { "mygallery.homelinux.net", true },
  { "mygate.at", false },
  { "mygedit.com", true },
  { "mygeotrip.com", true },
  { "mygest.me", true },
  { "mygigabitnation.com", true },
  { "mygignation.com", true },
  { "mygirlfriendshouse.com", true },
  { "mygnmr.com", true },
  { "mygoldennetwork.com", true },
  { "mygreatjobs.de", true },
  { "mygreatlakes.org", true },
  { "mygretchen.de", true },
  { "mygrotto.org", true },
  { "mygymer.ch", true },
  { "myhatsuden.jp", true },
  { "myhealthreviews.com", true },
  { "myhollywoodnews.com", true },
  { "myhome-24.pl", true },
  { "myhostname.net", true },
  { "myhuthwaite.com", true },
  { "myimds.com", true },
  { "myimmitracker.com", true },
  { "myinvite.nl", true },
  { "myipaddr.de", true },
  { "myipv4.de", true },
  { "myjudo.net", true },
  { "myjumparoo.co.uk", true },
  { "myki.co", true },
  { "mykontool.de", true },
  { "mykumedir.com", true },
  { "mylatestnews.org", true },
  { "mylawyer.be", true },
  { "myleanfactory.de", true },
  { "mylife360mag.com", true },
  { "mylifeabundant.com", true },
  { "mylittlechat.ru", true },
  { "myliveupdates.com", true },
  { "myloan.hk", true },
  { "mylookout.com", false },
  { "mylstrom.com", true },
  { "mylucknursinghome.com", true },
  { "mymadina.com", true },
  { "mymall.co.jp", true },
  { "mymarketingcourses.com", true },
  { "mymb.pm", true },
  { "mymed.de", true },
  { "mymed.eu", true },
  { "mymedz.nl", true },
  { "mymixtapez.com", true },
  { "mymommyworld.com", true },
  { "mymotor.nl", true },
  { "myms.eu", true },
  { "mymun.com", true },
  { "mymun.net", true },
  { "mymusiclist.alwaysdata.net", true },
  { "mymx.lu", true },
  { "myna.go.jp", true },
  { "mynameistavis.com", true },
  { "mynetworkingbuddy.com", true },
  { "mynext.events", true },
  { "mynextmove.org", true },
  { "mynn.io", true },
  { "mynook.info", false },
  { "mynortherngarden.com", true },
  { "myonline.hu", true },
  { "myonline.store", true },
  { "myonlinevehicleinsurance.com", true },
  { "myoptumhealthcomplexmedical.com", true },
  { "myoptumhealthparentsteps.com", true },
  { "myotopie.de", true },
  { "myoueb.fr", true },
  { "myoukochou.com", true },
  { "myownconference.cloud", true },
  { "myownconference.com", true },
  { "myownconference.com.ua", true },
  { "myownconference.pl", true },
  { "myownconference.ru", true },
  { "myowndisk.com", true },
  { "myowndisk.net", true },
  { "myownwebinar.com", true },
  { "mypaperdone.com", true },
  { "mypartnernews.com", true },
  { "mypartybynoelia.es", true },
  { "mypayoffloan.com", true },
  { "mypcqq.cc", true },
  { "myperfecthome.ca", true },
  { "myperks.in", true },
  { "myphotoshopbrushes.com", true },
  { "mypillcard.com", true },
  { "mypizza-bremen.de", true },
  { "myplaceonline.com", true },
  { "mypnu.net", true },
  { "mypress.mx", true },
  { "myprintcard.de", true },
  { "myproblog.com", true },
  { "myprotime.eu", true },
  { "myproxy.eu.org", true },
  { "mypup.nl", true },
  { "myrandomtips.com", true },
  { "myranicol.com", true },
  { "myraytech.net", false },
  { "myrealestatemate.com.au", true },
  { "myrealestateschool.com", true },
  { "myred.net", true },
  { "myref.net", true },
  { "myrekber.co.id", true },
  { "myrent.quebec", true },
  { "myrepubic.net", true },
  { "myrepubiic.net", true },
  { "myrepublc.net", true },
  { "myrepublic.asia", true },
  { "myrepublic.cf", true },
  { "myrepublic.cloud", true },
  { "myrepublic.co.id", true },
  { "myrepublic.com.cn", true },
  { "myrepublic.com.hk", true },
  { "myrepublic.com.kh", true },
  { "myrepublic.com.lk", true },
  { "myrepublic.com.my", true },
  { "myrepublic.com.ph", true },
  { "myrepublic.com.tw", true },
  { "myrepublic.eu.com", true },
  { "myrepublic.ga", true },
  { "myrepublic.gq", true },
  { "myrepublic.icu", true },
  { "myrepublic.id", true },
  { "myrepublic.in", true },
  { "myrepublic.limited", true },
  { "myrepublic.lk", true },
  { "myrepublic.ml", true },
  { "myrepublic.mobi", true },
  { "myrepublic.my", true },
  { "myrepublic.net", true },
  { "myrepublic.nz", true },
  { "myrepublic.ph", true },
  { "myrepublic.rocks", true },
  { "myrepublic.run", true },
  { "myrepublic.tk", true },
  { "myrepublic.tv", true },
  { "myrepublic.tw", true },
  { "myrepublic.us.com", true },
  { "myrepublic.xyz", true },
  { "myrepublicau.com", true },
  { "myrepublicaus.com", true },
  { "myrepublicbroadband.com.au", true },
  { "myrepublicfibre.com.au", true },
  { "myrepublicgroup.com", true },
  { "myrepublicinternet.com.au", true },
  { "myrepublicltd.com", true },
  { "myrepublicmy.com", true },
  { "myrepublicnz.com", true },
  { "myrepublicsg.com", true },
  { "myrepublictelecom.com", true },
  { "myrepubllc.net", true },
  { "myresearchapp.com", true },
  { "myrevery.com", true },
  { "myrewardspoints.com", true },
  { "myriadof.com", true },
  { "myrig.com", true },
  { "myrnabiondo.com.br", true },
  { "myrotvorets.center", true },
  { "myrotvorets.news", true },
  { "myrp.co", true },
  { "mysber.ru", true },
  { "myschoolphoto.org", true },
  { "myseatime.com", true },
  { "mysectools.org", true },
  { "myself5.de", true },
  { "myservicearl.com", true },
  { "myseu.cn", true },
  { "mysexydate24.com", true },
  { "myshirtsize.com", true },
  { "mysignal.com", true },
  { "mysize-condooms.nl", true },
  { "mysmelly.com", true },
  { "mysocialporn.com", true },
  { "mysockfactory.ch", true },
  { "mysockfactory.com", true },
  { "mysocrat.com", true },
  { "mysoundtalks.com", false },
  { "myspicer.com", true },
  { "mysqldump-secure.org", true },
  { "myssl.com", true },
  { "mysteriouscode.io", true },
  { "mysterydata.com", true },
  { "mysterymind.ch", true },
  { "mysterysear.ch", true },
  { "mystic-welten.de", true },
  { "mystickphysick.com", true },
  { "mysticplumes.com", true },
  { "mystorymonster.com", true },
  { "mystudycart.com", true },
  { "mysupboard.de", true },
  { "myswissmailaddress.com", true },
  { "mytfg.de", true },
  { "mythemeshop.com", false },
  { "mythengay.ch", true },
  { "mythicdelirium.com", true },
  { "myting.net", true },
  { "mytraiteurs.com", true },
  { "mytripcar.co.uk", true },
  { "mytripcar.com", true },
  { "mytripcar.de", true },
  { "mytripcar.es", true },
  { "mytripcar.fr", true },
  { "mytruecare.org", true },
  { "mytty.net", true },
  { "mytuleap.com", false },
  { "mytun.com", true },
  { "myulog.net", true },
  { "myunox.com", true },
  { "myupdatestar.com", true },
  { "myupdatestudio.com", true },
  { "myupdatesystems.com", true },
  { "myusagepayments.com", true },
  { "myvacompany.com", true },
  { "myvalleymarketing.com", true },
  { "myvirtualserver.com", true },
  { "myvitalhealthsolutions.com.au", true },
  { "myvoipnews.com", true },
  { "myvpl.com", true },
  { "mywari.com", true },
  { "mywebmanager.co.uk", true },
  { "mywebpanel.eu", true },
  { "mywebpanel.nl", true },
  { "myweddingaway.co.uk", true },
  { "myweddingreceptionideas.com", true },
  { "myworkinfo.com", false },
  { "myworth.com.au", true },
  { "myxnr.com", true },
  { "myyubikey.net", true },
  { "myyubikey.org", true },
  { "myzhili.com", true },
  { "myzina.cz", false },
  { "mz-mz.net", true },
  { "mza.com", true },
  { "mzh.io", true },
  { "mziulu.me", false },
  { "mzmtech.com", true },
  { "mznet.de", true },
  { "mzstatic.cc", true },
  { "mzzj.de", true },
  { "n-a.date", true },
  { "n-design.de", true },
  { "n-linear.org", true },
  { "n-m.lu", true },
  { "n-man.info", true },
  { "n-pix.com", false },
  { "n-soft.info", true },
  { "n-un.de", false },
  { "n0paste.tk", false },
  { "n0psled.nl", true },
  { "n26.com", true },
  { "n2diving.net", true },
  { "n2servers.com", true },
  { "n4v.eu", true },
  { "n5118.com", true },
  { "n6a.net", true },
  { "n8mgt.com", true },
  { "n8nvi.com", true },
  { "n8solutions.net", true },
  { "n8solutions.us", true },
  { "na-school.nl", true },
  { "naahgluck.de", true },
  { "naam.me", true },
  { "nabaleka.com", true },
  { "nabankco.com", true },
  { "nabidkamajetku.cz", true },
  { "nabidkydnes.cz", true },
  { "nabytek-valmo.cz", true },
  { "nacfit.com", true },
  { "nachsendeauftrag.net", true },
  { "nachsenden.info", true },
  { "nachtmuziek.info", true },
  { "nacin.com", true },
  { "nacktetatsachen.at", false },
  { "nacktwanderfreunde.de", true },
  { "nacyklo.cz", true },
  { "nadaquenosepas.com", true },
  { "nadejeproninu.cz", true },
  { "nadelholzkulturen.de", true },
  { "naders.com", true },
  { "nadiafourcade-photographie.fr", true },
  { "nadine-chaudier.net", true },
  { "nadsandgams.com", true },
  { "nadyaolcer.fr", true },
  { "nafod.net", true },
  { "naga-semi.com", true },
  { "nagashi.ma", false },
  { "nagaya.biz", true },
  { "nagb.gov", true },
  { "nagb.org", true },
  { "nagel-dentaltechnik.de", true },
  { "nagelfam.com", true },
  { "naggie.net", true },
  { "nah.nz", true },
  { "nah.re", true },
  { "nahura.com", true },
  { "nai-job.jp", true },
  { "nailattitude.ch", true },
  { "nailchiodo.com", true },
  { "nailsalon-aztplus.com", true },
  { "nailtodayminneapolis.com", true },
  { "nairobibusinessreview.com", true },
  { "naive.network", true },
  { "najany.de", true },
  { "najany.dk", true },
  { "najany.fr", true },
  { "najany.nl", true },
  { "najany.se", true },
  { "naji-astier.com", true },
  { "nakada4610.com", true },
  { "nakalabo.jp", true },
  { "nakama.tv", true },
  { "nakandya.com", true },
  { "nakayama.systems", true },
  { "nakedalarmclock.me", true },
  { "nakedtruthbeauty.com", true },
  { "nakene.com", true },
  { "nakliyat.name.tr", true },
  { "nakliyatsirketi.biz.tr", true },
  { "nako.no", true },
  { "nalepky-na-zed.cz", true },
  { "nalepte.cz", true },
  { "nalexandru.xyz", true },
  { "namaanakperempuan.net", true },
  { "namaleaks.com", false },
  { "namazon.org", true },
  { "namazvakitleri.com.tr", true },
  { "namegrep.com", true },
  { "nameid.org", true },
  { "namepros.com", true },
  { "namereel.com", true },
  { "namethissymbol.com", true },
  { "nametiles.co", true },
  { "nami.bo", true },
  { "nami.exchange", true },
  { "nami.trade", true },
  { "naminam.de", true },
  { "namrs.net", true },
  { "namskra.is", true },
  { "namu.live", true },
  { "namu.moe", true },
  { "namu.wiki", true },
  { "nanarose.ch", true },
  { "nanch.com", true },
  { "nancytelford.com", true },
  { "nandex.org", true },
  { "nange.cn", true },
  { "nange.co", true },
  { "nankiseamansclub.com", true },
  { "nannytax.ca", true },
  { "nano.voting", true },
  { "nanofy.org", true },
  { "nanogi.ga", true },
  { "nanollet.org", true },
  { "nanotechnologist.com", true },
  { "nanotechnologysolutions.com.au", true },
  { "nanotechtorsion.com", true },
  { "nanovolt.nl", true },
  { "nanowallet.io", true },
  { "nanpuyue.com", true },
  { "nansa.ch", true },
  { "nanubo.com", true },
  { "nanubo.de", true },
  { "naomi.es", false },
  { "naomiheji.com", true },
  { "naotone.com", true },
  { "napcae.de", true },
  { "naphogar.com", true },
  { "napisdata.us", true },
  { "napolinissanctparts.com", true },
  { "nappynko.com", true },
  { "narada.com.ua", true },
  { "narakenkoland.net", true },
  { "naralogics.com", true },
  { "narardetval.se", true },
  { "narazaka.net", true },
  { "narduin.xyz", true },
  { "narenderchopra.com", true },
  { "narfation.org", true },
  { "nargileh.nl", true },
  { "naric.com", true },
  { "narindal.ch", true },
  { "narmos.ch", true },
  { "naro.se", true },
  { "narodsovety.ru", true },
  { "naroska.name", true },
  { "narrativasdigitais.pt", true },
  { "narrative.network", true },
  { "narrative.org", true },
  { "narrenverein-wolkenschieber.de", true },
  { "narthollis.net", false },
  { "nasbi.pl", true },
  { "nasbnation.com", false },
  { "nascio.org", true },
  { "nashdistribution.com", true },
  { "nashikmatka.com", true },
  { "nashira.cz", true },
  { "nashvillebasements.com", true },
  { "nashvillelidsurgery.com", true },
  { "nashzhou.me", true },
  { "nasrsolar.com", true },
  { "nastoletni.pl", true },
  { "nataldigital.com", true },
  { "nataliedawnhanson.com", true },
  { "natanaelys.com", false },
  { "natation-nsh.com", false },
  { "natchmatch.com", true },
  { "natgeofreshwater.com", true },
  { "nathaliebaron.ch", true },
  { "nathaliebaroncoaching.ch", true },
  { "nathaliedijkxhoorn.com", true },
  { "nathaliedijkxhoorn.nl", true },
  { "nathanaeldawe.com", true },
  { "nathancheek.com", false },
  { "nathankonopinski.com", true },
  { "nathanmfarrugia.com", true },
  { "nathansmetana.com", true },
  { "nathumarket.com.br", true },
  { "nation-contracting.com.hk", true },
  { "nationalbank.gov", true },
  { "nationalbanknet.gov", true },
  { "nationalcentereg.org", true },
  { "nationalcprfoundation.com", true },
  { "nationalcrimecheck.com.au", true },
  { "nationalhomequotes.com", true },
  { "nationalmap.gov", true },
  { "nationalpassportservice.info", true },
  { "nationalpriorities.org", true },
  { "nationaltaxprep.com", true },
  { "nationaltrails.ru", true },
  { "nationwiderealtyinvestors.com", true },
  { "natives-team.ch", true },
  { "nativitynj.org", true },
  { "nativs.ch", true },
  { "natlec.com", true },
  { "natsumihoshino.com", true },
  { "natuerlichabnehmen.ch", true },
  { "natur.com", true },
  { "natura-sense.com", true },
  { "naturalezafengshui.com", true },
  { "naturalfit.co.uk", true },
  { "naturalhealthcures.net", false },
  { "naturalkitchen.co.uk", true },
  { "naturalspacesdomes.com", true },
  { "naturaum.de", true },
  { "nature-et-bio.fr", true },
  { "natureflo.net", true },
  { "naturesbest.co.uk", true },
  { "naturesorganichaven.com", true },
  { "natureword.com", true },
  { "naturheilpraxis-oida.de", true },
  { "naturheilpraxis-p-grote.de", true },
  { "naturline.com", true },
  { "naturtint.co.uk", true },
  { "natusvita.com.br", true },
  { "natverkstekniker.se", true },
  { "naude.co", true },
  { "naughty.audio", true },
  { "naughtytoy.co.uk", true },
  { "nausicaahotel.it", true },
  { "naut.ca", true },
  { "nautiljon.com", true },
  { "nautsch.de", true },
  { "navarralanparty.org", true },
  { "navdeep.ca", true },
  { "navenlle.com", true },
  { "navienna.com", true },
  { "navient.com", true },
  { "navigate-it-services.de", false },
  { "navstevnik.sk", true },
  { "navstivime.cz", true },
  { "navycs.com", true },
  { "nawir.de", true },
  { "nayahe.ru", true },
  { "nayami64.xyz", true },
  { "nayanaas.com", true },
  { "nazevfirmy.cz", true },
  { "nazukebanashi.com", true },
  { "nazuna.blue", true },
  { "nb.zone", true },
  { "nb01.com", true },
  { "nb6.de", true },
  { "nba-2k.com", true },
  { "nba.christmas", true },
  { "nba.com.de", true },
  { "nba.de.com", true },
  { "nba.download", true },
  { "nba.gd", true },
  { "nba.gs", true },
  { "nba.gy", true },
  { "nba.hosting", true },
  { "nba.im", true },
  { "nba.live", true },
  { "nba.lu", true },
  { "nba.moe", true },
  { "nba.trade", true },
  { "nba.vc", true },
  { "nba.vg", true },
  { "nba2.com", true },
  { "nba2k.blog", true },
  { "nba2k.cc", true },
  { "nba2k.cn", true },
  { "nba2k.co", true },
  { "nba2k.com.cn", true },
  { "nba2k.download", true },
  { "nba2k.live", true },
  { "nba2k.net", true },
  { "nba2k.online", true },
  { "nba2k.tw", true },
  { "nba2kcn.com", true },
  { "nba2kmods.com", true },
  { "nba2kmt.com", true },
  { "nba2kmy.team", true },
  { "nba2kol.com", true },
  { "nba2konline.com", true },
  { "nba2konlinex.com", true },
  { "nba2kx.com", true },
  { "nbad.al", true },
  { "nbadancers.com", true },
  { "nbade.com", true },
  { "nbafile.com", true },
  { "nbagirls.com", true },
  { "nbaim.com", true },
  { "nbaimg.com", true },
  { "nbalive.cn", true },
  { "nbalivecn.com", true },
  { "nbalivex.com", true },
  { "nbari.com", true },
  { "nbask.com", true },
  { "nbasky.com", true },
  { "nbaspot.com", true },
  { "nbavc.com", true },
  { "nbavg.com", true },
  { "nbayouxi.com", true },
  { "nbgrooves.de", true },
  { "nbhorsetraining.com", true },
  { "nbib.gov", true },
  { "nbnnetwork.com", true },
  { "nbp.com.pk", true },
  { "nbrain.de", true },
  { "nbrii.com", true },
  { "nbriresearch.com", true },
  { "nbrown.us", true },
  { "nbur.co.uk", true },
  { "nc-beautypro.fr", true },
  { "nc-formation.fr", true },
  { "nc-network.io", true },
  { "nc99.co", true },
  { "ncamarquee.co.uk", true },
  { "ncands.net", true },
  { "ncc-efm.com", true },
  { "ncc-efm.org", true },
  { "ncc-qualityandsafety.org", true },
  { "nccemail.net", true },
  { "ncdc.pt", true },
  { "ncea.net.au", true },
  { "nchangfong.com", true },
  { "nchponline.org", true },
  { "ncic.gg", true },
  { "ncloud.freeddns.org", true },
  { "ncm-malerbetrieb.de", true },
  { "ncsc.gov.uk", true },
  { "ncsccs.com", true },
  { "ncstep.org", true },
  { "nctx.co.uk", true },
  { "ndarville.com", true },
  { "ndatc.com", true },
  { "ndbt.com", true },
  { "ndcpolipak.com", true },
  { "ndeoffshore.com", true },
  { "nder.be", true },
  { "ndfa.net", true },
  { "ndfirefighter.com", true },
  { "ndhlink.com", true },
  { "ndpbrn-research.org", true },
  { "ndphp.org", true },
  { "ndpigskin.com", true },
  { "nds-helicopter.de", true },
  { "ndum.ch", true },
  { "ndy.sex", true },
  { "ne-on.org", true },
  { "nea.gov", true },
  { "nearbi.com.mx", true },
  { "nearby.in.th", true },
  { "neartothesky.com", true },
  { "neatous.cz", true },
  { "neatous.net", true },
  { "neatzy.co.uk", true },
  { "neave.tv", true },
  { "neba.io", true },
  { "nebelhauch.de", true },
  { "nebelheim.de", true },
  { "nebenbeiblog.ch", true },
  { "nebra.io", true },
  { "nebracy.com", true },
  { "nebul.at", true },
  { "nebulae.co", true },
  { "nebuluxcapital.com", true },
  { "necessaryandproportionate.net", true },
  { "necessaryandproportionate.org", true },
  { "nechiactua.com", true },
  { "necormansir.com", true },
  { "nectarleaf.com", true },
  { "nedcdata.org", true },
  { "nederland.media", true },
  { "nederlands-vastgoedfonds.nl", true },
  { "nedim-accueil.fr", true },
  { "nedlinin.com", true },
  { "nedraconsult.ru", true },
  { "neecist.org", true },
  { "needemand.com", true },
  { "needstyle.ru", true },
  { "neeerd.org", true },
  { "neel.ch", true },
  { "neemzy.org", true },
  { "nefertitis.cz", true },
  { "neffat.si", true },
  { "neflabs.com", true },
  { "nefro-cme.de", true },
  { "neftis.es", true },
  { "neg9.org", false },
  { "negai.moe", true },
  { "neglecteddiseases.gov", true },
  { "neheim-huesten.de", true },
  { "nehoupat.cz", true },
  { "nehrp.gov", true },
  { "neighborhoodelectricwa.com", true },
  { "neil-barrett.com", true },
  { "neil-barrett.uk", true },
  { "neildaniels.com", true },
  { "neilfarrington.com", true },
  { "neillans.co.uk", true },
  { "neillans.com", true },
  { "neilshealthymeals.com", true },
  { "neilwynne.com", true },
  { "nejenpneu.cz", true },
  { "nejkasy.cz", true },
  { "nejlevnejsi-parapety.cz", true },
  { "neko-nyan-nuko.com", true },
  { "neko-nyan.org", true },
  { "neko.ml", true },
  { "nekodex.net", true },
  { "nekolove.jp", true },
  { "nekomimi.pl", true },
  { "nekomimirouter.com", true },
  { "nekosc.com", true },
  { "nekowa.moe", true },
  { "nekusoul.de", true },
  { "nelhage.com", true },
  { "nella-project.org", true },
  { "nellacms.com", true },
  { "nellacms.org", true },
  { "nellafw.org", true },
  { "nemcd.com", true },
  { "nemecl.eu", true },
  { "nemez.net", true },
  { "nemo.run", true },
  { "nemopan.com", true },
  { "nemopret.dk", true },
  { "nemplex.com", true },
  { "nemplex.win", false },
  { "nems.no", true },
  { "nemumu.com", true },
  { "nemunai.re", true },
  { "nenkin-kikin.jp", true },
  { "neno.io", true },
  { "neo2shyalien.eu", false },
  { "neobits.nl", true },
  { "neocities.org", true },
  { "neoclick.io", true },
  { "neodigital.bg", true },
  { "neoedresources.org", true },
  { "neohu.com", true },
  { "neojo.org", true },
  { "neolaudia.es", true },
  { "neolink.dk", true },
  { "neonataleducationalresources.org", true },
  { "neonatalgoldenhours.org", true },
  { "neonknight.ch", true },
  { "neons.org", true },
  { "neophilus.net", true },
  { "neos.co.jp", true },
  { "neosdesignstudio.co.uk", true },
  { "neostralis.com", true },
  { "neotiv.com", true },
  { "neowin.net", true },
  { "neowlan.net", true },
  { "neoxcrf.com", true },
  { "neoz.com.br", true },
  { "nepageeks.com", true },
  { "nepal-evolution.org", true },
  { "nepezzano13.com", true },
  { "nephelion.org", true },
  { "nephy.jp", true },
  { "nepovolenainternetovahazardnihra.cz", true },
  { "nepremicninar.com", true },
  { "nepremicnine.click", true },
  { "nepremicnine.net", true },
  { "nepustil.net", false },
  { "nerdca.st", true },
  { "nerdhouse.io", true },
  { "nerdmind.de", true },
  { "nerdoutstudios.tv", true },
  { "nerdpol.ch", true },
  { "nerds-gegen-stephan.de", true },
  { "nerdtime.de", true },
  { "nerdwallet.com", true },
  { "nerdydev.net", true },
  { "nerot.eu", true },
  { "nerpa-club.ru", true },
  { "nerull7.info", true },
  { "nerven.se", false },
  { "nesbase.com", true },
  { "nesolabs.com", true },
  { "nesolabs.de", true },
  { "nestedquotes.ca", true },
  { "nestor.nu", true },
  { "neswec.org.uk", true },
  { "net-masters.pl", true },
  { "net-safe.info", true },
  { "net-share.de", true },
  { "net4visions.at", true },
  { "net4visions.de", true },
  { "netamia.com", true },
  { "netapps.de", true },
  { "netbank.com.au", true },
  { "netbears.com", true },
  { "netbears.ro", true },
  { "netbows.com", true },
  { "netbows.es", true },
  { "netbox.org", true },
  { "netbrewventures.com", true },
  { "netbulls.io", true },
  { "netbuzz.ru", true },
  { "netconnect.at", true },
  { "netcoolusers.org", true },
  { "netdex.co", true },
  { "netera.se", true },
  { "neteraser.de", true },
  { "netexem.com", true },
  { "netfabb.com", true },
  { "netflixlife.com", true },
  { "netfog.de", true },
  { "netfuture.ch", true },
  { "netfxharmonics.com", true },
  { "nethackwiki.com", true },
  { "nethask.ru", true },
  { "nethostingtalk.com", true },
  { "nethruster.com", true },
  { "nethunter.top", true },
  { "netki.com", true },
  { "netlentes.com.br", true },
  { "netlocal.ru", true },
  { "netmagicas.com.br", true },
  { "netmeister.org", true },
  { "netnea.com", true },
  { "netnik.de", true },
  { "netnodes.net", true },
  { "netraising.com", false },
  { "netrelay.email", true },
  { "netrewrite.com", true },
  { "netrider.net.au", false },
  { "netrogue.ninja", true },
  { "netronix.be", true },
  { "netsec.cloud", true },
  { "netsigna.de", true },
  { "netsite.dk", true },
  { "netsoins.org", true },
  { "netsparker.com", true },
  { "netsparker.com.tr", true },
  { "netspeedia.net", true },
  { "netsphere.cz", true },
  { "nettamente.com", true },
  { "nette.org", true },
  { "nettegeschenke.de", true },
  { "nettia.fi", true },
  { "nettilamppu.fi", true },
  { "netto-service.ch", true },
  { "nettools.link", true },
  { "nettoyage.email", true },
  { "nettx.co.uk", true },
  { "netulo.com", true },
  { "netvizura.co.uk", true },
  { "netvpn.ml", true },
  { "netwarc.eu", true },
  { "netwarc.nl", true },
  { "netweaver.uk", true },
  { "network-midlands.co.uk", true },
  { "network-midlands.uk", true },
  { "network-notes.com", true },
  { "network23.nl", true },
  { "networkersdiary.com", true },
  { "networking-groups.co.uk", true },
  { "networking4all.com", true },
  { "networkingnexus.net", true },
  { "networkingphoenix.com", true },
  { "networkmidlands.co.uk", true },
  { "networkmidlands.uk", true },
  { "networkposting.com", true },
  { "networth.at", true },
  { "netz-yokohama.co.jp", true },
  { "netzfabrik.com", true },
  { "netzfrauen.org", true },
  { "netzwerkwerk.de", true },
  { "neuber.uno", true },
  { "neuflizeobc.net", true },
  { "neurabyte.com", true },
  { "neurexcellence.com", true },
  { "neurobiology.com", true },
  { "neurochip.com", true },
  { "neurocny.cloud", true },
  { "neuroethics.com", true },
  { "neurogroove.info", true },
  { "neurolab.no", true },
  { "neuropharmacology.com", true },
  { "neurostimtms.com", true },
  { "neurotransmitter.net", true },
  { "neurozentrum-zentralschweiz.ch", true },
  { "neutein.com", true },
  { "neutralox.com", false },
  { "neuwal.com", true },
  { "neva.li", true },
  { "never.pet", true },
  { "nevergreen.io", true },
  { "nevermore.fi", true },
  { "neverwetturkey.com", true },
  { "nevntech.com", true },
  { "nevolution.me", true },
  { "nevoxo.com", true },
  { "new-black-order.com", true },
  { "new-boiler-prices.co.uk", true },
  { "new-ms.com", true },
  { "new-process.ch", true },
  { "new-process.com", true },
  { "new-process.de", true },
  { "new-process.eu", true },
  { "new.travel.pl", true },
  { "newaccess.ch", true },
  { "newbasemedia.us", true },
  { "newbietech.cn", false },
  { "newborncryptocoin.com", true },
  { "newburybouncycastles.co.uk", true },
  { "newburyparkelectric.com", true },
  { "newburyparkelectrical.com", true },
  { "newburyparkelectrician.com", true },
  { "newburyparkexteriorlighting.com", true },
  { "newburyparklandscapelighting.com", true },
  { "newburyparkoutdoorlighting.com", true },
  { "newcitygas.ca", true },
  { "newcityinfo.ch", true },
  { "newcitystudio.ch", true },
  { "newcloudwhodis.com", true },
  { "newday.host", true },
  { "newearth.press", true },
  { "newfangledscoop.com", true },
  { "newfiepedia.ca", true },
  { "newgrowbook.com", true },
  { "newguidance.ch", true },
  { "newind.info", true },
  { "newizv.ru", true },
  { "newjianzhi.com", true },
  { "newkaliningrad.ru", true },
  { "newknd.com", true },
  { "newlifeband.de", true },
  { "newmarketbouncycastlehire.co.uk", true },
  { "newmed.com.br", true },
  { "newmediaone.net", true },
  { "newmelalife.com", true },
  { "newmovements.net", true },
  { "newmusicjackson.org", true },
  { "newodesign.com", true },
  { "newreleases.io", true },
  { "news47ell.com", true },
  { "newsmotor.info", true },
  { "newspsychology.com", true },
  { "newstone-tech.com", true },
  { "newsyslog.org", true },
  { "newtonproject.org", true },
  { "newtrackon.com", true },
  { "newvehicle.com", true },
  { "nex.li", true },
  { "nex.sx", true },
  { "nexicafiles.com", true },
  { "nexril.net", true },
  { "next-web.ad.jp", true },
  { "next176.sk", true },
  { "next24.io", true },
  { "nextads.ch", true },
  { "nextbranders.com", true },
  { "nextcairn.com", true },
  { "nextcasino.com", true },
  { "nextcloud.co.za", true },
  { "nextcloud.com", true },
  { "nextcloud.nerdpol.ovh", true },
  { "nextclouddarwinkel.nl", true },
  { "nextevolution.co.uk", true },
  { "nextgen.sk", true },
  { "nextgencel.com", true },
  { "nextgenthemes.com", true },
  { "nextgreatmess.com", true },
  { "nexthop.jp", true },
  { "nextiot.de", true },
  { "nextmbta.com", true },
  { "nextme.se", true },
  { "nextnely.com", true },
  { "nextnowagency.com", true },
  { "nextrobotics.de", true },
  { "nextstep-labs.gr", true },
  { "nexttv.co.il", true },
  { "nextwab.com", true },
  { "nexus-exit.de", true },
  { "nexus-vienna.at", true },
  { "nexusconnectinternational.eu", true },
  { "nexwebsites.com", true },
  { "nexxus-sistemas.net.br", true },
  { "neyer-lorenz.de", true },
  { "nezrouge-est-vaudois.ch", true },
  { "nezrouge-geneve.ch", true },
  { "nezvestice.cz", true },
  { "nf4.net", true },
  { "nf9q.com", true },
  { "nfam.de", true },
  { "nfe-elektro.de", true },
  { "nfir.nl", true },
  { "nfl.dedyn.io", true },
  { "nfl.duckdns.org", true },
  { "nflchan.org", true },
  { "nflmocks.com", true },
  { "nflsic.org", true },
  { "nfpors.gov", true },
  { "nframe.io", true },
  { "nfsec.pl", true },
  { "nfz.moe", true },
  { "ng-musique.com", true },
  { "ngasembaru.com", true },
  { "ngc.gov", false },
  { "nghe.net", true },
  { "ngi.eu", true },
  { "nginxconfig.com", true },
  { "nginxconfig.io", true },
  { "ngndn.jp", true },
  { "ngt.gr", true },
  { "ngvf.de", true },
  { "ngx.hk", true },
  { "ngxpkg.com", true },
  { "nhccnews.org", true },
  { "nhchalton.com", true },
  { "nhdsilentheroes.org", true },
  { "nhgteam.hu", true },
  { "nhimf.org", true },
  { "nhome.ba", true },
  { "nhsolutions.be", true },
  { "nhw.ovh", true },
  { "ni-mate.com", true },
  { "ni.search.yahoo.com", false },
  { "niadd.com", true },
  { "niagara.ru", false },
  { "niagarafalls.ca", true },
  { "niagarafallsmuseums.ca", true },
  { "niagaraschoice.org", true },
  { "nibb13.tech", true },
  { "nibo.blog", true },
  { "nic.goog", true },
  { "nic.gov", true },
  { "nic.how", true },
  { "nic.soy", true },
  { "nic.xn--q9jyb4c", true },
  { "nice.ch", true },
  { "niceguyit.biz", true },
  { "nicesco.re", true },
  { "nicesleepo.com", true },
  { "nicestudio.co.il", false },
  { "nichijou.com", true },
  { "nicholasperkins.io", true },
  { "nicholaspruss.com", true },
  { "nicholasquigley.com", true },
  { "nicholaswilliams.net", true },
  { "nichteinschalten.de", false },
  { "nichthelfer.de", true },
  { "nicic.gov", true },
  { "nickcraver.com", true },
  { "nickdekruijk.nl", true },
  { "nickguyver.com", true },
  { "nickhitch.co.uk", true },
  { "nickloose.de", true },
  { "nicklord.com", true },
  { "nickplotnek.co.uk", true },
  { "nickrickard.co.uk", true },
  { "nicks-autos.com", true },
  { "nickscomputers.nl", true },
  { "nickserve.com", true },
  { "nickstories.de", true },
  { "nicktheitguy.com", true },
  { "niclasreich.de", true },
  { "nicn.me", true },
  { "nico.st", true },
  { "nicochinese.com", true },
  { "nicocourts.com", true },
  { "nicoknibbe.nl", true },
  { "nicoladixonrealestate.com", true },
  { "nicolajanedesigns.co.uk", true },
  { "nicolas-dumermuth.com", true },
  { "nicolas-hoffmann.net", true },
  { "nicolas-hoizey.com", true },
  { "nicolas-simond.com", true },
  { "nicolasfriedli.ch", true },
  { "nicolashess.de", true },
  { "nicolasiung.me", true },
  { "nicolaszambetti.ch", true },
  { "nicolaw.uk", true },
  { "nicolemathew.com", true },
  { "niconico.ooo", true },
  { "niconode.com", false },
  { "nicoobook.com", true },
  { "nicoobook.net", true },
  { "nicsezcheckfbi.gov", true },
  { "nicul.in", true },
  { "nidro.de", true },
  { "nidsuber.ch", true },
  { "niederohmig.de", true },
  { "niedrigsterpreis.de", true },
  { "niehage.name", true },
  { "nielshoogenhout.be", true },
  { "nielshoogenhout.eu", true },
  { "nielshoogenhout.nl", true },
  { "niemaler.de", true },
  { "nien.cf", true },
  { "nien.co", true },
  { "nien.com", true },
  { "nien.eu.org", true },
  { "nien.gq", true },
  { "nien.org", true },
  { "nien.taipei", true },
  { "nien.tk", true },
  { "nienkeslop.nl", true },
  { "nierenpraxis-dr-merkel.de", true },
  { "nierenpraxis-merkel.de", true },
  { "nieselregen.com", true },
  { "niess.space", true },
  { "niesstar.com", true },
  { "nietzsche.com", true },
  { "nieuwsberichten.eu", true },
  { "nieuwslagmaat.nl", true },
  { "nifc.gov", true },
  { "niftiestsoftware.com", true },
  { "nigelwakefield.com", true },
  { "nigensha.co.jp", true },
  { "niggemeier.cc", true },
  { "nigger.racing", true },
  { "niggo.eu", true },
  { "night2stay.cn", true },
  { "night2stay.com", true },
  { "night2stay.de", true },
  { "night2stay.fr", true },
  { "night2stay.ru", true },
  { "nightbutterflies.com", true },
  { "nightfirec.at", true },
  { "nightfirecat.com", true },
  { "nightmoose.org", true },
  { "nightsi.de", true },
  { "nightstand.io", true },
  { "nihon-no-sake.net", true },
  { "nihtek.in", true },
  { "nii2.org", true },
  { "nij.gov", true },
  { "nijiero-ch.com", false },
  { "nijikata.com", true },
  { "nijm.nl", true },
  { "nikandcara.com", true },
  { "nikao-tech.com", true },
  { "nikavandenbos.nl", true },
  { "nikimix.com", true },
  { "nikkasystems.com", true },
  { "nikkila.me", true },
  { "nikklassen.ca", true },
  { "niklas.pw", true },
  { "niklasbabel.com", true },
  { "nikomo.fi", false },
  { "nikoninframe.co.uk", true },
  { "nikonlibrary.co.uk", true },
  { "nikonnps.co.uk", true },
  { "nikonpromotions.co.uk", true },
  { "nikonschool.co.uk", true },
  { "nikz.in", true },
  { "nil.gs", true },
  { "nil.mx", true },
  { "niles.xyz", true },
  { "nilrem.org", true },
  { "nimeshjm.com", true },
  { "nimidam.com", true },
  { "nina-laaf.de", true },
  { "ninaforever.com", true },
  { "ninarinaldi.com.br", true },
  { "ninaundandre.de", true },
  { "ninchat.com", true },
  { "ninebennink.com", true },
  { "ninepints.co", true },
  { "ninesix.cc", true },
  { "ninespec.com", true },
  { "ninetailed.ninja", true },
  { "ninetaillabs.com", true },
  { "ninetaillabs.xyz", true },
  { "ninfora.com", true },
  { "ninja-galerie.de", true },
  { "ninja-skillz.com", true },
  { "ninjan.co", true },
  { "ninjaworld.co.uk", true },
  { "ninjio.com", true },
  { "ninov.de", true },
  { "nintendoforum.no", true },
  { "ninth.cat", true },
  { "ninthfloor.org", true },
  { "ninverse.com", true },
  { "nipax.cz", true },
  { "nipe-systems.de", true },
  { "nipit.biz", true },
  { "nippon-oku.com", true },
  { "nippon.fr", true },
  { "niqex.com", true },
  { "nirjonmela.com", true },
  { "nirjonmela.net", true },
  { "nirudo.me", true },
  { "nissanofbismarckparts.com", true },
  { "nitifilter.com", true },
  { "nitix.games", true },
  { "nitrix.me", true },
  { "nitrohorse.com", false },
  { "nitrokey.com", true },
  { "nitropanel.com", true },
  { "nitropur.com", true },
  { "nitropur.de", true },
  { "nitrous-networks.com", true },
  { "nitschinger.at", true },
  { "niu.moe", true },
  { "nivi.ca", true },
  { "nix.black", true },
  { "nixonlibrary.gov", true },
  { "nixtest.net", true },
  { "nixx-gel.cz", true },
  { "niyawe.de", true },
  { "niyazpoyilan.com", false },
  { "nja.id.au", true },
  { "njast.net", true },
  { "njguardtraining.com", true },
  { "njilc.com", true },
  { "njpjanssen.nl", true },
  { "nkapliev.org", true },
  { "nkforum.pl", true },
  { "nkinka.de", true },
  { "nkp-media.de", true },
  { "nl-ix.net", true },
  { "nl.search.yahoo.com", false },
  { "nl3ehv.nl", true },
  { "nlap.ca", false },
  { "nlbewustgezond.nl", true },
  { "nlegall.fr", true },
  { "nlfant.eu", true },
  { "nllboard.co.uk", true },
  { "nlleisure.co.uk", true },
  { "nlm.gov", true },
  { "nlt.by", false },
  { "nmmlp.org", true },
  { "nmnd.de", true },
  { "nmontag.com", true },
  { "nmsinusdoc.com", true },
  { "nn.cz", true },
  { "nna774.net", true },
  { "nnqc.nl", true },
  { "no-ip.cz", true },
  { "no-xice.com", true },
  { "no.search.yahoo.com", false },
  { "noagendahr.org", true },
  { "noahjacobson.com", true },
  { "noahmodas.com.br", true },
  { "noahsaso.com", true },
  { "nobitakun.com", true },
  { "nobledust.com", true },
  { "nobleparkapartments.com.au", true },
  { "nobly.de", true },
  { "noc.org", true },
  { "nocit.dk", true },
  { "nocks.com", true },
  { "nocmd.com", true },
  { "nocs.cn", true },
  { "nodari.com.ar", true },
  { "nodariweb.com.ar", true },
  { "nodecdn.net", true },
  { "nodecraft.com", true },
  { "nodejs.de", true },
  { "nodelia.com", true },
  { "nodesec.cc", true },
  { "nodesonic.com", true },
  { "nodevops.com", true },
  { "noeatnosleep.me", true },
  { "noedidacticos.com", true },
  { "noelclaremont.com", true },
  { "noellabo.jp", true },
  { "noematic.space", true },
  { "noemax.com", true },
  { "noexec.org", true },
  { "noez.de", true },
  { "nofrillsdns.com", true },
  { "nogerondier.eu", true },
  { "nogetime.com", true },
  { "noglobalwarrants.org", true },
  { "nohats.ca", true },
  { "nohkan.fr", true },
  { "nohm.eu", true },
  { "nohttps.org", true },
  { "nohup.se", true },
  { "nohup.xyz", true },
  { "noima.com", true },
  { "noincludesubdomains.preloaded.test", false },
  { "noise.agency", true },
  { "noisetor.net", true },
  { "noisetrap.cz", true },
  { "noisky.cn", true },
  { "noisyfox.cn", true },
  { "nojestorget.se", true },
  { "nokia.la", true },
  { "nokono.com", true },
  { "nolaviz.org", true },
  { "noleggio-bagni-chimici.it", true },
  { "noma-film.com", true },
  { "nomadproject.io", true },
  { "nomagic.software", true },
  { "nomenclator.org", true },
  { "nomesbiblicos.com", true },
  { "nomial.co.uk", true },
  { "nomifensine.com", true },
  { "nomsy.net", true },
  { "nonabytes.xyz", true },
  { "noname-ev.de", true },
  { "nonametheme.com", true },
  { "noncombatant.org", true },
  { "noob-box.net", true },
  { "noobow.me", true },
  { "noobswhatelse.net", true },
  { "noobunbox.net", true },
  { "noodles.net.nz", true },
  { "noodplan.co.za", true },
  { "noodweer.be", true },
  { "noofficewalls.com", true },
  { "noomist.com", true },
  { "noon-entertainments.com", true },
  { "noop.ch", true },
  { "noordsee.de", true },
  { "noorsolidarity.com", true },
  { "noortronic.com", true },
  { "nootronerd.com", true },
  { "nootropic.com", true },
  { "noovell.com", true },
  { "nopaste.xyz", true },
  { "nopaynocure.com", true },
  { "norad.sytes.net", true },
  { "norbertschneider-music.com", true },
  { "nord-restaurant-bar.de", true },
  { "nord-sud.be", true },
  { "nordakademie.de", true },
  { "nordicess.dk", true },
  { "nordicirc.com", true },
  { "nordinfo.fi", true },
  { "nordlichter-brv.de", true },
  { "nordmoregatebilklubb.com", true },
  { "nordnetz-hamburg.de", true },
  { "nordseeblicke.de", true },
  { "nordwal.de", true },
  { "nordwaldzendo.de", true },
  { "norestfortheweekend.com", true },
  { "noret.com", true },
  { "norichanmama.com", true },
  { "noriel.ro", true },
  { "normaculta.com.br", true },
  { "norman-preusser-gmbh.de", true },
  { "normanbauer.com", true },
  { "normandgascon.com", true },
  { "normankranich.de", true },
  { "noroshi-burger.com", true },
  { "norrliden.de", true },
  { "norsewars.com", true },
  { "norskpensjon.no", true },
  { "northatlantalaw.net", true },
  { "northbridgecre.com", true },
  { "northbrisbaneapartments.com.au", true },
  { "northconsulting.fr", true },
  { "northcountykiaparts.com", true },
  { "northcreekresort.com", true },
  { "northcreekresortblue.ca", true },
  { "northdakotahealthnetwork.com", true },
  { "northdevonbouncycastles.co.uk", true },
  { "northeastcdc.org", true },
  { "northeastrodeo.co.uk", true },
  { "northern-lakes.com", true },
  { "northerngate.net", true },
  { "northernhamsterclub.com", true },
  { "northernpage.com", true },
  { "northernselfstorage.co.za", true },
  { "northfieldyarn.com", true },
  { "northokanaganbookkeeping.com", true },
  { "northpointoutdoors.com", true },
  { "northpole.dance", true },
  { "northpost.is", true },
  { "northridgeelectrical.com", true },
  { "northumbriagames.co.uk", true },
  { "norys-escape.de", true },
  { "nos-medias.fr", true },
  { "nos-oignons.net", true },
  { "noscript.net", true },
  { "noscura.nl", true },
  { "nosecrets.ch", true },
  { "nosfermiers.com", true },
  { "noslite.nl", true },
  { "nospoint.cz", true },
  { "nosqlzoo.net", true },
  { "nossasenhora.net", true },
  { "nossasenhoradodesterro.com.br", true },
  { "nostosh.eu.org", true },
  { "nostraforma.com", false },
  { "noswap.com", true },
  { "nosyu.pe.kr", true },
  { "nota.moe", true },
  { "notabug.org", true },
  { "notacooldomain.com", true },
  { "notadd.com", true },
  { "notallmine.net", true },
  { "notar-glagowski.com", true },
  { "notar-glagowski.de", true },
  { "notar-peikert.com", true },
  { "notare-marktplatz24.info", true },
  { "notarkrauss.de", true },
  { "notarvysocina.cz", true },
  { "notcompletelycorrect.com", true },
  { "notepad.nz", true },
  { "noteskeeper.ru", true },
  { "noticaballos.com", true },
  { "noticiasdehumor.com", true },
  { "notify.moe", true },
  { "notigatos.es", true },
  { "notilus.fr", true },
  { "notinglife.com", true },
  { "notjustvacs.com", true },
  { "notmybox.com", true },
  { "notnize.net", true },
  { "notnl.com", true },
  { "notofilia.com", true },
  { "notora.tech", true },
  { "notoriousdev.com", true },
  { "nototema.com", true },
  { "notsafefor.work", true },
  { "nottres.com", true },
  { "noudjalink.nl", true },
  { "noustique.com", true },
  { "nova-dess.ch", true },
  { "nova-it.pl", true },
  { "nova-kultura.org", true },
  { "nova-wd.org.uk", true },
  { "nova.live", true },
  { "novabench.com", true },
  { "novacoast.com", false },
  { "novadermis.es", true },
  { "novafreixo.pt", true },
  { "novascan.net", true },
  { "novawave.ca", true },
  { "nove.city", true },
  { "noveciti.com", true },
  { "novecity.cloud", true },
  { "novecity.com", true },
  { "novecity.info", true },
  { "novecity.it", true },
  { "novecity.org", true },
  { "novecitymail.com", true },
  { "novelfeed.com", true },
  { "novelinglife.net", true },
  { "novelvyretraite.fr", true },
  { "novgorod-avia.ru", true },
  { "novilaw.com", true },
  { "novilidery.com", true },
  { "novinivo.com", true },
  { "novodiegomaia.com.br", true },
  { "novojet.cl", true },
  { "novoresume.com", false },
  { "novosibavia.ru", true },
  { "novurania.com", true },
  { "nowall.online", true },
  { "nowhere.dk", true },
  { "nowitzki.me", true },
  { "nowlas.org", true },
  { "nowloading.co", true },
  { "noxlogic.nl", true },
  { "noydeen.com", true },
  { "noyocenter.org", true },
  { "np-edv.at", true },
  { "np.search.yahoo.com", false },
  { "npath.de", true },
  { "npcrcss.org", true },
  { "npmcdn.com", true },
  { "npregion.org", true },
  { "npsas.org", true },
  { "npw.net", true },
  { "nqeshreviewer.com", true },
  { "nrd.li", true },
  { "nrdstd.io", true },
  { "nrev.ch", true },
  { "nrkn.fr", true },
  { "nrsweb.org", true },
  { "nrvn.cc", false },
  { "ns-frontier.com", true },
  { "ns2servers.pw", true },
  { "nsa.lol", true },
  { "nsapwn.com", true },
  { "nsboston.org", true },
  { "nsboutique.com", true },
  { "nscnet.jp", true },
  { "nsfw-story.com", true },
  { "nshipster.cn", true },
  { "nshipster.co.kr", true },
  { "nshipster.com", true },
  { "nshipster.es", true },
  { "nsm.ee", true },
  { "nsm.stat.no", true },
  { "nso.ie", true },
  { "nsofficeinteriors.com", true },
  { "nsp.ua", true },
  { "nst-maroc.com", true },
  { "nstatic.xyz", true },
  { "nstd.net", true },
  { "nstremsdoerfer.ovh", true },
  { "nstrust.co.uk", true },
  { "nsworks.com", true },
  { "ntags.org", true },
  { "ntcoss.org.au", true },
  { "nte.email", true },
  { "nti.de", true },
  { "ntia.gov", true },
  { "ntotten.com", true },
  { "ntppool.org", false },
  { "ntsb.gov", true },
  { "ntwt.us", true },
  { "ntx360grad-fallakte.de", true },
  { "ntzwrk.org", true },
  { "nu3tion.com", true },
  { "nu3tion.cz", true },
  { "nuacht.ie", true },
  { "nuamooreaindonesia.com", true },
  { "nubella.com.au", true },
  { "nubu.at", true },
  { "nuclea.id", true },
  { "nuclea.site", true },
  { "nuclearcat.com", true },
  { "nucleuscore.org", true },
  { "nudevotion.com", true },
  { "nuel.cl", true },
  { "nuevaimagenpublicidad.es", true },
  { "nuffield.nl", true },
  { "nugdev.co", true },
  { "null-life.com", true },
  { "nullday.de", true },
  { "nulle-part.org", true },
  { "nullonerror.org", true },
  { "nullpointer.io", true },
  { "nullroute.com", true },
  { "nulltime.net", false },
  { "numarasorgulama.tel", true },
  { "numatic.co.uk", true },
  { "number.me", true },
  { "numbercult.net", true },
  { "numbermunchers.net", true },
  { "numberoneshoes.co.nz", false },
  { "numberzero.org", true },
  { "numerik-games.ch", true },
  { "numero-aleatorio.com", true },
  { "numero1.ch", true },
  { "numerologist.com", true },
  { "numerossanos.com.ar", true },
  { "numismed-seniorcare.de", true },
  { "numwave.nl", true },
  { "nunesgh.com", true },
  { "nunnenmacher.net", true },
  { "nunnun.jp", true },
  { "nunomoura.com", true },
  { "nuos.org", true },
  { "nuovaelle.it", true },
  { "nuquery.com", true },
  { "nur.berlin", true },
  { "nureg.club", true },
  { "nureg.net", true },
  { "nureg.xyz", true },
  { "nuriacamaras.com", true },
  { "nursejj.com", true },
  { "nurseone.ca", true },
  { "nurses.dating", true },
  { "nursingschool.network", true },
  { "nuryahan.com.br", true },
  { "nussadoclub.org", true },
  { "nut.services", true },
  { "nutikell.com", true },
  { "nutleyeducationalfoundation.org", true },
  { "nutleyef.org", true },
  { "nutonic-sports.com", true },
  { "nutpanda.com", true },
  { "nutra-creations.com", true },
  { "nutrafitsuplementos.com.br", true },
  { "nutri-spec.me", true },
  { "nutriciametabolics-shop.de", true },
  { "nutridieta.com", true },
  { "nutripedia.gr", true },
  { "nutrishop.com", true },
  { "nutrition.gov", true },
  { "nutrivisa.com.br", true },
  { "nuvechtdal.nl", true },
  { "nuvini.com", true },
  { "nuvospineandsports.com", true },
  { "nuxer.fr", true },
  { "nv.gw", true },
  { "nve-qatar.com", true },
  { "nvl-game.tokyo", true },
  { "nvq.nl", true },
  { "nvr.bz", true },
  { "nvtc.gov", true },
  { "nwapproval.com", true },
  { "nwautorebuild.com", true },
  { "nwbc.gov", true },
  { "nwerc.party", true },
  { "nwgh.org", false },
  { "nwimports.com", true },
  { "nwk1.com", true },
  { "nwperformanceandoffroad.com", true },
  { "nwr-waffenbuch.de", true },
  { "nwra.com", true },
  { "nwuss.okinawa", true },
  { "nwwc.dk", true },
  { "nwwnetwork.net", true },
  { "nxinfo.ch", true },
  { "nxit.ca", true },
  { "nxth.io", true },
  { "nya.as", true },
  { "nyadora.com", true },
  { "nyadora.moe", true },
  { "nyan.it", true },
  { "nyan.stream", true },
  { "nyansparkle.com", true },
  { "nyantec.com", true },
  { "nybiz.nyc", true },
  { "nycoyote.org", true },
  { "nydig.com", true },
  { "nyghtus.net", false },
  { "nyhaoyuan.net", true },
  { "nyiad.edu", true },
  { "nyip.co.uk", true },
  { "nyip.edu", true },
  { "nylevemusic.com", true },
  { "nyloc.de", true },
  { "nymphetomania.net", true },
  { "nynex.net", true },
  { "nyoronfansubs.org", true },
  { "nyphox.ovh", true },
  { "nys-hk.com", false },
  { "nytrafficticket.com", true },
  { "nyxi.eu", true },
  { "nyyu.tk", true },
  { "nzb.cat", false },
  { "nzbr.de", true },
  { "nzstudy.ac.nz", true },
  { "nzws.me", true },
  { "o-loska.cz", true },
  { "o-results.ch", true },
  { "o-sp.com", true },
  { "o2careers.co.uk", true },
  { "o3.wf", true },
  { "o3wallet.com", true },
  { "o5.cx", true },
  { "o6asan.com", true },
  { "o8b.club", true },
  { "oaic.gov.au", true },
  { "oakandresin.co", true },
  { "oakington.info", false },
  { "oaklands.co.za", true },
  { "oakparkelectrical.com", true },
  { "oakparkexteriorlighting.com", true },
  { "oakparklandscapelighting.com", true },
  { "oakparklighting.com", true },
  { "oakparkoutdoorlighting.com", true },
  { "oakslighting.co.uk", true },
  { "oanalista.com.br", true },
  { "oasisdabeleza.com.br", true },
  { "oasisim.net", false },
  { "oatmealdome.me", true },
  { "oatycloud.spdns.de", true },
  { "oauth-dropins.appspot.com", false },
  { "obamalibrary.gov", true },
  { "obamawhitehouse.gov", true },
  { "oberhofdrinks.com", true },
  { "obermeiers.eu", true },
  { "oberoi.de", true },
  { "obesidadlavega.com", true },
  { "obfuscate.xyz", true },
  { "obg-global.com", true },
  { "obgalslancaster.com", true },
  { "obitech.de", true },
  { "object.earth", true },
  { "objectif-terre.ch", true },
  { "objekt-textil.ch", true },
  { "oblast45.ru", false },
  { "oboeta.com", true },
  { "obono.at", true },
  { "obrienswine.ie", true },
  { "obs.group", true },
  { "obscur.us", true },
  { "observer.name", true },
  { "obsessharness.com", true },
  { "obsidianirc.net", true },
  { "obsproject.com", true },
  { "obtima.org", true },
  { "obud.cz", true },
  { "obxlistings.com", true },
  { "obyvateleceska.cz", true },
  { "oc-sa.ch", true },
  { "ocalaflwomenshealth.com", true },
  { "ocarupo.com", true },
  { "occenterprises.org", true },
  { "occentus.net", true },
  { "occmon.net", true },
  { "occonnections.org", true },
  { "occupational-therapy-colleges.com", true },
  { "ocd2016.com", true },
  { "ocdadmin.com", true },
  { "oceancity4sales.com", true },
  { "oceandns.eu", true },
  { "oceandns.net", true },
  { "oceandns.nl", true },
  { "oceanlord.me", true },
  { "oceanvisuals.com", true },
  { "ocelot.help", true },
  { "ocenovani-inspekce.cz", true },
  { "ocf.io", true },
  { "ocg-card.com", true },
  { "ochrepoint.com.au", true },
  { "ochsenfeld.co", true },
  { "ochsundjunior.ch", true },
  { "ochsundjunior.swiss", true },
  { "ocim.ch", true },
  { "ockendenhemming.co.uk", true },
  { "oclausen.com", true },
  { "ocni-ambulance-most.cz", true },
  { "ocolere.ch", true },
  { "ocotg.com", true },
  { "ocrn.nl", true },
  { "ocsigroup.fr", true },
  { "ocsr.nl", true },
  { "octagongroup.co", true },
  { "octal.es", true },
  { "octarineparrot.com", true },
  { "octav.name", false },
  { "octobered.com", true },
  { "octocaptcha.com", true },
  { "octofox.de", true },
  { "octohedralpvp.tk", true },
  { "octolopagon.games", true },
  { "octopus-agents.com", true },
  { "octosniff.net", true },
  { "octosys.net", true },
  { "octosys.org", true },
  { "octosys.ru", true },
  { "octothorpe.club", true },
  { "octothorpe.ninja", true },
  { "oculus.com", true },
  { "oddmuse.org", true },
  { "oddnumber.ca", true },
  { "oddsandevens.ca", true },
  { "oddsandevensbookkeeping.ca", true },
  { "oddtime.net", true },
  { "odensc.me", true },
  { "odhosc.ca", true },
  { "odifi.com", true },
  { "odinseye.net", true },
  { "odoo.co.th", true },
  { "odpikedoslike.com", true },
  { "odtu.lu", true },
  { "oducs.org", true },
  { "odvps.com", true },
  { "odysseyofthemind.eu", true },
  { "odzyskaniedomeny.pl", true },
  { "oe-boston.com", true },
  { "oec-music.com", true },
  { "oeh.ac.at", true },
  { "oeko-bundesfreiwilligendienst-sh.de", true },
  { "oeko-bundesfreiwilligendienst.de", true },
  { "oeko-jahr-jubilaeum.de", true },
  { "oeko-jahr.de", true },
  { "oelbilder-oelmalerei.de", true },
  { "oelsner.net", true },
  { "oemspace.net", true },
  { "oemspace.nl", true },
  { "oemwolf.com", true },
  { "oenings.eu", true },
  { "of2m.fr", true },
  { "ofcampuslausanne.ch", true },
  { "ofda.gov", true },
  { "ofertasadsl.com", true },
  { "ofertino.es", true },
  { "ofertolino.fr", true },
  { "offandonagain.org", true },
  { "offbyinfinity.com", true },
  { "offenekommune.de", true },
  { "offenes-deutschland.de", true },
  { "offertegiuste.com", true },
  { "offfbynight.be", true },
  { "offgames.io", true },
  { "offgridhub.com", true },
  { "office-discount.at", true },
  { "office-discount.de", true },
  { "office-furniture-direct.co.uk", true },
  { "office-morimoto.com", true },
  { "officefundays.co.uk", true },
  { "officeinteriors.co.nz", true },
  { "officemovepro.com", true },
  { "officiants.wedding", false },
  { "officium.tech", true },
  { "offroadeq.com", true },
  { "offroadhoverboard.net", true },
  { "offshoot.ie", true },
  { "offshoot.rentals", true },
  { "offshore.digital", true },
  { "offshoremarineparts.com", false },
  { "ofggolf.com", true },
  { "oflow.me", true },
  { "ofsetas.lt", true },
  { "oftamedic.com", true },
  { "oftn.org", true },
  { "oge.ch", true },
  { "ogkw.de", true },
  { "oglen.ca", true },
  { "ogocare.com", true },
  { "oguya.ch", true },
  { "ogyaa.jp", true },
  { "oh14.de", true },
  { "ohadsoft.com", true },
  { "ohai.su", true },
  { "ohchouette.com", true },
  { "ohd.dk", true },
  { "oheila.com", true },
  { "ohhere.xyz", true },
  { "ohiohealthfortune100.com", true },
  { "ohling.org", true },
  { "ohmayonnaise.com", true },
  { "ohne-name.de", true },
  { "ohnonotme.com", true },
  { "ohol.se", true },
  { "ohsohairy.co.uk", true },
  { "ohyooo.com", true },
  { "oi-wiki.org", true },
  { "oilpaintingsonly.com", true },
  { "oirealtor.com", true },
  { "oisd.nl", true },
  { "oita-homes.com", true },
  { "ojaioliveoil.com", true },
  { "ojanaho.com", true },
  { "ojdip.net", true },
  { "ojomovies.com", true },
  { "ojp.gov", true },
  { "okakuro.org", true },
  { "okanaganrailtrail.ca", true },
  { "okashi.me", true },
  { "okay.cf", true },
  { "okay.coffee", true },
  { "okburrito.com", true },
  { "okchicas.com", true },
  { "okchousebuyer.com", true },
  { "okeeferanch.ca", true },
  { "okhrana.agency", true },
  { "okib.ca", true },
  { "okin-jp.net", true },
  { "okinawa-mag.net", true },
  { "okmx.cloud", true },
  { "okmx.de", true },
  { "okna-tm.kz", true },
  { "okonetwork.org.uk", true },
  { "okotoksbeach.ca", true },
  { "oksafe-t.org", true },
  { "oktime.cz", true },
  { "oktoberfeststore.nl", true },
  { "oktomus.com", true },
  { "okukan.com.au", true },
  { "okurapictures.com", true },
  { "okusiassociates.com", true },
  { "olanderflorist.com", true },
  { "olasouris.com", true },
  { "olastrafford.org", true },
  { "olback.net", true },
  { "olbat.net", true },
  { "olcayanar.com", true },
  { "olcbrookhaven.org", true },
  { "oldbrookinflatables.co.uk", true },
  { "oldbrookmarqueehire.co.uk", true },
  { "oldchaphome.nl", true },
  { "oldenglishsheepdog.com.br", true },
  { "older-racer.com", true },
  { "oldita.ru", true },
  { "oldking.net", true },
  { "oldnews.news", true },
  { "oldno07.com", true },
  { "oldoakflorist.com", true },
  { "oldprop.com", true },
  { "oldroutetwo.com", true },
  { "oldsticker.com", true },
  { "oldstmary.com", true },
  { "oldtimerreifen-moeller.de", true },
  { "olegon.ru", true },
  { "olegs.be", true },
  { "oleksii.name", true },
  { "oleodecopayba.com.br", true },
  { "oles-hundehaus.de", true },
  { "olfnewcastle.com", true },
  { "olfsecane.org", true },
  { "olgiati.org", true },
  { "olgui.net", true },
  { "olgun.eu", true },
  { "olhcparish.net", true },
  { "olightstore.ro", true },
  { "oliveoil.bot", true },
  { "oliveoilschool.org", true },
  { "oliveoiltest.com", true },
  { "oliveoiltimes.com", true },
  { "oliveraiedelabastideblanche.fr", true },
  { "oliverclausen.com", true },
  { "oliverdunk.com", false },
  { "oliverfaircliff.com", true },
  { "olivernaraki.com", true },
  { "oliverniebuhr.de", true },
  { "oliverschmid.space", true },
  { "oliverspringer.eu", true },
  { "oliverst.com", true },
  { "olivierberardphotographe.com", true },
  { "olivierlemoal.fr", true },
  { "olivierpieters.be", true },
  { "oliviervaillancourt.com", true },
  { "olizeite.ch", true },
  { "ollie.io", true },
  { "ollies.cloud", true },
  { "ollies.cz", true },
  { "olliespage.com", true },
  { "olliespage.net", true },
  { "olliespage.uk", true },
  { "ollning.com", true },
  { "olltechjob.com", true },
  { "olmari.fi", true },
  { "olmc-nutley.org", true },
  { "olmcnewark.com", true },
  { "olmsted.io", true },
  { "olomercy.com", true },
  { "olphseaside.org", true },
  { "olqoa.org", true },
  { "olsh-hilltown.com", true },
  { "olsonproperties.com", true },
  { "olygazoo.com", true },
  { "olymp-arts.world", true },
  { "olympeakgaming.tv", true },
  { "olympiads.ca", true },
  { "olympic-research.com", true },
  { "om1.com", true },
  { "omanko.porn", true },
  { "omar.yt", true },
  { "omarh.net", true },
  { "omdesign.cz", true },
  { "omegahosting.net", true },
  { "omegathermoproducts.nl", true },
  { "omeopatiadinamica.it", true },
  { "omertabeyond.com", true },
  { "omertabeyond.net", true },
  { "ometepeislandinfo.com", true },
  { "omf.link", true },
  { "omfg.exposed", true },
  { "omgbouncycastlehire.co.uk", true },
  { "omi-news.fr", true },
  { "omicron3069.com", true },
  { "omitech.co.uk", true },
  { "omlmetal.co.jp", true },
  { "omniaclubs.com", true },
  { "omniasig.ro", true },
  { "omniasl.com", true },
  { "omniatv.com", true },
  { "omnibot.tv", true },
  { "omnisafira.com", true },
  { "omniscimus.net", false },
  { "omnisky.dk", true },
  { "omnitrack.org", true },
  { "omniverse.ru", true },
  { "omoide-hitokoto.com", true },
  { "omori.ch", true },
  { "omoteura.com", true },
  { "omranic.com", true },
  { "omronwellness.com", true },
  { "on-tech.co.uk", true },
  { "on.tax", true },
  { "ona.io", true },
  { "onaboat.se", true },
  { "onahonavi.com", true },
  { "onarto.com", true },
  { "onazikgu.com", true },
  { "onbuzzer.com", false },
  { "onceuponarainbow.co.uk", true },
  { "oncf.asso.fr", true },
  { "oncodedesign.com", true },
  { "ond-inc.com", true },
  { "ond-inc.jp", true },
  { "ondcp.gov", true },
  { "onderwijstransparant.nl", true },
  { "ondevamosjantar.com", true },
  { "ondrej.org", true },
  { "ondrejbudin.cz", true },
  { "one---line.com", true },
  { "one-resource.com", true },
  { "one-s.co.jp", true },
  { "one-tab.com", true },
  { "one2edit.com", true },
  { "oneazcu.com", false },
  { "onebigcow.com", true },
  { "oneclic.ch", true },
  { "oneclickonejob.com", true },
  { "onedegreehealth.com", true },
  { "onedot.nl", true },
  { "onedottwelve.co.jp", true },
  { "onedottwelve.com", true },
  { "onedrive.com", true },
  { "onedrive.live.com", false },
  { "onee3.org", true },
  { "onefour.ga", false },
  { "onegoodthingbyjillee.com", true },
  { "oneheartbali.church", true },
  { "oneidentity.me", true },
  { "oneiroi.co.uk", true },
  { "onemid.net", true },
  { "onemoonmedia.de", true },
  { "oneononeonone.de", true },
  { "oneononeonone.tv", true },
  { "onepercentrentals.com", true },
  { "onepointsafeband.ca", true },
  { "onepointsafeband.com", true },
  { "onepointzero.com", true },
  { "oneprediction.com", true },
  { "onesnzeroes.com", false },
  { "onesports.cz", true },
  { "onestepfootcare.com", true },
  { "onestopcastles.co.uk", true },
  { "onetcenter.org", true },
  { "onetcodeconnector.org", true },
  { "onetech.it", true },
  { "onetime.info", true },
  { "onetonline.org", true },
  { "oneway.ga", true },
  { "onewaymail.com", true },
  { "oneweb.hu", true },
  { "onfarma.it", true },
  { "ongea.io", true },
  { "ongiaenegogoa.com", true },
  { "onhistory.co.uk", true },
  { "onhub1.com", true },
  { "oni.nl", true },
  { "onice.ch", true },
  { "onionbot.me", true },
  { "onionplay.net", true },
  { "onionplay.org", true },
  { "onionscan.org", true },
  { "oniria.ch", true },
  { "onix.eu.com", true },
  { "onixcco.com.br", true },
  { "onkentessegertdij.hu", true },
  { "onlfait.ch", true },
  { "online-bouwmaterialen.nl", true },
  { "online-calculator.com", true },
  { "online-consulting-corp.com", true },
  { "online-consulting-corp.fr", true },
  { "online-eikaiwa-guide.com", true },
  { "online-health-insurance.com", true },
  { "online-lernprogramme.de", true },
  { "online-pr.at", true },
  { "online-results.dk", true },
  { "online-stopwatch.com", true },
  { "online-textil.com", true },
  { "online-textil.cz", true },
  { "online-textil.sk", true },
  { "online.marketing", true },
  { "online.net.gr", true },
  { "online24.pt", true },
  { "onlinebizdirect.com", false },
  { "onlinecasino.vlaanderen", true },
  { "onlinecensorship.org", true },
  { "onlinecollegeessay.com", true },
  { "onlinefashion.it", true },
  { "onlinehashfollow.com", true },
  { "onlinekmc.com", true },
  { "onlinelegalmarketing.com", true },
  { "onlinelegalmedia.com", true },
  { "onlinelighting.com.au", true },
  { "onlinemarketingmuscle.com", true },
  { "onlinemarketingtraining.co.uk", true },
  { "onlinepokerspelen.be", true },
  { "onlineporno.xyz", true },
  { "onlineprofecional.com", true },
  { "onlinerollout.de", true },
  { "onlinestoreninjas.com", true },
  { "onlinetextil.cz", true },
  { "onlineth.com", false },
  { "onlinexl.nl", true },
  { "onlylebanon.net", true },
  { "onmaps.de", true },
  { "onmarketbookbuilds.com", true },
  { "onnaguse.com", true },
  { "onpay.io", true },
  { "onqproductions.com", true },
  { "onrr.gov", true },
  { "ons.ca", true },
  { "onsgenoegen-waz.nl", true },
  { "onshuistrust.co.za", true },
  { "onspring.com", true },
  { "ontdekhetzelf.nu", true },
  { "onthebriteside.com", true },
  { "ontras.com", false },
  { "ontsc.com", true },
  { "ontservice.com", true },
  { "ontsnappingskamer.nl", true },
  { "onurer.net", true },
  { "onvey.io", true },
  { "onviga.de", true },
  { "onvirt.de", true },
  { "onvori.com", true },
  { "onvori.de", true },
  { "onvousment.fr", true },
  { "onysix.net", true },
  { "onyxcts.com", true },
  { "onyxfireinc.com", true },
  { "onyxgen.duckdns.org", true },
  { "onyxmoon.me", true },
  { "oodlessoftplay.co.uk", true },
  { "oogami.name", true },
  { "oogartsennet.nl", true },
  { "ooharttemplates.com", true },
  { "ooonja.de", true },
  { "oopsis.com", true },
  { "ooyo.be", true },
  { "op11.co.uk", false },
  { "opalesurfcasting.net", true },
  { "oparl.org", true },
  { "opcenter.de", true },
  { "ope.ee", true },
  { "open-banking-access.uk", true },
  { "open-bs.com", true },
  { "open-bs.ru", true },
  { "open-domotics.info", true },
  { "open-freax.fr", true },
  { "open-gaming.net", true },
  { "open-infrastructure.net", true },
  { "open-letters.de", true },
  { "open-mesh.org", true },
  { "open-sauce-recipes.co.uk", true },
  { "open-source.gr", true },
  { "open.gl", true },
  { "openacte.ch", true },
  { "openbayes.com", true },
  { "openbeecloud.com", true },
  { "openblox.org", true },
  { "opencad.io", true },
  { "opencircuit.nl", true },
  { "openclima.com", true },
  { "opencluster.at", true },
  { "opencrm.co.uk", true },
  { "opendata.cz", true },
  { "opendataincubator.eu", true },
  { "opendecide.com", true },
  { "openfir.st", true },
  { "openfitapi-falke.azurewebsites.net", true },
  { "opengg.me", true },
  { "opengovpartnership.de", true },
  { "openings.ninja", true },
  { "openintelligence.uk", true },
  { "openitforum.pl", true },
  { "openkim.org", true },
  { "openkvk.nl", true },
  { "openmirrors.ml", true },
  { "openmtbmap.org", true },
  { "opennippon.com", true },
  { "opennippon.ru", true },
  { "openpictures.ch", true },
  { "openquery.com.au", true },
  { "openrainbow.com", true },
  { "openrainbow.net", true },
  { "openre.site", true },
  { "openrealestate.co", true },
  { "openresty.com", true },
  { "openreview.net", true },
  { "openroademail.com", true },
  { "openruhr.de", true },
  { "openscreen.lu", true },
  { "opensource-cms.nl", true },
  { "opensource-training.de", true },
  { "openspa.webhop.info", true },
  { "openssl.org", true },
  { "openstem.com.au", true },
  { "openstreetmap.is", true },
  { "openstreetmap.lu", true },
  { "openstreetmap.org", true },
  { "opentrack.info", true },
  { "opentrash.org", true },
  { "opentuition.com", true },
  { "openverse.com", true },
  { "openvz.org", true },
  { "openwaveguide.de", true },
  { "openwifi.gr", true },
  { "openwireless.org", true },
  { "operationforever.com", true },
  { "opexterminating.com", true },
  { "opfin.com", true },
  { "ophis-phosphoros.com", true },
  { "opiates.ca", true },
  { "opic.gov", true },
  { "opin.me", true },
  { "opioids.co.uk", true },
  { "opioids.gov", true },
  { "opium.io", true },
  { "oplop.appspot.com", true },
  { "opoleo.com", false },
  { "oportho.com.br", true },
  { "oposiciones.com.es", true },
  { "oposicionesapolicialocal.es", true },
  { "oposicionescorreos.com.es", true },
  { "oposicionescorreos.es", true },
  { "oposicionescorreos.info", true },
  { "oposicionesdejusticia.org", true },
  { "oposicionesertzaintza.com.es", true },
  { "oposicionesycursos.com", true },
  { "oppada.com", true },
  { "oppaiti.me", true },
  { "oppejoud.ee", true },
  { "opportunis.me", true },
  { "opportunity.de", true },
  { "oppositionsecurity.com", true },
  { "oppwa.com", true },
  { "opq.pw", true },
  { "oprbox.com", true },
  { "oprechtgezegd.nl", true },
  { "oprueba.com", true },
  { "opryshok.com", true },
  { "ops-com.com", true },
  { "opsmate.com", false },
  { "opti-net.at", true },
  { "opticaltest.com", true },
  { "optik-trosdorff.de", true },
  { "optimalsetup.com", true },
  { "optimised.cloud", true },
  { "optimised.io", true },
  { "optimisedlabs.co.uk", true },
  { "optimisedlabs.com", true },
  { "optimisedlabs.info", true },
  { "optimisedlabs.net", true },
  { "optimisedlabs.uk", true },
  { "optimist.bg", true },
  { "optimizedlabs.co.uk", true },
  { "optimizedlabs.info", true },
  { "optimizedlabs.net", true },
  { "optimizedlabs.uk", true },
  { "optimumwebdesigns.com", true },
  { "optimus.io", true },
  { "optimuscrime.net", true },
  { "optm.us", true },
  { "optmos.at", true },
  { "optometryscotland.org.uk", true },
  { "optoutday.de", true },
  { "opus-codium.fr", true },
  { "oraculum.cz", true },
  { "orang-utans.com", true },
  { "orangecomputers.com", true },
  { "orangefab.asia", true },
  { "orangefinanse.com.pl", true },
  { "orangejetpack.com", true },
  { "orangenbaum.at", true },
  { "orangenuts.in", true },
  { "orangutan-appeal.org.uk", true },
  { "orbital3.com", true },
  { "orbu.net", true },
  { "orca.pet", true },
  { "orcamoney.com", true },
  { "orchideenettoyage.com", true },
  { "orchidlive.com", true },
  { "orchidsforum.com", true },
  { "orchidspaper.com", true },
  { "orcsnet.com", true },
  { "orderessay.net", true },
  { "ordernow.at", true },
  { "orderswift.com", true },
  { "ordoro.com", true },
  { "ordr.mobi", true },
  { "oreshinya.xyz", true },
  { "oreskylaw.com", true },
  { "oreto.de", true },
  { "orf-digitalsatkarte.at", false },
  { "orf-kartentausch.at", false },
  { "organica.co.za", true },
  { "organisatieteam.nl", true },
  { "organisationsberatung-jacobi.de", true },
  { "organix.ma", true },
  { "orgasmium.com", true },
  { "orgatech-gmbh.de", true },
  { "orgsyn.in", true },
  { "orhideous.name", true },
  { "orians.eu", true },
  { "oribia.net", true },
  { "orientalart.nl", true },
  { "orientravelmacas.com", true },
  { "oriflameszepsegkozpont.hu", true },
  { "origami.to", true },
  { "origamika.com", true },
  { "original-christstollen.com", true },
  { "original-christstollen.de", true },
  { "originalniknihy.cz", true },
  { "origincoffee.com", true },
  { "origincoffee.nz", true },
  { "originpc.com", false },
  { "orikadabra.nl", true },
  { "orikum.org", true },
  { "orimex-mebel.ru", true },
  { "orion-universe.com", true },
  { "orioncokolada.cz", true },
  { "oriondynamic.be", true },
  { "orionfinancialservices.com", true },
  { "oriongames.eu", true },
  { "orkestar-krizevci.hr", true },
  { "orkiv.com", true },
  { "orlandoprojects.com", true },
  { "orleika.io", true },
  { "orlives.de", false },
  { "ormer.nl", true },
  { "orocojuco.com", true },
  { "orovillelaw.com", true },
  { "orro.ro", true },
  { "orrs.de", true },
  { "orthocop.cz", true },
  { "orthodontiste-geneve-docteur-rioux.com", true },
  { "orthograph.ch", true },
  { "orthotictransfers.com", true },
  { "ortlepp.eu", true },
  { "oruggt.is", true },
  { "orum.in", true },
  { "orwell1984.today", true },
  { "oryva.com", true },
  { "orz.uno", true },
  { "os-chrome.ru", true },
  { "os-s.net", true },
  { "os-t.de", true },
  { "os24.cz", true },
  { "osacrypt.studio", true },
  { "osakeannit.fi", true },
  { "osao.org", true },
  { "osbi.pl", true },
  { "osborn.io", true },
  { "osborneinn.com", true },
  { "osburn.com", true },
  { "oscarvk.ch", true },
  { "osepideasthatwork.org", true },
  { "osereso.tn", true },
  { "oses.mobi", true },
  { "oshayr.com", true },
  { "oshell.me", true },
  { "oshershalom.com", true },
  { "oshrc.gov", true },
  { "osielnava.com", true },
  { "osirisrp.online", true },
  { "oskrba.net", true },
  { "oskuro.net", true },
  { "osla.org", true },
  { "oslinux.net", true },
  { "osm.is", true },
  { "osmanlitorunu.com", true },
  { "osmosis.org", true },
  { "osmre.gov", true },
  { "osnova.cz", true },
  { "osobliwydom.pl", true },
  { "osomjournal.org", true },
  { "ospf.sk", true },
  { "osprecos.com.br", true },
  { "osprecos.pt", true },
  { "ospree.me", true },
  { "ostan-collections.net", true },
  { "osterkraenzchen.de", true },
  { "ostgotamusiken.se", true },
  { "osti.gov", true },
  { "ostimwebyazilim.com", true },
  { "ostr.io", true },
  { "osusume-houhou.com", true },
  { "oswalds.co.uk", true },
  { "oswaldsmillaudio.com", true },
  { "oswbouncycastles.co.uk", true },
  { "osworx.net", true },
  { "osx86spain.com", true },
  { "osxentwicklerforum.de", true },
  { "oszri.hu", true },
  { "otakubox.de", true },
  { "otakurepublic.com", true },
  { "otakurumi.de", true },
  { "otellio.com", true },
  { "otellio.de", true },
  { "otellio.it", true },
  { "other98.com", true },
  { "oticasaopaulo.com.br", true },
  { "oticasvisao.net.br", true },
  { "otoblok.com", true },
  { "otokiralama.name.tr", true },
  { "otorrino.pt", true },
  { "otoy.com", true },
  { "otoya.space", true },
  { "otpsmart.com.ua", true },
  { "otr.ie", true },
  { "otrm.de", true },
  { "otsfreestyle.jp", true },
  { "ottoproject.io", false },
  { "ottoversand.at", true },
  { "otus-magnum.com", true },
  { "otvaracie-hodiny.sk", true },
  { "otya.me", true },
  { "ouaibe.qc.ca", true },
  { "ouattara.ch", true },
  { "ouestsolutions.com", true },
  { "ouglor.com", true },
  { "ouimoove.com", true },
  { "ouin.land", true },
  { "oulunjujutsu.com", true },
  { "ouowo.gq", true },
  { "our-box.net", true },
  { "ourai.ws", true },
  { "ourcloud.at", true },
  { "ourdocuments.gov", true },
  { "ourevents.net", true },
  { "ourladymountcarmel.net", true },
  { "ourladyofcalvary.org", true },
  { "ourladyoftheassumptionchurch.org", true },
  { "ourladyqueenofmartyrs.org", true },
  { "ourls.win", true },
  { "ourmaster.org", true },
  { "ourwedding.xyz", true },
  { "ourworldindata.org", true },
  { "out-of-scope.de", true },
  { "outdoorfurniture.ie", true },
  { "outdoorimagingportal.com", true },
  { "outdoorlightingagoura.com", true },
  { "outdoorlightingagourahills.com", true },
  { "outdoorlightingcalabasas.com", true },
  { "outdoorlightingconejovalley.com", true },
  { "outdoorlightingdosvientos.com", true },
  { "outdoorlightinghiddenhills.com", true },
  { "outdoorlightinglakesherwood.com", true },
  { "outdoorlightingmalibu.com", true },
  { "outdoorlightingmoorpark.com", true },
  { "outdoorlightingnewburypark.com", true },
  { "outdoorlightingoakpark.com", true },
  { "outdoorlightingsimivalley.com", true },
  { "outdoorlightingthousandoaks.com", true },
  { "outdoorlightingwestlakevillage.com", true },
  { "outerlimitsdigital.com", true },
  { "outetc.com", true },
  { "outgress.com", true },
  { "outka.xyz", true },
  { "outline.ski", true },
  { "outlines.xyz", true },
  { "outlookonthedesktop.com", true },
  { "outplnr.fr", true },
  { "outpostinfo.com", true },
  { "outsideconnections.com", true },
  { "outsiders.paris", true },
  { "ovelhaostra.com", true },
  { "overalglas.nl", true },
  { "overamsteluitgevers.nl", true },
  { "overceny.cz", true },
  { "overclockers.ge", true },
  { "overdrive-usedcars.be", true },
  { "overkillshop.com", true },
  { "oversight.garden", true },
  { "oversight.gov", true },
  { "overstap.deals", true },
  { "overstemmen.nl", true },
  { "overstockpromote.com", true },
  { "overthecloud.it", true },
  { "overthinkingit.com", true },
  { "overtrolls.de", true },
  { "overwall.org", true },
  { "overzicht.pro", true },
  { "overzicht.ws", true },
  { "oveweddings.com", true },
  { "ovirt.org", true },
  { "ovix.co", true },
  { "ovnrain.com", true },
  { "ovpn.to", true },
  { "ovvy.net", false },
  { "owapi.net", true },
  { "owennelson.co.uk", true },
  { "owensordinarymd.com", true },
  { "owid.cloud", true },
  { "owl-square.com", true },
  { "owl-stat.ch", true },
  { "owl.net", true },
  { "owlandrabbitgallery.com", true },
  { "owlishmedia.com", true },
  { "own3d.ch", true },
  { "owncloud.ch", true },
  { "ownmay.com", true },
  { "oxborrow.ca", true },
  { "oxelie.com", true },
  { "oxo.cloud", true },
  { "oxygin.net", true },
  { "oxytocin.org", true },
  { "oxzeth3sboard.com", true },
  { "oyashirosama.tokyo", true },
  { "oyosoft.fr", true },
  { "oyosoft.net", true },
  { "oysterworldwide.com", true },
  { "ozark.be", true },
  { "oznamovacipovinnost.cz", true },
  { "ozonitron.com", true },
  { "ozonitron.de", true },
  { "ozonitron.eu", true },
  { "ozonytron.com", true },
  { "ozonytron.de", true },
  { "ozonytron.eu", true },
  { "ozvolvo.org", true },
  { "p-fent.ch", true },
  { "p-s-b.com", true },
  { "p-t.io", true },
  { "p.ki", true },
  { "p1cn.com", true },
  { "p1ratrulezzz.me", true },
  { "p22.co", true },
  { "p4chivtac.com", true },
  { "p5118.com", true },
  { "p5r.uk", true },
  { "pa-w.de", true },
  { "pa.search.yahoo.com", false },
  { "paarberatung-hn.de", true },
  { "paardenhulp.nl", true },
  { "paardensportbak.nl", true },
  { "paas-inf.net", true },
  { "paass.net", true },
  { "paazmaya.fi", true },
  { "pablo.im", true },
  { "pablo.scot", true },
  { "pablo.sh", true },
  { "pabloarteaga.co.uk", true },
  { "pabloarteaga.com", true },
  { "pabloarteaga.com.es", true },
  { "pabloarteaga.es", true },
  { "pabloarteaga.eu", true },
  { "pabloarteaga.info", true },
  { "pabloarteaga.me", true },
  { "pabloarteaga.net", true },
  { "pabloarteaga.nom.es", true },
  { "pabloarteaga.org", true },
  { "pabloarteaga.science", true },
  { "pabloarteaga.tech", true },
  { "pabloarteaga.uk", true },
  { "pabloarteaga.xyz", true },
  { "pabuzo.vn", true },
  { "pacaom.com", true },
  { "pacatlantic.com", true },
  { "pacco.com.br", true },
  { "paccolat.name", true },
  { "pace.car", true },
  { "paceda.nl", true },
  { "pacelink.de", true },
  { "pacifco.com", true },
  { "pacificcashforcars.com.au", true },
  { "pacificpalisadeselectric.com", true },
  { "pacificpalisadeselectrical.com", true },
  { "pacificpalisadeselectrician.com", true },
  { "pacificpalisadeslandscapelighting.com", true },
  { "pacificpalisadeslighting.com", true },
  { "pacifictilkin-occasions.be", true },
  { "pacifique-web.nc", true },
  { "pack-haus.de", true },
  { "packagefactory.dk", true },
  { "packagingproject.management", true },
  { "packagist.jp", true },
  { "packagist.org", false },
  { "packaware.com", true },
  { "packetdigital.com", true },
  { "packetlinux.com", true },
  { "pact2017.nl", true },
  { "pactf.com", true },
  { "padam-group.com", true },
  { "padberx-marketing-consultants.de", true },
  { "paddy.rocks", true },
  { "padianda.com", true },
  { "padkit.org", true },
  { "padovani.de", true },
  { "padpilot.co", true },
  { "padrepio.in", true },
  { "padron.com.es", true },
  { "paducaheic.com", true },
  { "padzilla.com", true },
  { "paedlink.ca", true },
  { "paf-events.ch", true },
  { "pagalworld.co", true },
  { "pagalworld.com", true },
  { "pagalworld.info", true },
  { "pagalworld.io", true },
  { "pagalworld.la", true },
  { "pagalworld.me", true },
  { "pagalworld.org", true },
  { "page-builders.com", true },
  { "pageantsnews.com", false },
  { "pagedesignhub.com", true },
  { "pagedesignpro.com", true },
  { "pagedesignweb.com", true },
  { "pagefulloflies.io", true },
  { "pagewizz.com", true },
  { "pagiamtzis.com", true },
  { "pagina.com.mx", true },
  { "paginaweb4u.com", true },
  { "pagure.io", true },
  { "pahae.de", true },
  { "pahealthbilling.com", true },
  { "pahlawanpulsa.com", true },
  { "paichai.space", false },
  { "paincareehr.com", true },
  { "paindata.dk", true },
  { "painefamily.co.uk", true },
  { "painlessproperty.co.uk", true },
  { "paint-it.pink", true },
  { "paintball-ljubljana.si", true },
  { "paintball-shop.sk", true },
  { "paintcolorsbysue.com", true },
  { "paintingindurban.co.za", true },
  { "paipuman.jp", true },
  { "pajadam.me", true },
  { "pajuvuo.fi", true },
  { "paketo.cz", true },
  { "paketo.sk", true },
  { "paketwatch.de", false },
  { "pakho.xyz", true },
  { "pakingas.lt", true },
  { "pakistani.dating", true },
  { "pakitow.fr", true },
  { "pakke.de", true },
  { "pakowanie-polska.pl", true },
  { "pakroyalpress.com", true },
  { "paktolos.net", true },
  { "palabr.as", true },
  { "palapadev.com", true },
  { "palariviera.com", true },
  { "palary.work", true },
  { "palatin.at", true },
  { "palava.tv", true },
  { "palavatv.com", true },
  { "palazzo.link", true },
  { "palazzo.work", true },
  { "paleoself.com", true },
  { "paleotraining.com", true },
  { "palestra.roma.it", true },
  { "palladium46.com", true },
  { "pallas.in", true },
  { "palletflow.com", true },
  { "palli.ch", true },
  { "palmaprop.com", true },
  { "palmavile.us", true },
  { "palmaville.com", true },
  { "palmen-apotheke.de", true },
  { "pamaniqu.nl", true },
  { "pamatv.hk", true },
  { "pamsorel.co.za", true },
  { "pan.digital", true },
  { "panasca.is", true },
  { "panascais.co", true },
  { "panascais.com", true },
  { "panascais.de", true },
  { "panascais.eu", true },
  { "panascais.host", true },
  { "panascais.me", true },
  { "panascais.pw", true },
  { "panascais.site", true },
  { "panascais.tech", true },
  { "panascais.us", true },
  { "panasproducciones.com", true },
  { "panaxis.biz", true },
  { "panaxis.ch", true },
  { "panaxis.li", true },
  { "panda-community.com", true },
  { "panda.tf", true },
  { "pandemicflu.gov", true },
  { "pandkonijn.nl", true },
  { "pandoraflora.com", true },
  { "pandymic.com", true },
  { "paneldewelopera.pl", true },
  { "paneu.de", true },
  { "panhandlemenshealth.com", true },
  { "panic.tk", true },
  { "panier-legumes.bio", true },
  { "paniyanovska.ua", true },
  { "panj.ws", true },
  { "panjiva.com", true },
  { "panmetro.com", true },
  { "panoma.de", true },
  { "panomizer.de", true },
  { "panopy.co", true },
  { "panopy.me", true },
  { "panoti.com", false },
  { "panoxadrez.com.br", true },
  { "panpa.ca", true },
  { "panpsychism.com", true },
  { "panpsychist.com", true },
  { "pantallasled.com.mx", true },
  { "pantallasled.mx", true },
  { "pantallasyescenarios.com", true },
  { "pantheoncrafters.com", true },
  { "panthur.com.au", false },
  { "pantographe.info", true },
  { "pantou.org", false },
  { "pants-off.xyz", true },
  { "panzer72.ru", true },
  { "panzerscreen.dk", true },
  { "pao.ge", true },
  { "pap.la", false },
  { "papa-webzeit.de", true },
  { "papadopoulos.me", true },
  { "papakatsu-life.com", true },
  { "papapa-members.club", true },
  { "papaya.me.uk", true },
  { "papayame.com", true },
  { "papayapythons.com", true },
  { "papelcraft.co.uk", true },
  { "paper-driver.biz", true },
  { "paper-republic.org", true },
  { "paper.sc", true },
  { "paperhoney.by", true },
  { "paperlesssolutionsltd.com.ng", true },
  { "papertracker.net", true },
  { "paperturn.com", true },
  { "paperwritinghelp.net", true },
  { "papiermakerijdehoop.nl", true },
  { "papiermeteenverhaal.nl", true },
  { "papierniczy.eu", true },
  { "papillon-events.be", true },
  { "papion.it", true },
  { "paprikas.fr", true },
  { "paraborsa.net", true },
  { "parachute70.com", true },
  { "paracomer.es", true },
  { "paradais-sphynx.com", true },
  { "paradependentesquimicos.com.br", true },
  { "paradise-engineer.com", true },
  { "paradise-engineering.com", true },
  { "paradise-travel.net", true },
  { "paradiselost.com", true },
  { "paradoxdesigns.org", true },
  { "paragonie.com", false },
  { "paragonremodeling.com", true },
  { "paragreen.net", true },
  { "paranoidcrypto.com", true },
  { "paranoidmode.com", true },
  { "paranoidpenguin.net", true },
  { "paranormalweirdo.com", true },
  { "paranoxer.hu", true },
  { "parasitologyclub.org", true },
  { "paratlan.hu", true },
  { "paratxt.org", true },
  { "parcelbroker.co.uk", false },
  { "parchcraftaustralia.com", true },
  { "parckwart.de", true },
  { "parcon.it", true },
  { "parentelement.com", true },
  { "parentheseardenne.be", true },
  { "parentinterview.com", true },
  { "parentsintouch.co.uk", true },
  { "paris-store.com", true },
  { "parisackerman.com", true },
  { "parisbloom.com", true },
  { "parisderriere.fr", true },
  { "parisescortgirls.com", true },
  { "parisfranceparking.com", true },
  { "parisfranceparking.de", true },
  { "parisfranceparking.fr", true },
  { "parisfranceparking.nl", true },
  { "parisprovincedemenagements.fr", true },
  { "parkeren.in", true },
  { "parkfans.net", true },
  { "parkhost.eu", true },
  { "parkinginparis.fr", true },
  { "parkingpoint.co.uk", true },
  { "parkrunstats.servehttp.com", true },
  { "parkviewmotorcompany.com", true },
  { "parkwayminyan.org", true },
  { "parlamento.gub.uy", true },
  { "parleamonluc.fr", true },
  { "parmels.com.br", true },
  { "parnassys.net", true },
  { "parodesigns.com", true },
  { "parolu.io", true },
  { "parquettista.milano.it", true },
  { "parquettista.roma.it", true },
  { "parroquiasanrafaeldegramalote.com", true },
  { "parry.org", true },
  { "parsemail.org", true },
  { "parser.nu", true },
  { "parsonsfamilyhomes.com", true },
  { "parteaga.com", true },
  { "parteaga.net", true },
  { "partecipa.tn.it", true },
  { "parthkolekar.me", true },
  { "partijhandel.website", true },
  { "partijtjevoordevrijheid.nl", false },
  { "partiono.com", true },
  { "partner.sh", true },
  { "partnermobil.de", true },
  { "partnersfcu.org", true },
  { "partou.de", true },
  { "partridge.tech", true },
  { "parts4phone.com", true },
  { "partsestore.com", true },
  { "partusedtyres.net", true },
  { "party-and-play.co.uk", true },
  { "party-calendar.net", true },
  { "party-kneipe-bar.com", true },
  { "party-time-inflatables-durham.co.uk", true },
  { "partybounceplay.co.uk", true },
  { "partycentrumdebinnenhof.nl", true },
  { "partycentrumopenhuis.nl", true },
  { "partyhireisleofwight.co.uk", true },
  { "partyhireliverpool.co.uk", true },
  { "partypearl.de", true },
  { "partyrocksbounce.co.uk", true },
  { "partyspaces.co.uk", true },
  { "partytime-uk.co.uk", true },
  { "partytimeltd.ie", true },
  { "partytownireland.co.uk", true },
  { "partytownmarquees.co.uk", true },
  { "partyvan.io", true },
  { "partyyy.io", true },
  { "partyzone.ie", true },
  { "parvaneh.fr", true },
  { "pasadenapooch.org", true },
  { "pasadenasandwich.co", true },
  { "pasadenasandwich.com", true },
  { "pasadenasandwichcompany.com", true },
  { "pasalt.com", true },
  { "pasarella.eu", true },
  { "pascal-bourhis.com", true },
  { "pascal-bourhis.net", true },
  { "pascal-wittmann.de", true },
  { "pascaline-jouis.fr", true },
  { "pascalleguern.com", true },
  { "pascalmathis.com", true },
  { "pascalmathis.me", true },
  { "pascalmathis.net", true },
  { "pascalspoerri.ch", false },
  { "pascualinmuebles.com", true },
  { "pasearch.nl", true },
  { "pashminacachemire.com", true },
  { "pass.org.my", true },
  { "passabook.com", true },
  { "passcod.name", true },
  { "passendonderwijs.nl", true },
  { "passfilesafe.com", true },
  { "passfoto-deinfoto.ch", true },
  { "passieposse.nl", true },
  { "passionandbalance.com", true },
  { "passionatefoodie.co.uk", true },
  { "passionatehorsemanship.com", true },
  { "passionatelife.com.au", true },
  { "passionbyd.com", true },
  { "passionebenessere.com", true },
  { "passionpictures.eu", true },
  { "passions-art.com", true },
  { "passover-fun.com", true },
  { "passphrase.today", true },
  { "passport.yandex.by", true },
  { "passport.yandex.com", true },
  { "passport.yandex.com.tr", true },
  { "passport.yandex.kz", true },
  { "passport.yandex.ru", true },
  { "passport.yandex.ua", true },
  { "passports.govt.nz", true },
  { "passrhce.com", true },
  { "passrhcsa.com", true },
  { "passthepopcorn.me", true },
  { "passumpsicbank.com", true },
  { "passvanille-reservation.fr", true },
  { "passvau.lt", true },
  { "passwd.one", true },
  { "passwd.org", true },
  { "password-checker.de", true },
  { "password.consulting", true },
  { "password.work", true },
  { "passwordhashing.com", true },
  { "passwordkeeperbooks.com", true },
  { "passwords.google.com", false },
  { "passwordscon.org", true },
  { "passwordsecurity.info", true },
  { "passworks.io", true },
  { "passy.pw", true },
  { "pasta-factory.co.il", true },
  { "pastaenprosecco.nl", true },
  { "paste.fedoraproject.org", true },
  { "paste.gg", true },
  { "paste.to", true },
  { "pastebin.co.za", true },
  { "pastebin.tw", true },
  { "pasteblin.com", true },
  { "pasternok.org", true },
  { "pasticcerialorenzetti.com", true },
  { "pastoral-verbund.de", true },
  { "pastorbelgagroenendael.com.br", true },
  { "pastordocaucaso.com.br", true },
  { "pastormaremanoabruzes.com.br", true },
  { "pasztor.at", true },
  { "patapwn.com", true },
  { "patatbesteld.nl", true },
  { "pataterosviajeros.com", true },
  { "patbatesremodeling.com", false },
  { "patdorf.com", true },
  { "patechmasters.com", true },
  { "patentados.com", true },
  { "patentfamily.de", true },
  { "paterno-gaming.com", true },
  { "pathagoras.com", true },
  { "pathwaystoresilience.org", true },
  { "patika-biztositas.hu", true },
  { "patikabiztositas.hu", true },
  { "patineteselectricosbaratos.net", true },
  { "patouille-et-gribouille.fr", true },
  { "patric-lenhart.de", true },
  { "patrick-othmer.de", true },
  { "patrick-robrecht.de", true },
  { "patrick.my-gateway.de", true },
  { "patrick21.ch", true },
  { "patrickaudley.ca", true },
  { "patrickaudley.com", true },
  { "patrickbrosi.de", true },
  { "patrickhoefler.net", true },
  { "patricklynch.xyz", true },
  { "patrikgarten.de", true },
  { "patriksima.cz", true },
  { "patriksimek.cz", true },
  { "patriotstationatchalfont.com", true },
  { "patrocinio.com.br", true },
  { "patrz.eu", true },
  { "patsch-photography.de", true },
  { "patsyforyou.ch", true },
  { "patsytoforyou.ch", true },
  { "pattonfanatic.com", true },
  { "pattuka.com", true },
  { "pattyliao.com", true },
  { "paudley.ca", true },
  { "paudley.com", true },
  { "paudley.org", true },
  { "paul-barton.co.uk", true },
  { "paul.reviews", true },
  { "pauladamsmith.com", true },
  { "paulbakaus.com", true },
  { "paulbdelaat.nl", true },
  { "paulbramhall.uk", true },
  { "paulchen.at", true },
  { "paulcooper.me.uk", true },
  { "pauldev.co", true },
  { "paulerhof.com", true },
  { "paulgerberrealtors.com", true },
  { "paulinewesterman.nl", true },
  { "paulmeier.com", false },
  { "paulomonteiro.pt", true },
  { "paulov.com", true },
  { "paulov.info", true },
  { "paulov.ru", true },
  { "paulrobertlloyd.com", true },
  { "paulrotter.de", true },
  { "paulschreiber.com", true },
  { "paulscustomauto.com", true },
  { "paulsnar.lv", true },
  { "paulswartz.net", true },
  { "paulus-foto.pl", true },
  { "paulward.net", true },
  { "paulwatabe.com", true },
  { "paulwendelboe.com", true },
  { "pauly-stahlhandel.com", true },
  { "pauly-stahlhandel.de", true },
  { "pauspam.net", true },
  { "pautadiaria.com", true },
  { "pavando.com", true },
  { "pavelfojt.cz", true },
  { "pavelrebrov.com", true },
  { "pavio.org", true },
  { "paw.cloud", true },
  { "paw.pt", true },
  { "pawel-international.com", true },
  { "pawelnazaruk.com", true },
  { "pawelurbanek.com", true },
  { "pawsomebox.co.uk", true },
  { "pawsr.us", true },
  { "paxerahealth.com", true },
  { "pay-online.in", true },
  { "pay.gov", true },
  { "paybook.co.tz", true },
  { "payboy.biz", true },
  { "payboy.rocks", true },
  { "paybro.eu", true },
  { "payexpresse.com", true },
  { "payfazz.com", true },
  { "paylike.io", true },
  { "payloc.io", true },
  { "payme.uz", true },
  { "payment-network.com", true },
  { "paymentaccuracy.gov", true },
  { "payments.google.com", true },
  { "paymerang.com", true },
  { "paymill.com", true },
  { "paymill.de", true },
  { "paynet.com.co", true },
  { "payoff.com", true },
  { "paypal.com", true },
  { "paypaq.com", true },
  { "paypro.nl", false },
  { "payroll.xero.com", false },
  { "payrollhive.com", true },
  { "paysbuy.net", true },
  { "paysera.com", true },
  { "payslipview.com", true },
  { "payssaintgilles.fr", false },
  { "paystack.com", true },
  { "paytm.in", true },
  { "paytonmoledor.com", true },
  { "payupay.ru", true },
  { "payzang.com", true },
  { "pb.ax", false },
  { "pback.se", true },
  { "pbosquet.com", true },
  { "pbourhis.me", true },
  { "pbr.so", true },
  { "pbraunschdash.com", true },
  { "pbrumby.com", true },
  { "pbz.im", true },
  { "pc-rescue.me", false },
  { "pc-servis-brno.com", true },
  { "pccentral.nl", true },
  { "pcdocjim.com", true },
  { "pcel.com", true },
  { "pcf92.fr", true },
  { "pcfeuerwehr.de", true },
  { "pcforum.sk", true },
  { "pcgamingfreaks.at", true },
  { "pchelpforum.net", true },
  { "pci-dss.hu", true },
  { "pci-e.net", true },
  { "pciconcursos.com.br", true },
  { "pcidss.hu", true },
  { "pcipac.com", true },
  { "pclaeuft.de", true },
  { "pclob.gov", true },
  { "pcloud.com", true },
  { "pcmkrembangan.or.id", true },
  { "pcmr.info", true },
  { "pcnotdienst-oldenburg-rastede.de", true },
  { "pcreparatiehardenberg.nl", true },
  { "pcrypt.org", true },
  { "pcs2.gr", true },
  { "pcsetting.com", true },
  { "pctonic.net", true },
  { "pctrouble.net", true },
  { "pculiar.com", true },
  { "pdf-archive.com", true },
  { "pdfconvert.me", true },
  { "pdfmint.com", true },
  { "pdfpassword.org", true },
  { "pdfpasswort.de", true },
  { "pdfresizer.com", true },
  { "pdfsearch.org", true },
  { "pdfsearches.com", true },
  { "pdkrawczyk.com", true },
  { "pdox.net", true },
  { "pdragt.com", true },
  { "pdthings.net", true },
  { "pdxtowncar.net", true },
  { "pe.search.yahoo.com", false },
  { "peacedivorce.com", true },
  { "peaceispossible.cc", true },
  { "peaceloveandlabor.com", true },
  { "peak-careers.com", true },
  { "peakhomeloan.com", true },
  { "peaksloth.com", true },
  { "peanutbase.org", true },
  { "peanutproductionsnyc.com", true },
  { "pear2pear.de", true },
  { "pearbloom.com", true },
  { "pearlcohen.com", true },
  { "pearlsenroses.nl", true },
  { "pearlsonly.com", true },
  { "peaudorange.net", true },
  { "pebbleparents.com", true },
  { "pebbles.net.in", true },
  { "pecker-johnson.com", true },
  { "peda.net", true },
  { "peddock.com", true },
  { "peddy.dyndns.org", true },
  { "pedicurean.nl", true },
  { "pedicureduiven.nl", true },
  { "pedidamanosevilla.com", true },
  { "pedidosfarma.com.br", true },
  { "pedikura-vitu.cz", true },
  { "pedimanie.cz", true },
  { "pedimoda.com.br", true },
  { "pedro.com.es", true },
  { "pedrosaurus.com", true },
  { "pedrosluiter.nl", true },
  { "pedroventura.com", false },
  { "peeekaaabooo.com", true },
  { "peekier.com", true },
  { "peep.gq", true },
  { "peercraft.at", true },
  { "peercraft.be", true },
  { "peercraft.biz", true },
  { "peercraft.ch", true },
  { "peercraft.cn", true },
  { "peercraft.co.uk", true },
  { "peercraft.com", true },
  { "peercraft.de", true },
  { "peercraft.dk", true },
  { "peercraft.es", true },
  { "peercraft.eu", true },
  { "peercraft.fr", true },
  { "peercraft.info", true },
  { "peercraft.it", true },
  { "peercraft.net", true },
  { "peercraft.nl", true },
  { "peercraft.org", true },
  { "peercraft.pl", true },
  { "peercraft.pt", true },
  { "peercraft.se", true },
  { "peercraft.us", true },
  { "peerigon.com", true },
  { "peername.com", true },
  { "peernode.net", true },
  { "peertube.social", true },
  { "peervpn.net", true },
  { "peerweb.com", true },
  { "peetah.com", true },
  { "peeters.io", true },
  { "peg.nu", true },
  { "pegas-studio.net", true },
  { "pehapkari.cz", true },
  { "peifi.de", false },
  { "peippo.at", true },
  { "peka.pw", true },
  { "pekarstvivetvrzi.cz", true },
  { "pekkapleppanen.fi", true },
  { "pekoe.se", true },
  { "pelanucto.cz", true },
  { "pelican.ie", true },
  { "pelletizermill.com", true },
  { "pelletsprice.com", true },
  { "pelopogrund.com", true },
  { "pelopoplot.com", true },
  { "pelotonimports.com", true },
  { "pems.gov.au", true },
  { "penaugustin.com", true },
  { "pencepay.com", true },
  { "pencillab.cn", true },
  { "pendriveapps.com", true },
  { "penetrationstest.se", true },
  { "penfold.fr", true },
  { "pengi.me", true },
  { "penguinbits.net", true },
  { "penguindrum.moe", true },
  { "penguinprotocols.com", true },
  { "penispumpen.se", true },
  { "pennergold.net", true },
  { "pennington.io", true },
  { "pennyparkerpaper.com", true },
  { "penrithapartments.com.au", true },
  { "pens.com", true },
  { "pensacolawinterfest.org", true },
  { "pensador.com", true },
  { "pensador.info", true },
  { "pensioenfonds-ey.nl", true },
  { "pension-am-alten-waschhaus.de", true },
  { "pensionpilot.ca", true },
  { "penslabyrinth.com", true },
  { "pentandra.com", true },
  { "pentest.blog", true },
  { "pentest.nl", true },
  { "pentesterlab.com", true },
  { "penticton.photography", true },
  { "pentofun.ch", true },
  { "pentoo.ch", true },
  { "penz.media", true },
  { "peoplelikemeapp.com", true },
  { "peoplesdecade.org", true },
  { "peoplesguardian.org", true },
  { "pepeelektro.sk", true },
  { "pepemodelismo.com.br", true },
  { "peperstraat.online", true },
  { "pepgrid.net", true },
  { "peplog.nl", true },
  { "pepme.net", true },
  { "pepstaff.net", true },
  { "pepwaterproofing.com", true },
  { "pequenosfavoritos.com.br", false },
  { "per-olsson.se", true },
  { "pera.gs", true },
  { "perala.me", true },
  { "peraparker.cz", true },
  { "percolate.com", true },
  { "percraft.com", true },
  { "percy.io", true },
  { "percyflix.com", true },
  { "perd.re", true },
  { "perecraft.com", true },
  { "perezdecastro.org", true },
  { "perfect.in.th", true },
  { "perfectbalance.tech", true },
  { "perfectcloud.org", true },
  { "perfectoparty.co.uk", true },
  { "perfectsnap.co.uk", true },
  { "perfectstreaming.systems", true },
  { "perfektesgewicht.com", true },
  { "perfektesgewicht.de", true },
  { "performancehealth.com", false },
  { "performing-art-schools.com", true },
  { "perfumeaz.com", true },
  { "perfumes.com.br", true },
  { "periodic-drinking.com", true },
  { "periscope.tv", true },
  { "perishablepress.com", true },
  { "perm-avia.ru", true },
  { "perm4.com", true },
  { "permajackofstlouis.com", true },
  { "permeance108.com", true },
  { "permiscoderoute.fr", true },
  { "permistheorique.be", true },
  { "permistheoriqueenligne.be", true },
  { "perniciousgames.com", true },
  { "perot.me", true },
  { "perpetualemotion.com", true },
  { "perrau.lt", true },
  { "perroquet-passion.ch", true },
  { "persephone.gr", true },
  { "persocloud.org", true },
  { "personal-genome.com", true },
  { "personaltrainer-senti.de", true },
  { "perspectivum.com", true },
  { "perspektivwechsel-coaching.de", true },
  { "persson.me", true },
  { "perthhillsarmadale.com.au", true },
  { "perthtrains.net", true },
  { "perucasestoril.com.br", true },
  { "pervacio.hu", true },
  { "perzeidi.hr", true },
  { "pescadorcomunicacao.com", true },
  { "pescadorcomunicacao.com.br", true },
  { "pescco.com.br", true },
  { "pestici.de", true },
  { "pestkill.info", true },
  { "pet-hotel-mura.net", true },
  { "pet-life.top", true },
  { "pet-tekk.co.uk", true },
  { "petabits.de", true },
  { "petalkr.com", true },
  { "petbooking.it", true },
  { "petcarvers.com", true },
  { "petdesign.pet", true },
  { "petech.ro", true },
  { "petelew.is", true },
  { "peter.org.ua", true },
  { "peterandjoelle.co.uk", true },
  { "peterbarrett.ca", true },
  { "peterboers.info", true },
  { "peterborgapps.com", true },
  { "peterbruceharvey.com", true },
  { "peterdavehello.org", true },
  { "peterfiorella.com", true },
  { "peterhons.com.au", true },
  { "peterhuetz.at", true },
  { "peterhuetz.com", true },
  { "peterjin.org", true },
  { "peterjohnson.io", true },
  { "peterlew.is", true },
  { "petermaar.com", true },
  { "petersontoscano.com", true },
  { "petervanleeuwentweewielers.nl", true },
  { "petfa.ga", true },
  { "petit-archer.com", true },
  { "petite-maison.ch", true },
  { "petitsfrenchies.com", true },
  { "petja.me", false },
  { "petko.me", true },
  { "petlife.vet", true },
  { "petmall.bg", true },
  { "peto.nl", true },
  { "petofiprogram.hu", true },
  { "petplus.com", true },
  { "petpost.co.nz", false },
  { "petpower.eu", true },
  { "petr.as", true },
  { "petrachuk.ru", true },
  { "petrasestakova.cz", true },
  { "petravdbos.nl", true },
  { "petresort.pt", true },
  { "petroleum-schools.com", true },
  { "petroscand.eu", true },
  { "petrostathis.com", true },
  { "petrpikora.com", true },
  { "petrucciresidential.com", true },
  { "petruzz.net", true },
  { "petschnighof.at", true },
  { "pettitcoat.com", true },
  { "petwall.info", true },
  { "pew.ninja", true },
  { "pewnews.org", true },
  { "pex.digital", true },
  { "peyote.com", true },
  { "pfa.or.jp", true },
  { "pfadfinder-aurich.de", true },
  { "pfarchimedes-pensioen123.nl", true },
  { "pfarre-kremsmuenster.at", true },
  { "pfcafeen.dk", true },
  { "pfd-nz.com", false },
  { "pfefferkuchen-shop.de", true },
  { "pfefferkuchenprinzessin-dresden.de", true },
  { "pferdekauf.de", true },
  { "pfeuffer-elektro.de", true },
  { "pfft.net", true },
  { "pfk.org.pl", true },
  { "pflan.dk", true },
  { "pflanzen-shop.ch", true },
  { "pflanzenshop-emsland.de", true },
  { "pflegesalon-siebke.de", true },
  { "pflug.email", true },
  { "pfmeasure.com", true },
  { "pfotentour-berlin.de", true },
  { "pfudor.tk", true },
  { "pg-forum.de", true },
  { "pg-mana.net", true },
  { "pgh-art.com", true },
  { "pglandscapingpaving.com", true },
  { "pgmann.cf", true },
  { "pgnetwork.net", true },
  { "pgp.guru", true },
  { "pgp.network", true },
  { "pgpmail.cc", true },
  { "ph-blog.de", true },
  { "ph.search.yahoo.com", false },
  { "ph3r3tz.net", true },
  { "phantasie.cc", true },
  { "phantastikon.de", true },
  { "pharma-display.com", true },
  { "pharmaabsoluta.com.br", true },
  { "pharmaboard.de", true },
  { "pharmacie-fr.org", true },
  { "pharmacieplusfm.ch", true },
  { "pharmafoto.ch", true },
  { "pharmaphoto.ch", true },
  { "pharmapolitics.com", true },
  { "pharmasana.co.uk", true },
  { "pharmasana.de", true },
  { "pharmica.co.uk", true },
  { "pharmica.uk", true },
  { "pharside.dyndns.org", true },
  { "pharynks.com", true },
  { "pharynx.nl", true },
  { "phasersec.com", false },
  { "phasme-2016.com", true },
  { "phattea.tk", true },
  { "phaux.uno", true },
  { "phcimages.com", true },
  { "phcnetworks.net", true },
  { "phcorner.net", true },
  { "phdhub.it", true },
  { "phellowseven.com", true },
  { "phelx.de", true },
  { "phenixairsoft.com", true },
  { "phenq.com", true },
  { "phget.com", true },
  { "phhtc.ir", true },
  { "phi-works.com", true },
  { "phialo.de", true },
  { "phil-dirt.com", true },
  { "phil-phillies.com", true },
  { "phil.red", true },
  { "phil.tw", true },
  { "philadelphia.com.mx", true },
  { "phileas-psychiatrie.be", true },
  { "philia-sa.com", true },
  { "philipdb.com", true },
  { "philipdb.nl", true },
  { "philipp-trulson.de", true },
  { "philipp-winkler.de", true },
  { "philipp1994.de", true },
  { "philippbirkholz.com", true },
  { "philippbirkholz.de", true },
  { "philippe-mignotte.fr", true },
  { "philippebonnard.fr", true },
  { "philipperoose.be", true },
  { "philippheenen.de", true },
  { "philippinedroneassociation.org", true },
  { "philippkeschl.at", true },
  { "philipssupportforum.com", true },
  { "philipzhan.tk", true },
  { "phillipgoldfarb.com", true },
  { "phillipsdistribution.com", true },
  { "phillyinjurylawyer.com", true },
  { "philna.sh", true },
  { "philosoftware.com.br", true },
  { "philosopherswool.com", true },
  { "philosophy-colleges.com", true },
  { "philosophy.moe", true },
  { "philosophyguides.org", true },
  { "philphonic.de", true },
  { "philslab.cloud", true },
  { "philslab.ninja", true },
  { "philsown.de", true },
  { "philsturgeon.uk", true },
  { "philux.ch", true },
  { "phishing-studie.org", true },
  { "phishingusertraining.com", true },
  { "phligence.com", true },
  { "phoenics.de", true },
  { "phoenixlogan.com", true },
  { "phoenixurbanspaces.com", true },
  { "phone-service-center.de", true },
  { "phonix-company.fr", true },
  { "phormance.com", true },
  { "phosagro.biz", false },
  { "phosagro.com", false },
  { "phosagro.ru", false },
  { "phosphene.io", true },
  { "photistic.org", true },
  { "photo-livesearch.com", true },
  { "photo-paysage.com", true },
  { "photo.org.il", true },
  { "photoancestry.com", true },
  { "photoartelle.com", true },
  { "photodeal.fr", true },
  { "photographe-reims.com", true },
  { "photographersdaydream.com", true },
  { "photography-workshops.net", true },
  { "photolium.net", false },
  { "photomodelcasting.com", true },
  { "phototravel.uk", true },
  { "phototrio.com", true },
  { "phoxmeh.com", true },
  { "php-developer.org", true },
  { "php-tuning.de", true },
  { "phparcade.com", true },
  { "phpartners.org", true },
  { "phpbbchinese.com", true },
  { "phpdorset.co.uk", true },
  { "phpinfo.in.th", true },
  { "phpkari.cz", true },
  { "phpliteadmin.org", true },
  { "phpmyadmin.net", true },
  { "phpower.com", true },
  { "phpprime.com", true },
  { "phpsecure.info", true },
  { "phpstan.org", true },
  { "phpunit.de", true },
  { "phrive.space", true },
  { "phryanjr.com", false },
  { "phuket-idc.com", true },
  { "phuket-idc.de", true },
  { "phunehehe.net", true },
  { "phurl.de", true },
  { "phurl.io", true },
  { "phus.lu", true },
  { "physicalism.com", true },
  { "physicalist.com", true },
  { "physicaltherapist.com", false },
  { "physics-schools.com", true },
  { "physiotherapie-seiwald.de", true },
  { "physiovesenaz.ch", true },
  { "pi-control.de", true },
  { "pi-dash.com", true },
  { "pi-net.dedyn.io", true },
  { "pi-supply.com", true },
  { "pianetaottica.com", true },
  { "pianetaottica.it", true },
  { "pianetatatuaggi.it", true },
  { "pianomover.co.uk", true },
  { "pianyigou.com", true },
  { "piatabrasil.com.br", true },
  { "piboubes.me", true },
  { "pic.gov", false },
  { "pic.sr", true },
  { "pic2map.com", true },
  { "picchietti.io", true },
  { "piccirello.com", true },
  { "piccolo-parties.co.uk", true },
  { "pickabrain.fr", true },
  { "pickelhaubes.com", true },
  { "pickersurvey.org", true },
  { "pickme.nl", false },
  { "pickmysoap.gr", true },
  { "pickormix.co.uk", true },
  { "picksin.club", true },
  { "piclect.com", true },
  { "picoauto.com", true },
  { "piconepress.com", true },
  { "picotech.com", true },
  { "picotronic.de", true },
  { "picster.at", true },
  { "picsto.re", true },
  { "pictorial.com.sg", true },
  { "pictorista.com", true },
  { "pictr.nl", true },
  { "picture.team", true },
  { "pictureguy.de", true },
  { "picturingjordan.com", true },
  { "pidginhost.com", true },
  { "pidjipi.com", true },
  { "pie-express.xxx", true },
  { "pieces-or.com", true },
  { "piekacz.eu.org", true },
  { "piekacz.net", true },
  { "piekacz.tel", true },
  { "pieland.eu", true },
  { "pieldenaranja.com", true },
  { "piem.org", true },
  { "pieq.eu", true },
  { "pieq.eu.org", true },
  { "pier28.com", true },
  { "piercing-store.com", true },
  { "piercraft.com", true },
  { "pierre-denoblens.net", true },
  { "pierre-schmitz.com", true },
  { "pierrefv.com", true },
  { "pierreprinetti.com", true },
  { "pierrickdeniel.fr", true },
  { "pietechsf.com", true },
  { "pieterbos.nl", true },
  { "pieterhordijk.com", true },
  { "pietermaene.be", false },
  { "pietz.uk", true },
  { "pigs.pictures", true },
  { "pijuice.com", true },
  { "pik.bzh", true },
  { "pikeitservices.com.au", true },
  { "pikimusic.moe", true },
  { "pilani.ch", true },
  { "pilarguineagil.com", true },
  { "pilatescenteraz.com", true },
  { "pildat.org", true },
  { "pileofgarbage.net", true },
  { "piliszek.net", true },
  { "pill.id", true },
  { "pilot-colleges.com", true },
  { "pilot.co", true },
  { "pilotgrowth.com", true },
  { "pilsoncontracting.com", true },
  { "pilvin.pl", true },
  { "pimg136.com", true },
  { "pimhaarsma.nl", true },
  { "pimhaarsmamedia.nl", true },
  { "pimpmyperf.fr", true },
  { "pinceaux.org", true },
  { "pincha.com.tw", false },
  { "pincodeit.com", true },
  { "pindanutjes.be", false },
  { "pinemountainnursery.com.au", true },
  { "pinemountbaptistchurch.org", true },
  { "pinetopazrealestate.com", true },
  { "pingworks.com", true },
  { "pingworks.de", true },
  { "pingworks.eu", true },
  { "pingworks.net", true },
  { "pinhadigital.com", true },
  { "pinimg.com", true },
  { "pinkapple.com", true },
  { "pinkbike.com", true },
  { "pinkbikecycle.com", true },
  { "pinkerton.io", true },
  { "pinkladyapples.co.uk", true },
  { "pinklecfest.org", true },
  { "pinklittlenotebook.com", true },
  { "pinkwalk.co.nz", true },
  { "pinkyf.com", false },
  { "pinkylam.me", true },
  { "pinnacle-tex.com", true },
  { "pinnacleallergy.net", true },
  { "pinnaclelife.co.nz", true },
  { "pinnaclelife.nz", true },
  { "pinnacles.com", true },
  { "pinner.io", true },
  { "pinoydailytvshow.net", true },
  { "pinoyonlinetv.com", true },
  { "pinoytech.ph", true },
  { "pinpayments.com", true },
  { "pinpointengineer.co.uk", true },
  { "pinskupakki.fi", true },
  { "pinterest.at", true },
  { "pinterest.co.uk", true },
  { "pinterest.com", true },
  { "pinterest.de", true },
  { "pinterest.engineering", true },
  { "pinterest.ie", true },
  { "pinterest.info", true },
  { "pinterest.jp", true },
  { "pinterjann.is", true },
  { "pintosplumbing.co.za", true },
  { "pioneer-car.eu", true },
  { "pioneer-rus.ru", true },
  { "pipfrosch.com", true },
  { "pipocao.com", true },
  { "pirate.trade", true },
  { "piratebayproxy.tf", true },
  { "piraten-basel.ch", true },
  { "piraten-bv-nord.de", true },
  { "pirateparty.org.uk", true },
  { "pirateproxy.cam", true },
  { "pirateproxy.cat", true },
  { "pirateproxy.cc", true },
  { "pirateproxy.gdn", true },
  { "pirateproxy.ist", true },
  { "pirateproxy.la", true },
  { "pirateproxy.one", true },
  { "pirateproxy.pl", true },
  { "pirateproxy.pw", true },
  { "pirateproxy.red", true },
  { "pirateproxy.sh", true },
  { "pirateproxy.tf", true },
  { "pirateproxy.tv", true },
  { "pirates-comic.com", true },
  { "pirates.click", true },
  { "piratesforums.co", true },
  { "pircher.co.uk", true },
  { "pires.ovh", true },
  { "pirman.es", true },
  { "piroleikki.co.jp", true },
  { "piruchita.com", true },
  { "pirxpilot.me", true },
  { "piscine.roma.it", true },
  { "piseach.be", true },
  { "piskenfuerwehr.de", true },
  { "pissblau.com", true },
  { "pissflaps.co.uk", true },
  { "pisupp.ly", true },
  { "pitbullsecuritysolutions.ca", true },
  { "pitchpinecapital.com", true },
  { "pitchupp.com", true },
  { "pitfire.io", true },
  { "pitot-rs.org", true },
  { "pittmantraffic.co.uk", true },
  { "piubip.com.br", true },
  { "pivniraj.com", true },
  { "pivotaltracker.com", true },
  { "pivotanimation.org", true },
  { "piwko.co", true },
  { "pix5.de", true },
  { "pixabay.com", true },
  { "pixe2019.org", true },
  { "pixel-kraft.de", true },
  { "pixel.facebook.com", false },
  { "pixel.google.com", true },
  { "pixelbash.de", true },
  { "pixelcubed.com", true },
  { "pixelfou.com", true },
  { "pixelminers.net", true },
  { "pixelpirat.ch", true },
  { "pixelsquared.us", true },
  { "pixelurbia.com", true },
  { "pixelution.at", true },
  { "pixelz.cc", true },
  { "pixiv.cat", true },
  { "pixiv.moe", true },
  { "pixiv.rip", true },
  { "pixlfox.com", true },
  { "pixloc.fr", true },
  { "pizza-show.fr", true },
  { "pizzabesteld.nl", true },
  { "pizzabottle.com", false },
  { "pizzafest.ddns.net", true },
  { "pizzagigant.hu", true },
  { "pizzahut.ru", true },
  { "pizzalongaway.it", true },
  { "pizzeria-mehrhoog.de", true },
  { "pizzeriaamadeus.hr", true },
  { "pizzeriacolore.com", true },
  { "pj539999.com", true },
  { "pjentertainments.co.uk", true },
  { "pjili.com", true },
  { "pjleisure.co.uk", true },
  { "pjo.no", true },
  { "pjuu.com", false },
  { "pk.search.yahoo.com", false },
  { "pkbjateng.com", true },
  { "pkgt.de", false },
  { "pkirwan.com", true },
  { "pkisolutions.com", true },
  { "pkov.cz", true },
  { "pkphotobooths.co.uk", true },
  { "pkrank.com", true },
  { "pksps.com", true },
  { "pl-cours.ch", true },
  { "pl.search.yahoo.com", false },
  { "placasonline.com.br", true },
  { "placebet.pro", true },
  { "placedaffiliate.com", true },
  { "placedapps.com", true },
  { "placedsupport.com", true },
  { "placeitsf.com", true },
  { "placeralplato.com", true },
  { "placker.com", true },
  { "plae.com.au", true },
  { "plainbulktshirts.co.za", true },
  { "plainjs.com", true },
  { "plainmark.com", true },
  { "plaintech.net.au", true },
  { "plaisirdumouvement.com", true },
  { "plan-immobilier.fr", true },
  { "plan-it-events.de", true },
  { "planboardapp.com", true },
  { "planecon.nz", true },
  { "planer.me", true },
  { "planespotterblog.de", true },
  { "planet-laas.de", true },
  { "planet-work.com", true },
  { "planetanim.fr", true },
  { "planetasuboficial.com.br", true },
  { "planetau2.com", true },
  { "planetbreath.ch", true },
  { "planete-cocoon.com", false },
  { "planete-lira.fr", true },
  { "planeteroliste.com", true },
  { "planeteroliste.fr", true },
  { "planetknauer.net", true },
  { "planetofthegames.tv", true },
  { "planetromeofoundation.org", true },
  { "planetsoftware.com.au", true },
  { "planify.io", true },
  { "planitz.com", true },
  { "planitz.net", true },
  { "planktonforhealth.co.uk", true },
  { "planktonholland.nl", true },
  { "planlos.net", true },
  { "planmemberpartners.com", true },
  { "plannedlink.com", true },
  { "planningexcellence.com.au", true },
  { "plant-gift.jp", true },
  { "plantarum.com.br", true },
  { "plantastique.ch", true },
  { "plantastique.com", true },
  { "planteforum.no", true },
  { "plantekno.com", true },
  { "plantes.ch", true },
  { "plantezcheznous.com", true },
  { "plantrustler.com", true },
  { "planujemywesele.pl", true },
  { "planup.fr", true },
  { "planview.com", true },
  { "plaque-funeraire.fr", true },
  { "plassmann.ws", true },
  { "plastovelehatko.cz", true },
  { "plateformecandidature.com", true },
  { "platformadmin.com", true },
  { "platinumexpress.com.ar", true },
  { "platomania.nl", true },
  { "platschi.net", true },
  { "platten-nach-mass.de", true },
  { "platterlauncher.com", true },
  { "plattner.club", true },
  { "play-casino-japan.com", true },
  { "play-charades.com", true },
  { "play.cash", true },
  { "play.google.com", true },
  { "playanka.com", true },
  { "playawaycastles.co.uk", true },
  { "playcollect.net", true },
  { "playdaysparties.co.uk", true },
  { "playerdb.co", true },
  { "players2gather.com", true },
  { "playerscout.net", true },
  { "playform.cloud", true },
  { "playhappywheelsunblocked.com", true },
  { "playnation.io", true },
  { "playocean.net", true },
  { "playpirates.com", true },
  { "playreal.city", true },
  { "playsharp.com", true },
  { "playsnake.org", true },
  { "playtictactoe.org", true },
  { "playtimebouncycastles.co.uk", true },
  { "playupnow.com", true },
  { "playviolinmusic.com", true },
  { "playzonecastles.co.uk", true },
  { "plazasummerlin.com", true },
  { "pld-entertainment.co.uk", true },
  { "pldx.org", true },
  { "pleasure-science.com", true },
  { "plegro.com", true },
  { "pleiades.com.tr", true },
  { "pleier-it.de", false },
  { "pleier.it", false },
  { "pleine-conscience.ch", true },
  { "plenigo.com", true },
  { "plesse.pl", true },
  { "plexa.de", true },
  { "plexhome13.ddns.net", true },
  { "plexmark.tk", true },
  { "plextv.de", true },
  { "plicca.com", true },
  { "pliosoft.com", true },
  { "plissee-experte.de", true },
  { "plitu.de", true },
  { "plixer.com", true },
  { "plny.eu", true },
  { "plob.org", true },
  { "plochka.bg", true },
  { "plokko.com", true },
  { "plongee-phuket.fr", true },
  { "ploofer.com", true },
  { "plot.ly", true },
  { "plotbubble.com", true },
  { "ploxel.com", true },
  { "plr4wp.com", true },
  { "plsboop.me", true },
  { "pluga.co", true },
  { "plugcubed.net", false },
  { "plugin-planet.com", true },
  { "pluginfactory.io", true },
  { "pluginsloaded.com", true },
  { "pluimveeplanner.nl", true },
  { "plumber-in-sandton.co.za", true },
  { "plumbermountedgecombe.co.za", true },
  { "plumberumhlangarocks.co.za", true },
  { "plumbingandheatingspecialistnw.com", true },
  { "plumbingbenoni.co.za", true },
  { "plumbingcentral.com.au", true },
  { "plumbingglenvista.co.za", true },
  { "plumlocosoft.com", true },
  { "plumnet.ch", true },
  { "plumpie.net", false },
  { "plumplat.com", true },
  { "plur.com.au", true },
  { "plural.cafe", true },
  { "plurr.me", true },
  { "plus-5.com", true },
  { "plus.google.com", false },
  { "plus.sandbox.google.com", true },
  { "plus1s.site", true },
  { "pluscbdoil.com", true },
  { "pluslink.co.jp", true },
  { "plusstreamfeed.appspot.com", true },
  { "plustech.id", true },
  { "pluta.net", true },
  { "plutiedev.com", true },
  { "pluto.life", true },
  { "plutokorea.com", true },
  { "plutopia.ch", true },
  { "plymouthbouncycastles.co.uk", true },
  { "plzdontpwn.me", true },
  { "plzenskybarcamp.cz", true },
  { "plzh4x.me", true },
  { "plzz.de", true },
  { "pm-onboarding-external-dev.azurewebsites.net", true },
  { "pm-partners-management-dev.azurewebsites.net", true },
  { "pm.me", true },
  { "pm13.cz", true },
  { "pm13.org", true },
  { "pm25.im", true },
  { "pma-iss.com", true },
  { "pmaene.be", false },
  { "pmalaty.com", true },
  { "pmarques.info", true },
  { "pmartin.tech", true },
  { "pmbc.org", true },
  { "pmconference.ch", true },
  { "pmf.gov", true },
  { "pmg-offshore-company.com", true },
  { "pmg-purchase.com", true },
  { "pmg-purchase.net", true },
  { "pmgnet.de", true },
  { "pmklaassen.com", true },
  { "pmnaish.co.uk", true },
  { "pmoreau.org", true },
  { "pmp-art.com", true },
  { "pmsacorp.com", true },
  { "pmsf.eu", true },
  { "pmsfdev.com", true },
  { "pmt-documenten.nl", true },
  { "pn.id.lv", true },
  { "pnakosoft.com", true },
  { "pnakosoft.com.au", true },
  { "pneu01.fr", true },
  { "pneu74.fr", true },
  { "pneuhaus-lemp.ch", true },
  { "pnimmobilier.ch", true },
  { "pnmhomecheckup.com", true },
  { "pnoec.org.do", true },
  { "pnona.cz", true },
  { "pnsc.is", true },
  { "pnut.io", false },
  { "po.net", true },
  { "poba.fr", true },
  { "poc.xn--fiqs8s", true },
  { "poc060.com", true },
  { "poc080.com", true },
  { "poc100.com", true },
  { "poc109.com", true },
  { "poc11.com", true },
  { "poc116.com", true },
  { "poc118.com", true },
  { "poc119.com", true },
  { "poc120.com", true },
  { "poc128.com", true },
  { "poc13.com", true },
  { "poc15.com", true },
  { "poc16.com", true },
  { "poc17.com", true },
  { "poc18.com", true },
  { "poc19.com", true },
  { "poc21.com", true },
  { "poc211.com", true },
  { "poc22.com", true },
  { "poc226.com", true },
  { "poc228.com", true },
  { "poc23.com", true },
  { "poc25.com", true },
  { "poc26.com", true },
  { "poc261.com", true },
  { "poc262.com", true },
  { "poc27.com", true },
  { "poc290.com", true },
  { "poc298.com", true },
  { "poc31.com", true },
  { "poc32.com", true },
  { "poc33.com", true },
  { "poc35.com", true },
  { "poc36.com", true },
  { "poc37.com", true },
  { "poc38.com", true },
  { "poc51.com", true },
  { "poc518.com", true },
  { "poc52.com", true },
  { "poc53.com", true },
  { "poc55.com", true },
  { "poc56.com", true },
  { "poc568.com", true },
  { "poc57.com", true },
  { "poc58.com", true },
  { "poc586.com", true },
  { "poc588.com", true },
  { "poc59.com", true },
  { "poc601.com", true },
  { "poc618.com", true },
  { "poc63.com", true },
  { "poc65.com", true },
  { "poc66.com", true },
  { "poc67.com", true },
  { "poc68.com", true },
  { "poc69.com", true },
  { "poc699.com", true },
  { "poc7.com", true },
  { "poc718.com", true },
  { "poc72.com", true },
  { "poc75.com", true },
  { "poc76.com", true },
  { "poc77.com", true },
  { "poc78.com", true },
  { "poc79.com", true },
  { "poc8.com", true },
  { "poc816.com", true },
  { "poc86.com", true },
  { "poc88.com", true },
  { "poc88.vip", true },
  { "poc888.com", true },
  { "poc89.com", true },
  { "poc899.com", true },
  { "poc916.com", true },
  { "poc918.com", true },
  { "poc98.com", true },
  { "poc99.com", true },
  { "pocatellonissanparts.com", true },
  { "pochaneko.com", true },
  { "pocitacezababku.cz", true },
  { "pocketfruity.com", true },
  { "pocketinsure.com", true },
  { "pocpok.com", true },
  { "pocqipai.com", true },
  { "podemos.info", true },
  { "podia.com.gr", false },
  { "podroof.com", true },
  { "podroof.com.au", true },
  { "podshrink.de", true },
  { "poe.digital", true },
  { "poed.net.au", true },
  { "poedgirl.com", true },
  { "poezja.com.pl", true },
  { "poezjagala.pl", true },
  { "poffenhouse.ddns.net", true },
  { "pogera.com", true },
  { "pogrebisky.net", true },
  { "pohlednice-tap.cz", true },
  { "pohlmann.io", true },
  { "poinsot.info", true },
  { "pointaction.com", true },
  { "pointhost.de", true },
  { "pointsgame.net", true },
  { "pointsixtyfive.com", true },
  { "pointum.com", true },
  { "poiru.net", true },
  { "poitiers-ttacc-86.eu.org", true },
  { "pojer.me", true },
  { "pokazy-iluzji.pl", true },
  { "pokefarm.com", true },
  { "pokeinthe.io", true },
  { "pokemondb.net", true },
  { "pokemonlab.com", true },
  { "pokemonsimulator.com", true },
  { "pokemontabletopadventures.com", true },
  { "pokemori.jp", true },
  { "pokepon.center", true },
  { "pokl.cz", true },
  { "polaire.org", true },
  { "polanda.com", true },
  { "polar-baer.com", true },
  { "polar.uk.com", true },
  { "pole-emotion.ch", true },
  { "poleacademie.com", true },
  { "poles4pilots.com", true },
  { "police-schools.com", true },
  { "policedriver.com", true },
  { "policereferencecheck.com", true },
  { "policesromandesrecrutement.ch", true },
  { "policyreporter.com", true },
  { "policyreporter.us", true },
  { "polinet.de", true },
  { "polis.or.at", true },
  { "polis.to", false },
  { "polis812.ru", true },
  { "polish-dictionary.com", true },
  { "polish-flag.com", true },
  { "polish-translator.com", true },
  { "polish-translator.net", true },
  { "polish-translators.net", true },
  { "polishforums.com", true },
  { "polishmarriage.org", true },
  { "polishtranslation.com", true },
  { "polishwomen.com", true },
  { "polit.im", true },
  { "politic.org.ua", true },
  { "politicachubut.com.ar", true },
  { "political-science-schools.com", true },
  { "politiezoneriho.be", true },
  { "politik-bei-uns.de", true },
  { "polizeiwallis.ch", true },
  { "polkhealthforanewyou.net", true },
  { "polki.com", true },
  { "pollet-ghijs.be", true },
  { "pollet-ghys.be", true },
  { "polletmera.com", true },
  { "polleverywhere.com", true },
  { "pollingplace.uk", true },
  { "polly.spdns.org", true },
  { "poloniainfo.com", true },
  { "polska-robota.com.ua", true },
  { "polskiemalzenstwo.org", true },
  { "poly-fast.com", true },
  { "polycraftual.co.uk", true },
  { "polyfluoroltd.com", false },
  { "polygamer.net", true },
  { "polygraphi.ae", true },
  { "polymake.org", true },
  { "polymathematician.com", true },
  { "polynomapp.com", true },
  { "polypane.rocks", true },
  { "polypet.com.sg", true },
  { "polyr.xyz", true },
  { "polytarian.com", true },
  { "polytekniskforening.dk", true },
  { "pomar.club", false },
  { "pomelo-paradigm.com", true },
  { "pomfeed.fr", true },
  { "pommedepain.fr", true },
  { "pomockypredeti.sk", true },
  { "pomocniczy.eu.org", true },
  { "pomozmruczkom.pl", true },
  { "pompiers-martigny.ch", true },
  { "pomsinoz.com", true },
  { "poncho-bedrucken.de", true },
  { "ponere.dz", true },
  { "poneypourtous.com", true },
  { "poneytelecom.org", true },
  { "ponga.se", true },
  { "ponio.xyz", true },
  { "pony-cl.co.jp", true },
  { "pony.tf", true },
  { "ponychan.net", true },
  { "ponycyclepals.co.uk", true },
  { "ponydesignclub.nl", true },
  { "ponyfoo.com", true },
  { "poodleassassin.com", true },
  { "poodlefan.net", true },
  { "pookl.com", true },
  { "poolsafely.gov", true },
  { "poolsafety.gov", true },
  { "poolspondsandwaterscapes.com", true },
  { "pooltools.net", true },
  { "poolvilla-margarita.net", false },
  { "poon.io", true },
  { "poopjournal.rocks", true },
  { "poopr.ru", true },
  { "poorclarepa.org", true },
  { "pop-corn.ro", true },
  { "pop3.jp", true },
  { "popcat.ru", true },
  { "popcornpalacefundraising.com", true },
  { "popeyes.com", true },
  { "popinga.it", true },
  { "popmagz.com", true },
  { "popoway.cloud", true },
  { "popoway.me", true },
  { "poppetsphere.de", true },
  { "population-ethics.com", true },
  { "popvitrin.com", true },
  { "poquvi.net", true },
  { "porchdaydreamer.com", true },
  { "porg.es", true },
  { "pork.org.uk", true },
  { "porkel.de", true },
  { "pornagent.de", true },
  { "pornbay.eu", true },
  { "porndragon.net", true },
  { "pornfacefinder.com", false },
  { "pornflare.net", true },
  { "porngay.co", true },
  { "pornhubhd.biz", true },
  { "porniwi.com", true },
  { "pornloupe.com", true },
  { "pornmega.net", true },
  { "pornofilmovi.us", true },
  { "pornomens.be", true },
  { "pornovk.xxx", true },
  { "pornshop.biz", true },
  { "pornspider.to", true },
  { "pornstop.net", true },
  { "pornsuper.net", true },
  { "porny.xyz", true },
  { "pors-sw.cz", true },
  { "port443.hamburg", true },
  { "port443.se", true },
  { "port67.org", true },
  { "port80.hamburg", true },
  { "portablebuildingsales.co.uk", true },
  { "portablespeakersfinder.com", true },
  { "portailevangelique.ca", true },
  { "portal.tirol.gv.at", true },
  { "portalcarriers.com", true },
  { "portalcentric.net", true },
  { "portalkla.com.br", true },
  { "portamiinpista.it", true },
  { "portatiles-baratos.net", true },
  { "porte.roma.it", true },
  { "portercup.com", true },
  { "porterranchelectrical.com", true },
  { "portofacil.com", true },
  { "portofala.pt", true },
  { "portofrotterdam.com", false },
  { "portosonline.pl", true },
  { "portsdebalears.gob.es", true },
  { "portsmouthbouncycastles.co.uk", true },
  { "portsmoutheic.com", true },
  { "portugal-a-programar.pt", true },
  { "portugalsko.net", true },
  { "portvincentcaravanpark.com.au", true },
  { "porybox.com", true },
  { "pos.co.tz", true },
  { "posalji.me", true },
  { "posaunenchor-senden.de", true },
  { "posbank.co.uk", true },
  { "poschtiliste.ch", true },
  { "poseidonwaterproofing.com", true },
  { "poshcastles.co.uk", true },
  { "poshlashes.se", true },
  { "poshsecurity.com", true },
  { "posijson.stream", true },
  { "positionus.io", true },
  { "positive.com.cy", true },
  { "posobota.cz", true },
  { "posoiu.net", true },
  { "post-darwinian.com", true },
  { "post-darwinism.com", true },
  { "post.com.ar", true },
  { "post.io", true },
  { "post4me.at", true },
  { "postal.dk", true },
  { "postal3.es", true },
  { "postblue.info", true },
  { "postbox.life", true },
  { "postcode.nl", true },
  { "postcodewise.co.uk", true },
  { "postdarwinian.com", true },
  { "postdarwinism.com", true },
  { "posteo.de", false },
  { "posterspy.com", true },
  { "postfalls-naturopathic.com", true },
  { "postfinance.ch", true },
  { "postmatescode.com", true },
  { "postn.eu", true },
  { "postpot.co.kr", true },
  { "posttigo.com", true },
  { "postura-corretta.it", true },
  { "posyperfume.com", true },
  { "potatiz.com", true },
  { "potatofrom.space", true },
  { "potatopro.com", true },
  { "potature.rimini.it", true },
  { "potature.roma.it", true },
  { "potentialproject.com", false },
  { "poterepersonale.it", true },
  { "pothe.com", true },
  { "pothe.de", true },
  { "potolok.am", true },
  { "potrillionaires.com", true },
  { "potterscraftcider.com", true },
  { "pottersheartministry.org", true },
  { "pottreid.com", false },
  { "pottshome.co.uk", true },
  { "potworowski.de", true },
  { "potzwonen.nl", true },
  { "poudlard.fr", true },
  { "poundwholesale.co.uk", true },
  { "pourlesenfants.info", true },
  { "pouwels-oss.nl", true },
  { "povareschka.ru", true },
  { "povertymind.com", true },
  { "povesham.tk", true },
  { "pow-s.com", true },
  { "pow.jp", true },
  { "powdersnow.top", true },
  { "powelljones.co.uk", true },
  { "power-fit.org", true },
  { "power-flowengineer.com", true },
  { "power-meter.cc", true },
  { "power-tools24.com", true },
  { "powerball.shop", true },
  { "powerblanket.com", true },
  { "powercloud.technology", true },
  { "poweredbyiris.nl", true },
  { "poweredbypurdy.com", true },
  { "powerfortunes.com", true },
  { "powerinboxperformance.com", true },
  { "powermatic7.com", true },
  { "powermeter.at", true },
  { "powermint.de", true },
  { "powerplaywashers.com", true },
  { "powerpointschool.com", true },
  { "powerserg.org", true },
  { "powersergdatasystems.com", true },
  { "powersergholdings.com", true },
  { "powersergthisisthetunnelfuckyouscott.com", true },
  { "powersergthisisthewebsitefuckyouchris.com", true },
  { "powersergthisisthewebsitefuckyouscott.com", true },
  { "powerwellness-korecki.de", true },
  { "pozemedicale.org", true },
  { "pozlife.net", true },
  { "pp-server.com", true },
  { "pp3345.net", true },
  { "ppcrestaurants.com", true },
  { "ppipe.net", true },
  { "pplsoft.nl", true },
  { "pplsvc.com", true },
  { "ppmathis.ch", true },
  { "ppmathis.com", true },
  { "ppmoon.com", true },
  { "ppro.com", true },
  { "pptavmdata.org", true },
  { "ppy.la", true },
  { "ppy.sh", true },
  { "pr.search.yahoo.com", false },
  { "pr1sm.com", true },
  { "pr2studio.com", true },
  { "prac.to", true },
  { "pracevjihlave.cz", true },
  { "pracowniatkanin.com", true },
  { "practicallabs.com", true },
  { "practicalprogrammer.tech", true },
  { "practiceflow.nl", true },
  { "practicepanther.com", true },
  { "practisforms.com", true },
  { "practo.com", true },
  { "prado.it", true },
  { "praeparation-keppner.de", true },
  { "praerien-racing.com", true },
  { "praetzlich-hamburg.de", true },
  { "prague-swim.cz", true },
  { "praguepsychology.com", true },
  { "praguepsychology.cz", true },
  { "pragueswim.cz", true },
  { "praha-9.eu", true },
  { "prajwalkoirala.com", true },
  { "prakhar.uk", true },
  { "prakharprasad.com", true },
  { "praktijkdevecht.nl", true },
  { "praktijkpassepartout.nl", true },
  { "prashchar.uk", true },
  { "pratopronto.org", true },
  { "pratorotoli.it", true },
  { "praxino.de", true },
  { "praxis-dingeldey.de", true },
  { "praxis-familienglueck.de", true },
  { "praxis-odermath.de", true },
  { "prayerrequest.com", true },
  { "prc-newmedia.com", true },
  { "prc.gov", true },
  { "pre-lean-consulting.de", true },
  { "precept.uk.com", true },
  { "preciosde.es", true },
  { "preciouslife.fr", true },
  { "preciscx.com", true },
  { "preciseassemblies.com", true },
  { "precision.st", true },
  { "precisiondigital-llc.com", true },
  { "precisionmachineservice.com", true },
  { "precisionventures.com", true },
  { "precode.eu", true },
  { "predoiu.ro", true },
  { "preferredreverse.com", true },
  { "prefix.eu", true },
  { "pregunteleakaren.gov", true },
  { "preigu.de", true },
  { "preis-alarm.info", true },
  { "preis-alarm.org", true },
  { "preisser-it.de", true },
  { "preisser.it", true },
  { "preissler.co.uk", true },
  { "preload.link", true },
  { "preloaded-hsts.badssl.com", true },
  { "prelogica.com.br", true },
  { "preludes.org", true },
  { "prelved.com", true },
  { "prelved.es", true },
  { "prelved.fi", true },
  { "prelved.fr", true },
  { "prelved.it", true },
  { "prelved.nl", true },
  { "prelved.pl", true },
  { "prelved.se", true },
  { "prematureacceleration.club", true },
  { "premierbouncycastles.co.uk", true },
  { "premieresloges.ca", false },
  { "premierevents.ie", true },
  { "premierheart.com", true },
  { "premierjewelersjax.com", true },
  { "premiership-predictors.co.uk", true },
  { "premiumcredit.am", true },
  { "premiumweb.co.id", true },
  { "premiumwebdesign.it", true },
  { "premtech.nl", true },
  { "prenatalgeboortekaartjes.nl", true },
  { "prepadefi.fr", true },
  { "prepaid-cards.xyz", true },
  { "prepaid-voip.nl", true },
  { "prepaidkredietkaart.be", true },
  { "prepare-job-hunting.com", true },
  { "prepavesale.fr", true },
  { "presbee.com", true },
  { "presbvm.org", true },
  { "presbyterian-colleges.com", true },
  { "prescotonline.co.uk", true },
  { "present-m.com", true },
  { "presentationmedia.com", true },
  { "preserveourhillcountry.org", true },
  { "president.bg", true },
  { "presidio.gov", true },
  { "prespanok.sk", true },
  { "pressakey.com", true },
  { "presscenter.jp", true },
  { "presscuozzo.com", true },
  { "pressertech.com", true },
  { "presses.ch", true },
  { "presskr.com", true },
  { "pressography.org", true },
  { "pressrush.com", true },
  { "pressup.it", true },
  { "pressureradio.com", true },
  { "prestige-car-location.ch", true },
  { "prestige-portal.com", true },
  { "prestigebouncycastles.co.uk", true },
  { "prestigerepairs.com.au", true },
  { "prestigesigns.net", true },
  { "prestonandsons.com.au", true },
  { "prestonbrant.com", true },
  { "pretachique.com.br", true },
  { "pretix.eu", true },
  { "pretrialservices.gov", true },
  { "pretty.hu", true },
  { "prettygirlcheats.com", true },
  { "prettynode.com", true },
  { "pretzelx.com", true },
  { "prevenir.ch", true },
  { "preventshare.com", true },
  { "preview-it-now.com", true },
  { "priceremoval.net", true },
  { "pricesniffer.co", true },
  { "pridetechdesign.com", false },
  { "prielwurmjaeger.de", true },
  { "prihatno.my.id", true },
  { "primalbase.com", true },
  { "primalinea.pro", true },
  { "primates.com", true },
  { "primeequityproperties.com", true },
  { "primoloyalty.com", true },
  { "primorus.lt", true },
  { "princeofwhales.com", true },
  { "princesparktouch.com", true },
  { "princessefoulard.com", true },
  { "principalsexam.com", true },
  { "principalship.net", true },
  { "principalstest.com", true },
  { "principalstest.ph", true },
  { "principalstest.review", true },
  { "principaltoolbox.com", true },
  { "principia-journal.de", true },
  { "principia-magazin.de", true },
  { "principia-online.de", true },
  { "princovi.cz", true },
  { "prinice.org", true },
  { "printeknologies.com", true },
  { "printerinktoutlet.nl", true },
  { "printerleasing.be", true },
  { "printertonerkopen.nl", true },
  { "printf.de", true },
  { "printfn.com", false },
  { "printler.com", true },
  { "printmet.com", true },
  { "printus.de", true },
  { "prior-it.be", true },
  { "priorite-education.com", true },
  { "priorityelectric-agourahills.com", true },
  { "priorityelectric-calabasas.com", true },
  { "priorityelectric-camarillo.com", true },
  { "priorityelectric-dosvientos.com", true },
  { "priorityelectric-hiddenhills.com", true },
  { "priorityelectric-lakesherwood.com", true },
  { "priorityelectric-malibu.com", true },
  { "priorityelectric-moorpark.com", true },
  { "priorityelectric-newburypark.com", true },
  { "priorityelectric-oakpark.com", true },
  { "priorityelectric-simivalley.com", true },
  { "priorityelectric-thousandoaks.com", true },
  { "priorityelectric-westlakevillage.com", true },
  { "priorityelectric.biz", true },
  { "priorityelectric.info", true },
  { "priorityelectric.mobi", true },
  { "priorityelectric.net", true },
  { "priorityessays.com", true },
  { "prioritylawyers.com.au", true },
  { "prioritynissannewportnewsparts.com", true },
  { "prismacloud.com", true },
  { "prismacloud.green", true },
  { "prismacloud.xyz", true },
  { "prismapayments.com", true },
  { "pristal.eu", true },
  { "pristinegreenlandscaping.com", true },
  { "pritalk.com", true },
  { "priv.im", true },
  { "privacy-week-vienna.at", true },
  { "privacy-week.at", true },
  { "privacy.com", true },
  { "privacybadger.org", true },
  { "privacychick.com", true },
  { "privacychick.io", true },
  { "privacyforjournalists.org.au", true },
  { "privacyinternational.org", true },
  { "privacynow.eu", true },
  { "privacyscore.org", true },
  { "privacyweek.at", true },
  { "privacyweek.de", true },
  { "privacyweek.eu", true },
  { "privacyweekvienna.at", true },
  { "privaday.de", false },
  { "privasphere.com", true },
  { "privatebanks.uk", true },
  { "privatebin.info", true },
  { "privatecapsecurity.org", true },
  { "privateideas.de", true },
  { "privateimarketing.com", true },
  { "privatepokertour.com", true },
  { "privatepropertymallorca.com", true },
  { "privatestatic.com", false },
  { "privatevoid.net", true },
  { "privatewolke.com", true },
  { "privatfrei.de", true },
  { "privatpatient-krankenhaus.de", true },
  { "privea.fr", true },
  { "privelust.nl", true },
  { "priverify.com", true },
  { "privy-staging.com", true },
  { "privy.com", true },
  { "prjktruby.com", false },
  { "prknje.co", true },
  { "prknje.com", true },
  { "prlved.co.uk", true },
  { "prnav.com", true },
  { "pro-ben.sk", true },
  { "pro-bike.ro", true },
  { "pro-link.eu", true },
  { "pro-mile.pl", true },
  { "pro-netz.de", false },
  { "pro-taucher.com", true },
  { "pro-taucher.de", true },
  { "pro-wiert.pl", true },
  { "proactivestructuresolutions.com", true },
  { "proadvanced.com", true },
  { "proautorepairs.com.au", true },
  { "probase.ph", true },
  { "probely.com", true },
  { "probiv.biz", true },
  { "probiv.cc", true },
  { "procar-rheinland.de", true },
  { "procarservices.com", true },
  { "procensus.com", true },
  { "procert.ch", true },
  { "processesinmotion.com", true },
  { "procharter.com", true },
  { "procinorte.net", true },
  { "proclib.org", true },
  { "procrastinationland.com", true },
  { "procreditbank-kos.com", true },
  { "procreditbank.com.al", true },
  { "proctorio.com", true },
  { "prodct.info", true },
  { "prodegree.com", true },
  { "prodietix.cz", true },
  { "prodigia.com", false },
  { "prodinger.com", true },
  { "prodottogiusto.com", true },
  { "prodsim.ninja", true },
  { "producepromotions.com", true },
  { "producertools.io", true },
  { "productbarcodes.com", true },
  { "productboard.com", true },
  { "productdesignsoftware.com.au", true },
  { "production.vn", true },
  { "productlondon.com", true },
  { "productoinnovador.com", true },
  { "productpeo.pl", true },
  { "products4more.at", true },
  { "produkttest-online.com", true },
  { "prodware.fr", true },
  { "prodware.nl", true },
  { "proeflokaalbakker.nl", true },
  { "proefteksten.nl", false },
  { "proeftuinveenweiden.nl", true },
  { "proemployeeprotection.com", true },
  { "proemployeeprotection.net", true },
  { "prof.ch", true },
  { "profection.biz", true },
  { "professional.cleaning", true },
  { "professionalboundaries.com", true },
  { "professors.ee", true },
  { "profhome-shop.com", true },
  { "profidea.cz", true },
  { "profile.tf", true },
  { "profiles.google.com", true },
  { "profitablewebprojects.com", true },
  { "profitopia.de", true },
  { "proft.eu", true },
  { "progarm.org", true },
  { "progenda.be", true },
  { "progenitor.space", true },
  { "progeon.nl", true },
  { "progettograjau.com", true },
  { "progg.no", true },
  { "proggersession.com", true },
  { "proggersession.de", true },
  { "progiscad.com", true },
  { "programistka.com", true },
  { "programlama.tk", true },
  { "programmaticmagic.com", true },
  { "programsareproofs.com", true },
  { "programsupport300procent.com", true },
  { "progreso.pl", true },
  { "progress-linux.org", true },
  { "progress.photos", true },
  { "progressive.work", true },
  { "progressiveplanning.com", true },
  { "progressnet.nl", true },
  { "progresswww.nl", true },
  { "prohrcloud.com", true },
  { "proimpact.it", true },
  { "project.supply", true },
  { "project86fashion.com", true },
  { "projectarmy.net", false },
  { "projectblackbook.us", true },
  { "projectborealisgitlab.site", true },
  { "projectforge.org", true },
  { "projectgrimoire.com", true },
  { "projectlinuseasttn.org", true },
  { "projectnom.com", true },
  { "projectsafechildhood.gov", true },
  { "projectsecretidentity.com", true },
  { "projectsecretidentity.org", true },
  { "projectxyz.eu", true },
  { "projektarbeit-projektplanung.de", true },
  { "projektzentrisch.de", true },
  { "projest.ch", true },
  { "prolan.pw", true },
  { "prolearningcentre.com", true },
  { "prolinos.de", true },
  { "promedyczny.pl", true },
  { "prometheanfire.net", true },
  { "prometheanfire.org", true },
  { "promiflash.de", true },
  { "promisesaplus.com", true },
  { "promo-brille.at", true },
  { "promo-brille.ch", true },
  { "promo-brille.de", true },
  { "promo-computers.nl", true },
  { "promo-matelas.com", true },
  { "promods.cn", true },
  { "promods.net", true },
  { "promohulp.nl", true },
  { "promolover.com", true },
  { "promopony.com", true },
  { "promorder.ru", true },
  { "promoscuola.net", true },
  { "promoteiq.com", true },
  { "promoterms.com.au", true },
  { "promotioncentre.co.uk", true },
  { "promozione.info", true },
  { "pronto-intervento.net", true },
  { "prontointerventoimmediato.it", true },
  { "prontossl.com", true },
  { "proobec.cz", true },
  { "proofwiki.org", true },
  { "proos.nl", true },
  { "proovn.com", true },
  { "propagandablog.de", true },
  { "propagationtools.com", true },
  { "properchels.com", true },
  { "propermatches.com", true },
  { "properticons.com", true },
  { "property-catalogue.eu", true },
  { "propertygroup.pl", true },
  { "propertyinside.id", true },
  { "propertyone.mk", true },
  { "propipesystem.com", true },
  { "proposalonline.com", true },
  { "propr.no", true },
  { "proprietairesmaisons.fr", true },
  { "propseller.com", true },
  { "proseandleprechauns.com", true },
  { "prospanek.cz", true },
  { "prospecto.com.au", true },
  { "prospecto.ee", true },
  { "prospecto.hr", true },
  { "prospecto.lt", true },
  { "prosperfit.com", true },
  { "prosperontheweb.com", true },
  { "prospo.co", true },
  { "prostoporno.vip", true },
  { "prostye-recepty.com", true },
  { "prosurveillancegear.com", true },
  { "prot.ch", false },
  { "protech.ge", true },
  { "protectedreport.com", true },
  { "protectem.de", true },
  { "protectoraanimalesalicante.org", true },
  { "protectr.de", true },
  { "protege.moi", true },
  { "protegetudescanso.com", true },
  { "protein-riegel-test.de", true },
  { "protempore.fr", true },
  { "proteogenix-products.com", true },
  { "proteogenix.science", true },
  { "proteus-eretes.nl", true },
  { "proteus-tech.com", true },
  { "proto-online.ru", true },
  { "protobetatest.com", true },
  { "protocol.ai", true },
  { "protonmail.com", true },
  { "protonvpn.com", true },
  { "prototypefund.de", true },
  { "protoxin.net", false },
  { "proust.ch", false },
  { "proust.media", false },
  { "proustmedia.de", false },
  { "provectus.de", true },
  { "proveits.me", false },
  { "provence-appartements.com", true },
  { "providencecmc.com", true },
  { "providerlijst.com", true },
  { "providerlijst.ml", true },
  { "providerlijst.nl", true },
  { "provision-isr.nl", true },
  { "provitec.com", true },
  { "provitec.de", true },
  { "provokator.co.il", true },
  { "prowebcenter.com", true },
  { "prowise.com", true },
  { "prowise.me", true },
  { "proximityradio.fr", true },
  { "proxybay.bz", true },
  { "proxybay.co", true },
  { "proxybay.eu.org", true },
  { "proxybay.la", true },
  { "proxybay.one", true },
  { "proxybay.tv", true },
  { "proxyportal.eu", true },
  { "proyectafengshui.com", true },
  { "prpferrara.it", true },
  { "prplz.io", true },
  { "prt.in.th", true },
  { "prtimes.com", true },
  { "prtpe.com", true },
  { "pru.com.hk", true },
  { "pru.hk", true },
  { "pruma.com.br", true },
  { "prvikvadrat.hr", true },
  { "prylarprylar.se", true },
  { "prynhawn.com", true },
  { "prynhawn.net", true },
  { "prynhawn.org", true },
  { "pryspry.com", true },
  { "prytkov.com", true },
  { "przemas.pl", true },
  { "ps-provider.co.jp", true },
  { "ps-sale.ru", true },
  { "ps-w.ru", true },
  { "ps4all.nl", true },
  { "psa.gov", true },
  { "psb.cloud", true },
  { "psb1.org", true },
  { "psb1911.com", true },
  { "psb4ukr.org", true },
  { "psbarrett.com", true },
  { "psc.gov", true },
  { "pschierl.com", true },
  { "pscp.tv", true },
  { "pscr.gov", true },
  { "psdreams.com", true },
  { "psdsfn.com", true },
  { "psdsuc.com", true },
  { "pself.net", true },
  { "pseta.ru", true },
  { "psg-calw.de", true },
  { "psg.bg", true },
  { "pshostpk.com", true },
  { "psici.eu", true },
  { "psicoexpansao.com.br", true },
  { "psicologajanainapresotto.com.br", true },
  { "psicologasandrabernal.es", true },
  { "psicologo-especialista-barcelona.com", true },
  { "psicologo-infantil-barcelona.com", true },
  { "psicologoforensemadrid.com", true },
  { "psm.org.ph", true },
  { "psochecker.com", true },
  { "pson.ninja", true },
  { "psono.pw", true },
  { "psoriasischecker.com", true },
  { "pssgcsim.org", true },
  { "pst.moe", true },
  { "pste.pw", true },
  { "psu.je", true },
  { "psw-consulting.de", true },
  { "psw-group.de", true },
  { "psw.net", true },
  { "psxtr.com", true },
  { "psyao.ch", true },
  { "psychedelia.com", true },
  { "psychedelics.org", true },
  { "psychic-healer-mariya-i-petrova-boyankinska-b-borovan-bg.com", true },
  { "psychintervention.com", true },
  { "psychiq.com", true },
  { "psycho-lobby.com", true },
  { "psycho.space", true },
  { "psychoactive.com", true },
  { "psychoco.net", false },
  { "psychotherapie-kp.de", true },
  { "psycolleges.com", true },
  { "psydix.org", true },
  { "psylab.cc", true },
  { "psylab.re", true },
  { "psylab.vip", true },
  { "psytrance-pro.com", true },
  { "pt-d.ru", true },
  { "pt-server.de", true },
  { "ptal.eu", true },
  { "ptbi.org.pl", true },
  { "ptbx.co", true },
  { "pterodactylus.cz", true },
  { "ptfiber.com", true },
  { "ptfiber.ru", true },
  { "ptfiber.spb.ru", true },
  { "ptgoldensun.com", true },
  { "pthsec.com", true },
  { "ptm.ro", false },
  { "ptmarquees.ie", true },
  { "ptr.kr", true },
  { "ptrbrs.nl", true },
  { "ptrl.ws", true },
  { "ptron.org", true },
  { "pty.gg", true },
  { "puac.de", true },
  { "pubclub.com", true },
  { "pubean.com", true },
  { "pubi.me", true },
  { "publanda.nl", true },
  { "public-g.de", true },
  { "public-projects.com", true },
  { "public-projects.de", true },
  { "public-vocals.de", true },
  { "publiccarauctionscalifornia.com", true },
  { "publicinquiry.eu", true },
  { "publicintegrity.org", true },
  { "publicintelligence.net", true },
  { "publicrea.com", true },
  { "publicsuffix.org", true },
  { "publiq.space", true },
  { "pubmire.com", false },
  { "pubreview.com.au", true },
  { "pubreviews.com", true },
  { "pucchi.net", true },
  { "pucssa.org", true },
  { "puddis.de", true },
  { "puestifiestas.mx", true },
  { "puestosdeferia.mx", true },
  { "puggan.se", true },
  { "pugovka72.ru", true },
  { "puhka.me", true },
  { "puissancemac.ch", true },
  { "pukfalkenberg.dk", true },
  { "pulizieuffici.milano.it", true },
  { "pulpproject.org", true },
  { "pulser.stream", true },
  { "pulsnitzer-lebkuchen-shop.de", true },
  { "pulsnitzer-lebkuchen.shop", true },
  { "pulsnitzer-pfefferkuchen-shop.de", true },
  { "pulsnitzer-pfefferkuchen.shop", true },
  { "pumperszene.com", true },
  { "punchlinetheatre.co.uk", true },
  { "punchunique.com", true },
  { "puneflowermall.com", true },
  { "punematka.com", true },
  { "punikonta.de", true },
  { "punitsheth.com", true },
  { "punkapoule.fr", true },
  { "punknews.org", true },
  { "puntacanalink.com", true },
  { "punte-juwelier.nl", true },
  { "pupboss.com", true },
  { "puppet.pl", true },
  { "puq.moe", true },
  { "puralps.ch", true },
  { "puravida-estate.com", true },
  { "pure-gmbh.com", true },
  { "purecabo.com", true },
  { "purefkh.xyz", true },
  { "purefreefrom.co.uk", true },
  { "pureitsolutionsllp.com", true },
  { "purelunch.co.uk", true },
  { "pureluxemedical.com", true },
  { "purenvi.ca", true },
  { "purevapeofficial.com", true },
  { "purplebooth.co.uk", false },
  { "purplebricks.co.uk", true },
  { "purplebricks.com", true },
  { "purplebricks.com.au", true },
  { "purplebricksplc.com", true },
  { "purplegrapegames.com", true },
  { "purplemet.com", true },
  { "purplemoon.ch", true },
  { "purplemoon.mobi", true },
  { "purpleplains.net", true },
  { "purplepr.bg", true },
  { "purplestar.ch", true },
  { "purplestar.com", true },
  { "purplestar.mobi", true },
  { "purplewindows.net", true },
  { "purrfect-box.co.uk", true },
  { "purrfectboudoir.com", true },
  { "purrfectcams.com", true },
  { "purrfectmembersclub.com", true },
  { "purrfectswingers.com", true },
  { "pursuedtirol.com", true },
  { "puryearlaw.com", true },
  { "pusatinkubatorbayi.com", true },
  { "pushers.com.mx", true },
  { "pushoflove.com", true },
  { "pushphp.com", true },
  { "pushrax.com", true },
  { "pusichatka.ddns.net", true },
  { "pussr.com", true },
  { "put.moe", true },
  { "put.re", true },
  { "putatara.net", true },
  { "putin.red", true },
  { "putman-it.nl", true },
  { "putney.io", true },
  { "putomani.rs", true },
  { "putrock.be", true },
  { "puurwonengeldrop.nl", false },
  { "puxlit.net", true },
  { "puyallupnissanparts.com", true },
  { "puyblanc.info", true },
  { "puzz.me", true },
  { "puzzlage.com", true },
  { "puzzle-welt.ch", true },
  { "puzzlepoint.ch", true },
  { "pv-paderborn-now.de", true },
  { "pvcvoordeel.nl", false },
  { "pvda.nl", true },
  { "pvmotorco.com", true },
  { "pvpcraft.ca", true },
  { "pvpctutorials.de", true },
  { "pvphs98.com", true },
  { "pvtschlag.com", true },
  { "pwaresume.com", true },
  { "pwdsafe.com", true },
  { "pwe.vision", true },
  { "pwnedpass.tk", true },
  { "pwnies.dk", true },
  { "pwolk.com", true },
  { "pxl-mailtracker.com", true },
  { "pxl.cl", true },
  { "pxx.io", true },
  { "py-amf.org", true },
  { "py.search.yahoo.com", false },
  { "pycoder.org", true },
  { "pycrc.org", true },
  { "pycrypto.org", true },
  { "pycycle.info", true },
  { "pygarage.com", true },
  { "pyopenssl.org", true },
  { "pypa.io", true },
  { "pypi.io", true },
  { "pypi.org", true },
  { "pypi.python.org", true },
  { "pyramidsofchi.com", true },
  { "pyrenees.io", true },
  { "pyrios.pro", true },
  { "pyrotechnologie.de", true },
  { "pysays.net", true },
  { "pyspace.org", true },
  { "python-hyper.org", true },
  { "python.org", false },
  { "pyxo.net", true },
  { "pyzlnar.com", true },
  { "pzpittsburgh.com", true },
  { "pzsearch.nl", true },
  { "q-inn.com", true },
  { "q-inn.nl", true },
  { "q-technologies.com.au", true },
  { "q123123.com", true },
  { "q1q2q3.tk", true },
  { "q5118.com", true },
  { "qa-brandywineglobal.com", true },
  { "qa-team.xyz", true },
  { "qa.fedoraproject.org", true },
  { "qa.stg.fedoraproject.org", true },
  { "qabalah.jp", true },
  { "qaconstrucciones.com", true },
  { "qadmium.com", true },
  { "qambarraza.com", true },
  { "qani.me", true },
  { "qaq.sh", true },
  { "qaz.cloud", true },
  { "qbeing.info", true },
  { "qbiju.com.br", true },
  { "qbiltrade.com", true },
  { "qbus.pl", true },
  { "qc.immo", true },
  { "qc.search.yahoo.com", false },
  { "qccareerschool.com", true },
  { "qcdesignschool.com", true },
  { "qceventplanning.com", true },
  { "qcloud.cz", true },
  { "qclt.com", true },
  { "qcmakeupacademy.com", true },
  { "qcmlw.com", true },
  { "qcstudentcenter.com", true },
  { "qcstyleacademy.com", true },
  { "qctravelschool.com", true },
  { "qdabogados.com", true },
  { "qdon.space", false },
  { "qe-lab.at", true },
  { "qedcon.org", false },
  { "qelectrotech.org", true },
  { "qetesh.de", true },
  { "qetic.co.jp", true },
  { "qewc.com", true },
  { "qgblog.org", true },
  { "qgustavor.tk", true },
  { "qhse-professionals.nl", true },
  { "qianalysis.com", true },
  { "qianmo.com", true },
  { "qianqiao.me", true },
  { "qiaohong.org", true },
  { "qicomidadeverdade.com.br", true },
  { "qifu.me", true },
  { "qiliang.wang", true },
  { "qingcao.org", true },
  { "qingpei.me", true },
  { "qionouu.cn", true },
  { "qipl.org", true },
  { "qis.fr", true },
  { "qitarabutrans.com", true },
  { "qiu521119.host", true },
  { "qiuri.org", true },
  { "qivonline.pt", true },
  { "qiwi.be", true },
  { "qixi.biz", true },
  { "qkmortgage.com", true },
  { "qldconservation.org.au", true },
  { "qldformulaford.org", true },
  { "qledtech.com", false },
  { "qlix.pl", true },
  { "qlrace.com", false },
  { "qm-marzahnnordwest.de", true },
  { "qnq.moe", true },
  { "qochealth.com", true },
  { "qoml.net", true },
  { "qonto.eu", true },
  { "qoor.io", true },
  { "qotw.net", true },
  { "qponverzum.hu", true },
  { "qq-navi.com", true },
  { "qq52o.me", true },
  { "qqrss.com", true },
  { "qr-city.org", true },
  { "qr.cl", true },
  { "qrbird.com", true },
  { "qrcontagion.com", true },
  { "qrpth.eu", true },
  { "qruiser.com", true },
  { "qscloud.de", true },
  { "qtacairsoft.com", true },
  { "qtl.me", true },
  { "qtmsheep.com", true },
  { "qtn.net", true },
  { "qto.com", true },
  { "qto.net", true },
  { "qtpass.org", true },
  { "qtpower.co.uk", true },
  { "qtpower.net", true },
  { "qtpower.org", true },
  { "qtvr.com", true },
  { "qtxh.net", true },
  { "quackerswaterproofing.com", true },
  { "quaggan.co", true },
  { "quai10.org", false },
  { "qualite-ecole-et-formation.ch", true },
  { "quality-life.gr", true },
  { "qualityedgarsolutions.com", true },
  { "qualityhomesystems.com", true },
  { "qualityhvacservices.com", true },
  { "qualityofcourse.com", true },
  { "qualitypropertycare.co.uk", true },
  { "qualpay.biz", true },
  { "qualtrics.com", true },
  { "quant-labs.de", true },
  { "quanterra.ch", true },
  { "quantolytic.de", true },
  { "quantoras.com", true },
  { "quantum-mechanics.com", true },
  { "quantum2.xyz", true },
  { "quantumfurball.net", true },
  { "quantumpair.net", true },
  { "quantumwebs.co", true },
  { "quareal.ru", true },
  { "quarkdose.de", true },
  { "quarterfull.com", true },
  { "quartix.com", true },
  { "quartzclinical.com", true },
  { "quasarelectronics.co.uk", true },
  { "quasiproxy.com", true },
  { "quasseldroid.info", true },
  { "quatrefoiscent.fr", true },
  { "quay.net", true },
  { "qubes-os.org", true },
  { "qubyte.codes", true },
  { "quchao.com", true },
  { "queencomplex.net", true },
  { "queene.eu", true },
  { "queens.lgbt", true },
  { "queensrdapartments.com.au", true },
  { "queer.party", true },
  { "queercinema.ch", true },
  { "queercoders.com", false },
  { "quehacerencusco.com", true },
  { "quelle.at", true },
  { "quelle.ch", true },
  { "quelle.de", true },
  { "quelleformation.net", true },
  { "quemeloquitan.com", true },
  { "queminventou.com.br", true },
  { "quemmeliga.com", true },
  { "quenotejodan.cl", true },
  { "quentinchevre.ch", true },
  { "queo.com.co", true },
  { "quera.ir", true },
  { "quermail.com", true },
  { "query-massage.com", true },
  { "question.com", true },
  { "questoj.cn", true },
  { "questsocial.it", true },
  { "quevisiongrafica.com", true },
  { "quic.stream", true },
  { "quickboysvrouwen2.nl", true },
  { "quickinfosystem.com", true },
  { "quieroserbombero.org", true },
  { "quiet-waters.org", true },
  { "quietapple.org", true },
  { "quikchange.net", true },
  { "quikpay.com.au", true },
  { "quilmo.com", true },
  { "quimatic.com.br", true },
  { "quinnlabs.com", true },
  { "quinoa24.com", true },
  { "quintessa.org", true },
  { "quintype.com", true },
  { "quiq-api.com", true },
  { "quiq-cdn.com", true },
  { "quiq.us", true },
  { "quire.io", true },
  { "quisido.com", true },
  { "quitarlasmanchasde.com", true },
  { "quitimes.com", true },
  { "quizogames.com", true },
  { "quizstore.net", true },
  { "qul.link", true },
  { "quli.nl", false },
  { "qunzi.la", true },
  { "quocdesign.ch", true },
  { "quote.gq", true },
  { "quoteidiot.com", true },
  { "quotev.com", true },
  { "quovadisaustria.com", true },
  { "quppa.net", true },
  { "quuz.org", true },
  { "qvg.company", true },
  { "qvggroup.com", true },
  { "qvi.st", true },
  { "qvitoo.com", true },
  { "qwans.nl", true },
  { "qwant.com", true },
  { "qwant.fr", true },
  { "qwdqwd.de", true },
  { "qwe7002.com", true },
  { "qwertee.com", true },
  { "qwerty.work", true },
  { "qwikdash.com", true },
  { "qwq.moe", true },
  { "qx.fi", true },
  { "qx.se", true },
  { "qxy.ch", true },
  { "r-ay.cn", true },
  { "r-rwebdesign.com", true },
  { "r-t-b.fr", true },
  { "r0t.co", true },
  { "r1a.eu", true },
  { "r1ch.net", true },
  { "r2d2pc.com", true },
  { "r33.space", true },
  { "r3bl.blog", true },
  { "r3bl.me", true },
  { "r3nt3r.com", true },
  { "r3s1stanc3.me", true },
  { "r40.us", true },
  { "r6-team.ru", true },
  { "r7.com.au", true },
  { "r7h.at", true },
  { "r811.de", true },
  { "ra-joergensen.de", true },
  { "ra-micro-koeln.de", true },
  { "ra-schaal.de", false },
  { "ra.co.ke", true },
  { "ra.vc", true },
  { "ra4wvpn.com", true },
  { "raah.co", true },
  { "rabbit.wales", false },
  { "rabbitfinance.com", true },
  { "rabica.de", true },
  { "rabynska.eu", true },
  { "raccoltarifiuti.com", true },
  { "racermaster.xyz", true },
  { "racesport.nl", false },
  { "raceviewcycles.com", true },
  { "raceviewequestrian.com", true },
  { "rachelchen.me", true },
  { "racheldiensthuette.de", true },
  { "rachelmoorelaw.com", true },
  { "rachelreagan.com", true },
  { "rachelsbouncycastles.co.uk", true },
  { "rachida-dati.eu", true },
  { "racius.com", true },
  { "rackerlab.com", false },
  { "raclet.co.uk", true },
  { "raconconsulting.co.uk", true },
  { "racoo.net", true },
  { "racozo.com", true },
  { "racunovodstvo-prina.si", true },
  { "radar.sx", true },
  { "radaravia.ru", true },
  { "radartatska.se", true },
  { "radartek.com", true },
  { "radcube.hu", true },
  { "radegundisfest.de", true },
  { "radfieldhomecare.co.uk", true },
  { "radfieldhomecarefranchising.co.uk", true },
  { "radicaloptimism.org", true },
  { "radicalsub.com.br", true },
  { "radins.com", true },
  { "radio-pulsar.eu", true },
  { "radio-utopie.de", true },
  { "radio1.ie", true },
  { "radiocommg.com.br", true },
  { "radiocomsaocarlos.com.br", true },
  { "radiofmimagen.net", true },
  { "radioheteroglossia.com", true },
  { "radioilusion.es", true },
  { "radiom.fr", true },
  { "radiomodem.dk", true },
  { "radiomontebianco.it", true },
  { "radionicabg.com", true },
  { "radiopolarniki.spb.ru", true },
  { "radiormi.com", true },
  { "radiorsvp.com", false },
  { "radiosendungen.com", true },
  { "radis-adopt.com", true },
  { "radiumone.io", true },
  { "radiumtree.com", true },
  { "radondetectionandcontrol.com", true },
  { "radreisetraumtreibstoff.de", true },
  { "radyabkhodro.net", true },
  { "radyn.com", true },
  { "raeu.me", true },
  { "raeven.nl", true },
  { "raevinnd.com", true },
  { "rafaelmagalhaesweb.com", true },
  { "rafey.xyz", true },
  { "raffaellaosti.com", true },
  { "rafleatherdesign.com", true },
  { "rafting-japan.com", true },
  { "ragasto.nl", true },
  { "rage4.com", true },
  { "raghavdua.in", true },
  { "rahulpnath.com", true },
  { "raidensnakesden.co.uk", true },
  { "raidensnakesden.com", true },
  { "raidensnakesden.net", true },
  { "raidstone.net", true },
  { "rail-o-rama.nl", true },
  { "rail24.nl", true },
  { "rail360.nl", true },
  { "railbird.nl", true },
  { "railgun.ac", true },
  { "railgun.com.cn", true },
  { "railorama.nl", true },
  { "railpassie.nl", true },
  { "railtoo.com", true },
  { "railvideo.co.uk", true },
  { "railvideo.net", true },
  { "railvideo.nl", true },
  { "railwaytech.net", true },
  { "raimixmotoparts.com.br", true },
  { "rain.bz", true },
  { "rainbowbay.org", true },
  { "rainbowinflatables.co.uk", true },
  { "rainbowstore.com.au", true },
  { "rainbowstore.com.ua", true },
  { "rainel.at", true },
  { "rainforest.engineering", true },
  { "rainiv.com", true },
  { "rainpaper.com", true },
  { "rainstormsinjuly.co", true },
  { "rainville.me", true },
  { "rainway.io", true },
  { "raipet.no-ip.biz", true },
  { "raiseyourflag.com", true },
  { "raissarobles.com", true },
  { "raito.win", true },
  { "rajivshah.co.uk", true },
  { "rajkapoordas.com", true },
  { "rajyogarishikesh.com", true },
  { "rak-business-service.com", true },
  { "raku.bzh", true },
  { "rakugokai.net", true },
  { "ralf-huebscher.de", true },
  { "ralfs-zusizone.de", true },
  { "ralimtek.com", false },
  { "rally-base.com", true },
  { "rally-base.cz", true },
  { "rally-base.eu", true },
  { "rally-results.eu", true },
  { "rally-vysledky.cz", true },
  { "rallybase.cz", true },
  { "rallybase.eu", true },
  { "rallycycling.com", true },
  { "ralph.bike", true },
  { "ralphwoessner.com", true },
  { "raltha.com", true },
  { "ram-it.nl", true },
  { "ram.nl", true },
  { "ramarka.de", true },
  { "rambo.codes", true },
  { "rammstein-portugal.com", true },
  { "ramrecha.com", false },
  { "ramsor-gaming.de", true },
  { "randc.org", true },
  { "random-samplings.org", true },
  { "randomadversary.com", true },
  { "randombit.eu", false },
  { "randomcode.org", true },
  { "randomdysfunctions.com", true },
  { "randomkoalafacts.com", true },
  { "randomprecision.co.uk", true },
  { "randomquotesapp.com", true },
  { "randomrepo.com", true },
  { "randomserver.pw", true },
  { "ranfurlychambers.co.nz", true },
  { "rangde.org", true },
  { "rangercollege.edu", true },
  { "rangsmo.se", true },
  { "rank-net.de", true },
  { "ranking-deli.jp", true },
  { "ranktopay.com", true },
  { "ranson.com.au", true },
  { "rante.com", true },
  { "ranyeh.co", true },
  { "ranyeh.com", true },
  { "ranzbak.nl", true },
  { "raoul-kieffer.net", true },
  { "rapdogg.com", true },
  { "rapenroer.com", true },
  { "rapenroer.nl", true },
  { "raphael.li", true },
  { "raphaeladdile.com", true },
  { "raphaelcasazza.ch", true },
  { "raphaelschmid.eu", true },
  { "raphrfg.com", true },
  { "rapidapp.io", true },
  { "rapidhubs.com", true },
  { "rapidoo.com.br", true },
  { "rapidshit.net", true },
  { "rapidstone.com", true },
  { "rappet.de", true },
  { "raptorsrapture.com", true },
  { "raraflora.com.au", true },
  { "rareative.com", true },
  { "raryosu.info", true },
  { "rasagiline.com", true },
  { "rascals-castles.co.uk", true },
  { "rascalscastles.co.uk", true },
  { "rascalscastlesdoncaster.co.uk", true },
  { "rasebo.ro", true },
  { "raspii.tech", true },
  { "raspitec.ddns.net", true },
  { "rasty.cz", true },
  { "ratd.net", true },
  { "ratebridge.com", true },
  { "ratelsec.com", true },
  { "rathbonesonline.com", true },
  { "rathgeb.org", true },
  { "ratinq.co", true },
  { "rationalcreation.com", true },
  { "rationalism.com", true },
  { "rationalops.com", true },
  { "rattenkot.io", true },
  { "raulrivero.es", true },
  { "rault.io", true },
  { "rauros.net", true },
  { "rautelow.de", true },
  { "ravchat.com", true },
  { "raven.dog", true },
  { "ravenger.net", true },
  { "ravensbuch.de", true },
  { "ravenx.me", true },
  { "ravhaaglanden.org", true },
  { "ravindran.me", true },
  { "raviparekh.co.uk", true },
  { "ravis.org", true },
  { "ravkr.duckdns.org", true },
  { "rawdutch.nl", true },
  { "rawinfosec.com", true },
  { "rawsec.net", true },
  { "raxion.cf", true },
  { "raxion.tk", true },
  { "ray-home.de", true },
  { "ray-works.de", true },
  { "rayan-it.ir", true },
  { "rayiris.com", true },
  { "raykitchenware.com", true },
  { "raymcbride.com", true },
  { "raymd.de", true },
  { "raymii.org", true },
  { "raystark.com", true },
  { "rayworks.de", true },
  { "razberry.kr", true },
  { "razeen.me", true },
  { "razeencheng.com", true },
  { "raziskovalec-resnice.com", true },
  { "razvanburz.net", true },
  { "rbensch.com", true },
  { "rbflote.lv", true },
  { "rbltracker.com", true },
  { "rbnet.xyz", true },
  { "rbran.com", true },
  { "rbx-talk.xyz", true },
  { "rc-offi.net", true },
  { "rc-rp.com", true },
  { "rc-shop.ch", true },
  { "rca.fr", true },
  { "rcd.cz", true },
  { "rcdocuments.com", true },
  { "rcgoncalves.pt", true },
  { "rchavez.site", true },
  { "rchrdsn.uk", true },
  { "rcifsgapinsurance.co.uk", true },
  { "rclsm.net", true },
  { "rcmlinx.com", true },
  { "rcmpsplib.com", true },
  { "rcmurphy.com", true },
  { "rcnitrotalk.com", true },
  { "rcraigmurphy.com", true },
  { "rcsolutions.nl", true },
  { "rct.sk", true },
  { "rct.uk", true },
  { "rctalk.com", true },
  { "rdfproject.it", true },
  { "rdjb2b.com", true },
  { "rdl.at", false },
  { "rdmc.fr", true },
  { "rdmrotterdam.nl", true },
  { "rdmtaxservice.com", true },
  { "rdv-cni.fr", true },
  { "rdv-prefecture.com", true },
  { "rdwh.tech", true },
  { "re-curi.com", true },
  { "re-engines.com", true },
  { "reachhead.com", true },
  { "reachonline.org", true },
  { "reachrss.com", true },
  { "reaconverter.com", true },
  { "react-db.com", true },
  { "reactivarte.es", true },
  { "reactive-press.com", true },
  { "reactpwa.com", true },
  { "read.sc", true },
  { "reades.co.uk", true },
  { "readheadcopywriting.com", true },
  { "readingandmath.org", true },
  { "readingrats.de", true },
  { "readmusiccoleman.com", true },
  { "readonly.de", true },
  { "readouble.com", false },
  { "reads.wang", true },
  { "readybetwin.com", true },
  { "readysell.net", true },
  { "readytobattle.net", true },
  { "readytongue.com", true },
  { "readytowear.es", true },
  { "reaganlibrary.gov", true },
  { "real-digital.co.uk", true },
  { "real-it.nl", true },
  { "realcapoeira.ru", true },
  { "realestate-in-uruguay.com", true },
  { "realestatecentralcoast.info", true },
  { "realestatemarketingblog.org", true },
  { "realestateonehowell.com", true },
  { "realestateradioshow.com", true },
  { "realfood.space", true },
  { "realfreedom.city", true },
  { "realhorsegirls.net", true },
  { "realhypnosistraining.com.au", true },
  { "realitea.co.uk", true },
  { "reality.news", true },
  { "reality0ne.com", false },
  { "realitycrazy.com", true },
  { "reallifeforums.com", true },
  { "realloc.me", true },
  { "really-simple-plugins.com", true },
  { "really-simple-ssl.com", true },
  { "reallytrusted.com", true },
  { "realme.govt.nz", true },
  { "realmofespionage.xyz", true },
  { "realoteam.ddns.net", true },
  { "realpropertyprofile.gov", true },
  { "realtygroup-virginia.com", true },
  { "realtyink.net", true },
  { "realum.com", true },
  { "realum.de", true },
  { "realum.eu", true },
  { "realum.net", true },
  { "realvnc.help", true },
  { "realwaycome.com", true },
  { "realwildart.com", true },
  { "realworldholidays.co.uk", true },
  { "reancos.report", true },
  { "reanimated.eu", true },
  { "reath.me", true },
  { "reaven.nl", true },
  { "rebane2001.com", true },
  { "rebeagle.com", true },
  { "rebelessex.com", true },
  { "rebelonline.nl", true },
  { "rebelrebel.com.au", true },
  { "rebelz.se", true },
  { "rebirthia.me", true },
  { "reboxetine.com", true },
  { "reboxonline.com", true },
  { "rebtoor.com", true },
  { "recalls.gov", true },
  { "recantoshop.com", true },
  { "recantoshop.com.br", true },
  { "recapp.ch", true },
  { "recaptcha-demo.appspot.com", true },
  { "receiliart.com", true },
  { "receptionpoint.com", true },
  { "recepty.eu", true },
  { "recetasdecocinaideal.com", true },
  { "recetin.com", true },
  { "rechenknaecht.de", true },
  { "rechtsanwaeltin-vollmer.de", true },
  { "rechtsanwalt-koeppen-feucht.de", true },
  { "rechtschreibpruefung24.de", true },
  { "recipea.com", true },
  { "recipex.ru", true },
  { "recipeyak.com", true },
  { "reckontalk.com", true },
  { "reclametoolz.nl", true },
  { "reclusiam.net", true },
  { "recmon.hu", true },
  { "reco-studio.de", true },
  { "recolic.net", true },
  { "recommended.reviews", true },
  { "recompiled.org", true },
  { "recon-networks.com", true },
  { "reconexion.life", true },
  { "recordeuropa.com", false },
  { "recoveringspirit.com", true },
  { "recoveryonline.org", true },
  { "recreoviral.com", true },
  { "recruitmade.jp", true },
  { "rectecforum.com", true },
  { "recuerdafilms.com", true },
  { "recuperodatiraidfastec.it", true },
  { "recurly.com", true },
  { "recursosdeautoayuda.com", true },
  { "recyclingpromotions.us", true },
  { "red-t-shirt.ru", true },
  { "red-trigger.net", true },
  { "red2fred2.com", true },
  { "redable.hosting", true },
  { "redable.nl", true },
  { "redactieco.nl", true },
  { "redb.cz", true },
  { "redballoonsecurity.com", true },
  { "redcatrampageforum.com", true },
  { "redchat.cz", true },
  { "redcoded.com", true },
  { "redcone.net", true },
  { "redcorus.com", true },
  { "redd.it", true },
  { "reddingo.at", true },
  { "reddingo.be", true },
  { "reddingo.ch", true },
  { "reddingo.com", true },
  { "reddingo.com.au", true },
  { "reddingo.de", true },
  { "reddingo.es", true },
  { "reddingo.eu", true },
  { "reddingo.fr", true },
  { "reddingo.it", true },
  { "reddingo.jp", true },
  { "reddingo.nl", true },
  { "reddingo.nz", true },
  { "reddingsbrigade-zwolle.nl", true },
  { "reddit2kindle.com", true },
  { "reddraggone9.com", true },
  { "reddyai.com", true },
  { "rede-reim.de", true },
  { "rede-t.com", true },
  { "redelectrical.co.uk", true },
  { "redespaulista.com", true },
  { "redessantaluzia.com.br", true },
  { "redflare.com.au", true },
  { "redfox-infosec.de", true },
  { "redfoxmarketiing.com", true },
  { "redgatesoftware.co.uk", true },
  { "redgoose.ca", true },
  { "redhandedsecurity.com.au", true },
  { "redicals.com", true },
  { "redigest.it", true },
  { "redir.me", true },
  { "redirect.fedoraproject.org", true },
  { "redirect.stg.fedoraproject.org", true },
  { "rediske.me", true },
  { "redit.com", true },
  { "rediverge.com", true },
  { "redivis.com", true },
  { "redleslie.com", true },
  { "redletter.link", true },
  { "redlinelap.com", true },
  { "redlink.de", true },
  { "redmind.se", true },
  { "redmondtea.com", true },
  { "redmore.me", true },
  { "redneragenturen.org", true },
  { "rednsx.org", true },
  { "redpact.com", true },
  { "redprice.by", true },
  { "redshield.co", true },
  { "redshiftlabs.com.au", true },
  { "redshoeswalking.net", true },
  { "redsicom.com", true },
  { "redsquarelasvegas.com", true },
  { "redstoner.com", true },
  { "redteam-pentesting.de", true },
  { "redwaterhost.com", true },
  { "redweek.com", true },
  { "redwoodpaddle.es", true },
  { "redwoodpaddle.pt", true },
  { "redzonedaily.com", true },
  { "redzurl.com", false },
  { "reed-sensor.com", true },
  { "reedloden.com", true },
  { "reedyforkfarm.com", true },
  { "reegle.com", true },
  { "reening.net", true },
  { "rees-carter.net", true },
  { "reesmichael1.com", true },
  { "reevaappliances.co.uk", true },
  { "reezer.org", true },
  { "refactor.zone", false },
  { "referdell.com", true },
  { "refficience.com", true },
  { "refill-roboter.de", true },
  { "refinansiering.no", true },
  { "reflectivity.io", true },
  { "reflectores.net", true },
  { "refletindosaude.com.br", true },
  { "reflets.info", true },
  { "reflexions.co", true },
  { "reflexive-engineering.com", true },
  { "reflexive.xyz", true },
  { "refood-cascaiscpr.eu", true },
  { "reforesttheplanet.com", true },
  { "refresh-media.nl", true },
  { "refreshliving.us", true },
  { "refu.net", true },
  { "refuelcollective.com", true },
  { "refuelcreative.com.au", true },
  { "refundo.cz", true },
  { "refundo.sk", true },
  { "regain.us", true },
  { "regalcapitalwi.com", true },
  { "regalosymuestrasgratis.com", true },
  { "reganclassics.co.uk", true },
  { "reganclassics.com", true },
  { "reganparty.com", true },
  { "regar42.fr", false },
  { "regeneo.cz", true },
  { "regenerapoint.it", true },
  { "regenerescence.com", true },
  { "regily.com", true },
  { "regime-anticellulite.com", true },
  { "regime-maigrir-vite.com", true },
  { "regimebonheur.com", true },
  { "regimecellulite.com", true },
  { "reginfo.gov", true },
  { "regiobeveland.nl", true },
  { "regionalbasementandcrawlspacerepair.com", true },
  { "regionalgrowth.com", true },
  { "regiosalland.nl", true },
  { "regiovertrieb.de", false },
  { "regis.tech", true },
  { "regisearch.co.uk", true },
  { "registerex.me", true },
  { "registerforevent.co.uk", true },
  { "registerra.nl", true },
  { "registrar.io", true },
  { "registrarplus.net", true },
  { "registrarplus.nl", true },
  { "registryplus.net", true },
  { "registryplus.nl", true },
  { "regmyr.se", true },
  { "regnix.net", true },
  { "regnr.info", true },
  { "regolithmedia.com", true },
  { "regraph.de", true },
  { "regresionavidaspasadas.com", true },
  { "regularflolloping.com", true },
  { "regulations.gov", true },
  { "reha-honpo.jp", true },
  { "rehabili-shigoto.com", true },
  { "rehabilitation.network", true },
  { "rehabmail.com", true },
  { "rehabphilippines.com", true },
  { "rehabthailand.com", true },
  { "rehabthailand.org", true },
  { "rei.ki", true },
  { "reichardt-home.goip.de", true },
  { "reichel-steinmetz.de", true },
  { "reichelt-cloud.de", true },
  { "reichl-online.net", true },
  { "reidasbombas.com", true },
  { "reifr.net", true },
  { "reiki-france.fr", true },
  { "reilly.io", true },
  { "reimaginebelonging.de", true },
  { "reimaginebelonging.org", true },
  { "reimann.me", true },
  { "reimers.de", true },
  { "rein.kr", true },
  { "reinaldudras.ee", true },
  { "reinaldudrasfamily.ee", true },
  { "reinencaressa.be", true },
  { "reinfer.io", true },
  { "reinhard.codes", true },
  { "reinhardtsgermanautorepair.com", true },
  { "reinhardtsgrimma.de", true },
  { "reinierjonker.nl", true },
  { "reinout.nu", true },
  { "reinouthoornweg.nl", true },
  { "reinventetoi.com", false },
  { "reisekosten-gorilla.com", true },
  { "reisenbauer.ee", true },
  { "reiseversicherung-werner-hahn.de", true },
  { "reishunger.de", true },
  { "reisslittle.com", true },
  { "reittherapie-tschoepke.de", true },
  { "rejahrehim.com", true },
  { "rejects.email", true },
  { "rejsehuskelisten.dk", true },
  { "rekisuta.com", true },
  { "reklamjog.hu", true },
  { "rekonstrukcestatu.cz", true },
  { "rekorsanat.com.tr", true },
  { "rekyou.com", false },
  { "relates.link", true },
  { "relax.hn", true },
  { "relaxdom.net", true },
  { "relaxhavefun.com", true },
  { "relaxpointhyncice.cz", true },
  { "relaybox.io", true },
  { "release-monitoring.org", true },
  { "releasetimes.io", true },
  { "reliancebank.bank", true },
  { "relocatefeds.gov", false },
  { "relojeriajoyeria.com", true },
  { "relojes-online.com", true },
  { "relojesseiko.es", true },
  { "relsak.cz", true },
  { "relvan.com", true },
  { "rem0te.net", true },
  { "remaimodern.org", true },
  { "remambo.jp", true },
  { "remarketable.org", true },
  { "remax.at", true },
  { "remedi.tokyo", true },
  { "remedionaturales.com", true },
  { "remedioscaserosparalacistitis.com", true },
  { "remejeanne.com", true },
  { "rememberthemilk.com", false },
  { "remi-saurel.com", true },
  { "remiafon.com", true },
  { "remilner.co.uk", true },
  { "remini.cz", true },
  { "remirampin.com", true },
  { "remissan.com", true },
  { "remitatm.com", false },
  { "remonti.info", true },
  { "remote.so", true },
  { "remoteutilities.com", true },
  { "removalcellulite.com", true },
  { "removedrepo.com", true },
  { "remptmotors.com", true },
  { "remrol.ru", true },
  { "remszeitung.de", true },
  { "renaissanceplasticsurgery.net", true },
  { "renascentia.asia", true },
  { "renaultclubticino.ch", true },
  { "rendall.tv", true },
  { "renderloop.com", true },
  { "rendre-service.ch", true },
  { "rene-schwarz.com", true },
  { "rene-stolp.de", true },
  { "renearends.nl", true },
  { "renedekoeijer.com", true },
  { "renee.today", true },
  { "reneleu.ch", true },
  { "renem.net", false },
  { "renemayrhofer.com", true },
  { "reneschmidt.de", true },
  { "renewablefreedom.org", true },
  { "renewablemaine.org", true },
  { "renewgsa.com", true },
  { "renewmedispa.com", true },
  { "renewpfc.com", true },
  { "renezuo.com", true },
  { "renkenlaw.com", true },
  { "renlen.nl", true },
  { "renov8sa.co.za", true },
  { "renovablesverdes.com", true },
  { "renovum.es", true },
  { "renrenche.com", false },
  { "rens.nu", true },
  { "rensa-datorn.se", true },
  { "renscreations.com", true },
  { "rent-a-c.io", true },
  { "rent-a-coder.de", true },
  { "rentacaramerica.com", true },
  { "rentasweb.gob.ar", true },
  { "rentayventadecarpas.com", true },
  { "renthelper.us", true },
  { "rentinsingapore.com.sg", true },
  { "rentourhomeinprovence.com", true },
  { "renuo.ch", true },
  { "renxinge.cn", false },
  { "reo.gov", true },
  { "reorz.com", true },
  { "reox.at", false },
  { "repaik.com", true },
  { "repair.by", true },
  { "repaper.org", true },
  { "repaxan.com", true },
  { "repkord.com", true },
  { "replicaswiss.nl", true },
  { "repology.org", true },
  { "report-uri.com", true },
  { "report2psb.online", true },
  { "reportband.gov", true },
  { "reporting.gov", true },
  { "reproduciblescience.org", true },
  { "reproductive-revolution.com", true },
  { "reproductiverevolution.com", true },
  { "reprogramming-predators.com", true },
  { "reprogrammingpredators.com", true },
  { "reprozip.org", true },
  { "repsomelt.com", true },
  { "reptrax.com", true },
  { "republic.gr", true },
  { "republictelecom.net", true },
  { "republique.org", true },
  { "repugnant-conclusion.com", true },
  { "repugnantconclusion.com", true },
  { "reputationweaver.com", true },
  { "reqrut.net", true },
  { "requestr.co.uk", true },
  { "res-kc.com", true },
  { "resama.eu", true },
  { "rescms-secure.com", true },
  { "research-panel.jp", true },
  { "research.facebook.com", false },
  { "researchgate.net", true },
  { "researchstory.com", true },
  { "reseausyndic.ca", true },
  { "reservar-un-hotel.com", true },
  { "reservetonshift.com", true },
  { "resfriatech.com.br", true },
  { "residence-simoncelli.com", true },
  { "residentiallocksmithsanantoniotx.com", true },
  { "resine.roma.it", true },
  { "resinflooringcompany.com", true },
  { "resist.ca", true },
  { "resistav.com", true },
  { "resnickandnash.com", true },
  { "resolvefa.co.uk", true },
  { "resolvefa.com", true },
  { "resolving.com", true },
  { "resoplus.ch", true },
  { "resort-islands.net", true },
  { "resortafroditatucepi.com", true },
  { "resortohshima.com", true },
  { "resourceconnect.com", true },
  { "resourceguruapp.com", true },
  { "resources.flowfinity.com", true },
  { "resourcesmanagementcorp.com", true },
  { "respectmyprivacy.eu", true },
  { "respectmyprivacy.net", true },
  { "respectmyprivacy.nl", true },
  { "respecttheflame.com", true },
  { "respiranto.de", true },
  { "respon.jp", true },
  { "responer.com", true },
  { "responsepartner.com", true },
  { "responsibledisclosure.nl", false },
  { "responsive-shop.com", true },
  { "responsivepaper.com", true },
  { "respostas.com.br", true },
  { "ressl.ch", true },
  { "restaurant-de-notenkraker.be", true },
  { "restaurant-oregano.de", true },
  { "restaurant-rosengarten.at", true },
  { "restaurantguru.com", true },
  { "restaurantmaan.nl", true },
  { "restauranttester.at", true },
  { "rester-a-domicile.ch", true },
  { "rester-autonome-chez-soi.ch", true },
  { "restoran-radovce.me", true },
  { "restorethegulf.gov", true },
  { "restoruns.com", true },
  { "restoruns.xyz", true },
  { "restrealitaet.de", true },
  { "restrito.org", true },
  { "resultsatretail.com", true },
  { "resursedigitale.ro", true },
  { "retefarmaciecostadamalfi.it", true },
  { "retetenoi.net", true },
  { "reticon.de", true },
  { "retmig.dk", true },
  { "reto.ch", true },
  { "reto.com", true },
  { "reto.io", true },
  { "retokromer.ch", true },
  { "retornaz.com", true },
  { "retornaz.eu", true },
  { "retornaz.fr", true },
  { "retractableawningssydney.com.au", true },
  { "retro.rocks", true },
  { "retro.sx", true },
  { "retroarms.com", true },
  { "retroarms.cz", true },
  { "retrocdn.net", true },
  { "retrofitlab.com", true },
  { "retroity.net", true },
  { "retrojar.top", true },
  { "retroroundup.com", true },
  { "retrotracks.net", true },
  { "retrovideospiele.com", true },
  { "returnpath.com", true },
  { "reucon.com", true },
  { "reulitz.de", true },
  { "reuna.me", true },
  { "reussirsavie.info", true },
  { "reuter-profishop.de", true },
  { "reuter-shop.com", true },
  { "reuter.de", true },
  { "revamed.com", false },
  { "revapost.fr", true },
  { "revayd.net", true },
  { "revensoftware.com", true },
  { "reverencestudios.com", true },
  { "reverseaustralia.com", true },
  { "reversecanada.com", true },
  { "reverseloansolutions.com", true },
  { "reversesouthafrica.com", true },
  { "review.jp", true },
  { "reviewmed-215418.appspot.com", true },
  { "reviewninja.net", true },
  { "reviews.anime.my", false },
  { "revirt.global", true },
  { "revision.co.zw", true },
  { "revisionnotes.xyz", true },
  { "revisit.date", true },
  { "revista-programar.info", true },
  { "revivalinhisword.com", true },
  { "revivalprayerfellowship.com", true },
  { "revivingtheredeemed.org", true },
  { "revlect.com", true },
  { "revolt.tv", true },
  { "revthefox.co.uk", true },
  { "rewardingexcellence.com", true },
  { "rewrite3.com", true },
  { "rewtherealtor.com", true },
  { "rex.tc", true },
  { "rexdf.net", true },
  { "rexskz.info", true },
  { "reyna.cc", true },
  { "rezept-planer.de", true },
  { "rezexpert.com", true },
  { "rezosup.net", true },
  { "rezosup.org", true },
  { "rezultant.ru", true },
  { "rftoon.com", true },
  { "rfxanalyst.com", true },
  { "rga.sh", true },
  { "rgavmf.ru", true },
  { "rgbinnovation.com", true },
  { "rgcomportement.fr", true },
  { "rgraph.net", true },
  { "rhaegal.me", true },
  { "rhd-instruments.com", true },
  { "rhd-instruments.de", true },
  { "rhees.nl", true },
  { "rhein-liebe.de", true },
  { "rheinneckarmetal.com", true },
  { "rheocube.com", true },
  { "rhese.net", true },
  { "rhetorical.ml", true },
  { "rhevelo.com", true },
  { "rhinelander.ca", true },
  { "rhinobase.net", true },
  { "rhinoceroses.org", true },
  { "rhnet.at", true },
  { "rhodenmanorcattery.co.uk", true },
  { "rhodri.io", true },
  { "rhowell.io", true },
  { "rhumblineadvisers.com", true },
  { "rhymeswithmogul.com", true },
  { "rhymix.org", true },
  { "rhynl.io", true },
  { "riajenaka.com", true },
  { "riaki.net", true },
  { "rial.space", true },
  { "ribs.com", true },
  { "ricardo.nu", true },
  { "ricardobalk.nl", true },
  { "ricardopq.com", true },
  { "ricaribeiro.com.br", true },
  { "ricaud.me", true },
  { "riccardopiccioni.it", true },
  { "riccy.org", true },
  { "riceadvice.info", true },
  { "richadams.me", true },
  { "richardbloomfield.blog", true },
  { "richardfeinbergdds.com", true },
  { "richardharpur.com", true },
  { "richardhering.de", true },
  { "richardhicks.us", true },
  { "richardjgreen.net", true },
  { "richardlangworth.com", true },
  { "richardlevinmd.com", true },
  { "richardlugten.nl", true },
  { "richardramos.me", true },
  { "richardrblocker.net", true },
  { "richardschut.nl", true },
  { "richardson.cam", true },
  { "richardson.engineering", true },
  { "richardson.pictures", true },
  { "richardson.software", true },
  { "richardson.systems", true },
  { "richardstonerealestate.com", true },
  { "richardwarrender.com", true },
  { "richie.fi", true },
  { "ricketyspace.net", true },
  { "ricki-z.com", true },
  { "rickrongen.nl", true },
  { "rickscastles.co.uk", true },
  { "ricksfamilycarpetcleaning.com", true },
  { "rickvanderzwet.nl", true },
  { "rickweijers.nl", true },
  { "rickyromero.com", true },
  { "rico.ovh", true },
  { "ricobaldegger.ch", true },
  { "ricochet.im", true },
  { "ricoydesign.com", true },
  { "ricozienke.de", true },
  { "riddims.co", true },
  { "rideintaxi.com", true },
  { "rideways.com", true },
  { "rideyourdamn.bike", true },
  { "ridgelandchurch.org", true },
  { "ridingboutique.de", true },
  { "ridwan.co", false },
  { "riederle.com", true },
  { "riemer.ml", true },
  { "riesenweber.id.au", true },
  { "riesheating.com", true },
  { "rievo.net", true },
  { "riffreporter.de", true },
  { "rifkivalkry.net", true },
  { "rift.pictures", true },
  { "rigabeerbike.com", true },
  { "rigabeerbike.lv", true },
  { "righettod.eu", true },
  { "righini.ch", true },
  { "rightbrain.training", true },
  { "rightcapital.com", true },
  { "rightmovecanada.com", true },
  { "rightnetworks.com", true },
  { "rightstuff.link", true },
  { "righttobuy.gov.uk", true },
  { "rigolitch.fr", true },
  { "rigsalesaustralia.com", true },
  { "rijk-catering.nl", false },
  { "rijschoolrichardschut.nl", true },
  { "rijschoolsafetyfirst.nl", true },
  { "rijsinkunst.nl", false },
  { "rik.onl", true },
  { "riku.pw", true },
  { "rile5.com", true },
  { "rileyevans.co.uk", true },
  { "rimax.vn", true },
  { "rimcountrymuseum.org", true },
  { "rimediogiusto.com", true },
  { "rimeto.io", true },
  { "rimo.site", true },
  { "rimorrecherche.nl", true },
  { "ring.com", true },
  { "ringingliberty.com", true },
  { "ringjewellery.co.uk", true },
  { "rinvex.com", true },
  { "rio-weimar.de", true },
  { "rioshop.com.br", true },
  { "rioxmarketing.com", true },
  { "rioxmarketing.pt", true },
  { "rip-sport.cz", true },
  { "ripaton.fr", true },
  { "ripcorddesign.com", true },
  { "ripcordsandbox.com", true },
  { "ripmixmake.org", true },
  { "riqy86.nl", true },
  { "ris-bad-wurzach.de", true },
  { "risada.nl", true },
  { "risaphuketproperty.com", true },
  { "riscascape.net", true },
  { "rischard.org", true },
  { "rise-technologies.com", true },
  { "riseup.net", true },
  { "rishikeshyoga.in", true },
  { "risiinfo.com", true },
  { "riskmitigation.ch", true },
  { "risparmiare.info", true },
  { "ristioja.ee", true },
  { "ristoarea.it", true },
  { "ristorantefattoamano.it", true },
  { "ristoviitanen.fi", true },
  { "ristrutturazioneappartamento.roma.it", true },
  { "rit.space", false },
  { "rittau.biz", true },
  { "rittau.org", true },
  { "ritzlux.com.tw", true },
  { "rivaforum.de", true },
  { "rivalsa.cn", true },
  { "rivastation.de", true },
  { "riverbanktearooms.co.uk", true },
  { "riverbendroofingnd.com", true },
  { "riverford.co.uk", true },
  { "rivermist.com.au", true },
  { "riverridgecc.com", true },
  { "riversidebaptistchurch.net", true },
  { "riversideradio.nl", true },
  { "riverviewcourtapts.com", true },
  { "riverweb.gr", true },
  { "rivierasaints.ch", true },
  { "rivoflor.it", true },
  { "rivus.net", true },
  { "rivy.org", true },
  { "rix.ninja", true },
  { "rixter.com", true },
  { "rixzz.ovh", true },
  { "riyono.com", true },
  { "rizalpalawan.gov.ph", true },
  { "rizospastis.gr", true },
  { "rj-onderneemt.nl", true },
  { "rkfp.cz", true },
  { "rkkhok.hu", false },
  { "rkmns.edu.in", true },
  { "rlalique.com", true },
  { "rld.org", true },
  { "rlds.ch", true },
  { "rleeden.servehttp.com", true },
  { "rleh.de", true },
  { "rlnunez.com", true },
  { "rlove.org", true },
  { "rm-it.de", true },
  { "rmb.li", true },
  { "rmcbs.de", true },
  { "rmeuropean.com", true },
  { "rmf.io", true },
  { "rmm-i.com", true },
  { "rmmanfredi.com", true },
  { "rmpsolution.de", true },
  { "rmrig.org", true },
  { "rms-digicert.ne.jp", true },
  { "rms.sexy", true },
  { "rmstudio.tw", true },
  { "rmsupply.nl", true },
  { "rnag.ie", true },
  { "rnb-storenbau.ch", true },
  { "rngmeme.com", true },
  { "rnt.cl", true },
  { "ro.search.yahoo.com", false },
  { "roaddoc.de", true },
  { "roadguard.nl", false },
  { "roadtopgm.com", true },
  { "roams.es", true },
  { "rob006.net", true },
  { "robandjanine.com", true },
  { "robbertt.com", false },
  { "robbiecrash.me", true },
  { "robdavidson.network", true },
  { "robert-flynn.de", true },
  { "robert-wiek-transporte.de", true },
  { "robertattfield.com", true },
  { "robertayamashita.com", true },
  { "robertayamashita.com.br", true },
  { "robertg.me", true },
  { "robertglastra.com", true },
  { "roberthurlbut.com", true },
  { "robertkrueger.de", true },
  { "robertlysik.com", true },
  { "robertnemec.com", true },
  { "robertoentringer.com", true },
  { "robertof.ovh", true },
  { "robertopazeller.ch", true },
  { "robertreiser.photography", true },
  { "robertrijnders.nl", true },
  { "robertsmits.be", false },
  { "robhorstmanshof.nl", true },
  { "robicue.com", true },
  { "robigalia.org", false },
  { "robin.co.kr", true },
  { "robin.info", true },
  { "robinevandenbos.nl", true },
  { "robinflikkema.nl", true },
  { "robinfrancq.ml", true },
  { "robinhoodbingo.com", true },
  { "robinlinden.eu", true },
  { "robinsonstrategy.com", true },
  { "robinsonyu.com", true },
  { "robinvdmarkt.nl", true },
  { "robinwill.de", true },
  { "robinwinslow.uk", true },
  { "robjager-fotografie.nl", true },
  { "robocop.no", true },
  { "robodeidentidad.gov", true },
  { "robohash.org", true },
  { "robokits.co.in", true },
  { "robot.car", true },
  { "robot.works", true },
  { "robotattack.org", true },
  { "roboth.am", true },
  { "robotham.org", true },
  { "robotics.plus", true },
  { "robotkvarnen.se", true },
  { "robototes.com", true },
  { "robots-ju.ch", true },
  { "robottip.com", true },
  { "robpol86.com", true },
  { "robspc.repair", true },
  { "robspeed.rocks", true },
  { "robtatemusic.com", true },
  { "robtex.com", true },
  { "robu.in", true },
  { "robud.info", true },
  { "robustac.com", true },
  { "rochakhand-knitcraft.com.np", true },
  { "rocis.gov", true },
  { "rocka.me", true },
  { "rockagogo.com", true },
  { "rockbankland.com.au", true },
  { "rockcanyonbank.com", true },
  { "rockenfuerlachenhelfen.de", true },
  { "rocket-wars.de", true },
  { "rocketevents.com.au", true },
  { "rocketgnomes.com", true },
  { "rocketr.net", true },
  { "rocketsandtutus.com", true },
  { "rockfax.com", true },
  { "rockhounds.co.za", true },
  { "rockinronniescastles.co.uk", true },
  { "rockitinflatables.co.uk", true },
  { "rockpesado.com.br", true },
  { "rockthebabybump.com", true },
  { "rockuse.com.br", true },
  { "rockymountainspice.com", true },
  { "rocssti.net", true },
  { "rodab.party", true },
  { "rodafe.sk", true },
  { "roddis.net", true },
  { "rodeobull.biz", true },
  { "rodeohire.com", true },
  { "rodeosales.co.uk", true },
  { "rodest.net", true },
  { "rodevlaggen.nl", true },
  { "rodichi.net", true },
  { "rodinnebyvanie.eu", true },
  { "rodinneodpoledne2018.cz", true },
  { "rodolfo.gs", true },
  { "rodomonte.org", true },
  { "rodrigocarvalho.blog.br", true },
  { "rody-design.com", true },
  { "rodzina-kupiec.eu.org", true },
  { "roeckx.be", true },
  { "roeitijd.nl", false },
  { "roeldevries.me", true },
  { "roeleveld.nl", true },
  { "roelhollander.eu", true },
  { "roelof.io", true },
  { "roelsworld.eu", true },
  { "roemhild.de", true },
  { "roerstaafjes.nl", true },
  { "rofl.com.ua", true },
  { "rogagym.com", true },
  { "rogerhub.com", true },
  { "rogerriendeau.ca", true },
  { "rogersaam.ch", true },
  { "rogersremovals.co.uk", true },
  { "rogersvilleumc.org", true },
  { "rognhaugen.no", true },
  { "rogoff.xyz", true },
  { "rogue-e.xyz", true },
  { "roguefinancial.com", true },
  { "roguefortgame.com", true },
  { "roguenation.space", true },
  { "roguenetworks.me", true },
  { "roguesignal.net", true },
  { "roguetechhub.org", true },
  { "rohedaten.de", true },
  { "rohitagr.com", true },
  { "rointe.online", true },
  { "roka9.de", true },
  { "rokass.nl", true },
  { "rokki.ch", true },
  { "rokort.dk", true },
  { "rokudenashi.de", true },
  { "roland.io", true },
  { "rolandinsh.com", true },
  { "rolandlips.com", true },
  { "rolandlips.nl", true },
  { "rolandreed.cn", true },
  { "rolandszabo.com", true },
  { "roleplayhome.com", true },
  { "roligprylar.se", true },
  { "rollatorweb.nl", true },
  { "rollercoasteritalia.it", true },
  { "rolleyes.org", true },
  { "rollingbarge.com", true },
  { "rolliwelt.de", true },
  { "rolodato.com", true },
  { "roma-servizi.it", true },
  { "romab.com", true },
  { "romain-arias.fr", true },
  { "roman-pavlik.cz", true },
  { "romancloud.com", true },
  { "romande-entretien.ch", true },
  { "romanmichel.de", true },
  { "romano.guru", true },
  { "romanpavlodar.kz", true },
  { "romantelychko.com", true },
  { "romantica-hotel.de", true },
  { "romanticfirstdance.com", true },
  { "romanticschemer.com", true },
  { "romanticsexshopguatemala.com", true },
  { "romanticvillas.com.au", false },
  { "romapa.com", true },
  { "romar-bos.nl", true },
  { "romarin.es", true },
  { "romaservicegroup.it", true },
  { "romatrip.it", true },
  { "rome.dating", true },
  { "rommelwood.de", true },
  { "romun.net", true },
  { "romy.tw", true },
  { "rondommen.nl", true },
  { "rondouin.fr", true },
  { "rondreis-amerika.be", true },
  { "rondreis-schotland.nl", true },
  { "roninf.ch", true },
  { "roninitconsulting.com", true },
  { "ronniegane.kiwi", true },
  { "ronnylindner.de", true },
  { "ronomon.com", true },
  { "roodfruit.studio", true },
  { "roodhealth.co.uk", true },
  { "roof.ai", false },
  { "roofingandconstructionllc.com", true },
  { "roofingomaha.com", true },
  { "roofsandbasements.com", true },
  { "rook-playz.net", true },
  { "rookvrij.nl", true },
  { "room-composite.com", true },
  { "room208.org", true },
  { "room2d.com", true },
  { "room3b.eu", true },
  { "roombase.nl", true },
  { "roomhub.jp", true },
  { "rooneytours.nl", true },
  { "roopakv.com", true },
  { "roosabels.nl", false },
  { "roosterpgplus.nl", true },
  { "root-space.eu", true },
  { "root.bg", true },
  { "root.cz", true },
  { "root.eu.org", true },
  { "rootcamp.net", true },
  { "rootcommand.com", true },
  { "rootear.com", true },
  { "rootedlifemontessori.com", true },
  { "rootkea.me", true },
  { "rootlair.com", true },
  { "rootonline.de", true },
  { "rootpigeon.com", true },
  { "roots-example-project.com", true },
  { "roots.io", true },
  { "rootsandrain.com", true },
  { "rootsbar.fr", true },
  { "rootscope.co.uk", false },
  { "rootspersona.com", true },
  { "rootswitch.com", false },
  { "rootusers.com", true },
  { "ropd.info", true },
  { "roryneville.com", true },
  { "rosabellas.co.uk", true },
  { "rosalindturner.co.uk", true },
  { "rosbass.ru", true },
  { "rose-prism.org", true },
  { "rosehosting.reviews", true },
  { "roseitsolutions.co.uk", true },
  { "roseitsolutions.uk", true },
  { "roseliere.ch", true },
  { "roseliere.com", true },
  { "roseluna.com", true },
  { "rosemariefloydballet.com", true },
  { "rosenheimsingles.de", true },
  { "rosenkeller.org", true },
  { "roseofyork.com", true },
  { "roseofyorkbooking.com", true },
  { "roseon.net", true },
  { "roseparkhouse.com", true },
  { "rosesciences.com", true },
  { "rosevillefacialplasticsurgery.com", true },
  { "roshhashanahfun.com", true },
  { "roslynpad.net", true },
  { "rosnertexte.at", true },
  { "rosset.me", true },
  { "rosset.net", true },
  { "rossfrancis.co.uk", true },
  { "rossmacphee.com", true },
  { "rostclub.ro", true },
  { "rostov-avia.ru", true },
  { "rostros.eu", true },
  { "rot47.net", true },
  { "rotek.at", true },
  { "roten.email", true },
  { "rothe.io", true },
  { "rothkranz.net", true },
  { "rothnater.ch", true },
  { "rothwellgornthomes.com", true },
  { "rotkreuzshop.de", true },
  { "rotol.me", true },
  { "rottweil-hilft.de", true },
  { "rotunneling.net", true },
  { "rougechocolat.fr", true },
  { "roughcopy.com.au", true },
  { "roughgrain.com", true },
  { "roulinfo.ch", true },
  { "roulons-autrement.com", true },
  { "rounda.it", true },
  { "roundcube.mayfirst.org", false },
  { "roundrock-locksmith.com", true },
  { "roundtablekzn.co.za", true },
  { "roundtoprealestate.com", true },
  { "roussos.cc", true },
  { "rout0r.org", true },
  { "route-wird-berechnet.de", true },
  { "routeragency.com", true },
  { "routerclub.ru", true },
  { "routercncperu.com", true },
  { "routetracker.co", true },
  { "rove3d.com", true },
  { "rowancasting.ie", true },
  { "rowancountync.gov", true },
  { "rowankaag.nl", true },
  { "rowlog.com", true },
  { "rows.io", true },
  { "roxiesbouncycastlehire.co.uk", true },
  { "roxtri.cz", true },
  { "royal-rangers.de", true },
  { "royal806.com", true },
  { "royal810.com", true },
  { "royal811.com", true },
  { "royal812.com", true },
  { "royal813.com", true },
  { "royal816.com", true },
  { "royal817.com", true },
  { "royal818.com", true },
  { "royal830.com", true },
  { "royal833.com", true },
  { "royal850.com", true },
  { "royal851.com", true },
  { "royal852.com", true },
  { "royal853.com", true },
  { "royal855.com", true },
  { "royal856.com", true },
  { "royal857.com", true },
  { "royal859.com", true },
  { "royal86.com", true },
  { "royal861.com", true },
  { "royal862.com", true },
  { "royal863.com", true },
  { "royal865.com", true },
  { "royal867.com", true },
  { "royal868.com", true },
  { "royal869.com", true },
  { "royal871.com", true },
  { "royal872.com", true },
  { "royal873.com", true },
  { "royal875.com", true },
  { "royal877.com", true },
  { "royal879.com", true },
  { "royal88.com", true },
  { "royal88.tech", true },
  { "royal881.com", true },
  { "royal882.com", true },
  { "royal883.com", true },
  { "royal885.com", true },
  { "royal886.com", true },
  { "royal887.com", true },
  { "royal888888.com", true },
  { "royal889.com", true },
  { "royal890.com", true },
  { "royal891.com", true },
  { "royal892.com", true },
  { "royal893.com", true },
  { "royal894.com", true },
  { "royal895.com", true },
  { "royal896.com", true },
  { "royal898.com", true },
  { "royal899.com", true },
  { "royalacademy.org.uk", true },
  { "royalasianescorts.co.uk", true },
  { "royalbeautyclinic.ir", true },
  { "royalbluewa3.cc", true },
  { "royalcitytaxi.ca", true },
  { "royalcitytaxi.com", true },
  { "royalfoxrealtor.com", true },
  { "royalmarinesassociation.org.uk", true },
  { "royalnissanparts.com", true },
  { "royalpalacenogent.fr", true },
  { "royalpub.net", false },
  { "royalrangers.fi", true },
  { "royalty-market.com", true },
  { "royalyule.com", true },
  { "royceandsteph.com", true },
  { "roycewilliams.net", true },
  { "roygerritse.nl", true },
  { "rozalynne-dawn.ga", true },
  { "rozhodce.cz", true },
  { "rpadovani.com", true },
  { "rpauto.ru", true },
  { "rpgcampaign.website", true },
  { "rpgmaker.es", true },
  { "rpherbig.com", true },
  { "rphl.net", true },
  { "rpine.net", true },
  { "rpmdrivingschool.com.au", true },
  { "rpus.co", true },
  { "rpy.xyz", true },
  { "rq-labo.jp", true },
  { "rr105.de", true },
  { "rraesthetics.com", true },
  { "rrdesignsuisse.com", true },
  { "rrg-partner.ch", true },
  { "rro.rs", true },
  { "rrudnik.com", true },
  { "rrwolfe.com", true },
  { "rs-maschinenverleih.de", true },
  { "rsanahuano.com", true },
  { "rsap.ca", true },
  { "rsauget.fr", true },
  { "rsblake.net", true },
  { "rsgcard.com", true },
  { "rsingermd.com", true },
  { "rsl.gd", true },
  { "rsm-liga.de", true },
  { "rsmith.io", true },
  { "rsp-blogs.de", true },
  { "rsridentassist.com", true },
  { "rss.sh", false },
  { "rssr.ddns.net", true },
  { "rssr.se", true },
  { "rsttraining.co.uk", true },
  { "rsync.eu", false },
  { "rt22.ch", true },
  { "rtate.ca", true },
  { "rtate.se", true },
  { "rtcx.net", true },
  { "rtd.uk.com", true },
  { "rte.eu", true },
  { "rte.radio", true },
  { "rte2fm.ie", true },
  { "rteaertel.ie", true },
  { "rtechservices.io", true },
  { "rteguide.ie", true },
  { "rteinternational.ie", true },
  { "rtejr.ie", true },
  { "rtek.se", true },
  { "rtenews.eu", true },
  { "rteone.ie", true },
  { "rteplayer.com", true },
  { "rtesport.eu", true },
  { "rteworld.com", true },
  { "rths.tk", false },
  { "rthsoftware.cn", true },
  { "rthsoftware.net", true },
  { "rtrappman.com", true },
  { "rtrinflatables.co.uk", true },
  { "rtsr.ch", true },
  { "rttvvip.com", true },
  { "rtwcourse.com", true },
  { "rtzoeller.com", true },
  { "ru-sprachstudio.ch", true },
  { "ru.search.yahoo.com", false },
  { "rua.cx", true },
  { "ruaneattorneys.com", true },
  { "ruanmi.de", true },
  { "rubberfurs.org", true },
  { "rubberlegscastles.co.uk", true },
  { "rubbermaidoutlet.com", true },
  { "rubbleremovalsbenoni.co.za", true },
  { "ruben.am", false },
  { "rubenbarbero.com", true },
  { "rubenkruisselbrink.nl", true },
  { "rubens.cloud", true },
  { "rublacklist.net", true },
  { "ruby-auf-schienen.de", true },
  { "rubyist.today", true },
  { "rubymartin.com.au", true },
  { "rubyquincunx.com", true },
  { "rubyquincunx.org", true },
  { "rubytune.com", true },
  { "rucksack-rauf-und-weg.de", true },
  { "ruckzuck-privatpatient.de", true },
  { "rucnerobene.eu", true },
  { "ruconsole.com", true },
  { "rud.is", true },
  { "rudd-o.com", true },
  { "rudelune.fr", true },
  { "rudewiki.com", true },
  { "rudhaulidirectory.com", true },
  { "rudloff.pro", true },
  { "rudnikas.com", true },
  { "rudolph.life", true },
  { "rudolphmarketing.com", true },
  { "rudrastyh.com", true },
  { "ruediger-voigt.eu", true },
  { "ruedigervoigt.de", true },
  { "ruedirrenggli.ch", true },
  { "rueduparticulier.tk", false },
  { "rueegger.me", true },
  { "rueg.eu", true },
  { "ruerte.net", true },
  { "rufabula-com.appspot.com", true },
  { "ruffbeatz.com", true },
  { "rugby.video", true },
  { "rugk.dedyn.io", true },
  { "ruh-veit.de", true },
  { "ruhrmobil-e.de", true },
  { "ruhrnalist.de", true },
  { "ruht.ro", true },
  { "ruicore.cn", true },
  { "ruiming.me", true },
  { "ruin.one", true },
  { "ruiruigeblog.com", true },
  { "ruitersportbak.nl", true },
  { "ruk.ca", true },
  { "rulu.co", true },
  { "rulu.tv", true },
  { "rulutv.com", true },
  { "rumartinez.es", true },
  { "rumlager.de", true },
  { "rummage4property.co.uk", true },
  { "rumplesinflatables.co.uk", true },
  { "rumtaste.com", true },
  { "rumtaste.de", true },
  { "run-it-direct.co.uk", true },
  { "runagain.ch", true },
  { "runebet.com", true },
  { "runklesecurity.com", true },
  { "runnergrapher.com", true },
  { "runreport.fr", true },
  { "runschrauger.com", true },
  { "runtimepanic.xyz", true },
  { "runvs.io", true },
  { "ruobr.ru", true },
  { "rupeevest.com", true },
  { "ruquay.com", true },
  { "ruralink.com.ar", true },
  { "ruralsuppliesdirect.co.uk", true },
  { "ruri.io", false },
  { "rusempire.ru", true },
  { "rushball.net", true },
  { "rushiiworks.com", true },
  { "rushpoppershop.co.uk", true },
  { "rushter.com", true },
  { "rushyo.com", true },
  { "rusi-ns.ca", true },
  { "ruska-modra.cz", true },
  { "ruskamodra.cz", true },
  { "ruskod.net", true },
  { "rusmolotok.ru", true },
  { "russellupevents.co.uk", true },
  { "russia.dating", true },
  { "russiaeconomy.org", true },
  { "russianorthodoxchurch.co.uk", true },
  { "russt.me", true },
  { "rust.mn", true },
  { "rustable.com", true },
  { "rustikalwallis.ch", true },
  { "rustyrambles.com", true },
  { "rusxakep.com", true },
  { "rutgerschimmel.nl", true },
  { "ruthmontenegro.com", false },
  { "rutiger.com", true },
  { "rutika.ru", true },
  { "ruudkoot.nl", true },
  { "ruwhof.net", true },
  { "ruya.com", true },
  { "ruyatabirleri.com", true },
  { "rv-jpshop.com", true },
  { "rva-asbestgroep.nl", true },
  { "rvfu98.com", true },
  { "rvnoel.net", true },
  { "rvsa2bevestigingen.nl", true },
  { "rvsa4bevestigingen.nl", true },
  { "rvsbevestigingen.nl", true },
  { "rw.search.yahoo.com", false },
  { "rwky.net", true },
  { "rws-vertriebsportal.de", true },
  { "rwx.ovh", true },
  { "rx-contact.com", false },
  { "rxbn.de", true },
  { "rxbusiness.com", true },
  { "rxcheck.com", true },
  { "rxgroup.io", true },
  { "rxight.com", true },
  { "ryan-design.com", true },
  { "ryan-gehring.com", true },
  { "ryan-goldstein.com", true },
  { "ryanbritton.com", true },
  { "ryancarter.co.uk", true },
  { "ryanhowell.io", false },
  { "ryankearney.com", false },
  { "ryanmcdonough.co.uk", false },
  { "ryansmithphotography.com", true },
  { "ryazan-region.ru", true },
  { "rychlikoderi.cz", true },
  { "rydermais.tk", true },
  { "rynekpierwotny.pl", true },
  { "ryois.me", true },
  { "rys.pw", true },
  { "ryssl.com", true },
  { "ryu22e.org", true },
  { "ryuu.es", true },
  { "ryyule.com", true },
  { "ryzhov.me", true },
  { "rzentarzewski.net", true },
  { "s-a.xyz", true },
  { "s-c.se", true },
  { "s-cubed.net", true },
  { "s-huset.dk", true },
  { "s-ip-media.de", true },
  { "s-mainte.com", true },
  { "s-n-unso.com", true },
  { "s-pegasus.com", true },
  { "s-s-paint.com", true },
  { "s007.co", true },
  { "s10y.eu", true },
  { "s13d.fr", true },
  { "s16e.no", true },
  { "s2member.com", true },
  { "s2p.moe", true },
  { "s3cur3.it", true },
  { "s3gfault.com", true },
  { "s3robertomarini.it", true },
  { "s404.de", true },
  { "s44.eu", true },
  { "s4db.net", true },
  { "s4media.org", true },
  { "s4q.me", true },
  { "s4tips.com", true },
  { "s5118.com", true },
  { "s64.cz", true },
  { "s8a.us", true },
  { "s95.de", true },
  { "sa-blog.net", true },
  { "sa-mp.ro", true },
  { "sa.net", true },
  { "saabpartsdistribution.com", true },
  { "saamhorigheidsfonds.nl", false },
  { "saastopankki.fi", true },
  { "saba-piserver.info", true },
  { "sabahattin-gucukoglu.com", true },
  { "sabe.cz", true },
  { "sabine-forschbach.de", true },
  { "sabineforschbach.de", true },
  { "sabrinajoias.com.br", true },
  { "sacaentradas.com", true },
  { "saccani.net", true },
  { "sackmesser.ch", true },
  { "saclier.at", true },
  { "sacprincesse.com", true },
  { "sacred-knights.net", true },
  { "sacrome.com", true },
  { "sadbox.es", true },
  { "sadbox.org", true },
  { "sadbox.xyz", true },
  { "sadeghian.us", true },
  { "sadev.co.za", true },
  { "sadhana.cz", true },
  { "sadhawkict.org", true },
  { "sadiejewellery.co.uk", true },
  { "sadmansh.com", true },
  { "sadou.kyoto.jp", true },
  { "saechsischer-christstollen.shop", true },
  { "saengsook.com", true },
  { "saengsuk.com", true },
  { "saf.earth", true },
  { "safar.sk", true },
  { "safaritenten.nl", true },
  { "safcstore.com", true },
  { "safe.moe", true },
  { "safebaseflorida.com", true },
  { "safebasements.com", true },
  { "safebasementsnorthdakota.com", true },
  { "safebasementsofindiana.com", true },
  { "safebuyerscheme.co.uk", true },
  { "safecar.gov", false },
  { "safeex.com", true },
  { "safegold.ca", true },
  { "safegroup.pl", true },
  { "safeguardcommerce.com", true },
  { "safeguardhosting.ca", true },
  { "safeinfra.nl", true },
  { "safejourney.education", true },
  { "safematix.com", true },
  { "safeme.ga", true },
  { "safeocs.gov", true },
  { "safer-networking.org", true },
  { "saferproduct.gov", true },
  { "saferproducts.gov", true },
  { "safersurfing.eu", false },
  { "safescan.com", true },
  { "safestore.io", true },
  { "safetext.me", true },
  { "safetycloud.me", true },
  { "safetynames.com", true },
  { "safetyrisk.net", true },
  { "safetyworkkits.co.nz", true },
  { "safeui.com", true },
  { "safire.ac.za", true },
  { "sagargandecha.com.au", true },
  { "sagedocumentmanager.com", true },
  { "sagerus.com", true },
  { "saggiocc.com", true },
  { "sagracefarms.com", true },
  { "sagsmarseille.com", true },
  { "sahajbooks.com", true },
  { "sahar.io", true },
  { "saharmassachi.com", true },
  { "sahb.dk", true },
  { "sahibinden.com", true },
  { "sahkotyot.eu", true },
  { "said.id", true },
  { "said.my.id", true },
  { "saidelbakkali.com", true },
  { "saidtezel.com", true },
  { "saier.me", true },
  { "saifoundation.in", true },
  { "saigonflowers.com", true },
  { "saikarra.com", true },
  { "saikou.moe", true },
  { "saikouji.tokushima.jp", true },
  { "sailingonward.com", true },
  { "sailormoonevents.org", true },
  { "sailormoonlibrary.org", true },
  { "sailwiz.com", true },
  { "saimoe.moe", true },
  { "sainetworks.net", true },
  { "saint-bernard-gouesch.fr", true },
  { "saint-cyril.com", true },
  { "saintaardvarkthecarpeted.com", true },
  { "saintanne.net", true },
  { "saintanthonyscorner.com", true },
  { "sainth.de", true },
  { "sainthedwig-saintmary.org", true },
  { "sainthelena-centersquare.net", true },
  { "sainthelenas.org", true },
  { "saintisidorecyo.com", true },
  { "saintjamestheapostle.org", true },
  { "saintjohn-bocaraton.com", true },
  { "saintjosephschurch.net", true },
  { "saintmarkchurch.net", true },
  { "saintmaryna.com", true },
  { "saintpatrick-norristown.net", true },
  { "saintpeterchurch.net", true },
  { "saintphilipneri.org", true },
  { "saintpius.net", true },
  { "saintpolycarp.org", true },
  { "saintsrobotics.com", true },
  { "saipariwar.com", true },
  { "saiputra.com", true },
  { "saitrance.com", true },
  { "saitv.org", true },
  { "sajamstudija.info", true },
  { "sajdowski.de", true },
  { "sakaki.anime.my", false },
  { "sakamichi.moe", true },
  { "sakerhetskopiering.nu", true },
  { "sakostacloud.de", true },
  { "sakura-paris.org", true },
  { "sakura.zone", true },
  { "sakuracdn.com", true },
  { "sakuracommunity.com", true },
  { "sakuraflores.com.br", true },
  { "sakuraplay.com", true },
  { "salamon-it.de", false },
  { "salandalairconditioning.com", true },
  { "salde.net", true },
  { "sale4ru.ru", true },
  { "saleduck.at", true },
  { "saleduck.ch", true },
  { "saleduck.co.id", true },
  { "saleduck.co.th", true },
  { "saleduck.com.my", true },
  { "saleduck.com.ph", true },
  { "saleduck.com.sg", true },
  { "saleduck.com.vn", true },
  { "saleduck.dk", true },
  { "saleduck.fi", true },
  { "saleduck.se", true },
  { "salemedia.pro", true },
  { "salensmotors-usedcars.be", true },
  { "salesflare.com", true },
  { "salesmachine.io", true },
  { "salexy.kz", true },
  { "salidaswap.com", true },
  { "salixcode.com", true },
  { "salland1.nl", true },
  { "salle-quali.fr", true },
  { "sallydowns.name", true },
  { "salmododia.net", true },
  { "salmonella.co.uk", true },
  { "salmonvision.com.tw", true },
  { "salmos91.com", true },
  { "salmotierra-salvatierra.com", true },
  { "salon-minipli.de", true },
  { "salon.io", false },
  { "salon1.ee", true },
  { "salonasymetria.com", true },
  { "salonasymetria.pl", true },
  { "salonsantebienetre.ch", true },
  { "salrosadohimalaia.com", true },
  { "salsa-straubing.de", true },
  { "saltbythesea.com", true },
  { "saltercane.com", false },
  { "saltireconservation.com", true },
  { "saltstack.cz", true },
  { "salud.top", false },
  { "saludmas.site", true },
  { "saludsis.mil.co", true },
  { "saludyvida.site", true },
  { "salutethefish.com", true },
  { "salutethegrains.com", true },
  { "salutethepig.com", true },
  { "salva.re", true },
  { "salvagedfurnitureparlour.com", true },
  { "sam-football.fr", true },
  { "samanacafe.com", true },
  { "samanthasgeckos.com", true },
  { "samanthasicecream.com", true },
  { "samappleton.com", true },
  { "samara-avia.ru", true },
  { "samaritainsmeyrin.ch", true },
  { "samatva-yogalaya.com", true },
  { "samba.com.co", true },
  { "samba.org", true },
  { "sambaa.com.br", true },
  { "sambaash.com", true },
  { "sambeso.net", true },
  { "samdev.io", true },
  { "samegoal.com", true },
  { "samegoal.org", true },
  { "samel.de", true },
  { "samenwerkingsportaal.nl", true },
  { "samenwerkingsportaal.tk", true },
  { "sameworks.com", true },
  { "samgrayson.me", true },
  { "samhuri.net", true },
  { "samifar.in", true },
  { "samip.fi", true },
  { "samitechnic.com", true },
  { "samizdat.cz", true },
  { "samkelleher.com", true },
  { "saml-gateway.org", true },
  { "samlaw.co.nz", true },
  { "samlivogarv.dk", true },
  { "sammamish--locksmith.com", true },
  { "sammyservers.com", true },
  { "sammyservers.net", true },
  { "sammyslimos.com", true },
  { "samnya.cn", true },
  { "samrobertson.co.uk", true },
  { "samshouseofspaghetti.net", true },
  { "samsungmobile.it", true },
  { "samsungphonegenerator.xyz", true },
  { "samtalen.nl", true },
  { "samuel-dumont.be", true },
  { "samuelkeeley.com", true },
  { "samuellaulhau.fr", true },
  { "samui-samui.de", false },
  { "samuirehabcenter.com", true },
  { "samwilberforce.com", true },
  { "samwrigley.co.uk", true },
  { "samwu.tw", true },
  { "san.ac.th", true },
  { "sana-store.com", true },
  { "sana-store.cz", true },
  { "sana-store.sk", true },
  { "sanael.net", true },
  { "sanantoniolocksmithinc.com", true },
  { "sanantoniolocksmithtx.com", true },
  { "sanasport.cz", true },
  { "sanasport.sk", true },
  { "sanatorii-sverdlovskoy-oblasti.ru", true },
  { "sanatorionosti.com.ar", true },
  { "sanbornteam.com", true },
  { "sand-islets.de", true },
  { "sandalj.com", true },
  { "sandbagexpress.com", true },
  { "sandbox.mydigipass.com", false },
  { "sandboxfp.com", true },
  { "sandburner.net", true },
  { "sander.sh", true },
  { "sanderdorigo.nl", true },
  { "sanderkoenders.eu", true },
  { "sanderkoenders.nl", true },
  { "sandervanderstap.nl", true },
  { "sandervankasteel.nl", false },
  { "sandhaufen.tk", true },
  { "sandiegotown.com", true },
  { "sandmanintel.com", true },
  { "sandmarc.cz", true },
  { "sandobygg.se", true },
  { "sandogruppen.se", true },
  { "sandor.wtf", true },
  { "sandrainden.nl", true },
  { "sandraindenfotografie.nl", true },
  { "sandrocorapi.com", true },
  { "sandrolittke.de", true },
  { "sandrproperty.com", true },
  { "sandtears.com", true },
  { "sandtonescorts.com", true },
  { "sandtonplumber24-7.co.za", true },
  { "sandtonvipcompanions.com", true },
  { "sandyrobsonhypnotherapy.co.uk", true },
  { "sanemind.de", true },
  { "sanemind.eu", true },
  { "sanepsychologen.nl", true },
  { "sanex.ca", false },
  { "sanglierhurlant.fr", true },
  { "sangwon.io", true },
  { "sanilodge.com", true },
  { "sanipousse.com", true },
  { "sanissimo.com.mx", false },
  { "sanitairwinkel.be", true },
  { "sanitairwinkel.com", true },
  { "sanitairwinkel.nl", true },
  { "sanitrak.cz", true },
  { "sannesfotklinikk.no", true },
  { "sanpham-balea.org", true },
  { "sanskritiyoga.com", true },
  { "sansonehowell.com", true },
  { "santafemacas.com.br", true },
  { "santamonicapost123.org", true },
  { "santanderideas.com", true },
  { "santenatureetcie.com", true },
  { "santensautomatics.be", true },
  { "santevie.ch", true },
  { "santiagogarza.co", true },
  { "santojuken.co.jp", true },
  { "santoshpandit.com", true },
  { "sanvitolocapobus.com", true },
  { "saol.eu", true },
  { "saoneth.pl", 