---
layout: docs
title: Contributing
permalink: /docs/contributing/
---

I'd like like to invite anyone to be part of the project. Generally this is pretty straight forward: Fork the repository, push your changes to the fork and finally send a pull request. However due to problems in the past there are some rules on ***how*** you should contribute:

1. _**Do absolutely not just implement things and send a PR!**_
2. [Contact](/help/) us / Open an issue / Comment an issue.
3. Discuss if the idea is reasonable and find a well designed approach.
4. Work on the issue. Reflect your work. If you have doubts, communicate it.
5. Test it. Not real world testing, but use it a few days yourself.
6. Send a PR to the `dev` branch.

This way nobody has to reject PR's, nobodies PR's will get rejected and there won't be multiple developers working on the same issue.

By contributing your code, you agree to license your contribution under the GPL license. According to the goals, only code that is well designed, documented, clear and readable will be accepted.

## Other contributions

There is plenty of other things you can do aside from coding:

- Star the [project. ![Issues](https://img.shields.io/github/stars/albertlauncher/albert.svg?style=social&label=Stars)](https://github.com/albertlauncher/albert)
- Spread the word.
- Join the community and help other users.
- Use the application and report issues.
- Check the [issues](https://github.com/albertlauncher/albert/issues?utf8=%E2%9C%93&q=is%3Aissue%20is%3Aopen%20sort%3Areactions-%2B1-desc) and try to help debugging. [![Issues](https://img.shields.io/github/issues/albertlauncher/albert.svg)](https://github.com/albertlauncher/albert/issues)
- Improve the documentation (Link on top of the pages).
- Support me as a creator by [donating some bucks](/docs/donation/).


## Supporters

The list [moved](/docs/supporters).
