---
layout: page
title:  "Albert 0.14.0 released"
date: 2017-10-18 18:00 +0100
---

This release contains internal API changes that make developers lifes easier and and a new extension that allows to embed python scripts.

With this release the use of the old CGI style external extension is discouraged. External extensions will stay for now but just for personal use. As soon as the scripts in the public repo of the external extensions have been ported it will be deleted.

With the Python extension writing an extension can be as easy as this:

```python
from albertv0 import *

__iid__ = "PythonInterface/v0.1"

def handleQuery(query):
    return [Item(text="Hello")]

```

This is a valid extension. However it makes not much sense, but by adding some docs, metadata and functionality a pretty minimal example, e.g. to run Zeal, can look like this:

```python
# -*- coding: utf-8 -*-

"""Fire up an external search in Zeal.
Just type zl <query>"""

from albertv0 import *
from subprocess import run
from shutil import which

__iid__ = "PythonInterface/v0.1"
__prettyname__ = "Zeal"
__version__ = "1.0"
__trigger__ = "zl "
__author__ = "Manuel Schneider"
__dependencies__ = ["zeal"]


if which("zeal") is None:
    raise Exception("'zeal' is not in $PATH.")


iconPath = iconLookup('zeal')


def handleQuery(query):
    if query.isTriggered:
        return [
            Item(
                id=__prettyname__,
                icon=iconPath,
                text=__prettyname__,
                subtext="Look up %s" % __prettyname__,
                completion=query.rawString,
                actions=[ProcAction("Start query in %s" % __prettyname__,
                                    ["zeal", query.string])])
        ]
```

This 26 lines build a full fledged extension. In fact it is the Zeal extension.

The documentation is not written at the moment, but the API is darn easy. Take a look at the [API test extension](https://github.com/albertlauncher/python/blob/master/api_test/__init__.py). It should contain every possible thing you can use. If you want to know it exactly read the [interface definition](https://github.com/albertlauncher/plugins/blob/master/python/src/extension.cpp#L60). For real examples of extensions check the [extensions shipped with albert](https://github.com/albertlauncher/python/).

I ask the devs of the external extensions in the public repo to port their extensions to the new scripting API and send a pull request.

I hope you enjoy the new scripting API and I'd be happy to receive pull requests for extensions you wish to see shipped with albert. Have fun.

As always check the [git log](https://github.com/albertlauncher/albert/commits/v0.14.0) for details.
