/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.sosanumbers;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Random;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;

public class ProgressPanel
extends JPanel
implements PropertyChangeListener {
    private ProgressMonitor progressMonitor;
    private Task task;

    public ProgressPanel() {
        super(new BorderLayout());
        this.initComponents();
        this.progressMonitor = new ProgressMonitor(this, "Running a Long Task", "", 0, 100);
        this.progressMonitor.setProgress(0);
        this.task = new Task();
        this.task.addPropertyChangeListener(this);
        this.task.execute();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressMonitor.setProgress(progress);
            String message = String.format("Completed %d%%.\n", progress);
            this.progressMonitor.setNote(message);
            if ((this.progressMonitor.isCanceled() || this.task.isDone()) && this.progressMonitor.isCanceled()) {
                this.task.cancel(true);
            }
        }
    }

    class Task
    extends SwingWorker<Void, Void> {
        Task() {
        }

        @Override
        public Void doInBackground() {
            Random random = new Random();
            int progress = 0;
            this.setProgress(0);
            try {
                Thread.sleep(1000L);
                while (progress < 100 && !this.isCancelled()) {
                    Thread.sleep(random.nextInt(1000));
                    this.setProgress(Math.min(progress += random.nextInt(10), 100));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void done() {
            ProgressPanel.this.progressMonitor.setProgress(100);
        }
    }
}

