/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.sosanumbers;

import ancestris.modules.gedcom.sosanumbers.Constants;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.UnitOfWork;
import genj.util.Registry;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SosaNumbersGenerator
implements Constants {
    private static final Logger LOG = Logger.getLogger(SosaNumbersGenerator.class.getName(), null);
    private Gedcom gedcom = null;
    private Registry registry = null;
    private int mode = 1;
    private int numbering = 1;
    private boolean allSosa = false;
    private Indi indiDeCujus = null;
    private boolean save = true;
    private Set<Indi> changedIndis = null;
    private boolean runBlank = false;
    private int maxCounter = 0;
    private int stoppedCounter = 0;
    private String title = "";
    private ProgressMonitor progressMonitor = null;
    private Task fullTask = null;
    private Runnable task = null;

    public void run(Gedcom gedcom, final Indi indiDeCujus, final String message) {
        this.gedcom = gedcom;
        this.registry = gedcom.getRegistry();
        this.mode = this.registry.get("sosaPanelAction", 1);
        this.numbering = this.registry.get("sosaPanelNumbering", 1);
        this.allSosa = this.registry.get("sosaPanelAllSosa", false);
        this.indiDeCujus = indiDeCujus;
        this.changedIndis = new HashSet<Indi>();
        this.save = this.registry.get("sosaPanelSave", true);
        if (this.mode == 2 && indiDeCujus == null) {
            this.task = new Runnable(){

                @Override
                public void run() {
                    SosaNumbersGenerator.this.title = NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.taskErase");
                    SosaNumbersGenerator.this.eraseAll();
                }
            };
        } else if (indiDeCujus != null) {
            if (this.numbering == 4 || this.numbering == 1 || this.numbering == 2) {
                this.task = new Runnable(){

                    @Override
                    public void run() {
                        SosaNumbersGenerator.this.title = NbBundle.getMessage(this.getClass(), (String)(SosaNumbersGenerator.this.mode != 2 ? "SosaNumbersGenerator.taskNb" : "SosaNumbersGenerator.taskErase"));
                        SosaNumbersGenerator.this.numberUp();
                    }
                };
            } else if (this.numbering == 3) {
                this.task = new Runnable(){

                    @Override
                    public void run() {
                        SosaNumbersGenerator.this.title = NbBundle.getMessage(this.getClass(), (String)(SosaNumbersGenerator.this.mode != 2 ? "SosaNumbersGenerator.taskNb" : "SosaNumbersGenerator.taskErase"));
                        SosaNumbersGenerator.this.numberDown(indiDeCujus, BigInteger.ZERO);
                    }
                };
            }
        }
        JProgressBar progressBar = new JProgressBar(0, 100);
        progressBar.setValue(0);
        progressBar.setStringPainted(false);
        progressBar.setIndeterminate(true);
        JOptionPane optionPane = new JOptionPane(progressBar, 1, -1, null, new Object[0], null);
        final JDialog dialog = new JDialog((Frame)null, NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.calc"), true);
        dialog.setContentPane(optionPane);
        dialog.setDefaultCloseOperation(0);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setLocation((screenSize.width - optionPane.getPreferredSize().width) / 2, (screenSize.height - optionPane.getPreferredSize().height) / 2);
        dialog.pack();
        this.fullTask = new Task(null, 100){

            @Override
            public Void doInBackground() {
                SosaNumbersGenerator.this.runBlank = true;
                SosaNumbersGenerator.this.changedIndis.clear();
                SosaNumbersGenerator.this.maxCounter = 0;
                SosaNumbersGenerator.this.task.run();
                SosaNumbersGenerator.this.runBlank = false;
                dialog.dispose();
                return null;
            }
        };
        this.fullTask.execute();
        dialog.setVisible(true);
        this.progressMonitor = new ProgressMonitor(null, this.title, "", 0, this.maxCounter);
        this.progressMonitor.setProgress(0);
        this.progressMonitor.setMillisToPopup(1);
        this.fullTask = new Task(this.progressMonitor, this.maxCounter){

            @Override
            public Void doInBackground() {
                SosaNumbersGenerator.this.maxCounter = 0;
                SosaNumbersGenerator.this.changedIndis.clear();
                SosaNumbersGenerator.this.stoppedCounter = 0;
                SosaNumbersGenerator.this.commit(SosaNumbersGenerator.this.task);
                String msg = "<html>";
                msg = SosaNumbersGenerator.this.stoppedCounter == 0 ? msg + message + "<br>" + NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.changes", (Object)SosaNumbersGenerator.this.maxCounter) + "</html>" : msg + NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.stopped", (Object)SosaNumbersGenerator.this.stoppedCounter) + "</html>";
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 1));
                return null;
            }
        };
        this.fullTask.execute();
    }

    public boolean setProgress(int progress) {
        if (progress % 10 != 0) {
            return true;
        }
        String message = String.format(NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.progress", (Object)"%d"), progress);
        this.progressMonitor.setNote(message);
        this.progressMonitor.setProgress(progress);
        if ((this.progressMonitor.isCanceled() || this.fullTask.isDone()) && this.progressMonitor.isCanceled()) {
            this.stoppedCounter = progress;
            return false;
        }
        return true;
    }

    private void eraseAll() {
        if (!(this.numbering != 4 && this.numbering != 1 || this.deleteTags(Indi.TAG_SOSADABOVILLE))) {
            return;
        }
        if (!(this.numbering != 4 && this.numbering != 2 || this.deleteTags(Indi.TAG_SOSA))) {
            return;
        }
        if (!(this.numbering != 4 && this.numbering != 3 || this.deleteTags(Indi.TAG_DABOVILLE))) {
            return;
        }
    }

    private boolean numberUp() {
        ArrayList<Pair> sosaPairs = new ArrayList<Pair>();
        BigInteger sosaCounter = BigInteger.ONE;
        ListIterator<Pair> listIter = sosaPairs.listIterator();
        this.updateIndi(this.indiDeCujus, sosaCounter, listIter, sosaPairs, null);
        while (listIter.hasNext()) {
            Pair pair = listIter.next();
            sosaCounter = new BigInteger(pair.value);
            Fam famc = pair.indi.getFamilyWhereBiologicalChild();
            if (famc == null) continue;
            Indi husband = famc.getHusband();
            BigInteger sosa = sosaCounter.shiftLeft(1);
            if (husband != null && !this.updateIndi(husband, sosa, listIter, sosaPairs, null)) {
                return false;
            }
            Indi wife = famc.getWife();
            sosa = sosaCounter.shiftLeft(1).add(BigInteger.ONE);
            if (wife == null || this.updateIndi(wife, sosa, listIter, sosaPairs, null)) continue;
            return false;
        }
        if (this.numbering == 4 || this.numbering == 1) {
            TreeSet<Pair> sosaSet = new TreeSet<Pair>(new SosaComparator());
            sosaSet.addAll(sosaPairs);
            for (Pair p : sosaSet) {
                if (p.indi.getSex() != 1 || this.numberDown(p.indi, new BigInteger(p.value))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean numberDown(Indi indiFrom, BigInteger sosaValue) {
        ArrayList<Pair> dabovillePairs = new ArrayList<Pair>();
        ListIterator<Pair> listIter = null;
        if (this.numbering == 4 || this.numbering == 3) {
            listIter = dabovillePairs.listIterator();
            this.updateIndi(indiFrom, sosaValue, listIter, dabovillePairs, "1");
        } else {
            dabovillePairs.add(new Pair(indiFrom, sosaValue == BigInteger.ZERO ? "1" : ""));
            listIter = dabovillePairs.listIterator();
        }
        while (listIter.hasNext()) {
            Fam[] families;
            Pair pair = listIter.next();
            Character suffix = Character.valueOf('a');
            String daboCounter = pair.value;
            for (Fam family : families = pair.indi.getFamiliesWhereSpouse()) {
                int childOrder = 0;
                for (Indi child : family.getChildren(true)) {
                    ++childOrder;
                    if (this.changedIndis.contains(child)) continue;
                    String counter = daboCounter + (families.length > 1 ? suffix.toString() : "");
                    counter = counter + (counter.length() > 0 ? "." : "");
                    if (this.updateIndi(child, sosaValue, listIter, dabovillePairs, counter = counter + childOrder)) continue;
                    return false;
                }
                Character object = suffix;
                Character c = suffix = Character.valueOf((char)(suffix.charValue() + '\u0001'));
            }
        }
        return true;
    }

    private boolean updateIndi(Indi indi, BigInteger sosaNumber, ListIterator<Pair> listIter, List<Pair> list, String daboValue) {
        boolean isNew;
        int nbErased = 0;
        boolean bl = isNew = !this.contains(list, indi);
        if (isNew && (this.numbering == 4 || this.numbering == 1)) {
            nbErased += indi.getProperties(Indi.TAG_SOSADABOVILLE).length;
            if (!this.runBlank) {
                indi.delProperties(Indi.TAG_SOSADABOVILLE);
            }
        }
        if (isNew && (this.numbering == 4 || this.numbering == 2)) {
            nbErased += indi.getProperties(Indi.TAG_SOSA).length;
            if (!this.runBlank) {
                indi.delProperties(Indi.TAG_SOSA);
            }
        }
        if (isNew && (this.numbering == 4 || this.numbering == 3)) {
            nbErased += indi.getProperties(Indi.TAG_DABOVILLE).length;
            if (!this.runBlank) {
                indi.delProperties(Indi.TAG_DABOVILLE);
            }
        }
        if (isNew || this.allSosa) {
            listIter.add(new Pair(indi, daboValue == null ? this.nbToString(sosaNumber) : daboValue));
            listIter.previous();
        }
        if (isNew) {
            this.changedIndis.add(indi);
            this.maxCounter = this.mode != 2 ? ++this.maxCounter : (this.maxCounter += nbErased);
            if (this.runBlank) {
                return true;
            }
        }
        if ((isNew || this.allSosa) && this.mode != 2) {
            Property prop = null;
            try {
                String value = this.nbToString(sosaNumber, "", true, daboValue);
                if (this.numbering == 1) {
                    prop = indi.addProperty(Indi.TAG_SOSADABOVILLE, value, this.getNumberPosition((Property)indi, Indi.TAG_SOSADABOVILLE, sosaNumber));
                } else if (this.numbering == 2) {
                    prop = indi.addProperty(Indi.TAG_SOSA, value, this.getNumberPosition((Property)indi, Indi.TAG_SOSA, sosaNumber));
                } else if (this.numbering == 3) {
                    prop = indi.addProperty(Indi.TAG_DABOVILLE, value, this.setPropertyPosition((Property)indi, Indi.TAG_DABOVILLE));
                }
                LOG.log(Level.FINER, "{0} -> {1}", new Object[]{indi.toString(true), value});
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (prop != null) {
                prop.setGuessed(!this.save);
            }
        }
        return !isNew || this.setProgress(this.maxCounter);
    }

    public boolean deleteTags(String tagToRemove) {
        if (this.runBlank) {
            for (Entity entity : this.gedcom.getIndis()) {
                List props = entity.getAllProperties(tagToRemove);
                this.maxCounter += props.size();
            }
        } else {
            for (Entity entity : this.gedcom.getIndis()) {
                List props = entity.getAllProperties(tagToRemove);
                for (Property prop : props) {
                    Property parent = prop.getParent();
                    if (parent == null) continue;
                    LOG.log(Level.FINER, "Tag {0} {1} deleted for {1}", new Object[]{tagToRemove, prop.getDisplayValue(), entity.toString(true)});
                    parent.delProperty(prop);
                    ++this.maxCounter;
                    if (this.setProgress(this.maxCounter)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean contains(List<Pair> list, Indi indi) {
        for (Pair pair : list) {
            if (pair.indi != indi) continue;
            return true;
        }
        return false;
    }

    private int getNumberPosition(Property prop, String tag, BigInteger value) {
        if (prop == null) {
            return 1;
        }
        BigInteger bi = BigInteger.ZERO;
        Property[] props = prop.getProperties(tag);
        if (props != null && props.length != 0) {
            for (Property p : props) {
                bi = this.extractNumber(p.getDisplayValue());
                if (bi.compareTo(value) <= 0) continue;
                return prop.getPropertyPosition(p);
            }
            return prop.getPropertyPosition(props[props.length - 1]) + 1;
        }
        Property pName = prop.getProperty("NAME");
        if (pName != null) {
            return prop.getPropertyPosition(pName) + 1;
        }
        return 1;
    }

    private int setPropertyPosition(Property prop, String tag) {
        if (prop == null) {
            return 1;
        }
        Property[] props = prop.getProperties(tag);
        if (props != null && props.length != 0) {
            return prop.getPropertyPosition(props[props.length - 1]) + 1;
        }
        Property pName = prop.getProperty("NAME");
        if (pName != null) {
            return prop.getPropertyPosition(pName) + 1;
        }
        return 1;
    }

    private BigInteger extractNumber(String str) {
        int start;
        int end = 0;
        for (start = 0; start <= str.length() - 1 && !Character.isDigit(str.charAt(start)); ++start) {
        }
        for (end = start; end <= str.length() - 1 && Character.isDigit(str.charAt(end)); ++end) {
        }
        if (end == start) {
            return BigInteger.ZERO;
        }
        return new BigInteger(str.substring(start, end));
    }

    protected String nbToString(BigInteger sosa) {
        return this.nbToString(sosa, "", false);
    }

    protected String nbToString(BigInteger sosa, String suffix, boolean gen) {
        return this.nbToString(sosa, suffix, gen, "");
    }

    protected String nbToString(BigInteger sosa, String suffix, boolean gen, String daboValue) {
        String sosaStr;
        DecimalFormat formatNbrs = new DecimalFormat("0");
        String string = sosaStr = sosa != BigInteger.ZERO ? formatNbrs.format(sosa) : "";
        String dabo = daboValue == null || daboValue.isEmpty() ? "" : (sosa != BigInteger.ZERO ? "-" + daboValue : daboValue);
        int genInt = sosa.bitLength();
        if (!dabo.isEmpty()) {
            int i = 1;
            for (int k = 0; k < dabo.length(); ++k) {
                if (dabo.charAt(k) != '.') continue;
                ++i;
            }
            genInt -= i;
        }
        String genStr = gen && sosa != BigInteger.ZERO ? " G" + genInt : "";
        return sosaStr + suffix + dabo + genStr;
    }

    private void commit(final Runnable change) {
        block5: {
            try {
                if (this.gedcom.isWriteLocked()) {
                    change.run();
                    break block5;
                }
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        change.run();
                    }
                });
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Error committing sosa generator", t);
            }
        }
    }

    private class Task
    extends SwingWorker<Void, Void> {
        private ProgressMonitor pm;
        private int maxp = 0;

        public Task(ProgressMonitor progressMonitor, int maxProgress) {
            this.pm = progressMonitor;
            this.maxp = maxProgress;
        }

        @Override
        public Void doInBackground() {
            return null;
        }

        @Override
        public void done() {
            if (this.pm != null) {
                this.pm.setProgress(this.maxp);
            }
        }
    }

    private class Pair {
        Indi indi;
        String value;

        public Pair(Indi indi, String value) {
            this.indi = indi;
            this.value = value;
        }
    }

    private class SosaComparator
    implements Comparator<Pair> {
        private SosaComparator() {
        }

        @Override
        public int compare(Pair p1, Pair p2) {
            BigInteger bi1 = new BigInteger(p1.value);
            BigInteger bi2 = new BigInteger(p2.value);
            return bi1.compareTo(bi2);
        }
    }
}

