/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.exports.cousinsgenweb;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.modules.exports.cousinsgenweb.CousinsGenWebPanel;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.PropertyPlace;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.WindowManager;

public final class CousinsGenWebAction
extends AbstractAncestrisContextAction {
    CousinsGenWebPanel cousinGenWebPanel;
    DialogDescriptor cousinGenWebPanelDescriptor;
    public int depPos = 0;
    public int cityPos = 0;
    public int depLen = 0;
    File dir = null;
    InputOutput io = null;

    public CousinsGenWebAction() {
        this.setImage("ancestris/modules/exports/cousinsgenweb/cousinsgenweb.png");
        this.setText(NbBundle.getMessage(CousinsGenWebAction.class, (String)"CTL_CousinsGenWebAction"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
    }

    public void actionPerformed(ActionEvent e) {
        Context contextToOpen = this.getContext();
        if (contextToOpen != null) {
            this.cousinGenWebPanel = new CousinsGenWebPanel(contextToOpen);
            this.cousinGenWebPanelDescriptor = new DialogDescriptor((Object)this.cousinGenWebPanel, NbBundle.getMessage(CousinsGenWebPanel.class, (String)"CTL_CousinsGenWebAction"), true, (ActionListener)new CousinGenWebPanelDescriptorActionListener());
            Dialog dialog = DialogDisplayer.getDefault().createDialog(this.cousinGenWebPanelDescriptor);
            dialog.setVisible(true);
            dialog.toFront();
            if (this.cousinGenWebPanelDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                if (this.dir == null) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(CousinsGenWebAction.class, (String)"ERR_EmptyDirectory"), 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    return;
                }
                CousinsGenWebAction.showWaitCursor();
                Gedcom myGedcom = contextToOpen.getGedcom();
                Collection indis = myGedcom.getEntities("INDI");
                this.io = IOProvider.getDefault().getIO(NbBundle.getMessage(CousinsGenWebAction.class, (String)"CousinsGenWebAction.TabTitle") + " " + myGedcom.getName(), true);
                this.io.getOut().println(String.format(NbBundle.getMessage(CousinsGenWebAction.class, (String)"CousinsGenWebAction.Start"), myGedcom.getName()));
                TreeMap<String, Object> primary = new TreeMap<String, Object>();
                Iterator it = indis.iterator();
                while (it.hasNext()) {
                    this.analyze((Indi)it.next(), primary);
                }
                for (String p : primary.keySet()) {
                    try {
                        this.export(p, primary, this.dir);
                    }
                    catch (IOException ioe) {
                        System.err.println("IO Exception!");
                        ioe.printStackTrace();
                    }
                }
                this.io.getOut().println(NbBundle.getMessage(CousinsGenWebAction.class, (String)"CousinsGenWebAction.End"));
                this.io.getOut().close();
                this.io.getErr().close();
                CousinsGenWebAction.hideWaitCursor();
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(CousinsGenWebAction.class, (String)"CousinsGenWebAction.End"), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
        }
    }

    private static void showWaitCursor() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                JFrame mainWindow = (JFrame)WindowManager.getDefault().getMainWindow();
                mainWindow.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
                mainWindow.getGlassPane().setVisible(true);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(CousinsGenWebAction.class, (String)"CousinsGenWebAction.Start"));
            }
        });
    }

    private static void hideWaitCursor() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                StatusDisplayer.getDefault().setStatusText("");
                JFrame mainWindow = (JFrame)WindowManager.getDefault().getMainWindow();
                mainWindow.getGlassPane().setVisible(false);
                mainWindow.getGlassPane().setCursor(null);
            }
        });
    }

    private void analyze(Indi indi, Map<String, Object> primary) {
        String name = indi.getLastName();
        if (name.length() == 0) {
            return;
        }
        for (PropertyPlace place : indi.getProperties(PropertyPlace.class)) {
            String jurisdiction;
            String dept = place.getJurisdiction(this.depPos);
            if (dept == null || dept.length() == 0) continue;
            int l = Math.min(dept.length(), this.depLen);
            if (l > 0) {
                dept = dept.substring(0, l);
            }
            if ((jurisdiction = place.getJurisdiction(this.cityPos)).length() == 0) {
                jurisdiction = "???";
            }
            this.keep(name, jurisdiction, dept, primary);
        }
    }

    private void keep(String name, String place, String dept, Map<String, Object> primary) {
        Map secondary = (Map)this.lookup(primary, dept, TreeMap.class);
        Map namelist = (Map)this.lookup(secondary, place, TreeMap.class);
        this.lookup(namelist, name, TreeMap.class);
    }

    private Object lookup(Map<String, Object> index, String key, Class<? extends Object> fallback) {
        Object result = index.get(key);
        if (result == null) {
            try {
                result = fallback.newInstance();
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new IllegalArgumentException("can't instantiate fallback " + fallback);
            }
            index.put(key, result);
        }
        return result;
    }

    private void export(String dept, Map<String, Object> primary, File directory) throws IOException {
        File file = new File(directory, dept + ".csv");
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
        this.io.getOut().println("DepartmentJur : " + dept);
        Map secondary = (Map)this.lookup(primary, dept, null);
        for (String s : secondary.keySet()) {
            Map namelist = (Map)this.lookup(secondary, s, null);
            for (String t : namelist.keySet()) {
                this.io.getOut().println("  " + t + " ; " + s);
                out.write(t + " ; " + s);
                out.newLine();
            }
        }
        out.close();
    }

    private class CousinGenWebPanelDescriptorActionListener
    implements ActionListener {
        private CousinGenWebPanelDescriptorActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CousinsGenWebAction.this.depPos = CousinsGenWebAction.this.cousinGenWebPanel.getDepPos();
            CousinsGenWebAction.this.cityPos = CousinsGenWebAction.this.cousinGenWebPanel.getCityPos();
            CousinsGenWebAction.this.depLen = CousinsGenWebAction.this.cousinGenWebPanel.getDepLength();
            CousinsGenWebAction.this.dir = CousinsGenWebAction.this.cousinGenWebPanel.getFile();
        }
    }
}

