/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyXRef;
import genj.util.swing.ImageIcon;
import javax.swing.Icon;

public class CreateParent
extends CreateRelationship {
    private static final ImageIcon IMG = new ImageIcon(CreateParent.class, "Parents.png");
    private static final ImageIcon IMG_FA = new ImageIcon(CreateParent.class, "Father.png");
    private static final ImageIcon IMG_MO = new ImageIcon(CreateParent.class, "Mother.png");
    private Entity entity;
    private Indi child;
    private Fam family;
    private int sex = 0;

    public CreateParent() {
        super(resources.getString("add.parent"), "INDI");
    }

    public CreateParent(Entity entity) {
        this(entity, 0);
    }

    public CreateParent(Entity entity, int sex) {
        super(CreateParent.calcName(sex), "INDI");
        this.entity = entity;
        this.sex = sex;
        this.setImage((Icon)(sex == 1 ? IMG_FA : (sex == 2 ? IMG_MO : IMG)));
        this.initialize(entity, sex);
        this.contextChanged();
    }

    private static String calcName(int sex) {
        if (sex == 2) {
            return resources.getString("add.mother");
        }
        if (sex == 1) {
            return resources.getString("add.father");
        }
        return resources.getString("add.parent");
    }

    private boolean initialize(Entity entity, int sex) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof Fam) {
            this.family = (Fam)entity;
            this.child = this.family.getNoOfChildren() > 0 ? this.family.getChild(0) : null;
            this.sex = sex;
            return this.family.acceptSpouse(sex);
        }
        if (entity instanceof Indi) {
            this.child = (Indi)entity;
            this.family = null;
            this.sex = sex;
            Fam[] fams = this.child.getFamiliesWhereChild();
            if (fams.length == 0) {
                return true;
            }
            for (Fam fam : fams) {
                if (!fam.acceptSpouse(sex)) continue;
                this.family = fam;
                return true;
            }
        }
        return false;
    }

    protected final void contextChanged() {
        this.entity = null;
        if (this.contextProperties.size() == 1 && this.contextProperties.get(0) instanceof Entity) {
            this.entity = (Entity)this.contextProperties.get(0);
        }
        if (this.entity != null && this.initialize(this.entity, this.sex)) {
            this.setEnabled(true);
            this.setTip(resources.getString("link", new Object[]{this.getDescription()}));
        } else {
            this.setEnabled(false);
            this.setTip(resources.getString("add.parent"));
        }
    }

    @Override
    public String getDescription() {
        if (this.child != null) {
            return resources.getString(this.sex == 1 ? "add.father.of" : (this.sex == 2 ? "add.mother.of" : "add.parent.of"), new Object[]{this.child});
        }
        return resources.getString(this.sex == 1 ? "add.father.in" : (this.sex == 2 ? "add.mother.in" : "add.parent.in"), new Object[]{this.family});
    }

    @Override
    public String getWarning(Entity indi) {
        Fam fam;
        if (this.child != null && this.family == null && (fam = this.child.getFamilyWhereBiologicalChild()) != null) {
            return PropertyChild.getLabelChildAlreadyinFamily((Indi)this.child, (Fam)fam);
        }
        return null;
    }

    @Override
    protected Property change(Entity parent, boolean parentIsNew) throws GedcomException {
        String lastname;
        PropertyXRef FAMS;
        Gedcom ged = parent.getGedcom();
        if (this.family != null) {
            if (parentIsNew && this.sex > 0) {
                ((Indi)parent).setSex(this.sex);
            }
            FAMS = this.family.setSpouse((Indi)parent).getTarget();
            Indi other = this.family.getOtherSpouse((Indi)parent);
            lastname = this.sex == 1 || GedcomOptions.getInstance().isSetWifeLastname() ? (this.child != null ? this.child.getLastName() : (other != null ? other.getLastName() : "")) : "";
            if (parentIsNew && this.sex == 0) {
                ((Indi)parent).setSex(this.sex);
            }
        } else {
            lastname = this.sex == 1 || GedcomOptions.getInstance().isSetWifeLastname() ? this.child.getLastName() : "";
            this.family = (Fam)ged.createEntity("FAM");
            this.family.addChild(this.child);
            this.family.addDefaultProperties();
            if (parentIsNew && this.sex > 0) {
                ((Indi)parent).setSex(this.sex);
            }
            FAMS = this.family.setSpouse((Indi)parent).getTarget();
            if (parentIsNew && this.sex == 0) {
                ((Indi)parent).setSex(this.sex);
            }
            if (GedcomOptions.getInstance().getCreateSpouse() && this.family.getNoOfSpouses() < 2) {
                Indi spouse = (Indi)ged.createEntity("INDI");
                spouse.addDefaultProperties();
                this.family.setSpouse(spouse);
                if (GedcomOptions.getInstance().isSetWifeLastname() || spouse.getSex() == 1) {
                    spouse.setName("", lastname);
                }
            }
        }
        if (parentIsNew && (((Indi)parent).getSex() == 1 || GedcomOptions.getInstance().isSetWifeLastname())) {
            ((Indi)parent).setName("", lastname);
        }
        return FAMS;
    }
}

