/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import ancestris.util.swing.SelectRelationshipPanel;
import genj.common.SelectEntityWidget;
import genj.edit.actions.AbstractChange;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.util.Registry;
import genj.util.WordBuffer;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class CreateRelationship
extends AbstractChange {
    protected Registry REGISTRY = Registry.get(CreateRelationship.class);
    private SelectRelationshipPanel select = null;
    private Entity existing;
    private Entity created;
    private JTextField requestID;
    protected String targetType;
    private boolean isNew;

    public CreateRelationship() {
    }

    public CreateRelationship(String name, String targetType) {
        this();
        this.setTargetType(targetType);
        this.setText(name);
    }

    public final void setTargetType(String targetType) {
        if (targetType != null) {
            this.setImage((Icon)Gedcom.getEntityImage((String)targetType));
        }
        this.targetType = targetType;
    }

    @Override
    protected String getConfirmMessage() {
        WordBuffer result = new WordBuffer("<br>");
        result.append(this.existing == null ? resources.getString("confirm.new", new Object[]{Gedcom.getName((String)this.targetType, (boolean)false), this.getGedcom()}) : resources.getString("confirm.use", new Object[]{this.existing.getId(), this.getGedcom()}));
        result.append(" ");
        result.append(resources.getString("confirm.new.related", new Object[]{this.getDescription()}));
        String warning = this.getWarning(this.existing);
        if (warning != null) {
            result.append("<br><br>/!\\ " + warning);
        }
        return result.toString();
    }

    public abstract String getDescription();

    public String getWarning(Entity target) {
        return null;
    }

    @Override
    protected JPanel getDialogContent() {
        this.existing = this.targetType.equals("INDI") ? null : this.getGedcom().getEntity(this.REGISTRY.get("select." + this.getGedcom().getName() + "." + this.targetType, (String)null));
        this.select = new SelectRelationshipPanel(this.getGedcom(), this.targetType, this.getConfirmMessage(), this.existing, SelectEntityWidget.NEW){

            public String getLabel() {
                CreateRelationship.this.existing = CreateRelationship.this.select.getSelection();
                return CreateRelationship.this.getConfirmMessage();
            }
        };
        this.requestID = this.select.getTextIDComponent();
        return this.select;
    }

    @Override
    protected final Context execute(Gedcom gedcom, ActionEvent event) throws GedcomException {
        Entity change;
        this.existing = this.select.getSelection();
        if (this.existing != null) {
            change = this.existing;
        } else {
            String id = null;
            if (this.requestID.isEditable() && gedcom.getEntity(this.targetType, id = this.requestID.getText()) != null) {
                throw new GedcomException(resources.getString("assign_id_error", new Object[]{id}));
            }
            change = gedcom.createEntity(this.targetType, id);
            change.addDefaultProperties();
        }
        this.isNew = change != this.existing;
        this.created = change;
        Property focus = this.change(change, change != this.existing);
        this.REGISTRY.put("select." + gedcom.getName() + "." + this.targetType, change.getId());
        return new Context(focus.getEntity());
    }

    public boolean isNew() {
        return this.isNew;
    }

    public Entity getCreated() {
        return this.created;
    }

    protected abstract Property change(Entity var1, boolean var2) throws GedcomException;
}

