/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateParent;
import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.util.swing.ImageIcon;
import javax.swing.Icon;

public class CreateSibling
extends CreateRelationship {
    private static final ImageIcon IMG_BROTHER = new ImageIcon(CreateParent.class, "Brother.png");
    private static final ImageIcon IMG_SISTER = new ImageIcon(CreateParent.class, "Sister.png");
    private static final ImageIcon IMG_SIBLING = new ImageIcon(CreateParent.class, "Sibling.png");
    private Indi sibling;
    private int sex = 0;

    public CreateSibling() {
        this(null, 0);
    }

    public CreateSibling(Indi sibling, int sex) {
        super(CreateSibling.calcName(sex), "INDI");
        this.sex = sex;
        this.setImage((Icon)(sex == 1 ? IMG_BROTHER : (sex == 2 ? IMG_SISTER : IMG_SIBLING)));
        this.setContextProperties((Property)sibling);
        this.contextChanged();
    }

    private static String calcName(int sex) {
        if (sex == 2) {
            return resources.getString("add.sister");
        }
        if (sex == 1) {
            return resources.getString("add.brother");
        }
        return resources.getString("add.sibling");
    }

    protected final void contextChanged() {
        this.sibling = null;
        if (this.contextProperties.size() == 1 && this.contextProperties.get(0) instanceof Indi) {
            this.sibling = (Indi)this.contextProperties.get(0);
        }
        if (this.sibling != null) {
            this.setEnabled(true);
            this.setTip(resources.getString("link", new Object[]{this.getDescription()}));
        } else {
            this.setEnabled(false);
            this.setTip(null);
        }
    }

    @Override
    public String getDescription() {
        return resources.getString(this.sex == 1 ? "add.brother.of" : (this.sex == 2 ? "add.sister.of" : "add.sibling.of"), new Object[]{this.sibling});
    }

    @Override
    protected Property change(Entity target, boolean targetIsNew) throws GedcomException {
        PropertyXRef CHIL;
        Fam[] fams = this.sibling.getFamiliesWhereChild();
        if (fams.length > 0) {
            CHIL = fams[0].addChild((Indi)target);
        } else {
            fams = ((Indi)target).getFamiliesWhereChild();
            if (fams.length > 0) {
                CHIL = fams[0].addChild(this.sibling);
            } else {
                Gedcom ged = this.sibling.getGedcom();
                Fam fam = (Fam)ged.createEntity("FAM");
                try {
                    CHIL = fam.addChild((Indi)target);
                }
                catch (GedcomException e) {
                    ged.deleteEntity((Entity)fam);
                    throw e;
                }
                Indi husband = (Indi)ged.createEntity("INDI").addDefaultProperties();
                Indi wife = (Indi)ged.createEntity("INDI").addDefaultProperties();
                husband.setName("", this.sibling.getLastName());
                if (GedcomOptions.getInstance().isSetWifeLastname()) {
                    wife.setName("", this.sibling.getLastName());
                }
                fam.setHusband(husband);
                fam.setWife(wife);
                fam.addChild(this.sibling);
            }
        }
        if (targetIsNew) {
            Indi indi = (Indi)target;
            indi.setName("", this.sibling.getLastName());
            indi.setSex(this.sex);
        }
        return CHIL.getTarget();
    }
}

