/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import ancestris.util.swing.DialogManager;
import genj.edit.actions.AbstractChange;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.util.swing.ImageIcon;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.TextAreaWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import modules.editors.gedcomproperties.GedcomPropertiesPlaceFormatPanel;
import modules.editors.gedcomproperties.GedcomPropertiesWizardIterator;
import modules.editors.gedcomproperties.utils.GedcomPlacesAligner;
import modules.editors.gedcomproperties.utils.GedcomPlacesConverter;
import modules.editors.gedcomproperties.utils.PlaceFormatConverterPanel;
import modules.editors.gedcomproperties.utils.PlaceFormatInterface;
import org.openide.util.LookupEvent;
import org.openide.util.NbBundle;

public class SetPlaceHierarchy
extends AbstractChange
implements PlaceFormatInterface {
    private static ImageIcon IMG = new ImageIcon((Icon)new javax.swing.ImageIcon(SetPlaceHierarchy.class.getResource("parameters.png")));
    private PropertyPlace place;
    GedcomPropertiesPlaceFormatPanel placePanel;
    private JLabel wrngMsg;
    PlaceFormatConverterPanel pfc;

    public SetPlaceHierarchy() {
        this.setImageText(IMG, resources.getString("place.hierarchy"));
        this.setTip(resources.getString("place.hierarchy.tip"));
    }

    public SetPlaceHierarchy(PropertyPlace place) {
        this();
        this.place = place;
        this.contextChanged();
    }

    public void resultChanged(LookupEvent ev) {
        Property p;
        Collection props = this.lkpInfo.allInstances();
        this.place = props.size() != 1 ? null : ((p = (Property)props.iterator().next()) instanceof PropertyPlace ? (PropertyPlace)p : null);
        super.resultChanged(ev);
    }

    protected final void contextChanged() {
        if (this.place != null) {
            this.setEnabled(true);
            this.setTip(resources.getString("place.hierarchy.tip"));
        } else {
            this.setEnabled(false);
        }
    }

    protected JComponent getComponent(String msg, int lines, Color color) {
        TextAreaWidget result = new TextAreaWidget(msg, lines, 40);
        result.setWrapStyleWord(true);
        result.setLineWrap(true);
        result.setEditable(false);
        result.setBackground(color);
        return new JScrollPane((Component)result);
    }

    @Override
    protected String getConfirmMessage() {
        return "";
    }

    @Override
    protected JPanel getDialogContent() {
        JPanel result = new JPanel((LayoutManager)new NestedBlockLayout("<col><row><text wx=\"1\" wy=\"1\" pad=\"5\"/></row><row><text wx=\"1\" wy=\"1\" pad=\"17\"/></row></col>"));
        this.placePanel = new GedcomPropertiesPlaceFormatPanel((PlaceFormatInterface)this);
        this.placePanel.setPLAC(this.getOriginalPlaceFormat());
        result.add((Component)this.placePanel);
        this.wrngMsg = new JLabel("");
        return result;
    }

    public void warnVersionChange(boolean canBeConverted) {
        if (this.wrngMsg == null) {
            return;
        }
        if (canBeConverted) {
            this.wrngMsg.setText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"WNG_PlaceFormatChanged"));
        } else {
            this.wrngMsg.setText("");
        }
    }

    public String getOriginalPlaceFormat() {
        return this.place.getGedcom().getPlaceFormat();
    }

    public void setPlaceFormatConverter(PlaceFormatConverterPanel pfc) {
        this.pfc = pfc;
    }

    public PlaceFormatConverterPanel getPlaceFormatConverter() {
        return this.pfc;
    }

    @Override
    protected Context execute(Gedcom gedcom, ActionEvent event) throws GedcomException {
        String msg;
        String title;
        Object o;
        if (this.placePanel.getPlacesConversionToBeDone() && (o = DialogManager.createYesNo((String)NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"GedcomPropertiesPlaceFormatPanel.jCheckBox2.toolTipText", (Object)PropertyPlace.getFormat((String)gedcom.getPlaceFormat()).length), (String)NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"WNG_ConfirmPlaceAlignment")).setMessageType(0).show()) == DialogManager.YES_OPTION) {
            title = NbBundle.getMessage(SetPlaceHierarchy.class, (String)"TITL_PlacesAlignment");
            msg = "";
            GedcomPlacesAligner placesAligner = new GedcomPlacesAligner(gedcom);
            msg = placesAligner.convert() ? NbBundle.getMessage(SetPlaceHierarchy.class, (String)"MSG_GedcomPlacesAligned", (Object)placesAligner.getNbOfPlacesAligned(), (Object)placesAligner.getNbOfPlaces()) : NbBundle.getMessage(SetPlaceHierarchy.class, (String)"MSG_GedcomPlacesNotAligned", (Object)placesAligner.getNbOfPlacesAligned(), (Object)placesAligner.getNbOfPlaces());
            DialogManager.create((String)title, (String)msg).setMessageType(1).show();
        }
        if (this.placePanel.getConversionToBeDone()) {
            o = DialogManager.createYesNo((String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jCheckBox1.text"), (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"WNG_ConfirmPlaceConversion")).setMessageType(0).show();
            if (o == DialogManager.YES_OPTION) {
                title = NbBundle.getMessage(SetPlaceHierarchy.class, (String)"TITL_PlacesFormatModification");
                msg = "";
                GedcomPlacesConverter placesConverter = new GedcomPlacesConverter(gedcom, this.getOriginalPlaceFormat(), this.placePanel.getPLAC(), this.pfc.getConversionMapAsString());
                if (placesConverter.convert()) {
                    msg = NbBundle.getMessage(SetPlaceHierarchy.class, (String)"MSG_GedcomModified", (Object)placesConverter.getNbOfDifferentChangedPlaces(), (Object)placesConverter.getNbOfDifferentFoundPlaces());
                    gedcom.setPlaceFormat(this.placePanel.getPLAC());
                } else {
                    msg = NbBundle.getMessage(SetPlaceHierarchy.class, (String)"MSG_GedcomNotModified", (Object)placesConverter.getNbOfDifferentChangedPlaces(), (Object)placesConverter.getNbOfDifferentFoundPlaces());
                }
                DialogManager.create((String)title, (String)msg).setMessageType(1).show();
            }
        } else {
            Object o2;
            String newFormat;
            String oldFormat = gedcom.getPlaceFormat();
            if (!oldFormat.equals(newFormat = this.placePanel.getPLAC()) && (o2 = DialogManager.createYesNo((String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"STEP_4_name"), (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"WNG_ConfirmPlaceHeaderChange")).setMessageType(0).show()) == DialogManager.YES_OPTION) {
                String title2 = NbBundle.getMessage(SetPlaceHierarchy.class, (String)"TITL_PlacesHeaderModification");
                gedcom.setPlaceFormat(newFormat);
                String msg2 = NbBundle.getMessage(SetPlaceHierarchy.class, (String)"MSG_GedcomHeaderModified");
                DialogManager.create((String)title2, (String)msg2).setMessageType(1).show();
            }
        }
        return new Context((Property)this.place);
    }

    public int getMode() {
        return 2;
    }
}

