/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.geo;

import ancestris.api.editor.AncestrisEditor;
import ancestris.api.place.Place;
import ancestris.modules.editors.geoplace.PlaceEditor;
import ancestris.modules.geo.GeoChildrenNodes;
import ancestris.modules.geo.GeoListTopComponent;
import ancestris.modules.geo.GeoMapTopComponent;
import ancestris.modules.geo.GeoNodeObject;
import ancestris.modules.geo.GeoPlacesList;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.gedcom.UnitOfWork;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.netbeans.api.javahelp.Help;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

class GeoNode
extends AbstractNode
implements PropertyChangeListener {
    public GeoNode(GeoPlacesList gpl) {
        super((Children)new GeoChildrenNodes(gpl));
        this.setDisplayName(NbBundle.getMessage(GeoListTopComponent.class, (String)"GeoListRoot") + " " + gpl.getGedcom().getName());
    }

    public GeoNode(GeoNodeObject obj) {
        super((Children)(obj != null && !obj.isEvent ? new GeoChildrenNodes(obj) : Children.LEAF), Lookups.singleton((Object)obj));
        if (obj != null) {
            this.setDisplayName(obj.toString());
            obj.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)obj));
        }
    }

    public String getHtmlDisplayName() {
        GeoNodeObject obj = (GeoNodeObject)this.getLookup().lookup(GeoNodeObject.class);
        if (obj != null) {
            String text = obj.toDisplayString();
            String color = obj.getColor();
            return obj.isEvent ? "<font color='!textText'>" + text + " </font>&nbsp;" : "<font color='!textText'>" + text + "</font><font " + color + "> [" + obj.getTextCoordinates() + "]" + " <i></font><font color='!textText'>(" + obj.getNbOfEvents() + ")" + "</i></font>&nbsp;";
        }
        return "";
    }

    public Image getIcon(int type) {
        GeoNodeObject obj = (GeoNodeObject)this.getLookup().lookup(GeoNodeObject.class);
        return obj != null ? obj.getIcon() : ImageUtilities.loadImage((String)"ancestris/modules/geo/geo.png");
    }

    public Image getOpenedIcon(int i) {
        return this.getIcon(i);
    }

    public Action getPreferredAction() {
        if (this.isLeaf()) {
            return new GeoAction("ACTION_SelectEvent");
        }
        return new GeoAction("ACTION_ShowPlace");
    }

    public Action[] getActions(boolean popup) {
        if (this.isLeaf()) {
            return new Action[]{new GeoAction("ACTION_SelectEvent"), null, new GeoAction("ACTION_EditEvent", this.getDefaultEditorsName()), null, new GeoAction("ACTION_HelpEvent")};
        }
        GeoNodeObject obj = (GeoNodeObject)this.getLookup().lookup(GeoNodeObject.class);
        if (obj == null) {
            return null;
        }
        if (obj.toDisplayString().equals(NbBundle.getMessage(GeoListTopComponent.class, (String)"GeoEmpty"))) {
            return new Action[]{new GeoAction("ACTION_None")};
        }
        return new Action[]{new GeoAction("ACTION_ShowPlace"), new GeoAction("ACTION_FindPlace"), null, new GeoAction("ACTION_EditPlace"), null, new GeoAction("ACTION_CopyPlace"), new GeoAction("ACTION_PastePlace", GeoPlacesList.getInstance(obj.getPlace().getGedcom()).getCopiedPlace() != null), null, new GeoAction("ACTION_UpdateList"), new GeoAction("ACTION_UpdatePlaceOptions"), null, new GeoAction("ACTION_HelpPlace")};
    }

    public void propertyChange(PropertyChangeEvent pce) {
        if ("topo".equals(pce.getPropertyName())) {
            this.fireDisplayNameChange(null, this.getDisplayName());
        }
    }

    private GeoMapTopComponent getMapTopComponent(GeoNodeObject obj) {
        GeoMapTopComponent theList = null;
        if (obj == null) {
            return theList;
        }
        for (TopComponent tc : WindowManager.getDefault().getRegistry().getOpened()) {
            GeoMapTopComponent gmtc;
            if (!(tc instanceof GeoMapTopComponent) || (gmtc = (GeoMapTopComponent)tc).getGedcom() != obj.getGedcom()) continue;
            theList = gmtc;
            break;
        }
        if (theList == null) {
            theList = new GeoMapTopComponent();
            theList.init(new Context(obj.getGedcom()));
            theList.open();
        }
        return theList;
    }

    private String getDefaultEditorsName() {
        AncestrisEditor edt = AncestrisEditor.findEditor((Property)new Indi());
        return edt.getName(false);
    }

    private class GeoAction
    extends AbstractAction {
        private String actionName = "";

        public GeoAction(String name) {
            this.actionName = name;
            this.putValue("Name", NbBundle.getMessage(GeoNode.class, (String)name));
        }

        public GeoAction(String name, String extension) {
            this.actionName = name + extension;
            this.putValue("Name", NbBundle.getMessage(GeoNode.class, (String)name, (Object)extension));
        }

        public GeoAction(String name, boolean enabled) {
            this.actionName = name;
            this.putValue("Name", NbBundle.getMessage(GeoNode.class, (String)name));
            this.setEnabled(enabled);
        }

        public void actionPerformed(ActionEvent e) {
            final GeoNodeObject obj = (GeoNodeObject)GeoNode.this.getLookup().lookup(GeoNodeObject.class);
            if (obj == null) {
                return;
            }
            if (!this.actionName.equals("ACTION_None")) {
                if (this.actionName.equals("ACTION_ShowPlace")) {
                    GeoMapTopComponent theMap = GeoNode.this.getMapTopComponent(obj);
                    if (theMap != null) {
                        theMap.requestActive();
                        theMap.setZoom(4);
                        theMap.centerMarker(obj);
                        theMap.showMarker(obj);
                    }
                } else if (this.actionName.equals("ACTION_FindPlace")) {
                    Place place = obj.getToponymFromPlace(obj.getPlace(), false);
                    if (place != obj.defaultPlace) {
                        String info = obj.displayToponym(place);
                        JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), info, NbBundle.getMessage(GeoNode.class, (String)"TXT_geoinfo"), 1, new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/geo/geoicon.png")));
                    } else {
                        JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(GeoNode.class, (String)"TXT_locationNotFound"), NbBundle.getMessage(GeoNode.class, (String)"TXT_geoinfo"), 1, new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/geo/geoicon.png")));
                    }
                } else if (this.actionName.equals("ACTION_EditPlace")) {
                    Gedcom gedcom = obj.getGedcom();
                    GeoPlacesList.getInstance(gedcom).stopListening();
                    PropertyPlace p = (PropertyPlace)new PlaceEditor().edit((Property)obj.getPlace(), (Object)obj.getGeoPosition());
                    try {
                        obj.updateAllEventsPlaces(p);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    GeoPlacesList.getInstance(gedcom).refreshPlaceName();
                    GeoPlacesList.getInstance(gedcom).startListening();
                } else if (this.actionName.equals("ACTION_CopyPlace")) {
                    GeoPlacesList.getInstance(obj.getGedcom()).setCopiedPlace(obj.getPlace(), obj.getGeoPosition());
                } else if (this.actionName.equals("ACTION_PastePlace")) {
                    Gedcom gedcom = obj.getPlace().getGedcom();
                    try {
                        GeoPlacesList.getInstance(gedcom).stopListening();
                        gedcom.doUnitOfWork(new UnitOfWork(){

                            public void perform(Gedcom gedcom) throws GedcomException {
                                obj.updateAllEventsPlaces(GeoPlacesList.getInstance(gedcom).getCopiedPlace());
                            }
                        });
                        GeoPlacesList.getInstance(gedcom).refreshPlaceName();
                        GeoPlacesList.getInstance(gedcom).startListening();
                    }
                    catch (GedcomException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else if (this.actionName.equals("ACTION_UpdateList")) {
                    GeoPlacesList.getInstance(obj.getGedcom()).launchPlacesSearch(false);
                } else if (this.actionName.equals("ACTION_UpdatePlaceOptions")) {
                    if (GeoPlacesList.getInstance(obj.getGedcom()).setPlaceDisplayFormat(obj.getPlace())) {
                        GeoPlacesList.getInstance(obj.getGedcom()).launchPlacesSearch(false);
                    }
                } else if (this.actionName.equals("ACTION_EditEvent" + GeoNode.this.getDefaultEditorsName())) {
                    AncestrisEditor editor = AncestrisEditor.findEditor((Property)obj.getProperty().getEntity());
                    if (editor != null) {
                        editor.edit(obj.getProperty());
                    }
                } else if (this.actionName.equals("ACTION_SelectEvent")) {
                    SelectionDispatcher.fireSelection((Context)new Context(obj.getProperty()));
                } else if (this.actionName.equals("ACTION_HelpPlace")) {
                    String id = "ancestris.app.view.geo.menuplace";
                    Help help = (Help)Lookup.getDefault().lookup(Help.class);
                    if (help != null && help.isValidID(id, true).booleanValue()) {
                        help.showHelp(new HelpCtx(id));
                    }
                } else if (this.actionName.equals("ACTION_HelpEvent")) {
                    String id = "ancestris.app.view.geo.menuevent";
                    Help help = (Help)Lookup.getDefault().lookup(Help.class);
                    if (help != null && help.isValidID(id, true).booleanValue()) {
                        help.showHelp(new HelpCtx(id));
                    }
                }
            }
        }
    }
}

