/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.geo;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.geonames.Toponym;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class GeoToken
implements Transferable {
    public static DataFlavor geoPosFlavor = new DataFlavor(GeoPosition.class, "X-data/geocoord; class=<org.jdesktop.swingx.mapviewer.GeoPosition>; Geographic coordinates");
    public static DataFlavor topoFlavor = new DataFlavor(Toponym.class, "X-data/toponym; class=<org.geonames.Toponym>; Geographic location");
    private GeoPosition geoPosition = null;
    private Toponym topo = null;
    private DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, geoPosFlavor, topoFlavor};

    public GeoToken(GeoPosition geoPosition) {
        this.geoPosition = geoPosition;
    }

    public GeoToken(Toponym topo) {
        this.topo = topo;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor df) {
        for (int i = 0; i < this.flavors.length; ++i) {
            DataFlavor dataFlavor = this.flavors[i];
            if (!df.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
        if (df.equals(this.flavors[0])) {
            return this.topo != null ? this.topo.toString() : (this.geoPosition != null ? this.geoPosition.toString() : "");
        }
        if (df.equals(this.flavors[1])) {
            return this.geoPosition;
        }
        if (df.equals(this.flavors[2])) {
            return this.topo;
        }
        return "";
    }
}

