/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook;

import ancestris.modules.webbook.Log;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.WebBookPlugin;
import ancestris.modules.webbook.creator.WebCities;
import ancestris.modules.webbook.creator.WebCitiesDetails;
import ancestris.modules.webbook.creator.WebDays;
import ancestris.modules.webbook.creator.WebDaysDetails;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebHome;
import ancestris.modules.webbook.creator.WebIncludes;
import ancestris.modules.webbook.creator.WebIndividuals;
import ancestris.modules.webbook.creator.WebIndividualsDetails;
import ancestris.modules.webbook.creator.WebLastnames;
import ancestris.modules.webbook.creator.WebMap;
import ancestris.modules.webbook.creator.WebMedia;
import ancestris.modules.webbook.creator.WebRepSosa;
import ancestris.modules.webbook.creator.WebSearch;
import ancestris.modules.webbook.creator.WebSources;
import ancestris.modules.webbook.creator.WebStatsFrequent;
import ancestris.modules.webbook.creator.WebStatsImplex;
import ancestris.modules.webbook.creator.WebTheme;
import ancestris.modules.webbook.transfer.FTPLoader;
import ancestris.modules.webbook.transfer.FTPRegister;
import genj.gedcom.Gedcom;
import genj.util.Registry;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;

public class WebBook {
    private Gedcom gedcom;
    public Log log;
    private Registry registry;
    public WebBookParams wp;
    private WebHelper wh;
    public WebIncludes sectionIncludes;
    public WebTheme sectionTheme;
    public WebHome sectionHome;
    public WebLastnames sectionLastnames;
    public WebIndividuals sectionIndividuals;
    public WebIndividualsDetails sectionIndividualsDetails;
    public WebSources sectionSources;
    public WebMedia sectionMedia;
    public WebCities sectionCities;
    public WebCitiesDetails sectionCitiesDetails;
    public WebDays sectionDays;
    public WebDaysDetails sectionDaysDetails;
    public WebStatsFrequent sectionStatsFrequent;
    public WebStatsImplex sectionStatsImplex;
    public WebRepSosa sectionRepSosa;
    public WebSearch sectionSearch;
    public WebMap sectionMap;
    private FTPRegister uploadRegister;

    public WebBook(Gedcom gedcom, Log log) throws InterruptedException {
        this.gedcom = gedcom;
        this.registry = gedcom.getRegistry();
        this.log = log;
        this.wp = new WebBookParams(gedcom);
        this.wh = new WebHelper(gedcom, log, this.wp);
        this.uploadRegister = new FTPRegister(this.wp, this.wh);
        this.sectionIncludes = new WebIncludes(true, this, this.wp, this.wh);
        this.sectionTheme = new WebTheme(true, this, this.wp, this.wh);
        this.sectionHome = new WebHome(true, this, this.wp, this.wh);
        this.sectionLastnames = new WebLastnames(true, this, this.wp, this.wh);
        this.sectionIndividuals = new WebIndividuals(true, this, this.wp, this.wh);
        this.sectionIndividualsDetails = new WebIndividualsDetails(true, this, this.wp, this.wh);
        this.sectionSources = new WebSources(this.wp.param_media_GeneSources.equals("1"), this, this.wp, this.wh);
        this.sectionMedia = new WebMedia(this.wp.param_media_GeneMedia.equals("1"), this, this.wp, this.wh);
        this.sectionCities = new WebCities(true, this, this.wp, this.wh);
        this.sectionCitiesDetails = new WebCitiesDetails(true, this, this.wp, this.wh);
        this.sectionDays = new WebDays(true, this, this.wp, this.wh);
        this.sectionDaysDetails = new WebDaysDetails(true, this, this.wp, this.wh);
        this.sectionStatsImplex = new WebStatsImplex(true, this, this.wp, this.wh);
        this.sectionStatsFrequent = new WebStatsFrequent(true, this, this.wp, this.wh);
        this.sectionRepSosa = new WebRepSosa(true, this, this.wp, this.wh);
        this.sectionSearch = new WebSearch(true, this, this.wp, this.wh);
        this.sectionMap = new WebMap(true, this, this.wp, this.wh);
        this.run();
    }

    private void run() throws InterruptedException {
        WebBookPlugin pi = new WebBookPlugin();
        String version = pi.getPluginVersion();
        this.log.write("----------- " + this.log.trs("CTL_WebBookTitle") + " -----------");
        this.log.write(pi.getPluginDisplayName() + " - " + version);
        this.sectionHome.setVersion(version);
        this.log.write("----------- " + this.log.trs("EXEC_start") + " -----------");
        this.log.timeStamp();
        this.log.write(" ");
        this.log.write(" ");
        this.log.write("----------- " + this.log.trs("EXEC_params") + " -----------");
        this.wp.logParameters(this.log);
        this.log.write(" ");
        this.log.write("----------- " + this.log.trs("EXEC_clean") + " -----------");
        this.wh.cleanLocalDir();
        this.log.write(" ");
        this.log.write("----------- " + this.log.trs("EXEC_init") + " -----------");
        this.sectionLastnames.init();
        this.sectionIndividuals.init();
        this.sectionIndividualsDetails.init();
        this.sectionSources.init();
        this.sectionMedia.init();
        this.sectionCities.init();
        this.sectionCitiesDetails.init();
        this.sectionDays.init();
        this.sectionDaysDetails.init();
        this.sectionStatsImplex.init();
        this.sectionStatsFrequent.init();
        this.sectionRepSosa.init();
        this.sectionSearch.init();
        this.sectionMap.init();
        this.sectionHome.init();
        this.log.write(" ");
        this.log.write("----------- " + this.log.trs("EXEC_create") + " -----------");
        this.sectionTheme.create();
        this.sectionIncludes.create();
        this.sectionLastnames.create();
        this.sectionIndividuals.create();
        this.sectionIndividualsDetails.create();
        this.sectionSources.create();
        this.sectionMedia.create();
        this.sectionCities.create();
        this.sectionCitiesDetails.create();
        this.sectionDays.create();
        this.sectionDaysDetails.create();
        this.sectionStatsFrequent.create();
        this.sectionStatsImplex.create();
        this.sectionRepSosa.create();
        this.sectionSearch.create();
        this.sectionMap.create();
        this.sectionHome.create();
        this.log.write(" ");
        this.log.write("----------- " + this.log.trs("EXEC_upload") + " -----------");
        if (this.wp.param_FTP_upload.equals("1")) {
            this.log.write(this.log.trs("upload_yes"));
            new FTPLoader(this.wp, this.wh, this.uploadRegister).run();
        } else {
            this.log.write(this.log.trs("upload_none"));
        }
        this.log.write(" ");
        this.log.write("----------- " + this.log.trs("EXEC_showPages") + " -----------");
        String fileStr = "";
        if (this.wp.param_FTP_upload.equals("1")) {
            int i = this.wp.param_FTP_site.indexOf("ftp");
            String siteStr = i == -1 ? this.wp.param_FTP_site : this.wp.param_FTP_site.substring(3);
            fileStr = "http://www" + siteStr;
        } else if (!this.wp.param_PHP_Support.equals("1")) {
            fileStr = "file://" + this.wp.param_localWebDir + File.separator + "index.html";
        }
        try {
            URI uri = new URI(fileStr);
            if (Desktop.isDesktopSupported()) {
                this.log.write(uri.toString());
                this.registry.put("localwebsite", uri.toString());
                Desktop.getDesktop().browse(uri);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.log.write(" ");
        this.log.timeStamp();
        this.log.write("----------- " + this.log.trs("EXEC_end") + " -----------");
    }
}

